import { ref, onMounted, resolveComponent, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, _ as _sfc_main$1, t as _sfc_main$2, j as _sfc_main$3, e as _sfc_main$4 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./InputError-DjBtKS5r.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputLabel-DXl8D0gR.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "QuickView",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "editRow"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const loading = ref(true);
    const stock_count = ref(null);
    onMounted(async () => {
      await axios.get(route("stock_counts.show", { stock_count: props.current.id, json: true })).then((res) => {
        stock_count.value = res.data;
        loading.value = false;
      }).catch((err) => loading.value = false);
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
      const _component_Icon = resolveComponent("Icon");
      if (loading.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative h-64" }, _attrs))}>`);
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
        _push(`</div>`);
      } else if (stock_count.value) {
        _push(`<!--[--><span class="absolute top-4 right-12 sm:right-14 inline-flex items-center gap-x-4 print:hidden"><button type="button" class="link -m-2 p-2">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "print-o",
          class: "size-5"
        }, null, _parent));
        _push(`</button>`);
        if (__props.editRow) {
          _push(`<button type="button" class="link -m-2 p-2">`);
          _push(ssrRenderComponent(_component_Icon, {
            name: "edit-o",
            class: "size-5"
          }, null, _parent));
          _push(`</button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</span><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4 print:hidden"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Stock Count"))} #${ssrInterpolate((_a = stock_count.value) == null ? void 0 : _a.id)} (${ssrInterpolate((_b = stock_count.value) == null ? void 0 : _b.reference)})</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the details below"))}</p></div></div></div><div class="mt-4 px-6 py-4 print:py-0 print:m-0"><div class="max-h-16 max-w-[250px] mb-1">`);
        if (stock_count.value.store.logo) {
          _push(`<img class="max-w-full h-16"${ssrRenderAttr("src", stock_count.value.store.logo)}${ssrRenderAttr("alt", stock_count.value.store.name)}>`);
        } else {
          _push(`<!--[-->`);
          if ((_c = _ctx.$page.props.settings) == null ? void 0 : _c.logo) {
            _push(`<img class="max-w-full h-16 dark:hidden"${ssrRenderAttr("src", (_d = _ctx.$page.props.settings) == null ? void 0 : _d.logo)}${ssrRenderAttr("alt", (_e = _ctx.$page.props.settings) == null ? void 0 : _e.name)}>`);
          } else {
            _push(`<!---->`);
          }
          if ((_f = _ctx.$page.props.settings) == null ? void 0 : _f.logo_dark) {
            _push(`<img class="max-w-full h-16 hidden dark:block"${ssrRenderAttr("src", (_g = _ctx.$page.props.settings) == null ? void 0 : _g.logo_dark)}${ssrRenderAttr("alt", (_h = _ctx.$page.props.settings) == null ? void 0 : _h.name)}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</div><div class="flex items-start justify-between gap-3 mb-8"><div class="flex flex-col w-3/5"><div class="font-semibold text-lg">${ssrInterpolate(stock_count.value.store.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(stock_count.value.store))}</div>`);
        if (stock_count.value.store.phone) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(stock_count.value.store.phone)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (stock_count.value.store.email) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(stock_count.value.store.email)}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="w-2/5"><div class="font-extrabold uppercase text-lg mb-1">${ssrInterpolate(stock_count.value.type == "full" ? _ctx.$t("Full Stock Count") : _ctx.$t("Partial Stock Count"))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Stock Count No. {x}", { x: (_i = stock_count.value) == null ? void 0 : _i.id }))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Date"))}: ${ssrInterpolate(_ctx.$datetime(stock_count.value.created_at))}</div><div class="text-sm flex gap-1">${ssrInterpolate(_ctx.$t("Reference"))}: <p class="truncate hover:text-clip print:text-clip print:block" dir="rtl">${ssrInterpolate(stock_count.value.reference)}</p></div></div></div>`);
        if (stock_count.value.type == "partial") {
          _push(`<div class="bg-gray-50 dark:bg-gray-950 border border-gray-200 dark:border-gray-700 py-4 px-5 rounded-md">`);
          if (stock_count.value.brands) {
            _push(`<div class="text-lg flex flex-wrap items-center justify-between">${ssrInterpolate(_ctx.$t("Brands"))}: <span class="font-bold">${ssrInterpolate(stock_count.value.brands.map((b) => b.name).join(", "))}</span></div>`);
          } else {
            _push(`<!---->`);
          }
          if (stock_count.value.categories) {
            _push(`<div class="text-lg flex flex-wrap items-center justify-between">${ssrInterpolate(_ctx.$t("Categories"))}: <span class="font-bold">${ssrInterpolate(stock_count.value.categories.map((b) => b.name).join(", "))}</span></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (stock_count.value.items && stock_count.value.items.length) {
          _push(`<div class="mt-6 rounded border border-gray-200 dark:border-gray-700 overflow-hidden"><table class="table-fixed w-full divide-y dark:divide-gray-700 print:divide-gray-400 dark:print:divide-gray-400 text-sm"><thead><tr><th class="font-bold text-right uppercase p-2 w-10">#</th><th class="font-bold text-left uppercase p-2">${ssrInterpolate(_ctx.$t("Product Code"))}</th><th class="font-bold text-left uppercase p-2">${ssrInterpolate(_ctx.$t("Variation Code"))}</th><th class="font-bold text-center uppercase p-2 w-[100px]">${ssrInterpolate(_ctx.$t("Expected"))}</th><th class="font-bold text-center uppercase p-2 w-[100px]">${ssrInterpolate(_ctx.$t("In Store"))}</th><th class="font-bold text-center uppercase p-2 w-[100px]">${ssrInterpolate(_ctx.$t("Difference"))}</th></tr></thead><tbody class="divide-y dark:divide-gray-700 border-y border-gray-200 dark:border-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><!--[-->`);
          ssrRenderList(stock_count.value.items, (item, index) => {
            _push(`<tr><td class="p-2 w-10 text-right">${ssrInterpolate(index + 1)}</td><td class="p-2">${ssrInterpolate(item.product_code)}</td><td class="p-2">${ssrInterpolate(item.variation_code)}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number_qty(item.expected_quantity))}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number_qty(item.in_store_quantity))}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number_qty(Number(item.expected_quantity) - Number(item.in_store_quantity)))}</td></tr>`);
          });
          _push(`<!--]--></tbody></table></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          modal: false,
          fields: __props.custom_fields,
          title: _ctx.$t("Custom Fields"),
          extra_attributes: stock_count.value.extra_attributes
        }, null, _parent));
        if (stock_count.value.details) {
          _push(`<div class="pt-8 mb-4">${ssrInterpolate(stock_count.value.details)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (stock_count.value.attachments && stock_count.value.attachments.length) {
          _push(`<div class="mt-8 py-2 w-full print:hidden">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            attachments: stock_count.value.attachments
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (!stock_count.value.completed_at) {
          _push(`<div class="mt-8 py-2 w-full print:hidden">`);
          _push(ssrRenderComponent(unref(_sfc_main$4), {
            away: "",
            type: "button",
            href: _ctx.route("stock_counts.export", stock_count.value.id),
            class: "w-full justify-center"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("Download excel file to complete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("Download excel file to complete")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`<div class="mt-6 text-center text-sm text-mute">${ssrInterpolate(_ctx.$t("Please edit to complete the stock count with checked excel file."))}</div></div>`);
        } else {
          _push(`<div><div>${ssrInterpolate(_ctx.$t("Completed at"))}: ${ssrInterpolate(_ctx.$datetime(stock_count.value.completed_at))}</div><div>${ssrInterpolate(_ctx.$t("Completed by"))}: ${ssrInterpolate(((_j = stock_count.value.completed_by) == null ? void 0 : _j.name) || "")}</div><div class="mt-6 print:hidden">`);
          _push(ssrRenderComponent(unref(_sfc_main$4), {
            away: "",
            type: "button",
            href: _ctx.route("stock_counts.download", stock_count.value.id),
            class: "w-full justify-center"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("Download final excel file"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("Download final excel file")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div></div>`);
        }
        _push(`</div><!--]-->`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-center p-6 min-h-64 text-lg font-thin" }, _attrs))}>${ssrInterpolate(_ctx.$t("No data found, the record might not belong to the selected store."))}</div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/StockCount/QuickView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
