import { ref, onMounted, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, _ as _sfc_main$1, t as _sfc_main$2, j as _sfc_main$3 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./InputError-DjBtKS5r.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputLabel-DXl8D0gR.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "QuickView",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "editRow", "xfetch", "force"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    usePage();
    const props = __props;
    const loading = ref(true);
    const payment = ref(null);
    onMounted(async () => {
      if (props.xfetch) {
        payment.value = props.current;
        loading.value = false;
      } else {
        await axios.get(
          props.force ? route("payments.report.show", { id: props.current.id }) : route("payments.show", { payment: props.current.id, json: true })
        ).then((res) => {
          payment.value = res.data;
          loading.value = false;
        }).catch((err) => loading.value = false);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i;
      const _component_Icon = resolveComponent("Icon");
      if (loading.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative h-64" }, _attrs))}>`);
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
        _push(`</div>`);
      } else if (payment.value) {
        _push(`<!--[-->`);
        if (!__props.xfetch) {
          _push(`<!--[--><span class="absolute top-4 right-12 sm:right-14 inline-flex items-center gap-x-4 print:hidden"><button type="button" class="link -m-2 p-2">`);
          _push(ssrRenderComponent(_component_Icon, {
            name: "print-o",
            class: "size-5"
          }, null, _parent));
          _push(`</button><button type="button" class="link -m-2 p-2">`);
          _push(ssrRenderComponent(_component_Icon, {
            name: "edit-o",
            class: "size-5"
          }, null, _parent));
          _push(`</button></span><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4 print:hidden"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Payment"))} #${ssrInterpolate((_a = payment.value) == null ? void 0 : _a.id)} (${ssrInterpolate((_b = payment.value) == null ? void 0 : _b.reference)})</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the details below"))}</p></div></div></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="mt-4 text-gray-600 dark:text-gray-400 px-6 py-4 print:py-0 print:m-0"><div class="max-h-16 max-w-[250px] mb-1">`);
        if (payment.value.store.logo) {
          _push(`<img class="max-w-full h-16"${ssrRenderAttr("src", payment.value.store.logo)}${ssrRenderAttr("alt", payment.value.store.name)}>`);
        } else {
          _push(`<!--[-->`);
          if ((_c = _ctx.$page.props.settings) == null ? void 0 : _c.logo) {
            _push(`<img class="max-w-full h-16 dark:hidden"${ssrRenderAttr("src", (_d = _ctx.$page.props.settings) == null ? void 0 : _d.logo)}${ssrRenderAttr("alt", (_e = _ctx.$page.props.settings) == null ? void 0 : _e.name)}>`);
          } else {
            _push(`<!---->`);
          }
          if ((_f = _ctx.$page.props.settings) == null ? void 0 : _f.logo_dark) {
            _push(`<img class="max-w-full h-16 hidden dark:block"${ssrRenderAttr("src", (_g = _ctx.$page.props.settings) == null ? void 0 : _g.logo_dark)}${ssrRenderAttr("alt", (_h = _ctx.$page.props.settings) == null ? void 0 : _h.name)}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</div>`);
        if (payment.value.store) {
          _push(`<div class="flex items-start justify-between gap-3 mb-8"><div class="flex flex-col w-3/5"><div class="font-semibold text-lg">${ssrInterpolate(payment.value.store.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(payment.value.store))}</div>`);
          if (payment.value.store.phone) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(payment.value.store.phone)}</div>`);
          } else {
            _push(`<!---->`);
          }
          if (payment.value.store.email) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(payment.value.store.email)}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="w-2/5"><div class="font-extrabold uppercase text-lg mb-1">${ssrInterpolate(payment.value.received ? _ctx.$t("Payment Receipt") : _ctx.$t("Payment Request"))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Payment No. {x}", { x: (_i = payment.value) == null ? void 0 : _i.id }))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Date"))}: ${ssrInterpolate(_ctx.$date(payment.value.date))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Created at"))}: ${ssrInterpolate(_ctx.$datetime(payment.value.created_at))}</div><div class="text-sm flex gap-1">${ssrInterpolate(_ctx.$t("Reference"))}: <p class="truncate hover:text-clip print:text-clip print:block" dir="rtl">${ssrInterpolate(payment.value.reference)}</p></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (payment.value.payment_for == "Customer" && payment.value.customer) {
          _push(`<div class="pb-8"><h2 class="text-xs font-bold mb-1">${ssrInterpolate(_ctx.$t("From"))}</h2><div class="font-semibold text-lg">${ssrInterpolate(payment.value.customer.company || payment.value.customer.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(payment.value.customer))}</div>`);
          if (payment.value.customer.phone) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(payment.value.customer.phone)}</div>`);
          } else {
            _push(`<!---->`);
          }
          if (payment.value.customer.email) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(payment.value.customer.email)}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (payment.value.payment_for == "Supplier" && payment.value.supplier) {
          _push(`<div class="pb-8"><h2 class="text-xs font-bold mb-1">${ssrInterpolate(_ctx.$t("To"))}</h2><div class="font-semibold text-lg">${ssrInterpolate(payment.value.supplier.company || payment.value.supplier.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(payment.value.supplier))}</div>`);
          if (payment.value.supplier.phone) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(payment.value.supplier.phone)}</div>`);
          } else {
            _push(`<!---->`);
          }
          if (payment.value.supplier.email) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(payment.value.supplier.email)}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="bg-gray-50 dark:bg-gray-950 border border-gray-200 dark:border-gray-700 py-4 px-5 rounded-md"><div class="text-lg font-bold flex items-center justify-between">${ssrInterpolate(_ctx.$t("Amount"))}: <span>${ssrInterpolate(_ctx.$currency(payment.value.amount))}</span></div><div class="mt-3 flex items-center justify-start gap-1">${ssrInterpolate(_ctx.$t("Method"))}: <div class="font-bold">${ssrInterpolate(_ctx.$t(payment.value.method))}</div></div>`);
        if (payment.value.method_data && Object.keys(payment.value.method_data).length) {
          _push(`<div class="mt-2 flex items-center justify-start gap-1"><div class="capitalize">${ssrInterpolate(payment.value.method_data && Object.keys(payment.value.method_data) ? Object.keys(payment.value.method_data).map((k) => _ctx.$t(k.replaceAll("_", " ")) + ": " + payment.value.method_data[k]).join(", ") : "")}</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          modal: false,
          fields: __props.custom_fields,
          title: _ctx.$t("Custom Fields"),
          extra_attributes: payment.value.extra_attributes
        }, null, _parent));
        if (payment.value.details) {
          _push(`<div class="pt-8 mb-4">${ssrInterpolate(payment.value.details)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (payment.value.attachments && payment.value.attachments.length) {
          _push(`<div class="mt-8 py-2 w-full print:hidden">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            attachments: payment.value.attachments
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><!--]-->`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-center p-6 min-h-64 text-lg font-thin" }, _attrs))}>${ssrInterpolate(_ctx.$t("No data found, the record might not belong to the selected store."))}</div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Payment/QuickView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
