import { ref, onMounted, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, _ as _sfc_main$1, t as _sfc_main$2, j as _sfc_main$3 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./InputError-DjBtKS5r.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputLabel-DXl8D0gR.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "QuickView",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "editRow", "xfetch"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const page = usePage();
    const loading = ref(true);
    const transfer = ref(null);
    onMounted(async () => {
      if (props.xfetch) {
        transfer.value = props.current;
        loading.value = false;
      } else {
        await axios.get(route("transfers.show", { transfer: props.current.id, json: true })).then((res) => {
          transfer.value = res.data;
          loading.value = false;
        }).catch((err) => loading.value = false);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i;
      const _component_Icon = resolveComponent("Icon");
      if (loading.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative h-64" }, _attrs))}>`);
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
        _push(`</div>`);
      } else if (transfer.value) {
        _push(`<!--[-->`);
        if (!__props.xfetch) {
          _push(`<!--[--><span class="absolute top-4 right-12 sm:right-14 inline-flex items-center gap-x-4"><button type="button" class="link -m-2 p-2">`);
          _push(ssrRenderComponent(_component_Icon, {
            name: "print-o",
            class: "size-5"
          }, null, _parent));
          _push(`</button>`);
          if (__props.editRow) {
            _push(`<button type="button" class="link -m-2 p-2">`);
            _push(ssrRenderComponent(_component_Icon, {
              name: "edit-o",
              class: "size-5"
            }, null, _parent));
            _push(`</button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</span><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Transfer"))} #${ssrInterpolate((_a = transfer.value) == null ? void 0 : _a.id)} (${ssrInterpolate((_b = transfer.value) == null ? void 0 : _b.reference)})</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the details below"))}</p></div></div></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="mt-4 px-6 py-4 print:py-0 print:m-0"><div class="max-h-16 max-w-[250px] mb-1">`);
        if (transfer.value.store.logo) {
          _push(`<img class="max-w-full h-16"${ssrRenderAttr("src", transfer.value.store.logo)}${ssrRenderAttr("alt", transfer.value.store.name)}>`);
        } else {
          _push(`<!--[-->`);
          if ((_c = _ctx.$page.props.settings) == null ? void 0 : _c.logo) {
            _push(`<img class="max-w-full h-16 dark:hidden"${ssrRenderAttr("src", (_d = _ctx.$page.props.settings) == null ? void 0 : _d.logo)}${ssrRenderAttr("alt", (_e = _ctx.$page.props.settings) == null ? void 0 : _e.name)}>`);
          } else {
            _push(`<!---->`);
          }
          if ((_f = _ctx.$page.props.settings) == null ? void 0 : _f.logo_dark) {
            _push(`<img class="max-w-full h-16 hidden dark:block"${ssrRenderAttr("src", (_g = _ctx.$page.props.settings) == null ? void 0 : _g.logo_dark)}${ssrRenderAttr("alt", (_h = _ctx.$page.props.settings) == null ? void 0 : _h.name)}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</div><div class="flex items-start justify-between gap-3 mb-8"><div class="flex flex-col w-3/5"><div class="font-semibold text-lg">${ssrInterpolate(transfer.value.store.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(transfer.value.store))}</div>`);
        if (transfer.value.store.phone) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(transfer.value.store.phone)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (transfer.value.store.email) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(transfer.value.store.email)}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="w-2/5"><div class="font-extrabold uppercase text-lg mb-1">${ssrInterpolate(_ctx.$t("Transfer"))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Transfer No. {x}", { x: (_i = transfer.value) == null ? void 0 : _i.id }))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Date"))}: ${ssrInterpolate(_ctx.$datetime(transfer.value.created_at))}</div><div class="text-sm flex gap-1">${ssrInterpolate(_ctx.$t("Reference"))}: <p class="truncate hover:text-clip print:text-clip print:block" dir="rtl">${ssrInterpolate(transfer.value.reference)}</p></div></div></div><div class="pb-8"><h2 class="text-xs font-bold mb-1">${ssrInterpolate(_ctx.$t("Transfer To"))}</h2><div class="font-semibold text-lg">${ssrInterpolate(transfer.value.to_store.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(transfer.value.to_store))}</div>`);
        if (transfer.value.to_store.phone) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(transfer.value.to_store.phone)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (transfer.value.to_store.email) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(transfer.value.to_store.email)}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="overflow-x-auto"><table class="w-full divide-y dark:divide-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><thead><tr><th class="font-bold text-right uppercase p-2 w-7">#</th><th class="font-bold text-left uppercase p-2">${ssrInterpolate(_ctx.$t("Description"))}</th><th class="font-bold text-center uppercase p-2 w-[80px]">${ssrInterpolate(_ctx.$t("Qty"))}</th></tr></thead><!--[-->`);
        ssrRenderList(transfer.value.items, (item, index) => {
          _push(`<!--[-->`);
          if (item.variations && item.variations.length) {
            _push(`<tbody><tr><td class="p-2 w-7 text-right">${ssrInterpolate(index + 1)}</td><td class="p-2"><div class="flex items-center gap-2">`);
            if (unref(page).props.settings.show_image == 1) {
              _push(`<!--[-->`);
              if (item.product.photo) {
                _push(`<img class="w-8 h-8 rounded-sm self-start"${ssrRenderAttr("src", item.product.photo)} alt="Product Image">`);
              } else {
                _push(`<img class="w-8 h-8 mr-2 rounded-sm self-start" src="img/no-image.png" alt="No Image">`);
              }
              _push(`<!--]-->`);
            } else {
              _push(`<!---->`);
            }
            _push(` ${ssrInterpolate(item.product.name)}</div></td><td class="p-2 text-right"></td></tr><!--[-->`);
            ssrRenderList(item.variations, (variation) => {
              _push(`<tr><td class="w-7"></td><td class="p-2">${ssrInterpolate(_ctx.$meta(variation.meta))}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number_qty(variation.pivot.quantity))}</td></tr>`);
            });
            _push(`<!--]--></tbody>`);
          } else {
            _push(`<tbody class="divide-y dark:divide-gray-700 border-y border-gray-200 dark:border-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><tr><td class="p-2 w-7 text-right">${ssrInterpolate(index + 1)}</td><td class="p-2"><div class="flex items-center gap-2">`);
            if (unref(page).props.settings.show_image == 1) {
              _push(`<!--[-->`);
              if (item.product.photo) {
                _push(`<img class="w-8 h-8 rounded-sm self-start"${ssrRenderAttr("src", item.product.photo)} alt="Product Image">`);
              } else {
                _push(`<img class="w-8 h-8 mr-2 rounded-sm self-start" src="img/no-image.png" alt="No Image">`);
              }
              _push(`<!--]-->`);
            } else {
              _push(`<!---->`);
            }
            _push(` ${ssrInterpolate(item.product.name)}</div></td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number_qty(item.quantity))}</td></tr></tbody>`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><tfoot><tr><td colspan="2" class="pt-1 pb-2 px-2 font-bold text-right">${ssrInterpolate(_ctx.$t("Total Quantity"))}</td><td class="pt-1 pb-2 px-2 font-bold text-right w-[80px]">${ssrInterpolate(_ctx.$number_qty(transfer.value.items.reduce((a, i) => Number(i.quantity) + a, 0)))}</td></tr></tfoot></table></div>`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          modal: false,
          fields: __props.custom_fields,
          title: _ctx.$t("Custom Fields"),
          extra_attributes: transfer.value.extra_attributes
        }, null, _parent));
        if (transfer.value.details) {
          _push(`<div class="pt-8 mb-4">${ssrInterpolate(transfer.value.details)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (transfer.value.attachments && transfer.value.attachments.length) {
          _push(`<div class="mt-8 py-2 w-full print:hidden">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            attachments: transfer.value.attachments
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><!--]-->`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-center p-6 min-h-64 text-lg font-thin" }, _attrs))}>${ssrInterpolate(_ctx.$t("No data found, the record might not belong to the selected store."))}</div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Transfer/QuickView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
