import { ref, onMounted, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, _ as _sfc_main$1, t as _sfc_main$2, j as _sfc_main$3 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./InputError-DjBtKS5r.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputLabel-DXl8D0gR.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "QuickView",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "editRow", "force"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    usePage();
    const props = __props;
    const loading = ref(true);
    const expense = ref(null);
    onMounted(async () => {
      await axios.get(
        props.force ? route("expenses.report.show", { id: props.current.id }) : route("expenses.show", { expense: props.current.id, json: true })
      ).then((res) => {
        expense.value = res.data;
        loading.value = false;
      }).catch((err) => loading.value = false);
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d;
      const _component_Icon = resolveComponent("Icon");
      if (loading.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative h-64" }, _attrs))}>`);
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
        _push(`</div>`);
      } else if (expense.value) {
        _push(`<!--[--><span class="absolute top-4 right-12 sm:right-14 inline-flex items-center gap-x-4 print:hidden"><button type="button" class="link -m-2 p-2">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "print-o",
          class: "size-5"
        }, null, _parent));
        _push(`</button><button type="button" class="link -m-2 p-2">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "edit-o",
          class: "size-5"
        }, null, _parent));
        _push(`</button></span><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4 print:hidden"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Expense"))} #${ssrInterpolate((_a = expense.value) == null ? void 0 : _a.id)} (${ssrInterpolate((_b = expense.value) == null ? void 0 : _b.reference)})</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the details below"))}</p></div></div></div><div class="mt-4 text-gray-600 dark:text-gray-400 px-6 py-4 print:py-0 print:m-0"><div class="flex items-start justify-between gap-3 mb-8"><div class="flex flex-col w-3/5">`);
        if (expense.value.store.logo) {
          _push(`<img class="h-8 max-w-[200pc]"${ssrRenderAttr("src", expense.value.store.logo)} alt="Logo">`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="font-semibold text-lg">${ssrInterpolate(expense.value.store.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(expense.value.store))}</div>`);
        if (expense.value.store.phone) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(expense.value.store.phone)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (expense.value.store.email) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(expense.value.store.email)}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="w-2/5"><div class="font-extrabold uppercase text-lg mb-1">${ssrInterpolate(_ctx.$t("Expense"))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Expense No. {x}", { x: (_c = expense.value) == null ? void 0 : _c.id }))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Date"))}: ${ssrInterpolate(_ctx.$date(expense.value.date))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Created at"))}: ${ssrInterpolate(_ctx.$datetime(expense.value.created_at))}</div><div class="text-sm flex gap-1">${ssrInterpolate(_ctx.$t("Reference"))}: <p class="truncate hover:text-clip print:text-clip print:block" dir="rtl">${ssrInterpolate(expense.value.reference)}</p></div></div></div>`);
        if (expense.value.supplier) {
          _push(`<div class="pb-8"><h2 class="text-xs font-bold mb-1">${ssrInterpolate(_ctx.$t("Order To"))}</h2><div class="font-semibold text-lg">${ssrInterpolate(expense.value.supplier.company || expense.value.supplier.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(expense.value.supplier))}</div>`);
          if (expense.value.supplier.phone) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(expense.value.supplier.phone)}</div>`);
          } else {
            _push(`<!---->`);
          }
          if (expense.value.supplier.email) {
            _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(expense.value.supplier.email)}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="bg-gray-50 dark:bg-gray-950 border border-gray-200 dark:border-gray-700 py-4 px-5 rounded-md"><div class="text-lg font-bold flex items-center justify-between">${ssrInterpolate(_ctx.$t("Amount"))}: <span>${ssrInterpolate(_ctx.$currency(expense.value.amount))}</span></div><div class="mt-2">${ssrInterpolate(_ctx.$t("By"))}: ${ssrInterpolate((_d = expense.value.user) == null ? void 0 : _d.name)}</div></div>`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          modal: false,
          fields: __props.custom_fields,
          title: _ctx.$t("Custom Fields"),
          extra_attributes: expense.value.extra_attributes
        }, null, _parent));
        if (expense.value.details) {
          _push(`<div class="pt-8 mb-4">${ssrInterpolate(expense.value.details)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (expense.value.attachments && expense.value.attachments.length) {
          _push(`<div class="mt-8 py-2 w-full print:hidden">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            attachments: expense.value.attachments
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><!--]-->`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-center p-6 min-h-64 text-lg font-thin" }, _attrs))}>${ssrInterpolate(_ctx.$t("No data found, the record might not belong to the selected store."))}</div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Expense/QuickView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
