import { ref, onMounted, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, _ as _sfc_main$1, t as _sfc_main$2 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import JsBarcode from "jsbarcode";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./InputError-DjBtKS5r.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputLabel-DXl8D0gR.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "QuickView",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "editRow"],
  setup(__props) {
    const props = __props;
    const loading = ref(true);
    const product = ref(null);
    onMounted(async () => {
      await axios.get(route("products.show", { product: props.current.id })).then((res) => {
        product.value = res.data;
        loading.value = false;
      });
      JsBarcode(".barcode").init();
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
      const _component_Icon = resolveComponent("Icon");
      if (loading.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative h-64" }, _attrs))}>`);
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!--[--><span class="absolute top-4 right-12 sm:right-14 inline-flex items-center"><button type="button" class="link -m-2 p-2">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "edit-o",
          class: "size-5"
        }, null, _parent));
        _push(`</button></span><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate((_a = __props.current) == null ? void 0 : _a.name)} (${ssrInterpolate((_b = __props.current) == null ? void 0 : _b.code)})</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the details below"))}</p></div></div></div><div class="grid w-full grid-cols-1 items-start gap-x-6 gap-y-8 sm:grid-cols-12 lg:gap-x-6 p-6"><div class="sm:col-span-4 lg:col-span-5"><div class="flex items-center justify-center mb-4"><svg class="barcode rounded-sm"${ssrRenderAttr("jsbarcode-width", 2)}${ssrRenderAttr("jsbarcode-margin", 10)}${ssrRenderAttr("jsbarcode-height", 80)}${ssrRenderAttr("jsbarcode-fontsize", 14)}${ssrRenderAttr("jsbarcode-textmargin", 2)} jsbarcode-fontoptions="bold"${ssrRenderAttr("jsbarcode-value", product.value.code)}${ssrRenderAttr("jsbarcode-format", product.value.symbology)}></svg></div>`);
        if (product.value.photo) {
          _push(`<img${ssrRenderAttr("src", product.value.photo)}${ssrRenderAttr("alt", (_c = __props.current) == null ? void 0 : _c.name)} class="aspect-square w-full rounded-lg bg-gray-100 dark:bg-gray-900 object-cover">`);
        } else {
          _push(`<!---->`);
        }
        _push(`<dl class="divide-y divide-gray-100 dark:divide-gray-700/50 mt-4"><div class="px-4 pt-3.5 pb-2.5 flex item-start justify-between gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Feature"))}</dt><dd class="text-sm/6 text-focus"><div class="size-5">${_ctx.$boolean(product.value.featured, true) ?? ""}</div></dd></div><div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Show in POS"))}</dt><dd class="text-sm/6 text-focus"><div class="size-5">${_ctx.$boolean(!product.value.hide_in_pos, true) ?? ""}</div></dd></div><div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Show in Shop"))}</dt><dd class="text-sm/6 text-focus"><div class="size-5">${_ctx.$boolean(!product.value.hide_in_shop, true) ?? ""}</div></dd></div><div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Has expiry date"))}</dt><dd class="text-sm/6 text-focus"><div class="size-5">${_ctx.$boolean(product.value.has_expiry_date, true) ?? ""}</div></dd></div><div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Stock Tracking"))}</dt><dd class="text-sm/6 text-focus"><div class="size-5">${_ctx.$boolean(!product.value.stock, true) ?? ""}</div></dd></div><div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Allow to change price"))}</dt><dd class="text-sm/6 text-focus"><div class="size-5">${_ctx.$boolean(product.value.can_edit_price, true) ?? ""}</div></dd></div><div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Taxes are included in price"))}</dt><dd class="text-sm/6 text-focus"><div class="size-5">${_ctx.$boolean(product.value.tax_included, true) ?? ""}</div></dd></div></dl></div><div class="sm:col-span-8 lg:col-span-7 pb-2 -mt-2.5"><dl class="divide-y divide-gray-100 dark:divide-gray-700/50"><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Type"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(_ctx.$t(product.value.type))}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Name"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.name)}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Secondary Name"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.secondary_name)}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Code"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.code)}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Brand"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(((_d = product.value.brand) == null ? void 0 : _d.name) || "")}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Category"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate((_e = product.value.category) == null ? void 0 : _e.name)}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Subcategory"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.subcategory_id ? (_g = (_f = product.value.category.children) == null ? void 0 : _f.find((c) => c.id == product.value.subcategory_id)) == null ? void 0 : _g.name : "")}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Cost"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(_ctx.$number(product.value.cost))}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Price"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(_ctx.$number(product.value.price))}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Min. Price"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.min_price ? _ctx.$number(product.value.min_price) : "")}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Max. Price"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.max_price ? _ctx.$number(product.value.max_price) : "")}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Max. Discount"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.max_discount ? _ctx.$number(product.value.max_discount) + "%" : "")}</dd></div><div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Taxes"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate((_h = product.value.taxes) == null ? void 0 : _h.map((t) => t.name).join(", "))}</dd></div>`);
        if (product.value.type == "Standard") {
          _push(`<div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Unit"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.unit ? product.value.unit.name + " (" + product.value.unit.code + ")" : "")}</dd></div>`);
        } else {
          _push(`<!---->`);
        }
        if (product.value.type != "Service") {
          _push(`<div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Weight"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.weight ? product.value.weight + " " + _ctx.$page.props.settings.weight_unit : "")}</dd></div>`);
        } else {
          _push(`<!---->`);
        }
        if (["Standard", "Combo"].includes(product.value.type)) {
          _push(`<div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Dimensions"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.dimensions || "")}</dd></div>`);
        } else {
          _push(`<!---->`);
        }
        if (["Standard", "Combo"].includes(product.value.type)) {
          _push(`<div class="px-4 py-2.5 grid grid-cols-3 gap-4 sm:px-6"><dt class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Rack Location"))}</dt><dd class="text-sm/6 text-focus col-span-2">${ssrInterpolate(product.value.rack_location || "")}</dd></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</dl></div>`);
        if (product.value.type == "Standard" && product.value.variations && product.value.variations.length) {
          _push(`<div class="col-span-full bg-gray-100 dark:bg-gray-900 rounded-md divide-y dark:divide-gray-800"><div class="px-4 py-2.5 text-center font-extrabold sm:px-6">${ssrInterpolate(_ctx.$t("Variations"))}</div><div class="col-span-full overflow-x-auto"><div class="inline-block min-w-full my-2 align-middle dark:border-gray-700"><table class="w-full text-sm"><thead><tr><th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("SKU"))}</th><!--[-->`);
          ssrRenderList(product.value.variants, (va, vi) => {
            _push(`<th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(va.name)}</th>`);
          });
          _push(`<!--]--><th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("Code"))}</th>`);
          if (!product.value.dont_track_stock) {
            _push(`<th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("Qty"))}</th>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("Cost"))}</th><th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("Price"))}</th><th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("Rack"))}</th><th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("Weight"))}</th><th class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-mute">${ssrInterpolate(_ctx.$t("Dimensions"))}</th></tr></thead><tbody><!--[-->`);
          ssrRenderList(product.value.variations, (variation, index) => {
            var _a2, _b2, _c2;
            _push(`<tr><td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 font-mono text-xs"><div class="group relative"><div class="max-w-[100px] truncate" dir="rtl">${ssrInterpolate(variation.sku)} <div class="hidden group-hover:block absolute -top-0.5 left-0 z-10 px-1 py-0.5 bg-gray-100 dark:bg-gray-800 rounded-md">${ssrInterpolate(variation.sku)}</div></div></div></td><!--[-->`);
            ssrRenderList(product.value.variants, (va, vi) => {
              _push(`<td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700">`);
              if (variation.meta) {
                _push(`<!--[-->${ssrInterpolate(variation.meta[va.name])}<!--]-->`);
              } else {
                _push(`<!---->`);
              }
              _push(`</td>`);
            });
            _push(`<!--]--><td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700">${ssrInterpolate(variation.code)}</td>`);
            if (!product.value.dont_track_stock) {
              _push(`<td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700">${ssrInterpolate(_ctx.$number_qty(
                _ctx.$page.props.selected_store ? (_b2 = (_a2 = variation.stocks) == null ? void 0 : _a2.find((s) => s.store_id == _ctx.$page.props.selected_store)) == null ? void 0 : _b2.balance : (_c2 = variation.stocks) == null ? void 0 : _c2.reduce((a, s) => Number(s.balance) + a, 0)
              ))}</td>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-right">${ssrInterpolate(variation.cost ? _ctx.$number(variation.cost) : "")}</td><td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700 text-right">${ssrInterpolate(variation.price ? _ctx.$number(variation.price) : "")}</td><td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700">${ssrInterpolate(variation.rack_location)}</td><td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700">${ssrInterpolate(variation.weight ? _ctx.$number(variation.weight) : "")}</td><td class="px-2 py-1 border-b border-gray-200 dark:border-gray-700">${ssrInterpolate(variation.dimensions)}</td></tr>`);
          });
          _push(`<!--]--></tbody></table></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (!product.value.dont_track_stock && product.value.type == "Standard" && product.value.stocks.length) {
          _push(`<div class="col-span-full bg-gray-100 dark:bg-gray-900 rounded-md divide-y dark:divide-gray-800"><div class="px-4 py-2.5 text-center font-extrabold sm:px-6">${ssrInterpolate(_ctx.$t("Quantity"))}</div><!--[-->`);
          ssrRenderList(product.value.stocks, (stock) => {
            var _a2, _b2;
            _push(`<div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><div class="text-sm font-medium">${ssrInterpolate((_b2 = (_a2 = product.value.stores) == null ? void 0 : _a2.find((s) => s.id == stock.store_id)) == null ? void 0 : _b2.name)}</div><div class="text-sm/6 text-focus">${ssrInterpolate(_ctx.$number_qty(stock.balance))}</div></div>`);
          });
          _push(`<!--]--><div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><div class="text-sm font-bold">${ssrInterpolate(_ctx.$t("Total"))}</div><div class="text-sm/6 text-focus font-bold">${ssrInterpolate(_ctx.$number_qty((_i = product.value.stocks) == null ? void 0 : _i.reduce((a, s) => Number(s.balance) + a, 0)))}</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (product.value.type == "Combo" && product.value.products && product.value.products.length) {
          _push(`<div class="col-span-full bg-gray-100 dark:bg-gray-900 rounded-md divide-y dark:divide-gray-800"><div class="px-4 py-2.5 text-center font-extrabold sm:px-6">${ssrInterpolate(_ctx.$t("Combo Products"))}</div><!--[-->`);
          ssrRenderList(product.value.products, (cp) => {
            _push(`<div class="px-4 py-2.5 flex item-start justify-between gap-4 sm:px-6"><div class="text-sm font-medium">${ssrInterpolate(cp.name)}</div><div class="text-sm/6 text-focus">${ssrInterpolate(_ctx.$number_qty(cp.pivot.quantity))}</div></div>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-span-full flex flex-col divide-y dark:divide-gray-700"><div class="pb-2.5 flex flex-wrap items-center gap-2"><div class="text-mute">${ssrInterpolate(_ctx.$t("Supplier"))}:</div> ${ssrInterpolate(((_j = product.value.supplier) == null ? void 0 : _j.name) || "")} `);
        if (product.value.supplier_part_id) {
          _push(`<span>(${ssrInterpolate(product.value.supplier_part_id)})</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="py-2.5 flex flex-wrap items-center gap-2"><div class="text-mute">${ssrInterpolate(_ctx.$t("Title"))}:</div> ${ssrInterpolate(product.value.title || "")}</div><div class="py-2.5 flex flex-wrap items-center gap-2"><div class="text-mute">${ssrInterpolate(_ctx.$t("Slug"))}:</div> ${ssrInterpolate(product.value.slug || "")} <div class="flex items-center text-sm"> ( <div class="flex items-center gap-1 mr-4"><div class="size-5">${_ctx.$boolean(product.value.noindex) ?? ""}</div> ${ssrInterpolate(_ctx.$t("No Index"))}</div><div class="flex items-center gap-1 mr-0.5"><div class="size-5">${_ctx.$boolean(product.value.nofollow) ?? ""}</div> ${ssrInterpolate(_ctx.$t("No Follow"))}</div> ) </div></div><div class="py-2.5"><div class="text-mute">${ssrInterpolate(_ctx.$t("Description"))}:</div> ${ssrInterpolate(product.value.description || "")}</div><div class="py-2.5"><div class="text-mute">${ssrInterpolate(_ctx.$t("Keywords"))}:</div> ${ssrInterpolate(product.value.keywords || "")}</div><div class="py-2.5"><div class="text-mute">${ssrInterpolate(_ctx.$t("Details"))}:</div> ${ssrInterpolate(product.value.details || "")}</div><div class="pt-2.5">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          modal: false,
          title: product.value.company || product.value.name,
          extra_attributes: product.value.extra_attributes
        }, null, _parent));
        _push(`</div></div><div class="hidden w-full h-full max-w-6 max-h-6"></div></div><!--]-->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/QuickView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
