import { ref, onMounted, resolveComponent, mergeProps, unref, withCtx, createVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, _ as _sfc_main$1, t as _sfc_main$2 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$3 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import _sfc_main$4 from "./PackingList-CrNFukaj.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "QuickView",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "editRow", "xfetch", "force"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const page = usePage();
    const props = __props;
    const colspan = ref(4);
    const sale = ref(null);
    const loading = ref(true);
    const packing = ref(false);
    onMounted(async () => {
      if (props.xfetch) {
        sale.value = props.current;
        loading.value = false;
      } else {
        await axios.get(props.force ? route("sales.report.show", { id: props.current.id }) : route("sales.show", { sale: props.current.id, json: true })).then((res) => {
          sale.value = res.data;
          loading.value = false;
        }).catch((err) => loading.value = false);
      }
      if (page.props.settings.show_discount == 1) {
        colspan.value++;
      }
      if (page.props.settings.show_tax == 1) {
        colspan.value++;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i;
      const _component_Icon = resolveComponent("Icon");
      const _component_Attachments = resolveComponent("Attachments");
      if (loading.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative h-64" }, _attrs))}>`);
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
        _push(`</div>`);
      } else if (sale.value) {
        _push(`<!--[-->`);
        if (!__props.xfetch) {
          _push(`<!--[--><span class="print:hidden absolute top-4 right-12 sm:right-14 inline-flex items-center gap-x-4"><button type="button" class="link -m-2 p-2">`);
          _push(ssrRenderComponent(_component_Icon, {
            name: "print-o",
            class: "size-5"
          }, null, _parent));
          _push(`</button>`);
          if (__props.editRow) {
            _push(`<button type="button" class="link -m-2 p-2">`);
            _push(ssrRenderComponent(_component_Icon, {
              name: "archive",
              class: "size-5"
            }, null, _parent));
            _push(`</button>`);
          } else {
            _push(`<!---->`);
          }
          if (__props.editRow) {
            _push(`<button type="button" class="link -m-2 p-2">`);
            _push(ssrRenderComponent(_component_Icon, {
              name: "edit-o",
              class: "size-5"
            }, null, _parent));
            _push(`</button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</span><div class="print:hidden border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Sale"))} #${ssrInterpolate((_a = sale.value) == null ? void 0 : _a.id)} (${ssrInterpolate((_b = sale.value) == null ? void 0 : _b.reference)})</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the details below"))}</p></div></div></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="mt-4 px-6 py-4 print:py-0 print:m-0"><div class="max-h-16 max-w-[250px] mb-1">`);
        if (sale.value.store.logo) {
          _push(`<img class="max-w-full h-16"${ssrRenderAttr("src", sale.value.store.logo)}${ssrRenderAttr("alt", sale.value.store.name)}>`);
        } else {
          _push(`<!--[-->`);
          if ((_c = _ctx.$page.props.settings) == null ? void 0 : _c.logo) {
            _push(`<img class="max-w-full h-16 dark:hidden"${ssrRenderAttr("src", (_d = _ctx.$page.props.settings) == null ? void 0 : _d.logo)}${ssrRenderAttr("alt", (_e = _ctx.$page.props.settings) == null ? void 0 : _e.name)}>`);
          } else {
            _push(`<!---->`);
          }
          if ((_f = _ctx.$page.props.settings) == null ? void 0 : _f.logo_dark) {
            _push(`<img class="max-w-full h-16 hidden dark:block"${ssrRenderAttr("src", (_g = _ctx.$page.props.settings) == null ? void 0 : _g.logo_dark)}${ssrRenderAttr("alt", (_h = _ctx.$page.props.settings) == null ? void 0 : _h.name)}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</div><div class="flex items-start justify-between gap-3 mb-8"><div class="flex flex-col w-3/5"><div class="font-semibold text-lg">${ssrInterpolate(sale.value.store.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(sale.value.store))}</div>`);
        if (sale.value.store.phone) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(sale.value.store.phone)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (sale.value.store.email) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(sale.value.store.email)}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="w-2/5"><div class="font-extrabold uppercase text-lg mb-1">${ssrInterpolate(_ctx.$t("Sale"))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Sale No. {x}", { x: (_i = sale.value) == null ? void 0 : _i.id }))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Date"))}: ${ssrInterpolate(_ctx.$date(sale.value.date))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Created at"))}: ${ssrInterpolate(_ctx.$datetime(sale.value.created_at))}</div><div class="text-sm flex gap-1">${ssrInterpolate(_ctx.$t("Reference"))}: <p class="truncate hover:text-clip print:text-clip print:block" dir="rtl">${ssrInterpolate(sale.value.reference)}</p></div>`);
        if (sale.value.due_date) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Due Date"))}: ${ssrInterpolate(_ctx.$date(sale.value.due_date))}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
        if (sale.value.return_orders_count > 0) {
          _push(`<div class="col-span-full pb-8"><a${ssrRenderAttr("href", _ctx.route("return_orders.index", { filters: { sale_id: sale.value.id } }))} class="block rounded-md bg-red-50 dark:bg-red-800 p-4 print:border print:border-red-700"><div class="flex"><div class="flex-shrink-0"><svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495zM10 5a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 5zm0 9a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd"></path></svg></div><div class="ml-3"><h3 class="text-sm font-medium text-red-800 dark:text-red-200">${ssrInterpolate(_ctx.$t("This sale has {x}", {
            x: sale.value.return_orders_count == 1 ? "1 " + _ctx.$t("return order") : sale.value.return_orders_count + " " + _ctx.$t("return orders")
          }))}</h3></div></div></a></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="pb-8"><h2 class="text-xs font-bold mb-1">${ssrInterpolate(_ctx.$t("Sell To"))}</h2><div class="font-semibold text-lg">${ssrInterpolate(sale.value.customer.company || sale.value.customer.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(sale.value.customer))}</div>`);
        if (sale.value.customer.phone) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(sale.value.customer.phone)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (sale.value.customer.email) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(sale.value.customer.email)}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="overflow-x-auto"><table class="w-full divide-y dark:divide-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><thead><tr><th class="font-bold text-center uppercase p-2 w-7">#</th><th class="font-bold text-left uppercase p-2">${ssrInterpolate(_ctx.$t("Description"))}</th><th class="font-bold text-center uppercase p-2 w-[120px] whitespace-nowrap">${ssrInterpolate(unref(page).props.settings.show_tax == 1 ? _ctx.$t("Price") : _ctx.$t("Unit Price"))}</th><th class="font-bold text-center uppercase p-2 w-[80px]">${ssrInterpolate(_ctx.$t("Qty"))}</th>`);
        if (unref(page).props.settings.show_discount == 1) {
          _push(`<th class="font-bold text-center uppercase p-2 w-[80px]">${ssrInterpolate(_ctx.$t("Discount"))}</th>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(page).props.settings.show_tax == 1) {
          _push(`<th class="font-bold text-center uppercase p-2 w-[80px]">${ssrInterpolate(_ctx.$t("Tax"))}</th>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<th class="font-bold text-center uppercase p-2 w-[120px]">${ssrInterpolate(_ctx.$t("Total"))}</th></tr></thead><!--[-->`);
        ssrRenderList(sale.value.items, (item, index) => {
          var _a2;
          _push(`<!--[-->`);
          if (item.variations && item.variations.length) {
            _push(`<tbody><tr><td class="p-2 w-7 text-right">${ssrInterpolate(index + 1)}</td><td class="px-2 py-1"><div class="flex items-center gap-2">`);
            if (unref(page).props.settings.show_image == 1) {
              _push(`<!--[-->`);
              if (item.product.photo) {
                _push(`<img class="w-8 h-8 rounded-sm self-start"${ssrRenderAttr("src", item.product.photo)} alt="Product Image">`);
              } else {
                _push(`<img class="w-8 h-8 mr-2 rounded-sm self-start" src="img/no-image.png" alt="No Image">`);
              }
              _push(`<!--]-->`);
            } else {
              _push(`<!---->`);
            }
            _push(` ${ssrInterpolate(item.product.name)}</div></td><td class="p-2"></td><td class="p-2 text-right"></td><td class="p-2 text-right"></td>`);
            if (unref(page).props.settings.show_tax == 1) {
              _push(`<td class="p-2"></td>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<td class="p-2"></td></tr><!--[-->`);
            ssrRenderList(item.variations, (variation) => {
              var _a3, _b2;
              _push(`<tr><td class="w-7"></td><td class="p-2">${ssrInterpolate(_ctx.$meta(variation.meta))}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number(variation.pivot.price))}</td><td class="p-2 text-right"><div class="flex items-center justify-end">${ssrInterpolate(_ctx.$number_qty(variation.pivot.quantity))}${ssrInterpolate(((_b2 = (_a3 = variation.pivot) == null ? void 0 : _a3.unit) == null ? void 0 : _b2.code) || "")}</div></td>`);
              if (unref(page).props.settings.show_discount == 1) {
                _push(`<td class="p-2 text-right">${ssrInterpolate(_ctx.$number(variation.pivot.discount_amount))}</td>`);
              } else {
                _push(`<!---->`);
              }
              if (unref(page).props.settings.show_tax == 1) {
                _push(`<td class="p-2 text-right">${ssrInterpolate(_ctx.$number(variation.pivot.tax_amount))}</td>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<td class="p-2 text-right font-bold">${ssrInterpolate(_ctx.$number(variation.pivot.total))}</td></tr>`);
            });
            _push(`<!--]--></tbody>`);
          } else {
            _push(`<tbody class="divide-y dark:divide-gray-700 border-y border-gray-200 dark:border-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><tr><td class="p-2 w-7 text-right">${ssrInterpolate(index + 1)}</td><td class="px-2 py-1"><div class="flex items-center gap-2">`);
            if (unref(page).props.settings.show_image == 1) {
              _push(`<!--[-->`);
              if (item.product.photo) {
                _push(`<img class="w-8 h-8 rounded-sm self-start"${ssrRenderAttr("src", item.product.photo)} alt="Product Image">`);
              } else {
                _push(`<img class="w-8 h-8 mr-2 rounded-sm self-start" src="img/no-image.png" alt="No Image">`);
              }
              _push(`<!--]-->`);
            } else {
              _push(`<!---->`);
            }
            _push(` ${ssrInterpolate(item.product.name)}</div></td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number(item.price))}</td><td class="p-2 text-right"><div class="flex items-center justify-end">${ssrInterpolate(_ctx.$number_qty(item.quantity))}${ssrInterpolate(((_a2 = item.unit) == null ? void 0 : _a2.code) || "")}</div></td>`);
            if (unref(page).props.settings.show_discount == 1) {
              _push(`<td class="p-2 text-right">${ssrInterpolate(_ctx.$number(item.discount_amount))}</td>`);
            } else {
              _push(`<!---->`);
            }
            if (unref(page).props.settings.show_tax == 1) {
              _push(`<td class="p-2 text-right">${ssrInterpolate(_ctx.$number(item.tax_amount))}</td>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<td class="p-2 text-right font-bold">${ssrInterpolate(_ctx.$number(item.total))}</td></tr></tbody>`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><tfoot class="divide-y dark:divide-gray-700">`);
        if (unref(page).props.settings.show_tax == 1) {
          _push(`<tr><th colspan="3" class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Total"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$decimal_qty(sale.value.items.reduce((a, i) => Number(i.quantity) + a, 0)))}</th>`);
          if (unref(page).props.settings.show_discount == 1) {
            _push(`<th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.total_discount_amount))}</th>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(page).props.settings.show_tax == 1) {
            _push(`<th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.total_tax_amount))}</th>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.total))}</th></tr>`);
        } else {
          _push(`<!--[-->`);
          if (unref(page).props.settings.show_discount == 1 && Number(sale.value.total_discount_amount) > 0) {
            _push(`<tr><th${ssrRenderAttr("colspan", colspan.value)} class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Discount"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.total_discount_amount))}</th></tr>`);
          } else {
            _push(`<!---->`);
          }
          if (_ctx.$decimal(sale.value.total_tax_amount, true) > 0) {
            _push(`<!--[--><tr><th${ssrRenderAttr("colspan", colspan.value)} class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Subtotal"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.subtotal))}</th></tr><tr><th${ssrRenderAttr("colspan", colspan.value)} class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Tax"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.total_tax_amount))}</th></tr><!--]-->`);
          } else if (unref(page).props.settings.show_zero_taxes == 1) {
            _push(`<tr><th${ssrRenderAttr("colspan", colspan.value)} class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Tax"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.total_tax_amount))}</th></tr>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<tr><th${ssrRenderAttr("colspan", colspan.value)} class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Total"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.grand_total))}</th></tr><tr><th${ssrRenderAttr("colspan", colspan.value)} class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Paid"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.paid))}</th></tr><tr><th${ssrRenderAttr("colspan", colspan.value)} class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Balance"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$currency(sale.value.grand_total - sale.value.paid))}</th></tr><!--]-->`);
        }
        _push(`</tfoot></table></div>`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          modal: false,
          fields: __props.custom_fields,
          title: _ctx.$t("Custom Fields"),
          extra_attributes: sale.value.extra_attributes
        }, null, _parent));
        if (sale.value.details) {
          _push(`<div class="pt-8 mb-4">${ssrInterpolate(sale.value.details)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (sale.value.attachments && sale.value.attachments.length) {
          _push(`<div class="mt-8 py-2 w-full print:hidden">`);
          _push(ssrRenderComponent(_component_Attachments, {
            attachments: sale.value.attachments
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (sale.value.payments && sale.value.payments.length) {
          _push(`<div class="mx-6 mb-6 rounded border border-gray-200 dark:border-gray-700 print:hidden"><h4 class="text-base px-4 py-2 font-extrabold border-b border-gray-200 dark:border-gray-700">${ssrInterpolate(_ctx.$t("Payments"))}</h4><div class="py-1 overflow-x-auto"><table class="w-full text-sm divide-y dark:divide-gray-700"><thead><tr><th class="font-bold text-left uppercase p-2 w-[140px]">${ssrInterpolate(_ctx.$t("Date"))}</th><th class="font-bold text-left uppercase p-2">${ssrInterpolate(_ctx.$t("Reference"))}</th><th class="font-bold text-left uppercase p-2 w-[100px]">${ssrInterpolate(_ctx.$t("Method"))}</th><th class="font-bold text-center uppercase p-2 w-[120px]">${ssrInterpolate(_ctx.$t("Amount"))}</th></tr></thead><tbody><!--[-->`);
          ssrRenderList(sale.value.payments, (p) => {
            _push(`<tr><td class="p-2 whitespace-nowrap">${ssrInterpolate(_ctx.$date(p.date))}</td><td class="p-2">${ssrInterpolate(p.reference)}</td><td class="p-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t(p.method))}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$currency(p.amount))}</td></tr>`);
          });
          _push(`<!--]--></tbody></table></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(unref(_sfc_main$3), {
          show: packing.value,
          "max-width": "2xl",
          onClose: ($event) => packing.value = false,
          class: "modal-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_sfc_main$4, { sale: sale.value }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_sfc_main$4, { sale: sale.value }, null, 8, ["sale"])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`<!--]-->`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-center p-6 min-h-64 text-lg font-thin" }, _attrs))}>${ssrInterpolate(_ctx.$t("No data found, the record might not belong to the selected store."))}</div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Sale/QuickView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
