import { ref, onMounted, resolveComponent, unref, mergeProps, withCtx, createTextVNode, toDisplayString, createVNode, createBlock, createCommentVNode, openBlock, Fragment, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderClass, ssrInterpolate } from "vue/server-renderer";
import { notify } from "notiwind";
import { useI18n } from "vue-i18n";
import { usePage, router } from "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, h as _sfc_main$2 } from "./http-CDixhmav.js";
import { _ as _sfc_main$3 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$1 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "RegisterDetails",
  __ssrInlineRender: true,
  props: ["show"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    usePage();
    const { t } = useI18n({});
    const emit = __emit;
    const loading = ref(false);
    const closing = ref(false);
    const register = ref(null);
    const closeRegister = ref(false);
    const registerForm = {
      note: "",
      cash_submitted: null,
      cash_in_register: null,
      cc_payments_submitted: null,
      stripe_payments_submitted: null,
      other_payments_submitted: null
    };
    onMounted(() => {
      viewRegisterDetails();
    });
    async function viewRegisterDetails() {
      loading.value = true;
      await axios.get(route("pos.register.details")).then((res) => {
        register.value = res.data.register;
        if (register.value) {
          registerForm.cash_submitted = Number(register.value.cash_payments || 0);
          registerForm.cash_in_register = Number(register.value.cash_in_hand || 0);
          registerForm.cc_payments_submitted = Number(register.value.cc_payments || 0);
          registerForm.stripe_payments_submitted = Number(register.value.other_payments || 0);
          registerForm.other_payments_submitted = Number(register.value.stripe_payments || 0);
        }
      }).finally(() => loading.value = false);
    }
    async function closeRegisterNow(e) {
      closing.value = true;
      axios.put(route("pos.register.close"), registerForm).then((res) => {
        notify({
          group: "main",
          type: "success",
          title: "Success!",
          text: t("The register has been closed!")
        });
        emit("close");
        closing.value = false;
        router.visit(route("dashboard"));
      }).finally(() => closing.value = false);
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_Loading = resolveComponent("Loading");
      const _component_TextareaInput = resolveComponent("TextareaInput");
      _push(ssrRenderComponent(unref(_sfc_main$1), mergeProps({
        show: __props.show,
        maxWidth: "xl",
        closeable: true,
        onClose: ($event) => emit("close"),
        round: ((_a = _ctx.$page.props.settings) == null ? void 0 : _a.pos_design) == "Modern"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b;
          if (_push2) {
            _push2(`<div class="${ssrRenderClass([((_a2 = _ctx.$page.props.settings) == null ? void 0 : _a2.pos_design) == "Modern" ? "rounded-2xl" : "rounded-lg", "transition-all"])}"${_scopeId}><div class="border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6"${_scopeId}><div class="absolute right-8 top-0 pr-6 pt-4 flex items-center gap-x-4"${_scopeId}>`);
            if (!loading.value) {
              _push2(`<button type="button" class="rounded-md text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Close Register"))}</span><svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor" viewBox="0 0 256 256"${_scopeId}><path d="M208,40H48A24,24,0,0,0,24,64V176a24,24,0,0,0,24,24H208a24,24,0,0,0,24-24V64A24,24,0,0,0,208,40Zm8,136a8,8,0,0,1-8,8H48a8,8,0,0,1-8-8V64a8,8,0,0,1,8-8H208a8,8,0,0,1,8,8Zm-48,48a8,8,0,0,1-8,8H96a8,8,0,0,1,0-16h64A8,8,0,0,1,168,224ZM157.66,106.34a8,8,0,0,1-11.32,11.32L136,107.31V152a8,8,0,0,1-16,0V107.31l-10.34,10.35a8,8,0,0,1-11.32-11.32l24-24a8,8,0,0,1,11.32,0Z"${_scopeId}></path></svg></button>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div><div${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(closeRegister.value ? _ctx.$t("Close Register") : _ctx.$t("Register Details"))}</h3><p class="mt-1 text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Please view the register details below."))}</p></div></div><div class="bg-gray-100 dark:bg-gray-800"${_scopeId}>`);
            if (loading.value) {
              _push2(`<div class="relative h-80"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_Loading, null, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else if (register.value) {
              _push2(`<div${_scopeId}><div class=""${_scopeId}><dl class="divide-y divide-gray-100 dark:divide-gray-700"${_scopeId}><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Opened at"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$datetime(register.value.created_at))}</dd></div><div class="px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Cash in hand"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2"${_scopeId}><div class="w-1/3"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.cash_in_hand))}</div><div class="flex-1 -my-1"${_scopeId}>`);
              if (closeRegister.value) {
                _push2(ssrRenderComponent(unref(_sfc_main$2), {
                  label: "",
                  size: "small",
                  placeholder: unref(t)("Cash in register"),
                  modelValue: registerForm.cash_in_register,
                  "onUpdate:modelValue": ($event) => registerForm.cash_in_register = $event
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></dd></div><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Total Sales"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.sales_sum_grand_total))}</dd></div><div class="px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Expenses"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.expenses_sum_amount))}</dd></div><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Purchases"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.purchases_sum_grand_total))}</dd></div><div class="px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Cash Amount"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2"${_scopeId}><div class="w-1/3"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.cash_payments))}</div><div class="flex-1 -my-1"${_scopeId}>`);
              if (closeRegister.value) {
                _push2(ssrRenderComponent(unref(_sfc_main$2), {
                  label: "",
                  size: "small",
                  placeholder: unref(t)("Cash Submitted"),
                  modelValue: registerForm.cash_submitted,
                  "onUpdate:modelValue": ($event) => registerForm.cash_submitted = $event
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></dd></div><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Credit Card Amount"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2"${_scopeId}><div class="w-1/3"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.cc_payments))}</div><div class="flex-1 -my-1"${_scopeId}>`);
              if (closeRegister.value) {
                _push2(ssrRenderComponent(unref(_sfc_main$2), {
                  label: "",
                  size: "small",
                  placeholder: unref(t)("Credit Card Value"),
                  modelValue: registerForm.cc_payments_submitted,
                  "onUpdate:modelValue": ($event) => registerForm.cc_payments_submitted = $event
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></dd></div><div class="px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Stripe Terminal Amount"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2"${_scopeId}><div class="w-1/3"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.stripe_payments))}</div><div class="flex-1 -my-1"${_scopeId}>`);
              if (closeRegister.value) {
                _push2(ssrRenderComponent(unref(_sfc_main$2), {
                  label: "",
                  size: "small",
                  placeholder: unref(t)("Stripe Payments Value"),
                  modelValue: registerForm.stripe_payments_submitted,
                  "onUpdate:modelValue": ($event) => registerForm.stripe_payments_submitted = $event
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></dd></div><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Other Payment Amount"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2"${_scopeId}><div class="w-1/3"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.other_payments))}</div><div class="flex-1 -my-1"${_scopeId}>`);
              if (closeRegister.value) {
                _push2(ssrRenderComponent(unref(_sfc_main$2), {
                  label: "",
                  size: "small",
                  placeholder: unref(t)("Other Payments Value"),
                  modelValue: registerForm.other_payments_submitted,
                  "onUpdate:modelValue": ($event) => registerForm.other_payments_submitted = $event
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></dd></div><div class="px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Gift Card Amount"))}</dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2"${_scopeId}><div class="w-1/3"${_scopeId}>${ssrInterpolate(_ctx.$number(register.value.gift_card_payments))}</div><div class="flex-1 -my-1"${_scopeId}></div></dd></div>`);
              if (closeRegister.value) {
                _push2(`<!--[--><div class="bg-gray-50 dark:bg-gray-900/50 transition-all px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_TextareaInput, {
                  label: "",
                  placeholder: unref(t)("Any Notes"),
                  modelValue: registerForm.note,
                  "onUpdate:modelValue": ($event) => registerForm.note = $event
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="transition-all bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm font-medium leading-6"${_scopeId}></dt><dd class="text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center justify-end gap-x-4"${_scopeId}><button type="button" class="rounded-sm p-1"${_scopeId}>${ssrInterpolate(_ctx.$t("Cancel"))}</button>`);
                _push2(ssrRenderComponent(unref(_sfc_main$3), {
                  type: "button",
                  onClick: closeRegisterNow,
                  loading: closing.value
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.$t("Close Register"))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("Close Register")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
                _push2(`</dd></div><!--]-->`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</dl></div></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", {
                class: ["transition-all", ((_b = _ctx.$page.props.settings) == null ? void 0 : _b.pos_design) == "Modern" ? "rounded-2xl" : "rounded-lg"]
              }, [
                createVNode("div", { class: "border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6" }, [
                  createVNode("div", { class: "absolute right-8 top-0 pr-6 pt-4 flex items-center gap-x-4" }, [
                    !loading.value ? (openBlock(), createBlock("button", {
                      key: 0,
                      type: "button",
                      onClick: () => closeRegister.value = true,
                      class: "rounded-md text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"
                    }, [
                      createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close Register")), 1),
                      (openBlock(), createBlock("svg", {
                        xmlns: "http://www.w3.org/2000/svg",
                        class: "h-6 w-6",
                        fill: "currentColor",
                        viewBox: "0 0 256 256"
                      }, [
                        createVNode("path", { d: "M208,40H48A24,24,0,0,0,24,64V176a24,24,0,0,0,24,24H208a24,24,0,0,0,24-24V64A24,24,0,0,0,208,40Zm8,136a8,8,0,0,1-8,8H48a8,8,0,0,1-8-8V64a8,8,0,0,1,8-8H208a8,8,0,0,1,8,8Zm-48,48a8,8,0,0,1-8,8H96a8,8,0,0,1,0-16h64A8,8,0,0,1,168,224ZM157.66,106.34a8,8,0,0,1-11.32,11.32L136,107.31V152a8,8,0,0,1-16,0V107.31l-10.34,10.35a8,8,0,0,1-11.32-11.32l24-24a8,8,0,0,1,11.32,0Z" })
                      ]))
                    ], 8, ["onClick"])) : createCommentVNode("", true)
                  ]),
                  createVNode("div", null, [
                    createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(closeRegister.value ? _ctx.$t("Close Register") : _ctx.$t("Register Details")), 1),
                    createVNode("p", { class: "mt-1 text-sm" }, toDisplayString(_ctx.$t("Please view the register details below.")), 1)
                  ])
                ]),
                createVNode("div", { class: "bg-gray-100 dark:bg-gray-800" }, [
                  loading.value ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "relative h-80"
                  }, [
                    createVNode(_component_Loading)
                  ])) : register.value ? (openBlock(), createBlock("div", { key: 1 }, [
                    createVNode("div", { class: "" }, [
                      createVNode("dl", { class: "divide-y divide-gray-100 dark:divide-gray-700" }, [
                        createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Opened at")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$datetime(register.value.created_at)), 1)
                        ]),
                        createVNode("div", { class: "px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Cash in hand")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2" }, [
                            createVNode("div", { class: "w-1/3" }, toDisplayString(_ctx.$number(register.value.cash_in_hand)), 1),
                            createVNode("div", { class: "flex-1 -my-1" }, [
                              closeRegister.value ? (openBlock(), createBlock(unref(_sfc_main$2), {
                                key: 0,
                                label: "",
                                size: "small",
                                placeholder: unref(t)("Cash in register"),
                                modelValue: registerForm.cash_in_register,
                                "onUpdate:modelValue": ($event) => registerForm.cash_in_register = $event
                              }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"])) : createCommentVNode("", true)
                            ])
                          ])
                        ]),
                        createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Total Sales")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$number(register.value.sales_sum_grand_total)), 1)
                        ]),
                        createVNode("div", { class: "px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Expenses")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$number(register.value.expenses_sum_amount)), 1)
                        ]),
                        createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Purchases")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$number(register.value.purchases_sum_grand_total)), 1)
                        ]),
                        createVNode("div", { class: "px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Cash Amount")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2" }, [
                            createVNode("div", { class: "w-1/3" }, toDisplayString(_ctx.$number(register.value.cash_payments)), 1),
                            createVNode("div", { class: "flex-1 -my-1" }, [
                              closeRegister.value ? (openBlock(), createBlock(unref(_sfc_main$2), {
                                key: 0,
                                label: "",
                                size: "small",
                                placeholder: unref(t)("Cash Submitted"),
                                modelValue: registerForm.cash_submitted,
                                "onUpdate:modelValue": ($event) => registerForm.cash_submitted = $event
                              }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"])) : createCommentVNode("", true)
                            ])
                          ])
                        ]),
                        createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Credit Card Amount")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2" }, [
                            createVNode("div", { class: "w-1/3" }, toDisplayString(_ctx.$number(register.value.cc_payments)), 1),
                            createVNode("div", { class: "flex-1 -my-1" }, [
                              closeRegister.value ? (openBlock(), createBlock(unref(_sfc_main$2), {
                                key: 0,
                                label: "",
                                size: "small",
                                placeholder: unref(t)("Credit Card Value"),
                                modelValue: registerForm.cc_payments_submitted,
                                "onUpdate:modelValue": ($event) => registerForm.cc_payments_submitted = $event
                              }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"])) : createCommentVNode("", true)
                            ])
                          ])
                        ]),
                        createVNode("div", { class: "px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Stripe Terminal Amount")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2" }, [
                            createVNode("div", { class: "w-1/3" }, toDisplayString(_ctx.$number(register.value.stripe_payments)), 1),
                            createVNode("div", { class: "flex-1 -my-1" }, [
                              closeRegister.value ? (openBlock(), createBlock(unref(_sfc_main$2), {
                                key: 0,
                                label: "",
                                size: "small",
                                placeholder: unref(t)("Stripe Payments Value"),
                                modelValue: registerForm.stripe_payments_submitted,
                                "onUpdate:modelValue": ($event) => registerForm.stripe_payments_submitted = $event
                              }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"])) : createCommentVNode("", true)
                            ])
                          ])
                        ]),
                        createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Other Payment Amount")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2" }, [
                            createVNode("div", { class: "w-1/3" }, toDisplayString(_ctx.$number(register.value.other_payments)), 1),
                            createVNode("div", { class: "flex-1 -my-1" }, [
                              closeRegister.value ? (openBlock(), createBlock(unref(_sfc_main$2), {
                                key: 0,
                                label: "",
                                size: "small",
                                placeholder: unref(t)("Other Payments Value"),
                                modelValue: registerForm.other_payments_submitted,
                                "onUpdate:modelValue": ($event) => registerForm.other_payments_submitted = $event
                              }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"])) : createCommentVNode("", true)
                            ])
                          ])
                        ]),
                        createVNode("div", { class: "px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                          createVNode("dt", { class: "text-sm font-medium leading-6" }, toDisplayString(_ctx.$t("Gift Card Amount")), 1),
                          createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center gap-x-2" }, [
                            createVNode("div", { class: "w-1/3" }, toDisplayString(_ctx.$number(register.value.gift_card_payments)), 1),
                            createVNode("div", { class: "flex-1 -my-1" })
                          ])
                        ]),
                        closeRegister.value ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                          createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 transition-all px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                            createVNode(_component_TextareaInput, {
                              label: "",
                              placeholder: unref(t)("Any Notes"),
                              modelValue: registerForm.note,
                              "onUpdate:modelValue": ($event) => registerForm.note = $event
                            }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"])
                          ]),
                          createVNode("div", { class: "transition-all bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                            createVNode("dt", { class: "text-sm font-medium leading-6" }),
                            createVNode("dd", { class: "text-sm leading-6 sm:col-span-2 sm:mt-0 flex items-center justify-end gap-x-4" }, [
                              createVNode("button", {
                                type: "button",
                                class: "rounded-sm p-1",
                                onClick: ($event) => closeRegister.value = false
                              }, toDisplayString(_ctx.$t("Cancel")), 9, ["onClick"]),
                              createVNode(unref(_sfc_main$3), {
                                type: "button",
                                onClick: closeRegisterNow,
                                loading: closing.value
                              }, {
                                default: withCtx(() => [
                                  createTextVNode(toDisplayString(_ctx.$t("Close Register")), 1)
                                ]),
                                _: 1
                              }, 8, ["loading"])
                            ])
                          ])
                        ], 64)) : createCommentVNode("", true)
                      ])
                    ])
                  ])) : createCommentVNode("", true)
                ])
              ], 2)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/RegisterDetails.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
