import { ref, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { T } from "../ssr.js";
import { useI18n } from "vue-i18n";
import { usePage, useForm } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { E as _sfc_main$2, b as _sfc_main$6, h as _sfc_main$7 } from "./http-CDixhmav.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$3 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "ScaleBarcode",
  __ssrInlineRender: true,
  props: { current: Object },
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k;
    usePage();
    const { t } = useI18n({});
    const props = __props;
    const showGuide = ref(false);
    const tab_links = ref([
      { label: t("General Settings"), route: "settings.index", icon: "settings" },
      { label: t("Mail Settings"), route: "settings.mail", icon: "envelope" },
      { label: t("Payment Settings"), route: "settings.payment", icon: "dollar" },
      { label: t("Scale Barcode Settings"), route: "settings.barcode", icon: "scale" }
    ]);
    if (T().has("settings.pos")) {
      tab_links.value.push({ label: t("POS Settings"), route: "settings.pos", icon: "pos" });
    }
    const form = useForm({
      type: ((_a = props.current) == null ? void 0 : _a.type) || "price",
      length: ((_b = props.current) == null ? void 0 : _b.length) || null,
      flag_length: ((_c = props.current) == null ? void 0 : _c.flag_length) || null,
      code_start: ((_d = props.current) == null ? void 0 : _d.code_start) || null,
      code_length: ((_e = props.current) == null ? void 0 : _e.code_length) || null,
      price_start: ((_f = props.current) == null ? void 0 : _f.price_start) || null,
      price_length: ((_g = props.current) == null ? void 0 : _g.price_length) || null,
      price_divide_by: ((_h = props.current) == null ? void 0 : _h.price_divide_by) || null,
      weight_start: ((_i = props.current) == null ? void 0 : _i.weight_start) || null,
      weight_length: ((_j = props.current) == null ? void 0 : _j.weight_length) || null,
      weight_divide_by: ((_k = props.current) == null ? void 0 : _k.weight_divide_by) || null
    });
    function save() {
      form.post(T("settings.barcode.store"));
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Icon = resolveComponent("Icon");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Scale Barcode Settings"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Scale Barcode Settings")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), { links: tab_links.value }, null, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onSubmitted: save }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center gap-2"${_scopeId}>${ssrInterpolate(_ctx.$t("Scale Barcode Settings"))} <button type="button" class="relative rounded-md hover:text-gray-500 focus:ring-2 focus:ring-primary-500 mr-2"${_scopeId}><span class="absolute -inset-2.5"${_scopeId}></span><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Guide"))}</span>`);
            _push2(ssrRenderComponent(_component_Icon, { name: "info" }, null, _parent2, _scopeId));
            _push2(`</button></div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center gap-2" }, [
                createTextVNode(toDisplayString(_ctx.$t("Scale Barcode Settings")) + " ", 1),
                createVNode("button", {
                  type: "button",
                  onClick: () => showGuide.value = true,
                  class: "relative rounded-md hover:text-gray-500 focus:ring-2 focus:ring-primary-500 mr-2"
                }, [
                  createVNode("span", { class: "absolute -inset-2.5" }),
                  createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Guide")), 1),
                  createVNode(_component_Icon, { name: "info" })
                ], 8, ["onClick"])
              ])
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please set the settings to parse scale barcodes."))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please set the settings to parse scale barcodes.")), 1)
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (showGuide.value) {
              _push2(`<div class="relative col-span-full -mx-4 -mt-6 sm:-mx-6"${_scopeId}><button type="button" class="absolute right-1 top-1 p-1 bg-gray-100 dark:bg-gray-700 rounded-md hover:text-gray-500 focus:ring-2 focus:ring-primary-500"${_scopeId}><span class="absolute -inset-2.5"${_scopeId}></span><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Hide"))}</span><svg class="size-5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12"${_scopeId}></path></svg></button><img src="/img/scale_barcode.png" alt="" class="sm:rounded-t-md w-full"${_scopeId}></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              json: true,
              id: "form.type",
              searchable: false,
              modelValue: unref(form).type,
              "onUpdate:modelValue": ($event) => unref(form).type = $event,
              error: unref(form).errors.type,
              label: _ctx.$t("Barcode Contains"),
              suggestions: [
                { value: "price", label: _ctx.$t("Price") },
                { value: "weight", label: _ctx.$t("Quantity/Weight") }
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              modelValue: unref(form).length,
              "onUpdate:modelValue": ($event) => unref(form).length = $event,
              label: _ctx.$t("Barcode Length"),
              error: unref(form).errors.length
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              modelValue: unref(form).flag_length,
              "onUpdate:modelValue": ($event) => unref(form).flag_length = $event,
              label: _ctx.$t("Flag Characters Length"),
              error: unref(form).errors.flag_length
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              modelValue: unref(form).code_start,
              "onUpdate:modelValue": ($event) => unref(form).code_start = $event,
              label: _ctx.$t("Item Code Start Position"),
              error: unref(form).errors.code_start
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              modelValue: unref(form).code_length,
              "onUpdate:modelValue": ($event) => unref(form).code_length = $event,
              label: _ctx.$t("Item Code Characters Length"),
              error: unref(form).errors.code_length
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(form).type == "weight") {
              _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                modelValue: unref(form).weight_start,
                "onUpdate:modelValue": ($event) => unref(form).weight_start = $event,
                label: _ctx.$t("Weight Start Position"),
                error: unref(form).errors.weight_start
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                modelValue: unref(form).weight_length,
                "onUpdate:modelValue": ($event) => unref(form).weight_length = $event,
                label: _ctx.$t("Weight Characters Length"),
                error: unref(form).errors.weight_length
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                modelValue: unref(form).weight_divide_by,
                "onUpdate:modelValue": ($event) => unref(form).weight_divide_by = $event,
                label: _ctx.$t("Weight Divide by"),
                error: unref(form).errors.weight_divide_by
              }, null, _parent2, _scopeId));
              _push2(`</div><!--]-->`);
            } else {
              _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                modelValue: unref(form).price_start,
                "onUpdate:modelValue": ($event) => unref(form).price_start = $event,
                label: _ctx.$t("Price Start Position"),
                error: unref(form).errors.price_start
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                modelValue: unref(form).price_length,
                "onUpdate:modelValue": ($event) => unref(form).price_length = $event,
                label: _ctx.$t("Price Characters Length"),
                error: unref(form).errors.price_length
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                modelValue: unref(form).price_divide_by,
                "onUpdate:modelValue": ($event) => unref(form).price_divide_by = $event,
                label: _ctx.$t("Price Divide by"),
                error: unref(form).errors.price_divide_by
              }, null, _parent2, _scopeId));
              _push2(`</div><!--]-->`);
            }
          } else {
            return [
              showGuide.value ? (openBlock(), createBlock("div", {
                key: 0,
                class: "relative col-span-full -mx-4 -mt-6 sm:-mx-6"
              }, [
                createVNode("button", {
                  type: "button",
                  onClick: () => showGuide.value = false,
                  class: "absolute right-1 top-1 p-1 bg-gray-100 dark:bg-gray-700 rounded-md hover:text-gray-500 focus:ring-2 focus:ring-primary-500"
                }, [
                  createVNode("span", { class: "absolute -inset-2.5" }),
                  createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Hide")), 1),
                  (openBlock(), createBlock("svg", {
                    class: "size-5",
                    fill: "none",
                    viewBox: "0 0 24 24",
                    "stroke-width": "1.5",
                    stroke: "currentColor",
                    "aria-hidden": "true",
                    "data-slot": "icon"
                  }, [
                    createVNode("path", {
                      "stroke-linecap": "round",
                      "stroke-linejoin": "round",
                      d: "M6 18 18 6M6 6l12 12"
                    })
                  ]))
                ], 8, ["onClick"]),
                createVNode("img", {
                  src: "/img/scale_barcode.png",
                  alt: "",
                  class: "sm:rounded-t-md w-full"
                })
              ])) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  json: true,
                  id: "form.type",
                  searchable: false,
                  modelValue: unref(form).type,
                  "onUpdate:modelValue": ($event) => unref(form).type = $event,
                  error: unref(form).errors.type,
                  label: _ctx.$t("Barcode Contains"),
                  suggestions: [
                    { value: "price", label: _ctx.$t("Price") },
                    { value: "weight", label: _ctx.$t("Quantity/Weight") }
                  ]
                }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "label", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$7), {
                  modelValue: unref(form).length,
                  "onUpdate:modelValue": ($event) => unref(form).length = $event,
                  label: _ctx.$t("Barcode Length"),
                  error: unref(form).errors.length
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$7), {
                  modelValue: unref(form).flag_length,
                  "onUpdate:modelValue": ($event) => unref(form).flag_length = $event,
                  label: _ctx.$t("Flag Characters Length"),
                  error: unref(form).errors.flag_length
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$7), {
                  modelValue: unref(form).code_start,
                  "onUpdate:modelValue": ($event) => unref(form).code_start = $event,
                  label: _ctx.$t("Item Code Start Position"),
                  error: unref(form).errors.code_start
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$7), {
                  modelValue: unref(form).code_length,
                  "onUpdate:modelValue": ($event) => unref(form).code_length = $event,
                  label: _ctx.$t("Item Code Characters Length"),
                  error: unref(form).errors.code_length
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              unref(form).type == "weight" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$7), {
                    modelValue: unref(form).weight_start,
                    "onUpdate:modelValue": ($event) => unref(form).weight_start = $event,
                    label: _ctx.$t("Weight Start Position"),
                    error: unref(form).errors.weight_start
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$7), {
                    modelValue: unref(form).weight_length,
                    "onUpdate:modelValue": ($event) => unref(form).weight_length = $event,
                    label: _ctx.$t("Weight Characters Length"),
                    error: unref(form).errors.weight_length
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$7), {
                    modelValue: unref(form).weight_divide_by,
                    "onUpdate:modelValue": ($event) => unref(form).weight_divide_by = $event,
                    label: _ctx.$t("Weight Divide by"),
                    error: unref(form).errors.weight_divide_by
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
                ])
              ], 64)) : (openBlock(), createBlock(Fragment, { key: 2 }, [
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$7), {
                    modelValue: unref(form).price_start,
                    "onUpdate:modelValue": ($event) => unref(form).price_start = $event,
                    label: _ctx.$t("Price Start Position"),
                    error: unref(form).errors.price_start
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$7), {
                    modelValue: unref(form).price_length,
                    "onUpdate:modelValue": ($event) => unref(form).price_length = $event,
                    label: _ctx.$t("Price Characters Length"),
                    error: unref(form).errors.price_length
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$7), {
                    modelValue: unref(form).price_divide_by,
                    "onUpdate:modelValue": ($event) => unref(form).price_divide_by = $event,
                    label: _ctx.$t("Price Divide by"),
                    error: unref(form).errors.price_divide_by
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
                ])
              ], 64))
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$4), {
                on: unref(form).recentlySuccessful,
                class: "me-3"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                ]),
                _: 1
              }, 8, ["on"]),
              createVNode(unref(_sfc_main$5), {
                class: { "opacity-25": unref(form).processing },
                loading: unref(form).processing
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                ]),
                _: 1
              }, 8, ["class", "loading"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/ScaleBarcode.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
