import { ref, computed, watch, onMounted, onUnmounted, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "../ssr.js";
import { useForm } from "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { b as _sfc_main$1, h as _sfc_main$2 } from "./http-CDixhmav.js";
import { _ as _sfc_main$4 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "ScaleBarcodeDrawer",
  __ssrInlineRender: true,
  props: { modelValue: Boolean, settings: Object },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const props = __props;
    const show = ref(false);
    const showGuide = ref(false);
    const form = useForm({
      type: "price",
      length: null,
      flag_length: null,
      code_start: null,
      code_length: null,
      price_start: null,
      price_length: null,
      price_divide_by: null,
      weight_start: null,
      weight_length: null,
      weight_divide_by: null
    });
    const proxyModelValue = computed({
      get() {
        setTimeout(() => {
          show.value = props.modelValue;
        }, 10);
        return props.modelValue;
      },
      set(val) {
        show.value = val;
        setTimeout(() => {
          emit("update:modelValue", val);
        }, 500);
      }
    });
    watch(
      () => proxyModelValue.value,
      () => {
        if (proxyModelValue.value) {
          document.body.style.overflow = "hidden";
        } else {
          document.body.style.overflow = null;
        }
      }
    );
    onMounted(() => {
      document.addEventListener("keydown", closeOnEscape);
      Object.keys(props.settings.scale_barcode).forEach((key) => {
        form[key] = props.settings.scale_barcode[key];
      });
    });
    onUnmounted(() => {
      document.removeEventListener("keydown", closeOnEscape);
      document.body.style.overflow = null;
    });
    const closeOnEscape = (e) => {
      if (e.key === "Escape") {
        e.preventDefault();
        if (proxyModelValue.value) {
          proxyModelValue.value = false;
        }
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      if (proxyModelValue.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative" }, _attrs))}><div class="fixed inset-0 z-20 overflow-hidden"><div class="absolute inset-0 overflow-hidden"><div style="${ssrRenderStyle(show.value ? null : { display: "none" })}" class="backdrop-blur-sm fixed inset-0 transform transition-all"><div class="absolute inset-0 bg-gray-100 dark:bg-gray-900 opacity-75"></div></div><div class="pointer-events-none fixed inset-y-0 right-0 flex max-w-full pl-10 sm:pl-16">`);
        if (show.value) {
          _push(`<div class="pointer-events-auto w-screen max-w-md z-10"><form class="flex h-full flex-col overflow-y-scroll bg-white dark:bg-gray-950 shadow-xl"><div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700"><div class="flex items-start justify-between"><div><h2 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Scale Barcode Settings"))}</h2><p class="text-mute mt-1 text-xs">${ssrInterpolate(_ctx.$t("Please configure the settings to parse scale barcodes."))}</p></div><div class="ml-3 flex h-7 items-center"><button type="button" class="relative rounded-md hover:text-gray-500 focus:ring-2 focus:ring-primary-500 mr-2"><span class="absolute -inset-2.5"></span><span class="sr-only">${ssrInterpolate(_ctx.$t("Guide"))}</span><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6"><path stroke-linecap="round" stroke-linejoin="round" d="m11.25 11.25.041-.02a.75.75 0 0 1 1.063.852l-.708 2.836a.75.75 0 0 0 1.063.853l.041-.021M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9-3.75h.008v.008H12V8.25Z"></path></svg></button><button type="button" class="relative rounded-md hover:text-gray-500 focus:ring-2 focus:ring-primary-500"><span class="absolute -inset-2.5"></span><span class="sr-only">${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12"></path></svg></button></div></div></div><div class="flex-1 overflow-y-auto p-6 flex flex-col gap-6">`);
          if (showGuide.value) {
            _push(`<div class="relative"><button type="button" class="absolute -right-2 -top-2 p-1 bg-gray-100 dark:bg-gray-700 rounded-md hover:text-gray-500 focus:ring-2 focus:ring-primary-500"><span class="absolute -inset-2.5"></span><span class="sr-only">${ssrInterpolate(_ctx.$t("Hide"))}</span><svg class="size-5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12"></path></svg></button><img src="/img/scale_barcode.png" alt="" class="rounded-md"></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div>`);
          _push(ssrRenderComponent(unref(_sfc_main$1), {
            json: true,
            id: "form.type",
            searchable: false,
            modelValue: unref(form).type,
            "onUpdate:modelValue": ($event) => unref(form).type = $event,
            error: unref(form).errors.type,
            label: _ctx.$t("Barcode Contains"),
            suggestions: [
              { value: "price", label: _ctx.$t("Price") },
              { value: "weight", label: _ctx.$t("Quantity/Weight") }
            ]
          }, null, _parent));
          _push(`</div><div>`);
          _push(ssrRenderComponent(unref(_sfc_main$2), {
            modelValue: unref(form).length,
            "onUpdate:modelValue": ($event) => unref(form).length = $event,
            label: _ctx.$t("Barcode Length"),
            error: unref(form).errors.length
          }, null, _parent));
          _push(`</div><div>`);
          _push(ssrRenderComponent(unref(_sfc_main$2), {
            modelValue: unref(form).flag_length,
            "onUpdate:modelValue": ($event) => unref(form).flag_length = $event,
            label: _ctx.$t("Flag Characters Length"),
            error: unref(form).errors.flag_length
          }, null, _parent));
          _push(`</div><div>`);
          _push(ssrRenderComponent(unref(_sfc_main$2), {
            modelValue: unref(form).code_start,
            "onUpdate:modelValue": ($event) => unref(form).code_start = $event,
            label: _ctx.$t("Item Code Start Position"),
            error: unref(form).errors.code_start
          }, null, _parent));
          _push(`</div><div>`);
          _push(ssrRenderComponent(unref(_sfc_main$2), {
            modelValue: unref(form).code_length,
            "onUpdate:modelValue": ($event) => unref(form).code_length = $event,
            label: _ctx.$t("Item Code Characters Length"),
            error: unref(form).errors.code_length
          }, null, _parent));
          _push(`</div>`);
          if (unref(form).type == "weight") {
            _push(`<!--[--><div>`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              modelValue: unref(form).weight_start,
              "onUpdate:modelValue": ($event) => unref(form).weight_start = $event,
              label: _ctx.$t("Weight Start Position"),
              error: unref(form).errors.weight_start
            }, null, _parent));
            _push(`</div><div>`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              modelValue: unref(form).weight_length,
              "onUpdate:modelValue": ($event) => unref(form).weight_length = $event,
              label: _ctx.$t("Weight Characters Length"),
              error: unref(form).errors.weight_length
            }, null, _parent));
            _push(`</div><div>`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              modelValue: unref(form).weight_divide_by,
              "onUpdate:modelValue": ($event) => unref(form).weight_divide_by = $event,
              label: _ctx.$t("Weight Divide by"),
              error: unref(form).errors.weight_divide_by
            }, null, _parent));
            _push(`</div><!--]-->`);
          } else {
            _push(`<!--[--><div>`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              modelValue: unref(form).price_start,
              "onUpdate:modelValue": ($event) => unref(form).price_start = $event,
              label: _ctx.$t("Price Start Position"),
              error: unref(form).errors.price_start
            }, null, _parent));
            _push(`</div><div>`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              modelValue: unref(form).price_length,
              "onUpdate:modelValue": ($event) => unref(form).price_length = $event,
              label: _ctx.$t("Price Characters Length"),
              error: unref(form).errors.price_length
            }, null, _parent));
            _push(`</div><div>`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              modelValue: unref(form).price_divide_by,
              "onUpdate:modelValue": ($event) => unref(form).price_divide_by = $event,
              label: _ctx.$t("Price Divide by"),
              error: unref(form).errors.price_divide_by
            }, null, _parent));
            _push(`</div><!--]-->`);
          }
          _push(`<div class="flex items-center justify-between">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            class: "mr-3",
            onClick: () => proxyModelValue.value = false
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(ssrRenderComponent(unref(_sfc_main$4), {
            class: { "opacity-25": unref(form).processing },
            loading: unref(form).processing
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div></div></form></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/ScaleBarcodeDrawer.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
