import { resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { T } from "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { E as _sfc_main$2, b as _sfc_main$6, s as _sfc_main$7 } from "./http-CDixhmav.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$3 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "lodash.debounce";
import "dayjs";
import "vue-i18n";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Setting",
  __ssrInlineRender: true,
  props: { current: Object, categories: Array },
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    usePage();
    const props = __props;
    const form = useForm({
      pos_design: ((_a = props.current) == null ? void 0 : _a.pos_design) || "Modern",
      default_category: (_b = props.current) == null ? void 0 : _b.default_category,
      default_customer: (_c = props.current) == null ? void 0 : _c.default_customer,
      quick_cash: (_d = props.current) == null ? void 0 : _d.quick_cash,
      play_sound: ((_e = props.current) == null ? void 0 : _e.play_sound) == 1,
      pos_server: ((_f = props.current) == null ? void 0 : _f.pos_server) == 1,
      auto_open_order: ((_g = props.current) == null ? void 0 : _g.auto_open_order) == 1,
      print_dialog: ((_h = props.current) == null ? void 0 : _h.print_dialog) == 1,
      restaurant: ((_i = props.current) == null ? void 0 : _i.restaurant) == 1
    });
    const save = () => {
      form.post(T("settings.pos"));
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Application Settings"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Application Settings")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        links: [
          { label: _ctx.$t("General Settings"), route: "settings.index", icon: "settings" },
          { label: _ctx.$t("Mail Settings"), route: "settings.mail", icon: "envelope" },
          { label: _ctx.$t("Payment Settings"), route: "settings.payment", icon: "dollar" },
          { label: _ctx.$t("Scale Barcode Settings"), route: "settings.barcode", icon: "scale" },
          { label: _ctx.$t("POS Settings"), route: "settings.pos", icon: "pos" }
        ]
      }, null, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onSubmitted: save }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("POS Settings"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("POS Settings")), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please update setting as you desire"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please update setting as you desire")), 1)
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              json: true,
              id: "pos_design",
              label: _ctx.$t("Design"),
              modelValue: unref(form).pos_design,
              "onUpdate:modelValue": ($event) => unref(form).pos_design = $event,
              error: unref(form).errors.pos_design,
              suggestions: [
                { value: "Modern", label: _ctx.$t("Modern") },
                { value: "Simple", label: _ctx.$t("Simple") }
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              json: true,
              id: "default_category",
              suggestions: __props.categories,
              label: _ctx.$t("Default Category"),
              modelValue: unref(form).default_category,
              "onUpdate:modelValue": ($event) => unref(form).default_category = $event,
              error: unref(form).errors.default_category
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              json: true,
              valueKey: "id",
              labelKey: "company",
              id: "default_customer",
              label: _ctx.$t("Default Customer"),
              modelValue: unref(form).default_customer,
              "onUpdate:modelValue": ($event) => unref(form).default_customer = $event,
              error: unref(form).errors.default_customer,
              suggestions: unref(T)("search.customers")
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}><h4 class="text-sm font-bold mb-3"${_scopeId}>${ssrInterpolate(_ctx.$t("POS"))}</h4>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "play_sound",
              label: _ctx.$t("Play sound on order item"),
              modelValue: unref(form).play_sound,
              "onUpdate:modelValue": ($event) => unref(form).play_sound = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "onscreen_keyboard",
              label: _ctx.$t("Enable onscreen keyboard"),
              modelValue: unref(form).onscreen_keyboard,
              "onUpdate:modelValue": ($event) => unref(form).onscreen_keyboard = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "pos_server",
              label: _ctx.$t("Print using POS Print Server"),
              modelValue: unref(form).pos_server,
              "onUpdate:modelValue": ($event) => unref(form).pos_server = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "auto_open_order",
              label: _ctx.$t("Auto open first order on POS"),
              modelValue: unref(form).auto_open_order,
              "onUpdate:modelValue": ($event) => unref(form).auto_open_order = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "print_dialog",
              label: _ctx.$t("Auto print or open browser print dialog"),
              modelValue: unref(form).print_dialog,
              "onUpdate:modelValue": ($event) => unref(form).print_dialog = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "restaurant",
              modelValue: unref(form).restaurant,
              "onUpdate:modelValue": ($event) => unref(form).restaurant = $event,
              label: _ctx.$t("Enable restaurant feature for POS i.e, halls, tables & recipes")
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  json: true,
                  id: "pos_design",
                  label: _ctx.$t("Design"),
                  modelValue: unref(form).pos_design,
                  "onUpdate:modelValue": ($event) => unref(form).pos_design = $event,
                  error: unref(form).errors.pos_design,
                  suggestions: [
                    { value: "Modern", label: _ctx.$t("Modern") },
                    { value: "Simple", label: _ctx.$t("Simple") }
                  ]
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  json: true,
                  id: "default_category",
                  suggestions: __props.categories,
                  label: _ctx.$t("Default Category"),
                  modelValue: unref(form).default_category,
                  "onUpdate:modelValue": ($event) => unref(form).default_category = $event,
                  error: unref(form).errors.default_category
                }, null, 8, ["suggestions", "label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  json: true,
                  valueKey: "id",
                  labelKey: "company",
                  id: "default_customer",
                  label: _ctx.$t("Default Customer"),
                  modelValue: unref(form).default_customer,
                  "onUpdate:modelValue": ($event) => unref(form).default_customer = $event,
                  error: unref(form).errors.default_customer,
                  suggestions: unref(T)("search.customers")
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                createVNode("h4", { class: "text-sm font-bold mb-3" }, toDisplayString(_ctx.$t("POS")), 1),
                createVNode(unref(_sfc_main$7), {
                  id: "play_sound",
                  label: _ctx.$t("Play sound on order item"),
                  modelValue: unref(form).play_sound,
                  "onUpdate:modelValue": ($event) => unref(form).play_sound = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$7), {
                  id: "onscreen_keyboard",
                  label: _ctx.$t("Enable onscreen keyboard"),
                  modelValue: unref(form).onscreen_keyboard,
                  "onUpdate:modelValue": ($event) => unref(form).onscreen_keyboard = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$7), {
                  id: "pos_server",
                  label: _ctx.$t("Print using POS Print Server"),
                  modelValue: unref(form).pos_server,
                  "onUpdate:modelValue": ($event) => unref(form).pos_server = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$7), {
                  id: "auto_open_order",
                  label: _ctx.$t("Auto open first order on POS"),
                  modelValue: unref(form).auto_open_order,
                  "onUpdate:modelValue": ($event) => unref(form).auto_open_order = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$7), {
                  id: "print_dialog",
                  label: _ctx.$t("Auto print or open browser print dialog"),
                  modelValue: unref(form).print_dialog,
                  "onUpdate:modelValue": ($event) => unref(form).print_dialog = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$7), {
                  id: "restaurant",
                  modelValue: unref(form).restaurant,
                  "onUpdate:modelValue": ($event) => unref(form).restaurant = $event,
                  label: _ctx.$t("Enable restaurant feature for POS i.e, halls, tables & recipes")
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label"])
              ])
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$4), {
                on: unref(form).recentlySuccessful,
                class: "me-3"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                ]),
                _: 1
              }, 8, ["on"]),
              createVNode(unref(_sfc_main$5), {
                class: { "opacity-25": unref(form).processing },
                loading: unref(form).processing
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                ]),
                _: 1
              }, 8, ["class", "loading"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Setting.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
