import { ref, onMounted, resolveComponent, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { a as axios, _ as _sfc_main$1 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "ShowOrders",
  __ssrInlineRender: true,
  props: ["show"],
  emits: ["close", "loadOrder", "delete-order"],
  setup(__props, { emit: __emit }) {
    usePage();
    const orders = ref(null);
    const loading = ref(false);
    onMounted(() => {
      showOpenOrders();
    });
    async function showOpenOrders() {
      loading.value = true;
      axios.get(route("pos.orders")).then((res) => orders.value = res.data).catch().finally(() => loading.value = false);
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="relative border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6"><div class="absolute right-0 top-0 pr-4 pt-4"><button type="button" class="rounded-md hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"><span class="sr-only">${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path></svg></button></div><div><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100">${ssrInterpolate(_ctx.$t("Open Orders (on hold)"))}</h3><p class="mt-1 text-sm">${ssrInterpolate(_ctx.$t("Please click the order below to load it."))}</p></div></div><div class="p-6 bg-gray-100 dark:bg-gray-800 rounded-b-lg">`);
      if (loading.value) {
        _push(`<div class="h-40">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), { loadingClass: "w-10 h-20" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (orders.value && orders.value.data && orders.value.data.length) {
        _push(`<ul role="list" class="grid grid-cols-1 gap-6 sm:grid-cols-2"><!--[-->`);
        ssrRenderList(orders.value.data, (openOrder) => {
          var _a;
          _push(`<li class="relative col-span-1 divide-y divide-gray-200 rounded-lg bg-white hover:bg-gray-50 shadow-sm dark:bg-gray-900"><button type="button" class="flex w-full text-left items-start justify-between space-x-4 p-4"><div class="flex-1 truncate"><p class="mt-1 truncate text-sm font-medium">${ssrInterpolate(_ctx.$t("Ref"))}: <span class="font-bold">${ssrInterpolate(openOrder.reference)}</span></p><h3 class="mt-0.5 truncate text-sm font-bold text-gray-900 dark:text-gray-100">#${ssrInterpolate(openOrder.number)}</h3><p class="mt-0.5 truncate text-sm font-medium">${ssrInterpolate((_a = openOrder.customer) == null ? void 0 : _a.name)}</p><p class="truncate text-sm">${ssrInterpolate(_ctx.$t("Items"))}: ${ssrInterpolate(openOrder.data.total_items)} (${ssrInterpolate(_ctx.$number_qty(openOrder.data.total_quantity))}) </p><p class="truncate text-sm">${ssrInterpolate(_ctx.$t("Total"))}: ${ssrInterpolate(_ctx.$currency(openOrder.data.total))}</p></div>`);
          if (!_ctx.$can("delete-sales")) {
            _push(`<img alt=""${ssrRenderAttr("src", openOrder.user.profile_photo_url)} class="group-hover:hidden -mt-px h-10 w-10 rounded-full bg-gray-300">`);
          } else {
            _push(`<!---->`);
          }
          _push(`</button>`);
          if (_ctx.$can("delete-orders")) {
            _push(`<div class="group absolute top-4 right-4 h-10 w-10 shrink-0 rounded-full"><img alt=""${ssrRenderAttr("src", openOrder.user.profile_photo_url)} class="group-hover:hidden -mt-px h-10 w-10 rounded-full bg-gray-300"><button type="button" class="hidden group-hover:flex -mt-px h-10 w-10 rounded-full bg-red-200 items-center justify-center">`);
            _push(ssrRenderComponent(_component_Icon, {
              name: "trash",
              class: "h-6 w-6 -mt-px text-red-600"
            }, null, _parent));
            _push(`</button></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</li>`);
        });
        _push(`<!--]--></ul>`);
      } else {
        _push(`<div class="text-center"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="mx-auto h-12 w-12 text-gray-400"><path stroke-linecap="round" stroke-linejoin="round" d="M6.429 9.75 2.25 12l4.179 2.25m0-4.5 5.571 3 5.571-3m-11.142 0L2.25 7.5 12 2.25l9.75 5.25-4.179 2.25m0 0L21.75 12l-4.179 2.25m0 0 4.179 2.25L12 21.75 2.25 16.5l4.179-2.25m11.142 0-5.571 3-5.571-3"></path></svg><h3 class="mt-2 text-sm font-semibold text-gray-900 dark:text-gray-100">${ssrInterpolate(_ctx.$t("No Suspended Orders"))}</h3><p class="mt-1 text-sm">${ssrInterpolate(_ctx.$t("There is no suspended order to display."))}</p></div>`);
      }
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/ShowOrders.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
