import { resolveComponent, unref, withCtx, createVNode, isRef, toDisplayString, createTextVNode, createBlock, createCommentVNode, openBlock, withModifiers, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle, ssrRenderClass } from "vue/server-renderer";
import { useI18n } from "vue-i18n";
import { usePage } from "@inertiajs/vue3";
import { P as PosHelper } from "./PosHelper-BQzKR4nS.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$6, a as _sfc_main$7 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import { A as ApplicationMark, _ as _sfc_main$3, b as _sfc_main$4 } from "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import { _ as _sfc_main$9 } from "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$8 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$1, h as _sfc_main$2, o as $can, b as _sfc_main$5, w as calculate_item } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import "ulid";
import "./search-h0wKx9lE.js";
import "./VariationSelection-kl6n6FuS.js";
import "notiwind";
import "lodash/debounce.js";
import "./Form-D8PGJU9a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./View-CVQ8Ytyo.js";
import "./FormItem-DBCP8LnQ.js";
import "./OpenOrder-Cjnx2lb5.js";
import "./PrintBill-Djpc2mSI.js";
import "./PrintOrder-BMjjb3g2.js";
import "./ShowOrders-Dr8JTqPS.js";
import "./AddGiftCard-DxPs7W3X.js";
import "./FormActions-BktKGYje.js";
import "./FinalizeSale-Cwjg4qiT.js";
import "./OpenRegister-CjTG8z1b.js";
import "./OrderSummary-B6dWEyEN.js";
import "./PrintReceipt-BJEx3z3f.js";
import "./OrderDiscount-CJED5TjQ.js";
import "./UpdateFormItem-Drx9dwJa.js";
import "./RegisterDetails-CioZFg03.js";
const _sfc_main = {
  __name: "Simple",
  __ssrInlineRender: true,
  props: [
    "taxes",
    "categories",
    "countries",
    "custom_fields",
    "customer_fields",
    "customer",
    "sale",
    "order",
    "products"
  ],
  setup(__props) {
    const page = usePage();
    const { t } = useI18n({});
    const props = __props;
    const {
      grid,
      cId,
      search,
      result,
      receipt,
      loading,
      customer,
      finalize,
      itemsHeight,
      showOrder,
      printBill,
      printOrder,
      showOrders,
      loadingPage,
      showReceipt,
      delete_order,
      giftCardModal,
      showCustomer,
      open_register,
      view_register,
      order_discount,
      showMobileMenu,
      addCustomerModal,
      form,
      currentItem,
      variantModal,
      SelectVariant,
      openItemModal,
      selectItem,
      selectedItem,
      saveForm,
      removeItem,
      openOrder,
      holdOrder,
      showPaymentModal,
      loadOrder,
      showOrderDiscount,
      applyOrderDiscount,
      updatedOrderItem,
      addItem,
      quantityChanged,
      deleteOrder,
      handleSubmit,
      CustomerForm,
      ViewCustomer,
      FormItem,
      OpenOrder,
      PrintBill,
      PrintOrder,
      ShowOrders,
      AddGiftCard,
      FormActions,
      FinalizeSale,
      OpenRegister,
      OrderSummary,
      PrintReceipt,
      OrderDiscount,
      UpdateFormItem,
      RegisterDetails
    } = PosHelper(props);
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b;
      const _component_Head = resolveComponent("Head");
      const _component_Link = resolveComponent("Link");
      const _component_Icon = resolveComponent("Icon");
      const _component_icons = resolveComponent("icons");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, { title: "POS" }, null, _parent));
      _push(`<div><div class="grow flex-1 flex self-stretch min-h-full h-screen flex-col">`);
      if (unref(loadingPage)) {
        _push(ssrRenderComponent(unref(_sfc_main$1), { class: "z-20" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="w-full max-h-full grow flex flex-col lg:flex-row lg:items-stretch lg:justify-stretch overflow-hidden"><div class="grow flex-1 flex flex-col max-w-full max-h-full print:hidden"><header class="bg-white dark:bg-gray-950 dark:border-gray-800 text-gray-700 dark:text-gray-300 border-b lg:static lg:overflow-y-visible h-16 flex items-center"><div class="w-full px-4"><div class="relative flex justify-between lg:gap-8"><div class="flex lg:static xl:col-span-2"><div class="flex shrink-0 items-center">`);
      _push(ssrRenderComponent(_component_Link, {
        href: _ctx.route("dashboard"),
        class: "h-8 w-auto focus:outline-hidden focus:ring-0"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(ApplicationMark), null, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(ApplicationMark))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="flex-1"><div class="flex items-center px-3 md:mx-auto md:max-w-3xl lg:mx-0 lg:max-w-none xl:px-0"><div class="relative w-full"><label for="product-search" class="sr-only">${ssrInterpolate(unref(t)("Scan Barcode or Search Product"))}</label><div class="relative flex items-center">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: "",
        modelValue: unref(search),
        "onUpdate:modelValue": ($event) => isRef(search) ? search.value = $event : null,
        id: "product-search",
        placeholder: _ctx.$t("Scan barcode or type to search")
      }, null, _parent));
      _push(`<div class="absolute inset-y-0 right-0 flex items-center pr-3"><button type="button" class="text-gray-400 hover:text-gray-500 dark:hover:text-gray-200">`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "gift-o",
        class: "size-6"
      }, null, _parent));
      _push(`</button></div></div>`);
      if (unref(search) && unref(result) && unref(result).length) {
        _push(`<div class="absolute z-20 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-2"><!--[-->`);
        ssrRenderList(unref(result), (p) => {
          _push(`<button type="button" class="w-full text-left py-1 px-4 hover:bg-gray-100 dark:hover:bg-gray-900">${ssrInterpolate(p.name)}</button>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><div class="flex items-center gap-2 lg:hidden"><button type="button" class="relative inline-flex items-center justify-center rounded-md p-2 text-gray-400 hover:bg-gray-100 hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-inset focus:ring-primary-500" aria-expanded="false"><span class="absolute -inset-0.5"></span><span class="sr-only">${ssrInterpolate(unref(t)("Open menu"))}</span><svg class="block h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"></path></svg><svg class="hidden h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path></svg></button><button type="button" class="relative inline-flex items-center justify-center rounded-md p-2 text-gray-400 hover:bg-gray-100 hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-inset focus:ring-primary-500"><span class="absolute -inset-0.5"></span><span class="sr-only">${ssrInterpolate(unref(t)("List Open Orders"))}</span><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6"><path stroke-linecap="round" stroke-linejoin="round" d="M6.429 9.75 2.25 12l4.179 2.25m0-4.5 5.571 3 5.571-3m-11.142 0L2.25 7.5 12 2.25l9.75 5.25-4.179 2.25m0 0L21.75 12l-4.179 2.25m0 0 4.179 2.25L12 21.75 2.25 16.5l4.179-2.25m11.142 0-5.571 3-5.571-3"></path></svg></button><button type="button" class="relative inline-flex items-center justify-center rounded-md p-2 text-gray-400 hover:bg-gray-100 hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-inset focus:ring-primary-500" aria-expanded="false"><span class="absolute -inset-0.5"></span><span class="sr-only">${ssrInterpolate(unref(t)("View Orders"))}</span><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6"><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 0 0-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 0 0-16.536-1.84M7.5 14.25 5.106 5.272M6 20.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm12.75 0a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z"></path></svg></button></div><div class="hidden lg:flex lg:items-center lg:justify-end lg:gap-4">`);
      if (unref($can)("read-sales")) {
        _push(ssrRenderComponent(_component_Link, {
          href: _ctx.route("sales.index"),
          class: "relative shrink-0 rounded-full p-1 text-gray-400 hover:text-gray-500 dark:hover:text-gray-200 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="absolute -inset-1.5"${_scopeId}></span><span class="sr-only"${_scopeId}>${ssrInterpolate(unref(t)("View Sales"))}</span>`);
              _push2(ssrRenderComponent(_component_Icon, {
                name: "bag-o",
                class: "size-6"
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode("span", { class: "absolute -inset-1.5" }),
                createVNode("span", { class: "sr-only" }, toDisplayString(unref(t)("View Sales")), 1),
                createVNode(_component_Icon, {
                  name: "bag-o",
                  class: "size-6"
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<button type="button" class="relative shrink-0 rounded-full p-1 text-gray-400 hover:text-gray-500 dark:hover:text-gray-200 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"><span class="absolute -inset-1.5"></span><span class="sr-only">${ssrInterpolate(unref(t)("Cash Register"))}</span>`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "register-o",
        class: "size-6 mt-1"
      }, null, _parent));
      _push(`</button><button type="button" class="relative shrink-0 rounded-full p-1 text-gray-400 hover:text-gray-500 dark:hover:text-gray-200 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"><span class="absolute -inset-1.5"></span><span class="sr-only">${ssrInterpolate(unref(t)("List Open Orders"))}</span>`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "squares-o",
        class: "size-6"
      }, null, _parent));
      _push(`</button>`);
      if (unref($can)("settings")) {
        _push(ssrRenderComponent(_component_Link, {
          href: _ctx.route("settings.pos"),
          class: "relative inline-flex items-center justify-center rounded-lg p-2 text-gray-400 hover:bg-gray-100 hover:text-gray-500 dark:hover:bg-gray-800 dark:hover:text-gray-200 focus:outline-hidden focus:ring-2 focus:ring-inset focus:ring-primary-500"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="absolute -inset-1.5"${_scopeId}></span><span class="sr-only"${_scopeId}>${ssrInterpolate(unref(t)("POS Settings"))}</span>`);
              _push2(ssrRenderComponent(_component_Icon, {
                name: "cog-o",
                class: "size-6"
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode("span", { class: "absolute -inset-1.5" }),
                createVNode("span", { class: "sr-only" }, toDisplayString(unref(t)("POS Settings")), 1),
                createVNode(_component_Icon, {
                  name: "cog-o",
                  class: "size-6"
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        align: "right",
        width: "48"
      }, {
        trigger: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<button class="flex items-center p-1 rounded-full transition duration-150 ease-in-out"${_scopeId}>`);
            if (_ctx.$page.props.jetstream.managesProfilePhotos) {
              _push2(`<img${ssrRenderAttr("alt", _ctx.$page.props.auth.user.name)}${ssrRenderAttr("src", _ctx.$page.props.auth.user.profile_photo_url)} class="h-8 w-8 rounded-full object-cover xl:mr-2"${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<span class="hidden xl:inline-flex items-center"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.user.name)} `);
            _push2(ssrRenderComponent(_component_icons, {
              name: "chevron-down",
              class: "ml-2 -mr-1 hidden xl:block"
            }, null, _parent2, _scopeId));
            _push2(`</span></button>`);
          } else {
            return [
              createVNode("button", { class: "flex items-center p-1 rounded-full transition duration-150 ease-in-out" }, [
                _ctx.$page.props.jetstream.managesProfilePhotos ? (openBlock(), createBlock("img", {
                  key: 0,
                  alt: _ctx.$page.props.auth.user.name,
                  src: _ctx.$page.props.auth.user.profile_photo_url,
                  class: "h-8 w-8 rounded-full object-cover xl:mr-2"
                }, null, 8, ["alt", "src"])) : createCommentVNode("", true),
                createVNode("span", { class: "hidden xl:inline-flex items-center" }, [
                  createTextVNode(toDisplayString(_ctx.$page.props.auth.user.name) + " ", 1),
                  createVNode(_component_icons, {
                    name: "chevron-down",
                    class: "ml-2 -mr-1 hidden xl:block"
                  })
                ])
              ])
            ];
          }
        }),
        content: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="text-left"${_scopeId}><div class="block px-4 py-2 text-xs text-gray-400"${_scopeId}>${ssrInterpolate(_ctx.$t("Manage Account"))}</div>`);
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              href: _ctx.route("profile.show")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Profile"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Profile")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (_ctx.$page.props.jetstream.hasApiFeatures) {
              _push2(ssrRenderComponent(unref(_sfc_main$4), {
                href: _ctx.route("api-tokens.index")
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("API Tokens"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("API Tokens")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="border-t border-gray-100 dark:border-gray-700"${_scopeId}></div><form${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$4), { as: "button" }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Log Out"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Log Out")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</form></div>`);
          } else {
            return [
              createVNode("div", { class: "text-left" }, [
                createVNode("div", { class: "block px-4 py-2 text-xs text-gray-400" }, toDisplayString(_ctx.$t("Manage Account")), 1),
                createVNode(unref(_sfc_main$4), {
                  href: _ctx.route("profile.show")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Profile")), 1)
                  ]),
                  _: 1
                }, 8, ["href"]),
                _ctx.$page.props.jetstream.hasApiFeatures ? (openBlock(), createBlock(unref(_sfc_main$4), {
                  key: 0,
                  href: _ctx.route("api-tokens.index")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("API Tokens")), 1)
                  ]),
                  _: 1
                }, 8, ["href"])) : createCommentVNode("", true),
                createVNode("div", { class: "border-t border-gray-100 dark:border-gray-700" }),
                createVNode("form", {
                  onSubmit: withModifiers(_ctx.logout, ["prevent"])
                }, [
                  createVNode(unref(_sfc_main$4), { as: "button" }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Log Out")), 1)
                    ]),
                    _: 1
                  })
                ], 40, ["onSubmit"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div></header><div style="${ssrRenderStyle({ "height": "calc(100vh - 4rem)" })}" class="grow flex-1 flex flex-col lg:flex-row max-w-full max-h-full"><div class="max-w-full border-b min-h-[60px] px-2 lg:px-4 lg:py-4 lg:h-full lg:w-56 lg:shrink-0 lg:border-b-0 lg:border-r flex flex-row lg:flex-col gap-x-2 gap-y-1 overflow-auto bg-white dark:bg-gray-950 dark:border-gray-800 text-gray-700 dark:text-gray-300"><!--[-->`);
      ssrRenderList(__props.categories, (c) => {
        _push(`<!--[--><button type="button" class="${ssrRenderClass([c.id == unref(cId) ? "bg-gray-100 dark:bg-gray-900" : "", "whitespace-nowrap flex items-center justify-center lg:justify-start rounded-md text-left my-2 lg:my-0 py-1.5 px-6 lg:px-2 focus:outline-hidden focus:ring-0 hover:bg-gray-100 dark:hover:bg-gray-900"])}">`);
        if (c.photo) {
          _push(`<img${ssrRenderAttr("src", c.photo)} alt="" class="w-6 h-6 mr-2">`);
        } else {
          _push(`<!---->`);
        }
        _push(` ${ssrInterpolate(c.name)}</button>`);
        if (c.children && c.children.length) {
          _push(`<div class="pl-2 flex lg:flex-wrap h-full lg:h-auto"><!--[-->`);
          ssrRenderList(c.children, (cc) => {
            _push(`<button type="button" class="${ssrRenderClass([cc.id == unref(cId) ? "bg-gray-100 dark:bg-gray-900" : "", "whitespace-nowrap w-full flex items-center justify-center lg:justify-start rounded-md text-left my-2 lg:my-0 py-1.5 px-6 lg:px-2 focus:outline-hidden focus:ring-0 hover:bg-gray-100 dark:hover:bg-gray-900"])}">`);
            if (cc.photo) {
              _push(`<img${ssrRenderAttr("src", cc.photo)} alt="" class="w-6 h-6 mr-2">`);
            } else {
              _push(`<span class="mr-2 text-xs">${"⮑"}</span>`);
            }
            _push(` ${ssrInterpolate(cc.name)}</button>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div><div class="relative flex-1 p-4 lg:flex-1 overflow-y-auto">`);
      if (unref(loading)) {
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(grid) && unref(grid).length) {
        _push(`<div class="grid grid-cols-2 sm:flex sm:flex-wrap sm:items-start sm:justify-start gap-4"><!--[-->`);
        ssrRenderList(unref(grid), (p) => {
          _push(`<button type="button" class="bg-white dark:bg-gray-950 sm:w-[140px] h-[180px] flex flex-col items-center justify-center border border-gray-200 dark:border-gray-700 rounded-md hover:drop-shadow-xl dark:hover:bg-gray-800 overflow-hidden">`);
          if (p.photo) {
            _push(`<img${ssrRenderAttr("src", p.photo)} alt="" class="object-cover w-full h-[125px]">`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="grow flex items-center justify-center">${ssrInterpolate(p.name)}</div></button>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<div class="flex items-center justify-center h-full w-full text-mute">${ssrInterpolate(unref(t)("There is no product to display"))}</div>`);
      }
      _push(`</div></div></div>`);
      if (unref(showOrder)) {
        _push(`<div class="fixed z-0 inset-0 bg-gray-500/70 dark:bg-gray-800/70 backdrop-blur-xs lg:hidden"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([unref(showOrder) ? "block z-10 fixed h-screen overflow-auto right-0 lg:static lg:overflow-hidden" : "hidden overflow-hidden", "lg:block bg-white dark:bg-gray-950 max-h-full min-h-full shrink-0 border-l border-gray-200 dark:border-gray-800 w-96 print:w-full print:block print:lg:block print:border-0 print:h-full"])}"><div id="order-container" class="flex flex-col w-full max-h-full min-h-full"><div id="order-details" class="px-4 pt-2 flex items-start justify-between"><div class="grow font-semibold leading-6 text-gray-900 dark:text-gray-100 flex items-center gap-1">${ssrInterpolate(unref(t)("Order Details"))} `);
      if (unref(form).reference && unref(form).reference != "f") {
        _push(`<div class="text-xs">(${ssrInterpolate(unref(form).reference)})</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="text-right flex items-center gap-1"><div class="text-right"><div class="text-xs">${ssrInterpolate(unref(t)("Order Number"))}</div><div class="font-bold text-xs">#${ssrInterpolate(unref(form).number)}</div></div>`);
      if (unref(showOrder)) {
        _push(`<button type="button" class="p-1 -mt-1 -mr-2 block rounded-sm lg:hidden bg-gray-100 hover:bg-gray-200 dark:bg-gray-900 dark:hover:bg-gray-950"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12"></path></svg></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div id="order-customer" class="px-4 pb-3"><div class="flex items-center gap-x-4 text-xs mb-px"><label for="customer">${ssrInterpolate(unref(t)("Customer"))}</label></div><div class="relative mt-px items-center grid grid-cols-1">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        json: true,
        size: "small",
        valueKey: "id",
        labelKey: "name",
        hideIcon: true,
        id: "customer_id",
        searchable: true,
        onChange: (e) => {
          unref(form).customer = e;
          unref(saveForm)();
        },
        modelValue: unref(form).customer_id,
        "onUpdate:modelValue": ($event) => unref(form).customer_id = $event,
        selected: unref(form).customer_id,
        suggestions: _ctx.route("search.customers"),
        inputClass: "border border-gray-200 dark:border-gray-700 focus rounded-md shadow-xs print:border-0 print:shadow-none print:border-b print:px-0 print:rounded-none"
      }, null, _parent));
      _push(`<div class="absolute inset-y-0 right-0 flex items-stretch gap-1 print:hidden"><button type="button" class="inline-flex items-center rounded-sm px-1 text-gray-400 focus:ring-inset"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6"><path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z"></path><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path></svg></button><button type="button" class="inline-flex items-center rounded-sm px-1 text-gray-400 focus:ring-inset"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6"><path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15"></path></svg></button></div></div>`);
      if ((_a = _ctx.$page.props.errors) == null ? void 0 : _a.customer_id) {
        _push(`<div class="text-sm text-red-500">${ssrInterpolate(_ctx.$page.props.errors.customer_id)}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div id="order-items" class="overflow-auto w-full flex flex-col px-4 min-h-[150px] print:h-full print:min-h-0 print:overflow-visible" style="${ssrRenderStyle({ height: unref(itemsHeight) + "px" })}">`);
      if (unref(page).props.opened_register) {
        _push(`<ul role="list" class="divide-y divide-gray-200 dark:divide-gray-700"><!--[-->`);
        ssrRenderList(unref(form).items, (item) => {
          _push(ssrRenderComponent(unref(FormItem), {
            item,
            onEdit: unref(selectItem),
            onRemove: unref(removeItem),
            onUpdate: unref(quantityChanged)
          }, null, _parent));
        });
        _push(`<!--]--></ul>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if ((_b = unref(form)) == null ? void 0 : _b.number) {
        _push(`<!--[--><div id="order-summary" class="mx-2 mt-auto mb-1">`);
        _push(ssrRenderComponent(unref(OrderSummary), {
          form: unref(form),
          onDiscount: unref(showOrderDiscount)
        }, null, _parent));
        _push(`</div><div id="order-actions" class="mx-2 py-1 flex gap-2 items-center print:hidden">`);
        _push(ssrRenderComponent(unref(FormActions), {
          onHold: unref(holdOrder),
          loading: unref(loadingPage),
          onPayment: unref(showPaymentModal),
          onPrintBill: ($event) => printBill.value = true,
          onPrintOrder: ($event) => printOrder.value = true,
          onDeleteOrder: ($event) => delete_order.value = true
        }, null, _parent));
        _push(`</div><!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (unref(showMobileMenu)) {
        _push(`<div class="fixed z-0 inset-0 bg-gray-500/70 dark:bg-gray-800/70 backdrop-blur-xs lg:hidden"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([
        unref(showMobileMenu) ? "flex items-stretch justify-stretch z-10 fixed h-screen overflow-auto left-0 lg:static lg:overflow-hidden lg:hidden" : "hidden overflow-hidden",
        "block lg:hidden bg-white dark:bg-gray-950 max-h-full min-h-full shrink-0 border-l border-gray-200 dark:border-gray-700 w-56 print:w-full print:block print:lg:block print:border-0 print:h-full shadow-lg"
      ])}"><div class="p-4 w-full flex items-stretch justify-stretch"><div class="flex flex-1 flex-col" aria-label="Sidebar"><ul role="list" class="-mx-2 space-y-1"><li><button type="button" class="w-full hover:bg-gray-50 dark:hover:bg-gray-950 group flex gap-x-3 rounded-md p-2 pl-3 text-sm leading-6 font-semibold">${ssrInterpolate(unref(t)("View Open Orders"))}</button></li><li><button type="button" class="w-full hover:bg-gray-50 dark:hover:bg-gray-950 group flex gap-x-3 rounded-md p-2 pl-3 text-sm leading-6 font-semibold">${ssrInterpolate(unref(t)("View Register Details"))}</button></li></ul><ul role="list" class="-mx-2 mt-auto space-y-1"><li><a${ssrRenderAttr("href", _ctx.route("dashboard"))} class="hover:bg-gray-50 dark:hover:bg-gray-950 group flex gap-x-3 rounded-md p-2 pl-3 text-sm leading-6 font-semibold">${ssrInterpolate(unref(t)("Dashboard"))}</a></li><li><a${ssrRenderAttr("href", _ctx.route("settings.pos"))} class="hover:bg-gray-50 dark:hover:bg-gray-950 group flex gap-x-3 rounded-md p-2 pl-3 text-sm leading-6 font-semibold">${ssrInterpolate(unref(t)("POS Settings"))}</a></li><li><a${ssrRenderAttr("href", _ctx.route("orders.index"))} class="hover:bg-gray-50 dark:hover:bg-gray-950 group flex gap-x-3 rounded-md p-2 pl-3 text-sm leading-6 font-semibold">${ssrInterpolate(unref(t)("POS Orders"))}</a></li><li><a${ssrRenderAttr("href", _ctx.route("sales.index"))} class="hover:bg-gray-50 dark:hover:bg-gray-950 group flex gap-x-3 rounded-md p-2 pl-3 text-sm leading-6 font-semibold">${ssrInterpolate(unref(t)("List {x}", { x: _ctx.$t("Sales") }))}</a></li></ul></div></div></div></div></div>`);
      if (unref(variantModal)) {
        _push(ssrRenderComponent(unref(SelectVariant), {
          item: unref(currentItem),
          show: unref(variantModal),
          onClose: () => {
            unref(currentItem).variations = unref(currentItem).variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == unref(currentItem).product_id ? unref(calculate_item)(unref(currentItem), unref(form).calculate_on) : i);
            variantModal.value = false;
          },
          onUpdate: (item) => {
            item.variations = item.variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == item.product_id ? unref(calculate_item)(item, unref(form).calculate_on) : i);
            unref(saveForm)();
            variantModal.value = false;
          }
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(unref(OpenOrder), {
        onClose: unref(openOrder),
        show: !unref(form).reference,
        onShowOpenOrders: ($event) => showOrders.value = true,
        onViewRegisterDetails: ($event) => view_register.value = true
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(openItemModal),
        "max-width": "xl",
        onClose: ($event) => openItemModal.value = false,
        overflow: true,
        backdrop: false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(UpdateFormItem), {
              taxes: __props.taxes,
              selectedItem: unref(selectedItem),
              onRemove: (i) => unref(removeItem)(i),
              onClose: ($event) => openItemModal.value = false,
              onUpdate: (i) => unref(updatedOrderItem)(i)
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(UpdateFormItem), {
                taxes: __props.taxes,
                selectedItem: unref(selectedItem),
                onRemove: (i) => unref(removeItem)(i),
                onClose: ($event) => openItemModal.value = false,
                onUpdate: (i) => unref(updatedOrderItem)(i)
              }, null, 8, ["taxes", "selectedItem", "onRemove", "onClose", "onUpdate"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(showOrders),
        onClose: ($event) => showOrders.value = false,
        maxWidth: "xl",
        closeable: false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(ShowOrders), {
              onLoadOrder: unref(loadOrder),
              onClose: ($event) => showOrders.value = false,
              onDeleteOrder: (id) => delete_order.value = id
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(ShowOrders), {
                onLoadOrder: unref(loadOrder),
                onClose: ($event) => showOrders.value = false,
                onDeleteOrder: (id) => delete_order.value = id
              }, null, 8, ["onLoadOrder", "onClose", "onDeleteOrder"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(printOrder),
        onClose: () => printOrder.value = false,
        maxWidth: "md",
        closeable: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(PrintOrder), {
              form: unref(form),
              onClose: () => printOrder.value = false
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(PrintOrder), {
                form: unref(form),
                onClose: () => printOrder.value = false
              }, null, 8, ["form", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(printBill),
        onClose: () => printBill.value = false,
        maxWidth: "md",
        closeable: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(PrintBill), {
              form: unref(form),
              onClose: () => printBill.value = false
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(PrintBill), {
                form: unref(form),
                onClose: () => printBill.value = false
              }, null, 8, ["form", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(showReceipt),
        onClose: () => showReceipt.value = false,
        maxWidth: "md",
        closeable: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(PrintReceipt), {
              receipt: unref(receipt),
              onClose: () => showReceipt.value = false
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(PrintReceipt), {
                receipt: unref(receipt),
                onClose: () => showReceipt.value = false
              }, null, 8, ["receipt", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(FinalizeSale), {
        show: unref(finalize),
        form: unref(form),
        saveForm: unref(saveForm),
        onClose: ($event) => finalize.value = false,
        onFinalize: unref(handleSubmit)
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(order_discount),
        onClose: () => order_discount.value = false,
        maxWidth: "md",
        closeable: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(OrderDiscount), { onApply: unref(applyOrderDiscount) }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(OrderDiscount), { onApply: unref(applyOrderDiscount) }, null, 8, ["onApply"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(addCustomerModal),
        onClose: ($event) => addCustomerModal.value = false,
        maxWidth: "3xl",
        closeable: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(CustomerForm), {
              pos: 1,
              countries: __props.countries,
              custom_fields: __props.customer_fields,
              onClose: ($event) => addCustomerModal.value = false
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(CustomerForm), {
                pos: 1,
                countries: __props.countries,
                custom_fields: __props.customer_fields,
                onClose: ($event) => addCustomerModal.value = false
              }, null, 8, ["countries", "custom_fields", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        show: unref(showCustomer),
        onClose: ($event) => showCustomer.value = false,
        maxWidth: "lg",
        closeable: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(customer)) {
              _push2(ssrRenderComponent(unref(ViewCustomer), {
                current: unref(customer),
                onClose: ($event) => showCustomer.value = false
              }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              unref(customer) ? (openBlock(), createBlock(unref(ViewCustomer), {
                key: 0,
                current: unref(customer),
                onClose: ($event) => showCustomer.value = false
              }, null, 8, ["current", "onClose"])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(RegisterDetails), {
        show: unref(view_register),
        onClose: ($event) => view_register.value = false
      }, null, _parent));
      _push(ssrRenderComponent(unref(AddGiftCard), {
        show: unref(giftCardModal),
        onClose: (item) => {
          item && unref(addItem)(item);
          giftCardModal.value = false;
        }
      }, null, _parent));
      _push(ssrRenderComponent(unref(OpenRegister), {
        show: unref(open_register),
        onClose: ($event) => open_register.value = false
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        show: unref(delete_order),
        onClose: () => delete_order.value = false,
        maxWidth: "sm"
      }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            if (_ctx.property) {
              _push2(`<span${_scopeId}>${ssrInterpolate(unref(t)("Delete {x}", { x: _ctx.row[_ctx.property] }))}</span>`);
            } else {
              _push2(`<span${_scopeId}>${ssrInterpolate(unref(t)("Delete Order"))} ${ssrInterpolate((_a2 = unref(form)) == null ? void 0 : _a2.number)}</span>`);
            }
          } else {
            return [
              _ctx.property ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(unref(t)("Delete {x}", { x: _ctx.row[_ctx.property] })), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(unref(t)("Delete Order")) + " " + toDisplayString((_b2 = unref(form)) == null ? void 0 : _b2.number), 1))
            ];
          }
        }),
        content: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<p${_scopeId}>${ssrInterpolate(unref(t)("Please confirm that you would like to delete the record?"))}</p>`);
          } else {
            return [
              createVNode("p", null, toDisplayString(unref(t)("Please confirm that you would like to delete the record?")), 1)
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              onClick: () => delete_order.value = false,
              class: "me-4"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref(t)("Cancel"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref(t)("Cancel")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              onClick: ($event) => unref(deleteOrder)(unref(delete_order))
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref(t)("Yes, delete"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref(t)("Yes, delete")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$8), {
                onClick: () => delete_order.value = false,
                class: "me-4"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(unref(t)("Cancel")), 1)
                ]),
                _: 1
              }, 8, ["onClick"]),
              createVNode(unref(_sfc_main$9), {
                onClick: ($event) => unref(deleteOrder)(unref(delete_order))
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(unref(t)("Yes, delete")), 1)
                ]),
                _: 1
              }, 8, ["onClick"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Simple.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
