import { resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, createBlock, openBlock, Fragment, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "./Form-D8PGJU9a.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { _ as _sfc_main$2, d as _sfc_main$3 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Statement",
  __ssrInlineRender: true,
  props: ["pagination", "customer"],
  setup(__props) {
    usePage();
    const { filters, searching } = PageSearch();
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Link = resolveComponent("Link");
      const _component_Icon = resolveComponent("Icon");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Customer Statement"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Customer Statement")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Link, {
              class: "btn-primary",
              href: _ctx.route("customers.index")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List {x}", { x: _ctx.$t("Customers") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Customers") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(_component_Link, {
                  class: "btn-primary",
                  href: _ctx.route("customers.index")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Customers") })), 1)
                  ]),
                  _: 1
                }, 8, ["href"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Customer Statement"))} (${ssrInterpolate(__props.customer.company || __props.customer.name)}) `);
            if (__props.customer.balance < 0) {
              _push2(`<!--[-->(${ssrInterpolate(_ctx.$t("Adv"))}: ${ssrInterpolate(_ctx.$currency(0 - __props.customer.balance))})<!--]-->`);
            } else {
              _push2(`<!--[-->(${ssrInterpolate(_ctx.$t("Due"))}: ${ssrInterpolate(_ctx.$currency(__props.customer.balance))})<!--]-->`);
            }
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Customer Statement")) + " (" + toDisplayString(__props.customer.company || __props.customer.name) + ") ", 1),
              __props.customer.balance < 0 ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                createTextVNode("(" + toDisplayString(_ctx.$t("Adv")) + ": " + toDisplayString(_ctx.$currency(0 - __props.customer.balance)) + ")", 1)
              ], 64)) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                createTextVNode("(" + toDisplayString(_ctx.$t("Due")) + ": " + toDisplayString(_ctx.$currency(__props.customer.balance)) + ")", 1)
              ], 64))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$2), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="pl-6 pr-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Created at"))} `);
      if ((_b = (_a = unref(filters)) == null ? void 0 : _a.sort) == null ? void 0 : _b.startsWith("created_at:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "created_at:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Description"))} `);
      if ((_d = (_c = unref(filters)) == null ? void 0 : _c.sort) == null ? void 0 : _d.startsWith("description:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "description:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="pl-3 pr-6 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Amount"))} `);
      if ((_f = (_e = unref(filters)) == null ? void 0 : _e.sort) == null ? void 0 : _f.startsWith("amount:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "amount:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          _push(`<tr class="${ssrRenderClass(row.deleted_at ? "bg-red-100 dark:bg-red-950" : "")}"><td class="whitespace-nowrap pl-6 pr-3 py-4 text-sm">${ssrInterpolate(_ctx.$datetime(row.created_at))}</td><td class="whitespace-nowrap px-3 py-4 text-sm"><div class="-my-2 min-w-64 line-clamp-2">${(row.description || "") ?? ""}</div></td><td class="whitespace-nowrap pl-3 pr-6 py-4 text-sm text-right">${ssrInterpolate(_ctx.$currency(row.value))}</td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/People/Customer/Statement.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
