import { ref, resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from "vue/server-renderer";
import "dayjs";
import "../ssr.js";
import "@inertiajs/vue3";
import _sfc_main$6 from "./Form-BDh7f-pB.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$5 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { e as _sfc_main$2, _ as _sfc_main$3, d as _sfc_main$4 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "lodash.debounce";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Supplier",
  __ssrInlineRender: true,
  props: ["pagination", "stores", "users"],
  setup(__props) {
    const form = ref(false);
    const { filters, searching } = PageSearch();
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Icon = resolveComponent("Icon");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("{x} Report", { x: _ctx.$t("Suppliers") }))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("{x} Report", { x: _ctx.$t("Suppliers") })), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              type: "button",
              onClick: ($event) => form.value = true
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Customize"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Customize")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(unref(_sfc_main$2), {
                  type: "button",
                  onClick: ($event) => form.value = true
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Customize")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("{x} Report", { x: _ctx.$t("Suppliers") }))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("{x} Report", { x: _ctx.$t("Suppliers") })) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$3), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="py-3.5 pl-4 pr-3 text-center text-sm font-semibold text-focus sm:pl-6 lg:pl-8"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Company"))} `);
      if ((_b = (_a = unref(filters)) == null ? void 0 : _a.sort) == null ? void 0 : _b.startsWith("company:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "company:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Contact"))} `);
      if ((_d = (_c = unref(filters)) == null ? void 0 : _c.sort) == null ? void 0 : _d.startsWith("phone:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "phone:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap mx-auto">${ssrInterpolate(_ctx.$t("Sales"))} `);
      if ((_f = (_e = unref(filters)) == null ? void 0 : _e.sort) == null ? void 0 : _f.startsWith("purchases:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "purchases:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap mx-auto">${ssrInterpolate(_ctx.$t("Sales Amount"))} `);
      if ((_h = (_g = unref(filters)) == null ? void 0 : _g.sort) == null ? void 0 : _h.startsWith("amount:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "amount:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap mx-auto">${ssrInterpolate(_ctx.$t("Paid Amount"))} `);
      if ((_j = (_i = unref(filters)) == null ? void 0 : _i.sort) == null ? void 0 : _j.startsWith("paid:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "paid:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Balance Amount"))}</th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          _push(`<tr><td class="cursor-pointer whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8"><div>${ssrInterpolate(row.company)}</div><div class="text-mute"><span>${ssrInterpolate(_ctx.$t("Name"))}</span>: ${ssrInterpolate(row.name)}</div></td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm"><div>${ssrInterpolate(row.phone)}</div><div class="text-mute">${ssrInterpolate(row.email)}</div></td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm text-center">${ssrInterpolate(_ctx.$number(row.purchases || 0, null, { minimumFractionDigits: 0, maximumFractionDigits: 0 }))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm text-right">${ssrInterpolate(_ctx.$currency(row.amount || 0))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm text-right">${ssrInterpolate(_ctx.$currency(Number(row.paid || 0)))}</td><td class="cursor-pointer whitespace-nowrap py-4 pl-4 pr-3 text-sm text-right font-medium text-focus sm:pl-6 lg:pl-8">${ssrInterpolate(_ctx.$currency(Number(row.amount || 0) - Number(row.paid || 0)))}</td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        show: form.value,
        "max-width": "2xl",
        onClose: ($event) => form.value = false,
        overflow: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$6, {
              users: __props.users,
              stores: __props.stores,
              filters: unref(filters),
              onClose: ($event) => form.value = false,
              fields: ["store", "user"]
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$6, {
                users: __props.users,
                stores: __props.stores,
                filters: unref(filters),
                onClose: ($event) => form.value = false,
                fields: ["store", "user"]
              }, null, 8, ["users", "stores", "filters", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Report/Supplier.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
