import { resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import { e as _sfc_main$2, b as _sfc_main$4, _ as _sfc_main$5, H as $datetime, d as _sfc_main$6 } from "./http-CDixhmav.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import "dayjs";
import "../ssr.js";
import "./LoadingButton-DREeyNQW.js";
import "./QuickView-DaWb2lTv.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import { _ as _sfc_main$3 } from "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import "lodash.debounce";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "jsbarcode";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Track",
  __ssrInlineRender: true,
  props: ["pagination", "product"],
  setup(__props) {
    const page = usePage();
    const { filters, searching, searchNow } = PageSearch();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Icon = resolveComponent("Icon");
      const _component_spam = resolveComponent("spam");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Product Tracks"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Product Tracks")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              href: _ctx.route("products.index")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List {x}", { x: _ctx.$t("Products") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Products") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              align: "right",
              width: "56",
              "auto-close": false
            }, {
              trigger: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<button class="flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Icon, {
                    name: "funnel-o",
                    size: "size-5"
                  }, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_spam, { class: "sr-only" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(_ctx.$t("Show Filters"))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</button>`);
                } else {
                  return [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ];
                }
              }),
              content: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="px-4 py-2"${_scopeId2}><div${_scopeId2}>`);
                  _push3(ssrRenderComponent(unref(_sfc_main$4), {
                    json: true,
                    onChange: unref(searchNow),
                    label: _ctx.$t("Trashed"),
                    modelValue: unref(filters).trashed,
                    "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                    placeholder: _ctx.$t("With Trashed"),
                    suggestions: [
                      { value: "not", label: _ctx.$t("Not Trashed") },
                      { value: "with", label: _ctx.$t("With Trashed") },
                      { value: "only", label: _ctx.$t("Only Trashed") }
                    ]
                  }, null, _parent3, _scopeId2));
                  _push3(`</div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(unref(_sfc_main$2), {
                  href: _ctx.route("products.index")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Products") })), 1)
                  ]),
                  _: 1
                }, 8, ["href"]),
                createVNode(unref(_sfc_main$3), {
                  align: "right",
                  width: "56",
                  "auto-close": false
                }, {
                  trigger: withCtx(() => [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ]),
                  content: withCtx(() => [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ]),
                  _: 1
                })
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Product Tracks"))} (${ssrInterpolate(__props.product.name)}) `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Product Tracks")) + " (" + toDisplayString(__props.product.name) + ") ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$5), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-focus sm:pl-6 lg:pl-8 w-16 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Created at"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Description"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus w-24">${ssrInterpolate(_ctx.$t("Quantity"))}</th>`);
      if (!unref(page).props.selected_store) {
        _push(`<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Store"))}</th>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          var _a;
          _push(`<tr><td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm text-focus sm:pl-6 lg:pl-8 w-14">${ssrInterpolate(unref($datetime)(row.created_at))}</td><td class="px-3 py-4 text-sm font-semibold"><div class="line-clamp-3">${row.description ?? ""}</div></td><td class="whitespace-nowrap pl-3 pr-6 py-4 text-sm text-right w-24">${ssrInterpolate(_ctx.$number_qty(row.value))}</td>`);
          if (!unref(page).props.selected_store) {
            _push(`<td class="whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_a = row.store) == null ? void 0 : _a.name) || "")}</td>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Track.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
