import { ref, onMounted, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderList, ssrRenderComponent, ssrRenderClass } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import { h as _sfc_main$1, b as _sfc_main$2, y as discount_keypress } from "./http-CDixhmav.js";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "UpdateFormItem",
  __ssrInlineRender: true,
  props: ["show", "selectedItem", "taxes"],
  emits: ["close", "update", "remove"],
  setup(__props, { emit: __emit }) {
    usePage();
    const props = __props;
    const item = ref(null);
    ref(false);
    onMounted(() => {
      item.value = props.selectedItem;
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d;
      if (item.value) {
        _push(`<div${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Edit {x}", { x: item.value.name }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please update the details below"))}</p></div></div></div><div>`);
        if (item.value.product.has_variants && item.value.variations && item.value.variations.length) {
          _push(`<div class="divide-y dark:divide-gray-700"><!--[-->`);
          ssrRenderList(item.value.variations, (v, vi) => {
            var _a2, _b2, _c2, _d2;
            _push(`<div class="p-6 grid grid-cols-6 gap-6">`);
            if (v.code) {
              _push(`<!--[--><div class="col-span-full font-bold text-mute">${ssrInterpolate(_ctx.$t("Code"))}: <span class="text-focus">${ssrInterpolate(v.code)}</span> (${ssrInterpolate(_ctx.$meta(v.meta))}) </div><div class="col-span-6 sm:col-span-2">`);
              _push(ssrRenderComponent(unref(_sfc_main$1), {
                type: "number",
                id: "item-quantity-v" + vi,
                label: _ctx.$t("Quantity"),
                modelValue: item.value.variations[vi].quantity,
                "onUpdate:modelValue": ($event) => item.value.variations[vi].quantity = $event
              }, null, _parent));
              _push(`</div>`);
              if ((_b2 = (_a2 = item.value.product.unit) == null ? void 0 : _a2.subunits) == null ? void 0 : _b2.length) {
                _push(`<div class="col-span-6 sm:col-span-4">`);
                _push(ssrRenderComponent(unref(_sfc_main$2), {
                  json: true,
                  "value-key": "id",
                  id: "item-unit",
                  "label-key": "name",
                  searchable: false,
                  label: _ctx.$t("Unit"),
                  modelValue: item.value.variations[vi].unit_id,
                  "onUpdate:modelValue": ($event) => item.value.variations[vi].unit_id = $event,
                  suggestions: [{ ...item.value.product.unit, subunits: null }, ...item.value.product.unit.subunits],
                  onChange: () => {
                    var _a3, _b3;
                    if (item.value.variations[vi].unit_id == item.value.product.unit.id) {
                      item.value.variations[vi].price = Number(item.value.product.price);
                    } else {
                      item.value.variations[vi].price = Number(
                        ((_b3 = (_a3 = item.value.product.unit_prices) == null ? void 0 : _a3.find((p) => p.unit_id == item.value.variations[vi].unit_id)) == null ? void 0 : _b3.price) || _ctx.convert_to_base_unit(item.value, item.value.variations[vi].unit_id, item.value.variations[vi].price || item.value.price)
                      );
                    }
                  }
                }, null, _parent));
                _push(`</div>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<div class="col-span-6 sm:col-span-4">`);
              _push(ssrRenderComponent(unref(_sfc_main$1), {
                type: "number",
                label: _ctx.$t("Price"),
                id: "item-price-v" + vi,
                modelValue: item.value.variations[vi].price,
                "onUpdate:modelValue": ($event) => item.value.variations[vi].price = $event,
                readonly: !item.value.product.can_edit_price
              }, null, _parent));
              _push(`</div><div class="col-span-6 sm:col-span-2">`);
              _push(ssrRenderComponent(unref(_sfc_main$1), {
                label: _ctx.$t("Discount"),
                id: "item-discount-v" + vi,
                onKeypress: unref(discount_keypress),
                modelValue: item.value.variations[vi].discount,
                "onUpdate:modelValue": ($event) => item.value.variations[vi].discount = $event,
                onChange: (e) => {
                  var _a3;
                  let max_discount = ((_a3 = unref(usePage)().props.settings) == null ? void 0 : _a3.max_discount) || null;
                  if (item.value.variations[vi].discount.includes("%")) {
                    if (Number(item.value.variations[vi].discount.replace("%", "")) > Number(item.value.product.max_discount)) {
                      item.value.variations[vi].discount = Number(item.value.product.max_discount) + "%";
                      _ctx.notify({
                        group: "main",
                        type: "error",
                        title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(item.value.product.max_discount) })
                      });
                    } else if (Number(item.value.variations[vi].discount.replace("%", "")) > Number(max_discount)) {
                      item.value.variations[vi].discount = Number(max_discount) + "%";
                      _ctx.notify({
                        group: "main",
                        type: "error",
                        title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(max_discount) })
                      });
                    }
                  }
                }
              }, null, _parent));
              _push(`</div><div class="${ssrRenderClass(((_d2 = (_c2 = item.value.product.unit) == null ? void 0 : _c2.subunits) == null ? void 0 : _d2.length) ? "col-span-full" : "col-span-6 sm:col-span-4")}">`);
              _push(ssrRenderComponent(unref(_sfc_main$2), {
                json: true,
                "value-key": "id",
                multiple: true,
                "label-key": "name",
                searchable: false,
                suggestions: __props.taxes,
                label: _ctx.$t("Taxes"),
                id: "item-taxes-v" + vi,
                modelValue: item.value.variations[vi].taxes,
                "onUpdate:modelValue": ($event) => item.value.variations[vi].taxes = $event,
                disabled: !item.value.product.can_edit_taxes
              }, null, _parent));
              _push(`</div><!--]-->`);
            } else {
              _push(`<div class="col-span-full">`);
              _push(ssrRenderComponent(unref(_sfc_main$3), {
                type: "button",
                onClick: () => {
                  _ctx.currentItem = item.value;
                  _ctx.variantModal = true;
                }
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`${ssrInterpolate(_ctx.$t("Select {x}", { x: _ctx.$t("Variation") }))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Select {x}", { x: _ctx.$t("Variation") })), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
              _push(`</div>`);
            }
            _push(`</div>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-2">`);
          _push(ssrRenderComponent(unref(_sfc_main$1), {
            type: "number",
            id: "item-quantity",
            label: _ctx.$t("Quantity"),
            modelValue: item.value.quantity,
            "onUpdate:modelValue": ($event) => item.value.quantity = $event
          }, null, _parent));
          _push(`</div>`);
          if ((_b = (_a = item.value.product.unit) == null ? void 0 : _a.subunits) == null ? void 0 : _b.length) {
            _push(`<div class="col-span-6 sm:col-span-4">`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              json: true,
              "value-key": "id",
              id: "item-unit",
              "label-key": "name",
              searchable: false,
              label: _ctx.$t("Unit"),
              modelValue: item.value.unit_id,
              "onUpdate:modelValue": ($event) => item.value.unit_id = $event,
              suggestions: [{ ...item.value.product.unit, subunits: null }, ...item.value.product.unit.subunits],
              onChange: () => {
                var _a2, _b2;
                if (item.value.unit_id == item.value.product.unit.id) {
                  item.value.price = Number(item.value.product.price);
                } else {
                  item.value.price = Number(
                    ((_b2 = (_a2 = item.value.product.unit_prices) == null ? void 0 : _a2.find((p) => p.unit_id == item.value.unit_id)) == null ? void 0 : _b2.price) || _ctx.convert_to_base_unit(item.value, item.value.unit_id, item.value.price)
                  );
                }
              }
            }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="col-span-6 sm:col-span-4">`);
          _push(ssrRenderComponent(unref(_sfc_main$1), {
            type: "number",
            id: "item-price",
            label: _ctx.$t("Price"),
            modelValue: item.value.price,
            "onUpdate:modelValue": ($event) => item.value.price = $event,
            readonly: !item.value.product.can_edit_price
          }, null, _parent));
          _push(`</div><div class="col-span-6 sm:col-span-2">`);
          _push(ssrRenderComponent(unref(_sfc_main$1), {
            id: "item-discount",
            label: _ctx.$t("Discount"),
            modelValue: item.value.discount,
            "onUpdate:modelValue": ($event) => item.value.discount = $event,
            onKeypress: unref(discount_keypress),
            onChange: (e) => {
              var _a2;
              let max_discount = ((_a2 = unref(usePage)().props.settings) == null ? void 0 : _a2.max_discount) || null;
              if (item.value.discount.includes("%")) {
                if (Number(item.value.discount.replace("%", "")) > Number(item.value.product.max_discount)) {
                  item.value.discount = Number(item.value.product.max_discount) + "%";
                  _ctx.notify({
                    group: "main",
                    type: "error",
                    title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(item.value.product.max_discount) })
                  });
                } else if (Number(item.value.discount.replace("%", "")) > Number(max_discount)) {
                  item.value.discount = Number(max_discount) + "%";
                  _ctx.notify({
                    group: "main",
                    type: "error",
                    title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(max_discount) })
                  });
                }
              }
            }
          }, null, _parent));
          _push(`</div><div class="${ssrRenderClass(((_d = (_c = item.value.product.unit) == null ? void 0 : _c.subunits) == null ? void 0 : _d.length) ? "col-span-full" : "col-span-6 sm:col-span-4")}">`);
          _push(ssrRenderComponent(unref(_sfc_main$2), {
            json: true,
            "value-key": "id",
            id: "item-taxes",
            multiple: true,
            "label-key": "name",
            searchable: false,
            suggestions: __props.taxes,
            label: _ctx.$t("Taxes"),
            modelValue: item.value.taxes,
            "onUpdate:modelValue": ($event) => item.value.taxes = $event,
            disabled: !item.value.product.can_edit_taxes
          }, null, _parent));
          _push(`</div></div>`);
        }
        _push(`<div class="col-span-full flex items-center justify-between border-t border-gray-200 dark:border-gray-700 px-6 py-4"><button type="button" class="py-2.5 px-1 rounded-md focus text-red-600 hover:text-red-500">${ssrInterpolate(_ctx.$t("Remove"))}</button><button class="btn-primary">${ssrInterpolate(_ctx.$t("Update"))}</button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/UpdateFormItem.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
