import { ref, unref, useSSRContext, onMounted, resolveComponent, mergeProps, withCtx, renderSlot, watch, createTextVNode, toDisplayString, createVNode, createBlock, createCommentVNode, openBlock, computed, nextTick, Fragment, renderList, onBeforeUnmount, withDirectives, vModelRadio } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderClass, ssrIncludeBooleanAttr, ssrRenderAttrs, ssrRenderList, ssrRenderSlot, ssrLooseContain, ssrRenderStyle, ssrLooseEqual } from "vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import { a as _sfc_main$o, b as _sfc_main$r } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import { usePage, router, Link } from "@inertiajs/vue3";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import { _ as _sfc_main$q } from "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import { a as _sfc_main$m } from "./InputError-DjBtKS5r.js";
import { _ as _sfc_main$l } from "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$p } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { T } from "../ssr.js";
import debounce from "lodash.debounce";
import "dayjs";
import { _ as _sfc_main$n } from "./LoadingButton-DREeyNQW.js";
import VueDatePicker from "@vuepic/vue-datepicker";
import { useI18n } from "vue-i18n";
import isequal from "lodash.isequal";
import axios$1 from "axios";
import { notify } from "notiwind";
import "lodash.throttle";
const $address = (row) => {
  var _a, _b;
  if (!row) {
    return "";
  }
  return `${row.lot_no || ""} ${row.street || ""} ${row.address_line_1 || ""} ${row.address_line_2 || ""} ${row.city || ""} ${row.postal_code || ""} ${((_a = row.state) == null ? void 0 : _a.name) || ""} ${((_b = row.country) == null ? void 0 : _b.name) || ""}`;
};
const $decimal = (amount, format = false) => {
  var _a;
  amount = number_format(amount, ((_a = usePage().props.settings) == null ? void 0 : _a.fraction) || 0);
  if (format) {
    return Number(amount);
  }
  return amount;
};
const $decimal_qty = (amount, format = false) => {
  var _a;
  amount = number_format(amount, ((_a = usePage().props.settings) == null ? void 0 : _a.quantity_fraction) || 0);
  if (format) {
    return Number(amount);
  }
  return amount;
};
const $number = (amount, locale, options) => {
  if (!amount) {
    amount = 0;
  }
  let formatted = parseFloat(amount);
  if (!locale || locale.length != 2 && locale.length != 5) {
    locale = usePage().props.settings.default_locale;
  }
  if (!options) {
    options = {
      minimumFractionDigits: usePage().props.settings.fraction || 0,
      maximumFractionDigits: usePage().props.settings.fraction || 0
    };
  }
  try {
    return new Intl.NumberFormat(locale, options).format(formatted);
  } catch (err) {
    return new Intl.NumberFormat("en-US", options).format(formatted);
  }
};
const $currency = (amount, locale, options) => {
  var _a;
  if (!amount) {
    amount = 0;
  }
  let formatted = parseFloat(amount);
  if (!locale || locale.length != 2 && locale.length != 5) {
    locale = usePage().props.settings.default_locale;
  }
  let currency_code = ((_a = usePage().props.settings.payment) == null ? void 0 : _a.default_currency) || "USD";
  if ((options == null ? void 0 : options.currency) && options.currency.length != 3) {
    options.currency = currency_code;
  }
  if (!options) {
    options = {
      style: "currency",
      //
      //   signDisplay: 'always',
      currency: currency_code,
      // currencySign: 'accounting', // standard, accounting
      currencyDisplay: "narrowSymbol",
      // code, name, narrowSymbol, symbol (default)
      minimumFractionDigits: usePage().props.settings.fraction || 0,
      maximumFractionDigits: usePage().props.settings.fraction || 0
    };
  }
  try {
    return new Intl.NumberFormat(locale, options).format(formatted);
  } catch (err) {
    return new Intl.NumberFormat("en-US", options).format(formatted);
  }
};
const isValidDate = (dateString) => {
  if (!dateString) {
    return false;
  }
  var regEx = /^\d{4}-\d{2}-\d{2}$/;
  if (!dateString.match(regEx)) return false;
  var d = new Date(dateString);
  var dNum = d.getTime();
  if (!dNum && dNum !== 0) return false;
  return d.toISOString().slice(0, 10) === dateString;
};
const $date$1 = (date, locale, style, force = false) => {
  var _a;
  if (!date) {
    return "";
  }
  if (!force && ((_a = usePage().props.settings) == null ? void 0 : _a.date_format) == "php") {
    return date.split("T")[0];
  }
  date = date.split(" ")[0];
  let formatted = new Date(Date.parse(date));
  try {
    let od = date.split("T")[0].split("-");
    formatted = new Date(od[0], od[1] - 1, od[2], 0, 0, 0, 0);
  } catch (err) {
  }
  if (!locale || locale.length != 2 && locale.length != 5) {
    locale = usePage().props.settings.default_locale;
  }
  try {
    return formatted.toLocaleString(locale, {
      dateStyle: style ? style : "medium"
      //   timeZone: usePage().props.settings.timezone || 'UTC',
    });
  } catch (err) {
    return formatted.toLocaleString("en-US", {
      dateStyle: style ? style : "medium"
      //   timeZone: usePage().props.settings.timezone || 'UTC',
    });
  }
};
const $datetime = (datetime, locale, style, force = false) => {
  var _a;
  if (!datetime) {
    return "";
  }
  if (!force && ((_a = usePage().props.settings) == null ? void 0 : _a.date_format) == "php") {
    return datetime;
  }
  let formatted = new Date(Date.parse(datetime));
  try {
    if (datetime.includes("T")) {
      let od = datetime.split("T")[0].split("-");
      let ot = datetime.split("T")[1].split(":");
      formatted = new Date(Number(od[0]), Number(od[1]) - 1, Number(od[2]), Number(ot[0]), Number(ot[1]), 0, 0);
    } else if (datetime.includes(" ")) {
      let od = datetime.split(" ")[0].split("-");
      let ot = datetime.split(" ")[1].split(":");
      formatted = new Date(Number(od[0]), Number(od[1]) - 1, Number(od[2]), Number(ot[0]), Number(ot[1]), 0, 0);
    }
  } catch (err) {
    console.error("Failed to parse date time.");
  }
  if (!locale || locale.length != 2 && locale.length != 5) {
    locale = usePage().props.settings.default_locale;
  }
  try {
    return formatted.toLocaleString(locale, {
      timeStyle: "short",
      dateStyle: style ? style : "medium",
      hour12: true
      // usePage().props.settings.hour12 == 1,
      // timeZone: usePage().props.settings.timezone || 'UTC',
    });
  } catch (err) {
    return formatted.toLocaleString("en-US", {
      timeStyle: "short",
      dateStyle: style ? style : "medium",
      hour12: true
      // usePage().props.settings.hour12 == 1,
      //   timeZone: usePage().props.settings.timezone || 'UTC',
    });
  }
};
const $extras = (fields, extra_attributes = {}) => {
  let extras = {};
  fields.map((f) => {
    if (extra_attributes[f.name]) {
      extras[f.name] = extra_attributes[f.name] ? extra_attributes[f.name] : f.type == "checkbox" ? [] : "";
    } else {
      extras[f.name] = f.type == "checkbox" ? [] : "";
    }
  });
  return extras;
};
const $can = (permissions) => {
  let user = usePage().props.is_impersonating ? usePage().props.user : usePage().props.auth.user;
  if (user && user.roles.find((r) => r.name == "Super Admin")) {
    return true;
  }
  let allow = false;
  if (!Array.isArray(permissions)) {
    permissions = [permissions];
  }
  if (permissions && permissions.length > 0) {
    if (permissions.includes("all")) {
      allow = true;
    } else {
      permissions.map((p) => {
        if (user && user.all_permissions && user.all_permissions.includes(p)) {
          allow = true;
        }
      });
    }
  }
  return allow;
};
const $random = (min = 0, max = 999) => {
  const minCeiled = Math.ceil(min);
  const maxFloored = Math.floor(max);
  return Math.floor(Math.random() * (maxFloored - minCeiled) + minCeiled);
};
const calculate_item = (item, calc_on = "price") => {
  if (item.variations && item.variations.length) {
    item.variations.map((v) => {
      v.discount_amount = calculate_discount(v[calc_on], v.discount || "");
      v.total_discount_amount = $decimal(Number(v.discount_amount) * Number(v.quantity), true);
      v = calculate_taxes(usePage().props.taxes, v, calc_on);
      v.total = $decimal(v["unit_" + calc_on] * $decimal_qty(v.quantity, true), true);
      v.subtotal = $decimal(v["net_" + calc_on] * $decimal_qty(v.quantity, true), true);
    });
    item.total = item.variations.reduce((a, v) => a + v.total, 0);
    item.subtotal = item.variations.reduce((a, v) => a + v.subtotal, 0);
    item.tax_amount = item.variations.reduce((a, v) => a + v.tax_amount, 0);
    item.discount_amount = item.variations.reduce((a, v) => a + v.discount_amount, 0);
    item.total_discount_amount = item.variations.reduce((a, v) => a + v.total_discount_amount, 0);
    item.total_tax_amount = item.variations.reduce((a, v) => a + v.total_tax_amount, 0);
  } else {
    item.discount_amount = calculate_discount(item[calc_on], item.discount || "");
    item.total_discount_amount = $decimal(Number(item.discount_amount) * Number(item.quantity), true);
    item = calculate_taxes(usePage().props.taxes, item, calc_on);
    item.subtotal = $decimal(
      // (item[calc_on] + (item.before_discount_tax_amount || item.tax_amount)) * $decimal_qty(item.quantity)
      item["net_" + calc_on] * $decimal_qty(item.quantity, true),
      true
    );
    item.total = $decimal(item["unit_" + calc_on] * $decimal_qty(item.quantity, true), true);
  }
  return item;
};
const calculate_discount = (price, discount) => {
  let discount_amount = 0;
  if (discount.indexOf("%") !== -1) {
    var pds = discount.split("%");
    if (!isNaN(pds[0])) {
      discount_amount = Number(price * Number(pds[0]) / 100);
    }
  } else {
    discount_amount = Number(discount);
  }
  return $decimal(discount_amount, true);
};
const calculate_inclusive_tax = (amount, tax) => {
  tax.amount = $decimal(Number(amount) * Number(tax.rate) / (100 + Number(tax.rate)), true);
  return tax;
};
const calculate_exclusive_tax = (amount, tax) => {
  tax.amount = $decimal(Number(amount) * Number(tax.rate) / 100, true);
  return tax;
};
const calculate_taxes = (taxes, item, calc_on = "price") => {
  item.tax_amount = 0;
  item.before_discount_tax_amount = 0;
  item[calc_on + "_before_discount"] = $decimal(item[calc_on], true);
  item.applied_taxes = taxes == null ? void 0 : taxes.filter((t) => {
    var _a;
    return (_a = item.taxes) == null ? void 0 : _a.includes(t.id);
  }).map((t) => {
    let rt;
    if (item.tax_included) {
      rt = calculate_inclusive_tax(item[calc_on], t);
      t = calculate_inclusive_tax(item[calc_on] - $decimal(item.discount_amount, true), t);
    } else {
      rt = calculate_exclusive_tax(item[calc_on], t);
      t = calculate_exclusive_tax(item[calc_on] - $decimal(item.discount_amount, true), t);
    }
    item.tax_amount += t.amount;
    item.before_discount_tax_amount += rt.amount;
    return t;
  });
  item.total_tax_amount = $decimal(item.tax_amount, true) * $decimal_qty(item.quantity, true);
  item["unit_" + calc_on] = $decimal(item[calc_on], true) - $decimal(item.discount_amount, true) + $decimal(item.tax_included != 1 && item.tax_amount ? item.tax_amount : 0, true);
  item["net_" + calc_on] = $decimal(item[calc_on], true) - $decimal(item.discount_amount, true) - $decimal(item.tax_included == 1 && item.tax_amount ? item.tax_amount : 0, true);
  return item;
};
const convert_to_base_unit = (item, unit_id, value) => {
  var _a, _b;
  if (unit_id && unit_id != item.product.unit_id && ((_b = (_a = item.product.unit) == null ? void 0 : _a.subunits) == null ? void 0 : _b.length)) {
    let res;
    let unit = item.product.unit.subunits.find((u) => u.id == unit_id);
    switch (unit.operator) {
      case "*":
        res = Number(value) * Number(unit.operation_value);
        break;
      case "/":
        res = Number(value) / Number(unit.operation_value);
        break;
      case "+":
        res = Number(value) + Number(unit.operation_value);
        break;
      case "-":
        res = Number(value) - Number(unit.operation_value);
        break;
      default:
        res = value;
    }
    return $decimal(res);
  }
  return $decimal(value);
};
const discount_keypress = async (event) => {
  if (event.keyCode == 46 || event.keyCode == 8 || event.keyCode == 37) ;
  else {
    if (event.keyCode < 48 || event.keyCode > 57) {
      event.preventDefault();
    }
  }
};
const number_format = (number, decimals, decPoint = ".", thousandsSep = "") => {
  var _a;
  if (decimals === void 0) {
    decimals = ((_a = usePage().props.settings) == null ? void 0 : _a.fraction) || 0;
  }
  number = (number + "").replace(/[^0-9+\-Ee.]/g, "");
  var n = !isFinite(+number) ? 0 : +number;
  var prec = !isFinite(+decimals) ? 0 : Math.abs(decimals);
  var sep = typeof thousandsSep === "undefined" ? "," : thousandsSep;
  var dec = typeof decPoint === "undefined" ? "." : decPoint;
  var s = "";
  var toFixedFix = function(n2, prec2) {
    if (("" + n2).indexOf("e") === -1) {
      return +(Math.round(n2 + "e+" + prec2) + "e-" + prec2);
    } else {
      var arr = ("" + n2).split("e");
      var sig = "";
      if (+arr[1] + prec2 > 0) {
        sig = "+";
      }
      return (+(Math.round(+arr[0] + "e" + sig + (+arr[1] + prec2)) + "e-" + prec2)).toFixed(prec2);
    }
  };
  s = (prec ? toFixedFix(n, prec).toString() : "" + Math.round(n)).split(".");
  if (s[0].length > 3) {
    s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
  }
  if ((s[1] || "").length < prec) {
    s[1] = s[1] || "";
    s[1] += new Array(prec - s[1].length + 1).join("0");
  }
  return s.join(dec);
};
const chunkArray = (array, size) => {
  if (size <= 0) {
    return array;
  }
  return array.reduce((a, _, i) => {
    if (i % size === 0) a.push(array.slice(i, i + size));
    return a;
  }, []);
};
const check_promotions = async (form) => {
  var _a, _b, _c;
  form.items = form.items.map((i) => !i.promotion_id ? i : { ...i, promotion_id: null, discount: null });
  for await (let item of form.items) {
    if (((_a = item.product) == null ? void 0 : _a.valid_promotions) && item.product.valid_promotions.length) {
      for await (const promotion of item.product.valid_promotions) {
        if (promotion.type == "simple") {
          item.promotion_id = promotion.id;
          item.discount = Number(promotion.discount) + "%";
        } else if (promotion.type == "advance") {
          if (item.quantity >= Number(promotion.quantity_to_buy)) {
            item.promotion_id = promotion.id;
            item.discount = Number(promotion.discount) + "%";
          }
        } else if (promotion.type == "BXGY") {
          if (item.quantity >= Number(promotion.quantity_to_buy)) {
            let ae = form.items.find((i) => i.product_id == promotion.product_id_to_get && i.price == 0);
            if (!ae) {
              let product = await axios.get(route("products.show", promotion.product_id_to_get)).then((r) => r.data);
              let i = calculate_item(
                {
                  code: product.code,
                  name: product.name,
                  id: null,
                  price: 0,
                  quantity: Number(promotion.quantity_to_get),
                  cost: Number(product.cost),
                  taxes: product.taxes.map((t) => t.id),
                  tax_included: product.tax_included == 1,
                  product_id: product.id,
                  promo_product_id: item.product_id,
                  product
                },
                form.calculate_on
              );
              item.promotion_id = promotion.id;
              form.items = [...form.items, { ...i }];
            }
          }
        } else if (promotion.type == "SXGD") {
          if (from.grand_total >= parseFloat(promotion.amount_to_spend)) {
            form.items = form.items.map((i) => {
              if (!i.promo_product_id) {
                i.promotion_id = promotion.id;
                i.discount = Number(promotion.discount) + "%";
                i = calculate_item(i, form.calculate_on);
              }
              return i;
            });
          }
        }
      }
    }
    if (((_c = (_b = item.product) == null ? void 0 : _b.category) == null ? void 0 : _c.valid_promotions) && item.product.category.valid_promotions.length) {
      for await (const promotion of item.product.category.valid_promotions) {
        if (promotion.type == "simple") {
          item.promotion_id = promotion.id;
          item.discount = Number(promotion.discount) + "%";
        } else if (promotion.type == "advance") {
          if (item.quantity >= Number(promotion.quantity_to_buy)) {
            item.promotion_id = promotion.id;
            item.discount = Number(promotion.discount) + "%";
          }
        } else if (promotion.type == "BXGY") {
          if (item.quantity >= Number(promotion.quantity_to_buy)) {
            let ae = form.items.find((i) => i.product_id == promotion.product_id_to_get && i.price == 0);
            if (!ae) {
              let product = await axios.get(route("products.show", promotion.product_id_to_get)).then((r) => r.data);
              let i = calculate_item(
                {
                  code: product.code,
                  name: product.name,
                  id: null,
                  price: 0,
                  quantity: Number(promotion.quantity_to_get),
                  cost: Number(product.cost),
                  taxes: product.taxes.map((t) => t.id),
                  tax_included: product.tax_included == 1,
                  product_id: product.id,
                  promo_product_id: item.product_id,
                  product
                },
                form.calculate_on
              );
              item.promotion_id = promotion.id;
              form.items = [...form.items, { ...i }];
            }
          }
        } else if (promotion.type == "SXGD") {
          if (from.grand_total >= parseFloat(promotion.amount_to_spend)) {
            form.items = form.items.map((i) => {
              if (!i.promo_product_id) {
                i.promotion_id = promotion.id;
                i.discount = Number(promotion.discount) + "%";
                i = calculate_item(i, form.calculate_on);
              }
              return i;
            });
          }
        }
      }
    }
    item = calculate_item(item, form.calculate_on);
  }
  return form.items;
};
const _sfc_main$k = {
  __name: "Input",
  __ssrInlineRender: true,
  props: {
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    },
    type: {
      type: String,
      default: "text"
    },
    readonly: {
      type: Boolean,
      default: false
    },
    step: {
      type: String,
      default: "1"
    },
    min: String,
    max: String,
    error: String,
    label: String,
    title: String,
    pattern: String,
    action: Function,
    actionText: String,
    modelValue: String,
    placeholder: String,
    selectOnFocus: Boolean
  },
  emits: ["blur", "input", "change", "focus", "keyup", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    ref(null);
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      _push(`<!--[-->`);
      if (__props.label) {
        _push(`<div class="flex items-center justify-between mb-1">`);
        _push(ssrRenderComponent(unref(_sfc_main$l), {
          for: __props.id,
          value: __props.label
        }, null, _parent));
        if (__props.actionText && __props.action) {
          _push(`<button type="button" class="link text-sm">${ssrInterpolate(__props.actionText)}</button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input${ssrRenderAttr("id", __props.id)}${ssrRenderAttr("min", __props.min)}${ssrRenderAttr("max", __props.max)}${ssrRenderAttr("step", __props.step)}${ssrRenderAttr("type", __props.type)}${ssrRenderAttr("title", __props.title)}${ssrRenderAttr("pattern", __props.pattern)}${ssrRenderAttr("value", __props.modelValue)}${ssrIncludeBooleanAttr(__props.readonly) ? " readonly" : ""}${ssrRenderAttr("placeholder", __props.placeholder || __props.label || "")} class="${ssrRenderClass([{
        error: __props.error,
        "border-gray-300 dark:border-gray-700": !__props.error,
        "focus:ring-0 border-gray-300 focus:border-gray-300 dark:focus:border-gray-700 opacity-60": __props.readonly,
        "focus:border-primary-500 dark:focus:border-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600": !__props.readonly
      }, "block w-full dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm"])}">`);
      _push(ssrRenderComponent(unref(_sfc_main$m), {
        message: (_a = __props.error) == null ? void 0 : _a.replace(" id", ""),
        class: "mt-2"
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup$k = _sfc_main$k.setup;
_sfc_main$k.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Input.vue");
  return _sfc_setup$k ? _sfc_setup$k(props, ctx) : void 0;
};
const _sfc_main$j = {
  __name: "Alerts",
  __ssrInlineRender: true,
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const data = ref({});
    const loading = ref(true);
    onMounted(async () => {
      await axios.get(T("alerts")).then((res) => data.value = res.data).finally(() => loading.value = false);
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_Icon = resolveComponent("Icon");
      _push(`<div${ssrRenderAttrs(_attrs)}><span class="absolute top-4 right-12 sm:right-14 inline-flex items-center gap-x-4 print:hidden"><button type="button" class="link -m-2 p-2">`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "print-o",
        class: "size-5"
      }, null, _parent));
      _push(`</button></span><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4 print:hidden"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Notifications"))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the app alerts below"))}</p></div></div></div>`);
      if (loading.value) {
        _push(`<div>`);
        _push(ssrRenderComponent(unref(_sfc_main$f), null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div class="px-6"><dl class="my-6 grid grid-cols-1 gap-0.5 overflow-hidden rounded-md text-center sm:grid-cols-2 md:grid-cols-3">`);
        if (((_a = data.value) == null ? void 0 : _a.customers) > 0) {
          _push(`<button type="button" class="flex flex-col items-center justify-center bg-gray-100 dark:bg-gray-900 p-4 rounded-md hover:bg-yellow-100 dark:hover:bg-yellow-900"><span class="text-sm/6 font-semibold">${ssrInterpolate(data.value.customers == 1 ? _ctx.$t("Customer") : _ctx.$t("Customers"))}</span><span class="text-sm/6 font-semibold -mt-1">${ssrInterpolate(_ctx.$t("reached due limit"))}</span><span class="order-first text-3xl font-semibold tracking-tight text-focused">${ssrInterpolate(data.value.customers)}</span></button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</dl><!--[-->`);
        ssrRenderList(data.value.stores, (store) => {
          _push(`<!--[--><div class="border-b border-gray-200 dark:border-gray-700 pb-2 mt-6"><h3 class="text-base font-bold text-focus">${ssrInterpolate(store.name)}</h3></div><div class="my-6 grid grid-cols-1 gap-0.5 overflow-hidden rounded-md text-center sm:grid-cols-2 md:grid-cols-3">`);
          if ((store == null ? void 0 : store.reorder_stock) > 0) {
            _push(`<button type="button" class="flex flex-col items-center justify-center bg-gray-100 dark:bg-gray-900 p-4 rounded-md hover:bg-yellow-100 dark:hover:bg-yellow-900"><span class="text-sm/6 font-semibold">${ssrInterpolate(_ctx.$t("Low Stock"))}</span><span class="order-first text-3xl font-semibold tracking-tight text-focused">${ssrInterpolate((store == null ? void 0 : store.reorder_stock) || 0)}</span></button>`);
          } else {
            _push(`<!---->`);
          }
          if ((store == null ? void 0 : store.unpaid_sales) > 0) {
            _push(`<button type="button" class="flex flex-col items-center justify-center bg-gray-100 dark:bg-gray-900 p-4 rounded-md hover:bg-yellow-100 dark:hover:bg-yellow-900"><span class="text-sm/6 font-semibold">${ssrInterpolate(_ctx.$t("Unpaid {x}", { x: _ctx.$t("Sales") }))}</span><span class="order-first text-3xl font-semibold tracking-tight text-focused">${ssrInterpolate(store.unpaid_sales)}</span></button>`);
          } else {
            _push(`<!---->`);
          }
          if ((store == null ? void 0 : store.due_sales) > 0) {
            _push(`<button type="button" class="flex flex-col items-center justify-center bg-gray-100 dark:bg-gray-900 p-4 rounded-md hover:bg-yellow-100 dark:hover:bg-yellow-900"><span class="text-sm/6 font-semibold">${ssrInterpolate(_ctx.$t("Overdue {x}", { x: _ctx.$t("Sales") }))}</span><span class="order-first text-3xl font-semibold tracking-tight text-focused">${ssrInterpolate(store.due_sales)}</span></button>`);
          } else {
            _push(`<!---->`);
          }
          if ((store == null ? void 0 : store.unreceived_payments) > 0) {
            _push(`<button type="button" class="flex flex-col items-center justify-center bg-gray-100 dark:bg-gray-900 p-4 rounded-md hover:bg-yellow-100 dark:hover:bg-yellow-900"><span class="text-sm/6 font-semibold">${ssrInterpolate(_ctx.$t("Payment Requests"))}</span><span class="order-first text-3xl font-semibold tracking-tight text-focused">${ssrInterpolate(store.unreceived_payments)}</span></button>`);
          } else {
            _push(`<!---->`);
          }
          if ((store == null ? void 0 : store.unpaid_purchases) > 0) {
            _push(`<button type="button" class="flex flex-col items-center justify-center bg-gray-100 dark:bg-gray-900 p-4 rounded-md hover:bg-yellow-100 dark:hover:bg-yellow-900"><span class="text-sm/6 font-semibold">${ssrInterpolate(_ctx.$t("Unpaid {x}", { x: _ctx.$t("Purchases") }))}</span><span class="order-first text-3xl font-semibold tracking-tight text-focused">${ssrInterpolate(store.unpaid_purchases)}</span></button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><!--]-->`);
        });
        _push(`<!--]--></div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$j = _sfc_main$j.setup;
_sfc_main$j.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Alerts.vue");
  return _sfc_setup$j ? _sfc_setup$j(props, ctx) : void 0;
};
const _sfc_main$i = {
  __name: "Button",
  __ssrInlineRender: true,
  props: {
    loading: Boolean,
    href: {
      type: String,
      default: ""
    },
    away: {
      type: Boolean,
      default: false
    },
    type: {
      type: String,
      default: "submit"
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Link = resolveComponent("Link");
      if (__props.away && __props.href) {
        _push(`<a${ssrRenderAttrs(mergeProps({
          href: __props.href,
          class: "btn-primary"
        }, _attrs))}>`);
        ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
        _push(`</a>`);
      } else if (__props.href) {
        _push(ssrRenderComponent(_component_Link, mergeProps({
          href: __props.href,
          class: "btn-primary"
        }, _attrs), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
            } else {
              return [
                renderSlot(_ctx.$slots, "default")
              ];
            }
          }),
          _: 3
        }, _parent));
      } else {
        _push(ssrRenderComponent(_sfc_main$n, mergeProps({
          type: __props.type,
          loading: __props.loading,
          class: "btn-primary"
        }, _attrs), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
            } else {
              return [
                renderSlot(_ctx.$slots, "default")
              ];
            }
          }),
          _: 3
        }, _parent));
      }
    };
  }
};
const _sfc_setup$i = _sfc_main$i.setup;
_sfc_main$i.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Button.vue");
  return _sfc_setup$i ? _sfc_setup$i(props, ctx) : void 0;
};
const _sfc_main$h = {
  __name: "Toggle",
  __ssrInlineRender: true,
  props: {
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    },
    modelValue: {
      type: Boolean,
      default: false
    },
    label: String,
    text: String,
    error: String
  },
  emits: ["change", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center" }, _attrs))}><button type="button" role="switch" class="${ssrRenderClass([__props.modelValue ? "bg-primary-600" : "bg-gray-200 dark:bg-gray-700", "relative inline-flex h-6 w-11 shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-primary-600 focus:ring-offset-2"])}"><span class="${ssrRenderClass([__props.modelValue ? "translate-x-5 bg-white" : "translate-x-0 bg-white dark:bg-gray-500 ", "pointer-events-none inline-block size-5 transform rounded-full shadow ring-0 transition duration-200 ease-in-out"])}"></span></button><label class="ml-3 text-sm">`);
      if (__props.label) {
        _push(`<span class="font-medium">${ssrInterpolate(__props.label)}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.text) {
        _push(`<span class="text-mute ml-1">${ssrInterpolate(__props.text)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</label></div>`);
    };
  }
};
const _sfc_setup$h = _sfc_main$h.setup;
_sfc_main$h.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Toggle.vue");
  return _sfc_setup$h ? _sfc_setup$h(props, ctx) : void 0;
};
const _sfc_main$g = {
  __name: "Actions",
  __ssrInlineRender: true,
  props: {
    row: { type: Object },
    record: { type: String },
    deleted: { type: Boolean },
    editRow: { type: Function },
    deleting: { type: Boolean },
    deleteRow: { type: Function }
  },
  setup(__props) {
    const props = __props;
    const confirm = ref(false);
    watch(
      () => props.deleted,
      (value) => {
        if (value == props.row.id) {
          confirm.value = false;
        }
      }
    );
    function deleteRecord(row) {
      props.deleteRow(row);
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center gap-4 text-mute" }, _attrs))}>`);
      if (__props.editRow) {
        _push(`<button type="button" class="link">`);
        _push(ssrRenderComponent(_component_Icon, { name: "edit-o" }, null, _parent));
        _push(`</button>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.deleteRow) {
        _push(`<button type="button">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "trash-o",
          class: "link-red"
        }, null, _parent));
        _push(`</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(unref(_sfc_main$o), {
        show: confirm.value,
        onClose: ($event) => confirm.value = false,
        "max-width": "sm",
        backdrop: !__props.deleting,
        closeable: !__props.deleting
      }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span class="text-red-500"${_scopeId}>${ssrInterpolate(_ctx.$t("Delete {x}", { x: __props.record || _ctx.$t("record") }))}? </span>`);
          } else {
            return [
              createVNode("span", { class: "text-red-500" }, toDisplayString(_ctx.$t("Delete {x}", { x: __props.record || _ctx.$t("record") })) + "? ", 1)
            ];
          }
        }),
        content: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<p${_scopeId}>${ssrInterpolate(_ctx.$t("Are you sure you want to delete the {record}?", { record: __props.record || _ctx.$t("record") }))}</p>`);
            if (__props.row.deleted_at) {
              _push2(`<div class="mt-4 text-red-500 font-extrabold"${_scopeId}><p${_scopeId}>${ssrInterpolate(_ctx.$t("{x} will be deleted permanently from system.", { x: __props.record || _ctx.$t("Record") }))}</p><p class="mt-2"${_scopeId}>${ssrInterpolate(_ctx.$t("This action is not reversible!", { x: __props.record || _ctx.$t("Record") }))}</p></div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("p", null, toDisplayString(_ctx.$t("Are you sure you want to delete the {record}?", { record: __props.record || _ctx.$t("record") })), 1),
              __props.row.deleted_at ? (openBlock(), createBlock("div", {
                key: 0,
                class: "mt-4 text-red-500 font-extrabold"
              }, [
                createVNode("p", null, toDisplayString(_ctx.$t("{x} will be deleted permanently from system.", { x: __props.record || _ctx.$t("Record") })), 1),
                createVNode("p", { class: "mt-2" }, toDisplayString(_ctx.$t("This action is not reversible!", { x: __props.record || _ctx.$t("Record") })), 1)
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$p), {
              onClick: ($event) => confirm.value = false,
              class: { "opacity-25": __props.deleting },
              disabled: __props.deleting
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$q), {
              class: ["ms-3", { "opacity-25": __props.deleting }],
              onClick: ($event) => deleteRecord(__props.row),
              disabled: __props.deleting
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Delete {x}", { x: __props.record || _ctx.$t("record") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Delete {x}", { x: __props.record || _ctx.$t("record") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$p), {
                onClick: ($event) => confirm.value = false,
                class: { "opacity-25": __props.deleting },
                disabled: __props.deleting
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                ]),
                _: 1
              }, 8, ["onClick", "class", "disabled"]),
              createVNode(unref(_sfc_main$q), {
                class: ["ms-3", { "opacity-25": __props.deleting }],
                onClick: ($event) => deleteRecord(__props.row),
                disabled: __props.deleting
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Delete {x}", { x: __props.record || _ctx.$t("record") })), 1)
                ]),
                _: 1
              }, 8, ["onClick", "class", "disabled"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup$g = _sfc_main$g.setup;
_sfc_main$g.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Actions.vue");
  return _sfc_setup$g ? _sfc_setup$g(props, ctx) : void 0;
};
const _sfc_main$f = {
  __name: "Loading",
  __ssrInlineRender: true,
  props: {
    loadingClass: {
      type: String,
      default: ""
    },
    circleSize: {
      type: String,
      default: "h-10 w-10"
    },
    fullScreen: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: [__props.fullScreen ? "fixed inset-0 z-10" : "absolute inset-0 z-1", "h-full w-full flex items-center justify-center text-gray-950 dark:text-gray-100"]
      }, _attrs))}><div class="absolute inset-0 backdrop-blur-sm bg-gray-100 dark:bg-gray-900 opacity-75"></div><div class="${ssrRenderClass([__props.loadingClass, "z-10 flex items-center justify-center"])}"><svg viewBox="0 0 38 38" class="${ssrRenderClass([__props.circleSize, "stroke-current inline"])}" stroke="currentColor" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"><g transform="translate(1 1)" stroke-width="1.5"><circle stroke-opacity=".3" cx="18" cy="18" r="18"></circle><path d="M36 18c0-9.94-8.06-18-18-18"><animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="1s" repeatCount="indefinite"></animateTransform></path></g></g></svg></div></div>`);
    };
  }
};
const _sfc_setup$f = _sfc_main$f.setup;
_sfc_main$f.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Loading.vue");
  return _sfc_setup$f ? _sfc_setup$f(props, ctx) : void 0;
};
const _sfc_main$e = {
  __name: "CheckBox",
  __ssrInlineRender: true,
  props: {
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    },
    checked: {
      type: [Array, Boolean],
      default: false
    },
    value: {
      type: String,
      default: null
    },
    label: String,
    error: String
  },
  emits: ["update:checked"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const props = __props;
    const proxyChecked = computed({
      get() {
        return props.checked;
      },
      set(val) {
        emit("update:checked", val);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}><label${ssrRenderAttr("for", __props.id)} class="inline-flex items-start"><input${ssrRenderAttr("id", __props.id)}${ssrRenderAttr("value", __props.value)} type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(proxyChecked.value) ? ssrLooseContain(proxyChecked.value, __props.value) : proxyChecked.value) ? " checked" : ""} class="${ssrRenderClass([{ "border-red-500": __props.error }, "mt-1 rounded border-gray-300 dark:border-gray-700 dark:bg-gray-600 text-primary-600 shadow-sm w-5 h-5 focus:rounded focus:ring-offset-0 focus:ring-primary-200 dark:focus:ring-opacity-50"])}">`);
      if (__props.label) {
        _push(`<span class="ml-2 mt-0.5">${__props.label ?? ""}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</label>`);
      _push(ssrRenderComponent(unref(_sfc_main$m), { message: __props.error }, null, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup$e = _sfc_main$e.setup;
_sfc_main$e.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/CheckBox.vue");
  return _sfc_setup$e ? _sfc_setup$e(props, ctx) : void 0;
};
const _sfc_main$d = {
  __name: "TabMenus",
  __ssrInlineRender: true,
  props: { links: { type: Array } },
  setup(__props) {
    router.on("navigate", () => currentRoute.value = T().current());
    let currentRoute = ref(T().current());
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      if (__props.links && __props.links.length) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "px-6 pt-6 sm:pt-0" }, _attrs))}><div class="sm:hidden"><label for="tabs" class="sr-only">${ssrInterpolate(_ctx.$t("Select a tab"))}</label><select id="tabs" name="tabs" class="block w-full rounded-md border-gray-300 dark:border-gray-700 focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-800"><!--[-->`);
        ssrRenderList(__props.links, (link) => {
          _push(`<option${ssrRenderAttr("value", link.route)}${ssrIncludeBooleanAttr(link.route == unref(currentRoute)) ? " selected" : ""}>${ssrInterpolate(link.label)}</option>`);
        });
        _push(`<!--]--></select></div><div class="hidden sm:block"><div class="border-b border-gray-200 dark:border-gray-700 -mx-6 px-6"><nav class="-mb-px flex space-x-8" aria-label="Tabs"><!--[-->`);
        ssrRenderList(__props.links, (link) => {
          _push(ssrRenderComponent(unref(Link), {
            href: unref(T)(link.route),
            class: [
              "group inline-flex items-center border-b-2 px-1 py-4 text-sm font-medium",
              link.route == unref(currentRoute) ? "border-primary-500 text-primary-600" : "border-transparent text-mute hover:border-gray-300 dark:hover:border-gray-600 hover:text-gray-700 dark:hover:text-gray-300"
            ]
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (link.icon) {
                  _push2(ssrRenderComponent(_component_Icon, {
                    name: link.icon,
                    size: link.route == unref(currentRoute) ? "-ml-0.5 mr-2 size-5 text-primary-500" : "-ml-0.5 mr-2 size-5 text-gray-400 group-hover:text-gray-500"
                  }, null, _parent2, _scopeId));
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<span${_scopeId}>${ssrInterpolate(link.label)}</span>`);
              } else {
                return [
                  link.icon ? (openBlock(), createBlock(_component_Icon, {
                    key: 0,
                    name: link.icon,
                    size: link.route == unref(currentRoute) ? "-ml-0.5 mr-2 size-5 text-primary-500" : "-ml-0.5 mr-2 size-5 text-gray-400 group-hover:text-gray-500"
                  }, null, 8, ["name", "size"])) : createCommentVNode("", true),
                  createVNode("span", null, toDisplayString(link.label), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></nav></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$d = _sfc_main$d.setup;
_sfc_main$d.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/TabMenus.vue");
  return _sfc_setup$d ? _sfc_setup$d(props, ctx) : void 0;
};
const _sfc_main$c = {
  __name: "Textarea",
  __ssrInlineRender: true,
  props: {
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    },
    modelValue: String,
    label: String,
    error: String,
    rows: String,
    className: String
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const input = ref(null);
    onMounted(async () => {
      await nextTick();
      input.value.setAttribute("style", `height: ${input.value.scrollHeight + 2}px`);
    });
    return (_ctx, _push, _parent, _attrs) => {
      let _temp0;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: __props.className || "col-span-6 sm:col-span-3 xl:col-span-6"
      }, _attrs))}>`);
      _push(ssrRenderComponent(unref(_sfc_main$l), {
        for: __props.id,
        value: __props.label
      }, null, _parent));
      _push(`<textarea${ssrRenderAttrs(_temp0 = mergeProps({
        id: __props.id,
        ref_key: "input",
        ref: input,
        rows: __props.rows
      }, _ctx.$attrs, {
        value: __props.modelValue,
        class: [{ error: __props.error, "border-gray-300 dark:border-gray-700": !__props.error }, "mt-1 block w-full dark:bg-gray-900 dark:text-gray-300 focus:border-primary-500 dark:focus:border-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 rounded-md shadow-sm"]
      }), "textarea")}>${ssrInterpolate("value" in _temp0 ? _temp0.value : "")}</textarea>`);
      if (__props.error) {
        _push(ssrRenderComponent(unref(_sfc_main$m), {
          message: __props.error,
          class: "mt-0"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$c = _sfc_main$c.setup;
_sfc_main$c.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Textarea.vue");
  return _sfc_setup$c ? _sfc_setup$c(props, ctx) : void 0;
};
const _sfc_main$b = {
  __name: "DateInput",
  __ssrInlineRender: true,
  props: {
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    },
    type: {
      type: String,
      default: "text"
    },
    readonly: {
      type: Boolean,
      default: false
    },
    monthPicker: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    clearable: {
      type: Boolean,
      default: true
    },
    time: {
      type: Boolean,
      default: false
    },
    showIcon: {
      type: Boolean,
      default: false
    },
    teleport: {
      type: Boolean,
      default: false
    },
    error: String,
    label: String,
    format: String,
    modelValue: String,
    placeholder: String,
    previewFormat: {
      type: Function,
      default: (date) => $date(date.toISOString())
    }
  },
  emits: ["change", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    ref(null);
    const emit = __emit;
    function update(date) {
      emit("update:modelValue", date);
      emit("change", date);
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      _push(`<!--[-->`);
      if (__props.label) {
        _push(`<div class="flex items-center justify-between">`);
        _push(ssrRenderComponent(unref(_sfc_main$l), {
          for: __props.id,
          value: __props.label,
          class: "flex-1 mb-1"
        }, null, _parent));
        if (_ctx.actionText && _ctx.action) {
          _push(`<button type="button" class="link text-sm">${ssrInterpolate(_ctx.actionText)}</button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(unref(VueDatePicker), {
        uid: __props.id,
        "auto-apply": true,
        readonly: __props.readonly,
        teleport: __props.teleport,
        clearable: __props.clearable,
        "model-value": __props.modelValue,
        onCleared: (e) => update(e),
        placeholder: __props.placeholder,
        "enable-time-picker": __props.time,
        "month-picker": __props.monthPicker,
        "hide-input-icon": !__props.showIcon,
        locale: _ctx.$page.props.language,
        "preview-format": __props.previewFormat,
        "onUpdate:modelValue": (e) => update(e),
        format: __props.monthPicker ? "MMM yyyy" : __props.time ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd"
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$m), {
        message: (_a = __props.error) == null ? void 0 : _a.replace(" id", ""),
        class: "mt-2"
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup$b = _sfc_main$b.setup;
_sfc_main$b.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/DateInput.vue");
  return _sfc_setup$b ? _sfc_setup$b(props, ctx) : void 0;
};
const _sfc_main$a = {
  __name: "FileInput",
  __ssrInlineRender: true,
  props: {
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    },
    type: {
      type: String,
      default: "text"
    },
    multiple: {
      type: Boolean,
      default: false
    },
    accept: {
      type: String,
      default: "image/*"
    },
    modelValue: String,
    label: String,
    error: String
  },
  emits: ["input", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const photo = ref(null);
    const { t } = useI18n({});
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (__props.label) {
        _push(ssrRenderComponent(unref(_sfc_main$l), {
          for: __props.id,
          value: __props.label,
          class: "mb-1"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<input${ssrRenderAttr("id", __props.id)}${ssrIncludeBooleanAttr(__props.multiple) ? " multiple" : ""} type="file" name="photo"${ssrRenderAttr("accept", __props.accept)} class="invisible absolute"><label${ssrRenderAttr("for", __props.id)} class="${ssrRenderClass([{
        "border-red-500": __props.error,
        "text-gray-700 dark:text-gray-300": photo.value,
        "text-gray-400 dark:text-gray-600": !photo.value,
        "border-gray-300 dark:border-gray-700": !__props.error
      }, "cursor-pointer inline-block py-2 px-4 border text-left w-full focus:border-primary-300 focus:ring focus:ring-primary-200 focus:ring-opacity-50 rounded-md shadow-sm dark:bg-gray-900"])}">${ssrInterpolate(photo.value ? photo.value : unref(t)("Select"))}</label>`);
      if (__props.error) {
        _push(ssrRenderComponent(unref(_sfc_main$m), {
          message: __props.error,
          class: "mt-1"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$a = _sfc_main$a.setup;
_sfc_main$a.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/FileInput.vue");
  return _sfc_setup$a ? _sfc_setup$a(props, ctx) : void 0;
};
const _sfc_main$9 = {
  __name: "Pagination",
  __ssrInlineRender: true,
  props: ["meta", "links", "half"],
  setup(__props) {
    const props = __props;
    computed(() => {
      if (props.meta.last_page > 9) {
        const previous = props.links.shift();
        const next = props.links.pop();
        let links = props.links.slice(
          props.meta.current_page > 4 ? props.meta.current_page - 4 : 0,
          props.meta.last_page > props.meta.current_page + 3 ? props.meta.current_page + 3 : props.meta.last_page
        );
        links.unshift(previous);
        links.push(next);
        if (props.meta.current_page > 4) {
          links.unshift({ ...props.meta.links[0], label: "&Lang;" });
        }
        if (props.meta.last_page > props.meta.current_page + 3) {
          links.push({ ...props.meta.links[props.meta.links.length - 1], label: "&Rang;" });
        }
        return links;
      }
      return props.meta.links;
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Link = resolveComponent("Link");
      if (__props.meta && __props.meta.total > 0) {
        _push(`<div${ssrRenderAttrs(_attrs)}><div class="hidden xl:flex items-center justify-between"><div class="mr-4 py-1.5">${ssrInterpolate(_ctx.$t("Showing from {from} to {to} of total {total} records", {
          from: Math.ceil(__props.meta.from / (__props.half ? 2 : 1)),
          to: Math.ceil(__props.meta.to / (__props.half ? 2 : 1)),
          total: Math.ceil(__props.meta.total / (__props.half ? 2 : 1))
        }))}</div>`);
        if (__props.meta.last_page > 1) {
          _push(`<div class="flex flex-wrap gap-1"><!--[-->`);
          ssrRenderList(__props.meta.links, (link, i) => {
            _push(`<!--[-->`);
            if (link.url === null) {
              _push(`<div class="px-4 py-3 text-sm leading-4 border border-gray-200 dark:border-gray-700 opacity-50 bg-white dark:bg-gray-950 text-gray-700 dark:text-gray-300 rounded-md cursor-default">${link.label.replace("Next", "").replace("Previous", "").replace("&laquo;", "⟨").replace("&raquo;", "⟩") ?? ""}</div>`);
            } else {
              _push(ssrRenderComponent(_component_Link, {
                href: link.url,
                class: [
                  link.active ? "bg-primary-600 border-primary-700 text-white" : "bg-white dark:bg-gray-950 text-gray-700 dark:text-gray-300",
                  "inline-block whitespace-nowrap px-4 py-3 text-sm leading-4 border border-gray-200 dark:border-gray-700 rounded-md hover:bg-primary-700 hover:text-white hover:border-primary-700 focus:border-primary-600"
                ]
              }, null, _parent));
            }
            _push(`<!--]-->`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex items-center justify-between xl:hidden">`);
        if (__props.meta.last_page > 1) {
          _push(ssrRenderComponent(_component_Link, {
            href: __props.links.prev,
            class: [
              "inline-block whitespace-nowrap px-4 py-3 text-sm leading-4 border border-gray-200 dark:border-gray-700 rounded-md print:hidden",
              __props.links.prev ? "bg-white dark:bg-gray-950 text-gray-700 dark:text-gray-300 hover:bg-primary-700 hover:text-white hover:border-primary-700 focus:border-primary-600" : "bg-gray-100 cursor-default"
            ]
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(` ⟪ <span class="hidden sm:inline-block ml-1"${_scopeId}>${ssrInterpolate(_ctx.$t("Previous"))}</span>`);
              } else {
                return [
                  createTextVNode(" ⟪ "),
                  createVNode("span", { class: "hidden sm:inline-block ml-1" }, toDisplayString(_ctx.$t("Previous")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="mx-3">${ssrInterpolate(_ctx.$t("Showing from {from} to {to} of total {total} records", {
          from: Math.ceil(__props.meta.from / (__props.half ? 2 : 1)),
          to: Math.ceil(__props.meta.to / (__props.half ? 2 : 1)),
          total: Math.ceil(__props.meta.total / (__props.half ? 2 : 1))
        }))}</div>`);
        if (__props.meta.last_page > 1) {
          _push(ssrRenderComponent(_component_Link, {
            href: __props.links.next,
            class: [
              "inline-block whitespace-nowrap px-4 py-3 text-sm leading-4 border border-gray-200 dark:border-gray-700 rounded-md print:hidden",
              __props.links.next ? "bg-white dark:bg-gray-950 text-gray-700 dark:text-gray-300 hover:bg-primary-700 hover:text-white hover:border-primary-700 focus:border-primary-600" : "bg-gray-100 cursor-default"
            ]
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span class="hidden sm:inline-block mr-1"${_scopeId}>${ssrInterpolate(_ctx.$t("Next"))}</span> ⟫ `);
              } else {
                return [
                  createVNode("span", { class: "hidden sm:inline-block mr-1" }, toDisplayString(_ctx.$t("Next")), 1),
                  createTextVNode(" ⟫ ")
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Pagination.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const _sfc_main$8 = {
  __name: "Attachments",
  __ssrInlineRender: true,
  props: {
    attachments: {
      type: Array
    }
  },
  setup(__props) {
    const modal = ref(false);
    const selected = ref(null);
    computed(() => usePage().props.auth.user);
    const destroy = () => {
      router.delete(route("attachments.destroy", selected.value.id), {
        onFinish: closeModal
      });
    };
    const closeModal = () => {
      modal.value = false;
      selected.value = null;
    };
    return (_ctx, _push, _parent, _attrs) => {
      if (__props.attachments.length) {
        _push(`<div${ssrRenderAttrs(_attrs)}><p class="mb-1">${ssrInterpolate(_ctx.$t("Attachments"))}</p><ul role="list" class="divide-y dark:divide-gray-700 rounded-md border border-gray-200 dark:border-gray-700"><!--[-->`);
        ssrRenderList(__props.attachments, (attachment) => {
          _push(`<li class="flex items-center justify-between py-4 pl-4 pr-5 text-sm leading-6"><div class="flex w-0 flex-1 items-center"><svg class="h-5 w-5 flex-shrink-0 text-gray-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M15.621 4.379a3 3 0 00-4.242 0l-7 7a3 3 0 004.241 4.243h.001l.497-.5a.75.75 0 011.064 1.057l-.498.501-.002.002a4.5 4.5 0 01-6.364-6.364l7-7a4.5 4.5 0 016.368 6.36l-3.455 3.553A2.625 2.625 0 119.52 9.52l3.45-3.451a.75.75 0 111.061 1.06l-3.45 3.451a1.125 1.125 0 001.587 1.595l3.454-3.553a3 3 0 000-4.242z" clip-rule="evenodd"></path></svg><div class="ml-4 flex min-w-0 flex-1 gap-2"><span class="truncate font-medium">${ssrInterpolate(attachment.title)}</span></div></div><div class="ml-4 flex-shrink-0 flex items-center gap-2"><a${ssrRenderAttr("href", _ctx.route("attachments.download", attachment.uuid))} class="font-medium link">${ssrInterpolate(_ctx.$t("Download"))}</a>`);
          if (_ctx.$can("delete-attachments")) {
            _push(`<button type="button" class="font-medium text-red-600 hover:text-red-500">${ssrInterpolate(_ctx.$t("Delete"))}</button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></li>`);
        });
        _push(`<!--]--></ul>`);
        _push(ssrRenderComponent(unref(_sfc_main$o), {
          show: modal.value,
          onClose: closeModal,
          maxWidth: "sm"
        }, {
          title: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Delete {x}", { x: _ctx.$t("attachment") }))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Delete {x}", { x: _ctx.$t("attachment") })), 1)
              ];
            }
          }),
          content: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<p${_scopeId}>${ssrInterpolate(_ctx.$t("Please confirm that you would like to delete the record?"))}</p><p class="mt-2 text-red-500"${_scopeId}>${ssrInterpolate(_ctx.$t("This action will delete the data permanently."))}</p>`);
            } else {
              return [
                createVNode("p", null, toDisplayString(_ctx.$t("Please confirm that you would like to delete the record?")), 1),
                createVNode("p", { class: "mt-2 text-red-500" }, toDisplayString(_ctx.$t("This action will delete the data permanently.")), 1)
              ];
            }
          }),
          footer: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(unref(_sfc_main$p), { onClick: closeModal }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(_sfc_main$q), { onClick: destroy }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Yes, delete"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Yes, delete")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(unref(_sfc_main$p), { onClick: closeModal }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                  ]),
                  _: 1
                }),
                createVNode(unref(_sfc_main$q), { onClick: destroy }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Yes, delete")), 1)
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Attachments.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const _sfc_main$7 = {
  __name: "NumberInput",
  __ssrInlineRender: true,
  props: {
    modelValue: {
      type: [String, Number],
      default: null
    },
    name: {
      type: String,
      default: ""
    },
    min: {
      type: Number
    },
    max: {
      type: Number
    },
    delOn: {
      type: Number
    },
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    }
  },
  emits: ["change", "remove", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const props = __props;
    const value = computed({
      get: () => props.modelValue,
      set: (value2) => {
        emit("update:modelValue", value2);
        emit("change", value2);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center max-w-[7rem]" }, _attrs))}>`);
      if (__props.delOn === 0 && __props.delOn == value.value) {
        _push(`<button type="button" id="decrement-button" data-input-counter-decrement="quantity-input" class="bg-gray-100 dark:bg-gray-800 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 border rounded-s-lg p-2 h-8 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-hidden"><svg fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 -mx-1 -my-2 text-red-600"><path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path></svg></button>`);
      } else {
        _push(`<button type="button" id="decrement-button" data-input-counter-decrement="quantity-input" class="bg-gray-100 dark:bg-gray-800 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 border rounded-s-lg p-2 h-8 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-hidden"><svg fill="none" aria-hidden="true" viewBox="0 0 18 2" xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 text-gray-900 dark:text-white"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M1 1h16"></path></svg></button>`);
      }
      _push(`<input${ssrRenderAttr("id", __props.id)} type="text" placeholder="1"${ssrRenderAttr("value", value.value)} class="border border-gray-200 dark:border-gray-600 border-x-0 h-8 text-center text-gray-900 text-sm block w-full py-2.5 dark:bg-gray-800 dark:placeholder-gray-400 dark:text-white"><button type="button" id="increment-button" data-input-counter-increment="quantity-input" class="bg-gray-100 dark:bg-gray-800 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 border rounded-e-lg p-2 h-8 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-hidden"><svg class="w-3 h-3 text-gray-900 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 18 18"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 1v16M1 9h16"></path></svg></button></div>`);
    };
  }
};
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/NumberInput.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const _sfc_main$6 = {
  __name: "SelectStore",
  __ssrInlineRender: true,
  setup(__props) {
    const page = usePage();
    const { t } = useI18n({});
    watch(
      () => page.props.flash,
      () => {
        var _a;
        page.props.select_store = ((_a = page.props.flash) == null ? void 0 : _a.select_store) ? true : false;
      }
    );
    function hide(e) {
      page.props.select_store = false;
    }
    function selectStore(id) {
      router.visit(route("stores.select", { id }), {
        method: "post",
        onSuccess: () => page.props.select_store = false
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      _push(ssrRenderComponent(unref(_sfc_main$r), mergeProps({
        show: unref(page).props.select_store,
        "max-width": "md",
        onClose: hide
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="p-6"${_scopeId}><div class="flex items-center justify-start gap-4"${_scopeId}><div class="mx-auto flex h-10 w-10 items-center justify-center rounded-full bg-primary-100"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Icon, {
              name: "store-o",
              size: "size-5 text-primary-600"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="flex-1 grow"${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(_ctx.$t("Select {x}", { x: _ctx.$t("Store") }))}</h3><p class="text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Please select a store first!"))}</p></div></div><div class="mt-6 sm:mt-8 grid grid-cols-2 gap-6"${_scopeId}><!--[-->`);
            ssrRenderList(unref(page).props.available_stores, (store) => {
              _push2(`<!--[-->`);
              if (store.id == unref(page).props.selected_store) {
                _push2(`<button class="inline-flex w-full justify-center rounded-lg bg-yellow-100 yellow:bg-yellow-800 px-3 py-2 text-sm font-semibold text-yellow-900 yellow:text-yellow-100 shadow-sm hover:bg-yellow-300 yellow:hover:bg-yellow-700 focus"${_scopeId}>${ssrInterpolate(_ctx.$t("Unselect {x}", { x: store.name }))}</button>`);
              } else {
                _push2(`<button class="inline-flex w-full justify-center rounded-lg bg-gray-100 dark:bg-gray-900 px-3 py-2 text-sm font-semibold text-gray-900 dark:text-gray-100 shadow-sm hover:bg-gray-300 dark:hover:bg-gray-700 focus"${_scopeId}>${ssrInterpolate(_ctx.$t("Select {x}", { x: store.name }))}</button>`);
              }
              _push2(`<!--]-->`);
            });
            _push2(`<!--]--></div></div>`);
          } else {
            return [
              createVNode("div", { class: "p-6" }, [
                createVNode("div", { class: "flex items-center justify-start gap-4" }, [
                  createVNode("div", { class: "mx-auto flex h-10 w-10 items-center justify-center rounded-full bg-primary-100" }, [
                    createVNode(_component_Icon, {
                      name: "store-o",
                      size: "size-5 text-primary-600"
                    })
                  ]),
                  createVNode("div", { class: "flex-1 grow" }, [
                    createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(_ctx.$t("Select {x}", { x: _ctx.$t("Store") })), 1),
                    createVNode("p", { class: "text-sm" }, toDisplayString(_ctx.$t("Please select a store first!")), 1)
                  ])
                ]),
                createVNode("div", { class: "mt-6 sm:mt-8 grid grid-cols-2 gap-6" }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(page).props.available_stores, (store) => {
                    return openBlock(), createBlock(Fragment, {
                      key: store.id
                    }, [
                      store.id == unref(page).props.selected_store ? (openBlock(), createBlock("button", {
                        key: 0,
                        onClick: ($event) => selectStore(0),
                        class: "inline-flex w-full justify-center rounded-lg bg-yellow-100 yellow:bg-yellow-800 px-3 py-2 text-sm font-semibold text-yellow-900 yellow:text-yellow-100 shadow-sm hover:bg-yellow-300 yellow:hover:bg-yellow-700 focus"
                      }, toDisplayString(_ctx.$t("Unselect {x}", { x: store.name })), 9, ["onClick"])) : (openBlock(), createBlock("button", {
                        key: 1,
                        onClick: ($event) => selectStore(store.id),
                        class: "inline-flex w-full justify-center rounded-lg bg-gray-100 dark:bg-gray-900 px-3 py-2 text-sm font-semibold text-gray-900 dark:text-gray-100 shadow-sm hover:bg-gray-300 dark:hover:bg-gray-700 focus"
                      }, toDisplayString(_ctx.$t("Select {x}", { x: store.name })), 9, ["onClick"]))
                    ], 64);
                  }), 128))
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/SelectStore.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
function useClickOutside(component, callback, excludeComponent) {
  if (!component) {
    throw new Error("A target component has to be provided.");
  }
  if (!callback) {
    throw new Error("A callback has to be provided.");
  }
  const listener = (event) => {
    if (event.target === component.value || event.composedPath().includes(component.value) || event.target === excludeComponent.value || event.composedPath().includes(excludeComponent.value)) {
      return;
    }
    if (typeof callback === "function") {
      callback();
    }
  };
  onMounted(() => {
    window.addEventListener("click", listener);
  });
  onBeforeUnmount(() => {
    window.removeEventListener("click", listener);
  });
}
const _sfc_main$5 = {
  __name: "AutoComplete",
  __ssrInlineRender: true,
  props: {
    id: {
      type: String,
      default() {
        return Math.random().toString().replace("0.", "1");
      }
    },
    json: Boolean,
    size: String,
    label: String,
    error: String,
    action: Function,
    addResult: Array,
    position: String,
    disabled: Boolean,
    actionText: String,
    defaultText: String,
    placeholder: String,
    disable: [String, Number],
    suggestions: [String, Array],
    selectedValues: [String, Array],
    modelValue: [String, Number, Array],
    hideIcon: { type: Boolean, default: false },
    multiple: { type: Boolean, default: false },
    clearable: { type: Boolean, default: false },
    keepFocus: { type: Boolean, default: false },
    labelKey: { type: String, default: "label" },
    searchable: { type: Boolean, default: true },
    valueKey: { type: String, default: "value" },
    placement: { type: String, default: "bottom" },
    resetSearch: { type: Boolean, default: false },
    inputClass: { type: String, default: "" }
  },
  emits: ["change", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const { t } = useI18n({});
    const excludeRef = ref(null);
    const componentRef = ref(null);
    const emit = __emit;
    const by_id = ref(false);
    const auto_complete = ref(null);
    const props = __props;
    const search = ref("");
    const result = ref([]);
    const input = ref(null);
    const open = ref(false);
    const stop = ref(false);
    const search0 = ref("");
    const current = ref(null);
    const loading = ref(false);
    const selected = ref(null);
    const multi_current = ref([]);
    const multi_selected = ref([]);
    watch(
      () => props.modelValue,
      async (v) => {
        if (!v) {
          reset();
          await hide();
        } else {
          if (props.multiple) {
            let vl = multi_selected.value.map((s) => props.json ? s[props.valueKey] : s);
            if (v.toString() !== vl.toString()) {
              await initializeValue();
            }
          } else {
            by_id.value = true;
            await initializeValue();
          }
        }
      }
    );
    watch(
      () => props.suggestions,
      (v) => result.value = v
    );
    watch(
      () => props.addResult,
      async (v) => {
        if (v && v.value) {
          result.value.push(v.value);
          current.value = v.value;
          selected.value = v.value;
          suggestionClick(current.value);
          setTimeout(() => {
            search.value = props.json ? v.value[props.labelKey] : v.value;
            emit("update:modelValue", v.value);
          }, 100);
        }
      }
    );
    watch(search, (s) => {
      if (props.searchable) {
        open.value = true;
        if (Array.isArray(props.suggestions)) {
          if (props.multiple && Array.isArray(props.suggestions)) {
            result.value = props.suggestions;
          } else {
            result.value = s ? props.suggestions.filter((r) => cLabel(r, s)) : props.suggestions;
          }
        } else if (s) {
          loading.value = true;
          getSuggestions(s);
        }
      }
    });
    const currentLabel = computed(() => cLabel(selected.value));
    const currentValue = computed(() => cValue(selected.value));
    useClickOutside(componentRef, () => hide(), excludeRef);
    onBeforeUnmount(() => {
      if (props.multiple) {
        window.removeEventListener("click", clickListener);
      }
    });
    onMounted(async () => {
      if (props.multiple) {
        window.addEventListener("click", clickListener);
      }
      await initializeValue();
    });
    const initializeValue = async () => {
      if (Array.isArray(props.suggestions)) {
        result.value = props.suggestions;
      }
      if (props.modelValue) {
        multi_current.value = [];
        if (Array.isArray(props.suggestions)) {
          if (props.multiple) {
            if (props.selectedValues) {
              multi_selected.value = props.selectedValues;
              search.value = props.selectedValues.join(", ");
            } else {
              multi_selected.value = props.suggestions.filter(
                (s) => s == props.modelValue || s[props.valueKey] == props.modelValue || props.modelValue.filter((m) => m == s[props.valueKey])[0] || props.modelValue.filter((m) => m[props.valueKey] == s[props.valueKey])[0] || s.id == props.modelValue
              );
            }
            if (props.json) {
              props.suggestions.map((s, si) => {
                if (multi_selected.value.find((v) => v[props.valueKey] == s[props.valueKey])) {
                  multi_current.value = [...multi_current.value, si];
                }
              });
            } else {
              props.suggestions.map((s, si) => {
                if (multi_selected.value.includes(s)) {
                  multi_current.value = [...multi_current.value, si];
                }
              });
            }
            search.value = multi_selected.value.map((v) => props.json ? v[props.labelKey] : v).join(", ");
          } else {
            if (props.json) {
              selected.value = props.suggestions.find(
                (s) => s == props.modelValue || s[props.valueKey] == props.modelValue || s.value == props.modelValue || s.id == props.modelValue
              );
              current.value = props.suggestions.findIndex(
                (s) => s == props.modelValue || s[props.valueKey] == props.modelValue || s.value == props.modelValue || s.id == props.modelValue
              );
              search.value = currentLabel.value;
            } else {
              selected.value = props.modelValue;
            }
          }
          await nextTick();
          await hide(null, true);
        } else {
          if (!stop.value) {
            axios.post(props.suggestions, { id: props.modelValue }).then((res) => {
              if (props.multiple) {
                current.value = 0;
                result.value = res.data;
                res.data.map(async (s, si) => await suggestionClick(si));
                hide(null, true);
              } else {
                current.value = 0;
                result.value = res.data;
                selected.value = res.data[0];
                search.value = cLabel(selected.value);
              }
            }).finally(async () => {
              await hide();
              loading.value = false;
            });
          }
        }
      }
    };
    const clickListener = (e) => {
      if (e.target == auto_complete.value || e.composedPath().includes(auto_complete.value)) {
        return false;
      }
      hide(e, true);
    };
    const getSuggestions = debounce((s) => {
      let nr = result.value;
      (nr == null ? void 0 : nr.length) ? nr[0] : {};
      if (!stop.value && s && s !== currentLabel.value) {
        search0.value = s;
        axios.post(props.suggestions, { search: s }).then((res) => {
          result.value = res.data;
          if (result.value.length == 1) {
            suggestionClick(0);
          }
        }).finally(() => loading.value = false);
      } else {
        loading.value = false;
      }
      stop.value = false;
    }, 300);
    const cLabel = (r, s) => {
      if (r === null) {
        return null;
      } else if (typeof r !== "object") {
        return r;
      }
      let key = "";
      if (props.labelKey) {
        key = props.labelKey;
      } else if (r.label !== void 0) {
        key = "label";
      } else if (r.name !== void 0) {
        key = "name";
      }
      if (s) {
        return key ? r[key].toLowerCase().includes(s.toString().toLowerCase()) : r.toLowerCase().includes(s.toLowerCase());
      }
      return key ? r[key] : r;
    };
    const cValue = (r) => {
      if (r === null) {
        return null;
      } else if (typeof r !== "object") {
        return r;
      }
      let key = "";
      if (props.valueKey) {
        key = props.valueKey;
      } else if (r.value !== void 0) {
        key = "value";
      } else if (r.id !== void 0) {
        key = "id";
      }
      return key ? r[key] : r;
    };
    const hide = async (e, force, wait = false) => {
      if (wait) {
        setTimeout(hide, 200);
        return false;
      }
      if (!props.multiple || force) {
        if (selected.value) {
          search.value = currentLabel.value;
        }
        await nextTick();
        setTimeout(() => open.value = false, 10);
      } else {
        if (multi_selected.value && multi_selected.value.length) {
          search.value = multi_selected.value.map((v) => props.json ? v[props.labelKey] : v).join(", ");
          search.value = search.value || currentLabel.value;
        }
      }
    };
    const isActive = (index) => {
      if (props.multiple) {
        return multi_current.value.includes(index);
      }
      return index == current.value;
    };
    const suggestionClick = async (index, reset2 = false) => {
      stop.value = true;
      if (index !== void 0) {
        if (props.multiple) {
          if (props.json && multi_selected.value.find((v) => v[props.valueKey] == result.value[index][props.valueKey])) {
            multi_selected.value = multi_selected.value.filter((v) => v[props.valueKey] != result.value[index][props.valueKey]);
          } else {
            if (multi_selected.value.find((v) => v == result.value[index][props.valueKey])) {
              multi_selected.value = multi_selected.value.filter((v) => v != result.value[index][props.valueKey]);
            } else {
              multi_selected.value = [...multi_selected.value, result.value[index]];
            }
          }
          multi_current.value = [];
          if (props.multiple) {
            result.value.map((s, si) => {
              if (props.json && multi_selected.value.find((v) => v[props.valueKey] == s[props.valueKey])) {
                multi_current.value = [...multi_current.value, si];
              } else if (multi_selected.value.includes(s)) {
                multi_current.value = [...multi_current.value, si];
              }
            });
          } else {
            props.suggestions.map((s, si) => {
              if (props.json && multi_selected.value.find((v) => v[props.valueKey] == s[props.valueKey])) {
                multi_current.value = [...multi_current.value, si];
              } else if (multi_selected.value.includes(s)) {
                multi_current.value = [...multi_current.value, si];
              }
            });
          }
          emit("update:modelValue", props.json ? multi_selected.value.map((v) => v[props.valueKey]) : multi_selected.value);
          emit("change", multi_selected.value);
          search.value = multi_selected.value.map((v) => props.json ? v[props.labelKey] : v).join(", ");
          search.value = search.value || currentLabel.value;
        } else {
          current.value = index;
          selected.value = result.value[index];
          emit("update:modelValue", props.json ? currentValue.value : selected.value);
          emit("change", selected.value);
          search.value = props.resetSearch ? null : currentLabel.value;
          await hide();
        }
      }
      if (reset2) {
        result.value = [];
      }
      if (props.resetSearch) {
        selected.value = null;
      }
      if (props.keepFocus) {
        input.value.focus();
      }
    };
    const reset = async () => {
      search.value = "";
      current.value = 0;
      selected.value = null;
      multi_current.value = [];
      multi_selected.value = [];
      emit("change", "");
      emit("update:modelValue", "");
      await hide();
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      _push(`<div${ssrRenderAttrs(mergeProps({
        ref_key: "excludeRef",
        ref: excludeRef,
        class: "col-span-6 sm:col-span-3 xl:col-span-4"
      }, _attrs))}><div class="flex items-center justify-between">`);
      if (__props.label) {
        _push(ssrRenderComponent(unref(_sfc_main$l), {
          for: __props.id,
          value: __props.label,
          class: "inline-block"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (__props.actionText && __props.action) {
        _push(`<button type="button" class="link text-sm focus:ring-0">${ssrInterpolate(__props.actionText)}</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="relative flex items-center"><label${ssrRenderAttr("for", __props.id)} class="inline-block cursor-pointer absolute top-2 right-0 border border-transparent p-2 text-gray-500 dark:text-gray-400">`);
      if (!__props.hideIcon) {
        _push(ssrRenderComponent(_component_Icon, {
          name: "c-down",
          size: "size-4"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</label>`);
      if (__props.clearable && __props.modelValue) {
        _push(`<button type="button" tabindex="-1" class="cursor-pointer focus:outline-none absolute top-2 right-6 border border-transparent p-2 text-gray-500 hover:text-red-500">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "x",
          size: "size-4"
        }, null, _parent));
        _push(`</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input${ssrRenderAttr("id", __props.id)}${ssrRenderAttr("value", search.value)} autocomplete="none"${ssrIncludeBooleanAttr(!__props.searchable || __props.disabled) ? " readonly" : ""}${ssrRenderAttr("placeholder", __props.placeholder || __props.label)} class="${ssrRenderClass([[
        __props.clearable ? "pr-16" : "pr-8",
        __props.inputClass || "mt-1 border focus rounded-md shadow-sm",
        __props.size == "small" ? "py-1.5 pl-2 text-sm" : "py-2 pl-4 text-base",
        __props.error ? "border-red-500" : "border-gray-300 dark:border-gray-700",
        __props.disabled ? "opacity-60 focus:border-gray-200 dark:focus:border-gray-700 focus:ring-0 dark:focus:ring-0" : "focus:border-primary-500 dark:focus:border-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600"
      ], "block w-full dark:bg-gray-900 dark:text-gray-300"])}"><div style="${ssrRenderStyle(open.value ? null : { display: "none" })}" class="${ssrRenderClass([__props.placement == "top" ? "mb-1 bottom-full " + __props.position : "mt-1 top-full " + __props.position, "absolute w-full rounded-md z-20"])}"><ul${ssrRenderAttr("id", "ac-" + __props.id)} class="max-h-56 rounded-md bg-white dark:bg-gray-700 border text-base overflow-auto focus:outline-none border-primary-300 dark:border-primary-500 ring-2 ring-primary-200/50 dark:ring-primary-400/50 sm:text-sm">`);
      if (result.value && result.value.length) {
        _push(`<!--[-->`);
        ssrRenderList(result.value, (r, ri) => {
          _push(`<!--[-->`);
          if (!(__props.disable && __props.disable == cValue())) {
            _push(`<li${ssrRenderAttr("id", "s" + ri)}><button type="button"${ssrRenderAttr("id", __props.id + "-" + ri)} class="${ssrRenderClass([isActive(ri) ? "bg-primary-500 text-white " : "text-focus", "w-full text-left flex items-center select-none relative py-2 hover:bg-primary-200 hover:text-primary-800 dark:hover:bg-primary-700 dark:hover:text-primary-100 focus:outline-none focus:ring-0 focus:rounded-none"])}"><span class="ml-3 block font-normal truncate">${ssrInterpolate(cLabel(r))}</span></button></li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<li class="bg-primary-600 text-white cursor-default select-none relative py-2"><div class="flex items-center"><span class="ml-3 block font-normal truncate">`);
        if (loading.value) {
          _push(`<span>${ssrInterpolate(_ctx.$t("Searching for results"))}...</span>`);
        } else if (result.value == null) {
          _push(`<span>${ssrInterpolate(_ctx.$t("Scan barcode or search items for next"))}</span>`);
        } else if (__props.json) {
          _push(`<span>${ssrInterpolate(__props.defaultText || _ctx.$t("Please type to search"))}</span>`);
        } else {
          _push(`<span>${ssrInterpolate(_ctx.$t("No suggestions to list."))}</span>`);
        }
        _push(`</span></div></li>`);
      }
      _push(`</ul></div></div>`);
      if (__props.error) {
        _push(ssrRenderComponent(unref(_sfc_main$m), {
          message: __props.error.replace(" id", ""),
          class: "mt-0"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/AutoComplete.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = {
  __name: "CustomFields",
  __ssrInlineRender: true,
  props: {
    errors: { type: Object, default: {} },
    custom_fields: { type: Array, default: [] },
    extra_attributes: { type: Object, default: {} }
  },
  emits: ["update"],
  setup(__props, { emit: __emit }) {
    const emits = __emit;
    const props = __props;
    function isChecked(field, opt) {
      return props.extra_attributes[field] && props.extra_attributes[field].includes(opt);
    }
    function updateValue(field, e, opt) {
      if (!props.extra_attributes[field]) {
        props.extra_attributes[field] = [];
      }
      if (e.target.checked) {
        props.extra_attributes[field] = [...props.extra_attributes[field], opt];
      } else {
        props.extra_attributes[field] = props.extra_attributes[field].filter((v) => v != opt);
      }
      emits("update", e);
    }
    return (_ctx, _push, _parent, _attrs) => {
      if (__props.custom_fields && __props.custom_fields.length) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "col-span-full grid grid-cols-6 gap-6" }, _attrs))}><!--[-->`);
        ssrRenderList(__props.custom_fields, (field, fi) => {
          _push(`<!--[-->`);
          if (field.type == "text" || field.type == "number") {
            _push(`<div class="col-span-6 sm:col-span-3">`);
            _push(ssrRenderComponent(unref(_sfc_main$k), {
              type: field.type,
              label: _ctx.$t(field.name),
              onChange: (e) => emits("update", e),
              modelValue: __props.extra_attributes[field.name],
              "onUpdate:modelValue": ($event) => __props.extra_attributes[field.name] = $event,
              error: __props.errors["extra_attributes." + field.name]
            }, null, _parent));
            _push(`</div>`);
          } else if (field.type == "select") {
            _push(`<div class="col-span-6 sm:col-span-3">`);
            _push(ssrRenderComponent(unref(_sfc_main$5), {
              label: _ctx.$t(field.name),
              suggestions: field.options,
              onChange: (e) => emits("update", e),
              modelValue: __props.extra_attributes[field.name],
              "onUpdate:modelValue": ($event) => __props.extra_attributes[field.name] = $event,
              error: __props.errors["extra_attributes." + field.name] || null
            }, null, _parent));
            _push(`</div>`);
          } else if (field.type == "date") {
            _push(`<div class="col-span-6 sm:col-span-3">`);
            _push(ssrRenderComponent(unref(_sfc_main$k), {
              type: "date",
              label: _ctx.$t(field.name),
              onChange: (e) => emits("update", e),
              modelValue: __props.extra_attributes[field.name],
              "onUpdate:modelValue": ($event) => __props.extra_attributes[field.name] = $event,
              error: __props.errors["extra_attributes." + field.name] || null
            }, null, _parent));
            _push(`</div>`);
          } else if (field.type == "time") {
            _push(`<div class="col-span-6 sm:col-span-3">`);
            _push(ssrRenderComponent(unref(_sfc_main$k), {
              type: "time",
              label: _ctx.$t(field.name),
              onChange: (e) => emits("update", e),
              modelValue: __props.extra_attributes[field.name],
              "onUpdate:modelValue": ($event) => __props.extra_attributes[field.name] = $event,
              error: __props.errors["extra_attributes." + field.name] || null
            }, null, _parent));
            _push(`</div>`);
          } else if (field.type == "checkbox") {
            _push(`<div class="col-span-full">`);
            _push(ssrRenderComponent(unref(_sfc_main$l), {
              value: _ctx.$t(field.name)
            }, null, _parent));
            _push(`<div class="my-2 flex flex-wrap items-center gap-x-12 gap-y-3"><!--[-->`);
            ssrRenderList(field.options, (opt, index) => {
              _push(ssrRenderComponent(unref(_sfc_main$l), {
                class: "flex items-center",
                key: fi + "_ex_cb_" + index,
                "for-id": fi + "_ex_cb_" + index
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<input${ssrRenderAttr("value", opt)} type="checkbox"${ssrRenderAttr("name", field.name + "[]")}${ssrRenderAttr("id", fi + "_ex_cb_" + index)}${ssrIncludeBooleanAttr(isChecked(field.name, opt)) ? " checked" : ""} class="rounded dark:bg-gray-900 w-5 h-5 border border-gray-300 dark:border-gray-700 text-primary-600 shadow-sm"${_scopeId}><span class="ml-2 cursor-default"${_scopeId}>${opt ?? ""}</span>`);
                  } else {
                    return [
                      createVNode("input", {
                        value: opt,
                        type: "checkbox",
                        name: field.name + "[]",
                        id: fi + "_ex_cb_" + index,
                        checked: isChecked(field.name, opt),
                        onChange: (e) => updateValue(field.name, e, opt),
                        class: "rounded dark:bg-gray-900 w-5 h-5 border border-gray-300 dark:border-gray-700 text-primary-600 shadow-sm"
                      }, null, 40, ["value", "name", "id", "checked", "onChange"]),
                      createVNode("span", {
                        innerHTML: opt,
                        class: "ml-2 cursor-default"
                      }, null, 8, ["innerHTML"])
                    ];
                  }
                }),
                _: 2
              }, _parent));
            });
            _push(`<!--]--></div>`);
            if (__props.errors["extra_attributes." + field.name] || null) {
              _push(ssrRenderComponent(unref(_sfc_main$m), {
                message: __props.errors["extra_attributes." + field.name] || null
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          } else if (field.type == "radio") {
            _push(`<div class="col-span-full">`);
            _push(ssrRenderComponent(unref(_sfc_main$l), {
              value: _ctx.$t(field.name)
            }, null, _parent));
            _push(`<div class="my-2 flex flex-wrap items-center gap-x-12 gap-y-3"><!--[-->`);
            ssrRenderList(field.options, (opt, index) => {
              _push(ssrRenderComponent(unref(_sfc_main$l), {
                class: "flex items-center",
                key: fi + "_ex_radio_" + index,
                "for-id": fi + "_ex_radio_" + index
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<input type="radio"${ssrRenderAttr("value", opt)}${ssrRenderAttr("name", field.name)}${ssrRenderAttr("id", fi + "_ex_radio_" + index)}${ssrIncludeBooleanAttr(ssrLooseEqual(__props.extra_attributes[field.name], opt)) ? " checked" : ""}${ssrIncludeBooleanAttr(__props.extra_attributes[field.name] == opt) ? " checked" : ""} class="rounded-full dark:bg-gray-900 w-5 h-5 border border-gray-300 dark:border-gray-700 text-primary-600 shadow-sm"${_scopeId}><span class="ml-2 cursor-default"${_scopeId}>${opt ?? ""}</span>`);
                  } else {
                    return [
                      withDirectives(createVNode("input", {
                        type: "radio",
                        value: opt,
                        name: field.name,
                        id: fi + "_ex_radio_" + index,
                        onChange: (e) => emits("update", e),
                        "onUpdate:modelValue": ($event) => __props.extra_attributes[field.name] = $event,
                        checked: __props.extra_attributes[field.name] == opt,
                        class: "rounded-full dark:bg-gray-900 w-5 h-5 border border-gray-300 dark:border-gray-700 text-primary-600 shadow-sm"
                      }, null, 40, ["value", "name", "id", "onChange", "onUpdate:modelValue", "checked"]), [
                        [vModelRadio, __props.extra_attributes[field.name]]
                      ]),
                      createVNode("span", {
                        innerHTML: opt,
                        class: "ml-2 cursor-default"
                      }, null, 8, ["innerHTML"])
                    ];
                  }
                }),
                _: 2
              }, _parent));
            });
            _push(`<!--]--></div>`);
            if (__props.errors["extra_attributes." + field.name] || null) {
              _push(ssrRenderComponent(unref(_sfc_main$m), {
                message: __props.errors["extra_attributes." + field.name] || null
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          } else if (field.type == "textarea") {
            _push(`<div class="col-span-full">`);
            _push(ssrRenderComponent(unref(_sfc_main$c), {
              label: _ctx.$t(field.name),
              onChange: (e) => emits("update", e),
              modelValue: __props.extra_attributes[field.name],
              "onUpdate:modelValue": ($event) => __props.extra_attributes[field.name] = $event,
              error: __props.errors["extra_attributes." + field.name] || null
            }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/CustomFields.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = {
  __name: "SelectVariant",
  __ssrInlineRender: true,
  props: ["item", "round"],
  emits: ["close", "update"],
  setup(__props, { emit: __emit }) {
    const page = usePage();
    const props = __props;
    const emit = __emit;
    const meta = ref({});
    const show = ref(true);
    const code = ref(null);
    const selected = ref(null);
    watch(code, (s) => {
      var _a, _b;
      selected.value = (_b = (_a = props.item) == null ? void 0 : _a.product) == null ? void 0 : _b.variations.find((v) => v.code.toLowerCase() == s.toLowerCase());
      update();
    });
    watch(
      meta,
      (s) => {
        var _a, _b;
        selected.value = (_b = (_a = props.item) == null ? void 0 : _a.product) == null ? void 0 : _b.variations.find((v) => isequal(v.meta, s));
        update();
      },
      { deep: true }
    );
    onMounted(async () => {
      var _a;
      await nextTick();
      (_a = document.getElementById("variation-code")) == null ? void 0 : _a.focus();
    });
    function update() {
      if (selected.value) {
        let variation = props.item.variations.find((v) => v.id == selected.value.id);
        if (variation) {
          props.item.variations = props.item.variations.map((v) => v.id == variation.id ? { ...v, quantity: v.quantity + 1 } : v);
          selected.value = variation;
        } else {
          props.item.variations = props.item.variations.map(
            (v) => v.id ? v : {
              ...selected.value,
              quantity: 1,
              taxes: props.item.taxes,
              unit_id: props.item.unit_id,
              tax_included: props.item.tax_included == 1,
              cost: selected.value.cost || props.item.cost,
              price: selected.value.price || props.item.price
            }
          );
        }
        props.item.variations = props.item.variations.filter((v) => v.id);
        props.item.quantity = props.item.variations.reduce((a, v) => Number(v.quantity) + a, 0);
        meta.value = {};
        code.value = null;
        selected.value = null;
        emit("update", props.item);
      }
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      _push(ssrRenderComponent(unref(_sfc_main$r), mergeProps({
        show: show.value,
        "max-width": "md",
        onClose: ($event) => _ctx.$emit("close"),
        overflow: true,
        round: __props.round
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a, _b;
          if (_push2) {
            _push2(`<div class="p-6"${_scopeId}><div class="flex items-center justify-start gap-4"${_scopeId}><div class="mx-auto flex h-10 w-10 items-center justify-center rounded-full bg-primary-100"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Icon, {
              name: "bolt",
              size: "size-5 text-primary-600"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="flex-1 grow"${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(_ctx.$t("Select {x}", { x: _ctx.$t("Variant") }))}</h3><p class="text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Please select the variant to add item to order list."))}</p></div></div><div class="mt-6 sm:mt-8 grid grid-cols-1 sm:grid-cols-2 gap-6"${_scopeId}><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$k), {
              label: "",
              modelValue: code.value,
              "onUpdate:modelValue": ($event) => code.value = $event,
              id: "variation-code",
              placeholder: _ctx.$t("Scan barcode or type the variation code")
            }, null, _parent2, _scopeId));
            _push2(`</div><!--[-->`);
            ssrRenderList(__props.item.product.variants, (variant, vi) => {
              _push2(`<div${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$5), {
                id: "type",
                json: true,
                label: _ctx.$t(variant.name),
                suggestions: variant.options,
                modelValue: meta.value[variant.name],
                "onUpdate:modelValue": ($event) => meta.value[variant.name] = $event
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            });
            _push2(`<!--]-->`);
            if (selected.value) {
              _push2(`<div class="col-span-full border border-gray-200 dark:border-gray-700 rounded-lg"${_scopeId}><dl class="divide-y dark:divide-gray-700"${_scopeId}><div class="px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm/6 font-medium text-gray-900"${_scopeId}>${ssrInterpolate(_ctx.$t("Code"))}</dt><dd class="mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(selected.value.code)}</dd></div><div class="px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm/6 font-medium text-gray-900"${_scopeId}>${ssrInterpolate(_ctx.$t("Quantity"))}</dt><dd class="mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$number((_a = selected.value.stocks.find((s) => s.store_id == unref(page).props.selected_store)) == null ? void 0 : _a.balance))}</dd></div><div class="px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm/6 font-medium text-gray-900"${_scopeId}>${ssrInterpolate(_ctx.$t("Cost"))}</dt><dd class="mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(selected.value.cost ? _ctx.$number(selected.value.cost) : "")}</dd></div><div class="px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm/6 font-medium text-gray-900"${_scopeId}>${ssrInterpolate(_ctx.$t("Price"))}</dt><dd class="mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(selected.value.price ? _ctx.$number(selected.value.price) : "")}</dd></div><div class="px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm/6 font-medium text-gray-900"${_scopeId}>${ssrInterpolate(_ctx.$t("Weight"))}</dt><dd class="mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(selected.value.weight ? _ctx.$number(selected.value.weight) : "")}</dd></div><div class="px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="text-sm/6 font-medium text-gray-900"${_scopeId}>${ssrInterpolate(_ctx.$t("Dimensions"))}</dt><dd class="mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(selected.value.dimensions)}</dd></div></dl></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "p-6" }, [
                createVNode("div", { class: "flex items-center justify-start gap-4" }, [
                  createVNode("div", { class: "mx-auto flex h-10 w-10 items-center justify-center rounded-full bg-primary-100" }, [
                    createVNode(_component_Icon, {
                      name: "bolt",
                      size: "size-5 text-primary-600"
                    })
                  ]),
                  createVNode("div", { class: "flex-1 grow" }, [
                    createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(_ctx.$t("Select {x}", { x: _ctx.$t("Variant") })), 1),
                    createVNode("p", { class: "text-sm" }, toDisplayString(_ctx.$t("Please select the variant to add item to order list.")), 1)
                  ])
                ]),
                createVNode("div", { class: "mt-6 sm:mt-8 grid grid-cols-1 sm:grid-cols-2 gap-6" }, [
                  createVNode("div", { class: "col-span-full" }, [
                    createVNode(unref(_sfc_main$k), {
                      label: "",
                      modelValue: code.value,
                      "onUpdate:modelValue": ($event) => code.value = $event,
                      id: "variation-code",
                      placeholder: _ctx.$t("Scan barcode or type the variation code")
                    }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                  ]),
                  (openBlock(true), createBlock(Fragment, null, renderList(__props.item.product.variants, (variant, vi) => {
                    return openBlock(), createBlock("div", { key: vi }, [
                      createVNode(unref(_sfc_main$5), {
                        id: "type",
                        json: true,
                        label: _ctx.$t(variant.name),
                        suggestions: variant.options,
                        modelValue: meta.value[variant.name],
                        "onUpdate:modelValue": ($event) => meta.value[variant.name] = $event
                      }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue"])
                    ]);
                  }), 128)),
                  selected.value ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "col-span-full border border-gray-200 dark:border-gray-700 rounded-lg"
                  }, [
                    createVNode("dl", { class: "divide-y dark:divide-gray-700" }, [
                      createVNode("div", { class: "px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "text-sm/6 font-medium text-gray-900" }, toDisplayString(_ctx.$t("Code")), 1),
                        createVNode("dd", { class: "mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0" }, toDisplayString(selected.value.code), 1)
                      ]),
                      createVNode("div", { class: "px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "text-sm/6 font-medium text-gray-900" }, toDisplayString(_ctx.$t("Quantity")), 1),
                        createVNode("dd", { class: "mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$number((_b = selected.value.stocks.find((s) => s.store_id == unref(page).props.selected_store)) == null ? void 0 : _b.balance)), 1)
                      ]),
                      createVNode("div", { class: "px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "text-sm/6 font-medium text-gray-900" }, toDisplayString(_ctx.$t("Cost")), 1),
                        createVNode("dd", { class: "mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0" }, toDisplayString(selected.value.cost ? _ctx.$number(selected.value.cost) : ""), 1)
                      ]),
                      createVNode("div", { class: "px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "text-sm/6 font-medium text-gray-900" }, toDisplayString(_ctx.$t("Price")), 1),
                        createVNode("dd", { class: "mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0" }, toDisplayString(selected.value.price ? _ctx.$number(selected.value.price) : ""), 1)
                      ]),
                      createVNode("div", { class: "px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "text-sm/6 font-medium text-gray-900" }, toDisplayString(_ctx.$t("Weight")), 1),
                        createVNode("dd", { class: "mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0" }, toDisplayString(selected.value.weight ? _ctx.$number(selected.value.weight) : ""), 1)
                      ]),
                      createVNode("div", { class: "px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "text-sm/6 font-medium text-gray-900" }, toDisplayString(_ctx.$t("Dimensions")), 1),
                        createVNode("dd", { class: "mt-1 text-sm/6 text-gray-700 sm:col-span-2 sm:mt-0" }, toDisplayString(selected.value.dimensions), 1)
                      ])
                    ])
                  ])) : createCommentVNode("", true)
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/SelectVariant.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = {
  __name: "CopyTextButton",
  __ssrInlineRender: true,
  props: { text: { type: String } },
  setup(__props) {
    const copied = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      _push(`<button${ssrRenderAttrs(mergeProps({
        type: "button",
        class: "flex items-center relative"
      }, _attrs))}>`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      if (copied.value) {
        _push(ssrRenderComponent(_component_Icon, {
          name: "copied-o",
          class: "ml-1 w-5 h-full absolute left-full text-success-500"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button>`);
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/CopyTextButton.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "NumberInputRound",
  __ssrInlineRender: true,
  props: {
    modelValue: {
      type: [String, Number],
      default: null
    },
    name: {
      type: String,
      default: ""
    },
    min: {
      type: Number
    },
    max: {
      type: Number
    },
    delOn: {
      type: Number
    },
    id: {
      type: String,
      default() {
        return (Math.random() + "").replace("0.", "");
      }
    }
  },
  emits: ["change", "remove", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const props = __props;
    const value = computed({
      get: () => props.modelValue,
      set: (value2) => {
        emit("update:modelValue", value2);
        emit("change", value2);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center max-w-[7rem]" }, _attrs))}>`);
      if (__props.delOn === 0 && __props.delOn == value.value) {
        _push(`<button type="button" id="decrement-button" data-input-counter-decrement="quantity-input" class="bg-gray-100 dark:bg-gray-800 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 border rounded-full p-2 h-8 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-hidden"><svg fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 -mx-1 -my-2 text-red-600"><path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path></svg></button>`);
      } else {
        _push(`<button type="button" id="decrement-button" data-input-counter-decrement="quantity-input" class="flex-1 bg-gray-100 dark:bg-gray-800 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 border rounded-full p-2 h-8 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-hidden"><svg fill="none" aria-hidden="true" viewBox="0 0 18 2" xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 text-gray-900 dark:text-white"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M1 1h16"></path></svg></button>`);
      }
      _push(`<input${ssrRenderAttr("id", __props.id)} type="text" placeholder="1"${ssrRenderAttr("value", value.value)} class="border-0 h-8 text-center text-gray-900 text-sm block w-full py-2.5 dark:bg-gray-950 dark:placeholder-gray-400 dark:text-white"><button type="button" id="increment-button" data-input-counter-increment="quantity-input" class="bg-gray-100 dark:bg-gray-800 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 border rounded-full p-2 h-8 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-hidden"><svg class="w-3 h-3 text-gray-900 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 18 18"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 1v16M1 9h16"></path></svg></button></div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/NumberInputRound.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {
  __name: "ViewCustomFields",
  __ssrInlineRender: true,
  props: {
    title: String,
    modal: { type: Boolean, default: true },
    extra_attributes: { type: Object, default: {} }
  },
  setup(__props) {
    const show = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      if (Object.keys(__props.extra_attributes).length) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "" }, _attrs))}>`);
        if (__props.modal) {
          _push(`<!--[--><button type="button" class="px-2 py-0.5 rounded-md -my-1 border border-gray-200 dark:border-gray-700">${ssrInterpolate(_ctx.$t("View"))}</button>`);
          _push(ssrRenderComponent(unref(_sfc_main$r), {
            show: show.value,
            maxWidth: "lg",
            closeable: true,
            onClose: () => show.value = false
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="font-bold p-4 border-b border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Custom Fields"))} ${ssrInterpolate(__props.title ? " (" + __props.title + ")" : "")}</div><div class="m-6 flow-root"${_scopeId}><div class="overflow-x-auto"${_scopeId}><div class="inline-block border border-gray-200 dark:border-gray-700 rounded-md min-w-full align-middle"${_scopeId}><table class="min-w-full"${_scopeId}><tbody class="divide-y dark:divide-gray-700"${_scopeId}><!--[-->`);
                ssrRenderList(Object.keys(__props.extra_attributes), (key) => {
                  _push2(`<tr${_scopeId}><td class="pl-4 pr-3 py-2 text-sm text-right w-1/3"${_scopeId}>${ssrInterpolate(key)}</td><td class="pl-3 pr-4 py-2 text-sm font-bold"${_scopeId}>${ssrInterpolate(Array.isArray(__props.extra_attributes[key]) ? __props.extra_attributes[key].join(", ") : unref(isValidDate)(__props.extra_attributes[key]) ? unref($date$1)(__props.extra_attributes[key]) : __props.extra_attributes[key] || "")}</td></tr>`);
                });
                _push2(`<!--]--></tbody></table></div></div></div>`);
              } else {
                return [
                  createVNode("div", { class: "font-bold p-4 border-b border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Custom Fields")) + " " + toDisplayString(__props.title ? " (" + __props.title + ")" : ""), 1),
                  createVNode("div", { class: "m-6 flow-root" }, [
                    createVNode("div", { class: "overflow-x-auto" }, [
                      createVNode("div", { class: "inline-block border border-gray-200 dark:border-gray-700 rounded-md min-w-full align-middle" }, [
                        createVNode("table", { class: "min-w-full" }, [
                          createVNode("tbody", { class: "divide-y dark:divide-gray-700" }, [
                            (openBlock(true), createBlock(Fragment, null, renderList(Object.keys(__props.extra_attributes), (key) => {
                              return openBlock(), createBlock("tr", { key }, [
                                createVNode("td", { class: "pl-4 pr-3 py-2 text-sm text-right w-1/3" }, toDisplayString(key), 1),
                                createVNode("td", { class: "pl-3 pr-4 py-2 text-sm font-bold" }, toDisplayString(Array.isArray(__props.extra_attributes[key]) ? __props.extra_attributes[key].join(", ") : unref(isValidDate)(__props.extra_attributes[key]) ? unref($date$1)(__props.extra_attributes[key]) : __props.extra_attributes[key] || ""), 1)
                              ]);
                            }), 128))
                          ])
                        ])
                      ])
                    ])
                  ])
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`<!--]-->`);
        } else {
          _push(`<div><!--[-->`);
          ssrRenderList(Object.keys(__props.extra_attributes), (key) => {
            _push(`<div><span class="text-mute">${ssrInterpolate(key)}</span> : ${ssrInterpolate(Array.isArray(__props.extra_attributes[key]) ? __props.extra_attributes[key].join(", ") : unref(isValidDate)(__props.extra_attributes[key]) ? unref($date$1)(__props.extra_attributes[key]) : __props.extra_attributes[key] || "")}</div>`);
          });
          _push(`<!--]--></div>`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/ViewCustomFields.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const fetchClient = () => {
  const defaultOptions = {
    withCredentials: true,
    headers: {
      Accept: "application/json",
      "X-Requested-With": "XMLHttpRequest"
    }
  };
  let instance = axios$1.create(defaultOptions);
  instance.interceptors.request.use(function(config) {
    return config;
  });
  instance.interceptors.response.use(
    (response) => response,
    (error) => {
      var _a, _b, _c, _d;
      if ((_b = (_a = error.response) == null ? void 0 : _a.data) == null ? void 0 : _b.errors) {
        notify(
          {
            group: "main",
            type: "error",
            title: "Error!",
            text: Object.values(error.response.data.errors).join("<br />")
          },
          1e4
        );
      } else if ((_d = (_c = error.response) == null ? void 0 : _c.data) == null ? void 0 : _d.message) {
        notify(
          {
            group: "main",
            type: "error",
            title: "Error!",
            text: error.response.data.message
          },
          1e4
        );
      }
      if (error.response.status === 401) {
        router.visit("/login");
      }
      return Promise.reject(error);
    }
  );
  window.axios = instance;
  return instance;
};
const axios = fetchClient();
export {
  $currency as $,
  _sfc_main$3 as A,
  _sfc_main$1 as B,
  _sfc_main$7 as C,
  useClickOutside as D,
  _sfc_main$d as E,
  $number as F,
  chunkArray as G,
  $datetime as H,
  _sfc_main$f as _,
  axios as a,
  _sfc_main$5 as b,
  _sfc_main$g as c,
  _sfc_main$9 as d,
  _sfc_main$i as e,
  $extras as f,
  _sfc_main$b as g,
  _sfc_main$k as h,
  _sfc_main$a as i,
  _sfc_main$8 as j,
  _sfc_main$4 as k,
  _sfc_main$c as l,
  _sfc_main$2 as m,
  $random as n,
  $can as o,
  _sfc_main$j as p,
  _sfc_main$6 as q,
  $address as r,
  _sfc_main$h as s,
  _sfc_main as t,
  $decimal as u,
  _sfc_main$e as v,
  calculate_item as w,
  convert_to_base_unit as x,
  discount_keypress as y,
  check_promotions as z
};
