<?php

declare(strict_types=1);

return [
    'default' => env('FISCAL_SERVICE_DRIVER', null),

    'drivers' => [
        'malaysia-einvoice' => [
            'service'       => Plugins\FiscalServices\Services\MalaysiaEinvoiceFiscalService::class,
            'label'         => 'Malaysia MyInvois',
            'description'   => 'Malaysia LHDN MyInvois e-invoicing.',
            'client_id'     => env('MALAYSIA_EINVOICE_CLIENT_ID'),
            'client_secret' => env('MALAYSIA_EINVOICE_CLIENT_SECRET'),
            'mode'          => env('MALAYSIA_EINVOICE_MODE', 'sandbox'),
            'fields'        => [
                [
                    'key'         => 'client_id',
                    'label'       => 'Client ID',
                    'type'        => 'text',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => null,
                    'help'        => 'Issued by the Malaysia MyInvois portal.',
                    'rows'        => null,
                ],
                [
                    'key'         => 'client_secret',
                    'label'       => 'Client Secret',
                    'type'        => 'password',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => null,
                    'help'        => 'Keep this value secure. Issued by the Malaysia MyInvois portal.',
                    'rows'        => null,
                ],
                [
                    'key'       => 'mode',
                    'label'     => 'Mode',
                    'type'      => 'radio',
                    'component' => 'radio',
                    'options'   => [
                        ['value' => 'production', 'label' => 'Production'],
                        ['value' => 'sandbox', 'label' => 'Sandbox/Test Mode'],
                    ],
                    'help' => 'Please select the Malaysia MyInvois environment. Please test before start using production.',
                ],
            ],
        ],

        'zatca-phase-two' => [
            'service'                => Plugins\FiscalServices\Services\ZatcaPhaseTwoFiscalService::class,
            'label'                  => 'ZATCA Phase 2',
            'description'            => 'Saudi Arabia e-invoicing (Phase 2).',
            'base_url'               => env('ZATCA_API_BASE_URL', 'https://gw-fatoora.zatca.gov.sa/e-invoicing/developer-portal'),
            'compliance_id'          => env('ZATCA_COMPLIANCE_ID'),
            'certificate'            => env('ZATCA_CERTIFICATE'),
            'secret_key'             => env('ZATCA_SECRET_KEY'),
            'private_key'            => env('ZATCA_PRIVATE_KEY'),
            'private_key_path'       => env('ZATCA_PRIVATE_KEY_PATH'),
            'private_key_passphrase' => env('ZATCA_PRIVATE_KEY_PASSPHRASE'),
            'fields'                 => [
                [
                    'key'         => 'base_url',
                    'label'       => 'Base URL',
                    'type'        => 'text',
                    'component'   => 'input',
                    'required'    => false,
                    'placeholder' => 'https://gw-fatoora.zatca.gov.sa/e-invoicing/core/',
                    'help'        => 'Leave blank to use the default ZATCA endpoint.',
                    'rows'        => null,
                ],
                [
                    'key'         => 'compliance_id',
                    'label'       => 'Compliance ID',
                    'type'        => 'text',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => null,
                    'help'        => 'Provided by the ZATCA compliance portal.',
                    'rows'        => null,
                ],
                [
                    'key'         => 'certificate',
                    'label'       => 'Certificate (PEM)',
                    'type'        => 'text',
                    'component'   => 'textarea',
                    'required'    => true,
                    'placeholder' => null,
                    'help'        => 'Paste the PEM encoded certificate provided by ZATCA.',
                    'rows'        => 6,
                ],
                [
                    'key'         => 'secret_key',
                    'label'       => 'Secret Key',
                    'type'        => 'password',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => null,
                    'help'        => 'The secret key associated with the certificate.',
                    'rows'        => null,
                ],
                [
                    'key'         => 'private_key',
                    'label'       => 'Private Key (PEM)',
                    'type'        => 'text',
                    'component'   => 'textarea',
                    'required'    => false,
                    'placeholder' => null,
                    'help'        => 'Paste the PEM encoded private key provided by ZATCA.',
                    'rows'        => 6,
                ],
                [
                    'key'         => 'private_key_path',
                    'label'       => 'Private Key Path',
                    'type'        => 'text',
                    'component'   => 'input',
                    'required'    => false,
                    'placeholder' => '/path/to/private-key.pem',
                    'help'        => 'If the private key is stored on disk, provide the absolute path to the PEM file.',
                    'rows'        => null,
                ],
                [
                    'key'         => 'private_key_passphrase',
                    'label'       => 'Private Key Passphrase',
                    'type'        => 'password',
                    'component'   => 'input',
                    'required'    => false,
                    'placeholder' => null,
                    'help'        => 'Optional passphrase used to decrypt the private key.',
                    'rows'        => null,
                ],
            ],
        ],

        'costa-rica-einvoice' => [
            'service'          => Plugins\FiscalServices\Services\CostaRicaEinvoiceFiscalService::class,
            'label'            => 'Costa Rica e-Invoice',
            'description'      => 'Costa Rica Ministerio de Hacienda electronic invoicing (Factura Electrónica).',
            'username'         => env('COSTA_RICA_EINVOICE_USERNAME'),
            'password'         => env('COSTA_RICA_EINVOICE_PASSWORD'),
            'certificate_path' => env('COSTA_RICA_EINVOICE_CERTIFICATE_PATH'),
            'certificate_pin'  => env('COSTA_RICA_EINVOICE_CERTIFICATE_PIN'),
            'mode'             => env('COSTA_RICA_EINVOICE_MODE', 'sandbox'),
            'fields'           => [
                [
                    'key'         => 'username',
                    'label'       => 'Username (ATV)',
                    'type'        => 'text',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => 'user@prod.comprobanteselectronicos.go.cr',
                    'help'        => 'Your ATV username from the Hacienda portal (e.g., cpj-3-101-123456@prod.comprobanteselectronicos.go.cr).',
                    'rows'        => null,
                ],
                [
                    'key'         => 'password',
                    'label'       => 'Password (ATV)',
                    'type'        => 'password',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => null,
                    'help'        => 'Your ATV password from the Hacienda portal.',
                    'rows'        => null,
                ],
                [
                    'key'         => 'certificate_path',
                    'label'       => 'Certificate Path',
                    'type'        => 'text',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => 'certificates/costa-rica.pem',
                    'help'        => 'Path to your .pem or .p12 certificate file (relative to storage/app or absolute path).',
                    'rows'        => null,
                ],
                [
                    'key'         => 'certificate_pin',
                    'label'       => 'Certificate PIN',
                    'type'        => 'password',
                    'component'   => 'input',
                    'required'    => true,
                    'placeholder' => null,
                    'help'        => 'The PIN/password for your digital certificate.',
                    'rows'        => null,
                ],
                [
                    'key'       => 'mode',
                    'label'     => 'Mode',
                    'type'      => 'radio',
                    'component' => 'radio',
                    'options'   => [
                        ['value' => 'production', 'label' => 'Production'],
                        ['value' => 'sandbox', 'label' => 'Sandbox/Test Mode (api-stag)'],
                    ],
                    'help' => 'Select the Hacienda environment. Use sandbox for testing before production.',
                ],
            ],
        ],
    ],
];
