-- -------------------------------------------------------------
-- TablePlus 4.5.2(402)
--
-- https://tableplus.com/
--
-- Database: sma4
-- Generation Time: 2025-01-10 12:40:28.3210
-- -------------------------------------------------------------


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


DROP TABLE IF EXISTS `cities`;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint unsigned NOT NULL,
  `state_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state_code` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=150720 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `iso2` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `phone_code` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso3` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `emoji` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `emojiU` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=251 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE `currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `precision` tinyint NOT NULL DEFAULT '2',
  `symbol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol_native` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol_first` tinyint NOT NULL DEFAULT '1',
  `decimal_mark` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `thousands_separator` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=251 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `states`;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_code` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `timezones`;
CREATE TABLE `timezones` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=429 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(1, 1, 1, 'Ashkāsham', 'AF', 'BDS'),
(2, 1, 1, 'Fayzabad', 'AF', 'BDS'),
(3, 1, 1, 'Jurm', 'AF', 'BDS'),
(4, 1, 1, 'Khandūd', 'AF', 'BDS'),
(5, 1, 1, 'Rāghistān', 'AF', 'BDS'),
(6, 1, 1, 'Wākhān', 'AF', 'BDS'),
(7, 1, 2, 'Ghormach', 'AF', 'BDG'),
(8, 1, 2, 'Qala i Naw', 'AF', 'BDG'),
(9, 1, 3, 'Baghlān', 'AF', 'BGL'),
(10, 1, 3, 'Ḩukūmatī Dahanah-ye Ghōrī', 'AF', 'BGL'),
(11, 1, 3, 'Nahrīn', 'AF', 'BGL'),
(12, 1, 3, 'Pul-e Khumrī', 'AF', 'BGL'),
(13, 1, 4, 'Balkh', 'AF', 'BAL'),
(14, 1, 4, 'Dowlatābād', 'AF', 'BAL'),
(15, 1, 4, 'Khulm', 'AF', 'BAL'),
(16, 1, 4, 'Lab-Sar', 'AF', 'BAL'),
(17, 1, 4, 'Mazār-e Sharīf', 'AF', 'BAL'),
(18, 1, 4, 'Qarchī Gak', 'AF', 'BAL'),
(19, 1, 5, 'Bāmyān', 'AF', 'BAM'),
(20, 1, 5, 'Panjāb', 'AF', 'BAM'),
(21, 1, 6, 'Nīlī', 'AF', 'DAY'),
(22, 1, 7, 'Farah', 'AF', 'FRA'),
(23, 1, 8, 'Andkhoy', 'AF', 'FYB'),
(24, 1, 8, 'Maymana', 'AF', 'FYB'),
(25, 1, 9, 'Ghazni', 'AF', 'GHA'),
(26, 1, 10, 'Fayrōz Kōh', 'AF', 'GHO'),
(27, 1, 10, 'Shahrak', 'AF', 'GHO'),
(28, 1, 11, '‘Alāqahdārī Dīshū', 'AF', 'HEL'),
(29, 1, 11, 'Gereshk', 'AF', 'HEL'),
(30, 1, 11, 'Lashkar Gāh', 'AF', 'HEL'),
(31, 1, 11, 'Markaz-e Ḩukūmat-e Darwēshān', 'AF', 'HEL'),
(32, 1, 11, 'Sangīn', 'AF', 'HEL'),
(33, 1, 12, 'Chahār Burj', 'AF', 'HER'),
(34, 1, 12, 'Ghōriyān', 'AF', 'HER'),
(35, 1, 12, 'Herāt', 'AF', 'HER'),
(36, 1, 12, 'Kafir Qala', 'AF', 'HER'),
(37, 1, 12, 'Karukh', 'AF', 'HER'),
(38, 1, 12, 'Kuhsān', 'AF', 'HER'),
(39, 1, 12, 'Kushk', 'AF', 'HER'),
(40, 1, 12, 'Qarah Bāgh', 'AF', 'HER'),
(41, 1, 12, 'Shīnḏanḏ', 'AF', 'HER'),
(42, 1, 12, 'Tīr Pul', 'AF', 'HER'),
(43, 1, 12, 'Zindah Jān', 'AF', 'HER'),
(44, 1, 13, 'Āqchah', 'AF', 'JOW'),
(45, 1, 13, 'Darzāb', 'AF', 'JOW'),
(46, 1, 13, 'Qarqīn', 'AF', 'JOW'),
(47, 1, 13, 'Shibirghān', 'AF', 'JOW'),
(48, 1, 14, 'Kabul', 'AF', 'KAB'),
(49, 1, 14, 'Mīr Bachah Kōṯ', 'AF', 'KAB'),
(50, 1, 14, 'Paghmān', 'AF', 'KAB'),
(51, 1, 15, 'Kandahār', 'AF', 'KAN'),
(52, 1, 16, 'Sidqābād', 'AF', 'KAP'),
(53, 1, 17, 'Khōst', 'AF', 'KHO'),
(54, 1, 18, 'Asadabad', 'AF', 'KNR'),
(55, 1, 18, 'Āsmār', 'AF', 'KNR'),
(56, 1, 19, 'Dasht-e Archī', 'AF', 'KDZ'),
(57, 1, 19, 'Imām Şāḩib', 'AF', 'KDZ'),
(58, 1, 19, 'Khanabad', 'AF', 'KDZ'),
(59, 1, 19, 'Kunduz', 'AF', 'KDZ'),
(60, 1, 19, 'Qarāwul', 'AF', 'KDZ'),
(61, 1, 20, 'Mehtar Lām', 'AF', 'LAG'),
(62, 1, 21, 'Baraki Barak', 'AF', 'LOG'),
(63, 1, 21, 'Ḩukūmatī Azrah', 'AF', 'LOG'),
(64, 1, 21, 'Pul-e ‘Alam', 'AF', 'LOG'),
(65, 1, 22, 'Bāsawul', 'AF', 'NAN'),
(66, 1, 22, 'Jalālābād', 'AF', 'NAN'),
(67, 1, 22, 'Markaz-e Woluswalī-ye Āchīn', 'AF', 'NAN'),
(68, 1, 23, 'Khāsh', 'AF', 'NIM'),
(69, 1, 23, 'Mīrābād', 'AF', 'NIM'),
(70, 1, 23, 'Rūdbār', 'AF', 'NIM'),
(71, 1, 23, 'Zaranj', 'AF', 'NIM'),
(72, 1, 24, 'Pārūn', 'AF', 'NUR'),
(73, 1, 25, 'Gardez', 'AF', 'PIA'),
(74, 1, 26, 'Saṟōbī', 'AF', 'PKA'),
(75, 1, 26, 'Zaṟah Sharan', 'AF', 'PKA'),
(76, 1, 26, 'Zarghūn Shahr', 'AF', 'PKA'),
(77, 1, 27, 'Bāzārak', 'AF', 'PAN'),
(78, 1, 28, 'Charikar', 'AF', 'PAR'),
(79, 1, 28, 'Jabal os Saraj', 'AF', 'PAR'),
(80, 1, 29, 'Aībak', 'AF', 'SAM'),
(81, 1, 30, 'Chīras', 'AF', 'SAR'),
(82, 1, 30, 'Larkird', 'AF', 'SAR'),
(83, 1, 30, 'Qal‘ah-ye Shahr', 'AF', 'SAR'),
(84, 1, 30, 'Sang-e Chārak', 'AF', 'SAR'),
(85, 1, 30, 'Sar-e Pul', 'AF', 'SAR'),
(86, 1, 30, 'Tagāw-Bāy', 'AF', 'SAR'),
(87, 1, 30, 'Tukzār', 'AF', 'SAR'),
(88, 1, 31, 'Ārt Khwājah', 'AF', 'TAK'),
(89, 1, 31, 'Taloqan', 'AF', 'TAK'),
(90, 1, 32, 'Tarinkot', 'AF', 'URU'),
(91, 1, 32, 'Uruzgān', 'AF', 'URU'),
(92, 1, 33, 'Qalāt', 'AF', 'ZAB'),
(93, 3, 35, 'Banaj', 'AL', 'BR'),
(94, 3, 35, 'Bashkia Berat', 'AL', 'BR'),
(95, 3, 35, 'Bashkia Kuçovë', 'AL', 'BR'),
(96, 3, 35, 'Bashkia Poliçan', 'AL', 'BR'),
(97, 3, 35, 'Bashkia Skrapar', 'AL', 'BR'),
(98, 3, 35, 'Berat', 'AL', 'BR'),
(99, 3, 35, 'Çorovodë', 'AL', 'BR'),
(100, 3, 35, 'Kuçovë', 'AL', 'BR'),
(101, 3, 35, 'Poliçan', 'AL', 'BR'),
(102, 3, 35, 'Rrethi i Beratit', 'AL', 'BR'),
(103, 3, 35, 'Rrethi i Kuçovës', 'AL', 'BR'),
(104, 3, 35, 'Rrethi i Skraparit', 'AL', 'BR'),
(105, 3, 35, 'Ura Vajgurore', 'AL', 'BR'),
(106, 3, 39, 'Bashkia Bulqizë', 'AL', '09'),
(107, 3, 39, 'Bashkia Klos', 'AL', '09'),
(108, 3, 39, 'Bashkia Mat', 'AL', '09'),
(109, 3, 39, 'Bulqizë', 'AL', '09'),
(110, 3, 39, 'Burrel', 'AL', '09'),
(111, 3, 39, 'Klos', 'AL', '09'),
(112, 3, 39, 'Peshkopi', 'AL', '09'),
(113, 3, 39, 'Rrethi i Bulqizës', 'AL', '09'),
(114, 3, 39, 'Rrethi i Dibrës', 'AL', '09'),
(115, 3, 39, 'Rrethi i Matit', 'AL', '09'),
(116, 3, 39, 'Ulëz', 'AL', '09'),
(117, 3, 42, 'Bashkia Durrës', 'AL', 'DR'),
(118, 3, 42, 'Bashkia Krujë', 'AL', 'DR'),
(119, 3, 42, 'Bashkia Shijak', 'AL', 'DR'),
(120, 3, 42, 'Durrës', 'AL', 'DR'),
(121, 3, 42, 'Durrës District', 'AL', 'DR'),
(122, 3, 42, 'Fushë-Krujë', 'AL', 'DR'),
(123, 3, 42, 'Krujë', 'AL', 'DR'),
(124, 3, 42, 'Rrethi i Krujës', 'AL', 'DR'),
(125, 3, 42, 'Shijak', 'AL', 'DR'),
(126, 3, 42, 'Sukth', 'AL', 'DR'),
(127, 3, 44, 'Ballsh', 'AL', '04'),
(128, 3, 44, 'Bashkia Divjakë', 'AL', '04'),
(129, 3, 44, 'Bashkia Fier', 'AL', '04'),
(130, 3, 44, 'Bashkia Mallakastër', 'AL', '04'),
(131, 3, 44, 'Bashkia Patos', 'AL', '04'),
(132, 3, 44, 'Divjakë', 'AL', '04'),
(133, 3, 44, 'Fier', 'AL', '04'),
(134, 3, 44, 'Fier-Çifçi', 'AL', '04'),
(135, 3, 44, 'Lushnjë', 'AL', '04'),
(136, 3, 44, 'Patos', 'AL', '04'),
(137, 3, 44, 'Patos Fshat', 'AL', '04'),
(138, 3, 44, 'Roskovec', 'AL', '04'),
(139, 3, 44, 'Rrethi i Mallakastrës', 'AL', '04'),
(140, 3, 47, 'Bashkia Dropull', 'AL', 'GJ'),
(141, 3, 47, 'Bashkia Kelcyrë', 'AL', 'GJ'),
(142, 3, 47, 'Bashkia Libohovë', 'AL', 'GJ'),
(143, 3, 47, 'Bashkia Memaliaj', 'AL', 'GJ'),
(144, 3, 47, 'Bashkia Përmet', 'AL', 'GJ'),
(145, 3, 47, 'Bashkia Tepelenë', 'AL', 'GJ'),
(146, 3, 47, 'Gjinkar', 'AL', 'GJ'),
(147, 3, 47, 'Gjirokastër', 'AL', 'GJ'),
(148, 3, 47, 'Këlcyrë', 'AL', 'GJ'),
(149, 3, 47, 'Lazarat', 'AL', 'GJ'),
(150, 3, 47, 'Libohovë', 'AL', 'GJ'),
(151, 3, 47, 'Memaliaj', 'AL', 'GJ'),
(152, 3, 47, 'Përmet', 'AL', 'GJ'),
(153, 3, 47, 'Tepelenë', 'AL', 'GJ'),
(154, 3, 52, 'Bashkia Devoll', 'AL', '06'),
(155, 3, 52, 'Bashkia Kolonjë', 'AL', '06'),
(156, 3, 52, 'Bashkia Maliq', 'AL', '06'),
(157, 3, 52, 'Bashkia Pustec', 'AL', '06'),
(158, 3, 52, 'Bilisht', 'AL', '06'),
(159, 3, 52, 'Ersekë', 'AL', '06'),
(160, 3, 52, 'Korçë', 'AL', '06'),
(161, 3, 52, 'Leskovik', 'AL', '06'),
(162, 3, 52, 'Libonik', 'AL', '06'),
(163, 3, 52, 'Maliq', 'AL', '06'),
(164, 3, 52, 'Mborje', 'AL', '06'),
(165, 3, 52, 'Pogradec', 'AL', '06'),
(166, 3, 52, 'Rrethi i Devollit', 'AL', '06'),
(167, 3, 52, 'Rrethi i Kolonjës', 'AL', '06'),
(168, 3, 52, 'Velçan', 'AL', '06'),
(169, 3, 52, 'Voskopojë', 'AL', '06'),
(170, 3, 57, 'Bajram Curri', 'AL', 'KU'),
(171, 3, 57, 'Krumë', 'AL', 'KU'),
(172, 3, 57, 'Kukës', 'AL', 'KU'),
(173, 3, 57, 'Rrethi i Hasit', 'AL', 'KU'),
(174, 3, 57, 'Rrethi i Kukësit', 'AL', 'KU'),
(175, 3, 59, 'Bashkia Kurbin', 'AL', '08'),
(176, 3, 59, 'Bashkia Lezhë', 'AL', '08'),
(177, 3, 59, 'Bashkia Mirditë', 'AL', '08'),
(178, 3, 59, 'Kurbnesh', 'AL', '08'),
(179, 3, 59, 'Laç', 'AL', '08'),
(180, 3, 59, 'Lezhë', 'AL', '08'),
(181, 3, 59, 'Mamurras', 'AL', '08'),
(182, 3, 59, 'Milot', 'AL', '08'),
(183, 3, 59, 'Rrëshen', 'AL', '08'),
(184, 3, 59, 'Rrethi i Kurbinit', 'AL', '08'),
(185, 3, 59, 'Rubik', 'AL', '08'),
(186, 3, 59, 'Shëngjin', 'AL', '08'),
(187, 3, 73, 'Bashkia Malësi e Madhe', 'AL', 'SH'),
(188, 3, 73, 'Bashkia Pukë', 'AL', 'SH'),
(189, 3, 73, 'Bashkia Vau i Dejës', 'AL', 'SH'),
(190, 3, 73, 'Fushë-Arrëz', 'AL', 'SH'),
(191, 3, 73, 'Koplik', 'AL', 'SH'),
(192, 3, 73, 'Pukë', 'AL', 'SH'),
(193, 3, 73, 'Rrethi i Malësia e Madhe', 'AL', 'SH'),
(194, 3, 73, 'Rrethi i Shkodrës', 'AL', 'SH'),
(195, 3, 73, 'Shkodër', 'AL', 'SH'),
(196, 3, 73, 'Vau i Dejës', 'AL', 'SH'),
(197, 3, 73, 'Vukatanë', 'AL', 'SH'),
(198, 3, 77, 'Bashkia Kavajë', 'AL', 'TR'),
(199, 3, 77, 'Bashkia Vorë', 'AL', 'TR'),
(200, 3, 77, 'Kamëz', 'AL', 'TR'),
(201, 3, 77, 'Kavajë', 'AL', 'TR'),
(202, 3, 77, 'Krrabë', 'AL', 'TR'),
(203, 3, 77, 'Rrethi i Kavajës', 'AL', 'TR'),
(204, 3, 77, 'Rrethi i Tiranës', 'AL', 'TR'),
(205, 3, 77, 'Rrogozhinë', 'AL', 'TR'),
(206, 3, 77, 'Sinaballaj', 'AL', 'TR'),
(207, 3, 77, 'Tirana', 'AL', 'TR'),
(208, 3, 77, 'Vorë', 'AL', 'TR'),
(209, 3, 79, 'Bashkia Finiq', 'AL', '12'),
(210, 3, 79, 'Bashkia Himarë', 'AL', '12'),
(211, 3, 79, 'Bashkia Konispol', 'AL', '12'),
(212, 3, 79, 'Bashkia Selenicë', 'AL', '12'),
(213, 3, 79, 'Bashkia Vlorë', 'AL', '12'),
(214, 3, 79, 'Delvinë', 'AL', '12'),
(215, 3, 79, 'Himarë', 'AL', '12'),
(216, 3, 79, 'Konispol', 'AL', '12'),
(217, 3, 79, 'Ksamil', 'AL', '12'),
(218, 3, 79, 'Orikum', 'AL', '12'),
(219, 3, 79, 'Rrethi i Delvinës', 'AL', '12'),
(220, 3, 79, 'Sarandë', 'AL', '12'),
(221, 3, 79, 'Selenicë', 'AL', '12'),
(222, 3, 79, 'Vlorë', 'AL', '12'),
(223, 4, 81, 'Adrar', 'DZ', '01'),
(224, 4, 81, 'Aoulef', 'DZ', '01'),
(225, 4, 81, 'Reggane', 'DZ', '01'),
(226, 4, 81, 'Timimoun', 'DZ', '01'),
(227, 4, 82, 'Aïn Defla', 'DZ', '44'),
(228, 4, 82, 'El Abadia', 'DZ', '44'),
(229, 4, 82, 'El Attaf', 'DZ', '44'),
(230, 4, 82, 'Khemis Miliana', 'DZ', '44'),
(231, 4, 82, 'Theniet el Had', 'DZ', '44'),
(232, 4, 83, 'Aïn Temouchent', 'DZ', '46'),
(233, 4, 83, 'Beni Saf', 'DZ', '46'),
(234, 4, 83, 'El Amria', 'DZ', '46'),
(235, 4, 83, 'El Malah', 'DZ', '46'),
(236, 4, 83, 'Hammam Bou Hadjar', 'DZ', '46'),
(237, 4, 84, 'Aïn Taya', 'DZ', '16'),
(238, 4, 84, 'Algiers', 'DZ', '16'),
(239, 4, 84, 'Bab Ezzouar', 'DZ', '16'),
(240, 4, 84, 'Birkhadem', 'DZ', '16'),
(241, 4, 84, 'Bordj el Kiffan', 'DZ', '16'),
(242, 4, 84, 'Dar el Beïda', 'DZ', '16'),
(243, 4, 84, 'Rouiba', 'DZ', '16'),
(244, 4, 85, 'Annaba', 'DZ', '23'),
(245, 4, 85, 'Berrahal', 'DZ', '23'),
(246, 4, 85, 'Drean', 'DZ', '23'),
(247, 4, 85, 'El Hadjar', 'DZ', '23'),
(248, 4, 86, 'Aïn Touta', 'DZ', '05'),
(249, 4, 86, 'Arris', 'DZ', '05'),
(250, 4, 86, 'Barika', 'DZ', '05'),
(251, 4, 86, 'Batna', 'DZ', '05'),
(252, 4, 86, 'Boumagueur', 'DZ', '05'),
(253, 4, 86, 'Merouana', 'DZ', '05'),
(254, 4, 86, 'Râs el Aïoun', 'DZ', '05'),
(255, 4, 86, 'Tazoult-Lambese', 'DZ', '05'),
(256, 4, 87, 'Béchar', 'DZ', '08'),
(257, 4, 88, 'Akbou', 'DZ', '06'),
(258, 4, 88, 'Amizour', 'DZ', '06'),
(259, 4, 88, 'Barbacha', 'DZ', '06'),
(260, 4, 88, 'Bejaïa', 'DZ', '06'),
(261, 4, 88, 'el hed', 'DZ', '06'),
(262, 4, 88, 'El Kseur', 'DZ', '06'),
(263, 4, 88, 'Feraoun', 'DZ', '06'),
(264, 4, 88, 'Seddouk', 'DZ', '06'),
(265, 4, 90, 'Biskra', 'DZ', '07'),
(266, 4, 90, 'Oumache', 'DZ', '07'),
(267, 4, 90, 'Sidi Khaled', 'DZ', '07'),
(268, 4, 90, 'Sidi Okba', 'DZ', '07'),
(269, 4, 90, 'Tolga', 'DZ', '07'),
(270, 4, 90, 'Zeribet el Oued', 'DZ', '07'),
(271, 4, 91, 'Beni Mered', 'DZ', '09'),
(272, 4, 91, 'Blida', 'DZ', '09'),
(273, 4, 91, 'Boû Arfa', 'DZ', '09'),
(274, 4, 91, 'Boufarik', 'DZ', '09'),
(275, 4, 91, 'Bougara', 'DZ', '09'),
(276, 4, 91, 'Bouinan', 'DZ', '09'),
(277, 4, 91, 'Chebli', 'DZ', '09'),
(278, 4, 91, 'Chiffa', 'DZ', '09'),
(279, 4, 91, 'Larbaâ', 'DZ', '09'),
(280, 4, 91, 'Meftah', 'DZ', '09'),
(281, 4, 91, 'Sidi Moussa', 'DZ', '09'),
(282, 4, 91, 'Souma', 'DZ', '09'),
(283, 4, 93, 'Bordj Bou Arreridj', 'DZ', '34'),
(284, 4, 93, 'Bordj Ghdir', 'DZ', '34'),
(285, 4, 93, 'Bordj Zemoura', 'DZ', '34'),
(286, 4, 93, 'El Achir', 'DZ', '34'),
(287, 4, 93, 'Mansourah', 'DZ', '34'),
(288, 4, 93, 'Melouza', 'DZ', '34'),
(289, 4, 93, 'Râs el Oued', 'DZ', '34'),
(290, 4, 94, 'Aïn Bessem', 'DZ', '10'),
(291, 4, 94, 'Bouïra', 'DZ', '10'),
(292, 4, 94, 'Chorfa', 'DZ', '10'),
(293, 4, 94, 'Draa el Mizan', 'DZ', '10'),
(294, 4, 94, 'Lakhdaria', 'DZ', '10'),
(295, 4, 94, 'Sour el Ghozlane', 'DZ', '10'),
(296, 4, 95, 'Arbatache', 'DZ', '35'),
(297, 4, 95, 'Beni Amrane', 'DZ', '35'),
(298, 4, 95, 'Boudouaou', 'DZ', '35'),
(299, 4, 95, 'Boumerdas', 'DZ', '35'),
(300, 4, 95, 'Chabet el Ameur', 'DZ', '35'),
(301, 4, 95, 'Dellys', 'DZ', '35'),
(302, 4, 95, 'Khemis el Khechna', 'DZ', '35'),
(303, 4, 95, 'Makouda', 'DZ', '35'),
(304, 4, 95, 'Naciria', 'DZ', '35'),
(305, 4, 95, 'Ouled Moussa', 'DZ', '35'),
(306, 4, 95, 'Reghaïa', 'DZ', '35'),
(307, 4, 95, 'Tadmaït', 'DZ', '35'),
(308, 4, 95, 'Thenia', 'DZ', '35'),
(309, 4, 95, 'Tizi Gheniff', 'DZ', '35'),
(310, 4, 96, 'Abou el Hassan', 'DZ', '02'),
(311, 4, 96, 'Boukadir', 'DZ', '02'),
(312, 4, 96, 'Chlef', 'DZ', '02'),
(313, 4, 96, 'Ech Chettia', 'DZ', '02'),
(314, 4, 96, 'Oued Fodda', 'DZ', '02'),
(315, 4, 96, 'Oued Sly', 'DZ', '02'),
(316, 4, 96, 'Sidi Akkacha', 'DZ', '02'),
(317, 4, 97, '’Aïn Abid', 'DZ', '25'),
(318, 4, 97, 'Aïn Smara', 'DZ', '25'),
(319, 4, 97, 'Constantine', 'DZ', '25'),
(320, 4, 97, 'Didouche Mourad', 'DZ', '25'),
(321, 4, 97, 'El Khroub', 'DZ', '25'),
(322, 4, 97, 'Hamma Bouziane', 'DZ', '25'),
(323, 4, 99, '’Aïn el Bell', 'DZ', '17'),
(324, 4, 99, 'Aïn Oussera', 'DZ', '17'),
(325, 4, 99, 'Birine', 'DZ', '17'),
(326, 4, 99, 'Charef', 'DZ', '17'),
(327, 4, 99, 'Dar Chioukh', 'DZ', '17'),
(328, 4, 99, 'Djelfa', 'DZ', '17'),
(329, 4, 99, 'El Idrissia', 'DZ', '17'),
(330, 4, 99, 'Messaad', 'DZ', '17'),
(331, 4, 100, 'Brezina', 'DZ', '32'),
(332, 4, 100, 'El Abiodh Sidi Cheikh', 'DZ', '32'),
(333, 4, 100, 'El Bayadh', 'DZ', '32'),
(334, 4, 103, 'Debila', 'DZ', '39'),
(335, 4, 103, 'El Oued', 'DZ', '39'),
(336, 4, 103, 'Reguiba', 'DZ', '39'),
(337, 4, 103, 'Robbah', 'DZ', '39'),
(338, 4, 104, 'Ben Mehidi', 'DZ', '36'),
(339, 4, 104, 'Besbes', 'DZ', '36'),
(340, 4, 104, 'El Kala', 'DZ', '36'),
(341, 4, 104, 'El Tarf', 'DZ', '36'),
(342, 4, 105, 'Berriane', 'DZ', '47'),
(343, 4, 105, 'Ghardaïa', 'DZ', '47'),
(344, 4, 105, 'Metlili Chaamba', 'DZ', '47'),
(345, 4, 106, 'Boumahra Ahmed', 'DZ', '24'),
(346, 4, 106, 'Guelma', 'DZ', '24'),
(347, 4, 106, 'Héliopolis', 'DZ', '24'),
(348, 4, 107, 'Illizi', 'DZ', '33'),
(349, 4, 110, 'Jijel', 'DZ', '18'),
(350, 4, 111, 'Khenchela', 'DZ', '40'),
(351, 4, 112, 'Aflou', 'DZ', '03'),
(352, 4, 112, 'Laghouat', 'DZ', '03'),
(353, 4, 113, '‘Aïn el Hadjel', 'DZ', '28'),
(354, 4, 113, '’Aïn el Melh', 'DZ', '28'),
(355, 4, 113, 'M’Sila', 'DZ', '28'),
(356, 4, 113, 'Sidi Aïssa', 'DZ', '28'),
(357, 4, 114, 'Bou Hanifia el Hamamat', 'DZ', '29'),
(358, 4, 114, 'Mascara', 'DZ', '29'),
(359, 4, 114, 'Oued el Abtal', 'DZ', '29'),
(360, 4, 114, 'Sig', 'DZ', '29'),
(361, 4, 115, '’Aïn Boucif', 'DZ', '26'),
(362, 4, 115, 'Berrouaghia', 'DZ', '26'),
(363, 4, 115, 'Ksar el Boukhari', 'DZ', '26'),
(364, 4, 115, 'Médéa', 'DZ', '26'),
(365, 4, 116, 'Chelghoum el Aïd', 'DZ', '43'),
(366, 4, 116, 'Mila', 'DZ', '43'),
(367, 4, 116, 'Rouached', 'DZ', '43'),
(368, 4, 116, 'Sidi Mérouane', 'DZ', '43'),
(369, 4, 116, 'Telerghma', 'DZ', '43'),
(370, 4, 117, 'Mostaganem', 'DZ', '27'),
(371, 4, 118, 'Aïn Sefra', 'DZ', '45'),
(372, 4, 118, 'Naama', 'DZ', '45'),
(373, 4, 119, '’Aïn el Turk', 'DZ', '31'),
(374, 4, 119, 'Aïn el Bya', 'DZ', '31'),
(375, 4, 119, 'Bir el Djir', 'DZ', '31'),
(376, 4, 119, 'Bou Tlelis', 'DZ', '31'),
(377, 4, 119, 'Es Senia', 'DZ', '31'),
(378, 4, 119, 'Mers el Kebir', 'DZ', '31'),
(379, 4, 119, 'Oran', 'DZ', '31'),
(380, 4, 119, 'Sidi ech Chahmi', 'DZ', '31'),
(381, 4, 120, 'Djamaa', 'DZ', '30'),
(382, 4, 120, 'El Hadjira', 'DZ', '30'),
(383, 4, 120, 'Hassi Messaoud', 'DZ', '30'),
(384, 4, 120, 'Megarine', 'DZ', '30'),
(385, 4, 120, 'Ouargla', 'DZ', '30'),
(386, 4, 120, 'Rouissat', 'DZ', '30'),
(387, 4, 120, 'Sidi Amrane', 'DZ', '30'),
(388, 4, 120, 'Tebesbest', 'DZ', '30'),
(389, 4, 120, 'Touggourt', 'DZ', '30'),
(390, 4, 122, 'Aïn Beïda', 'DZ', '04'),
(391, 4, 122, 'Aïn Fakroun', 'DZ', '04'),
(392, 4, 122, 'Aïn Kercha', 'DZ', '04'),
(393, 4, 122, 'El Aouinet', 'DZ', '04'),
(394, 4, 122, 'Meskiana', 'DZ', '04'),
(395, 4, 122, 'Oum el Bouaghi', 'DZ', '04'),
(396, 4, 123, '’Aïn Merane', 'DZ', '48'),
(397, 4, 123, 'Ammi Moussa', 'DZ', '48'),
(398, 4, 123, 'Djidiouia', 'DZ', '48'),
(399, 4, 123, 'Mazouna', 'DZ', '48'),
(400, 4, 123, 'Oued Rhiou', 'DZ', '48'),
(401, 4, 123, 'Relizane', 'DZ', '48'),
(402, 4, 123, 'Smala', 'DZ', '48'),
(403, 4, 123, 'Zemoura', 'DZ', '48'),
(404, 4, 124, '’Aïn el Hadjar', 'DZ', '20'),
(405, 4, 124, 'Saïda', 'DZ', '20'),
(406, 4, 125, 'Aïn Arnat', 'DZ', '19'),
(407, 4, 125, 'BABOR - VILLE', 'DZ', '19'),
(408, 4, 125, 'Bougaa', 'DZ', '19'),
(409, 4, 125, 'El Eulma', 'DZ', '19'),
(410, 4, 125, 'Salah Bey', 'DZ', '19'),
(411, 4, 125, 'Sétif', 'DZ', '19'),
(412, 4, 126, 'Aïn El Berd District', 'DZ', '22'),
(413, 4, 126, 'Balidat Ameur', 'DZ', '22'),
(414, 4, 126, 'Belarbi', 'DZ', '22'),
(415, 4, 126, 'Ben Badis Sid Bel Abbés', 'DZ', '22'),
(416, 4, 126, 'Djamaa', 'DZ', '22'),
(417, 4, 126, 'El Bour', 'DZ', '22'),
(418, 4, 126, 'El Hadjira', 'DZ', '22'),
(419, 4, 126, 'Haoud El Hamra', 'DZ', '22'),
(420, 4, 126, 'Hassi Messaoud', 'DZ', '22'),
(421, 4, 126, 'Lamtar', 'DZ', '22'),
(422, 4, 126, 'Marhoum', 'DZ', '22'),
(423, 4, 126, 'Megarine', 'DZ', '22'),
(424, 4, 126, 'Merine', 'DZ', '22'),
(425, 4, 126, 'Mezaourou', 'DZ', '22'),
(426, 4, 126, 'Moggar', 'DZ', '22'),
(427, 4, 126, 'Moulay Slissen', 'DZ', '22'),
(428, 4, 126, 'N\'Goussa', 'DZ', '22'),
(429, 4, 126, 'Ouargla', 'DZ', '22'),
(430, 4, 126, 'Rouissat', 'DZ', '22'),
(431, 4, 126, 'Sfissef', 'DZ', '22'),
(432, 4, 126, 'Sidi Ali Boussidi', 'DZ', '22'),
(433, 4, 126, 'Sidi Amrane', 'DZ', '22'),
(434, 4, 126, 'Sidi Bel Abbès', 'DZ', '22'),
(435, 4, 126, 'Sidi Brahim', 'DZ', '22'),
(436, 4, 126, 'Sidi Hamadouche', 'DZ', '22'),
(437, 4, 126, 'Sidi Slimane', 'DZ', '22'),
(438, 4, 126, 'Sidi Yacoub', 'DZ', '22'),
(439, 4, 126, 'Sidi Yahia', 'DZ', '22'),
(440, 4, 126, 'Tabia Sid Bel Abbés', 'DZ', '22'),
(441, 4, 126, 'Taibet', 'DZ', '22'),
(442, 4, 126, 'Tamellaht', 'DZ', '22'),
(443, 4, 126, 'Tamerna Djedida', 'DZ', '22'),
(444, 4, 126, 'Tebesbest', 'DZ', '22'),
(445, 4, 126, 'Teghalimet', 'DZ', '22'),
(446, 4, 126, 'Telagh', 'DZ', '22'),
(447, 4, 126, 'Tenezara', 'DZ', '22'),
(448, 4, 126, 'Tenira', 'DZ', '22'),
(449, 4, 126, 'Tessala', 'DZ', '22'),
(450, 4, 126, 'Touggourt', 'DZ', '22'),
(451, 4, 126, 'Zerouala', 'DZ', '22'),
(452, 4, 127, 'Azzaba', 'DZ', '21'),
(453, 4, 127, 'Karkira', 'DZ', '21'),
(454, 4, 127, 'Skikda', 'DZ', '21'),
(455, 4, 127, 'Tamalous', 'DZ', '21'),
(456, 4, 128, 'Sedrata', 'DZ', '41'),
(457, 4, 128, 'Souk Ahras', 'DZ', '41'),
(458, 4, 129, 'I-n-Salah', 'DZ', '11'),
(459, 4, 129, 'Tamanrasset', 'DZ', '11'),
(460, 4, 130, 'Bir el Ater', 'DZ', '12'),
(461, 4, 130, 'Cheria', 'DZ', '12'),
(462, 4, 130, 'Hammamet', 'DZ', '12'),
(463, 4, 130, 'Tébessa', 'DZ', '12'),
(464, 4, 131, '’Aïn Deheb', 'DZ', '14'),
(465, 4, 131, 'Djebilet Rosfa', 'DZ', '14'),
(466, 4, 131, 'Frenda', 'DZ', '14'),
(467, 4, 131, 'Ksar Chellala', 'DZ', '14'),
(468, 4, 131, 'Mehdia daira de meghila', 'DZ', '14'),
(469, 4, 131, 'Sougueur', 'DZ', '14'),
(470, 4, 131, 'Tiaret', 'DZ', '14'),
(471, 4, 133, 'Tindouf', 'DZ', '37'),
(472, 4, 134, '’Aïn Benian', 'DZ', '42'),
(473, 4, 134, 'Baraki', 'DZ', '42'),
(474, 4, 134, 'Bou Ismaïl', 'DZ', '42'),
(475, 4, 134, 'Cheraga', 'DZ', '42'),
(476, 4, 134, 'Douera', 'DZ', '42'),
(477, 4, 134, 'El Affroun', 'DZ', '42'),
(478, 4, 134, 'Hadjout', 'DZ', '42'),
(479, 4, 134, 'Kolea', 'DZ', '42'),
(480, 4, 134, 'Mouzaïa', 'DZ', '42'),
(481, 4, 134, 'Oued el Alleug', 'DZ', '42'),
(482, 4, 134, 'Saoula', 'DZ', '42'),
(483, 4, 134, 'Tipasa', 'DZ', '42'),
(484, 4, 134, 'Zeralda', 'DZ', '42'),
(485, 4, 135, 'Lardjem', 'DZ', '38'),
(486, 4, 135, 'Tissemsilt', 'DZ', '38'),
(487, 4, 136, '’Aïn el Hammam', 'DZ', '15'),
(488, 4, 136, 'Arhribs', 'DZ', '15'),
(489, 4, 136, 'Azazga', 'DZ', '15'),
(490, 4, 136, 'Beni Douala', 'DZ', '15'),
(491, 4, 136, 'Boghni', 'DZ', '15'),
(492, 4, 136, 'Boudjima', 'DZ', '15'),
(493, 4, 136, 'Chemini', 'DZ', '15'),
(494, 4, 136, 'Draa Ben Khedda', 'DZ', '15'),
(495, 4, 136, 'Freha', 'DZ', '15'),
(496, 4, 136, 'Ighram', 'DZ', '15'),
(497, 4, 136, 'L’Arbaa Naït Irathen', 'DZ', '15'),
(498, 4, 136, 'Mekla', 'DZ', '15'),
(499, 4, 136, 'Timizart', 'DZ', '15'),
(500, 4, 136, 'Tirmitine', 'DZ', '15');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(501, 4, 136, 'Tizi Ouzou', 'DZ', '15'),
(502, 4, 136, 'Tizi Rached', 'DZ', '15'),
(503, 4, 136, 'Tizi-n-Tleta', 'DZ', '15'),
(504, 4, 137, 'Beni Mester', 'DZ', '13'),
(505, 4, 137, 'Bensekrane', 'DZ', '13'),
(506, 4, 137, 'Chetouane', 'DZ', '13'),
(507, 4, 137, 'Hennaya', 'DZ', '13'),
(508, 4, 137, 'Mansoûra', 'DZ', '13'),
(509, 4, 137, 'Nedroma', 'DZ', '13'),
(510, 4, 137, 'Ouled Mimoun', 'DZ', '13'),
(511, 4, 137, 'Remchi', 'DZ', '13'),
(512, 4, 137, 'Sebdou', 'DZ', '13'),
(513, 4, 137, 'Sidi Abdelli', 'DZ', '13'),
(514, 4, 137, 'Sidi Senoussi سيدي سنوسي', 'DZ', '13'),
(515, 4, 137, 'Tlemcen', 'DZ', '13'),
(516, 6, 139, 'Andorra la Vella', 'AD', '07'),
(517, 6, 140, 'Canillo', 'AD', '02'),
(518, 6, 140, 'El Tarter', 'AD', '02'),
(519, 6, 141, 'Encamp', 'AD', '03'),
(520, 6, 141, 'Pas de la Casa', 'AD', '03'),
(521, 6, 142, 'les Escaldes', 'AD', '08'),
(522, 6, 143, 'Arinsal', 'AD', '04'),
(523, 6, 143, 'la Massana', 'AD', '04'),
(524, 6, 144, 'Ordino', 'AD', '05'),
(525, 6, 145, 'Sant Julià de Lòria', 'AD', '06'),
(526, 7, 146, 'Caxito', 'AO', 'BGO'),
(527, 7, 147, 'Benguela', 'AO', 'BGU'),
(528, 7, 147, 'Catumbela', 'AO', 'BGU'),
(529, 7, 147, 'Lobito', 'AO', 'BGU'),
(530, 7, 148, 'Camacupa', 'AO', 'BIE'),
(531, 7, 148, 'Catabola', 'AO', 'BIE'),
(532, 7, 148, 'Chissamba', 'AO', 'BIE'),
(533, 7, 148, 'Cuito', 'AO', 'BIE'),
(534, 7, 149, 'Cabinda', 'AO', 'CAB'),
(535, 7, 150, 'Menongue', 'AO', 'CCU'),
(536, 7, 151, 'Camabatela', 'AO', 'CNO'),
(537, 7, 151, 'N’dalatando', 'AO', 'CNO'),
(538, 7, 152, 'Quibala', 'AO', 'CUS'),
(539, 7, 152, 'Sumbe', 'AO', 'CUS'),
(540, 7, 152, 'Uacu Cungo', 'AO', 'CUS'),
(541, 7, 153, 'Ondjiva', 'AO', 'CNN'),
(542, 7, 154, 'Caála', 'AO', 'HUA'),
(543, 7, 154, 'Chela', 'AO', 'HUA'),
(544, 7, 154, 'Huambo', 'AO', 'HUA'),
(545, 7, 154, 'Longonjo', 'AO', 'HUA'),
(546, 7, 155, 'Caconda', 'AO', 'HUI'),
(547, 7, 155, 'Caluquembe', 'AO', 'HUI'),
(548, 7, 155, 'Chibia', 'AO', 'HUI'),
(549, 7, 155, 'Chicomba', 'AO', 'HUI'),
(550, 7, 155, 'Chipindo', 'AO', 'HUI'),
(551, 7, 155, 'Cuvango', 'AO', 'HUI'),
(552, 7, 155, 'Gambos', 'AO', 'HUI'),
(553, 7, 155, 'Humpata', 'AO', 'HUI'),
(554, 7, 155, 'Jamba', 'AO', 'HUI'),
(555, 7, 155, 'Lubango', 'AO', 'HUI'),
(556, 7, 155, 'Matala', 'AO', 'HUI'),
(557, 7, 155, 'Quilengues', 'AO', 'HUI'),
(558, 7, 155, 'Quipungo', 'AO', 'HUI'),
(559, 7, 156, 'Belas', 'AO', 'LUA'),
(560, 7, 156, 'Icolo e Bengo', 'AO', 'LUA'),
(561, 7, 156, 'Luanda', 'AO', 'LUA'),
(562, 7, 157, 'Lucapa', 'AO', 'LNO'),
(563, 7, 158, 'Cazaji', 'AO', 'LSU'),
(564, 7, 158, 'Saurimo', 'AO', 'LSU'),
(565, 7, 159, 'Malanje', 'AO', 'MAL'),
(566, 7, 160, 'Léua', 'AO', 'MOX'),
(567, 7, 160, 'Luau', 'AO', 'MOX'),
(568, 7, 160, 'Luena', 'AO', 'MOX'),
(569, 7, 160, 'Lumeje', 'AO', 'MOX'),
(570, 7, 161, 'Uíge', 'AO', 'UIG'),
(571, 7, 162, 'Mbanza Congo', 'AO', 'ZAI'),
(572, 7, 162, 'N\'zeto', 'AO', 'ZAI'),
(573, 7, 162, 'Soio', 'AO', 'ZAI'),
(574, 10, 163, 'Codrington', 'AG', '10'),
(575, 10, 165, 'Piggotts', 'AG', '03'),
(576, 10, 166, 'Potters Village', 'AG', '04'),
(577, 10, 166, 'Saint John’s', 'AG', '04'),
(578, 10, 167, 'Bolands', 'AG', '05'),
(579, 10, 168, 'Falmouth', 'AG', '06'),
(580, 10, 168, 'Liberta', 'AG', '06'),
(581, 10, 169, 'All Saints', 'AG', '07'),
(582, 10, 169, 'Parham', 'AG', '07'),
(583, 11, 171, 'Balvanera', 'AR', 'B'),
(584, 11, 171, 'Barracas', 'AR', 'B'),
(585, 11, 171, 'Belgrano', 'AR', 'B'),
(586, 11, 171, 'Boedo', 'AR', 'B'),
(587, 11, 171, 'Buenos Aires', 'AR', 'B'),
(588, 11, 171, 'Colegiales', 'AR', 'B'),
(589, 11, 171, 'Retiro', 'AR', 'B'),
(590, 11, 171, 'Villa Lugano', 'AR', 'B'),
(591, 11, 171, 'Villa Ortúzar', 'AR', 'B'),
(592, 11, 171, 'Villa Santa Rita', 'AR', 'B'),
(593, 11, 172, 'Ancasti', 'AR', 'K'),
(594, 11, 172, 'Andalgalá', 'AR', 'K'),
(595, 11, 172, 'Antofagasta de la Sierra', 'AR', 'K'),
(596, 11, 172, 'Capayán', 'AR', 'K'),
(597, 11, 172, 'Departamento de Ambato', 'AR', 'K'),
(598, 11, 172, 'Departamento de Ancasti', 'AR', 'K'),
(599, 11, 172, 'Departamento de Andalgalá', 'AR', 'K'),
(600, 11, 172, 'Departamento de Antofagasta de la Sierra', 'AR', 'K'),
(601, 11, 172, 'Departamento de Capayán', 'AR', 'K'),
(602, 11, 172, 'Departamento de Capital', 'AR', 'K'),
(603, 11, 172, 'Departamento de El Alto', 'AR', 'K'),
(604, 11, 172, 'Departamento de Fray Mamerto Esquiú', 'AR', 'K'),
(605, 11, 172, 'Departamento de La Paz', 'AR', 'K'),
(606, 11, 172, 'Departamento de Pomán', 'AR', 'K'),
(607, 11, 172, 'Departamento de Santa María', 'AR', 'K'),
(608, 11, 172, 'Departamento de Santa Rosa', 'AR', 'K'),
(609, 11, 172, 'Departamento de Tinogasta', 'AR', 'K'),
(610, 11, 172, 'Departamento de Valle Viejo', 'AR', 'K'),
(611, 11, 172, 'El Rodeo', 'AR', 'K'),
(612, 11, 172, 'Fiambalá', 'AR', 'K'),
(613, 11, 172, 'Hualfín', 'AR', 'K'),
(614, 11, 172, 'Huillapima', 'AR', 'K'),
(615, 11, 172, 'Icaño', 'AR', 'K'),
(616, 11, 172, 'La Puerta de San José', 'AR', 'K'),
(617, 11, 172, 'Londres', 'AR', 'K'),
(618, 11, 172, 'Los Altos', 'AR', 'K'),
(619, 11, 172, 'Los Varela', 'AR', 'K'),
(620, 11, 172, 'Mutquín', 'AR', 'K'),
(621, 11, 172, 'Pomán', 'AR', 'K'),
(622, 11, 172, 'Puerta de Corral Quemado', 'AR', 'K'),
(623, 11, 172, 'Recreo', 'AR', 'K'),
(624, 11, 172, 'San Antonio', 'AR', 'K'),
(625, 11, 172, 'San Fernando del Valle de Catamarca', 'AR', 'K'),
(626, 11, 172, 'Santa María', 'AR', 'K'),
(627, 11, 172, 'Tinogasta', 'AR', 'K'),
(628, 11, 173, 'Aviá Terai', 'AR', 'H'),
(629, 11, 173, 'Barranqueras', 'AR', 'H'),
(630, 11, 173, 'Basail', 'AR', 'H'),
(631, 11, 173, 'Campo Largo', 'AR', 'H'),
(632, 11, 173, 'Capitán Solari', 'AR', 'H'),
(633, 11, 173, 'Castelli', 'AR', 'H'),
(634, 11, 173, 'Charadai', 'AR', 'H'),
(635, 11, 173, 'Charata', 'AR', 'H'),
(636, 11, 173, 'Chorotis', 'AR', 'H'),
(637, 11, 173, 'Ciervo Petiso', 'AR', 'H'),
(638, 11, 173, 'Colonia Benítez', 'AR', 'H'),
(639, 11, 173, 'Colonia Elisa', 'AR', 'H'),
(640, 11, 173, 'Colonias Unidas', 'AR', 'H'),
(641, 11, 173, 'Concepción del Bermejo', 'AR', 'H'),
(642, 11, 173, 'Coronel Du Graty', 'AR', 'H'),
(643, 11, 173, 'Corzuela', 'AR', 'H'),
(644, 11, 173, 'Coté-Lai', 'AR', 'H'),
(645, 11, 173, 'Departamento de Almirante Brown', 'AR', 'H'),
(646, 11, 173, 'Departamento de Bermejo', 'AR', 'H'),
(647, 11, 173, 'Departamento de Comandante Fernández', 'AR', 'H'),
(648, 11, 173, 'Departamento de Doce de Octubre', 'AR', 'H'),
(649, 11, 173, 'Departamento de Dos de Abril', 'AR', 'H'),
(650, 11, 173, 'Departamento de General Donovan', 'AR', 'H'),
(651, 11, 173, 'Departamento de General Güemes', 'AR', 'H'),
(652, 11, 173, 'Departamento de Independencia', 'AR', 'H'),
(653, 11, 173, 'Departamento de Libertad', 'AR', 'H'),
(654, 11, 173, 'Departamento de Maipú', 'AR', 'H'),
(655, 11, 173, 'Departamento de Nueve de Julio', 'AR', 'H'),
(656, 11, 173, 'Departamento de O’Higgins', 'AR', 'H'),
(657, 11, 173, 'Departamento de Presidencia de la Plaza', 'AR', 'H'),
(658, 11, 173, 'Departamento de Quitilipi', 'AR', 'H'),
(659, 11, 173, 'Departamento de San Fernando', 'AR', 'H'),
(660, 11, 173, 'Departamento de San Lorenzo', 'AR', 'H'),
(661, 11, 173, 'Departamento de Sargento Cabral', 'AR', 'H'),
(662, 11, 173, 'Departamento de Tapenagá', 'AR', 'H'),
(663, 11, 173, 'Fontana', 'AR', 'H'),
(664, 11, 173, 'Gancedo', 'AR', 'H'),
(665, 11, 173, 'General José de San Martín', 'AR', 'H'),
(666, 11, 173, 'General Pinedo', 'AR', 'H'),
(667, 11, 173, 'General Vedia', 'AR', 'H'),
(668, 11, 173, 'Hermoso Campo', 'AR', 'H'),
(669, 11, 173, 'La Clotilde', 'AR', 'H'),
(670, 11, 173, 'La Eduvigis', 'AR', 'H'),
(671, 11, 173, 'La Escondida', 'AR', 'H'),
(672, 11, 173, 'La Leonesa', 'AR', 'H'),
(673, 11, 173, 'La Tigra', 'AR', 'H'),
(674, 11, 173, 'La Verde', 'AR', 'H'),
(675, 11, 173, 'Laguna Limpia', 'AR', 'H'),
(676, 11, 173, 'Lapachito', 'AR', 'H'),
(677, 11, 173, 'Las Breñas', 'AR', 'H'),
(678, 11, 173, 'Las Garcitas', 'AR', 'H'),
(679, 11, 173, 'Los Frentones', 'AR', 'H'),
(680, 11, 173, 'Machagai', 'AR', 'H'),
(681, 11, 173, 'Makallé', 'AR', 'H'),
(682, 11, 173, 'Margarita Belén', 'AR', 'H'),
(683, 11, 173, 'Napenay', 'AR', 'H'),
(684, 11, 173, 'Pampa Almirón', 'AR', 'H'),
(685, 11, 173, 'Pampa del Indio', 'AR', 'H'),
(686, 11, 173, 'Pampa del Infierno', 'AR', 'H'),
(687, 11, 173, 'Presidencia de la Plaza', 'AR', 'H'),
(688, 11, 173, 'Presidencia Roca', 'AR', 'H'),
(689, 11, 173, 'Presidencia Roque Sáenz Peña', 'AR', 'H'),
(690, 11, 173, 'Puerto Bermejo', 'AR', 'H'),
(691, 11, 173, 'Puerto Tirol', 'AR', 'H'),
(692, 11, 173, 'Puerto Vilelas', 'AR', 'H'),
(693, 11, 173, 'Quitilipi', 'AR', 'H'),
(694, 11, 173, 'Resistencia', 'AR', 'H'),
(695, 11, 173, 'Samuhú', 'AR', 'H'),
(696, 11, 173, 'San Bernardo', 'AR', 'H'),
(697, 11, 173, 'Santa Sylvina', 'AR', 'H'),
(698, 11, 173, 'Taco Pozo', 'AR', 'H'),
(699, 11, 173, 'Tres Isletas', 'AR', 'H'),
(700, 11, 173, 'Villa Ángela', 'AR', 'H'),
(701, 11, 173, 'Villa Berthet', 'AR', 'H'),
(702, 11, 174, 'Alto Río Senguer', 'AR', 'U'),
(703, 11, 174, 'Camarones', 'AR', 'U'),
(704, 11, 174, 'Comodoro Rivadavia', 'AR', 'U'),
(705, 11, 174, 'Departamento de Biedma', 'AR', 'U'),
(706, 11, 174, 'Departamento de Cushamen', 'AR', 'U'),
(707, 11, 174, 'Departamento de Escalante', 'AR', 'U'),
(708, 11, 174, 'Departamento de Florentino Ameghino', 'AR', 'U'),
(709, 11, 174, 'Departamento de Futaleufú', 'AR', 'U'),
(710, 11, 174, 'Departamento de Gaimán', 'AR', 'U'),
(711, 11, 174, 'Departamento de Gastre', 'AR', 'U'),
(712, 11, 174, 'Departamento de Languiñeo', 'AR', 'U'),
(713, 11, 174, 'Departamento de Mártires', 'AR', 'U'),
(714, 11, 174, 'Departamento de Paso de Indios', 'AR', 'U'),
(715, 11, 174, 'Departamento de Rawson', 'AR', 'U'),
(716, 11, 174, 'Departamento de Río Senguerr', 'AR', 'U'),
(717, 11, 174, 'Departamento de Sarmiento', 'AR', 'U'),
(718, 11, 174, 'Departamento de Tehuelches', 'AR', 'U'),
(719, 11, 174, 'Departamento de Telsen', 'AR', 'U'),
(720, 11, 174, 'Dolavón', 'AR', 'U'),
(721, 11, 174, 'El Maitén', 'AR', 'U'),
(722, 11, 174, 'Esquel', 'AR', 'U'),
(723, 11, 174, 'Gaimán', 'AR', 'U'),
(724, 11, 174, 'Gastre', 'AR', 'U'),
(725, 11, 174, 'Gobernador Costa', 'AR', 'U'),
(726, 11, 174, 'Hoyo de Epuyén', 'AR', 'U'),
(727, 11, 174, 'José de San Martín', 'AR', 'U'),
(728, 11, 174, 'Lago Puelo', 'AR', 'U'),
(729, 11, 174, 'Las Plumas', 'AR', 'U'),
(730, 11, 174, 'Puerto Madryn', 'AR', 'U'),
(731, 11, 174, 'Rada Tilly', 'AR', 'U'),
(732, 11, 174, 'Rawson', 'AR', 'U'),
(733, 11, 174, 'Río Mayo', 'AR', 'U'),
(734, 11, 174, 'Río Pico', 'AR', 'U'),
(735, 11, 174, 'Sarmiento', 'AR', 'U'),
(736, 11, 174, 'Tecka', 'AR', 'U'),
(737, 11, 174, 'Trelew', 'AR', 'U'),
(738, 11, 174, 'Trevelin', 'AR', 'U'),
(739, 11, 176, 'Achiras', 'AR', 'X'),
(740, 11, 176, 'Adelia María', 'AR', 'X'),
(741, 11, 176, 'Agua de Oro', 'AR', 'X'),
(742, 11, 176, 'Alejandro Roca', 'AR', 'X'),
(743, 11, 176, 'Alejo Ledesma', 'AR', 'X'),
(744, 11, 176, 'Almafuerte', 'AR', 'X'),
(745, 11, 176, 'Alta Gracia', 'AR', 'X'),
(746, 11, 176, 'Altos de Chipión', 'AR', 'X'),
(747, 11, 176, 'Arias', 'AR', 'X'),
(748, 11, 176, 'Arroyito', 'AR', 'X'),
(749, 11, 176, 'Arroyo Cabral', 'AR', 'X'),
(750, 11, 176, 'Balnearia', 'AR', 'X'),
(751, 11, 176, 'Bell Ville', 'AR', 'X'),
(752, 11, 176, 'Berrotarán', 'AR', 'X'),
(753, 11, 176, 'Brinkmann', 'AR', 'X'),
(754, 11, 176, 'Buchardo', 'AR', 'X'),
(755, 11, 176, 'Camilo Aldao', 'AR', 'X'),
(756, 11, 176, 'Cañada de Luque', 'AR', 'X'),
(757, 11, 176, 'Canals', 'AR', 'X'),
(758, 11, 176, 'Capilla del Monte', 'AR', 'X'),
(759, 11, 176, 'Carnerillo', 'AR', 'X'),
(760, 11, 176, 'Carrilobo', 'AR', 'X'),
(761, 11, 176, 'Cavanagh', 'AR', 'X'),
(762, 11, 176, 'Charras', 'AR', 'X'),
(763, 11, 176, 'Chazón', 'AR', 'X'),
(764, 11, 176, 'Cintra', 'AR', 'X'),
(765, 11, 176, 'Colonia La Tordilla', 'AR', 'X'),
(766, 11, 176, 'Colonia San Bartolomé', 'AR', 'X'),
(767, 11, 176, 'Córdoba', 'AR', 'X'),
(768, 11, 176, 'Coronel Baigorria', 'AR', 'X'),
(769, 11, 176, 'Coronel Moldes', 'AR', 'X'),
(770, 11, 176, 'Corral de Bustos', 'AR', 'X'),
(771, 11, 176, 'Corralito', 'AR', 'X'),
(772, 11, 176, 'Cosquín', 'AR', 'X'),
(773, 11, 176, 'Costa Sacate', 'AR', 'X'),
(774, 11, 176, 'Cruz Alta', 'AR', 'X'),
(775, 11, 176, 'Cruz del Eje', 'AR', 'X'),
(776, 11, 176, 'Cuesta Blanca', 'AR', 'X'),
(777, 11, 176, 'Dalmacio Vélez Sársfield', 'AR', 'X'),
(778, 11, 176, 'Deán Funes', 'AR', 'X'),
(779, 11, 176, 'Del Campillo', 'AR', 'X'),
(780, 11, 176, 'Departamento de Calamuchita', 'AR', 'X'),
(781, 11, 176, 'Departamento de Colón', 'AR', 'X'),
(782, 11, 176, 'Departamento de Cruz del Eje', 'AR', 'X'),
(783, 11, 176, 'Departamento de General Roca', 'AR', 'X'),
(784, 11, 176, 'Departamento de General San Martín', 'AR', 'X'),
(785, 11, 176, 'Departamento de Juárez Celman', 'AR', 'X'),
(786, 11, 176, 'Departamento de Marcos Juárez', 'AR', 'X'),
(787, 11, 176, 'Departamento de Minas', 'AR', 'X'),
(788, 11, 176, 'Departamento de Presidente Roque Sáenz Peña', 'AR', 'X'),
(789, 11, 176, 'Departamento de Río Cuarto', 'AR', 'X'),
(790, 11, 176, 'Departamento de Río Primero', 'AR', 'X'),
(791, 11, 176, 'Departamento de Río Seco', 'AR', 'X'),
(792, 11, 176, 'Departamento de Río Segundo', 'AR', 'X'),
(793, 11, 176, 'Departamento de San Alberto', 'AR', 'X'),
(794, 11, 176, 'Departamento de San Javier', 'AR', 'X'),
(795, 11, 176, 'Departamento de San Justo', 'AR', 'X'),
(796, 11, 176, 'Departamento de Sobremonte', 'AR', 'X'),
(797, 11, 176, 'Departamento de Totoral', 'AR', 'X'),
(798, 11, 176, 'Departamento de Tulumba', 'AR', 'X'),
(799, 11, 176, 'Departamento de Unión', 'AR', 'X'),
(800, 11, 176, 'Despeñaderos', 'AR', 'X'),
(801, 11, 176, 'Devoto', 'AR', 'X'),
(802, 11, 176, 'El Arañado', 'AR', 'X'),
(803, 11, 176, 'El Tío', 'AR', 'X'),
(804, 11, 176, 'Elena', 'AR', 'X'),
(805, 11, 176, 'Embalse', 'AR', 'X'),
(806, 11, 176, 'Etruria', 'AR', 'X'),
(807, 11, 176, 'General Baldissera', 'AR', 'X'),
(808, 11, 176, 'General Cabrera', 'AR', 'X'),
(809, 11, 176, 'General Levalle', 'AR', 'X'),
(810, 11, 176, 'General Roca', 'AR', 'X'),
(811, 11, 176, 'Guatimozín', 'AR', 'X'),
(812, 11, 176, 'Hernando', 'AR', 'X'),
(813, 11, 176, 'Huanchillas', 'AR', 'X'),
(814, 11, 176, 'Huerta Grande', 'AR', 'X'),
(815, 11, 176, 'Huinca Renancó', 'AR', 'X'),
(816, 11, 176, 'Idiazábal', 'AR', 'X'),
(817, 11, 176, 'Inriville', 'AR', 'X'),
(818, 11, 176, 'Isla Verde', 'AR', 'X'),
(819, 11, 176, 'Italó', 'AR', 'X'),
(820, 11, 176, 'James Craik', 'AR', 'X'),
(821, 11, 176, 'Jesús María', 'AR', 'X'),
(822, 11, 176, 'Justiniano Posse', 'AR', 'X'),
(823, 11, 176, 'La Calera', 'AR', 'X'),
(824, 11, 176, 'La Carlota', 'AR', 'X'),
(825, 11, 176, 'La Cesira', 'AR', 'X'),
(826, 11, 176, 'La Cumbre', 'AR', 'X'),
(827, 11, 176, 'La Falda', 'AR', 'X'),
(828, 11, 176, 'La Francia', 'AR', 'X'),
(829, 11, 176, 'La Granja', 'AR', 'X'),
(830, 11, 176, 'La Para', 'AR', 'X'),
(831, 11, 176, 'La Playosa', 'AR', 'X'),
(832, 11, 176, 'Laborde', 'AR', 'X'),
(833, 11, 176, 'Laboulaye', 'AR', 'X'),
(834, 11, 176, 'Laguna Larga', 'AR', 'X'),
(835, 11, 176, 'Las Acequias', 'AR', 'X'),
(836, 11, 176, 'Las Higueras', 'AR', 'X'),
(837, 11, 176, 'Las Junturas', 'AR', 'X'),
(838, 11, 176, 'Las Perdices', 'AR', 'X'),
(839, 11, 176, 'Las Varas', 'AR', 'X'),
(840, 11, 176, 'Las Varillas', 'AR', 'X'),
(841, 11, 176, 'Leones', 'AR', 'X'),
(842, 11, 176, 'Los Cocos', 'AR', 'X'),
(843, 11, 176, 'Los Cóndores', 'AR', 'X'),
(844, 11, 176, 'Los Surgentes', 'AR', 'X'),
(845, 11, 176, 'Malagueño', 'AR', 'X'),
(846, 11, 176, 'Malvinas Argentinas', 'AR', 'X'),
(847, 11, 176, 'Marcos Juárez', 'AR', 'X'),
(848, 11, 176, 'Marull', 'AR', 'X'),
(849, 11, 176, 'Mattaldi', 'AR', 'X'),
(850, 11, 176, 'Mendiolaza', 'AR', 'X'),
(851, 11, 176, 'Mina Clavero', 'AR', 'X'),
(852, 11, 176, 'Miramar', 'AR', 'X'),
(853, 11, 176, 'Monte Buey', 'AR', 'X'),
(854, 11, 176, 'Monte Cristo', 'AR', 'X'),
(855, 11, 176, 'Monte Maíz', 'AR', 'X'),
(856, 11, 176, 'Morrison', 'AR', 'X'),
(857, 11, 176, 'Morteros', 'AR', 'X'),
(858, 11, 176, 'Noetinger', 'AR', 'X'),
(859, 11, 176, 'Obispo Trejo', 'AR', 'X'),
(860, 11, 176, 'Oliva', 'AR', 'X'),
(861, 11, 176, 'Oncativo', 'AR', 'X'),
(862, 11, 176, 'Ordóñez', 'AR', 'X'),
(863, 11, 176, 'Pascanas', 'AR', 'X'),
(864, 11, 176, 'Pasco', 'AR', 'X'),
(865, 11, 176, 'Pilar', 'AR', 'X'),
(866, 11, 176, 'Piquillín', 'AR', 'X'),
(867, 11, 176, 'Porteña', 'AR', 'X'),
(868, 11, 176, 'Pozo del Molle', 'AR', 'X'),
(869, 11, 176, 'Quilino', 'AR', 'X'),
(870, 11, 176, 'Río Ceballos', 'AR', 'X'),
(871, 11, 176, 'Río Cuarto', 'AR', 'X'),
(872, 11, 176, 'Río Segundo', 'AR', 'X'),
(873, 11, 176, 'Río Tercero', 'AR', 'X'),
(874, 11, 176, 'Sacanta', 'AR', 'X'),
(875, 11, 176, 'Saldán', 'AR', 'X'),
(876, 11, 176, 'Salsacate', 'AR', 'X'),
(877, 11, 176, 'Salsipuedes', 'AR', 'X'),
(878, 11, 176, 'Sampacho', 'AR', 'X'),
(879, 11, 176, 'San Agustín', 'AR', 'X'),
(880, 11, 176, 'San Antonio de Litín', 'AR', 'X'),
(881, 11, 176, 'San Basilio', 'AR', 'X'),
(882, 11, 176, 'San Carlos', 'AR', 'X'),
(883, 11, 176, 'San Francisco', 'AR', 'X'),
(884, 11, 176, 'San Francisco del Chañar', 'AR', 'X'),
(885, 11, 176, 'San José de la Dormida', 'AR', 'X'),
(886, 11, 176, 'Santa Eufemia', 'AR', 'X'),
(887, 11, 176, 'Santa Magdalena', 'AR', 'X'),
(888, 11, 176, 'Santa Rosa de Calamuchita', 'AR', 'X'),
(889, 11, 176, 'Santa Rosa de Río Primero', 'AR', 'X'),
(890, 11, 176, 'Santiago Temple', 'AR', 'X'),
(891, 11, 176, 'Saturnino M. Laspiur', 'AR', 'X'),
(892, 11, 176, 'Sebastián Elcano', 'AR', 'X'),
(893, 11, 176, 'Serrano', 'AR', 'X'),
(894, 11, 176, 'Serrezuela', 'AR', 'X'),
(895, 11, 176, 'Tancacha', 'AR', 'X'),
(896, 11, 176, 'Ticino', 'AR', 'X'),
(897, 11, 176, 'Tío Pujio', 'AR', 'X'),
(898, 11, 176, 'Toledo', 'AR', 'X'),
(899, 11, 176, 'Ucacha', 'AR', 'X'),
(900, 11, 176, 'Unquillo', 'AR', 'X'),
(901, 11, 176, 'Valle Hermoso', 'AR', 'X'),
(902, 11, 176, 'Viamonte', 'AR', 'X'),
(903, 11, 176, 'Vicuña Mackenna', 'AR', 'X'),
(904, 11, 176, 'Villa Allende', 'AR', 'X'),
(905, 11, 176, 'Villa Ascasubi', 'AR', 'X'),
(906, 11, 176, 'Villa Berna', 'AR', 'X'),
(907, 11, 176, 'Villa Carlos Paz', 'AR', 'X'),
(908, 11, 176, 'Villa Concepción del Tío', 'AR', 'X'),
(909, 11, 176, 'Villa Cura Brochero', 'AR', 'X'),
(910, 11, 176, 'Villa de Soto', 'AR', 'X'),
(911, 11, 176, 'Villa del Dique', 'AR', 'X'),
(912, 11, 176, 'Villa del Rosario', 'AR', 'X'),
(913, 11, 176, 'Villa del Totoral', 'AR', 'X'),
(914, 11, 176, 'Villa Dolores', 'AR', 'X'),
(915, 11, 176, 'Villa General Belgrano', 'AR', 'X'),
(916, 11, 176, 'Villa Giardino', 'AR', 'X'),
(917, 11, 176, 'Villa Huidobro', 'AR', 'X'),
(918, 11, 176, 'Villa Las Rosas', 'AR', 'X'),
(919, 11, 176, 'Villa María', 'AR', 'X'),
(920, 11, 176, 'Villa Nueva', 'AR', 'X'),
(921, 11, 176, 'Villa Reducción', 'AR', 'X'),
(922, 11, 176, 'Villa Rumipal', 'AR', 'X'),
(923, 11, 176, 'Villa Tulumba', 'AR', 'X'),
(924, 11, 176, 'Villa Valeria', 'AR', 'X'),
(925, 11, 176, 'Wenceslao Escalante', 'AR', 'X'),
(926, 11, 177, 'Alvear', 'AR', 'W'),
(927, 11, 177, 'Berón de Astrada', 'AR', 'W'),
(928, 11, 177, 'Bonpland', 'AR', 'W'),
(929, 11, 177, 'Chavarría', 'AR', 'W'),
(930, 11, 177, 'Concepción', 'AR', 'W'),
(931, 11, 177, 'Corrientes', 'AR', 'W'),
(932, 11, 177, 'Cruz de los Milagros', 'AR', 'W'),
(933, 11, 177, 'Curuzú Cuatiá', 'AR', 'W'),
(934, 11, 177, 'Departamento de Bella Vista', 'AR', 'W'),
(935, 11, 177, 'Departamento de Berón de Astrada', 'AR', 'W'),
(936, 11, 177, 'Departamento de Capital', 'AR', 'W'),
(937, 11, 177, 'Departamento de Concepción', 'AR', 'W'),
(938, 11, 177, 'Departamento de Curuzú Cuatiá', 'AR', 'W'),
(939, 11, 177, 'Departamento de Empedrado', 'AR', 'W'),
(940, 11, 177, 'Departamento de Esquina', 'AR', 'W'),
(941, 11, 177, 'Departamento de General Alvear', 'AR', 'W'),
(942, 11, 177, 'Departamento de General Paz', 'AR', 'W'),
(943, 11, 177, 'Departamento de Goya', 'AR', 'W'),
(944, 11, 177, 'Departamento de Itatí', 'AR', 'W'),
(945, 11, 177, 'Departamento de Ituzaingó', 'AR', 'W'),
(946, 11, 177, 'Departamento de Lavalle', 'AR', 'W'),
(947, 11, 177, 'Departamento de Mburucuyá', 'AR', 'W'),
(948, 11, 177, 'Departamento de Mercedes', 'AR', 'W'),
(949, 11, 177, 'Departamento de Monte Caseros', 'AR', 'W'),
(950, 11, 177, 'Departamento de Paso de los Libres', 'AR', 'W'),
(951, 11, 177, 'Departamento de Saladas', 'AR', 'W'),
(952, 11, 177, 'Departamento de San Cosme', 'AR', 'W'),
(953, 11, 177, 'Departamento de San Luis del Palmar', 'AR', 'W'),
(954, 11, 177, 'Departamento de San Martín', 'AR', 'W'),
(955, 11, 177, 'Departamento de San Miguel', 'AR', 'W'),
(956, 11, 177, 'Departamento de San Roque', 'AR', 'W'),
(957, 11, 177, 'Departamento de Santo Tomé', 'AR', 'W'),
(958, 11, 177, 'Departamento de Sauce', 'AR', 'W'),
(959, 11, 177, 'Empedrado', 'AR', 'W'),
(960, 11, 177, 'Esquina', 'AR', 'W'),
(961, 11, 177, 'Felipe Yofré', 'AR', 'W'),
(962, 11, 177, 'Garruchos', 'AR', 'W'),
(963, 11, 177, 'Gobernador Juan E. Martínez', 'AR', 'W'),
(964, 11, 177, 'Gobernador Virasora', 'AR', 'W'),
(965, 11, 177, 'Goya', 'AR', 'W'),
(966, 11, 177, 'Herlitzka', 'AR', 'W'),
(967, 11, 177, 'Itá Ibaté', 'AR', 'W'),
(968, 11, 177, 'Itatí', 'AR', 'W'),
(969, 11, 177, 'Ituzaingó', 'AR', 'W'),
(970, 11, 177, 'Juan Pujol', 'AR', 'W'),
(971, 11, 177, 'La Cruz', 'AR', 'W'),
(972, 11, 177, 'Libertad', 'AR', 'W'),
(973, 11, 177, 'Lomas de Vallejos', 'AR', 'W'),
(974, 11, 177, 'Loreto', 'AR', 'W'),
(975, 11, 177, 'Mariano I. Loza', 'AR', 'W'),
(976, 11, 177, 'Mburucuyá', 'AR', 'W'),
(977, 11, 177, 'Mercedes', 'AR', 'W'),
(978, 11, 177, 'Mocoretá', 'AR', 'W'),
(979, 11, 177, 'Monte Caseros', 'AR', 'W'),
(980, 11, 177, 'Nuestra Señora del Rosario de Caa Catí', 'AR', 'W'),
(981, 11, 177, 'Nueve de Julio', 'AR', 'W'),
(982, 11, 177, 'Palmar Grande', 'AR', 'W'),
(983, 11, 177, 'Paso de la Patria', 'AR', 'W'),
(984, 11, 177, 'Paso de los Libres', 'AR', 'W'),
(985, 11, 177, 'Pedro R. Fernández', 'AR', 'W'),
(986, 11, 177, 'Perugorría', 'AR', 'W'),
(987, 11, 177, 'Pueblo Libertador', 'AR', 'W'),
(988, 11, 177, 'Riachuelo', 'AR', 'W'),
(989, 11, 177, 'Saladas', 'AR', 'W'),
(990, 11, 177, 'San Carlos', 'AR', 'W'),
(991, 11, 177, 'San Cosme', 'AR', 'W'),
(992, 11, 177, 'San Lorenzo', 'AR', 'W'),
(993, 11, 177, 'San Luis del Palmar', 'AR', 'W'),
(994, 11, 177, 'San Miguel', 'AR', 'W'),
(995, 11, 177, 'Santa Lucía', 'AR', 'W'),
(996, 11, 177, 'Santa Rosa', 'AR', 'W'),
(997, 11, 177, 'Santo Tomé', 'AR', 'W'),
(998, 11, 177, 'Yapeyú', 'AR', 'W'),
(999, 11, 177, 'Yataity Calle', 'AR', 'W'),
(1000, 11, 178, 'Aldea San Antonio', 'AR', 'E');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(1001, 11, 178, 'Aranguren', 'AR', 'E'),
(1002, 11, 178, 'Bovril', 'AR', 'E'),
(1003, 11, 178, 'Caseros', 'AR', 'E'),
(1004, 11, 178, 'Ceibas', 'AR', 'E'),
(1005, 11, 178, 'Chajarí', 'AR', 'E'),
(1006, 11, 178, 'Colón', 'AR', 'E'),
(1007, 11, 178, 'Colonia Elía', 'AR', 'E'),
(1008, 11, 178, 'Concepción del Uruguay', 'AR', 'E'),
(1009, 11, 178, 'Concordia', 'AR', 'E'),
(1010, 11, 178, 'Conscripto Bernardi', 'AR', 'E'),
(1011, 11, 178, 'Crespo', 'AR', 'E'),
(1012, 11, 178, 'Departamento de Gualeguaychú', 'AR', 'E'),
(1013, 11, 178, 'Departamento de Paraná', 'AR', 'E'),
(1014, 11, 178, 'Diamante', 'AR', 'E'),
(1015, 11, 178, 'Domínguez', 'AR', 'E'),
(1016, 11, 178, 'Federación', 'AR', 'E'),
(1017, 11, 178, 'Federal', 'AR', 'E'),
(1018, 11, 178, 'General Campos', 'AR', 'E'),
(1019, 11, 178, 'General Galarza', 'AR', 'E'),
(1020, 11, 178, 'General Ramírez', 'AR', 'E'),
(1021, 11, 178, 'Gobernador Mansilla', 'AR', 'E'),
(1022, 11, 178, 'Gualeguay', 'AR', 'E'),
(1023, 11, 178, 'Gualeguaychú', 'AR', 'E'),
(1024, 11, 178, 'Hasenkamp', 'AR', 'E'),
(1025, 11, 178, 'Hernández', 'AR', 'E'),
(1026, 11, 178, 'Herrera', 'AR', 'E'),
(1027, 11, 178, 'La Criolla', 'AR', 'E'),
(1028, 11, 178, 'La Paz', 'AR', 'E'),
(1029, 11, 178, 'Larroque', 'AR', 'E'),
(1030, 11, 178, 'Los Charrúas', 'AR', 'E'),
(1031, 11, 178, 'Los Conquistadores', 'AR', 'E'),
(1032, 11, 178, 'Lucas González', 'AR', 'E'),
(1033, 11, 178, 'Maciá', 'AR', 'E'),
(1034, 11, 178, 'Nogoyá', 'AR', 'E'),
(1035, 11, 178, 'Oro Verde', 'AR', 'E'),
(1036, 11, 178, 'Paraná', 'AR', 'E'),
(1037, 11, 178, 'Piedras Blancas', 'AR', 'E'),
(1038, 11, 178, 'Pronunciamiento', 'AR', 'E'),
(1039, 11, 178, 'Puerto Ibicuy', 'AR', 'E'),
(1040, 11, 178, 'Puerto Yeruá', 'AR', 'E'),
(1041, 11, 178, 'Rosario del Tala', 'AR', 'E'),
(1042, 11, 178, 'San Benito', 'AR', 'E'),
(1043, 11, 178, 'San Gustavo', 'AR', 'E'),
(1044, 11, 178, 'San José de Feliciano', 'AR', 'E'),
(1045, 11, 178, 'San Justo', 'AR', 'E'),
(1046, 11, 178, 'San Salvador', 'AR', 'E'),
(1047, 11, 178, 'Santa Ana', 'AR', 'E'),
(1048, 11, 178, 'Santa Anita', 'AR', 'E'),
(1049, 11, 178, 'Santa Elena', 'AR', 'E'),
(1050, 11, 178, 'Sauce de Luna', 'AR', 'E'),
(1051, 11, 178, 'Seguí', 'AR', 'E'),
(1052, 11, 178, 'Tabossi', 'AR', 'E'),
(1053, 11, 178, 'Ubajay', 'AR', 'E'),
(1054, 11, 178, 'Urdinarrain', 'AR', 'E'),
(1055, 11, 178, 'Viale', 'AR', 'E'),
(1056, 11, 178, 'Victoria', 'AR', 'E'),
(1057, 11, 178, 'Villa del Rosario', 'AR', 'E'),
(1058, 11, 178, 'Villa Elisa', 'AR', 'E'),
(1059, 11, 178, 'Villa Hernandarias', 'AR', 'E'),
(1060, 11, 178, 'Villa Mantero', 'AR', 'E'),
(1061, 11, 178, 'Villa María Grande', 'AR', 'E'),
(1062, 11, 178, 'Villa Paranacito', 'AR', 'E'),
(1063, 11, 178, 'Villa Urquiza', 'AR', 'E'),
(1064, 11, 178, 'Villaguay', 'AR', 'E'),
(1065, 11, 179, 'Clorinda', 'AR', 'P'),
(1066, 11, 179, 'Comandante Fontana', 'AR', 'P'),
(1067, 11, 179, 'Departamento de Pilcomayo', 'AR', 'P'),
(1068, 11, 179, 'El Colorado', 'AR', 'P'),
(1069, 11, 179, 'Estanislao del Campo', 'AR', 'P'),
(1070, 11, 179, 'Formosa', 'AR', 'P'),
(1071, 11, 179, 'General Enrique Mosconi', 'AR', 'P'),
(1072, 11, 179, 'Herradura', 'AR', 'P'),
(1073, 11, 179, 'Ibarreta', 'AR', 'P'),
(1074, 11, 179, 'Ingeniero Guillermo N. Juárez', 'AR', 'P'),
(1075, 11, 179, 'Laguna Naick-Neck', 'AR', 'P'),
(1076, 11, 179, 'Laguna Yema', 'AR', 'P'),
(1077, 11, 179, 'Las Lomitas', 'AR', 'P'),
(1078, 11, 179, 'Palo Santo', 'AR', 'P'),
(1079, 11, 179, 'Pirané', 'AR', 'P'),
(1080, 11, 179, 'Pozo del Tigre', 'AR', 'P'),
(1081, 11, 179, 'Riacho Eh-Eh', 'AR', 'P'),
(1082, 11, 179, 'San Francisco de Laishí', 'AR', 'P'),
(1083, 11, 179, 'Villa Escolar', 'AR', 'P'),
(1084, 11, 179, 'Villa General Guemes', 'AR', 'P'),
(1085, 11, 180, 'Abra Pampa', 'AR', 'Y'),
(1086, 11, 180, 'Caimancito', 'AR', 'Y'),
(1087, 11, 180, 'Calilegua', 'AR', 'Y'),
(1088, 11, 180, 'Departamento de Cochinoca', 'AR', 'Y'),
(1089, 11, 180, 'Departamento de Rinconada', 'AR', 'Y'),
(1090, 11, 180, 'Departamento de Tumbaya', 'AR', 'Y'),
(1091, 11, 180, 'El Aguilar', 'AR', 'Y'),
(1092, 11, 180, 'Fraile Pintado', 'AR', 'Y'),
(1093, 11, 180, 'Humahuaca', 'AR', 'Y'),
(1094, 11, 180, 'Ingenio La Esperanza', 'AR', 'Y'),
(1095, 11, 180, 'La Mendieta', 'AR', 'Y'),
(1096, 11, 180, 'La Quiaca', 'AR', 'Y'),
(1097, 11, 180, 'Libertador General San Martín', 'AR', 'Y'),
(1098, 11, 180, 'Maimará', 'AR', 'Y'),
(1099, 11, 180, 'Palma Sola', 'AR', 'Y'),
(1100, 11, 180, 'Palpalá', 'AR', 'Y'),
(1101, 11, 180, 'San Pedro de Jujuy', 'AR', 'Y'),
(1102, 11, 180, 'San Salvador de Jujuy', 'AR', 'Y'),
(1103, 11, 180, 'Santa Clara', 'AR', 'Y'),
(1104, 11, 180, 'Tilcara', 'AR', 'Y'),
(1105, 11, 180, 'Yuto', 'AR', 'Y'),
(1106, 11, 181, 'Alpachiri', 'AR', 'L'),
(1107, 11, 181, 'Alta Italia', 'AR', 'L'),
(1108, 11, 181, 'Anguil', 'AR', 'L'),
(1109, 11, 181, 'Arata', 'AR', 'L'),
(1110, 11, 181, 'Bernardo Larroudé', 'AR', 'L'),
(1111, 11, 181, 'Bernasconi', 'AR', 'L'),
(1112, 11, 181, 'Caleufú', 'AR', 'L'),
(1113, 11, 181, 'Catriló', 'AR', 'L'),
(1114, 11, 181, 'Colonia Barón', 'AR', 'L'),
(1115, 11, 181, 'Departamento de Caleu-Caleu', 'AR', 'L'),
(1116, 11, 181, 'Departamento de Toay', 'AR', 'L'),
(1117, 11, 181, 'Doblas', 'AR', 'L'),
(1118, 11, 181, 'Eduardo Castex', 'AR', 'L'),
(1119, 11, 181, 'Embajador Martini', 'AR', 'L'),
(1120, 11, 181, 'General Acha', 'AR', 'L'),
(1121, 11, 181, 'General Manuel J. Campos', 'AR', 'L'),
(1122, 11, 181, 'General Pico', 'AR', 'L'),
(1123, 11, 181, 'General San Martín', 'AR', 'L'),
(1124, 11, 181, 'Guatraché', 'AR', 'L'),
(1125, 11, 181, 'Ingeniero Luiggi', 'AR', 'L'),
(1126, 11, 181, 'Intendente Alvear', 'AR', 'L'),
(1127, 11, 181, 'Jacinto Arauz', 'AR', 'L'),
(1128, 11, 181, 'La Adela', 'AR', 'L'),
(1129, 11, 181, 'La Maruja', 'AR', 'L'),
(1130, 11, 181, 'Lonquimay', 'AR', 'L'),
(1131, 11, 181, 'Macachín', 'AR', 'L'),
(1132, 11, 181, 'Miguel Riglos', 'AR', 'L'),
(1133, 11, 181, 'Parera', 'AR', 'L'),
(1134, 11, 181, 'Quemú Quemú', 'AR', 'L'),
(1135, 11, 181, 'Rancul', 'AR', 'L'),
(1136, 11, 181, 'Realicó', 'AR', 'L'),
(1137, 11, 181, 'Santa Isabel', 'AR', 'L'),
(1138, 11, 181, 'Santa Rosa', 'AR', 'L'),
(1139, 11, 181, 'Telén', 'AR', 'L'),
(1140, 11, 181, 'Trenel', 'AR', 'L'),
(1141, 11, 181, 'Uriburu', 'AR', 'L'),
(1142, 11, 181, 'Veinticinco de Mayo', 'AR', 'L'),
(1143, 11, 181, 'Victorica', 'AR', 'L'),
(1144, 11, 181, 'Winifreda', 'AR', 'L'),
(1145, 11, 182, 'Arauco', 'AR', 'F'),
(1146, 11, 182, 'Castro Barros', 'AR', 'F'),
(1147, 11, 182, 'Chamical', 'AR', 'F'),
(1148, 11, 182, 'Chilecito', 'AR', 'F'),
(1149, 11, 182, 'Departamento de Arauco', 'AR', 'F'),
(1150, 11, 182, 'Departamento de General Lamadrid', 'AR', 'F'),
(1151, 11, 182, 'Departamento de Independencia', 'AR', 'F'),
(1152, 11, 182, 'La Rioja', 'AR', 'F'),
(1153, 11, 182, 'Villa Bustos', 'AR', 'F'),
(1154, 11, 182, 'Vinchina', 'AR', 'F'),
(1155, 11, 183, 'Departamento de Capital', 'AR', 'M'),
(1156, 11, 183, 'Departamento de General Alvear', 'AR', 'M'),
(1157, 11, 183, 'Departamento de Godoy Cruz', 'AR', 'M'),
(1158, 11, 183, 'Departamento de Guaymallén', 'AR', 'M'),
(1159, 11, 183, 'Departamento de La Paz', 'AR', 'M'),
(1160, 11, 183, 'Departamento de Las Heras', 'AR', 'M'),
(1161, 11, 183, 'Departamento de Lavalle', 'AR', 'M'),
(1162, 11, 183, 'Departamento de Luján', 'AR', 'M'),
(1163, 11, 183, 'Departamento de Maipú', 'AR', 'M'),
(1164, 11, 183, 'Departamento de Malargüe', 'AR', 'M'),
(1165, 11, 183, 'Departamento de Rivadavia', 'AR', 'M'),
(1166, 11, 183, 'Departamento de San Carlos', 'AR', 'M'),
(1167, 11, 183, 'Departamento de San Martín', 'AR', 'M'),
(1168, 11, 183, 'Departamento de San Rafael', 'AR', 'M'),
(1169, 11, 183, 'Departamento de Santa Rosa', 'AR', 'M'),
(1170, 11, 183, 'Departamento de Tunuyán', 'AR', 'M'),
(1171, 11, 183, 'Departamento de Tupungato', 'AR', 'M'),
(1172, 11, 183, 'Godoy Cruz', 'AR', 'M'),
(1173, 11, 183, 'Las Heras', 'AR', 'M'),
(1174, 11, 183, 'Mendoza', 'AR', 'M'),
(1175, 11, 183, 'San Martín', 'AR', 'M'),
(1176, 11, 183, 'San Rafael', 'AR', 'M'),
(1177, 11, 184, 'Alba Posse', 'AR', 'N'),
(1178, 11, 184, 'Almafuerte', 'AR', 'N'),
(1179, 11, 184, 'Aristóbulo del Valle', 'AR', 'N'),
(1180, 11, 184, 'Arroyo del Medio', 'AR', 'N'),
(1181, 11, 184, 'Azara', 'AR', 'N'),
(1182, 11, 184, 'Bernardo de Irigoyen', 'AR', 'N'),
(1183, 11, 184, 'Bonpland', 'AR', 'N'),
(1184, 11, 184, 'Campo Grande', 'AR', 'N'),
(1185, 11, 184, 'Campo Ramón', 'AR', 'N'),
(1186, 11, 184, 'Campo Viera', 'AR', 'N'),
(1187, 11, 184, 'Candelaria', 'AR', 'N'),
(1188, 11, 184, 'Capioví', 'AR', 'N'),
(1189, 11, 184, 'Caraguatay', 'AR', 'N'),
(1190, 11, 184, 'Cerro Azul', 'AR', 'N'),
(1191, 11, 184, 'Cerro Corá', 'AR', 'N'),
(1192, 11, 184, 'Colonia Aurora', 'AR', 'N'),
(1193, 11, 184, 'Concepción de la Sierra', 'AR', 'N'),
(1194, 11, 184, 'Departamento de Apóstoles', 'AR', 'N'),
(1195, 11, 184, 'Departamento de Cainguás', 'AR', 'N'),
(1196, 11, 184, 'Departamento de Candelaria', 'AR', 'N'),
(1197, 11, 184, 'Departamento de Capital', 'AR', 'N'),
(1198, 11, 184, 'Departamento de Concepción de la Sierra', 'AR', 'N'),
(1199, 11, 184, 'Departamento de Eldorado', 'AR', 'N'),
(1200, 11, 184, 'Departamento de General Manuel Belgrano', 'AR', 'N'),
(1201, 11, 184, 'Departamento de Guaraní', 'AR', 'N'),
(1202, 11, 184, 'Departamento de Iguazú', 'AR', 'N'),
(1203, 11, 184, 'Departamento de Leandro N. Alem', 'AR', 'N'),
(1204, 11, 184, 'Departamento de Libertador General San Martín', 'AR', 'N'),
(1205, 11, 184, 'Departamento de Montecarlo', 'AR', 'N'),
(1206, 11, 184, 'Departamento de Oberá', 'AR', 'N'),
(1207, 11, 184, 'Departamento de San Ignacio', 'AR', 'N'),
(1208, 11, 184, 'Departamento de San Javier', 'AR', 'N'),
(1209, 11, 184, 'Departamento de San Pedro', 'AR', 'N'),
(1210, 11, 184, 'Departamento de Veinticinco de Mayo', 'AR', 'N'),
(1211, 11, 184, 'Dos Arroyos', 'AR', 'N'),
(1212, 11, 184, 'Dos de Mayo', 'AR', 'N'),
(1213, 11, 184, 'El Alcázar', 'AR', 'N'),
(1214, 11, 184, 'El Soberbio', 'AR', 'N'),
(1215, 11, 184, 'Florentino Ameghino', 'AR', 'N'),
(1216, 11, 184, 'Garuhapé', 'AR', 'N'),
(1217, 11, 184, 'Garupá', 'AR', 'N'),
(1218, 11, 184, 'General Alvear', 'AR', 'N'),
(1219, 11, 184, 'Gobernador Roca', 'AR', 'N'),
(1220, 11, 184, 'Guaraní', 'AR', 'N'),
(1221, 11, 184, 'Jardín América', 'AR', 'N'),
(1222, 11, 184, 'Loreto', 'AR', 'N'),
(1223, 11, 184, 'Los Helechos', 'AR', 'N'),
(1224, 11, 184, 'Mártires', 'AR', 'N'),
(1225, 11, 184, 'Mojón Grande', 'AR', 'N'),
(1226, 11, 184, 'Montecarlo', 'AR', 'N'),
(1227, 11, 184, 'Oberá', 'AR', 'N'),
(1228, 11, 184, 'Panambí', 'AR', 'N'),
(1229, 11, 184, 'Picada Gobernador López', 'AR', 'N'),
(1230, 11, 184, 'Posadas', 'AR', 'N'),
(1231, 11, 184, 'Puerto Eldorado', 'AR', 'N'),
(1232, 11, 184, 'Puerto Esperanza', 'AR', 'N'),
(1233, 11, 184, 'Puerto Iguazú', 'AR', 'N'),
(1234, 11, 184, 'Puerto Leoni', 'AR', 'N'),
(1235, 11, 184, 'Puerto Libertad', 'AR', 'N'),
(1236, 11, 184, 'Puerto Piray', 'AR', 'N'),
(1237, 11, 184, 'Puerto Rico', 'AR', 'N'),
(1238, 11, 184, 'Ruiz de Montoya', 'AR', 'N'),
(1239, 11, 184, 'San José', 'AR', 'N'),
(1240, 11, 184, 'San Pedro', 'AR', 'N'),
(1241, 11, 184, 'San Vicente', 'AR', 'N'),
(1242, 11, 184, 'Santa María', 'AR', 'N'),
(1243, 11, 184, 'Santo Pipó', 'AR', 'N'),
(1244, 11, 184, 'Tres Capones', 'AR', 'N'),
(1245, 11, 184, 'Veinticinco de Mayo', 'AR', 'N'),
(1246, 11, 184, 'Wanda', 'AR', 'N'),
(1247, 11, 185, 'Aluminé', 'AR', 'Q'),
(1248, 11, 185, 'Andacollo', 'AR', 'Q'),
(1249, 11, 185, 'Añelo', 'AR', 'Q'),
(1250, 11, 185, 'Barrancas', 'AR', 'Q'),
(1251, 11, 185, 'Buta Ranquil', 'AR', 'Q'),
(1252, 11, 185, 'Centenario', 'AR', 'Q'),
(1253, 11, 185, 'Chos Malal', 'AR', 'Q'),
(1254, 11, 185, 'Cutral-Có', 'AR', 'Q'),
(1255, 11, 185, 'Departamento de Aluminé', 'AR', 'Q'),
(1256, 11, 185, 'Departamento de Añelo', 'AR', 'Q'),
(1257, 11, 185, 'Departamento de Catán-Lil', 'AR', 'Q'),
(1258, 11, 185, 'Departamento de Chos-Malal', 'AR', 'Q'),
(1259, 11, 185, 'Departamento de Collón-Curá', 'AR', 'Q'),
(1260, 11, 185, 'Departamento de Confluencia', 'AR', 'Q'),
(1261, 11, 185, 'Departamento de Lácar', 'AR', 'Q'),
(1262, 11, 185, 'Departamento de Minas', 'AR', 'Q'),
(1263, 11, 185, 'Departamento de Zapala', 'AR', 'Q'),
(1264, 11, 185, 'El Huecú', 'AR', 'Q'),
(1265, 11, 185, 'Junín de los Andes', 'AR', 'Q'),
(1266, 11, 185, 'Las Coloradas', 'AR', 'Q'),
(1267, 11, 185, 'Las Lajas', 'AR', 'Q'),
(1268, 11, 185, 'Las Ovejas', 'AR', 'Q'),
(1269, 11, 185, 'Loncopué', 'AR', 'Q'),
(1270, 11, 185, 'Mariano Moreno', 'AR', 'Q'),
(1271, 11, 185, 'Neuquén', 'AR', 'Q'),
(1272, 11, 185, 'Picún Leufú', 'AR', 'Q'),
(1273, 11, 185, 'Piedra del Águila', 'AR', 'Q'),
(1274, 11, 185, 'Plaza Huincul', 'AR', 'Q'),
(1275, 11, 185, 'Plottier', 'AR', 'Q'),
(1276, 11, 185, 'San Martín de los Andes', 'AR', 'Q'),
(1277, 11, 185, 'Senillosa', 'AR', 'Q'),
(1278, 11, 185, 'Villa La Angostura', 'AR', 'Q'),
(1279, 11, 185, 'Vista Alegre', 'AR', 'Q'),
(1280, 11, 185, 'Zapala', 'AR', 'Q'),
(1281, 11, 186, 'Allen', 'AR', 'R'),
(1282, 11, 186, 'Catriel', 'AR', 'R'),
(1283, 11, 186, 'Cervantes', 'AR', 'R'),
(1284, 11, 186, 'Chichinales', 'AR', 'R'),
(1285, 11, 186, 'Chimpay', 'AR', 'R'),
(1286, 11, 186, 'Choele Choel', 'AR', 'R'),
(1287, 11, 186, 'Cinco Saltos', 'AR', 'R'),
(1288, 11, 186, 'Cipolletti', 'AR', 'R'),
(1289, 11, 186, 'Comallo', 'AR', 'R'),
(1290, 11, 186, 'Contraalmirante Cordero', 'AR', 'R'),
(1291, 11, 186, 'Coronel Belisle', 'AR', 'R'),
(1292, 11, 186, 'Darwin', 'AR', 'R'),
(1293, 11, 186, 'Departamento de Avellaneda', 'AR', 'R'),
(1294, 11, 186, 'Departamento de Veinticinco de Mayo', 'AR', 'R'),
(1295, 11, 186, 'El Bolsón', 'AR', 'R'),
(1296, 11, 186, 'El Cuy', 'AR', 'R'),
(1297, 11, 186, 'Fray Luis Beltrán', 'AR', 'R'),
(1298, 11, 186, 'General Conesa', 'AR', 'R'),
(1299, 11, 186, 'General Enrique Godoy', 'AR', 'R'),
(1300, 11, 186, 'General Fernández Oro', 'AR', 'R'),
(1301, 11, 186, 'General Roca', 'AR', 'R'),
(1302, 11, 186, 'Ingeniero Jacobacci', 'AR', 'R'),
(1303, 11, 186, 'Ingeniero Luis A. Huergo', 'AR', 'R'),
(1304, 11, 186, 'Lamarque', 'AR', 'R'),
(1305, 11, 186, 'Los Menucos', 'AR', 'R'),
(1306, 11, 186, 'Mainque', 'AR', 'R'),
(1307, 11, 186, 'Maquinchao', 'AR', 'R'),
(1308, 11, 186, 'Ñorquinco', 'AR', 'R'),
(1309, 11, 186, 'Pilcaniyeu', 'AR', 'R'),
(1310, 11, 186, 'Río Colorado', 'AR', 'R'),
(1311, 11, 186, 'San Antonio Oeste', 'AR', 'R'),
(1312, 11, 186, 'San Carlos de Bariloche', 'AR', 'R'),
(1313, 11, 186, 'Sierra Colorada', 'AR', 'R'),
(1314, 11, 186, 'Sierra Grande', 'AR', 'R'),
(1315, 11, 186, 'Valcheta', 'AR', 'R'),
(1316, 11, 186, 'Viedma', 'AR', 'R'),
(1317, 11, 186, 'Villa Regina', 'AR', 'R'),
(1318, 11, 187, 'Apolinario Saravia', 'AR', 'A'),
(1319, 11, 187, 'Cachí', 'AR', 'A'),
(1320, 11, 187, 'Cafayate', 'AR', 'A'),
(1321, 11, 187, 'Campo Quijano', 'AR', 'A'),
(1322, 11, 187, 'Chicoana', 'AR', 'A'),
(1323, 11, 187, 'Departamento Capital', 'AR', 'A'),
(1324, 11, 187, 'Departamento de Anta', 'AR', 'A'),
(1325, 11, 187, 'Departamento de Cerrillos', 'AR', 'A'),
(1326, 11, 187, 'Departamento de Chicoana', 'AR', 'A'),
(1327, 11, 187, 'Departamento de General Güemes', 'AR', 'A'),
(1328, 11, 187, 'Departamento de Guachipas', 'AR', 'A'),
(1329, 11, 187, 'Departamento de Iruya', 'AR', 'A'),
(1330, 11, 187, 'Departamento de La Poma', 'AR', 'A'),
(1331, 11, 187, 'Departamento de La Viña', 'AR', 'A'),
(1332, 11, 187, 'Departamento de Los Andes', 'AR', 'A'),
(1333, 11, 187, 'Departamento de Metán', 'AR', 'A'),
(1334, 11, 187, 'Departamento de Rivadavia', 'AR', 'A'),
(1335, 11, 187, 'Departamento de Rosario de la Frontera', 'AR', 'A'),
(1336, 11, 187, 'Departamento de Rosario de Lerma', 'AR', 'A'),
(1337, 11, 187, 'Departamento de San Carlos', 'AR', 'A'),
(1338, 11, 187, 'El Carril', 'AR', 'A'),
(1339, 11, 187, 'El Galpón', 'AR', 'A'),
(1340, 11, 187, 'El Quebrachal', 'AR', 'A'),
(1341, 11, 187, 'Embarcación', 'AR', 'A'),
(1342, 11, 187, 'General Enrique Mosconi', 'AR', 'A'),
(1343, 11, 187, 'Joaquín V. González', 'AR', 'A'),
(1344, 11, 187, 'La Caldera', 'AR', 'A'),
(1345, 11, 187, 'Las Lajitas', 'AR', 'A'),
(1346, 11, 187, 'Salta', 'AR', 'A'),
(1347, 11, 187, 'San Antonio de los Cobres', 'AR', 'A'),
(1348, 11, 187, 'San Ramón de la Nueva Orán', 'AR', 'A'),
(1349, 11, 187, 'Santa Rosa de Tastil', 'AR', 'A'),
(1350, 11, 187, 'Tartagal', 'AR', 'A'),
(1351, 11, 188, 'Albardón', 'AR', 'J'),
(1352, 11, 188, 'Calingasta', 'AR', 'J'),
(1353, 11, 188, 'Caucete', 'AR', 'J'),
(1354, 11, 188, 'Chimbas', 'AR', 'J'),
(1355, 11, 188, 'Departamento de Albardón', 'AR', 'J'),
(1356, 11, 188, 'Departamento de Angaco', 'AR', 'J'),
(1357, 11, 188, 'Departamento de Calingasta', 'AR', 'J'),
(1358, 11, 188, 'Departamento de Capital', 'AR', 'J'),
(1359, 11, 188, 'Departamento de Caucete', 'AR', 'J'),
(1360, 11, 188, 'Departamento de Chimbas', 'AR', 'J'),
(1361, 11, 188, 'Departamento de Iglesia', 'AR', 'J'),
(1362, 11, 188, 'Departamento de Jáchal', 'AR', 'J'),
(1363, 11, 188, 'Departamento de Nueve de Julio', 'AR', 'J'),
(1364, 11, 188, 'Departamento de Rawson', 'AR', 'J'),
(1365, 11, 188, 'Departamento de Rivadavia', 'AR', 'J'),
(1366, 11, 188, 'Departamento de San Martín', 'AR', 'J'),
(1367, 11, 188, 'Departamento de Santa Lucía', 'AR', 'J'),
(1368, 11, 188, 'Departamento de Sarmiento', 'AR', 'J'),
(1369, 11, 188, 'Departamento de Ullúm', 'AR', 'J'),
(1370, 11, 188, 'Departamento de Zonda', 'AR', 'J'),
(1371, 11, 188, 'Nueve de Julio', 'AR', 'J'),
(1372, 11, 188, 'Pocito', 'AR', 'J'),
(1373, 11, 188, 'San Agustín de Valle Fértil', 'AR', 'J'),
(1374, 11, 188, 'San José de Jáchal', 'AR', 'J'),
(1375, 11, 188, 'San Juan', 'AR', 'J'),
(1376, 11, 188, 'San Martín', 'AR', 'J'),
(1377, 11, 188, 'Santa Lucía', 'AR', 'J'),
(1378, 11, 188, 'Villa Basilio Nievas', 'AR', 'J'),
(1379, 11, 188, 'Villa Paula de Sarmiento', 'AR', 'J'),
(1380, 11, 189, 'Buena Esperanza', 'AR', 'D'),
(1381, 11, 189, 'Candelaria', 'AR', 'D'),
(1382, 11, 189, 'Concarán', 'AR', 'D'),
(1383, 11, 189, 'Juan Martín de Pueyrredón', 'AR', 'D'),
(1384, 11, 189, 'Justo Daract', 'AR', 'D'),
(1385, 11, 189, 'La Punta', 'AR', 'D'),
(1386, 11, 189, 'La Toma', 'AR', 'D'),
(1387, 11, 189, 'Luján', 'AR', 'D'),
(1388, 11, 189, 'Merlo', 'AR', 'D'),
(1389, 11, 189, 'Naschel', 'AR', 'D'),
(1390, 11, 189, 'San Francisco del Monte de Oro', 'AR', 'D'),
(1391, 11, 189, 'San Luis', 'AR', 'D'),
(1392, 11, 189, 'Santa Rosa del Conlara', 'AR', 'D'),
(1393, 11, 189, 'Tilisarao', 'AR', 'D'),
(1394, 11, 189, 'Unión', 'AR', 'D'),
(1395, 11, 189, 'Villa General Roca', 'AR', 'D'),
(1396, 11, 189, 'Villa Mercedes', 'AR', 'D'),
(1397, 11, 190, '28 de Noviembre', 'AR', 'Z'),
(1398, 11, 190, 'Caleta Olivia', 'AR', 'Z'),
(1399, 11, 190, 'Comandante Luis Piedra Buena', 'AR', 'Z'),
(1400, 11, 190, 'Departamento de Deseado', 'AR', 'Z'),
(1401, 11, 190, 'Departamento de Güer Aike', 'AR', 'Z'),
(1402, 11, 190, 'Departamento de Lago Argentino', 'AR', 'Z'),
(1403, 11, 190, 'Departamento de Magallanes', 'AR', 'Z'),
(1404, 11, 190, 'Departamento de Río Chico', 'AR', 'Z'),
(1405, 11, 190, 'El Calafate', 'AR', 'Z'),
(1406, 11, 190, 'Gobernador Gregores', 'AR', 'Z'),
(1407, 11, 190, 'Las Heras', 'AR', 'Z'),
(1408, 11, 190, 'Los Antiguos', 'AR', 'Z'),
(1409, 11, 190, 'Perito Moreno', 'AR', 'Z'),
(1410, 11, 190, 'Pico Truncado', 'AR', 'Z'),
(1411, 11, 190, 'Puerto Deseado', 'AR', 'Z'),
(1412, 11, 190, 'Puerto Santa Cruz', 'AR', 'Z'),
(1413, 11, 190, 'Río Gallegos', 'AR', 'Z'),
(1414, 11, 190, 'Río Turbio', 'AR', 'Z'),
(1415, 11, 190, 'San Julián', 'AR', 'Z'),
(1416, 11, 190, 'Yacimiento Río Turbio', 'AR', 'Z'),
(1417, 11, 191, 'Armstrong', 'AR', 'S'),
(1418, 11, 191, 'Arroyo Seco', 'AR', 'S'),
(1419, 11, 191, 'Arrufó', 'AR', 'S'),
(1420, 11, 191, 'Avellaneda', 'AR', 'S'),
(1421, 11, 191, 'Bella Italia', 'AR', 'S'),
(1422, 11, 191, 'Calchaquí', 'AR', 'S'),
(1423, 11, 191, 'Cañada de Gómez', 'AR', 'S'),
(1424, 11, 191, 'Capitán Bermúdez', 'AR', 'S'),
(1425, 11, 191, 'Carcarañá', 'AR', 'S'),
(1426, 11, 191, 'Casilda', 'AR', 'S'),
(1427, 11, 191, 'Ceres', 'AR', 'S'),
(1428, 11, 191, 'Chañar Ladeado', 'AR', 'S'),
(1429, 11, 191, 'Coronda', 'AR', 'S'),
(1430, 11, 191, 'Departamento de Belgrano', 'AR', 'S'),
(1431, 11, 191, 'Departamento de Caseros', 'AR', 'S'),
(1432, 11, 191, 'Departamento de Castellanos', 'AR', 'S'),
(1433, 11, 191, 'Departamento de Constitución', 'AR', 'S'),
(1434, 11, 191, 'Departamento de La Capital', 'AR', 'S'),
(1435, 11, 191, 'Departamento de Nueve de Julio', 'AR', 'S'),
(1436, 11, 191, 'Departamento de San Cristóbal', 'AR', 'S'),
(1437, 11, 191, 'Departamento de San Javier', 'AR', 'S'),
(1438, 11, 191, 'Departamento de San Justo', 'AR', 'S'),
(1439, 11, 191, 'Departamento de San Lorenzo', 'AR', 'S'),
(1440, 11, 191, 'Departamento de San Martín', 'AR', 'S'),
(1441, 11, 191, 'Departamento de Vera', 'AR', 'S'),
(1442, 11, 191, 'El Trébol', 'AR', 'S'),
(1443, 11, 191, 'Esperanza', 'AR', 'S'),
(1444, 11, 191, 'Firmat', 'AR', 'S'),
(1445, 11, 191, 'Fray Luis A. Beltrán', 'AR', 'S'),
(1446, 11, 191, 'Funes', 'AR', 'S'),
(1447, 11, 191, 'Gálvez', 'AR', 'S'),
(1448, 11, 191, 'Gato Colorado', 'AR', 'S'),
(1449, 11, 191, 'Gobernador Gálvez', 'AR', 'S'),
(1450, 11, 191, 'Granadero Baigorria', 'AR', 'S'),
(1451, 11, 191, 'Helvecia', 'AR', 'S'),
(1452, 11, 191, 'Hersilia', 'AR', 'S'),
(1453, 11, 191, 'Iriondo Department', 'AR', 'S'),
(1454, 11, 191, 'Laguna Paiva', 'AR', 'S'),
(1455, 11, 191, 'Las Parejas', 'AR', 'S'),
(1456, 11, 191, 'Las Rosas', 'AR', 'S'),
(1457, 11, 191, 'Las Toscas', 'AR', 'S'),
(1458, 11, 191, 'Los Laureles', 'AR', 'S'),
(1459, 11, 191, 'Malabrigo', 'AR', 'S'),
(1460, 11, 191, 'Melincué', 'AR', 'S'),
(1461, 11, 191, 'Pérez', 'AR', 'S'),
(1462, 11, 191, 'Rafaela', 'AR', 'S'),
(1463, 11, 191, 'Reconquista', 'AR', 'S'),
(1464, 11, 191, 'Recreo', 'AR', 'S'),
(1465, 11, 191, 'Roldán', 'AR', 'S'),
(1466, 11, 191, 'Rosario', 'AR', 'S'),
(1467, 11, 191, 'Rufino', 'AR', 'S'),
(1468, 11, 191, 'San Carlos Centro', 'AR', 'S'),
(1469, 11, 191, 'San Cristóbal', 'AR', 'S'),
(1470, 11, 191, 'San Javier', 'AR', 'S'),
(1471, 11, 191, 'San Jorge', 'AR', 'S'),
(1472, 11, 191, 'San Justo', 'AR', 'S'),
(1473, 11, 191, 'Santa Fe', 'AR', 'S'),
(1474, 11, 191, 'Santo Tomé', 'AR', 'S'),
(1475, 11, 191, 'Sastre', 'AR', 'S'),
(1476, 11, 191, 'Sunchales', 'AR', 'S'),
(1477, 11, 191, 'Tacuarendí', 'AR', 'S'),
(1478, 11, 191, 'Tostado', 'AR', 'S'),
(1479, 11, 191, 'Totoras', 'AR', 'S'),
(1480, 11, 191, 'Venado Tuerto', 'AR', 'S'),
(1481, 11, 191, 'Vera', 'AR', 'S'),
(1482, 11, 191, 'Villa Cañás', 'AR', 'S'),
(1483, 11, 191, 'Villa Constitución', 'AR', 'S'),
(1484, 11, 191, 'Villa Mugueta', 'AR', 'S'),
(1485, 11, 191, 'Villa Ocampo', 'AR', 'S'),
(1486, 11, 191, 'Villa Trinidad', 'AR', 'S'),
(1487, 11, 192, 'Añatuya', 'AR', 'G'),
(1488, 11, 192, 'Beltrán', 'AR', 'G'),
(1489, 11, 192, 'Campo Gallo', 'AR', 'G'),
(1490, 11, 192, 'Clodomira', 'AR', 'G'),
(1491, 11, 192, 'Colonia Dora', 'AR', 'G'),
(1492, 11, 192, 'Departamento de Aguirre', 'AR', 'G'),
(1493, 11, 192, 'Departamento de Banda', 'AR', 'G'),
(1494, 11, 192, 'Departamento de Choya', 'AR', 'G'),
(1495, 11, 192, 'Departamento de Guasayán', 'AR', 'G'),
(1496, 11, 192, 'Departamento de Loreto', 'AR', 'G'),
(1497, 11, 192, 'Departamento de Moreno', 'AR', 'G'),
(1498, 11, 192, 'Departamento de Río Hondo', 'AR', 'G'),
(1499, 11, 192, 'Departamento de Robles', 'AR', 'G'),
(1500, 11, 192, 'Departamento de San Martín', 'AR', 'G');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(1501, 11, 192, 'Departamento de Sarmiento', 'AR', 'G'),
(1502, 11, 192, 'El Hoyo', 'AR', 'G'),
(1503, 11, 192, 'La Banda', 'AR', 'G'),
(1504, 11, 192, 'Los Juríes', 'AR', 'G'),
(1505, 11, 192, 'Los Telares', 'AR', 'G'),
(1506, 11, 192, 'Pampa de los Guanacos', 'AR', 'G'),
(1507, 11, 192, 'Quimilí', 'AR', 'G'),
(1508, 11, 192, 'San Pedro', 'AR', 'G'),
(1509, 11, 192, 'Santiago del Estero', 'AR', 'G'),
(1510, 11, 192, 'Sumampa', 'AR', 'G'),
(1511, 11, 192, 'Suncho Corral', 'AR', 'G'),
(1512, 11, 192, 'Termas de Río Hondo', 'AR', 'G'),
(1513, 11, 192, 'Tintina', 'AR', 'G'),
(1514, 11, 192, 'Villa Atamisqui', 'AR', 'G'),
(1515, 11, 192, 'Villa General Mitre', 'AR', 'G'),
(1516, 11, 192, 'Villa Ojo de Agua', 'AR', 'G'),
(1517, 11, 193, 'Río Grande', 'AR', 'V'),
(1518, 11, 193, 'Tolhuin', 'AR', 'V'),
(1519, 11, 193, 'Ushuaia', 'AR', 'V'),
(1520, 11, 194, 'Aguilares', 'AR', 'T'),
(1521, 11, 194, 'Alderetes', 'AR', 'T'),
(1522, 11, 194, 'Bella Vista', 'AR', 'T'),
(1523, 11, 194, 'Burruyacú', 'AR', 'T'),
(1524, 11, 194, 'Departamento de Burruyacú', 'AR', 'T'),
(1525, 11, 194, 'Departamento de Capital', 'AR', 'T'),
(1526, 11, 194, 'Departamento de Cruz Alta', 'AR', 'T'),
(1527, 11, 194, 'Departamento de Famaillá', 'AR', 'T'),
(1528, 11, 194, 'Departamento de Graneros', 'AR', 'T'),
(1529, 11, 194, 'Departamento de La Cocha', 'AR', 'T'),
(1530, 11, 194, 'Departamento de Lules', 'AR', 'T'),
(1531, 11, 194, 'Departamento de Monteros', 'AR', 'T'),
(1532, 11, 194, 'Departamento de Río Chico', 'AR', 'T'),
(1533, 11, 194, 'Departamento de Simoca', 'AR', 'T'),
(1534, 11, 194, 'Departamento de Trancas', 'AR', 'T'),
(1535, 11, 194, 'Departamento de Yerba Buena', 'AR', 'T'),
(1536, 11, 194, 'Famaillá', 'AR', 'T'),
(1537, 11, 194, 'Graneros', 'AR', 'T'),
(1538, 11, 194, 'La Cocha', 'AR', 'T'),
(1539, 11, 194, 'Monteros', 'AR', 'T'),
(1540, 11, 194, 'San Miguel de Tucumán', 'AR', 'T'),
(1541, 11, 194, 'Simoca', 'AR', 'T'),
(1542, 11, 194, 'Tafí del Valle', 'AR', 'T'),
(1543, 11, 194, 'Tafí Viejo', 'AR', 'T'),
(1544, 11, 194, 'Trancas', 'AR', 'T'),
(1545, 11, 194, 'Yerba Buena', 'AR', 'T'),
(1546, 12, 195, 'Agarakavan', 'AM', 'AG'),
(1547, 12, 195, 'Aparan', 'AM', 'AG'),
(1548, 12, 195, 'Aragats', 'AM', 'AG'),
(1549, 12, 195, 'Arteni', 'AM', 'AG'),
(1550, 12, 195, 'Ashnak', 'AM', 'AG'),
(1551, 12, 195, 'Ashtarak', 'AM', 'AG'),
(1552, 12, 195, 'Byurakan', 'AM', 'AG'),
(1553, 12, 195, 'Hnaberd', 'AM', 'AG'),
(1554, 12, 195, 'Karbi', 'AM', 'AG'),
(1555, 12, 195, 'Kasakh', 'AM', 'AG'),
(1556, 12, 195, 'Kosh', 'AM', 'AG'),
(1557, 12, 195, 'Nor Yerznka', 'AM', 'AG'),
(1558, 12, 195, 'Oshakan', 'AM', 'AG'),
(1559, 12, 195, 'Sasunik', 'AM', 'AG'),
(1560, 12, 195, 'Shenavan', 'AM', 'AG'),
(1561, 12, 195, 'T’alin', 'AM', 'AG'),
(1562, 12, 195, 'Tsaghkahovit', 'AM', 'AG'),
(1563, 12, 195, 'Ushi', 'AM', 'AG'),
(1564, 12, 195, 'Voskevaz', 'AM', 'AG'),
(1565, 12, 195, 'Zovuni', 'AM', 'AG'),
(1566, 12, 196, 'Abovyan', 'AM', 'AR'),
(1567, 12, 196, 'Aralez', 'AM', 'AR'),
(1568, 12, 196, 'Ararat', 'AM', 'AR'),
(1569, 12, 196, 'Arevabuyr', 'AM', 'AR'),
(1570, 12, 196, 'Arevshat', 'AM', 'AR'),
(1571, 12, 196, 'Armash', 'AM', 'AR'),
(1572, 12, 196, 'Artashat', 'AM', 'AR'),
(1573, 12, 196, 'Avshar', 'AM', 'AR'),
(1574, 12, 196, 'Aygavan', 'AM', 'AR'),
(1575, 12, 196, 'Aygepat', 'AM', 'AR'),
(1576, 12, 196, 'Aygestan', 'AM', 'AR'),
(1577, 12, 196, 'Aygezard', 'AM', 'AR'),
(1578, 12, 196, 'Bardzrashen', 'AM', 'AR'),
(1579, 12, 196, 'Berk’anush', 'AM', 'AR'),
(1580, 12, 196, 'Burastan', 'AM', 'AR'),
(1581, 12, 196, 'Byuravan', 'AM', 'AR'),
(1582, 12, 196, 'Dalar', 'AM', 'AR'),
(1583, 12, 196, 'Darakert', 'AM', 'AR'),
(1584, 12, 196, 'Dashtavan', 'AM', 'AR'),
(1585, 12, 196, 'Dimitrov', 'AM', 'AR'),
(1586, 12, 196, 'Dvin', 'AM', 'AR'),
(1587, 12, 196, 'Getazat', 'AM', 'AR'),
(1588, 12, 196, 'Ghukasavan', 'AM', 'AR'),
(1589, 12, 196, 'Goravan', 'AM', 'AR'),
(1590, 12, 196, 'Hayanist', 'AM', 'AR'),
(1591, 12, 196, 'Hovtashat', 'AM', 'AR'),
(1592, 12, 196, 'Hovtashen', 'AM', 'AR'),
(1593, 12, 196, 'Jrahovit', 'AM', 'AR'),
(1594, 12, 196, 'Lusarrat', 'AM', 'AR'),
(1595, 12, 196, 'Marmarashen', 'AM', 'AR'),
(1596, 12, 196, 'Masis', 'AM', 'AR'),
(1597, 12, 196, 'Mrganush', 'AM', 'AR'),
(1598, 12, 196, 'Mrgavan', 'AM', 'AR'),
(1599, 12, 196, 'Mrgavet', 'AM', 'AR'),
(1600, 12, 196, 'Nizami', 'AM', 'AR'),
(1601, 12, 196, 'Norabats’', 'AM', 'AR'),
(1602, 12, 196, 'Noramarg', 'AM', 'AR'),
(1603, 12, 196, 'Norashen', 'AM', 'AR'),
(1604, 12, 196, 'Noyakert', 'AM', 'AR'),
(1605, 12, 196, 'Nshavan', 'AM', 'AR'),
(1606, 12, 196, 'Sayat’-Nova', 'AM', 'AR'),
(1607, 12, 196, 'Shahumyan', 'AM', 'AR'),
(1608, 12, 196, 'Sis', 'AM', 'AR'),
(1609, 12, 196, 'Sisavan', 'AM', 'AR'),
(1610, 12, 196, 'Surenavan', 'AM', 'AR'),
(1611, 12, 196, 'Vedi', 'AM', 'AR'),
(1612, 12, 196, 'Verin Artashat', 'AM', 'AR'),
(1613, 12, 196, 'Verin Dvin', 'AM', 'AR'),
(1614, 12, 196, 'Vosketap’', 'AM', 'AR'),
(1615, 12, 196, 'Vostan', 'AM', 'AR'),
(1616, 12, 196, 'Yeghegnavan', 'AM', 'AR'),
(1617, 12, 196, 'Zangakatun', 'AM', 'AR'),
(1618, 12, 196, 'Zorak', 'AM', 'AR'),
(1619, 12, 197, 'Aghavnatun', 'AM', 'AV'),
(1620, 12, 197, 'Aknalich', 'AM', 'AV'),
(1621, 12, 197, 'Aknashen', 'AM', 'AV'),
(1622, 12, 197, 'Alashkert', 'AM', 'AV'),
(1623, 12, 197, 'Apaga', 'AM', 'AV'),
(1624, 12, 197, 'Arak’s', 'AM', 'AV'),
(1625, 12, 197, 'Arazap’', 'AM', 'AV'),
(1626, 12, 197, 'Arbat’', 'AM', 'AV'),
(1627, 12, 197, 'Arevashat', 'AM', 'AV'),
(1628, 12, 197, 'Arevik', 'AM', 'AV'),
(1629, 12, 197, 'Argavand', 'AM', 'AV'),
(1630, 12, 197, 'Armavir', 'AM', 'AV'),
(1631, 12, 197, 'Arshaluys', 'AM', 'AV'),
(1632, 12, 197, 'Artimet', 'AM', 'AV'),
(1633, 12, 197, 'Aygek', 'AM', 'AV'),
(1634, 12, 197, 'Aygeshat', 'AM', 'AV'),
(1635, 12, 197, 'Baghramyan', 'AM', 'AV'),
(1636, 12, 197, 'Bambakashat', 'AM', 'AV'),
(1637, 12, 197, 'Dalarik', 'AM', 'AV'),
(1638, 12, 197, 'Doghs', 'AM', 'AV'),
(1639, 12, 197, 'Gay', 'AM', 'AV'),
(1640, 12, 197, 'Geghakert', 'AM', 'AV'),
(1641, 12, 197, 'Geghanist', 'AM', 'AV'),
(1642, 12, 197, 'Getashen', 'AM', 'AV'),
(1643, 12, 197, 'Gmbet’', 'AM', 'AV'),
(1644, 12, 197, 'Griboyedov', 'AM', 'AV'),
(1645, 12, 197, 'Haykashen', 'AM', 'AV'),
(1646, 12, 197, 'Hovtamej', 'AM', 'AV'),
(1647, 12, 197, 'Janfida', 'AM', 'AV'),
(1648, 12, 197, 'Khoronk’', 'AM', 'AV'),
(1649, 12, 197, 'Lenughi', 'AM', 'AV'),
(1650, 12, 197, 'Lukashin', 'AM', 'AV'),
(1651, 12, 197, 'Margara', 'AM', 'AV'),
(1652, 12, 197, 'Mayisyan', 'AM', 'AV'),
(1653, 12, 197, 'Merdzavan', 'AM', 'AV'),
(1654, 12, 197, 'Metsamor', 'AM', 'AV'),
(1655, 12, 197, 'Mrgashat', 'AM', 'AV'),
(1656, 12, 197, 'Musalerr', 'AM', 'AV'),
(1657, 12, 197, 'Myasnikyan', 'AM', 'AV'),
(1658, 12, 197, 'Nalbandyan', 'AM', 'AV'),
(1659, 12, 197, 'Nor Armavir', 'AM', 'AV'),
(1660, 12, 197, 'Norakert', 'AM', 'AV'),
(1661, 12, 197, 'P’shatavan', 'AM', 'AV'),
(1662, 12, 197, 'Ptghunk’', 'AM', 'AV'),
(1663, 12, 197, 'Sardarapat', 'AM', 'AV'),
(1664, 12, 197, 'Shenavan', 'AM', 'AV'),
(1665, 12, 197, 'Tandzut', 'AM', 'AV'),
(1666, 12, 197, 'Taronik', 'AM', 'AV'),
(1667, 12, 197, 'Tsaghkunk’', 'AM', 'AV'),
(1668, 12, 197, 'Tsiatsan', 'AM', 'AV'),
(1669, 12, 197, 'Vagharshapat', 'AM', 'AV'),
(1670, 12, 197, 'Voskehat', 'AM', 'AV'),
(1671, 12, 197, 'Yeghegnut', 'AM', 'AV'),
(1672, 12, 197, 'Yeraskhahun', 'AM', 'AV'),
(1673, 12, 198, 'Akunk’', 'AM', 'GR'),
(1674, 12, 198, 'Astghadzor', 'AM', 'GR'),
(1675, 12, 198, 'Chambarak', 'AM', 'GR'),
(1676, 12, 198, 'Ddmashen', 'AM', 'GR'),
(1677, 12, 198, 'Drakhtik', 'AM', 'GR'),
(1678, 12, 198, 'Dzoragyugh', 'AM', 'GR'),
(1679, 12, 198, 'Gagarin', 'AM', 'GR'),
(1680, 12, 198, 'Gandzak', 'AM', 'GR'),
(1681, 12, 198, 'Gavarr', 'AM', 'GR'),
(1682, 12, 198, 'Geghamasar', 'AM', 'GR'),
(1683, 12, 198, 'Geghamavan', 'AM', 'GR'),
(1684, 12, 198, 'Karanlukh', 'AM', 'GR'),
(1685, 12, 198, 'Karchaghbyur', 'AM', 'GR'),
(1686, 12, 198, 'Lanjaghbyur', 'AM', 'GR'),
(1687, 12, 198, 'Lchap’', 'AM', 'GR'),
(1688, 12, 198, 'Lchashen', 'AM', 'GR'),
(1689, 12, 198, 'Lichk’', 'AM', 'GR'),
(1690, 12, 198, 'Madina', 'AM', 'GR'),
(1691, 12, 198, 'Martuni', 'AM', 'GR'),
(1692, 12, 198, 'Mets Masrik', 'AM', 'GR'),
(1693, 12, 198, 'Nerk’in Getashen', 'AM', 'GR'),
(1694, 12, 198, 'Noratus', 'AM', 'GR'),
(1695, 12, 198, 'Sarukhan', 'AM', 'GR'),
(1696, 12, 198, 'Sevan', 'AM', 'GR'),
(1697, 12, 198, 'Tsovagyugh', 'AM', 'GR'),
(1698, 12, 198, 'Tsovak', 'AM', 'GR'),
(1699, 12, 198, 'Tsovasar', 'AM', 'GR'),
(1700, 12, 198, 'Tsovazard', 'AM', 'GR'),
(1701, 12, 198, 'Tsovinar', 'AM', 'GR'),
(1702, 12, 198, 'Vaghashen', 'AM', 'GR'),
(1703, 12, 198, 'Vahan', 'AM', 'GR'),
(1704, 12, 198, 'Vardenik', 'AM', 'GR'),
(1705, 12, 198, 'Vardenis', 'AM', 'GR'),
(1706, 12, 198, 'Varser', 'AM', 'GR'),
(1707, 12, 198, 'Verin Getashen', 'AM', 'GR'),
(1708, 12, 198, 'Yeranos', 'AM', 'GR'),
(1709, 12, 199, 'Abovyan', 'AM', 'KT'),
(1710, 12, 199, 'Aghavnadzor', 'AM', 'KT'),
(1711, 12, 199, 'Akunk’', 'AM', 'KT'),
(1712, 12, 199, 'Aramus', 'AM', 'KT'),
(1713, 12, 199, 'Argel', 'AM', 'KT'),
(1714, 12, 199, 'Arzakan', 'AM', 'KT'),
(1715, 12, 199, 'Arzni', 'AM', 'KT'),
(1716, 12, 199, 'Balahovit', 'AM', 'KT'),
(1717, 12, 199, 'Bjni', 'AM', 'KT'),
(1718, 12, 199, 'Buzhakan', 'AM', 'KT'),
(1719, 12, 199, 'Byureghavan', 'AM', 'KT'),
(1720, 12, 199, 'Dzoraghbyur', 'AM', 'KT'),
(1721, 12, 199, 'Fantan', 'AM', 'KT'),
(1722, 12, 199, 'Garrni', 'AM', 'KT'),
(1723, 12, 199, 'Goght’', 'AM', 'KT'),
(1724, 12, 199, 'Hrazdan', 'AM', 'KT'),
(1725, 12, 199, 'Kaputan', 'AM', 'KT'),
(1726, 12, 199, 'Kotayk’', 'AM', 'KT'),
(1727, 12, 199, 'Lerrnanist', 'AM', 'KT'),
(1728, 12, 199, 'Mayakovski', 'AM', 'KT'),
(1729, 12, 199, 'Meghradzor', 'AM', 'KT'),
(1730, 12, 199, 'Mrgashen', 'AM', 'KT'),
(1731, 12, 199, 'Nor Geghi', 'AM', 'KT'),
(1732, 12, 199, 'Nor Gyugh', 'AM', 'KT'),
(1733, 12, 199, 'Prroshyan', 'AM', 'KT'),
(1734, 12, 199, 'Ptghni', 'AM', 'KT'),
(1735, 12, 199, 'Solak', 'AM', 'KT'),
(1736, 12, 199, 'Tsaghkadzor', 'AM', 'KT'),
(1737, 12, 199, 'Yeghvard', 'AM', 'KT'),
(1738, 12, 199, 'Zarr', 'AM', 'KT'),
(1739, 12, 199, 'Zoravan', 'AM', 'KT'),
(1740, 12, 199, 'Zovaber', 'AM', 'KT'),
(1741, 12, 200, 'Agarak', 'AM', 'LO'),
(1742, 12, 200, 'Akht’ala', 'AM', 'LO'),
(1743, 12, 200, 'Alaverdi', 'AM', 'LO'),
(1744, 12, 200, 'Arevashogh', 'AM', 'LO'),
(1745, 12, 200, 'Bazum', 'AM', 'LO'),
(1746, 12, 200, 'Chochkan', 'AM', 'LO'),
(1747, 12, 200, 'Darpas', 'AM', 'LO'),
(1748, 12, 200, 'Dsegh', 'AM', 'LO'),
(1749, 12, 200, 'Fioletovo', 'AM', 'LO'),
(1750, 12, 200, 'Gogaran', 'AM', 'LO'),
(1751, 12, 200, 'Gugark’', 'AM', 'LO'),
(1752, 12, 200, 'Gyulagarak', 'AM', 'LO'),
(1753, 12, 200, 'Jrashen', 'AM', 'LO'),
(1754, 12, 200, 'Lerrnants’k’', 'AM', 'LO'),
(1755, 12, 200, 'Lerrnapat', 'AM', 'LO'),
(1756, 12, 200, 'Lerrnavan', 'AM', 'LO'),
(1757, 12, 200, 'Lorut', 'AM', 'LO'),
(1758, 12, 200, 'Margahovit', 'AM', 'LO'),
(1759, 12, 200, 'Mets Parni', 'AM', 'LO'),
(1760, 12, 200, 'Metsavan', 'AM', 'LO'),
(1761, 12, 200, 'Norashen', 'AM', 'LO'),
(1762, 12, 200, 'Odzun', 'AM', 'LO'),
(1763, 12, 200, 'Sarahart’', 'AM', 'LO'),
(1764, 12, 200, 'Saramej', 'AM', 'LO'),
(1765, 12, 200, 'Shahumyan', 'AM', 'LO'),
(1766, 12, 200, 'Shirakamut', 'AM', 'LO'),
(1767, 12, 200, 'Shnogh', 'AM', 'LO'),
(1768, 12, 200, 'Spitak', 'AM', 'LO'),
(1769, 12, 200, 'Step’anavan', 'AM', 'LO'),
(1770, 12, 200, 'Tashir', 'AM', 'LO'),
(1771, 12, 200, 'Tsaghkaber', 'AM', 'LO'),
(1772, 12, 200, 'Urrut', 'AM', 'LO'),
(1773, 12, 200, 'Vahagni', 'AM', 'LO'),
(1774, 12, 200, 'Vanadzor', 'AM', 'LO'),
(1775, 12, 200, 'Vardablur', 'AM', 'LO'),
(1776, 12, 200, 'Yeghegnut', 'AM', 'LO'),
(1777, 12, 201, 'Akhuryan', 'AM', 'SH'),
(1778, 12, 201, 'Amasia', 'AM', 'SH'),
(1779, 12, 201, 'Anushavan', 'AM', 'SH'),
(1780, 12, 201, 'Arevik', 'AM', 'SH'),
(1781, 12, 201, 'Arevshat', 'AM', 'SH'),
(1782, 12, 201, 'Arrap’i', 'AM', 'SH'),
(1783, 12, 201, 'Azatan', 'AM', 'SH'),
(1784, 12, 201, 'Basen', 'AM', 'SH'),
(1785, 12, 201, 'Dzit’hank’ov', 'AM', 'SH'),
(1786, 12, 201, 'Gyumri', 'AM', 'SH'),
(1787, 12, 201, 'Haykavan', 'AM', 'SH'),
(1788, 12, 201, 'Horrom', 'AM', 'SH'),
(1789, 12, 201, 'Kamo', 'AM', 'SH'),
(1790, 12, 201, 'Lerrnakert', 'AM', 'SH'),
(1791, 12, 201, 'Maralik', 'AM', 'SH'),
(1792, 12, 201, 'Marmashen', 'AM', 'SH'),
(1793, 12, 201, 'Mayisyan', 'AM', 'SH'),
(1794, 12, 201, 'Meghrashen', 'AM', 'SH'),
(1795, 12, 201, 'Mets Mant’ash', 'AM', 'SH'),
(1796, 12, 201, 'P’ok’r Mant’ash', 'AM', 'SH'),
(1797, 12, 201, 'Pemzashen', 'AM', 'SH'),
(1798, 12, 201, 'Saratak', 'AM', 'SH'),
(1799, 12, 201, 'Shirak', 'AM', 'SH'),
(1800, 12, 201, 'Spandaryan', 'AM', 'SH'),
(1801, 12, 201, 'Voskehask', 'AM', 'SH'),
(1802, 12, 201, 'Yerazgavors', 'AM', 'SH'),
(1803, 12, 202, 'Agarak', 'AM', 'SU'),
(1804, 12, 202, 'Akner', 'AM', 'SU'),
(1805, 12, 202, 'Angeghakot’', 'AM', 'SU'),
(1806, 12, 202, 'Brrnakot’', 'AM', 'SU'),
(1807, 12, 202, 'Dzorastan', 'AM', 'SU'),
(1808, 12, 202, 'Goris', 'AM', 'SU'),
(1809, 12, 202, 'Hats’avan', 'AM', 'SU'),
(1810, 12, 202, 'Kapan', 'AM', 'SU'),
(1811, 12, 202, 'Khndzoresk', 'AM', 'SU'),
(1812, 12, 202, 'Meghri', 'AM', 'SU'),
(1813, 12, 202, 'Shaghat', 'AM', 'SU'),
(1814, 12, 202, 'Shinuhayr', 'AM', 'SU'),
(1815, 12, 202, 'Tegh', 'AM', 'SU'),
(1816, 12, 202, 'Verishen', 'AM', 'SU'),
(1817, 12, 203, 'Archis', 'AM', 'TV'),
(1818, 12, 203, 'Artsvaberd', 'AM', 'TV'),
(1819, 12, 203, 'Aygehovit', 'AM', 'TV'),
(1820, 12, 203, 'Azatamut', 'AM', 'TV'),
(1821, 12, 203, 'Bagratashen', 'AM', 'TV'),
(1822, 12, 203, 'Berd', 'AM', 'TV'),
(1823, 12, 203, 'Berdavan', 'AM', 'TV'),
(1824, 12, 203, 'Dilijan', 'AM', 'TV'),
(1825, 12, 203, 'Haghartsin', 'AM', 'TV'),
(1826, 12, 203, 'Ijevan', 'AM', 'TV'),
(1827, 12, 203, 'Khasht’arrak', 'AM', 'TV'),
(1828, 12, 203, 'Mosesgegh', 'AM', 'TV'),
(1829, 12, 203, 'Navur', 'AM', 'TV'),
(1830, 12, 203, 'Noyemberyan', 'AM', 'TV'),
(1831, 12, 203, 'Parravak’ar', 'AM', 'TV'),
(1832, 12, 203, 'Sarigyugh', 'AM', 'TV'),
(1833, 12, 203, 'Voskevan', 'AM', 'TV'),
(1834, 12, 204, 'Agarakadzor', 'AM', 'VD'),
(1835, 12, 204, 'Aghavnadzor', 'AM', 'VD'),
(1836, 12, 204, 'Areni', 'AM', 'VD'),
(1837, 12, 204, 'Getap’', 'AM', 'VD'),
(1838, 12, 204, 'Gladzor', 'AM', 'VD'),
(1839, 12, 204, 'Jermuk', 'AM', 'VD'),
(1840, 12, 204, 'Malishka', 'AM', 'VD'),
(1841, 12, 204, 'Rrind', 'AM', 'VD'),
(1842, 12, 204, 'Shatin', 'AM', 'VD'),
(1843, 12, 204, 'Vayk’', 'AM', 'VD'),
(1844, 12, 204, 'Vernashen', 'AM', 'VD'),
(1845, 12, 204, 'Yeghegis', 'AM', 'VD'),
(1846, 12, 204, 'Yeghegnadzor', 'AM', 'VD'),
(1847, 12, 204, 'Zarrit’ap’', 'AM', 'VD'),
(1848, 12, 205, 'Arabkir', 'AM', 'ER'),
(1849, 12, 205, 'Argavand', 'AM', 'ER'),
(1850, 12, 205, 'Jrashen', 'AM', 'ER'),
(1851, 12, 205, 'K’anak’erravan', 'AM', 'ER'),
(1852, 12, 205, 'Vardadzor', 'AM', 'ER'),
(1853, 12, 205, 'Yerevan', 'AM', 'ER'),
(1854, 14, 206, 'Acton', 'AU', 'ACT'),
(1855, 14, 206, 'Ainslie', 'AU', 'ACT'),
(1856, 14, 206, 'Amaroo', 'AU', 'ACT'),
(1857, 14, 206, 'Aranda', 'AU', 'ACT'),
(1858, 14, 206, 'Banks', 'AU', 'ACT'),
(1859, 14, 206, 'Barton', 'AU', 'ACT'),
(1860, 14, 206, 'Belconnen', 'AU', 'ACT'),
(1861, 14, 206, 'Bonner', 'AU', 'ACT'),
(1862, 14, 206, 'Bonython', 'AU', 'ACT'),
(1863, 14, 206, 'Braddon', 'AU', 'ACT'),
(1864, 14, 206, 'Bruce', 'AU', 'ACT'),
(1865, 14, 206, 'Calwell', 'AU', 'ACT'),
(1866, 14, 206, 'Campbell', 'AU', 'ACT'),
(1867, 14, 206, 'Canberra', 'AU', 'ACT'),
(1868, 14, 206, 'Casey', 'AU', 'ACT'),
(1869, 14, 206, 'Chapman', 'AU', 'ACT'),
(1870, 14, 206, 'Charnwood', 'AU', 'ACT'),
(1871, 14, 206, 'Chifley', 'AU', 'ACT'),
(1872, 14, 206, 'Chisholm', 'AU', 'ACT'),
(1873, 14, 206, 'City', 'AU', 'ACT'),
(1874, 14, 206, 'Conder', 'AU', 'ACT'),
(1875, 14, 206, 'Cook', 'AU', 'ACT'),
(1876, 14, 206, 'Coombs', 'AU', 'ACT'),
(1877, 14, 206, 'Crace', 'AU', 'ACT'),
(1878, 14, 206, 'Curtin', 'AU', 'ACT'),
(1879, 14, 206, 'Deakin', 'AU', 'ACT'),
(1880, 14, 206, 'Dickson', 'AU', 'ACT'),
(1881, 14, 206, 'Downer', 'AU', 'ACT'),
(1882, 14, 206, 'Duffy', 'AU', 'ACT'),
(1883, 14, 206, 'Dunlop', 'AU', 'ACT'),
(1884, 14, 206, 'Evatt', 'AU', 'ACT'),
(1885, 14, 206, 'Fadden', 'AU', 'ACT'),
(1886, 14, 206, 'Farrer', 'AU', 'ACT'),
(1887, 14, 206, 'Fisher', 'AU', 'ACT'),
(1888, 14, 206, 'Florey', 'AU', 'ACT'),
(1889, 14, 206, 'Flynn', 'AU', 'ACT'),
(1890, 14, 206, 'Forde', 'AU', 'ACT'),
(1891, 14, 206, 'Forrest', 'AU', 'ACT'),
(1892, 14, 206, 'Franklin', 'AU', 'ACT'),
(1893, 14, 206, 'Fraser', 'AU', 'ACT'),
(1894, 14, 206, 'Garran', 'AU', 'ACT'),
(1895, 14, 206, 'Gilmore', 'AU', 'ACT'),
(1896, 14, 206, 'Giralang', 'AU', 'ACT'),
(1897, 14, 206, 'Gordon', 'AU', 'ACT'),
(1898, 14, 206, 'Gowrie', 'AU', 'ACT'),
(1899, 14, 206, 'Greenway', 'AU', 'ACT'),
(1900, 14, 206, 'Griffith', 'AU', 'ACT'),
(1901, 14, 206, 'Gungahlin', 'AU', 'ACT'),
(1902, 14, 206, 'Hackett', 'AU', 'ACT'),
(1903, 14, 206, 'Harrison', 'AU', 'ACT'),
(1904, 14, 206, 'Hawker', 'AU', 'ACT'),
(1905, 14, 206, 'Higgins', 'AU', 'ACT'),
(1906, 14, 206, 'Holder', 'AU', 'ACT'),
(1907, 14, 206, 'Holt', 'AU', 'ACT'),
(1908, 14, 206, 'Hughes', 'AU', 'ACT'),
(1909, 14, 206, 'Isaacs', 'AU', 'ACT'),
(1910, 14, 206, 'Isabella Plains', 'AU', 'ACT'),
(1911, 14, 206, 'Kaleen', 'AU', 'ACT'),
(1912, 14, 206, 'Kambah', 'AU', 'ACT'),
(1913, 14, 206, 'Kingston', 'AU', 'ACT'),
(1914, 14, 206, 'Latham', 'AU', 'ACT'),
(1915, 14, 206, 'Lyneham', 'AU', 'ACT'),
(1916, 14, 206, 'Lyons', 'AU', 'ACT'),
(1917, 14, 206, 'Macarthur', 'AU', 'ACT'),
(1918, 14, 206, 'Macgregor', 'AU', 'ACT'),
(1919, 14, 206, 'Macquarie', 'AU', 'ACT'),
(1920, 14, 206, 'Mawson', 'AU', 'ACT'),
(1921, 14, 206, 'McKellar', 'AU', 'ACT'),
(1922, 14, 206, 'Melba', 'AU', 'ACT'),
(1923, 14, 206, 'Monash', 'AU', 'ACT'),
(1924, 14, 206, 'Narrabundah', 'AU', 'ACT'),
(1925, 14, 206, 'Ngunnawal', 'AU', 'ACT'),
(1926, 14, 206, 'Nicholls', 'AU', 'ACT'),
(1927, 14, 206, 'O\'Connor', 'AU', 'ACT'),
(1928, 14, 206, 'Oxley', 'AU', 'ACT'),
(1929, 14, 206, 'Page', 'AU', 'ACT'),
(1930, 14, 206, 'Palmerston', 'AU', 'ACT'),
(1931, 14, 206, 'Pearce', 'AU', 'ACT'),
(1932, 14, 206, 'Phillip', 'AU', 'ACT'),
(1933, 14, 206, 'Red Hill', 'AU', 'ACT'),
(1934, 14, 206, 'Reid', 'AU', 'ACT'),
(1935, 14, 206, 'Richardson', 'AU', 'ACT'),
(1936, 14, 206, 'Rivett', 'AU', 'ACT'),
(1937, 14, 206, 'Scullin', 'AU', 'ACT'),
(1938, 14, 206, 'Spence', 'AU', 'ACT'),
(1939, 14, 206, 'Stirling', 'AU', 'ACT'),
(1940, 14, 206, 'Theodore', 'AU', 'ACT'),
(1941, 14, 206, 'Torrens', 'AU', 'ACT'),
(1942, 14, 206, 'Turner', 'AU', 'ACT'),
(1943, 14, 206, 'Wanniassa', 'AU', 'ACT'),
(1944, 14, 206, 'Waramanga', 'AU', 'ACT'),
(1945, 14, 206, 'Watson', 'AU', 'ACT'),
(1946, 14, 206, 'Weetangera', 'AU', 'ACT'),
(1947, 14, 206, 'Weston', 'AU', 'ACT'),
(1948, 14, 206, 'Wright', 'AU', 'ACT'),
(1949, 14, 206, 'Yarralumla', 'AU', 'ACT'),
(1950, 14, 207, 'Abbotsbury', 'AU', 'NSW'),
(1951, 14, 207, 'Abbotsford', 'AU', 'NSW'),
(1952, 14, 207, 'Abercrombie', 'AU', 'NSW'),
(1953, 14, 207, 'Aberdare', 'AU', 'NSW'),
(1954, 14, 207, 'Aberdeen', 'AU', 'NSW'),
(1955, 14, 207, 'Aberglasslyn', 'AU', 'NSW'),
(1956, 14, 207, 'Abermain', 'AU', 'NSW'),
(1957, 14, 207, 'Acacia Gardens', 'AU', 'NSW'),
(1958, 14, 207, 'Adamstown', 'AU', 'NSW'),
(1959, 14, 207, 'Adamstown Heights', 'AU', 'NSW'),
(1960, 14, 207, 'Airds', 'AU', 'NSW'),
(1961, 14, 207, 'Albion Park', 'AU', 'NSW'),
(1962, 14, 207, 'Albion Park Rail', 'AU', 'NSW'),
(1963, 14, 207, 'Albury', 'AU', 'NSW'),
(1964, 14, 207, 'Albury Municipality', 'AU', 'NSW'),
(1965, 14, 207, 'Aldavilla', 'AU', 'NSW'),
(1966, 14, 207, 'Alexandria', 'AU', 'NSW'),
(1967, 14, 207, 'Alfords Point', 'AU', 'NSW'),
(1968, 14, 207, 'Allambie Heights', 'AU', 'NSW'),
(1969, 14, 207, 'Allawah', 'AU', 'NSW'),
(1970, 14, 207, 'Alstonville', 'AU', 'NSW'),
(1971, 14, 207, 'Ambarvale', 'AU', 'NSW'),
(1972, 14, 207, 'Anna Bay', 'AU', 'NSW'),
(1973, 14, 207, 'Annandale', 'AU', 'NSW'),
(1974, 14, 207, 'Annangrove', 'AU', 'NSW'),
(1975, 14, 207, 'Appin', 'AU', 'NSW'),
(1976, 14, 207, 'Arcadia', 'AU', 'NSW'),
(1977, 14, 207, 'Arcadia vale', 'AU', 'NSW'),
(1978, 14, 207, 'Argenton', 'AU', 'NSW'),
(1979, 14, 207, 'Armidale', 'AU', 'NSW'),
(1980, 14, 207, 'Arncliffe', 'AU', 'NSW'),
(1981, 14, 207, 'Artarmon', 'AU', 'NSW'),
(1982, 14, 207, 'Ashbury', 'AU', 'NSW'),
(1983, 14, 207, 'Ashcroft', 'AU', 'NSW'),
(1984, 14, 207, 'Ashfield', 'AU', 'NSW'),
(1985, 14, 207, 'Ashmont', 'AU', 'NSW'),
(1986, 14, 207, 'Ashtonfield', 'AU', 'NSW'),
(1987, 14, 207, 'Asquith', 'AU', 'NSW'),
(1988, 14, 207, 'Auburn', 'AU', 'NSW'),
(1989, 14, 207, 'Austinmer', 'AU', 'NSW'),
(1990, 14, 207, 'Austral', 'AU', 'NSW'),
(1991, 14, 207, 'Avoca Beach', 'AU', 'NSW'),
(1992, 14, 207, 'Avondale', 'AU', 'NSW'),
(1993, 14, 207, 'Balgowlah', 'AU', 'NSW'),
(1994, 14, 207, 'Balgowlah Heights', 'AU', 'NSW'),
(1995, 14, 207, 'Balgownie', 'AU', 'NSW'),
(1996, 14, 207, 'Ballina', 'AU', 'NSW'),
(1997, 14, 207, 'Balmain', 'AU', 'NSW'),
(1998, 14, 207, 'Balmain East', 'AU', 'NSW'),
(1999, 14, 207, 'Balranald', 'AU', 'NSW'),
(2000, 14, 207, 'Bangalow', 'AU', 'NSW');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(2001, 14, 207, 'Bangor', 'AU', 'NSW'),
(2002, 14, 207, 'Banksia', 'AU', 'NSW'),
(2003, 14, 207, 'Banksmeadow', 'AU', 'NSW'),
(2004, 14, 207, 'Bankstown', 'AU', 'NSW'),
(2005, 14, 207, 'Banora Point', 'AU', 'NSW'),
(2006, 14, 207, 'Bar Beach', 'AU', 'NSW'),
(2007, 14, 207, 'Barden Ridge', 'AU', 'NSW'),
(2008, 14, 207, 'Bardia', 'AU', 'NSW'),
(2009, 14, 207, 'Bardwell Park', 'AU', 'NSW'),
(2010, 14, 207, 'Bardwell Valley', 'AU', 'NSW'),
(2011, 14, 207, 'Bargo', 'AU', 'NSW'),
(2012, 14, 207, 'Barham', 'AU', 'NSW'),
(2013, 14, 207, 'Barnsley', 'AU', 'NSW'),
(2014, 14, 207, 'Barooga', 'AU', 'NSW'),
(2015, 14, 207, 'Barraba', 'AU', 'NSW'),
(2016, 14, 207, 'Barrack Heights', 'AU', 'NSW'),
(2017, 14, 207, 'Basin View', 'AU', 'NSW'),
(2018, 14, 207, 'Bass Hill', 'AU', 'NSW'),
(2019, 14, 207, 'Bateau Bay', 'AU', 'NSW'),
(2020, 14, 207, 'Batehaven', 'AU', 'NSW'),
(2021, 14, 207, 'Batemans Bay', 'AU', 'NSW'),
(2022, 14, 207, 'Bathurst', 'AU', 'NSW'),
(2023, 14, 207, 'Bathurst city centre', 'AU', 'NSW'),
(2024, 14, 207, 'Bathurst Regional', 'AU', 'NSW'),
(2025, 14, 207, 'Batlow', 'AU', 'NSW'),
(2026, 14, 207, 'Baulkham Hills', 'AU', 'NSW'),
(2027, 14, 207, 'Bay View', 'AU', 'NSW'),
(2028, 14, 207, 'Beacon Hill', 'AU', 'NSW'),
(2029, 14, 207, 'Beaumont Hills', 'AU', 'NSW'),
(2030, 14, 207, 'Beecroft', 'AU', 'NSW'),
(2031, 14, 207, 'Bega', 'AU', 'NSW'),
(2032, 14, 207, 'Bega Valley', 'AU', 'NSW'),
(2033, 14, 207, 'Belfield', 'AU', 'NSW'),
(2034, 14, 207, 'Bella Vista', 'AU', 'NSW'),
(2035, 14, 207, 'Bellambi', 'AU', 'NSW'),
(2036, 14, 207, 'Bellbird', 'AU', 'NSW'),
(2037, 14, 207, 'Bellevue Hill', 'AU', 'NSW'),
(2038, 14, 207, 'Bellingen', 'AU', 'NSW'),
(2039, 14, 207, 'Belmont', 'AU', 'NSW'),
(2040, 14, 207, 'Belmont North', 'AU', 'NSW'),
(2041, 14, 207, 'Belmont South', 'AU', 'NSW'),
(2042, 14, 207, 'Belmore', 'AU', 'NSW'),
(2043, 14, 207, 'Belrose', 'AU', 'NSW'),
(2044, 14, 207, 'Bensville', 'AU', 'NSW'),
(2045, 14, 207, 'Berala', 'AU', 'NSW'),
(2046, 14, 207, 'Beresfield', 'AU', 'NSW'),
(2047, 14, 207, 'Berkeley', 'AU', 'NSW'),
(2048, 14, 207, 'Berkeley Vale', 'AU', 'NSW'),
(2049, 14, 207, 'Berkshire Park', 'AU', 'NSW'),
(2050, 14, 207, 'Bermagui', 'AU', 'NSW'),
(2051, 14, 207, 'Berowra', 'AU', 'NSW'),
(2052, 14, 207, 'Berowra Heights', 'AU', 'NSW'),
(2053, 14, 207, 'Berridale', 'AU', 'NSW'),
(2054, 14, 207, 'Berrigan', 'AU', 'NSW'),
(2055, 14, 207, 'Berry', 'AU', 'NSW'),
(2056, 14, 207, 'Beverley Park', 'AU', 'NSW'),
(2057, 14, 207, 'Beverly Hills', 'AU', 'NSW'),
(2058, 14, 207, 'Bexley', 'AU', 'NSW'),
(2059, 14, 207, 'Bexley North', 'AU', 'NSW'),
(2060, 14, 207, 'Bidwill', 'AU', 'NSW'),
(2061, 14, 207, 'Bilambil Heights', 'AU', 'NSW'),
(2062, 14, 207, 'Bilgola Plateau', 'AU', 'NSW'),
(2063, 14, 207, 'Bingara', 'AU', 'NSW'),
(2064, 14, 207, 'Birchgrove', 'AU', 'NSW'),
(2065, 14, 207, 'Birmingham Gardens', 'AU', 'NSW'),
(2066, 14, 207, 'Birrong', 'AU', 'NSW'),
(2067, 14, 207, 'Blackalls Park', 'AU', 'NSW'),
(2068, 14, 207, 'Blackbutt', 'AU', 'NSW'),
(2069, 14, 207, 'Blackett', 'AU', 'NSW'),
(2070, 14, 207, 'Blackheath', 'AU', 'NSW'),
(2071, 14, 207, 'Blacksmiths', 'AU', 'NSW'),
(2072, 14, 207, 'Blacktown', 'AU', 'NSW'),
(2073, 14, 207, 'Blackwall', 'AU', 'NSW'),
(2074, 14, 207, 'Blair Athol', 'AU', 'NSW'),
(2075, 14, 207, 'Blakehurst', 'AU', 'NSW'),
(2076, 14, 207, 'Bland', 'AU', 'NSW'),
(2077, 14, 207, 'Blaxland', 'AU', 'NSW'),
(2078, 14, 207, 'Blayney', 'AU', 'NSW'),
(2079, 14, 207, 'Bligh Park', 'AU', 'NSW'),
(2080, 14, 207, 'Blue Bay', 'AU', 'NSW'),
(2081, 14, 207, 'Blue Haven', 'AU', 'NSW'),
(2082, 14, 207, 'Blue Mountains Municipality', 'AU', 'NSW'),
(2083, 14, 207, 'Boambee', 'AU', 'NSW'),
(2084, 14, 207, 'Boambee East', 'AU', 'NSW'),
(2085, 14, 207, 'Bogan', 'AU', 'NSW'),
(2086, 14, 207, 'Bogangar', 'AU', 'NSW'),
(2087, 14, 207, 'Boggabri', 'AU', 'NSW'),
(2088, 14, 207, 'Bolton Point', 'AU', 'NSW'),
(2089, 14, 207, 'Bolwarra Heights', 'AU', 'NSW'),
(2090, 14, 207, 'Bomaderry', 'AU', 'NSW'),
(2091, 14, 207, 'Bombala', 'AU', 'NSW'),
(2092, 14, 207, 'Bondi', 'AU', 'NSW'),
(2093, 14, 207, 'Bondi Beach', 'AU', 'NSW'),
(2094, 14, 207, 'Bondi Junction', 'AU', 'NSW'),
(2095, 14, 207, 'Bonnells Bay', 'AU', 'NSW'),
(2096, 14, 207, 'Bonnet Bay', 'AU', 'NSW'),
(2097, 14, 207, 'Bonny Hills', 'AU', 'NSW'),
(2098, 14, 207, 'Bonnyrigg', 'AU', 'NSW'),
(2099, 14, 207, 'Bonnyrigg Heights', 'AU', 'NSW'),
(2100, 14, 207, 'Bonville', 'AU', 'NSW'),
(2101, 14, 207, 'Booker Bay', 'AU', 'NSW'),
(2102, 14, 207, 'Booragul', 'AU', 'NSW'),
(2103, 14, 207, 'Boorowa', 'AU', 'NSW'),
(2104, 14, 207, 'Bossley Park', 'AU', 'NSW'),
(2105, 14, 207, 'Botany', 'AU', 'NSW'),
(2106, 14, 207, 'Botany Bay', 'AU', 'NSW'),
(2107, 14, 207, 'Bourke', 'AU', 'NSW'),
(2108, 14, 207, 'Bourkelands', 'AU', 'NSW'),
(2109, 14, 207, 'Bow Bowing', 'AU', 'NSW'),
(2110, 14, 207, 'Bowen Mountain', 'AU', 'NSW'),
(2111, 14, 207, 'Bowenfels', 'AU', 'NSW'),
(2112, 14, 207, 'Bowral', 'AU', 'NSW'),
(2113, 14, 207, 'Bowraville', 'AU', 'NSW'),
(2114, 14, 207, 'Bradbury', 'AU', 'NSW'),
(2115, 14, 207, 'Braidwood', 'AU', 'NSW'),
(2116, 14, 207, 'Branxton', 'AU', 'NSW'),
(2117, 14, 207, 'Breakfast Point', 'AU', 'NSW'),
(2118, 14, 207, 'Brewarrina', 'AU', 'NSW'),
(2119, 14, 207, 'Brighton-Le-Sands', 'AU', 'NSW'),
(2120, 14, 207, 'Bringelly', 'AU', 'NSW'),
(2121, 14, 207, 'Broadmeadow', 'AU', 'NSW'),
(2122, 14, 207, 'Broken Hill', 'AU', 'NSW'),
(2123, 14, 207, 'Broken Hill Municipality', 'AU', 'NSW'),
(2124, 14, 207, 'Bronte', 'AU', 'NSW'),
(2125, 14, 207, 'Brookvale', 'AU', 'NSW'),
(2126, 14, 207, 'Broulee', 'AU', 'NSW'),
(2127, 14, 207, 'Brunswick Heads', 'AU', 'NSW'),
(2128, 14, 207, 'Budgewoi', 'AU', 'NSW'),
(2129, 14, 207, 'Buff Point', 'AU', 'NSW'),
(2130, 14, 207, 'Bulahdelah', 'AU', 'NSW'),
(2131, 14, 207, 'Bullaburra', 'AU', 'NSW'),
(2132, 14, 207, 'Bulli', 'AU', 'NSW'),
(2133, 14, 207, 'Bundanoon', 'AU', 'NSW'),
(2134, 14, 207, 'Bundeena', 'AU', 'NSW'),
(2135, 14, 207, 'Bungarribee', 'AU', 'NSW'),
(2136, 14, 207, 'Bungendore', 'AU', 'NSW'),
(2137, 14, 207, 'Buronga', 'AU', 'NSW'),
(2138, 14, 207, 'Burradoo', 'AU', 'NSW'),
(2139, 14, 207, 'Burraneer', 'AU', 'NSW'),
(2140, 14, 207, 'Burrill Lake', 'AU', 'NSW'),
(2141, 14, 207, 'Burwood', 'AU', 'NSW'),
(2142, 14, 207, 'Busby', 'AU', 'NSW'),
(2143, 14, 207, 'Buttaba', 'AU', 'NSW'),
(2144, 14, 207, 'Buxton', 'AU', 'NSW'),
(2145, 14, 207, 'Byron Bay', 'AU', 'NSW'),
(2146, 14, 207, 'Byron Shire', 'AU', 'NSW'),
(2147, 14, 207, 'Bywong', 'AU', 'NSW'),
(2148, 14, 207, 'Cabarita', 'AU', 'NSW'),
(2149, 14, 207, 'Cabonne', 'AU', 'NSW'),
(2150, 14, 207, 'Cabramatta', 'AU', 'NSW'),
(2151, 14, 207, 'Cabramatta West', 'AU', 'NSW'),
(2152, 14, 207, 'Caddens', 'AU', 'NSW'),
(2153, 14, 207, 'Calala', 'AU', 'NSW'),
(2154, 14, 207, 'Callaghan', 'AU', 'NSW'),
(2155, 14, 207, 'Callala Bay', 'AU', 'NSW'),
(2156, 14, 207, 'Cambewarra Village', 'AU', 'NSW'),
(2157, 14, 207, 'Cambridge Gardens', 'AU', 'NSW'),
(2158, 14, 207, 'Cambridge Park', 'AU', 'NSW'),
(2159, 14, 207, 'Camden', 'AU', 'NSW'),
(2160, 14, 207, 'Camden Haven', 'AU', 'NSW'),
(2161, 14, 207, 'Camden South', 'AU', 'NSW'),
(2162, 14, 207, 'Cameron Park', 'AU', 'NSW'),
(2163, 14, 207, 'Cammeray', 'AU', 'NSW'),
(2164, 14, 207, 'Campbelltown', 'AU', 'NSW'),
(2165, 14, 207, 'Campbelltown Municipality', 'AU', 'NSW'),
(2166, 14, 207, 'Camperdown', 'AU', 'NSW'),
(2167, 14, 207, 'Campsie', 'AU', 'NSW'),
(2168, 14, 207, 'Canada Bay', 'AU', 'NSW'),
(2169, 14, 207, 'Canley Heights', 'AU', 'NSW'),
(2170, 14, 207, 'Canley Vale', 'AU', 'NSW'),
(2171, 14, 207, 'Canowindra', 'AU', 'NSW'),
(2172, 14, 207, 'Canterbury', 'AU', 'NSW'),
(2173, 14, 207, 'Canton Beach', 'AU', 'NSW'),
(2174, 14, 207, 'Cardiff', 'AU', 'NSW'),
(2175, 14, 207, 'Cardiff Heights', 'AU', 'NSW'),
(2176, 14, 207, 'Cardiff South', 'AU', 'NSW'),
(2177, 14, 207, 'Caringbah', 'AU', 'NSW'),
(2178, 14, 207, 'Caringbah South', 'AU', 'NSW'),
(2179, 14, 207, 'Carlingford', 'AU', 'NSW'),
(2180, 14, 207, 'Carlton', 'AU', 'NSW'),
(2181, 14, 207, 'Carnes Hill', 'AU', 'NSW'),
(2182, 14, 207, 'Carramar', 'AU', 'NSW'),
(2183, 14, 207, 'Carrathool', 'AU', 'NSW'),
(2184, 14, 207, 'Carrington', 'AU', 'NSW'),
(2185, 14, 207, 'Carss Park', 'AU', 'NSW'),
(2186, 14, 207, 'Cartwright', 'AU', 'NSW'),
(2187, 14, 207, 'Carwoola', 'AU', 'NSW'),
(2188, 14, 207, 'Casino', 'AU', 'NSW'),
(2189, 14, 207, 'Castle Cove', 'AU', 'NSW'),
(2190, 14, 207, 'Castle Hill', 'AU', 'NSW'),
(2191, 14, 207, 'Castlecrag', 'AU', 'NSW'),
(2192, 14, 207, 'Castlereagh', 'AU', 'NSW'),
(2193, 14, 207, 'Casuarina', 'AU', 'NSW'),
(2194, 14, 207, 'Casula', 'AU', 'NSW'),
(2195, 14, 207, 'Catalina', 'AU', 'NSW'),
(2196, 14, 207, 'Catherine Field', 'AU', 'NSW'),
(2197, 14, 207, 'Caves Beach', 'AU', 'NSW'),
(2198, 14, 207, 'Cecil Hills', 'AU', 'NSW'),
(2199, 14, 207, 'Centennial Park', 'AU', 'NSW'),
(2200, 14, 207, 'Central Darling', 'AU', 'NSW'),
(2201, 14, 207, 'Cessnock', 'AU', 'NSW'),
(2202, 14, 207, 'Chain Valley Bay', 'AU', 'NSW'),
(2203, 14, 207, 'Charlestown', 'AU', 'NSW'),
(2204, 14, 207, 'Charmhaven', 'AU', 'NSW'),
(2205, 14, 207, 'Chatswood', 'AU', 'NSW'),
(2206, 14, 207, 'Chatswood West', 'AU', 'NSW'),
(2207, 14, 207, 'Cherrybrook', 'AU', 'NSW'),
(2208, 14, 207, 'Chester Hill', 'AU', 'NSW'),
(2209, 14, 207, 'Chifley', 'AU', 'NSW'),
(2210, 14, 207, 'Chinderah', 'AU', 'NSW'),
(2211, 14, 207, 'Chippendale', 'AU', 'NSW'),
(2212, 14, 207, 'Chipping Norton', 'AU', 'NSW'),
(2213, 14, 207, 'Chiswick', 'AU', 'NSW'),
(2214, 14, 207, 'Chittaway Bay', 'AU', 'NSW'),
(2215, 14, 207, 'City of Sydney', 'AU', 'NSW'),
(2216, 14, 207, 'Claremont Meadows', 'AU', 'NSW'),
(2217, 14, 207, 'Clarence Town', 'AU', 'NSW'),
(2218, 14, 207, 'Clarence Valley', 'AU', 'NSW'),
(2219, 14, 207, 'Claymore', 'AU', 'NSW'),
(2220, 14, 207, 'Clemton Park', 'AU', 'NSW'),
(2221, 14, 207, 'Clontarf', 'AU', 'NSW'),
(2222, 14, 207, 'Clovelly', 'AU', 'NSW'),
(2223, 14, 207, 'Coal Point', 'AU', 'NSW'),
(2224, 14, 207, 'Cobar', 'AU', 'NSW'),
(2225, 14, 207, 'Cobbitty', 'AU', 'NSW'),
(2226, 14, 207, 'Coffs Harbour', 'AU', 'NSW'),
(2227, 14, 207, 'Coleambally', 'AU', 'NSW'),
(2228, 14, 207, 'Colebee', 'AU', 'NSW'),
(2229, 14, 207, 'Coledale', 'AU', 'NSW'),
(2230, 14, 207, 'Collaroy', 'AU', 'NSW'),
(2231, 14, 207, 'Collaroy Plateau', 'AU', 'NSW'),
(2232, 14, 207, 'Colo Vale', 'AU', 'NSW'),
(2233, 14, 207, 'Colyton', 'AU', 'NSW'),
(2234, 14, 207, 'Como', 'AU', 'NSW'),
(2235, 14, 207, 'Concord', 'AU', 'NSW'),
(2236, 14, 207, 'Concord West', 'AU', 'NSW'),
(2237, 14, 207, 'Condell Park', 'AU', 'NSW'),
(2238, 14, 207, 'Condobolin', 'AU', 'NSW'),
(2239, 14, 207, 'Coniston', 'AU', 'NSW'),
(2240, 14, 207, 'Connells Point', 'AU', 'NSW'),
(2241, 14, 207, 'Constitution Hill', 'AU', 'NSW'),
(2242, 14, 207, 'Coogee', 'AU', 'NSW'),
(2243, 14, 207, 'Cooks Hill', 'AU', 'NSW'),
(2244, 14, 207, 'Coolah', 'AU', 'NSW'),
(2245, 14, 207, 'Coolamon', 'AU', 'NSW'),
(2246, 14, 207, 'Cooma', 'AU', 'NSW'),
(2247, 14, 207, 'Coonabarabran', 'AU', 'NSW'),
(2248, 14, 207, 'Coonamble', 'AU', 'NSW'),
(2249, 14, 207, 'Cooranbong', 'AU', 'NSW'),
(2250, 14, 207, 'Cootamundra', 'AU', 'NSW'),
(2251, 14, 207, 'Copacabana', 'AU', 'NSW'),
(2252, 14, 207, 'Coraki', 'AU', 'NSW'),
(2253, 14, 207, 'Cordeaux Heights', 'AU', 'NSW'),
(2254, 14, 207, 'Corindi Beach', 'AU', 'NSW'),
(2255, 14, 207, 'Corlette', 'AU', 'NSW'),
(2256, 14, 207, 'Corowa', 'AU', 'NSW'),
(2257, 14, 207, 'Corrimal', 'AU', 'NSW'),
(2258, 14, 207, 'Coutts Crossing', 'AU', 'NSW'),
(2259, 14, 207, 'Cowra', 'AU', 'NSW'),
(2260, 14, 207, 'Cranebrook', 'AU', 'NSW'),
(2261, 14, 207, 'Cremorne', 'AU', 'NSW'),
(2262, 14, 207, 'Cremorne Point', 'AU', 'NSW'),
(2263, 14, 207, 'Crescent Head', 'AU', 'NSW'),
(2264, 14, 207, 'Crestwood', 'AU', 'NSW'),
(2265, 14, 207, 'Cringila', 'AU', 'NSW'),
(2266, 14, 207, 'Cromer', 'AU', 'NSW'),
(2267, 14, 207, 'Cronulla', 'AU', 'NSW'),
(2268, 14, 207, 'Crookwell', 'AU', 'NSW'),
(2269, 14, 207, 'Crows Nest', 'AU', 'NSW'),
(2270, 14, 207, 'Croydon', 'AU', 'NSW'),
(2271, 14, 207, 'Culburra Beach', 'AU', 'NSW'),
(2272, 14, 207, 'Culcairn', 'AU', 'NSW'),
(2273, 14, 207, 'Cumbalum', 'AU', 'NSW'),
(2274, 14, 207, 'Cundletown', 'AU', 'NSW'),
(2275, 14, 207, 'Curl Curl', 'AU', 'NSW'),
(2276, 14, 207, 'Currans Hill', 'AU', 'NSW'),
(2277, 14, 207, 'Daceyville', 'AU', 'NSW'),
(2278, 14, 207, 'Dalmeny', 'AU', 'NSW'),
(2279, 14, 207, 'Dapto', 'AU', 'NSW'),
(2280, 14, 207, 'Darling Point', 'AU', 'NSW'),
(2281, 14, 207, 'Darlinghurst', 'AU', 'NSW'),
(2282, 14, 207, 'Darlington', 'AU', 'NSW'),
(2283, 14, 207, 'Darlington Point', 'AU', 'NSW'),
(2284, 14, 207, 'Davidson', 'AU', 'NSW'),
(2285, 14, 207, 'Davistown', 'AU', 'NSW'),
(2286, 14, 207, 'Dean Park', 'AU', 'NSW'),
(2287, 14, 207, 'Dee Why', 'AU', 'NSW'),
(2288, 14, 207, 'Denham Court', 'AU', 'NSW'),
(2289, 14, 207, 'Deniliquin', 'AU', 'NSW'),
(2290, 14, 207, 'Denistone', 'AU', 'NSW'),
(2291, 14, 207, 'Denistone East', 'AU', 'NSW'),
(2292, 14, 207, 'Denman', 'AU', 'NSW'),
(2293, 14, 207, 'Dharruk', 'AU', 'NSW'),
(2294, 14, 207, 'Dolls Point', 'AU', 'NSW'),
(2295, 14, 207, 'Doonside', 'AU', 'NSW'),
(2296, 14, 207, 'Dora Creek', 'AU', 'NSW'),
(2297, 14, 207, 'Dorrigo', 'AU', 'NSW'),
(2298, 14, 207, 'Double Bay', 'AU', 'NSW'),
(2299, 14, 207, 'Douglas Park', 'AU', 'NSW'),
(2300, 14, 207, 'Dover Heights', 'AU', 'NSW'),
(2301, 14, 207, 'Drummoyne', 'AU', 'NSW'),
(2302, 14, 207, 'Dubbo', 'AU', 'NSW'),
(2303, 14, 207, 'Dudley', 'AU', 'NSW'),
(2304, 14, 207, 'Dulwich Hill', 'AU', 'NSW'),
(2305, 14, 207, 'Dundas Valley', 'AU', 'NSW'),
(2306, 14, 207, 'Dunedoo', 'AU', 'NSW'),
(2307, 14, 207, 'Dungog', 'AU', 'NSW'),
(2308, 14, 207, 'Dural', 'AU', 'NSW'),
(2309, 14, 207, 'Eagle Vale', 'AU', 'NSW'),
(2310, 14, 207, 'Earlwood', 'AU', 'NSW'),
(2311, 14, 207, 'East Albury', 'AU', 'NSW'),
(2312, 14, 207, 'East Ballina', 'AU', 'NSW'),
(2313, 14, 207, 'East Branxton', 'AU', 'NSW'),
(2314, 14, 207, 'East Corrimal', 'AU', 'NSW'),
(2315, 14, 207, 'East Gosford', 'AU', 'NSW'),
(2316, 14, 207, 'East Hills', 'AU', 'NSW'),
(2317, 14, 207, 'East Jindabyne', 'AU', 'NSW'),
(2318, 14, 207, 'East Kempsey', 'AU', 'NSW'),
(2319, 14, 207, 'East Killara', 'AU', 'NSW'),
(2320, 14, 207, 'East Kurrajong', 'AU', 'NSW'),
(2321, 14, 207, 'East Lindfield', 'AU', 'NSW'),
(2322, 14, 207, 'East Lismore', 'AU', 'NSW'),
(2323, 14, 207, 'East Maitland', 'AU', 'NSW'),
(2324, 14, 207, 'East Ryde', 'AU', 'NSW'),
(2325, 14, 207, 'East Tamworth', 'AU', 'NSW'),
(2326, 14, 207, 'Eastlakes', 'AU', 'NSW'),
(2327, 14, 207, 'Eastwood', 'AU', 'NSW'),
(2328, 14, 207, 'Eden', 'AU', 'NSW'),
(2329, 14, 207, 'Edensor Park', 'AU', 'NSW'),
(2330, 14, 207, 'Edgecliff', 'AU', 'NSW'),
(2331, 14, 207, 'Edgeworth', 'AU', 'NSW'),
(2332, 14, 207, 'Edmondson Park', 'AU', 'NSW'),
(2333, 14, 207, 'Eglinton', 'AU', 'NSW'),
(2334, 14, 207, 'Elanora Heights', 'AU', 'NSW'),
(2335, 14, 207, 'Elderslie', 'AU', 'NSW'),
(2336, 14, 207, 'Eleebana', 'AU', 'NSW'),
(2337, 14, 207, 'Elermore Vale', 'AU', 'NSW'),
(2338, 14, 207, 'Elizabeth Bay', 'AU', 'NSW'),
(2339, 14, 207, 'Elizabeth Hills', 'AU', 'NSW'),
(2340, 14, 207, 'Ellalong', 'AU', 'NSW'),
(2341, 14, 207, 'Emerald Beach', 'AU', 'NSW'),
(2342, 14, 207, 'Emerton', 'AU', 'NSW'),
(2343, 14, 207, 'Empire Bay', 'AU', 'NSW'),
(2344, 14, 207, 'Emu Heights', 'AU', 'NSW'),
(2345, 14, 207, 'Emu Plains', 'AU', 'NSW'),
(2346, 14, 207, 'Engadine', 'AU', 'NSW'),
(2347, 14, 207, 'Enmore', 'AU', 'NSW'),
(2348, 14, 207, 'Epping', 'AU', 'NSW'),
(2349, 14, 207, 'Erina', 'AU', 'NSW'),
(2350, 14, 207, 'Ermington', 'AU', 'NSW'),
(2351, 14, 207, 'Erskine Park', 'AU', 'NSW'),
(2352, 14, 207, 'Erskineville', 'AU', 'NSW'),
(2353, 14, 207, 'Eschol Park', 'AU', 'NSW'),
(2354, 14, 207, 'Estella', 'AU', 'NSW'),
(2355, 14, 207, 'Ettalong', 'AU', 'NSW'),
(2356, 14, 207, 'Ettalong Beach', 'AU', 'NSW'),
(2357, 14, 207, 'Eulomogo', 'AU', 'NSW'),
(2358, 14, 207, 'Eurobodalla', 'AU', 'NSW'),
(2359, 14, 207, 'Evans Head', 'AU', 'NSW'),
(2360, 14, 207, 'Fairfield', 'AU', 'NSW'),
(2361, 14, 207, 'Fairfield East', 'AU', 'NSW'),
(2362, 14, 207, 'Fairfield Heights', 'AU', 'NSW'),
(2363, 14, 207, 'Fairfield West', 'AU', 'NSW'),
(2364, 14, 207, 'Fairlight', 'AU', 'NSW'),
(2365, 14, 207, 'Fairy Meadow', 'AU', 'NSW'),
(2366, 14, 207, 'Farmborough Heights', 'AU', 'NSW'),
(2367, 14, 207, 'Faulconbridge', 'AU', 'NSW'),
(2368, 14, 207, 'Fennell Bay', 'AU', 'NSW'),
(2369, 14, 207, 'Fern Bay', 'AU', 'NSW'),
(2370, 14, 207, 'Fern Hill', 'AU', 'NSW'),
(2371, 14, 207, 'Figtree', 'AU', 'NSW'),
(2372, 14, 207, 'Fingal Bay', 'AU', 'NSW'),
(2373, 14, 207, 'Finley', 'AU', 'NSW'),
(2374, 14, 207, 'Five Dock', 'AU', 'NSW'),
(2375, 14, 207, 'Fletcher', 'AU', 'NSW'),
(2376, 14, 207, 'Flinders', 'AU', 'NSW'),
(2377, 14, 207, 'Floraville', 'AU', 'NSW'),
(2378, 14, 207, 'Forbes', 'AU', 'NSW'),
(2379, 14, 207, 'Forest Hill', 'AU', 'NSW'),
(2380, 14, 207, 'Forest Lodge', 'AU', 'NSW'),
(2381, 14, 207, 'Forestville', 'AU', 'NSW'),
(2382, 14, 207, 'Forresters Beach', 'AU', 'NSW'),
(2383, 14, 207, 'Forster', 'AU', 'NSW'),
(2384, 14, 207, 'Frederickton', 'AU', 'NSW'),
(2385, 14, 207, 'Freemans Reach', 'AU', 'NSW'),
(2386, 14, 207, 'Frenchs Forest', 'AU', 'NSW'),
(2387, 14, 207, 'Freshwater', 'AU', 'NSW'),
(2388, 14, 207, 'Galston', 'AU', 'NSW'),
(2389, 14, 207, 'Garden Suburb', 'AU', 'NSW'),
(2390, 14, 207, 'Gateshead', 'AU', 'NSW'),
(2391, 14, 207, 'Georges Hall', 'AU', 'NSW'),
(2392, 14, 207, 'Georgetown', 'AU', 'NSW'),
(2393, 14, 207, 'Gerringong', 'AU', 'NSW'),
(2394, 14, 207, 'Gilgandra', 'AU', 'NSW'),
(2395, 14, 207, 'Gillieston Heights', 'AU', 'NSW'),
(2396, 14, 207, 'Girards Hill', 'AU', 'NSW'),
(2397, 14, 207, 'Girraween', 'AU', 'NSW'),
(2398, 14, 207, 'Gladesville', 'AU', 'NSW'),
(2399, 14, 207, 'Glebe', 'AU', 'NSW'),
(2400, 14, 207, 'Glen Alpine', 'AU', 'NSW'),
(2401, 14, 207, 'Glen Innes', 'AU', 'NSW'),
(2402, 14, 207, 'Glen Innes Severn', 'AU', 'NSW'),
(2403, 14, 207, 'Glenbrook', 'AU', 'NSW'),
(2404, 14, 207, 'Glendale', 'AU', 'NSW'),
(2405, 14, 207, 'Glendenning', 'AU', 'NSW'),
(2406, 14, 207, 'Glenfield', 'AU', 'NSW'),
(2407, 14, 207, 'Glenfield Park', 'AU', 'NSW'),
(2408, 14, 207, 'Glenhaven', 'AU', 'NSW'),
(2409, 14, 207, 'Glenmore Park', 'AU', 'NSW'),
(2410, 14, 207, 'Glenning Valley', 'AU', 'NSW'),
(2411, 14, 207, 'Glenorie', 'AU', 'NSW'),
(2412, 14, 207, 'Glenroy', 'AU', 'NSW'),
(2413, 14, 207, 'Glenwood', 'AU', 'NSW'),
(2414, 14, 207, 'Glossodia', 'AU', 'NSW'),
(2415, 14, 207, 'Gloucester', 'AU', 'NSW'),
(2416, 14, 207, 'Gol Gol', 'AU', 'NSW'),
(2417, 14, 207, 'Googong', 'AU', 'NSW'),
(2418, 14, 207, 'Goonellabah', 'AU', 'NSW'),
(2419, 14, 207, 'Gordon', 'AU', 'NSW'),
(2420, 14, 207, 'Gorokan', 'AU', 'NSW'),
(2421, 14, 207, 'Gosford', 'AU', 'NSW'),
(2422, 14, 207, 'Goulburn', 'AU', 'NSW'),
(2423, 14, 207, 'Goulburn Mulwaree', 'AU', 'NSW'),
(2424, 14, 207, 'Grafton', 'AU', 'NSW'),
(2425, 14, 207, 'Granville', 'AU', 'NSW'),
(2426, 14, 207, 'Grasmere', 'AU', 'NSW'),
(2427, 14, 207, 'Grays Point', 'AU', 'NSW'),
(2428, 14, 207, 'Greater Hume Shire', 'AU', 'NSW'),
(2429, 14, 207, 'Green Valley', 'AU', 'NSW'),
(2430, 14, 207, 'Greenacre', 'AU', 'NSW'),
(2431, 14, 207, 'Greenfield Park', 'AU', 'NSW'),
(2432, 14, 207, 'Greenwell Point', 'AU', 'NSW'),
(2433, 14, 207, 'Greenwich', 'AU', 'NSW'),
(2434, 14, 207, 'Gregory Hills', 'AU', 'NSW'),
(2435, 14, 207, 'Grenfell', 'AU', 'NSW'),
(2436, 14, 207, 'Greta', 'AU', 'NSW'),
(2437, 14, 207, 'Greystanes', 'AU', 'NSW'),
(2438, 14, 207, 'Griffith', 'AU', 'NSW'),
(2439, 14, 207, 'Grose Vale', 'AU', 'NSW'),
(2440, 14, 207, 'Guildford West', 'AU', 'NSW'),
(2441, 14, 207, 'Gulgong', 'AU', 'NSW'),
(2442, 14, 207, 'Gulmarrad', 'AU', 'NSW'),
(2443, 14, 207, 'Gundagai', 'AU', 'NSW'),
(2444, 14, 207, 'Gundaroo', 'AU', 'NSW'),
(2445, 14, 207, 'Gunnedah', 'AU', 'NSW'),
(2446, 14, 207, 'Guyra', 'AU', 'NSW'),
(2447, 14, 207, 'Gwandalan', 'AU', 'NSW'),
(2448, 14, 207, 'Gwydir', 'AU', 'NSW'),
(2449, 14, 207, 'Gwynneville', 'AU', 'NSW'),
(2450, 14, 207, 'Gymea', 'AU', 'NSW'),
(2451, 14, 207, 'Gymea Bay', 'AU', 'NSW'),
(2452, 14, 207, 'Haberfield', 'AU', 'NSW'),
(2453, 14, 207, 'Halekulani', 'AU', 'NSW'),
(2454, 14, 207, 'Hamilton', 'AU', 'NSW'),
(2455, 14, 207, 'Hamlyn Terrace', 'AU', 'NSW'),
(2456, 14, 207, 'Hammondville', 'AU', 'NSW'),
(2457, 14, 207, 'Hanwood', 'AU', 'NSW'),
(2458, 14, 207, 'Harrington', 'AU', 'NSW'),
(2459, 14, 207, 'Harrington Park', 'AU', 'NSW'),
(2460, 14, 207, 'Harris Park', 'AU', 'NSW'),
(2461, 14, 207, 'Hassall Grove', 'AU', 'NSW'),
(2462, 14, 207, 'Hawkesbury', 'AU', 'NSW'),
(2463, 14, 207, 'Hawks Nest', 'AU', 'NSW'),
(2464, 14, 207, 'Hay', 'AU', 'NSW'),
(2465, 14, 207, 'Haymarket', 'AU', 'NSW'),
(2466, 14, 207, 'Hazelbrook', 'AU', 'NSW'),
(2467, 14, 207, 'Heathcote', 'AU', 'NSW'),
(2468, 14, 207, 'Hebersham', 'AU', 'NSW'),
(2469, 14, 207, 'Heckenberg', 'AU', 'NSW'),
(2470, 14, 207, 'Heddon Greta', 'AU', 'NSW'),
(2471, 14, 207, 'Helensburgh', 'AU', 'NSW'),
(2472, 14, 207, 'Henty', 'AU', 'NSW'),
(2473, 14, 207, 'Hill Top', 'AU', 'NSW'),
(2474, 14, 207, 'Hillsdale', 'AU', 'NSW'),
(2475, 14, 207, 'Hillston', 'AU', 'NSW'),
(2476, 14, 207, 'Hillvue', 'AU', 'NSW'),
(2477, 14, 207, 'Hinchinbrook', 'AU', 'NSW'),
(2478, 14, 207, 'Hobartville', 'AU', 'NSW'),
(2479, 14, 207, 'Holbrook', 'AU', 'NSW'),
(2480, 14, 207, 'Holmesville', 'AU', 'NSW'),
(2481, 14, 207, 'Holroyd', 'AU', 'NSW'),
(2482, 14, 207, 'Holsworthy', 'AU', 'NSW'),
(2483, 14, 207, 'Homebush', 'AU', 'NSW'),
(2484, 14, 207, 'Homebush West', 'AU', 'NSW'),
(2485, 14, 207, 'Horningsea Park', 'AU', 'NSW'),
(2486, 14, 207, 'Hornsby', 'AU', 'NSW'),
(2487, 14, 207, 'Hornsby Heights', 'AU', 'NSW'),
(2488, 14, 207, 'Hornsby Shire', 'AU', 'NSW'),
(2489, 14, 207, 'Horsley', 'AU', 'NSW'),
(2490, 14, 207, 'Horsley Park', 'AU', 'NSW'),
(2491, 14, 207, 'Howlong', 'AU', 'NSW'),
(2492, 14, 207, 'Hoxton Park', 'AU', 'NSW'),
(2493, 14, 207, 'Hunters Hill', 'AU', 'NSW'),
(2494, 14, 207, 'Hunterview', 'AU', 'NSW'),
(2495, 14, 207, 'Huntingwood', 'AU', 'NSW'),
(2496, 14, 207, 'Hurlstone Park', 'AU', 'NSW'),
(2497, 14, 207, 'Hurstville', 'AU', 'NSW'),
(2498, 14, 207, 'Hurstville Grove', 'AU', 'NSW'),
(2499, 14, 207, 'Illawong', 'AU', 'NSW'),
(2500, 14, 207, 'Iluka', 'AU', 'NSW');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(2501, 14, 207, 'Ingleburn', 'AU', 'NSW'),
(2502, 14, 207, 'Inverell', 'AU', 'NSW'),
(2503, 14, 207, 'Islington', 'AU', 'NSW'),
(2504, 14, 207, 'Jamberoo', 'AU', 'NSW'),
(2505, 14, 207, 'Jamisontown', 'AU', 'NSW'),
(2506, 14, 207, 'Jannali', 'AU', 'NSW'),
(2507, 14, 207, 'Jerilderie', 'AU', 'NSW'),
(2508, 14, 207, 'Jerrabomberra', 'AU', 'NSW'),
(2509, 14, 207, 'Jesmond', 'AU', 'NSW'),
(2510, 14, 207, 'Jewells', 'AU', 'NSW'),
(2511, 14, 207, 'Jilliby', 'AU', 'NSW'),
(2512, 14, 207, 'Jindabyne', 'AU', 'NSW'),
(2513, 14, 207, 'Jindera', 'AU', 'NSW'),
(2514, 14, 207, 'Jordan Springs', 'AU', 'NSW'),
(2515, 14, 207, 'Junction Hill', 'AU', 'NSW'),
(2516, 14, 207, 'Junee', 'AU', 'NSW'),
(2517, 14, 207, 'Kahibah', 'AU', 'NSW'),
(2518, 14, 207, 'Kanahooka', 'AU', 'NSW'),
(2519, 14, 207, 'Kandos', 'AU', 'NSW'),
(2520, 14, 207, 'Kanwal', 'AU', 'NSW'),
(2521, 14, 207, 'Kapooka', 'AU', 'NSW'),
(2522, 14, 207, 'Karabar', 'AU', 'NSW'),
(2523, 14, 207, 'Kareela', 'AU', 'NSW'),
(2524, 14, 207, 'Kariong', 'AU', 'NSW'),
(2525, 14, 207, 'Karuah', 'AU', 'NSW'),
(2526, 14, 207, 'Katoomba', 'AU', 'NSW'),
(2527, 14, 207, 'Kearns', 'AU', 'NSW'),
(2528, 14, 207, 'Keiraville', 'AU', 'NSW'),
(2529, 14, 207, 'Kellyville', 'AU', 'NSW'),
(2530, 14, 207, 'Kellyville Ridge', 'AU', 'NSW'),
(2531, 14, 207, 'Kelso', 'AU', 'NSW'),
(2532, 14, 207, 'Kemps Creek', 'AU', 'NSW'),
(2533, 14, 207, 'Kempsey', 'AU', 'NSW'),
(2534, 14, 207, 'Kendall', 'AU', 'NSW'),
(2535, 14, 207, 'Kensington', 'AU', 'NSW'),
(2536, 14, 207, 'Kenthurst', 'AU', 'NSW'),
(2537, 14, 207, 'Kew', 'AU', 'NSW'),
(2538, 14, 207, 'Kiama', 'AU', 'NSW'),
(2539, 14, 207, 'Kiama Downs', 'AU', 'NSW'),
(2540, 14, 207, 'Kilaben Bay', 'AU', 'NSW'),
(2541, 14, 207, 'Killara', 'AU', 'NSW'),
(2542, 14, 207, 'Killarney Heights', 'AU', 'NSW'),
(2543, 14, 207, 'Killarney Vale', 'AU', 'NSW'),
(2544, 14, 207, 'King Creek', 'AU', 'NSW'),
(2545, 14, 207, 'Kings Langley', 'AU', 'NSW'),
(2546, 14, 207, 'Kings Park', 'AU', 'NSW'),
(2547, 14, 207, 'Kingscliff', 'AU', 'NSW'),
(2548, 14, 207, 'Kingsford', 'AU', 'NSW'),
(2549, 14, 207, 'Kingsgrove', 'AU', 'NSW'),
(2550, 14, 207, 'Kingswood Park', 'AU', 'NSW'),
(2551, 14, 207, 'Kirrawee', 'AU', 'NSW'),
(2552, 14, 207, 'Kirribilli', 'AU', 'NSW'),
(2553, 14, 207, 'Kogarah', 'AU', 'NSW'),
(2554, 14, 207, 'Kogarah Bay', 'AU', 'NSW'),
(2555, 14, 207, 'Koonawarra', 'AU', 'NSW'),
(2556, 14, 207, 'Kooringal', 'AU', 'NSW'),
(2557, 14, 207, 'Kootingal', 'AU', 'NSW'),
(2558, 14, 207, 'Korora', 'AU', 'NSW'),
(2559, 14, 207, 'Kosciuszko National Park', 'AU', 'NSW'),
(2560, 14, 207, 'Kotara', 'AU', 'NSW'),
(2561, 14, 207, 'Kotara South', 'AU', 'NSW'),
(2562, 14, 207, 'Ku-ring-gai', 'AU', 'NSW'),
(2563, 14, 207, 'Kurnell', 'AU', 'NSW'),
(2564, 14, 207, 'Kurraba Point', 'AU', 'NSW'),
(2565, 14, 207, 'Kurrajong Heights', 'AU', 'NSW'),
(2566, 14, 207, 'Kurri Kurri', 'AU', 'NSW'),
(2567, 14, 207, 'Kyle Bay', 'AU', 'NSW'),
(2568, 14, 207, 'Kyogle', 'AU', 'NSW'),
(2569, 14, 207, 'Lachlan', 'AU', 'NSW'),
(2570, 14, 207, 'Lake Albert', 'AU', 'NSW'),
(2571, 14, 207, 'Lake Cargelligo', 'AU', 'NSW'),
(2572, 14, 207, 'Lake Cathie', 'AU', 'NSW'),
(2573, 14, 207, 'Lake Haven', 'AU', 'NSW'),
(2574, 14, 207, 'Lake Heights', 'AU', 'NSW'),
(2575, 14, 207, 'Lake Illawarra', 'AU', 'NSW'),
(2576, 14, 207, 'Lake Macquarie Shire', 'AU', 'NSW'),
(2577, 14, 207, 'Lake Munmorah', 'AU', 'NSW'),
(2578, 14, 207, 'Lakelands', 'AU', 'NSW'),
(2579, 14, 207, 'Lakemba', 'AU', 'NSW'),
(2580, 14, 207, 'Lakewood', 'AU', 'NSW'),
(2581, 14, 207, 'Lalor Park', 'AU', 'NSW'),
(2582, 14, 207, 'Lambton', 'AU', 'NSW'),
(2583, 14, 207, 'Lane Cove', 'AU', 'NSW'),
(2584, 14, 207, 'Lane Cove North', 'AU', 'NSW'),
(2585, 14, 207, 'Lane Cove West', 'AU', 'NSW'),
(2586, 14, 207, 'Lansvale', 'AU', 'NSW'),
(2587, 14, 207, 'Largs', 'AU', 'NSW'),
(2588, 14, 207, 'Lavington', 'AU', 'NSW'),
(2589, 14, 207, 'Lawrence', 'AU', 'NSW'),
(2590, 14, 207, 'Lawson', 'AU', 'NSW'),
(2591, 14, 207, 'Leeton', 'AU', 'NSW'),
(2592, 14, 207, 'Leichhardt', 'AU', 'NSW'),
(2593, 14, 207, 'Lemon Tree Passage', 'AU', 'NSW'),
(2594, 14, 207, 'Lennox Head', 'AU', 'NSW'),
(2595, 14, 207, 'Leonay', 'AU', 'NSW'),
(2596, 14, 207, 'Leppington', 'AU', 'NSW'),
(2597, 14, 207, 'Lethbridge Park', 'AU', 'NSW'),
(2598, 14, 207, 'Leumeah', 'AU', 'NSW'),
(2599, 14, 207, 'Leura', 'AU', 'NSW'),
(2600, 14, 207, 'Lewisham', 'AU', 'NSW'),
(2601, 14, 207, 'Liberty Grove', 'AU', 'NSW'),
(2602, 14, 207, 'Lidcombe', 'AU', 'NSW'),
(2603, 14, 207, 'Lightning Ridge', 'AU', 'NSW'),
(2604, 14, 207, 'Lilli Pilli', 'AU', 'NSW'),
(2605, 14, 207, 'Lilyfield', 'AU', 'NSW'),
(2606, 14, 207, 'Lindfield', 'AU', 'NSW'),
(2607, 14, 207, 'Lisarow', 'AU', 'NSW'),
(2608, 14, 207, 'Lismore', 'AU', 'NSW'),
(2609, 14, 207, 'Lismore Heights', 'AU', 'NSW'),
(2610, 14, 207, 'Lismore Municipality', 'AU', 'NSW'),
(2611, 14, 207, 'Lithgow', 'AU', 'NSW'),
(2612, 14, 207, 'Little Bay', 'AU', 'NSW'),
(2613, 14, 207, 'Liverpool', 'AU', 'NSW'),
(2614, 14, 207, 'Liverpool Plains', 'AU', 'NSW'),
(2615, 14, 207, 'Llanarth', 'AU', 'NSW'),
(2616, 14, 207, 'Llandilo', 'AU', 'NSW'),
(2617, 14, 207, 'Lockhart', 'AU', 'NSW'),
(2618, 14, 207, 'Loftus', 'AU', 'NSW'),
(2619, 14, 207, 'Londonderry', 'AU', 'NSW'),
(2620, 14, 207, 'Long Beach', 'AU', 'NSW'),
(2621, 14, 207, 'Long Jetty', 'AU', 'NSW'),
(2622, 14, 207, 'Longueville', 'AU', 'NSW'),
(2623, 14, 207, 'Lorn', 'AU', 'NSW'),
(2624, 14, 207, 'Luddenham', 'AU', 'NSW'),
(2625, 14, 207, 'Lugarno', 'AU', 'NSW'),
(2626, 14, 207, 'Lurnea', 'AU', 'NSW'),
(2627, 14, 207, 'Macksville', 'AU', 'NSW'),
(2628, 14, 207, 'Maclean', 'AU', 'NSW'),
(2629, 14, 207, 'Macmasters Beach', 'AU', 'NSW'),
(2630, 14, 207, 'Macquarie Fields', 'AU', 'NSW'),
(2631, 14, 207, 'Macquarie Hills', 'AU', 'NSW'),
(2632, 14, 207, 'Macquarie Links', 'AU', 'NSW'),
(2633, 14, 207, 'Macquarie Park', 'AU', 'NSW'),
(2634, 14, 207, 'Maitland', 'AU', 'NSW'),
(2635, 14, 207, 'Maitland city centre', 'AU', 'NSW'),
(2636, 14, 207, 'Maitland Municipality', 'AU', 'NSW'),
(2637, 14, 207, 'Malabar', 'AU', 'NSW'),
(2638, 14, 207, 'Malua Bay', 'AU', 'NSW'),
(2639, 14, 207, 'Mangerton', 'AU', 'NSW'),
(2640, 14, 207, 'Manilla', 'AU', 'NSW'),
(2641, 14, 207, 'Manly', 'AU', 'NSW'),
(2642, 14, 207, 'Manly Vale', 'AU', 'NSW'),
(2643, 14, 207, 'Mannering Park', 'AU', 'NSW'),
(2644, 14, 207, 'Maraylya', 'AU', 'NSW'),
(2645, 14, 207, 'Marayong', 'AU', 'NSW'),
(2646, 14, 207, 'Mardi', 'AU', 'NSW'),
(2647, 14, 207, 'Marks Point', 'AU', 'NSW'),
(2648, 14, 207, 'Maroubra', 'AU', 'NSW'),
(2649, 14, 207, 'Marrickville', 'AU', 'NSW'),
(2650, 14, 207, 'Marsfield', 'AU', 'NSW'),
(2651, 14, 207, 'Marulan', 'AU', 'NSW'),
(2652, 14, 207, 'Maryland', 'AU', 'NSW'),
(2653, 14, 207, 'Maryville', 'AU', 'NSW'),
(2654, 14, 207, 'Mascot', 'AU', 'NSW'),
(2655, 14, 207, 'Matraville', 'AU', 'NSW'),
(2656, 14, 207, 'Mayfield', 'AU', 'NSW'),
(2657, 14, 207, 'Mayfield East', 'AU', 'NSW'),
(2658, 14, 207, 'Mayfield West', 'AU', 'NSW'),
(2659, 14, 207, 'McGraths Hill', 'AU', 'NSW'),
(2660, 14, 207, 'McMahons Point', 'AU', 'NSW'),
(2661, 14, 207, 'Meadowbank', 'AU', 'NSW'),
(2662, 14, 207, 'Medowie', 'AU', 'NSW'),
(2663, 14, 207, 'Melrose Park', 'AU', 'NSW'),
(2664, 14, 207, 'Menai', 'AU', 'NSW'),
(2665, 14, 207, 'Menangle', 'AU', 'NSW'),
(2666, 14, 207, 'Merewether', 'AU', 'NSW'),
(2667, 14, 207, 'Merewether Heights', 'AU', 'NSW'),
(2668, 14, 207, 'Merimbula', 'AU', 'NSW'),
(2669, 14, 207, 'Merriwa', 'AU', 'NSW'),
(2670, 14, 207, 'Merrylands', 'AU', 'NSW'),
(2671, 14, 207, 'Merrylands West', 'AU', 'NSW'),
(2672, 14, 207, 'Metford', 'AU', 'NSW'),
(2673, 14, 207, 'Mid-Western Regional', 'AU', 'NSW'),
(2674, 14, 207, 'Middle Cove', 'AU', 'NSW'),
(2675, 14, 207, 'Middleton Grange', 'AU', 'NSW'),
(2676, 14, 207, 'Miller', 'AU', 'NSW'),
(2677, 14, 207, 'Millers Point', 'AU', 'NSW'),
(2678, 14, 207, 'Millthorpe', 'AU', 'NSW'),
(2679, 14, 207, 'Milperra', 'AU', 'NSW'),
(2680, 14, 207, 'Milsons Point', 'AU', 'NSW'),
(2681, 14, 207, 'Milton', 'AU', 'NSW'),
(2682, 14, 207, 'Minchinbury', 'AU', 'NSW'),
(2683, 14, 207, 'Minto', 'AU', 'NSW'),
(2684, 14, 207, 'Miranda', 'AU', 'NSW'),
(2685, 14, 207, 'Mitchell', 'AU', 'NSW'),
(2686, 14, 207, 'Mittagong', 'AU', 'NSW'),
(2687, 14, 207, 'Moama', 'AU', 'NSW'),
(2688, 14, 207, 'Mollymook', 'AU', 'NSW'),
(2689, 14, 207, 'Mollymook Beach', 'AU', 'NSW'),
(2690, 14, 207, 'Molong', 'AU', 'NSW'),
(2691, 14, 207, 'Mona Vale', 'AU', 'NSW'),
(2692, 14, 207, 'Monterey', 'AU', 'NSW'),
(2693, 14, 207, 'Moonbi', 'AU', 'NSW'),
(2694, 14, 207, 'Moonee Beach', 'AU', 'NSW'),
(2695, 14, 207, 'Moorebank', 'AU', 'NSW'),
(2696, 14, 207, 'Moree', 'AU', 'NSW'),
(2697, 14, 207, 'Moree Plains', 'AU', 'NSW'),
(2698, 14, 207, 'Morisset', 'AU', 'NSW'),
(2699, 14, 207, 'Morpeth', 'AU', 'NSW'),
(2700, 14, 207, 'Mortdale', 'AU', 'NSW'),
(2701, 14, 207, 'Mortlake', 'AU', 'NSW'),
(2702, 14, 207, 'Moruya', 'AU', 'NSW'),
(2703, 14, 207, 'Mosman', 'AU', 'NSW'),
(2704, 14, 207, 'Moss Vale', 'AU', 'NSW'),
(2705, 14, 207, 'Mount Annan', 'AU', 'NSW'),
(2706, 14, 207, 'Mount Austin', 'AU', 'NSW'),
(2707, 14, 207, 'Mount Colah', 'AU', 'NSW'),
(2708, 14, 207, 'Mount Druitt', 'AU', 'NSW'),
(2709, 14, 207, 'Mount Hutton', 'AU', 'NSW'),
(2710, 14, 207, 'Mount Keira', 'AU', 'NSW'),
(2711, 14, 207, 'Mount Kembla', 'AU', 'NSW'),
(2712, 14, 207, 'Mount Kuring-Gai', 'AU', 'NSW'),
(2713, 14, 207, 'Mount Lewis', 'AU', 'NSW'),
(2714, 14, 207, 'Mount Ousley', 'AU', 'NSW'),
(2715, 14, 207, 'Mount Pleasant', 'AU', 'NSW'),
(2716, 14, 207, 'Mount Pritchard', 'AU', 'NSW'),
(2717, 14, 207, 'Mount Riverview', 'AU', 'NSW'),
(2718, 14, 207, 'Mount Saint Thomas', 'AU', 'NSW'),
(2719, 14, 207, 'Mount Vernon', 'AU', 'NSW'),
(2720, 14, 207, 'Mount Warrigal', 'AU', 'NSW'),
(2721, 14, 207, 'Mudgee', 'AU', 'NSW'),
(2722, 14, 207, 'Mulgoa', 'AU', 'NSW'),
(2723, 14, 207, 'Mullumbimby', 'AU', 'NSW'),
(2724, 14, 207, 'Mulwala', 'AU', 'NSW'),
(2725, 14, 207, 'Murrumbateman', 'AU', 'NSW'),
(2726, 14, 207, 'Murrurundi', 'AU', 'NSW'),
(2727, 14, 207, 'Murwillumbah', 'AU', 'NSW'),
(2728, 14, 207, 'Muswellbrook', 'AU', 'NSW'),
(2729, 14, 207, 'Nabiac', 'AU', 'NSW'),
(2730, 14, 207, 'Nambucca', 'AU', 'NSW'),
(2731, 14, 207, 'Nambucca Heads', 'AU', 'NSW'),
(2732, 14, 207, 'Nambucca Shire', 'AU', 'NSW'),
(2733, 14, 207, 'Nana Glen', 'AU', 'NSW'),
(2734, 14, 207, 'Narara', 'AU', 'NSW'),
(2735, 14, 207, 'Narellan', 'AU', 'NSW'),
(2736, 14, 207, 'Narellan Vale', 'AU', 'NSW'),
(2737, 14, 207, 'Naremburn', 'AU', 'NSW'),
(2738, 14, 207, 'Narooma', 'AU', 'NSW'),
(2739, 14, 207, 'Narrabeen', 'AU', 'NSW'),
(2740, 14, 207, 'Narrabri', 'AU', 'NSW'),
(2741, 14, 207, 'Narrandera', 'AU', 'NSW'),
(2742, 14, 207, 'Narrawallee', 'AU', 'NSW'),
(2743, 14, 207, 'Narraweena', 'AU', 'NSW'),
(2744, 14, 207, 'Narromine', 'AU', 'NSW'),
(2745, 14, 207, 'Narwee', 'AU', 'NSW'),
(2746, 14, 207, 'Nelson Bay', 'AU', 'NSW'),
(2747, 14, 207, 'Neutral Bay', 'AU', 'NSW'),
(2748, 14, 207, 'New Lambton', 'AU', 'NSW'),
(2749, 14, 207, 'New Lambton Heights', 'AU', 'NSW'),
(2750, 14, 207, 'Newcastle', 'AU', 'NSW'),
(2751, 14, 207, 'Newcastle city centre', 'AU', 'NSW'),
(2752, 14, 207, 'Newcastle East', 'AU', 'NSW'),
(2753, 14, 207, 'Newington', 'AU', 'NSW'),
(2754, 14, 207, 'Newport', 'AU', 'NSW'),
(2755, 14, 207, 'Newtown', 'AU', 'NSW'),
(2756, 14, 207, 'Niagara Park', 'AU', 'NSW'),
(2757, 14, 207, 'Nimbin', 'AU', 'NSW'),
(2758, 14, 207, 'Noraville', 'AU', 'NSW'),
(2759, 14, 207, 'Normanhurst', 'AU', 'NSW'),
(2760, 14, 207, 'North Albury', 'AU', 'NSW'),
(2761, 14, 207, 'North Avoca', 'AU', 'NSW'),
(2762, 14, 207, 'North Balgowlah', 'AU', 'NSW'),
(2763, 14, 207, 'North Boambee Valley', 'AU', 'NSW'),
(2764, 14, 207, 'North Bondi', 'AU', 'NSW'),
(2765, 14, 207, 'North Curl Curl', 'AU', 'NSW'),
(2766, 14, 207, 'North Epping', 'AU', 'NSW'),
(2767, 14, 207, 'North Gosford', 'AU', 'NSW'),
(2768, 14, 207, 'North Haven', 'AU', 'NSW'),
(2769, 14, 207, 'North Lambton', 'AU', 'NSW'),
(2770, 14, 207, 'North Manly', 'AU', 'NSW'),
(2771, 14, 207, 'North Narrabeen', 'AU', 'NSW'),
(2772, 14, 207, 'North Nowra', 'AU', 'NSW'),
(2773, 14, 207, 'North Parramatta', 'AU', 'NSW'),
(2774, 14, 207, 'North Richmond', 'AU', 'NSW'),
(2775, 14, 207, 'North Rocks', 'AU', 'NSW'),
(2776, 14, 207, 'North Ryde', 'AU', 'NSW'),
(2777, 14, 207, 'North St Marys', 'AU', 'NSW'),
(2778, 14, 207, 'North Strathfield', 'AU', 'NSW'),
(2779, 14, 207, 'North Sydney', 'AU', 'NSW'),
(2780, 14, 207, 'North Tamworth', 'AU', 'NSW'),
(2781, 14, 207, 'North Turramurra', 'AU', 'NSW'),
(2782, 14, 207, 'North Wahroonga', 'AU', 'NSW'),
(2783, 14, 207, 'North Willoughby', 'AU', 'NSW'),
(2784, 14, 207, 'North Wollongong', 'AU', 'NSW'),
(2785, 14, 207, 'Northbridge', 'AU', 'NSW'),
(2786, 14, 207, 'Northmead', 'AU', 'NSW'),
(2787, 14, 207, 'Nowra', 'AU', 'NSW'),
(2788, 14, 207, 'Nowra Hill', 'AU', 'NSW'),
(2789, 14, 207, 'Nyngan', 'AU', 'NSW'),
(2790, 14, 207, 'Oak Flats', 'AU', 'NSW'),
(2791, 14, 207, 'Oakdale', 'AU', 'NSW'),
(2792, 14, 207, 'Oakhurst', 'AU', 'NSW'),
(2793, 14, 207, 'Oakville', 'AU', 'NSW'),
(2794, 14, 207, 'Oatlands', 'AU', 'NSW'),
(2795, 14, 207, 'Oatley', 'AU', 'NSW'),
(2796, 14, 207, 'Oberon', 'AU', 'NSW'),
(2797, 14, 207, 'Ocean Shores', 'AU', 'NSW'),
(2798, 14, 207, 'Old Bar', 'AU', 'NSW'),
(2799, 14, 207, 'Old Erowal Bay', 'AU', 'NSW'),
(2800, 14, 207, 'Old Guildford', 'AU', 'NSW'),
(2801, 14, 207, 'Old Toongabbie', 'AU', 'NSW'),
(2802, 14, 207, 'Oran Park', 'AU', 'NSW'),
(2803, 14, 207, 'Orange', 'AU', 'NSW'),
(2804, 14, 207, 'Orange Municipality', 'AU', 'NSW'),
(2805, 14, 207, 'Orangeville', 'AU', 'NSW'),
(2806, 14, 207, 'Orchard Hills', 'AU', 'NSW'),
(2807, 14, 207, 'Ourimbah', 'AU', 'NSW'),
(2808, 14, 207, 'Oxley Park', 'AU', 'NSW'),
(2809, 14, 207, 'Oxley Vale', 'AU', 'NSW'),
(2810, 14, 207, 'Oyster Bay', 'AU', 'NSW'),
(2811, 14, 207, 'Paddington', 'AU', 'NSW'),
(2812, 14, 207, 'Padstow', 'AU', 'NSW'),
(2813, 14, 207, 'Padstow Heights', 'AU', 'NSW'),
(2814, 14, 207, 'Pagewood', 'AU', 'NSW'),
(2815, 14, 207, 'Palm Beach', 'AU', 'NSW'),
(2816, 14, 207, 'Panania', 'AU', 'NSW'),
(2817, 14, 207, 'Parkes', 'AU', 'NSW'),
(2818, 14, 207, 'Parklea', 'AU', 'NSW'),
(2819, 14, 207, 'Parramatta', 'AU', 'NSW'),
(2820, 14, 207, 'Peak Hill', 'AU', 'NSW'),
(2821, 14, 207, 'Peakhurst', 'AU', 'NSW'),
(2822, 14, 207, 'Peakhurst Heights', 'AU', 'NSW'),
(2823, 14, 207, 'Pemulwuy', 'AU', 'NSW'),
(2824, 14, 207, 'Pendle Hill', 'AU', 'NSW'),
(2825, 14, 207, 'Pennant Hills', 'AU', 'NSW'),
(2826, 14, 207, 'Penrith', 'AU', 'NSW'),
(2827, 14, 207, 'Penrith Municipality', 'AU', 'NSW'),
(2828, 14, 207, 'Penshurst', 'AU', 'NSW'),
(2829, 14, 207, 'Petersham', 'AU', 'NSW'),
(2830, 14, 207, 'Phillip', 'AU', 'NSW'),
(2831, 14, 207, 'Picnic Point', 'AU', 'NSW'),
(2832, 14, 207, 'Picton', 'AU', 'NSW'),
(2833, 14, 207, 'Pitt Town', 'AU', 'NSW'),
(2834, 14, 207, 'Plumpton', 'AU', 'NSW'),
(2835, 14, 207, 'Point Clare', 'AU', 'NSW'),
(2836, 14, 207, 'Point Frederick', 'AU', 'NSW'),
(2837, 14, 207, 'Point Piper', 'AU', 'NSW'),
(2838, 14, 207, 'Pokolbin', 'AU', 'NSW'),
(2839, 14, 207, 'Port Hacking', 'AU', 'NSW'),
(2840, 14, 207, 'Port Kembla', 'AU', 'NSW'),
(2841, 14, 207, 'Port Macquarie', 'AU', 'NSW'),
(2842, 14, 207, 'Port Macquarie-Hastings', 'AU', 'NSW'),
(2843, 14, 207, 'Port Stephens Shire', 'AU', 'NSW'),
(2844, 14, 207, 'Portland', 'AU', 'NSW'),
(2845, 14, 207, 'Potts Point', 'AU', 'NSW'),
(2846, 14, 207, 'Pottsville', 'AU', 'NSW'),
(2847, 14, 207, 'Pottsville Beach', 'AU', 'NSW'),
(2848, 14, 207, 'Prairiewood', 'AU', 'NSW'),
(2849, 14, 207, 'Prestons', 'AU', 'NSW'),
(2850, 14, 207, 'Primbee', 'AU', 'NSW'),
(2851, 14, 207, 'Prospect', 'AU', 'NSW'),
(2852, 14, 207, 'Punchbowl', 'AU', 'NSW'),
(2853, 14, 207, 'Putney', 'AU', 'NSW'),
(2854, 14, 207, 'Pymble', 'AU', 'NSW'),
(2855, 14, 207, 'Pyrmont', 'AU', 'NSW'),
(2856, 14, 207, 'Quakers Hill', 'AU', 'NSW'),
(2857, 14, 207, 'Queanbeyan', 'AU', 'NSW'),
(2858, 14, 207, 'Queanbeyan East', 'AU', 'NSW'),
(2859, 14, 207, 'Queanbeyan West', 'AU', 'NSW'),
(2860, 14, 207, 'Queens Park', 'AU', 'NSW'),
(2861, 14, 207, 'Queenscliff', 'AU', 'NSW'),
(2862, 14, 207, 'Quirindi', 'AU', 'NSW'),
(2863, 14, 207, 'Raby', 'AU', 'NSW'),
(2864, 14, 207, 'Raglan', 'AU', 'NSW'),
(2865, 14, 207, 'Ramsgate', 'AU', 'NSW'),
(2866, 14, 207, 'Ramsgate Beach', 'AU', 'NSW'),
(2867, 14, 207, 'Randwick', 'AU', 'NSW'),
(2868, 14, 207, 'Rankin Park', 'AU', 'NSW'),
(2869, 14, 207, 'Rathmines', 'AU', 'NSW'),
(2870, 14, 207, 'Raworth', 'AU', 'NSW'),
(2871, 14, 207, 'Raymond Terrace', 'AU', 'NSW'),
(2872, 14, 207, 'Razorback', 'AU', 'NSW'),
(2873, 14, 207, 'Redfern', 'AU', 'NSW'),
(2874, 14, 207, 'Redhead', 'AU', 'NSW'),
(2875, 14, 207, 'Regents Park', 'AU', 'NSW'),
(2876, 14, 207, 'Revesby', 'AU', 'NSW'),
(2877, 14, 207, 'Revesby Heights', 'AU', 'NSW'),
(2878, 14, 207, 'Rhodes', 'AU', 'NSW'),
(2879, 14, 207, 'Richmond', 'AU', 'NSW'),
(2880, 14, 207, 'Richmond Valley', 'AU', 'NSW'),
(2881, 14, 207, 'Riverstone', 'AU', 'NSW'),
(2882, 14, 207, 'Riverview', 'AU', 'NSW'),
(2883, 14, 207, 'Riverwood', 'AU', 'NSW'),
(2884, 14, 207, 'Robertson', 'AU', 'NSW'),
(2885, 14, 207, 'Rockdale', 'AU', 'NSW'),
(2886, 14, 207, 'Rodd Point', 'AU', 'NSW'),
(2887, 14, 207, 'Rooty Hill', 'AU', 'NSW'),
(2888, 14, 207, 'Ropes Crossing', 'AU', 'NSW'),
(2889, 14, 207, 'Rose Bay', 'AU', 'NSW'),
(2890, 14, 207, 'Rosebery', 'AU', 'NSW'),
(2891, 14, 207, 'Rosehill', 'AU', 'NSW'),
(2892, 14, 207, 'Roselands', 'AU', 'NSW'),
(2893, 14, 207, 'Rosemeadow', 'AU', 'NSW'),
(2894, 14, 207, 'Roseville', 'AU', 'NSW'),
(2895, 14, 207, 'Roseville Chase', 'AU', 'NSW'),
(2896, 14, 207, 'Rouse Hill', 'AU', 'NSW'),
(2897, 14, 207, 'Rozelle', 'AU', 'NSW'),
(2898, 14, 207, 'Ruse', 'AU', 'NSW'),
(2899, 14, 207, 'Rushcutters Bay', 'AU', 'NSW'),
(2900, 14, 207, 'Russell Lea', 'AU', 'NSW'),
(2901, 14, 207, 'Russell Vale', 'AU', 'NSW'),
(2902, 14, 207, 'Rutherford', 'AU', 'NSW'),
(2903, 14, 207, 'Rydalmere', 'AU', 'NSW'),
(2904, 14, 207, 'Ryde', 'AU', 'NSW'),
(2905, 14, 207, 'Sadleir', 'AU', 'NSW'),
(2906, 14, 207, 'Saint Ives', 'AU', 'NSW'),
(2907, 14, 207, 'Saint Peters', 'AU', 'NSW'),
(2908, 14, 207, 'Salamander Bay', 'AU', 'NSW'),
(2909, 14, 207, 'Salt Ash', 'AU', 'NSW'),
(2910, 14, 207, 'San Remo', 'AU', 'NSW'),
(2911, 14, 207, 'Sanctuary Point', 'AU', 'NSW'),
(2912, 14, 207, 'Sandringham', 'AU', 'NSW'),
(2913, 14, 207, 'Sandy Beach', 'AU', 'NSW'),
(2914, 14, 207, 'Sans Souci', 'AU', 'NSW'),
(2915, 14, 207, 'Sapphire Beach', 'AU', 'NSW'),
(2916, 14, 207, 'Saratoga', 'AU', 'NSW'),
(2917, 14, 207, 'Sawtell', 'AU', 'NSW'),
(2918, 14, 207, 'Schofields', 'AU', 'NSW'),
(2919, 14, 207, 'Scone', 'AU', 'NSW'),
(2920, 14, 207, 'Seaforth', 'AU', 'NSW'),
(2921, 14, 207, 'Sefton', 'AU', 'NSW'),
(2922, 14, 207, 'Seven Hills', 'AU', 'NSW'),
(2923, 14, 207, 'Shalvey', 'AU', 'NSW'),
(2924, 14, 207, 'Shell Cove', 'AU', 'NSW'),
(2925, 14, 207, 'Shellharbour', 'AU', 'NSW'),
(2926, 14, 207, 'Shelly Beach', 'AU', 'NSW'),
(2927, 14, 207, 'Shoal Bay', 'AU', 'NSW'),
(2928, 14, 207, 'Shoalhaven Heads', 'AU', 'NSW'),
(2929, 14, 207, 'Shoalhaven Shire', 'AU', 'NSW'),
(2930, 14, 207, 'Shortland', 'AU', 'NSW'),
(2931, 14, 207, 'Silverdale', 'AU', 'NSW'),
(2932, 14, 207, 'Silverwater', 'AU', 'NSW'),
(2933, 14, 207, 'Singleton', 'AU', 'NSW'),
(2934, 14, 207, 'Singleton Heights', 'AU', 'NSW'),
(2935, 14, 207, 'Skennars Head', 'AU', 'NSW'),
(2936, 14, 207, 'Smithfield', 'AU', 'NSW'),
(2937, 14, 207, 'Smiths Lake', 'AU', 'NSW'),
(2938, 14, 207, 'Soldiers Point', 'AU', 'NSW'),
(2939, 14, 207, 'Somersby', 'AU', 'NSW'),
(2940, 14, 207, 'South Albury', 'AU', 'NSW'),
(2941, 14, 207, 'South Bathurst', 'AU', 'NSW'),
(2942, 14, 207, 'South Bowenfels', 'AU', 'NSW'),
(2943, 14, 207, 'South Coogee', 'AU', 'NSW'),
(2944, 14, 207, 'South Grafton', 'AU', 'NSW'),
(2945, 14, 207, 'South Granville', 'AU', 'NSW'),
(2946, 14, 207, 'South Hurstville', 'AU', 'NSW'),
(2947, 14, 207, 'South Kempsey', 'AU', 'NSW'),
(2948, 14, 207, 'South Lismore', 'AU', 'NSW'),
(2949, 14, 207, 'South Murwillumbah', 'AU', 'NSW'),
(2950, 14, 207, 'South Nowra', 'AU', 'NSW'),
(2951, 14, 207, 'South Penrith', 'AU', 'NSW'),
(2952, 14, 207, 'South Tamworth', 'AU', 'NSW'),
(2953, 14, 207, 'South Turramurra', 'AU', 'NSW'),
(2954, 14, 207, 'South Wentworthville', 'AU', 'NSW'),
(2955, 14, 207, 'South West Rocks', 'AU', 'NSW'),
(2956, 14, 207, 'South Windsor', 'AU', 'NSW'),
(2957, 14, 207, 'Speers Point', 'AU', 'NSW'),
(2958, 14, 207, 'Spring Farm', 'AU', 'NSW'),
(2959, 14, 207, 'Springdale Heights', 'AU', 'NSW'),
(2960, 14, 207, 'Springvale', 'AU', 'NSW'),
(2961, 14, 207, 'Springwood', 'AU', 'NSW'),
(2962, 14, 207, 'St Andrews', 'AU', 'NSW'),
(2963, 14, 207, 'St Clair', 'AU', 'NSW'),
(2964, 14, 207, 'St Helens Park', 'AU', 'NSW'),
(2965, 14, 207, 'St Huberts Island', 'AU', 'NSW'),
(2966, 14, 207, 'St Ives Chase', 'AU', 'NSW'),
(2967, 14, 207, 'St Johns Park', 'AU', 'NSW'),
(2968, 14, 207, 'St Leonards', 'AU', 'NSW'),
(2969, 14, 207, 'St. Georges Basin', 'AU', 'NSW'),
(2970, 14, 207, 'Stanhope Gardens', 'AU', 'NSW'),
(2971, 14, 207, 'Stanmore', 'AU', 'NSW'),
(2972, 14, 207, 'Stanwell Park', 'AU', 'NSW'),
(2973, 14, 207, 'Stockton', 'AU', 'NSW'),
(2974, 14, 207, 'Strathfield', 'AU', 'NSW'),
(2975, 14, 207, 'Strathfield South', 'AU', 'NSW'),
(2976, 14, 207, 'Suffolk Park', 'AU', 'NSW'),
(2977, 14, 207, 'Summer Hill', 'AU', 'NSW'),
(2978, 14, 207, 'Summerland Point', 'AU', 'NSW'),
(2979, 14, 207, 'Sunshine Bay', 'AU', 'NSW'),
(2980, 14, 207, 'Surfside', 'AU', 'NSW'),
(2981, 14, 207, 'Surry Hills', 'AU', 'NSW'),
(2982, 14, 207, 'Sussex Inlet', 'AU', 'NSW'),
(2983, 14, 207, 'Sutherland', 'AU', 'NSW'),
(2984, 14, 207, 'Sutherland Shire', 'AU', 'NSW'),
(2985, 14, 207, 'Sutton', 'AU', 'NSW'),
(2986, 14, 207, 'Swansea', 'AU', 'NSW'),
(2987, 14, 207, 'Sydenham', 'AU', 'NSW'),
(2988, 14, 207, 'Sydney', 'AU', 'NSW'),
(2989, 14, 207, 'Sydney Central Business District', 'AU', 'NSW'),
(2990, 14, 207, 'Sydney Olympic Park', 'AU', 'NSW'),
(2991, 14, 207, 'Sylvania', 'AU', 'NSW'),
(2992, 14, 207, 'Sylvania Waters', 'AU', 'NSW'),
(2993, 14, 207, 'Table Top', 'AU', 'NSW'),
(2994, 14, 207, 'Tahmoor', 'AU', 'NSW'),
(2995, 14, 207, 'Tamarama', 'AU', 'NSW'),
(2996, 14, 207, 'Tamworth', 'AU', 'NSW'),
(2997, 14, 207, 'Tamworth Municipality', 'AU', 'NSW'),
(2998, 14, 207, 'Tanilba Bay', 'AU', 'NSW'),
(2999, 14, 207, 'Taree', 'AU', 'NSW'),
(3000, 14, 207, 'Taren Point', 'AU', 'NSW');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(3001, 14, 207, 'Tarrawanna', 'AU', 'NSW'),
(3002, 14, 207, 'Tarro', 'AU', 'NSW'),
(3003, 14, 207, 'Tascott', 'AU', 'NSW'),
(3004, 14, 207, 'Tathra', 'AU', 'NSW'),
(3005, 14, 207, 'Tatton', 'AU', 'NSW'),
(3006, 14, 207, 'Tea Gardens', 'AU', 'NSW'),
(3007, 14, 207, 'Telarah', 'AU', 'NSW'),
(3008, 14, 207, 'Telopea', 'AU', 'NSW'),
(3009, 14, 207, 'Temora', 'AU', 'NSW'),
(3010, 14, 207, 'Temora Municipality', 'AU', 'NSW'),
(3011, 14, 207, 'Tempe', 'AU', 'NSW'),
(3012, 14, 207, 'Tenambit', 'AU', 'NSW'),
(3013, 14, 207, 'Tennyson Point', 'AU', 'NSW'),
(3014, 14, 207, 'Tenterfield', 'AU', 'NSW'),
(3015, 14, 207, 'Tenterfield Municipality', 'AU', 'NSW'),
(3016, 14, 207, 'Teralba', 'AU', 'NSW'),
(3017, 14, 207, 'Terranora', 'AU', 'NSW'),
(3018, 14, 207, 'Terrigal', 'AU', 'NSW'),
(3019, 14, 207, 'Terry Hills', 'AU', 'NSW'),
(3020, 14, 207, 'The Entrance', 'AU', 'NSW'),
(3021, 14, 207, 'The Entrance North', 'AU', 'NSW'),
(3022, 14, 207, 'The Hill', 'AU', 'NSW'),
(3023, 14, 207, 'The Hills Shire', 'AU', 'NSW'),
(3024, 14, 207, 'The Junction', 'AU', 'NSW'),
(3025, 14, 207, 'The Oaks', 'AU', 'NSW'),
(3026, 14, 207, 'The Ponds', 'AU', 'NSW'),
(3027, 14, 207, 'The Rock', 'AU', 'NSW'),
(3028, 14, 207, 'The Rocks', 'AU', 'NSW'),
(3029, 14, 207, 'Thirlmere', 'AU', 'NSW'),
(3030, 14, 207, 'Thirroul', 'AU', 'NSW'),
(3031, 14, 207, 'Thornleigh', 'AU', 'NSW'),
(3032, 14, 207, 'Thornton', 'AU', 'NSW'),
(3033, 14, 207, 'Thurgoona', 'AU', 'NSW'),
(3034, 14, 207, 'Tighes Hill', 'AU', 'NSW'),
(3035, 14, 207, 'Tingira Heights', 'AU', 'NSW'),
(3036, 14, 207, 'Tinonee', 'AU', 'NSW'),
(3037, 14, 207, 'Tocumwal', 'AU', 'NSW'),
(3038, 14, 207, 'Tolland', 'AU', 'NSW'),
(3039, 14, 207, 'Tomakin', 'AU', 'NSW'),
(3040, 14, 207, 'Tomerong', 'AU', 'NSW'),
(3041, 14, 207, 'Toongabbie', 'AU', 'NSW'),
(3042, 14, 207, 'Toormina', 'AU', 'NSW'),
(3043, 14, 207, 'Toronto', 'AU', 'NSW'),
(3044, 14, 207, 'Toukley', 'AU', 'NSW'),
(3045, 14, 207, 'Towradgi', 'AU', 'NSW'),
(3046, 14, 207, 'Trangie', 'AU', 'NSW'),
(3047, 14, 207, 'Tregear', 'AU', 'NSW'),
(3048, 14, 207, 'Tuggerawong', 'AU', 'NSW'),
(3049, 14, 207, 'Tumbarumba', 'AU', 'NSW'),
(3050, 14, 207, 'Tumbi Vmbi', 'AU', 'NSW'),
(3051, 14, 207, 'Tumut', 'AU', 'NSW'),
(3052, 14, 207, 'Tuncurry', 'AU', 'NSW'),
(3053, 14, 207, 'Tura Beach', 'AU', 'NSW'),
(3054, 14, 207, 'Tuross Head', 'AU', 'NSW'),
(3055, 14, 207, 'Turramurra', 'AU', 'NSW'),
(3056, 14, 207, 'Turrella', 'AU', 'NSW'),
(3057, 14, 207, 'Turvey Park', 'AU', 'NSW'),
(3058, 14, 207, 'Tweed', 'AU', 'NSW'),
(3059, 14, 207, 'Tweed Heads', 'AU', 'NSW'),
(3060, 14, 207, 'Tweed Heads South', 'AU', 'NSW'),
(3061, 14, 207, 'Tweed Heads West', 'AU', 'NSW'),
(3062, 14, 207, 'Ulladulla', 'AU', 'NSW'),
(3063, 14, 207, 'Ultimo', 'AU', 'NSW'),
(3064, 14, 207, 'Umina Beach', 'AU', 'NSW'),
(3065, 14, 207, 'Unanderra', 'AU', 'NSW'),
(3066, 14, 207, 'Upper Hunter Shire', 'AU', 'NSW'),
(3067, 14, 207, 'Upper Lachlan Shire', 'AU', 'NSW'),
(3068, 14, 207, 'Uralla', 'AU', 'NSW'),
(3069, 14, 207, 'Urunga', 'AU', 'NSW'),
(3070, 14, 207, 'Valentine', 'AU', 'NSW'),
(3071, 14, 207, 'Valla Beach', 'AU', 'NSW'),
(3072, 14, 207, 'Valley Heights', 'AU', 'NSW'),
(3073, 14, 207, 'Vaucluse', 'AU', 'NSW'),
(3074, 14, 207, 'Villawood', 'AU', 'NSW'),
(3075, 14, 207, 'Vincentia', 'AU', 'NSW'),
(3076, 14, 207, 'Vineyard', 'AU', 'NSW'),
(3077, 14, 207, 'Voyager Point', 'AU', 'NSW'),
(3078, 14, 207, 'Wadalba', 'AU', 'NSW'),
(3079, 14, 207, 'Wagga Wagga', 'AU', 'NSW'),
(3080, 14, 207, 'Wahroonga', 'AU', 'NSW'),
(3081, 14, 207, 'Waitara', 'AU', 'NSW'),
(3082, 14, 207, 'Wakeley', 'AU', 'NSW'),
(3083, 14, 207, 'Walcha', 'AU', 'NSW'),
(3084, 14, 207, 'Walgett', 'AU', 'NSW'),
(3085, 14, 207, 'Wallacia', 'AU', 'NSW'),
(3086, 14, 207, 'Wallalong', 'AU', 'NSW'),
(3087, 14, 207, 'Wallerawang', 'AU', 'NSW'),
(3088, 14, 207, 'Wallsend', 'AU', 'NSW'),
(3089, 14, 207, 'Wamberal', 'AU', 'NSW'),
(3090, 14, 207, 'Wamboin', 'AU', 'NSW'),
(3091, 14, 207, 'Wangi Wangi', 'AU', 'NSW'),
(3092, 14, 207, 'Warabrook', 'AU', 'NSW'),
(3093, 14, 207, 'Waratah', 'AU', 'NSW'),
(3094, 14, 207, 'Waratah West', 'AU', 'NSW'),
(3095, 14, 207, 'Wareemba', 'AU', 'NSW'),
(3096, 14, 207, 'Warialda', 'AU', 'NSW'),
(3097, 14, 207, 'Warilla', 'AU', 'NSW'),
(3098, 14, 207, 'Warners Bay', 'AU', 'NSW'),
(3099, 14, 207, 'Warragamba', 'AU', 'NSW'),
(3100, 14, 207, 'Warrawee', 'AU', 'NSW'),
(3101, 14, 207, 'Warrawong', 'AU', 'NSW'),
(3102, 14, 207, 'Warren', 'AU', 'NSW'),
(3103, 14, 207, 'Warren Shire', 'AU', 'NSW'),
(3104, 14, 207, 'Warriewood', 'AU', 'NSW'),
(3105, 14, 207, 'Warrimoo', 'AU', 'NSW'),
(3106, 14, 207, 'Warrumbungle Shire', 'AU', 'NSW'),
(3107, 14, 207, 'Warwick Farm', 'AU', 'NSW'),
(3108, 14, 207, 'Watanobbi', 'AU', 'NSW'),
(3109, 14, 207, 'Waterview Heights', 'AU', 'NSW'),
(3110, 14, 207, 'Wattle Grove', 'AU', 'NSW'),
(3111, 14, 207, 'Wattle Ponds', 'AU', 'NSW'),
(3112, 14, 207, 'Wauchope', 'AU', 'NSW'),
(3113, 14, 207, 'Waverley', 'AU', 'NSW'),
(3114, 14, 207, 'Waverton', 'AU', 'NSW'),
(3115, 14, 207, 'Weddin', 'AU', 'NSW'),
(3116, 14, 207, 'Wee Waa', 'AU', 'NSW'),
(3117, 14, 207, 'Wellington', 'AU', 'NSW'),
(3118, 14, 207, 'Wentworth', 'AU', 'NSW'),
(3119, 14, 207, 'Wentworth Falls', 'AU', 'NSW'),
(3120, 14, 207, 'Wentworth Point', 'AU', 'NSW'),
(3121, 14, 207, 'Wentworthville', 'AU', 'NSW'),
(3122, 14, 207, 'Werrington', 'AU', 'NSW'),
(3123, 14, 207, 'Werrington County', 'AU', 'NSW'),
(3124, 14, 207, 'Werrington Downs', 'AU', 'NSW'),
(3125, 14, 207, 'Werris Creek', 'AU', 'NSW'),
(3126, 14, 207, 'West Albury', 'AU', 'NSW'),
(3127, 14, 207, 'West Ballina', 'AU', 'NSW'),
(3128, 14, 207, 'West Bathurst', 'AU', 'NSW'),
(3129, 14, 207, 'West Gosford', 'AU', 'NSW'),
(3130, 14, 207, 'West Haven', 'AU', 'NSW'),
(3131, 14, 207, 'West Hoxton', 'AU', 'NSW'),
(3132, 14, 207, 'West Kempsey', 'AU', 'NSW'),
(3133, 14, 207, 'West Nowra', 'AU', 'NSW'),
(3134, 14, 207, 'West Pennant Hills', 'AU', 'NSW'),
(3135, 14, 207, 'West Pymble', 'AU', 'NSW'),
(3136, 14, 207, 'West Ryde', 'AU', 'NSW'),
(3137, 14, 207, 'West Tamworth', 'AU', 'NSW'),
(3138, 14, 207, 'West Wallsend', 'AU', 'NSW'),
(3139, 14, 207, 'West Wollongong', 'AU', 'NSW'),
(3140, 14, 207, 'West Wyalong', 'AU', 'NSW'),
(3141, 14, 207, 'Westdale', 'AU', 'NSW'),
(3142, 14, 207, 'Westleigh', 'AU', 'NSW'),
(3143, 14, 207, 'Westmead', 'AU', 'NSW'),
(3144, 14, 207, 'Wetherill Park', 'AU', 'NSW'),
(3145, 14, 207, 'Whalan', 'AU', 'NSW'),
(3146, 14, 207, 'Whale Beach', 'AU', 'NSW'),
(3147, 14, 207, 'Wheeler Heights', 'AU', 'NSW'),
(3148, 14, 207, 'Whitebridge', 'AU', 'NSW'),
(3149, 14, 207, 'Wickham', 'AU', 'NSW'),
(3150, 14, 207, 'Wilberforce', 'AU', 'NSW'),
(3151, 14, 207, 'Wiley Park', 'AU', 'NSW'),
(3152, 14, 207, 'Williamtown', 'AU', 'NSW'),
(3153, 14, 207, 'Willmot', 'AU', 'NSW'),
(3154, 14, 207, 'Willoughby', 'AU', 'NSW'),
(3155, 14, 207, 'Willoughby East', 'AU', 'NSW'),
(3156, 14, 207, 'Wilton', 'AU', 'NSW'),
(3157, 14, 207, 'Windale', 'AU', 'NSW'),
(3158, 14, 207, 'Windang', 'AU', 'NSW'),
(3159, 14, 207, 'Windradyne', 'AU', 'NSW'),
(3160, 14, 207, 'Windsor', 'AU', 'NSW'),
(3161, 14, 207, 'Windsor Downs', 'AU', 'NSW'),
(3162, 14, 207, 'Wingecarribee', 'AU', 'NSW'),
(3163, 14, 207, 'Wingham', 'AU', 'NSW'),
(3164, 14, 207, 'Winmalee', 'AU', 'NSW'),
(3165, 14, 207, 'Winston Hills', 'AU', 'NSW'),
(3166, 14, 207, 'Wolli Creek', 'AU', 'NSW'),
(3167, 14, 207, 'Wollondilly', 'AU', 'NSW'),
(3168, 14, 207, 'Wollongbar', 'AU', 'NSW'),
(3169, 14, 207, 'Wollongong', 'AU', 'NSW'),
(3170, 14, 207, 'Wollongong city centre', 'AU', 'NSW'),
(3171, 14, 207, 'Wollstonecraft', 'AU', 'NSW'),
(3172, 14, 207, 'Woodberry', 'AU', 'NSW'),
(3173, 14, 207, 'Woodbine', 'AU', 'NSW'),
(3174, 14, 207, 'Woodcroft', 'AU', 'NSW'),
(3175, 14, 207, 'Woodford', 'AU', 'NSW'),
(3176, 14, 207, 'Woodpark', 'AU', 'NSW'),
(3177, 14, 207, 'Woodrising', 'AU', 'NSW'),
(3178, 14, 207, 'Woolgoolga', 'AU', 'NSW'),
(3179, 14, 207, 'Woollahra', 'AU', 'NSW'),
(3180, 14, 207, 'Woolloomooloo', 'AU', 'NSW'),
(3181, 14, 207, 'Woolooware', 'AU', 'NSW'),
(3182, 14, 207, 'Woongarrah', 'AU', 'NSW'),
(3183, 14, 207, 'Woonona', 'AU', 'NSW'),
(3184, 14, 207, 'Woronora', 'AU', 'NSW'),
(3185, 14, 207, 'Woronora Heights', 'AU', 'NSW'),
(3186, 14, 207, 'Worrigee', 'AU', 'NSW'),
(3187, 14, 207, 'Woy Woy', 'AU', 'NSW'),
(3188, 14, 207, 'Wyee', 'AU', 'NSW'),
(3189, 14, 207, 'Wyee Point', 'AU', 'NSW'),
(3190, 14, 207, 'Wyoming', 'AU', 'NSW'),
(3191, 14, 207, 'Wyong', 'AU', 'NSW'),
(3192, 14, 207, 'Wyongah', 'AU', 'NSW'),
(3193, 14, 207, 'Yagoona', 'AU', 'NSW'),
(3194, 14, 207, 'Yallah', 'AU', 'NSW'),
(3195, 14, 207, 'Yamba', 'AU', 'NSW'),
(3196, 14, 207, 'Yarravel', 'AU', 'NSW'),
(3197, 14, 207, 'Yarrawarrah', 'AU', 'NSW'),
(3198, 14, 207, 'Yass', 'AU', 'NSW'),
(3199, 14, 207, 'Yass Valley', 'AU', 'NSW'),
(3200, 14, 207, 'Yenda', 'AU', 'NSW'),
(3201, 14, 207, 'Yennora', 'AU', 'NSW'),
(3202, 14, 207, 'Yerrinbool', 'AU', 'NSW'),
(3203, 14, 207, 'Yoogali', 'AU', 'NSW'),
(3204, 14, 207, 'Young', 'AU', 'NSW'),
(3205, 14, 207, 'Yowie Bay', 'AU', 'NSW'),
(3206, 14, 207, 'Zetland', 'AU', 'NSW'),
(3207, 14, 208, 'Alawa', 'AU', 'NT'),
(3208, 14, 208, 'Alice Springs', 'AU', 'NT'),
(3209, 14, 208, 'Alyangula', 'AU', 'NT'),
(3210, 14, 208, 'Anula', 'AU', 'NT'),
(3211, 14, 208, 'Araluen', 'AU', 'NT'),
(3212, 14, 208, 'Bakewell', 'AU', 'NT'),
(3213, 14, 208, 'Barkly', 'AU', 'NT'),
(3214, 14, 208, 'Bellamack', 'AU', 'NT'),
(3215, 14, 208, 'Belyuen', 'AU', 'NT'),
(3216, 14, 208, 'Berrimah', 'AU', 'NT'),
(3217, 14, 208, 'Braitling', 'AU', 'NT'),
(3218, 14, 208, 'Brinkin', 'AU', 'NT'),
(3219, 14, 208, 'Central Desert', 'AU', 'NT'),
(3220, 14, 208, 'Coconut Grove', 'AU', 'NT'),
(3221, 14, 208, 'Coomalie', 'AU', 'NT'),
(3222, 14, 208, 'Cossack', 'AU', 'NT'),
(3223, 14, 208, 'Darwin', 'AU', 'NT'),
(3224, 14, 208, 'Desert Springs', 'AU', 'NT'),
(3225, 14, 208, 'Driver', 'AU', 'NT'),
(3226, 14, 208, 'Durack', 'AU', 'NT'),
(3227, 14, 208, 'East Arnhem', 'AU', 'NT'),
(3228, 14, 208, 'East Side', 'AU', 'NT'),
(3229, 14, 208, 'Fannie Bay', 'AU', 'NT'),
(3230, 14, 208, 'Farrar', 'AU', 'NT'),
(3231, 14, 208, 'Galiwinku', 'AU', 'NT'),
(3232, 14, 208, 'Gillen', 'AU', 'NT'),
(3233, 14, 208, 'Girraween', 'AU', 'NT'),
(3234, 14, 208, 'Gray', 'AU', 'NT'),
(3235, 14, 208, 'Gunbalanya', 'AU', 'NT'),
(3236, 14, 208, 'Gunn', 'AU', 'NT'),
(3237, 14, 208, 'Herbert', 'AU', 'NT'),
(3238, 14, 208, 'Holtze', 'AU', 'NT'),
(3239, 14, 208, 'Howard Springs', 'AU', 'NT'),
(3240, 14, 208, 'Humpty Doo', 'AU', 'NT'),
(3241, 14, 208, 'Jabiru', 'AU', 'NT'),
(3242, 14, 208, 'Jingili', 'AU', 'NT'),
(3243, 14, 208, 'Johnston', 'AU', 'NT'),
(3244, 14, 208, 'Karama', 'AU', 'NT'),
(3245, 14, 208, 'Katherine', 'AU', 'NT'),
(3246, 14, 208, 'Katherine East', 'AU', 'NT'),
(3247, 14, 208, 'Katherine South', 'AU', 'NT'),
(3248, 14, 208, 'Larapinta', 'AU', 'NT'),
(3249, 14, 208, 'Larrakeyah', 'AU', 'NT'),
(3250, 14, 208, 'Leanyer', 'AU', 'NT'),
(3251, 14, 208, 'Litchfield', 'AU', 'NT'),
(3252, 14, 208, 'Ludmilla', 'AU', 'NT'),
(3253, 14, 208, 'Lyons', 'AU', 'NT'),
(3254, 14, 208, 'MacDonnell', 'AU', 'NT'),
(3255, 14, 208, 'Malak', 'AU', 'NT'),
(3256, 14, 208, 'Maningrida', 'AU', 'NT'),
(3257, 14, 208, 'Marrara', 'AU', 'NT'),
(3258, 14, 208, 'Milingimbi', 'AU', 'NT'),
(3259, 14, 208, 'Millner', 'AU', 'NT'),
(3260, 14, 208, 'Moil', 'AU', 'NT'),
(3261, 14, 208, 'Moulden', 'AU', 'NT'),
(3262, 14, 208, 'Muirhead', 'AU', 'NT'),
(3263, 14, 208, 'Nakara', 'AU', 'NT'),
(3264, 14, 208, 'Ngukurr', 'AU', 'NT'),
(3265, 14, 208, 'Nhulunbuy', 'AU', 'NT'),
(3266, 14, 208, 'Nightcliff', 'AU', 'NT'),
(3267, 14, 208, 'Palmerston', 'AU', 'NT'),
(3268, 14, 208, 'Parap', 'AU', 'NT'),
(3269, 14, 208, 'Rapid Creek', 'AU', 'NT'),
(3270, 14, 208, 'Roper Gulf', 'AU', 'NT'),
(3271, 14, 208, 'Rosebery', 'AU', 'NT'),
(3272, 14, 208, 'Ross', 'AU', 'NT'),
(3273, 14, 208, 'Sadadeen', 'AU', 'NT'),
(3274, 14, 208, 'Stuart Park', 'AU', 'NT'),
(3275, 14, 208, 'Tennant Creek', 'AU', 'NT'),
(3276, 14, 208, 'The Gap', 'AU', 'NT'),
(3277, 14, 208, 'Tiwi', 'AU', 'NT'),
(3278, 14, 208, 'Tiwi Islands', 'AU', 'NT'),
(3279, 14, 208, 'Victoria Daly', 'AU', 'NT'),
(3280, 14, 208, 'Virginia', 'AU', 'NT'),
(3281, 14, 208, 'Wadeye', 'AU', 'NT'),
(3282, 14, 208, 'Wagait', 'AU', 'NT'),
(3283, 14, 208, 'Wagaman', 'AU', 'NT'),
(3284, 14, 208, 'Wanguri', 'AU', 'NT'),
(3285, 14, 208, 'West Arnhem', 'AU', 'NT'),
(3286, 14, 208, 'Woodroffe', 'AU', 'NT'),
(3287, 14, 208, 'Wulagi', 'AU', 'NT'),
(3288, 14, 208, 'Wurrumiyanga', 'AU', 'NT'),
(3289, 14, 208, 'Yulara', 'AU', 'NT'),
(3290, 14, 208, 'Zuccoli', 'AU', 'NT'),
(3291, 14, 209, 'Acacia Ridge', 'AU', 'QLD'),
(3292, 14, 209, 'Agnes Water', 'AU', 'QLD'),
(3293, 14, 209, 'Airlie Beach', 'AU', 'QLD'),
(3294, 14, 209, 'Aitkenvale', 'AU', 'QLD'),
(3295, 14, 209, 'Albany Creek', 'AU', 'QLD'),
(3296, 14, 209, 'Alderley', 'AU', 'QLD'),
(3297, 14, 209, 'Aldershot', 'AU', 'QLD'),
(3298, 14, 209, 'Alexandra Headland', 'AU', 'QLD'),
(3299, 14, 209, 'Alexandra Hills', 'AU', 'QLD'),
(3300, 14, 209, 'Algester', 'AU', 'QLD'),
(3301, 14, 209, 'Alice River', 'AU', 'QLD'),
(3302, 14, 209, 'Allenstown', 'AU', 'QLD'),
(3303, 14, 209, 'Alligator Creek', 'AU', 'QLD'),
(3304, 14, 209, 'Allora', 'AU', 'QLD'),
(3305, 14, 209, 'Alton Downs', 'AU', 'QLD'),
(3306, 14, 209, 'Andergrove', 'AU', 'QLD'),
(3307, 14, 209, 'Annandale', 'AU', 'QLD'),
(3308, 14, 209, 'Annerley', 'AU', 'QLD'),
(3309, 14, 209, 'Anstead', 'AU', 'QLD'),
(3310, 14, 209, 'Arana Hills', 'AU', 'QLD'),
(3311, 14, 209, 'Aroona', 'AU', 'QLD'),
(3312, 14, 209, 'Arundel', 'AU', 'QLD'),
(3313, 14, 209, 'Ascot', 'AU', 'QLD'),
(3314, 14, 209, 'Ashgrove', 'AU', 'QLD'),
(3315, 14, 209, 'Ashmore', 'AU', 'QLD'),
(3316, 14, 209, 'Aspley', 'AU', 'QLD'),
(3317, 14, 209, 'Atherton', 'AU', 'QLD'),
(3318, 14, 209, 'Auchenflower', 'AU', 'QLD'),
(3319, 14, 209, 'Augustine Heights', 'AU', 'QLD'),
(3320, 14, 209, 'Aurukun', 'AU', 'QLD'),
(3321, 14, 209, 'Avenell Heights', 'AU', 'QLD'),
(3322, 14, 209, 'Avoca', 'AU', 'QLD'),
(3323, 14, 209, 'Ayr', 'AU', 'QLD'),
(3324, 14, 209, 'Babinda', 'AU', 'QLD'),
(3325, 14, 209, 'Bahrs Scrub', 'AU', 'QLD'),
(3326, 14, 209, 'Bakers Creek', 'AU', 'QLD'),
(3327, 14, 209, 'Bald Hills', 'AU', 'QLD'),
(3328, 14, 209, 'Balmoral', 'AU', 'QLD'),
(3329, 14, 209, 'Balonne Shire', 'AU', 'QLD'),
(3330, 14, 209, 'Bamaga', 'AU', 'QLD'),
(3331, 14, 209, 'Banana', 'AU', 'QLD'),
(3332, 14, 209, 'Banksia Beach', 'AU', 'QLD'),
(3333, 14, 209, 'Banyo', 'AU', 'QLD'),
(3334, 14, 209, 'Barcaldine', 'AU', 'QLD'),
(3335, 14, 209, 'Barcoo', 'AU', 'QLD'),
(3336, 14, 209, 'Bardon', 'AU', 'QLD'),
(3337, 14, 209, 'Barellan Point', 'AU', 'QLD'),
(3338, 14, 209, 'Bargara', 'AU', 'QLD'),
(3339, 14, 209, 'Barney Point', 'AU', 'QLD'),
(3340, 14, 209, 'Battery Hill', 'AU', 'QLD'),
(3341, 14, 209, 'Bayview Heights', 'AU', 'QLD'),
(3342, 14, 209, 'Beachmere', 'AU', 'QLD'),
(3343, 14, 209, 'Beaconsfield', 'AU', 'QLD'),
(3344, 14, 209, 'Beaudesert', 'AU', 'QLD'),
(3345, 14, 209, 'Beenleigh', 'AU', 'QLD'),
(3346, 14, 209, 'Beerwah', 'AU', 'QLD'),
(3347, 14, 209, 'Belgian Gardens', 'AU', 'QLD'),
(3348, 14, 209, 'Bellara', 'AU', 'QLD'),
(3349, 14, 209, 'Bellbird Park', 'AU', 'QLD'),
(3350, 14, 209, 'Bellbowrie', 'AU', 'QLD'),
(3351, 14, 209, 'Bellmere', 'AU', 'QLD'),
(3352, 14, 209, 'Belmont', 'AU', 'QLD'),
(3353, 14, 209, 'Benaraby', 'AU', 'QLD'),
(3354, 14, 209, 'Benowa', 'AU', 'QLD'),
(3355, 14, 209, 'Bentley Park', 'AU', 'QLD'),
(3356, 14, 209, 'Berrinba', 'AU', 'QLD'),
(3357, 14, 209, 'Berserker', 'AU', 'QLD'),
(3358, 14, 209, 'Biggera Waters', 'AU', 'QLD'),
(3359, 14, 209, 'Bilinga', 'AU', 'QLD'),
(3360, 14, 209, 'Biloela', 'AU', 'QLD'),
(3361, 14, 209, 'Birkdale', 'AU', 'QLD'),
(3362, 14, 209, 'Birtinya', 'AU', 'QLD'),
(3363, 14, 209, 'Black Mountain', 'AU', 'QLD'),
(3364, 14, 209, 'Black River', 'AU', 'QLD'),
(3365, 14, 209, 'Blackall', 'AU', 'QLD'),
(3366, 14, 209, 'Blackall Tambo', 'AU', 'QLD'),
(3367, 14, 209, 'Blacks Beach', 'AU', 'QLD'),
(3368, 14, 209, 'Blackwater', 'AU', 'QLD'),
(3369, 14, 209, 'Bli Bli', 'AU', 'QLD'),
(3370, 14, 209, 'Bluewater', 'AU', 'QLD'),
(3371, 14, 209, 'Bohle Plains', 'AU', 'QLD'),
(3372, 14, 209, 'Bokarina', 'AU', 'QLD'),
(3373, 14, 209, 'Bongaree', 'AU', 'QLD'),
(3374, 14, 209, 'Bonogin', 'AU', 'QLD'),
(3375, 14, 209, 'Booie', 'AU', 'QLD'),
(3376, 14, 209, 'Boonah', 'AU', 'QLD'),
(3377, 14, 209, 'Boondall', 'AU', 'QLD'),
(3378, 14, 209, 'Booral', 'AU', 'QLD'),
(3379, 14, 209, 'Booval', 'AU', 'QLD'),
(3380, 14, 209, 'Boronia Heights', 'AU', 'QLD'),
(3381, 14, 209, 'Bouldercombe', 'AU', 'QLD'),
(3382, 14, 209, 'Boulia', 'AU', 'QLD'),
(3383, 14, 209, 'Bowen', 'AU', 'QLD'),
(3384, 14, 209, 'Bowen Hills', 'AU', 'QLD'),
(3385, 14, 209, 'Boyne Island', 'AU', 'QLD'),
(3386, 14, 209, 'Bracken Ridge', 'AU', 'QLD'),
(3387, 14, 209, 'Brandon', 'AU', 'QLD'),
(3388, 14, 209, 'Branyan', 'AU', 'QLD'),
(3389, 14, 209, 'Brassall', 'AU', 'QLD'),
(3390, 14, 209, 'Bray Park', 'AU', 'QLD'),
(3391, 14, 209, 'Brendale', 'AU', 'QLD'),
(3392, 14, 209, 'Bridgeman Downs', 'AU', 'QLD'),
(3393, 14, 209, 'Brighton', 'AU', 'QLD'),
(3394, 14, 209, 'Brinsmead', 'AU', 'QLD'),
(3395, 14, 209, 'Brisbane', 'AU', 'QLD'),
(3396, 14, 209, 'Broadbeach', 'AU', 'QLD'),
(3397, 14, 209, 'Broadbeach Waters', 'AU', 'QLD'),
(3398, 14, 209, 'Brookfield', 'AU', 'QLD'),
(3399, 14, 209, 'Brookwater', 'AU', 'QLD'),
(3400, 14, 209, 'Bucasia', 'AU', 'QLD'),
(3401, 14, 209, 'Bucca', 'AU', 'QLD'),
(3402, 14, 209, 'Buccan', 'AU', 'QLD'),
(3403, 14, 209, 'Buddina', 'AU', 'QLD'),
(3404, 14, 209, 'Buderim', 'AU', 'QLD'),
(3405, 14, 209, 'Bulimba', 'AU', 'QLD'),
(3406, 14, 209, 'Bulloo', 'AU', 'QLD'),
(3407, 14, 209, 'Bundaberg', 'AU', 'QLD'),
(3408, 14, 209, 'Bundaberg East', 'AU', 'QLD'),
(3409, 14, 209, 'Bundaberg North', 'AU', 'QLD'),
(3410, 14, 209, 'Bundaberg South', 'AU', 'QLD'),
(3411, 14, 209, 'Bundaberg West', 'AU', 'QLD'),
(3412, 14, 209, 'Bundall', 'AU', 'QLD'),
(3413, 14, 209, 'Bundamba', 'AU', 'QLD'),
(3414, 14, 209, 'Bungalow', 'AU', 'QLD'),
(3415, 14, 209, 'Bunya', 'AU', 'QLD'),
(3416, 14, 209, 'Burbank', 'AU', 'QLD'),
(3417, 14, 209, 'Burdekin', 'AU', 'QLD'),
(3418, 14, 209, 'Burdell', 'AU', 'QLD'),
(3419, 14, 209, 'Burke', 'AU', 'QLD'),
(3420, 14, 209, 'Burleigh Heads', 'AU', 'QLD'),
(3421, 14, 209, 'Burleigh Waters', 'AU', 'QLD'),
(3422, 14, 209, 'Burnett Heads', 'AU', 'QLD'),
(3423, 14, 209, 'Burnside', 'AU', 'QLD'),
(3424, 14, 209, 'Burpengary', 'AU', 'QLD'),
(3425, 14, 209, 'Burpengary East', 'AU', 'QLD'),
(3426, 14, 209, 'Burrum Heads', 'AU', 'QLD'),
(3427, 14, 209, 'Bushland Beach', 'AU', 'QLD'),
(3428, 14, 209, 'Cabarlah', 'AU', 'QLD'),
(3429, 14, 209, 'Caboolture', 'AU', 'QLD'),
(3430, 14, 209, 'Caboolture South', 'AU', 'QLD'),
(3431, 14, 209, 'Cairns', 'AU', 'QLD'),
(3432, 14, 209, 'Cairns City', 'AU', 'QLD'),
(3433, 14, 209, 'Cairns North', 'AU', 'QLD'),
(3434, 14, 209, 'Calamvale', 'AU', 'QLD'),
(3435, 14, 209, 'Calliope', 'AU', 'QLD'),
(3436, 14, 209, 'Caloundra', 'AU', 'QLD'),
(3437, 14, 209, 'Caloundra West', 'AU', 'QLD'),
(3438, 14, 209, 'Cambooya', 'AU', 'QLD'),
(3439, 14, 209, 'Camira', 'AU', 'QLD'),
(3440, 14, 209, 'Camp Hill', 'AU', 'QLD'),
(3441, 14, 209, 'Camp Mountain', 'AU', 'QLD'),
(3442, 14, 209, 'Cannon Hill', 'AU', 'QLD'),
(3443, 14, 209, 'Cannonvale', 'AU', 'QLD'),
(3444, 14, 209, 'Canungra', 'AU', 'QLD'),
(3445, 14, 209, 'Capalaba', 'AU', 'QLD'),
(3446, 14, 209, 'Capella', 'AU', 'QLD'),
(3447, 14, 209, 'Caravonica', 'AU', 'QLD'),
(3448, 14, 209, 'Carbrook', 'AU', 'QLD'),
(3449, 14, 209, 'Cardwell', 'AU', 'QLD'),
(3450, 14, 209, 'Carina Heights', 'AU', 'QLD'),
(3451, 14, 209, 'Carindale', 'AU', 'QLD'),
(3452, 14, 209, 'Carpentaria', 'AU', 'QLD'),
(3453, 14, 209, 'Carrara', 'AU', 'QLD'),
(3454, 14, 209, 'Carseldine', 'AU', 'QLD'),
(3455, 14, 209, 'Cashmere', 'AU', 'QLD'),
(3456, 14, 209, 'Cassowary Coast', 'AU', 'QLD'),
(3457, 14, 209, 'Cedar Grove', 'AU', 'QLD'),
(3458, 14, 209, 'Cedar Vale', 'AU', 'QLD'),
(3459, 14, 209, 'Centenary Heights', 'AU', 'QLD'),
(3460, 14, 209, 'Central Highlands', 'AU', 'QLD'),
(3461, 14, 209, 'Chambers Flat', 'AU', 'QLD'),
(3462, 14, 209, 'Chandler', 'AU', 'QLD'),
(3463, 14, 209, 'Chapel Hill', 'AU', 'QLD'),
(3464, 14, 209, 'Charleville', 'AU', 'QLD'),
(3465, 14, 209, 'Charters Towers', 'AU', 'QLD'),
(3466, 14, 209, 'Charters Towers City', 'AU', 'QLD'),
(3467, 14, 209, 'Chatsworth', 'AU', 'QLD'),
(3468, 14, 209, 'Chelmer', 'AU', 'QLD'),
(3469, 14, 209, 'Cherbourg', 'AU', 'QLD'),
(3470, 14, 209, 'Chermside', 'AU', 'QLD'),
(3471, 14, 209, 'Chermside West', 'AU', 'QLD'),
(3472, 14, 209, 'Childers', 'AU', 'QLD'),
(3473, 14, 209, 'Chinchilla', 'AU', 'QLD'),
(3474, 14, 209, 'Churchill', 'AU', 'QLD'),
(3475, 14, 209, 'Chuwar', 'AU', 'QLD'),
(3476, 14, 209, 'Clayfield', 'AU', 'QLD'),
(3477, 14, 209, 'Clear Island Waters', 'AU', 'QLD'),
(3478, 14, 209, 'Clermont', 'AU', 'QLD'),
(3479, 14, 209, 'Cleveland', 'AU', 'QLD'),
(3480, 14, 209, 'Clifton', 'AU', 'QLD'),
(3481, 14, 209, 'Clifton Beach', 'AU', 'QLD'),
(3482, 14, 209, 'Clinton', 'AU', 'QLD'),
(3483, 14, 209, 'Cloncurry', 'AU', 'QLD'),
(3484, 14, 209, 'Clontarf', 'AU', 'QLD'),
(3485, 14, 209, 'Coes Creek', 'AU', 'QLD'),
(3486, 14, 209, 'Collingwood Park', 'AU', 'QLD'),
(3487, 14, 209, 'Collinsville', 'AU', 'QLD'),
(3488, 14, 209, 'Condon', 'AU', 'QLD'),
(3489, 14, 209, 'Cooee Bay', 'AU', 'QLD'),
(3490, 14, 209, 'Cook Shire', 'AU', 'QLD'),
(3491, 14, 209, 'Cooktown', 'AU', 'QLD'),
(3492, 14, 209, 'Coolangatta', 'AU', 'QLD'),
(3493, 14, 209, 'Cooloola Cove', 'AU', 'QLD'),
(3494, 14, 209, 'Coolum Beach', 'AU', 'QLD'),
(3495, 14, 209, 'Coombabah', 'AU', 'QLD'),
(3496, 14, 209, 'Coomera', 'AU', 'QLD'),
(3497, 14, 209, 'Coominya', 'AU', 'QLD'),
(3498, 14, 209, 'Coopers Plains', 'AU', 'QLD'),
(3499, 14, 209, 'Cooran', 'AU', 'QLD'),
(3500, 14, 209, 'Cooroibah', 'AU', 'QLD');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(3501, 14, 209, 'Cooroy', 'AU', 'QLD'),
(3502, 14, 209, 'Coorparoo', 'AU', 'QLD'),
(3503, 14, 209, 'Coppabella', 'AU', 'QLD'),
(3504, 14, 209, 'Coral Cove', 'AU', 'QLD'),
(3505, 14, 209, 'Corinda', 'AU', 'QLD'),
(3506, 14, 209, 'Cornubia', 'AU', 'QLD'),
(3507, 14, 209, 'Cotswold Hills', 'AU', 'QLD'),
(3508, 14, 209, 'Craiglie', 'AU', 'QLD'),
(3509, 14, 209, 'Craignish', 'AU', 'QLD'),
(3510, 14, 209, 'Cranbrook', 'AU', 'QLD'),
(3511, 14, 209, 'Cranley', 'AU', 'QLD'),
(3512, 14, 209, 'Crestmead', 'AU', 'QLD'),
(3513, 14, 209, 'Crows Nest', 'AU', 'QLD'),
(3514, 14, 209, 'Croydon', 'AU', 'QLD'),
(3515, 14, 209, 'Cunnamulla', 'AU', 'QLD'),
(3516, 14, 209, 'Curra', 'AU', 'QLD'),
(3517, 14, 209, 'Currajong', 'AU', 'QLD'),
(3518, 14, 209, 'Currimundi', 'AU', 'QLD'),
(3519, 14, 209, 'Currumbin', 'AU', 'QLD'),
(3520, 14, 209, 'Currumbin Valley', 'AU', 'QLD'),
(3521, 14, 209, 'Currumbin Waters', 'AU', 'QLD'),
(3522, 14, 209, 'D’Aguilar', 'AU', 'QLD'),
(3523, 14, 209, 'Daisy Hill', 'AU', 'QLD'),
(3524, 14, 209, 'Dakabin', 'AU', 'QLD'),
(3525, 14, 209, 'Dalby', 'AU', 'QLD'),
(3526, 14, 209, 'Darling Heights', 'AU', 'QLD'),
(3527, 14, 209, 'Darra', 'AU', 'QLD'),
(3528, 14, 209, 'Dayboro', 'AU', 'QLD'),
(3529, 14, 209, 'Deagon', 'AU', 'QLD'),
(3530, 14, 209, 'Deception Bay', 'AU', 'QLD'),
(3531, 14, 209, 'Deebing Heights', 'AU', 'QLD'),
(3532, 14, 209, 'Deeragun', 'AU', 'QLD'),
(3533, 14, 209, 'Delaneys Creek', 'AU', 'QLD'),
(3534, 14, 209, 'Depot Hill', 'AU', 'QLD'),
(3535, 14, 209, 'Diamantina', 'AU', 'QLD'),
(3536, 14, 209, 'Dicky Beach', 'AU', 'QLD'),
(3537, 14, 209, 'Diddillibah', 'AU', 'QLD'),
(3538, 14, 209, 'Dimbulah', 'AU', 'QLD'),
(3539, 14, 209, 'Doolandella', 'AU', 'QLD'),
(3540, 14, 209, 'Doomadgee', 'AU', 'QLD'),
(3541, 14, 209, 'Doonan', 'AU', 'QLD'),
(3542, 14, 209, 'Douglas', 'AU', 'QLD'),
(3543, 14, 209, 'Drayton', 'AU', 'QLD'),
(3544, 14, 209, 'Drewvale', 'AU', 'QLD'),
(3545, 14, 209, 'Dundowran Beach', 'AU', 'QLD'),
(3546, 14, 209, 'Durack', 'AU', 'QLD'),
(3547, 14, 209, 'Dutton Park', 'AU', 'QLD'),
(3548, 14, 209, 'Dysart', 'AU', 'QLD'),
(3549, 14, 209, 'Eagle Farm', 'AU', 'QLD'),
(3550, 14, 209, 'Eagleby', 'AU', 'QLD'),
(3551, 14, 209, 'Earlville', 'AU', 'QLD'),
(3552, 14, 209, 'East Brisbane', 'AU', 'QLD'),
(3553, 14, 209, 'East Innisfail', 'AU', 'QLD'),
(3554, 14, 209, 'East Ipswich', 'AU', 'QLD'),
(3555, 14, 209, 'East Mackay', 'AU', 'QLD'),
(3556, 14, 209, 'East Toowoomba', 'AU', 'QLD'),
(3557, 14, 209, 'Eastern Heights', 'AU', 'QLD'),
(3558, 14, 209, 'Eatons Hill', 'AU', 'QLD'),
(3559, 14, 209, 'Edens Landing', 'AU', 'QLD'),
(3560, 14, 209, 'Edge Hill', 'AU', 'QLD'),
(3561, 14, 209, 'Edmonton', 'AU', 'QLD'),
(3562, 14, 209, 'Eight Mile Plains', 'AU', 'QLD'),
(3563, 14, 209, 'Eimeo', 'AU', 'QLD'),
(3564, 14, 209, 'Elanora', 'AU', 'QLD'),
(3565, 14, 209, 'Eli Waters', 'AU', 'QLD'),
(3566, 14, 209, 'Elimbah', 'AU', 'QLD'),
(3567, 14, 209, 'Ellen Grove', 'AU', 'QLD'),
(3568, 14, 209, 'Elliott Heads', 'AU', 'QLD'),
(3569, 14, 209, 'Emerald', 'AU', 'QLD'),
(3570, 14, 209, 'Emu Park', 'AU', 'QLD'),
(3571, 14, 209, 'Enoggera', 'AU', 'QLD'),
(3572, 14, 209, 'Esk', 'AU', 'QLD'),
(3573, 14, 209, 'Etheridge', 'AU', 'QLD'),
(3574, 14, 209, 'Eudlo', 'AU', 'QLD'),
(3575, 14, 209, 'Eumundi', 'AU', 'QLD'),
(3576, 14, 209, 'Everton Hills', 'AU', 'QLD'),
(3577, 14, 209, 'Everton Park', 'AU', 'QLD'),
(3578, 14, 209, 'Fairfield', 'AU', 'QLD'),
(3579, 14, 209, 'Fernvale', 'AU', 'QLD'),
(3580, 14, 209, 'Ferny Grove', 'AU', 'QLD'),
(3581, 14, 209, 'Ferny Hills', 'AU', 'QLD'),
(3582, 14, 209, 'Fig Tree Pocket', 'AU', 'QLD'),
(3583, 14, 209, 'Fitzgibbon', 'AU', 'QLD'),
(3584, 14, 209, 'Flinders', 'AU', 'QLD'),
(3585, 14, 209, 'Flinders View', 'AU', 'QLD'),
(3586, 14, 209, 'Forest Glen', 'AU', 'QLD'),
(3587, 14, 209, 'Forest Lake', 'AU', 'QLD'),
(3588, 14, 209, 'Forestdale', 'AU', 'QLD'),
(3589, 14, 209, 'Fortitude Valley', 'AU', 'QLD'),
(3590, 14, 209, 'Fraser Coast', 'AU', 'QLD'),
(3591, 14, 209, 'Frenchville', 'AU', 'QLD'),
(3592, 14, 209, 'Freshwater', 'AU', 'QLD'),
(3593, 14, 209, 'Gailes', 'AU', 'QLD'),
(3594, 14, 209, 'Garbutt', 'AU', 'QLD'),
(3595, 14, 209, 'Gatton', 'AU', 'QLD'),
(3596, 14, 209, 'Gaven', 'AU', 'QLD'),
(3597, 14, 209, 'Gayndah', 'AU', 'QLD'),
(3598, 14, 209, 'Gaythorne', 'AU', 'QLD'),
(3599, 14, 209, 'Geebung', 'AU', 'QLD'),
(3600, 14, 209, 'Gilston', 'AU', 'QLD'),
(3601, 14, 209, 'Gin Gin', 'AU', 'QLD'),
(3602, 14, 209, 'Gladstone', 'AU', 'QLD'),
(3603, 14, 209, 'Gladstone Central', 'AU', 'QLD'),
(3604, 14, 209, 'Glass House Mountains', 'AU', 'QLD'),
(3605, 14, 209, 'Glen Eden', 'AU', 'QLD'),
(3606, 14, 209, 'Gleneagle', 'AU', 'QLD'),
(3607, 14, 209, 'Glenella', 'AU', 'QLD'),
(3608, 14, 209, 'Glenvale', 'AU', 'QLD'),
(3609, 14, 209, 'Glenview', 'AU', 'QLD'),
(3610, 14, 209, 'Gold Coast', 'AU', 'QLD'),
(3611, 14, 209, 'Golden Beach', 'AU', 'QLD'),
(3612, 14, 209, 'Gooburrum', 'AU', 'QLD'),
(3613, 14, 209, 'Goodna', 'AU', 'QLD'),
(3614, 14, 209, 'Goondiwindi', 'AU', 'QLD'),
(3615, 14, 209, 'Gordon Park', 'AU', 'QLD'),
(3616, 14, 209, 'Gordonvale', 'AU', 'QLD'),
(3617, 14, 209, 'Gowrie Junction', 'AU', 'QLD'),
(3618, 14, 209, 'Gracemere', 'AU', 'QLD'),
(3619, 14, 209, 'Graceville', 'AU', 'QLD'),
(3620, 14, 209, 'Grange', 'AU', 'QLD'),
(3621, 14, 209, 'Granville', 'AU', 'QLD'),
(3622, 14, 209, 'Greenbank', 'AU', 'QLD'),
(3623, 14, 209, 'Greenslopes', 'AU', 'QLD'),
(3624, 14, 209, 'Griffin', 'AU', 'QLD'),
(3625, 14, 209, 'Gulliver', 'AU', 'QLD'),
(3626, 14, 209, 'Gumdale', 'AU', 'QLD'),
(3627, 14, 209, 'Gympie', 'AU', 'QLD'),
(3628, 14, 209, 'Gympie Regional Council', 'AU', 'QLD'),
(3629, 14, 209, 'Hamilton', 'AU', 'QLD'),
(3630, 14, 209, 'Harlaxton', 'AU', 'QLD'),
(3631, 14, 209, 'Harristown', 'AU', 'QLD'),
(3632, 14, 209, 'Hatton Vale', 'AU', 'QLD'),
(3633, 14, 209, 'Hawthorne', 'AU', 'QLD'),
(3634, 14, 209, 'Hay Point', 'AU', 'QLD'),
(3635, 14, 209, 'Healy', 'AU', 'QLD'),
(3636, 14, 209, 'Heathwood', 'AU', 'QLD'),
(3637, 14, 209, 'Heatley', 'AU', 'QLD'),
(3638, 14, 209, 'Helensvale', 'AU', 'QLD'),
(3639, 14, 209, 'Helidon', 'AU', 'QLD'),
(3640, 14, 209, 'Hemmant', 'AU', 'QLD'),
(3641, 14, 209, 'Hendra', 'AU', 'QLD'),
(3642, 14, 209, 'Heritage Park', 'AU', 'QLD'),
(3643, 14, 209, 'Hermit Park', 'AU', 'QLD'),
(3644, 14, 209, 'Herston', 'AU', 'QLD'),
(3645, 14, 209, 'Hervey Bay', 'AU', 'QLD'),
(3646, 14, 209, 'Highfields', 'AU', 'QLD'),
(3647, 14, 209, 'Highgate Hill', 'AU', 'QLD'),
(3648, 14, 209, 'Highland Park', 'AU', 'QLD'),
(3649, 14, 209, 'Highvale', 'AU', 'QLD'),
(3650, 14, 209, 'Hillcrest', 'AU', 'QLD'),
(3651, 14, 209, 'Hinchinbrook', 'AU', 'QLD'),
(3652, 14, 209, 'Hodgson Vale', 'AU', 'QLD'),
(3653, 14, 209, 'Holland Park', 'AU', 'QLD'),
(3654, 14, 209, 'Holland Park West', 'AU', 'QLD'),
(3655, 14, 209, 'Holloways Beach', 'AU', 'QLD'),
(3656, 14, 209, 'Hollywell', 'AU', 'QLD'),
(3657, 14, 209, 'Holmview', 'AU', 'QLD'),
(3658, 14, 209, 'Home Hill', 'AU', 'QLD'),
(3659, 14, 209, 'Hope Island', 'AU', 'QLD'),
(3660, 14, 209, 'Hope Vale', 'AU', 'QLD'),
(3661, 14, 209, 'Howard', 'AU', 'QLD'),
(3662, 14, 209, 'Hughenden', 'AU', 'QLD'),
(3663, 14, 209, 'Hyde Park', 'AU', 'QLD'),
(3664, 14, 209, 'Idalia', 'AU', 'QLD'),
(3665, 14, 209, 'Inala', 'AU', 'QLD'),
(3666, 14, 209, 'Indooroopilly', 'AU', 'QLD'),
(3667, 14, 209, 'Ingham', 'AU', 'QLD'),
(3668, 14, 209, 'Innes Park', 'AU', 'QLD'),
(3669, 14, 209, 'Innisfail', 'AU', 'QLD'),
(3670, 14, 209, 'Innisfail Estate', 'AU', 'QLD'),
(3671, 14, 209, 'Ipswich', 'AU', 'QLD'),
(3672, 14, 209, 'Isaac', 'AU', 'QLD'),
(3673, 14, 209, 'Jacobs Well', 'AU', 'QLD'),
(3674, 14, 209, 'Jamboree Heights', 'AU', 'QLD'),
(3675, 14, 209, 'Jandowae', 'AU', 'QLD'),
(3676, 14, 209, 'Jensen', 'AU', 'QLD'),
(3677, 14, 209, 'Jimboomba', 'AU', 'QLD'),
(3678, 14, 209, 'Jindalee', 'AU', 'QLD'),
(3679, 14, 209, 'Joyner', 'AU', 'QLD'),
(3680, 14, 209, 'Jubilee Pocket', 'AU', 'QLD'),
(3681, 14, 209, 'Julatten', 'AU', 'QLD'),
(3682, 14, 209, 'Kalbar', 'AU', 'QLD'),
(3683, 14, 209, 'Kalinga', 'AU', 'QLD'),
(3684, 14, 209, 'Kalkie', 'AU', 'QLD'),
(3685, 14, 209, 'Kallangur', 'AU', 'QLD'),
(3686, 14, 209, 'Kamerunga', 'AU', 'QLD'),
(3687, 14, 209, 'Kangaroo Point', 'AU', 'QLD'),
(3688, 14, 209, 'Kanimbla', 'AU', 'QLD'),
(3689, 14, 209, 'Karalee', 'AU', 'QLD'),
(3690, 14, 209, 'Karana Downs', 'AU', 'QLD'),
(3691, 14, 209, 'Karumba', 'AU', 'QLD'),
(3692, 14, 209, 'Kawana', 'AU', 'QLD'),
(3693, 14, 209, 'Kawungan', 'AU', 'QLD'),
(3694, 14, 209, 'Kearneys Spring', 'AU', 'QLD'),
(3695, 14, 209, 'Kedron', 'AU', 'QLD'),
(3696, 14, 209, 'Kelso', 'AU', 'QLD'),
(3697, 14, 209, 'Kelvin Grove', 'AU', 'QLD'),
(3698, 14, 209, 'Kenmore', 'AU', 'QLD'),
(3699, 14, 209, 'Kenmore Hills', 'AU', 'QLD'),
(3700, 14, 209, 'Kensington Grove', 'AU', 'QLD'),
(3701, 14, 209, 'Keperra', 'AU', 'QLD'),
(3702, 14, 209, 'Kepnock', 'AU', 'QLD'),
(3703, 14, 209, 'Kewarra Beach', 'AU', 'QLD'),
(3704, 14, 209, 'Kilcoy', 'AU', 'QLD'),
(3705, 14, 209, 'Kin Kora', 'AU', 'QLD'),
(3706, 14, 209, 'Kingaroy', 'AU', 'QLD'),
(3707, 14, 209, 'Kings Beach', 'AU', 'QLD'),
(3708, 14, 209, 'Kingsthorpe', 'AU', 'QLD'),
(3709, 14, 209, 'Kingston', 'AU', 'QLD'),
(3710, 14, 209, 'Kippa-Ring', 'AU', 'QLD'),
(3711, 14, 209, 'Kirkwood', 'AU', 'QLD'),
(3712, 14, 209, 'Kirwan', 'AU', 'QLD'),
(3713, 14, 209, 'Kleinton', 'AU', 'QLD'),
(3714, 14, 209, 'Koongal', 'AU', 'QLD'),
(3715, 14, 209, 'Kooralbyn', 'AU', 'QLD'),
(3716, 14, 209, 'Kowanyama', 'AU', 'QLD'),
(3717, 14, 209, 'Kuluin', 'AU', 'QLD'),
(3718, 14, 209, 'Kuraby', 'AU', 'QLD'),
(3719, 14, 209, 'Kuranda', 'AU', 'QLD'),
(3720, 14, 209, 'Kurwongbah', 'AU', 'QLD'),
(3721, 14, 209, 'Labrador', 'AU', 'QLD'),
(3722, 14, 209, 'Laidley', 'AU', 'QLD'),
(3723, 14, 209, 'Lake Macdonald', 'AU', 'QLD'),
(3724, 14, 209, 'Lammermoor', 'AU', 'QLD'),
(3725, 14, 209, 'Landsborough', 'AU', 'QLD'),
(3726, 14, 209, 'Lawnton', 'AU', 'QLD'),
(3727, 14, 209, 'Leichhardt', 'AU', 'QLD'),
(3728, 14, 209, 'Little Mountain', 'AU', 'QLD'),
(3729, 14, 209, 'Lockhart River', 'AU', 'QLD'),
(3730, 14, 209, 'Lockyer Valley', 'AU', 'QLD'),
(3731, 14, 209, 'Logan', 'AU', 'QLD'),
(3732, 14, 209, 'Logan Central', 'AU', 'QLD'),
(3733, 14, 209, 'Logan City', 'AU', 'QLD'),
(3734, 14, 209, 'Logan Reserve', 'AU', 'QLD'),
(3735, 14, 209, 'Logan Village', 'AU', 'QLD'),
(3736, 14, 209, 'Loganholme', 'AU', 'QLD'),
(3737, 14, 209, 'Loganlea', 'AU', 'QLD'),
(3738, 14, 209, 'Longreach', 'AU', 'QLD'),
(3739, 14, 209, 'Lota', 'AU', 'QLD'),
(3740, 14, 209, 'Lower Beechmont', 'AU', 'QLD'),
(3741, 14, 209, 'Lowood', 'AU', 'QLD'),
(3742, 14, 209, 'Lutwyche', 'AU', 'QLD'),
(3743, 14, 209, 'Macgregor', 'AU', 'QLD'),
(3744, 14, 209, 'Machans Beach', 'AU', 'QLD'),
(3745, 14, 209, 'Mackay', 'AU', 'QLD'),
(3746, 14, 209, 'Mackay City', 'AU', 'QLD'),
(3747, 14, 209, 'Mackenzie', 'AU', 'QLD'),
(3748, 14, 209, 'Macleay Island', 'AU', 'QLD'),
(3749, 14, 209, 'Magnetic Island', 'AU', 'QLD'),
(3750, 14, 209, 'Main Beach', 'AU', 'QLD'),
(3751, 14, 209, 'Malanda', 'AU', 'QLD'),
(3752, 14, 209, 'Maleny', 'AU', 'QLD'),
(3753, 14, 209, 'Mango Hill', 'AU', 'QLD'),
(3754, 14, 209, 'Manly West', 'AU', 'QLD'),
(3755, 14, 209, 'Manoora', 'AU', 'QLD'),
(3756, 14, 209, 'Mansfield', 'AU', 'QLD'),
(3757, 14, 209, 'Manunda', 'AU', 'QLD'),
(3758, 14, 209, 'Mapleton', 'AU', 'QLD'),
(3759, 14, 209, 'Mapoon', 'AU', 'QLD'),
(3760, 14, 209, 'Maranoa', 'AU', 'QLD'),
(3761, 14, 209, 'Marcoola', 'AU', 'QLD'),
(3762, 14, 209, 'Mareeba', 'AU', 'QLD'),
(3763, 14, 209, 'Margate', 'AU', 'QLD'),
(3764, 14, 209, 'Marian', 'AU', 'QLD'),
(3765, 14, 209, 'Maroochy River', 'AU', 'QLD'),
(3766, 14, 209, 'Maroochydore', 'AU', 'QLD'),
(3767, 14, 209, 'Marsden', 'AU', 'QLD'),
(3768, 14, 209, 'Maryborough', 'AU', 'QLD'),
(3769, 14, 209, 'Maudsland', 'AU', 'QLD'),
(3770, 14, 209, 'McDowall', 'AU', 'QLD'),
(3771, 14, 209, 'McKinlay', 'AU', 'QLD'),
(3772, 14, 209, 'Meadowbrook', 'AU', 'QLD'),
(3773, 14, 209, 'Menzies', 'AU', 'QLD'),
(3774, 14, 209, 'Meridan Plains', 'AU', 'QLD'),
(3775, 14, 209, 'Meringandan West', 'AU', 'QLD'),
(3776, 14, 209, 'Mermaid Beach', 'AU', 'QLD'),
(3777, 14, 209, 'Mermaid Waters', 'AU', 'QLD'),
(3778, 14, 209, 'Merrimac', 'AU', 'QLD'),
(3779, 14, 209, 'Miami', 'AU', 'QLD'),
(3780, 14, 209, 'Middle Park', 'AU', 'QLD'),
(3781, 14, 209, 'Middle Ridge', 'AU', 'QLD'),
(3782, 14, 209, 'Middlemount', 'AU', 'QLD'),
(3783, 14, 209, 'Miles', 'AU', 'QLD'),
(3784, 14, 209, 'Millbank', 'AU', 'QLD'),
(3785, 14, 209, 'Millmerran', 'AU', 'QLD'),
(3786, 14, 209, 'Millstream', 'AU', 'QLD'),
(3787, 14, 209, 'Milton', 'AU', 'QLD'),
(3788, 14, 209, 'Minden', 'AU', 'QLD'),
(3789, 14, 209, 'Minyama', 'AU', 'QLD'),
(3790, 14, 209, 'Mirani', 'AU', 'QLD'),
(3791, 14, 209, 'Mission Beach', 'AU', 'QLD'),
(3792, 14, 209, 'Mission River', 'AU', 'QLD'),
(3793, 14, 209, 'Mitchell', 'AU', 'QLD'),
(3794, 14, 209, 'Mitchelton', 'AU', 'QLD'),
(3795, 14, 209, 'Moffat Beach', 'AU', 'QLD'),
(3796, 14, 209, 'Moggill', 'AU', 'QLD'),
(3797, 14, 209, 'Molendinar', 'AU', 'QLD'),
(3798, 14, 209, 'Monkland', 'AU', 'QLD'),
(3799, 14, 209, 'Monto', 'AU', 'QLD'),
(3800, 14, 209, 'Montville', 'AU', 'QLD'),
(3801, 14, 209, 'Mooloolaba', 'AU', 'QLD'),
(3802, 14, 209, 'Moore Park Beach', 'AU', 'QLD'),
(3803, 14, 209, 'Mooroobool', 'AU', 'QLD'),
(3804, 14, 209, 'Moorooka', 'AU', 'QLD'),
(3805, 14, 209, 'Moranbah', 'AU', 'QLD'),
(3806, 14, 209, 'Morayfield', 'AU', 'QLD'),
(3807, 14, 209, 'Moreton Bay', 'AU', 'QLD'),
(3808, 14, 209, 'Morningside', 'AU', 'QLD'),
(3809, 14, 209, 'Mornington', 'AU', 'QLD'),
(3810, 14, 209, 'Mossman', 'AU', 'QLD'),
(3811, 14, 209, 'Mount Coolum', 'AU', 'QLD'),
(3812, 14, 209, 'Mount Cotton', 'AU', 'QLD'),
(3813, 14, 209, 'Mount Crosby', 'AU', 'QLD'),
(3814, 14, 209, 'Mount Gravatt', 'AU', 'QLD'),
(3815, 14, 209, 'Mount Gravatt East', 'AU', 'QLD'),
(3816, 14, 209, 'Mount Isa', 'AU', 'QLD'),
(3817, 14, 209, 'Mount Lofty', 'AU', 'QLD'),
(3818, 14, 209, 'Mount Louisa', 'AU', 'QLD'),
(3819, 14, 209, 'Mount Low', 'AU', 'QLD'),
(3820, 14, 209, 'Mount Morgan', 'AU', 'QLD'),
(3821, 14, 209, 'Mount Nathan', 'AU', 'QLD'),
(3822, 14, 209, 'Mount Ommaney', 'AU', 'QLD'),
(3823, 14, 209, 'Mount Pleasant', 'AU', 'QLD'),
(3824, 14, 209, 'Mount Sheridan', 'AU', 'QLD'),
(3825, 14, 209, 'Mount Warren Park', 'AU', 'QLD'),
(3826, 14, 209, 'Mountain Creek', 'AU', 'QLD'),
(3827, 14, 209, 'Moura', 'AU', 'QLD'),
(3828, 14, 209, 'Mudgeeraba', 'AU', 'QLD'),
(3829, 14, 209, 'Mudjimba', 'AU', 'QLD'),
(3830, 14, 209, 'Mulambin', 'AU', 'QLD'),
(3831, 14, 209, 'Mundingburra', 'AU', 'QLD'),
(3832, 14, 209, 'Mundoolun', 'AU', 'QLD'),
(3833, 14, 209, 'Mundubbera', 'AU', 'QLD'),
(3834, 14, 209, 'Munruben', 'AU', 'QLD'),
(3835, 14, 209, 'Murarrie', 'AU', 'QLD'),
(3836, 14, 209, 'Murgon', 'AU', 'QLD'),
(3837, 14, 209, 'Murray', 'AU', 'QLD'),
(3838, 14, 209, 'Murrumba Downs', 'AU', 'QLD'),
(3839, 14, 209, 'Murweh', 'AU', 'QLD'),
(3840, 14, 209, 'Nambour', 'AU', 'QLD'),
(3841, 14, 209, 'Nanango', 'AU', 'QLD'),
(3842, 14, 209, 'Nanum', 'AU', 'QLD'),
(3843, 14, 209, 'Napranum', 'AU', 'QLD'),
(3844, 14, 209, 'Narangba', 'AU', 'QLD'),
(3845, 14, 209, 'Nathan', 'AU', 'QLD'),
(3846, 14, 209, 'Nebo', 'AU', 'QLD'),
(3847, 14, 209, 'Nelly Bay', 'AU', 'QLD'),
(3848, 14, 209, 'Nerang', 'AU', 'QLD'),
(3849, 14, 209, 'New Auckland', 'AU', 'QLD'),
(3850, 14, 209, 'New Beith', 'AU', 'QLD'),
(3851, 14, 209, 'New Farm', 'AU', 'QLD'),
(3852, 14, 209, 'Newmarket', 'AU', 'QLD'),
(3853, 14, 209, 'Newport', 'AU', 'QLD'),
(3854, 14, 209, 'Newstead', 'AU', 'QLD'),
(3855, 14, 209, 'Newtown', 'AU', 'QLD'),
(3856, 14, 209, 'Ninderry', 'AU', 'QLD'),
(3857, 14, 209, 'Ningi', 'AU', 'QLD'),
(3858, 14, 209, 'Nome', 'AU', 'QLD'),
(3859, 14, 209, 'Noosa Heads', 'AU', 'QLD'),
(3860, 14, 209, 'Noosaville', 'AU', 'QLD'),
(3861, 14, 209, 'Norman Gardens', 'AU', 'QLD'),
(3862, 14, 209, 'Norman Park', 'AU', 'QLD'),
(3863, 14, 209, 'Normanton', 'AU', 'QLD'),
(3864, 14, 209, 'North Booval', 'AU', 'QLD'),
(3865, 14, 209, 'North Burnett', 'AU', 'QLD'),
(3866, 14, 209, 'North Ipswich', 'AU', 'QLD'),
(3867, 14, 209, 'North Lakes', 'AU', 'QLD'),
(3868, 14, 209, 'North Mackay', 'AU', 'QLD'),
(3869, 14, 209, 'North Maclean', 'AU', 'QLD'),
(3870, 14, 209, 'North Toowoomba', 'AU', 'QLD'),
(3871, 14, 209, 'North Ward', 'AU', 'QLD'),
(3872, 14, 209, 'Northern Peninsula Area', 'AU', 'QLD'),
(3873, 14, 209, 'Norville', 'AU', 'QLD'),
(3874, 14, 209, 'Nudgee', 'AU', 'QLD'),
(3875, 14, 209, 'Nundah', 'AU', 'QLD'),
(3876, 14, 209, 'Oakey', 'AU', 'QLD'),
(3877, 14, 209, 'Oakhurst', 'AU', 'QLD'),
(3878, 14, 209, 'One Mile', 'AU', 'QLD'),
(3879, 14, 209, 'Oonoonba', 'AU', 'QLD'),
(3880, 14, 209, 'Ooralea', 'AU', 'QLD'),
(3881, 14, 209, 'Ormeau', 'AU', 'QLD'),
(3882, 14, 209, 'Ormeau Hills', 'AU', 'QLD'),
(3883, 14, 209, 'Ormiston', 'AU', 'QLD'),
(3884, 14, 209, 'Oxenford', 'AU', 'QLD'),
(3885, 14, 209, 'Oxley', 'AU', 'QLD'),
(3886, 14, 209, 'Pacific Paradise', 'AU', 'QLD'),
(3887, 14, 209, 'Pacific Pines', 'AU', 'QLD'),
(3888, 14, 209, 'Paddington', 'AU', 'QLD'),
(3889, 14, 209, 'Palm Beach', 'AU', 'QLD'),
(3890, 14, 209, 'Palm Cove', 'AU', 'QLD'),
(3891, 14, 209, 'Palm Island', 'AU', 'QLD'),
(3892, 14, 209, 'Palmwoods', 'AU', 'QLD'),
(3893, 14, 209, 'Paradise Point', 'AU', 'QLD'),
(3894, 14, 209, 'Park Avenue', 'AU', 'QLD'),
(3895, 14, 209, 'Park Ridge', 'AU', 'QLD'),
(3896, 14, 209, 'Park Ridge South', 'AU', 'QLD'),
(3897, 14, 209, 'Parkhurst', 'AU', 'QLD'),
(3898, 14, 209, 'Parkinson', 'AU', 'QLD'),
(3899, 14, 209, 'Parkside', 'AU', 'QLD'),
(3900, 14, 209, 'Parkwood', 'AU', 'QLD'),
(3901, 14, 209, 'Paroo', 'AU', 'QLD'),
(3902, 14, 209, 'Parramatta Park', 'AU', 'QLD'),
(3903, 14, 209, 'Parrearra', 'AU', 'QLD'),
(3904, 14, 209, 'Peachester', 'AU', 'QLD'),
(3905, 14, 209, 'Pelican Waters', 'AU', 'QLD'),
(3906, 14, 209, 'Peregian Beach', 'AU', 'QLD'),
(3907, 14, 209, 'Peregian Springs', 'AU', 'QLD'),
(3908, 14, 209, 'Petrie', 'AU', 'QLD'),
(3909, 14, 209, 'Petrie Terrace', 'AU', 'QLD'),
(3910, 14, 209, 'Pialba', 'AU', 'QLD'),
(3911, 14, 209, 'Pie Creek', 'AU', 'QLD'),
(3912, 14, 209, 'Pimlico', 'AU', 'QLD'),
(3913, 14, 209, 'Pimpama', 'AU', 'QLD'),
(3914, 14, 209, 'Pine Mountain', 'AU', 'QLD'),
(3915, 14, 209, 'Pioneer', 'AU', 'QLD'),
(3916, 14, 209, 'Pittsworth', 'AU', 'QLD'),
(3917, 14, 209, 'Plainland', 'AU', 'QLD'),
(3918, 14, 209, 'Point Vernon', 'AU', 'QLD'),
(3919, 14, 209, 'Pomona', 'AU', 'QLD'),
(3920, 14, 209, 'Pormpuraaw', 'AU', 'QLD'),
(3921, 14, 209, 'Port Douglas', 'AU', 'QLD'),
(3922, 14, 209, 'Proserpine', 'AU', 'QLD'),
(3923, 14, 209, 'Pullenvale', 'AU', 'QLD'),
(3924, 14, 209, 'Queenton', 'AU', 'QLD'),
(3925, 14, 209, 'Quilpie', 'AU', 'QLD'),
(3926, 14, 209, 'Raceview', 'AU', 'QLD'),
(3927, 14, 209, 'Railway Estate', 'AU', 'QLD'),
(3928, 14, 209, 'Rainbow Beach', 'AU', 'QLD'),
(3929, 14, 209, 'Rangeville', 'AU', 'QLD'),
(3930, 14, 209, 'Rangewood', 'AU', 'QLD'),
(3931, 14, 209, 'Rasmussen', 'AU', 'QLD'),
(3932, 14, 209, 'Ravenshoe', 'AU', 'QLD'),
(3933, 14, 209, 'Red Hill', 'AU', 'QLD'),
(3934, 14, 209, 'Redbank', 'AU', 'QLD'),
(3935, 14, 209, 'Redbank Plains', 'AU', 'QLD'),
(3936, 14, 209, 'Redland', 'AU', 'QLD'),
(3937, 14, 209, 'Redland Bay', 'AU', 'QLD'),
(3938, 14, 209, 'Redlynch', 'AU', 'QLD'),
(3939, 14, 209, 'Reedy Creek', 'AU', 'QLD'),
(3940, 14, 209, 'Regency Downs', 'AU', 'QLD'),
(3941, 14, 209, 'Regents Park', 'AU', 'QLD'),
(3942, 14, 209, 'Richlands', 'AU', 'QLD'),
(3943, 14, 209, 'Richmond', 'AU', 'QLD'),
(3944, 14, 209, 'River Heads', 'AU', 'QLD'),
(3945, 14, 209, 'Riverhills', 'AU', 'QLD'),
(3946, 14, 209, 'Riverview', 'AU', 'QLD'),
(3947, 14, 209, 'Robertson', 'AU', 'QLD'),
(3948, 14, 209, 'Robina', 'AU', 'QLD'),
(3949, 14, 209, 'Rochedale', 'AU', 'QLD'),
(3950, 14, 209, 'Rochedale South', 'AU', 'QLD'),
(3951, 14, 209, 'Rockhampton', 'AU', 'QLD'),
(3952, 14, 209, 'Rocklea', 'AU', 'QLD'),
(3953, 14, 209, 'Rockville', 'AU', 'QLD'),
(3954, 14, 209, 'Roma', 'AU', 'QLD'),
(3955, 14, 209, 'Rosemount', 'AU', 'QLD'),
(3956, 14, 209, 'Rosenthal Heights', 'AU', 'QLD'),
(3957, 14, 209, 'Rosewood', 'AU', 'QLD'),
(3958, 14, 209, 'Rosslea', 'AU', 'QLD'),
(3959, 14, 209, 'Rothwell', 'AU', 'QLD'),
(3960, 14, 209, 'Runaway Bay', 'AU', 'QLD'),
(3961, 14, 209, 'Runcorn', 'AU', 'QLD'),
(3962, 14, 209, 'Rural View', 'AU', 'QLD'),
(3963, 14, 209, 'Russell Island', 'AU', 'QLD'),
(3964, 14, 209, 'Sadliers Crossing', 'AU', 'QLD'),
(3965, 14, 209, 'Salisbury', 'AU', 'QLD'),
(3966, 14, 209, 'Samford Valley', 'AU', 'QLD'),
(3967, 14, 209, 'Sandgate', 'AU', 'QLD'),
(3968, 14, 209, 'Sandstone Point', 'AU', 'QLD'),
(3969, 14, 209, 'Sarina', 'AU', 'QLD'),
(3970, 14, 209, 'Scarborough', 'AU', 'QLD'),
(3971, 14, 209, 'Scarness', 'AU', 'QLD'),
(3972, 14, 209, 'Scenic Rim', 'AU', 'QLD'),
(3973, 14, 209, 'Seven Hills', 'AU', 'QLD'),
(3974, 14, 209, 'Seventeen Mile Rocks', 'AU', 'QLD'),
(3975, 14, 209, 'Shailer Park', 'AU', 'QLD'),
(3976, 14, 209, 'Sharon', 'AU', 'QLD'),
(3977, 14, 209, 'Sheldon', 'AU', 'QLD'),
(3978, 14, 209, 'Shorncliffe', 'AU', 'QLD'),
(3979, 14, 209, 'Silkstone', 'AU', 'QLD'),
(3980, 14, 209, 'Sinnamon Park', 'AU', 'QLD'),
(3981, 14, 209, 'Sippy Downs', 'AU', 'QLD'),
(3982, 14, 209, 'Slacks Creek', 'AU', 'QLD'),
(3983, 14, 209, 'Slade Point', 'AU', 'QLD'),
(3984, 14, 209, 'Soldiers Hill', 'AU', 'QLD'),
(3985, 14, 209, 'Somerset', 'AU', 'QLD'),
(3986, 14, 209, 'South Brisbane', 'AU', 'QLD'),
(3987, 14, 209, 'South Burnett', 'AU', 'QLD'),
(3988, 14, 209, 'South Gladstone', 'AU', 'QLD'),
(3989, 14, 209, 'South Kolan', 'AU', 'QLD'),
(3990, 14, 209, 'South Mackay', 'AU', 'QLD'),
(3991, 14, 209, 'South Maclean', 'AU', 'QLD'),
(3992, 14, 209, 'South Toowoomba', 'AU', 'QLD'),
(3993, 14, 209, 'South Townsville', 'AU', 'QLD'),
(3994, 14, 209, 'Southern Downs', 'AU', 'QLD'),
(3995, 14, 209, 'Southport', 'AU', 'QLD'),
(3996, 14, 209, 'Southside', 'AU', 'QLD'),
(3997, 14, 209, 'Spring Hill', 'AU', 'QLD'),
(3998, 14, 209, 'Springfield', 'AU', 'QLD'),
(3999, 14, 209, 'Springfield Lakes', 'AU', 'QLD'),
(4000, 14, 209, 'Springsure', 'AU', 'QLD');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(4001, 14, 209, 'Springwood', 'AU', 'QLD'),
(4002, 14, 209, 'St George', 'AU', 'QLD'),
(4003, 14, 209, 'Stafford', 'AU', 'QLD'),
(4004, 14, 209, 'Stafford Heights', 'AU', 'QLD'),
(4005, 14, 209, 'Stanthorpe', 'AU', 'QLD'),
(4006, 14, 209, 'Strathpine', 'AU', 'QLD'),
(4007, 14, 209, 'Stretton', 'AU', 'QLD'),
(4008, 14, 209, 'Stuart', 'AU', 'QLD'),
(4009, 14, 209, 'Sun Valley', 'AU', 'QLD'),
(4010, 14, 209, 'Sunnybank', 'AU', 'QLD'),
(4011, 14, 209, 'Sunnybank Hills', 'AU', 'QLD'),
(4012, 14, 209, 'Sunrise Beach', 'AU', 'QLD'),
(4013, 14, 209, 'Sunset', 'AU', 'QLD'),
(4014, 14, 209, 'Sunshine Beach', 'AU', 'QLD'),
(4015, 14, 209, 'Sunshine Coast', 'AU', 'QLD'),
(4016, 14, 209, 'Surfers Paradise', 'AU', 'QLD'),
(4017, 14, 209, 'Svensson Heights', 'AU', 'QLD'),
(4018, 14, 209, 'Taigum', 'AU', 'QLD'),
(4019, 14, 209, 'Tallai', 'AU', 'QLD'),
(4020, 14, 209, 'Tallebudgera', 'AU', 'QLD'),
(4021, 14, 209, 'Tallebudgera Valley', 'AU', 'QLD'),
(4022, 14, 209, 'Tamborine', 'AU', 'QLD'),
(4023, 14, 209, 'Tamborine Mountain', 'AU', 'QLD'),
(4024, 14, 209, 'Tanah Merah', 'AU', 'QLD'),
(4025, 14, 209, 'Tanawha', 'AU', 'QLD'),
(4026, 14, 209, 'Tannum Sands', 'AU', 'QLD'),
(4027, 14, 209, 'Tara', 'AU', 'QLD'),
(4028, 14, 209, 'Taranganba', 'AU', 'QLD'),
(4029, 14, 209, 'Taringa', 'AU', 'QLD'),
(4030, 14, 209, 'Tarragindi', 'AU', 'QLD'),
(4031, 14, 209, 'Telina', 'AU', 'QLD'),
(4032, 14, 209, 'Teneriffe', 'AU', 'QLD'),
(4033, 14, 209, 'Tewantin', 'AU', 'QLD'),
(4034, 14, 209, 'Thabeban', 'AU', 'QLD'),
(4035, 14, 209, 'The Gap', 'AU', 'QLD'),
(4036, 14, 209, 'The Gemfields', 'AU', 'QLD'),
(4037, 14, 209, 'The Range', 'AU', 'QLD'),
(4038, 14, 209, 'Thorneside', 'AU', 'QLD'),
(4039, 14, 209, 'Thornlands', 'AU', 'QLD'),
(4040, 14, 209, 'Thursday Island', 'AU', 'QLD'),
(4041, 14, 209, 'Tieri', 'AU', 'QLD'),
(4042, 14, 209, 'Tin Can Bay', 'AU', 'QLD'),
(4043, 14, 209, 'Tinana', 'AU', 'QLD'),
(4044, 14, 209, 'Tingalpa', 'AU', 'QLD'),
(4045, 14, 209, 'Tivoli', 'AU', 'QLD'),
(4046, 14, 209, 'Tolga', 'AU', 'QLD'),
(4047, 14, 209, 'Toogoolawah', 'AU', 'QLD'),
(4048, 14, 209, 'Toogoom', 'AU', 'QLD'),
(4049, 14, 209, 'Toowong', 'AU', 'QLD'),
(4050, 14, 209, 'Toowoomba', 'AU', 'QLD'),
(4051, 14, 209, 'Torquay', 'AU', 'QLD'),
(4052, 14, 209, 'Torres', 'AU', 'QLD'),
(4053, 14, 209, 'Torres Strait Island Region', 'AU', 'QLD'),
(4054, 14, 209, 'Townsville', 'AU', 'QLD'),
(4055, 14, 209, 'Townview', 'AU', 'QLD'),
(4056, 14, 209, 'Trinity Beach', 'AU', 'QLD'),
(4057, 14, 209, 'Trinity Park', 'AU', 'QLD'),
(4058, 14, 209, 'Trunding', 'AU', 'QLD'),
(4059, 14, 209, 'Tugun', 'AU', 'QLD'),
(4060, 14, 209, 'Tully', 'AU', 'QLD'),
(4061, 14, 209, 'Twin Waters', 'AU', 'QLD'),
(4062, 14, 209, 'Underwood', 'AU', 'QLD'),
(4063, 14, 209, 'Upper Caboolture', 'AU', 'QLD'),
(4064, 14, 209, 'Upper Coomera', 'AU', 'QLD'),
(4065, 14, 209, 'Upper Kedron', 'AU', 'QLD'),
(4066, 14, 209, 'Upper Mount Gravatt', 'AU', 'QLD'),
(4067, 14, 209, 'Urangan', 'AU', 'QLD'),
(4068, 14, 209, 'Urraween', 'AU', 'QLD'),
(4069, 14, 209, 'Varsity Lakes', 'AU', 'QLD'),
(4070, 14, 209, 'Victoria Point', 'AU', 'QLD'),
(4071, 14, 209, 'Vincent', 'AU', 'QLD'),
(4072, 14, 209, 'Virginia', 'AU', 'QLD'),
(4073, 14, 209, 'Wacol', 'AU', 'QLD'),
(4074, 14, 209, 'Wakerley', 'AU', 'QLD'),
(4075, 14, 209, 'Walkerston', 'AU', 'QLD'),
(4076, 14, 209, 'Walkervale', 'AU', 'QLD'),
(4077, 14, 209, 'Walloon', 'AU', 'QLD'),
(4078, 14, 209, 'Wamuran', 'AU', 'QLD'),
(4079, 14, 209, 'Wandal', 'AU', 'QLD'),
(4080, 14, 209, 'Wandoan', 'AU', 'QLD'),
(4081, 14, 209, 'Warana', 'AU', 'QLD'),
(4082, 14, 209, 'Warner', 'AU', 'QLD'),
(4083, 14, 209, 'Warwick', 'AU', 'QLD'),
(4084, 14, 209, 'Waterford West', 'AU', 'QLD'),
(4085, 14, 209, 'Wavell Heights', 'AU', 'QLD'),
(4086, 14, 209, 'Weipa', 'AU', 'QLD'),
(4087, 14, 209, 'Wellesley Islands', 'AU', 'QLD'),
(4088, 14, 209, 'Wellington Point', 'AU', 'QLD'),
(4089, 14, 209, 'West End', 'AU', 'QLD'),
(4090, 14, 209, 'West Gladstone', 'AU', 'QLD'),
(4091, 14, 209, 'West Mackay', 'AU', 'QLD'),
(4092, 14, 209, 'West Rockhampton', 'AU', 'QLD'),
(4093, 14, 209, 'West Woombye', 'AU', 'QLD'),
(4094, 14, 209, 'Westbrook', 'AU', 'QLD'),
(4095, 14, 209, 'Westcourt', 'AU', 'QLD'),
(4096, 14, 209, 'Western Downs', 'AU', 'QLD'),
(4097, 14, 209, 'Westlake', 'AU', 'QLD'),
(4098, 14, 209, 'White Rock', 'AU', 'QLD'),
(4099, 14, 209, 'Whitfield', 'AU', 'QLD'),
(4100, 14, 209, 'Whitsunday', 'AU', 'QLD'),
(4101, 14, 209, 'Whitsundays', 'AU', 'QLD'),
(4102, 14, 209, 'Willow Vale', 'AU', 'QLD'),
(4103, 14, 209, 'Willowbank', 'AU', 'QLD'),
(4104, 14, 209, 'Wilsonton', 'AU', 'QLD'),
(4105, 14, 209, 'Wilsonton Heights', 'AU', 'QLD'),
(4106, 14, 209, 'Wilston', 'AU', 'QLD'),
(4107, 14, 209, 'Windaroo', 'AU', 'QLD'),
(4108, 14, 209, 'Windsor', 'AU', 'QLD'),
(4109, 14, 209, 'Winston', 'AU', 'QLD'),
(4110, 14, 209, 'Winton', 'AU', 'QLD'),
(4111, 14, 209, 'Wishart', 'AU', 'QLD'),
(4112, 14, 209, 'Withcott', 'AU', 'QLD'),
(4113, 14, 209, 'Witta', 'AU', 'QLD'),
(4114, 14, 209, 'Wondai', 'AU', 'QLD'),
(4115, 14, 209, 'Wondunna', 'AU', 'QLD'),
(4116, 14, 209, 'Wongaling Beach', 'AU', 'QLD'),
(4117, 14, 209, 'Wongawallan', 'AU', 'QLD'),
(4118, 14, 209, 'Woodend', 'AU', 'QLD'),
(4119, 14, 209, 'Woodford', 'AU', 'QLD'),
(4120, 14, 209, 'Woodgate', 'AU', 'QLD'),
(4121, 14, 209, 'Woodridge', 'AU', 'QLD'),
(4122, 14, 209, 'Woody Point', 'AU', 'QLD'),
(4123, 14, 209, 'Woolloongabba', 'AU', 'QLD'),
(4124, 14, 209, 'Wooloowin', 'AU', 'QLD'),
(4125, 14, 209, 'Woombye', 'AU', 'QLD'),
(4126, 14, 209, 'Woorabinda', 'AU', 'QLD'),
(4127, 14, 209, 'Woorim', 'AU', 'QLD'),
(4128, 14, 209, 'Woree', 'AU', 'QLD'),
(4129, 14, 209, 'Worongary', 'AU', 'QLD'),
(4130, 14, 209, 'Wujal Wujal', 'AU', 'QLD'),
(4131, 14, 209, 'Wulguru', 'AU', 'QLD'),
(4132, 14, 209, 'Wulkuraka', 'AU', 'QLD'),
(4133, 14, 209, 'Wurtulla', 'AU', 'QLD'),
(4134, 14, 209, 'Wynnum', 'AU', 'QLD'),
(4135, 14, 209, 'Wynnum West', 'AU', 'QLD'),
(4136, 14, 209, 'Wyreema', 'AU', 'QLD'),
(4137, 14, 209, 'Yamanto', 'AU', 'QLD'),
(4138, 14, 209, 'Yandina', 'AU', 'QLD'),
(4139, 14, 209, 'Yaroomba', 'AU', 'QLD'),
(4140, 14, 209, 'Yarrabah', 'AU', 'QLD'),
(4141, 14, 209, 'Yarrabilba', 'AU', 'QLD'),
(4142, 14, 209, 'Yarraman', 'AU', 'QLD'),
(4143, 14, 209, 'Yatala', 'AU', 'QLD'),
(4144, 14, 209, 'Yeerongpilly', 'AU', 'QLD'),
(4145, 14, 209, 'Yeppoon', 'AU', 'QLD'),
(4146, 14, 209, 'Yeppoon city centre', 'AU', 'QLD'),
(4147, 14, 209, 'Yeronga', 'AU', 'QLD'),
(4148, 14, 209, 'Yorkeys Knob', 'AU', 'QLD'),
(4149, 14, 209, 'Yungaburra', 'AU', 'QLD'),
(4150, 14, 209, 'Zillmere', 'AU', 'QLD'),
(4151, 14, 209, 'Zilzie', 'AU', 'QLD'),
(4152, 14, 210, 'Aberfoyle Park', 'AU', 'SA'),
(4153, 14, 210, 'Adelaide', 'AU', 'SA'),
(4154, 14, 210, 'Adelaide city centre', 'AU', 'SA'),
(4155, 14, 210, 'Adelaide Hills', 'AU', 'SA'),
(4156, 14, 210, 'Albert Park', 'AU', 'SA'),
(4157, 14, 210, 'Alberton', 'AU', 'SA'),
(4158, 14, 210, 'Aldgate', 'AU', 'SA'),
(4159, 14, 210, 'Aldinga Beach', 'AU', 'SA'),
(4160, 14, 210, 'Alexandrina', 'AU', 'SA'),
(4161, 14, 210, 'Allenby Gardens', 'AU', 'SA'),
(4162, 14, 210, 'Anangu Pitjantjatjara', 'AU', 'SA'),
(4163, 14, 210, 'Andrews Farm', 'AU', 'SA'),
(4164, 14, 210, 'Angaston', 'AU', 'SA'),
(4165, 14, 210, 'Angle Park', 'AU', 'SA'),
(4166, 14, 210, 'Angle Vale', 'AU', 'SA'),
(4167, 14, 210, 'Ardrossan', 'AU', 'SA'),
(4168, 14, 210, 'Ascot Park', 'AU', 'SA'),
(4169, 14, 210, 'Ashford', 'AU', 'SA'),
(4170, 14, 210, 'Athelstone', 'AU', 'SA'),
(4171, 14, 210, 'Athol Park', 'AU', 'SA'),
(4172, 14, 210, 'Balaklava', 'AU', 'SA'),
(4173, 14, 210, 'Balhannah', 'AU', 'SA'),
(4174, 14, 210, 'Banksia Park', 'AU', 'SA'),
(4175, 14, 210, 'Barmera', 'AU', 'SA'),
(4176, 14, 210, 'Barossa', 'AU', 'SA'),
(4177, 14, 210, 'Barunga West', 'AU', 'SA'),
(4178, 14, 210, 'Beaumont', 'AU', 'SA'),
(4179, 14, 210, 'Bedford Park', 'AU', 'SA'),
(4180, 14, 210, 'Belair', 'AU', 'SA'),
(4181, 14, 210, 'Bellevue Heights', 'AU', 'SA'),
(4182, 14, 210, 'Berri', 'AU', 'SA'),
(4183, 14, 210, 'Berri and Barmera', 'AU', 'SA'),
(4184, 14, 210, 'Beulah Park', 'AU', 'SA'),
(4185, 14, 210, 'Beverley', 'AU', 'SA'),
(4186, 14, 210, 'Birdwood', 'AU', 'SA'),
(4187, 14, 210, 'Birkenhead', 'AU', 'SA'),
(4188, 14, 210, 'Black Forest', 'AU', 'SA'),
(4189, 14, 210, 'Blackwood', 'AU', 'SA'),
(4190, 14, 210, 'Blair Athol', 'AU', 'SA'),
(4191, 14, 210, 'Blakeview', 'AU', 'SA'),
(4192, 14, 210, 'Bordertown', 'AU', 'SA'),
(4193, 14, 210, 'Brahma Lodge', 'AU', 'SA'),
(4194, 14, 210, 'Bridgewater', 'AU', 'SA'),
(4195, 14, 210, 'Brighton', 'AU', 'SA'),
(4196, 14, 210, 'Broadview', 'AU', 'SA'),
(4197, 14, 210, 'Brompton', 'AU', 'SA'),
(4198, 14, 210, 'Brooklyn Park', 'AU', 'SA'),
(4199, 14, 210, 'Burnside', 'AU', 'SA'),
(4200, 14, 210, 'Burra', 'AU', 'SA'),
(4201, 14, 210, 'Burton', 'AU', 'SA'),
(4202, 14, 210, 'Camden Park', 'AU', 'SA'),
(4203, 14, 210, 'Campbelltown', 'AU', 'SA'),
(4204, 14, 210, 'Ceduna', 'AU', 'SA'),
(4205, 14, 210, 'Charles Sturt', 'AU', 'SA'),
(4206, 14, 210, 'Cheltenham', 'AU', 'SA'),
(4207, 14, 210, 'Christie Downs', 'AU', 'SA'),
(4208, 14, 210, 'Christies Beach', 'AU', 'SA'),
(4209, 14, 210, 'City of West Torrens', 'AU', 'SA'),
(4210, 14, 210, 'Clapham', 'AU', 'SA'),
(4211, 14, 210, 'Clare', 'AU', 'SA'),
(4212, 14, 210, 'Clare and Gilbert Valleys', 'AU', 'SA'),
(4213, 14, 210, 'Clarence Gardens', 'AU', 'SA'),
(4214, 14, 210, 'Clarence Park', 'AU', 'SA'),
(4215, 14, 210, 'Clearview', 'AU', 'SA'),
(4216, 14, 210, 'Cleve', 'AU', 'SA'),
(4217, 14, 210, 'Clovelly Park', 'AU', 'SA'),
(4218, 14, 210, 'Collinswood', 'AU', 'SA'),
(4219, 14, 210, 'Colonel Light Gardens', 'AU', 'SA'),
(4220, 14, 210, 'Coober Pedy', 'AU', 'SA'),
(4221, 14, 210, 'Copper Coast', 'AU', 'SA'),
(4222, 14, 210, 'Coromandel Valley', 'AU', 'SA'),
(4223, 14, 210, 'Cowandilla', 'AU', 'SA'),
(4224, 14, 210, 'Cowell', 'AU', 'SA'),
(4225, 14, 210, 'Crafers', 'AU', 'SA'),
(4226, 14, 210, 'Crafers West', 'AU', 'SA'),
(4227, 14, 210, 'Craigburn Farm', 'AU', 'SA'),
(4228, 14, 210, 'Craigmore', 'AU', 'SA'),
(4229, 14, 210, 'Croydon Park', 'AU', 'SA'),
(4230, 14, 210, 'Crystal Brook', 'AU', 'SA'),
(4231, 14, 210, 'Cumberland Park', 'AU', 'SA'),
(4232, 14, 210, 'Darlington', 'AU', 'SA'),
(4233, 14, 210, 'Davoren Park', 'AU', 'SA'),
(4234, 14, 210, 'Daw Park', 'AU', 'SA'),
(4235, 14, 210, 'Dernancourt', 'AU', 'SA'),
(4236, 14, 210, 'Dover Gardens', 'AU', 'SA'),
(4237, 14, 210, 'Dulwich', 'AU', 'SA'),
(4238, 14, 210, 'Echunga', 'AU', 'SA'),
(4239, 14, 210, 'Eden Hills', 'AU', 'SA'),
(4240, 14, 210, 'Edwardstown', 'AU', 'SA'),
(4241, 14, 210, 'Elizabeth Downs', 'AU', 'SA'),
(4242, 14, 210, 'Elizabeth East', 'AU', 'SA'),
(4243, 14, 210, 'Elizabeth Grove', 'AU', 'SA'),
(4244, 14, 210, 'Elizabeth North', 'AU', 'SA'),
(4245, 14, 210, 'Elizabeth Park', 'AU', 'SA'),
(4246, 14, 210, 'Elizabeth South', 'AU', 'SA'),
(4247, 14, 210, 'Elizabeth Vale', 'AU', 'SA'),
(4248, 14, 210, 'Elliston', 'AU', 'SA'),
(4249, 14, 210, 'Encounter Bay', 'AU', 'SA'),
(4250, 14, 210, 'Enfield', 'AU', 'SA'),
(4251, 14, 210, 'Erindale', 'AU', 'SA'),
(4252, 14, 210, 'Ethelton', 'AU', 'SA'),
(4253, 14, 210, 'Evandale', 'AU', 'SA'),
(4254, 14, 210, 'Evanston', 'AU', 'SA'),
(4255, 14, 210, 'Evanston Gardens', 'AU', 'SA'),
(4256, 14, 210, 'Evanston Park', 'AU', 'SA'),
(4257, 14, 210, 'Everard Park', 'AU', 'SA'),
(4258, 14, 210, 'Exeter', 'AU', 'SA'),
(4259, 14, 210, 'Fairview Park', 'AU', 'SA'),
(4260, 14, 210, 'Felixstow', 'AU', 'SA'),
(4261, 14, 210, 'Ferryden Park', 'AU', 'SA'),
(4262, 14, 210, 'Findon', 'AU', 'SA'),
(4263, 14, 210, 'Firle', 'AU', 'SA'),
(4264, 14, 210, 'Flagstaff Hill', 'AU', 'SA'),
(4265, 14, 210, 'Flinders Park', 'AU', 'SA'),
(4266, 14, 210, 'Flinders Ranges', 'AU', 'SA'),
(4267, 14, 210, 'Forestville', 'AU', 'SA'),
(4268, 14, 210, 'Franklin Harbour', 'AU', 'SA'),
(4269, 14, 210, 'Freeling', 'AU', 'SA'),
(4270, 14, 210, 'Fulham', 'AU', 'SA'),
(4271, 14, 210, 'Fulham Gardens', 'AU', 'SA'),
(4272, 14, 210, 'Fullarton', 'AU', 'SA'),
(4273, 14, 210, 'Gawler', 'AU', 'SA'),
(4274, 14, 210, 'Gawler East', 'AU', 'SA'),
(4275, 14, 210, 'Gawler South', 'AU', 'SA'),
(4276, 14, 210, 'Gilberton', 'AU', 'SA'),
(4277, 14, 210, 'Gilles Plains', 'AU', 'SA'),
(4278, 14, 210, 'Glandore', 'AU', 'SA'),
(4279, 14, 210, 'Glen Osmond', 'AU', 'SA'),
(4280, 14, 210, 'Glenalta', 'AU', 'SA'),
(4281, 14, 210, 'Glenelg', 'AU', 'SA'),
(4282, 14, 210, 'Glenelg East', 'AU', 'SA'),
(4283, 14, 210, 'Glenelg North', 'AU', 'SA'),
(4284, 14, 210, 'Glenelg South', 'AU', 'SA'),
(4285, 14, 210, 'Glengowrie', 'AU', 'SA'),
(4286, 14, 210, 'Glenside', 'AU', 'SA'),
(4287, 14, 210, 'Glenunga', 'AU', 'SA'),
(4288, 14, 210, 'Glynde', 'AU', 'SA'),
(4289, 14, 210, 'Golden Grove', 'AU', 'SA'),
(4290, 14, 210, 'Goodwood', 'AU', 'SA'),
(4291, 14, 210, 'Goolwa', 'AU', 'SA'),
(4292, 14, 210, 'Goolwa Beach', 'AU', 'SA'),
(4293, 14, 210, 'Goyder', 'AU', 'SA'),
(4294, 14, 210, 'Grange', 'AU', 'SA'),
(4295, 14, 210, 'Grant', 'AU', 'SA'),
(4296, 14, 210, 'Greenacres', 'AU', 'SA'),
(4297, 14, 210, 'Greenock', 'AU', 'SA'),
(4298, 14, 210, 'Greenwith', 'AU', 'SA'),
(4299, 14, 210, 'Gulfview Heights', 'AU', 'SA'),
(4300, 14, 210, 'Hackham', 'AU', 'SA'),
(4301, 14, 210, 'Hackham West', 'AU', 'SA'),
(4302, 14, 210, 'Hahndorf', 'AU', 'SA'),
(4303, 14, 210, 'Hallett Cove', 'AU', 'SA'),
(4304, 14, 210, 'Hampstead Gardens', 'AU', 'SA'),
(4305, 14, 210, 'Happy Valley', 'AU', 'SA'),
(4306, 14, 210, 'Hawthorn', 'AU', 'SA'),
(4307, 14, 210, 'Hawthorndene', 'AU', 'SA'),
(4308, 14, 210, 'Hayborough', 'AU', 'SA'),
(4309, 14, 210, 'Hazelwood Park', 'AU', 'SA'),
(4310, 14, 210, 'Hectorville', 'AU', 'SA'),
(4311, 14, 210, 'Henley Beach', 'AU', 'SA'),
(4312, 14, 210, 'Henley Beach South', 'AU', 'SA'),
(4313, 14, 210, 'Hewett', 'AU', 'SA'),
(4314, 14, 210, 'Highbury', 'AU', 'SA'),
(4315, 14, 210, 'Highgate', 'AU', 'SA'),
(4316, 14, 210, 'Hillbank', 'AU', 'SA'),
(4317, 14, 210, 'Hillcrest', 'AU', 'SA'),
(4318, 14, 210, 'Hindmarsh Island', 'AU', 'SA'),
(4319, 14, 210, 'Holden Hill', 'AU', 'SA'),
(4320, 14, 210, 'Holdfast Bay', 'AU', 'SA'),
(4321, 14, 210, 'Hope Valley', 'AU', 'SA'),
(4322, 14, 210, 'Hove', 'AU', 'SA'),
(4323, 14, 210, 'Huntfield Heights', 'AU', 'SA'),
(4324, 14, 210, 'Hyde Park', 'AU', 'SA'),
(4325, 14, 210, 'Ingle Farm', 'AU', 'SA'),
(4326, 14, 210, 'Jamestown', 'AU', 'SA'),
(4327, 14, 210, 'Joslin', 'AU', 'SA'),
(4328, 14, 210, 'Kadina', 'AU', 'SA'),
(4329, 14, 210, 'Kangaroo Island', 'AU', 'SA'),
(4330, 14, 210, 'Kapunda', 'AU', 'SA'),
(4331, 14, 210, 'Karoonda East Murray', 'AU', 'SA'),
(4332, 14, 210, 'Keith', 'AU', 'SA'),
(4333, 14, 210, 'Kensington Gardens', 'AU', 'SA'),
(4334, 14, 210, 'Kensington Park', 'AU', 'SA'),
(4335, 14, 210, 'Kent Town', 'AU', 'SA'),
(4336, 14, 210, 'Kersbrook', 'AU', 'SA'),
(4337, 14, 210, 'Kidman Park', 'AU', 'SA'),
(4338, 14, 210, 'Kilburn', 'AU', 'SA'),
(4339, 14, 210, 'Kilkenny', 'AU', 'SA'),
(4340, 14, 210, 'Kimba', 'AU', 'SA'),
(4341, 14, 210, 'Kingscote', 'AU', 'SA'),
(4342, 14, 210, 'Kingston', 'AU', 'SA'),
(4343, 14, 210, 'Kingston South East', 'AU', 'SA'),
(4344, 14, 210, 'Klemzig', 'AU', 'SA'),
(4345, 14, 210, 'Kurralta Park', 'AU', 'SA'),
(4346, 14, 210, 'Largs Bay', 'AU', 'SA'),
(4347, 14, 210, 'Largs North', 'AU', 'SA'),
(4348, 14, 210, 'Leabrook', 'AU', 'SA'),
(4349, 14, 210, 'Lewiston', 'AU', 'SA'),
(4350, 14, 210, 'Light', 'AU', 'SA'),
(4351, 14, 210, 'Linden Park', 'AU', 'SA'),
(4352, 14, 210, 'Little Hampton', 'AU', 'SA'),
(4353, 14, 210, 'Lobethal', 'AU', 'SA'),
(4354, 14, 210, 'Lockleys', 'AU', 'SA'),
(4355, 14, 210, 'Lower Eyre Peninsula', 'AU', 'SA'),
(4356, 14, 210, 'Lower Mitcham', 'AU', 'SA'),
(4357, 14, 210, 'Loxton', 'AU', 'SA'),
(4358, 14, 210, 'Loxton Waikerie', 'AU', 'SA'),
(4359, 14, 210, 'Lyndoch', 'AU', 'SA'),
(4360, 14, 210, 'Macclesfield', 'AU', 'SA'),
(4361, 14, 210, 'Magill', 'AU', 'SA'),
(4362, 14, 210, 'Maitland', 'AU', 'SA'),
(4363, 14, 210, 'Mallala', 'AU', 'SA'),
(4364, 14, 210, 'Malvern', 'AU', 'SA'),
(4365, 14, 210, 'Manningham', 'AU', 'SA'),
(4366, 14, 210, 'Mannum', 'AU', 'SA'),
(4367, 14, 210, 'Mansfield Park', 'AU', 'SA'),
(4368, 14, 210, 'Maralinga Tjarutja', 'AU', 'SA'),
(4369, 14, 210, 'Marden', 'AU', 'SA'),
(4370, 14, 210, 'Marino', 'AU', 'SA'),
(4371, 14, 210, 'Marion', 'AU', 'SA'),
(4372, 14, 210, 'Marleston', 'AU', 'SA'),
(4373, 14, 210, 'Maslin Beach', 'AU', 'SA'),
(4374, 14, 210, 'Mawson Lakes', 'AU', 'SA'),
(4375, 14, 210, 'Maylands', 'AU', 'SA'),
(4376, 14, 210, 'McCracken', 'AU', 'SA'),
(4377, 14, 210, 'McLaren Flat', 'AU', 'SA'),
(4378, 14, 210, 'McLaren Vale', 'AU', 'SA'),
(4379, 14, 210, 'Meadows', 'AU', 'SA'),
(4380, 14, 210, 'Medindie', 'AU', 'SA'),
(4381, 14, 210, 'Melrose Park', 'AU', 'SA'),
(4382, 14, 210, 'Meningie', 'AU', 'SA'),
(4383, 14, 210, 'Mid Murray', 'AU', 'SA'),
(4384, 14, 210, 'Middleton', 'AU', 'SA'),
(4385, 14, 210, 'Mile End', 'AU', 'SA'),
(4386, 14, 210, 'Millicent', 'AU', 'SA'),
(4387, 14, 210, 'Millswood', 'AU', 'SA'),
(4388, 14, 210, 'Minlaton', 'AU', 'SA'),
(4389, 14, 210, 'Mitcham', 'AU', 'SA'),
(4390, 14, 210, 'Mitchell Park', 'AU', 'SA'),
(4391, 14, 210, 'Moana', 'AU', 'SA'),
(4392, 14, 210, 'Modbury', 'AU', 'SA'),
(4393, 14, 210, 'Modbury Heights', 'AU', 'SA'),
(4394, 14, 210, 'Modbury North', 'AU', 'SA'),
(4395, 14, 210, 'Monash', 'AU', 'SA'),
(4396, 14, 210, 'Moonta Bay', 'AU', 'SA'),
(4397, 14, 210, 'Moorak', 'AU', 'SA'),
(4398, 14, 210, 'Morphett Vale', 'AU', 'SA'),
(4399, 14, 210, 'Morphettville', 'AU', 'SA'),
(4400, 14, 210, 'Mount Barker', 'AU', 'SA'),
(4401, 14, 210, 'Mount Compass', 'AU', 'SA'),
(4402, 14, 210, 'Mount Gambier', 'AU', 'SA'),
(4403, 14, 210, 'Mount Remarkable', 'AU', 'SA'),
(4404, 14, 210, 'Munno Para', 'AU', 'SA'),
(4405, 14, 210, 'Munno Para West', 'AU', 'SA'),
(4406, 14, 210, 'Murray Bridge', 'AU', 'SA'),
(4407, 14, 210, 'Mylor', 'AU', 'SA'),
(4408, 14, 210, 'Myrtle Bank', 'AU', 'SA'),
(4409, 14, 210, 'Nailsworth', 'AU', 'SA'),
(4410, 14, 210, 'Nairne', 'AU', 'SA'),
(4411, 14, 210, 'Naracoorte', 'AU', 'SA'),
(4412, 14, 210, 'Naracoorte and Lucindale', 'AU', 'SA'),
(4413, 14, 210, 'Netherby', 'AU', 'SA'),
(4414, 14, 210, 'Netley', 'AU', 'SA'),
(4415, 14, 210, 'Newton', 'AU', 'SA'),
(4416, 14, 210, 'Noarlunga Downs', 'AU', 'SA'),
(4417, 14, 210, 'Normanville', 'AU', 'SA'),
(4418, 14, 210, 'North Adelaide', 'AU', 'SA'),
(4419, 14, 210, 'North Brighton', 'AU', 'SA'),
(4420, 14, 210, 'North Haven', 'AU', 'SA'),
(4421, 14, 210, 'North Plympton', 'AU', 'SA'),
(4422, 14, 210, 'Northern Areas', 'AU', 'SA'),
(4423, 14, 210, 'Northfield', 'AU', 'SA'),
(4424, 14, 210, 'Northgate', 'AU', 'SA'),
(4425, 14, 210, 'Norwood', 'AU', 'SA'),
(4426, 14, 210, 'Norwood Payneham St Peters', 'AU', 'SA'),
(4427, 14, 210, 'Novar Gardens', 'AU', 'SA'),
(4428, 14, 210, 'Nuriootpa', 'AU', 'SA'),
(4429, 14, 210, 'O\'Sullivan Beach', 'AU', 'SA'),
(4430, 14, 210, 'O’Halloran Hill', 'AU', 'SA'),
(4431, 14, 210, 'Oakden', 'AU', 'SA'),
(4432, 14, 210, 'Oaklands Park', 'AU', 'SA'),
(4433, 14, 210, 'Old Noarlunga', 'AU', 'SA'),
(4434, 14, 210, 'Old Reynella', 'AU', 'SA'),
(4435, 14, 210, 'One Tree Hill', 'AU', 'SA'),
(4436, 14, 210, 'Onkaparinga', 'AU', 'SA'),
(4437, 14, 210, 'Onkaparinga Hills', 'AU', 'SA'),
(4438, 14, 210, 'Orroroo/Carrieton', 'AU', 'SA'),
(4439, 14, 210, 'Osborne', 'AU', 'SA'),
(4440, 14, 210, 'Ottoway', 'AU', 'SA'),
(4441, 14, 210, 'Panorama', 'AU', 'SA'),
(4442, 14, 210, 'Para Hills', 'AU', 'SA'),
(4443, 14, 210, 'Para Hills West', 'AU', 'SA'),
(4444, 14, 210, 'Para Vista', 'AU', 'SA'),
(4445, 14, 210, 'Paradise', 'AU', 'SA'),
(4446, 14, 210, 'Parafield Gardens', 'AU', 'SA'),
(4447, 14, 210, 'Paralowie', 'AU', 'SA'),
(4448, 14, 210, 'Paringa', 'AU', 'SA'),
(4449, 14, 210, 'Park Holme', 'AU', 'SA'),
(4450, 14, 210, 'Parkside', 'AU', 'SA'),
(4451, 14, 210, 'Pasadena', 'AU', 'SA'),
(4452, 14, 210, 'Payneham', 'AU', 'SA'),
(4453, 14, 210, 'Payneham South', 'AU', 'SA'),
(4454, 14, 210, 'Pennington', 'AU', 'SA'),
(4455, 14, 210, 'Penola', 'AU', 'SA'),
(4456, 14, 210, 'Peterborough', 'AU', 'SA'),
(4457, 14, 210, 'Peterhead', 'AU', 'SA'),
(4458, 14, 210, 'Playford', 'AU', 'SA'),
(4459, 14, 210, 'Plympton', 'AU', 'SA'),
(4460, 14, 210, 'Plympton Park', 'AU', 'SA'),
(4461, 14, 210, 'Pooraka', 'AU', 'SA'),
(4462, 14, 210, 'Port Adelaide', 'AU', 'SA'),
(4463, 14, 210, 'Port Adelaide Enfield', 'AU', 'SA'),
(4464, 14, 210, 'Port Augusta', 'AU', 'SA'),
(4465, 14, 210, 'Port Augusta West', 'AU', 'SA'),
(4466, 14, 210, 'Port Broughton', 'AU', 'SA'),
(4467, 14, 210, 'Port Elliot', 'AU', 'SA'),
(4468, 14, 210, 'Port Lincoln', 'AU', 'SA'),
(4469, 14, 210, 'Port Noarlunga', 'AU', 'SA'),
(4470, 14, 210, 'Port Noarlunga South', 'AU', 'SA'),
(4471, 14, 210, 'Port Pirie', 'AU', 'SA'),
(4472, 14, 210, 'Port Pirie City and Dists', 'AU', 'SA'),
(4473, 14, 210, 'Port Pirie South', 'AU', 'SA'),
(4474, 14, 210, 'Port Pirie West', 'AU', 'SA'),
(4475, 14, 210, 'Port Willunga', 'AU', 'SA'),
(4476, 14, 210, 'Prospect', 'AU', 'SA'),
(4477, 14, 210, 'Queenstown', 'AU', 'SA'),
(4478, 14, 210, 'Quorn', 'AU', 'SA'),
(4479, 14, 210, 'Redwood Park', 'AU', 'SA'),
(4480, 14, 210, 'Renmark', 'AU', 'SA'),
(4481, 14, 210, 'Renmark Paringa', 'AU', 'SA'),
(4482, 14, 210, 'Renmark West', 'AU', 'SA'),
(4483, 14, 210, 'Renown Park', 'AU', 'SA'),
(4484, 14, 210, 'Reynella', 'AU', 'SA'),
(4485, 14, 210, 'Reynella East', 'AU', 'SA'),
(4486, 14, 210, 'Richmond', 'AU', 'SA'),
(4487, 14, 210, 'Ridgehaven', 'AU', 'SA'),
(4488, 14, 210, 'Ridleyton', 'AU', 'SA'),
(4489, 14, 210, 'Risdon Park', 'AU', 'SA'),
(4490, 14, 210, 'Risdon Park South', 'AU', 'SA'),
(4491, 14, 210, 'Robe', 'AU', 'SA'),
(4492, 14, 210, 'Rose Park', 'AU', 'SA'),
(4493, 14, 210, 'Rosewater', 'AU', 'SA'),
(4494, 14, 210, 'Rosslyn Park', 'AU', 'SA'),
(4495, 14, 210, 'Rostrevor', 'AU', 'SA'),
(4496, 14, 210, 'Roxby Downs', 'AU', 'SA'),
(4497, 14, 210, 'Royal Park', 'AU', 'SA'),
(4498, 14, 210, 'Royston Park', 'AU', 'SA'),
(4499, 14, 210, 'Salisbury', 'AU', 'SA'),
(4500, 14, 210, 'Salisbury Downs', 'AU', 'SA');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(4501, 14, 210, 'Salisbury East', 'AU', 'SA'),
(4502, 14, 210, 'Salisbury Heights', 'AU', 'SA'),
(4503, 14, 210, 'Salisbury North', 'AU', 'SA'),
(4504, 14, 210, 'Salisbury Park', 'AU', 'SA'),
(4505, 14, 210, 'Salisbury Plain', 'AU', 'SA'),
(4506, 14, 210, 'Seacliff', 'AU', 'SA'),
(4507, 14, 210, 'Seacliff Park', 'AU', 'SA'),
(4508, 14, 210, 'Seacombe Gardens', 'AU', 'SA'),
(4509, 14, 210, 'Seacombe Heights', 'AU', 'SA'),
(4510, 14, 210, 'Seaford', 'AU', 'SA'),
(4511, 14, 210, 'Seaford Meadows', 'AU', 'SA'),
(4512, 14, 210, 'Seaford Rise', 'AU', 'SA'),
(4513, 14, 210, 'Seaton', 'AU', 'SA'),
(4514, 14, 210, 'Seaview Downs', 'AU', 'SA'),
(4515, 14, 210, 'Sefton Park', 'AU', 'SA'),
(4516, 14, 210, 'Sellicks Beach', 'AU', 'SA'),
(4517, 14, 210, 'Semaphore', 'AU', 'SA'),
(4518, 14, 210, 'Semaphore Park', 'AU', 'SA'),
(4519, 14, 210, 'Semaphore South', 'AU', 'SA'),
(4520, 14, 210, 'Sheidow Park', 'AU', 'SA'),
(4521, 14, 210, 'Smithfield', 'AU', 'SA'),
(4522, 14, 210, 'Smithfield Plains', 'AU', 'SA'),
(4523, 14, 210, 'Solomontown', 'AU', 'SA'),
(4524, 14, 210, 'Somerton Park', 'AU', 'SA'),
(4525, 14, 210, 'South Brighton', 'AU', 'SA'),
(4526, 14, 210, 'South Plympton', 'AU', 'SA'),
(4527, 14, 210, 'Southern Mallee', 'AU', 'SA'),
(4528, 14, 210, 'St Agnes', 'AU', 'SA'),
(4529, 14, 210, 'St Georges', 'AU', 'SA'),
(4530, 14, 210, 'St Marys', 'AU', 'SA'),
(4531, 14, 210, 'St Morris', 'AU', 'SA'),
(4532, 14, 210, 'St Peters', 'AU', 'SA'),
(4533, 14, 210, 'Stirling', 'AU', 'SA'),
(4534, 14, 210, 'Stirling North', 'AU', 'SA'),
(4535, 14, 210, 'Stonyfell', 'AU', 'SA'),
(4536, 14, 210, 'Strathalbyn', 'AU', 'SA'),
(4537, 14, 210, 'Streaky Bay', 'AU', 'SA'),
(4538, 14, 210, 'Sturt', 'AU', 'SA'),
(4539, 14, 210, 'Surrey Downs', 'AU', 'SA'),
(4540, 14, 210, 'Tailem Bend', 'AU', 'SA'),
(4541, 14, 210, 'Tanunda', 'AU', 'SA'),
(4542, 14, 210, 'Taperoo', 'AU', 'SA'),
(4543, 14, 210, 'Tatiara', 'AU', 'SA'),
(4544, 14, 210, 'Tea Tree Gully', 'AU', 'SA'),
(4545, 14, 210, 'Tennyson', 'AU', 'SA'),
(4546, 14, 210, 'The Coorong', 'AU', 'SA'),
(4547, 14, 210, 'Thebarton', 'AU', 'SA'),
(4548, 14, 210, 'Toorak Gardens', 'AU', 'SA'),
(4549, 14, 210, 'Torrens Park', 'AU', 'SA'),
(4550, 14, 210, 'Torrensville', 'AU', 'SA'),
(4551, 14, 210, 'Tranmere', 'AU', 'SA'),
(4552, 14, 210, 'Trinity Gardens', 'AU', 'SA'),
(4553, 14, 210, 'Trott Park', 'AU', 'SA'),
(4554, 14, 210, 'Tumby Bay', 'AU', 'SA'),
(4555, 14, 210, 'Tusmore', 'AU', 'SA'),
(4556, 14, 210, 'Two Wells', 'AU', 'SA'),
(4557, 14, 210, 'Underdale', 'AU', 'SA'),
(4558, 14, 210, 'Unley', 'AU', 'SA'),
(4559, 14, 210, 'Unley Park', 'AU', 'SA'),
(4560, 14, 210, 'Vale Park', 'AU', 'SA'),
(4561, 14, 210, 'Valley View', 'AU', 'SA'),
(4562, 14, 210, 'Victor Harbor', 'AU', 'SA'),
(4563, 14, 210, 'Virginia', 'AU', 'SA'),
(4564, 14, 210, 'Waikerie', 'AU', 'SA'),
(4565, 14, 210, 'Wakefield', 'AU', 'SA'),
(4566, 14, 210, 'Walkerville', 'AU', 'SA'),
(4567, 14, 210, 'Walkley Heights', 'AU', 'SA'),
(4568, 14, 210, 'Wallaroo', 'AU', 'SA'),
(4569, 14, 210, 'Warradale', 'AU', 'SA'),
(4570, 14, 210, 'Waterloo Corner', 'AU', 'SA'),
(4571, 14, 210, 'Wattle Park', 'AU', 'SA'),
(4572, 14, 210, 'Wattle Range', 'AU', 'SA'),
(4573, 14, 210, 'Wayville', 'AU', 'SA'),
(4574, 14, 210, 'West Beach', 'AU', 'SA'),
(4575, 14, 210, 'West Croydon', 'AU', 'SA'),
(4576, 14, 210, 'West Hindmarsh', 'AU', 'SA'),
(4577, 14, 210, 'West Lakes', 'AU', 'SA'),
(4578, 14, 210, 'West Lakes Shore', 'AU', 'SA'),
(4579, 14, 210, 'Westbourne Park', 'AU', 'SA'),
(4580, 14, 210, 'Whyalla', 'AU', 'SA'),
(4581, 14, 210, 'Whyalla Jenkins', 'AU', 'SA'),
(4582, 14, 210, 'Whyalla Norrie', 'AU', 'SA'),
(4583, 14, 210, 'Whyalla Playford', 'AU', 'SA'),
(4584, 14, 210, 'Whyalla Stuart', 'AU', 'SA'),
(4585, 14, 210, 'Willaston', 'AU', 'SA'),
(4586, 14, 210, 'Williamstown', 'AU', 'SA'),
(4587, 14, 210, 'Willunga', 'AU', 'SA'),
(4588, 14, 210, 'Windsor Gardens', 'AU', 'SA'),
(4589, 14, 210, 'Woodcroft', 'AU', 'SA'),
(4590, 14, 210, 'Woodside', 'AU', 'SA'),
(4591, 14, 210, 'Woodville', 'AU', 'SA'),
(4592, 14, 210, 'Woodville Gardens', 'AU', 'SA'),
(4593, 14, 210, 'Woodville North', 'AU', 'SA'),
(4594, 14, 210, 'Woodville Park', 'AU', 'SA'),
(4595, 14, 210, 'Woodville South', 'AU', 'SA'),
(4596, 14, 210, 'Woodville West', 'AU', 'SA'),
(4597, 14, 210, 'Wudinna', 'AU', 'SA'),
(4598, 14, 210, 'Wynn Vale', 'AU', 'SA'),
(4599, 14, 210, 'Yankalilla', 'AU', 'SA'),
(4600, 14, 210, 'Yorke Peninsula', 'AU', 'SA'),
(4601, 14, 211, 'Acton Park', 'AU', 'TAS'),
(4602, 14, 211, 'Austins Ferry', 'AU', 'TAS'),
(4603, 14, 211, 'Bagdad', 'AU', 'TAS'),
(4604, 14, 211, 'Battery Point', 'AU', 'TAS'),
(4605, 14, 211, 'Beaconsfield', 'AU', 'TAS'),
(4606, 14, 211, 'Beauty Point', 'AU', 'TAS'),
(4607, 14, 211, 'Bellerive', 'AU', 'TAS'),
(4608, 14, 211, 'Berriedale', 'AU', 'TAS'),
(4609, 14, 211, 'Blackmans Bay', 'AU', 'TAS'),
(4610, 14, 211, 'Blackstone Heights', 'AU', 'TAS'),
(4611, 14, 211, 'Break O\'Day', 'AU', 'TAS'),
(4612, 14, 211, 'Bridgewater', 'AU', 'TAS'),
(4613, 14, 211, 'Bridport', 'AU', 'TAS'),
(4614, 14, 211, 'Brighton', 'AU', 'TAS'),
(4615, 14, 211, 'Burnie', 'AU', 'TAS'),
(4616, 14, 211, 'Cambridge', 'AU', 'TAS'),
(4617, 14, 211, 'Central Coast', 'AU', 'TAS'),
(4618, 14, 211, 'Central Highlands', 'AU', 'TAS'),
(4619, 14, 211, 'Chigwell', 'AU', 'TAS'),
(4620, 14, 211, 'Circular Head', 'AU', 'TAS'),
(4621, 14, 211, 'Claremont', 'AU', 'TAS'),
(4622, 14, 211, 'Clarence', 'AU', 'TAS'),
(4623, 14, 211, 'Clarendon Vale', 'AU', 'TAS'),
(4624, 14, 211, 'Cressy', 'AU', 'TAS'),
(4625, 14, 211, 'Currie', 'AU', 'TAS'),
(4626, 14, 211, 'Cygnet', 'AU', 'TAS'),
(4627, 14, 211, 'Deloraine', 'AU', 'TAS'),
(4628, 14, 211, 'Derwent Valley', 'AU', 'TAS'),
(4629, 14, 211, 'Devonport', 'AU', 'TAS'),
(4630, 14, 211, 'Dodges Ferry', 'AU', 'TAS'),
(4631, 14, 211, 'Dorset', 'AU', 'TAS'),
(4632, 14, 211, 'Dynnyrne', 'AU', 'TAS'),
(4633, 14, 211, 'East Devonport', 'AU', 'TAS'),
(4634, 14, 211, 'East Launceston', 'AU', 'TAS'),
(4635, 14, 211, 'Evandale', 'AU', 'TAS'),
(4636, 14, 211, 'Flinders', 'AU', 'TAS'),
(4637, 14, 211, 'Franklin', 'AU', 'TAS'),
(4638, 14, 211, 'Gagebrook', 'AU', 'TAS'),
(4639, 14, 211, 'Geeveston', 'AU', 'TAS'),
(4640, 14, 211, 'Geilston Bay', 'AU', 'TAS'),
(4641, 14, 211, 'George Town', 'AU', 'TAS'),
(4642, 14, 211, 'Glamorgan/Spring Bay', 'AU', 'TAS'),
(4643, 14, 211, 'Glenorchy', 'AU', 'TAS'),
(4644, 14, 211, 'Goodwood', 'AU', 'TAS'),
(4645, 14, 211, 'Granton', 'AU', 'TAS'),
(4646, 14, 211, 'Hadspen', 'AU', 'TAS'),
(4647, 14, 211, 'Herdsmans Cove', 'AU', 'TAS'),
(4648, 14, 211, 'Hillcrest', 'AU', 'TAS'),
(4649, 14, 211, 'Hobart', 'AU', 'TAS'),
(4650, 14, 211, 'Hobart city centre', 'AU', 'TAS'),
(4651, 14, 211, 'Howrah', 'AU', 'TAS'),
(4652, 14, 211, 'Huon Valley', 'AU', 'TAS'),
(4653, 14, 211, 'Huonville', 'AU', 'TAS'),
(4654, 14, 211, 'Invermay', 'AU', 'TAS'),
(4655, 14, 211, 'Kentish', 'AU', 'TAS'),
(4656, 14, 211, 'King Island', 'AU', 'TAS'),
(4657, 14, 211, 'Kingborough', 'AU', 'TAS'),
(4658, 14, 211, 'Kings Meadows', 'AU', 'TAS'),
(4659, 14, 211, 'Kingston', 'AU', 'TAS'),
(4660, 14, 211, 'Kingston Beach', 'AU', 'TAS'),
(4661, 14, 211, 'Latrobe', 'AU', 'TAS'),
(4662, 14, 211, 'Lauderdale', 'AU', 'TAS'),
(4663, 14, 211, 'Launceston', 'AU', 'TAS'),
(4664, 14, 211, 'Launceston city centre', 'AU', 'TAS'),
(4665, 14, 211, 'Legana', 'AU', 'TAS'),
(4666, 14, 211, 'Lenah Valley', 'AU', 'TAS'),
(4667, 14, 211, 'Lindisfarne', 'AU', 'TAS'),
(4668, 14, 211, 'Longford', 'AU', 'TAS'),
(4669, 14, 211, 'Lutana', 'AU', 'TAS'),
(4670, 14, 211, 'Margate', 'AU', 'TAS'),
(4671, 14, 211, 'Mayfield', 'AU', 'TAS'),
(4672, 14, 211, 'Meander Valley', 'AU', 'TAS'),
(4673, 14, 211, 'Miandetta', 'AU', 'TAS'),
(4674, 14, 211, 'Midway Point', 'AU', 'TAS'),
(4675, 14, 211, 'Montello', 'AU', 'TAS'),
(4676, 14, 211, 'Montrose', 'AU', 'TAS'),
(4677, 14, 211, 'Moonah', 'AU', 'TAS'),
(4678, 14, 211, 'Mornington', 'AU', 'TAS'),
(4679, 14, 211, 'Mount Nelson', 'AU', 'TAS'),
(4680, 14, 211, 'Mount Stuart', 'AU', 'TAS'),
(4681, 14, 211, 'Mowbray', 'AU', 'TAS'),
(4682, 14, 211, 'New Norfolk', 'AU', 'TAS'),
(4683, 14, 211, 'New Town', 'AU', 'TAS'),
(4684, 14, 211, 'Newnham', 'AU', 'TAS'),
(4685, 14, 211, 'Newstead', 'AU', 'TAS'),
(4686, 14, 211, 'North Hobart', 'AU', 'TAS'),
(4687, 14, 211, 'Northern Midlands', 'AU', 'TAS'),
(4688, 14, 211, 'Norwood', 'AU', 'TAS'),
(4689, 14, 211, 'Oakdowns', 'AU', 'TAS'),
(4690, 14, 211, 'Old Beach', 'AU', 'TAS'),
(4691, 14, 211, 'Park Grove', 'AU', 'TAS'),
(4692, 14, 211, 'Penguin', 'AU', 'TAS'),
(4693, 14, 211, 'Perth', 'AU', 'TAS'),
(4694, 14, 211, 'Port Sorell', 'AU', 'TAS'),
(4695, 14, 211, 'Prospect Vale', 'AU', 'TAS'),
(4696, 14, 211, 'Queenstown', 'AU', 'TAS'),
(4697, 14, 211, 'Ranelagh', 'AU', 'TAS'),
(4698, 14, 211, 'Ravenswood', 'AU', 'TAS'),
(4699, 14, 211, 'Richmond', 'AU', 'TAS'),
(4700, 14, 211, 'Risdon Vale', 'AU', 'TAS'),
(4701, 14, 211, 'Riverside', 'AU', 'TAS'),
(4702, 14, 211, 'Rocherlea', 'AU', 'TAS'),
(4703, 14, 211, 'Rokeby', 'AU', 'TAS'),
(4704, 14, 211, 'Romaine', 'AU', 'TAS'),
(4705, 14, 211, 'Rosetta', 'AU', 'TAS'),
(4706, 14, 211, 'Saint Leonards', 'AU', 'TAS'),
(4707, 14, 211, 'Sandford', 'AU', 'TAS'),
(4708, 14, 211, 'Sandy Bay', 'AU', 'TAS'),
(4709, 14, 211, 'Scottsdale', 'AU', 'TAS'),
(4710, 14, 211, 'Seven Mile Beach', 'AU', 'TAS'),
(4711, 14, 211, 'Shearwater', 'AU', 'TAS'),
(4712, 14, 211, 'Sheffield', 'AU', 'TAS'),
(4713, 14, 211, 'Shorewell Park', 'AU', 'TAS'),
(4714, 14, 211, 'Smithton', 'AU', 'TAS'),
(4715, 14, 211, 'Snug', 'AU', 'TAS'),
(4716, 14, 211, 'Somerset', 'AU', 'TAS'),
(4717, 14, 211, 'Sorell', 'AU', 'TAS'),
(4718, 14, 211, 'South Hobart', 'AU', 'TAS'),
(4719, 14, 211, 'South Launceston', 'AU', 'TAS'),
(4720, 14, 211, 'Southern Midlands', 'AU', 'TAS'),
(4721, 14, 211, 'Spreyton', 'AU', 'TAS'),
(4722, 14, 211, 'St Helens', 'AU', 'TAS'),
(4723, 14, 211, 'Summerhill', 'AU', 'TAS'),
(4724, 14, 211, 'Taroona', 'AU', 'TAS'),
(4725, 14, 211, 'Tasman Peninsula', 'AU', 'TAS'),
(4726, 14, 211, 'Tranmere', 'AU', 'TAS'),
(4727, 14, 211, 'Trevallyn', 'AU', 'TAS'),
(4728, 14, 211, 'Turners Beach', 'AU', 'TAS'),
(4729, 14, 211, 'Ulverstone', 'AU', 'TAS'),
(4730, 14, 211, 'Upper Burnie', 'AU', 'TAS'),
(4731, 14, 211, 'Waratah/Wynyard', 'AU', 'TAS'),
(4732, 14, 211, 'Warrane', 'AU', 'TAS'),
(4733, 14, 211, 'Waverley', 'AU', 'TAS'),
(4734, 14, 211, 'West Coast', 'AU', 'TAS'),
(4735, 14, 211, 'West Hobart', 'AU', 'TAS'),
(4736, 14, 211, 'West Launceston', 'AU', 'TAS'),
(4737, 14, 211, 'West Moonah', 'AU', 'TAS'),
(4738, 14, 211, 'West Tamar', 'AU', 'TAS'),
(4739, 14, 211, 'West Ulverstone', 'AU', 'TAS'),
(4740, 14, 211, 'Westbury', 'AU', 'TAS'),
(4741, 14, 211, 'Wynyard', 'AU', 'TAS'),
(4742, 14, 211, 'Youngtown', 'AU', 'TAS'),
(4743, 14, 212, 'Abbotsford', 'AU', 'VIC'),
(4744, 14, 212, 'Aberfeldie', 'AU', 'VIC'),
(4745, 14, 212, 'Airport West', 'AU', 'VIC'),
(4746, 14, 212, 'Albanvale', 'AU', 'VIC'),
(4747, 14, 212, 'Albert Park', 'AU', 'VIC'),
(4748, 14, 212, 'Albion', 'AU', 'VIC'),
(4749, 14, 212, 'Alexandra', 'AU', 'VIC'),
(4750, 14, 212, 'Alfredton', 'AU', 'VIC'),
(4751, 14, 212, 'Allansford', 'AU', 'VIC'),
(4752, 14, 212, 'Alphington', 'AU', 'VIC'),
(4753, 14, 212, 'Alpine', 'AU', 'VIC'),
(4754, 14, 212, 'Altona', 'AU', 'VIC'),
(4755, 14, 212, 'Altona Meadows', 'AU', 'VIC'),
(4756, 14, 212, 'Altona North', 'AU', 'VIC'),
(4757, 14, 212, 'Anglesea', 'AU', 'VIC'),
(4758, 14, 212, 'Apollo Bay', 'AU', 'VIC'),
(4759, 14, 212, 'Ararat', 'AU', 'VIC'),
(4760, 14, 212, 'Ardeer', 'AU', 'VIC'),
(4761, 14, 212, 'Armadale', 'AU', 'VIC'),
(4762, 14, 212, 'Armstrong Creek', 'AU', 'VIC'),
(4763, 14, 212, 'Ascot', 'AU', 'VIC'),
(4764, 14, 212, 'Ascot Vale', 'AU', 'VIC'),
(4765, 14, 212, 'Ashburton', 'AU', 'VIC'),
(4766, 14, 212, 'Ashwood', 'AU', 'VIC'),
(4767, 14, 212, 'Aspendale', 'AU', 'VIC'),
(4768, 14, 212, 'Aspendale Gardens', 'AU', 'VIC'),
(4769, 14, 212, 'Attwood', 'AU', 'VIC'),
(4770, 14, 212, 'Avenel', 'AU', 'VIC'),
(4771, 14, 212, 'Avoca', 'AU', 'VIC'),
(4772, 14, 212, 'Avondale Heights', 'AU', 'VIC'),
(4773, 14, 212, 'Bacchus Marsh', 'AU', 'VIC'),
(4774, 14, 212, 'Badger Creek', 'AU', 'VIC'),
(4775, 14, 212, 'Bairnsdale', 'AU', 'VIC'),
(4776, 14, 212, 'Balaclava', 'AU', 'VIC'),
(4777, 14, 212, 'Ballan', 'AU', 'VIC'),
(4778, 14, 212, 'Ballarat', 'AU', 'VIC'),
(4779, 14, 212, 'Ballarat Central', 'AU', 'VIC'),
(4780, 14, 212, 'Ballarat East', 'AU', 'VIC'),
(4781, 14, 212, 'Ballarat North', 'AU', 'VIC'),
(4782, 14, 212, 'Balnarring', 'AU', 'VIC'),
(4783, 14, 212, 'Balwyn', 'AU', 'VIC'),
(4784, 14, 212, 'Balwyn North', 'AU', 'VIC'),
(4785, 14, 212, 'Bannockburn', 'AU', 'VIC'),
(4786, 14, 212, 'Banyule', 'AU', 'VIC'),
(4787, 14, 212, 'Baranduda', 'AU', 'VIC'),
(4788, 14, 212, 'Barwon Heads', 'AU', 'VIC'),
(4789, 14, 212, 'Bass Coast', 'AU', 'VIC'),
(4790, 14, 212, 'Baw Baw', 'AU', 'VIC'),
(4791, 14, 212, 'Baxter', 'AU', 'VIC'),
(4792, 14, 212, 'Bayside', 'AU', 'VIC'),
(4793, 14, 212, 'Bayswater', 'AU', 'VIC'),
(4794, 14, 212, 'Bayswater North', 'AU', 'VIC'),
(4795, 14, 212, 'Beaconsfield', 'AU', 'VIC'),
(4796, 14, 212, 'Beaconsfield Upper', 'AU', 'VIC'),
(4797, 14, 212, 'Beaufort', 'AU', 'VIC'),
(4798, 14, 212, 'Beaumaris', 'AU', 'VIC'),
(4799, 14, 212, 'Beechworth', 'AU', 'VIC'),
(4800, 14, 212, 'Belgrave', 'AU', 'VIC'),
(4801, 14, 212, 'Belgrave Heights', 'AU', 'VIC'),
(4802, 14, 212, 'Belgrave South', 'AU', 'VIC'),
(4803, 14, 212, 'Bell Park', 'AU', 'VIC'),
(4804, 14, 212, 'Bell Post Hill', 'AU', 'VIC'),
(4805, 14, 212, 'Bellfield', 'AU', 'VIC'),
(4806, 14, 212, 'Belmont', 'AU', 'VIC'),
(4807, 14, 212, 'Benalla', 'AU', 'VIC'),
(4808, 14, 212, 'Bendigo', 'AU', 'VIC'),
(4809, 14, 212, 'Bendigo city centre', 'AU', 'VIC'),
(4810, 14, 212, 'Bentleigh', 'AU', 'VIC'),
(4811, 14, 212, 'Bentleigh East', 'AU', 'VIC'),
(4812, 14, 212, 'Berwick', 'AU', 'VIC'),
(4813, 14, 212, 'Beveridge', 'AU', 'VIC'),
(4814, 14, 212, 'Bittern', 'AU', 'VIC'),
(4815, 14, 212, 'Black Hill', 'AU', 'VIC'),
(4816, 14, 212, 'Black Rock', 'AU', 'VIC'),
(4817, 14, 212, 'Blackburn', 'AU', 'VIC'),
(4818, 14, 212, 'Blackburn North', 'AU', 'VIC'),
(4819, 14, 212, 'Blackburn South', 'AU', 'VIC'),
(4820, 14, 212, 'Blairgowrie', 'AU', 'VIC'),
(4821, 14, 212, 'Blind Bight', 'AU', 'VIC'),
(4822, 14, 212, 'Bonbeach', 'AU', 'VIC'),
(4823, 14, 212, 'Boronia', 'AU', 'VIC'),
(4824, 14, 212, 'Boroondara', 'AU', 'VIC'),
(4825, 14, 212, 'Botanic Ridge', 'AU', 'VIC'),
(4826, 14, 212, 'Box Hill', 'AU', 'VIC'),
(4827, 14, 212, 'Box Hill North', 'AU', 'VIC'),
(4828, 14, 212, 'Box Hill South', 'AU', 'VIC'),
(4829, 14, 212, 'Braybrook', 'AU', 'VIC'),
(4830, 14, 212, 'Briagolong', 'AU', 'VIC'),
(4831, 14, 212, 'Briar Hill', 'AU', 'VIC'),
(4832, 14, 212, 'Bright', 'AU', 'VIC'),
(4833, 14, 212, 'Brighton', 'AU', 'VIC'),
(4834, 14, 212, 'Brighton East', 'AU', 'VIC'),
(4835, 14, 212, 'Brimbank', 'AU', 'VIC'),
(4836, 14, 212, 'Broadford', 'AU', 'VIC'),
(4837, 14, 212, 'Broadmeadows', 'AU', 'VIC'),
(4838, 14, 212, 'Brookfield', 'AU', 'VIC'),
(4839, 14, 212, 'Brooklyn', 'AU', 'VIC'),
(4840, 14, 212, 'Brown Hill', 'AU', 'VIC'),
(4841, 14, 212, 'Brunswick', 'AU', 'VIC'),
(4842, 14, 212, 'Brunswick East', 'AU', 'VIC'),
(4843, 14, 212, 'Brunswick West', 'AU', 'VIC'),
(4844, 14, 212, 'Bulleen', 'AU', 'VIC'),
(4845, 14, 212, 'Buloke', 'AU', 'VIC'),
(4846, 14, 212, 'Bundoora', 'AU', 'VIC'),
(4847, 14, 212, 'Buninyong', 'AU', 'VIC'),
(4848, 14, 212, 'Bunyip', 'AU', 'VIC'),
(4849, 14, 212, 'Burnside', 'AU', 'VIC'),
(4850, 14, 212, 'Burnside Heights', 'AU', 'VIC'),
(4851, 14, 212, 'Burwood', 'AU', 'VIC'),
(4852, 14, 212, 'Burwood East', 'AU', 'VIC'),
(4853, 14, 212, 'Cairnlea', 'AU', 'VIC'),
(4854, 14, 212, 'California Gully', 'AU', 'VIC'),
(4855, 14, 212, 'Camberwell', 'AU', 'VIC'),
(4856, 14, 212, 'Campaspe', 'AU', 'VIC'),
(4857, 14, 212, 'Campbellfield', 'AU', 'VIC'),
(4858, 14, 212, 'Campbells Creek', 'AU', 'VIC'),
(4859, 14, 212, 'Camperdown', 'AU', 'VIC'),
(4860, 14, 212, 'Canadian', 'AU', 'VIC'),
(4861, 14, 212, 'Canterbury', 'AU', 'VIC'),
(4862, 14, 212, 'Cape Woolamai', 'AU', 'VIC'),
(4863, 14, 212, 'Cardinia', 'AU', 'VIC'),
(4864, 14, 212, 'Carisbrook', 'AU', 'VIC'),
(4865, 14, 212, 'Carlton', 'AU', 'VIC'),
(4866, 14, 212, 'Carlton North', 'AU', 'VIC'),
(4867, 14, 212, 'Carnegie', 'AU', 'VIC'),
(4868, 14, 212, 'Caroline Springs', 'AU', 'VIC'),
(4869, 14, 212, 'Carrum', 'AU', 'VIC'),
(4870, 14, 212, 'Carrum Downs', 'AU', 'VIC'),
(4871, 14, 212, 'Casey', 'AU', 'VIC'),
(4872, 14, 212, 'Casterton', 'AU', 'VIC'),
(4873, 14, 212, 'Castlemaine', 'AU', 'VIC'),
(4874, 14, 212, 'Caulfield', 'AU', 'VIC'),
(4875, 14, 212, 'Caulfield East', 'AU', 'VIC'),
(4876, 14, 212, 'Caulfield North', 'AU', 'VIC'),
(4877, 14, 212, 'Caulfield South', 'AU', 'VIC'),
(4878, 14, 212, 'Central Goldfields', 'AU', 'VIC'),
(4879, 14, 212, 'Chadstone', 'AU', 'VIC'),
(4880, 14, 212, 'Charlton', 'AU', 'VIC'),
(4881, 14, 212, 'Chelsea', 'AU', 'VIC'),
(4882, 14, 212, 'Chelsea Heights', 'AU', 'VIC'),
(4883, 14, 212, 'Cheltenham', 'AU', 'VIC'),
(4884, 14, 212, 'Chewton', 'AU', 'VIC'),
(4885, 14, 212, 'Chiltern', 'AU', 'VIC'),
(4886, 14, 212, 'Chirnside Park', 'AU', 'VIC'),
(4887, 14, 212, 'Churchill', 'AU', 'VIC'),
(4888, 14, 212, 'Clarinda', 'AU', 'VIC'),
(4889, 14, 212, 'Clayton', 'AU', 'VIC'),
(4890, 14, 212, 'Clayton South', 'AU', 'VIC'),
(4891, 14, 212, 'Clifton Hill', 'AU', 'VIC'),
(4892, 14, 212, 'Clifton Springs', 'AU', 'VIC'),
(4893, 14, 212, 'Clunes', 'AU', 'VIC'),
(4894, 14, 212, 'Clyde', 'AU', 'VIC'),
(4895, 14, 212, 'Clyde North', 'AU', 'VIC'),
(4896, 14, 212, 'Cobden', 'AU', 'VIC'),
(4897, 14, 212, 'Cobram', 'AU', 'VIC'),
(4898, 14, 212, 'Coburg', 'AU', 'VIC'),
(4899, 14, 212, 'Coburg North', 'AU', 'VIC'),
(4900, 14, 212, 'Cockatoo', 'AU', 'VIC'),
(4901, 14, 212, 'Cohuna', 'AU', 'VIC'),
(4902, 14, 212, 'Colac', 'AU', 'VIC'),
(4903, 14, 212, 'Colac-Otway', 'AU', 'VIC'),
(4904, 14, 212, 'Coldstream', 'AU', 'VIC'),
(4905, 14, 212, 'Collingwood', 'AU', 'VIC'),
(4906, 14, 212, 'Coolaroo', 'AU', 'VIC'),
(4907, 14, 212, 'Corangamite', 'AU', 'VIC'),
(4908, 14, 212, 'Corio', 'AU', 'VIC'),
(4909, 14, 212, 'Corryong', 'AU', 'VIC'),
(4910, 14, 212, 'Cowes', 'AU', 'VIC'),
(4911, 14, 212, 'Craigieburn', 'AU', 'VIC'),
(4912, 14, 212, 'Cranbourne', 'AU', 'VIC'),
(4913, 14, 212, 'Cranbourne East', 'AU', 'VIC'),
(4914, 14, 212, 'Cranbourne North', 'AU', 'VIC'),
(4915, 14, 212, 'Cranbourne South', 'AU', 'VIC'),
(4916, 14, 212, 'Cranbourne West', 'AU', 'VIC'),
(4917, 14, 212, 'Cremorne', 'AU', 'VIC'),
(4918, 14, 212, 'Creswick', 'AU', 'VIC'),
(4919, 14, 212, 'Crib Point', 'AU', 'VIC'),
(4920, 14, 212, 'Croydon', 'AU', 'VIC'),
(4921, 14, 212, 'Croydon Hills', 'AU', 'VIC'),
(4922, 14, 212, 'Croydon North', 'AU', 'VIC'),
(4923, 14, 212, 'Croydon South', 'AU', 'VIC'),
(4924, 14, 212, 'Dallas', 'AU', 'VIC'),
(4925, 14, 212, 'Dandenong', 'AU', 'VIC'),
(4926, 14, 212, 'Dandenong North', 'AU', 'VIC'),
(4927, 14, 212, 'Darebin', 'AU', 'VIC'),
(4928, 14, 212, 'Darley', 'AU', 'VIC'),
(4929, 14, 212, 'Daylesford', 'AU', 'VIC'),
(4930, 14, 212, 'Deer Park', 'AU', 'VIC'),
(4931, 14, 212, 'Delacombe', 'AU', 'VIC'),
(4932, 14, 212, 'Delahey', 'AU', 'VIC'),
(4933, 14, 212, 'Dennington', 'AU', 'VIC'),
(4934, 14, 212, 'Derrimut', 'AU', 'VIC'),
(4935, 14, 212, 'Devon Meadows', 'AU', 'VIC'),
(4936, 14, 212, 'Diamond Creek', 'AU', 'VIC'),
(4937, 14, 212, 'Diggers Rest', 'AU', 'VIC'),
(4938, 14, 212, 'Dimboola', 'AU', 'VIC'),
(4939, 14, 212, 'Dingley Village', 'AU', 'VIC'),
(4940, 14, 212, 'Dinner Plain', 'AU', 'VIC'),
(4941, 14, 212, 'Docklands', 'AU', 'VIC'),
(4942, 14, 212, 'Donald', 'AU', 'VIC'),
(4943, 14, 212, 'Doncaster', 'AU', 'VIC'),
(4944, 14, 212, 'Doncaster East', 'AU', 'VIC'),
(4945, 14, 212, 'Donvale', 'AU', 'VIC'),
(4946, 14, 212, 'Doreen', 'AU', 'VIC'),
(4947, 14, 212, 'Doveton', 'AU', 'VIC'),
(4948, 14, 212, 'Dromana', 'AU', 'VIC'),
(4949, 14, 212, 'Drouin', 'AU', 'VIC'),
(4950, 14, 212, 'Drysdale', 'AU', 'VIC'),
(4951, 14, 212, 'Eagle Point', 'AU', 'VIC'),
(4952, 14, 212, 'Eaglehawk', 'AU', 'VIC'),
(4953, 14, 212, 'Eaglemont', 'AU', 'VIC'),
(4954, 14, 212, 'East Bairnsdale', 'AU', 'VIC'),
(4955, 14, 212, 'East Bendigo', 'AU', 'VIC'),
(4956, 14, 212, 'East Geelong', 'AU', 'VIC'),
(4957, 14, 212, 'East Gippsland', 'AU', 'VIC'),
(4958, 14, 212, 'East Melbourne', 'AU', 'VIC'),
(4959, 14, 212, 'Echuca', 'AU', 'VIC'),
(4960, 14, 212, 'Eden Park', 'AU', 'VIC'),
(4961, 14, 212, 'Edithvale', 'AU', 'VIC'),
(4962, 14, 212, 'Elliminyt', 'AU', 'VIC'),
(4963, 14, 212, 'Elsternwick', 'AU', 'VIC'),
(4964, 14, 212, 'Eltham', 'AU', 'VIC'),
(4965, 14, 212, 'Eltham North', 'AU', 'VIC'),
(4966, 14, 212, 'Elwood', 'AU', 'VIC'),
(4967, 14, 212, 'Emerald', 'AU', 'VIC'),
(4968, 14, 212, 'Endeavour Hills', 'AU', 'VIC'),
(4969, 14, 212, 'Epping', 'AU', 'VIC'),
(4970, 14, 212, 'Epsom', 'AU', 'VIC'),
(4971, 14, 212, 'Essendon', 'AU', 'VIC'),
(4972, 14, 212, 'Essendon North', 'AU', 'VIC'),
(4973, 14, 212, 'Essendon West', 'AU', 'VIC'),
(4974, 14, 212, 'Eumemmerring', 'AU', 'VIC'),
(4975, 14, 212, 'Euroa', 'AU', 'VIC'),
(4976, 14, 212, 'Eynesbury', 'AU', 'VIC'),
(4977, 14, 212, 'Fairfield', 'AU', 'VIC'),
(4978, 14, 212, 'Falls Creek', 'AU', 'VIC'),
(4979, 14, 212, 'Fawkner', 'AU', 'VIC'),
(4980, 14, 212, 'Ferntree Gully', 'AU', 'VIC'),
(4981, 14, 212, 'Ferny Creek', 'AU', 'VIC'),
(4982, 14, 212, 'Fitzroy', 'AU', 'VIC'),
(4983, 14, 212, 'Fitzroy North', 'AU', 'VIC'),
(4984, 14, 212, 'Flemington', 'AU', 'VIC'),
(4985, 14, 212, 'Flora Hill', 'AU', 'VIC'),
(4986, 14, 212, 'Footscray', 'AU', 'VIC'),
(4987, 14, 212, 'Forest Hill', 'AU', 'VIC'),
(4988, 14, 212, 'Foster', 'AU', 'VIC'),
(4989, 14, 212, 'Frankston', 'AU', 'VIC'),
(4990, 14, 212, 'Frankston East', 'AU', 'VIC'),
(4991, 14, 212, 'Frankston North', 'AU', 'VIC'),
(4992, 14, 212, 'Frankston South', 'AU', 'VIC'),
(4993, 14, 212, 'Gannawarra', 'AU', 'VIC'),
(4994, 14, 212, 'Garfield', 'AU', 'VIC'),
(4995, 14, 212, 'Geelong', 'AU', 'VIC'),
(4996, 14, 212, 'Geelong city centre', 'AU', 'VIC'),
(4997, 14, 212, 'Geelong West', 'AU', 'VIC'),
(4998, 14, 212, 'Gembrook', 'AU', 'VIC'),
(4999, 14, 212, 'Gisborne', 'AU', 'VIC'),
(5000, 14, 212, 'Gladstone Park', 'AU', 'VIC');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(5001, 14, 212, 'Glen Eira', 'AU', 'VIC'),
(5002, 14, 212, 'Glen Huntly', 'AU', 'VIC'),
(5003, 14, 212, 'Glen Iris', 'AU', 'VIC'),
(5004, 14, 212, 'Glen Waverley', 'AU', 'VIC'),
(5005, 14, 212, 'Glenelg', 'AU', 'VIC'),
(5006, 14, 212, 'Glenferrie', 'AU', 'VIC'),
(5007, 14, 212, 'Glengarry', 'AU', 'VIC'),
(5008, 14, 212, 'Glenroy', 'AU', 'VIC'),
(5009, 14, 212, 'Golden Plains', 'AU', 'VIC'),
(5010, 14, 212, 'Golden Point', 'AU', 'VIC'),
(5011, 14, 212, 'Golden Square', 'AU', 'VIC'),
(5012, 14, 212, 'Gordon', 'AU', 'VIC'),
(5013, 14, 212, 'Gowanbrae', 'AU', 'VIC'),
(5014, 14, 212, 'Greater Bendigo', 'AU', 'VIC'),
(5015, 14, 212, 'Greater Dandenong', 'AU', 'VIC'),
(5016, 14, 212, 'Greater Geelong', 'AU', 'VIC'),
(5017, 14, 212, 'Greater Shepparton', 'AU', 'VIC'),
(5018, 14, 212, 'Greensborough', 'AU', 'VIC'),
(5019, 14, 212, 'Greenvale', 'AU', 'VIC'),
(5020, 14, 212, 'Grovedale', 'AU', 'VIC'),
(5021, 14, 212, 'Haddon', 'AU', 'VIC'),
(5022, 14, 212, 'Hadfield', 'AU', 'VIC'),
(5023, 14, 212, 'Hallam', 'AU', 'VIC'),
(5024, 14, 212, 'Hamilton', 'AU', 'VIC'),
(5025, 14, 212, 'Hamlyn Heights', 'AU', 'VIC'),
(5026, 14, 212, 'Hampton', 'AU', 'VIC'),
(5027, 14, 212, 'Hampton East', 'AU', 'VIC'),
(5028, 14, 212, 'Hampton Park', 'AU', 'VIC'),
(5029, 14, 212, 'Hastings', 'AU', 'VIC'),
(5030, 14, 212, 'Haven', 'AU', 'VIC'),
(5031, 14, 212, 'Hawthorn', 'AU', 'VIC'),
(5032, 14, 212, 'Hawthorn East', 'AU', 'VIC'),
(5033, 14, 212, 'Hawthorn South', 'AU', 'VIC'),
(5034, 14, 212, 'Hazelwood North', 'AU', 'VIC'),
(5035, 14, 212, 'Healesville', 'AU', 'VIC'),
(5036, 14, 212, 'Heathcote', 'AU', 'VIC'),
(5037, 14, 212, 'Heatherton', 'AU', 'VIC'),
(5038, 14, 212, 'Heathmont', 'AU', 'VIC'),
(5039, 14, 212, 'Heidelberg', 'AU', 'VIC'),
(5040, 14, 212, 'Heidelberg Heights', 'AU', 'VIC'),
(5041, 14, 212, 'Heidelberg West', 'AU', 'VIC'),
(5042, 14, 212, 'Hepburn', 'AU', 'VIC'),
(5043, 14, 212, 'Herne Hill', 'AU', 'VIC'),
(5044, 14, 212, 'Heyfield', 'AU', 'VIC'),
(5045, 14, 212, 'Heywood', 'AU', 'VIC'),
(5046, 14, 212, 'Highett', 'AU', 'VIC'),
(5047, 14, 212, 'Highton', 'AU', 'VIC'),
(5048, 14, 212, 'Hillside', 'AU', 'VIC'),
(5049, 14, 212, 'Hindmarsh', 'AU', 'VIC'),
(5050, 14, 212, 'Hmas Cerberus', 'AU', 'VIC'),
(5051, 14, 212, 'Hobsons Bay', 'AU', 'VIC'),
(5052, 14, 212, 'Hoppers Crossing', 'AU', 'VIC'),
(5053, 14, 212, 'Horsham', 'AU', 'VIC'),
(5054, 14, 212, 'Hotham Heights', 'AU', 'VIC'),
(5055, 14, 212, 'Hughesdale', 'AU', 'VIC'),
(5056, 14, 212, 'Hume', 'AU', 'VIC'),
(5057, 14, 212, 'Huntingdale', 'AU', 'VIC'),
(5058, 14, 212, 'Huntly', 'AU', 'VIC'),
(5059, 14, 212, 'Hurstbridge', 'AU', 'VIC'),
(5060, 14, 212, 'Indented Head', 'AU', 'VIC'),
(5061, 14, 212, 'Indigo', 'AU', 'VIC'),
(5062, 14, 212, 'Inverleigh', 'AU', 'VIC'),
(5063, 14, 212, 'Inverloch', 'AU', 'VIC'),
(5064, 14, 212, 'Invermay Park', 'AU', 'VIC'),
(5065, 14, 212, 'Ironbark', 'AU', 'VIC'),
(5066, 14, 212, 'Irymple', 'AU', 'VIC'),
(5067, 14, 212, 'Ivanhoe', 'AU', 'VIC'),
(5068, 14, 212, 'Ivanhoe East', 'AU', 'VIC'),
(5069, 14, 212, 'Jacana', 'AU', 'VIC'),
(5070, 14, 212, 'Jackass Flat', 'AU', 'VIC'),
(5071, 14, 212, 'Jan Juc', 'AU', 'VIC'),
(5072, 14, 212, 'Junction Village', 'AU', 'VIC'),
(5073, 14, 212, 'Junortoun', 'AU', 'VIC'),
(5074, 14, 212, 'Kalimna', 'AU', 'VIC'),
(5075, 14, 212, 'Kallista', 'AU', 'VIC'),
(5076, 14, 212, 'Kalorama', 'AU', 'VIC'),
(5077, 14, 212, 'Kangaroo Flat', 'AU', 'VIC'),
(5078, 14, 212, 'Kangaroo Ground', 'AU', 'VIC'),
(5079, 14, 212, 'Kealba', 'AU', 'VIC'),
(5080, 14, 212, 'Keilor', 'AU', 'VIC'),
(5081, 14, 212, 'Keilor Downs', 'AU', 'VIC'),
(5082, 14, 212, 'Keilor East', 'AU', 'VIC'),
(5083, 14, 212, 'Keilor Lodge', 'AU', 'VIC'),
(5084, 14, 212, 'Keilor Park', 'AU', 'VIC'),
(5085, 14, 212, 'Kennington', 'AU', 'VIC'),
(5086, 14, 212, 'Kensington', 'AU', 'VIC'),
(5087, 14, 212, 'Kerang', 'AU', 'VIC'),
(5088, 14, 212, 'Kew', 'AU', 'VIC'),
(5089, 14, 212, 'Kew East', 'AU', 'VIC'),
(5090, 14, 212, 'Keysborough', 'AU', 'VIC'),
(5091, 14, 212, 'Kialla', 'AU', 'VIC'),
(5092, 14, 212, 'Kilmore', 'AU', 'VIC'),
(5093, 14, 212, 'Kilsyth', 'AU', 'VIC'),
(5094, 14, 212, 'Kilsyth South', 'AU', 'VIC'),
(5095, 14, 212, 'Kinglake', 'AU', 'VIC'),
(5096, 14, 212, 'Kinglake West', 'AU', 'VIC'),
(5097, 14, 212, 'Kings Park', 'AU', 'VIC'),
(5098, 14, 212, 'Kingsbury', 'AU', 'VIC'),
(5099, 14, 212, 'Kingston', 'AU', 'VIC'),
(5100, 14, 212, 'Kingsville', 'AU', 'VIC'),
(5101, 14, 212, 'Knox', 'AU', 'VIC'),
(5102, 14, 212, 'Knoxfield', 'AU', 'VIC'),
(5103, 14, 212, 'Koo-Wee-Rup', 'AU', 'VIC'),
(5104, 14, 212, 'Koroit', 'AU', 'VIC'),
(5105, 14, 212, 'Korumburra', 'AU', 'VIC'),
(5106, 14, 212, 'Kurunjang', 'AU', 'VIC'),
(5107, 14, 212, 'Kyabram', 'AU', 'VIC'),
(5108, 14, 212, 'Kyneton', 'AU', 'VIC'),
(5109, 14, 212, 'Lake Gardens', 'AU', 'VIC'),
(5110, 14, 212, 'Lake Wendouree', 'AU', 'VIC'),
(5111, 14, 212, 'Lakes Entrance', 'AU', 'VIC'),
(5112, 14, 212, 'Lalor', 'AU', 'VIC'),
(5113, 14, 212, 'Lancefield', 'AU', 'VIC'),
(5114, 14, 212, 'Lang Lang', 'AU', 'VIC'),
(5115, 14, 212, 'Langwarrin', 'AU', 'VIC'),
(5116, 14, 212, 'Langwarrin South', 'AU', 'VIC'),
(5117, 14, 212, 'Lara', 'AU', 'VIC'),
(5118, 14, 212, 'Latrobe', 'AU', 'VIC'),
(5119, 14, 212, 'Launching Place', 'AU', 'VIC'),
(5120, 14, 212, 'Laverton', 'AU', 'VIC'),
(5121, 14, 212, 'Leongatha', 'AU', 'VIC'),
(5122, 14, 212, 'Leopold', 'AU', 'VIC'),
(5123, 14, 212, 'Lilydale', 'AU', 'VIC'),
(5124, 14, 212, 'Little River', 'AU', 'VIC'),
(5125, 14, 212, 'Loddon', 'AU', 'VIC'),
(5126, 14, 212, 'Long Gully', 'AU', 'VIC'),
(5127, 14, 212, 'Longford', 'AU', 'VIC'),
(5128, 14, 212, 'Longwarry', 'AU', 'VIC'),
(5129, 14, 212, 'Lorne', 'AU', 'VIC'),
(5130, 14, 212, 'Lovely Banks', 'AU', 'VIC'),
(5131, 14, 212, 'Lower Plenty', 'AU', 'VIC'),
(5132, 14, 212, 'Lucknow', 'AU', 'VIC'),
(5133, 14, 212, 'Lynbrook', 'AU', 'VIC'),
(5134, 14, 212, 'Lysterfield', 'AU', 'VIC'),
(5135, 14, 212, 'Macedon', 'AU', 'VIC'),
(5136, 14, 212, 'Macedon Ranges', 'AU', 'VIC'),
(5137, 14, 212, 'Macleod', 'AU', 'VIC'),
(5138, 14, 212, 'Maddingley', 'AU', 'VIC'),
(5139, 14, 212, 'Maffra', 'AU', 'VIC'),
(5140, 14, 212, 'Maiden Gully', 'AU', 'VIC'),
(5141, 14, 212, 'Maidstone', 'AU', 'VIC'),
(5142, 14, 212, 'Maldon', 'AU', 'VIC'),
(5143, 14, 212, 'Mallacoota', 'AU', 'VIC'),
(5144, 14, 212, 'Malvern', 'AU', 'VIC'),
(5145, 14, 212, 'Malvern East', 'AU', 'VIC'),
(5146, 14, 212, 'Manifold Heights', 'AU', 'VIC'),
(5147, 14, 212, 'Manningham', 'AU', 'VIC'),
(5148, 14, 212, 'Mansfield', 'AU', 'VIC'),
(5149, 14, 212, 'Maribyrnong', 'AU', 'VIC'),
(5150, 14, 212, 'Marong', 'AU', 'VIC'),
(5151, 14, 212, 'Maroondah', 'AU', 'VIC'),
(5152, 14, 212, 'Maryborough', 'AU', 'VIC'),
(5153, 14, 212, 'McCrae', 'AU', 'VIC'),
(5154, 14, 212, 'McKinnon', 'AU', 'VIC'),
(5155, 14, 212, 'Meadow Heights', 'AU', 'VIC'),
(5156, 14, 212, 'Melbourne', 'AU', 'VIC'),
(5157, 14, 212, 'Melbourne City Centre', 'AU', 'VIC'),
(5158, 14, 212, 'Melton', 'AU', 'VIC'),
(5159, 14, 212, 'Melton South', 'AU', 'VIC'),
(5160, 14, 212, 'Melton West', 'AU', 'VIC'),
(5161, 14, 212, 'Mentone', 'AU', 'VIC'),
(5162, 14, 212, 'Merbein', 'AU', 'VIC'),
(5163, 14, 212, 'Mernda', 'AU', 'VIC'),
(5164, 14, 212, 'Metung', 'AU', 'VIC'),
(5165, 14, 212, 'Mickleham', 'AU', 'VIC'),
(5166, 14, 212, 'Middle Park', 'AU', 'VIC'),
(5167, 14, 212, 'Mildura', 'AU', 'VIC'),
(5168, 14, 212, 'Mildura Shire', 'AU', 'VIC'),
(5169, 14, 212, 'Mill Park', 'AU', 'VIC'),
(5170, 14, 212, 'Millgrove', 'AU', 'VIC'),
(5171, 14, 212, 'Miners Rest', 'AU', 'VIC'),
(5172, 14, 212, 'Mirboo North', 'AU', 'VIC'),
(5173, 14, 212, 'Mitcham', 'AU', 'VIC'),
(5174, 14, 212, 'Mitchell', 'AU', 'VIC'),
(5175, 14, 212, 'Moe', 'AU', 'VIC'),
(5176, 14, 212, 'Moira', 'AU', 'VIC'),
(5177, 14, 212, 'Monash', 'AU', 'VIC'),
(5178, 14, 212, 'Monbulk', 'AU', 'VIC'),
(5179, 14, 212, 'Mont Albert', 'AU', 'VIC'),
(5180, 14, 212, 'Mont Albert North', 'AU', 'VIC'),
(5181, 14, 212, 'Montmorency', 'AU', 'VIC'),
(5182, 14, 212, 'Montrose', 'AU', 'VIC'),
(5183, 14, 212, 'Moolap', 'AU', 'VIC'),
(5184, 14, 212, 'Moonee Ponds', 'AU', 'VIC'),
(5185, 14, 212, 'Moonee Valley', 'AU', 'VIC'),
(5186, 14, 212, 'Moorabbin', 'AU', 'VIC'),
(5187, 14, 212, 'Moorabool', 'AU', 'VIC'),
(5188, 14, 212, 'Moorooduc', 'AU', 'VIC'),
(5189, 14, 212, 'Mooroolbark', 'AU', 'VIC'),
(5190, 14, 212, 'Mooroopna', 'AU', 'VIC'),
(5191, 14, 212, 'Mordialloc', 'AU', 'VIC'),
(5192, 14, 212, 'Moreland', 'AU', 'VIC'),
(5193, 14, 212, 'Mornington', 'AU', 'VIC'),
(5194, 14, 212, 'Mornington Peninsula', 'AU', 'VIC'),
(5195, 14, 212, 'Mortlake', 'AU', 'VIC'),
(5196, 14, 212, 'Morwell', 'AU', 'VIC'),
(5197, 14, 212, 'Mount Alexander', 'AU', 'VIC'),
(5198, 14, 212, 'Mount Buller', 'AU', 'VIC'),
(5199, 14, 212, 'Mount Clear', 'AU', 'VIC'),
(5200, 14, 212, 'Mount Dandenong', 'AU', 'VIC'),
(5201, 14, 212, 'Mount Duneed', 'AU', 'VIC'),
(5202, 14, 212, 'Mount Eliza', 'AU', 'VIC'),
(5203, 14, 212, 'Mount Evelyn', 'AU', 'VIC'),
(5204, 14, 212, 'Mount Helen', 'AU', 'VIC'),
(5205, 14, 212, 'Mount Macedon', 'AU', 'VIC'),
(5206, 14, 212, 'Mount Martha', 'AU', 'VIC'),
(5207, 14, 212, 'Mount Pleasant', 'AU', 'VIC'),
(5208, 14, 212, 'Mount Waverley', 'AU', 'VIC'),
(5209, 14, 212, 'Moyne', 'AU', 'VIC'),
(5210, 14, 212, 'Mulgrave', 'AU', 'VIC'),
(5211, 14, 212, 'Murrindindi', 'AU', 'VIC'),
(5212, 14, 212, 'Murrumbeena', 'AU', 'VIC'),
(5213, 14, 212, 'Myrtleford', 'AU', 'VIC'),
(5214, 14, 212, 'Nagambie', 'AU', 'VIC'),
(5215, 14, 212, 'Narre Warren', 'AU', 'VIC'),
(5216, 14, 212, 'Narre Warren North', 'AU', 'VIC'),
(5217, 14, 212, 'Narre Warren South', 'AU', 'VIC'),
(5218, 14, 212, 'Nathalia', 'AU', 'VIC'),
(5219, 14, 212, 'Neerim South', 'AU', 'VIC'),
(5220, 14, 212, 'New Gisborne', 'AU', 'VIC'),
(5221, 14, 212, 'Newborough', 'AU', 'VIC'),
(5222, 14, 212, 'Newcomb', 'AU', 'VIC'),
(5223, 14, 212, 'Newington', 'AU', 'VIC'),
(5224, 14, 212, 'Newport', 'AU', 'VIC'),
(5225, 14, 212, 'Newtown', 'AU', 'VIC'),
(5226, 14, 212, 'Nhill', 'AU', 'VIC'),
(5227, 14, 212, 'Nichols Point', 'AU', 'VIC'),
(5228, 14, 212, 'Nicholson', 'AU', 'VIC'),
(5229, 14, 212, 'Niddrie', 'AU', 'VIC'),
(5230, 14, 212, 'Nillumbik', 'AU', 'VIC'),
(5231, 14, 212, 'Noble Park', 'AU', 'VIC'),
(5232, 14, 212, 'Noble Park North', 'AU', 'VIC'),
(5233, 14, 212, 'Norlane', 'AU', 'VIC'),
(5234, 14, 212, 'North Bendigo', 'AU', 'VIC'),
(5235, 14, 212, 'North Brighton', 'AU', 'VIC'),
(5236, 14, 212, 'North Geelong', 'AU', 'VIC'),
(5237, 14, 212, 'North Melbourne', 'AU', 'VIC'),
(5238, 14, 212, 'North Warrandyte', 'AU', 'VIC'),
(5239, 14, 212, 'North Wonthaggi', 'AU', 'VIC'),
(5240, 14, 212, 'Northcote', 'AU', 'VIC'),
(5241, 14, 212, 'Northern Grampians', 'AU', 'VIC'),
(5242, 14, 212, 'Notting Hill', 'AU', 'VIC'),
(5243, 14, 212, 'Numurkah', 'AU', 'VIC'),
(5244, 14, 212, 'Nunawading', 'AU', 'VIC'),
(5245, 14, 212, 'Nyora', 'AU', 'VIC'),
(5246, 14, 212, 'Oak Park', 'AU', 'VIC'),
(5247, 14, 212, 'Oakleigh', 'AU', 'VIC'),
(5248, 14, 212, 'Oakleigh East', 'AU', 'VIC'),
(5249, 14, 212, 'Oakleigh South', 'AU', 'VIC'),
(5250, 14, 212, 'Ocean Grove', 'AU', 'VIC'),
(5251, 14, 212, 'Officer', 'AU', 'VIC'),
(5252, 14, 212, 'Olinda', 'AU', 'VIC'),
(5253, 14, 212, 'Orbost', 'AU', 'VIC'),
(5254, 14, 212, 'Ormond', 'AU', 'VIC'),
(5255, 14, 212, 'Ouyen', 'AU', 'VIC'),
(5256, 14, 212, 'Pakenham', 'AU', 'VIC'),
(5257, 14, 212, 'Pakenham Upper', 'AU', 'VIC'),
(5258, 14, 212, 'Panton Hill', 'AU', 'VIC'),
(5259, 14, 212, 'Park Orchards', 'AU', 'VIC'),
(5260, 14, 212, 'Parkdale', 'AU', 'VIC'),
(5261, 14, 212, 'Parkville', 'AU', 'VIC'),
(5262, 14, 212, 'Pascoe Vale', 'AU', 'VIC'),
(5263, 14, 212, 'Pascoe Vale South', 'AU', 'VIC'),
(5264, 14, 212, 'Patterson Lakes', 'AU', 'VIC'),
(5265, 14, 212, 'Paynesville', 'AU', 'VIC'),
(5266, 14, 212, 'Pearcedale', 'AU', 'VIC'),
(5267, 14, 212, 'Phillip Island', 'AU', 'VIC'),
(5268, 14, 212, 'Plenty', 'AU', 'VIC'),
(5269, 14, 212, 'Plumpton', 'AU', 'VIC'),
(5270, 14, 212, 'Point Cook', 'AU', 'VIC'),
(5271, 14, 212, 'Point Lonsdale', 'AU', 'VIC'),
(5272, 14, 212, 'Port Fairy', 'AU', 'VIC'),
(5273, 14, 212, 'Port Melbourne', 'AU', 'VIC'),
(5274, 14, 212, 'Port Phillip', 'AU', 'VIC'),
(5275, 14, 212, 'Portarlington', 'AU', 'VIC'),
(5276, 14, 212, 'Portland', 'AU', 'VIC'),
(5277, 14, 212, 'Prahran', 'AU', 'VIC'),
(5278, 14, 212, 'Preston', 'AU', 'VIC'),
(5279, 14, 212, 'Princes Hill', 'AU', 'VIC'),
(5280, 14, 212, 'Puckapunyal', 'AU', 'VIC'),
(5281, 14, 212, 'Pyrenees', 'AU', 'VIC'),
(5282, 14, 212, 'Quarry Hill', 'AU', 'VIC'),
(5283, 14, 212, 'Queenscliff', 'AU', 'VIC'),
(5284, 14, 212, 'Queenscliffe', 'AU', 'VIC'),
(5285, 14, 212, 'Ravenhall', 'AU', 'VIC'),
(5286, 14, 212, 'Red Cliffs', 'AU', 'VIC'),
(5287, 14, 212, 'Redan', 'AU', 'VIC'),
(5288, 14, 212, 'Research', 'AU', 'VIC'),
(5289, 14, 212, 'Reservoir', 'AU', 'VIC'),
(5290, 14, 212, 'Richmond', 'AU', 'VIC'),
(5291, 14, 212, 'Ringwood', 'AU', 'VIC'),
(5292, 14, 212, 'Ringwood East', 'AU', 'VIC'),
(5293, 14, 212, 'Ringwood North', 'AU', 'VIC'),
(5294, 14, 212, 'Ripponlea', 'AU', 'VIC'),
(5295, 14, 212, 'Robinvale', 'AU', 'VIC'),
(5296, 14, 212, 'Rochester', 'AU', 'VIC'),
(5297, 14, 212, 'Rockbank', 'AU', 'VIC'),
(5298, 14, 212, 'Romsey', 'AU', 'VIC'),
(5299, 14, 212, 'Rosanna', 'AU', 'VIC'),
(5300, 14, 212, 'Rosebud', 'AU', 'VIC'),
(5301, 14, 212, 'Rosebud West', 'AU', 'VIC'),
(5302, 14, 212, 'Rosedale', 'AU', 'VIC'),
(5303, 14, 212, 'Ross Creek', 'AU', 'VIC'),
(5304, 14, 212, 'Rowville', 'AU', 'VIC'),
(5305, 14, 212, 'Roxburgh Park', 'AU', 'VIC'),
(5306, 14, 212, 'Rushworth', 'AU', 'VIC'),
(5307, 14, 212, 'Rutherglen', 'AU', 'VIC'),
(5308, 14, 212, 'Rye', 'AU', 'VIC'),
(5309, 14, 212, 'Safety Beach', 'AU', 'VIC'),
(5310, 14, 212, 'Saint Albans', 'AU', 'VIC'),
(5311, 14, 212, 'Saint Andrews', 'AU', 'VIC'),
(5312, 14, 212, 'Saint Andrews Beach', 'AU', 'VIC'),
(5313, 14, 212, 'Saint Helena', 'AU', 'VIC'),
(5314, 14, 212, 'Saint Kilda', 'AU', 'VIC'),
(5315, 14, 212, 'Saint Leonards', 'AU', 'VIC'),
(5316, 14, 212, 'Sale', 'AU', 'VIC'),
(5317, 14, 212, 'San Remo', 'AU', 'VIC'),
(5318, 14, 212, 'Sandhurst', 'AU', 'VIC'),
(5319, 14, 212, 'Sandringham', 'AU', 'VIC'),
(5320, 14, 212, 'Sassafras', 'AU', 'VIC'),
(5321, 14, 212, 'Scoresby', 'AU', 'VIC'),
(5322, 14, 212, 'Seabrook', 'AU', 'VIC'),
(5323, 14, 212, 'Seaford', 'AU', 'VIC'),
(5324, 14, 212, 'Seaholme', 'AU', 'VIC'),
(5325, 14, 212, 'Sebastopol', 'AU', 'VIC'),
(5326, 14, 212, 'Seddon', 'AU', 'VIC'),
(5327, 14, 212, 'Selby', 'AU', 'VIC'),
(5328, 14, 212, 'Seville', 'AU', 'VIC'),
(5329, 14, 212, 'Seymour', 'AU', 'VIC'),
(5330, 14, 212, 'Shepparton', 'AU', 'VIC'),
(5331, 14, 212, 'Shepparton East', 'AU', 'VIC'),
(5332, 14, 212, 'Silvan', 'AU', 'VIC'),
(5333, 14, 212, 'Skye', 'AU', 'VIC'),
(5334, 14, 212, 'Smythes Creek', 'AU', 'VIC'),
(5335, 14, 212, 'Smythesdale', 'AU', 'VIC'),
(5336, 14, 212, 'Soldiers Hill', 'AU', 'VIC'),
(5337, 14, 212, 'Somers', 'AU', 'VIC'),
(5338, 14, 212, 'Somerville', 'AU', 'VIC'),
(5339, 14, 212, 'Sorrento', 'AU', 'VIC'),
(5340, 14, 212, 'South Gippsland', 'AU', 'VIC'),
(5341, 14, 212, 'South Kingsville', 'AU', 'VIC'),
(5342, 14, 212, 'South Melbourne', 'AU', 'VIC'),
(5343, 14, 212, 'South Morang', 'AU', 'VIC'),
(5344, 14, 212, 'South Yarra', 'AU', 'VIC'),
(5345, 14, 212, 'Southbank', 'AU', 'VIC'),
(5346, 14, 212, 'Southern Grampians', 'AU', 'VIC'),
(5347, 14, 212, 'Spotswood', 'AU', 'VIC'),
(5348, 14, 212, 'Springvale', 'AU', 'VIC'),
(5349, 14, 212, 'Springvale South', 'AU', 'VIC'),
(5350, 14, 212, 'St Albans Park', 'AU', 'VIC'),
(5351, 14, 212, 'St Helena', 'AU', 'VIC'),
(5352, 14, 212, 'St Kilda East', 'AU', 'VIC'),
(5353, 14, 212, 'St Kilda West', 'AU', 'VIC'),
(5354, 14, 212, 'Stawell', 'AU', 'VIC'),
(5355, 14, 212, 'Stonnington', 'AU', 'VIC'),
(5356, 14, 212, 'Stratford', 'AU', 'VIC'),
(5357, 14, 212, 'Strathbogie', 'AU', 'VIC'),
(5358, 14, 212, 'Strathdale', 'AU', 'VIC'),
(5359, 14, 212, 'Strathfieldsaye', 'AU', 'VIC'),
(5360, 14, 212, 'Strathmerton', 'AU', 'VIC'),
(5361, 14, 212, 'Strathmore', 'AU', 'VIC'),
(5362, 14, 212, 'Sunbury', 'AU', 'VIC'),
(5363, 14, 212, 'Sunshine', 'AU', 'VIC'),
(5364, 14, 212, 'Sunshine North', 'AU', 'VIC'),
(5365, 14, 212, 'Sunshine West', 'AU', 'VIC'),
(5366, 14, 212, 'Surf Coast', 'AU', 'VIC'),
(5367, 14, 212, 'Surrey Hills', 'AU', 'VIC'),
(5368, 14, 212, 'Swan Hill', 'AU', 'VIC'),
(5369, 14, 212, 'Sydenham', 'AU', 'VIC'),
(5370, 14, 212, 'Tallangatta', 'AU', 'VIC'),
(5371, 14, 212, 'Tarneit', 'AU', 'VIC'),
(5372, 14, 212, 'Tatura', 'AU', 'VIC'),
(5373, 14, 212, 'Taylors Hill', 'AU', 'VIC'),
(5374, 14, 212, 'Taylors Lakes', 'AU', 'VIC'),
(5375, 14, 212, 'Tecoma', 'AU', 'VIC'),
(5376, 14, 212, 'Teesdale', 'AU', 'VIC'),
(5377, 14, 212, 'Templestowe', 'AU', 'VIC'),
(5378, 14, 212, 'Templestowe Lower', 'AU', 'VIC'),
(5379, 14, 212, 'Terang', 'AU', 'VIC'),
(5380, 14, 212, 'The Basin', 'AU', 'VIC'),
(5381, 14, 212, 'The Patch', 'AU', 'VIC'),
(5382, 14, 212, 'Thomastown', 'AU', 'VIC'),
(5383, 14, 212, 'Thomson', 'AU', 'VIC'),
(5384, 14, 212, 'Thornbury', 'AU', 'VIC'),
(5385, 14, 212, 'Timboon', 'AU', 'VIC'),
(5386, 14, 212, 'Tongala', 'AU', 'VIC'),
(5387, 14, 212, 'Tooradin', 'AU', 'VIC'),
(5388, 14, 212, 'Toorak', 'AU', 'VIC'),
(5389, 14, 212, 'Tootgarook', 'AU', 'VIC'),
(5390, 14, 212, 'Torquay', 'AU', 'VIC'),
(5391, 14, 212, 'Towong', 'AU', 'VIC'),
(5392, 14, 212, 'Trafalgar', 'AU', 'VIC'),
(5393, 14, 212, 'Traralgon', 'AU', 'VIC'),
(5394, 14, 212, 'Travancore', 'AU', 'VIC'),
(5395, 14, 212, 'Trentham', 'AU', 'VIC'),
(5396, 14, 212, 'Truganina', 'AU', 'VIC'),
(5397, 14, 212, 'Tullamarine', 'AU', 'VIC'),
(5398, 14, 212, 'Tyabb', 'AU', 'VIC'),
(5399, 14, 212, 'Upwey', 'AU', 'VIC'),
(5400, 14, 212, 'Vermont', 'AU', 'VIC'),
(5401, 14, 212, 'Vermont South', 'AU', 'VIC'),
(5402, 14, 212, 'Viewbank', 'AU', 'VIC'),
(5403, 14, 212, 'Wahgunyah', 'AU', 'VIC'),
(5404, 14, 212, 'Wallan', 'AU', 'VIC'),
(5405, 14, 212, 'Wallington', 'AU', 'VIC'),
(5406, 14, 212, 'Wandana Heights', 'AU', 'VIC'),
(5407, 14, 212, 'Wandin North', 'AU', 'VIC'),
(5408, 14, 212, 'Wandong', 'AU', 'VIC'),
(5409, 14, 212, 'Wangaratta', 'AU', 'VIC'),
(5410, 14, 212, 'Wantirna', 'AU', 'VIC'),
(5411, 14, 212, 'Wantirna South', 'AU', 'VIC'),
(5412, 14, 212, 'Warburton', 'AU', 'VIC'),
(5413, 14, 212, 'Warracknabeal', 'AU', 'VIC'),
(5414, 14, 212, 'Warragul', 'AU', 'VIC'),
(5415, 14, 212, 'Warrandyte', 'AU', 'VIC'),
(5416, 14, 212, 'Warranwood', 'AU', 'VIC'),
(5417, 14, 212, 'Warrnambool', 'AU', 'VIC'),
(5418, 14, 212, 'Waterways', 'AU', 'VIC'),
(5419, 14, 212, 'Watsonia', 'AU', 'VIC'),
(5420, 14, 212, 'Watsonia North', 'AU', 'VIC'),
(5421, 14, 212, 'Wattleglen', 'AU', 'VIC'),
(5422, 14, 212, 'Waurn Ponds', 'AU', 'VIC'),
(5423, 14, 212, 'Wellington', 'AU', 'VIC'),
(5424, 14, 212, 'Wendouree', 'AU', 'VIC'),
(5425, 14, 212, 'Werribee', 'AU', 'VIC'),
(5426, 14, 212, 'Werribee South', 'AU', 'VIC'),
(5427, 14, 212, 'Wesburn', 'AU', 'VIC'),
(5428, 14, 212, 'West Footscray', 'AU', 'VIC'),
(5429, 14, 212, 'West Melbourne', 'AU', 'VIC'),
(5430, 14, 212, 'West Wimmera', 'AU', 'VIC'),
(5431, 14, 212, 'West Wodonga', 'AU', 'VIC'),
(5432, 14, 212, 'Westmeadows', 'AU', 'VIC'),
(5433, 14, 212, 'Wheelers Hill', 'AU', 'VIC'),
(5434, 14, 212, 'White Hills', 'AU', 'VIC'),
(5435, 14, 212, 'Whitehorse', 'AU', 'VIC'),
(5436, 14, 212, 'Whittington', 'AU', 'VIC'),
(5437, 14, 212, 'Whittlesea', 'AU', 'VIC'),
(5438, 14, 212, 'Williams Landing', 'AU', 'VIC'),
(5439, 14, 212, 'Williamstown', 'AU', 'VIC'),
(5440, 14, 212, 'Williamstown North', 'AU', 'VIC'),
(5441, 14, 212, 'Winchelsea', 'AU', 'VIC'),
(5442, 14, 212, 'Windsor', 'AU', 'VIC'),
(5443, 14, 212, 'Wodonga', 'AU', 'VIC'),
(5444, 14, 212, 'Wollert', 'AU', 'VIC'),
(5445, 14, 212, 'Wonga Park', 'AU', 'VIC'),
(5446, 14, 212, 'Wonthaggi', 'AU', 'VIC'),
(5447, 14, 212, 'Woodend', 'AU', 'VIC'),
(5448, 14, 212, 'Woori Yallock', 'AU', 'VIC'),
(5449, 14, 212, 'Wurruk', 'AU', 'VIC'),
(5450, 14, 212, 'Wy Yung', 'AU', 'VIC'),
(5451, 14, 212, 'Wyndham', 'AU', 'VIC'),
(5452, 14, 212, 'Wyndham Vale', 'AU', 'VIC'),
(5453, 14, 212, 'Yackandandah', 'AU', 'VIC'),
(5454, 14, 212, 'Yallambie', 'AU', 'VIC'),
(5455, 14, 212, 'Yallourn North', 'AU', 'VIC'),
(5456, 14, 212, 'Yarra', 'AU', 'VIC'),
(5457, 14, 212, 'Yarra Glen', 'AU', 'VIC'),
(5458, 14, 212, 'Yarra Junction', 'AU', 'VIC'),
(5459, 14, 212, 'Yarra Ranges', 'AU', 'VIC'),
(5460, 14, 212, 'Yarragon', 'AU', 'VIC'),
(5461, 14, 212, 'Yarram', 'AU', 'VIC'),
(5462, 14, 212, 'Yarrambat', 'AU', 'VIC'),
(5463, 14, 212, 'Yarraville', 'AU', 'VIC'),
(5464, 14, 212, 'Yarrawonga', 'AU', 'VIC'),
(5465, 14, 212, 'Yarriambiack', 'AU', 'VIC'),
(5466, 14, 212, 'Yea', 'AU', 'VIC'),
(5467, 14, 213, 'Abbey', 'AU', 'WA'),
(5468, 14, 213, 'Albany', 'AU', 'WA'),
(5469, 14, 213, 'Albany city centre', 'AU', 'WA'),
(5470, 14, 213, 'Alexander Heights', 'AU', 'WA'),
(5471, 14, 213, 'Alfred Cove', 'AU', 'WA'),
(5472, 14, 213, 'Alkimos', 'AU', 'WA'),
(5473, 14, 213, 'Applecross', 'AU', 'WA'),
(5474, 14, 213, 'Ardross', 'AU', 'WA'),
(5475, 14, 213, 'Armadale', 'AU', 'WA'),
(5476, 14, 213, 'Ascot', 'AU', 'WA'),
(5477, 14, 213, 'Ashburton', 'AU', 'WA'),
(5478, 14, 213, 'Ashby', 'AU', 'WA'),
(5479, 14, 213, 'Ashfield', 'AU', 'WA'),
(5480, 14, 213, 'Attadale', 'AU', 'WA'),
(5481, 14, 213, 'Atwell', 'AU', 'WA'),
(5482, 14, 213, 'Aubin Grove', 'AU', 'WA'),
(5483, 14, 213, 'Augusta', 'AU', 'WA'),
(5484, 14, 213, 'Augusta-Margaret River Shire', 'AU', 'WA'),
(5485, 14, 213, 'Australind', 'AU', 'WA'),
(5486, 14, 213, 'Aveley', 'AU', 'WA'),
(5487, 14, 213, 'Badgingarra', 'AU', 'WA'),
(5488, 14, 213, 'Bakers Hill', 'AU', 'WA'),
(5489, 14, 213, 'Balcatta', 'AU', 'WA'),
(5490, 14, 213, 'Baldivis', 'AU', 'WA'),
(5491, 14, 213, 'Balga', 'AU', 'WA'),
(5492, 14, 213, 'Ballajura', 'AU', 'WA'),
(5493, 14, 213, 'Banjup', 'AU', 'WA'),
(5494, 14, 213, 'Banksia Grove', 'AU', 'WA'),
(5495, 14, 213, 'Bassendean', 'AU', 'WA'),
(5496, 14, 213, 'Bateman', 'AU', 'WA'),
(5497, 14, 213, 'Baynton', 'AU', 'WA'),
(5498, 14, 213, 'Bayonet Head', 'AU', 'WA'),
(5499, 14, 213, 'Bayswater', 'AU', 'WA'),
(5500, 14, 213, 'Beachlands', 'AU', 'WA');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(5501, 14, 213, 'Beaconsfield', 'AU', 'WA'),
(5502, 14, 213, 'Beckenham', 'AU', 'WA'),
(5503, 14, 213, 'Bedford', 'AU', 'WA'),
(5504, 14, 213, 'Bedfordale', 'AU', 'WA'),
(5505, 14, 213, 'Beechboro', 'AU', 'WA'),
(5506, 14, 213, 'Beeliar', 'AU', 'WA'),
(5507, 14, 213, 'Beldon', 'AU', 'WA'),
(5508, 14, 213, 'Bellevue', 'AU', 'WA'),
(5509, 14, 213, 'Belmont', 'AU', 'WA'),
(5510, 14, 213, 'Bennett Springs', 'AU', 'WA'),
(5511, 14, 213, 'Bentley', 'AU', 'WA'),
(5512, 14, 213, 'Beresford', 'AU', 'WA'),
(5513, 14, 213, 'Bertram', 'AU', 'WA'),
(5514, 14, 213, 'Beverley', 'AU', 'WA'),
(5515, 14, 213, 'Bibra Lake', 'AU', 'WA'),
(5516, 14, 213, 'Bicton', 'AU', 'WA'),
(5517, 14, 213, 'Bilingurr', 'AU', 'WA'),
(5518, 14, 213, 'Bindoon', 'AU', 'WA'),
(5519, 14, 213, 'Binningup', 'AU', 'WA'),
(5520, 14, 213, 'Bluff Point', 'AU', 'WA'),
(5521, 14, 213, 'Boddington', 'AU', 'WA'),
(5522, 14, 213, 'Booragoon', 'AU', 'WA'),
(5523, 14, 213, 'Boulder', 'AU', 'WA'),
(5524, 14, 213, 'Boyanup', 'AU', 'WA'),
(5525, 14, 213, 'Boyup Brook', 'AU', 'WA'),
(5526, 14, 213, 'Brabham', 'AU', 'WA'),
(5527, 14, 213, 'Brentwood', 'AU', 'WA'),
(5528, 14, 213, 'Bridgetown', 'AU', 'WA'),
(5529, 14, 213, 'Bridgetown-Greenbushes', 'AU', 'WA'),
(5530, 14, 213, 'Broadwater', 'AU', 'WA'),
(5531, 14, 213, 'Brockman', 'AU', 'WA'),
(5532, 14, 213, 'Brookdale', 'AU', 'WA'),
(5533, 14, 213, 'Brookton', 'AU', 'WA'),
(5534, 14, 213, 'Broome', 'AU', 'WA'),
(5535, 14, 213, 'Broomehill-Tambellup', 'AU', 'WA'),
(5536, 14, 213, 'Bruce Rock', 'AU', 'WA'),
(5537, 14, 213, 'Brunswick', 'AU', 'WA'),
(5538, 14, 213, 'Bulgarra', 'AU', 'WA'),
(5539, 14, 213, 'Bull Creek', 'AU', 'WA'),
(5540, 14, 213, 'Bullsbrook', 'AU', 'WA'),
(5541, 14, 213, 'Bunbury', 'AU', 'WA'),
(5542, 14, 213, 'Burns Beach', 'AU', 'WA'),
(5543, 14, 213, 'Burswood', 'AU', 'WA'),
(5544, 14, 213, 'Busselton', 'AU', 'WA'),
(5545, 14, 213, 'Busselton city cenre', 'AU', 'WA'),
(5546, 14, 213, 'Butler', 'AU', 'WA'),
(5547, 14, 213, 'Byford', 'AU', 'WA'),
(5548, 14, 213, 'Cable Beach', 'AU', 'WA'),
(5549, 14, 213, 'Calista', 'AU', 'WA'),
(5550, 14, 213, 'Cambridge', 'AU', 'WA'),
(5551, 14, 213, 'Camillo', 'AU', 'WA'),
(5552, 14, 213, 'Canning', 'AU', 'WA'),
(5553, 14, 213, 'Canning Vale', 'AU', 'WA'),
(5554, 14, 213, 'Cannington', 'AU', 'WA'),
(5555, 14, 213, 'Capel', 'AU', 'WA'),
(5556, 14, 213, 'Cardup', 'AU', 'WA'),
(5557, 14, 213, 'Carey Park', 'AU', 'WA'),
(5558, 14, 213, 'Carine', 'AU', 'WA'),
(5559, 14, 213, 'Carlisle', 'AU', 'WA'),
(5560, 14, 213, 'Carnamah', 'AU', 'WA'),
(5561, 14, 213, 'Carnarvon', 'AU', 'WA'),
(5562, 14, 213, 'Carramar', 'AU', 'WA'),
(5563, 14, 213, 'Castletown', 'AU', 'WA'),
(5564, 14, 213, 'Casuarina', 'AU', 'WA'),
(5565, 14, 213, 'Cataby', 'AU', 'WA'),
(5566, 14, 213, 'Caversham', 'AU', 'WA'),
(5567, 14, 213, 'Cervantes', 'AU', 'WA'),
(5568, 14, 213, 'Champion Lakes', 'AU', 'WA'),
(5569, 14, 213, 'Chapman Valley', 'AU', 'WA'),
(5570, 14, 213, 'Chidlow', 'AU', 'WA'),
(5571, 14, 213, 'Chittering', 'AU', 'WA'),
(5572, 14, 213, 'Churchlands', 'AU', 'WA'),
(5573, 14, 213, 'City Beach', 'AU', 'WA'),
(5574, 14, 213, 'City of Cockburn', 'AU', 'WA'),
(5575, 14, 213, 'City of Perth', 'AU', 'WA'),
(5576, 14, 213, 'Claremont', 'AU', 'WA'),
(5577, 14, 213, 'Clarkson', 'AU', 'WA'),
(5578, 14, 213, 'Cloverdale', 'AU', 'WA'),
(5579, 14, 213, 'Cockburn Central', 'AU', 'WA'),
(5580, 14, 213, 'College Grove', 'AU', 'WA'),
(5581, 14, 213, 'Collie', 'AU', 'WA'),
(5582, 14, 213, 'Como', 'AU', 'WA'),
(5583, 14, 213, 'Connolly', 'AU', 'WA'),
(5584, 14, 213, 'Coodanup', 'AU', 'WA'),
(5585, 14, 213, 'Coogee', 'AU', 'WA'),
(5586, 14, 213, 'Coolbellup', 'AU', 'WA'),
(5587, 14, 213, 'Coolbinia', 'AU', 'WA'),
(5588, 14, 213, 'Coolgardie', 'AU', 'WA'),
(5589, 14, 213, 'Cooloongup', 'AU', 'WA'),
(5590, 14, 213, 'Coorow', 'AU', 'WA'),
(5591, 14, 213, 'Corrigin', 'AU', 'WA'),
(5592, 14, 213, 'Cottesloe', 'AU', 'WA'),
(5593, 14, 213, 'Cowaramup', 'AU', 'WA'),
(5594, 14, 213, 'Craigie', 'AU', 'WA'),
(5595, 14, 213, 'Cranbrook', 'AU', 'WA'),
(5596, 14, 213, 'Crawley', 'AU', 'WA'),
(5597, 14, 213, 'Cuballing', 'AU', 'WA'),
(5598, 14, 213, 'Cue', 'AU', 'WA'),
(5599, 14, 213, 'Cunderdin', 'AU', 'WA'),
(5600, 14, 213, 'Currambine', 'AU', 'WA'),
(5601, 14, 213, 'Daglish', 'AU', 'WA'),
(5602, 14, 213, 'Dalkeith', 'AU', 'WA'),
(5603, 14, 213, 'Dalwallinu', 'AU', 'WA'),
(5604, 14, 213, 'Dalyellup', 'AU', 'WA'),
(5605, 14, 213, 'Dampier', 'AU', 'WA'),
(5606, 14, 213, 'Dampier Peninsula', 'AU', 'WA'),
(5607, 14, 213, 'Dandaragan', 'AU', 'WA'),
(5608, 14, 213, 'Darch', 'AU', 'WA'),
(5609, 14, 213, 'Dardanup', 'AU', 'WA'),
(5610, 14, 213, 'Darling Downs', 'AU', 'WA'),
(5611, 14, 213, 'Darlington', 'AU', 'WA'),
(5612, 14, 213, 'Dawesville', 'AU', 'WA'),
(5613, 14, 213, 'Dayton', 'AU', 'WA'),
(5614, 14, 213, 'Denham', 'AU', 'WA'),
(5615, 14, 213, 'Denmark', 'AU', 'WA'),
(5616, 14, 213, 'Derby', 'AU', 'WA'),
(5617, 14, 213, 'Derby-West Kimberley', 'AU', 'WA'),
(5618, 14, 213, 'Dianella', 'AU', 'WA'),
(5619, 14, 213, 'Djugun', 'AU', 'WA'),
(5620, 14, 213, 'Dongara', 'AU', 'WA'),
(5621, 14, 213, 'Donnybrook', 'AU', 'WA'),
(5622, 14, 213, 'Donnybrook-Balingup', 'AU', 'WA'),
(5623, 14, 213, 'Doubleview', 'AU', 'WA'),
(5624, 14, 213, 'Dowerin', 'AU', 'WA'),
(5625, 14, 213, 'Drummond Cove', 'AU', 'WA'),
(5626, 14, 213, 'Dudley Park', 'AU', 'WA'),
(5627, 14, 213, 'Dumbleyung Shire', 'AU', 'WA'),
(5628, 14, 213, 'Duncraig', 'AU', 'WA'),
(5629, 14, 213, 'Dundas', 'AU', 'WA'),
(5630, 14, 213, 'Dunsborough', 'AU', 'WA'),
(5631, 14, 213, 'East Bunbury', 'AU', 'WA'),
(5632, 14, 213, 'East Cannington', 'AU', 'WA'),
(5633, 14, 213, 'East Carnarvon', 'AU', 'WA'),
(5634, 14, 213, 'East Fremantle', 'AU', 'WA'),
(5635, 14, 213, 'East Perth', 'AU', 'WA'),
(5636, 14, 213, 'East Pilbara', 'AU', 'WA'),
(5637, 14, 213, 'East Victoria Park', 'AU', 'WA'),
(5638, 14, 213, 'Eaton', 'AU', 'WA'),
(5639, 14, 213, 'Eden Hill', 'AU', 'WA'),
(5640, 14, 213, 'Edgewater', 'AU', 'WA'),
(5641, 14, 213, 'Eglinton', 'AU', 'WA'),
(5642, 14, 213, 'Ellenbrook', 'AU', 'WA'),
(5643, 14, 213, 'Embleton', 'AU', 'WA'),
(5644, 14, 213, 'Erskine', 'AU', 'WA'),
(5645, 14, 213, 'Esperance', 'AU', 'WA'),
(5646, 14, 213, 'Esperance Shire', 'AU', 'WA'),
(5647, 14, 213, 'Exmouth', 'AU', 'WA'),
(5648, 14, 213, 'Falcon', 'AU', 'WA'),
(5649, 14, 213, 'Ferndale', 'AU', 'WA'),
(5650, 14, 213, 'Fitzroy Crossing', 'AU', 'WA'),
(5651, 14, 213, 'Floreat', 'AU', 'WA'),
(5652, 14, 213, 'Forrestdale', 'AU', 'WA'),
(5653, 14, 213, 'Forrestfield', 'AU', 'WA'),
(5654, 14, 213, 'Fremantle', 'AU', 'WA'),
(5655, 14, 213, 'Garden Island', 'AU', 'WA'),
(5656, 14, 213, 'Gelorup', 'AU', 'WA'),
(5657, 14, 213, 'Geographe', 'AU', 'WA'),
(5658, 14, 213, 'Geraldton', 'AU', 'WA'),
(5659, 14, 213, 'Geraldton city centre', 'AU', 'WA'),
(5660, 14, 213, 'Gidgegannup', 'AU', 'WA'),
(5661, 14, 213, 'Gingin', 'AU', 'WA'),
(5662, 14, 213, 'Girrawheen', 'AU', 'WA'),
(5663, 14, 213, 'Glen Forrest', 'AU', 'WA'),
(5664, 14, 213, 'Glen Iris', 'AU', 'WA'),
(5665, 14, 213, 'Glendalough', 'AU', 'WA'),
(5666, 14, 213, 'Gnangara', 'AU', 'WA'),
(5667, 14, 213, 'Gnowangerup', 'AU', 'WA'),
(5668, 14, 213, 'Golden Bay', 'AU', 'WA'),
(5669, 14, 213, 'Goomalling', 'AU', 'WA'),
(5670, 14, 213, 'Gooseberry Hill', 'AU', 'WA'),
(5671, 14, 213, 'Gosnells', 'AU', 'WA'),
(5672, 14, 213, 'Grasmere', 'AU', 'WA'),
(5673, 14, 213, 'Green Head', 'AU', 'WA'),
(5674, 14, 213, 'Greenfields', 'AU', 'WA'),
(5675, 14, 213, 'Greenmount', 'AU', 'WA'),
(5676, 14, 213, 'Greenwood', 'AU', 'WA'),
(5677, 14, 213, 'Guildford', 'AU', 'WA'),
(5678, 14, 213, 'Gwelup', 'AU', 'WA'),
(5679, 14, 213, 'Halls Creek', 'AU', 'WA'),
(5680, 14, 213, 'Halls Head', 'AU', 'WA'),
(5681, 14, 213, 'Hamersley', 'AU', 'WA'),
(5682, 14, 213, 'Hamilton Hill', 'AU', 'WA'),
(5683, 14, 213, 'Hammond Park', 'AU', 'WA'),
(5684, 14, 213, 'Hannans', 'AU', 'WA'),
(5685, 14, 213, 'Harrisdale', 'AU', 'WA'),
(5686, 14, 213, 'Harvey', 'AU', 'WA'),
(5687, 14, 213, 'Heathridge', 'AU', 'WA'),
(5688, 14, 213, 'Helena Valley', 'AU', 'WA'),
(5689, 14, 213, 'Henley Brook', 'AU', 'WA'),
(5690, 14, 213, 'Herne Hill', 'AU', 'WA'),
(5691, 14, 213, 'High Wycombe', 'AU', 'WA'),
(5692, 14, 213, 'Highgate', 'AU', 'WA'),
(5693, 14, 213, 'Hilbert', 'AU', 'WA'),
(5694, 14, 213, 'Hill River', 'AU', 'WA'),
(5695, 14, 213, 'Hillarys', 'AU', 'WA'),
(5696, 14, 213, 'Hillman', 'AU', 'WA'),
(5697, 14, 213, 'Hilton', 'AU', 'WA'),
(5698, 14, 213, 'Hocking', 'AU', 'WA'),
(5699, 14, 213, 'Huntingdale', 'AU', 'WA'),
(5700, 14, 213, 'Iluka', 'AU', 'WA'),
(5701, 14, 213, 'Inglewood', 'AU', 'WA'),
(5702, 14, 213, 'Innaloo', 'AU', 'WA'),
(5703, 14, 213, 'Irwin', 'AU', 'WA'),
(5704, 14, 213, 'Jandakot', 'AU', 'WA'),
(5705, 14, 213, 'Jane Brook', 'AU', 'WA'),
(5706, 14, 213, 'Jarrahdale', 'AU', 'WA'),
(5707, 14, 213, 'Jerramungup', 'AU', 'WA'),
(5708, 14, 213, 'Jindalee', 'AU', 'WA'),
(5709, 14, 213, 'Jolimont', 'AU', 'WA'),
(5710, 14, 213, 'Joondalup', 'AU', 'WA'),
(5711, 14, 213, 'Joondanna', 'AU', 'WA'),
(5712, 14, 213, 'Jurien Bay', 'AU', 'WA'),
(5713, 14, 213, 'Kalamunda', 'AU', 'WA'),
(5714, 14, 213, 'Kalbarri', 'AU', 'WA'),
(5715, 14, 213, 'Kalgoorlie', 'AU', 'WA'),
(5716, 14, 213, 'Kalgoorlie/Boulder', 'AU', 'WA'),
(5717, 14, 213, 'Kallaroo', 'AU', 'WA'),
(5718, 14, 213, 'Kambalda East', 'AU', 'WA'),
(5719, 14, 213, 'Kambalda West', 'AU', 'WA'),
(5720, 14, 213, 'Karawara', 'AU', 'WA'),
(5721, 14, 213, 'Kardinya', 'AU', 'WA'),
(5722, 14, 213, 'Karnup', 'AU', 'WA'),
(5723, 14, 213, 'Karratha', 'AU', 'WA'),
(5724, 14, 213, 'Karrinyup', 'AU', 'WA'),
(5725, 14, 213, 'Katanning', 'AU', 'WA'),
(5726, 14, 213, 'Kellerberrin', 'AU', 'WA'),
(5727, 14, 213, 'Kelmscott', 'AU', 'WA'),
(5728, 14, 213, 'Kent Shire', 'AU', 'WA'),
(5729, 14, 213, 'Kenwick', 'AU', 'WA'),
(5730, 14, 213, 'Kewdale', 'AU', 'WA'),
(5731, 14, 213, 'Kiara', 'AU', 'WA'),
(5732, 14, 213, 'Kingsley', 'AU', 'WA'),
(5733, 14, 213, 'Kinross', 'AU', 'WA'),
(5734, 14, 213, 'Kojonup', 'AU', 'WA'),
(5735, 14, 213, 'Kondinin', 'AU', 'WA'),
(5736, 14, 213, 'Koondoola', 'AU', 'WA'),
(5737, 14, 213, 'Koorda', 'AU', 'WA'),
(5738, 14, 213, 'Kulin', 'AU', 'WA'),
(5739, 14, 213, 'Kununurra', 'AU', 'WA'),
(5740, 14, 213, 'Kwinana', 'AU', 'WA'),
(5741, 14, 213, 'Lake Grace', 'AU', 'WA'),
(5742, 14, 213, 'Lakelands', 'AU', 'WA'),
(5743, 14, 213, 'Lamington', 'AU', 'WA'),
(5744, 14, 213, 'Lancelin', 'AU', 'WA'),
(5745, 14, 213, 'Landsdale', 'AU', 'WA'),
(5746, 14, 213, 'Langford', 'AU', 'WA'),
(5747, 14, 213, 'Lathlain', 'AU', 'WA'),
(5748, 14, 213, 'Laverton', 'AU', 'WA'),
(5749, 14, 213, 'Leda', 'AU', 'WA'),
(5750, 14, 213, 'Leederville', 'AU', 'WA'),
(5751, 14, 213, 'Leeman', 'AU', 'WA'),
(5752, 14, 213, 'Leeming', 'AU', 'WA'),
(5753, 14, 213, 'Leinster', 'AU', 'WA'),
(5754, 14, 213, 'Leonora', 'AU', 'WA'),
(5755, 14, 213, 'Leschenault', 'AU', 'WA'),
(5756, 14, 213, 'Lesmurdie', 'AU', 'WA'),
(5757, 14, 213, 'Little Grove', 'AU', 'WA'),
(5758, 14, 213, 'Lockridge', 'AU', 'WA'),
(5759, 14, 213, 'Lockyer', 'AU', 'WA'),
(5760, 14, 213, 'Lower Chittering', 'AU', 'WA'),
(5761, 14, 213, 'Lower King', 'AU', 'WA'),
(5762, 14, 213, 'Lynwood', 'AU', 'WA'),
(5763, 14, 213, 'Maddington', 'AU', 'WA'),
(5764, 14, 213, 'Madeley', 'AU', 'WA'),
(5765, 14, 213, 'Madora Bay', 'AU', 'WA'),
(5766, 14, 213, 'Maida Vale', 'AU', 'WA'),
(5767, 14, 213, 'Malaga', 'AU', 'WA'),
(5768, 14, 213, 'Mandurah', 'AU', 'WA'),
(5769, 14, 213, 'Mandurah city centre', 'AU', 'WA'),
(5770, 14, 213, 'Manjimup', 'AU', 'WA'),
(5771, 14, 213, 'Manning', 'AU', 'WA'),
(5772, 14, 213, 'Marangaroo', 'AU', 'WA'),
(5773, 14, 213, 'Marble Bar', 'AU', 'WA'),
(5774, 14, 213, 'Margaret River', 'AU', 'WA'),
(5775, 14, 213, 'Marmion', 'AU', 'WA'),
(5776, 14, 213, 'Martin', 'AU', 'WA'),
(5777, 14, 213, 'Maylands', 'AU', 'WA'),
(5778, 14, 213, 'McKail', 'AU', 'WA'),
(5779, 14, 213, 'Meadow Springs', 'AU', 'WA'),
(5780, 14, 213, 'Medina', 'AU', 'WA'),
(5781, 14, 213, 'Meekatharra', 'AU', 'WA'),
(5782, 14, 213, 'Melville', 'AU', 'WA'),
(5783, 14, 213, 'Menora', 'AU', 'WA'),
(5784, 14, 213, 'Menzies', 'AU', 'WA'),
(5785, 14, 213, 'Merredin', 'AU', 'WA'),
(5786, 14, 213, 'Merriwa', 'AU', 'WA'),
(5787, 14, 213, 'Middle Swan', 'AU', 'WA'),
(5788, 14, 213, 'Midland', 'AU', 'WA'),
(5789, 14, 213, 'Midvale', 'AU', 'WA'),
(5790, 14, 213, 'Millars Well', 'AU', 'WA'),
(5791, 14, 213, 'Millbridge', 'AU', 'WA'),
(5792, 14, 213, 'Mindarie', 'AU', 'WA'),
(5793, 14, 213, 'Mingenew', 'AU', 'WA'),
(5794, 14, 213, 'Mira Mar', 'AU', 'WA'),
(5795, 14, 213, 'Mirrabooka', 'AU', 'WA'),
(5796, 14, 213, 'Moora', 'AU', 'WA'),
(5797, 14, 213, 'Morawa', 'AU', 'WA'),
(5798, 14, 213, 'Morley', 'AU', 'WA'),
(5799, 14, 213, 'Mosman Park', 'AU', 'WA'),
(5800, 14, 213, 'Mount Barker', 'AU', 'WA'),
(5801, 14, 213, 'Mount Claremont', 'AU', 'WA'),
(5802, 14, 213, 'Mount Hawthorn', 'AU', 'WA'),
(5803, 14, 213, 'Mount Helena', 'AU', 'WA'),
(5804, 14, 213, 'Mount Lawley', 'AU', 'WA'),
(5805, 14, 213, 'Mount Magnet', 'AU', 'WA'),
(5806, 14, 213, 'Mount Marshall', 'AU', 'WA'),
(5807, 14, 213, 'Mount Melville', 'AU', 'WA'),
(5808, 14, 213, 'Mount Nasura', 'AU', 'WA'),
(5809, 14, 213, 'Mount Pleasant', 'AU', 'WA'),
(5810, 14, 213, 'Mount Richon', 'AU', 'WA'),
(5811, 14, 213, 'Mount Tarcoola', 'AU', 'WA'),
(5812, 14, 213, 'Muchea', 'AU', 'WA'),
(5813, 14, 213, 'Mukinbudin', 'AU', 'WA'),
(5814, 14, 213, 'Mullaloo', 'AU', 'WA'),
(5815, 14, 213, 'Mundaring', 'AU', 'WA'),
(5816, 14, 213, 'Mundijong', 'AU', 'WA'),
(5817, 14, 213, 'Munster', 'AU', 'WA'),
(5818, 14, 213, 'Murchison', 'AU', 'WA'),
(5819, 14, 213, 'Murdoch', 'AU', 'WA'),
(5820, 14, 213, 'Murray', 'AU', 'WA'),
(5821, 14, 213, 'Myaree', 'AU', 'WA'),
(5822, 14, 213, 'Nannup', 'AU', 'WA'),
(5823, 14, 213, 'Narembeen', 'AU', 'WA'),
(5824, 14, 213, 'Narrogin', 'AU', 'WA'),
(5825, 14, 213, 'Nedlands', 'AU', 'WA'),
(5826, 14, 213, 'Newman', 'AU', 'WA'),
(5827, 14, 213, 'Ngaanyatjarraku', 'AU', 'WA'),
(5828, 14, 213, 'Nickol', 'AU', 'WA'),
(5829, 14, 213, 'Nollamara', 'AU', 'WA'),
(5830, 14, 213, 'Noranda', 'AU', 'WA'),
(5831, 14, 213, 'North Beach', 'AU', 'WA'),
(5832, 14, 213, 'North Coogee', 'AU', 'WA'),
(5833, 14, 213, 'North Fremantle', 'AU', 'WA'),
(5834, 14, 213, 'North Lake', 'AU', 'WA'),
(5835, 14, 213, 'North Perth', 'AU', 'WA'),
(5836, 14, 213, 'Northam', 'AU', 'WA'),
(5837, 14, 213, 'Northampton Shire', 'AU', 'WA'),
(5838, 14, 213, 'Northbridge', 'AU', 'WA'),
(5839, 14, 213, 'Nullagine', 'AU', 'WA'),
(5840, 14, 213, 'Nulsen', 'AU', 'WA'),
(5841, 14, 213, 'Nungarin', 'AU', 'WA'),
(5842, 14, 213, 'Oakford', 'AU', 'WA'),
(5843, 14, 213, 'Ocean Reef', 'AU', 'WA'),
(5844, 14, 213, 'Onslow', 'AU', 'WA'),
(5845, 14, 213, 'Orana', 'AU', 'WA'),
(5846, 14, 213, 'Orelia', 'AU', 'WA'),
(5847, 14, 213, 'Osborne Park', 'AU', 'WA'),
(5848, 14, 213, 'Padbury', 'AU', 'WA'),
(5849, 14, 213, 'Palmyra', 'AU', 'WA'),
(5850, 14, 213, 'Paraburdoo', 'AU', 'WA'),
(5851, 14, 213, 'Parkerville', 'AU', 'WA'),
(5852, 14, 213, 'Parkwood', 'AU', 'WA'),
(5853, 14, 213, 'Parmelia', 'AU', 'WA'),
(5854, 14, 213, 'Pearce', 'AU', 'WA'),
(5855, 14, 213, 'Pearsall', 'AU', 'WA'),
(5856, 14, 213, 'Pegs Creek', 'AU', 'WA'),
(5857, 14, 213, 'Pemberton', 'AU', 'WA'),
(5858, 14, 213, 'Peppermint Grove', 'AU', 'WA'),
(5859, 14, 213, 'Perenjori', 'AU', 'WA'),
(5860, 14, 213, 'Perth', 'AU', 'WA'),
(5861, 14, 213, 'Perth city centre', 'AU', 'WA'),
(5862, 14, 213, 'Piara Waters', 'AU', 'WA'),
(5863, 14, 213, 'Piccadilly', 'AU', 'WA'),
(5864, 14, 213, 'Pingelly', 'AU', 'WA'),
(5865, 14, 213, 'Pinjarra', 'AU', 'WA'),
(5866, 14, 213, 'Plantagenet Shire', 'AU', 'WA'),
(5867, 14, 213, 'Port Denison', 'AU', 'WA'),
(5868, 14, 213, 'Port Hedland', 'AU', 'WA'),
(5869, 14, 213, 'Port Kennedy', 'AU', 'WA'),
(5870, 14, 213, 'Quairading', 'AU', 'WA'),
(5871, 14, 213, 'Queens Park', 'AU', 'WA'),
(5872, 14, 213, 'Quindalup', 'AU', 'WA'),
(5873, 14, 213, 'Quinns Rocks', 'AU', 'WA'),
(5874, 14, 213, 'Rangeway', 'AU', 'WA'),
(5875, 14, 213, 'Ravensthorpe', 'AU', 'WA'),
(5876, 14, 213, 'Ravenswood', 'AU', 'WA'),
(5877, 14, 213, 'Redcliffe', 'AU', 'WA'),
(5878, 14, 213, 'Regans Ford', 'AU', 'WA'),
(5879, 14, 213, 'Ridgewood', 'AU', 'WA'),
(5880, 14, 213, 'Riverton', 'AU', 'WA'),
(5881, 14, 213, 'Rivervale', 'AU', 'WA'),
(5882, 14, 213, 'Rockingham', 'AU', 'WA'),
(5883, 14, 213, 'Rockingham city centre', 'AU', 'WA'),
(5884, 14, 213, 'Roebuck', 'AU', 'WA'),
(5885, 14, 213, 'Roleystone', 'AU', 'WA'),
(5886, 14, 213, 'Rossmoyne', 'AU', 'WA'),
(5887, 14, 213, 'Safety Bay', 'AU', 'WA'),
(5888, 14, 213, 'Salter Point', 'AU', 'WA'),
(5889, 14, 213, 'Samson', 'AU', 'WA'),
(5890, 14, 213, 'Sandstone', 'AU', 'WA'),
(5891, 14, 213, 'Scarborough', 'AU', 'WA'),
(5892, 14, 213, 'Secret Harbour', 'AU', 'WA'),
(5893, 14, 213, 'Serpentine', 'AU', 'WA'),
(5894, 14, 213, 'Serpentine-Jarrahdale', 'AU', 'WA'),
(5895, 14, 213, 'Seville Grove', 'AU', 'WA'),
(5896, 14, 213, 'Shark Bay', 'AU', 'WA'),
(5897, 14, 213, 'Shelley', 'AU', 'WA'),
(5898, 14, 213, 'Shenton Park', 'AU', 'WA'),
(5899, 14, 213, 'Shoalwater', 'AU', 'WA'),
(5900, 14, 213, 'Silver Sands', 'AU', 'WA'),
(5901, 14, 213, 'Sinagra', 'AU', 'WA'),
(5902, 14, 213, 'Singleton', 'AU', 'WA'),
(5903, 14, 213, 'Somerville', 'AU', 'WA'),
(5904, 14, 213, 'Sorrento', 'AU', 'WA'),
(5905, 14, 213, 'South Bunbury', 'AU', 'WA'),
(5906, 14, 213, 'South Carnarvon', 'AU', 'WA'),
(5907, 14, 213, 'South Fremantle', 'AU', 'WA'),
(5908, 14, 213, 'South Guildford', 'AU', 'WA'),
(5909, 14, 213, 'South Hedland', 'AU', 'WA'),
(5910, 14, 213, 'South Kalgoorlie', 'AU', 'WA'),
(5911, 14, 213, 'South Lake', 'AU', 'WA'),
(5912, 14, 213, 'South Perth', 'AU', 'WA'),
(5913, 14, 213, 'South Yunderup', 'AU', 'WA'),
(5914, 14, 213, 'Southern River', 'AU', 'WA'),
(5915, 14, 213, 'Spalding', 'AU', 'WA'),
(5916, 14, 213, 'Spearwood', 'AU', 'WA'),
(5917, 14, 213, 'Spencer Park', 'AU', 'WA'),
(5918, 14, 213, 'St George Ranges', 'AU', 'WA'),
(5919, 14, 213, 'St James', 'AU', 'WA'),
(5920, 14, 213, 'Stirling', 'AU', 'WA'),
(5921, 14, 213, 'Stoneville', 'AU', 'WA'),
(5922, 14, 213, 'Strathalbyn', 'AU', 'WA'),
(5923, 14, 213, 'Stratton', 'AU', 'WA'),
(5924, 14, 213, 'Subiaco', 'AU', 'WA'),
(5925, 14, 213, 'Success', 'AU', 'WA'),
(5926, 14, 213, 'Sunset Beach', 'AU', 'WA'),
(5927, 14, 213, 'Swan', 'AU', 'WA'),
(5928, 14, 213, 'Swan View', 'AU', 'WA'),
(5929, 14, 213, 'Swanbourne', 'AU', 'WA'),
(5930, 14, 213, 'Tammin', 'AU', 'WA'),
(5931, 14, 213, 'Tapping', 'AU', 'WA'),
(5932, 14, 213, 'Tarcoola Beach', 'AU', 'WA'),
(5933, 14, 213, 'Telfer', 'AU', 'WA'),
(5934, 14, 213, 'The Vines', 'AU', 'WA'),
(5935, 14, 213, 'Thornlie', 'AU', 'WA'),
(5936, 14, 213, 'Three Springs', 'AU', 'WA'),
(5937, 14, 213, 'Tom Price', 'AU', 'WA'),
(5938, 14, 213, 'Toodyay', 'AU', 'WA'),
(5939, 14, 213, 'Trayning', 'AU', 'WA'),
(5940, 14, 213, 'Trigg', 'AU', 'WA'),
(5941, 14, 213, 'Tuart Hill', 'AU', 'WA'),
(5942, 14, 213, 'Two Rocks', 'AU', 'WA'),
(5943, 14, 213, 'Upper Gascoyne', 'AU', 'WA'),
(5944, 14, 213, 'Usher', 'AU', 'WA'),
(5945, 14, 213, 'Utakarra', 'AU', 'WA'),
(5946, 14, 213, 'Vasse', 'AU', 'WA'),
(5947, 14, 213, 'Victoria Park', 'AU', 'WA'),
(5948, 14, 213, 'Victoria Plains', 'AU', 'WA'),
(5949, 14, 213, 'Vincent', 'AU', 'WA'),
(5950, 14, 213, 'Viveash', 'AU', 'WA'),
(5951, 14, 213, 'Waggrakine', 'AU', 'WA'),
(5952, 14, 213, 'Wagin', 'AU', 'WA'),
(5953, 14, 213, 'Waikiki', 'AU', 'WA'),
(5954, 14, 213, 'Wandering', 'AU', 'WA'),
(5955, 14, 213, 'Wandi', 'AU', 'WA'),
(5956, 14, 213, 'Wandina', 'AU', 'WA'),
(5957, 14, 213, 'Wannanup', 'AU', 'WA'),
(5958, 14, 213, 'Wanneroo', 'AU', 'WA'),
(5959, 14, 213, 'Warnbro', 'AU', 'WA'),
(5960, 14, 213, 'Waroona', 'AU', 'WA'),
(5961, 14, 213, 'Warwick', 'AU', 'WA'),
(5962, 14, 213, 'Waterford', 'AU', 'WA'),
(5963, 14, 213, 'Watermans Bay', 'AU', 'WA'),
(5964, 14, 213, 'Wattle Grove', 'AU', 'WA'),
(5965, 14, 213, 'Wellard', 'AU', 'WA'),
(5966, 14, 213, 'Wembley', 'AU', 'WA'),
(5967, 14, 213, 'Wembley Downs', 'AU', 'WA'),
(5968, 14, 213, 'West Arthur', 'AU', 'WA'),
(5969, 14, 213, 'West Beach', 'AU', 'WA'),
(5970, 14, 213, 'West Busselton', 'AU', 'WA'),
(5971, 14, 213, 'West Lamington', 'AU', 'WA'),
(5972, 14, 213, 'West Leederville', 'AU', 'WA'),
(5973, 14, 213, 'West Perth', 'AU', 'WA'),
(5974, 14, 213, 'Westminster', 'AU', 'WA'),
(5975, 14, 213, 'Westonia', 'AU', 'WA'),
(5976, 14, 213, 'White Gum Valley', 'AU', 'WA'),
(5977, 14, 213, 'Wickepin', 'AU', 'WA'),
(5978, 14, 213, 'Wickham', 'AU', 'WA'),
(5979, 14, 213, 'Willagee', 'AU', 'WA'),
(5980, 14, 213, 'Willetton', 'AU', 'WA'),
(5981, 14, 213, 'Williams', 'AU', 'WA'),
(5982, 14, 213, 'Wilson', 'AU', 'WA'),
(5983, 14, 213, 'Wiluna', 'AU', 'WA'),
(5984, 14, 213, 'Winthrop', 'AU', 'WA'),
(5985, 14, 213, 'Withers', 'AU', 'WA'),
(5986, 14, 213, 'Wongan-Ballidu', 'AU', 'WA'),
(5987, 14, 213, 'Wonthella', 'AU', 'WA'),
(5988, 14, 213, 'Woodanilling', 'AU', 'WA'),
(5989, 14, 213, 'Woodbridge', 'AU', 'WA'),
(5990, 14, 213, 'Woodridge', 'AU', 'WA'),
(5991, 14, 213, 'Woodvale', 'AU', 'WA'),
(5992, 14, 213, 'Wooroloo', 'AU', 'WA'),
(5993, 14, 213, 'Woorree', 'AU', 'WA'),
(5994, 14, 213, 'Wundowie', 'AU', 'WA'),
(5995, 14, 213, 'Wyalkatchem', 'AU', 'WA'),
(5996, 14, 213, 'Wyndham-East Kimberley', 'AU', 'WA'),
(5997, 14, 213, 'Yakamia', 'AU', 'WA'),
(5998, 14, 213, 'Yalgoo', 'AU', 'WA'),
(5999, 14, 213, 'Yallingup', 'AU', 'WA'),
(6000, 14, 213, 'Yalyalup', 'AU', 'WA');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(6001, 14, 213, 'Yanchep', 'AU', 'WA'),
(6002, 14, 213, 'Yangebup', 'AU', 'WA'),
(6003, 14, 213, 'Yilgarn', 'AU', 'WA'),
(6004, 14, 213, 'Yokine', 'AU', 'WA'),
(6005, 14, 213, 'York', 'AU', 'WA'),
(6006, 15, 214, 'Andau', 'AT', '1'),
(6007, 15, 214, 'Antau', 'AT', '1'),
(6008, 15, 214, 'Apetlon', 'AT', '1'),
(6009, 15, 214, 'Bad Sauerbrunn', 'AT', '1'),
(6010, 15, 214, 'Bad Tatzmannsdorf', 'AT', '1'),
(6011, 15, 214, 'Badersdorf', 'AT', '1'),
(6012, 15, 214, 'Bernstein', 'AT', '1'),
(6013, 15, 214, 'Bocksdorf', 'AT', '1'),
(6014, 15, 214, 'Breitenbrunn', 'AT', '1'),
(6015, 15, 214, 'Bruckneudorf', 'AT', '1'),
(6016, 15, 214, 'Deutsch Jahrndorf', 'AT', '1'),
(6017, 15, 214, 'Deutsch Kaltenbrunn', 'AT', '1'),
(6018, 15, 214, 'Deutschkreutz', 'AT', '1'),
(6019, 15, 214, 'Donnerskirchen', 'AT', '1'),
(6020, 15, 214, 'Drassburg', 'AT', '1'),
(6021, 15, 214, 'Eberau', 'AT', '1'),
(6022, 15, 214, 'Edelstal', 'AT', '1'),
(6023, 15, 214, 'Eisenstadt', 'AT', '1'),
(6024, 15, 214, 'Eisenstadt Stadt', 'AT', '1'),
(6025, 15, 214, 'Eisenstadt-Umgebung', 'AT', '1'),
(6026, 15, 214, 'Eltendorf', 'AT', '1'),
(6027, 15, 214, 'Forchtenstein', 'AT', '1'),
(6028, 15, 214, 'Frauenkirchen', 'AT', '1'),
(6029, 15, 214, 'Gattendorf', 'AT', '1'),
(6030, 15, 214, 'Gols', 'AT', '1'),
(6031, 15, 214, 'Grafenschachen', 'AT', '1'),
(6032, 15, 214, 'Grosshöflein', 'AT', '1'),
(6033, 15, 214, 'Grosspetersdorf', 'AT', '1'),
(6034, 15, 214, 'Güssing', 'AT', '1'),
(6035, 15, 214, 'Güttenbach', 'AT', '1'),
(6036, 15, 214, 'Hackerberg', 'AT', '1'),
(6037, 15, 214, 'Halbturn', 'AT', '1'),
(6038, 15, 214, 'Hannersdorf', 'AT', '1'),
(6039, 15, 214, 'Heiligenbrunn', 'AT', '1'),
(6040, 15, 214, 'Heiligenkreuz im Lafnitztal', 'AT', '1'),
(6041, 15, 214, 'Heugraben', 'AT', '1'),
(6042, 15, 214, 'Hirm', 'AT', '1'),
(6043, 15, 214, 'Horitschon', 'AT', '1'),
(6044, 15, 214, 'Hornstein', 'AT', '1'),
(6045, 15, 214, 'Illmitz', 'AT', '1'),
(6046, 15, 214, 'Inzenhof', 'AT', '1'),
(6047, 15, 214, 'Jabing', 'AT', '1'),
(6048, 15, 214, 'Jennersdorf', 'AT', '1'),
(6049, 15, 214, 'Jois', 'AT', '1'),
(6050, 15, 214, 'Kaisersdorf', 'AT', '1'),
(6051, 15, 214, 'Kemeten', 'AT', '1'),
(6052, 15, 214, 'Kittsee', 'AT', '1'),
(6053, 15, 214, 'Kleinhöflein im Burgenland', 'AT', '1'),
(6054, 15, 214, 'Kleinmürbisch', 'AT', '1'),
(6055, 15, 214, 'Klingenbach', 'AT', '1'),
(6056, 15, 214, 'Kobersdorf', 'AT', '1'),
(6057, 15, 214, 'Kohfidisch', 'AT', '1'),
(6058, 15, 214, 'Königsdorf', 'AT', '1'),
(6059, 15, 214, 'Krensdorf', 'AT', '1'),
(6060, 15, 214, 'Kukmirn', 'AT', '1'),
(6061, 15, 214, 'Lackenbach', 'AT', '1'),
(6062, 15, 214, 'Lackendorf', 'AT', '1'),
(6063, 15, 214, 'Leithaprodersdorf', 'AT', '1'),
(6064, 15, 214, 'Litzelsdorf', 'AT', '1'),
(6065, 15, 214, 'Lockenhaus', 'AT', '1'),
(6066, 15, 214, 'Loipersbach im Burgenland', 'AT', '1'),
(6067, 15, 214, 'Loretto', 'AT', '1'),
(6068, 15, 214, 'Lutzmannsburg', 'AT', '1'),
(6069, 15, 214, 'Mannersdorf an der Rabnitz', 'AT', '1'),
(6070, 15, 214, 'Mariasdorf', 'AT', '1'),
(6071, 15, 214, 'Markt Allhau', 'AT', '1'),
(6072, 15, 214, 'Markt Neuhodis', 'AT', '1'),
(6073, 15, 214, 'Markt Sankt Martin', 'AT', '1'),
(6074, 15, 214, 'Marz', 'AT', '1'),
(6075, 15, 214, 'Mattersburg', 'AT', '1'),
(6076, 15, 214, 'Mischendorf', 'AT', '1'),
(6077, 15, 214, 'Mitterpullendorf', 'AT', '1'),
(6078, 15, 214, 'Mogersdorf', 'AT', '1'),
(6079, 15, 214, 'Mönchhof', 'AT', '1'),
(6080, 15, 214, 'Mörbisch am See', 'AT', '1'),
(6081, 15, 214, 'Moschendorf', 'AT', '1'),
(6082, 15, 214, 'Mühlgraben', 'AT', '1'),
(6083, 15, 214, 'Müllendorf', 'AT', '1'),
(6084, 15, 214, 'Neckenmarkt', 'AT', '1'),
(6085, 15, 214, 'Neuberg im Burgenland', 'AT', '1'),
(6086, 15, 214, 'Neudörfl', 'AT', '1'),
(6087, 15, 214, 'Neufeld an der Leitha', 'AT', '1'),
(6088, 15, 214, 'Neuhaus am Klausenbach', 'AT', '1'),
(6089, 15, 214, 'Neusiedl am See', 'AT', '1'),
(6090, 15, 214, 'Neustift an der Lafnitz', 'AT', '1'),
(6091, 15, 214, 'Neustift bei Güssing', 'AT', '1'),
(6092, 15, 214, 'Neutal', 'AT', '1'),
(6093, 15, 214, 'Nickelsdorf', 'AT', '1'),
(6094, 15, 214, 'Nikitsch', 'AT', '1'),
(6095, 15, 214, 'Oberdorf im Burgenland', 'AT', '1'),
(6096, 15, 214, 'Oberloisdorf', 'AT', '1'),
(6097, 15, 214, 'Oberpullendorf', 'AT', '1'),
(6098, 15, 214, 'Oberschützen', 'AT', '1'),
(6099, 15, 214, 'Oberwart', 'AT', '1'),
(6100, 15, 214, 'Oggau', 'AT', '1'),
(6101, 15, 214, 'Olbendorf', 'AT', '1'),
(6102, 15, 214, 'Ollersdorf im Burgenland', 'AT', '1'),
(6103, 15, 214, 'Oslip', 'AT', '1'),
(6104, 15, 214, 'Pama', 'AT', '1'),
(6105, 15, 214, 'Pamhagen', 'AT', '1'),
(6106, 15, 214, 'Parndorf', 'AT', '1'),
(6107, 15, 214, 'Pilgersdorf', 'AT', '1'),
(6108, 15, 214, 'Pinkafeld', 'AT', '1'),
(6109, 15, 214, 'Piringsdorf', 'AT', '1'),
(6110, 15, 214, 'Podersdorf am See', 'AT', '1'),
(6111, 15, 214, 'Politischer Bezirk Güssing', 'AT', '1'),
(6112, 15, 214, 'Politischer Bezirk Jennersdorf', 'AT', '1'),
(6113, 15, 214, 'Politischer Bezirk Mattersburg', 'AT', '1'),
(6114, 15, 214, 'Politischer Bezirk Neusiedl am See', 'AT', '1'),
(6115, 15, 214, 'Politischer Bezirk Oberpullendorf', 'AT', '1'),
(6116, 15, 214, 'Politischer Bezirk Oberwart', 'AT', '1'),
(6117, 15, 214, 'Pöttelsdorf', 'AT', '1'),
(6118, 15, 214, 'Pöttsching', 'AT', '1'),
(6119, 15, 214, 'Potzneusiedl', 'AT', '1'),
(6120, 15, 214, 'Purbach am Neusiedler See', 'AT', '1'),
(6121, 15, 214, 'Raiding', 'AT', '1'),
(6122, 15, 214, 'Rechnitz', 'AT', '1'),
(6123, 15, 214, 'Riedlingsdorf', 'AT', '1'),
(6124, 15, 214, 'Ritzing', 'AT', '1'),
(6125, 15, 214, 'Rohr im Burgenland', 'AT', '1'),
(6126, 15, 214, 'Rohrbach bei Mattersburg', 'AT', '1'),
(6127, 15, 214, 'Rotenturm an der Pinka', 'AT', '1'),
(6128, 15, 214, 'Rudersdorf', 'AT', '1'),
(6129, 15, 214, 'Rust', 'AT', '1'),
(6130, 15, 214, 'Rust Stadt', 'AT', '1'),
(6131, 15, 214, 'Sankt Andrä am Zicksee', 'AT', '1'),
(6132, 15, 214, 'Sankt Georgen am Leithagebirge', 'AT', '1'),
(6133, 15, 214, 'Sankt Margarethen im Burgenland', 'AT', '1'),
(6134, 15, 214, 'Sankt Martin an der Raab', 'AT', '1'),
(6135, 15, 214, 'Sankt Michael im Burgenland', 'AT', '1'),
(6136, 15, 214, 'Schachendorf', 'AT', '1'),
(6137, 15, 214, 'Schandorf', 'AT', '1'),
(6138, 15, 214, 'Schattendorf', 'AT', '1'),
(6139, 15, 214, 'Schützen am Gebirge', 'AT', '1'),
(6140, 15, 214, 'Siegendorf im Burgenland', 'AT', '1'),
(6141, 15, 214, 'Sieggraben', 'AT', '1'),
(6142, 15, 214, 'Sigless', 'AT', '1'),
(6143, 15, 214, 'Stadtschlaining', 'AT', '1'),
(6144, 15, 214, 'Stegersbach', 'AT', '1'),
(6145, 15, 214, 'Steinbrunn', 'AT', '1'),
(6146, 15, 214, 'Stinatz', 'AT', '1'),
(6147, 15, 214, 'Stoob', 'AT', '1'),
(6148, 15, 214, 'Stotzing', 'AT', '1'),
(6149, 15, 214, 'Strem', 'AT', '1'),
(6150, 15, 214, 'Tadten', 'AT', '1'),
(6151, 15, 214, 'Tobaj', 'AT', '1'),
(6152, 15, 214, 'Trausdorf an der Wulka', 'AT', '1'),
(6153, 15, 214, 'Tschanigraben', 'AT', '1'),
(6154, 15, 214, 'Unterfrauenhaid', 'AT', '1'),
(6155, 15, 214, 'Unterkohlstätten', 'AT', '1'),
(6156, 15, 214, 'Unterwart', 'AT', '1'),
(6157, 15, 214, 'Wallern im Burgenland', 'AT', '1'),
(6158, 15, 214, 'Weichselbaum', 'AT', '1'),
(6159, 15, 214, 'Weiden am See', 'AT', '1'),
(6160, 15, 214, 'Weiden bei Rechnitz', 'AT', '1'),
(6161, 15, 214, 'Weingraben', 'AT', '1'),
(6162, 15, 214, 'Weppersdorf', 'AT', '1'),
(6163, 15, 214, 'Wiesen', 'AT', '1'),
(6164, 15, 214, 'Wiesfleck', 'AT', '1'),
(6165, 15, 214, 'Wimpassing an der Leitha', 'AT', '1'),
(6166, 15, 214, 'Winden am See', 'AT', '1'),
(6167, 15, 214, 'Wolfau', 'AT', '1'),
(6168, 15, 214, 'Wörterberg', 'AT', '1'),
(6169, 15, 214, 'Wulkaprodersdorf', 'AT', '1'),
(6170, 15, 214, 'Zagersdorf', 'AT', '1'),
(6171, 15, 214, 'Zillingtal', 'AT', '1'),
(6172, 15, 214, 'Zurndorf', 'AT', '1'),
(6173, 15, 215, 'Albeck', 'AT', '2'),
(6174, 15, 215, 'Althofen', 'AT', '2'),
(6175, 15, 215, 'Annabichl', 'AT', '2'),
(6176, 15, 215, 'Arnoldstein', 'AT', '2'),
(6177, 15, 215, 'Arriach', 'AT', '2'),
(6178, 15, 215, 'Auen', 'AT', '2'),
(6179, 15, 215, 'Bad Bleiberg', 'AT', '2'),
(6180, 15, 215, 'Bad Eisenkappel', 'AT', '2'),
(6181, 15, 215, 'Bad Kleinkirchheim', 'AT', '2'),
(6182, 15, 215, 'Bad Sankt Leonhard im Lavanttal', 'AT', '2'),
(6183, 15, 215, 'Baldramsdorf', 'AT', '2'),
(6184, 15, 215, 'Berg im Drautal', 'AT', '2'),
(6185, 15, 215, 'Bleiburg', 'AT', '2'),
(6186, 15, 215, 'Bodensdorf', 'AT', '2'),
(6187, 15, 215, 'Brückl', 'AT', '2'),
(6188, 15, 215, 'Dellach', 'AT', '2'),
(6189, 15, 215, 'Dellach im Drautal', 'AT', '2'),
(6190, 15, 215, 'Deutsch Griffen', 'AT', '2'),
(6191, 15, 215, 'Deutsch-Griffen', 'AT', '2'),
(6192, 15, 215, 'Diex', 'AT', '2'),
(6193, 15, 215, 'Döbriach', 'AT', '2'),
(6194, 15, 215, 'Draschen', 'AT', '2'),
(6195, 15, 215, 'Ebenthal', 'AT', '2'),
(6196, 15, 215, 'Eberndorf', 'AT', '2'),
(6197, 15, 215, 'Eberstein', 'AT', '2'),
(6198, 15, 215, 'Ebriach', 'AT', '2'),
(6199, 15, 215, 'Eisenkappel-Vellach', 'AT', '2'),
(6200, 15, 215, 'Faak am See', 'AT', '2'),
(6201, 15, 215, 'Feffernitz', 'AT', '2'),
(6202, 15, 215, 'Feistritz an der Drau', 'AT', '2'),
(6203, 15, 215, 'Feistritz an der Gail', 'AT', '2'),
(6204, 15, 215, 'Feistritz im Rosental', 'AT', '2'),
(6205, 15, 215, 'Feistritz ob Bleiburg', 'AT', '2'),
(6206, 15, 215, 'Feld am See', 'AT', '2'),
(6207, 15, 215, 'Feldkirchen District', 'AT', '2'),
(6208, 15, 215, 'Feldkirchen in Kärnten', 'AT', '2'),
(6209, 15, 215, 'Ferlach', 'AT', '2'),
(6210, 15, 215, 'Ferndorf', 'AT', '2'),
(6211, 15, 215, 'Finkenstein', 'AT', '2'),
(6212, 15, 215, 'Finkenstein am Faaker See', 'AT', '2'),
(6213, 15, 215, 'Flattach', 'AT', '2'),
(6214, 15, 215, 'Föderlach I', 'AT', '2'),
(6215, 15, 215, 'Frantschach-Sankt Gertraud', 'AT', '2'),
(6216, 15, 215, 'Frauenstein', 'AT', '2'),
(6217, 15, 215, 'Fresach', 'AT', '2'),
(6218, 15, 215, 'Fresen', 'AT', '2'),
(6219, 15, 215, 'Friesach', 'AT', '2'),
(6220, 15, 215, 'Fürnitz', 'AT', '2'),
(6221, 15, 215, 'Gailitz', 'AT', '2'),
(6222, 15, 215, 'Gallizien', 'AT', '2'),
(6223, 15, 215, 'Gemmersdorf', 'AT', '2'),
(6224, 15, 215, 'Gerlamoos', 'AT', '2'),
(6225, 15, 215, 'Gitschtal', 'AT', '2'),
(6226, 15, 215, 'Glanegg', 'AT', '2'),
(6227, 15, 215, 'Globasnitz', 'AT', '2'),
(6228, 15, 215, 'Glödnitz', 'AT', '2'),
(6229, 15, 215, 'Gmünd', 'AT', '2'),
(6230, 15, 215, 'Gmünd in Kärnten', 'AT', '2'),
(6231, 15, 215, 'Gnesau', 'AT', '2'),
(6232, 15, 215, 'Görtschach', 'AT', '2'),
(6233, 15, 215, 'Grafenstein', 'AT', '2'),
(6234, 15, 215, 'Greifenburg', 'AT', '2'),
(6235, 15, 215, 'Gries', 'AT', '2'),
(6236, 15, 215, 'Griffen', 'AT', '2'),
(6237, 15, 215, 'Großkirchheim', 'AT', '2'),
(6238, 15, 215, 'Gurk', 'AT', '2'),
(6239, 15, 215, 'Guttaring', 'AT', '2'),
(6240, 15, 215, 'Heiligenblut', 'AT', '2'),
(6241, 15, 215, 'Hermagor', 'AT', '2'),
(6242, 15, 215, 'Hermagor District', 'AT', '2'),
(6243, 15, 215, 'Hermagor-Pressegger See', 'AT', '2'),
(6244, 15, 215, 'Himmelberg', 'AT', '2'),
(6245, 15, 215, 'Hohenthurn', 'AT', '2'),
(6246, 15, 215, 'Hörtendorf', 'AT', '2'),
(6247, 15, 215, 'Hüttenberg', 'AT', '2'),
(6248, 15, 215, 'Irschen', 'AT', '2'),
(6249, 15, 215, 'Kappel am Krappfeld', 'AT', '2'),
(6250, 15, 215, 'Keutschach am See', 'AT', '2'),
(6251, 15, 215, 'Kirchbach', 'AT', '2'),
(6252, 15, 215, 'Klagenfurt', 'AT', '2'),
(6253, 15, 215, 'Klagenfurt am Wörthersee', 'AT', '2'),
(6254, 15, 215, 'Klagenfurt-Land District', 'AT', '2'),
(6255, 15, 215, 'Kleblach-Lind', 'AT', '2'),
(6256, 15, 215, 'Klein Sankt Paul', 'AT', '2'),
(6257, 15, 215, 'Kleinedling', 'AT', '2'),
(6258, 15, 215, 'Kötschach', 'AT', '2'),
(6259, 15, 215, 'Kötschach-Mauthen', 'AT', '2'),
(6260, 15, 215, 'Köttmannsdorf', 'AT', '2'),
(6261, 15, 215, 'Krems', 'AT', '2'),
(6262, 15, 215, 'Krumpendorf', 'AT', '2'),
(6263, 15, 215, 'Kühnsdorf', 'AT', '2'),
(6264, 15, 215, 'Lamnitz', 'AT', '2'),
(6265, 15, 215, 'Landskron', 'AT', '2'),
(6266, 15, 215, 'Launsdorf', 'AT', '2'),
(6267, 15, 215, 'Lavamünd', 'AT', '2'),
(6268, 15, 215, 'Ledenitzen', 'AT', '2'),
(6269, 15, 215, 'Lendorf', 'AT', '2'),
(6270, 15, 215, 'Leppen', 'AT', '2'),
(6271, 15, 215, 'Lesachtal', 'AT', '2'),
(6272, 15, 215, 'Liebenfels', 'AT', '2'),
(6273, 15, 215, 'Lind', 'AT', '2'),
(6274, 15, 215, 'Lobersberg', 'AT', '2'),
(6275, 15, 215, 'Ludmannsdorf', 'AT', '2'),
(6276, 15, 215, 'Lurnfeld', 'AT', '2'),
(6277, 15, 215, 'Magdalensberg', 'AT', '2'),
(6278, 15, 215, 'Mallnitz', 'AT', '2'),
(6279, 15, 215, 'Malta', 'AT', '2'),
(6280, 15, 215, 'Maria Rain', 'AT', '2'),
(6281, 15, 215, 'Maria Saal', 'AT', '2'),
(6282, 15, 215, 'Maria Wörth', 'AT', '2'),
(6283, 15, 215, 'Mautbrücken', 'AT', '2'),
(6284, 15, 215, 'Metnitz', 'AT', '2'),
(6285, 15, 215, 'Micheldorf', 'AT', '2'),
(6286, 15, 215, 'Millstatt', 'AT', '2'),
(6287, 15, 215, 'Mölbling', 'AT', '2'),
(6288, 15, 215, 'Möllbrücke', 'AT', '2'),
(6289, 15, 215, 'Moosburg', 'AT', '2'),
(6290, 15, 215, 'Mörtschach', 'AT', '2'),
(6291, 15, 215, 'Mühldorf', 'AT', '2'),
(6292, 15, 215, 'Neu-Feffernitz', 'AT', '2'),
(6293, 15, 215, 'Neuhaus', 'AT', '2'),
(6294, 15, 215, 'Niederdorf', 'AT', '2'),
(6295, 15, 215, 'Nötsch im Gailtal', 'AT', '2'),
(6296, 15, 215, 'Oberdörfl', 'AT', '2'),
(6297, 15, 215, 'Oberdrauburg', 'AT', '2'),
(6298, 15, 215, 'Obermillstatt', 'AT', '2'),
(6299, 15, 215, 'Obervellach', 'AT', '2'),
(6300, 15, 215, 'Ossiach', 'AT', '2'),
(6301, 15, 215, 'Paternion', 'AT', '2'),
(6302, 15, 215, 'Pischeldorf', 'AT', '2'),
(6303, 15, 215, 'Pöckau', 'AT', '2'),
(6304, 15, 215, 'Poggersdorf', 'AT', '2'),
(6305, 15, 215, 'Pörtschach am Wörthersee', 'AT', '2'),
(6306, 15, 215, 'Preitenegg', 'AT', '2'),
(6307, 15, 215, 'Priel', 'AT', '2'),
(6308, 15, 215, 'Pusarnitz', 'AT', '2'),
(6309, 15, 215, 'Radenthein', 'AT', '2'),
(6310, 15, 215, 'Rain', 'AT', '2'),
(6311, 15, 215, 'Rangersdorf', 'AT', '2'),
(6312, 15, 215, 'Reding', 'AT', '2'),
(6313, 15, 215, 'Reichenau', 'AT', '2'),
(6314, 15, 215, 'Reichenfels', 'AT', '2'),
(6315, 15, 215, 'Reißeck', 'AT', '2'),
(6316, 15, 215, 'Rennweg am Katschberg', 'AT', '2'),
(6317, 15, 215, 'Rittersdorf', 'AT', '2'),
(6318, 15, 215, 'Rosegg', 'AT', '2'),
(6319, 15, 215, 'Ruden', 'AT', '2'),
(6320, 15, 215, 'Sachsenburg', 'AT', '2'),
(6321, 15, 215, 'Sankt Andrä', 'AT', '2'),
(6322, 15, 215, 'Sankt Egyden an der Drau', 'AT', '2'),
(6323, 15, 215, 'Sankt Georgen am Längsee', 'AT', '2'),
(6324, 15, 215, 'Sankt Georgen im Lavanttal', 'AT', '2'),
(6325, 15, 215, 'Sankt Jakob', 'AT', '2'),
(6326, 15, 215, 'Sankt Jakob im Rosental', 'AT', '2'),
(6327, 15, 215, 'Sankt Kanzian am Klopeiner See', 'AT', '2'),
(6328, 15, 215, 'Sankt Leonhard', 'AT', '2'),
(6329, 15, 215, 'Sankt Magdalen', 'AT', '2'),
(6330, 15, 215, 'Sankt Margareten im Rosental', 'AT', '2'),
(6331, 15, 215, 'Sankt Martin', 'AT', '2'),
(6332, 15, 215, 'Sankt Paul im Lavanttal', 'AT', '2'),
(6333, 15, 215, 'Sankt Peter', 'AT', '2'),
(6334, 15, 215, 'Sankt Ruprecht', 'AT', '2'),
(6335, 15, 215, 'Sankt Stefan', 'AT', '2'),
(6336, 15, 215, 'Sankt Stefan im Gailtal', 'AT', '2'),
(6337, 15, 215, 'Sankt Urban', 'AT', '2'),
(6338, 15, 215, 'Sankt Veit an der Glan', 'AT', '2'),
(6339, 15, 215, 'Sankt Veit an der Glan District', 'AT', '2'),
(6340, 15, 215, 'Schiefling am See', 'AT', '2'),
(6341, 15, 215, 'Schleben', 'AT', '2'),
(6342, 15, 215, 'Seebach', 'AT', '2'),
(6343, 15, 215, 'Seeboden', 'AT', '2'),
(6344, 15, 215, 'Seitenberg', 'AT', '2'),
(6345, 15, 215, 'Sirnitz', 'AT', '2'),
(6346, 15, 215, 'Sittersdorf', 'AT', '2'),
(6347, 15, 215, 'Spittal an der Drau', 'AT', '2'),
(6348, 15, 215, 'Spittal an der Drau District', 'AT', '2'),
(6349, 15, 215, 'St. Agathen und Perau', 'AT', '2'),
(6350, 15, 215, 'St. Andrä', 'AT', '2'),
(6351, 15, 215, 'St. Margareten im Rosental', 'AT', '2'),
(6352, 15, 215, 'St. Paul im Lavanttal', 'AT', '2'),
(6353, 15, 215, 'St. Stefan im Gailtal', 'AT', '2'),
(6354, 15, 215, 'St. Urban', 'AT', '2'),
(6355, 15, 215, 'St. Veit an der Glan', 'AT', '2'),
(6356, 15, 215, 'St. Veiter Vorstadt', 'AT', '2'),
(6357, 15, 215, 'Stall', 'AT', '2'),
(6358, 15, 215, 'Steindorf am Ossiacher See', 'AT', '2'),
(6359, 15, 215, 'Steinfeld', 'AT', '2'),
(6360, 15, 215, 'Steuerberg', 'AT', '2'),
(6361, 15, 215, 'Stockenboi', 'AT', '2'),
(6362, 15, 215, 'Straßburg', 'AT', '2'),
(6363, 15, 215, 'Straßburg-Stadt', 'AT', '2'),
(6364, 15, 215, 'Suetschach', 'AT', '2'),
(6365, 15, 215, 'Techelsberg', 'AT', '2'),
(6366, 15, 215, 'Timenitz', 'AT', '2'),
(6367, 15, 215, 'Trebesing', 'AT', '2'),
(6368, 15, 215, 'Treffen', 'AT', '2'),
(6369, 15, 215, 'Treibach', 'AT', '2'),
(6370, 15, 215, 'Tschachoritsch', 'AT', '2'),
(6371, 15, 215, 'Umberg', 'AT', '2'),
(6372, 15, 215, 'Untere Fellach', 'AT', '2'),
(6373, 15, 215, 'Velden am Wörther See', 'AT', '2'),
(6374, 15, 215, 'Velden am Wörthersee', 'AT', '2'),
(6375, 15, 215, 'Viktring', 'AT', '2'),
(6376, 15, 215, 'Viktringer Vorstadt', 'AT', '2'),
(6377, 15, 215, 'Villach', 'AT', '2'),
(6378, 15, 215, 'Villach-Innere Stadt', 'AT', '2'),
(6379, 15, 215, 'Villach-Land District', 'AT', '2'),
(6380, 15, 215, 'Villacher Vorstadt', 'AT', '2'),
(6381, 15, 215, 'Völkendorf', 'AT', '2'),
(6382, 15, 215, 'Völkermarkt', 'AT', '2'),
(6383, 15, 215, 'Völkermarkt District', 'AT', '2'),
(6384, 15, 215, 'Völkermarkter Vorstadt', 'AT', '2'),
(6385, 15, 215, 'Waiern', 'AT', '2'),
(6386, 15, 215, 'Warmbad-Judendorf', 'AT', '2'),
(6387, 15, 215, 'Weißensee', 'AT', '2'),
(6388, 15, 215, 'Weißenstein', 'AT', '2'),
(6389, 15, 215, 'Weitensfeld', 'AT', '2'),
(6390, 15, 215, 'Weitensfeld im Gurktal', 'AT', '2'),
(6391, 15, 215, 'Wernberg', 'AT', '2'),
(6392, 15, 215, 'Winklern', 'AT', '2'),
(6393, 15, 215, 'Wölfnitz', 'AT', '2'),
(6394, 15, 215, 'Wolfsberg', 'AT', '2'),
(6395, 15, 215, 'Wolfsberg District', 'AT', '2'),
(6396, 15, 215, 'Wudmath', 'AT', '2'),
(6397, 15, 215, 'Zell', 'AT', '2'),
(6398, 15, 216, 'Absdorf', 'AT', '3'),
(6399, 15, 216, 'Achau', 'AT', '3'),
(6400, 15, 216, 'Aderklaa', 'AT', '3'),
(6401, 15, 216, 'Aggsbach', 'AT', '3'),
(6402, 15, 216, 'Alland', 'AT', '3'),
(6403, 15, 216, 'Allentsteig', 'AT', '3'),
(6404, 15, 216, 'Allhartsberg', 'AT', '3'),
(6405, 15, 216, 'Altenburg', 'AT', '3'),
(6406, 15, 216, 'Altendorf', 'AT', '3'),
(6407, 15, 216, 'Altenmarkt an der Triesting', 'AT', '3'),
(6408, 15, 216, 'Altlengbach', 'AT', '3'),
(6409, 15, 216, 'Altlichtenwarth', 'AT', '3'),
(6410, 15, 216, 'Altmelon', 'AT', '3'),
(6411, 15, 216, 'Amstetten', 'AT', '3'),
(6412, 15, 216, 'Andlersdorf', 'AT', '3'),
(6413, 15, 216, 'Angern an der March', 'AT', '3'),
(6414, 15, 216, 'Arbesbach', 'AT', '3'),
(6415, 15, 216, 'Ardagger Stift', 'AT', '3'),
(6416, 15, 216, 'Aschbach Markt', 'AT', '3'),
(6417, 15, 216, 'Aspang Markt', 'AT', '3'),
(6418, 15, 216, 'Asparn an der Zaya', 'AT', '3'),
(6419, 15, 216, 'Asperhofen', 'AT', '3'),
(6420, 15, 216, 'Atzenbrugg', 'AT', '3'),
(6421, 15, 216, 'Au am Leithaberge', 'AT', '3'),
(6422, 15, 216, 'Auersthal', 'AT', '3'),
(6423, 15, 216, 'Bad Deutsch-Altenburg', 'AT', '3'),
(6424, 15, 216, 'Bad Erlach', 'AT', '3'),
(6425, 15, 216, 'Bad Fischau', 'AT', '3'),
(6426, 15, 216, 'Bad Pirawarth', 'AT', '3'),
(6427, 15, 216, 'Bad Schönau', 'AT', '3'),
(6428, 15, 216, 'Bad Traunstein', 'AT', '3'),
(6429, 15, 216, 'Bad Vöslau', 'AT', '3'),
(6430, 15, 216, 'Baden', 'AT', '3'),
(6431, 15, 216, 'Bärnkopf', 'AT', '3'),
(6432, 15, 216, 'Behamberg', 'AT', '3'),
(6433, 15, 216, 'Berg', 'AT', '3'),
(6434, 15, 216, 'Bergland', 'AT', '3'),
(6435, 15, 216, 'Berndorf', 'AT', '3'),
(6436, 15, 216, 'Bernhardsthal', 'AT', '3'),
(6437, 15, 216, 'Biberbach', 'AT', '3'),
(6438, 15, 216, 'Biedermannsdorf', 'AT', '3'),
(6439, 15, 216, 'Bisamberg', 'AT', '3'),
(6440, 15, 216, 'Bischofstetten', 'AT', '3'),
(6441, 15, 216, 'Blindenmarkt', 'AT', '3'),
(6442, 15, 216, 'Bockfließ', 'AT', '3'),
(6443, 15, 216, 'Böheimkirchen', 'AT', '3'),
(6444, 15, 216, 'Breitenau', 'AT', '3'),
(6445, 15, 216, 'Breitenfurt bei Wien', 'AT', '3'),
(6446, 15, 216, 'Bromberg', 'AT', '3'),
(6447, 15, 216, 'Bruck an der Leitha', 'AT', '3'),
(6448, 15, 216, 'Brunn am Gebirge', 'AT', '3'),
(6449, 15, 216, 'Brunn an der Schneebergbahn', 'AT', '3'),
(6450, 15, 216, 'Brunn an der Wild', 'AT', '3'),
(6451, 15, 216, 'Buchbach', 'AT', '3'),
(6452, 15, 216, 'Deutsch-Wagram', 'AT', '3'),
(6453, 15, 216, 'Dobersberg', 'AT', '3'),
(6454, 15, 216, 'Dorfstetten', 'AT', '3'),
(6455, 15, 216, 'Drasenhofen', 'AT', '3'),
(6456, 15, 216, 'Drösing', 'AT', '3'),
(6457, 15, 216, 'Droß', 'AT', '3'),
(6458, 15, 216, 'Dürnkrut', 'AT', '3'),
(6459, 15, 216, 'Dürnstein', 'AT', '3'),
(6460, 15, 216, 'Ebenfurth', 'AT', '3'),
(6461, 15, 216, 'Ebenthal', 'AT', '3'),
(6462, 15, 216, 'Ebergassing', 'AT', '3'),
(6463, 15, 216, 'Ebreichsdorf', 'AT', '3'),
(6464, 15, 216, 'Echsenbach', 'AT', '3'),
(6465, 15, 216, 'Eckartsau', 'AT', '3'),
(6466, 15, 216, 'Edlitz', 'AT', '3'),
(6467, 15, 216, 'Eggenburg', 'AT', '3'),
(6468, 15, 216, 'Eggendorf', 'AT', '3'),
(6469, 15, 216, 'Eggern', 'AT', '3'),
(6470, 15, 216, 'Eichgraben', 'AT', '3'),
(6471, 15, 216, 'Eisgarn', 'AT', '3'),
(6472, 15, 216, 'Emmersdorf an der Donau', 'AT', '3'),
(6473, 15, 216, 'Engelhartstetten', 'AT', '3'),
(6474, 15, 216, 'Ennsdorf', 'AT', '3'),
(6475, 15, 216, 'Enzenreith', 'AT', '3'),
(6476, 15, 216, 'Enzersdorf an der Fischa', 'AT', '3'),
(6477, 15, 216, 'Enzersfeld', 'AT', '3'),
(6478, 15, 216, 'Erlauf', 'AT', '3'),
(6479, 15, 216, 'Ernstbrunn', 'AT', '3'),
(6480, 15, 216, 'Ernsthofen', 'AT', '3'),
(6481, 15, 216, 'Erpersdorf', 'AT', '3'),
(6482, 15, 216, 'Ertl', 'AT', '3'),
(6483, 15, 216, 'Eschenau', 'AT', '3'),
(6484, 15, 216, 'Euratsfeld', 'AT', '3'),
(6485, 15, 216, 'Falkenstein', 'AT', '3'),
(6486, 15, 216, 'Fallbach', 'AT', '3'),
(6487, 15, 216, 'Feistritz am Wechsel', 'AT', '3'),
(6488, 15, 216, 'Felixdorf', 'AT', '3'),
(6489, 15, 216, 'Fels am Wagram', 'AT', '3'),
(6490, 15, 216, 'Ferschnitz', 'AT', '3'),
(6491, 15, 216, 'Fischamend-Markt', 'AT', '3'),
(6492, 15, 216, 'Frankenfels', 'AT', '3'),
(6493, 15, 216, 'Frohsdorf', 'AT', '3'),
(6494, 15, 216, 'Furth an der Triesting', 'AT', '3'),
(6495, 15, 216, 'Furth bei Göttweig', 'AT', '3'),
(6496, 15, 216, 'Gaaden', 'AT', '3'),
(6497, 15, 216, 'Gablitz', 'AT', '3'),
(6498, 15, 216, 'Gainfarn', 'AT', '3'),
(6499, 15, 216, 'Gaming', 'AT', '3'),
(6500, 15, 216, 'Gänserndorf', 'AT', '3');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(6501, 15, 216, 'Gars am Kamp', 'AT', '3'),
(6502, 15, 216, 'Gastern', 'AT', '3'),
(6503, 15, 216, 'Gaubitsch', 'AT', '3'),
(6504, 15, 216, 'Gaweinstal', 'AT', '3'),
(6505, 15, 216, 'Gedersdorf', 'AT', '3'),
(6506, 15, 216, 'Geras', 'AT', '3'),
(6507, 15, 216, 'Gerasdorf bei Wien', 'AT', '3'),
(6508, 15, 216, 'Gerersdorf', 'AT', '3'),
(6509, 15, 216, 'Gerolding', 'AT', '3'),
(6510, 15, 216, 'Gföhl', 'AT', '3'),
(6511, 15, 216, 'Gießhübl', 'AT', '3'),
(6512, 15, 216, 'Glinzendorf', 'AT', '3'),
(6513, 15, 216, 'Gloggnitz', 'AT', '3'),
(6514, 15, 216, 'Gmünd', 'AT', '3'),
(6515, 15, 216, 'Gnadendorf', 'AT', '3'),
(6516, 15, 216, 'Gneixendorf', 'AT', '3'),
(6517, 15, 216, 'Göllersdorf', 'AT', '3'),
(6518, 15, 216, 'Göpfritz an der Wild', 'AT', '3'),
(6519, 15, 216, 'Göstling an der Ybbs', 'AT', '3'),
(6520, 15, 216, 'Götzendorf an der Leitha', 'AT', '3'),
(6521, 15, 216, 'Grafenegg', 'AT', '3'),
(6522, 15, 216, 'Grafenschlag', 'AT', '3'),
(6523, 15, 216, 'Grafenwörth', 'AT', '3'),
(6524, 15, 216, 'Gramatneusiedl', 'AT', '3'),
(6525, 15, 216, 'Greinsfurth', 'AT', '3'),
(6526, 15, 216, 'Gresten', 'AT', '3'),
(6527, 15, 216, 'Grimmenstein', 'AT', '3'),
(6528, 15, 216, 'Groß-Engersdorf', 'AT', '3'),
(6529, 15, 216, 'Groß-Enzersdorf', 'AT', '3'),
(6530, 15, 216, 'Groß-Gerungs', 'AT', '3'),
(6531, 15, 216, 'Groß-Schweinbarth', 'AT', '3'),
(6532, 15, 216, 'Groß-Siegharts', 'AT', '3'),
(6533, 15, 216, 'Großebersdorf', 'AT', '3'),
(6534, 15, 216, 'Großharras', 'AT', '3'),
(6535, 15, 216, 'Großhofen', 'AT', '3'),
(6536, 15, 216, 'Großkrut', 'AT', '3'),
(6537, 15, 216, 'Großmugl', 'AT', '3'),
(6538, 15, 216, 'Großriedenthal', 'AT', '3'),
(6539, 15, 216, 'Großrußbach', 'AT', '3'),
(6540, 15, 216, 'Großweikersdorf', 'AT', '3'),
(6541, 15, 216, 'Grünbach am Schneeberg', 'AT', '3'),
(6542, 15, 216, 'Gugging', 'AT', '3'),
(6543, 15, 216, 'Gumpoldskirchen', 'AT', '3'),
(6544, 15, 216, 'Günselsdorf', 'AT', '3'),
(6545, 15, 216, 'Guntersdorf', 'AT', '3'),
(6546, 15, 216, 'Guntramsdorf', 'AT', '3'),
(6547, 15, 216, 'Gutenbrunn', 'AT', '3'),
(6548, 15, 216, 'Gutenstein', 'AT', '3'),
(6549, 15, 216, 'Haag', 'AT', '3'),
(6550, 15, 216, 'Hadersdorf am Kamp', 'AT', '3'),
(6551, 15, 216, 'Hadres', 'AT', '3'),
(6552, 15, 216, 'Hafnerbach', 'AT', '3'),
(6553, 15, 216, 'Hagenbrunn', 'AT', '3'),
(6554, 15, 216, 'Haidershofen', 'AT', '3'),
(6555, 15, 216, 'Hainburg an der Donau', 'AT', '3'),
(6556, 15, 216, 'Hainfeld', 'AT', '3'),
(6557, 15, 216, 'Hardegg', 'AT', '3'),
(6558, 15, 216, 'Haringsee', 'AT', '3'),
(6559, 15, 216, 'Harland', 'AT', '3'),
(6560, 15, 216, 'Harmannsdorf', 'AT', '3'),
(6561, 15, 216, 'Hart', 'AT', '3'),
(6562, 15, 216, 'Haugschlag', 'AT', '3'),
(6563, 15, 216, 'Haugsdorf', 'AT', '3'),
(6564, 15, 216, 'Haunoldstein', 'AT', '3'),
(6565, 15, 216, 'Hausbrunn', 'AT', '3'),
(6566, 15, 216, 'Hauskirchen', 'AT', '3'),
(6567, 15, 216, 'Hausleiten', 'AT', '3'),
(6568, 15, 216, 'Hausmening', 'AT', '3'),
(6569, 15, 216, 'Heidenreichstein', 'AT', '3'),
(6570, 15, 216, 'Heiligeneich', 'AT', '3'),
(6571, 15, 216, 'Heiligenkreuz', 'AT', '3'),
(6572, 15, 216, 'Hennersdorf', 'AT', '3'),
(6573, 15, 216, 'Hernstein', 'AT', '3'),
(6574, 15, 216, 'Herrnbaumgarten', 'AT', '3'),
(6575, 15, 216, 'Herzogenburg', 'AT', '3'),
(6576, 15, 216, 'Himberg', 'AT', '3'),
(6577, 15, 216, 'Hinterbrühl', 'AT', '3'),
(6578, 15, 216, 'Hinterleiten', 'AT', '3'),
(6579, 15, 216, 'Hirschbach', 'AT', '3'),
(6580, 15, 216, 'Hirtenberg', 'AT', '3'),
(6581, 15, 216, 'Hochleithen', 'AT', '3'),
(6582, 15, 216, 'Hochwolkersdorf', 'AT', '3'),
(6583, 15, 216, 'Hof am Leithaberge', 'AT', '3'),
(6584, 15, 216, 'Hofamt Priel', 'AT', '3'),
(6585, 15, 216, 'Höflein', 'AT', '3'),
(6586, 15, 216, 'Höfling', 'AT', '3'),
(6587, 15, 216, 'Hofstetten', 'AT', '3'),
(6588, 15, 216, 'Hohenau', 'AT', '3'),
(6589, 15, 216, 'Hohenberg', 'AT', '3'),
(6590, 15, 216, 'Hoheneich', 'AT', '3'),
(6591, 15, 216, 'Hohenruppersdorf', 'AT', '3'),
(6592, 15, 216, 'Hollabrunn', 'AT', '3'),
(6593, 15, 216, 'Hollenstein an der Ybbs', 'AT', '3'),
(6594, 15, 216, 'Hollenthon', 'AT', '3'),
(6595, 15, 216, 'Horn', 'AT', '3'),
(6596, 15, 216, 'Hundsheim', 'AT', '3'),
(6597, 15, 216, 'Hürm', 'AT', '3'),
(6598, 15, 216, 'Hutten', 'AT', '3'),
(6599, 15, 216, 'Jaidhof', 'AT', '3'),
(6600, 15, 216, 'Japons', 'AT', '3'),
(6601, 15, 216, 'Jedenspeigen', 'AT', '3'),
(6602, 15, 216, 'Kaltenleutgeben', 'AT', '3'),
(6603, 15, 216, 'Kapelln', 'AT', '3'),
(6604, 15, 216, 'Karlstetten', 'AT', '3'),
(6605, 15, 216, 'Kasten bei Böheimkirchen', 'AT', '3'),
(6606, 15, 216, 'Katzelsdorf', 'AT', '3'),
(6607, 15, 216, 'Kaumberg', 'AT', '3'),
(6608, 15, 216, 'Kautzen', 'AT', '3'),
(6609, 15, 216, 'Kematen an der Ybbs', 'AT', '3'),
(6610, 15, 216, 'Kierling', 'AT', '3'),
(6611, 15, 216, 'Kilb', 'AT', '3'),
(6612, 15, 216, 'Kirchberg am Wagram', 'AT', '3'),
(6613, 15, 216, 'Kirchberg am Walde', 'AT', '3'),
(6614, 15, 216, 'Kirchberg am Wechsel', 'AT', '3'),
(6615, 15, 216, 'Kirchberg an der Pielach', 'AT', '3'),
(6616, 15, 216, 'Kirchschlag', 'AT', '3'),
(6617, 15, 216, 'Kirchschlag in der Buckligen Welt', 'AT', '3'),
(6618, 15, 216, 'Kirchstetten', 'AT', '3'),
(6619, 15, 216, 'Kirnberg an der Mank', 'AT', '3'),
(6620, 15, 216, 'Klausen-Leopoldsdorf', 'AT', '3'),
(6621, 15, 216, 'Klein-Neusiedl', 'AT', '3'),
(6622, 15, 216, 'Klein-Pöchlarn', 'AT', '3'),
(6623, 15, 216, 'Kleinzell', 'AT', '3'),
(6624, 15, 216, 'Klosterneuburg', 'AT', '3'),
(6625, 15, 216, 'Königstetten', 'AT', '3'),
(6626, 15, 216, 'Korneuburg', 'AT', '3'),
(6627, 15, 216, 'Kottingbrunn', 'AT', '3'),
(6628, 15, 216, 'Krems an der Donau', 'AT', '3'),
(6629, 15, 216, 'Krems an der Donau Stadt', 'AT', '3'),
(6630, 15, 216, 'Kritzendorf', 'AT', '3'),
(6631, 15, 216, 'Krumau am Kamp', 'AT', '3'),
(6632, 15, 216, 'Krumbach Markt', 'AT', '3'),
(6633, 15, 216, 'Krumnussbaum', 'AT', '3'),
(6634, 15, 216, 'Laa an der Thaya', 'AT', '3'),
(6635, 15, 216, 'Laab im Walde', 'AT', '3'),
(6636, 15, 216, 'Ladendorf', 'AT', '3'),
(6637, 15, 216, 'Landegg', 'AT', '3'),
(6638, 15, 216, 'Langau', 'AT', '3'),
(6639, 15, 216, 'Langenlebarn-Oberaigen', 'AT', '3'),
(6640, 15, 216, 'Langenlois', 'AT', '3'),
(6641, 15, 216, 'Langenrohr', 'AT', '3'),
(6642, 15, 216, 'Langenzersdorf', 'AT', '3'),
(6643, 15, 216, 'Langschlag', 'AT', '3'),
(6644, 15, 216, 'Lanzendorf', 'AT', '3'),
(6645, 15, 216, 'Lanzenkirchen', 'AT', '3'),
(6646, 15, 216, 'Lassee', 'AT', '3'),
(6647, 15, 216, 'Laxenburg', 'AT', '3'),
(6648, 15, 216, 'Leiben', 'AT', '3'),
(6649, 15, 216, 'Leitzersdorf', 'AT', '3'),
(6650, 15, 216, 'Lengenfeld', 'AT', '3'),
(6651, 15, 216, 'Leobendorf', 'AT', '3'),
(6652, 15, 216, 'Leobersdorf', 'AT', '3'),
(6653, 15, 216, 'Leopoldsdorf', 'AT', '3'),
(6654, 15, 216, 'Leopoldsdorf im Marchfelde', 'AT', '3'),
(6655, 15, 216, 'Lerchenfeld', 'AT', '3'),
(6656, 15, 216, 'Lichtenegg', 'AT', '3'),
(6657, 15, 216, 'Lichtenwörth', 'AT', '3'),
(6658, 15, 216, 'Lilienfeld', 'AT', '3'),
(6659, 15, 216, 'Litschau', 'AT', '3'),
(6660, 15, 216, 'Loich', 'AT', '3'),
(6661, 15, 216, 'Loosdorf', 'AT', '3'),
(6662, 15, 216, 'Lunz am See', 'AT', '3'),
(6663, 15, 216, 'Mailberg', 'AT', '3'),
(6664, 15, 216, 'Maissau', 'AT', '3'),
(6665, 15, 216, 'Mank', 'AT', '3'),
(6666, 15, 216, 'Mannersdorf am Leithagebirge', 'AT', '3'),
(6667, 15, 216, 'Mannsdorf an der Donau', 'AT', '3'),
(6668, 15, 216, 'Mannswörth', 'AT', '3'),
(6669, 15, 216, 'Marbach an der Donau', 'AT', '3'),
(6670, 15, 216, 'Marchegg', 'AT', '3'),
(6671, 15, 216, 'Margarethen am Moos', 'AT', '3'),
(6672, 15, 216, 'Maria Ellend', 'AT', '3'),
(6673, 15, 216, 'Maria Enzersdorf', 'AT', '3'),
(6674, 15, 216, 'Maria Laach am Jauerling', 'AT', '3'),
(6675, 15, 216, 'Maria Lanzendorf', 'AT', '3'),
(6676, 15, 216, 'Maria Taferl', 'AT', '3'),
(6677, 15, 216, 'Maria-Anzbach', 'AT', '3'),
(6678, 15, 216, 'Markersdorf an der Pielach', 'AT', '3'),
(6679, 15, 216, 'Markgrafneusiedl', 'AT', '3'),
(6680, 15, 216, 'Markt Piesting', 'AT', '3'),
(6681, 15, 216, 'Martinsberg', 'AT', '3'),
(6682, 15, 216, 'Matzen', 'AT', '3'),
(6683, 15, 216, 'Matzendorf', 'AT', '3'),
(6684, 15, 216, 'Mauer bei Amstetten', 'AT', '3'),
(6685, 15, 216, 'Mauerbach', 'AT', '3'),
(6686, 15, 216, 'Mautern', 'AT', '3'),
(6687, 15, 216, 'Melk', 'AT', '3'),
(6688, 15, 216, 'Michelhausen', 'AT', '3'),
(6689, 15, 216, 'Miesenbach', 'AT', '3'),
(6690, 15, 216, 'Mistelbach', 'AT', '3'),
(6691, 15, 216, 'Mitterbach am Erlaufsee', 'AT', '3'),
(6692, 15, 216, 'Mitterndorf an der Fischa', 'AT', '3'),
(6693, 15, 216, 'Mödling', 'AT', '3'),
(6694, 15, 216, 'Möllersdorf', 'AT', '3'),
(6695, 15, 216, 'Mönichkirchen', 'AT', '3'),
(6696, 15, 216, 'Moosbrunn', 'AT', '3'),
(6697, 15, 216, 'Muckendorf an der Donau', 'AT', '3'),
(6698, 15, 216, 'Muggendorf', 'AT', '3'),
(6699, 15, 216, 'Mühldorf', 'AT', '3'),
(6700, 15, 216, 'Münchendorf', 'AT', '3'),
(6701, 15, 216, 'Neidling', 'AT', '3'),
(6702, 15, 216, 'Neu-Guntramsdorf', 'AT', '3'),
(6703, 15, 216, 'Neudorf bei Staatz', 'AT', '3'),
(6704, 15, 216, 'Neufurth', 'AT', '3'),
(6705, 15, 216, 'Neuhofen an der Ybbs', 'AT', '3'),
(6706, 15, 216, 'Neulengbach', 'AT', '3'),
(6707, 15, 216, 'Neumarkt an der Ybbs', 'AT', '3'),
(6708, 15, 216, 'Neunkirchen', 'AT', '3'),
(6709, 15, 216, 'Neusiedl', 'AT', '3'),
(6710, 15, 216, 'Neusiedl an der Zaya', 'AT', '3'),
(6711, 15, 216, 'Niederhollabrunn', 'AT', '3'),
(6712, 15, 216, 'Niederleis', 'AT', '3'),
(6713, 15, 216, 'Nöchling', 'AT', '3'),
(6714, 15, 216, 'Ober-Grafendorf', 'AT', '3'),
(6715, 15, 216, 'Oberhausen', 'AT', '3'),
(6716, 15, 216, 'Oberndorf an der Melk', 'AT', '3'),
(6717, 15, 216, 'Oberndorf in der Ebene', 'AT', '3'),
(6718, 15, 216, 'Obersdorf', 'AT', '3'),
(6719, 15, 216, 'Obersiebenbrunn', 'AT', '3'),
(6720, 15, 216, 'Oberwagram', 'AT', '3'),
(6721, 15, 216, 'Oberwaltersdorf', 'AT', '3'),
(6722, 15, 216, 'Oberwölbling', 'AT', '3'),
(6723, 15, 216, 'Oehling', 'AT', '3'),
(6724, 15, 216, 'Oeynhausen', 'AT', '3'),
(6725, 15, 216, 'Opponitz', 'AT', '3'),
(6726, 15, 216, 'Orth an der Donau', 'AT', '3'),
(6727, 15, 216, 'Ottenschlag', 'AT', '3'),
(6728, 15, 216, 'Ottenthal', 'AT', '3'),
(6729, 15, 216, 'Otterthal', 'AT', '3'),
(6730, 15, 216, 'Parbasdorf', 'AT', '3'),
(6731, 15, 216, 'Paudorf', 'AT', '3'),
(6732, 15, 216, 'Payerbach', 'AT', '3'),
(6733, 15, 216, 'Penz', 'AT', '3'),
(6734, 15, 216, 'Perchtoldsdorf', 'AT', '3'),
(6735, 15, 216, 'Pernegg', 'AT', '3'),
(6736, 15, 216, 'Pernersdorf', 'AT', '3'),
(6737, 15, 216, 'Pernitz', 'AT', '3'),
(6738, 15, 216, 'Persenbeug', 'AT', '3'),
(6739, 15, 216, 'Petronell-Carnuntum', 'AT', '3'),
(6740, 15, 216, 'Petzenkirchen', 'AT', '3'),
(6741, 15, 216, 'Pfaffstätten', 'AT', '3'),
(6742, 15, 216, 'Pillichsdorf', 'AT', '3'),
(6743, 15, 216, 'Pitten', 'AT', '3'),
(6744, 15, 216, 'Pöchlarn', 'AT', '3'),
(6745, 15, 216, 'Pöggstall', 'AT', '3'),
(6746, 15, 216, 'Politischer Bezirk Amstetten', 'AT', '3'),
(6747, 15, 216, 'Politischer Bezirk Baden', 'AT', '3'),
(6748, 15, 216, 'Politischer Bezirk Bruck an der Leitha', 'AT', '3'),
(6749, 15, 216, 'Politischer Bezirk Gänserndorf', 'AT', '3'),
(6750, 15, 216, 'Politischer Bezirk Gmünd', 'AT', '3'),
(6751, 15, 216, 'Politischer Bezirk Hollabrunn', 'AT', '3'),
(6752, 15, 216, 'Politischer Bezirk Horn', 'AT', '3'),
(6753, 15, 216, 'Politischer Bezirk Korneuburg', 'AT', '3'),
(6754, 15, 216, 'Politischer Bezirk Krems', 'AT', '3'),
(6755, 15, 216, 'Politischer Bezirk Lilienfeld', 'AT', '3'),
(6756, 15, 216, 'Politischer Bezirk Melk', 'AT', '3'),
(6757, 15, 216, 'Politischer Bezirk Mistelbach', 'AT', '3'),
(6758, 15, 216, 'Politischer Bezirk Mödling', 'AT', '3'),
(6759, 15, 216, 'Politischer Bezirk Neunkirchen', 'AT', '3'),
(6760, 15, 216, 'Politischer Bezirk Sankt Pölten', 'AT', '3'),
(6761, 15, 216, 'Politischer Bezirk Scheibbs', 'AT', '3'),
(6762, 15, 216, 'Politischer Bezirk Tulln', 'AT', '3'),
(6763, 15, 216, 'Politischer Bezirk Waidhofen an der Thaya', 'AT', '3'),
(6764, 15, 216, 'Politischer Bezirk Wiener Neustadt', 'AT', '3'),
(6765, 15, 216, 'Politischer Bezirk Zwettl', 'AT', '3'),
(6766, 15, 216, 'Pottenbrunn', 'AT', '3'),
(6767, 15, 216, 'Pottendorf', 'AT', '3'),
(6768, 15, 216, 'Pottenstein', 'AT', '3'),
(6769, 15, 216, 'Pottschach', 'AT', '3'),
(6770, 15, 216, 'Poysdorf', 'AT', '3'),
(6771, 15, 216, 'Prellenkirchen', 'AT', '3'),
(6772, 15, 216, 'Pressbaum', 'AT', '3'),
(6773, 15, 216, 'Prigglitz', 'AT', '3'),
(6774, 15, 216, 'Prinzersdorf', 'AT', '3'),
(6775, 15, 216, 'Prottes', 'AT', '3'),
(6776, 15, 216, 'Puchberg am Schneeberg', 'AT', '3'),
(6777, 15, 216, 'Puchenstuben', 'AT', '3'),
(6778, 15, 216, 'Pulkau', 'AT', '3'),
(6779, 15, 216, 'Purgstall', 'AT', '3'),
(6780, 15, 216, 'Purkersdorf', 'AT', '3'),
(6781, 15, 216, 'Pyhra', 'AT', '3'),
(6782, 15, 216, 'Raabs an der Thaya', 'AT', '3'),
(6783, 15, 216, 'Raach am Hochgebirge', 'AT', '3'),
(6784, 15, 216, 'Raasdorf', 'AT', '3'),
(6785, 15, 216, 'Rabensburg', 'AT', '3'),
(6786, 15, 216, 'Rabenstein an der Pielach', 'AT', '3'),
(6787, 15, 216, 'Ramsau', 'AT', '3'),
(6788, 15, 216, 'Randegg', 'AT', '3'),
(6789, 15, 216, 'Rannersdorf', 'AT', '3'),
(6790, 15, 216, 'Rappottenstein', 'AT', '3'),
(6791, 15, 216, 'Rastenfeld', 'AT', '3'),
(6792, 15, 216, 'Ratzersdorf an der Traisen', 'AT', '3'),
(6793, 15, 216, 'Rauchenwarth', 'AT', '3'),
(6794, 15, 216, 'Ravelsbach', 'AT', '3'),
(6795, 15, 216, 'Raxendorf', 'AT', '3'),
(6796, 15, 216, 'Rehberg', 'AT', '3'),
(6797, 15, 216, 'Reichenau an der Rax', 'AT', '3'),
(6798, 15, 216, 'Reingers', 'AT', '3'),
(6799, 15, 216, 'Reinsberg', 'AT', '3'),
(6800, 15, 216, 'Reisenberg', 'AT', '3'),
(6801, 15, 216, 'Retz', 'AT', '3'),
(6802, 15, 216, 'Rohr im Gebirge', 'AT', '3'),
(6803, 15, 216, 'Rohrau', 'AT', '3'),
(6804, 15, 216, 'Rohrbach an der Gölsen', 'AT', '3'),
(6805, 15, 216, 'Röhrenbach', 'AT', '3'),
(6806, 15, 216, 'Rohrendorf bei Krems', 'AT', '3'),
(6807, 15, 216, 'Röschitz', 'AT', '3'),
(6808, 15, 216, 'Rosenau am Sonntagberg', 'AT', '3'),
(6809, 15, 216, 'Ruprechtshofen', 'AT', '3'),
(6810, 15, 216, 'Sallingberg', 'AT', '3'),
(6811, 15, 216, 'Sankt Aegyd am Neuwalde', 'AT', '3'),
(6812, 15, 216, 'Sankt Andrä vor dem Hagenthale', 'AT', '3'),
(6813, 15, 216, 'Sankt Corona am Wechsel', 'AT', '3'),
(6814, 15, 216, 'Sankt Georgen am Ybbsfelde', 'AT', '3'),
(6815, 15, 216, 'Sankt Georgen an der Leys', 'AT', '3'),
(6816, 15, 216, 'Sankt Leonhard am Forst', 'AT', '3'),
(6817, 15, 216, 'Sankt Leonhard am Hornerwald', 'AT', '3'),
(6818, 15, 216, 'Sankt Margarethen an der Sierning', 'AT', '3'),
(6819, 15, 216, 'Sankt Martin am Ybbsfelde', 'AT', '3'),
(6820, 15, 216, 'Sankt Pantaleon', 'AT', '3'),
(6821, 15, 216, 'Sankt Peter in der Au Markt', 'AT', '3'),
(6822, 15, 216, 'Sankt Pölten', 'AT', '3'),
(6823, 15, 216, 'Sankt Pölten Stadt', 'AT', '3'),
(6824, 15, 216, 'Sankt Valentin', 'AT', '3'),
(6825, 15, 216, 'Sankt Veit an der Gölsen', 'AT', '3'),
(6826, 15, 216, 'Scharndorf', 'AT', '3'),
(6827, 15, 216, 'Scheibbs', 'AT', '3'),
(6828, 15, 216, 'Schleinbach', 'AT', '3'),
(6829, 15, 216, 'Schönau an der Triesting', 'AT', '3'),
(6830, 15, 216, 'Schönbach', 'AT', '3'),
(6831, 15, 216, 'Schönkirchen-Reyersdorf', 'AT', '3'),
(6832, 15, 216, 'Schottwien', 'AT', '3'),
(6833, 15, 216, 'Schrattenbach', 'AT', '3'),
(6834, 15, 216, 'Schrattenberg', 'AT', '3'),
(6835, 15, 216, 'Schrattenthal', 'AT', '3'),
(6836, 15, 216, 'Schrems', 'AT', '3'),
(6837, 15, 216, 'Schwadorf', 'AT', '3'),
(6838, 15, 216, 'Schwarzau am Steinfeld', 'AT', '3'),
(6839, 15, 216, 'Schwarzau im Gebirge', 'AT', '3'),
(6840, 15, 216, 'Schwarzenau', 'AT', '3'),
(6841, 15, 216, 'Schwarzenbach', 'AT', '3'),
(6842, 15, 216, 'Schwarzenbach an der Pielach', 'AT', '3'),
(6843, 15, 216, 'Schwechat', 'AT', '3'),
(6844, 15, 216, 'Schweiggers', 'AT', '3'),
(6845, 15, 216, 'Seebenstein', 'AT', '3'),
(6846, 15, 216, 'Seibersdorf', 'AT', '3'),
(6847, 15, 216, 'Seitenstetten Markt', 'AT', '3'),
(6848, 15, 216, 'Semmering', 'AT', '3'),
(6849, 15, 216, 'Senftenberg', 'AT', '3'),
(6850, 15, 216, 'Seyring', 'AT', '3'),
(6851, 15, 216, 'Sieghartskirchen', 'AT', '3'),
(6852, 15, 216, 'Sierndorf', 'AT', '3'),
(6853, 15, 216, 'Sigmundsherberg', 'AT', '3'),
(6854, 15, 216, 'Sitzendorf an der Schmida', 'AT', '3'),
(6855, 15, 216, 'Sollenau', 'AT', '3'),
(6856, 15, 216, 'Sommerein', 'AT', '3'),
(6857, 15, 216, 'Sonntagberg', 'AT', '3'),
(6858, 15, 216, 'Sooss', 'AT', '3'),
(6859, 15, 216, 'Spannberg', 'AT', '3'),
(6860, 15, 216, 'Spillern', 'AT', '3'),
(6861, 15, 216, 'Spitz', 'AT', '3'),
(6862, 15, 216, 'Spratzern', 'AT', '3'),
(6863, 15, 216, 'Staatz', 'AT', '3'),
(6864, 15, 216, 'Stattersdorf', 'AT', '3'),
(6865, 15, 216, 'Statzendorf', 'AT', '3'),
(6866, 15, 216, 'Stein an der Donau', 'AT', '3'),
(6867, 15, 216, 'Steinabrückl', 'AT', '3'),
(6868, 15, 216, 'Steinakirchen am Forst', 'AT', '3'),
(6869, 15, 216, 'Stephanshart', 'AT', '3'),
(6870, 15, 216, 'Stetteldorf am Wagram', 'AT', '3'),
(6871, 15, 216, 'Stetten', 'AT', '3'),
(6872, 15, 216, 'Stockerau', 'AT', '3'),
(6873, 15, 216, 'Stollhofen', 'AT', '3'),
(6874, 15, 216, 'Stössing', 'AT', '3'),
(6875, 15, 216, 'Strass', 'AT', '3'),
(6876, 15, 216, 'Strasshof an der Nordbahn', 'AT', '3'),
(6877, 15, 216, 'Stratzing', 'AT', '3'),
(6878, 15, 216, 'Strengberg', 'AT', '3'),
(6879, 15, 216, 'Stronsdorf', 'AT', '3'),
(6880, 15, 216, 'Tattendorf', 'AT', '3'),
(6881, 15, 216, 'Teesdorf', 'AT', '3'),
(6882, 15, 216, 'Ternitz', 'AT', '3'),
(6883, 15, 216, 'Thaya', 'AT', '3'),
(6884, 15, 216, 'Theresienfeld', 'AT', '3'),
(6885, 15, 216, 'Thomasberg', 'AT', '3'),
(6886, 15, 216, 'Tiefenbach', 'AT', '3'),
(6887, 15, 216, 'Traisen', 'AT', '3'),
(6888, 15, 216, 'Traiskirchen', 'AT', '3'),
(6889, 15, 216, 'Traismauer', 'AT', '3'),
(6890, 15, 216, 'Trattenbach', 'AT', '3'),
(6891, 15, 216, 'Trautmannsdorf an der Leitha', 'AT', '3'),
(6892, 15, 216, 'Tribuswinkel', 'AT', '3'),
(6893, 15, 216, 'Trumau', 'AT', '3'),
(6894, 15, 216, 'Tulbing', 'AT', '3'),
(6895, 15, 216, 'Tulln', 'AT', '3'),
(6896, 15, 216, 'Tullnerbach-Lawies', 'AT', '3'),
(6897, 15, 216, 'Türnitz', 'AT', '3'),
(6898, 15, 216, 'Ulrichskirchen', 'AT', '3'),
(6899, 15, 216, 'Untersiebenbrunn', 'AT', '3'),
(6900, 15, 216, 'Unterstinkenbrunn', 'AT', '3'),
(6901, 15, 216, 'Unterwagram', 'AT', '3'),
(6902, 15, 216, 'Unterwaltersdorf', 'AT', '3'),
(6903, 15, 216, 'Velm', 'AT', '3'),
(6904, 15, 216, 'Viehofen', 'AT', '3'),
(6905, 15, 216, 'Vitis', 'AT', '3'),
(6906, 15, 216, 'Vösendorf', 'AT', '3'),
(6907, 15, 216, 'Waidhofen an der Thaya', 'AT', '3'),
(6908, 15, 216, 'Waidhofen an der Ybbs', 'AT', '3'),
(6909, 15, 216, 'Waidhofen an der Ybbs Stadt', 'AT', '3'),
(6910, 15, 216, 'Waidmannsfeld', 'AT', '3'),
(6911, 15, 216, 'Waldegg', 'AT', '3'),
(6912, 15, 216, 'Waldenstein', 'AT', '3'),
(6913, 15, 216, 'Waldhausen', 'AT', '3'),
(6914, 15, 216, 'Waldkirchen an der Thaya', 'AT', '3'),
(6915, 15, 216, 'Wallsee', 'AT', '3'),
(6916, 15, 216, 'Walpersbach', 'AT', '3'),
(6917, 15, 216, 'Wang', 'AT', '3'),
(6918, 15, 216, 'Warth', 'AT', '3'),
(6919, 15, 216, 'Wartmannstetten', 'AT', '3'),
(6920, 15, 216, 'Weidling', 'AT', '3'),
(6921, 15, 216, 'Weigelsdorf', 'AT', '3'),
(6922, 15, 216, 'Weikendorf', 'AT', '3'),
(6923, 15, 216, 'Weikersdorf am Steinfelde', 'AT', '3'),
(6924, 15, 216, 'Weinburg', 'AT', '3'),
(6925, 15, 216, 'Weinzierl am Walde', 'AT', '3'),
(6926, 15, 216, 'Weinzierl bei Krems', 'AT', '3'),
(6927, 15, 216, 'Weissenbach an der Triesting', 'AT', '3'),
(6928, 15, 216, 'Weißenkirchen in der Wachau', 'AT', '3'),
(6929, 15, 216, 'Weistrach', 'AT', '3'),
(6930, 15, 216, 'Weiten', 'AT', '3'),
(6931, 15, 216, 'Weitersfeld', 'AT', '3'),
(6932, 15, 216, 'Weitra', 'AT', '3'),
(6933, 15, 216, 'Wiener Neudorf', 'AT', '3'),
(6934, 15, 216, 'Wiener Neustadt', 'AT', '3'),
(6935, 15, 216, 'Wiener Neustadt Stadt', 'AT', '3'),
(6936, 15, 216, 'Wienersdorf', 'AT', '3'),
(6937, 15, 216, 'Wieselburg', 'AT', '3'),
(6938, 15, 216, 'Wiesmath', 'AT', '3'),
(6939, 15, 216, 'Wilfersdorf', 'AT', '3'),
(6940, 15, 216, 'Wilfleinsdorf', 'AT', '3'),
(6941, 15, 216, 'Wilhelmsburg', 'AT', '3'),
(6942, 15, 216, 'Willendorf am Steinfelde', 'AT', '3'),
(6943, 15, 216, 'Wimpassing im Schwarzatale', 'AT', '3'),
(6944, 15, 216, 'Windhag', 'AT', '3'),
(6945, 15, 216, 'Windigsteig', 'AT', '3'),
(6946, 15, 216, 'Winklarn', 'AT', '3'),
(6947, 15, 216, 'Winzendorf', 'AT', '3'),
(6948, 15, 216, 'Wolfpassing', 'AT', '3'),
(6949, 15, 216, 'Wolfsbach', 'AT', '3'),
(6950, 15, 216, 'Wolfsgraben', 'AT', '3'),
(6951, 15, 216, 'Wolfsthal', 'AT', '3'),
(6952, 15, 216, 'Wolkersdorf im Weinviertel', 'AT', '3'),
(6953, 15, 216, 'Wöllersdorf', 'AT', '3'),
(6954, 15, 216, 'Wördern', 'AT', '3'),
(6955, 15, 216, 'Wullersdorf', 'AT', '3'),
(6956, 15, 216, 'Würflach', 'AT', '3'),
(6957, 15, 216, 'Würmla', 'AT', '3'),
(6958, 15, 216, 'Ybbs an der Donau', 'AT', '3'),
(6959, 15, 216, 'Ybbsitz', 'AT', '3'),
(6960, 15, 216, 'Ysper', 'AT', '3'),
(6961, 15, 216, 'Zeillern', 'AT', '3'),
(6962, 15, 216, 'Zeiselmauer', 'AT', '3'),
(6963, 15, 216, 'Zell-Arzberg', 'AT', '3'),
(6964, 15, 216, 'Zell-Markt', 'AT', '3'),
(6965, 15, 216, 'Zellerndorf', 'AT', '3'),
(6966, 15, 216, 'Ziersdorf', 'AT', '3'),
(6967, 15, 216, 'Zillingdorf', 'AT', '3'),
(6968, 15, 216, 'Zistersdorf', 'AT', '3'),
(6969, 15, 216, 'Zöbern', 'AT', '3'),
(6970, 15, 216, 'Zwentendorf', 'AT', '3'),
(6971, 15, 216, 'Zwettl Stadt', 'AT', '3'),
(6972, 15, 216, 'Zwölfaxing', 'AT', '3'),
(6973, 15, 217, 'Abtenau', 'AT', '5'),
(6974, 15, 217, 'Adnet', 'AT', '5'),
(6975, 15, 217, 'Altenmarkt im Pongau', 'AT', '5'),
(6976, 15, 217, 'Anger', 'AT', '5'),
(6977, 15, 217, 'Anif', 'AT', '5'),
(6978, 15, 217, 'Anthering', 'AT', '5'),
(6979, 15, 217, 'Au', 'AT', '5'),
(6980, 15, 217, 'Bad Gastein', 'AT', '5'),
(6981, 15, 217, 'Bad Hofgastein', 'AT', '5'),
(6982, 15, 217, 'Bergheim', 'AT', '5'),
(6983, 15, 217, 'Berndorf bei Salzburg', 'AT', '5'),
(6984, 15, 217, 'Bischofshofen', 'AT', '5'),
(6985, 15, 217, 'Bramberg am Wildkogel', 'AT', '5'),
(6986, 15, 217, 'Bruck an der Großglocknerstraße', 'AT', '5'),
(6987, 15, 217, 'Burgfried', 'AT', '5'),
(6988, 15, 217, 'Bürmoos', 'AT', '5'),
(6989, 15, 217, 'Dienten am Hochkönig', 'AT', '5'),
(6990, 15, 217, 'Dorfbeuern', 'AT', '5'),
(6991, 15, 217, 'Dorfgastein', 'AT', '5'),
(6992, 15, 217, 'Eben im Pongau', 'AT', '5'),
(6993, 15, 217, 'Ebenau', 'AT', '5'),
(6994, 15, 217, 'Eching', 'AT', '5'),
(6995, 15, 217, 'Elixhausen', 'AT', '5'),
(6996, 15, 217, 'Elsbethen', 'AT', '5'),
(6997, 15, 217, 'Esch', 'AT', '5'),
(6998, 15, 217, 'Eugendorf', 'AT', '5'),
(6999, 15, 217, 'Faistenau', 'AT', '5'),
(7000, 15, 217, 'Filzmoos', 'AT', '5');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(7001, 15, 217, 'Flachau', 'AT', '5'),
(7002, 15, 217, 'Forstau', 'AT', '5'),
(7003, 15, 217, 'Fuschl am See', 'AT', '5'),
(7004, 15, 217, 'Georgenberg', 'AT', '5'),
(7005, 15, 217, 'Glanegg', 'AT', '5'),
(7006, 15, 217, 'Glasenbach', 'AT', '5'),
(7007, 15, 217, 'Golling an der Salzach', 'AT', '5'),
(7008, 15, 217, 'Grödig', 'AT', '5'),
(7009, 15, 217, 'Grossarl', 'AT', '5'),
(7010, 15, 217, 'Grossgmain', 'AT', '5'),
(7011, 15, 217, 'Habach', 'AT', '5'),
(7012, 15, 217, 'Hallein', 'AT', '5'),
(7013, 15, 217, 'Hallwang', 'AT', '5'),
(7014, 15, 217, 'Henndorf am Wallersee', 'AT', '5'),
(7015, 15, 217, 'Himmelreich', 'AT', '5'),
(7016, 15, 217, 'Hinterglemm', 'AT', '5'),
(7017, 15, 217, 'Hintersee', 'AT', '5'),
(7018, 15, 217, 'Hof', 'AT', '5'),
(7019, 15, 217, 'Hof bei Salzburg', 'AT', '5'),
(7020, 15, 217, 'Hollersbach im Pinzgau', 'AT', '5'),
(7021, 15, 217, 'Hüttau', 'AT', '5'),
(7022, 15, 217, 'Hüttschlag', 'AT', '5'),
(7023, 15, 217, 'Irrsdorf', 'AT', '5'),
(7024, 15, 217, 'Kaprun', 'AT', '5'),
(7025, 15, 217, 'Kleinarl', 'AT', '5'),
(7026, 15, 217, 'Koppl', 'AT', '5'),
(7027, 15, 217, 'Köstendorf', 'AT', '5'),
(7028, 15, 217, 'Krimml', 'AT', '5'),
(7029, 15, 217, 'Krispl', 'AT', '5'),
(7030, 15, 217, 'Kuchl', 'AT', '5'),
(7031, 15, 217, 'Lamprechtshausen', 'AT', '5'),
(7032, 15, 217, 'Lehen', 'AT', '5'),
(7033, 15, 217, 'Lend', 'AT', '5'),
(7034, 15, 217, 'Lengfelden', 'AT', '5'),
(7035, 15, 217, 'Leogang', 'AT', '5'),
(7036, 15, 217, 'Lofer', 'AT', '5'),
(7037, 15, 217, 'Maishofen', 'AT', '5'),
(7038, 15, 217, 'Maria Alm am Steinernen Meer', 'AT', '5'),
(7039, 15, 217, 'Mariapfarr', 'AT', '5'),
(7040, 15, 217, 'Mattsee', 'AT', '5'),
(7041, 15, 217, 'Mauterndorf', 'AT', '5'),
(7042, 15, 217, 'Mitterberghütten', 'AT', '5'),
(7043, 15, 217, 'Mitterhofen', 'AT', '5'),
(7044, 15, 217, 'Mittersill', 'AT', '5'),
(7045, 15, 217, 'Mühlbach am Hochkönig', 'AT', '5'),
(7046, 15, 217, 'Neualm', 'AT', '5'),
(7047, 15, 217, 'Neukirchen am Großvenediger', 'AT', '5'),
(7048, 15, 217, 'Neumarkt am Wallersee', 'AT', '5'),
(7049, 15, 217, 'Niederalm', 'AT', '5'),
(7050, 15, 217, 'Niedernsill', 'AT', '5'),
(7051, 15, 217, 'Nußdorf am Haunsberg', 'AT', '5'),
(7052, 15, 217, 'Oberalm', 'AT', '5'),
(7053, 15, 217, 'Obergäu', 'AT', '5'),
(7054, 15, 217, 'Oberndorf bei Salzburg', 'AT', '5'),
(7055, 15, 217, 'Obertrum am See', 'AT', '5'),
(7056, 15, 217, 'Pfarrwerfen', 'AT', '5'),
(7057, 15, 217, 'Pichl', 'AT', '5'),
(7058, 15, 217, 'Piesendorf', 'AT', '5'),
(7059, 15, 217, 'Plainfeld', 'AT', '5'),
(7060, 15, 217, 'Plankenau', 'AT', '5'),
(7061, 15, 217, 'Politischer Bezirk Hallein', 'AT', '5'),
(7062, 15, 217, 'Politischer Bezirk Salzburg-Umgebung', 'AT', '5'),
(7063, 15, 217, 'Politischer Bezirk Sankt Johann im Pongau', 'AT', '5'),
(7064, 15, 217, 'Politischer Bezirk Tamsweg', 'AT', '5'),
(7065, 15, 217, 'Puch bei Hallein', 'AT', '5'),
(7066, 15, 217, 'Radstadt', 'AT', '5'),
(7067, 15, 217, 'Ramingstein', 'AT', '5'),
(7068, 15, 217, 'Rauris', 'AT', '5'),
(7069, 15, 217, 'Reinbach', 'AT', '5'),
(7070, 15, 217, 'Reitberg', 'AT', '5'),
(7071, 15, 217, 'Saalbach', 'AT', '5'),
(7072, 15, 217, 'Saalfelden am Steinernen Meer', 'AT', '5'),
(7073, 15, 217, 'Salzburg', 'AT', '5'),
(7074, 15, 217, 'Salzburg Stadt', 'AT', '5'),
(7075, 15, 217, 'Sankt Andrä im Lungau', 'AT', '5'),
(7076, 15, 217, 'Sankt Gilgen', 'AT', '5'),
(7077, 15, 217, 'Sankt Johann im Pongau', 'AT', '5'),
(7078, 15, 217, 'Sankt Leonhard', 'AT', '5'),
(7079, 15, 217, 'Sankt Margarethen im Lungau', 'AT', '5'),
(7080, 15, 217, 'Sankt Martin bei Lofer', 'AT', '5'),
(7081, 15, 217, 'Sankt Michael im Lungau', 'AT', '5'),
(7082, 15, 217, 'Sankt Veit im Pongau', 'AT', '5'),
(7083, 15, 217, 'Scheffau am Tennengebirge', 'AT', '5'),
(7084, 15, 217, 'Schleedorf', 'AT', '5'),
(7085, 15, 217, 'Schwarzach im Pongau', 'AT', '5'),
(7086, 15, 217, 'Seeham', 'AT', '5'),
(7087, 15, 217, 'Seekirchen am Wallersee', 'AT', '5'),
(7088, 15, 217, 'Seewalchen', 'AT', '5'),
(7089, 15, 217, 'Siezenheim', 'AT', '5'),
(7090, 15, 217, 'St. Martin of Tennengebirge', 'AT', '5'),
(7091, 15, 217, 'Strasswalchen', 'AT', '5'),
(7092, 15, 217, 'Strobl', 'AT', '5'),
(7093, 15, 217, 'Stuhlfelden', 'AT', '5'),
(7094, 15, 217, 'Tamsweg', 'AT', '5'),
(7095, 15, 217, 'Taugl', 'AT', '5'),
(7096, 15, 217, 'Taxach', 'AT', '5'),
(7097, 15, 217, 'Taxenbach', 'AT', '5'),
(7098, 15, 217, 'Thalgau', 'AT', '5'),
(7099, 15, 217, 'Thomatal', 'AT', '5'),
(7100, 15, 217, 'Thumersbach', 'AT', '5'),
(7101, 15, 217, 'Tweng', 'AT', '5'),
(7102, 15, 217, 'Unken', 'AT', '5'),
(7103, 15, 217, 'Unternberg', 'AT', '5'),
(7104, 15, 217, 'Untertauern', 'AT', '5'),
(7105, 15, 217, 'Uttendorf', 'AT', '5'),
(7106, 15, 217, 'Viehhausen', 'AT', '5'),
(7107, 15, 217, 'Viehhofen', 'AT', '5'),
(7108, 15, 217, 'Vigaun', 'AT', '5'),
(7109, 15, 217, 'Wagnergraben', 'AT', '5'),
(7110, 15, 217, 'Wagrain', 'AT', '5'),
(7111, 15, 217, 'Walchen', 'AT', '5'),
(7112, 15, 217, 'Wald im Pinzgau', 'AT', '5'),
(7113, 15, 217, 'Waldprechting', 'AT', '5'),
(7114, 15, 217, 'Wals', 'AT', '5'),
(7115, 15, 217, 'Walserfeld', 'AT', '5'),
(7116, 15, 217, 'Werfen', 'AT', '5'),
(7117, 15, 217, 'Werfenweng', 'AT', '5'),
(7118, 15, 217, 'Zederhaus', 'AT', '5'),
(7119, 15, 217, 'Zell am See', 'AT', '5'),
(7120, 15, 218, 'Abtissendorf', 'AT', '6'),
(7121, 15, 218, 'Admont', 'AT', '6'),
(7122, 15, 218, 'Aflenz Kurort', 'AT', '6'),
(7123, 15, 218, 'Aibl', 'AT', '6'),
(7124, 15, 218, 'Aigen im Ennstal', 'AT', '6'),
(7125, 15, 218, 'Albersdorf', 'AT', '6'),
(7126, 15, 218, 'Allerheiligen bei Wildon', 'AT', '6'),
(7127, 15, 218, 'Allerheiligen im Mürztal', 'AT', '6'),
(7128, 15, 218, 'Altaussee', 'AT', '6'),
(7129, 15, 218, 'Altenmarkt bei Fürstenfeld', 'AT', '6'),
(7130, 15, 218, 'Altenmarkt bei Sankt Gallen', 'AT', '6'),
(7131, 15, 218, 'Andritz', 'AT', '6'),
(7132, 15, 218, 'Anger', 'AT', '6'),
(7133, 15, 218, 'Apfelberg', 'AT', '6'),
(7134, 15, 218, 'Ardning', 'AT', '6'),
(7135, 15, 218, 'Arnfels', 'AT', '6'),
(7136, 15, 218, 'Arzberg', 'AT', '6'),
(7137, 15, 218, 'Attendorf', 'AT', '6'),
(7138, 15, 218, 'Auersbach', 'AT', '6'),
(7139, 15, 218, 'Bad Aussee', 'AT', '6'),
(7140, 15, 218, 'Bad Blumau', 'AT', '6'),
(7141, 15, 218, 'Bad Gams', 'AT', '6'),
(7142, 15, 218, 'Bad Gleichenberg', 'AT', '6'),
(7143, 15, 218, 'Bad Radkersburg', 'AT', '6'),
(7144, 15, 218, 'Bad Waltersdorf', 'AT', '6'),
(7145, 15, 218, 'Baierdorf-Umgebung', 'AT', '6'),
(7146, 15, 218, 'Bairisch Kölldorf', 'AT', '6'),
(7147, 15, 218, 'Bärnbach', 'AT', '6'),
(7148, 15, 218, 'Baumgarten bei Gnas', 'AT', '6'),
(7149, 15, 218, 'Berndorf', 'AT', '6'),
(7150, 15, 218, 'Bierbaum am Auersbach', 'AT', '6'),
(7151, 15, 218, 'Birkfeld', 'AT', '6'),
(7152, 15, 218, 'Blaindorf', 'AT', '6'),
(7153, 15, 218, 'Breitenfeld am Tannenriegel', 'AT', '6'),
(7154, 15, 218, 'Breitenfeld an der Rittschein', 'AT', '6'),
(7155, 15, 218, 'Bretstein', 'AT', '6'),
(7156, 15, 218, 'Bruck an der Mur', 'AT', '6'),
(7157, 15, 218, 'Brunn', 'AT', '6'),
(7158, 15, 218, 'Burgau', 'AT', '6'),
(7159, 15, 218, 'Dechantskirchen', 'AT', '6'),
(7160, 15, 218, 'Deuchendorf', 'AT', '6'),
(7161, 15, 218, 'Deutsch Goritz', 'AT', '6'),
(7162, 15, 218, 'Deutschfeistritz', 'AT', '6'),
(7163, 15, 218, 'Deutschlandsberg', 'AT', '6'),
(7164, 15, 218, 'Diemlach', 'AT', '6'),
(7165, 15, 218, 'Dienersdorf', 'AT', '6'),
(7166, 15, 218, 'Dietersdorf', 'AT', '6'),
(7167, 15, 218, 'Dietersdorf am Gnasbach', 'AT', '6'),
(7168, 15, 218, 'Donawitz', 'AT', '6'),
(7169, 15, 218, 'Donnersbach', 'AT', '6'),
(7170, 15, 218, 'Dürnstein in der Steiermark', 'AT', '6'),
(7171, 15, 218, 'Ebersdorf', 'AT', '6'),
(7172, 15, 218, 'Edelsbach bei Feldbach', 'AT', '6'),
(7173, 15, 218, 'Edelschrott', 'AT', '6'),
(7174, 15, 218, 'Edelsgrub', 'AT', '6'),
(7175, 15, 218, 'Edelstauden', 'AT', '6'),
(7176, 15, 218, 'Eggenberg', 'AT', '6'),
(7177, 15, 218, 'Eggersdorf bei Graz', 'AT', '6'),
(7178, 15, 218, 'Ehrenhausen', 'AT', '6'),
(7179, 15, 218, 'Eibiswald', 'AT', '6'),
(7180, 15, 218, 'Eichberg', 'AT', '6'),
(7181, 15, 218, 'Eichfeld', 'AT', '6'),
(7182, 15, 218, 'Eisbach', 'AT', '6'),
(7183, 15, 218, 'Eisenerz', 'AT', '6'),
(7184, 15, 218, 'Empersdorf', 'AT', '6'),
(7185, 15, 218, 'Eppenstein', 'AT', '6'),
(7186, 15, 218, 'Falkenburg', 'AT', '6'),
(7187, 15, 218, 'Farrach', 'AT', '6'),
(7188, 15, 218, 'Fehring', 'AT', '6'),
(7189, 15, 218, 'Feistritz bei Knittelfeld', 'AT', '6'),
(7190, 15, 218, 'Feldbach', 'AT', '6'),
(7191, 15, 218, 'Feldkirchen bei Graz', 'AT', '6'),
(7192, 15, 218, 'Fernitz', 'AT', '6'),
(7193, 15, 218, 'Fischbach', 'AT', '6'),
(7194, 15, 218, 'Fladnitz im Raabtal', 'AT', '6'),
(7195, 15, 218, 'Flatschach', 'AT', '6'),
(7196, 15, 218, 'Floing', 'AT', '6'),
(7197, 15, 218, 'Fohnsdorf', 'AT', '6'),
(7198, 15, 218, 'Frannach', 'AT', '6'),
(7199, 15, 218, 'Frauenberg', 'AT', '6'),
(7200, 15, 218, 'Freidorf an der Laßnitz', 'AT', '6'),
(7201, 15, 218, 'Freiland bei Deutschlandsberg', 'AT', '6'),
(7202, 15, 218, 'Friedberg', 'AT', '6'),
(7203, 15, 218, 'Frohnleiten', 'AT', '6'),
(7204, 15, 218, 'Fürstenfeld', 'AT', '6'),
(7205, 15, 218, 'Gaal', 'AT', '6'),
(7206, 15, 218, 'Gabersdorf', 'AT', '6'),
(7207, 15, 218, 'Gallmannsegg', 'AT', '6'),
(7208, 15, 218, 'Gamlitz', 'AT', '6'),
(7209, 15, 218, 'Gams bei Hieflau', 'AT', '6'),
(7210, 15, 218, 'Ganz', 'AT', '6'),
(7211, 15, 218, 'Garanas', 'AT', '6'),
(7212, 15, 218, 'Gasen', 'AT', '6'),
(7213, 15, 218, 'Geidorf', 'AT', '6'),
(7214, 15, 218, 'Geistthal', 'AT', '6'),
(7215, 15, 218, 'Gersdorf an der Feistritz', 'AT', '6'),
(7216, 15, 218, 'Gleinstätten', 'AT', '6'),
(7217, 15, 218, 'Gleisdorf', 'AT', '6'),
(7218, 15, 218, 'Glojach', 'AT', '6'),
(7219, 15, 218, 'Gnas', 'AT', '6'),
(7220, 15, 218, 'Gniebing', 'AT', '6'),
(7221, 15, 218, 'Gosdorf', 'AT', '6'),
(7222, 15, 218, 'Göss', 'AT', '6'),
(7223, 15, 218, 'Gössenberg', 'AT', '6'),
(7224, 15, 218, 'Gossendorf', 'AT', '6'),
(7225, 15, 218, 'Gösting', 'AT', '6'),
(7226, 15, 218, 'Göttelsberg', 'AT', '6'),
(7227, 15, 218, 'Grabersdorf', 'AT', '6'),
(7228, 15, 218, 'Grafendorf bei Hartberg', 'AT', '6'),
(7229, 15, 218, 'Gralla', 'AT', '6'),
(7230, 15, 218, 'Grambach', 'AT', '6'),
(7231, 15, 218, 'Gratkorn', 'AT', '6'),
(7232, 15, 218, 'Gratwein', 'AT', '6'),
(7233, 15, 218, 'Graz', 'AT', '6'),
(7234, 15, 218, 'Graz Stadt', 'AT', '6'),
(7235, 15, 218, 'Greisdorf', 'AT', '6'),
(7236, 15, 218, 'Gressenberg', 'AT', '6'),
(7237, 15, 218, 'Gries', 'AT', '6'),
(7238, 15, 218, 'Gröbming', 'AT', '6'),
(7239, 15, 218, 'Groß Sankt Florian', 'AT', '6'),
(7240, 15, 218, 'Großklein', 'AT', '6'),
(7241, 15, 218, 'Großlobming', 'AT', '6'),
(7242, 15, 218, 'Großsölk', 'AT', '6'),
(7243, 15, 218, 'Grosssulz', 'AT', '6'),
(7244, 15, 218, 'Gundersdorf', 'AT', '6'),
(7245, 15, 218, 'Hafendorf', 'AT', '6'),
(7246, 15, 218, 'Hainersdorf', 'AT', '6'),
(7247, 15, 218, 'Hainsdorf im Schwarzautal', 'AT', '6'),
(7248, 15, 218, 'Halbenrain', 'AT', '6'),
(7249, 15, 218, 'Hall bei Admont', 'AT', '6'),
(7250, 15, 218, 'Hart bei Graz', 'AT', '6'),
(7251, 15, 218, 'Hartberg', 'AT', '6'),
(7252, 15, 218, 'Hartl', 'AT', '6'),
(7253, 15, 218, 'Hartmannsdorf', 'AT', '6'),
(7254, 15, 218, 'Hatzendorf', 'AT', '6'),
(7255, 15, 218, 'Haus', 'AT', '6'),
(7256, 15, 218, 'Haus im Ennstal', 'AT', '6'),
(7257, 15, 218, 'Hausmannstätten', 'AT', '6'),
(7258, 15, 218, 'Heiligenkreuz am Waasen', 'AT', '6'),
(7259, 15, 218, 'Heimschuh', 'AT', '6'),
(7260, 15, 218, 'Hengsberg', 'AT', '6'),
(7261, 15, 218, 'Hetzendorf', 'AT', '6'),
(7262, 15, 218, 'Hieflau', 'AT', '6'),
(7263, 15, 218, 'Hinterberg', 'AT', '6'),
(7264, 15, 218, 'Hirnsdorf', 'AT', '6'),
(7265, 15, 218, 'Hitzendorf', 'AT', '6'),
(7266, 15, 218, 'Hochtregist', 'AT', '6'),
(7267, 15, 218, 'Höf', 'AT', '6'),
(7268, 15, 218, 'Hof bei Straden', 'AT', '6'),
(7269, 15, 218, 'Hofstätten an der Raab', 'AT', '6'),
(7270, 15, 218, 'Hohenau an der Raab', 'AT', '6'),
(7271, 15, 218, 'Hohentauern', 'AT', '6'),
(7272, 15, 218, 'Hollenegg', 'AT', '6'),
(7273, 15, 218, 'Hönigsberg', 'AT', '6'),
(7274, 15, 218, 'Ilz', 'AT', '6'),
(7275, 15, 218, 'Innere Stadt', 'AT', '6'),
(7276, 15, 218, 'Irdning', 'AT', '6'),
(7277, 15, 218, 'Jagerberg', 'AT', '6'),
(7278, 15, 218, 'Jakomini', 'AT', '6'),
(7279, 15, 218, 'Johnsbach', 'AT', '6'),
(7280, 15, 218, 'Judenburg', 'AT', '6'),
(7281, 15, 218, 'Judendorf', 'AT', '6'),
(7282, 15, 218, 'Kaibing', 'AT', '6'),
(7283, 15, 218, 'Kainach bei Voitsberg', 'AT', '6'),
(7284, 15, 218, 'Kainbach', 'AT', '6'),
(7285, 15, 218, 'Kaindorf', 'AT', '6'),
(7286, 15, 218, 'Kaindorf an der Sulm', 'AT', '6'),
(7287, 15, 218, 'Kalsdorf bei Graz', 'AT', '6'),
(7288, 15, 218, 'Kalwang', 'AT', '6'),
(7289, 15, 218, 'Kammern im Liesingtal', 'AT', '6'),
(7290, 15, 218, 'Kapellen', 'AT', '6'),
(7291, 15, 218, 'Kapfenberg', 'AT', '6'),
(7292, 15, 218, 'Kapfenstein', 'AT', '6'),
(7293, 15, 218, 'Kindberg', 'AT', '6'),
(7294, 15, 218, 'Kirchbach in Steiermark', 'AT', '6'),
(7295, 15, 218, 'Kirchberg an der Raab', 'AT', '6'),
(7296, 15, 218, 'Kirchenviertel', 'AT', '6'),
(7297, 15, 218, 'Kitzeck im Sausal', 'AT', '6'),
(7298, 15, 218, 'Kleinlobming', 'AT', '6'),
(7299, 15, 218, 'Kleinsöding', 'AT', '6'),
(7300, 15, 218, 'Kleinsölk', 'AT', '6'),
(7301, 15, 218, 'Klöch', 'AT', '6'),
(7302, 15, 218, 'Kloster', 'AT', '6'),
(7303, 15, 218, 'Knittelfeld', 'AT', '6'),
(7304, 15, 218, 'Kobenz', 'AT', '6'),
(7305, 15, 218, 'Köflach', 'AT', '6'),
(7306, 15, 218, 'Kohlberg', 'AT', '6'),
(7307, 15, 218, 'Kohlschwarz', 'AT', '6'),
(7308, 15, 218, 'Krakaudorf', 'AT', '6'),
(7309, 15, 218, 'Krakauhintermühlen', 'AT', '6'),
(7310, 15, 218, 'Krakauschatten', 'AT', '6'),
(7311, 15, 218, 'Kraubath an der Mur', 'AT', '6'),
(7312, 15, 218, 'Krieglach', 'AT', '6'),
(7313, 15, 218, 'Krottendorf', 'AT', '6'),
(7314, 15, 218, 'Krottendorf bei Ligist', 'AT', '6'),
(7315, 15, 218, 'Krumegg', 'AT', '6'),
(7316, 15, 218, 'Krusdorf', 'AT', '6'),
(7317, 15, 218, 'Kulm am Zirbitz', 'AT', '6'),
(7318, 15, 218, 'Kumberg', 'AT', '6'),
(7319, 15, 218, 'Labuch', 'AT', '6'),
(7320, 15, 218, 'Lafnitz', 'AT', '6'),
(7321, 15, 218, 'Landl', 'AT', '6'),
(7322, 15, 218, 'Lang', 'AT', '6'),
(7323, 15, 218, 'Langegg bei Graz', 'AT', '6'),
(7324, 15, 218, 'Langenwang', 'AT', '6'),
(7325, 15, 218, 'Lannach', 'AT', '6'),
(7326, 15, 218, 'Lassnitzhöhe', 'AT', '6'),
(7327, 15, 218, 'Leibnitz', 'AT', '6'),
(7328, 15, 218, 'Leitendorf', 'AT', '6'),
(7329, 15, 218, 'Leitersdorf im Raabtal', 'AT', '6'),
(7330, 15, 218, 'Leitring', 'AT', '6'),
(7331, 15, 218, 'Lend', 'AT', '6'),
(7332, 15, 218, 'Leoben', 'AT', '6'),
(7333, 15, 218, 'Leutschach', 'AT', '6'),
(7334, 15, 218, 'Liebenau', 'AT', '6'),
(7335, 15, 218, 'Lieboch', 'AT', '6'),
(7336, 15, 218, 'Liesingtal', 'AT', '6'),
(7337, 15, 218, 'Liezen', 'AT', '6'),
(7338, 15, 218, 'Ligist', 'AT', '6'),
(7339, 15, 218, 'Lödersdorf', 'AT', '6'),
(7340, 15, 218, 'Loipersdorf bei Fürstenfeld', 'AT', '6'),
(7341, 15, 218, 'Maierdorf', 'AT', '6'),
(7342, 15, 218, 'Maria Lankowitz', 'AT', '6'),
(7343, 15, 218, 'Mariahof', 'AT', '6'),
(7344, 15, 218, 'Mariatrost', 'AT', '6'),
(7345, 15, 218, 'Mariazell', 'AT', '6'),
(7346, 15, 218, 'Mautern in Steiermark', 'AT', '6'),
(7347, 15, 218, 'Mellach', 'AT', '6'),
(7348, 15, 218, 'Merkendorf', 'AT', '6'),
(7349, 15, 218, 'Mettersdorf am Saßbach', 'AT', '6'),
(7350, 15, 218, 'Michaelerberg', 'AT', '6'),
(7351, 15, 218, 'Mitterdorf an der Raab', 'AT', '6'),
(7352, 15, 218, 'Mitterdorf im Mürztal', 'AT', '6'),
(7353, 15, 218, 'Mitterlabill', 'AT', '6'),
(7354, 15, 218, 'Mitterndorf im Steirischen Salzkammergut', 'AT', '6'),
(7355, 15, 218, 'Modriach', 'AT', '6'),
(7356, 15, 218, 'Mönichwald', 'AT', '6'),
(7357, 15, 218, 'Mooskirchen', 'AT', '6'),
(7358, 15, 218, 'Mortantsch', 'AT', '6'),
(7359, 15, 218, 'Mühldorf bei Feldbach', 'AT', '6'),
(7360, 15, 218, 'Mühlen', 'AT', '6'),
(7361, 15, 218, 'Murau', 'AT', '6'),
(7362, 15, 218, 'Mureck', 'AT', '6'),
(7363, 15, 218, 'Mürzhofen', 'AT', '6'),
(7364, 15, 218, 'Mürzsteg', 'AT', '6'),
(7365, 15, 218, 'Mürzzuschlag', 'AT', '6'),
(7366, 15, 218, 'Naas', 'AT', '6'),
(7367, 15, 218, 'Nestelbach bei Graz', 'AT', '6'),
(7368, 15, 218, 'Nestelbach im Ilztal', 'AT', '6'),
(7369, 15, 218, 'Neuberg an der Mürz', 'AT', '6'),
(7370, 15, 218, 'Neudau', 'AT', '6'),
(7371, 15, 218, 'Neumarkt in Steiermark', 'AT', '6'),
(7372, 15, 218, 'Neutillmitsch', 'AT', '6'),
(7373, 15, 218, 'Niederöblarn', 'AT', '6'),
(7374, 15, 218, 'Niederschöckl', 'AT', '6'),
(7375, 15, 218, 'Niederwölz', 'AT', '6'),
(7376, 15, 218, 'Niklasdorf', 'AT', '6'),
(7377, 15, 218, 'Nitscha', 'AT', '6'),
(7378, 15, 218, 'Obdach', 'AT', '6'),
(7379, 15, 218, 'Oberaich', 'AT', '6'),
(7380, 15, 218, 'Oberdorf am Hochegg', 'AT', '6'),
(7381, 15, 218, 'Oberhaag', 'AT', '6'),
(7382, 15, 218, 'Oberkurzheim', 'AT', '6'),
(7383, 15, 218, 'Oberpremstätten', 'AT', '6'),
(7384, 15, 218, 'Oberrettenbach', 'AT', '6'),
(7385, 15, 218, 'Oberstorcha', 'AT', '6'),
(7386, 15, 218, 'Obervogau', 'AT', '6'),
(7387, 15, 218, 'Oberweg', 'AT', '6'),
(7388, 15, 218, 'Oberwölz Stadt', 'AT', '6'),
(7389, 15, 218, 'Oberzeiring', 'AT', '6'),
(7390, 15, 218, 'Öblarn', 'AT', '6'),
(7391, 15, 218, 'Oppenberg', 'AT', '6'),
(7392, 15, 218, 'Ortgraben', 'AT', '6'),
(7393, 15, 218, 'Osterwitz', 'AT', '6'),
(7394, 15, 218, 'Pack', 'AT', '6'),
(7395, 15, 218, 'Paldau', 'AT', '6'),
(7396, 15, 218, 'Palfau', 'AT', '6'),
(7397, 15, 218, 'Parschlug', 'AT', '6'),
(7398, 15, 218, 'Passail', 'AT', '6'),
(7399, 15, 218, 'Peggau', 'AT', '6'),
(7400, 15, 218, 'Perchau am Sattel', 'AT', '6'),
(7401, 15, 218, 'Perlsdorf', 'AT', '6'),
(7402, 15, 218, 'Pernegg an der Mur', 'AT', '6'),
(7403, 15, 218, 'Pertlstein', 'AT', '6'),
(7404, 15, 218, 'Piberegg', 'AT', '6'),
(7405, 15, 218, 'Pichling bei Köflach', 'AT', '6'),
(7406, 15, 218, 'Pinggau', 'AT', '6'),
(7407, 15, 218, 'Pirching am Traubenberg', 'AT', '6'),
(7408, 15, 218, 'Pirka', 'AT', '6'),
(7409, 15, 218, 'Pischelsdorf in der Steiermark', 'AT', '6'),
(7410, 15, 218, 'Pistorf', 'AT', '6'),
(7411, 15, 218, 'Pitschgau', 'AT', '6'),
(7412, 15, 218, 'Politischer Bezirk Bruck-Mürzzuschlag', 'AT', '6'),
(7413, 15, 218, 'Politischer Bezirk Deutschlandsberg', 'AT', '6'),
(7414, 15, 218, 'Politischer Bezirk Graz-Umgebung', 'AT', '6'),
(7415, 15, 218, 'Politischer Bezirk Hartberg-Fürstenfeld', 'AT', '6'),
(7416, 15, 218, 'Politischer Bezirk Leibnitz', 'AT', '6'),
(7417, 15, 218, 'Politischer Bezirk Leoben', 'AT', '6'),
(7418, 15, 218, 'Politischer Bezirk Liezen', 'AT', '6'),
(7419, 15, 218, 'Politischer Bezirk Murau', 'AT', '6'),
(7420, 15, 218, 'Politischer Bezirk Murtal', 'AT', '6'),
(7421, 15, 218, 'Politischer Bezirk Südoststeiermark', 'AT', '6'),
(7422, 15, 218, 'Politischer Bezirk Voitsberg', 'AT', '6'),
(7423, 15, 218, 'Politischer Bezirk Weiz', 'AT', '6'),
(7424, 15, 218, 'Pöllau', 'AT', '6'),
(7425, 15, 218, 'Pöllauberg', 'AT', '6'),
(7426, 15, 218, 'Pöls', 'AT', '6'),
(7427, 15, 218, 'Poppendorf', 'AT', '6'),
(7428, 15, 218, 'Preding', 'AT', '6'),
(7429, 15, 218, 'Proleb', 'AT', '6'),
(7430, 15, 218, 'Pruggern', 'AT', '6'),
(7431, 15, 218, 'Puch bei Weiz', 'AT', '6'),
(7432, 15, 218, 'Puntigam', 'AT', '6'),
(7433, 15, 218, 'Pusterwald', 'AT', '6'),
(7434, 15, 218, 'Raaba', 'AT', '6'),
(7435, 15, 218, 'Raabau', 'AT', '6'),
(7436, 15, 218, 'Rabenwald', 'AT', '6'),
(7437, 15, 218, 'Rachau', 'AT', '6'),
(7438, 15, 218, 'Ragnitz', 'AT', '6'),
(7439, 15, 218, 'Ramsau am Dachstein', 'AT', '6'),
(7440, 15, 218, 'Raning', 'AT', '6'),
(7441, 15, 218, 'Ranten', 'AT', '6'),
(7442, 15, 218, 'Rassach', 'AT', '6'),
(7443, 15, 218, 'Ratsch an der Weinstraße', 'AT', '6'),
(7444, 15, 218, 'Ratschendorf', 'AT', '6'),
(7445, 15, 218, 'Ratten', 'AT', '6'),
(7446, 15, 218, 'Reichendorf', 'AT', '6'),
(7447, 15, 218, 'Reifling', 'AT', '6'),
(7448, 15, 218, 'Rettenegg', 'AT', '6'),
(7449, 15, 218, 'Retznei', 'AT', '6'),
(7450, 15, 218, 'Riegersburg', 'AT', '6'),
(7451, 15, 218, 'Ries', 'AT', '6'),
(7452, 15, 218, 'Rohrbach an der Lafnitz', 'AT', '6'),
(7453, 15, 218, 'Rosental an der Kainach', 'AT', '6'),
(7454, 15, 218, 'Röthelstein', 'AT', '6'),
(7455, 15, 218, 'Rottenmann', 'AT', '6'),
(7456, 15, 218, 'Salla', 'AT', '6'),
(7457, 15, 218, 'Sankt Anna am Aigen', 'AT', '6'),
(7458, 15, 218, 'Sankt Bartholomä', 'AT', '6'),
(7459, 15, 218, 'Sankt Blasen', 'AT', '6'),
(7460, 15, 218, 'Sankt Gallen', 'AT', '6'),
(7461, 15, 218, 'Sankt Georgen an der Stiefing', 'AT', '6'),
(7462, 15, 218, 'Sankt Georgen ob Judenburg', 'AT', '6'),
(7463, 15, 218, 'Sankt Georgen ob Murau', 'AT', '6'),
(7464, 15, 218, 'Sankt Ilgen', 'AT', '6'),
(7465, 15, 218, 'Sankt Jakob im Walde', 'AT', '6'),
(7466, 15, 218, 'Sankt Jakob-Breitenau', 'AT', '6'),
(7467, 15, 218, 'Sankt Johann am Tauern', 'AT', '6'),
(7468, 15, 218, 'Sankt Johann bei Herberstein', 'AT', '6'),
(7469, 15, 218, 'Sankt Johann im Saggautal', 'AT', '6'),
(7470, 15, 218, 'Sankt Johann in der Haide', 'AT', '6'),
(7471, 15, 218, 'Sankt Josef (Weststeiermark)', 'AT', '6'),
(7472, 15, 218, 'Sankt Katharein an der Laming', 'AT', '6'),
(7473, 15, 218, 'Sankt Kathrein am Hauenstein', 'AT', '6'),
(7474, 15, 218, 'Sankt Kathrein am Offenegg', 'AT', '6'),
(7475, 15, 218, 'Sankt Lambrecht', 'AT', '6'),
(7476, 15, 218, 'Sankt Leonhard', 'AT', '6'),
(7477, 15, 218, 'Sankt Lorenzen am Wechsel', 'AT', '6'),
(7478, 15, 218, 'Sankt Lorenzen bei Knittelfeld', 'AT', '6'),
(7479, 15, 218, 'Sankt Lorenzen bei Scheifling', 'AT', '6'),
(7480, 15, 218, 'Sankt Lorenzen im Mürztal', 'AT', '6'),
(7481, 15, 218, 'Sankt Marein bei Graz', 'AT', '6'),
(7482, 15, 218, 'Sankt Marein bei Knittelfeld', 'AT', '6'),
(7483, 15, 218, 'Sankt Marein bei Neumarkt', 'AT', '6'),
(7484, 15, 218, 'Sankt Marein im Mürztal', 'AT', '6'),
(7485, 15, 218, 'Sankt Margarethen an der Raab', 'AT', '6'),
(7486, 15, 218, 'Sankt Margarethen bei Knittelfeld', 'AT', '6'),
(7487, 15, 218, 'Sankt Martin', 'AT', '6'),
(7488, 15, 218, 'Sankt Martin am Grimming', 'AT', '6'),
(7489, 15, 218, 'Sankt Martin im Sulmtal', 'AT', '6'),
(7490, 15, 218, 'Sankt Michael in Obersteiermark', 'AT', '6'),
(7491, 15, 218, 'Sankt Nikolai im Sausal', 'AT', '6'),
(7492, 15, 218, 'Sankt Nikolai im Sölktal', 'AT', '6'),
(7493, 15, 218, 'Sankt Nikolai ob Draßling', 'AT', '6'),
(7494, 15, 218, 'Sankt Oswald bei Plankenwarth', 'AT', '6'),
(7495, 15, 218, 'Sankt Oswald ob Eibiswald', 'AT', '6'),
(7496, 15, 218, 'Sankt Peter', 'AT', '6'),
(7497, 15, 218, 'Sankt Peter am Kammersberg', 'AT', '6'),
(7498, 15, 218, 'Sankt Peter am Ottersbach', 'AT', '6'),
(7499, 15, 218, 'Sankt Peter im Sulmtal', 'AT', '6'),
(7500, 15, 218, 'Sankt Peter ob Judenburg', 'AT', '6');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(7501, 15, 218, 'Sankt Peter-Freienstein', 'AT', '6'),
(7502, 15, 218, 'Sankt Radegund bei Graz', 'AT', '6'),
(7503, 15, 218, 'Sankt Ruprecht an der Raab', 'AT', '6'),
(7504, 15, 218, 'Sankt Stefan im Rosental', 'AT', '6'),
(7505, 15, 218, 'Sankt Stefan ob Leoben', 'AT', '6'),
(7506, 15, 218, 'Sankt Stefan ob Stainz', 'AT', '6'),
(7507, 15, 218, 'Sankt Ulrich am Waasen', 'AT', '6'),
(7508, 15, 218, 'Sankt Veit am Vogau', 'AT', '6'),
(7509, 15, 218, 'Schachen bei Vorau', 'AT', '6'),
(7510, 15, 218, 'Schäffern', 'AT', '6'),
(7511, 15, 218, 'Scheifling', 'AT', '6'),
(7512, 15, 218, 'Schladming', 'AT', '6'),
(7513, 15, 218, 'Schöder', 'AT', '6'),
(7514, 15, 218, 'Schrems bei Frohnleiten', 'AT', '6'),
(7515, 15, 218, 'Schwanberg', 'AT', '6'),
(7516, 15, 218, 'Schwarzau im Schwarzautal', 'AT', '6'),
(7517, 15, 218, 'Sebersdorf', 'AT', '6'),
(7518, 15, 218, 'Seckau', 'AT', '6'),
(7519, 15, 218, 'Seggauberg', 'AT', '6'),
(7520, 15, 218, 'Seiersberg', 'AT', '6'),
(7521, 15, 218, 'Selzthal', 'AT', '6'),
(7522, 15, 218, 'Semriach', 'AT', '6'),
(7523, 15, 218, 'Siegersdorf bei Herberstein', 'AT', '6'),
(7524, 15, 218, 'Sinabelkirchen', 'AT', '6'),
(7525, 15, 218, 'Soboth', 'AT', '6'),
(7526, 15, 218, 'Söchau', 'AT', '6'),
(7527, 15, 218, 'Södingberg', 'AT', '6'),
(7528, 15, 218, 'Spatenhof', 'AT', '6'),
(7529, 15, 218, 'Spielberg bei Knittelfeld', 'AT', '6'),
(7530, 15, 218, 'Spielfeld', 'AT', '6'),
(7531, 15, 218, 'Spital am Semmering', 'AT', '6'),
(7532, 15, 218, 'Stadl an der Mur', 'AT', '6'),
(7533, 15, 218, 'Stainach', 'AT', '6'),
(7534, 15, 218, 'Stainz', 'AT', '6'),
(7535, 15, 218, 'Stainz bei Straden', 'AT', '6'),
(7536, 15, 218, 'Stallhof', 'AT', '6'),
(7537, 15, 218, 'Stallhofen', 'AT', '6'),
(7538, 15, 218, 'Stambach', 'AT', '6'),
(7539, 15, 218, 'Stattegg', 'AT', '6'),
(7540, 15, 218, 'Stein', 'AT', '6'),
(7541, 15, 218, 'Stenzengreith', 'AT', '6'),
(7542, 15, 218, 'Stiwoll', 'AT', '6'),
(7543, 15, 218, 'Straden', 'AT', '6'),
(7544, 15, 218, 'Strallegg', 'AT', '6'),
(7545, 15, 218, 'Straß in Steiermark', 'AT', '6'),
(7546, 15, 218, 'Strassengel', 'AT', '6'),
(7547, 15, 218, 'Straßgang', 'AT', '6'),
(7548, 15, 218, 'Stubenberg', 'AT', '6'),
(7549, 15, 218, 'Studenzen', 'AT', '6'),
(7550, 15, 218, 'Sulztal an der Weinstraße', 'AT', '6'),
(7551, 15, 218, 'Tauplitz', 'AT', '6'),
(7552, 15, 218, 'Teufenbach', 'AT', '6'),
(7553, 15, 218, 'Thal', 'AT', '6'),
(7554, 15, 218, 'Thörl', 'AT', '6'),
(7555, 15, 218, 'Tieschen', 'AT', '6'),
(7556, 15, 218, 'Tillmitsch', 'AT', '6'),
(7557, 15, 218, 'Tillmitsch Links der Laßnitz', 'AT', '6'),
(7558, 15, 218, 'Traboch', 'AT', '6'),
(7559, 15, 218, 'Trahütten', 'AT', '6'),
(7560, 15, 218, 'Trautmannsdorf in Oststeiermark', 'AT', '6'),
(7561, 15, 218, 'Treglwang', 'AT', '6'),
(7562, 15, 218, 'Trieben', 'AT', '6'),
(7563, 15, 218, 'Triebendorf', 'AT', '6'),
(7564, 15, 218, 'Trofaiach', 'AT', '6'),
(7565, 15, 218, 'Trössing', 'AT', '6'),
(7566, 15, 218, 'Turnau', 'AT', '6'),
(7567, 15, 218, 'Übelbach', 'AT', '6'),
(7568, 15, 218, 'Übersbach', 'AT', '6'),
(7569, 15, 218, 'Ungerdorf', 'AT', '6'),
(7570, 15, 218, 'Unterauersbach', 'AT', '6'),
(7571, 15, 218, 'Unterbergla', 'AT', '6'),
(7572, 15, 218, 'Unterfladnitz', 'AT', '6'),
(7573, 15, 218, 'Unterlamm', 'AT', '6'),
(7574, 15, 218, 'Unterpremstätten', 'AT', '6'),
(7575, 15, 218, 'Utschtal', 'AT', '6'),
(7576, 15, 218, 'Vasoldsberg', 'AT', '6'),
(7577, 15, 218, 'Veitsch', 'AT', '6'),
(7578, 15, 218, 'Vogau', 'AT', '6'),
(7579, 15, 218, 'Voitsberg', 'AT', '6'),
(7580, 15, 218, 'Vorau', 'AT', '6'),
(7581, 15, 218, 'Vordernberg', 'AT', '6'),
(7582, 15, 218, 'Wagna', 'AT', '6'),
(7583, 15, 218, 'Wagnitz', 'AT', '6'),
(7584, 15, 218, 'Wald am Schoberpaß', 'AT', '6'),
(7585, 15, 218, 'Waltendorf', 'AT', '6'),
(7586, 15, 218, 'Wartberg', 'AT', '6'),
(7587, 15, 218, 'Weinburg am Saßbach', 'AT', '6'),
(7588, 15, 218, 'Weißenbach bei Liezen', 'AT', '6'),
(7589, 15, 218, 'Weißkirchen in Steiermark', 'AT', '6'),
(7590, 15, 218, 'Weiz', 'AT', '6'),
(7591, 15, 218, 'Werndorf', 'AT', '6'),
(7592, 15, 218, 'Wernersdorf', 'AT', '6'),
(7593, 15, 218, 'Wettmannstätten', 'AT', '6'),
(7594, 15, 218, 'Wetzelsdorf', 'AT', '6'),
(7595, 15, 218, 'Wies', 'AT', '6'),
(7596, 15, 218, 'Wildalpen', 'AT', '6'),
(7597, 15, 218, 'Wildon', 'AT', '6'),
(7598, 15, 218, 'Winklern bei Oberwölz', 'AT', '6'),
(7599, 15, 218, 'Wolfsberg im Schwarzautal', 'AT', '6'),
(7600, 15, 218, 'Wörschach', 'AT', '6'),
(7601, 15, 218, 'Wörth an der Lafnitz', 'AT', '6'),
(7602, 15, 218, 'Wundschuh', 'AT', '6'),
(7603, 15, 218, 'Zeltweg', 'AT', '6'),
(7604, 15, 218, 'Zerlach', 'AT', '6'),
(7605, 15, 218, 'Zettling', 'AT', '6'),
(7606, 15, 218, 'Zeutschach', 'AT', '6'),
(7607, 15, 219, 'Abfaltersbach', 'AT', '7'),
(7608, 15, 219, 'Absam', 'AT', '7'),
(7609, 15, 219, 'Achenkirch', 'AT', '7'),
(7610, 15, 219, 'Ainet', 'AT', '7'),
(7611, 15, 219, 'Aldrans', 'AT', '7'),
(7612, 15, 219, 'Alpbach', 'AT', '7'),
(7613, 15, 219, 'Amlach', 'AT', '7'),
(7614, 15, 219, 'Ampass', 'AT', '7'),
(7615, 15, 219, 'Amras', 'AT', '7'),
(7616, 15, 219, 'Angath', 'AT', '7'),
(7617, 15, 219, 'Angerberg', 'AT', '7'),
(7618, 15, 219, 'Anras', 'AT', '7'),
(7619, 15, 219, 'Arzl', 'AT', '7'),
(7620, 15, 219, 'Arzl im Pitztal', 'AT', '7'),
(7621, 15, 219, 'Aschau', 'AT', '7'),
(7622, 15, 219, 'Aschau im Zillertal', 'AT', '7'),
(7623, 15, 219, 'Aurach', 'AT', '7'),
(7624, 15, 219, 'Außervillgraten', 'AT', '7'),
(7625, 15, 219, 'Axams', 'AT', '7'),
(7626, 15, 219, 'Bad Häring', 'AT', '7'),
(7627, 15, 219, 'Barwies', 'AT', '7'),
(7628, 15, 219, 'Baumkirchen', 'AT', '7'),
(7629, 15, 219, 'Berwang', 'AT', '7'),
(7630, 15, 219, 'Biberwier', 'AT', '7'),
(7631, 15, 219, 'Bichlbach', 'AT', '7'),
(7632, 15, 219, 'Birgitz', 'AT', '7'),
(7633, 15, 219, 'Brandenberg', 'AT', '7'),
(7634, 15, 219, 'Breitenbach am Inn', 'AT', '7'),
(7635, 15, 219, 'Breitenwang', 'AT', '7'),
(7636, 15, 219, 'Brixen im Thale', 'AT', '7'),
(7637, 15, 219, 'Brixlegg', 'AT', '7'),
(7638, 15, 219, 'Bruck am Ziller', 'AT', '7'),
(7639, 15, 219, 'Buch in Tirol', 'AT', '7'),
(7640, 15, 219, 'Debant', 'AT', '7'),
(7641, 15, 219, 'Dölsach', 'AT', '7'),
(7642, 15, 219, 'Ebbs', 'AT', '7'),
(7643, 15, 219, 'Eben am Achensee', 'AT', '7'),
(7644, 15, 219, 'Ehenbichl', 'AT', '7'),
(7645, 15, 219, 'Ehrwald', 'AT', '7'),
(7646, 15, 219, 'Elbigenalp', 'AT', '7'),
(7647, 15, 219, 'Ellbögen', 'AT', '7'),
(7648, 15, 219, 'Ellmau', 'AT', '7'),
(7649, 15, 219, 'Elmen', 'AT', '7'),
(7650, 15, 219, 'Endach', 'AT', '7'),
(7651, 15, 219, 'Erl', 'AT', '7'),
(7652, 15, 219, 'Erpfendorf', 'AT', '7'),
(7653, 15, 219, 'Fendels', 'AT', '7'),
(7654, 15, 219, 'Fieberbrunn', 'AT', '7'),
(7655, 15, 219, 'Fiecht', 'AT', '7'),
(7656, 15, 219, 'Finkenberg', 'AT', '7'),
(7657, 15, 219, 'Fiss', 'AT', '7'),
(7658, 15, 219, 'Flaurling', 'AT', '7'),
(7659, 15, 219, 'Fliess', 'AT', '7'),
(7660, 15, 219, 'Flirsch', 'AT', '7'),
(7661, 15, 219, 'Forchach', 'AT', '7'),
(7662, 15, 219, 'Fritzens', 'AT', '7'),
(7663, 15, 219, 'Fügen', 'AT', '7'),
(7664, 15, 219, 'Fügenberg', 'AT', '7'),
(7665, 15, 219, 'Fulpmes', 'AT', '7'),
(7666, 15, 219, 'Gallzein', 'AT', '7'),
(7667, 15, 219, 'Galtür', 'AT', '7'),
(7668, 15, 219, 'Gerlos', 'AT', '7'),
(7669, 15, 219, 'Gerlosberg', 'AT', '7'),
(7670, 15, 219, 'Gnadenwald', 'AT', '7'),
(7671, 15, 219, 'Going', 'AT', '7'),
(7672, 15, 219, 'Götzens', 'AT', '7'),
(7673, 15, 219, 'Gramais', 'AT', '7'),
(7674, 15, 219, 'Grän', 'AT', '7'),
(7675, 15, 219, 'Gries am Brenner', 'AT', '7'),
(7676, 15, 219, 'Gries im Sellrain', 'AT', '7'),
(7677, 15, 219, 'Grins', 'AT', '7'),
(7678, 15, 219, 'Grinzens', 'AT', '7'),
(7679, 15, 219, 'Gschnitz', 'AT', '7'),
(7680, 15, 219, 'Haiming', 'AT', '7'),
(7681, 15, 219, 'Hainzenberg', 'AT', '7'),
(7682, 15, 219, 'Hall in Tirol', 'AT', '7'),
(7683, 15, 219, 'Hart im Zillertal', 'AT', '7'),
(7684, 15, 219, 'Häselgehr', 'AT', '7'),
(7685, 15, 219, 'Hatting', 'AT', '7'),
(7686, 15, 219, 'Heinfels', 'AT', '7'),
(7687, 15, 219, 'Heiterwang', 'AT', '7'),
(7688, 15, 219, 'Hippach', 'AT', '7'),
(7689, 15, 219, 'Hochfilzen', 'AT', '7'),
(7690, 15, 219, 'Höfen', 'AT', '7'),
(7691, 15, 219, 'Holzgau', 'AT', '7'),
(7692, 15, 219, 'Hopfgarten im Brixental', 'AT', '7'),
(7693, 15, 219, 'Hopfgarten in Defereggen', 'AT', '7'),
(7694, 15, 219, 'Hötting', 'AT', '7'),
(7695, 15, 219, 'Igls', 'AT', '7'),
(7696, 15, 219, 'Imst', 'AT', '7'),
(7697, 15, 219, 'Imsterberg', 'AT', '7'),
(7698, 15, 219, 'Innervillgraten', 'AT', '7'),
(7699, 15, 219, 'Innsbruck', 'AT', '7'),
(7700, 15, 219, 'Innsbruck Stadt', 'AT', '7'),
(7701, 15, 219, 'Inzing', 'AT', '7'),
(7702, 15, 219, 'Ischgl', 'AT', '7'),
(7703, 15, 219, 'Itter', 'AT', '7'),
(7704, 15, 219, 'Jenbach', 'AT', '7'),
(7705, 15, 219, 'Jerzens', 'AT', '7'),
(7706, 15, 219, 'Jochberg', 'AT', '7'),
(7707, 15, 219, 'Jungholz', 'AT', '7'),
(7708, 15, 219, 'Kaltenbach', 'AT', '7'),
(7709, 15, 219, 'Kapfing', 'AT', '7'),
(7710, 15, 219, 'Kappl', 'AT', '7'),
(7711, 15, 219, 'Karres', 'AT', '7'),
(7712, 15, 219, 'Karrösten', 'AT', '7'),
(7713, 15, 219, 'Kartitsch', 'AT', '7'),
(7714, 15, 219, 'Kauns', 'AT', '7'),
(7715, 15, 219, 'Kematen in Tirol', 'AT', '7'),
(7716, 15, 219, 'Kirchberg in Tirol', 'AT', '7'),
(7717, 15, 219, 'Kirchbichl', 'AT', '7'),
(7718, 15, 219, 'Kirchdorf in Tirol', 'AT', '7'),
(7719, 15, 219, 'Kitzbühel', 'AT', '7'),
(7720, 15, 219, 'Kolsass', 'AT', '7'),
(7721, 15, 219, 'Kolsassberg', 'AT', '7'),
(7722, 15, 219, 'Kössen', 'AT', '7'),
(7723, 15, 219, 'Kramsach', 'AT', '7'),
(7724, 15, 219, 'Kufstein', 'AT', '7'),
(7725, 15, 219, 'Kundl', 'AT', '7'),
(7726, 15, 219, 'Ladis', 'AT', '7'),
(7727, 15, 219, 'Landeck', 'AT', '7'),
(7728, 15, 219, 'Längenfeld', 'AT', '7'),
(7729, 15, 219, 'Lans', 'AT', '7'),
(7730, 15, 219, 'Lavant', 'AT', '7'),
(7731, 15, 219, 'Lechaschau', 'AT', '7'),
(7732, 15, 219, 'Leisach', 'AT', '7'),
(7733, 15, 219, 'Lermoos', 'AT', '7'),
(7734, 15, 219, 'Leutasch', 'AT', '7'),
(7735, 15, 219, 'Lienz', 'AT', '7'),
(7736, 15, 219, 'Mariastein', 'AT', '7'),
(7737, 15, 219, 'Mariatal', 'AT', '7'),
(7738, 15, 219, 'Matrei am Brenner', 'AT', '7'),
(7739, 15, 219, 'Matrei in Osttirol', 'AT', '7'),
(7740, 15, 219, 'Maurach', 'AT', '7'),
(7741, 15, 219, 'Mayrhofen', 'AT', '7'),
(7742, 15, 219, 'Medraz', 'AT', '7'),
(7743, 15, 219, 'Mieders', 'AT', '7'),
(7744, 15, 219, 'Mieming', 'AT', '7'),
(7745, 15, 219, 'Mils bei Imst', 'AT', '7'),
(7746, 15, 219, 'Mils bei Solbad Hall', 'AT', '7'),
(7747, 15, 219, 'Mitterndorf', 'AT', '7'),
(7748, 15, 219, 'Mötz', 'AT', '7'),
(7749, 15, 219, 'Mühlau', 'AT', '7'),
(7750, 15, 219, 'Mühlbachl', 'AT', '7'),
(7751, 15, 219, 'Münster', 'AT', '7'),
(7752, 15, 219, 'Musau', 'AT', '7'),
(7753, 15, 219, 'Mutters', 'AT', '7'),
(7754, 15, 219, 'Namlos', 'AT', '7'),
(7755, 15, 219, 'Nassereith', 'AT', '7'),
(7756, 15, 219, 'Natters', 'AT', '7'),
(7757, 15, 219, 'Nauders', 'AT', '7'),
(7758, 15, 219, 'Nesselwängle', 'AT', '7'),
(7759, 15, 219, 'Neustift im Stubaital', 'AT', '7'),
(7760, 15, 219, 'Niederau', 'AT', '7'),
(7761, 15, 219, 'Niederbreitenbach', 'AT', '7'),
(7762, 15, 219, 'Niederndorf', 'AT', '7'),
(7763, 15, 219, 'Nikolsdorf', 'AT', '7'),
(7764, 15, 219, 'Oberau', 'AT', '7'),
(7765, 15, 219, 'Oberhofen im Inntal', 'AT', '7'),
(7766, 15, 219, 'Oberlienz', 'AT', '7'),
(7767, 15, 219, 'Obermieming', 'AT', '7'),
(7768, 15, 219, 'Obernberg am Brenner', 'AT', '7'),
(7769, 15, 219, 'Oberndorf in Tirol', 'AT', '7'),
(7770, 15, 219, 'Oberperfuss', 'AT', '7'),
(7771, 15, 219, 'Obertilliach', 'AT', '7'),
(7772, 15, 219, 'Obsteig', 'AT', '7'),
(7773, 15, 219, 'Oetz', 'AT', '7'),
(7774, 15, 219, 'Ötztal-Bahnhof', 'AT', '7'),
(7775, 15, 219, 'Patsch', 'AT', '7'),
(7776, 15, 219, 'Pettnau', 'AT', '7'),
(7777, 15, 219, 'Pettneu', 'AT', '7'),
(7778, 15, 219, 'Pfaffenhofen', 'AT', '7'),
(7779, 15, 219, 'Pflach', 'AT', '7'),
(7780, 15, 219, 'Pfons', 'AT', '7'),
(7781, 15, 219, 'Pfunds', 'AT', '7'),
(7782, 15, 219, 'Pians', 'AT', '7'),
(7783, 15, 219, 'Pill', 'AT', '7'),
(7784, 15, 219, 'Politischer Bezirk Imst', 'AT', '7'),
(7785, 15, 219, 'Politischer Bezirk Innsbruck Land', 'AT', '7'),
(7786, 15, 219, 'Politischer Bezirk Kitzbühel', 'AT', '7'),
(7787, 15, 219, 'Politischer Bezirk Kufstein', 'AT', '7'),
(7788, 15, 219, 'Politischer Bezirk Landeck', 'AT', '7'),
(7789, 15, 219, 'Politischer Bezirk Lienz', 'AT', '7'),
(7790, 15, 219, 'Politischer Bezirk Reutte', 'AT', '7'),
(7791, 15, 219, 'Politischer Bezirk Schwaz', 'AT', '7'),
(7792, 15, 219, 'Polling in Tirol', 'AT', '7'),
(7793, 15, 219, 'Pradl', 'AT', '7'),
(7794, 15, 219, 'Prutz', 'AT', '7'),
(7795, 15, 219, 'Radfeld', 'AT', '7'),
(7796, 15, 219, 'Ramsau im Zillertal', 'AT', '7'),
(7797, 15, 219, 'Ranggen', 'AT', '7'),
(7798, 15, 219, 'Rattenberg', 'AT', '7'),
(7799, 15, 219, 'Reith bei Kitzbühel', 'AT', '7'),
(7800, 15, 219, 'Reith bei Seefeld', 'AT', '7'),
(7801, 15, 219, 'Reith im Alpbachtal', 'AT', '7'),
(7802, 15, 219, 'Rettenschöss', 'AT', '7'),
(7803, 15, 219, 'Reutte', 'AT', '7'),
(7804, 15, 219, 'Ried im Oberinntal', 'AT', '7'),
(7805, 15, 219, 'Ried im Zillertal', 'AT', '7'),
(7806, 15, 219, 'Rietz', 'AT', '7'),
(7807, 15, 219, 'Rinn', 'AT', '7'),
(7808, 15, 219, 'Rohrberg', 'AT', '7'),
(7809, 15, 219, 'Roppen', 'AT', '7'),
(7810, 15, 219, 'Rum', 'AT', '7'),
(7811, 15, 219, 'Sankt Johann in Tirol', 'AT', '7'),
(7812, 15, 219, 'Sankt Ulrich am Pillersee', 'AT', '7'),
(7813, 15, 219, 'Sankt Veit in Defereggen', 'AT', '7'),
(7814, 15, 219, 'Sautens', 'AT', '7'),
(7815, 15, 219, 'Scharnitz', 'AT', '7'),
(7816, 15, 219, 'Schattwald', 'AT', '7'),
(7817, 15, 219, 'Scheffau am Wilden Kaiser', 'AT', '7'),
(7818, 15, 219, 'Schlaiten', 'AT', '7'),
(7819, 15, 219, 'Schlitters', 'AT', '7'),
(7820, 15, 219, 'Schönberg im Stubaital', 'AT', '7'),
(7821, 15, 219, 'Schönwies', 'AT', '7'),
(7822, 15, 219, 'Schwaz', 'AT', '7'),
(7823, 15, 219, 'Schwendau', 'AT', '7'),
(7824, 15, 219, 'Schwendt', 'AT', '7'),
(7825, 15, 219, 'Schwoich', 'AT', '7'),
(7826, 15, 219, 'See', 'AT', '7'),
(7827, 15, 219, 'Seefeld in Tirol', 'AT', '7'),
(7828, 15, 219, 'Sellrain', 'AT', '7'),
(7829, 15, 219, 'Serfaus', 'AT', '7'),
(7830, 15, 219, 'Sillian', 'AT', '7'),
(7831, 15, 219, 'Silz', 'AT', '7'),
(7832, 15, 219, 'Sistrans', 'AT', '7'),
(7833, 15, 219, 'Sölden', 'AT', '7'),
(7834, 15, 219, 'Söll', 'AT', '7'),
(7835, 15, 219, 'St Anton am Arlberg', 'AT', '7'),
(7836, 15, 219, 'Stams', 'AT', '7'),
(7837, 15, 219, 'Stans', 'AT', '7'),
(7838, 15, 219, 'Stanz bei Landeck', 'AT', '7'),
(7839, 15, 219, 'Stanzach', 'AT', '7'),
(7840, 15, 219, 'Steeg', 'AT', '7'),
(7841, 15, 219, 'Steinach am Brenner', 'AT', '7'),
(7842, 15, 219, 'Strass im Zillertal', 'AT', '7'),
(7843, 15, 219, 'Strassen', 'AT', '7'),
(7844, 15, 219, 'Strengen', 'AT', '7'),
(7845, 15, 219, 'Stumm', 'AT', '7'),
(7846, 15, 219, 'Stummerberg', 'AT', '7'),
(7847, 15, 219, 'Tannheim', 'AT', '7'),
(7848, 15, 219, 'Tarrenz', 'AT', '7'),
(7849, 15, 219, 'Telfes im Stubai', 'AT', '7'),
(7850, 15, 219, 'Telfs', 'AT', '7'),
(7851, 15, 219, 'Terfens', 'AT', '7'),
(7852, 15, 219, 'Thaur', 'AT', '7'),
(7853, 15, 219, 'Thurn', 'AT', '7'),
(7854, 15, 219, 'Tobadill', 'AT', '7'),
(7855, 15, 219, 'Trins', 'AT', '7'),
(7856, 15, 219, 'Tristach', 'AT', '7'),
(7857, 15, 219, 'Tulfes', 'AT', '7'),
(7858, 15, 219, 'Tux', 'AT', '7'),
(7859, 15, 219, 'Uderns', 'AT', '7'),
(7860, 15, 219, 'Umhausen', 'AT', '7'),
(7861, 15, 219, 'Unterlangkampfen', 'AT', '7'),
(7862, 15, 219, 'Unterperfuss', 'AT', '7'),
(7863, 15, 219, 'Untertilliach', 'AT', '7'),
(7864, 15, 219, 'Vals', 'AT', '7'),
(7865, 15, 219, 'Vils', 'AT', '7'),
(7866, 15, 219, 'Virgen', 'AT', '7'),
(7867, 15, 219, 'Volders', 'AT', '7'),
(7868, 15, 219, 'Voldöpp', 'AT', '7'),
(7869, 15, 219, 'Völs', 'AT', '7'),
(7870, 15, 219, 'Vomp', 'AT', '7'),
(7871, 15, 219, 'Vorderhornbach', 'AT', '7'),
(7872, 15, 219, 'Vorderthiersee', 'AT', '7'),
(7873, 15, 219, 'Waidring', 'AT', '7'),
(7874, 15, 219, 'Walchsee', 'AT', '7'),
(7875, 15, 219, 'Wängle', 'AT', '7'),
(7876, 15, 219, 'Wattenberg', 'AT', '7'),
(7877, 15, 219, 'Wattens', 'AT', '7'),
(7878, 15, 219, 'Weer', 'AT', '7'),
(7879, 15, 219, 'Weerberg', 'AT', '7'),
(7880, 15, 219, 'Weissach', 'AT', '7'),
(7881, 15, 219, 'Weissenbach am Lech', 'AT', '7'),
(7882, 15, 219, 'Wenns', 'AT', '7'),
(7883, 15, 219, 'Westendorf', 'AT', '7'),
(7884, 15, 219, 'Wiesing', 'AT', '7'),
(7885, 15, 219, 'Wildermieming', 'AT', '7'),
(7886, 15, 219, 'Wildschönau', 'AT', '7'),
(7887, 15, 219, 'Wilten', 'AT', '7'),
(7888, 15, 219, 'Wörgl', 'AT', '7'),
(7889, 15, 219, 'Zams', 'AT', '7'),
(7890, 15, 219, 'Zell', 'AT', '7'),
(7891, 15, 219, 'Zell am Ziller', 'AT', '7'),
(7892, 15, 219, 'Zellberg', 'AT', '7'),
(7893, 15, 219, 'Zirl', 'AT', '7'),
(7894, 15, 219, 'Zöblen', 'AT', '7'),
(7895, 15, 220, 'Abwinden', 'AT', '4'),
(7896, 15, 220, 'Adlwang', 'AT', '4'),
(7897, 15, 220, 'Afiesl', 'AT', '4'),
(7898, 15, 220, 'Ahorn', 'AT', '4'),
(7899, 15, 220, 'Aichkirchen', 'AT', '4'),
(7900, 15, 220, 'Aigen im Mühlkreis', 'AT', '4'),
(7901, 15, 220, 'Aistersheim', 'AT', '4'),
(7902, 15, 220, 'Alberndorf in der Riedmark', 'AT', '4'),
(7903, 15, 220, 'Alkoven', 'AT', '4'),
(7904, 15, 220, 'Allerheiligen im Mühlkreis', 'AT', '4'),
(7905, 15, 220, 'Allhaming', 'AT', '4'),
(7906, 15, 220, 'Altenberg bei Linz', 'AT', '4'),
(7907, 15, 220, 'Altenfelden', 'AT', '4'),
(7908, 15, 220, 'Altheim', 'AT', '4'),
(7909, 15, 220, 'Altlichtenberg', 'AT', '4'),
(7910, 15, 220, 'Altmünster', 'AT', '4'),
(7911, 15, 220, 'Ampflwang', 'AT', '4'),
(7912, 15, 220, 'Andorf', 'AT', '4'),
(7913, 15, 220, 'Ansfelden', 'AT', '4'),
(7914, 15, 220, 'Arnreit', 'AT', '4'),
(7915, 15, 220, 'Aschach an der Donau', 'AT', '4'),
(7916, 15, 220, 'Aschach an der Steyr', 'AT', '4'),
(7917, 15, 220, 'Asten', 'AT', '4'),
(7918, 15, 220, 'Attersee', 'AT', '4'),
(7919, 15, 220, 'Attnang', 'AT', '4'),
(7920, 15, 220, 'Attnang-Puchheim', 'AT', '4'),
(7921, 15, 220, 'Atzbach', 'AT', '4'),
(7922, 15, 220, 'Atzesberg', 'AT', '4'),
(7923, 15, 220, 'Au an der Traun', 'AT', '4'),
(7924, 15, 220, 'Audorf', 'AT', '4'),
(7925, 15, 220, 'Aurach am Hongar', 'AT', '4'),
(7926, 15, 220, 'Aurolzmünster', 'AT', '4'),
(7927, 15, 220, 'Bachmanning', 'AT', '4'),
(7928, 15, 220, 'Bad Goisern', 'AT', '4'),
(7929, 15, 220, 'Bad Hall', 'AT', '4'),
(7930, 15, 220, 'Bad Ischl', 'AT', '4'),
(7931, 15, 220, 'Bad Kreuzen', 'AT', '4'),
(7932, 15, 220, 'Bad Leonfelden', 'AT', '4'),
(7933, 15, 220, 'Bad Schallerbach', 'AT', '4'),
(7934, 15, 220, 'Bad Zell', 'AT', '4'),
(7935, 15, 220, 'Berg', 'AT', '4'),
(7936, 15, 220, 'Bergern', 'AT', '4'),
(7937, 15, 220, 'Bergham', 'AT', '4'),
(7938, 15, 220, 'Bernardin', 'AT', '4'),
(7939, 15, 220, 'Brandln', 'AT', '4'),
(7940, 15, 220, 'Braunau am Inn', 'AT', '4'),
(7941, 15, 220, 'Braunau Neustadt', 'AT', '4'),
(7942, 15, 220, 'Buchkirchen', 'AT', '4'),
(7943, 15, 220, 'Burgfried', 'AT', '4'),
(7944, 15, 220, 'Desselbrunn', 'AT', '4'),
(7945, 15, 220, 'Dickerldorf', 'AT', '4'),
(7946, 15, 220, 'Diesseits', 'AT', '4'),
(7947, 15, 220, 'Dietach', 'AT', '4'),
(7948, 15, 220, 'Dietachdorf', 'AT', '4'),
(7949, 15, 220, 'Doppl', 'AT', '4'),
(7950, 15, 220, 'Dörfl', 'AT', '4'),
(7951, 15, 220, 'Dürnau', 'AT', '4'),
(7952, 15, 220, 'Ebensee', 'AT', '4'),
(7953, 15, 220, 'Eberschwang', 'AT', '4'),
(7954, 15, 220, 'Eberstalzell', 'AT', '4'),
(7955, 15, 220, 'Edt bei Lambach', 'AT', '4'),
(7956, 15, 220, 'Eferding', 'AT', '4'),
(7957, 15, 220, 'Eidenberg', 'AT', '4'),
(7958, 15, 220, 'Engerwitzdorf', 'AT', '4'),
(7959, 15, 220, 'Enns', 'AT', '4'),
(7960, 15, 220, 'Feldkirchen an der Donau', 'AT', '4'),
(7961, 15, 220, 'Fisching', 'AT', '4'),
(7962, 15, 220, 'Fornach', 'AT', '4'),
(7963, 15, 220, 'Frankenburg', 'AT', '4'),
(7964, 15, 220, 'Frankenmarkt', 'AT', '4'),
(7965, 15, 220, 'Freindorf', 'AT', '4'),
(7966, 15, 220, 'Freistadt', 'AT', '4'),
(7967, 15, 220, 'Gaflenz', 'AT', '4'),
(7968, 15, 220, 'Gallneukirchen', 'AT', '4'),
(7969, 15, 220, 'Gallspach', 'AT', '4'),
(7970, 15, 220, 'Gampern', 'AT', '4'),
(7971, 15, 220, 'Garsten', 'AT', '4'),
(7972, 15, 220, 'Gaspoltshofen', 'AT', '4'),
(7973, 15, 220, 'Gaumberg', 'AT', '4'),
(7974, 15, 220, 'Geboltskirchen', 'AT', '4'),
(7975, 15, 220, 'Gmunden', 'AT', '4'),
(7976, 15, 220, 'Goldwörth', 'AT', '4'),
(7977, 15, 220, 'Gosau', 'AT', '4'),
(7978, 15, 220, 'Gramastetten', 'AT', '4'),
(7979, 15, 220, 'Grein', 'AT', '4'),
(7980, 15, 220, 'Grieskirchen', 'AT', '4'),
(7981, 15, 220, 'Grossraming', 'AT', '4'),
(7982, 15, 220, 'Grünau im Almtal', 'AT', '4'),
(7983, 15, 220, 'Grünburg', 'AT', '4'),
(7984, 15, 220, 'Gschwandt', 'AT', '4'),
(7985, 15, 220, 'Gunskirchen', 'AT', '4'),
(7986, 15, 220, 'Gutau', 'AT', '4'),
(7987, 15, 220, 'Haag', 'AT', '4'),
(7988, 15, 220, 'Haag am Hausruck', 'AT', '4'),
(7989, 15, 220, 'Hagenberg im Mühlkreis', 'AT', '4'),
(7990, 15, 220, 'Haibach im Mühlkreis', 'AT', '4'),
(7991, 15, 220, 'Haid', 'AT', '4'),
(7992, 15, 220, 'Haiden', 'AT', '4'),
(7993, 15, 220, 'Haidl', 'AT', '4'),
(7994, 15, 220, 'Handenberg', 'AT', '4'),
(7995, 15, 220, 'Hart', 'AT', '4'),
(7996, 15, 220, 'Hartheim', 'AT', '4'),
(7997, 15, 220, 'Hartkirchen', 'AT', '4'),
(7998, 15, 220, 'Haselbach', 'AT', '4'),
(7999, 15, 220, 'Haslach an der Mühl', 'AT', '4'),
(8000, 15, 220, 'Hellmonsödt', 'AT', '4');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(8001, 15, 220, 'Herzogsdorf', 'AT', '4'),
(8002, 15, 220, 'Hochburg-Ach', 'AT', '4'),
(8003, 15, 220, 'Hochpoint', 'AT', '4'),
(8004, 15, 220, 'Hof', 'AT', '4'),
(8005, 15, 220, 'Hofkirchen im Traunkreis', 'AT', '4'),
(8006, 15, 220, 'Holzhausen', 'AT', '4'),
(8007, 15, 220, 'Hörsching', 'AT', '4'),
(8008, 15, 220, 'Innerschwand', 'AT', '4'),
(8009, 15, 220, 'Inzersdorf im Kremstal', 'AT', '4'),
(8010, 15, 220, 'Kaltenbach', 'AT', '4'),
(8011, 15, 220, 'Katsdorf', 'AT', '4'),
(8012, 15, 220, 'Kematen an der Krems', 'AT', '4'),
(8013, 15, 220, 'Kirchberg ob der Donau', 'AT', '4'),
(8014, 15, 220, 'Kirchdorf an der Krems', 'AT', '4'),
(8015, 15, 220, 'Kirchschlag bei Linz', 'AT', '4'),
(8016, 15, 220, 'Klaffer am Hochficht', 'AT', '4'),
(8017, 15, 220, 'Königswiesen', 'AT', '4'),
(8018, 15, 220, 'Kopfing im Innkreis', 'AT', '4'),
(8019, 15, 220, 'Kremsdorf', 'AT', '4'),
(8020, 15, 220, 'Kremsmünster', 'AT', '4'),
(8021, 15, 220, 'Kronstorf', 'AT', '4'),
(8022, 15, 220, 'Laab', 'AT', '4'),
(8023, 15, 220, 'Laahen', 'AT', '4'),
(8024, 15, 220, 'Laakirchen', 'AT', '4'),
(8025, 15, 220, 'Lambach', 'AT', '4'),
(8026, 15, 220, 'Langenstein', 'AT', '4'),
(8027, 15, 220, 'Langholzfeld', 'AT', '4'),
(8028, 15, 220, 'Laussa', 'AT', '4'),
(8029, 15, 220, 'Lembach im Mühlkreis', 'AT', '4'),
(8030, 15, 220, 'Lenzing', 'AT', '4'),
(8031, 15, 220, 'Leonding', 'AT', '4'),
(8032, 15, 220, 'Leonstein', 'AT', '4'),
(8033, 15, 220, 'Lichtenegg', 'AT', '4'),
(8034, 15, 220, 'Linz', 'AT', '4'),
(8035, 15, 220, 'Linz Stadt', 'AT', '4'),
(8036, 15, 220, 'Losenstein', 'AT', '4'),
(8037, 15, 220, 'Luftenberg an der Donau', 'AT', '4'),
(8038, 15, 220, 'Manning', 'AT', '4'),
(8039, 15, 220, 'Marchtrenk', 'AT', '4'),
(8040, 15, 220, 'Maria Neustift', 'AT', '4'),
(8041, 15, 220, 'Maria Schmolln', 'AT', '4'),
(8042, 15, 220, 'Mattighofen', 'AT', '4'),
(8043, 15, 220, 'Mauerkirchen', 'AT', '4'),
(8044, 15, 220, 'Meggenhofen', 'AT', '4'),
(8045, 15, 220, 'Mehrnbach', 'AT', '4'),
(8046, 15, 220, 'Michaelnbach', 'AT', '4'),
(8047, 15, 220, 'Micheldorf in Oberösterreich', 'AT', '4'),
(8048, 15, 220, 'Mitterkirchen im Machland', 'AT', '4'),
(8049, 15, 220, 'Mittertreffling', 'AT', '4'),
(8050, 15, 220, 'Molln', 'AT', '4'),
(8051, 15, 220, 'Mondsee', 'AT', '4'),
(8052, 15, 220, 'Moosdorf', 'AT', '4'),
(8053, 15, 220, 'Mühldorf', 'AT', '4'),
(8054, 15, 220, 'Munderfing', 'AT', '4'),
(8055, 15, 220, 'Münzbach', 'AT', '4'),
(8056, 15, 220, 'Münzkirchen', 'AT', '4'),
(8057, 15, 220, 'Naarn im Machlande', 'AT', '4'),
(8058, 15, 220, 'Natternbach', 'AT', '4'),
(8059, 15, 220, 'Nebelberg', 'AT', '4'),
(8060, 15, 220, 'Neubau', 'AT', '4'),
(8061, 15, 220, 'Neue Heimat', 'AT', '4'),
(8062, 15, 220, 'Neuhofen an der Krems', 'AT', '4'),
(8063, 15, 220, 'Neukirchen', 'AT', '4'),
(8064, 15, 220, 'Neukirchen am Walde', 'AT', '4'),
(8065, 15, 220, 'Neukirchen an der Vöckla', 'AT', '4'),
(8066, 15, 220, 'Neukirchen bei Lambach', 'AT', '4'),
(8067, 15, 220, 'Neumarkt im Hausruckkreis', 'AT', '4'),
(8068, 15, 220, 'Neumarkt im Mühlkreis', 'AT', '4'),
(8069, 15, 220, 'Neuzeug', 'AT', '4'),
(8070, 15, 220, 'Niederneukirchen', 'AT', '4'),
(8071, 15, 220, 'Niederstraß', 'AT', '4'),
(8072, 15, 220, 'Niederthalheim', 'AT', '4'),
(8073, 15, 220, 'Nöstlbach', 'AT', '4'),
(8074, 15, 220, 'Oberhaid', 'AT', '4'),
(8075, 15, 220, 'Oberhart', 'AT', '4'),
(8076, 15, 220, 'Oberhofen am Irrsee', 'AT', '4'),
(8077, 15, 220, 'Obernberg am Inn', 'AT', '4'),
(8078, 15, 220, 'Oberndorf bei Schwanenstadt', 'AT', '4'),
(8079, 15, 220, 'Oberneukirchen', 'AT', '4'),
(8080, 15, 220, 'Oberwang', 'AT', '4'),
(8081, 15, 220, 'Oedt', 'AT', '4'),
(8082, 15, 220, 'Oepping', 'AT', '4'),
(8083, 15, 220, 'Offenhausen', 'AT', '4'),
(8084, 15, 220, 'Ohlsdorf', 'AT', '4'),
(8085, 15, 220, 'Ort im Innkreis', 'AT', '4'),
(8086, 15, 220, 'Ostermiething', 'AT', '4'),
(8087, 15, 220, 'Ottenschlag im Mühlkreis', 'AT', '4'),
(8088, 15, 220, 'Ottensheim', 'AT', '4'),
(8089, 15, 220, 'Ottnang am Hausruck', 'AT', '4'),
(8090, 15, 220, 'Pabneukirchen', 'AT', '4'),
(8091, 15, 220, 'Palting', 'AT', '4'),
(8092, 15, 220, 'Pasching', 'AT', '4'),
(8093, 15, 220, 'Pattigham', 'AT', '4'),
(8094, 15, 220, 'Pennewang', 'AT', '4'),
(8095, 15, 220, 'Perg', 'AT', '4'),
(8096, 15, 220, 'Perwang am Grabensee', 'AT', '4'),
(8097, 15, 220, 'Pettenbach', 'AT', '4'),
(8098, 15, 220, 'Peuerbach', 'AT', '4'),
(8099, 15, 220, 'Pfaffing', 'AT', '4'),
(8100, 15, 220, 'Pfarrkirchen bei Bad Hall', 'AT', '4'),
(8101, 15, 220, 'Pichl bei Wels', 'AT', '4'),
(8102, 15, 220, 'Pierbach', 'AT', '4'),
(8103, 15, 220, 'Pinsdorf', 'AT', '4'),
(8104, 15, 220, 'Pitzenberg', 'AT', '4'),
(8105, 15, 220, 'Plesching', 'AT', '4'),
(8106, 15, 220, 'Politischer Bezirk Braunau am Inn', 'AT', '4'),
(8107, 15, 220, 'Politischer Bezirk Eferding', 'AT', '4'),
(8108, 15, 220, 'Politischer Bezirk Freistadt', 'AT', '4'),
(8109, 15, 220, 'Politischer Bezirk Gmunden', 'AT', '4'),
(8110, 15, 220, 'Politischer Bezirk Grieskirchen', 'AT', '4'),
(8111, 15, 220, 'Politischer Bezirk Kirchdorf an der Krems', 'AT', '4'),
(8112, 15, 220, 'Politischer Bezirk Linz-Land', 'AT', '4'),
(8113, 15, 220, 'Politischer Bezirk Perg', 'AT', '4'),
(8114, 15, 220, 'Politischer Bezirk Ried im Innkreis', 'AT', '4'),
(8115, 15, 220, 'Politischer Bezirk Rohrbach', 'AT', '4'),
(8116, 15, 220, 'Politischer Bezirk Schärding', 'AT', '4'),
(8117, 15, 220, 'Politischer Bezirk Steyr-Land', 'AT', '4'),
(8118, 15, 220, 'Politischer Bezirk Urfahr-Umgebung', 'AT', '4'),
(8119, 15, 220, 'Politischer Bezirk Vöcklabruck', 'AT', '4'),
(8120, 15, 220, 'Pötting', 'AT', '4'),
(8121, 15, 220, 'Pram', 'AT', '4'),
(8122, 15, 220, 'Prambachkirchen', 'AT', '4'),
(8123, 15, 220, 'Pramet', 'AT', '4'),
(8124, 15, 220, 'Pregarten', 'AT', '4'),
(8125, 15, 220, 'Puchenau', 'AT', '4'),
(8126, 15, 220, 'Puchheim', 'AT', '4'),
(8127, 15, 220, 'Puchlkirchen am Trattberg', 'AT', '4'),
(8128, 15, 220, 'Pucking', 'AT', '4'),
(8129, 15, 220, 'Pühret', 'AT', '4'),
(8130, 15, 220, 'Raab', 'AT', '4'),
(8131, 15, 220, 'Raffelstetten', 'AT', '4'),
(8132, 15, 220, 'Rainbach im Mühlkreis', 'AT', '4'),
(8133, 15, 220, 'Ranshofen', 'AT', '4'),
(8134, 15, 220, 'Redleiten', 'AT', '4'),
(8135, 15, 220, 'Redlham', 'AT', '4'),
(8136, 15, 220, 'Regau', 'AT', '4'),
(8137, 15, 220, 'Reichenau im Mühlkreis', 'AT', '4'),
(8138, 15, 220, 'Reichenthal', 'AT', '4'),
(8139, 15, 220, 'Reichraming', 'AT', '4'),
(8140, 15, 220, 'Reiterndorf', 'AT', '4'),
(8141, 15, 220, 'Ried im Innkreis', 'AT', '4'),
(8142, 15, 220, 'Ried im Traunkreis', 'AT', '4'),
(8143, 15, 220, 'Ried in der Riedmark', 'AT', '4'),
(8144, 15, 220, 'Rohr im Kremstal', 'AT', '4'),
(8145, 15, 220, 'Rohrbach-Berg', 'AT', '4'),
(8146, 15, 220, 'Roitham', 'AT', '4'),
(8147, 15, 220, 'Rufling', 'AT', '4'),
(8148, 15, 220, 'Rüstorf', 'AT', '4'),
(8149, 15, 220, 'Rutzenham', 'AT', '4'),
(8150, 15, 220, 'Sammersdorf', 'AT', '4'),
(8151, 15, 220, 'Sankt Aegidi', 'AT', '4'),
(8152, 15, 220, 'Sankt Dionysen', 'AT', '4'),
(8153, 15, 220, 'Sankt Florian', 'AT', '4'),
(8154, 15, 220, 'Sankt Georgen am Fillmannsbach', 'AT', '4'),
(8155, 15, 220, 'Sankt Georgen an der Gusen', 'AT', '4'),
(8156, 15, 220, 'Sankt Georgen bei Obernberg am Inn', 'AT', '4'),
(8157, 15, 220, 'Sankt Georgen im Attergau', 'AT', '4'),
(8158, 15, 220, 'Sankt Gotthard im Mühlkreis', 'AT', '4'),
(8159, 15, 220, 'Sankt Lorenz', 'AT', '4'),
(8160, 15, 220, 'Sankt Marien', 'AT', '4'),
(8161, 15, 220, 'Sankt Martin', 'AT', '4'),
(8162, 15, 220, 'Sankt Martin im Mühlkreis', 'AT', '4'),
(8163, 15, 220, 'Sankt Oswald bei Freistadt', 'AT', '4'),
(8164, 15, 220, 'Sankt Peter am Hart', 'AT', '4'),
(8165, 15, 220, 'Sankt Ulrich bei Steyr', 'AT', '4'),
(8166, 15, 220, 'Sankt Wolfgang im Salzkammergut', 'AT', '4'),
(8167, 15, 220, 'Sarleinsbach', 'AT', '4'),
(8168, 15, 220, 'Sattledt', 'AT', '4'),
(8169, 15, 220, 'Schafwiesen', 'AT', '4'),
(8170, 15, 220, 'Schalchen', 'AT', '4'),
(8171, 15, 220, 'Schalchham', 'AT', '4'),
(8172, 15, 220, 'Schardenberg', 'AT', '4'),
(8173, 15, 220, 'Schärding', 'AT', '4'),
(8174, 15, 220, 'Schärding Vorstadt', 'AT', '4'),
(8175, 15, 220, 'Scharnstein', 'AT', '4'),
(8176, 15, 220, 'Schenkenfelden', 'AT', '4'),
(8177, 15, 220, 'Schildorn', 'AT', '4'),
(8178, 15, 220, 'Schlatt', 'AT', '4'),
(8179, 15, 220, 'Schlierbach', 'AT', '4'),
(8180, 15, 220, 'Schlüsslberg', 'AT', '4'),
(8181, 15, 220, 'Schöndorf', 'AT', '4'),
(8182, 15, 220, 'Schönering', 'AT', '4'),
(8183, 15, 220, 'Schörfling', 'AT', '4'),
(8184, 15, 220, 'Schwanenstadt', 'AT', '4'),
(8185, 15, 220, 'Schweinbach', 'AT', '4'),
(8186, 15, 220, 'Schwertberg', 'AT', '4'),
(8187, 15, 220, 'Seewalchen', 'AT', '4'),
(8188, 15, 220, 'Sierning', 'AT', '4'),
(8189, 15, 220, 'Sonnberg im Mühlkreis', 'AT', '4'),
(8190, 15, 220, 'Spital am Pyhrn', 'AT', '4'),
(8191, 15, 220, 'Stadl-Hausruck', 'AT', '4'),
(8192, 15, 220, 'Stadl-Paura', 'AT', '4'),
(8193, 15, 220, 'Stadl-Traun', 'AT', '4'),
(8194, 15, 220, 'Steinbach am Attersee', 'AT', '4'),
(8195, 15, 220, 'Steinerkirchen an der Traun', 'AT', '4'),
(8196, 15, 220, 'Steinfeld', 'AT', '4'),
(8197, 15, 220, 'Steinhaus', 'AT', '4'),
(8198, 15, 220, 'Steyr', 'AT', '4'),
(8199, 15, 220, 'Steyr Stadt', 'AT', '4'),
(8200, 15, 220, 'Steyregg', 'AT', '4'),
(8201, 15, 220, 'Strassham', 'AT', '4'),
(8202, 15, 220, 'Taiskirchen im Innkreis', 'AT', '4'),
(8203, 15, 220, 'Taufkirchen an der Trattnach', 'AT', '4'),
(8204, 15, 220, 'Ternberg', 'AT', '4'),
(8205, 15, 220, 'Thalheim bei Wels', 'AT', '4'),
(8206, 15, 220, 'Tiefgraben', 'AT', '4'),
(8207, 15, 220, 'Timelkam', 'AT', '4'),
(8208, 15, 220, 'Tragwein', 'AT', '4'),
(8209, 15, 220, 'Traun', 'AT', '4'),
(8210, 15, 220, 'Traunkirchen', 'AT', '4'),
(8211, 15, 220, 'Ufer', 'AT', '4'),
(8212, 15, 220, 'Ulrichsberg', 'AT', '4'),
(8213, 15, 220, 'Ungenach', 'AT', '4'),
(8214, 15, 220, 'Untereisenfeld', 'AT', '4'),
(8215, 15, 220, 'Unterjosefstal', 'AT', '4'),
(8216, 15, 220, 'Uttendorf', 'AT', '4'),
(8217, 15, 220, 'Utzenaich', 'AT', '4'),
(8218, 15, 220, 'Viechtwang', 'AT', '4'),
(8219, 15, 220, 'Vöcklabruck', 'AT', '4'),
(8220, 15, 220, 'Vöcklamarkt', 'AT', '4'),
(8221, 15, 220, 'Vorchdorf', 'AT', '4'),
(8222, 15, 220, 'Wagrain', 'AT', '4'),
(8223, 15, 220, 'Wagram', 'AT', '4'),
(8224, 15, 220, 'Waizenkirchen', 'AT', '4'),
(8225, 15, 220, 'Walding', 'AT', '4'),
(8226, 15, 220, 'Waldkirchen am Wesen', 'AT', '4'),
(8227, 15, 220, 'Waldneukirchen', 'AT', '4'),
(8228, 15, 220, 'Waldzell', 'AT', '4'),
(8229, 15, 220, 'Wallern an der Trattnach', 'AT', '4'),
(8230, 15, 220, 'Wartberg an der Krems', 'AT', '4'),
(8231, 15, 220, 'Wartberg ob der Aist', 'AT', '4'),
(8232, 15, 220, 'Weibern', 'AT', '4'),
(8233, 15, 220, 'Weilbach', 'AT', '4'),
(8234, 15, 220, 'Weißenkirchen im Attergau', 'AT', '4'),
(8235, 15, 220, 'Weisskirchen an der Traun', 'AT', '4'),
(8236, 15, 220, 'Weitersfelden', 'AT', '4'),
(8237, 15, 220, 'Wels', 'AT', '4'),
(8238, 15, 220, 'Wels Stadt', 'AT', '4'),
(8239, 15, 220, 'Wels-Land', 'AT', '4'),
(8240, 15, 220, 'Wendling', 'AT', '4'),
(8241, 15, 220, 'Weng im Innkreis', 'AT', '4'),
(8242, 15, 220, 'Wernstein am Inn', 'AT', '4'),
(8243, 15, 220, 'Weyer', 'AT', '4'),
(8244, 15, 220, 'Weyregg', 'AT', '4'),
(8245, 15, 220, 'Wimpassing', 'AT', '4'),
(8246, 15, 220, 'Wimsbach', 'AT', '4'),
(8247, 15, 220, 'Windhaag bei Freistadt', 'AT', '4'),
(8248, 15, 220, 'Windhaag bei Perg', 'AT', '4'),
(8249, 15, 220, 'Windischgarsten', 'AT', '4'),
(8250, 15, 220, 'Wippenham', 'AT', '4'),
(8251, 15, 220, 'Wispl', 'AT', '4'),
(8252, 15, 220, 'Wolfern', 'AT', '4'),
(8253, 15, 220, 'Wolfsegg am Hausruck', 'AT', '4'),
(8254, 15, 220, 'Zell am Moos', 'AT', '4'),
(8255, 15, 220, 'Zell am Pettenfirst', 'AT', '4'),
(8256, 15, 220, 'Zell an der Pram', 'AT', '4'),
(8257, 15, 220, 'Zwettl an der Rodl', 'AT', '4'),
(8258, 15, 221, 'Donaustadt', 'AT', '9'),
(8259, 15, 221, 'Favoriten', 'AT', '9'),
(8260, 15, 221, 'Floridsdorf', 'AT', '9'),
(8261, 15, 221, 'Hernals', 'AT', '9'),
(8262, 15, 221, 'Hietzing', 'AT', '9'),
(8263, 15, 221, 'Innere Stadt', 'AT', '9'),
(8264, 15, 221, 'Meidling', 'AT', '9'),
(8265, 15, 221, 'Ottakring', 'AT', '9'),
(8266, 15, 221, 'Simmering', 'AT', '9'),
(8267, 15, 221, 'Vienna', 'AT', '9'),
(8268, 15, 222, 'Alberschwende', 'AT', '8'),
(8269, 15, 222, 'Altach', 'AT', '8'),
(8270, 15, 222, 'Andelsbuch', 'AT', '8'),
(8271, 15, 222, 'Au', 'AT', '8'),
(8272, 15, 222, 'Ausserbraz', 'AT', '8'),
(8273, 15, 222, 'Bartholomäberg', 'AT', '8'),
(8274, 15, 222, 'Batschuns', 'AT', '8'),
(8275, 15, 222, 'Bezau', 'AT', '8'),
(8276, 15, 222, 'Bildstein', 'AT', '8'),
(8277, 15, 222, 'Bizau', 'AT', '8'),
(8278, 15, 222, 'Blons', 'AT', '8'),
(8279, 15, 222, 'Bludenz', 'AT', '8'),
(8280, 15, 222, 'Bludesch', 'AT', '8'),
(8281, 15, 222, 'Brand', 'AT', '8'),
(8282, 15, 222, 'Bregenz', 'AT', '8'),
(8283, 15, 222, 'Bürs', 'AT', '8'),
(8284, 15, 222, 'Bürserberg', 'AT', '8'),
(8285, 15, 222, 'Dalaas', 'AT', '8'),
(8286, 15, 222, 'Damüls', 'AT', '8'),
(8287, 15, 222, 'Doren', 'AT', '8'),
(8288, 15, 222, 'Dornbirn', 'AT', '8'),
(8289, 15, 222, 'Düns', 'AT', '8'),
(8290, 15, 222, 'Dünserberg', 'AT', '8'),
(8291, 15, 222, 'Egg', 'AT', '8'),
(8292, 15, 222, 'Eichenberg', 'AT', '8'),
(8293, 15, 222, 'Feldkirch', 'AT', '8'),
(8294, 15, 222, 'Frastanz', 'AT', '8'),
(8295, 15, 222, 'Fraxern', 'AT', '8'),
(8296, 15, 222, 'Fußach', 'AT', '8'),
(8297, 15, 222, 'Gaißau', 'AT', '8'),
(8298, 15, 222, 'Gaschurn', 'AT', '8'),
(8299, 15, 222, 'Göfis', 'AT', '8'),
(8300, 15, 222, 'Götzis', 'AT', '8'),
(8301, 15, 222, 'Großdorf', 'AT', '8'),
(8302, 15, 222, 'Hard', 'AT', '8'),
(8303, 15, 222, 'Hirschegg', 'AT', '8'),
(8304, 15, 222, 'Hittisau', 'AT', '8'),
(8305, 15, 222, 'Höchst', 'AT', '8'),
(8306, 15, 222, 'Hohenems', 'AT', '8'),
(8307, 15, 222, 'Hohenweiler', 'AT', '8'),
(8308, 15, 222, 'Hörbranz', 'AT', '8'),
(8309, 15, 222, 'Innerbraz', 'AT', '8'),
(8310, 15, 222, 'Kennelbach', 'AT', '8'),
(8311, 15, 222, 'Klaus', 'AT', '8'),
(8312, 15, 222, 'Klösterle', 'AT', '8'),
(8313, 15, 222, 'Koblach', 'AT', '8'),
(8314, 15, 222, 'Krumbach', 'AT', '8'),
(8315, 15, 222, 'Langen', 'AT', '8'),
(8316, 15, 222, 'Langenegg', 'AT', '8'),
(8317, 15, 222, 'Lauterach', 'AT', '8'),
(8318, 15, 222, 'Lech', 'AT', '8'),
(8319, 15, 222, 'Lingenau', 'AT', '8'),
(8320, 15, 222, 'Lochau', 'AT', '8'),
(8321, 15, 222, 'Lorüns', 'AT', '8'),
(8322, 15, 222, 'Ludesch', 'AT', '8'),
(8323, 15, 222, 'Lustenau', 'AT', '8'),
(8324, 15, 222, 'Mäder', 'AT', '8'),
(8325, 15, 222, 'Meiningen', 'AT', '8'),
(8326, 15, 222, 'Mellau', 'AT', '8'),
(8327, 15, 222, 'Mittelberg', 'AT', '8'),
(8328, 15, 222, 'Möggers', 'AT', '8'),
(8329, 15, 222, 'Muntlix', 'AT', '8'),
(8330, 15, 222, 'Nenzing', 'AT', '8'),
(8331, 15, 222, 'Nüziders', 'AT', '8'),
(8332, 15, 222, 'Politischer Bezirk Bludenz', 'AT', '8'),
(8333, 15, 222, 'Politischer Bezirk Bregenz', 'AT', '8'),
(8334, 15, 222, 'Politischer Bezirk Dornbirn', 'AT', '8'),
(8335, 15, 222, 'Politischer Bezirk Feldkirch', 'AT', '8'),
(8336, 15, 222, 'Raggal', 'AT', '8'),
(8337, 15, 222, 'Rankweil', 'AT', '8'),
(8338, 15, 222, 'Reuthe', 'AT', '8'),
(8339, 15, 222, 'Riefensberg', 'AT', '8'),
(8340, 15, 222, 'Riezlern', 'AT', '8'),
(8341, 15, 222, 'Röns', 'AT', '8'),
(8342, 15, 222, 'Röthis', 'AT', '8'),
(8343, 15, 222, 'Sankt Anton im Montafon', 'AT', '8'),
(8344, 15, 222, 'Sankt Gallenkirch', 'AT', '8'),
(8345, 15, 222, 'Satteins', 'AT', '8'),
(8346, 15, 222, 'Schlins', 'AT', '8'),
(8347, 15, 222, 'Schnepfau', 'AT', '8'),
(8348, 15, 222, 'Schnifis', 'AT', '8'),
(8349, 15, 222, 'Schoppernau', 'AT', '8'),
(8350, 15, 222, 'Schröcken', 'AT', '8'),
(8351, 15, 222, 'Schruns', 'AT', '8'),
(8352, 15, 222, 'Schwarzach', 'AT', '8'),
(8353, 15, 222, 'Schwarzenberg', 'AT', '8'),
(8354, 15, 222, 'Sibratsgfäll', 'AT', '8'),
(8355, 15, 222, 'Silbertal', 'AT', '8'),
(8356, 15, 222, 'Stallehr', 'AT', '8'),
(8357, 15, 222, 'Sulz', 'AT', '8'),
(8358, 15, 222, 'Sulzberg', 'AT', '8'),
(8359, 15, 222, 'Thüringen', 'AT', '8'),
(8360, 15, 222, 'Tschagguns', 'AT', '8'),
(8361, 15, 222, 'Übersaxen', 'AT', '8'),
(8362, 15, 222, 'Vandans', 'AT', '8'),
(8363, 15, 222, 'Viktorsberg', 'AT', '8'),
(8364, 15, 222, 'Warth', 'AT', '8'),
(8365, 15, 222, 'Weiler', 'AT', '8'),
(8366, 15, 222, 'Wolfurt', 'AT', '8'),
(8367, 16, 223, 'Ceyranbatan', 'AZ', 'ABS'),
(8368, 16, 223, 'Digah', 'AZ', 'ABS'),
(8369, 16, 223, 'Gyuzdek', 'AZ', 'ABS'),
(8370, 16, 223, 'Khirdalan', 'AZ', 'ABS'),
(8371, 16, 223, 'Qobu', 'AZ', 'ABS'),
(8372, 16, 223, 'Saray', 'AZ', 'ABS'),
(8373, 16, 224, 'Ağdam', 'AZ', 'AGM'),
(8374, 16, 225, 'Ağdaş', 'AZ', 'AGS'),
(8375, 16, 226, 'Agdzhabedy', 'AZ', 'AGC'),
(8376, 16, 226, 'Avşar', 'AZ', 'AGC'),
(8377, 16, 227, 'Aghstafa', 'AZ', 'AGA'),
(8378, 16, 227, 'Saloğlu', 'AZ', 'AGA'),
(8379, 16, 227, 'Vurğun', 'AZ', 'AGA'),
(8380, 16, 228, 'Aghsu', 'AZ', 'AGU'),
(8381, 16, 229, 'Astara', 'AZ', 'AST'),
(8382, 16, 229, 'Kizhaba', 'AZ', 'AST'),
(8383, 16, 231, 'Amirdzhan', 'AZ', 'BA'),
(8384, 16, 231, 'Badamdar', 'AZ', 'BA'),
(8385, 16, 231, 'Bakıxanov', 'AZ', 'BA'),
(8386, 16, 231, 'Baku', 'AZ', 'BA'),
(8387, 16, 231, 'Balakhani', 'AZ', 'BA'),
(8388, 16, 231, 'Bilajari', 'AZ', 'BA'),
(8389, 16, 231, 'Bilajer', 'AZ', 'BA'),
(8390, 16, 231, 'Binagadi', 'AZ', 'BA'),
(8391, 16, 231, 'Biny Selo', 'AZ', 'BA'),
(8392, 16, 231, 'Buzovna', 'AZ', 'BA'),
(8393, 16, 231, 'Hövsan', 'AZ', 'BA'),
(8394, 16, 231, 'Khodzhi-Gasan', 'AZ', 'BA'),
(8395, 16, 231, 'Korgöz', 'AZ', 'BA'),
(8396, 16, 231, 'Lökbatan', 'AZ', 'BA'),
(8397, 16, 231, 'Mardakan', 'AZ', 'BA'),
(8398, 16, 231, 'Maştağa', 'AZ', 'BA'),
(8399, 16, 231, 'Nardaran', 'AZ', 'BA'),
(8400, 16, 231, 'Nizami Rayonu', 'AZ', 'BA'),
(8401, 16, 231, 'Pirallahı', 'AZ', 'BA'),
(8402, 16, 231, 'Puta', 'AZ', 'BA'),
(8403, 16, 231, 'Qala', 'AZ', 'BA'),
(8404, 16, 231, 'Qaraçuxur', 'AZ', 'BA'),
(8405, 16, 231, 'Qobustan', 'AZ', 'BA'),
(8406, 16, 231, 'Ramana', 'AZ', 'BA'),
(8407, 16, 231, 'Sabunçu', 'AZ', 'BA'),
(8408, 16, 231, 'Sanqaçal', 'AZ', 'BA'),
(8409, 16, 231, 'Türkan', 'AZ', 'BA'),
(8410, 16, 231, 'Yeni Suraxanı', 'AZ', 'BA'),
(8411, 16, 231, 'Zabrat', 'AZ', 'BA'),
(8412, 16, 231, 'Zyrya', 'AZ', 'BA'),
(8413, 16, 232, 'Belokany', 'AZ', 'BAL'),
(8414, 16, 232, 'Qabaqçöl', 'AZ', 'BAL'),
(8415, 16, 233, 'Barda', 'AZ', 'BAR'),
(8416, 16, 233, 'Samuxlu', 'AZ', 'BAR'),
(8417, 16, 234, 'Beylagan', 'AZ', 'BEY'),
(8418, 16, 234, 'Birinci Aşıqlı', 'AZ', 'BEY'),
(8419, 16, 234, 'Dünyamalılar', 'AZ', 'BEY'),
(8420, 16, 234, 'Orjonikidze', 'AZ', 'BEY'),
(8421, 16, 234, 'Yuxarı Aran', 'AZ', 'BEY'),
(8422, 16, 235, 'Pushkino', 'AZ', 'BIL'),
(8423, 16, 236, 'Verkhniy Dashkesan', 'AZ', 'DAS'),
(8424, 16, 236, 'Yukhary-Dashkesan', 'AZ', 'DAS'),
(8425, 16, 237, 'Fizuli', 'AZ', 'FUZ'),
(8426, 16, 237, 'Horadiz', 'AZ', 'FUZ'),
(8427, 16, 238, 'Ganja', 'AZ', 'GA'),
(8428, 16, 239, 'Arıqdam', 'AZ', 'GAD'),
(8429, 16, 239, 'Arıqıran', 'AZ', 'GAD'),
(8430, 16, 239, 'Böyük Qaramurad', 'AZ', 'GAD'),
(8431, 16, 239, 'Kyadabek', 'AZ', 'GAD'),
(8432, 16, 239, 'Novosaratovka', 'AZ', 'GAD'),
(8433, 16, 240, 'Qobustan', 'AZ', 'QOB'),
(8434, 16, 241, 'Goranboy', 'AZ', 'GOR'),
(8435, 16, 241, 'Qızılhacılı', 'AZ', 'GOR'),
(8436, 16, 242, 'Geoktschai', 'AZ', 'GOY'),
(8437, 16, 243, 'Yelenendorf', 'AZ', 'GYG'),
(8438, 16, 244, 'Hacıqabul', 'AZ', 'HAC'),
(8439, 16, 244, 'Mughan', 'AZ', 'HAC'),
(8440, 16, 245, 'Imishli', 'AZ', 'IMI'),
(8441, 16, 246, 'Basqal', 'AZ', 'ISM'),
(8442, 16, 246, 'İsmayıllı', 'AZ', 'ISM'),
(8443, 16, 247, 'Jebrail', 'AZ', 'CAB'),
(8444, 16, 248, 'Jalilabad', 'AZ', 'CAL'),
(8445, 16, 248, 'Prishibinskoye', 'AZ', 'CAL'),
(8446, 16, 250, 'Kerbakhiar', 'AZ', 'KAL'),
(8447, 16, 250, 'Vank', 'AZ', 'KAL'),
(8448, 16, 252, 'Xaçmaz', 'AZ', 'XAC'),
(8449, 16, 252, 'Xudat', 'AZ', 'XAC'),
(8450, 16, 253, 'Altıağac', 'AZ', 'XIZ'),
(8451, 16, 253, 'Khyzy', 'AZ', 'XIZ'),
(8452, 16, 253, 'Kilyazi', 'AZ', 'XIZ'),
(8453, 16, 253, 'Şuraabad', 'AZ', 'XIZ'),
(8454, 16, 254, 'Askyaran', 'AZ', 'XCI'),
(8455, 16, 254, 'Xocalı', 'AZ', 'XCI'),
(8456, 16, 255, 'Kyurdarmir', 'AZ', 'KUR'),
(8457, 16, 256, 'Laçın', 'AZ', 'LAC'),
(8458, 16, 258, 'Haftoni', 'AZ', 'LA'),
(8459, 16, 258, 'Lankaran', 'AZ', 'LA'),
(8460, 16, 259, 'Lerik', 'AZ', 'LER'),
(8461, 16, 260, 'Hadrut', 'AZ', 'XVD'),
(8462, 16, 260, 'Novyy Karanlug', 'AZ', 'XVD'),
(8463, 16, 260, 'Qırmızı Bazar', 'AZ', 'XVD'),
(8464, 16, 261, 'Boradigah', 'AZ', 'MAS'),
(8465, 16, 261, 'Masally', 'AZ', 'MAS'),
(8466, 16, 262, 'Mingelchaur', 'AZ', 'MI'),
(8467, 16, 263, 'Cahri', 'AZ', 'NX'),
(8468, 16, 263, 'Çalxanqala', 'AZ', 'NX'),
(8469, 16, 263, 'Culfa', 'AZ', 'NX'),
(8470, 16, 263, 'Deste', 'AZ', 'NX'),
(8471, 16, 263, 'Heydarabad', 'AZ', 'NX'),
(8472, 16, 263, 'Julfa Rayon', 'AZ', 'NX'),
(8473, 16, 263, 'Nakhchivan', 'AZ', 'NX'),
(8474, 16, 263, 'Oğlanqala', 'AZ', 'NX'),
(8475, 16, 263, 'Ordubad', 'AZ', 'NX'),
(8476, 16, 263, 'Ordubad Rayon', 'AZ', 'NX'),
(8477, 16, 263, 'Qıvraq', 'AZ', 'NX'),
(8478, 16, 263, 'Şahbuz', 'AZ', 'NX'),
(8479, 16, 263, 'Sedarak', 'AZ', 'NX'),
(8480, 16, 263, 'Shahbuz Rayon', 'AZ', 'NX'),
(8481, 16, 263, 'Sharur City', 'AZ', 'NX'),
(8482, 16, 263, 'Sumbatan-diza', 'AZ', 'NX'),
(8483, 16, 263, 'Tazakend', 'AZ', 'NX'),
(8484, 16, 263, 'Yaycı', 'AZ', 'NX'),
(8485, 16, 264, 'Neftçala', 'AZ', 'NEF'),
(8486, 16, 264, 'Severo-Vostotchnyi Bank', 'AZ', 'NEF'),
(8487, 16, 264, 'Sovetabad', 'AZ', 'NEF'),
(8488, 16, 264, 'Xıllı', 'AZ', 'NEF'),
(8489, 16, 265, 'Oğuz', 'AZ', 'OGU'),
(8490, 16, 267, 'Qutqashen', 'AZ', 'QAB'),
(8491, 16, 268, 'Çinarlı', 'AZ', 'QAX'),
(8492, 16, 268, 'Qax', 'AZ', 'QAX'),
(8493, 16, 268, 'Qax İngiloy', 'AZ', 'QAX'),
(8494, 16, 268, 'Qaxbaş', 'AZ', 'QAX'),
(8495, 16, 269, 'Qazax', 'AZ', 'QAZ'),
(8496, 16, 270, 'Hacıhüseynli', 'AZ', 'QBA'),
(8497, 16, 270, 'Quba', 'AZ', 'QBA'),
(8498, 16, 271, 'Qubadlı', 'AZ', 'QBI'),
(8499, 16, 272, 'Qusar', 'AZ', 'QUS'),
(8500, 16, 272, 'Samur', 'AZ', 'QUS');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(8501, 16, 273, 'Əhmədbəyli', 'AZ', 'SAT'),
(8502, 16, 273, 'Saatlı', 'AZ', 'SAT'),
(8503, 16, 274, 'Sabirabad', 'AZ', 'SAB'),
(8504, 16, 276, 'Qaraçala', 'AZ', 'SAL'),
(8505, 16, 276, 'Salyan', 'AZ', 'SAL'),
(8506, 16, 277, 'Qarayeri', 'AZ', 'SMX'),
(8507, 16, 277, 'Qırmızı Samux', 'AZ', 'SMX'),
(8508, 16, 277, 'Samux', 'AZ', 'SMX'),
(8509, 16, 278, 'Divichibazar', 'AZ', 'SBN'),
(8510, 16, 280, 'Sheki', 'AZ', 'SA'),
(8511, 16, 281, 'Baş Göynük', 'AZ', 'SAK'),
(8512, 16, 282, 'Shamakhi', 'AZ', 'SMI'),
(8513, 16, 283, 'Dolyar', 'AZ', 'SKR'),
(8514, 16, 283, 'Dzagam', 'AZ', 'SKR'),
(8515, 16, 283, 'Qasım İsmayılov', 'AZ', 'SKR'),
(8516, 16, 283, 'Shamkhor', 'AZ', 'SKR'),
(8517, 16, 285, 'Şirvan', 'AZ', 'SR'),
(8518, 16, 286, 'Shushi', 'AZ', 'SUS'),
(8519, 16, 287, 'Gilgilçay', 'AZ', 'SIY'),
(8520, 16, 287, 'Kyzyl-Burun', 'AZ', 'SIY'),
(8521, 16, 288, 'Corat', 'AZ', 'SM'),
(8522, 16, 288, 'Hacı Zeynalabdin', 'AZ', 'SM'),
(8523, 16, 288, 'Sumqayıt', 'AZ', 'SM'),
(8524, 16, 289, 'Martakert', 'AZ', 'TAR'),
(8525, 16, 289, 'Terter', 'AZ', 'TAR'),
(8526, 16, 290, 'Çatax', 'AZ', 'TOV'),
(8527, 16, 290, 'Çobansığnaq', 'AZ', 'TOV'),
(8528, 16, 290, 'Dondar Quşçu', 'AZ', 'TOV'),
(8529, 16, 290, 'Qaraxanlı', 'AZ', 'TOV'),
(8530, 16, 290, 'Tovuz', 'AZ', 'TOV'),
(8531, 16, 290, 'Yanıqlı', 'AZ', 'TOV'),
(8532, 16, 291, 'Ujar', 'AZ', 'UCA'),
(8533, 16, 292, 'Yardımlı', 'AZ', 'YAR'),
(8534, 16, 293, 'Yevlakh', 'AZ', 'YE'),
(8535, 16, 294, 'Aran', 'AZ', 'YEV'),
(8536, 16, 294, 'Qaramanlı', 'AZ', 'YEV'),
(8537, 16, 295, 'Mincivan', 'AZ', 'ZAN'),
(8538, 16, 295, 'Zangilan', 'AZ', 'ZAN'),
(8539, 16, 296, 'Aliabad', 'AZ', 'ZAQ'),
(8540, 16, 296, 'Faldarlı', 'AZ', 'ZAQ'),
(8541, 16, 296, 'Mamrux', 'AZ', 'ZAQ'),
(8542, 16, 296, 'Qandax', 'AZ', 'ZAQ'),
(8543, 16, 296, 'Zaqatala', 'AZ', 'ZAQ'),
(8544, 16, 297, 'Zardob', 'AZ', 'ZAR'),
(8545, 17, 298, 'Jidd Ḩafş', 'BH', '13'),
(8546, 17, 298, 'Manama', 'BH', '13'),
(8547, 17, 298, 'Sitrah', 'BH', '13'),
(8548, 17, 299, 'Madīnat Ḩamad', 'BH', '16'),
(8549, 17, 300, 'Al Ḩadd', 'BH', '15'),
(8550, 17, 300, 'Al Muharraq', 'BH', '15'),
(8551, 17, 302, 'Ar Rifā‘', 'BH', '14'),
(8552, 17, 302, 'Dār Kulayb', 'BH', '14'),
(8553, 17, 302, 'Madīnat ‘Īsá', 'BH', '14'),
(8554, 18, 307, 'Barguna', 'BD', '06'),
(8555, 18, 307, 'Barisal', 'BD', '06'),
(8556, 18, 307, 'Bhāndāria', 'BD', '06'),
(8557, 18, 307, 'Bhola', 'BD', '06'),
(8558, 18, 307, 'Burhānuddin', 'BD', '06'),
(8559, 18, 307, 'Gaurnadi', 'BD', '06'),
(8560, 18, 307, 'Jhalokati', 'BD', '06'),
(8561, 18, 307, 'Lālmohan', 'BD', '06'),
(8562, 18, 307, 'Mathba', 'BD', '06'),
(8563, 18, 307, 'Mehendiganj', 'BD', '06'),
(8564, 18, 307, 'Nālchiti', 'BD', '06'),
(8565, 18, 307, 'Patuakhali', 'BD', '06'),
(8566, 18, 307, 'Pirojpur', 'BD', '06'),
(8567, 18, 315, 'Bandarban', 'BD', 'B'),
(8568, 18, 315, 'Bibir Hat', 'BD', 'B'),
(8569, 18, 315, 'Brahmanbaria', 'BD', 'B'),
(8570, 18, 315, 'Chandpur', 'BD', 'B'),
(8571, 18, 315, 'Chhāgalnāiya', 'BD', 'B'),
(8572, 18, 315, 'Chittagong', 'BD', 'B'),
(8573, 18, 315, 'Comilla', 'BD', 'B'),
(8574, 18, 315, 'Cox\'s Bazar', 'BD', 'B'),
(8575, 18, 315, 'Cox’s Bāzār', 'BD', 'B'),
(8576, 18, 315, 'Feni', 'BD', 'B'),
(8577, 18, 315, 'Hājīganj', 'BD', 'B'),
(8578, 18, 315, 'Khagrachhari', 'BD', 'B'),
(8579, 18, 315, 'Lākshām', 'BD', 'B'),
(8580, 18, 315, 'Lakshmipur', 'BD', 'B'),
(8581, 18, 315, 'Manikchari', 'BD', 'B'),
(8582, 18, 315, 'Nabīnagar', 'BD', 'B'),
(8583, 18, 315, 'Noakhali', 'BD', 'B'),
(8584, 18, 315, 'Patiya', 'BD', 'B'),
(8585, 18, 315, 'Rāipur', 'BD', 'B'),
(8586, 18, 315, 'Rāmganj', 'BD', 'B'),
(8587, 18, 315, 'Rangamati', 'BD', 'B'),
(8588, 18, 315, 'Raojān', 'BD', 'B'),
(8589, 18, 315, 'Sandwīp', 'BD', 'B'),
(8590, 18, 315, 'Sātkania', 'BD', 'B'),
(8591, 18, 315, 'Teknāf', 'BD', 'B'),
(8592, 18, 319, 'Azimpur', 'BD', '13'),
(8593, 18, 319, 'Bājitpur', 'BD', '13'),
(8594, 18, 319, 'Bhairab Bāzār', 'BD', '13'),
(8595, 18, 319, 'Char Bhadrāsan', 'BD', '13'),
(8596, 18, 319, 'Char Golora', 'BD', '13'),
(8597, 18, 319, 'Dhaka', 'BD', '13'),
(8598, 18, 319, 'Dohār', 'BD', '13'),
(8599, 18, 319, 'Faridpur', 'BD', '13'),
(8600, 18, 319, 'Gazipur', 'BD', '13'),
(8601, 18, 319, 'Gopalganj', 'BD', '13'),
(8602, 18, 319, 'Joymontop', 'BD', '13'),
(8603, 18, 319, 'Khanbaniara', 'BD', '13'),
(8604, 18, 319, 'Kishoregonj', 'BD', '13'),
(8605, 18, 319, 'Kishorganj', 'BD', '13'),
(8606, 18, 319, 'Madaripur', 'BD', '13'),
(8607, 18, 319, 'Manikganj', 'BD', '13'),
(8608, 18, 319, 'Mirzāpur', 'BD', '13'),
(8609, 18, 319, 'Munshiganj', 'BD', '13'),
(8610, 18, 319, 'Nāgarpur', 'BD', '13'),
(8611, 18, 319, 'Narayanganj', 'BD', '13'),
(8612, 18, 319, 'Narsingdi', 'BD', '13'),
(8613, 18, 319, 'Pālang', 'BD', '13'),
(8614, 18, 319, 'Paltan', 'BD', '13'),
(8615, 18, 319, 'Parvez Ali', 'BD', '13'),
(8616, 18, 319, 'Parvez Ali Hossain', 'BD', '13'),
(8617, 18, 319, 'Rajbari', 'BD', '13'),
(8618, 18, 319, 'Ramnagar', 'BD', '13'),
(8619, 18, 319, 'Sakhipur', 'BD', '13'),
(8620, 18, 319, 'Sayani', 'BD', '13'),
(8621, 18, 319, 'Shariatpur', 'BD', '13'),
(8622, 18, 319, 'Sonārgaon', 'BD', '13'),
(8623, 18, 319, 'Tangail', 'BD', '13'),
(8624, 18, 319, 'Tungi', 'BD', '13'),
(8625, 18, 319, 'Tungipāra', 'BD', '13'),
(8626, 18, 334, 'Bagerhat', 'BD', '27'),
(8627, 18, 334, 'Bhātpāra Abhaynagar', 'BD', '27'),
(8628, 18, 334, 'Bherāmāra', 'BD', '27'),
(8629, 18, 334, 'Chuadanga', 'BD', '27'),
(8630, 18, 334, 'Jessore', 'BD', '27'),
(8631, 18, 334, 'Jhenaidah', 'BD', '27'),
(8632, 18, 334, 'Jhingergācha', 'BD', '27'),
(8633, 18, 334, 'Kālia', 'BD', '27'),
(8634, 18, 334, 'Kālīganj', 'BD', '27'),
(8635, 18, 334, 'Kesabpur', 'BD', '27'),
(8636, 18, 334, 'Khulna', 'BD', '27'),
(8637, 18, 334, 'Kushtia', 'BD', '27'),
(8638, 18, 334, 'Magura', 'BD', '27'),
(8639, 18, 334, 'Meherpur', 'BD', '27'),
(8640, 18, 334, 'Morrelgonj', 'BD', '27'),
(8641, 18, 334, 'Narail', 'BD', '27'),
(8642, 18, 334, 'Nowlamary', 'BD', '27'),
(8643, 18, 334, 'Phultala', 'BD', '27'),
(8644, 18, 334, 'Sarankhola', 'BD', '27'),
(8645, 18, 334, 'Satkhira', 'BD', '27'),
(8646, 18, 334, 'Ujalpur', 'BD', '27'),
(8647, 18, 334, 'Uttar Char Fasson', 'BD', '27'),
(8648, 18, 345, 'Gafargaon', 'BD', '34'),
(8649, 18, 345, 'Jamalpur', 'BD', '34'),
(8650, 18, 345, 'Muktāgācha', 'BD', '34'),
(8651, 18, 345, 'Mymensingh', 'BD', '34'),
(8652, 18, 345, 'Netrakona', 'BD', '34'),
(8653, 18, 345, 'Sarishābāri', 'BD', '34'),
(8654, 18, 345, 'Sherpur', 'BD', '34'),
(8655, 18, 359, 'Bera', 'BD', '54'),
(8656, 18, 359, 'Bogra', 'BD', '54'),
(8657, 18, 359, 'Chapai Nababganj', 'BD', '54'),
(8658, 18, 359, 'Ishurdi', 'BD', '54'),
(8659, 18, 359, 'Joypur Hāt', 'BD', '54'),
(8660, 18, 359, 'Joypurhat', 'BD', '54'),
(8661, 18, 359, 'Mahasthangarh', 'BD', '54'),
(8662, 18, 359, 'Naogaon', 'BD', '54'),
(8663, 18, 359, 'Natore', 'BD', '54'),
(8664, 18, 359, 'Nawābganj', 'BD', '54'),
(8665, 18, 359, 'Pabna', 'BD', '54'),
(8666, 18, 359, 'Pār Naogaon', 'BD', '54'),
(8667, 18, 359, 'Puthia', 'BD', '54'),
(8668, 18, 359, 'Rajshahi', 'BD', '54'),
(8669, 18, 359, 'Saidpur', 'BD', '54'),
(8670, 18, 359, 'Shāhzādpur', 'BD', '54'),
(8671, 18, 359, 'Shibganj', 'BD', '54'),
(8672, 18, 359, 'Sirajganj', 'BD', '54'),
(8673, 18, 362, 'Badarganj', 'BD', '55'),
(8674, 18, 362, 'Chilmāri', 'BD', '55'),
(8675, 18, 362, 'Dinajpur', 'BD', '55'),
(8676, 18, 362, 'Gaibandha', 'BD', '55'),
(8677, 18, 362, 'Kurigram', 'BD', '55'),
(8678, 18, 362, 'Lalmonirhat', 'BD', '55'),
(8679, 18, 362, 'Lalmonirhat District', 'BD', '55'),
(8680, 18, 362, 'Nageswari', 'BD', '55'),
(8681, 18, 362, 'Nilphamari Zila', 'BD', '55'),
(8682, 18, 362, 'Panchagarh', 'BD', '55'),
(8683, 18, 362, 'Parbatipur', 'BD', '55'),
(8684, 18, 362, 'Pīrgaaj', 'BD', '55'),
(8685, 18, 362, 'Rangpur', 'BD', '55'),
(8686, 18, 362, 'Thakurgaon', 'BD', '55'),
(8687, 18, 369, 'Baniachang', 'BD', '60'),
(8688, 18, 369, 'Chhātak', 'BD', '60'),
(8689, 18, 369, 'Habiganj', 'BD', '60'),
(8690, 18, 369, 'Jahedpur', 'BD', '60'),
(8691, 18, 369, 'Maulavi Bāzār', 'BD', '60'),
(8692, 18, 369, 'Maulvibazar', 'BD', '60'),
(8693, 18, 369, 'Sunamganj', 'BD', '60'),
(8694, 18, 369, 'Sylhet', 'BD', '60'),
(8695, 19, 373, 'Oistins', 'BB', '01'),
(8696, 19, 374, 'Greenland', 'BB', '02'),
(8697, 19, 376, 'Holetown', 'BB', '04'),
(8698, 19, 378, 'Bathsheba', 'BB', '06'),
(8699, 19, 380, 'Bridgetown', 'BB', '08'),
(8700, 19, 381, 'Speightstown', 'BB', '09'),
(8701, 19, 382, 'Crane', 'BB', '10'),
(8702, 20, 384, 'Antopal’', 'BY', 'BR'),
(8703, 20, 384, 'Asnyezhytsy', 'BY', 'BR'),
(8704, 20, 384, 'Baranovichi', 'BY', 'BR'),
(8705, 20, 384, 'Baranovichskiy Rayon', 'BY', 'BR'),
(8706, 20, 384, 'Brest', 'BY', 'BR'),
(8707, 20, 384, 'Brestski Rayon', 'BY', 'BR'),
(8708, 20, 384, 'Byaroza', 'BY', 'BR'),
(8709, 20, 384, 'Byarozawski Rayon', 'BY', 'BR'),
(8710, 20, 384, 'Byelaazyorsk', 'BY', 'BR'),
(8711, 20, 384, 'Charnawchytsy', 'BY', 'BR'),
(8712, 20, 384, 'Damachava', 'BY', 'BR'),
(8713, 20, 384, 'Davyd-Haradok', 'BY', 'BR'),
(8714, 20, 384, 'Drahichyn', 'BY', 'BR'),
(8715, 20, 384, 'Drahichynski Rayon', 'BY', 'BR'),
(8716, 20, 384, 'Hantsavichy', 'BY', 'BR'),
(8717, 20, 384, 'Hantsavitski Rayon', 'BY', 'BR'),
(8718, 20, 384, 'Haradzishcha', 'BY', 'BR'),
(8719, 20, 384, 'Horad Baranavichy', 'BY', 'BR'),
(8720, 20, 384, 'Horad Brest', 'BY', 'BR'),
(8721, 20, 384, 'Ivanava', 'BY', 'BR'),
(8722, 20, 384, 'Ivanawski Rayon', 'BY', 'BR'),
(8723, 20, 384, 'Ivatsevichy', 'BY', 'BR'),
(8724, 20, 384, 'Kamyanyets', 'BY', 'BR'),
(8725, 20, 384, 'Kamyanyetski Rayon', 'BY', 'BR'),
(8726, 20, 384, 'Kamyanyuki', 'BY', 'BR'),
(8727, 20, 384, 'Kobryn', 'BY', 'BR'),
(8728, 20, 384, 'Kosava', 'BY', 'BR'),
(8729, 20, 384, 'Lahishyn', 'BY', 'BR'),
(8730, 20, 384, 'Luninyets', 'BY', 'BR'),
(8731, 20, 384, 'Lyakhavichy', 'BY', 'BR'),
(8732, 20, 384, 'Malaryta', 'BY', 'BR'),
(8733, 20, 384, 'Mikashevichy', 'BY', 'BR'),
(8734, 20, 384, 'Motal’', 'BY', 'BR'),
(8735, 20, 384, 'Nyakhachava', 'BY', 'BR'),
(8736, 20, 384, 'Pinsk', 'BY', 'BR'),
(8737, 20, 384, 'Pruzhanski Rayon', 'BY', 'BR'),
(8738, 20, 384, 'Pruzhany', 'BY', 'BR'),
(8739, 20, 384, 'Ruzhany', 'BY', 'BR'),
(8740, 20, 384, 'Stolin', 'BY', 'BR'),
(8741, 20, 384, 'Stolinski Rayon', 'BY', 'BR'),
(8742, 20, 384, 'Tsyelyakhany', 'BY', 'BR'),
(8743, 20, 384, 'Vysokaye', 'BY', 'BR'),
(8744, 20, 384, 'Zhabinka', 'BY', 'BR'),
(8745, 20, 384, 'Zhabinkawski Rayon', 'BY', 'BR'),
(8746, 20, 384, 'Znamenka', 'BY', 'BR'),
(8747, 20, 385, 'Aktsyabrski', 'BY', 'HO'),
(8748, 20, 385, 'Brahin', 'BY', 'HO'),
(8749, 20, 385, 'Brahinski Rayon', 'BY', 'HO'),
(8750, 20, 385, 'Buda-Kashalyova', 'BY', 'HO'),
(8751, 20, 385, 'Chachersk', 'BY', 'HO'),
(8752, 20, 385, 'Chacherski Rayon', 'BY', 'HO'),
(8753, 20, 385, 'Dobrush', 'BY', 'HO'),
(8754, 20, 385, 'Dowsk', 'BY', 'HO'),
(8755, 20, 385, 'Homyel\'', 'BY', 'HO'),
(8756, 20, 385, 'Homyel’ski Rayon', 'BY', 'HO'),
(8757, 20, 385, 'Kalinkavichy', 'BY', 'HO'),
(8758, 20, 385, 'Karanyowka', 'BY', 'HO'),
(8759, 20, 385, 'Karma', 'BY', 'HO'),
(8760, 20, 385, 'Kastsyukowka', 'BY', 'HO'),
(8761, 20, 385, 'Khal’ch', 'BY', 'HO'),
(8762, 20, 385, 'Khoyniki', 'BY', 'HO'),
(8763, 20, 385, 'Loyew', 'BY', 'HO'),
(8764, 20, 385, 'Lyel’chytski Rayon', 'BY', 'HO'),
(8765, 20, 385, 'Lyel’chytsy', 'BY', 'HO'),
(8766, 20, 385, 'Mazyr', 'BY', 'HO'),
(8767, 20, 385, 'Mazyrski Rayon', 'BY', 'HO'),
(8768, 20, 385, 'Narowlya', 'BY', 'HO'),
(8769, 20, 385, 'Novaya Huta', 'BY', 'HO'),
(8770, 20, 385, 'Parychy', 'BY', 'HO'),
(8771, 20, 385, 'Peramoga', 'BY', 'HO'),
(8772, 20, 385, 'Pyetrykaw', 'BY', 'HO'),
(8773, 20, 385, 'Rahachow', 'BY', 'HO'),
(8774, 20, 385, 'Rahachowski Rayon', 'BY', 'HO'),
(8775, 20, 385, 'Rechytsa', 'BY', 'HO'),
(8776, 20, 385, 'Sasnovy Bor', 'BY', 'HO'),
(8777, 20, 385, 'Svyetlahorsk', 'BY', 'HO'),
(8778, 20, 385, 'Turaw', 'BY', 'HO'),
(8779, 20, 385, 'Vasilyevichy', 'BY', 'HO'),
(8780, 20, 385, 'Vyetka', 'BY', 'HO'),
(8781, 20, 385, 'Vyetkawski Rayon', 'BY', 'HO'),
(8782, 20, 385, 'Yel’sk', 'BY', 'HO'),
(8783, 20, 385, 'Zhlobin', 'BY', 'HO'),
(8784, 20, 385, 'Zhlobinski Rayon', 'BY', 'HO'),
(8785, 20, 385, 'Zhytkavichy', 'BY', 'HO'),
(8786, 20, 386, 'Ashmyanski Rayon', 'BY', 'HR'),
(8787, 20, 386, 'Ashmyany', 'BY', 'HR'),
(8788, 20, 386, 'Astravyets', 'BY', 'HR'),
(8789, 20, 386, 'Astravyetski Rayon', 'BY', 'HR'),
(8790, 20, 386, 'Baruny', 'BY', 'HR'),
(8791, 20, 386, 'Byarozawka', 'BY', 'HR'),
(8792, 20, 386, 'Dyatlovo', 'BY', 'HR'),
(8793, 20, 386, 'Grodnenskiy Rayon', 'BY', 'HR'),
(8794, 20, 386, 'Hal’shany', 'BY', 'HR'),
(8795, 20, 386, 'Horad Hrodna', 'BY', 'HR'),
(8796, 20, 386, 'Hrodna', 'BY', 'HR'),
(8797, 20, 386, 'Hyeranyony', 'BY', 'HR'),
(8798, 20, 386, 'Indura', 'BY', 'HR'),
(8799, 20, 386, 'Iwye', 'BY', 'HR'),
(8800, 20, 386, 'Karelichy', 'BY', 'HR'),
(8801, 20, 386, 'Karelitski Rayon', 'BY', 'HR'),
(8802, 20, 386, 'Krasnosel’skiy', 'BY', 'HR'),
(8803, 20, 386, 'Kreva', 'BY', 'HR'),
(8804, 20, 386, 'Lida', 'BY', 'HR'),
(8805, 20, 386, 'Lidski Rayon', 'BY', 'HR'),
(8806, 20, 386, 'Lyubcha', 'BY', 'HR'),
(8807, 20, 386, 'Mir', 'BY', 'HR'),
(8808, 20, 386, 'Mosty', 'BY', 'HR'),
(8809, 20, 386, 'Novogrudok', 'BY', 'HR'),
(8810, 20, 386, 'Ross’', 'BY', 'HR'),
(8811, 20, 386, 'Sapotskin', 'BY', 'HR'),
(8812, 20, 386, 'Shchuchyn', 'BY', 'HR'),
(8813, 20, 386, 'Shchuchynski Rayon', 'BY', 'HR'),
(8814, 20, 386, 'Skidel’', 'BY', 'HR'),
(8815, 20, 386, 'Slonim', 'BY', 'HR'),
(8816, 20, 386, 'Smarhon’', 'BY', 'HR'),
(8817, 20, 386, 'Soly', 'BY', 'HR'),
(8818, 20, 386, 'Svislach', 'BY', 'HR'),
(8819, 20, 386, 'Vishnyeva', 'BY', 'HR'),
(8820, 20, 386, 'Volkovysk', 'BY', 'HR'),
(8821, 20, 386, 'Voranava', 'BY', 'HR'),
(8822, 20, 386, 'Vyalikaya Byerastavitsa', 'BY', 'HR'),
(8823, 20, 386, 'Zel’va', 'BY', 'HR'),
(8824, 20, 386, 'Zhaludok', 'BY', 'HR'),
(8825, 20, 386, 'Zhirovichi', 'BY', 'HR'),
(8826, 20, 387, 'Frunzyenski Rayon', 'BY', 'HM'),
(8827, 20, 387, 'Kastrychnitski Rayon', 'BY', 'HM'),
(8828, 20, 387, 'Lyeninski Rayon', 'BY', 'HM'),
(8829, 20, 387, 'Maskowski Rayon', 'BY', 'HM'),
(8830, 20, 387, 'Minsk', 'BY', 'HM'),
(8831, 20, 387, 'Partyzanski Rayon', 'BY', 'HM'),
(8832, 20, 387, 'Savyetski Rayon', 'BY', 'HM'),
(8833, 20, 387, 'Tsentral’ny Rayon', 'BY', 'HM'),
(8834, 20, 387, 'Zavodski Rayon', 'BY', 'HM'),
(8835, 20, 388, 'Astrashytski Haradok', 'BY', 'MI'),
(8836, 20, 388, 'Atolina', 'BY', 'MI'),
(8837, 20, 388, 'Azyartso', 'BY', 'MI'),
(8838, 20, 388, 'Bal’shavik', 'BY', 'MI'),
(8839, 20, 388, 'Barysaw', 'BY', 'MI'),
(8840, 20, 388, 'Barysawski Rayon', 'BY', 'MI'),
(8841, 20, 388, 'Blon’', 'BY', 'MI'),
(8842, 20, 388, 'Bobr', 'BY', 'MI'),
(8843, 20, 388, 'Borovlyany', 'BY', 'MI'),
(8844, 20, 388, 'Byarezinski Rayon', 'BY', 'MI'),
(8845, 20, 388, 'Byerazino', 'BY', 'MI'),
(8846, 20, 388, 'Chervyen’', 'BY', 'MI'),
(8847, 20, 388, 'Chervyen’ski Rayon', 'BY', 'MI'),
(8848, 20, 388, 'Chyrvonaya Slabada', 'BY', 'MI'),
(8849, 20, 388, 'Chyst’', 'BY', 'MI'),
(8850, 20, 388, 'Druzhny', 'BY', 'MI'),
(8851, 20, 388, 'Dukora', 'BY', 'MI'),
(8852, 20, 388, 'Dzyarzhynsk', 'BY', 'MI'),
(8853, 20, 388, 'Enyerhyetykaw', 'BY', 'MI'),
(8854, 20, 388, 'Fanipol', 'BY', 'MI'),
(8855, 20, 388, 'Haradzyeya', 'BY', 'MI'),
(8856, 20, 388, 'Hatava', 'BY', 'MI'),
(8857, 20, 388, 'Horad Smalyavichy', 'BY', 'MI'),
(8858, 20, 388, 'Horad Zhodzina', 'BY', 'MI'),
(8859, 20, 388, 'Hotsk', 'BY', 'MI'),
(8860, 20, 388, 'Il’ya', 'BY', 'MI'),
(8861, 20, 388, 'Ivyanyets', 'BY', 'MI'),
(8862, 20, 388, 'Kalodzishchy', 'BY', 'MI'),
(8863, 20, 388, 'Kapyl’', 'BY', 'MI'),
(8864, 20, 388, 'Kapyl’ski Rayon', 'BY', 'MI'),
(8865, 20, 388, 'Khatsyezhyna', 'BY', 'MI'),
(8866, 20, 388, 'Kholopenichi', 'BY', 'MI'),
(8867, 20, 388, 'Klyetsk', 'BY', 'MI'),
(8868, 20, 388, 'Klyetski Rayon', 'BY', 'MI'),
(8869, 20, 388, 'Korolëv Stan', 'BY', 'MI'),
(8870, 20, 388, 'Krasnaye', 'BY', 'MI'),
(8871, 20, 388, 'Krupki', 'BY', 'MI'),
(8872, 20, 388, 'Kryvichy', 'BY', 'MI'),
(8873, 20, 388, 'Lahoysk', 'BY', 'MI'),
(8874, 20, 388, 'Loshnitsa', 'BY', 'MI'),
(8875, 20, 388, 'Luhavaya Slabada', 'BY', 'MI'),
(8876, 20, 388, 'Lyasny', 'BY', 'MI'),
(8877, 20, 388, 'Lyeskawka', 'BY', 'MI'),
(8878, 20, 388, 'Lyuban’', 'BY', 'MI'),
(8879, 20, 388, 'Machulishchy', 'BY', 'MI'),
(8880, 20, 388, 'Maladzyechna', 'BY', 'MI'),
(8881, 20, 388, 'Mar’’ina Horka', 'BY', 'MI'),
(8882, 20, 388, 'Michanovichi', 'BY', 'MI'),
(8883, 20, 388, 'Myadzyel', 'BY', 'MI'),
(8884, 20, 388, 'Myadzyel’ski Rayon', 'BY', 'MI'),
(8885, 20, 388, 'Narach', 'BY', 'MI'),
(8886, 20, 388, 'Nasilava', 'BY', 'MI'),
(8887, 20, 388, 'Novosel’ye', 'BY', 'MI'),
(8888, 20, 388, 'Novy Svyerzhan’', 'BY', 'MI'),
(8889, 20, 388, 'Nyasvizh', 'BY', 'MI'),
(8890, 20, 388, 'Nyasvizhski Rayon', 'BY', 'MI'),
(8891, 20, 388, 'Plyeshchanitsy', 'BY', 'MI'),
(8892, 20, 388, 'Prawdzinski', 'BY', 'MI'),
(8893, 20, 388, 'Pryvol’ny', 'BY', 'MI'),
(8894, 20, 388, 'Pukhavichy', 'BY', 'MI'),
(8895, 20, 388, 'Pukhavichy Raion', 'BY', 'MI'),
(8896, 20, 388, 'Pyatryshki', 'BY', 'MI'),
(8897, 20, 388, 'Radashkovichy', 'BY', 'MI'),
(8898, 20, 388, 'Rakaw', 'BY', 'MI'),
(8899, 20, 388, 'Rudzyensk', 'BY', 'MI'),
(8900, 20, 388, 'Salihorsk', 'BY', 'MI'),
(8901, 20, 388, 'Samakhvalavichy', 'BY', 'MI'),
(8902, 20, 388, 'Sarachy', 'BY', 'MI'),
(8903, 20, 388, 'Schomyslitsa', 'BY', 'MI'),
(8904, 20, 388, 'Slabada', 'BY', 'MI'),
(8905, 20, 388, 'Slutsk', 'BY', 'MI'),
(8906, 20, 388, 'Slutski Rayon', 'BY', 'MI'),
(8907, 20, 388, 'Smalyavitski Rayon', 'BY', 'MI'),
(8908, 20, 388, 'Smilavichy', 'BY', 'MI'),
(8909, 20, 388, 'Snow', 'BY', 'MI'),
(8910, 20, 388, 'Stan’kava', 'BY', 'MI'),
(8911, 20, 388, 'Staradarozhski Rayon', 'BY', 'MI'),
(8912, 20, 388, 'Starobin', 'BY', 'MI'),
(8913, 20, 388, 'Staryya Darohi', 'BY', 'MI'),
(8914, 20, 388, 'Stawbtsowski Rayon', 'BY', 'MI'),
(8915, 20, 388, 'Stowbtsy', 'BY', 'MI'),
(8916, 20, 388, 'Svir', 'BY', 'MI'),
(8917, 20, 388, 'Svislach', 'BY', 'MI'),
(8918, 20, 388, 'Syenitsa', 'BY', 'MI'),
(8919, 20, 388, 'Syomkava', 'BY', 'MI'),
(8920, 20, 388, 'Tsimkavichy', 'BY', 'MI'),
(8921, 20, 388, 'Turets-Bayary', 'BY', 'MI'),
(8922, 20, 388, 'Urechcha', 'BY', 'MI'),
(8923, 20, 388, 'Usiazh', 'BY', 'MI'),
(8924, 20, 388, 'Uzda', 'BY', 'MI'),
(8925, 20, 388, 'Uzdzyenski Rayon', 'BY', 'MI'),
(8926, 20, 388, 'Valozhyn', 'BY', 'MI'),
(8927, 20, 388, 'Vilyeyka', 'BY', 'MI'),
(8928, 20, 388, 'Vilyeyski Rayon', 'BY', 'MI'),
(8929, 20, 388, 'Vyaliki Trastsyanets', 'BY', 'MI'),
(8930, 20, 388, 'Yubilyeyny', 'BY', 'MI'),
(8931, 20, 388, 'Zamostochye', 'BY', 'MI'),
(8932, 20, 388, 'Zaslawye', 'BY', 'MI'),
(8933, 20, 388, 'Zhdanovichy', 'BY', 'MI'),
(8934, 20, 388, 'Zyembin', 'BY', 'MI'),
(8935, 20, 388, 'Октябрьский', 'BY', 'MI'),
(8936, 20, 389, 'Asipovichy', 'BY', 'MA'),
(8937, 20, 389, 'Asipovitski Rayon', 'BY', 'MA'),
(8938, 20, 389, 'Babruysk', 'BY', 'MA'),
(8939, 20, 389, 'Babruyski Rayon', 'BY', 'MA'),
(8940, 20, 389, 'Buynichy', 'BY', 'MA'),
(8941, 20, 389, 'Byalynichy', 'BY', 'MA'),
(8942, 20, 389, 'Byalynitski Rayon', 'BY', 'MA'),
(8943, 20, 389, 'Bykhaw', 'BY', 'MA'),
(8944, 20, 389, 'Chavuski Rayon', 'BY', 'MA'),
(8945, 20, 389, 'Chavusy', 'BY', 'MA'),
(8946, 20, 389, 'Cherykaw', 'BY', 'MA'),
(8947, 20, 389, 'Cherykawski Rayon', 'BY', 'MA'),
(8948, 20, 389, 'Dashkawka', 'BY', 'MA'),
(8949, 20, 389, 'Drybin', 'BY', 'MA'),
(8950, 20, 389, 'Drybinski Rayon', 'BY', 'MA'),
(8951, 20, 389, 'Hlusha', 'BY', 'MA'),
(8952, 20, 389, 'Hlusk', 'BY', 'MA'),
(8953, 20, 389, 'Horatski Rayon', 'BY', 'MA'),
(8954, 20, 389, 'Horki', 'BY', 'MA'),
(8955, 20, 389, 'Kadino', 'BY', 'MA'),
(8956, 20, 389, 'Kamyennyya Lavy', 'BY', 'MA'),
(8957, 20, 389, 'Kastsyukovichy', 'BY', 'MA'),
(8958, 20, 389, 'Khodasy', 'BY', 'MA'),
(8959, 20, 389, 'Khotsimsk', 'BY', 'MA'),
(8960, 20, 389, 'Khotsimski Rayon', 'BY', 'MA'),
(8961, 20, 389, 'Kirawsk', 'BY', 'MA'),
(8962, 20, 389, 'Klichaw', 'BY', 'MA'),
(8963, 20, 389, 'Klimavichy', 'BY', 'MA'),
(8964, 20, 389, 'Krasnapol’ski Rayon', 'BY', 'MA'),
(8965, 20, 389, 'Krasnapollye', 'BY', 'MA'),
(8966, 20, 389, 'Krasnyy Bereg', 'BY', 'MA'),
(8967, 20, 389, 'Kruhlaye', 'BY', 'MA'),
(8968, 20, 389, 'Krychaw', 'BY', 'MA'),
(8969, 20, 389, 'Mahilyow', 'BY', 'MA'),
(8970, 20, 389, 'Mahilyowski Rayon', 'BY', 'MA'),
(8971, 20, 389, 'Mstsislaw', 'BY', 'MA'),
(8972, 20, 389, 'Myazhysyatki', 'BY', 'MA'),
(8973, 20, 389, 'Myshkavichy', 'BY', 'MA'),
(8974, 20, 389, 'Palykavichy Pyershyya', 'BY', 'MA'),
(8975, 20, 389, 'Posëlok Voskhod', 'BY', 'MA'),
(8976, 20, 389, 'Ramanavichy', 'BY', 'MA'),
(8977, 20, 389, 'Shklow', 'BY', 'MA'),
(8978, 20, 389, 'Shklowski Rayon', 'BY', 'MA'),
(8979, 20, 389, 'Slawharad', 'BY', 'MA'),
(8980, 20, 389, 'Veyno', 'BY', 'MA'),
(8981, 20, 389, 'Vishow', 'BY', 'MA'),
(8982, 20, 389, 'Yalizava', 'BY', 'MA'),
(8983, 20, 390, 'Balbasava', 'BY', 'VI'),
(8984, 20, 390, 'Baran’', 'BY', 'VI'),
(8985, 20, 390, 'Braslaw', 'BY', 'VI'),
(8986, 20, 390, 'Braslawski Rayon', 'BY', 'VI'),
(8987, 20, 390, 'Byahoml’', 'BY', 'VI'),
(8988, 20, 390, 'Byeshankovitski Rayon', 'BY', 'VI'),
(8989, 20, 390, 'Chashniki', 'BY', 'VI'),
(8990, 20, 390, 'Chashnitski Rayon', 'BY', 'VI'),
(8991, 20, 390, 'Dokshytski Rayon', 'BY', 'VI'),
(8992, 20, 390, 'Dokshytsy', 'BY', 'VI'),
(8993, 20, 390, 'Druya', 'BY', 'VI'),
(8994, 20, 390, 'Dubrowna', 'BY', 'VI'),
(8995, 20, 390, 'Dzisna', 'BY', 'VI'),
(8996, 20, 390, 'Haradok', 'BY', 'VI'),
(8997, 20, 390, 'Haradotski Rayon', 'BY', 'VI'),
(8998, 20, 390, 'Hlybokaye', 'BY', 'VI'),
(8999, 20, 390, 'Hlybotski Rayon', 'BY', 'VI'),
(9000, 20, 390, 'Kokhanava', 'BY', 'VI');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(9001, 20, 390, 'Konstantinovo', 'BY', 'VI'),
(9002, 20, 390, 'Lyepyel’', 'BY', 'VI'),
(9003, 20, 390, 'Lyepyel’ski Rayon', 'BY', 'VI'),
(9004, 20, 390, 'Lyntupy', 'BY', 'VI'),
(9005, 20, 390, 'Lyozna', 'BY', 'VI'),
(9006, 20, 390, 'Lyoznyenski Rayon', 'BY', 'VI'),
(9007, 20, 390, 'Mosar', 'BY', 'VI'),
(9008, 20, 390, 'Myorski Rayon', 'BY', 'VI'),
(9009, 20, 390, 'Myory', 'BY', 'VI'),
(9010, 20, 390, 'Navapolatsk', 'BY', 'VI'),
(9011, 20, 390, 'Novolukoml’', 'BY', 'VI'),
(9012, 20, 390, 'Orsha', 'BY', 'VI'),
(9013, 20, 390, 'Osveya', 'BY', 'VI'),
(9014, 20, 390, 'Pastavy', 'BY', 'VI'),
(9015, 20, 390, 'Pastawski Rayon', 'BY', 'VI'),
(9016, 20, 390, 'Polatsk', 'BY', 'VI'),
(9017, 20, 390, 'Polatski Rayon', 'BY', 'VI'),
(9018, 20, 390, 'Rasonski Rayon', 'BY', 'VI'),
(9019, 20, 390, 'Rasony', 'BY', 'VI'),
(9020, 20, 390, 'Sharkawshchyna', 'BY', 'VI'),
(9021, 20, 390, 'Sharkawshchynski Rayon', 'BY', 'VI'),
(9022, 20, 390, 'Shumilinski Rayon', 'BY', 'VI'),
(9023, 20, 390, 'Syanno', 'BY', 'VI'),
(9024, 20, 390, 'Syennyenski Rayon', 'BY', 'VI'),
(9025, 20, 390, 'Talachyn', 'BY', 'VI'),
(9026, 20, 390, 'Ushachy', 'BY', 'VI'),
(9027, 20, 390, 'Vidzy', 'BY', 'VI'),
(9028, 20, 390, 'Vitebsk', 'BY', 'VI'),
(9029, 20, 390, 'Vyerkhnyadzvinsk', 'BY', 'VI'),
(9030, 20, 390, 'Vyerkhnyadzvinski Rayon', 'BY', 'VI'),
(9031, 21, 392, 'Brussels', 'BE', 'BRU'),
(9032, 21, 394, 'Aalst', 'BE', 'VLG'),
(9033, 21, 394, 'Aalter', 'BE', 'VLG'),
(9034, 21, 394, 'Aarschot', 'BE', 'VLG'),
(9035, 21, 394, 'Aartselaar', 'BE', 'VLG'),
(9036, 21, 394, 'Alken', 'BE', 'VLG'),
(9037, 21, 394, 'Alveringem', 'BE', 'VLG'),
(9038, 21, 394, 'Antwerpen', 'BE', 'VLG'),
(9039, 21, 394, 'Anzegem', 'BE', 'VLG'),
(9040, 21, 394, 'Ardooie', 'BE', 'VLG'),
(9041, 21, 394, 'Arendonk', 'BE', 'VLG'),
(9042, 21, 394, 'As', 'BE', 'VLG'),
(9043, 21, 394, 'Asse', 'BE', 'VLG'),
(9044, 21, 394, 'Assenede', 'BE', 'VLG'),
(9045, 21, 394, 'Avelgem', 'BE', 'VLG'),
(9046, 21, 394, 'Baarle-Hertog', 'BE', 'VLG'),
(9047, 21, 394, 'Balen', 'BE', 'VLG'),
(9048, 21, 394, 'Beernem', 'BE', 'VLG'),
(9049, 21, 394, 'Beerse', 'BE', 'VLG'),
(9050, 21, 394, 'Beersel', 'BE', 'VLG'),
(9051, 21, 394, 'Begijnendijk', 'BE', 'VLG'),
(9052, 21, 394, 'Bekkevoort', 'BE', 'VLG'),
(9053, 21, 394, 'Beringen', 'BE', 'VLG'),
(9054, 21, 394, 'Berlaar', 'BE', 'VLG'),
(9055, 21, 394, 'Berlare', 'BE', 'VLG'),
(9056, 21, 394, 'Bertem', 'BE', 'VLG'),
(9057, 21, 394, 'Bever', 'BE', 'VLG'),
(9058, 21, 394, 'Beveren', 'BE', 'VLG'),
(9059, 21, 394, 'Bierbeek', 'BE', 'VLG'),
(9060, 21, 394, 'Bilzen', 'BE', 'VLG'),
(9061, 21, 394, 'Blankenberge', 'BE', 'VLG'),
(9062, 21, 394, 'Bocholt', 'BE', 'VLG'),
(9063, 21, 394, 'Boechout', 'BE', 'VLG'),
(9064, 21, 394, 'Bonheiden', 'BE', 'VLG'),
(9065, 21, 394, 'Boom', 'BE', 'VLG'),
(9066, 21, 394, 'Boortmeerbeek', 'BE', 'VLG'),
(9067, 21, 394, 'Borgloon', 'BE', 'VLG'),
(9068, 21, 394, 'Bornem', 'BE', 'VLG'),
(9069, 21, 394, 'Borsbeek', 'BE', 'VLG'),
(9070, 21, 394, 'Boutersem', 'BE', 'VLG'),
(9071, 21, 394, 'Brasschaat', 'BE', 'VLG'),
(9072, 21, 394, 'Brecht', 'BE', 'VLG'),
(9073, 21, 394, 'Bredene', 'BE', 'VLG'),
(9074, 21, 394, 'Bree', 'BE', 'VLG'),
(9075, 21, 394, 'Brugge', 'BE', 'VLG'),
(9076, 21, 394, 'Buggenhout', 'BE', 'VLG'),
(9077, 21, 394, 'Damme', 'BE', 'VLG'),
(9078, 21, 394, 'De Haan', 'BE', 'VLG'),
(9079, 21, 394, 'De Panne', 'BE', 'VLG'),
(9080, 21, 394, 'De Pinte', 'BE', 'VLG'),
(9081, 21, 394, 'Deerlijk', 'BE', 'VLG'),
(9082, 21, 394, 'Deinze', 'BE', 'VLG'),
(9083, 21, 394, 'Denderleeuw', 'BE', 'VLG'),
(9084, 21, 394, 'Dendermonde', 'BE', 'VLG'),
(9085, 21, 394, 'Dentergem', 'BE', 'VLG'),
(9086, 21, 394, 'Dessel', 'BE', 'VLG'),
(9087, 21, 394, 'Destelbergen', 'BE', 'VLG'),
(9088, 21, 394, 'Deurne', 'BE', 'VLG'),
(9089, 21, 394, 'Diegem', 'BE', 'VLG'),
(9090, 21, 394, 'Diepenbeek', 'BE', 'VLG'),
(9091, 21, 394, 'Diest', 'BE', 'VLG'),
(9092, 21, 394, 'Diksmuide', 'BE', 'VLG'),
(9093, 21, 394, 'Dilbeek', 'BE', 'VLG'),
(9094, 21, 394, 'Drogenbos', 'BE', 'VLG'),
(9095, 21, 394, 'Duffel', 'BE', 'VLG'),
(9096, 21, 394, 'Edegem', 'BE', 'VLG'),
(9097, 21, 394, 'Eeklo', 'BE', 'VLG'),
(9098, 21, 394, 'Essen', 'BE', 'VLG'),
(9099, 21, 394, 'Evergem', 'BE', 'VLG'),
(9100, 21, 394, 'Galmaarden', 'BE', 'VLG'),
(9101, 21, 394, 'Gavere', 'BE', 'VLG'),
(9102, 21, 394, 'Geel', 'BE', 'VLG'),
(9103, 21, 394, 'Geetbets', 'BE', 'VLG'),
(9104, 21, 394, 'Genk', 'BE', 'VLG'),
(9105, 21, 394, 'Gent', 'BE', 'VLG'),
(9106, 21, 394, 'Geraardsbergen', 'BE', 'VLG'),
(9107, 21, 394, 'Gingelom', 'BE', 'VLG'),
(9108, 21, 394, 'Gistel', 'BE', 'VLG'),
(9109, 21, 394, 'Glabbeek', 'BE', 'VLG'),
(9110, 21, 394, 'Gooik', 'BE', 'VLG'),
(9111, 21, 394, 'Grimbergen', 'BE', 'VLG'),
(9112, 21, 394, 'Grobbendonk', 'BE', 'VLG'),
(9113, 21, 394, 'Haacht', 'BE', 'VLG'),
(9114, 21, 394, 'Haaltert', 'BE', 'VLG'),
(9115, 21, 394, 'Halen', 'BE', 'VLG'),
(9116, 21, 394, 'Halle', 'BE', 'VLG'),
(9117, 21, 394, 'Hamme', 'BE', 'VLG'),
(9118, 21, 394, 'Harelbeke', 'BE', 'VLG'),
(9119, 21, 394, 'Hasselt', 'BE', 'VLG'),
(9120, 21, 394, 'Heers', 'BE', 'VLG'),
(9121, 21, 394, 'Heist-op-den-Berg', 'BE', 'VLG'),
(9122, 21, 394, 'Helchteren', 'BE', 'VLG'),
(9123, 21, 394, 'Hemiksem', 'BE', 'VLG'),
(9124, 21, 394, 'Herent', 'BE', 'VLG'),
(9125, 21, 394, 'Herentals', 'BE', 'VLG'),
(9126, 21, 394, 'Herenthout', 'BE', 'VLG'),
(9127, 21, 394, 'Herk-de-Stad', 'BE', 'VLG'),
(9128, 21, 394, 'Herne', 'BE', 'VLG'),
(9129, 21, 394, 'Herselt', 'BE', 'VLG'),
(9130, 21, 394, 'Herzele', 'BE', 'VLG'),
(9131, 21, 394, 'Heusden', 'BE', 'VLG'),
(9132, 21, 394, 'Hoboken', 'BE', 'VLG'),
(9133, 21, 394, 'Hoegaarden', 'BE', 'VLG'),
(9134, 21, 394, 'Hoeilaart', 'BE', 'VLG'),
(9135, 21, 394, 'Hoeselt', 'BE', 'VLG'),
(9136, 21, 394, 'Holsbeek', 'BE', 'VLG'),
(9137, 21, 394, 'Hooglede', 'BE', 'VLG'),
(9138, 21, 394, 'Hoogstraten', 'BE', 'VLG'),
(9139, 21, 394, 'Houthalen', 'BE', 'VLG'),
(9140, 21, 394, 'Houthulst', 'BE', 'VLG'),
(9141, 21, 394, 'Hove', 'BE', 'VLG'),
(9142, 21, 394, 'Huldenberg', 'BE', 'VLG'),
(9143, 21, 394, 'Hulshout', 'BE', 'VLG'),
(9144, 21, 394, 'Ichtegem', 'BE', 'VLG'),
(9145, 21, 394, 'Ieper', 'BE', 'VLG'),
(9146, 21, 394, 'Ingelmunster', 'BE', 'VLG'),
(9147, 21, 394, 'Izegem', 'BE', 'VLG'),
(9148, 21, 394, 'Jabbeke', 'BE', 'VLG'),
(9149, 21, 394, 'Kalmthout', 'BE', 'VLG'),
(9150, 21, 394, 'Kampenhout', 'BE', 'VLG'),
(9151, 21, 394, 'Kapelle-op-den-Bos', 'BE', 'VLG'),
(9152, 21, 394, 'Kapellen', 'BE', 'VLG'),
(9153, 21, 394, 'Kaprijke', 'BE', 'VLG'),
(9154, 21, 394, 'Kasterlee', 'BE', 'VLG'),
(9155, 21, 394, 'Keerbergen', 'BE', 'VLG'),
(9156, 21, 394, 'Kinrooi', 'BE', 'VLG'),
(9157, 21, 394, 'Knesselare', 'BE', 'VLG'),
(9158, 21, 394, 'Knokke-Heist', 'BE', 'VLG'),
(9159, 21, 394, 'Koekelare', 'BE', 'VLG'),
(9160, 21, 394, 'Koksijde', 'BE', 'VLG'),
(9161, 21, 394, 'Kontich', 'BE', 'VLG'),
(9162, 21, 394, 'Kortemark', 'BE', 'VLG'),
(9163, 21, 394, 'Kortenaken', 'BE', 'VLG'),
(9164, 21, 394, 'Kortenberg', 'BE', 'VLG'),
(9165, 21, 394, 'Kortessem', 'BE', 'VLG'),
(9166, 21, 394, 'Kortrijk', 'BE', 'VLG'),
(9167, 21, 394, 'Kraainem', 'BE', 'VLG'),
(9168, 21, 394, 'Kruibeke', 'BE', 'VLG'),
(9169, 21, 394, 'Kruishoutem', 'BE', 'VLG'),
(9170, 21, 394, 'Kuurne', 'BE', 'VLG'),
(9171, 21, 394, 'Laarne', 'BE', 'VLG'),
(9172, 21, 394, 'Lanaken', 'BE', 'VLG'),
(9173, 21, 394, 'Landen', 'BE', 'VLG'),
(9174, 21, 394, 'Lebbeke', 'BE', 'VLG'),
(9175, 21, 394, 'Lede', 'BE', 'VLG'),
(9176, 21, 394, 'Ledeberg', 'BE', 'VLG'),
(9177, 21, 394, 'Ledegem', 'BE', 'VLG'),
(9178, 21, 394, 'Lendelede', 'BE', 'VLG'),
(9179, 21, 394, 'Leopoldsburg', 'BE', 'VLG'),
(9180, 21, 394, 'Leuven', 'BE', 'VLG'),
(9181, 21, 394, 'Lichtervelde', 'BE', 'VLG'),
(9182, 21, 394, 'Liedekerke', 'BE', 'VLG'),
(9183, 21, 394, 'Lier', 'BE', 'VLG'),
(9184, 21, 394, 'Lille', 'BE', 'VLG'),
(9185, 21, 394, 'Linkebeek', 'BE', 'VLG'),
(9186, 21, 394, 'Lint', 'BE', 'VLG'),
(9187, 21, 394, 'Lochristi', 'BE', 'VLG'),
(9188, 21, 394, 'Lokeren', 'BE', 'VLG'),
(9189, 21, 394, 'Lommel', 'BE', 'VLG'),
(9190, 21, 394, 'Londerzeel', 'BE', 'VLG'),
(9191, 21, 394, 'Lovendegem', 'BE', 'VLG'),
(9192, 21, 394, 'Lubbeek', 'BE', 'VLG'),
(9193, 21, 394, 'Lummen', 'BE', 'VLG'),
(9194, 21, 394, 'Maaseik', 'BE', 'VLG'),
(9195, 21, 394, 'Maasmechelen', 'BE', 'VLG'),
(9196, 21, 394, 'Machelen', 'BE', 'VLG'),
(9197, 21, 394, 'Maldegem', 'BE', 'VLG'),
(9198, 21, 394, 'Mechelen', 'BE', 'VLG'),
(9199, 21, 394, 'Meerhout', 'BE', 'VLG'),
(9200, 21, 394, 'Meise', 'BE', 'VLG'),
(9201, 21, 394, 'Melle', 'BE', 'VLG'),
(9202, 21, 394, 'Menen', 'BE', 'VLG'),
(9203, 21, 394, 'Merchtem', 'BE', 'VLG'),
(9204, 21, 394, 'Merelbeke', 'BE', 'VLG'),
(9205, 21, 394, 'Merksplas', 'BE', 'VLG'),
(9206, 21, 394, 'Meulebeke', 'BE', 'VLG'),
(9207, 21, 394, 'Middelkerke', 'BE', 'VLG'),
(9208, 21, 394, 'Moerbeke', 'BE', 'VLG'),
(9209, 21, 394, 'Mol', 'BE', 'VLG'),
(9210, 21, 394, 'Moorslede', 'BE', 'VLG'),
(9211, 21, 394, 'Mortsel', 'BE', 'VLG'),
(9212, 21, 394, 'Nazareth', 'BE', 'VLG'),
(9213, 21, 394, 'Neerpelt', 'BE', 'VLG'),
(9214, 21, 394, 'Nevele', 'BE', 'VLG'),
(9215, 21, 394, 'Niel', 'BE', 'VLG'),
(9216, 21, 394, 'Nieuwerkerken', 'BE', 'VLG'),
(9217, 21, 394, 'Nieuwpoort', 'BE', 'VLG'),
(9218, 21, 394, 'Nijlen', 'BE', 'VLG'),
(9219, 21, 394, 'Ninove', 'BE', 'VLG'),
(9220, 21, 394, 'Olen', 'BE', 'VLG'),
(9221, 21, 394, 'Oostduinkerke', 'BE', 'VLG'),
(9222, 21, 394, 'Oosterzele', 'BE', 'VLG'),
(9223, 21, 394, 'Oostkamp', 'BE', 'VLG'),
(9224, 21, 394, 'Oostmalle', 'BE', 'VLG'),
(9225, 21, 394, 'Oostrozebeke', 'BE', 'VLG'),
(9226, 21, 394, 'Opglabbeek', 'BE', 'VLG'),
(9227, 21, 394, 'Opwijk', 'BE', 'VLG'),
(9228, 21, 394, 'Ostend', 'BE', 'VLG'),
(9229, 21, 394, 'Oud-Heverlee', 'BE', 'VLG'),
(9230, 21, 394, 'Oud-Turnhout', 'BE', 'VLG'),
(9231, 21, 394, 'Oudenaarde', 'BE', 'VLG'),
(9232, 21, 394, 'Oudenburg', 'BE', 'VLG'),
(9233, 21, 394, 'Overijse', 'BE', 'VLG'),
(9234, 21, 394, 'Overpelt', 'BE', 'VLG'),
(9235, 21, 394, 'Peer', 'BE', 'VLG'),
(9236, 21, 394, 'Pepingen', 'BE', 'VLG'),
(9237, 21, 394, 'Perre', 'BE', 'VLG'),
(9238, 21, 394, 'Pittem', 'BE', 'VLG'),
(9239, 21, 394, 'Poperinge', 'BE', 'VLG'),
(9240, 21, 394, 'Provincie Antwerpen', 'BE', 'VLG'),
(9241, 21, 394, 'Provincie Limburg', 'BE', 'VLG'),
(9242, 21, 394, 'Provincie Oost-Vlaanderen', 'BE', 'VLG'),
(9243, 21, 394, 'Provincie Vlaams-Brabant', 'BE', 'VLG'),
(9244, 21, 394, 'Provincie West-Vlaanderen', 'BE', 'VLG'),
(9245, 21, 394, 'Putte', 'BE', 'VLG'),
(9246, 21, 394, 'Puurs', 'BE', 'VLG'),
(9247, 21, 394, 'Ranst', 'BE', 'VLG'),
(9248, 21, 394, 'Ravels', 'BE', 'VLG'),
(9249, 21, 394, 'Retie', 'BE', 'VLG'),
(9250, 21, 394, 'Riemst', 'BE', 'VLG'),
(9251, 21, 394, 'Rijkevorsel', 'BE', 'VLG'),
(9252, 21, 394, 'Roeselare', 'BE', 'VLG'),
(9253, 21, 394, 'Ronse', 'BE', 'VLG'),
(9254, 21, 394, 'Rotselaar', 'BE', 'VLG'),
(9255, 21, 394, 'Ruiselede', 'BE', 'VLG'),
(9256, 21, 394, 'Rumst', 'BE', 'VLG'),
(9257, 21, 394, 'Schelle', 'BE', 'VLG'),
(9258, 21, 394, 'Schilde', 'BE', 'VLG'),
(9259, 21, 394, 'Schoten', 'BE', 'VLG'),
(9260, 21, 394, 'Sint-Amands', 'BE', 'VLG'),
(9261, 21, 394, 'Sint-Genesius-Rode', 'BE', 'VLG'),
(9262, 21, 394, 'Sint-Gillis-Waas', 'BE', 'VLG'),
(9263, 21, 394, 'Sint-Joris', 'BE', 'VLG'),
(9264, 21, 394, 'Sint-Katelijne-Waver', 'BE', 'VLG'),
(9265, 21, 394, 'Sint-Kruis', 'BE', 'VLG'),
(9266, 21, 394, 'Sint-Laureins', 'BE', 'VLG'),
(9267, 21, 394, 'Sint-Lievens-Houtem', 'BE', 'VLG'),
(9268, 21, 394, 'Sint-Maria-Lierde', 'BE', 'VLG'),
(9269, 21, 394, 'Sint-Martens-Latem', 'BE', 'VLG'),
(9270, 21, 394, 'Sint-Martens-Lennik', 'BE', 'VLG'),
(9271, 21, 394, 'Sint-Niklaas', 'BE', 'VLG'),
(9272, 21, 394, 'Sint-Pieters-Leeuw', 'BE', 'VLG'),
(9273, 21, 394, 'Sint-Pieters-Voeren', 'BE', 'VLG'),
(9274, 21, 394, 'Sint-Truiden', 'BE', 'VLG'),
(9275, 21, 394, 'Stabroek', 'BE', 'VLG'),
(9276, 21, 394, 'Staden', 'BE', 'VLG'),
(9277, 21, 394, 'Steenokkerzeel', 'BE', 'VLG'),
(9278, 21, 394, 'Stekene', 'BE', 'VLG'),
(9279, 21, 394, 'Temse', 'BE', 'VLG'),
(9280, 21, 394, 'Terkoest', 'BE', 'VLG'),
(9281, 21, 394, 'Ternat', 'BE', 'VLG'),
(9282, 21, 394, 'Tervuren', 'BE', 'VLG'),
(9283, 21, 394, 'Tessenderlo', 'BE', 'VLG'),
(9284, 21, 394, 'Tielt', 'BE', 'VLG'),
(9285, 21, 394, 'Tienen', 'BE', 'VLG'),
(9286, 21, 394, 'Tongeren', 'BE', 'VLG'),
(9287, 21, 394, 'Torhout', 'BE', 'VLG'),
(9288, 21, 394, 'Tremelo', 'BE', 'VLG'),
(9289, 21, 394, 'Turnhout', 'BE', 'VLG'),
(9290, 21, 394, 'Veurne', 'BE', 'VLG'),
(9291, 21, 394, 'Vilvoorde', 'BE', 'VLG'),
(9292, 21, 394, 'Vorselaar', 'BE', 'VLG'),
(9293, 21, 394, 'Vosselaar', 'BE', 'VLG'),
(9294, 21, 394, 'Waarschoot', 'BE', 'VLG'),
(9295, 21, 394, 'Waasmunster', 'BE', 'VLG'),
(9296, 21, 394, 'Wachtebeke', 'BE', 'VLG'),
(9297, 21, 394, 'Waregem', 'BE', 'VLG'),
(9298, 21, 394, 'Wellen', 'BE', 'VLG'),
(9299, 21, 394, 'Wemmel', 'BE', 'VLG'),
(9300, 21, 394, 'Wenduine', 'BE', 'VLG'),
(9301, 21, 394, 'Wervik', 'BE', 'VLG'),
(9302, 21, 394, 'Westerlo', 'BE', 'VLG'),
(9303, 21, 394, 'Wetteren', 'BE', 'VLG'),
(9304, 21, 394, 'Wevelgem', 'BE', 'VLG'),
(9305, 21, 394, 'Wezembeek-Oppem', 'BE', 'VLG'),
(9306, 21, 394, 'Wichelen', 'BE', 'VLG'),
(9307, 21, 394, 'Wielsbeke', 'BE', 'VLG'),
(9308, 21, 394, 'Wijnegem', 'BE', 'VLG'),
(9309, 21, 394, 'Willebroek', 'BE', 'VLG'),
(9310, 21, 394, 'Wingene', 'BE', 'VLG'),
(9311, 21, 394, 'Wommelgem', 'BE', 'VLG'),
(9312, 21, 394, 'Wuustwezel', 'BE', 'VLG'),
(9313, 21, 394, 'Zandhoven', 'BE', 'VLG'),
(9314, 21, 394, 'Zaventem', 'BE', 'VLG'),
(9315, 21, 394, 'Zedelgem', 'BE', 'VLG'),
(9316, 21, 394, 'Zeebrugge', 'BE', 'VLG'),
(9317, 21, 394, 'Zele', 'BE', 'VLG'),
(9318, 21, 394, 'Zelzate', 'BE', 'VLG'),
(9319, 21, 394, 'Zemst', 'BE', 'VLG'),
(9320, 21, 394, 'Zingem', 'BE', 'VLG'),
(9321, 21, 394, 'Zoersel', 'BE', 'VLG'),
(9322, 21, 394, 'Zomergem', 'BE', 'VLG'),
(9323, 21, 394, 'Zonhoven', 'BE', 'VLG'),
(9324, 21, 394, 'Zonnebeke', 'BE', 'VLG'),
(9325, 21, 394, 'Zottegem', 'BE', 'VLG'),
(9326, 21, 394, 'Zoutleeuw', 'BE', 'VLG'),
(9327, 21, 394, 'Zuienkerke', 'BE', 'VLG'),
(9328, 21, 394, 'Zulte', 'BE', 'VLG'),
(9329, 21, 394, 'Zutendaal', 'BE', 'VLG'),
(9330, 21, 394, 'Zwevegem', 'BE', 'VLG'),
(9331, 21, 394, 'Zwijndrecht', 'BE', 'VLG'),
(9332, 21, 401, 'Aiseau', 'BE', 'WAL'),
(9333, 21, 401, 'Amay', 'BE', 'WAL'),
(9334, 21, 401, 'Amblève', 'BE', 'WAL'),
(9335, 21, 401, 'Andenne', 'BE', 'WAL'),
(9336, 21, 401, 'Anderlues', 'BE', 'WAL'),
(9337, 21, 401, 'Anhée', 'BE', 'WAL'),
(9338, 21, 401, 'Ans', 'BE', 'WAL'),
(9339, 21, 401, 'Anthisnes', 'BE', 'WAL'),
(9340, 21, 401, 'Antoing', 'BE', 'WAL'),
(9341, 21, 401, 'Arlon', 'BE', 'WAL'),
(9342, 21, 401, 'Assesse', 'BE', 'WAL'),
(9343, 21, 401, 'Ath', 'BE', 'WAL'),
(9344, 21, 401, 'Attert', 'BE', 'WAL'),
(9345, 21, 401, 'Aubange', 'BE', 'WAL'),
(9346, 21, 401, 'Aubel', 'BE', 'WAL'),
(9347, 21, 401, 'Awans', 'BE', 'WAL'),
(9348, 21, 401, 'Aywaille', 'BE', 'WAL'),
(9349, 21, 401, 'Baelen', 'BE', 'WAL'),
(9350, 21, 401, 'Basse Lasne', 'BE', 'WAL'),
(9351, 21, 401, 'Bassenge', 'BE', 'WAL'),
(9352, 21, 401, 'Bastogne', 'BE', 'WAL'),
(9353, 21, 401, 'Beaumont', 'BE', 'WAL'),
(9354, 21, 401, 'Beauraing', 'BE', 'WAL'),
(9355, 21, 401, 'Beauvechain', 'BE', 'WAL'),
(9356, 21, 401, 'Beloeil', 'BE', 'WAL'),
(9357, 21, 401, 'Berloz', 'BE', 'WAL'),
(9358, 21, 401, 'Bernissart', 'BE', 'WAL'),
(9359, 21, 401, 'Bertogne', 'BE', 'WAL'),
(9360, 21, 401, 'Bertrix', 'BE', 'WAL'),
(9361, 21, 401, 'Beyne-Heusay', 'BE', 'WAL'),
(9362, 21, 401, 'Bièvre', 'BE', 'WAL'),
(9363, 21, 401, 'Binche', 'BE', 'WAL'),
(9364, 21, 401, 'Blégny', 'BE', 'WAL'),
(9365, 21, 401, 'Bouillon', 'BE', 'WAL'),
(9366, 21, 401, 'Boussu', 'BE', 'WAL'),
(9367, 21, 401, 'Braine-l\'Alleud', 'BE', 'WAL'),
(9368, 21, 401, 'Braine-le-Château', 'BE', 'WAL'),
(9369, 21, 401, 'Braine-le-Comte', 'BE', 'WAL'),
(9370, 21, 401, 'Braives', 'BE', 'WAL'),
(9371, 21, 401, 'Brugelette', 'BE', 'WAL'),
(9372, 21, 401, 'Brunehault', 'BE', 'WAL'),
(9373, 21, 401, 'Bullange', 'BE', 'WAL'),
(9374, 21, 401, 'Burdinne', 'BE', 'WAL'),
(9375, 21, 401, 'Butgenbach', 'BE', 'WAL'),
(9376, 21, 401, 'Celles', 'BE', 'WAL'),
(9377, 21, 401, 'Cerfontaine', 'BE', 'WAL'),
(9378, 21, 401, 'Chapelle-lez-Herlaimont', 'BE', 'WAL'),
(9379, 21, 401, 'Charleroi', 'BE', 'WAL'),
(9380, 21, 401, 'Chastre-Villeroux-Blanmont', 'BE', 'WAL'),
(9381, 21, 401, 'Châtelet', 'BE', 'WAL'),
(9382, 21, 401, 'Chaudfontaine', 'BE', 'WAL'),
(9383, 21, 401, 'Chaumont-Gistoux', 'BE', 'WAL'),
(9384, 21, 401, 'Chièvres', 'BE', 'WAL'),
(9385, 21, 401, 'Chimay', 'BE', 'WAL'),
(9386, 21, 401, 'Chiny', 'BE', 'WAL'),
(9387, 21, 401, 'Ciney', 'BE', 'WAL'),
(9388, 21, 401, 'Clavier', 'BE', 'WAL'),
(9389, 21, 401, 'Colfontaine', 'BE', 'WAL'),
(9390, 21, 401, 'Comblain-au-Pont', 'BE', 'WAL'),
(9391, 21, 401, 'Courcelles', 'BE', 'WAL'),
(9392, 21, 401, 'Court-Saint-Étienne', 'BE', 'WAL'),
(9393, 21, 401, 'Couvin', 'BE', 'WAL'),
(9394, 21, 401, 'Crisnée', 'BE', 'WAL'),
(9395, 21, 401, 'Dalhem', 'BE', 'WAL'),
(9396, 21, 401, 'Daverdisse', 'BE', 'WAL'),
(9397, 21, 401, 'Dinant', 'BE', 'WAL'),
(9398, 21, 401, 'Dison', 'BE', 'WAL'),
(9399, 21, 401, 'Doische', 'BE', 'WAL'),
(9400, 21, 401, 'Donceel', 'BE', 'WAL'),
(9401, 21, 401, 'Dour', 'BE', 'WAL'),
(9402, 21, 401, 'Durbuy', 'BE', 'WAL'),
(9403, 21, 401, 'Écaussinnes-d’Enghien', 'BE', 'WAL'),
(9404, 21, 401, 'Éghezée', 'BE', 'WAL'),
(9405, 21, 401, 'Ellezelles', 'BE', 'WAL'),
(9406, 21, 401, 'Enghien', 'BE', 'WAL'),
(9407, 21, 401, 'Engis', 'BE', 'WAL'),
(9408, 21, 401, 'Érezée', 'BE', 'WAL'),
(9409, 21, 401, 'Erquelinnes', 'BE', 'WAL'),
(9410, 21, 401, 'Esneux', 'BE', 'WAL'),
(9411, 21, 401, 'Estaimpuis', 'BE', 'WAL'),
(9412, 21, 401, 'Estinnes-au-Val', 'BE', 'WAL'),
(9413, 21, 401, 'Étalle', 'BE', 'WAL'),
(9414, 21, 401, 'Eupen', 'BE', 'WAL'),
(9415, 21, 401, 'Faimes', 'BE', 'WAL'),
(9416, 21, 401, 'Farciennes', 'BE', 'WAL'),
(9417, 21, 401, 'Fauvillers', 'BE', 'WAL'),
(9418, 21, 401, 'Ferrières', 'BE', 'WAL'),
(9419, 21, 401, 'Fexhe-le-Haut-Clocher', 'BE', 'WAL'),
(9420, 21, 401, 'Flémalle-Haute', 'BE', 'WAL'),
(9421, 21, 401, 'Fléron', 'BE', 'WAL'),
(9422, 21, 401, 'Fleurus', 'BE', 'WAL'),
(9423, 21, 401, 'Flobecq', 'BE', 'WAL'),
(9424, 21, 401, 'Floreffe', 'BE', 'WAL'),
(9425, 21, 401, 'Florennes', 'BE', 'WAL'),
(9426, 21, 401, 'Florenville', 'BE', 'WAL'),
(9427, 21, 401, 'Forville', 'BE', 'WAL'),
(9428, 21, 401, 'Fosses-la-Ville', 'BE', 'WAL'),
(9429, 21, 401, 'Frameries', 'BE', 'WAL'),
(9430, 21, 401, 'Frasnes-lez-Buissenal', 'BE', 'WAL'),
(9431, 21, 401, 'Froidchapelle', 'BE', 'WAL'),
(9432, 21, 401, 'Gedinne', 'BE', 'WAL'),
(9433, 21, 401, 'Geer', 'BE', 'WAL'),
(9434, 21, 401, 'Gembloux', 'BE', 'WAL'),
(9435, 21, 401, 'Genappe', 'BE', 'WAL'),
(9436, 21, 401, 'Gerpinnes', 'BE', 'WAL'),
(9437, 21, 401, 'Gesves', 'BE', 'WAL'),
(9438, 21, 401, 'Gouvy', 'BE', 'WAL'),
(9439, 21, 401, 'Grez-Doiceau', 'BE', 'WAL'),
(9440, 21, 401, 'Habay-la-Vieille', 'BE', 'WAL'),
(9441, 21, 401, 'Hamoir', 'BE', 'WAL'),
(9442, 21, 401, 'Hamois', 'BE', 'WAL'),
(9443, 21, 401, 'Hannut', 'BE', 'WAL'),
(9444, 21, 401, 'Hastière-Lavaux', 'BE', 'WAL'),
(9445, 21, 401, 'Havelange', 'BE', 'WAL'),
(9446, 21, 401, 'Hensies', 'BE', 'WAL'),
(9447, 21, 401, 'Herbeumont', 'BE', 'WAL'),
(9448, 21, 401, 'Héron', 'BE', 'WAL'),
(9449, 21, 401, 'Herstal', 'BE', 'WAL'),
(9450, 21, 401, 'Herve', 'BE', 'WAL'),
(9451, 21, 401, 'Hotton', 'BE', 'WAL'),
(9452, 21, 401, 'Houffalize', 'BE', 'WAL'),
(9453, 21, 401, 'Houyet', 'BE', 'WAL'),
(9454, 21, 401, 'Huy', 'BE', 'WAL'),
(9455, 21, 401, 'Incourt', 'BE', 'WAL'),
(9456, 21, 401, 'Ittre', 'BE', 'WAL'),
(9457, 21, 401, 'Jalhay', 'BE', 'WAL'),
(9458, 21, 401, 'Jodoigne', 'BE', 'WAL'),
(9459, 21, 401, 'Juprelle', 'BE', 'WAL'),
(9460, 21, 401, 'Jurbise', 'BE', 'WAL'),
(9461, 21, 401, 'La Bruyère', 'BE', 'WAL'),
(9462, 21, 401, 'La Calamine', 'BE', 'WAL'),
(9463, 21, 401, 'La Hulpe', 'BE', 'WAL'),
(9464, 21, 401, 'La Louvière', 'BE', 'WAL'),
(9465, 21, 401, 'La Roche-en-Ardenne', 'BE', 'WAL'),
(9466, 21, 401, 'Léglise', 'BE', 'WAL'),
(9467, 21, 401, 'Lens', 'BE', 'WAL'),
(9468, 21, 401, 'Lessines', 'BE', 'WAL'),
(9469, 21, 401, 'Libin', 'BE', 'WAL'),
(9470, 21, 401, 'Liège', 'BE', 'WAL'),
(9471, 21, 401, 'Lierneux', 'BE', 'WAL'),
(9472, 21, 401, 'Limbourg', 'BE', 'WAL'),
(9473, 21, 401, 'Lincent', 'BE', 'WAL'),
(9474, 21, 401, 'Lobbes', 'BE', 'WAL'),
(9475, 21, 401, 'Lontzen', 'BE', 'WAL'),
(9476, 21, 401, 'Louvain-la-Neuve', 'BE', 'WAL'),
(9477, 21, 401, 'Malmédy', 'BE', 'WAL'),
(9478, 21, 401, 'Manage', 'BE', 'WAL'),
(9479, 21, 401, 'Manhay', 'BE', 'WAL'),
(9480, 21, 401, 'Marche-en-Famenne', 'BE', 'WAL'),
(9481, 21, 401, 'Marchin', 'BE', 'WAL'),
(9482, 21, 401, 'Martelange', 'BE', 'WAL'),
(9483, 21, 401, 'Meix-devant-Virton', 'BE', 'WAL'),
(9484, 21, 401, 'Merbes-le-Château', 'BE', 'WAL'),
(9485, 21, 401, 'Messancy', 'BE', 'WAL'),
(9486, 21, 401, 'Mettet', 'BE', 'WAL'),
(9487, 21, 401, 'Modave', 'BE', 'WAL'),
(9488, 21, 401, 'Momignies', 'BE', 'WAL'),
(9489, 21, 401, 'Mons', 'BE', 'WAL'),
(9490, 21, 401, 'Mons-lez-Liège', 'BE', 'WAL'),
(9491, 21, 401, 'Mont-Saint-Guibert', 'BE', 'WAL'),
(9492, 21, 401, 'Morlanwelz-Mariemont', 'BE', 'WAL'),
(9493, 21, 401, 'Mouscron', 'BE', 'WAL'),
(9494, 21, 401, 'Musson', 'BE', 'WAL'),
(9495, 21, 401, 'Namur', 'BE', 'WAL'),
(9496, 21, 401, 'Nandrin', 'BE', 'WAL'),
(9497, 21, 401, 'Nassogne', 'BE', 'WAL'),
(9498, 21, 401, 'Neufchâteau', 'BE', 'WAL'),
(9499, 21, 401, 'Nivelles', 'BE', 'WAL'),
(9500, 21, 401, 'Noville-les-Bois', 'BE', 'WAL');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(9501, 21, 401, 'Ohey', 'BE', 'WAL'),
(9502, 21, 401, 'Olne', 'BE', 'WAL'),
(9503, 21, 401, 'Onhaye', 'BE', 'WAL'),
(9504, 21, 401, 'Oreye', 'BE', 'WAL'),
(9505, 21, 401, 'Ottignies', 'BE', 'WAL'),
(9506, 21, 401, 'Ouffet', 'BE', 'WAL'),
(9507, 21, 401, 'Oupeye', 'BE', 'WAL'),
(9508, 21, 401, 'Paliseul', 'BE', 'WAL'),
(9509, 21, 401, 'Pecq', 'BE', 'WAL'),
(9510, 21, 401, 'Pepinster', 'BE', 'WAL'),
(9511, 21, 401, 'Péruwelz', 'BE', 'WAL'),
(9512, 21, 401, 'Perwez', 'BE', 'WAL'),
(9513, 21, 401, 'Philippeville', 'BE', 'WAL'),
(9514, 21, 401, 'Plombières', 'BE', 'WAL'),
(9515, 21, 401, 'Pont-à-Celles', 'BE', 'WAL'),
(9516, 21, 401, 'Profondeville', 'BE', 'WAL'),
(9517, 21, 401, 'Province de Liège', 'BE', 'WAL'),
(9518, 21, 401, 'Province de Namur', 'BE', 'WAL'),
(9519, 21, 401, 'Province du Brabant Wallon', 'BE', 'WAL'),
(9520, 21, 401, 'Province du Hainaut', 'BE', 'WAL'),
(9521, 21, 401, 'Province du Luxembourg', 'BE', 'WAL'),
(9522, 21, 401, 'Quaregnon', 'BE', 'WAL'),
(9523, 21, 401, 'Quévy-le-Petit', 'BE', 'WAL'),
(9524, 21, 401, 'Quiévrain', 'BE', 'WAL'),
(9525, 21, 401, 'Raeren', 'BE', 'WAL'),
(9526, 21, 401, 'Ramillies', 'BE', 'WAL'),
(9527, 21, 401, 'Rebecq-Rognon', 'BE', 'WAL'),
(9528, 21, 401, 'Remicourt', 'BE', 'WAL'),
(9529, 21, 401, 'Rendeux', 'BE', 'WAL'),
(9530, 21, 401, 'Rixensart', 'BE', 'WAL'),
(9531, 21, 401, 'Rochefort', 'BE', 'WAL'),
(9532, 21, 401, 'Roeulx', 'BE', 'WAL'),
(9533, 21, 401, 'Rouvroy', 'BE', 'WAL'),
(9534, 21, 401, 'Rumes', 'BE', 'WAL'),
(9535, 21, 401, 'Saint-Ghislain', 'BE', 'WAL'),
(9536, 21, 401, 'Saint-Hubert', 'BE', 'WAL'),
(9537, 21, 401, 'Saint-Léger', 'BE', 'WAL'),
(9538, 21, 401, 'Saint-Nicolas', 'BE', 'WAL'),
(9539, 21, 401, 'Saint-Vith', 'BE', 'WAL'),
(9540, 21, 401, 'Sainte-Ode', 'BE', 'WAL'),
(9541, 21, 401, 'Seneffe', 'BE', 'WAL'),
(9542, 21, 401, 'Seraing', 'BE', 'WAL'),
(9543, 21, 401, 'Silly', 'BE', 'WAL'),
(9544, 21, 401, 'Soignies', 'BE', 'WAL'),
(9545, 21, 401, 'Sombreffe', 'BE', 'WAL'),
(9546, 21, 401, 'Somme-Leuze', 'BE', 'WAL'),
(9547, 21, 401, 'Soumagne', 'BE', 'WAL'),
(9548, 21, 401, 'Spa', 'BE', 'WAL'),
(9549, 21, 401, 'Sprimont', 'BE', 'WAL'),
(9550, 21, 401, 'Stavelot', 'BE', 'WAL'),
(9551, 21, 401, 'Stoumont', 'BE', 'WAL'),
(9552, 21, 401, 'Tellin', 'BE', 'WAL'),
(9553, 21, 401, 'Tenneville', 'BE', 'WAL'),
(9554, 21, 401, 'Theux', 'BE', 'WAL'),
(9555, 21, 401, 'Thuin', 'BE', 'WAL'),
(9556, 21, 401, 'Tinlot', 'BE', 'WAL'),
(9557, 21, 401, 'Tintigny', 'BE', 'WAL'),
(9558, 21, 401, 'Tournai', 'BE', 'WAL'),
(9559, 21, 401, 'Trois-Ponts', 'BE', 'WAL'),
(9560, 21, 401, 'Trooz', 'BE', 'WAL'),
(9561, 21, 401, 'Tubize', 'BE', 'WAL'),
(9562, 21, 401, 'Vaux-sur-Sûre', 'BE', 'WAL'),
(9563, 21, 401, 'Verlaine', 'BE', 'WAL'),
(9564, 21, 401, 'Verviers', 'BE', 'WAL'),
(9565, 21, 401, 'Vielsalm', 'BE', 'WAL'),
(9566, 21, 401, 'Villers-la-Ville', 'BE', 'WAL'),
(9567, 21, 401, 'Villers-le-Bouillet', 'BE', 'WAL'),
(9568, 21, 401, 'Virton', 'BE', 'WAL'),
(9569, 21, 401, 'Visé', 'BE', 'WAL'),
(9570, 21, 401, 'Waimes', 'BE', 'WAL'),
(9571, 21, 401, 'Walcourt', 'BE', 'WAL'),
(9572, 21, 401, 'Walhain-Saint-Paul', 'BE', 'WAL'),
(9573, 21, 401, 'Wanze', 'BE', 'WAL'),
(9574, 21, 401, 'Waremme', 'BE', 'WAL'),
(9575, 21, 401, 'Wasseiges', 'BE', 'WAL'),
(9576, 21, 401, 'Waterloo', 'BE', 'WAL'),
(9577, 21, 401, 'Wavre', 'BE', 'WAL'),
(9578, 21, 401, 'Welkenraedt', 'BE', 'WAL'),
(9579, 21, 401, 'Wellin', 'BE', 'WAL'),
(9580, 21, 401, 'Yvoir', 'BE', 'WAL'),
(9581, 22, 404, 'Belize City', 'BZ', 'BZ'),
(9582, 22, 404, 'San Pedro', 'BZ', 'BZ'),
(9583, 22, 405, 'Belmopan', 'BZ', 'CY'),
(9584, 22, 405, 'Benque Viejo el Carmen', 'BZ', 'CY'),
(9585, 22, 405, 'San Ignacio', 'BZ', 'CY'),
(9586, 22, 405, 'Valley of Peace', 'BZ', 'CY'),
(9587, 22, 406, 'Corozal', 'BZ', 'CZL'),
(9588, 22, 407, 'Hopelchén', 'BZ', 'OW'),
(9589, 22, 407, 'Orange Walk', 'BZ', 'OW'),
(9590, 22, 407, 'Shipyard', 'BZ', 'OW'),
(9591, 22, 408, 'Dangriga', 'BZ', 'SC'),
(9592, 22, 408, 'Placencia', 'BZ', 'SC'),
(9593, 22, 409, 'Punta Gorda', 'BZ', 'TOL'),
(9594, 23, 410, 'Banikoara', 'BJ', 'AL'),
(9595, 23, 410, 'Kandi', 'BJ', 'AL'),
(9596, 23, 410, 'Malanville', 'BJ', 'AL'),
(9597, 23, 411, 'Guilmaro', 'BJ', 'AK'),
(9598, 23, 411, 'Natitingou', 'BJ', 'AK'),
(9599, 23, 411, 'Tanguieta', 'BJ', 'AK'),
(9600, 23, 412, 'Abomey-Calavi', 'BJ', 'AQ'),
(9601, 23, 412, 'Allada', 'BJ', 'AQ'),
(9602, 23, 412, 'Hévié', 'BJ', 'AQ'),
(9603, 23, 412, 'Hinvi', 'BJ', 'AQ'),
(9604, 23, 412, 'Ouidah', 'BJ', 'AQ'),
(9605, 23, 413, 'Bembèrèkè', 'BJ', 'BO'),
(9606, 23, 413, 'Bétérou', 'BJ', 'BO'),
(9607, 23, 413, 'Nikki', 'BJ', 'BO'),
(9608, 23, 413, 'Parakou', 'BJ', 'BO'),
(9609, 23, 413, 'Tchaourou', 'BJ', 'BO'),
(9610, 23, 414, 'Comé', 'BJ', 'CO'),
(9611, 23, 414, 'Dassa-Zoumé', 'BJ', 'CO'),
(9612, 23, 414, 'Savalou', 'BJ', 'CO'),
(9613, 23, 414, 'Savé', 'BJ', 'CO'),
(9614, 23, 415, 'Bassila', 'BJ', 'DO'),
(9615, 23, 415, 'Commune of Djougou', 'BJ', 'DO'),
(9616, 23, 415, 'Djougou', 'BJ', 'DO'),
(9617, 23, 416, 'Djakotomey', 'BJ', 'KO'),
(9618, 23, 416, 'Dogbo', 'BJ', 'KO'),
(9619, 23, 417, 'Cotonou', 'BJ', 'LI'),
(9620, 23, 418, 'Commune of Athieme', 'BJ', 'MO'),
(9621, 23, 418, 'Lokossa', 'BJ', 'MO'),
(9622, 23, 419, 'Porto-Novo', 'BJ', 'OU'),
(9623, 23, 420, 'Kétou', 'BJ', 'PL'),
(9624, 23, 420, 'Pobé', 'BJ', 'PL'),
(9625, 23, 420, 'Sakété', 'BJ', 'PL'),
(9626, 23, 421, 'Abomey', 'BJ', 'ZO'),
(9627, 23, 421, 'Bohicon', 'BJ', 'ZO'),
(9628, 23, 421, 'Commune of Agbangnizoun', 'BJ', 'ZO'),
(9629, 23, 421, 'Cové', 'BJ', 'ZO'),
(9630, 25, 431, 'Jakar', 'BT', '33'),
(9631, 25, 432, 'Daphu', 'BT', '12'),
(9632, 25, 432, 'Phuntsholing', 'BT', '12'),
(9633, 25, 432, 'Tsimasham', 'BT', '12'),
(9634, 25, 433, 'Daga', 'BT', '22'),
(9635, 25, 433, 'Wangdue Phodrang', 'BT', '22'),
(9636, 25, 434, 'Gasa', 'BT', 'GA'),
(9637, 25, 435, 'Ha', 'BT', '13'),
(9638, 25, 436, 'Lhuentse', 'BT', '44'),
(9639, 25, 437, 'Mongar', 'BT', '42'),
(9640, 25, 438, 'Paro', 'BT', '11'),
(9641, 25, 439, 'Pemagatshel', 'BT', '43'),
(9642, 25, 440, 'Pajo', 'BT', '23'),
(9643, 25, 440, 'Punākha', 'BT', '23'),
(9644, 25, 441, 'Samdrup Jongkhar', 'BT', '45'),
(9645, 25, 442, 'Samtse', 'BT', '14'),
(9646, 25, 443, 'Sarpang', 'BT', '31'),
(9647, 25, 444, 'Thimphu', 'BT', '15'),
(9648, 25, 445, 'Trashigang', 'BT', '41'),
(9649, 25, 447, 'Trongsa', 'BT', '21'),
(9650, 25, 447, 'Tsirang', 'BT', '21'),
(9651, 25, 448, 'Trashi Yangtse', 'BT', '24'),
(9652, 25, 449, 'Panbang', 'BT', '34'),
(9653, 25, 449, 'Shemgang', 'BT', '34'),
(9654, 26, 450, 'Guayaramerín', 'BO', 'B'),
(9655, 26, 450, 'Provincia Cercado', 'BO', 'B'),
(9656, 26, 450, 'Provincia General José Ballivián', 'BO', 'B'),
(9657, 26, 450, 'Provincia Iténez', 'BO', 'B'),
(9658, 26, 450, 'Provincia Mamoré', 'BO', 'B'),
(9659, 26, 450, 'Provincia Marbán', 'BO', 'B'),
(9660, 26, 450, 'Provincia Moxos', 'BO', 'B'),
(9661, 26, 450, 'Provincia Vaca Diez', 'BO', 'B'),
(9662, 26, 450, 'Provincia Yacuma', 'BO', 'B'),
(9663, 26, 450, 'Reyes', 'BO', 'B'),
(9664, 26, 450, 'Riberalta', 'BO', 'B'),
(9665, 26, 450, 'Rurrenabaque', 'BO', 'B'),
(9666, 26, 450, 'San Borja', 'BO', 'B'),
(9667, 26, 450, 'San Ramón', 'BO', 'B'),
(9668, 26, 450, 'Santa Ana de Yacuma', 'BO', 'B'),
(9669, 26, 450, 'Santa Rosa', 'BO', 'B'),
(9670, 26, 450, 'Trinidad', 'BO', 'B'),
(9671, 26, 451, 'Camargo', 'BO', 'H'),
(9672, 26, 451, 'Monteagudo', 'BO', 'H'),
(9673, 26, 451, 'Padilla', 'BO', 'H'),
(9674, 26, 451, 'Provincia Azurduy', 'BO', 'H'),
(9675, 26, 451, 'Provincia Belisario Boeto', 'BO', 'H'),
(9676, 26, 451, 'Provincia Hernando Siles', 'BO', 'H'),
(9677, 26, 451, 'Provincia Luis Calvo', 'BO', 'H'),
(9678, 26, 451, 'Provincia Nor Cinti', 'BO', 'H'),
(9679, 26, 451, 'Provincia Oropeza', 'BO', 'H'),
(9680, 26, 451, 'Provincia Sud Cinti', 'BO', 'H'),
(9681, 26, 451, 'Provincia Tomina', 'BO', 'H'),
(9682, 26, 451, 'Provincia Yamparáez', 'BO', 'H'),
(9683, 26, 451, 'Provincia Zudáñez', 'BO', 'H'),
(9684, 26, 451, 'Sucre', 'BO', 'H'),
(9685, 26, 451, 'Tarabuco', 'BO', 'H'),
(9686, 26, 452, 'Aiquile', 'BO', 'C'),
(9687, 26, 452, 'Arani', 'BO', 'C'),
(9688, 26, 452, 'Bolivar', 'BO', 'C'),
(9689, 26, 452, 'Capinota', 'BO', 'C'),
(9690, 26, 452, 'Chimoré', 'BO', 'C'),
(9691, 26, 452, 'Cliza', 'BO', 'C'),
(9692, 26, 452, 'Cochabamba', 'BO', 'C'),
(9693, 26, 452, 'Colchani', 'BO', 'C'),
(9694, 26, 452, 'Colomi', 'BO', 'C'),
(9695, 26, 452, 'Independencia', 'BO', 'C'),
(9696, 26, 452, 'Irpa Irpa', 'BO', 'C'),
(9697, 26, 452, 'Mizque', 'BO', 'C'),
(9698, 26, 452, 'Provincia Arani', 'BO', 'C'),
(9699, 26, 452, 'Provincia Arque', 'BO', 'C'),
(9700, 26, 452, 'Provincia Ayopaya', 'BO', 'C'),
(9701, 26, 452, 'Provincia Campero', 'BO', 'C'),
(9702, 26, 452, 'Provincia Capinota', 'BO', 'C'),
(9703, 26, 452, 'Provincia Carrasco', 'BO', 'C'),
(9704, 26, 452, 'Provincia Cercado', 'BO', 'C'),
(9705, 26, 452, 'Provincia Chaparé', 'BO', 'C'),
(9706, 26, 452, 'Provincia Esteban Arce', 'BO', 'C'),
(9707, 26, 452, 'Provincia Germán Jordán', 'BO', 'C'),
(9708, 26, 452, 'Provincia Mizque', 'BO', 'C'),
(9709, 26, 452, 'Provincia Punata', 'BO', 'C'),
(9710, 26, 452, 'Provincia Quillacollo', 'BO', 'C'),
(9711, 26, 452, 'Provincia Tapacarí', 'BO', 'C'),
(9712, 26, 452, 'Punata', 'BO', 'C'),
(9713, 26, 452, 'Quillacollo', 'BO', 'C'),
(9714, 26, 452, 'Sacaba', 'BO', 'C'),
(9715, 26, 452, 'Sipe Sipe', 'BO', 'C'),
(9716, 26, 452, 'Tarata', 'BO', 'C'),
(9717, 26, 452, 'Tiquipaya', 'BO', 'C'),
(9718, 26, 452, 'Tiraque Province', 'BO', 'C'),
(9719, 26, 452, 'Totora', 'BO', 'C'),
(9720, 26, 453, 'Achacachi', 'BO', 'L'),
(9721, 26, 453, 'Amarete', 'BO', 'L'),
(9722, 26, 453, 'Batallas', 'BO', 'L'),
(9723, 26, 453, 'Caranavi', 'BO', 'L'),
(9724, 26, 453, 'Chulumani', 'BO', 'L'),
(9725, 26, 453, 'Colquiri', 'BO', 'L'),
(9726, 26, 453, 'Coripata', 'BO', 'L'),
(9727, 26, 453, 'Coroico', 'BO', 'L'),
(9728, 26, 453, 'Curahuara de Carangas', 'BO', 'L'),
(9729, 26, 453, 'Eucaliptus', 'BO', 'L'),
(9730, 26, 453, 'Guanay', 'BO', 'L'),
(9731, 26, 453, 'Huarina', 'BO', 'L'),
(9732, 26, 453, 'Huatajata', 'BO', 'L'),
(9733, 26, 453, 'José Manuel Pando', 'BO', 'L'),
(9734, 26, 453, 'La Paz', 'BO', 'L'),
(9735, 26, 453, 'Lahuachaca', 'BO', 'L'),
(9736, 26, 453, 'Mapiri', 'BO', 'L'),
(9737, 26, 453, 'Patacamaya', 'BO', 'L'),
(9738, 26, 453, 'Provincia Aroma', 'BO', 'L'),
(9739, 26, 453, 'Provincia Bautista Saavedra', 'BO', 'L'),
(9740, 26, 453, 'Provincia Camacho', 'BO', 'L'),
(9741, 26, 453, 'Provincia Franz Tamayo', 'BO', 'L'),
(9742, 26, 453, 'Provincia Gualberto Villarroel', 'BO', 'L'),
(9743, 26, 453, 'Provincia Ingavi', 'BO', 'L'),
(9744, 26, 453, 'Provincia Inquisivi', 'BO', 'L'),
(9745, 26, 453, 'Provincia Iturralde', 'BO', 'L'),
(9746, 26, 453, 'Provincia Larecaja', 'BO', 'L'),
(9747, 26, 453, 'Provincia Loayza', 'BO', 'L'),
(9748, 26, 453, 'Provincia Los Andes', 'BO', 'L'),
(9749, 26, 453, 'Provincia Manco Kapac', 'BO', 'L'),
(9750, 26, 453, 'Provincia Muñecas', 'BO', 'L'),
(9751, 26, 453, 'Provincia Murillo', 'BO', 'L'),
(9752, 26, 453, 'Provincia Nor Yungas', 'BO', 'L'),
(9753, 26, 453, 'Provincia Omasuyos', 'BO', 'L'),
(9754, 26, 453, 'Provincia Pacajes', 'BO', 'L'),
(9755, 26, 453, 'Provincia Sud Yungas', 'BO', 'L'),
(9756, 26, 453, 'Quime', 'BO', 'L'),
(9757, 26, 453, 'San Pablo', 'BO', 'L'),
(9758, 26, 453, 'San Pedro', 'BO', 'L'),
(9759, 26, 453, 'Sorata', 'BO', 'L'),
(9760, 26, 453, 'Tiahuanaco', 'BO', 'L'),
(9761, 26, 453, 'Viloco', 'BO', 'L'),
(9762, 26, 453, 'Yumani', 'BO', 'L'),
(9763, 26, 454, 'Challapata', 'BO', 'O'),
(9764, 26, 454, 'Huanuni', 'BO', 'O'),
(9765, 26, 454, 'Litoral de Atacama', 'BO', 'O'),
(9766, 26, 454, 'Machacamarca', 'BO', 'O'),
(9767, 26, 454, 'Nor Carangas Province', 'BO', 'O'),
(9768, 26, 454, 'Oruro', 'BO', 'O'),
(9769, 26, 454, 'Poopó', 'BO', 'O'),
(9770, 26, 454, 'Provincia Avaroa', 'BO', 'O'),
(9771, 26, 454, 'Provincia Carangas', 'BO', 'O'),
(9772, 26, 454, 'Provincia Cercado', 'BO', 'O'),
(9773, 26, 454, 'Provincia Ladislao Cabrera', 'BO', 'O'),
(9774, 26, 454, 'Provincia Pantaleón Dalence', 'BO', 'O'),
(9775, 26, 454, 'Provincia Poopó', 'BO', 'O'),
(9776, 26, 454, 'Provincia Sabaya', 'BO', 'O'),
(9777, 26, 454, 'Provincia Sajama', 'BO', 'O'),
(9778, 26, 454, 'Provincia San Pedro de Totora', 'BO', 'O'),
(9779, 26, 454, 'Provincia Saucari', 'BO', 'O'),
(9780, 26, 454, 'Provincia Tomás Barron', 'BO', 'O'),
(9781, 26, 454, 'Puerto de Mejillones', 'BO', 'O'),
(9782, 26, 454, 'Sebastian Pagador Province', 'BO', 'O'),
(9783, 26, 454, 'Sud Carangas Province', 'BO', 'O'),
(9784, 26, 454, 'Totoral', 'BO', 'O'),
(9785, 26, 455, 'Cobija', 'BO', 'N'),
(9786, 26, 455, 'Provincia Abuná', 'BO', 'N'),
(9787, 26, 455, 'Provincia General Federico Román', 'BO', 'N'),
(9788, 26, 455, 'Provincia Madre de Dios', 'BO', 'N'),
(9789, 26, 455, 'Provincia Manuripi', 'BO', 'N'),
(9790, 26, 455, 'Provincia Nicolás Suárez', 'BO', 'N'),
(9791, 26, 456, 'Atocha', 'BO', 'P'),
(9792, 26, 456, 'Betanzos', 'BO', 'P'),
(9793, 26, 456, 'Colchani', 'BO', 'P'),
(9794, 26, 456, 'Colquechaca', 'BO', 'P'),
(9795, 26, 456, 'Enrique Baldivieso', 'BO', 'P'),
(9796, 26, 456, 'Llallagua', 'BO', 'P'),
(9797, 26, 456, 'Potosí', 'BO', 'P'),
(9798, 26, 456, 'Provincia Alonzo de Ibáñez', 'BO', 'P'),
(9799, 26, 456, 'Provincia Charcas', 'BO', 'P'),
(9800, 26, 456, 'Provincia Chayanta', 'BO', 'P'),
(9801, 26, 456, 'Provincia Daniel Campos', 'BO', 'P'),
(9802, 26, 456, 'Provincia General Bilbao', 'BO', 'P'),
(9803, 26, 456, 'Provincia Linares', 'BO', 'P'),
(9804, 26, 456, 'Provincia Modesto Omiste', 'BO', 'P'),
(9805, 26, 456, 'Provincia Nor Chichas', 'BO', 'P'),
(9806, 26, 456, 'Provincia Nor Lípez', 'BO', 'P'),
(9807, 26, 456, 'Provincia Quijarro', 'BO', 'P'),
(9808, 26, 456, 'Provincia Rafael Bustillo', 'BO', 'P'),
(9809, 26, 456, 'Provincia Saavedra', 'BO', 'P'),
(9810, 26, 456, 'Provincia Sud Chichas', 'BO', 'P'),
(9811, 26, 456, 'Provincia Sud Lípez', 'BO', 'P'),
(9812, 26, 456, 'Provincia Tomás Frías', 'BO', 'P'),
(9813, 26, 456, 'Santa Bárbara', 'BO', 'P'),
(9814, 26, 456, 'Tupiza', 'BO', 'P'),
(9815, 26, 456, 'Uyuni', 'BO', 'P'),
(9816, 26, 456, 'Villazón', 'BO', 'P'),
(9817, 26, 457, 'Abapó', 'BO', 'S'),
(9818, 26, 457, 'Ascención de Guarayos', 'BO', 'S'),
(9819, 26, 457, 'Ascensión', 'BO', 'S'),
(9820, 26, 457, 'Boyuibe', 'BO', 'S'),
(9821, 26, 457, 'Buena Vista', 'BO', 'S'),
(9822, 26, 457, 'Camiri', 'BO', 'S'),
(9823, 26, 457, 'Charagua', 'BO', 'S'),
(9824, 26, 457, 'Comarapa', 'BO', 'S'),
(9825, 26, 457, 'Concepción', 'BO', 'S'),
(9826, 26, 457, 'Cotoca', 'BO', 'S'),
(9827, 26, 457, 'German Busch', 'BO', 'S'),
(9828, 26, 457, 'Guarayos', 'BO', 'S'),
(9829, 26, 457, 'Jorochito', 'BO', 'S'),
(9830, 26, 457, 'La Bélgica', 'BO', 'S'),
(9831, 26, 457, 'Limoncito', 'BO', 'S'),
(9832, 26, 457, 'Los Negros', 'BO', 'S'),
(9833, 26, 457, 'Mairana', 'BO', 'S'),
(9834, 26, 457, 'Mineros', 'BO', 'S'),
(9835, 26, 457, 'Montero', 'BO', 'S'),
(9836, 26, 457, 'Okinawa Número Uno', 'BO', 'S'),
(9837, 26, 457, 'Pailón', 'BO', 'S'),
(9838, 26, 457, 'Paurito', 'BO', 'S'),
(9839, 26, 457, 'Portachuelo', 'BO', 'S'),
(9840, 26, 457, 'Provincia Andrés Ibáñez', 'BO', 'S'),
(9841, 26, 457, 'Provincia Ángel Sandoval', 'BO', 'S'),
(9842, 26, 457, 'Provincia Chiquitos', 'BO', 'S'),
(9843, 26, 457, 'Provincia Cordillera', 'BO', 'S'),
(9844, 26, 457, 'Provincia Florida', 'BO', 'S'),
(9845, 26, 457, 'Provincia Ichilo', 'BO', 'S'),
(9846, 26, 457, 'Provincia Manuel María Caballero', 'BO', 'S'),
(9847, 26, 457, 'Provincia Ñuflo de Chávez', 'BO', 'S'),
(9848, 26, 457, 'Provincia Santiesteban', 'BO', 'S'),
(9849, 26, 457, 'Provincia Sara', 'BO', 'S'),
(9850, 26, 457, 'Provincia Vallegrande', 'BO', 'S'),
(9851, 26, 457, 'Provincia Velasco', 'BO', 'S'),
(9852, 26, 457, 'Provincia Warnes', 'BO', 'S'),
(9853, 26, 457, 'Puerto Quijarro', 'BO', 'S'),
(9854, 26, 457, 'Puesto de Pailas', 'BO', 'S'),
(9855, 26, 457, 'Roboré', 'BO', 'S'),
(9856, 26, 457, 'Samaipata', 'BO', 'S'),
(9857, 26, 457, 'San Carlos', 'BO', 'S'),
(9858, 26, 457, 'San Ignacio de Velasco', 'BO', 'S'),
(9859, 26, 457, 'San Juan del Surutú', 'BO', 'S'),
(9860, 26, 457, 'San Julian', 'BO', 'S'),
(9861, 26, 457, 'San Matías', 'BO', 'S'),
(9862, 26, 457, 'San Pedro', 'BO', 'S'),
(9863, 26, 457, 'Santa Cruz de la Sierra', 'BO', 'S'),
(9864, 26, 457, 'Santa Rita', 'BO', 'S'),
(9865, 26, 457, 'Santa Rosa del Sara', 'BO', 'S'),
(9866, 26, 457, 'Santiago del Torno', 'BO', 'S'),
(9867, 26, 457, 'Urubichá', 'BO', 'S'),
(9868, 26, 457, 'Vallegrande', 'BO', 'S'),
(9869, 26, 457, 'Villa Yapacaní', 'BO', 'S'),
(9870, 26, 457, 'Warnes', 'BO', 'S'),
(9871, 26, 458, 'Bermejo', 'BO', 'T'),
(9872, 26, 458, 'Entre Ríos', 'BO', 'T'),
(9873, 26, 458, 'Provincia Arce', 'BO', 'T'),
(9874, 26, 458, 'Provincia Avilez', 'BO', 'T'),
(9875, 26, 458, 'Provincia Cercado', 'BO', 'T'),
(9876, 26, 458, 'Provincia Gran Chaco', 'BO', 'T'),
(9877, 26, 458, 'Provincia Méndez', 'BO', 'T'),
(9878, 26, 458, 'Provincia O’Connor', 'BO', 'T'),
(9879, 26, 458, 'Tarija', 'BO', 'T'),
(9880, 26, 458, 'Villamontes', 'BO', 'T'),
(9881, 26, 458, 'Yacuiba', 'BO', 'T'),
(9882, 27, 459, 'Boven Bolivia', 'BQ', 'BQ1'),
(9883, 27, 459, 'Dorp Tera Kora', 'BQ', 'BQ1'),
(9884, 27, 459, 'Oranjestad', 'BQ', 'BQ1'),
(9885, 27, 459, 'Rincon', 'BQ', 'BQ1'),
(9886, 27, 459, 'St. Johns', 'BQ', 'BQ1'),
(9887, 27, 459, 'The Bottom', 'BQ', 'BQ1'),
(9888, 27, 459, 'Windwardside', 'BQ', 'BQ1'),
(9889, 27, 459, 'Zion\'s Hill', 'BQ', 'BQ1'),
(9890, 28, 463, 'Brčko', 'BA', 'BRC'),
(9891, 28, 463, 'Brka', 'BA', 'BRC'),
(9892, 28, 466, 'Banovići', 'BA', 'BIH'),
(9893, 28, 466, 'Barice', 'BA', 'BIH'),
(9894, 28, 466, 'Bihać', 'BA', 'BIH'),
(9895, 28, 466, 'Bijela', 'BA', 'BIH'),
(9896, 28, 466, 'Bila', 'BA', 'BIH'),
(9897, 28, 466, 'Blagaj', 'BA', 'BIH'),
(9898, 28, 466, 'Bosanska Krupa', 'BA', 'BIH'),
(9899, 28, 466, 'Bosanski Petrovac', 'BA', 'BIH'),
(9900, 28, 466, 'Bosansko Grahovo', 'BA', 'BIH'),
(9901, 28, 466, 'Breza', 'BA', 'BIH'),
(9902, 28, 466, 'Bugojno', 'BA', 'BIH'),
(9903, 28, 466, 'Busovača', 'BA', 'BIH'),
(9904, 28, 466, 'Bužim', 'BA', 'BIH'),
(9905, 28, 466, 'Čapljina', 'BA', 'BIH'),
(9906, 28, 466, 'Cazin', 'BA', 'BIH'),
(9907, 28, 466, 'Čelić', 'BA', 'BIH'),
(9908, 28, 466, 'Cim', 'BA', 'BIH'),
(9909, 28, 466, 'Čitluk', 'BA', 'BIH'),
(9910, 28, 466, 'Ćoralići', 'BA', 'BIH'),
(9911, 28, 466, 'Crnići', 'BA', 'BIH'),
(9912, 28, 466, 'Divičani', 'BA', 'BIH'),
(9913, 28, 466, 'Dobrinje', 'BA', 'BIH'),
(9914, 28, 466, 'Domaljevac', 'BA', 'BIH'),
(9915, 28, 466, 'Donja Dubica', 'BA', 'BIH'),
(9916, 28, 466, 'Donja Mahala', 'BA', 'BIH'),
(9917, 28, 466, 'Donja Međiđa', 'BA', 'BIH'),
(9918, 28, 466, 'Donji Vakuf', 'BA', 'BIH'),
(9919, 28, 466, 'Drežnica', 'BA', 'BIH'),
(9920, 28, 466, 'Drinovci', 'BA', 'BIH'),
(9921, 28, 466, 'Drvar', 'BA', 'BIH'),
(9922, 28, 466, 'Dubrave Donje', 'BA', 'BIH'),
(9923, 28, 466, 'Dubrave Gornje', 'BA', 'BIH'),
(9924, 28, 466, 'Dubravica', 'BA', 'BIH'),
(9925, 28, 466, 'Fojnica', 'BA', 'BIH'),
(9926, 28, 466, 'Glamoč', 'BA', 'BIH'),
(9927, 28, 466, 'Gnojnica', 'BA', 'BIH'),
(9928, 28, 466, 'Goražde', 'BA', 'BIH'),
(9929, 28, 466, 'Gorica', 'BA', 'BIH'),
(9930, 28, 466, 'Gornja Breza', 'BA', 'BIH'),
(9931, 28, 466, 'Gornja Koprivna', 'BA', 'BIH'),
(9932, 28, 466, 'Gornja Tuzla', 'BA', 'BIH'),
(9933, 28, 466, 'Gornje Moštre', 'BA', 'BIH'),
(9934, 28, 466, 'Gornje Živinice', 'BA', 'BIH'),
(9935, 28, 466, 'Gornji Vakuf', 'BA', 'BIH'),
(9936, 28, 466, 'Gostovići', 'BA', 'BIH'),
(9937, 28, 466, 'Gračanica', 'BA', 'BIH'),
(9938, 28, 466, 'Gradačac', 'BA', 'BIH'),
(9939, 28, 466, 'Gromiljak', 'BA', 'BIH'),
(9940, 28, 466, 'Grude', 'BA', 'BIH'),
(9941, 28, 466, 'Hadžići', 'BA', 'BIH'),
(9942, 28, 466, 'Hercegovačko-Neretvanski Kanton', 'BA', 'BIH'),
(9943, 28, 466, 'Hotonj', 'BA', 'BIH'),
(9944, 28, 466, 'Ilići', 'BA', 'BIH'),
(9945, 28, 466, 'Ilijaš', 'BA', 'BIH'),
(9946, 28, 466, 'Izačić', 'BA', 'BIH'),
(9947, 28, 466, 'Jablanica', 'BA', 'BIH'),
(9948, 28, 466, 'Jajce', 'BA', 'BIH'),
(9949, 28, 466, 'Jelah', 'BA', 'BIH'),
(9950, 28, 466, 'Jezerski', 'BA', 'BIH'),
(9951, 28, 466, 'Kačuni', 'BA', 'BIH'),
(9952, 28, 466, 'Kakanj', 'BA', 'BIH'),
(9953, 28, 466, 'Kanton Sarajevo', 'BA', 'BIH'),
(9954, 28, 466, 'Karadaglije', 'BA', 'BIH'),
(9955, 28, 466, 'Kiseljak', 'BA', 'BIH'),
(9956, 28, 466, 'Kladanj', 'BA', 'BIH'),
(9957, 28, 466, 'Ključ', 'BA', 'BIH'),
(9958, 28, 466, 'Kobilja Glava', 'BA', 'BIH'),
(9959, 28, 466, 'Kočerin', 'BA', 'BIH'),
(9960, 28, 466, 'Konjic', 'BA', 'BIH'),
(9961, 28, 466, 'Kovači', 'BA', 'BIH'),
(9962, 28, 466, 'Liješnica', 'BA', 'BIH'),
(9963, 28, 466, 'Livno', 'BA', 'BIH'),
(9964, 28, 466, 'Ljubuški', 'BA', 'BIH'),
(9965, 28, 466, 'Lokvine', 'BA', 'BIH'),
(9966, 28, 466, 'Lukavac', 'BA', 'BIH'),
(9967, 28, 466, 'Lukavica', 'BA', 'BIH'),
(9968, 28, 466, 'Maglaj', 'BA', 'BIH'),
(9969, 28, 466, 'Mahala', 'BA', 'BIH'),
(9970, 28, 466, 'Mala Kladuša', 'BA', 'BIH'),
(9971, 28, 466, 'Malešići', 'BA', 'BIH'),
(9972, 28, 466, 'Mionica', 'BA', 'BIH'),
(9973, 28, 466, 'Mostar', 'BA', 'BIH'),
(9974, 28, 466, 'Mramor', 'BA', 'BIH'),
(9975, 28, 466, 'Neum', 'BA', 'BIH'),
(9976, 28, 466, 'Novi Šeher', 'BA', 'BIH'),
(9977, 28, 466, 'Novi Travnik', 'BA', 'BIH'),
(9978, 28, 466, 'Odžak', 'BA', 'BIH'),
(9979, 28, 466, 'Olovo', 'BA', 'BIH'),
(9980, 28, 466, 'Omanjska', 'BA', 'BIH'),
(9981, 28, 466, 'Orahovica Donja', 'BA', 'BIH'),
(9982, 28, 466, 'Orašac', 'BA', 'BIH'),
(9983, 28, 466, 'Orašje', 'BA', 'BIH'),
(9984, 28, 466, 'Orguz', 'BA', 'BIH'),
(9985, 28, 466, 'Ostrožac', 'BA', 'BIH'),
(9986, 28, 466, 'Otoka', 'BA', 'BIH'),
(9987, 28, 466, 'Pajić Polje', 'BA', 'BIH'),
(9988, 28, 466, 'Pazarić', 'BA', 'BIH'),
(9989, 28, 466, 'Peći', 'BA', 'BIH'),
(9990, 28, 466, 'Pećigrad', 'BA', 'BIH'),
(9991, 28, 466, 'Pjanići', 'BA', 'BIH'),
(9992, 28, 466, 'Podhum', 'BA', 'BIH'),
(9993, 28, 466, 'Podzvizd', 'BA', 'BIH'),
(9994, 28, 466, 'Polje', 'BA', 'BIH'),
(9995, 28, 466, 'Polje-Bijela', 'BA', 'BIH'),
(9996, 28, 466, 'Potoci', 'BA', 'BIH'),
(9997, 28, 466, 'Prozor', 'BA', 'BIH'),
(9998, 28, 466, 'Puračić', 'BA', 'BIH'),
(9999, 28, 466, 'Radišići', 'BA', 'BIH'),
(10000, 28, 466, 'Rodoč', 'BA', 'BIH');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(10001, 28, 466, 'Rumboci', 'BA', 'BIH'),
(10002, 28, 466, 'Sanica', 'BA', 'BIH'),
(10003, 28, 466, 'Sanski Most', 'BA', 'BIH'),
(10004, 28, 466, 'Sapna', 'BA', 'BIH'),
(10005, 28, 466, 'Sarajevo', 'BA', 'BIH'),
(10006, 28, 466, 'Šerići', 'BA', 'BIH'),
(10007, 28, 466, 'Široki Brijeg', 'BA', 'BIH'),
(10008, 28, 466, 'Skokovi', 'BA', 'BIH'),
(10009, 28, 466, 'Sladna', 'BA', 'BIH'),
(10010, 28, 466, 'Solina', 'BA', 'BIH'),
(10011, 28, 466, 'Srebrenik', 'BA', 'BIH'),
(10012, 28, 466, 'Stijena', 'BA', 'BIH'),
(10013, 28, 466, 'Stjepan-Polje', 'BA', 'BIH'),
(10014, 28, 466, 'Stolac', 'BA', 'BIH'),
(10015, 28, 466, 'Šturlić', 'BA', 'BIH'),
(10016, 28, 466, 'Šumatac', 'BA', 'BIH'),
(10017, 28, 466, 'Tasovčići', 'BA', 'BIH'),
(10018, 28, 466, 'Tešanj', 'BA', 'BIH'),
(10019, 28, 466, 'Tešanjka', 'BA', 'BIH'),
(10020, 28, 466, 'Todorovo', 'BA', 'BIH'),
(10021, 28, 466, 'Tojšići', 'BA', 'BIH'),
(10022, 28, 466, 'Tomislavgrad', 'BA', 'BIH'),
(10023, 28, 466, 'Travnik', 'BA', 'BIH'),
(10024, 28, 466, 'Tržačka Raštela', 'BA', 'BIH'),
(10025, 28, 466, 'Turbe', 'BA', 'BIH'),
(10026, 28, 466, 'Tuzla', 'BA', 'BIH'),
(10027, 28, 466, 'Ustikolina', 'BA', 'BIH'),
(10028, 28, 466, 'Vareš', 'BA', 'BIH'),
(10029, 28, 466, 'Varoška Rijeka', 'BA', 'BIH'),
(10030, 28, 466, 'Velagići', 'BA', 'BIH'),
(10031, 28, 466, 'Velika Kladuša', 'BA', 'BIH'),
(10032, 28, 466, 'Vidoši', 'BA', 'BIH'),
(10033, 28, 466, 'Visoko', 'BA', 'BIH'),
(10034, 28, 466, 'Vitez', 'BA', 'BIH'),
(10035, 28, 466, 'Vitina', 'BA', 'BIH'),
(10036, 28, 466, 'Vogošća', 'BA', 'BIH'),
(10037, 28, 466, 'Voljevac', 'BA', 'BIH'),
(10038, 28, 466, 'Vrnograč', 'BA', 'BIH'),
(10039, 28, 466, 'Vukovije Donje', 'BA', 'BIH'),
(10040, 28, 466, 'Zabrišće', 'BA', 'BIH'),
(10041, 28, 466, 'Zavidovići', 'BA', 'BIH'),
(10042, 28, 466, 'Zborište', 'BA', 'BIH'),
(10043, 28, 466, 'Željezno Polje', 'BA', 'BIH'),
(10044, 28, 466, 'Zenica', 'BA', 'BIH'),
(10045, 28, 466, 'Žepče', 'BA', 'BIH'),
(10046, 28, 466, 'Živinice', 'BA', 'BIH'),
(10047, 28, 469, 'Balatun', 'BA', 'SRP'),
(10048, 28, 469, 'Banja Luka', 'BA', 'SRP'),
(10049, 28, 469, 'Bijeljina', 'BA', 'SRP'),
(10050, 28, 469, 'Bileća', 'BA', 'SRP'),
(10051, 28, 469, 'Blatnica', 'BA', 'SRP'),
(10052, 28, 469, 'Brod', 'BA', 'SRP'),
(10053, 28, 469, 'Bronzani Majdan', 'BA', 'SRP'),
(10054, 28, 469, 'Čajniče', 'BA', 'SRP'),
(10055, 28, 469, 'Čečava', 'BA', 'SRP'),
(10056, 28, 469, 'Čelinac', 'BA', 'SRP'),
(10057, 28, 469, 'Derventa', 'BA', 'SRP'),
(10058, 28, 469, 'Doboj', 'BA', 'SRP'),
(10059, 28, 469, 'Dobrljin', 'BA', 'SRP'),
(10060, 28, 469, 'Dvorovi', 'BA', 'SRP'),
(10061, 28, 469, 'Foča', 'BA', 'SRP'),
(10062, 28, 469, 'Gacko', 'BA', 'SRP'),
(10063, 28, 469, 'Gradiška', 'BA', 'SRP'),
(10064, 28, 469, 'Hiseti', 'BA', 'SRP'),
(10065, 28, 469, 'Istočni Mostar', 'BA', 'SRP'),
(10066, 28, 469, 'Janja', 'BA', 'SRP'),
(10067, 28, 469, 'Kalenderovci Donji', 'BA', 'SRP'),
(10068, 28, 469, 'Kneževo', 'BA', 'SRP'),
(10069, 28, 469, 'Knežica', 'BA', 'SRP'),
(10070, 28, 469, 'Koran', 'BA', 'SRP'),
(10071, 28, 469, 'Kostajnica', 'BA', 'SRP'),
(10072, 28, 469, 'Kotor Varoš', 'BA', 'SRP'),
(10073, 28, 469, 'Kozarska Dubica', 'BA', 'SRP'),
(10074, 28, 469, 'Krupa na Vrbasu', 'BA', 'SRP'),
(10075, 28, 469, 'Laktaši', 'BA', 'SRP'),
(10076, 28, 469, 'Lamovita', 'BA', 'SRP'),
(10077, 28, 469, 'Ljubinje', 'BA', 'SRP'),
(10078, 28, 469, 'Lopare', 'BA', 'SRP'),
(10079, 28, 469, 'Maglajani', 'BA', 'SRP'),
(10080, 28, 469, 'Marićka', 'BA', 'SRP'),
(10081, 28, 469, 'Maslovare', 'BA', 'SRP'),
(10082, 28, 469, 'Mejdan - Obilićevo', 'BA', 'SRP'),
(10083, 28, 469, 'Milići', 'BA', 'SRP'),
(10084, 28, 469, 'Modriča', 'BA', 'SRP'),
(10085, 28, 469, 'Mrkonjić Grad', 'BA', 'SRP'),
(10086, 28, 469, 'Nevesinje', 'BA', 'SRP'),
(10087, 28, 469, 'Novi Grad', 'BA', 'SRP'),
(10088, 28, 469, 'Obudovac', 'BA', 'SRP'),
(10089, 28, 469, 'Omarska', 'BA', 'SRP'),
(10090, 28, 469, 'Opština Oštra Luka', 'BA', 'SRP'),
(10091, 28, 469, 'Opština Višegrad', 'BA', 'SRP'),
(10092, 28, 469, 'Oštra Luka', 'BA', 'SRP'),
(10093, 28, 469, 'Pale', 'BA', 'SRP'),
(10094, 28, 469, 'Pelagićevo', 'BA', 'SRP'),
(10095, 28, 469, 'Petkovci', 'BA', 'SRP'),
(10096, 28, 469, 'Piskavica', 'BA', 'SRP'),
(10097, 28, 469, 'Podbrdo', 'BA', 'SRP'),
(10098, 28, 469, 'Popovi', 'BA', 'SRP'),
(10099, 28, 469, 'Pribinić', 'BA', 'SRP'),
(10100, 28, 469, 'Priboj', 'BA', 'SRP'),
(10101, 28, 469, 'Prijedor', 'BA', 'SRP'),
(10102, 28, 469, 'Rogatica', 'BA', 'SRP'),
(10103, 28, 469, 'Rudo', 'BA', 'SRP'),
(10104, 28, 469, 'Šamac', 'BA', 'SRP'),
(10105, 28, 469, 'Šekovići', 'BA', 'SRP'),
(10106, 28, 469, 'Šipovo', 'BA', 'SRP'),
(10107, 28, 469, 'Sokolac', 'BA', 'SRP'),
(10108, 28, 469, 'Srbac', 'BA', 'SRP'),
(10109, 28, 469, 'Srebrenica', 'BA', 'SRP'),
(10110, 28, 469, 'Stanari', 'BA', 'SRP'),
(10111, 28, 469, 'Starcevica', 'BA', 'SRP'),
(10112, 28, 469, 'Svodna', 'BA', 'SRP'),
(10113, 28, 469, 'Teslić', 'BA', 'SRP'),
(10114, 28, 469, 'Trebinje', 'BA', 'SRP'),
(10115, 28, 469, 'Trn', 'BA', 'SRP'),
(10116, 28, 469, 'Ugljevik', 'BA', 'SRP'),
(10117, 28, 469, 'Velika Obarska', 'BA', 'SRP'),
(10118, 28, 469, 'Višegrad', 'BA', 'SRP'),
(10119, 28, 469, 'Vlasenica', 'BA', 'SRP'),
(10120, 28, 469, 'Živinice', 'BA', 'SRP'),
(10121, 28, 469, 'Zvornik', 'BA', 'SRP'),
(10122, 29, 475, 'Gobojango', 'BW', 'CE'),
(10123, 29, 475, 'Gweta', 'BW', 'CE'),
(10124, 29, 475, 'Kalamare', 'BW', 'CE'),
(10125, 29, 475, 'Letlhakane', 'BW', 'CE'),
(10126, 29, 475, 'Letsheng', 'BW', 'CE'),
(10127, 29, 475, 'Maapi', 'BW', 'CE'),
(10128, 29, 475, 'Machaneng', 'BW', 'CE'),
(10129, 29, 475, 'Mahalapye', 'BW', 'CE'),
(10130, 29, 475, 'Makobeng', 'BW', 'CE'),
(10131, 29, 475, 'Makwata', 'BW', 'CE'),
(10132, 29, 475, 'Mathakola', 'BW', 'CE'),
(10133, 29, 475, 'Mathambgwane', 'BW', 'CE'),
(10134, 29, 475, 'Mathathane', 'BW', 'CE'),
(10135, 29, 475, 'Maunatlala', 'BW', 'CE'),
(10136, 29, 475, 'Mogapi', 'BW', 'CE'),
(10137, 29, 475, 'Moijabana', 'BW', 'CE'),
(10138, 29, 475, 'Mookane', 'BW', 'CE'),
(10139, 29, 475, 'Mopipi', 'BW', 'CE'),
(10140, 29, 475, 'Mosetse', 'BW', 'CE'),
(10141, 29, 475, 'Nata', 'BW', 'CE'),
(10142, 29, 475, 'Orapa', 'BW', 'CE'),
(10143, 29, 475, 'Palapye', 'BW', 'CE'),
(10144, 29, 475, 'Pilikwe', 'BW', 'CE'),
(10145, 29, 475, 'Rakops', 'BW', 'CE'),
(10146, 29, 475, 'Ramokgonami', 'BW', 'CE'),
(10147, 29, 475, 'Ratholo', 'BW', 'CE'),
(10148, 29, 475, 'Sefophe', 'BW', 'CE'),
(10149, 29, 475, 'Serowe', 'BW', 'CE'),
(10150, 29, 475, 'Sua', 'BW', 'CE'),
(10151, 29, 475, 'Tamasane', 'BW', 'CE'),
(10152, 29, 475, 'Tobane', 'BW', 'CE'),
(10153, 29, 475, 'Tonota', 'BW', 'CE'),
(10154, 29, 476, 'Dekar', 'BW', 'GH'),
(10155, 29, 476, 'Ghanzi', 'BW', 'GH'),
(10156, 29, 477, 'Hukuntsi', 'BW', 'KG'),
(10157, 29, 477, 'Kang', 'BW', 'KG'),
(10158, 29, 477, 'Lehututu', 'BW', 'KG'),
(10159, 29, 477, 'Manyana', 'BW', 'KG'),
(10160, 29, 477, 'Tshabong', 'BW', 'KG'),
(10161, 29, 477, 'Werda', 'BW', 'KG'),
(10162, 29, 478, 'Bokaa', 'BW', 'KL'),
(10163, 29, 478, 'Mmathubudukwane', 'BW', 'KL'),
(10164, 29, 478, 'Mochudi', 'BW', 'KL'),
(10165, 29, 478, 'Pilane', 'BW', 'KL'),
(10166, 29, 479, 'Botlhapatlou', 'BW', 'KW'),
(10167, 29, 479, 'Dutlwe', 'BW', 'KW'),
(10168, 29, 479, 'Gabane', 'BW', 'KW'),
(10169, 29, 479, 'Gaphatshwe', 'BW', 'KW'),
(10170, 29, 479, 'Khudumelapye', 'BW', 'KW'),
(10171, 29, 479, 'Lenchwe Le Tau', 'BW', 'KW'),
(10172, 29, 479, 'Letlhakeng', 'BW', 'KW'),
(10173, 29, 479, 'Metsemotlhaba', 'BW', 'KW'),
(10174, 29, 479, 'Mmopone', 'BW', 'KW'),
(10175, 29, 479, 'Mogoditshane', 'BW', 'KW'),
(10176, 29, 479, 'Molepolole', 'BW', 'KW'),
(10177, 29, 479, 'Nkoyaphiri', 'BW', 'KW'),
(10178, 29, 479, 'Thamaga', 'BW', 'KW'),
(10179, 29, 481, 'Dukwe', 'BW', 'NE'),
(10180, 29, 481, 'Makaleng', 'BW', 'NE'),
(10181, 29, 481, 'Masunga', 'BW', 'NE'),
(10182, 29, 481, 'Sebina', 'BW', 'NE'),
(10183, 29, 482, 'Maun', 'BW', 'NW'),
(10184, 29, 482, 'Nokaneng', 'BW', 'NW'),
(10185, 29, 482, 'Pandamatenga', 'BW', 'NW'),
(10186, 29, 482, 'Sehithwa', 'BW', 'NW'),
(10187, 29, 482, 'Shakawe', 'BW', 'NW'),
(10188, 29, 483, 'Gaborone', 'BW', 'SE'),
(10189, 29, 483, 'Janeng', 'BW', 'SE'),
(10190, 29, 483, 'Kopong', 'BW', 'SE'),
(10191, 29, 483, 'Otse', 'BW', 'SE'),
(10192, 29, 483, 'Ramotswa', 'BW', 'SE'),
(10193, 29, 484, 'Kanye', 'BW', 'SO'),
(10194, 29, 484, 'Khakhea', 'BW', 'SO'),
(10195, 29, 484, 'Mosopa', 'BW', 'SO'),
(10196, 29, 484, 'Sekoma', 'BW', 'SO'),
(10197, 31, 485, 'Acrelândia', 'BR', 'AC'),
(10198, 31, 485, 'Assis Brasil', 'BR', 'AC'),
(10199, 31, 485, 'Brasiléia', 'BR', 'AC'),
(10200, 31, 485, 'Bujari', 'BR', 'AC'),
(10201, 31, 485, 'Capixaba', 'BR', 'AC'),
(10202, 31, 485, 'Cruzeiro do Sul', 'BR', 'AC'),
(10203, 31, 485, 'Epitaciolândia', 'BR', 'AC'),
(10204, 31, 485, 'Feijó', 'BR', 'AC'),
(10205, 31, 485, 'Jordão', 'BR', 'AC'),
(10206, 31, 485, 'Mâncio Lima', 'BR', 'AC'),
(10207, 31, 485, 'Manoel Urbano', 'BR', 'AC'),
(10208, 31, 485, 'Marechal Thaumaturgo', 'BR', 'AC'),
(10209, 31, 485, 'Plácido de Castro', 'BR', 'AC'),
(10210, 31, 485, 'Porto Acre', 'BR', 'AC'),
(10211, 31, 485, 'Porto Walter', 'BR', 'AC'),
(10212, 31, 485, 'Rio Branco', 'BR', 'AC'),
(10213, 31, 485, 'Rodrigues Alves', 'BR', 'AC'),
(10214, 31, 485, 'Santa Rosa do Purus', 'BR', 'AC'),
(10215, 31, 485, 'Sena Madureira', 'BR', 'AC'),
(10216, 31, 485, 'Senador Guiomard', 'BR', 'AC'),
(10217, 31, 485, 'Tarauacá', 'BR', 'AC'),
(10218, 31, 485, 'Xapuri', 'BR', 'AC'),
(10219, 31, 486, 'Água Branca', 'BR', 'AL'),
(10220, 31, 486, 'Anadia', 'BR', 'AL'),
(10221, 31, 486, 'Arapiraca', 'BR', 'AL'),
(10222, 31, 486, 'Atalaia', 'BR', 'AL'),
(10223, 31, 486, 'Barra de Santo Antônio', 'BR', 'AL'),
(10224, 31, 486, 'Barra de São Miguel', 'BR', 'AL'),
(10225, 31, 486, 'Batalha', 'BR', 'AL'),
(10226, 31, 486, 'Belém', 'BR', 'AL'),
(10227, 31, 486, 'Belo Monte', 'BR', 'AL'),
(10228, 31, 486, 'Boca da Mata', 'BR', 'AL'),
(10229, 31, 486, 'Branquinha', 'BR', 'AL'),
(10230, 31, 486, 'Cacimbinhas', 'BR', 'AL'),
(10231, 31, 486, 'Cajueiro', 'BR', 'AL'),
(10232, 31, 486, 'Campestre', 'BR', 'AL'),
(10233, 31, 486, 'Campo Alegre', 'BR', 'AL'),
(10234, 31, 486, 'Campo Grande', 'BR', 'AL'),
(10235, 31, 486, 'Canapi', 'BR', 'AL'),
(10236, 31, 486, 'Capela', 'BR', 'AL'),
(10237, 31, 486, 'Carneiros', 'BR', 'AL'),
(10238, 31, 486, 'Chã Preta', 'BR', 'AL'),
(10239, 31, 486, 'Coité do Nóia', 'BR', 'AL'),
(10240, 31, 486, 'Colônia Leopoldina', 'BR', 'AL'),
(10241, 31, 486, 'Coqueiro Seco', 'BR', 'AL'),
(10242, 31, 486, 'Coruripe', 'BR', 'AL'),
(10243, 31, 486, 'Craíbas', 'BR', 'AL'),
(10244, 31, 486, 'Delmiro Gouveia', 'BR', 'AL'),
(10245, 31, 486, 'Dois Riachos', 'BR', 'AL'),
(10246, 31, 486, 'Estrela de Alagoas', 'BR', 'AL'),
(10247, 31, 486, 'Feira Grande', 'BR', 'AL'),
(10248, 31, 486, 'Feliz Deserto', 'BR', 'AL'),
(10249, 31, 486, 'Flexeiras', 'BR', 'AL'),
(10250, 31, 486, 'Girau do Ponciano', 'BR', 'AL'),
(10251, 31, 486, 'Ibateguara', 'BR', 'AL'),
(10252, 31, 486, 'Igaci', 'BR', 'AL'),
(10253, 31, 486, 'Igreja Nova', 'BR', 'AL'),
(10254, 31, 486, 'Inhapi', 'BR', 'AL'),
(10255, 31, 486, 'Jacaré dos Homens', 'BR', 'AL'),
(10256, 31, 486, 'Jacuípe', 'BR', 'AL'),
(10257, 31, 486, 'Japaratinga', 'BR', 'AL'),
(10258, 31, 486, 'Jaramataia', 'BR', 'AL'),
(10259, 31, 486, 'Jequiá da Praia', 'BR', 'AL'),
(10260, 31, 486, 'Joaquim Gomes', 'BR', 'AL'),
(10261, 31, 486, 'Jundiá', 'BR', 'AL'),
(10262, 31, 486, 'Junqueiro', 'BR', 'AL'),
(10263, 31, 486, 'Lagoa da Canoa', 'BR', 'AL'),
(10264, 31, 486, 'Limoeiro de Anadia', 'BR', 'AL'),
(10265, 31, 486, 'Maceió', 'BR', 'AL'),
(10266, 31, 486, 'Major Isidoro', 'BR', 'AL'),
(10267, 31, 486, 'Mar Vermelho', 'BR', 'AL'),
(10268, 31, 486, 'Maragogi', 'BR', 'AL'),
(10269, 31, 486, 'Maravilha', 'BR', 'AL'),
(10270, 31, 486, 'Marechal Deodoro', 'BR', 'AL'),
(10271, 31, 486, 'Maribondo', 'BR', 'AL'),
(10272, 31, 486, 'Mata Grande', 'BR', 'AL'),
(10273, 31, 486, 'Matriz de Camaragibe', 'BR', 'AL'),
(10274, 31, 486, 'Messias', 'BR', 'AL'),
(10275, 31, 486, 'Minador do Negrão', 'BR', 'AL'),
(10276, 31, 486, 'Monteirópolis', 'BR', 'AL'),
(10277, 31, 486, 'Murici', 'BR', 'AL'),
(10278, 31, 486, 'Novo Lino', 'BR', 'AL'),
(10279, 31, 486, 'Olho d\'Água das Flores', 'BR', 'AL'),
(10280, 31, 486, 'Olho d\'Água do Casado', 'BR', 'AL'),
(10281, 31, 486, 'Olho d\'Água Grande', 'BR', 'AL'),
(10282, 31, 486, 'Olivença', 'BR', 'AL'),
(10283, 31, 486, 'Ouro Branco', 'BR', 'AL'),
(10284, 31, 486, 'Palestina', 'BR', 'AL'),
(10285, 31, 486, 'Palmeira dos Índios', 'BR', 'AL'),
(10286, 31, 486, 'Pão de Açúcar', 'BR', 'AL'),
(10287, 31, 486, 'Pariconha', 'BR', 'AL'),
(10288, 31, 486, 'Paripueira', 'BR', 'AL'),
(10289, 31, 486, 'Passo de Camaragibe', 'BR', 'AL'),
(10290, 31, 486, 'Paulo Jacinto', 'BR', 'AL'),
(10291, 31, 486, 'Penedo', 'BR', 'AL'),
(10292, 31, 486, 'Piaçabuçu', 'BR', 'AL'),
(10293, 31, 486, 'Pilar', 'BR', 'AL'),
(10294, 31, 486, 'Pindoba', 'BR', 'AL'),
(10295, 31, 486, 'Piranhas', 'BR', 'AL'),
(10296, 31, 486, 'Poço das Trincheiras', 'BR', 'AL'),
(10297, 31, 486, 'Porto Calvo', 'BR', 'AL'),
(10298, 31, 486, 'Porto de Pedras', 'BR', 'AL'),
(10299, 31, 486, 'Porto Real do Colégio', 'BR', 'AL'),
(10300, 31, 486, 'Quebrangulo', 'BR', 'AL'),
(10301, 31, 486, 'Rio Largo', 'BR', 'AL'),
(10302, 31, 486, 'Roteiro', 'BR', 'AL'),
(10303, 31, 486, 'Santa Luzia do Norte', 'BR', 'AL'),
(10304, 31, 486, 'Santana do Ipanema', 'BR', 'AL'),
(10305, 31, 486, 'Santana do Mundaú', 'BR', 'AL'),
(10306, 31, 486, 'São Brás', 'BR', 'AL'),
(10307, 31, 486, 'São José da Laje', 'BR', 'AL'),
(10308, 31, 486, 'São José da Tapera', 'BR', 'AL'),
(10309, 31, 486, 'São Luís do Quitunde', 'BR', 'AL'),
(10310, 31, 486, 'São Miguel dos Campos', 'BR', 'AL'),
(10311, 31, 486, 'São Miguel dos Milagres', 'BR', 'AL'),
(10312, 31, 486, 'São Sebastião', 'BR', 'AL'),
(10313, 31, 486, 'Satuba', 'BR', 'AL'),
(10314, 31, 486, 'Senador Rui Palmeira', 'BR', 'AL'),
(10315, 31, 486, 'Tanque d\'Arca', 'BR', 'AL'),
(10316, 31, 486, 'Taquarana', 'BR', 'AL'),
(10317, 31, 486, 'Teotônio Vilela', 'BR', 'AL'),
(10318, 31, 486, 'Traipu', 'BR', 'AL'),
(10319, 31, 486, 'União dos Palmares', 'BR', 'AL'),
(10320, 31, 486, 'Viçosa', 'BR', 'AL'),
(10321, 31, 487, 'Amapá', 'BR', 'AP'),
(10322, 31, 487, 'Calçoene', 'BR', 'AP'),
(10323, 31, 487, 'Cutias', 'BR', 'AP'),
(10324, 31, 487, 'Ferreira Gomes', 'BR', 'AP'),
(10325, 31, 487, 'Itaubal', 'BR', 'AP'),
(10326, 31, 487, 'Laranjal do Jari', 'BR', 'AP'),
(10327, 31, 487, 'Macapá', 'BR', 'AP'),
(10328, 31, 487, 'Mazagão', 'BR', 'AP'),
(10329, 31, 487, 'Oiapoque', 'BR', 'AP'),
(10330, 31, 487, 'Pedra Branca do Amapari', 'BR', 'AP'),
(10331, 31, 487, 'Porto Grande', 'BR', 'AP'),
(10332, 31, 487, 'Pracuúba', 'BR', 'AP'),
(10333, 31, 487, 'Santana', 'BR', 'AP'),
(10334, 31, 487, 'Serra do Navio', 'BR', 'AP'),
(10335, 31, 487, 'Tartarugalzinho', 'BR', 'AP'),
(10336, 31, 487, 'Vitória do Jari', 'BR', 'AP'),
(10337, 31, 488, 'Alvarães', 'BR', 'AM'),
(10338, 31, 488, 'Amaturá', 'BR', 'AM'),
(10339, 31, 488, 'Anamã', 'BR', 'AM'),
(10340, 31, 488, 'Anori', 'BR', 'AM'),
(10341, 31, 488, 'Apuí', 'BR', 'AM'),
(10342, 31, 488, 'Atalaia do Norte', 'BR', 'AM'),
(10343, 31, 488, 'Autazes', 'BR', 'AM'),
(10344, 31, 488, 'Barcelos', 'BR', 'AM'),
(10345, 31, 488, 'Barreirinha', 'BR', 'AM'),
(10346, 31, 488, 'Benjamin Constant', 'BR', 'AM'),
(10347, 31, 488, 'Beruri', 'BR', 'AM'),
(10348, 31, 488, 'Boa Vista do Ramos', 'BR', 'AM'),
(10349, 31, 488, 'Boca do Acre', 'BR', 'AM'),
(10350, 31, 488, 'Borba', 'BR', 'AM'),
(10351, 31, 488, 'Caapiranga', 'BR', 'AM'),
(10352, 31, 488, 'Canutama', 'BR', 'AM'),
(10353, 31, 488, 'Carauari', 'BR', 'AM'),
(10354, 31, 488, 'Careiro', 'BR', 'AM'),
(10355, 31, 488, 'Careiro da Várzea', 'BR', 'AM'),
(10356, 31, 488, 'Coari', 'BR', 'AM'),
(10357, 31, 488, 'Codajás', 'BR', 'AM'),
(10358, 31, 488, 'Eirunepé', 'BR', 'AM'),
(10359, 31, 488, 'Envira', 'BR', 'AM'),
(10360, 31, 488, 'Fonte Boa', 'BR', 'AM'),
(10361, 31, 488, 'Guajará', 'BR', 'AM'),
(10362, 31, 488, 'Humaitá', 'BR', 'AM'),
(10363, 31, 488, 'Ipixuna', 'BR', 'AM'),
(10364, 31, 488, 'Iranduba', 'BR', 'AM'),
(10365, 31, 488, 'Itacoatiara', 'BR', 'AM'),
(10366, 31, 488, 'Itamarati', 'BR', 'AM'),
(10367, 31, 488, 'Itapiranga', 'BR', 'AM'),
(10368, 31, 488, 'Japurá', 'BR', 'AM'),
(10369, 31, 488, 'Juruá', 'BR', 'AM'),
(10370, 31, 488, 'Jutaí', 'BR', 'AM'),
(10371, 31, 488, 'Lábrea', 'BR', 'AM'),
(10372, 31, 488, 'Manacapuru', 'BR', 'AM'),
(10373, 31, 488, 'Manaquiri', 'BR', 'AM'),
(10374, 31, 488, 'Manaus', 'BR', 'AM'),
(10375, 31, 488, 'Manicoré', 'BR', 'AM'),
(10376, 31, 488, 'Maraã', 'BR', 'AM'),
(10377, 31, 488, 'Maués', 'BR', 'AM'),
(10378, 31, 488, 'Nhamundá', 'BR', 'AM'),
(10379, 31, 488, 'Nova Olinda do Norte', 'BR', 'AM'),
(10380, 31, 488, 'Novo Airão', 'BR', 'AM'),
(10381, 31, 488, 'Novo Aripuanã', 'BR', 'AM'),
(10382, 31, 488, 'Parintins', 'BR', 'AM'),
(10383, 31, 488, 'Pauini', 'BR', 'AM'),
(10384, 31, 488, 'Presidente Figueiredo', 'BR', 'AM'),
(10385, 31, 488, 'Rio Preto da Eva', 'BR', 'AM'),
(10386, 31, 488, 'Santa Isabel do Rio Negro', 'BR', 'AM'),
(10387, 31, 488, 'Santo Antônio do Içá', 'BR', 'AM'),
(10388, 31, 488, 'São Gabriel da Cachoeira', 'BR', 'AM'),
(10389, 31, 488, 'São Paulo de Olivença', 'BR', 'AM'),
(10390, 31, 488, 'São Sebastião do Uatumã', 'BR', 'AM'),
(10391, 31, 488, 'Silves', 'BR', 'AM'),
(10392, 31, 488, 'Tabatinga', 'BR', 'AM'),
(10393, 31, 488, 'Tapauá', 'BR', 'AM'),
(10394, 31, 488, 'Tefé', 'BR', 'AM'),
(10395, 31, 488, 'Tonantins', 'BR', 'AM'),
(10396, 31, 488, 'Uarini', 'BR', 'AM'),
(10397, 31, 488, 'Urucará', 'BR', 'AM'),
(10398, 31, 488, 'Urucurituba', 'BR', 'AM'),
(10399, 31, 489, 'Abaíra', 'BR', 'BA'),
(10400, 31, 489, 'Abaré', 'BR', 'BA'),
(10401, 31, 489, 'Acajutiba', 'BR', 'BA'),
(10402, 31, 489, 'Adustina', 'BR', 'BA'),
(10403, 31, 489, 'Água Fria', 'BR', 'BA'),
(10404, 31, 489, 'Aiquara', 'BR', 'BA'),
(10405, 31, 489, 'Alagoinhas', 'BR', 'BA'),
(10406, 31, 489, 'Alcobaça', 'BR', 'BA'),
(10407, 31, 489, 'Almadina', 'BR', 'BA'),
(10408, 31, 489, 'Amargosa', 'BR', 'BA'),
(10409, 31, 489, 'Amélia Rodrigues', 'BR', 'BA'),
(10410, 31, 489, 'América Dourada', 'BR', 'BA'),
(10411, 31, 489, 'Anagé', 'BR', 'BA'),
(10412, 31, 489, 'Andaraí', 'BR', 'BA'),
(10413, 31, 489, 'Andorinha', 'BR', 'BA'),
(10414, 31, 489, 'Angical', 'BR', 'BA'),
(10415, 31, 489, 'Anguera', 'BR', 'BA'),
(10416, 31, 489, 'Antas', 'BR', 'BA'),
(10417, 31, 489, 'Antônio Cardoso', 'BR', 'BA'),
(10418, 31, 489, 'Antônio Gonçalves', 'BR', 'BA'),
(10419, 31, 489, 'Aporá', 'BR', 'BA'),
(10420, 31, 489, 'Apuarema', 'BR', 'BA'),
(10421, 31, 489, 'Araçás', 'BR', 'BA'),
(10422, 31, 489, 'Aracatu', 'BR', 'BA'),
(10423, 31, 489, 'Araci', 'BR', 'BA'),
(10424, 31, 489, 'Aramari', 'BR', 'BA'),
(10425, 31, 489, 'Arataca', 'BR', 'BA'),
(10426, 31, 489, 'Aratuípe', 'BR', 'BA'),
(10427, 31, 489, 'Aurelino Leal', 'BR', 'BA'),
(10428, 31, 489, 'Baianópolis', 'BR', 'BA'),
(10429, 31, 489, 'Baixa Grande', 'BR', 'BA'),
(10430, 31, 489, 'Banzaê', 'BR', 'BA'),
(10431, 31, 489, 'Barra', 'BR', 'BA'),
(10432, 31, 489, 'Barra da Estiva', 'BR', 'BA'),
(10433, 31, 489, 'Barra do Choça', 'BR', 'BA'),
(10434, 31, 489, 'Barra do Mendes', 'BR', 'BA'),
(10435, 31, 489, 'Barra do Rocha', 'BR', 'BA'),
(10436, 31, 489, 'Barreiras', 'BR', 'BA'),
(10437, 31, 489, 'Barro Alto', 'BR', 'BA'),
(10438, 31, 489, 'Barro Preto', 'BR', 'BA'),
(10439, 31, 489, 'Barrocas', 'BR', 'BA'),
(10440, 31, 489, 'Beira Rio', 'BR', 'BA'),
(10441, 31, 489, 'Belmonte', 'BR', 'BA'),
(10442, 31, 489, 'Belo Campo', 'BR', 'BA'),
(10443, 31, 489, 'Biritinga', 'BR', 'BA'),
(10444, 31, 489, 'Boa Nova', 'BR', 'BA'),
(10445, 31, 489, 'Boa Vista do Tupim', 'BR', 'BA'),
(10446, 31, 489, 'Bom Jesus da Lapa', 'BR', 'BA'),
(10447, 31, 489, 'Bom Jesus da Serra', 'BR', 'BA'),
(10448, 31, 489, 'Boninal', 'BR', 'BA'),
(10449, 31, 489, 'Bonito', 'BR', 'BA'),
(10450, 31, 489, 'Boquira', 'BR', 'BA'),
(10451, 31, 489, 'Botuporã', 'BR', 'BA'),
(10452, 31, 489, 'Brejões', 'BR', 'BA'),
(10453, 31, 489, 'Brejolândia', 'BR', 'BA'),
(10454, 31, 489, 'Brotas de Macaúbas', 'BR', 'BA'),
(10455, 31, 489, 'Brumado', 'BR', 'BA'),
(10456, 31, 489, 'Buerarema', 'BR', 'BA'),
(10457, 31, 489, 'Buritirama', 'BR', 'BA'),
(10458, 31, 489, 'Caatiba', 'BR', 'BA'),
(10459, 31, 489, 'Cabaceiras do Paraguaçu', 'BR', 'BA'),
(10460, 31, 489, 'Cachoeira', 'BR', 'BA'),
(10461, 31, 489, 'Caculé', 'BR', 'BA'),
(10462, 31, 489, 'Caém', 'BR', 'BA'),
(10463, 31, 489, 'Caetanos', 'BR', 'BA'),
(10464, 31, 489, 'Caetité', 'BR', 'BA'),
(10465, 31, 489, 'Cafarnaum', 'BR', 'BA'),
(10466, 31, 489, 'Cairu', 'BR', 'BA'),
(10467, 31, 489, 'Caldeirão Grande', 'BR', 'BA'),
(10468, 31, 489, 'Camacan', 'BR', 'BA'),
(10469, 31, 489, 'Camaçari', 'BR', 'BA'),
(10470, 31, 489, 'Camamu', 'BR', 'BA'),
(10471, 31, 489, 'Campo Alegre de Lourdes', 'BR', 'BA'),
(10472, 31, 489, 'Campo Formoso', 'BR', 'BA'),
(10473, 31, 489, 'Canápolis', 'BR', 'BA'),
(10474, 31, 489, 'Canarana', 'BR', 'BA'),
(10475, 31, 489, 'Canavieiras', 'BR', 'BA'),
(10476, 31, 489, 'Candeal', 'BR', 'BA'),
(10477, 31, 489, 'Candeias', 'BR', 'BA'),
(10478, 31, 489, 'Candiba', 'BR', 'BA'),
(10479, 31, 489, 'Cândido Sales', 'BR', 'BA'),
(10480, 31, 489, 'Cansanção', 'BR', 'BA'),
(10481, 31, 489, 'Canudos', 'BR', 'BA'),
(10482, 31, 489, 'Capela do Alto Alegre', 'BR', 'BA'),
(10483, 31, 489, 'Capim Grosso', 'BR', 'BA'),
(10484, 31, 489, 'Caraíbas', 'BR', 'BA'),
(10485, 31, 489, 'Caravelas', 'BR', 'BA'),
(10486, 31, 489, 'Cardeal da Silva', 'BR', 'BA'),
(10487, 31, 489, 'Carinhanha', 'BR', 'BA'),
(10488, 31, 489, 'Casa Nova', 'BR', 'BA'),
(10489, 31, 489, 'Castro Alves', 'BR', 'BA'),
(10490, 31, 489, 'Catolândia', 'BR', 'BA'),
(10491, 31, 489, 'Catu', 'BR', 'BA'),
(10492, 31, 489, 'Caturama', 'BR', 'BA'),
(10493, 31, 489, 'Central', 'BR', 'BA'),
(10494, 31, 489, 'Chorrochó', 'BR', 'BA'),
(10495, 31, 489, 'Cícero Dantas', 'BR', 'BA'),
(10496, 31, 489, 'Cipó', 'BR', 'BA'),
(10497, 31, 489, 'Coaraci', 'BR', 'BA'),
(10498, 31, 489, 'Cocos', 'BR', 'BA'),
(10499, 31, 489, 'Conceição da Feira', 'BR', 'BA'),
(10500, 31, 489, 'Conceição do Almeida', 'BR', 'BA');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(10501, 31, 489, 'Conceição do Coité', 'BR', 'BA'),
(10502, 31, 489, 'Conceição do Jacuípe', 'BR', 'BA'),
(10503, 31, 489, 'Conde', 'BR', 'BA'),
(10504, 31, 489, 'Condeúba', 'BR', 'BA'),
(10505, 31, 489, 'Contendas do Sincorá', 'BR', 'BA'),
(10506, 31, 489, 'Coração de Maria', 'BR', 'BA'),
(10507, 31, 489, 'Cordeiros', 'BR', 'BA'),
(10508, 31, 489, 'Coribe', 'BR', 'BA'),
(10509, 31, 489, 'Coronel João Sá', 'BR', 'BA'),
(10510, 31, 489, 'Correntina', 'BR', 'BA'),
(10511, 31, 489, 'Cotegipe', 'BR', 'BA'),
(10512, 31, 489, 'Cravolândia', 'BR', 'BA'),
(10513, 31, 489, 'Crisópolis', 'BR', 'BA'),
(10514, 31, 489, 'Cristópolis', 'BR', 'BA'),
(10515, 31, 489, 'Cruz das Almas', 'BR', 'BA'),
(10516, 31, 489, 'Curaçá', 'BR', 'BA'),
(10517, 31, 489, 'Dário Meira', 'BR', 'BA'),
(10518, 31, 489, 'Dias d\'Ávila', 'BR', 'BA'),
(10519, 31, 489, 'Dom Basílio', 'BR', 'BA'),
(10520, 31, 489, 'Dom Macedo Costa', 'BR', 'BA'),
(10521, 31, 489, 'Elísio Medrado', 'BR', 'BA'),
(10522, 31, 489, 'Encruzilhada', 'BR', 'BA'),
(10523, 31, 489, 'Entre Rios', 'BR', 'BA'),
(10524, 31, 489, 'Érico Cardoso', 'BR', 'BA'),
(10525, 31, 489, 'Esplanada', 'BR', 'BA'),
(10526, 31, 489, 'Euclides da Cunha', 'BR', 'BA'),
(10527, 31, 489, 'Eunápolis', 'BR', 'BA'),
(10528, 31, 489, 'Fátima', 'BR', 'BA'),
(10529, 31, 489, 'Feira da Mata', 'BR', 'BA'),
(10530, 31, 489, 'Feira de Santana', 'BR', 'BA'),
(10531, 31, 489, 'Filadélfia', 'BR', 'BA'),
(10532, 31, 489, 'Firmino Alves', 'BR', 'BA'),
(10533, 31, 489, 'Floresta Azul', 'BR', 'BA'),
(10534, 31, 489, 'Formosa do Rio Preto', 'BR', 'BA'),
(10535, 31, 489, 'Gandu', 'BR', 'BA'),
(10536, 31, 489, 'Gavião', 'BR', 'BA'),
(10537, 31, 489, 'Gentio do Ouro', 'BR', 'BA'),
(10538, 31, 489, 'Glória', 'BR', 'BA'),
(10539, 31, 489, 'Gongogi', 'BR', 'BA'),
(10540, 31, 489, 'Governador Mangabeira', 'BR', 'BA'),
(10541, 31, 489, 'Guajeru', 'BR', 'BA'),
(10542, 31, 489, 'Guanambi', 'BR', 'BA'),
(10543, 31, 489, 'Guaratinga', 'BR', 'BA'),
(10544, 31, 489, 'Heliópolis', 'BR', 'BA'),
(10545, 31, 489, 'Iaçu', 'BR', 'BA'),
(10546, 31, 489, 'Ibiassucê', 'BR', 'BA'),
(10547, 31, 489, 'Ibicaraí', 'BR', 'BA'),
(10548, 31, 489, 'Ibicoara', 'BR', 'BA'),
(10549, 31, 489, 'Ibicuí', 'BR', 'BA'),
(10550, 31, 489, 'Ibipeba', 'BR', 'BA'),
(10551, 31, 489, 'Ibipitanga', 'BR', 'BA'),
(10552, 31, 489, 'Ibiquera', 'BR', 'BA'),
(10553, 31, 489, 'Ibirapitanga', 'BR', 'BA'),
(10554, 31, 489, 'Ibirapuã', 'BR', 'BA'),
(10555, 31, 489, 'Ibirataia', 'BR', 'BA'),
(10556, 31, 489, 'Ibitiara', 'BR', 'BA'),
(10557, 31, 489, 'Ibititá', 'BR', 'BA'),
(10558, 31, 489, 'Ibotirama', 'BR', 'BA'),
(10559, 31, 489, 'Ichu', 'BR', 'BA'),
(10560, 31, 489, 'Igaporã', 'BR', 'BA'),
(10561, 31, 489, 'Igrapiúna', 'BR', 'BA'),
(10562, 31, 489, 'Iguaí', 'BR', 'BA'),
(10563, 31, 489, 'Ilhéus', 'BR', 'BA'),
(10564, 31, 489, 'Inhambupe', 'BR', 'BA'),
(10565, 31, 489, 'Ipecaetá', 'BR', 'BA'),
(10566, 31, 489, 'Ipiaú', 'BR', 'BA'),
(10567, 31, 489, 'Ipirá', 'BR', 'BA'),
(10568, 31, 489, 'Ipupiara', 'BR', 'BA'),
(10569, 31, 489, 'Irajuba', 'BR', 'BA'),
(10570, 31, 489, 'Iramaia', 'BR', 'BA'),
(10571, 31, 489, 'Iraquara', 'BR', 'BA'),
(10572, 31, 489, 'Irará', 'BR', 'BA'),
(10573, 31, 489, 'Irecê', 'BR', 'BA'),
(10574, 31, 489, 'Itabela', 'BR', 'BA'),
(10575, 31, 489, 'Itaberaba', 'BR', 'BA'),
(10576, 31, 489, 'Itabuna', 'BR', 'BA'),
(10577, 31, 489, 'Itacaré', 'BR', 'BA'),
(10578, 31, 489, 'Itaeté', 'BR', 'BA'),
(10579, 31, 489, 'Itagi', 'BR', 'BA'),
(10580, 31, 489, 'Itagibá', 'BR', 'BA'),
(10581, 31, 489, 'Itagimirim', 'BR', 'BA'),
(10582, 31, 489, 'Itaguaçu da Bahia', 'BR', 'BA'),
(10583, 31, 489, 'Itaju do Colônia', 'BR', 'BA'),
(10584, 31, 489, 'Itajuípe', 'BR', 'BA'),
(10585, 31, 489, 'Itamaraju', 'BR', 'BA'),
(10586, 31, 489, 'Itamari', 'BR', 'BA'),
(10587, 31, 489, 'Itambé', 'BR', 'BA'),
(10588, 31, 489, 'Itanagra', 'BR', 'BA'),
(10589, 31, 489, 'Itanhém', 'BR', 'BA'),
(10590, 31, 489, 'Itaparica', 'BR', 'BA'),
(10591, 31, 489, 'Itapé', 'BR', 'BA'),
(10592, 31, 489, 'Itapebi', 'BR', 'BA'),
(10593, 31, 489, 'Itapetinga', 'BR', 'BA'),
(10594, 31, 489, 'Itapicuru', 'BR', 'BA'),
(10595, 31, 489, 'Itapitanga', 'BR', 'BA'),
(10596, 31, 489, 'Itaquara', 'BR', 'BA'),
(10597, 31, 489, 'Itarantim', 'BR', 'BA'),
(10598, 31, 489, 'Itatim', 'BR', 'BA'),
(10599, 31, 489, 'Itiruçu', 'BR', 'BA'),
(10600, 31, 489, 'Itiúba', 'BR', 'BA'),
(10601, 31, 489, 'Itororó', 'BR', 'BA'),
(10602, 31, 489, 'Ituaçu', 'BR', 'BA'),
(10603, 31, 489, 'Ituberá', 'BR', 'BA'),
(10604, 31, 489, 'Iuiu', 'BR', 'BA'),
(10605, 31, 489, 'Jaborandi', 'BR', 'BA'),
(10606, 31, 489, 'Jacaraci', 'BR', 'BA'),
(10607, 31, 489, 'Jacobina', 'BR', 'BA'),
(10608, 31, 489, 'Jaguaquara', 'BR', 'BA'),
(10609, 31, 489, 'Jaguarari', 'BR', 'BA'),
(10610, 31, 489, 'Jaguaripe', 'BR', 'BA'),
(10611, 31, 489, 'Jandaíra', 'BR', 'BA'),
(10612, 31, 489, 'Jequié', 'BR', 'BA'),
(10613, 31, 489, 'Jeremoabo', 'BR', 'BA'),
(10614, 31, 489, 'Jiquiriçá', 'BR', 'BA'),
(10615, 31, 489, 'Jitaúna', 'BR', 'BA'),
(10616, 31, 489, 'João Dourado', 'BR', 'BA'),
(10617, 31, 489, 'Juazeiro', 'BR', 'BA'),
(10618, 31, 489, 'Jucuruçu', 'BR', 'BA'),
(10619, 31, 489, 'Jussara', 'BR', 'BA'),
(10620, 31, 489, 'Jussari', 'BR', 'BA'),
(10621, 31, 489, 'Jussiape', 'BR', 'BA'),
(10622, 31, 489, 'Lafaiete Coutinho', 'BR', 'BA'),
(10623, 31, 489, 'Lagoa Real', 'BR', 'BA'),
(10624, 31, 489, 'Laje', 'BR', 'BA'),
(10625, 31, 489, 'Lajedão', 'BR', 'BA'),
(10626, 31, 489, 'Lajedinho', 'BR', 'BA'),
(10627, 31, 489, 'Lajedo do Tabocal', 'BR', 'BA'),
(10628, 31, 489, 'Lamarão', 'BR', 'BA'),
(10629, 31, 489, 'Lapão', 'BR', 'BA'),
(10630, 31, 489, 'Lauro de Freitas', 'BR', 'BA'),
(10631, 31, 489, 'Lençóis', 'BR', 'BA'),
(10632, 31, 489, 'Licínio de Almeida', 'BR', 'BA'),
(10633, 31, 489, 'Livramento de Nossa Senhora', 'BR', 'BA'),
(10634, 31, 489, 'Livramento do Brumado', 'BR', 'BA'),
(10635, 31, 489, 'Luís Eduardo Magalhães', 'BR', 'BA'),
(10636, 31, 489, 'Macajuba', 'BR', 'BA'),
(10637, 31, 489, 'Macarani', 'BR', 'BA'),
(10638, 31, 489, 'Macaúbas', 'BR', 'BA'),
(10639, 31, 489, 'Macururé', 'BR', 'BA'),
(10640, 31, 489, 'Madre de Deus', 'BR', 'BA'),
(10641, 31, 489, 'Maetinga', 'BR', 'BA'),
(10642, 31, 489, 'Maiquinique', 'BR', 'BA'),
(10643, 31, 489, 'Mairi', 'BR', 'BA'),
(10644, 31, 489, 'Malhada', 'BR', 'BA'),
(10645, 31, 489, 'Malhada de Pedras', 'BR', 'BA'),
(10646, 31, 489, 'Manoel Vitorino', 'BR', 'BA'),
(10647, 31, 489, 'Mansidão', 'BR', 'BA'),
(10648, 31, 489, 'Maracás', 'BR', 'BA'),
(10649, 31, 489, 'Maragogipe', 'BR', 'BA'),
(10650, 31, 489, 'Maraú', 'BR', 'BA'),
(10651, 31, 489, 'Marcionílio Souza', 'BR', 'BA'),
(10652, 31, 489, 'Mascote', 'BR', 'BA'),
(10653, 31, 489, 'Mata de São João', 'BR', 'BA'),
(10654, 31, 489, 'Matina', 'BR', 'BA'),
(10655, 31, 489, 'Medeiros Neto', 'BR', 'BA'),
(10656, 31, 489, 'Miguel Calmon', 'BR', 'BA'),
(10657, 31, 489, 'Milagres', 'BR', 'BA'),
(10658, 31, 489, 'Mirangaba', 'BR', 'BA'),
(10659, 31, 489, 'Mirante', 'BR', 'BA'),
(10660, 31, 489, 'Monte Santo', 'BR', 'BA'),
(10661, 31, 489, 'Morpará', 'BR', 'BA'),
(10662, 31, 489, 'Morro do Chapéu', 'BR', 'BA'),
(10663, 31, 489, 'Mortugaba', 'BR', 'BA'),
(10664, 31, 489, 'Mucugê', 'BR', 'BA'),
(10665, 31, 489, 'Mucuri', 'BR', 'BA'),
(10666, 31, 489, 'Mulungu do Morro', 'BR', 'BA'),
(10667, 31, 489, 'Mundo Novo', 'BR', 'BA'),
(10668, 31, 489, 'Muniz Ferreira', 'BR', 'BA'),
(10669, 31, 489, 'Muquém do São Francisco', 'BR', 'BA'),
(10670, 31, 489, 'Muritiba', 'BR', 'BA'),
(10671, 31, 489, 'Mutuípe', 'BR', 'BA'),
(10672, 31, 489, 'Nazaré', 'BR', 'BA'),
(10673, 31, 489, 'Nilo Peçanha', 'BR', 'BA'),
(10674, 31, 489, 'Nordestina', 'BR', 'BA'),
(10675, 31, 489, 'Nova Canaã', 'BR', 'BA'),
(10676, 31, 489, 'Nova Fátima', 'BR', 'BA'),
(10677, 31, 489, 'Nova Ibiá', 'BR', 'BA'),
(10678, 31, 489, 'Nova Itarana', 'BR', 'BA'),
(10679, 31, 489, 'Nova Redenção', 'BR', 'BA'),
(10680, 31, 489, 'Nova Soure', 'BR', 'BA'),
(10681, 31, 489, 'Nova Viçosa', 'BR', 'BA'),
(10682, 31, 489, 'Novo Horizonte', 'BR', 'BA'),
(10683, 31, 489, 'Novo Triunfo', 'BR', 'BA'),
(10684, 31, 489, 'Olindina', 'BR', 'BA'),
(10685, 31, 489, 'Oliveira dos Brejinhos', 'BR', 'BA'),
(10686, 31, 489, 'Ouriçangas', 'BR', 'BA'),
(10687, 31, 489, 'Ourolândia', 'BR', 'BA'),
(10688, 31, 489, 'Palmas de Monte Alto', 'BR', 'BA'),
(10689, 31, 489, 'Palmeiras', 'BR', 'BA'),
(10690, 31, 489, 'Paramirim', 'BR', 'BA'),
(10691, 31, 489, 'Paratinga', 'BR', 'BA'),
(10692, 31, 489, 'Paripiranga', 'BR', 'BA'),
(10693, 31, 489, 'Pau Brasil', 'BR', 'BA'),
(10694, 31, 489, 'Paulo Afonso', 'BR', 'BA'),
(10695, 31, 489, 'Pé de Serra', 'BR', 'BA'),
(10696, 31, 489, 'Pedrão', 'BR', 'BA'),
(10697, 31, 489, 'Pedro Alexandre', 'BR', 'BA'),
(10698, 31, 489, 'Piatã', 'BR', 'BA'),
(10699, 31, 489, 'Pilão Arcado', 'BR', 'BA'),
(10700, 31, 489, 'Pindaí', 'BR', 'BA'),
(10701, 31, 489, 'Pindobaçu', 'BR', 'BA'),
(10702, 31, 489, 'Pintadas', 'BR', 'BA'),
(10703, 31, 489, 'Piraí do Norte', 'BR', 'BA'),
(10704, 31, 489, 'Piripá', 'BR', 'BA'),
(10705, 31, 489, 'Piritiba', 'BR', 'BA'),
(10706, 31, 489, 'Planaltino', 'BR', 'BA'),
(10707, 31, 489, 'Planalto', 'BR', 'BA'),
(10708, 31, 489, 'Poções', 'BR', 'BA'),
(10709, 31, 489, 'Pojuca', 'BR', 'BA'),
(10710, 31, 489, 'Ponto Novo', 'BR', 'BA'),
(10711, 31, 489, 'Porto Seguro', 'BR', 'BA'),
(10712, 31, 489, 'Posto da Mata', 'BR', 'BA'),
(10713, 31, 489, 'Potiraguá', 'BR', 'BA'),
(10714, 31, 489, 'Prado', 'BR', 'BA'),
(10715, 31, 489, 'Presidente Dutra', 'BR', 'BA'),
(10716, 31, 489, 'Presidente Jânio Quadros', 'BR', 'BA'),
(10717, 31, 489, 'Presidente Tancredo Neves', 'BR', 'BA'),
(10718, 31, 489, 'Queimadas', 'BR', 'BA'),
(10719, 31, 489, 'Quijingue', 'BR', 'BA'),
(10720, 31, 489, 'Quixabeira', 'BR', 'BA'),
(10721, 31, 489, 'Rafael Jambeiro', 'BR', 'BA'),
(10722, 31, 489, 'Remanso', 'BR', 'BA'),
(10723, 31, 489, 'Retirolândia', 'BR', 'BA'),
(10724, 31, 489, 'Riachão das Neves', 'BR', 'BA'),
(10725, 31, 489, 'Riachão do Jacuípe', 'BR', 'BA'),
(10726, 31, 489, 'Riacho de Santana', 'BR', 'BA'),
(10727, 31, 489, 'Ribeira do Amparo', 'BR', 'BA'),
(10728, 31, 489, 'Ribeira do Pombal', 'BR', 'BA'),
(10729, 31, 489, 'Ribeirão do Largo', 'BR', 'BA'),
(10730, 31, 489, 'Rio de Contas', 'BR', 'BA'),
(10731, 31, 489, 'Rio do Antônio', 'BR', 'BA'),
(10732, 31, 489, 'Rio do Pires', 'BR', 'BA'),
(10733, 31, 489, 'Rio Real', 'BR', 'BA'),
(10734, 31, 489, 'Rodelas', 'BR', 'BA'),
(10735, 31, 489, 'Ruy Barbosa', 'BR', 'BA'),
(10736, 31, 489, 'Salinas da Margarida', 'BR', 'BA'),
(10737, 31, 489, 'Salvador', 'BR', 'BA'),
(10738, 31, 489, 'Santa Bárbara', 'BR', 'BA'),
(10739, 31, 489, 'Santa Brígida', 'BR', 'BA'),
(10740, 31, 489, 'Santa Cruz Cabrália', 'BR', 'BA'),
(10741, 31, 489, 'Santa Cruz da Vitória', 'BR', 'BA'),
(10742, 31, 489, 'Santa Inês', 'BR', 'BA'),
(10743, 31, 489, 'Santa Luzia', 'BR', 'BA'),
(10744, 31, 489, 'Santa Maria da Vitória', 'BR', 'BA'),
(10745, 31, 489, 'Santa Rita de Cássia', 'BR', 'BA'),
(10746, 31, 489, 'Santa Terezinha', 'BR', 'BA'),
(10747, 31, 489, 'Santaluz', 'BR', 'BA'),
(10748, 31, 489, 'Santana', 'BR', 'BA'),
(10749, 31, 489, 'Santanópolis', 'BR', 'BA'),
(10750, 31, 489, 'Santo Amaro', 'BR', 'BA'),
(10751, 31, 489, 'Santo Antônio de Jesus', 'BR', 'BA'),
(10752, 31, 489, 'Santo Estêvão', 'BR', 'BA'),
(10753, 31, 489, 'São Desidério', 'BR', 'BA'),
(10754, 31, 489, 'São Domingos', 'BR', 'BA'),
(10755, 31, 489, 'São Felipe', 'BR', 'BA'),
(10756, 31, 489, 'São Félix', 'BR', 'BA'),
(10757, 31, 489, 'São Félix do Coribe', 'BR', 'BA'),
(10758, 31, 489, 'São Francisco do Conde', 'BR', 'BA'),
(10759, 31, 489, 'São Gabriel', 'BR', 'BA'),
(10760, 31, 489, 'São Gonçalo dos Campos', 'BR', 'BA'),
(10761, 31, 489, 'São José da Vitória', 'BR', 'BA'),
(10762, 31, 489, 'São José do Jacuípe', 'BR', 'BA'),
(10763, 31, 489, 'São Miguel das Matas', 'BR', 'BA'),
(10764, 31, 489, 'São Sebastião do Passé', 'BR', 'BA'),
(10765, 31, 489, 'Sapeaçu', 'BR', 'BA'),
(10766, 31, 489, 'Sátiro Dias', 'BR', 'BA'),
(10767, 31, 489, 'Saubara', 'BR', 'BA'),
(10768, 31, 489, 'Saúde', 'BR', 'BA'),
(10769, 31, 489, 'Seabra', 'BR', 'BA'),
(10770, 31, 489, 'Sebastião Laranjeiras', 'BR', 'BA'),
(10771, 31, 489, 'Senhor do Bonfim', 'BR', 'BA'),
(10772, 31, 489, 'Sento Sé', 'BR', 'BA'),
(10773, 31, 489, 'Serra do Ramalho', 'BR', 'BA'),
(10774, 31, 489, 'Serra Dourada', 'BR', 'BA'),
(10775, 31, 489, 'Serra Preta', 'BR', 'BA'),
(10776, 31, 489, 'Serrinha', 'BR', 'BA'),
(10777, 31, 489, 'Serrolândia', 'BR', 'BA'),
(10778, 31, 489, 'Simões Filho', 'BR', 'BA'),
(10779, 31, 489, 'Sítio do Mato', 'BR', 'BA'),
(10780, 31, 489, 'Sítio do Quinto', 'BR', 'BA'),
(10781, 31, 489, 'Sobradinho', 'BR', 'BA'),
(10782, 31, 489, 'Souto Soares', 'BR', 'BA'),
(10783, 31, 489, 'Tabocas do Brejo Velho', 'BR', 'BA'),
(10784, 31, 489, 'Tanhaçu', 'BR', 'BA'),
(10785, 31, 489, 'Tanque Novo', 'BR', 'BA'),
(10786, 31, 489, 'Tanquinho', 'BR', 'BA'),
(10787, 31, 489, 'Taperoá', 'BR', 'BA'),
(10788, 31, 489, 'Tapiramutá', 'BR', 'BA'),
(10789, 31, 489, 'Teixeira de Freitas', 'BR', 'BA'),
(10790, 31, 489, 'Teodoro Sampaio', 'BR', 'BA'),
(10791, 31, 489, 'Teofilândia', 'BR', 'BA'),
(10792, 31, 489, 'Teolândia', 'BR', 'BA'),
(10793, 31, 489, 'Terra Nova', 'BR', 'BA'),
(10794, 31, 489, 'Tremedal', 'BR', 'BA'),
(10795, 31, 489, 'Tucano', 'BR', 'BA'),
(10796, 31, 489, 'Uauá', 'BR', 'BA'),
(10797, 31, 489, 'Ubaíra', 'BR', 'BA'),
(10798, 31, 489, 'Ubaitaba', 'BR', 'BA'),
(10799, 31, 489, 'Ubatã', 'BR', 'BA'),
(10800, 31, 489, 'Uibaí', 'BR', 'BA'),
(10801, 31, 489, 'Umburanas', 'BR', 'BA'),
(10802, 31, 489, 'Una', 'BR', 'BA'),
(10803, 31, 489, 'Urandi', 'BR', 'BA'),
(10804, 31, 489, 'Uruçuca', 'BR', 'BA'),
(10805, 31, 489, 'Utinga', 'BR', 'BA'),
(10806, 31, 489, 'Valença', 'BR', 'BA'),
(10807, 31, 489, 'Valente', 'BR', 'BA'),
(10808, 31, 489, 'Várzea da Roça', 'BR', 'BA'),
(10809, 31, 489, 'Várzea do Poço', 'BR', 'BA'),
(10810, 31, 489, 'Várzea Nova', 'BR', 'BA'),
(10811, 31, 489, 'Varzedo', 'BR', 'BA'),
(10812, 31, 489, 'Vera Cruz', 'BR', 'BA'),
(10813, 31, 489, 'Vereda', 'BR', 'BA'),
(10814, 31, 489, 'Vitória da Conquista', 'BR', 'BA'),
(10815, 31, 489, 'Wagner', 'BR', 'BA'),
(10816, 31, 489, 'Wanderley', 'BR', 'BA'),
(10817, 31, 489, 'Wenceslau Guimarães', 'BR', 'BA'),
(10818, 31, 489, 'Xique Xique', 'BR', 'BA'),
(10819, 31, 489, 'Xique-Xique', 'BR', 'BA'),
(10820, 31, 490, 'Abaiara', 'BR', 'CE'),
(10821, 31, 490, 'Acarape', 'BR', 'CE'),
(10822, 31, 490, 'Acaraú', 'BR', 'CE'),
(10823, 31, 490, 'Acopiara', 'BR', 'CE'),
(10824, 31, 490, 'Aiuaba', 'BR', 'CE'),
(10825, 31, 490, 'Alcântaras', 'BR', 'CE'),
(10826, 31, 490, 'Altaneira', 'BR', 'CE'),
(10827, 31, 490, 'Alto Santo', 'BR', 'CE'),
(10828, 31, 490, 'Amontada', 'BR', 'CE'),
(10829, 31, 490, 'Antonina do Norte', 'BR', 'CE'),
(10830, 31, 490, 'Apuiarés', 'BR', 'CE'),
(10831, 31, 490, 'Aquiraz', 'BR', 'CE'),
(10832, 31, 490, 'Aracati', 'BR', 'CE'),
(10833, 31, 490, 'Aracoiaba', 'BR', 'CE'),
(10834, 31, 490, 'Ararendá', 'BR', 'CE'),
(10835, 31, 490, 'Araripe', 'BR', 'CE'),
(10836, 31, 490, 'Aratuba', 'BR', 'CE'),
(10837, 31, 490, 'Arneiroz', 'BR', 'CE'),
(10838, 31, 490, 'Assaré', 'BR', 'CE'),
(10839, 31, 490, 'Aurora', 'BR', 'CE'),
(10840, 31, 490, 'Baixio', 'BR', 'CE'),
(10841, 31, 490, 'Banabuiú', 'BR', 'CE'),
(10842, 31, 490, 'Barbalha', 'BR', 'CE'),
(10843, 31, 490, 'Barreira', 'BR', 'CE'),
(10844, 31, 490, 'Barro', 'BR', 'CE'),
(10845, 31, 490, 'Barroquinha', 'BR', 'CE'),
(10846, 31, 490, 'Baturité', 'BR', 'CE'),
(10847, 31, 490, 'Beberibe', 'BR', 'CE'),
(10848, 31, 490, 'Bela Cruz', 'BR', 'CE'),
(10849, 31, 490, 'Boa Viagem', 'BR', 'CE'),
(10850, 31, 490, 'Brejo Santo', 'BR', 'CE'),
(10851, 31, 490, 'Camocim', 'BR', 'CE'),
(10852, 31, 490, 'Campos Sales', 'BR', 'CE'),
(10853, 31, 490, 'Canindé', 'BR', 'CE'),
(10854, 31, 490, 'Capistrano', 'BR', 'CE'),
(10855, 31, 490, 'Caridade', 'BR', 'CE'),
(10856, 31, 490, 'Cariré', 'BR', 'CE'),
(10857, 31, 490, 'Caririaçu', 'BR', 'CE'),
(10858, 31, 490, 'Cariús', 'BR', 'CE'),
(10859, 31, 490, 'Carnaubal', 'BR', 'CE'),
(10860, 31, 490, 'Cascavel', 'BR', 'CE'),
(10861, 31, 490, 'Catarina', 'BR', 'CE'),
(10862, 31, 490, 'Catunda', 'BR', 'CE'),
(10863, 31, 490, 'Caucaia', 'BR', 'CE'),
(10864, 31, 490, 'Cedro', 'BR', 'CE'),
(10865, 31, 490, 'Chaval', 'BR', 'CE'),
(10866, 31, 490, 'Choró', 'BR', 'CE'),
(10867, 31, 490, 'Chorozinho', 'BR', 'CE'),
(10868, 31, 490, 'Coreaú', 'BR', 'CE'),
(10869, 31, 490, 'Crateús', 'BR', 'CE'),
(10870, 31, 490, 'Crato', 'BR', 'CE'),
(10871, 31, 490, 'Croatá', 'BR', 'CE'),
(10872, 31, 490, 'Cruz', 'BR', 'CE'),
(10873, 31, 490, 'Deputado Irapuan Pinheiro', 'BR', 'CE'),
(10874, 31, 490, 'Ererê', 'BR', 'CE'),
(10875, 31, 490, 'Eusébio', 'BR', 'CE'),
(10876, 31, 490, 'Farias Brito', 'BR', 'CE'),
(10877, 31, 490, 'Forquilha', 'BR', 'CE'),
(10878, 31, 490, 'Fortaleza', 'BR', 'CE'),
(10879, 31, 490, 'Fortim', 'BR', 'CE'),
(10880, 31, 490, 'Frecheirinha', 'BR', 'CE'),
(10881, 31, 490, 'General Sampaio', 'BR', 'CE'),
(10882, 31, 490, 'Graça', 'BR', 'CE'),
(10883, 31, 490, 'Granja', 'BR', 'CE'),
(10884, 31, 490, 'Granjeiro', 'BR', 'CE'),
(10885, 31, 490, 'Groaíras', 'BR', 'CE'),
(10886, 31, 490, 'Guaiúba', 'BR', 'CE'),
(10887, 31, 490, 'Guaraciaba do Norte', 'BR', 'CE'),
(10888, 31, 490, 'Guaramiranga', 'BR', 'CE'),
(10889, 31, 490, 'Hidrolândia', 'BR', 'CE'),
(10890, 31, 490, 'Horizonte', 'BR', 'CE'),
(10891, 31, 490, 'Ibaretama', 'BR', 'CE'),
(10892, 31, 490, 'Ibiapina', 'BR', 'CE'),
(10893, 31, 490, 'Ibicuitinga', 'BR', 'CE'),
(10894, 31, 490, 'Icapuí', 'BR', 'CE'),
(10895, 31, 490, 'Icó', 'BR', 'CE'),
(10896, 31, 490, 'Iguatu', 'BR', 'CE'),
(10897, 31, 490, 'Independência', 'BR', 'CE'),
(10898, 31, 490, 'Ipaporanga', 'BR', 'CE'),
(10899, 31, 490, 'Ipaumirim', 'BR', 'CE'),
(10900, 31, 490, 'Ipu', 'BR', 'CE'),
(10901, 31, 490, 'Ipueiras', 'BR', 'CE'),
(10902, 31, 490, 'Iracema', 'BR', 'CE'),
(10903, 31, 490, 'Irauçuba', 'BR', 'CE'),
(10904, 31, 490, 'Itaiçaba', 'BR', 'CE'),
(10905, 31, 490, 'Itaitinga', 'BR', 'CE'),
(10906, 31, 490, 'Itapagé', 'BR', 'CE'),
(10907, 31, 490, 'Itapajé', 'BR', 'CE'),
(10908, 31, 490, 'Itapipoca', 'BR', 'CE'),
(10909, 31, 490, 'Itapiúna', 'BR', 'CE'),
(10910, 31, 490, 'Itarema', 'BR', 'CE'),
(10911, 31, 490, 'Itatira', 'BR', 'CE'),
(10912, 31, 490, 'Jaguaretama', 'BR', 'CE'),
(10913, 31, 490, 'Jaguaribara', 'BR', 'CE'),
(10914, 31, 490, 'Jaguaribe', 'BR', 'CE'),
(10915, 31, 490, 'Jaguaruana', 'BR', 'CE'),
(10916, 31, 490, 'Jardim', 'BR', 'CE'),
(10917, 31, 490, 'Jati', 'BR', 'CE'),
(10918, 31, 490, 'Jijoca de Jericoacoara', 'BR', 'CE'),
(10919, 31, 490, 'Juá dos Vieiras', 'BR', 'CE'),
(10920, 31, 490, 'Juazeiro do Norte', 'BR', 'CE'),
(10921, 31, 490, 'Jucás', 'BR', 'CE'),
(10922, 31, 490, 'Lavras da Mangabeira', 'BR', 'CE'),
(10923, 31, 490, 'Limoeiro do Norte', 'BR', 'CE'),
(10924, 31, 490, 'Madalena', 'BR', 'CE'),
(10925, 31, 490, 'Maracanaú', 'BR', 'CE'),
(10926, 31, 490, 'Maranguape', 'BR', 'CE'),
(10927, 31, 490, 'Marco', 'BR', 'CE'),
(10928, 31, 490, 'Martinópole', 'BR', 'CE'),
(10929, 31, 490, 'Massapê', 'BR', 'CE'),
(10930, 31, 490, 'Mauriti', 'BR', 'CE'),
(10931, 31, 490, 'Meruoca', 'BR', 'CE'),
(10932, 31, 490, 'Milagres', 'BR', 'CE'),
(10933, 31, 490, 'Milhã', 'BR', 'CE'),
(10934, 31, 490, 'Miraíma', 'BR', 'CE'),
(10935, 31, 490, 'Missão Velha', 'BR', 'CE'),
(10936, 31, 490, 'Mombaça', 'BR', 'CE'),
(10937, 31, 490, 'Monsenhor Tabosa', 'BR', 'CE'),
(10938, 31, 490, 'Morada Nova', 'BR', 'CE'),
(10939, 31, 490, 'Moraújo', 'BR', 'CE'),
(10940, 31, 490, 'Morrinhos', 'BR', 'CE'),
(10941, 31, 490, 'Mucambo', 'BR', 'CE'),
(10942, 31, 490, 'Mulungu', 'BR', 'CE'),
(10943, 31, 490, 'Nova Olinda', 'BR', 'CE'),
(10944, 31, 490, 'Nova Russas', 'BR', 'CE'),
(10945, 31, 490, 'Novo Oriente', 'BR', 'CE'),
(10946, 31, 490, 'Ocara', 'BR', 'CE'),
(10947, 31, 490, 'Orós', 'BR', 'CE'),
(10948, 31, 490, 'Pacajus', 'BR', 'CE'),
(10949, 31, 490, 'Pacatuba', 'BR', 'CE'),
(10950, 31, 490, 'Pacoti', 'BR', 'CE'),
(10951, 31, 490, 'Pacujá', 'BR', 'CE'),
(10952, 31, 490, 'Palhano', 'BR', 'CE'),
(10953, 31, 490, 'Palmácia', 'BR', 'CE'),
(10954, 31, 490, 'Paracuru', 'BR', 'CE'),
(10955, 31, 490, 'Paraipaba', 'BR', 'CE'),
(10956, 31, 490, 'Parambu', 'BR', 'CE'),
(10957, 31, 490, 'Paramoti', 'BR', 'CE'),
(10958, 31, 490, 'Pedra Branca', 'BR', 'CE'),
(10959, 31, 490, 'Penaforte', 'BR', 'CE'),
(10960, 31, 490, 'Pentecoste', 'BR', 'CE'),
(10961, 31, 490, 'Pereiro', 'BR', 'CE'),
(10962, 31, 490, 'Pindoretama', 'BR', 'CE'),
(10963, 31, 490, 'Piquet Carneiro', 'BR', 'CE'),
(10964, 31, 490, 'Pires Ferreira', 'BR', 'CE'),
(10965, 31, 490, 'Poranga', 'BR', 'CE'),
(10966, 31, 490, 'Porteiras', 'BR', 'CE'),
(10967, 31, 490, 'Potengi', 'BR', 'CE'),
(10968, 31, 490, 'Potiretama', 'BR', 'CE'),
(10969, 31, 490, 'Quiterianópolis', 'BR', 'CE'),
(10970, 31, 490, 'Quixadá', 'BR', 'CE'),
(10971, 31, 490, 'Quixelô', 'BR', 'CE'),
(10972, 31, 490, 'Quixeramobim', 'BR', 'CE'),
(10973, 31, 490, 'Quixeré', 'BR', 'CE'),
(10974, 31, 490, 'Redenção', 'BR', 'CE'),
(10975, 31, 490, 'Reriutaba', 'BR', 'CE'),
(10976, 31, 490, 'Russas', 'BR', 'CE'),
(10977, 31, 490, 'Saboeiro', 'BR', 'CE'),
(10978, 31, 490, 'Salitre', 'BR', 'CE'),
(10979, 31, 490, 'Santa Quitéria', 'BR', 'CE'),
(10980, 31, 490, 'Santana do Acaraú', 'BR', 'CE'),
(10981, 31, 490, 'Santana do Cariri', 'BR', 'CE'),
(10982, 31, 490, 'São Benedito', 'BR', 'CE'),
(10983, 31, 490, 'São Gonçalo do Amarante', 'BR', 'CE'),
(10984, 31, 490, 'São João do Jaguaribe', 'BR', 'CE'),
(10985, 31, 490, 'São João dos Inhamuns', 'BR', 'CE'),
(10986, 31, 490, 'São Luís do Curu', 'BR', 'CE'),
(10987, 31, 490, 'Senador Pompeu', 'BR', 'CE'),
(10988, 31, 490, 'Senador Sá', 'BR', 'CE'),
(10989, 31, 490, 'Sobral', 'BR', 'CE'),
(10990, 31, 490, 'Solonópole', 'BR', 'CE'),
(10991, 31, 490, 'Tabuleiro do Norte', 'BR', 'CE'),
(10992, 31, 490, 'Tamboril', 'BR', 'CE'),
(10993, 31, 490, 'Tarrafas', 'BR', 'CE'),
(10994, 31, 490, 'Tauá', 'BR', 'CE'),
(10995, 31, 490, 'Tejuçuoca', 'BR', 'CE'),
(10996, 31, 490, 'Tianguá', 'BR', 'CE'),
(10997, 31, 490, 'Trairi', 'BR', 'CE'),
(10998, 31, 490, 'Tururu', 'BR', 'CE'),
(10999, 31, 490, 'Ubajara', 'BR', 'CE'),
(11000, 31, 490, 'Umari', 'BR', 'CE');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(11001, 31, 490, 'Umirim', 'BR', 'CE'),
(11002, 31, 490, 'Uruburetama', 'BR', 'CE'),
(11003, 31, 490, 'Uruoca', 'BR', 'CE'),
(11004, 31, 490, 'Varjota', 'BR', 'CE'),
(11005, 31, 490, 'Várzea Alegre', 'BR', 'CE'),
(11006, 31, 490, 'Viçosa do Ceará', 'BR', 'CE'),
(11007, 31, 491, 'Brasília', 'BR', 'DF'),
(11008, 31, 491, 'Planaltina', 'BR', 'DF'),
(11009, 31, 492, 'Afonso Cláudio', 'BR', 'ES'),
(11010, 31, 492, 'Água Doce do Norte', 'BR', 'ES'),
(11011, 31, 492, 'Águia Branca', 'BR', 'ES'),
(11012, 31, 492, 'Alegre', 'BR', 'ES'),
(11013, 31, 492, 'Alfredo Chaves', 'BR', 'ES'),
(11014, 31, 492, 'Alto Rio Novo', 'BR', 'ES'),
(11015, 31, 492, 'Anchieta', 'BR', 'ES'),
(11016, 31, 492, 'Apiacá', 'BR', 'ES'),
(11017, 31, 492, 'Aracruz', 'BR', 'ES'),
(11018, 31, 492, 'Atílio Vivacqua', 'BR', 'ES'),
(11019, 31, 492, 'Baixo Guandu', 'BR', 'ES'),
(11020, 31, 492, 'Barra de São Francisco', 'BR', 'ES'),
(11021, 31, 492, 'Boa Esperança', 'BR', 'ES'),
(11022, 31, 492, 'Bom Jesus do Norte', 'BR', 'ES'),
(11023, 31, 492, 'Brejetuba', 'BR', 'ES'),
(11024, 31, 492, 'Cachoeiro de Itapemirim', 'BR', 'ES'),
(11025, 31, 492, 'Cariacica', 'BR', 'ES'),
(11026, 31, 492, 'Castelo', 'BR', 'ES'),
(11027, 31, 492, 'Colatina', 'BR', 'ES'),
(11028, 31, 492, 'Conceição da Barra', 'BR', 'ES'),
(11029, 31, 492, 'Conceição do Castelo', 'BR', 'ES'),
(11030, 31, 492, 'Divino de São Lourenço', 'BR', 'ES'),
(11031, 31, 492, 'Domingos Martins', 'BR', 'ES'),
(11032, 31, 492, 'Dores do Rio Preto', 'BR', 'ES'),
(11033, 31, 492, 'Ecoporanga', 'BR', 'ES'),
(11034, 31, 492, 'Fundão', 'BR', 'ES'),
(11035, 31, 492, 'Governador Lindenberg', 'BR', 'ES'),
(11036, 31, 492, 'Guaçuí', 'BR', 'ES'),
(11037, 31, 492, 'Guarapari', 'BR', 'ES'),
(11038, 31, 492, 'Ibatiba', 'BR', 'ES'),
(11039, 31, 492, 'Ibiraçu', 'BR', 'ES'),
(11040, 31, 492, 'Ibitirama', 'BR', 'ES'),
(11041, 31, 492, 'Iconha', 'BR', 'ES'),
(11042, 31, 492, 'Irupi', 'BR', 'ES'),
(11043, 31, 492, 'Itaguaçu', 'BR', 'ES'),
(11044, 31, 492, 'Itapemirim', 'BR', 'ES'),
(11045, 31, 492, 'Itarana', 'BR', 'ES'),
(11046, 31, 492, 'Iúna', 'BR', 'ES'),
(11047, 31, 492, 'Jaguaré', 'BR', 'ES'),
(11048, 31, 492, 'Jerônimo Monteiro', 'BR', 'ES'),
(11049, 31, 492, 'Jetibá', 'BR', 'ES'),
(11050, 31, 492, 'João Neiva', 'BR', 'ES'),
(11051, 31, 492, 'Laranja da Terra', 'BR', 'ES'),
(11052, 31, 492, 'Linhares', 'BR', 'ES'),
(11053, 31, 492, 'Mantenópolis', 'BR', 'ES'),
(11054, 31, 492, 'Marataizes', 'BR', 'ES'),
(11055, 31, 492, 'Marechal Floriano', 'BR', 'ES'),
(11056, 31, 492, 'Marilândia', 'BR', 'ES'),
(11057, 31, 492, 'Mimoso do Sul', 'BR', 'ES'),
(11058, 31, 492, 'Montanha', 'BR', 'ES'),
(11059, 31, 492, 'Mucurici', 'BR', 'ES'),
(11060, 31, 492, 'Muniz Freire', 'BR', 'ES'),
(11061, 31, 492, 'Muqui', 'BR', 'ES'),
(11062, 31, 492, 'Nova Venécia', 'BR', 'ES'),
(11063, 31, 492, 'Pancas', 'BR', 'ES'),
(11064, 31, 492, 'Pedro Canário', 'BR', 'ES'),
(11065, 31, 492, 'Pinheiros', 'BR', 'ES'),
(11066, 31, 492, 'Piúma', 'BR', 'ES'),
(11067, 31, 492, 'Ponto Belo', 'BR', 'ES'),
(11068, 31, 492, 'Presidente Kennedy', 'BR', 'ES'),
(11069, 31, 492, 'Rio Bananal', 'BR', 'ES'),
(11070, 31, 492, 'Rio Novo do Sul', 'BR', 'ES'),
(11071, 31, 492, 'Santa Leopoldina', 'BR', 'ES'),
(11072, 31, 492, 'Santa Maria de Jetibá', 'BR', 'ES'),
(11073, 31, 492, 'Santa Teresa', 'BR', 'ES'),
(11074, 31, 492, 'São Domingos do Norte', 'BR', 'ES'),
(11075, 31, 492, 'São Gabriel da Palha', 'BR', 'ES'),
(11076, 31, 492, 'São José do Calçado', 'BR', 'ES'),
(11077, 31, 492, 'São Mateus', 'BR', 'ES'),
(11078, 31, 492, 'São Roque do Canaã', 'BR', 'ES'),
(11079, 31, 492, 'Serra', 'BR', 'ES'),
(11080, 31, 492, 'Sooretama', 'BR', 'ES'),
(11081, 31, 492, 'Vargem Alta', 'BR', 'ES'),
(11082, 31, 492, 'Venda Nova do Imigrante', 'BR', 'ES'),
(11083, 31, 492, 'Viana', 'BR', 'ES'),
(11084, 31, 492, 'Vila Pavão', 'BR', 'ES'),
(11085, 31, 492, 'Vila Valério', 'BR', 'ES'),
(11086, 31, 492, 'Vila Velha', 'BR', 'ES'),
(11087, 31, 492, 'Vitória', 'BR', 'ES'),
(11088, 31, 493, 'Abadia de Goiás', 'BR', 'GO'),
(11089, 31, 493, 'Abadiânia', 'BR', 'GO'),
(11090, 31, 493, 'Acreúna', 'BR', 'GO'),
(11091, 31, 493, 'Adelândia', 'BR', 'GO'),
(11092, 31, 493, 'Água Fria de Goiás', 'BR', 'GO'),
(11093, 31, 493, 'Água Limpa', 'BR', 'GO'),
(11094, 31, 493, 'Águas Lindas de Goiás', 'BR', 'GO'),
(11095, 31, 493, 'Alexânia', 'BR', 'GO'),
(11096, 31, 493, 'Aloândia', 'BR', 'GO'),
(11097, 31, 493, 'Alto Horizonte', 'BR', 'GO'),
(11098, 31, 493, 'Alto Paraíso de Goiás', 'BR', 'GO'),
(11099, 31, 493, 'Alvorada do Norte', 'BR', 'GO'),
(11100, 31, 493, 'Amaralina', 'BR', 'GO'),
(11101, 31, 493, 'Americano do Brasil', 'BR', 'GO'),
(11102, 31, 493, 'Amorinópolis', 'BR', 'GO'),
(11103, 31, 493, 'Anápolis', 'BR', 'GO'),
(11104, 31, 493, 'Anhanguera', 'BR', 'GO'),
(11105, 31, 493, 'Anicuns', 'BR', 'GO'),
(11106, 31, 493, 'Aparecida de Goiânia', 'BR', 'GO'),
(11107, 31, 493, 'Aparecida do Rio Doce', 'BR', 'GO'),
(11108, 31, 493, 'Aporé', 'BR', 'GO'),
(11109, 31, 493, 'Araçu', 'BR', 'GO'),
(11110, 31, 493, 'Aragarças', 'BR', 'GO'),
(11111, 31, 493, 'Aragoiânia', 'BR', 'GO'),
(11112, 31, 493, 'Araguapaz', 'BR', 'GO'),
(11113, 31, 493, 'Arenópolis', 'BR', 'GO'),
(11114, 31, 493, 'Aruanã', 'BR', 'GO'),
(11115, 31, 493, 'Aurilândia', 'BR', 'GO'),
(11116, 31, 493, 'Avelinópolis', 'BR', 'GO'),
(11117, 31, 493, 'Baliza', 'BR', 'GO'),
(11118, 31, 493, 'Barro Alto', 'BR', 'GO'),
(11119, 31, 493, 'Bela Vista de Goiás', 'BR', 'GO'),
(11120, 31, 493, 'Bom Jardim de Goiás', 'BR', 'GO'),
(11121, 31, 493, 'Bom Jesus de Goiás', 'BR', 'GO'),
(11122, 31, 493, 'Bonfinópolis', 'BR', 'GO'),
(11123, 31, 493, 'Bonópolis', 'BR', 'GO'),
(11124, 31, 493, 'Brazabrantes', 'BR', 'GO'),
(11125, 31, 493, 'Britânia', 'BR', 'GO'),
(11126, 31, 493, 'Buriti Alegre', 'BR', 'GO'),
(11127, 31, 493, 'Buriti de Goiás', 'BR', 'GO'),
(11128, 31, 493, 'Buritinópolis', 'BR', 'GO'),
(11129, 31, 493, 'Cabeceiras', 'BR', 'GO'),
(11130, 31, 493, 'Cachoeira Alta', 'BR', 'GO'),
(11131, 31, 493, 'Cachoeira de Goiás', 'BR', 'GO'),
(11132, 31, 493, 'Cachoeira Dourada', 'BR', 'GO'),
(11133, 31, 493, 'Caçu', 'BR', 'GO'),
(11134, 31, 493, 'Caiapônia', 'BR', 'GO'),
(11135, 31, 493, 'Caldas Novas', 'BR', 'GO'),
(11136, 31, 493, 'Caldazinha', 'BR', 'GO'),
(11137, 31, 493, 'Campestre de Goiás', 'BR', 'GO'),
(11138, 31, 493, 'Campinaçu', 'BR', 'GO'),
(11139, 31, 493, 'Campinorte', 'BR', 'GO'),
(11140, 31, 493, 'Campo Alegre de Goiás', 'BR', 'GO'),
(11141, 31, 493, 'Campo Limpo de Goiás', 'BR', 'GO'),
(11142, 31, 493, 'Campos Belos', 'BR', 'GO'),
(11143, 31, 493, 'Campos Verdes', 'BR', 'GO'),
(11144, 31, 493, 'Carmo do Rio Verde', 'BR', 'GO'),
(11145, 31, 493, 'Castelândia', 'BR', 'GO'),
(11146, 31, 493, 'Catalão', 'BR', 'GO'),
(11147, 31, 493, 'Caturaí', 'BR', 'GO'),
(11148, 31, 493, 'Cavalcante', 'BR', 'GO'),
(11149, 31, 493, 'Ceres', 'BR', 'GO'),
(11150, 31, 493, 'Cezarina', 'BR', 'GO'),
(11151, 31, 493, 'Chapadão do Céu', 'BR', 'GO'),
(11152, 31, 493, 'Cidade Ocidental', 'BR', 'GO'),
(11153, 31, 493, 'Cocalzinho de Goiás', 'BR', 'GO'),
(11154, 31, 493, 'Colinas do Sul', 'BR', 'GO'),
(11155, 31, 493, 'Córrego do Ouro', 'BR', 'GO'),
(11156, 31, 493, 'Corumbá de Goiás', 'BR', 'GO'),
(11157, 31, 493, 'Corumbaíba', 'BR', 'GO'),
(11158, 31, 493, 'Cristalina', 'BR', 'GO'),
(11159, 31, 493, 'Cristianópolis', 'BR', 'GO'),
(11160, 31, 493, 'Crixás', 'BR', 'GO'),
(11161, 31, 493, 'Cromínia', 'BR', 'GO'),
(11162, 31, 493, 'Cumari', 'BR', 'GO'),
(11163, 31, 493, 'Damianópolis', 'BR', 'GO'),
(11164, 31, 493, 'Damolândia', 'BR', 'GO'),
(11165, 31, 493, 'Davinópolis', 'BR', 'GO'),
(11166, 31, 493, 'Diorama', 'BR', 'GO'),
(11167, 31, 493, 'Divinópolis de Goiás', 'BR', 'GO'),
(11168, 31, 493, 'Doverlândia', 'BR', 'GO'),
(11169, 31, 493, 'Edealina', 'BR', 'GO'),
(11170, 31, 493, 'Edéia', 'BR', 'GO'),
(11171, 31, 493, 'Estrela do Norte', 'BR', 'GO'),
(11172, 31, 493, 'Faina', 'BR', 'GO'),
(11173, 31, 493, 'Fazenda Nova', 'BR', 'GO'),
(11174, 31, 493, 'Firminópolis', 'BR', 'GO'),
(11175, 31, 493, 'Flores de Goiás', 'BR', 'GO'),
(11176, 31, 493, 'Formosa', 'BR', 'GO'),
(11177, 31, 493, 'Formoso', 'BR', 'GO'),
(11178, 31, 493, 'Gameleira de Goiás', 'BR', 'GO'),
(11179, 31, 493, 'Goianápolis', 'BR', 'GO'),
(11180, 31, 493, 'Goiandira', 'BR', 'GO'),
(11181, 31, 493, 'Goianésia', 'BR', 'GO'),
(11182, 31, 493, 'Goiânia', 'BR', 'GO'),
(11183, 31, 493, 'Goianira', 'BR', 'GO'),
(11184, 31, 493, 'Goiás', 'BR', 'GO'),
(11185, 31, 493, 'Goiatuba', 'BR', 'GO'),
(11186, 31, 493, 'Gouvelândia', 'BR', 'GO'),
(11187, 31, 493, 'Guapó', 'BR', 'GO'),
(11188, 31, 493, 'Guaraíta', 'BR', 'GO'),
(11189, 31, 493, 'Guarani de Goiás', 'BR', 'GO'),
(11190, 31, 493, 'Guarinos', 'BR', 'GO'),
(11191, 31, 493, 'Heitoraí', 'BR', 'GO'),
(11192, 31, 493, 'Hidrolândia', 'BR', 'GO'),
(11193, 31, 493, 'Hidrolina', 'BR', 'GO'),
(11194, 31, 493, 'Iaciara', 'BR', 'GO'),
(11195, 31, 493, 'Inaciolândia', 'BR', 'GO'),
(11196, 31, 493, 'Indiara', 'BR', 'GO'),
(11197, 31, 493, 'Inhumas', 'BR', 'GO'),
(11198, 31, 493, 'Ipameri', 'BR', 'GO'),
(11199, 31, 493, 'Ipiranga de Goiás', 'BR', 'GO'),
(11200, 31, 493, 'Iporá', 'BR', 'GO'),
(11201, 31, 493, 'Israelândia', 'BR', 'GO'),
(11202, 31, 493, 'Itaberaí', 'BR', 'GO'),
(11203, 31, 493, 'Itaguari', 'BR', 'GO'),
(11204, 31, 493, 'Itaguaru', 'BR', 'GO'),
(11205, 31, 493, 'Itajá', 'BR', 'GO'),
(11206, 31, 493, 'Itapaci', 'BR', 'GO'),
(11207, 31, 493, 'Itapirapuã', 'BR', 'GO'),
(11208, 31, 493, 'Itapuranga', 'BR', 'GO'),
(11209, 31, 493, 'Itarumã', 'BR', 'GO'),
(11210, 31, 493, 'Itauçu', 'BR', 'GO'),
(11211, 31, 493, 'Itumbiara', 'BR', 'GO'),
(11212, 31, 493, 'Ivolândia', 'BR', 'GO'),
(11213, 31, 493, 'Jandaia', 'BR', 'GO'),
(11214, 31, 493, 'Jaraguá', 'BR', 'GO'),
(11215, 31, 493, 'Jataí', 'BR', 'GO'),
(11216, 31, 493, 'Jaupaci', 'BR', 'GO'),
(11217, 31, 493, 'Jesúpolis', 'BR', 'GO'),
(11218, 31, 493, 'Joviânia', 'BR', 'GO'),
(11219, 31, 493, 'Jussara', 'BR', 'GO'),
(11220, 31, 493, 'Lagoa Santa', 'BR', 'GO'),
(11221, 31, 493, 'Leopoldo de Bulhões', 'BR', 'GO'),
(11222, 31, 493, 'Luziânia', 'BR', 'GO'),
(11223, 31, 493, 'Mairipotaba', 'BR', 'GO'),
(11224, 31, 493, 'Mambaí', 'BR', 'GO'),
(11225, 31, 493, 'Mara Rosa', 'BR', 'GO'),
(11226, 31, 493, 'Marzagão', 'BR', 'GO'),
(11227, 31, 493, 'Matrinchã', 'BR', 'GO'),
(11228, 31, 493, 'Maurilândia', 'BR', 'GO'),
(11229, 31, 493, 'Mimoso de Goiás', 'BR', 'GO'),
(11230, 31, 493, 'Minaçu', 'BR', 'GO'),
(11231, 31, 493, 'Mineiros', 'BR', 'GO'),
(11232, 31, 493, 'Moiporá', 'BR', 'GO'),
(11233, 31, 493, 'Monte Alegre de Goiás', 'BR', 'GO'),
(11234, 31, 493, 'Montes Claros de Goiás', 'BR', 'GO'),
(11235, 31, 493, 'Montividiu', 'BR', 'GO'),
(11236, 31, 493, 'Montividiu do Norte', 'BR', 'GO'),
(11237, 31, 493, 'Morrinhos', 'BR', 'GO'),
(11238, 31, 493, 'Morro Agudo de Goiás', 'BR', 'GO'),
(11239, 31, 493, 'Mossâmedes', 'BR', 'GO'),
(11240, 31, 493, 'Mozarlândia', 'BR', 'GO'),
(11241, 31, 493, 'Mundo Novo', 'BR', 'GO'),
(11242, 31, 493, 'Mutunópolis', 'BR', 'GO'),
(11243, 31, 493, 'Nazário', 'BR', 'GO'),
(11244, 31, 493, 'Nerópolis', 'BR', 'GO'),
(11245, 31, 493, 'Niquelândia', 'BR', 'GO'),
(11246, 31, 493, 'Nova América', 'BR', 'GO'),
(11247, 31, 493, 'Nova Aurora', 'BR', 'GO'),
(11248, 31, 493, 'Nova Crixás', 'BR', 'GO'),
(11249, 31, 493, 'Nova Glória', 'BR', 'GO'),
(11250, 31, 493, 'Nova Iguaçu de Goiás', 'BR', 'GO'),
(11251, 31, 493, 'Nova Roma', 'BR', 'GO'),
(11252, 31, 493, 'Nova Veneza', 'BR', 'GO'),
(11253, 31, 493, 'Novo Brasil', 'BR', 'GO'),
(11254, 31, 493, 'Novo Gama', 'BR', 'GO'),
(11255, 31, 493, 'Novo Planalto', 'BR', 'GO'),
(11256, 31, 493, 'Orizona', 'BR', 'GO'),
(11257, 31, 493, 'Ouro Verde de Goiás', 'BR', 'GO'),
(11258, 31, 493, 'Ouvidor', 'BR', 'GO'),
(11259, 31, 493, 'Padre Bernardo', 'BR', 'GO'),
(11260, 31, 493, 'Palestina de Goiás', 'BR', 'GO'),
(11261, 31, 493, 'Palmeiras de Goiás', 'BR', 'GO'),
(11262, 31, 493, 'Palmelo', 'BR', 'GO'),
(11263, 31, 493, 'Palminópolis', 'BR', 'GO'),
(11264, 31, 493, 'Panamá', 'BR', 'GO'),
(11265, 31, 493, 'Paranaiguara', 'BR', 'GO'),
(11266, 31, 493, 'Paraúna', 'BR', 'GO'),
(11267, 31, 493, 'Perolândia', 'BR', 'GO'),
(11268, 31, 493, 'Petrolina de Goiás', 'BR', 'GO'),
(11269, 31, 493, 'Pilar de Goiás', 'BR', 'GO'),
(11270, 31, 493, 'Piracanjuba', 'BR', 'GO'),
(11271, 31, 493, 'Piranhas', 'BR', 'GO'),
(11272, 31, 493, 'Pirenópolis', 'BR', 'GO'),
(11273, 31, 493, 'Pires do Rio', 'BR', 'GO'),
(11274, 31, 493, 'Planaltina', 'BR', 'GO'),
(11275, 31, 493, 'Pontalina', 'BR', 'GO'),
(11276, 31, 493, 'Porangatu', 'BR', 'GO'),
(11277, 31, 493, 'Porteirão', 'BR', 'GO'),
(11278, 31, 493, 'Portelândia', 'BR', 'GO'),
(11279, 31, 493, 'Posse', 'BR', 'GO'),
(11280, 31, 493, 'Professor Jamil', 'BR', 'GO'),
(11281, 31, 493, 'Quirinópolis', 'BR', 'GO'),
(11282, 31, 493, 'Rialma', 'BR', 'GO'),
(11283, 31, 493, 'Rianápolis', 'BR', 'GO'),
(11284, 31, 493, 'Rio Quente', 'BR', 'GO'),
(11285, 31, 493, 'Rio Verde', 'BR', 'GO'),
(11286, 31, 493, 'Rubiataba', 'BR', 'GO'),
(11287, 31, 493, 'Sanclerlândia', 'BR', 'GO'),
(11288, 31, 493, 'Santa Bárbara de Goiás', 'BR', 'GO'),
(11289, 31, 493, 'Santa Cruz de Goiás', 'BR', 'GO'),
(11290, 31, 493, 'Santa Fé de Goiás', 'BR', 'GO'),
(11291, 31, 493, 'Santa Helena de Goiás', 'BR', 'GO'),
(11292, 31, 493, 'Santa Isabel', 'BR', 'GO'),
(11293, 31, 493, 'Santa Rita do Araguaia', 'BR', 'GO'),
(11294, 31, 493, 'Santa Rita do Novo Destino', 'BR', 'GO'),
(11295, 31, 493, 'Santa Rosa de Goiás', 'BR', 'GO'),
(11296, 31, 493, 'Santa Tereza de Goiás', 'BR', 'GO'),
(11297, 31, 493, 'Santa Terezinha de Goiás', 'BR', 'GO'),
(11298, 31, 493, 'Santo Antônio da Barra', 'BR', 'GO'),
(11299, 31, 493, 'Santo Antônio de Goiás', 'BR', 'GO'),
(11300, 31, 493, 'Santo Antônio do Descoberto', 'BR', 'GO'),
(11301, 31, 493, 'São Domingos', 'BR', 'GO'),
(11302, 31, 493, 'São Francisco de Goiás', 'BR', 'GO'),
(11303, 31, 493, 'São João d\'Aliança', 'BR', 'GO'),
(11304, 31, 493, 'São João da Paraúna', 'BR', 'GO'),
(11305, 31, 493, 'São Luís de Montes Belos', 'BR', 'GO'),
(11306, 31, 493, 'São Luiz do Norte', 'BR', 'GO'),
(11307, 31, 493, 'São Miguel do Araguaia', 'BR', 'GO'),
(11308, 31, 493, 'São Miguel do Passa Quatro', 'BR', 'GO'),
(11309, 31, 493, 'São Patrício', 'BR', 'GO'),
(11310, 31, 493, 'São Simão', 'BR', 'GO'),
(11311, 31, 493, 'Senador Canedo', 'BR', 'GO'),
(11312, 31, 493, 'Serranópolis', 'BR', 'GO'),
(11313, 31, 493, 'Silvânia', 'BR', 'GO'),
(11314, 31, 493, 'Simolândia', 'BR', 'GO'),
(11315, 31, 493, 'Sítio d\'Abadia', 'BR', 'GO'),
(11316, 31, 493, 'Taquaral de Goiás', 'BR', 'GO'),
(11317, 31, 493, 'Teresina de Goiás', 'BR', 'GO'),
(11318, 31, 493, 'Terezópolis de Goiás', 'BR', 'GO'),
(11319, 31, 493, 'Três Ranchos', 'BR', 'GO'),
(11320, 31, 493, 'Trindade', 'BR', 'GO'),
(11321, 31, 493, 'Trombas', 'BR', 'GO'),
(11322, 31, 493, 'Turvânia', 'BR', 'GO'),
(11323, 31, 493, 'Turvelândia', 'BR', 'GO'),
(11324, 31, 493, 'Uirapuru', 'BR', 'GO'),
(11325, 31, 493, 'Uruaçu', 'BR', 'GO'),
(11326, 31, 493, 'Uruana', 'BR', 'GO'),
(11327, 31, 493, 'Urutaí', 'BR', 'GO'),
(11328, 31, 493, 'Valparaíso de Goiás', 'BR', 'GO'),
(11329, 31, 493, 'Varjão', 'BR', 'GO'),
(11330, 31, 493, 'Vianópolis', 'BR', 'GO'),
(11331, 31, 493, 'Vicentinópolis', 'BR', 'GO'),
(11332, 31, 493, 'Vila Boa', 'BR', 'GO'),
(11333, 31, 493, 'Vila Propício', 'BR', 'GO'),
(11334, 31, 494, 'Açailândia', 'BR', 'MA'),
(11335, 31, 494, 'Afonso Cunha', 'BR', 'MA'),
(11336, 31, 494, 'Água Doce do Maranhão', 'BR', 'MA'),
(11337, 31, 494, 'Alcântara', 'BR', 'MA'),
(11338, 31, 494, 'Aldeias Altas', 'BR', 'MA'),
(11339, 31, 494, 'Altamira do Maranhão', 'BR', 'MA'),
(11340, 31, 494, 'Alto Alegre do Maranhão', 'BR', 'MA'),
(11341, 31, 494, 'Alto Alegre do Pindaré', 'BR', 'MA'),
(11342, 31, 494, 'Alto Parnaíba', 'BR', 'MA'),
(11343, 31, 494, 'Amapá do Maranhão', 'BR', 'MA'),
(11344, 31, 494, 'Amarante do Maranhão', 'BR', 'MA'),
(11345, 31, 494, 'Anajatuba', 'BR', 'MA'),
(11346, 31, 494, 'Anapurus', 'BR', 'MA'),
(11347, 31, 494, 'Apicum-Açu', 'BR', 'MA'),
(11348, 31, 494, 'Araguanã', 'BR', 'MA'),
(11349, 31, 494, 'Araioses', 'BR', 'MA'),
(11350, 31, 494, 'Arame', 'BR', 'MA'),
(11351, 31, 494, 'Arari', 'BR', 'MA'),
(11352, 31, 494, 'Atins', 'BR', 'MA'),
(11353, 31, 494, 'Axixá', 'BR', 'MA'),
(11354, 31, 494, 'Bacabal', 'BR', 'MA'),
(11355, 31, 494, 'Bacabeira', 'BR', 'MA'),
(11356, 31, 494, 'Bacuri', 'BR', 'MA'),
(11357, 31, 494, 'Bacurituba', 'BR', 'MA'),
(11358, 31, 494, 'Balsas', 'BR', 'MA'),
(11359, 31, 494, 'Barão de Grajaú', 'BR', 'MA'),
(11360, 31, 494, 'Barra do Corda', 'BR', 'MA'),
(11361, 31, 494, 'Barreirinhas', 'BR', 'MA'),
(11362, 31, 494, 'Bela Vista do Maranhão', 'BR', 'MA'),
(11363, 31, 494, 'Belágua', 'BR', 'MA'),
(11364, 31, 494, 'Benedito Leite', 'BR', 'MA'),
(11365, 31, 494, 'Bequimão', 'BR', 'MA'),
(11366, 31, 494, 'Bernardo do Mearim', 'BR', 'MA'),
(11367, 31, 494, 'Boa Vista do Gurupi', 'BR', 'MA'),
(11368, 31, 494, 'Bom Jardim', 'BR', 'MA'),
(11369, 31, 494, 'Bom Jesus das Selvas', 'BR', 'MA'),
(11370, 31, 494, 'Bom Lugar', 'BR', 'MA'),
(11371, 31, 494, 'Brejo', 'BR', 'MA'),
(11372, 31, 494, 'Brejo de Areia', 'BR', 'MA'),
(11373, 31, 494, 'Buriti', 'BR', 'MA'),
(11374, 31, 494, 'Buriti Bravo', 'BR', 'MA'),
(11375, 31, 494, 'Buriticupu', 'BR', 'MA'),
(11376, 31, 494, 'Buritirana', 'BR', 'MA'),
(11377, 31, 494, 'Cachoeira Grande', 'BR', 'MA'),
(11378, 31, 494, 'Cajapió', 'BR', 'MA'),
(11379, 31, 494, 'Cajari', 'BR', 'MA'),
(11380, 31, 494, 'Campestre do Maranhão', 'BR', 'MA'),
(11381, 31, 494, 'Cândido Mendes', 'BR', 'MA'),
(11382, 31, 494, 'Cantanhede', 'BR', 'MA'),
(11383, 31, 494, 'Capinzal do Norte', 'BR', 'MA'),
(11384, 31, 494, 'Carolina', 'BR', 'MA'),
(11385, 31, 494, 'Carutapera', 'BR', 'MA'),
(11386, 31, 494, 'Caxias', 'BR', 'MA'),
(11387, 31, 494, 'Cedral', 'BR', 'MA'),
(11388, 31, 494, 'Central do Maranhão', 'BR', 'MA'),
(11389, 31, 494, 'Centro do Guilherme', 'BR', 'MA'),
(11390, 31, 494, 'Centro Novo do Maranhão', 'BR', 'MA'),
(11391, 31, 494, 'Chapadinha', 'BR', 'MA'),
(11392, 31, 494, 'Cidelândia', 'BR', 'MA'),
(11393, 31, 494, 'Codó', 'BR', 'MA'),
(11394, 31, 494, 'Coelho Neto', 'BR', 'MA'),
(11395, 31, 494, 'Colinas', 'BR', 'MA'),
(11396, 31, 494, 'Conceição do Lago-Açu', 'BR', 'MA'),
(11397, 31, 494, 'Coroatá', 'BR', 'MA'),
(11398, 31, 494, 'Cururupu', 'BR', 'MA'),
(11399, 31, 494, 'Davinópolis', 'BR', 'MA'),
(11400, 31, 494, 'Dom Pedro', 'BR', 'MA'),
(11401, 31, 494, 'Duque Bacelar', 'BR', 'MA'),
(11402, 31, 494, 'Esperantinópolis', 'BR', 'MA'),
(11403, 31, 494, 'Estreito', 'BR', 'MA'),
(11404, 31, 494, 'Feira Nova do Maranhão', 'BR', 'MA'),
(11405, 31, 494, 'Fernando Falcão', 'BR', 'MA'),
(11406, 31, 494, 'Formosa da Serra Negra', 'BR', 'MA'),
(11407, 31, 494, 'Fortaleza dos Nogueiras', 'BR', 'MA'),
(11408, 31, 494, 'Fortuna', 'BR', 'MA'),
(11409, 31, 494, 'Godofredo Viana', 'BR', 'MA'),
(11410, 31, 494, 'Gonçalves Dias', 'BR', 'MA'),
(11411, 31, 494, 'Governador Archer', 'BR', 'MA'),
(11412, 31, 494, 'Governador Edison Lobão', 'BR', 'MA'),
(11413, 31, 494, 'Governador Eugênio Barros', 'BR', 'MA'),
(11414, 31, 494, 'Governador Luiz Rocha', 'BR', 'MA'),
(11415, 31, 494, 'Governador Newton Bello', 'BR', 'MA'),
(11416, 31, 494, 'Governador Nunes Freire', 'BR', 'MA'),
(11417, 31, 494, 'Graça Aranha', 'BR', 'MA'),
(11418, 31, 494, 'Grajaú', 'BR', 'MA'),
(11419, 31, 494, 'Guimarães', 'BR', 'MA'),
(11420, 31, 494, 'Humberto de Campos', 'BR', 'MA'),
(11421, 31, 494, 'Icatu', 'BR', 'MA'),
(11422, 31, 494, 'Igarapé do Meio', 'BR', 'MA'),
(11423, 31, 494, 'Igarapé Grande', 'BR', 'MA'),
(11424, 31, 494, 'Imperatriz', 'BR', 'MA'),
(11425, 31, 494, 'Itaipava do Grajaú', 'BR', 'MA'),
(11426, 31, 494, 'Itapecuru Mirim', 'BR', 'MA'),
(11427, 31, 494, 'Itinga do Maranhão', 'BR', 'MA'),
(11428, 31, 494, 'Jatobá', 'BR', 'MA'),
(11429, 31, 494, 'Jenipapo dos Vieiras', 'BR', 'MA'),
(11430, 31, 494, 'João Lisboa', 'BR', 'MA'),
(11431, 31, 494, 'Joselândia', 'BR', 'MA'),
(11432, 31, 494, 'Junco do Maranhão', 'BR', 'MA'),
(11433, 31, 494, 'Lago da Pedra', 'BR', 'MA'),
(11434, 31, 494, 'Lago do Junco', 'BR', 'MA'),
(11435, 31, 494, 'Lago dos Rodrigues', 'BR', 'MA'),
(11436, 31, 494, 'Lago Verde', 'BR', 'MA'),
(11437, 31, 494, 'Lagoa do Mato', 'BR', 'MA'),
(11438, 31, 494, 'Lagoa Grande do Maranhão', 'BR', 'MA'),
(11439, 31, 494, 'Lajeado Novo', 'BR', 'MA'),
(11440, 31, 494, 'Lima Campos', 'BR', 'MA'),
(11441, 31, 494, 'Loreto', 'BR', 'MA'),
(11442, 31, 494, 'Luís Domingues', 'BR', 'MA'),
(11443, 31, 494, 'Magalhães de Almeida', 'BR', 'MA'),
(11444, 31, 494, 'Maracaçumé', 'BR', 'MA'),
(11445, 31, 494, 'Marajá do Sena', 'BR', 'MA'),
(11446, 31, 494, 'Maranhãozinho', 'BR', 'MA'),
(11447, 31, 494, 'Mata Roma', 'BR', 'MA'),
(11448, 31, 494, 'Matinha', 'BR', 'MA'),
(11449, 31, 494, 'Matões', 'BR', 'MA'),
(11450, 31, 494, 'Matões do Norte', 'BR', 'MA'),
(11451, 31, 494, 'Milagres do Maranhão', 'BR', 'MA'),
(11452, 31, 494, 'Mirador', 'BR', 'MA'),
(11453, 31, 494, 'Miranda do Norte', 'BR', 'MA'),
(11454, 31, 494, 'Mirinzal', 'BR', 'MA'),
(11455, 31, 494, 'Monção', 'BR', 'MA'),
(11456, 31, 494, 'Montes Altos', 'BR', 'MA'),
(11457, 31, 494, 'Morros', 'BR', 'MA'),
(11458, 31, 494, 'Nina Rodrigues', 'BR', 'MA'),
(11459, 31, 494, 'Nova Colinas', 'BR', 'MA'),
(11460, 31, 494, 'Nova Iorque', 'BR', 'MA'),
(11461, 31, 494, 'Nova Olinda do Maranhão', 'BR', 'MA'),
(11462, 31, 494, 'Olho d\'Água das Cunhãs', 'BR', 'MA'),
(11463, 31, 494, 'Olinda Nova do Maranhão', 'BR', 'MA'),
(11464, 31, 494, 'Paço do Lumiar', 'BR', 'MA'),
(11465, 31, 494, 'Palmeirândia', 'BR', 'MA'),
(11466, 31, 494, 'Paraibano', 'BR', 'MA'),
(11467, 31, 494, 'Parnarama', 'BR', 'MA'),
(11468, 31, 494, 'Passagem Franca', 'BR', 'MA'),
(11469, 31, 494, 'Pastos Bons', 'BR', 'MA'),
(11470, 31, 494, 'Paulino Neves', 'BR', 'MA'),
(11471, 31, 494, 'Paulo Ramos', 'BR', 'MA'),
(11472, 31, 494, 'Pedreiras', 'BR', 'MA'),
(11473, 31, 494, 'Pedro do Rosário', 'BR', 'MA'),
(11474, 31, 494, 'Penalva', 'BR', 'MA'),
(11475, 31, 494, 'Peri Mirim', 'BR', 'MA'),
(11476, 31, 494, 'Peritoró', 'BR', 'MA'),
(11477, 31, 494, 'Pindaré Mirim', 'BR', 'MA'),
(11478, 31, 494, 'Pindaré-Mirim', 'BR', 'MA'),
(11479, 31, 494, 'Pinheiro', 'BR', 'MA'),
(11480, 31, 494, 'Pio XII', 'BR', 'MA'),
(11481, 31, 494, 'Pirapemas', 'BR', 'MA'),
(11482, 31, 494, 'Poção de Pedras', 'BR', 'MA'),
(11483, 31, 494, 'Porto Franco', 'BR', 'MA'),
(11484, 31, 494, 'Porto Rico do Maranhão', 'BR', 'MA'),
(11485, 31, 494, 'Presidente Dutra', 'BR', 'MA'),
(11486, 31, 494, 'Presidente Juscelino', 'BR', 'MA'),
(11487, 31, 494, 'Presidente Médici', 'BR', 'MA'),
(11488, 31, 494, 'Presidente Sarney', 'BR', 'MA'),
(11489, 31, 494, 'Presidente Vargas', 'BR', 'MA'),
(11490, 31, 494, 'Primeira Cruz', 'BR', 'MA'),
(11491, 31, 494, 'Raposa', 'BR', 'MA'),
(11492, 31, 494, 'Riachão', 'BR', 'MA'),
(11493, 31, 494, 'Ribamar Fiquene', 'BR', 'MA'),
(11494, 31, 494, 'Rosário', 'BR', 'MA'),
(11495, 31, 494, 'Sambaíba', 'BR', 'MA'),
(11496, 31, 494, 'Santa Filomena do Maranhão', 'BR', 'MA'),
(11497, 31, 494, 'Santa Helena', 'BR', 'MA'),
(11498, 31, 494, 'Santa Inês', 'BR', 'MA'),
(11499, 31, 494, 'Santa Luzia', 'BR', 'MA'),
(11500, 31, 494, 'Santa Luzia do Paruá', 'BR', 'MA');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(11501, 31, 494, 'Santa Quitéria do Maranhão', 'BR', 'MA'),
(11502, 31, 494, 'Santa Rita', 'BR', 'MA'),
(11503, 31, 494, 'Santana do Maranhão', 'BR', 'MA'),
(11504, 31, 494, 'Santo Amaro do Maranhão', 'BR', 'MA'),
(11505, 31, 494, 'Santo Antônio dos Lopes', 'BR', 'MA'),
(11506, 31, 494, 'São Benedito do Rio Preto', 'BR', 'MA'),
(11507, 31, 494, 'São Bento', 'BR', 'MA'),
(11508, 31, 494, 'São Bernardo', 'BR', 'MA'),
(11509, 31, 494, 'São Domingos do Azeitão', 'BR', 'MA'),
(11510, 31, 494, 'São Domingos do Maranhão', 'BR', 'MA'),
(11511, 31, 494, 'São Félix de Balsas', 'BR', 'MA'),
(11512, 31, 494, 'São Francisco do Brejão', 'BR', 'MA'),
(11513, 31, 494, 'São Francisco do Maranhão', 'BR', 'MA'),
(11514, 31, 494, 'São João Batista', 'BR', 'MA'),
(11515, 31, 494, 'São João do Carú', 'BR', 'MA'),
(11516, 31, 494, 'São João do Paraíso', 'BR', 'MA'),
(11517, 31, 494, 'São João do Soter', 'BR', 'MA'),
(11518, 31, 494, 'São João dos Patos', 'BR', 'MA'),
(11519, 31, 494, 'São José de Ribamar', 'BR', 'MA'),
(11520, 31, 494, 'São José dos Basílios', 'BR', 'MA'),
(11521, 31, 494, 'São Luís', 'BR', 'MA'),
(11522, 31, 494, 'São Luís Gonzaga do Maranhão', 'BR', 'MA'),
(11523, 31, 494, 'São Mateus do Maranhão', 'BR', 'MA'),
(11524, 31, 494, 'São Pedro da Água Branca', 'BR', 'MA'),
(11525, 31, 494, 'São Pedro dos Crentes', 'BR', 'MA'),
(11526, 31, 494, 'São Raimundo das Mangabeiras', 'BR', 'MA'),
(11527, 31, 494, 'São Raimundo do Doca Bezerra', 'BR', 'MA'),
(11528, 31, 494, 'São Roberto', 'BR', 'MA'),
(11529, 31, 494, 'São Vicente Ferrer', 'BR', 'MA'),
(11530, 31, 494, 'Satubinha', 'BR', 'MA'),
(11531, 31, 494, 'Senador Alexandre Costa', 'BR', 'MA'),
(11532, 31, 494, 'Senador La Rocque', 'BR', 'MA'),
(11533, 31, 494, 'Serrano do Maranhão', 'BR', 'MA'),
(11534, 31, 494, 'Sítio Novo', 'BR', 'MA'),
(11535, 31, 494, 'Sucupira do Norte', 'BR', 'MA'),
(11536, 31, 494, 'Sucupira do Riachão', 'BR', 'MA'),
(11537, 31, 494, 'Tasso Fragoso', 'BR', 'MA'),
(11538, 31, 494, 'Timbiras', 'BR', 'MA'),
(11539, 31, 494, 'Timon', 'BR', 'MA'),
(11540, 31, 494, 'Trizidela do Vale', 'BR', 'MA'),
(11541, 31, 494, 'Tufilândia', 'BR', 'MA'),
(11542, 31, 494, 'Tuntum', 'BR', 'MA'),
(11543, 31, 494, 'Turiaçu', 'BR', 'MA'),
(11544, 31, 494, 'Turilândia', 'BR', 'MA'),
(11545, 31, 494, 'Tutóia', 'BR', 'MA'),
(11546, 31, 494, 'Urbano Santos', 'BR', 'MA'),
(11547, 31, 494, 'Vargem Grande', 'BR', 'MA'),
(11548, 31, 494, 'Viana', 'BR', 'MA'),
(11549, 31, 494, 'Vila Nova dos Martírios', 'BR', 'MA'),
(11550, 31, 494, 'Vitória do Mearim', 'BR', 'MA'),
(11551, 31, 494, 'Vitorino Freire', 'BR', 'MA'),
(11552, 31, 494, 'Zé Doca', 'BR', 'MA'),
(11553, 31, 495, 'Acorizal', 'BR', 'MT'),
(11554, 31, 495, 'Água Boa', 'BR', 'MT'),
(11555, 31, 495, 'Alta Floresta', 'BR', 'MT'),
(11556, 31, 495, 'Alto Araguaia', 'BR', 'MT'),
(11557, 31, 495, 'Alto Boa Vista', 'BR', 'MT'),
(11558, 31, 495, 'Alto Garças', 'BR', 'MT'),
(11559, 31, 495, 'Alto Paraguai', 'BR', 'MT'),
(11560, 31, 495, 'Alto Taquari', 'BR', 'MT'),
(11561, 31, 495, 'Apiacás', 'BR', 'MT'),
(11562, 31, 495, 'Araguaiana', 'BR', 'MT'),
(11563, 31, 495, 'Araguainha', 'BR', 'MT'),
(11564, 31, 495, 'Araputanga', 'BR', 'MT'),
(11565, 31, 495, 'Arenápolis', 'BR', 'MT'),
(11566, 31, 495, 'Aripuanã', 'BR', 'MT'),
(11567, 31, 495, 'Barão de Melgaço', 'BR', 'MT'),
(11568, 31, 495, 'Barra do Bugres', 'BR', 'MT'),
(11569, 31, 495, 'Barra do Garças', 'BR', 'MT'),
(11570, 31, 495, 'Bom Jesus do Araguaia', 'BR', 'MT'),
(11571, 31, 495, 'Brasnorte', 'BR', 'MT'),
(11572, 31, 495, 'Cáceres', 'BR', 'MT'),
(11573, 31, 495, 'Campinápolis', 'BR', 'MT'),
(11574, 31, 495, 'Campo Novo do Parecis', 'BR', 'MT'),
(11575, 31, 495, 'Campo Verde', 'BR', 'MT'),
(11576, 31, 495, 'Campos de Júlio', 'BR', 'MT'),
(11577, 31, 495, 'CanaBrava do Norte', 'BR', 'MT'),
(11578, 31, 495, 'Canarana', 'BR', 'MT'),
(11579, 31, 495, 'Carlinda', 'BR', 'MT'),
(11580, 31, 495, 'Castanheira', 'BR', 'MT'),
(11581, 31, 495, 'Chapada dos Guimarães', 'BR', 'MT'),
(11582, 31, 495, 'Cláudia', 'BR', 'MT'),
(11583, 31, 495, 'Cocalinho', 'BR', 'MT'),
(11584, 31, 495, 'Colíder', 'BR', 'MT'),
(11585, 31, 495, 'Colniza', 'BR', 'MT'),
(11586, 31, 495, 'Comodoro', 'BR', 'MT'),
(11587, 31, 495, 'Confresa', 'BR', 'MT'),
(11588, 31, 495, 'Conquista D\'oeste', 'BR', 'MT'),
(11589, 31, 495, 'Cotriguaçu', 'BR', 'MT'),
(11590, 31, 495, 'Cuiabá', 'BR', 'MT'),
(11591, 31, 495, 'Curvelândia', 'BR', 'MT'),
(11592, 31, 495, 'Denise', 'BR', 'MT'),
(11593, 31, 495, 'Diamantino', 'BR', 'MT'),
(11594, 31, 495, 'Dom Aquino', 'BR', 'MT'),
(11595, 31, 495, 'Feliz Natal', 'BR', 'MT'),
(11596, 31, 495, 'Figueirópolis d\'Oeste', 'BR', 'MT'),
(11597, 31, 495, 'Gaúcha do Norte', 'BR', 'MT'),
(11598, 31, 495, 'General Carneiro', 'BR', 'MT'),
(11599, 31, 495, 'Glória d\'Oeste', 'BR', 'MT'),
(11600, 31, 495, 'Guarantã do Norte', 'BR', 'MT'),
(11601, 31, 495, 'Guiratinga', 'BR', 'MT'),
(11602, 31, 495, 'Indiavaí', 'BR', 'MT'),
(11603, 31, 495, 'Ipiranga do Norte', 'BR', 'MT'),
(11604, 31, 495, 'Itanhangá', 'BR', 'MT'),
(11605, 31, 495, 'Itaúba', 'BR', 'MT'),
(11606, 31, 495, 'Itiquira', 'BR', 'MT'),
(11607, 31, 495, 'Jaciara', 'BR', 'MT'),
(11608, 31, 495, 'Jangada', 'BR', 'MT'),
(11609, 31, 495, 'Jauru', 'BR', 'MT'),
(11610, 31, 495, 'Juara', 'BR', 'MT'),
(11611, 31, 495, 'Juína', 'BR', 'MT'),
(11612, 31, 495, 'Juruena', 'BR', 'MT'),
(11613, 31, 495, 'Juscimeira', 'BR', 'MT'),
(11614, 31, 495, 'Lambari d\'Oeste', 'BR', 'MT'),
(11615, 31, 495, 'Lucas', 'BR', 'MT'),
(11616, 31, 495, 'Lucas do Rio Verde', 'BR', 'MT'),
(11617, 31, 495, 'Luciara', 'BR', 'MT'),
(11618, 31, 495, 'Marcelândia', 'BR', 'MT'),
(11619, 31, 495, 'Matupá', 'BR', 'MT'),
(11620, 31, 495, 'Mirassol d\'Oeste', 'BR', 'MT'),
(11621, 31, 495, 'Nobres', 'BR', 'MT'),
(11622, 31, 495, 'Nortelândia', 'BR', 'MT'),
(11623, 31, 495, 'Nossa Senhora do Livramento', 'BR', 'MT'),
(11624, 31, 495, 'Nova Bandeirantes', 'BR', 'MT'),
(11625, 31, 495, 'Nova Brasilândia', 'BR', 'MT'),
(11626, 31, 495, 'Nova Canaã do Norte', 'BR', 'MT'),
(11627, 31, 495, 'Nova Guarita', 'BR', 'MT'),
(11628, 31, 495, 'Nova Lacerda', 'BR', 'MT'),
(11629, 31, 495, 'Nova Marilândia', 'BR', 'MT'),
(11630, 31, 495, 'Nova Maringá', 'BR', 'MT'),
(11631, 31, 495, 'Nova Monte Verde', 'BR', 'MT'),
(11632, 31, 495, 'Nova Mutum', 'BR', 'MT'),
(11633, 31, 495, 'Nova Nazaré', 'BR', 'MT'),
(11634, 31, 495, 'Nova Olímpia', 'BR', 'MT'),
(11635, 31, 495, 'Nova Santa Helena', 'BR', 'MT'),
(11636, 31, 495, 'Nova Ubiratã', 'BR', 'MT'),
(11637, 31, 495, 'Nova Xavantina', 'BR', 'MT'),
(11638, 31, 495, 'Novo Horizonte do Norte', 'BR', 'MT'),
(11639, 31, 495, 'Novo Mundo', 'BR', 'MT'),
(11640, 31, 495, 'Novo Santo Antônio', 'BR', 'MT'),
(11641, 31, 495, 'Novo São Joaquim', 'BR', 'MT'),
(11642, 31, 495, 'Paranaíta', 'BR', 'MT'),
(11643, 31, 495, 'Paranatinga', 'BR', 'MT'),
(11644, 31, 495, 'Pedra Preta', 'BR', 'MT'),
(11645, 31, 495, 'Peixoto de Azevedo', 'BR', 'MT'),
(11646, 31, 495, 'Planalto da Serra', 'BR', 'MT'),
(11647, 31, 495, 'Poconé', 'BR', 'MT'),
(11648, 31, 495, 'Pontal do Araguaia', 'BR', 'MT'),
(11649, 31, 495, 'Ponte Branca', 'BR', 'MT'),
(11650, 31, 495, 'Pontes e Lacerda', 'BR', 'MT'),
(11651, 31, 495, 'Porto Alegre do Norte', 'BR', 'MT'),
(11652, 31, 495, 'Porto dos Gaúchos', 'BR', 'MT'),
(11653, 31, 495, 'Porto Esperidião', 'BR', 'MT'),
(11654, 31, 495, 'Porto Estrela', 'BR', 'MT'),
(11655, 31, 495, 'Poxoréo', 'BR', 'MT'),
(11656, 31, 495, 'Poxoréu', 'BR', 'MT'),
(11657, 31, 495, 'Primavera do Leste', 'BR', 'MT'),
(11658, 31, 495, 'Querência', 'BR', 'MT'),
(11659, 31, 495, 'Reserva do Cabaçal', 'BR', 'MT'),
(11660, 31, 495, 'Ribeirão Cascalheira', 'BR', 'MT'),
(11661, 31, 495, 'Ribeirãozinho', 'BR', 'MT'),
(11662, 31, 495, 'Rio Branco', 'BR', 'MT'),
(11663, 31, 495, 'Rondolândia', 'BR', 'MT'),
(11664, 31, 495, 'Rondonópolis', 'BR', 'MT'),
(11665, 31, 495, 'Rosário Oeste', 'BR', 'MT'),
(11666, 31, 495, 'Salto do Céu', 'BR', 'MT'),
(11667, 31, 495, 'Santa Carmem', 'BR', 'MT'),
(11668, 31, 495, 'Santa Cruz do Xingu', 'BR', 'MT'),
(11669, 31, 495, 'Santa Rita do Trivelato', 'BR', 'MT'),
(11670, 31, 495, 'Santa Terezinha', 'BR', 'MT'),
(11671, 31, 495, 'Santo Afonso', 'BR', 'MT'),
(11672, 31, 495, 'Santo Antônio do Leste', 'BR', 'MT'),
(11673, 31, 495, 'Santo Antônio do Leverger', 'BR', 'MT'),
(11674, 31, 495, 'São Félix do Araguaia', 'BR', 'MT'),
(11675, 31, 495, 'São José do Povo', 'BR', 'MT'),
(11676, 31, 495, 'São José do Rio Claro', 'BR', 'MT'),
(11677, 31, 495, 'São José do Xingu', 'BR', 'MT'),
(11678, 31, 495, 'São José dos Quatro Marcos', 'BR', 'MT'),
(11679, 31, 495, 'São Pedro da Cipa', 'BR', 'MT'),
(11680, 31, 495, 'Sapezal', 'BR', 'MT'),
(11681, 31, 495, 'Serra Nova Dourada', 'BR', 'MT'),
(11682, 31, 495, 'Sinop', 'BR', 'MT'),
(11683, 31, 495, 'Sorriso', 'BR', 'MT'),
(11684, 31, 495, 'Tabaporã', 'BR', 'MT'),
(11685, 31, 495, 'Tangará da Serra', 'BR', 'MT'),
(11686, 31, 495, 'Tapurah', 'BR', 'MT'),
(11687, 31, 495, 'Terra Nova do Norte', 'BR', 'MT'),
(11688, 31, 495, 'Tesouro', 'BR', 'MT'),
(11689, 31, 495, 'Torixoréu', 'BR', 'MT'),
(11690, 31, 495, 'União do Sul', 'BR', 'MT'),
(11691, 31, 495, 'Vale de São Domingos', 'BR', 'MT'),
(11692, 31, 495, 'Várzea Grande', 'BR', 'MT'),
(11693, 31, 495, 'Vera', 'BR', 'MT'),
(11694, 31, 495, 'Vila Bela da Santíssima Trindade', 'BR', 'MT'),
(11695, 31, 495, 'Vila Rica', 'BR', 'MT'),
(11696, 31, 496, 'Água Clara', 'BR', 'MS'),
(11697, 31, 496, 'Alcinópolis', 'BR', 'MS'),
(11698, 31, 496, 'Amambai', 'BR', 'MS'),
(11699, 31, 496, 'Anastácio', 'BR', 'MS'),
(11700, 31, 496, 'Anaurilândia', 'BR', 'MS'),
(11701, 31, 496, 'Angélica', 'BR', 'MS'),
(11702, 31, 496, 'Antônio João', 'BR', 'MS'),
(11703, 31, 496, 'Aparecida do Taboado', 'BR', 'MS'),
(11704, 31, 496, 'Aquidauana', 'BR', 'MS'),
(11705, 31, 496, 'Aral Moreira', 'BR', 'MS'),
(11706, 31, 496, 'Bandeirantes', 'BR', 'MS'),
(11707, 31, 496, 'Bataguassu', 'BR', 'MS'),
(11708, 31, 496, 'Bataiporã', 'BR', 'MS'),
(11709, 31, 496, 'Batayporã', 'BR', 'MS'),
(11710, 31, 496, 'Bela Vista', 'BR', 'MS'),
(11711, 31, 496, 'Bodoquena', 'BR', 'MS'),
(11712, 31, 496, 'Bonito', 'BR', 'MS'),
(11713, 31, 496, 'Brasilândia', 'BR', 'MS'),
(11714, 31, 496, 'Caarapó', 'BR', 'MS'),
(11715, 31, 496, 'Camapuã', 'BR', 'MS'),
(11716, 31, 496, 'Campo Grande', 'BR', 'MS'),
(11717, 31, 496, 'Campo Verde', 'BR', 'MS'),
(11718, 31, 496, 'Caracol', 'BR', 'MS'),
(11719, 31, 496, 'Cassilândia', 'BR', 'MS'),
(11720, 31, 496, 'Chapadão do Sul', 'BR', 'MS'),
(11721, 31, 496, 'Corguinho', 'BR', 'MS'),
(11722, 31, 496, 'Coronel Sapucaia', 'BR', 'MS'),
(11723, 31, 496, 'Corumbá', 'BR', 'MS'),
(11724, 31, 496, 'Costa Rica', 'BR', 'MS'),
(11725, 31, 496, 'Coxim', 'BR', 'MS'),
(11726, 31, 496, 'Deodápolis', 'BR', 'MS'),
(11727, 31, 496, 'Dois Irmãos do Buriti', 'BR', 'MS'),
(11728, 31, 496, 'Douradina', 'BR', 'MS'),
(11729, 31, 496, 'Dourados', 'BR', 'MS'),
(11730, 31, 496, 'Eldorado', 'BR', 'MS'),
(11731, 31, 496, 'Fátima do Sul', 'BR', 'MS'),
(11732, 31, 496, 'Figueirão', 'BR', 'MS'),
(11733, 31, 496, 'Glória de Dourados', 'BR', 'MS'),
(11734, 31, 496, 'Guia Lopes da Laguna', 'BR', 'MS'),
(11735, 31, 496, 'Iguatemi', 'BR', 'MS'),
(11736, 31, 496, 'Inocência', 'BR', 'MS'),
(11737, 31, 496, 'Itaporã', 'BR', 'MS'),
(11738, 31, 496, 'Itaquiraí', 'BR', 'MS'),
(11739, 31, 496, 'Ivinhema', 'BR', 'MS'),
(11740, 31, 496, 'Japorã', 'BR', 'MS'),
(11741, 31, 496, 'Jaraguari', 'BR', 'MS'),
(11742, 31, 496, 'Jardim', 'BR', 'MS'),
(11743, 31, 496, 'Jateí', 'BR', 'MS'),
(11744, 31, 496, 'Juti', 'BR', 'MS'),
(11745, 31, 496, 'Ladário', 'BR', 'MS'),
(11746, 31, 496, 'Laguna Carapã', 'BR', 'MS'),
(11747, 31, 496, 'Maracaju', 'BR', 'MS'),
(11748, 31, 496, 'Miranda', 'BR', 'MS'),
(11749, 31, 496, 'Mundo Novo', 'BR', 'MS'),
(11750, 31, 496, 'Naviraí', 'BR', 'MS'),
(11751, 31, 496, 'Nioaque', 'BR', 'MS'),
(11752, 31, 496, 'Nova Alvorada do Sul', 'BR', 'MS'),
(11753, 31, 496, 'Nova Andradina', 'BR', 'MS'),
(11754, 31, 496, 'Novo Horizonte do Sul', 'BR', 'MS'),
(11755, 31, 496, 'Paraíso das Águas', 'BR', 'MS'),
(11756, 31, 496, 'Paranaíba', 'BR', 'MS'),
(11757, 31, 496, 'Paranhos', 'BR', 'MS'),
(11758, 31, 496, 'Pedro Gomes', 'BR', 'MS'),
(11759, 31, 496, 'Ponta Porã', 'BR', 'MS'),
(11760, 31, 496, 'Pôrto Barra do Ivinheima', 'BR', 'MS'),
(11761, 31, 496, 'Porto Murtinho', 'BR', 'MS'),
(11762, 31, 496, 'Ribas do Rio Pardo', 'BR', 'MS'),
(11763, 31, 496, 'Rio Brilhante', 'BR', 'MS'),
(11764, 31, 496, 'Rio Negro', 'BR', 'MS'),
(11765, 31, 496, 'Rio Verde de Mato Grosso', 'BR', 'MS'),
(11766, 31, 496, 'Rochedo', 'BR', 'MS'),
(11767, 31, 496, 'Santa Rita do Pardo', 'BR', 'MS'),
(11768, 31, 496, 'São Gabriel do Oeste', 'BR', 'MS'),
(11769, 31, 496, 'Selvíria', 'BR', 'MS'),
(11770, 31, 496, 'Sete Quedas', 'BR', 'MS'),
(11771, 31, 496, 'Sidrolândia', 'BR', 'MS'),
(11772, 31, 496, 'Sonora', 'BR', 'MS'),
(11773, 31, 496, 'Tacuru', 'BR', 'MS'),
(11774, 31, 496, 'Taquarussu', 'BR', 'MS'),
(11775, 31, 496, 'Terenos', 'BR', 'MS'),
(11776, 31, 496, 'Três Lagoas', 'BR', 'MS'),
(11777, 31, 496, 'Vicentina', 'BR', 'MS'),
(11778, 31, 497, 'Abadia dos Dourados', 'BR', 'MG'),
(11779, 31, 497, 'Abaeté', 'BR', 'MG'),
(11780, 31, 497, 'Abre Campo', 'BR', 'MG'),
(11781, 31, 497, 'Acaiaca', 'BR', 'MG'),
(11782, 31, 497, 'Açucena', 'BR', 'MG'),
(11783, 31, 497, 'Água Boa', 'BR', 'MG'),
(11784, 31, 497, 'Água Comprida', 'BR', 'MG'),
(11785, 31, 497, 'Aguanil', 'BR', 'MG'),
(11786, 31, 497, 'Águas Formosas', 'BR', 'MG'),
(11787, 31, 497, 'Águas Vermelhas', 'BR', 'MG'),
(11788, 31, 497, 'Aimorés', 'BR', 'MG'),
(11789, 31, 497, 'Aiuruoca', 'BR', 'MG'),
(11790, 31, 497, 'Alagoa', 'BR', 'MG'),
(11791, 31, 497, 'Albertina', 'BR', 'MG'),
(11792, 31, 497, 'Além Paraíba', 'BR', 'MG'),
(11793, 31, 497, 'Alfenas', 'BR', 'MG'),
(11794, 31, 497, 'Alfredo Vasconcelos', 'BR', 'MG'),
(11795, 31, 497, 'Almenara', 'BR', 'MG'),
(11796, 31, 497, 'Alpercata', 'BR', 'MG'),
(11797, 31, 497, 'Alpinópolis', 'BR', 'MG'),
(11798, 31, 497, 'Alterosa', 'BR', 'MG'),
(11799, 31, 497, 'Alto Caparaó', 'BR', 'MG'),
(11800, 31, 497, 'Alto Jequitibá', 'BR', 'MG'),
(11801, 31, 497, 'Alto Rio Doce', 'BR', 'MG'),
(11802, 31, 497, 'Alvarenga', 'BR', 'MG'),
(11803, 31, 497, 'Alvinópolis', 'BR', 'MG'),
(11804, 31, 497, 'Alvorada de Minas', 'BR', 'MG'),
(11805, 31, 497, 'Amparo da Serra', 'BR', 'MG'),
(11806, 31, 497, 'Andradas', 'BR', 'MG'),
(11807, 31, 497, 'Andrelândia', 'BR', 'MG'),
(11808, 31, 497, 'Angelândia', 'BR', 'MG'),
(11809, 31, 497, 'Antônio Carlos', 'BR', 'MG'),
(11810, 31, 497, 'Antônio Dias', 'BR', 'MG'),
(11811, 31, 497, 'Antônio Prado de Minas', 'BR', 'MG'),
(11812, 31, 497, 'Araçaí', 'BR', 'MG'),
(11813, 31, 497, 'Aracitaba', 'BR', 'MG'),
(11814, 31, 497, 'Araçuaí', 'BR', 'MG'),
(11815, 31, 497, 'Araguari', 'BR', 'MG'),
(11816, 31, 497, 'Arantina', 'BR', 'MG'),
(11817, 31, 497, 'Araponga', 'BR', 'MG'),
(11818, 31, 497, 'Araporã', 'BR', 'MG'),
(11819, 31, 497, 'Arapuá', 'BR', 'MG'),
(11820, 31, 497, 'Araújos', 'BR', 'MG'),
(11821, 31, 497, 'Araxá', 'BR', 'MG'),
(11822, 31, 497, 'Arceburgo', 'BR', 'MG'),
(11823, 31, 497, 'Arcos', 'BR', 'MG'),
(11824, 31, 497, 'Areado', 'BR', 'MG'),
(11825, 31, 497, 'Argirita', 'BR', 'MG'),
(11826, 31, 497, 'Aricanduva', 'BR', 'MG'),
(11827, 31, 497, 'Arinos', 'BR', 'MG'),
(11828, 31, 497, 'Astolfo Dutra', 'BR', 'MG'),
(11829, 31, 497, 'Ataléia', 'BR', 'MG'),
(11830, 31, 497, 'Augusto de Lima', 'BR', 'MG'),
(11831, 31, 497, 'Baependi', 'BR', 'MG'),
(11832, 31, 497, 'Baldim', 'BR', 'MG'),
(11833, 31, 497, 'Bambuí', 'BR', 'MG'),
(11834, 31, 497, 'Bandeira', 'BR', 'MG'),
(11835, 31, 497, 'Bandeira do Sul', 'BR', 'MG'),
(11836, 31, 497, 'Barão de Cocais', 'BR', 'MG'),
(11837, 31, 497, 'Barão de Monte Alto', 'BR', 'MG'),
(11838, 31, 497, 'Barbacena', 'BR', 'MG'),
(11839, 31, 497, 'Barra Longa', 'BR', 'MG'),
(11840, 31, 497, 'Barreiro do Jaíba', 'BR', 'MG'),
(11841, 31, 497, 'Barroso', 'BR', 'MG'),
(11842, 31, 497, 'Bela Vista de Minas', 'BR', 'MG'),
(11843, 31, 497, 'Belmiro Braga', 'BR', 'MG'),
(11844, 31, 497, 'Belo Horizonte', 'BR', 'MG'),
(11845, 31, 497, 'Belo Oriente', 'BR', 'MG'),
(11846, 31, 497, 'Belo Vale', 'BR', 'MG'),
(11847, 31, 497, 'Berilo', 'BR', 'MG'),
(11848, 31, 497, 'Berizal', 'BR', 'MG'),
(11849, 31, 497, 'Bertópolis', 'BR', 'MG'),
(11850, 31, 497, 'Betim', 'BR', 'MG'),
(11851, 31, 497, 'Bias Fortes', 'BR', 'MG'),
(11852, 31, 497, 'Bicas', 'BR', 'MG'),
(11853, 31, 497, 'Biquinhas', 'BR', 'MG'),
(11854, 31, 497, 'Boa Esperança', 'BR', 'MG'),
(11855, 31, 497, 'Bocaina de Minas', 'BR', 'MG'),
(11856, 31, 497, 'Bocaiúva', 'BR', 'MG'),
(11857, 31, 497, 'Bom Despacho', 'BR', 'MG'),
(11858, 31, 497, 'Bom Jardim de Minas', 'BR', 'MG'),
(11859, 31, 497, 'Bom Jesus da Penha', 'BR', 'MG'),
(11860, 31, 497, 'Bom Jesus do Amparo', 'BR', 'MG'),
(11861, 31, 497, 'Bom Jesus do Galho', 'BR', 'MG'),
(11862, 31, 497, 'Bom Repouso', 'BR', 'MG'),
(11863, 31, 497, 'Bom Sucesso', 'BR', 'MG'),
(11864, 31, 497, 'Bonfim', 'BR', 'MG'),
(11865, 31, 497, 'Bonfinópolis de Minas', 'BR', 'MG'),
(11866, 31, 497, 'Bonito de Minas', 'BR', 'MG'),
(11867, 31, 497, 'Borda da Mata', 'BR', 'MG'),
(11868, 31, 497, 'Botelhos', 'BR', 'MG'),
(11869, 31, 497, 'Botumirim', 'BR', 'MG'),
(11870, 31, 497, 'Brás Pires', 'BR', 'MG'),
(11871, 31, 497, 'Brasilândia de Minas', 'BR', 'MG'),
(11872, 31, 497, 'Brasília de Minas', 'BR', 'MG'),
(11873, 31, 497, 'Braúnas', 'BR', 'MG'),
(11874, 31, 497, 'Brazópolis', 'BR', 'MG'),
(11875, 31, 497, 'Brumadinho', 'BR', 'MG'),
(11876, 31, 497, 'Bueno Brandão', 'BR', 'MG'),
(11877, 31, 497, 'Buenópolis', 'BR', 'MG'),
(11878, 31, 497, 'Bugre', 'BR', 'MG'),
(11879, 31, 497, 'Buritis', 'BR', 'MG'),
(11880, 31, 497, 'Buritizeiro', 'BR', 'MG'),
(11881, 31, 497, 'Cabeceira Grande', 'BR', 'MG'),
(11882, 31, 497, 'Cabo Verde', 'BR', 'MG'),
(11883, 31, 497, 'Cachoeira da Prata', 'BR', 'MG'),
(11884, 31, 497, 'Cachoeira de Minas', 'BR', 'MG'),
(11885, 31, 497, 'Cachoeira de Pajeú', 'BR', 'MG'),
(11886, 31, 497, 'Cachoeira Dourada', 'BR', 'MG'),
(11887, 31, 497, 'Caetanópolis', 'BR', 'MG'),
(11888, 31, 497, 'Caeté', 'BR', 'MG'),
(11889, 31, 497, 'Caiana', 'BR', 'MG'),
(11890, 31, 497, 'Cajuri', 'BR', 'MG'),
(11891, 31, 497, 'Caldas', 'BR', 'MG'),
(11892, 31, 497, 'Camacho', 'BR', 'MG'),
(11893, 31, 497, 'Camanducaia', 'BR', 'MG'),
(11894, 31, 497, 'Cambuí', 'BR', 'MG'),
(11895, 31, 497, 'Cambuquira', 'BR', 'MG'),
(11896, 31, 497, 'Campanário', 'BR', 'MG'),
(11897, 31, 497, 'Campanha', 'BR', 'MG'),
(11898, 31, 497, 'Campestre', 'BR', 'MG'),
(11899, 31, 497, 'Campina Verde', 'BR', 'MG'),
(11900, 31, 497, 'Campo Azul', 'BR', 'MG'),
(11901, 31, 497, 'Campo Belo', 'BR', 'MG'),
(11902, 31, 497, 'Campo do Meio', 'BR', 'MG'),
(11903, 31, 497, 'Campo Florido', 'BR', 'MG'),
(11904, 31, 497, 'Campos Altos', 'BR', 'MG'),
(11905, 31, 497, 'Campos Gerais', 'BR', 'MG'),
(11906, 31, 497, 'Cana Verde', 'BR', 'MG'),
(11907, 31, 497, 'Canaã', 'BR', 'MG'),
(11908, 31, 497, 'Canápolis', 'BR', 'MG'),
(11909, 31, 497, 'Candeias', 'BR', 'MG'),
(11910, 31, 497, 'Cantagalo', 'BR', 'MG'),
(11911, 31, 497, 'Caparaó', 'BR', 'MG'),
(11912, 31, 497, 'Capela Nova', 'BR', 'MG'),
(11913, 31, 497, 'Capelinha', 'BR', 'MG'),
(11914, 31, 497, 'Capetinga', 'BR', 'MG'),
(11915, 31, 497, 'Capim Branco', 'BR', 'MG'),
(11916, 31, 497, 'Capinópolis', 'BR', 'MG'),
(11917, 31, 497, 'Capitão Andrade', 'BR', 'MG'),
(11918, 31, 497, 'Capitão Enéas', 'BR', 'MG'),
(11919, 31, 497, 'Capitólio', 'BR', 'MG'),
(11920, 31, 497, 'Caputira', 'BR', 'MG'),
(11921, 31, 497, 'Caraí', 'BR', 'MG'),
(11922, 31, 497, 'Caranaíba', 'BR', 'MG'),
(11923, 31, 497, 'Carandaí', 'BR', 'MG'),
(11924, 31, 497, 'Carangola', 'BR', 'MG'),
(11925, 31, 497, 'Caratinga', 'BR', 'MG'),
(11926, 31, 497, 'Carbonita', 'BR', 'MG'),
(11927, 31, 497, 'Careaçu', 'BR', 'MG'),
(11928, 31, 497, 'Carlos Chagas', 'BR', 'MG'),
(11929, 31, 497, 'Carmésia', 'BR', 'MG'),
(11930, 31, 497, 'Carmo da Cachoeira', 'BR', 'MG'),
(11931, 31, 497, 'Carmo da Mata', 'BR', 'MG'),
(11932, 31, 497, 'Carmo de Minas', 'BR', 'MG'),
(11933, 31, 497, 'Carmo do Cajuru', 'BR', 'MG'),
(11934, 31, 497, 'Carmo do Paranaíba', 'BR', 'MG'),
(11935, 31, 497, 'Carmo do Rio Claro', 'BR', 'MG'),
(11936, 31, 497, 'Carmópolis de Minas', 'BR', 'MG'),
(11937, 31, 497, 'Carneirinho', 'BR', 'MG'),
(11938, 31, 497, 'Carrancas', 'BR', 'MG'),
(11939, 31, 497, 'Carvalhópolis', 'BR', 'MG'),
(11940, 31, 497, 'Carvalhos', 'BR', 'MG'),
(11941, 31, 497, 'Casa Grande', 'BR', 'MG'),
(11942, 31, 497, 'Cascalho Rico', 'BR', 'MG'),
(11943, 31, 497, 'Cássia', 'BR', 'MG'),
(11944, 31, 497, 'Cataguases', 'BR', 'MG'),
(11945, 31, 497, 'Catas Altas', 'BR', 'MG'),
(11946, 31, 497, 'Catas Altas da Noruega', 'BR', 'MG'),
(11947, 31, 497, 'Catuji', 'BR', 'MG'),
(11948, 31, 497, 'Catuti', 'BR', 'MG'),
(11949, 31, 497, 'Caxambu', 'BR', 'MG'),
(11950, 31, 497, 'Cedro do Abaeté', 'BR', 'MG'),
(11951, 31, 497, 'Central de Minas', 'BR', 'MG'),
(11952, 31, 497, 'Centralina', 'BR', 'MG'),
(11953, 31, 497, 'Chácara', 'BR', 'MG'),
(11954, 31, 497, 'Chalé', 'BR', 'MG'),
(11955, 31, 497, 'Chapada do Norte', 'BR', 'MG'),
(11956, 31, 497, 'Chapada Gaúcha', 'BR', 'MG'),
(11957, 31, 497, 'Chiador', 'BR', 'MG'),
(11958, 31, 497, 'Cipotânea', 'BR', 'MG'),
(11959, 31, 497, 'Claraval', 'BR', 'MG'),
(11960, 31, 497, 'Claro dos Poções', 'BR', 'MG'),
(11961, 31, 497, 'Cláudio', 'BR', 'MG'),
(11962, 31, 497, 'Coimbra', 'BR', 'MG'),
(11963, 31, 497, 'Coluna', 'BR', 'MG'),
(11964, 31, 497, 'Comendador Gomes', 'BR', 'MG'),
(11965, 31, 497, 'Comercinho', 'BR', 'MG'),
(11966, 31, 497, 'Conceição da Aparecida', 'BR', 'MG'),
(11967, 31, 497, 'Conceição da Barra de Minas', 'BR', 'MG'),
(11968, 31, 497, 'Conceição das Alagoas', 'BR', 'MG'),
(11969, 31, 497, 'Conceição das Pedras', 'BR', 'MG'),
(11970, 31, 497, 'Conceição de Ipanema', 'BR', 'MG'),
(11971, 31, 497, 'Conceição do Mato Dentro', 'BR', 'MG'),
(11972, 31, 497, 'Conceição do Pará', 'BR', 'MG'),
(11973, 31, 497, 'Conceição do Rio Verde', 'BR', 'MG'),
(11974, 31, 497, 'Conceição dos Ouros', 'BR', 'MG'),
(11975, 31, 497, 'Cônego Marinho', 'BR', 'MG'),
(11976, 31, 497, 'Confins', 'BR', 'MG'),
(11977, 31, 497, 'Congonhal', 'BR', 'MG'),
(11978, 31, 497, 'Congonhas', 'BR', 'MG'),
(11979, 31, 497, 'Congonhas do Norte', 'BR', 'MG'),
(11980, 31, 497, 'Conquista', 'BR', 'MG'),
(11981, 31, 497, 'Conselheiro Lafaiete', 'BR', 'MG'),
(11982, 31, 497, 'Conselheiro Pena', 'BR', 'MG'),
(11983, 31, 497, 'Consolação', 'BR', 'MG'),
(11984, 31, 497, 'Contagem', 'BR', 'MG'),
(11985, 31, 497, 'Coqueiral', 'BR', 'MG'),
(11986, 31, 497, 'Coração de Jesus', 'BR', 'MG'),
(11987, 31, 497, 'Cordisburgo', 'BR', 'MG'),
(11988, 31, 497, 'Cordislândia', 'BR', 'MG'),
(11989, 31, 497, 'Corinto', 'BR', 'MG'),
(11990, 31, 497, 'Coroaci', 'BR', 'MG'),
(11991, 31, 497, 'Coromandel', 'BR', 'MG'),
(11992, 31, 497, 'Coronel Fabriciano', 'BR', 'MG'),
(11993, 31, 497, 'Coronel Murta', 'BR', 'MG'),
(11994, 31, 497, 'Coronel Pacheco', 'BR', 'MG'),
(11995, 31, 497, 'Coronel Xavier Chaves', 'BR', 'MG'),
(11996, 31, 497, 'Córrego Danta', 'BR', 'MG'),
(11997, 31, 497, 'Córrego do Bom Jesus', 'BR', 'MG'),
(11998, 31, 497, 'Córrego Fundo', 'BR', 'MG'),
(11999, 31, 497, 'Córrego Novo', 'BR', 'MG'),
(12000, 31, 497, 'Couto de Magalhães de Minas', 'BR', 'MG');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(12001, 31, 497, 'Crisólita', 'BR', 'MG'),
(12002, 31, 497, 'Cristais', 'BR', 'MG'),
(12003, 31, 497, 'Cristália', 'BR', 'MG'),
(12004, 31, 497, 'Cristiano Otoni', 'BR', 'MG'),
(12005, 31, 497, 'Cristina', 'BR', 'MG'),
(12006, 31, 497, 'Crucilândia', 'BR', 'MG'),
(12007, 31, 497, 'Cruzeiro da Fortaleza', 'BR', 'MG'),
(12008, 31, 497, 'Cruzília', 'BR', 'MG'),
(12009, 31, 497, 'Cuparaque', 'BR', 'MG'),
(12010, 31, 497, 'Curral de Dentro', 'BR', 'MG'),
(12011, 31, 497, 'Curvelo', 'BR', 'MG'),
(12012, 31, 497, 'Datas', 'BR', 'MG'),
(12013, 31, 497, 'Delfim Moreira', 'BR', 'MG'),
(12014, 31, 497, 'Delfinópolis', 'BR', 'MG'),
(12015, 31, 497, 'Delta', 'BR', 'MG'),
(12016, 31, 497, 'Descoberto', 'BR', 'MG'),
(12017, 31, 497, 'Desterro de Entre Rios', 'BR', 'MG'),
(12018, 31, 497, 'Desterro do Melo', 'BR', 'MG'),
(12019, 31, 497, 'Diamantina', 'BR', 'MG'),
(12020, 31, 497, 'Diogo de Vasconcelos', 'BR', 'MG'),
(12021, 31, 497, 'Dionísio', 'BR', 'MG'),
(12022, 31, 497, 'Divinésia', 'BR', 'MG'),
(12023, 31, 497, 'Divino', 'BR', 'MG'),
(12024, 31, 497, 'Divino das Laranjeiras', 'BR', 'MG'),
(12025, 31, 497, 'Divinolândia de Minas', 'BR', 'MG'),
(12026, 31, 497, 'Divinópolis', 'BR', 'MG'),
(12027, 31, 497, 'Divisa Alegre', 'BR', 'MG'),
(12028, 31, 497, 'Divisa Nova', 'BR', 'MG'),
(12029, 31, 497, 'Divisópolis', 'BR', 'MG'),
(12030, 31, 497, 'Dom Bosco', 'BR', 'MG'),
(12031, 31, 497, 'Dom Cavati', 'BR', 'MG'),
(12032, 31, 497, 'Dom Joaquim', 'BR', 'MG'),
(12033, 31, 497, 'Dom Silvério', 'BR', 'MG'),
(12034, 31, 497, 'Dom Viçoso', 'BR', 'MG'),
(12035, 31, 497, 'Dona Eusébia', 'BR', 'MG'),
(12036, 31, 497, 'Dores de Campos', 'BR', 'MG'),
(12037, 31, 497, 'Dores de Guanhães', 'BR', 'MG'),
(12038, 31, 497, 'Dores do Indaiá', 'BR', 'MG'),
(12039, 31, 497, 'Dores do Turvo', 'BR', 'MG'),
(12040, 31, 497, 'Doresópolis', 'BR', 'MG'),
(12041, 31, 497, 'Douradoquara', 'BR', 'MG'),
(12042, 31, 497, 'Durandé', 'BR', 'MG'),
(12043, 31, 497, 'Elói Mendes', 'BR', 'MG'),
(12044, 31, 497, 'Engenheiro Caldas', 'BR', 'MG'),
(12045, 31, 497, 'Engenheiro Navarro', 'BR', 'MG'),
(12046, 31, 497, 'Entre Folhas', 'BR', 'MG'),
(12047, 31, 497, 'Entre Rios de Minas', 'BR', 'MG'),
(12048, 31, 497, 'Ervália', 'BR', 'MG'),
(12049, 31, 497, 'Esmeraldas', 'BR', 'MG'),
(12050, 31, 497, 'Espera Feliz', 'BR', 'MG'),
(12051, 31, 497, 'Espinosa', 'BR', 'MG'),
(12052, 31, 497, 'Espírito Santo do Dourado', 'BR', 'MG'),
(12053, 31, 497, 'Estiva', 'BR', 'MG'),
(12054, 31, 497, 'Estrela Dalva', 'BR', 'MG'),
(12055, 31, 497, 'Estrela do Indaiá', 'BR', 'MG'),
(12056, 31, 497, 'Estrela do Sul', 'BR', 'MG'),
(12057, 31, 497, 'Eugenópolis', 'BR', 'MG'),
(12058, 31, 497, 'Ewbank da Câmara', 'BR', 'MG'),
(12059, 31, 497, 'Extrema', 'BR', 'MG'),
(12060, 31, 497, 'Fama', 'BR', 'MG'),
(12061, 31, 497, 'Faria Lemos', 'BR', 'MG'),
(12062, 31, 497, 'Felício dos Santos', 'BR', 'MG'),
(12063, 31, 497, 'Felisburgo', 'BR', 'MG'),
(12064, 31, 497, 'Felixlândia', 'BR', 'MG'),
(12065, 31, 497, 'Fernandes Tourinho', 'BR', 'MG'),
(12066, 31, 497, 'Ferros', 'BR', 'MG'),
(12067, 31, 497, 'Fervedouro', 'BR', 'MG'),
(12068, 31, 497, 'Florestal', 'BR', 'MG'),
(12069, 31, 497, 'Formiga', 'BR', 'MG'),
(12070, 31, 497, 'Formoso', 'BR', 'MG'),
(12071, 31, 497, 'Fortaleza de Minas', 'BR', 'MG'),
(12072, 31, 497, 'Fortuna de Minas', 'BR', 'MG'),
(12073, 31, 497, 'Francisco Badaró', 'BR', 'MG'),
(12074, 31, 497, 'Francisco Dumont', 'BR', 'MG'),
(12075, 31, 497, 'Francisco Sá', 'BR', 'MG'),
(12076, 31, 497, 'Franciscópolis', 'BR', 'MG'),
(12077, 31, 497, 'Frei Gaspar', 'BR', 'MG'),
(12078, 31, 497, 'Frei Inocêncio', 'BR', 'MG'),
(12079, 31, 497, 'Frei Lagonegro', 'BR', 'MG'),
(12080, 31, 497, 'Fronteira', 'BR', 'MG'),
(12081, 31, 497, 'Fronteira dos Vales', 'BR', 'MG'),
(12082, 31, 497, 'Fruta de Leite', 'BR', 'MG'),
(12083, 31, 497, 'Frutal', 'BR', 'MG'),
(12084, 31, 497, 'Funilândia', 'BR', 'MG'),
(12085, 31, 497, 'Galiléia', 'BR', 'MG'),
(12086, 31, 497, 'Gameleiras', 'BR', 'MG'),
(12087, 31, 497, 'Glaucilândia', 'BR', 'MG'),
(12088, 31, 497, 'Goiabeira', 'BR', 'MG'),
(12089, 31, 497, 'Goianá', 'BR', 'MG'),
(12090, 31, 497, 'Gonçalves', 'BR', 'MG'),
(12091, 31, 497, 'Gonzaga', 'BR', 'MG'),
(12092, 31, 497, 'Gouveia', 'BR', 'MG'),
(12093, 31, 497, 'Governador Valadares', 'BR', 'MG'),
(12094, 31, 497, 'Grão Mogol', 'BR', 'MG'),
(12095, 31, 497, 'Grupiara', 'BR', 'MG'),
(12096, 31, 497, 'Guanhães', 'BR', 'MG'),
(12097, 31, 497, 'Guapé', 'BR', 'MG'),
(12098, 31, 497, 'Guaraciaba', 'BR', 'MG'),
(12099, 31, 497, 'Guaraciama', 'BR', 'MG'),
(12100, 31, 497, 'Guaranésia', 'BR', 'MG'),
(12101, 31, 497, 'Guarani', 'BR', 'MG'),
(12102, 31, 497, 'Guarará', 'BR', 'MG'),
(12103, 31, 497, 'Guarda-Mor', 'BR', 'MG'),
(12104, 31, 497, 'Guaxupé', 'BR', 'MG'),
(12105, 31, 497, 'Guidoval', 'BR', 'MG'),
(12106, 31, 497, 'Guimarânia', 'BR', 'MG'),
(12107, 31, 497, 'Guiricema', 'BR', 'MG'),
(12108, 31, 497, 'Gurinhatã', 'BR', 'MG'),
(12109, 31, 497, 'Heliodora', 'BR', 'MG'),
(12110, 31, 497, 'Iapu', 'BR', 'MG'),
(12111, 31, 497, 'Ibertioga', 'BR', 'MG'),
(12112, 31, 497, 'Ibiá', 'BR', 'MG'),
(12113, 31, 497, 'Ibiaí', 'BR', 'MG'),
(12114, 31, 497, 'Ibiracatu', 'BR', 'MG'),
(12115, 31, 497, 'Ibiraci', 'BR', 'MG'),
(12116, 31, 497, 'Ibirité', 'BR', 'MG'),
(12117, 31, 497, 'Ibitiúra de Minas', 'BR', 'MG'),
(12118, 31, 497, 'Ibituruna', 'BR', 'MG'),
(12119, 31, 497, 'Icaraí de Minas', 'BR', 'MG'),
(12120, 31, 497, 'Igarapé', 'BR', 'MG'),
(12121, 31, 497, 'Igaratinga', 'BR', 'MG'),
(12122, 31, 497, 'Iguatama', 'BR', 'MG'),
(12123, 31, 497, 'Ijaci', 'BR', 'MG'),
(12124, 31, 497, 'Ilicínea', 'BR', 'MG'),
(12125, 31, 497, 'Imbé de Minas', 'BR', 'MG'),
(12126, 31, 497, 'Inconfidentes', 'BR', 'MG'),
(12127, 31, 497, 'Indaiabira', 'BR', 'MG'),
(12128, 31, 497, 'Indianópolis', 'BR', 'MG'),
(12129, 31, 497, 'Ingaí', 'BR', 'MG'),
(12130, 31, 497, 'Inhapim', 'BR', 'MG'),
(12131, 31, 497, 'Inhaúma', 'BR', 'MG'),
(12132, 31, 497, 'Inimutaba', 'BR', 'MG'),
(12133, 31, 497, 'Ipaba', 'BR', 'MG'),
(12134, 31, 497, 'Ipanema', 'BR', 'MG'),
(12135, 31, 497, 'Ipatinga', 'BR', 'MG'),
(12136, 31, 497, 'Ipiaçu', 'BR', 'MG'),
(12137, 31, 497, 'Ipuiúna', 'BR', 'MG'),
(12138, 31, 497, 'Iraí de Minas', 'BR', 'MG'),
(12139, 31, 497, 'Itabira', 'BR', 'MG'),
(12140, 31, 497, 'Itabirinha', 'BR', 'MG'),
(12141, 31, 497, 'Itabirito', 'BR', 'MG'),
(12142, 31, 497, 'Itacambira', 'BR', 'MG'),
(12143, 31, 497, 'Itacarambi', 'BR', 'MG'),
(12144, 31, 497, 'Itaguara', 'BR', 'MG'),
(12145, 31, 497, 'Itaipé', 'BR', 'MG'),
(12146, 31, 497, 'Itajubá', 'BR', 'MG'),
(12147, 31, 497, 'Itamarandiba', 'BR', 'MG'),
(12148, 31, 497, 'Itamarati de Minas', 'BR', 'MG'),
(12149, 31, 497, 'Itambacuri', 'BR', 'MG'),
(12150, 31, 497, 'Itambé do Mato Dentro', 'BR', 'MG'),
(12151, 31, 497, 'Itamogi', 'BR', 'MG'),
(12152, 31, 497, 'Itamonte', 'BR', 'MG'),
(12153, 31, 497, 'Itanhandu', 'BR', 'MG'),
(12154, 31, 497, 'Itanhomi', 'BR', 'MG'),
(12155, 31, 497, 'Itaobim', 'BR', 'MG'),
(12156, 31, 497, 'Itapagipe', 'BR', 'MG'),
(12157, 31, 497, 'Itapecerica', 'BR', 'MG'),
(12158, 31, 497, 'Itapeva', 'BR', 'MG'),
(12159, 31, 497, 'Itatiaiuçu', 'BR', 'MG'),
(12160, 31, 497, 'Itaú de Minas', 'BR', 'MG'),
(12161, 31, 497, 'Itaúna', 'BR', 'MG'),
(12162, 31, 497, 'Itaverava', 'BR', 'MG'),
(12163, 31, 497, 'Itinga', 'BR', 'MG'),
(12164, 31, 497, 'Itueta', 'BR', 'MG'),
(12165, 31, 497, 'Ituiutaba', 'BR', 'MG'),
(12166, 31, 497, 'Itumirim', 'BR', 'MG'),
(12167, 31, 497, 'Iturama', 'BR', 'MG'),
(12168, 31, 497, 'Itutinga', 'BR', 'MG'),
(12169, 31, 497, 'Jaboticatubas', 'BR', 'MG'),
(12170, 31, 497, 'Jacinto', 'BR', 'MG'),
(12171, 31, 497, 'Jacuí', 'BR', 'MG'),
(12172, 31, 497, 'Jacutinga', 'BR', 'MG'),
(12173, 31, 497, 'Jaguaraçu', 'BR', 'MG'),
(12174, 31, 497, 'Jaíba', 'BR', 'MG'),
(12175, 31, 497, 'Jampruca', 'BR', 'MG'),
(12176, 31, 497, 'Janaúba', 'BR', 'MG'),
(12177, 31, 497, 'Januária', 'BR', 'MG'),
(12178, 31, 497, 'Japaraíba', 'BR', 'MG'),
(12179, 31, 497, 'Japonvar', 'BR', 'MG'),
(12180, 31, 497, 'Jeceaba', 'BR', 'MG'),
(12181, 31, 497, 'Jenipapo de Minas', 'BR', 'MG'),
(12182, 31, 497, 'Jequeri', 'BR', 'MG'),
(12183, 31, 497, 'Jequitaí', 'BR', 'MG'),
(12184, 31, 497, 'Jequitibá', 'BR', 'MG'),
(12185, 31, 497, 'Jequitinhonha', 'BR', 'MG'),
(12186, 31, 497, 'Jesuânia', 'BR', 'MG'),
(12187, 31, 497, 'Joaíma', 'BR', 'MG'),
(12188, 31, 497, 'Joanésia', 'BR', 'MG'),
(12189, 31, 497, 'João Monlevade', 'BR', 'MG'),
(12190, 31, 497, 'João Pinheiro', 'BR', 'MG'),
(12191, 31, 497, 'Joaquim Felício', 'BR', 'MG'),
(12192, 31, 497, 'Jordânia', 'BR', 'MG'),
(12193, 31, 497, 'José Gonçalves de Minas', 'BR', 'MG'),
(12194, 31, 497, 'José Raydan', 'BR', 'MG'),
(12195, 31, 497, 'Josenópolis', 'BR', 'MG'),
(12196, 31, 497, 'Juatuba', 'BR', 'MG'),
(12197, 31, 497, 'Juiz de Fora', 'BR', 'MG'),
(12198, 31, 497, 'Juramento', 'BR', 'MG'),
(12199, 31, 497, 'Juruaia', 'BR', 'MG'),
(12200, 31, 497, 'Juvenília', 'BR', 'MG'),
(12201, 31, 497, 'Ladainha', 'BR', 'MG'),
(12202, 31, 497, 'Lagamar', 'BR', 'MG'),
(12203, 31, 497, 'Lagoa da Prata', 'BR', 'MG'),
(12204, 31, 497, 'Lagoa dos Patos', 'BR', 'MG'),
(12205, 31, 497, 'Lagoa Dourada', 'BR', 'MG'),
(12206, 31, 497, 'Lagoa Formosa', 'BR', 'MG'),
(12207, 31, 497, 'Lagoa Grande', 'BR', 'MG'),
(12208, 31, 497, 'Lagoa Santa', 'BR', 'MG'),
(12209, 31, 497, 'Lajinha', 'BR', 'MG'),
(12210, 31, 497, 'Lambari', 'BR', 'MG'),
(12211, 31, 497, 'Lamim', 'BR', 'MG'),
(12212, 31, 497, 'Laranjal', 'BR', 'MG'),
(12213, 31, 497, 'Lassance', 'BR', 'MG'),
(12214, 31, 497, 'Lavras', 'BR', 'MG'),
(12215, 31, 497, 'Leandro Ferreira', 'BR', 'MG'),
(12216, 31, 497, 'Leme do Prado', 'BR', 'MG'),
(12217, 31, 497, 'Leopoldina', 'BR', 'MG'),
(12218, 31, 497, 'Liberdade', 'BR', 'MG'),
(12219, 31, 497, 'Lima Duarte', 'BR', 'MG'),
(12220, 31, 497, 'Limeira do Oeste', 'BR', 'MG'),
(12221, 31, 497, 'Lontra', 'BR', 'MG'),
(12222, 31, 497, 'Luisburgo', 'BR', 'MG'),
(12223, 31, 497, 'Luislândia', 'BR', 'MG'),
(12224, 31, 497, 'Luminárias', 'BR', 'MG'),
(12225, 31, 497, 'Luz', 'BR', 'MG'),
(12226, 31, 497, 'Machacalis', 'BR', 'MG'),
(12227, 31, 497, 'Machado', 'BR', 'MG'),
(12228, 31, 497, 'Madre de Deus de Minas', 'BR', 'MG'),
(12229, 31, 497, 'Malacacheta', 'BR', 'MG'),
(12230, 31, 497, 'Mamonas', 'BR', 'MG'),
(12231, 31, 497, 'Manga', 'BR', 'MG'),
(12232, 31, 497, 'Manhuaçu', 'BR', 'MG'),
(12233, 31, 497, 'Manhumirim', 'BR', 'MG'),
(12234, 31, 497, 'Mantena', 'BR', 'MG'),
(12235, 31, 497, 'Mar de Espanha', 'BR', 'MG'),
(12236, 31, 497, 'Maravilhas', 'BR', 'MG'),
(12237, 31, 497, 'Maria da Fé', 'BR', 'MG'),
(12238, 31, 497, 'Mariana', 'BR', 'MG'),
(12239, 31, 497, 'Marilac', 'BR', 'MG'),
(12240, 31, 497, 'Mário Campos', 'BR', 'MG'),
(12241, 31, 497, 'Maripá de Minas', 'BR', 'MG'),
(12242, 31, 497, 'Marliéria', 'BR', 'MG'),
(12243, 31, 497, 'Marmelópolis', 'BR', 'MG'),
(12244, 31, 497, 'Martinho Campos', 'BR', 'MG'),
(12245, 31, 497, 'Martins Soares', 'BR', 'MG'),
(12246, 31, 497, 'Mata Verde', 'BR', 'MG'),
(12247, 31, 497, 'Materlândia', 'BR', 'MG'),
(12248, 31, 497, 'Mateus Leme', 'BR', 'MG'),
(12249, 31, 497, 'Mathias Lobato', 'BR', 'MG'),
(12250, 31, 497, 'Matias Barbosa', 'BR', 'MG'),
(12251, 31, 497, 'Matias Cardoso', 'BR', 'MG'),
(12252, 31, 497, 'Matipó', 'BR', 'MG'),
(12253, 31, 497, 'Mato Verde', 'BR', 'MG'),
(12254, 31, 497, 'Matozinhos', 'BR', 'MG'),
(12255, 31, 497, 'Matutina', 'BR', 'MG'),
(12256, 31, 497, 'Medeiros', 'BR', 'MG'),
(12257, 31, 497, 'Medina', 'BR', 'MG'),
(12258, 31, 497, 'Mendes Pimentel', 'BR', 'MG'),
(12259, 31, 497, 'Mercês', 'BR', 'MG'),
(12260, 31, 497, 'Mesquita', 'BR', 'MG'),
(12261, 31, 497, 'Minas Novas', 'BR', 'MG'),
(12262, 31, 497, 'Minduri', 'BR', 'MG'),
(12263, 31, 497, 'Mirabela', 'BR', 'MG'),
(12264, 31, 497, 'Miradouro', 'BR', 'MG'),
(12265, 31, 497, 'Miraí', 'BR', 'MG'),
(12266, 31, 497, 'Miravânia', 'BR', 'MG'),
(12267, 31, 497, 'Moeda', 'BR', 'MG'),
(12268, 31, 497, 'Moema', 'BR', 'MG'),
(12269, 31, 497, 'Monjolos', 'BR', 'MG'),
(12270, 31, 497, 'Monsenhor Paulo', 'BR', 'MG'),
(12271, 31, 497, 'Montalvânia', 'BR', 'MG'),
(12272, 31, 497, 'Monte Alegre de Minas', 'BR', 'MG'),
(12273, 31, 497, 'Monte Azul', 'BR', 'MG'),
(12274, 31, 497, 'Monte Belo', 'BR', 'MG'),
(12275, 31, 497, 'Monte Carmelo', 'BR', 'MG'),
(12276, 31, 497, 'Monte Formoso', 'BR', 'MG'),
(12277, 31, 497, 'Monte Santo de Minas', 'BR', 'MG'),
(12278, 31, 497, 'Monte Sião', 'BR', 'MG'),
(12279, 31, 497, 'Monte Verde', 'BR', 'MG'),
(12280, 31, 497, 'Montes Claros', 'BR', 'MG'),
(12281, 31, 497, 'Montezuma', 'BR', 'MG'),
(12282, 31, 497, 'Morada Nova de Minas', 'BR', 'MG'),
(12283, 31, 497, 'Morro da Garça', 'BR', 'MG'),
(12284, 31, 497, 'Morro do Pilar', 'BR', 'MG'),
(12285, 31, 497, 'Munhoz', 'BR', 'MG'),
(12286, 31, 497, 'Muriaé', 'BR', 'MG'),
(12287, 31, 497, 'Mutum', 'BR', 'MG'),
(12288, 31, 497, 'Muzambinho', 'BR', 'MG'),
(12289, 31, 497, 'Nacip Raydan', 'BR', 'MG'),
(12290, 31, 497, 'Nanuque', 'BR', 'MG'),
(12291, 31, 497, 'Naque', 'BR', 'MG'),
(12292, 31, 497, 'Natalândia', 'BR', 'MG'),
(12293, 31, 497, 'Natércia', 'BR', 'MG'),
(12294, 31, 497, 'Nazareno', 'BR', 'MG'),
(12295, 31, 497, 'Nepomuceno', 'BR', 'MG'),
(12296, 31, 497, 'Ninheira', 'BR', 'MG'),
(12297, 31, 497, 'Nova Belém', 'BR', 'MG'),
(12298, 31, 497, 'Nova Era', 'BR', 'MG'),
(12299, 31, 497, 'Nova Lima', 'BR', 'MG'),
(12300, 31, 497, 'Nova Módica', 'BR', 'MG'),
(12301, 31, 497, 'Nova Ponte', 'BR', 'MG'),
(12302, 31, 497, 'Nova Porteirinha', 'BR', 'MG'),
(12303, 31, 497, 'Nova Resende', 'BR', 'MG'),
(12304, 31, 497, 'Nova Serrana', 'BR', 'MG'),
(12305, 31, 497, 'Nova União', 'BR', 'MG'),
(12306, 31, 497, 'Novo Cruzeiro', 'BR', 'MG'),
(12307, 31, 497, 'Novo Oriente de Minas', 'BR', 'MG'),
(12308, 31, 497, 'Novorizonte', 'BR', 'MG'),
(12309, 31, 497, 'Olaria', 'BR', 'MG'),
(12310, 31, 497, 'Olhos-d\'Água', 'BR', 'MG'),
(12311, 31, 497, 'Olímpio Noronha', 'BR', 'MG'),
(12312, 31, 497, 'Oliveira', 'BR', 'MG'),
(12313, 31, 497, 'Oliveira Fortes', 'BR', 'MG'),
(12314, 31, 497, 'Onça de Pitangui', 'BR', 'MG'),
(12315, 31, 497, 'Oratórios', 'BR', 'MG'),
(12316, 31, 497, 'Orizânia', 'BR', 'MG'),
(12317, 31, 497, 'Ouro Branco', 'BR', 'MG'),
(12318, 31, 497, 'Ouro Fino', 'BR', 'MG'),
(12319, 31, 497, 'Ouro Preto', 'BR', 'MG'),
(12320, 31, 497, 'Ouro Verde de Minas', 'BR', 'MG'),
(12321, 31, 497, 'Padre Carvalho', 'BR', 'MG'),
(12322, 31, 497, 'Padre Paraíso', 'BR', 'MG'),
(12323, 31, 497, 'Pai Pedro', 'BR', 'MG'),
(12324, 31, 497, 'Paineiras', 'BR', 'MG'),
(12325, 31, 497, 'Pains', 'BR', 'MG'),
(12326, 31, 497, 'Paiva', 'BR', 'MG'),
(12327, 31, 497, 'Palma', 'BR', 'MG'),
(12328, 31, 497, 'Palmópolis', 'BR', 'MG'),
(12329, 31, 497, 'Papagaios', 'BR', 'MG'),
(12330, 31, 497, 'Pará de Minas', 'BR', 'MG'),
(12331, 31, 497, 'Paracatu', 'BR', 'MG'),
(12332, 31, 497, 'Paraguaçu', 'BR', 'MG'),
(12333, 31, 497, 'Paraisópolis', 'BR', 'MG'),
(12334, 31, 497, 'Paraopeba', 'BR', 'MG'),
(12335, 31, 497, 'Passa Quatro', 'BR', 'MG'),
(12336, 31, 497, 'Passa Tempo', 'BR', 'MG'),
(12337, 31, 497, 'Passa-Vinte', 'BR', 'MG'),
(12338, 31, 497, 'Passabém', 'BR', 'MG'),
(12339, 31, 497, 'Passos', 'BR', 'MG'),
(12340, 31, 497, 'Patis', 'BR', 'MG'),
(12341, 31, 497, 'Patos de Minas', 'BR', 'MG'),
(12342, 31, 497, 'Patrocínio', 'BR', 'MG'),
(12343, 31, 497, 'Patrocínio do Muriaé', 'BR', 'MG'),
(12344, 31, 497, 'Paula Cândido', 'BR', 'MG'),
(12345, 31, 497, 'Paulistas', 'BR', 'MG'),
(12346, 31, 497, 'Pavão', 'BR', 'MG'),
(12347, 31, 497, 'Peçanha', 'BR', 'MG'),
(12348, 31, 497, 'Pedra Azul', 'BR', 'MG'),
(12349, 31, 497, 'Pedra Bonita', 'BR', 'MG'),
(12350, 31, 497, 'Pedra do Anta', 'BR', 'MG'),
(12351, 31, 497, 'Pedra do Indaiá', 'BR', 'MG'),
(12352, 31, 497, 'Pedra Dourada', 'BR', 'MG'),
(12353, 31, 497, 'Pedralva', 'BR', 'MG'),
(12354, 31, 497, 'Pedras de Maria da Cruz', 'BR', 'MG'),
(12355, 31, 497, 'Pedrinópolis', 'BR', 'MG'),
(12356, 31, 497, 'Pedro Leopoldo', 'BR', 'MG'),
(12357, 31, 497, 'Pedro Teixeira', 'BR', 'MG'),
(12358, 31, 497, 'Pequeri', 'BR', 'MG'),
(12359, 31, 497, 'Pequi', 'BR', 'MG'),
(12360, 31, 497, 'Perdigão', 'BR', 'MG'),
(12361, 31, 497, 'Perdizes', 'BR', 'MG'),
(12362, 31, 497, 'Perdões', 'BR', 'MG'),
(12363, 31, 497, 'Periquito', 'BR', 'MG'),
(12364, 31, 497, 'Pescador', 'BR', 'MG'),
(12365, 31, 497, 'Piau', 'BR', 'MG'),
(12366, 31, 497, 'Piedade de Caratinga', 'BR', 'MG'),
(12367, 31, 497, 'Piedade de Ponte Nova', 'BR', 'MG'),
(12368, 31, 497, 'Piedade do Rio Grande', 'BR', 'MG'),
(12369, 31, 497, 'Piedade dos Gerais', 'BR', 'MG'),
(12370, 31, 497, 'Pimenta', 'BR', 'MG'),
(12371, 31, 497, 'Pingo-d\'Água', 'BR', 'MG'),
(12372, 31, 497, 'Pintópolis', 'BR', 'MG'),
(12373, 31, 497, 'Piracema', 'BR', 'MG'),
(12374, 31, 497, 'Pirajuba', 'BR', 'MG'),
(12375, 31, 497, 'Piranga', 'BR', 'MG'),
(12376, 31, 497, 'Piranguçu', 'BR', 'MG'),
(12377, 31, 497, 'Piranguinho', 'BR', 'MG'),
(12378, 31, 497, 'Pirapetinga', 'BR', 'MG'),
(12379, 31, 497, 'Pirapora', 'BR', 'MG'),
(12380, 31, 497, 'Piraúba', 'BR', 'MG'),
(12381, 31, 497, 'Pitangui', 'BR', 'MG'),
(12382, 31, 497, 'Piuí', 'BR', 'MG'),
(12383, 31, 497, 'Piumhi', 'BR', 'MG'),
(12384, 31, 497, 'Planura', 'BR', 'MG'),
(12385, 31, 497, 'Poço Fundo', 'BR', 'MG'),
(12386, 31, 497, 'Poços de Caldas', 'BR', 'MG'),
(12387, 31, 497, 'Pocrane', 'BR', 'MG'),
(12388, 31, 497, 'Pompéu', 'BR', 'MG'),
(12389, 31, 497, 'Ponte Nova', 'BR', 'MG'),
(12390, 31, 497, 'Ponto Chique', 'BR', 'MG'),
(12391, 31, 497, 'Ponto dos Volantes', 'BR', 'MG'),
(12392, 31, 497, 'Porteirinha', 'BR', 'MG'),
(12393, 31, 497, 'Porto Firme', 'BR', 'MG'),
(12394, 31, 497, 'Poté', 'BR', 'MG'),
(12395, 31, 497, 'Pouso Alegre', 'BR', 'MG'),
(12396, 31, 497, 'Pouso Alto', 'BR', 'MG'),
(12397, 31, 497, 'Prados', 'BR', 'MG'),
(12398, 31, 497, 'Prata', 'BR', 'MG'),
(12399, 31, 497, 'Pratápolis', 'BR', 'MG'),
(12400, 31, 497, 'Pratinha', 'BR', 'MG'),
(12401, 31, 497, 'Presidente Bernardes', 'BR', 'MG'),
(12402, 31, 497, 'Presidente Juscelino', 'BR', 'MG'),
(12403, 31, 497, 'Presidente Kubitschek', 'BR', 'MG'),
(12404, 31, 497, 'Presidente Olegário', 'BR', 'MG'),
(12405, 31, 497, 'Prudente de Morais', 'BR', 'MG'),
(12406, 31, 497, 'Quartel Geral', 'BR', 'MG'),
(12407, 31, 497, 'Queluzito', 'BR', 'MG'),
(12408, 31, 497, 'Raposos', 'BR', 'MG'),
(12409, 31, 497, 'Raul Soares', 'BR', 'MG'),
(12410, 31, 497, 'Recreio', 'BR', 'MG'),
(12411, 31, 497, 'Reduto', 'BR', 'MG'),
(12412, 31, 497, 'Resende Costa', 'BR', 'MG'),
(12413, 31, 497, 'Resplendor', 'BR', 'MG'),
(12414, 31, 497, 'Ressaquinha', 'BR', 'MG'),
(12415, 31, 497, 'Riachinho', 'BR', 'MG'),
(12416, 31, 497, 'Riacho dos Machados', 'BR', 'MG'),
(12417, 31, 497, 'Ribeirão das Neves', 'BR', 'MG'),
(12418, 31, 497, 'Ribeirão Vermelho', 'BR', 'MG'),
(12419, 31, 497, 'Rio Acima', 'BR', 'MG'),
(12420, 31, 497, 'Rio Casca', 'BR', 'MG'),
(12421, 31, 497, 'Rio do Prado', 'BR', 'MG'),
(12422, 31, 497, 'Rio Doce', 'BR', 'MG'),
(12423, 31, 497, 'Rio Espera', 'BR', 'MG'),
(12424, 31, 497, 'Rio Manso', 'BR', 'MG'),
(12425, 31, 497, 'Rio Novo', 'BR', 'MG'),
(12426, 31, 497, 'Rio Paranaíba', 'BR', 'MG'),
(12427, 31, 497, 'Rio Pardo de Minas', 'BR', 'MG'),
(12428, 31, 497, 'Rio Piracicaba', 'BR', 'MG'),
(12429, 31, 497, 'Rio Pomba', 'BR', 'MG'),
(12430, 31, 497, 'Rio Preto', 'BR', 'MG'),
(12431, 31, 497, 'Rio Vermelho', 'BR', 'MG'),
(12432, 31, 497, 'Ritápolis', 'BR', 'MG'),
(12433, 31, 497, 'Rochedo de Minas', 'BR', 'MG'),
(12434, 31, 497, 'Rodeiro', 'BR', 'MG'),
(12435, 31, 497, 'Romaria', 'BR', 'MG'),
(12436, 31, 497, 'Rosário da Limeira', 'BR', 'MG'),
(12437, 31, 497, 'Rubelita', 'BR', 'MG'),
(12438, 31, 497, 'Rubim', 'BR', 'MG'),
(12439, 31, 497, 'Sabará', 'BR', 'MG'),
(12440, 31, 497, 'Sabinópolis', 'BR', 'MG'),
(12441, 31, 497, 'Sacramento', 'BR', 'MG'),
(12442, 31, 497, 'Salinas', 'BR', 'MG'),
(12443, 31, 497, 'Salto da Divisa', 'BR', 'MG'),
(12444, 31, 497, 'Santa Bárbara', 'BR', 'MG'),
(12445, 31, 497, 'Santa Bárbara do Leste', 'BR', 'MG'),
(12446, 31, 497, 'Santa Bárbara do Monte Verde', 'BR', 'MG'),
(12447, 31, 497, 'Santa Bárbara do Tugúrio', 'BR', 'MG'),
(12448, 31, 497, 'Santa Cruz de Minas', 'BR', 'MG'),
(12449, 31, 497, 'Santa Cruz de Salinas', 'BR', 'MG'),
(12450, 31, 497, 'Santa Cruz do Escalvado', 'BR', 'MG'),
(12451, 31, 497, 'Santa Efigênia de Minas', 'BR', 'MG'),
(12452, 31, 497, 'Santa Fé de Minas', 'BR', 'MG'),
(12453, 31, 497, 'Santa Helena de Minas', 'BR', 'MG'),
(12454, 31, 497, 'Santa Juliana', 'BR', 'MG'),
(12455, 31, 497, 'Santa Luzia', 'BR', 'MG'),
(12456, 31, 497, 'Santa Margarida', 'BR', 'MG'),
(12457, 31, 497, 'Santa Maria de Itabira', 'BR', 'MG'),
(12458, 31, 497, 'Santa Maria do Salto', 'BR', 'MG'),
(12459, 31, 497, 'Santa Maria do Suaçuí', 'BR', 'MG'),
(12460, 31, 497, 'Santa Rita de Caldas', 'BR', 'MG'),
(12461, 31, 497, 'Santa Rita de Ibitipoca', 'BR', 'MG'),
(12462, 31, 497, 'Santa Rita de Jacutinga', 'BR', 'MG'),
(12463, 31, 497, 'Santa Rita de Minas', 'BR', 'MG'),
(12464, 31, 497, 'Santa Rita do Itueto', 'BR', 'MG'),
(12465, 31, 497, 'Santa Rita do Sapucaí', 'BR', 'MG'),
(12466, 31, 497, 'Santa Rosa da Serra', 'BR', 'MG'),
(12467, 31, 497, 'Santa Vitória', 'BR', 'MG'),
(12468, 31, 497, 'Santana da Vargem', 'BR', 'MG'),
(12469, 31, 497, 'Santana de Cataguases', 'BR', 'MG'),
(12470, 31, 497, 'Santana de Pirapama', 'BR', 'MG'),
(12471, 31, 497, 'Santana do Deserto', 'BR', 'MG'),
(12472, 31, 497, 'Santana do Garambéu', 'BR', 'MG'),
(12473, 31, 497, 'Santana do Jacaré', 'BR', 'MG'),
(12474, 31, 497, 'Santana do Manhuaçu', 'BR', 'MG'),
(12475, 31, 497, 'Santana do Paraíso', 'BR', 'MG'),
(12476, 31, 497, 'Santana do Riacho', 'BR', 'MG'),
(12477, 31, 497, 'Santana dos Montes', 'BR', 'MG'),
(12478, 31, 497, 'Santo Antônio do Amparo', 'BR', 'MG'),
(12479, 31, 497, 'Santo Antônio do Aventureiro', 'BR', 'MG'),
(12480, 31, 497, 'Santo Antônio do Grama', 'BR', 'MG'),
(12481, 31, 497, 'Santo Antônio do Itambé', 'BR', 'MG'),
(12482, 31, 497, 'Santo Antônio do Jacinto', 'BR', 'MG'),
(12483, 31, 497, 'Santo Antônio do Monte', 'BR', 'MG'),
(12484, 31, 497, 'Santo Antônio do Retiro', 'BR', 'MG'),
(12485, 31, 497, 'Santo Antônio do Rio Abaixo', 'BR', 'MG'),
(12486, 31, 497, 'Santo Hipólito', 'BR', 'MG'),
(12487, 31, 497, 'Santos Dumont', 'BR', 'MG'),
(12488, 31, 497, 'São Bento Abade', 'BR', 'MG'),
(12489, 31, 497, 'São Brás do Suaçuí', 'BR', 'MG'),
(12490, 31, 497, 'São Domingos das Dores', 'BR', 'MG'),
(12491, 31, 497, 'São Domingos do Prata', 'BR', 'MG'),
(12492, 31, 497, 'São Félix de Minas', 'BR', 'MG'),
(12493, 31, 497, 'São Francisco', 'BR', 'MG'),
(12494, 31, 497, 'São Francisco de Paula', 'BR', 'MG'),
(12495, 31, 497, 'São Francisco de Sales', 'BR', 'MG'),
(12496, 31, 497, 'São Francisco do Glória', 'BR', 'MG'),
(12497, 31, 497, 'São Geraldo', 'BR', 'MG'),
(12498, 31, 497, 'São Geraldo da Piedade', 'BR', 'MG'),
(12499, 31, 497, 'São Geraldo do Baixio', 'BR', 'MG'),
(12500, 31, 497, 'São Gonçalo do Abaeté', 'BR', 'MG');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(12501, 31, 497, 'São Gonçalo do Pará', 'BR', 'MG'),
(12502, 31, 497, 'São Gonçalo do Rio Abaixo', 'BR', 'MG'),
(12503, 31, 497, 'São Gonçalo do Rio Preto', 'BR', 'MG'),
(12504, 31, 497, 'São Gonçalo do Sapucaí', 'BR', 'MG'),
(12505, 31, 497, 'São Gotardo', 'BR', 'MG'),
(12506, 31, 497, 'São João Batista do Glória', 'BR', 'MG'),
(12507, 31, 497, 'São João da Lagoa', 'BR', 'MG'),
(12508, 31, 497, 'São João da Mata', 'BR', 'MG'),
(12509, 31, 497, 'São João da Ponte', 'BR', 'MG'),
(12510, 31, 497, 'São João das Missões', 'BR', 'MG'),
(12511, 31, 497, 'São João del Rei', 'BR', 'MG'),
(12512, 31, 497, 'São João do Manhuaçu', 'BR', 'MG'),
(12513, 31, 497, 'São João do Manteninha', 'BR', 'MG'),
(12514, 31, 497, 'São João do Oriente', 'BR', 'MG'),
(12515, 31, 497, 'São João do Pacuí', 'BR', 'MG'),
(12516, 31, 497, 'São João do Paraíso', 'BR', 'MG'),
(12517, 31, 497, 'São João Evangelista', 'BR', 'MG'),
(12518, 31, 497, 'São João Nepomuceno', 'BR', 'MG'),
(12519, 31, 497, 'São Joaquim de Bicas', 'BR', 'MG'),
(12520, 31, 497, 'São José da Barra', 'BR', 'MG'),
(12521, 31, 497, 'São José da Lapa', 'BR', 'MG'),
(12522, 31, 497, 'São José da Safira', 'BR', 'MG'),
(12523, 31, 497, 'São José da Varginha', 'BR', 'MG'),
(12524, 31, 497, 'São José do Alegre', 'BR', 'MG'),
(12525, 31, 497, 'São José do Divino', 'BR', 'MG'),
(12526, 31, 497, 'São José do Goiabal', 'BR', 'MG'),
(12527, 31, 497, 'São José do Jacuri', 'BR', 'MG'),
(12528, 31, 497, 'São José do Mantimento', 'BR', 'MG'),
(12529, 31, 497, 'São Lourenço', 'BR', 'MG'),
(12530, 31, 497, 'São Miguel do Anta', 'BR', 'MG'),
(12531, 31, 497, 'São Pedro da União', 'BR', 'MG'),
(12532, 31, 497, 'São Pedro do Suaçuí', 'BR', 'MG'),
(12533, 31, 497, 'São Pedro dos Ferros', 'BR', 'MG'),
(12534, 31, 497, 'São Romão', 'BR', 'MG'),
(12535, 31, 497, 'São Roque de Minas', 'BR', 'MG'),
(12536, 31, 497, 'São Sebastião da Bela Vista', 'BR', 'MG'),
(12537, 31, 497, 'São Sebastião da Vargem Alegre', 'BR', 'MG'),
(12538, 31, 497, 'São Sebastião do Anta', 'BR', 'MG'),
(12539, 31, 497, 'São Sebastião do Maranhão', 'BR', 'MG'),
(12540, 31, 497, 'São Sebastião do Oeste', 'BR', 'MG'),
(12541, 31, 497, 'São Sebastião do Paraíso', 'BR', 'MG'),
(12542, 31, 497, 'São Sebastião do Rio Preto', 'BR', 'MG'),
(12543, 31, 497, 'São Sebastião do Rio Verde', 'BR', 'MG'),
(12544, 31, 497, 'São Thomé das Letras', 'BR', 'MG'),
(12545, 31, 497, 'São Tiago', 'BR', 'MG'),
(12546, 31, 497, 'São Tomás de Aquino', 'BR', 'MG'),
(12547, 31, 497, 'São Vicente de Minas', 'BR', 'MG'),
(12548, 31, 497, 'Sapucaí-Mirim', 'BR', 'MG'),
(12549, 31, 497, 'Sardoá', 'BR', 'MG'),
(12550, 31, 497, 'Sarzedo', 'BR', 'MG'),
(12551, 31, 497, 'Sem-Peixe', 'BR', 'MG'),
(12552, 31, 497, 'Senador Amaral', 'BR', 'MG'),
(12553, 31, 497, 'Senador Cortes', 'BR', 'MG'),
(12554, 31, 497, 'Senador Firmino', 'BR', 'MG'),
(12555, 31, 497, 'Senador José Bento', 'BR', 'MG'),
(12556, 31, 497, 'Senador Modestino Gonçalves', 'BR', 'MG'),
(12557, 31, 497, 'Senhora de Oliveira', 'BR', 'MG'),
(12558, 31, 497, 'Senhora do Porto', 'BR', 'MG'),
(12559, 31, 497, 'Senhora dos Remédios', 'BR', 'MG'),
(12560, 31, 497, 'Sericita', 'BR', 'MG'),
(12561, 31, 497, 'Seritinga', 'BR', 'MG'),
(12562, 31, 497, 'Serra Azul de Minas', 'BR', 'MG'),
(12563, 31, 497, 'Serra da Saudade', 'BR', 'MG'),
(12564, 31, 497, 'Serra do Salitre', 'BR', 'MG'),
(12565, 31, 497, 'Serra dos Aimorés', 'BR', 'MG'),
(12566, 31, 497, 'Serrania', 'BR', 'MG'),
(12567, 31, 497, 'Serranópolis de Minas', 'BR', 'MG'),
(12568, 31, 497, 'Serranos', 'BR', 'MG'),
(12569, 31, 497, 'Serro', 'BR', 'MG'),
(12570, 31, 497, 'Sete Lagoas', 'BR', 'MG'),
(12571, 31, 497, 'Setubinha', 'BR', 'MG'),
(12572, 31, 497, 'Silveirânia', 'BR', 'MG'),
(12573, 31, 497, 'Silvianópolis', 'BR', 'MG'),
(12574, 31, 497, 'Simão Pereira', 'BR', 'MG'),
(12575, 31, 497, 'Simonésia', 'BR', 'MG'),
(12576, 31, 497, 'Sobrália', 'BR', 'MG'),
(12577, 31, 497, 'Soledade de Minas', 'BR', 'MG'),
(12578, 31, 497, 'Tabuleiro', 'BR', 'MG'),
(12579, 31, 497, 'Taiobeiras', 'BR', 'MG'),
(12580, 31, 497, 'Taparuba', 'BR', 'MG'),
(12581, 31, 497, 'Tapira', 'BR', 'MG'),
(12582, 31, 497, 'Tapiraí', 'BR', 'MG'),
(12583, 31, 497, 'Taquaraçu de Minas', 'BR', 'MG'),
(12584, 31, 497, 'Tarumirim', 'BR', 'MG'),
(12585, 31, 497, 'Teixeiras', 'BR', 'MG'),
(12586, 31, 497, 'Teófilo Otoni', 'BR', 'MG'),
(12587, 31, 497, 'Timóteo', 'BR', 'MG'),
(12588, 31, 497, 'Tiradentes', 'BR', 'MG'),
(12589, 31, 497, 'Tiros', 'BR', 'MG'),
(12590, 31, 497, 'Tocantins', 'BR', 'MG'),
(12591, 31, 497, 'Tocos do Moji', 'BR', 'MG'),
(12592, 31, 497, 'Toledo', 'BR', 'MG'),
(12593, 31, 497, 'Tombos', 'BR', 'MG'),
(12594, 31, 497, 'Três Corações', 'BR', 'MG'),
(12595, 31, 497, 'Três Marias', 'BR', 'MG'),
(12596, 31, 497, 'Três Pontas', 'BR', 'MG'),
(12597, 31, 497, 'Tumiritinga', 'BR', 'MG'),
(12598, 31, 497, 'Tupaciguara', 'BR', 'MG'),
(12599, 31, 497, 'Turmalina', 'BR', 'MG'),
(12600, 31, 497, 'Turvolândia', 'BR', 'MG'),
(12601, 31, 497, 'Ubá', 'BR', 'MG'),
(12602, 31, 497, 'Ubaí', 'BR', 'MG'),
(12603, 31, 497, 'Ubaporanga', 'BR', 'MG'),
(12604, 31, 497, 'Uberaba', 'BR', 'MG'),
(12605, 31, 497, 'Uberlândia', 'BR', 'MG'),
(12606, 31, 497, 'Umburatiba', 'BR', 'MG'),
(12607, 31, 497, 'Unaí', 'BR', 'MG'),
(12608, 31, 497, 'União de Minas', 'BR', 'MG'),
(12609, 31, 497, 'Uruana de Minas', 'BR', 'MG'),
(12610, 31, 497, 'Urucânia', 'BR', 'MG'),
(12611, 31, 497, 'Urucuia', 'BR', 'MG'),
(12612, 31, 497, 'Vargem Alegre', 'BR', 'MG'),
(12613, 31, 497, 'Vargem Bonita', 'BR', 'MG'),
(12614, 31, 497, 'Vargem Grande do Rio Pardo', 'BR', 'MG'),
(12615, 31, 497, 'Varginha', 'BR', 'MG'),
(12616, 31, 497, 'Varjão de MInas', 'BR', 'MG'),
(12617, 31, 497, 'Várzea da Palma', 'BR', 'MG'),
(12618, 31, 497, 'Varzelândia', 'BR', 'MG'),
(12619, 31, 497, 'Vazante', 'BR', 'MG'),
(12620, 31, 497, 'Verdelândia', 'BR', 'MG'),
(12621, 31, 497, 'Veredinha', 'BR', 'MG'),
(12622, 31, 497, 'Veríssimo', 'BR', 'MG'),
(12623, 31, 497, 'Vermelho Novo', 'BR', 'MG'),
(12624, 31, 497, 'Vespasiano', 'BR', 'MG'),
(12625, 31, 497, 'Viçosa', 'BR', 'MG'),
(12626, 31, 497, 'Vieiras', 'BR', 'MG'),
(12627, 31, 497, 'Virgem da Lapa', 'BR', 'MG'),
(12628, 31, 497, 'Virgínia', 'BR', 'MG'),
(12629, 31, 497, 'Virginópolis', 'BR', 'MG'),
(12630, 31, 497, 'Virgolândia', 'BR', 'MG'),
(12631, 31, 497, 'Visconde do Rio Branco', 'BR', 'MG'),
(12632, 31, 497, 'Volta Grande', 'BR', 'MG'),
(12633, 31, 497, 'Wenceslau Braz', 'BR', 'MG'),
(12634, 31, 498, 'Abaetetuba', 'BR', 'PA'),
(12635, 31, 498, 'Abel Figueiredo', 'BR', 'PA'),
(12636, 31, 498, 'Acará', 'BR', 'PA'),
(12637, 31, 498, 'Afuá', 'BR', 'PA'),
(12638, 31, 498, 'Água Azul do Norte', 'BR', 'PA'),
(12639, 31, 498, 'Alenquer', 'BR', 'PA'),
(12640, 31, 498, 'Almeirim', 'BR', 'PA'),
(12641, 31, 498, 'Altamira', 'BR', 'PA'),
(12642, 31, 498, 'Anajás', 'BR', 'PA'),
(12643, 31, 498, 'Ananindeua', 'BR', 'PA'),
(12644, 31, 498, 'Anapu', 'BR', 'PA'),
(12645, 31, 498, 'Augusto Corrêa', 'BR', 'PA'),
(12646, 31, 498, 'Aurora do Pará', 'BR', 'PA'),
(12647, 31, 498, 'Aveiro', 'BR', 'PA'),
(12648, 31, 498, 'Bagre', 'BR', 'PA'),
(12649, 31, 498, 'Baião', 'BR', 'PA'),
(12650, 31, 498, 'Bannach', 'BR', 'PA'),
(12651, 31, 498, 'Barcarena', 'BR', 'PA'),
(12652, 31, 498, 'Belém', 'BR', 'PA'),
(12653, 31, 498, 'Belterra', 'BR', 'PA'),
(12654, 31, 498, 'Benevides', 'BR', 'PA'),
(12655, 31, 498, 'Bom Jesus do Tocantins', 'BR', 'PA'),
(12656, 31, 498, 'Bonito', 'BR', 'PA'),
(12657, 31, 498, 'Bragança', 'BR', 'PA'),
(12658, 31, 498, 'Brasil Novo', 'BR', 'PA'),
(12659, 31, 498, 'Brejo Grande do Araguaia', 'BR', 'PA'),
(12660, 31, 498, 'Breu Branco', 'BR', 'PA'),
(12661, 31, 498, 'Breves', 'BR', 'PA'),
(12662, 31, 498, 'Bujaru', 'BR', 'PA'),
(12663, 31, 498, 'Cachoeira do Arari', 'BR', 'PA'),
(12664, 31, 498, 'Cachoeira do Piriá', 'BR', 'PA'),
(12665, 31, 498, 'Cametá', 'BR', 'PA'),
(12666, 31, 498, 'Canaã dos Carajás', 'BR', 'PA'),
(12667, 31, 498, 'Capanema', 'BR', 'PA'),
(12668, 31, 498, 'Capitão Poço', 'BR', 'PA'),
(12669, 31, 498, 'Castanhal', 'BR', 'PA'),
(12670, 31, 498, 'Chaves', 'BR', 'PA'),
(12671, 31, 498, 'Colares', 'BR', 'PA'),
(12672, 31, 498, 'Conceição do Araguaia', 'BR', 'PA'),
(12673, 31, 498, 'Concórdia do Pará', 'BR', 'PA'),
(12674, 31, 498, 'Cumaru do Norte', 'BR', 'PA'),
(12675, 31, 498, 'Curionópolis', 'BR', 'PA'),
(12676, 31, 498, 'Curralinho', 'BR', 'PA'),
(12677, 31, 498, 'Curuá', 'BR', 'PA'),
(12678, 31, 498, 'Curuçá', 'BR', 'PA'),
(12679, 31, 498, 'Dom Eliseu', 'BR', 'PA'),
(12680, 31, 498, 'Eldorado do Carajás', 'BR', 'PA'),
(12681, 31, 498, 'Faro', 'BR', 'PA'),
(12682, 31, 498, 'Floresta do Araguaia', 'BR', 'PA'),
(12683, 31, 498, 'Garrafão do Norte', 'BR', 'PA'),
(12684, 31, 498, 'Goianésia do Pará', 'BR', 'PA'),
(12685, 31, 498, 'Gurupá', 'BR', 'PA'),
(12686, 31, 498, 'Igarapé Açu', 'BR', 'PA'),
(12687, 31, 498, 'Igarapé Miri', 'BR', 'PA'),
(12688, 31, 498, 'Igarapé-Açu', 'BR', 'PA'),
(12689, 31, 498, 'Igarapé-Miri', 'BR', 'PA'),
(12690, 31, 498, 'Inhangapi', 'BR', 'PA'),
(12691, 31, 498, 'Ipixuna do Pará', 'BR', 'PA'),
(12692, 31, 498, 'Irituia', 'BR', 'PA'),
(12693, 31, 498, 'Itaituba', 'BR', 'PA'),
(12694, 31, 498, 'Itupiranga', 'BR', 'PA'),
(12695, 31, 498, 'Jacareacanga', 'BR', 'PA'),
(12696, 31, 498, 'Jacundá', 'BR', 'PA'),
(12697, 31, 498, 'Juruti', 'BR', 'PA'),
(12698, 31, 498, 'Limoeiro do Ajuru', 'BR', 'PA'),
(12699, 31, 498, 'Mãe do Rio', 'BR', 'PA'),
(12700, 31, 498, 'Magalhães Barata', 'BR', 'PA'),
(12701, 31, 498, 'Marabá', 'BR', 'PA'),
(12702, 31, 498, 'Maracanã', 'BR', 'PA'),
(12703, 31, 498, 'Marapanim', 'BR', 'PA'),
(12704, 31, 498, 'Marituba', 'BR', 'PA'),
(12705, 31, 498, 'Medicilândia', 'BR', 'PA'),
(12706, 31, 498, 'Melgaço', 'BR', 'PA'),
(12707, 31, 498, 'Mocajuba', 'BR', 'PA'),
(12708, 31, 498, 'Moju', 'BR', 'PA'),
(12709, 31, 498, 'Mojuí Dos Campos', 'BR', 'PA'),
(12710, 31, 498, 'Monte Alegre', 'BR', 'PA'),
(12711, 31, 498, 'Muaná', 'BR', 'PA'),
(12712, 31, 498, 'Nova Esperança do Piriá', 'BR', 'PA'),
(12713, 31, 498, 'Nova Ipixuna', 'BR', 'PA'),
(12714, 31, 498, 'Nova Timboteua', 'BR', 'PA'),
(12715, 31, 498, 'Novo Progresso', 'BR', 'PA'),
(12716, 31, 498, 'Novo Repartimento', 'BR', 'PA'),
(12717, 31, 498, 'Óbidos', 'BR', 'PA'),
(12718, 31, 498, 'Oeiras do Pará', 'BR', 'PA'),
(12719, 31, 498, 'Oriximiná', 'BR', 'PA'),
(12720, 31, 498, 'Ourém', 'BR', 'PA'),
(12721, 31, 498, 'Ourilândia do Norte', 'BR', 'PA'),
(12722, 31, 498, 'Pacajá', 'BR', 'PA'),
(12723, 31, 498, 'Palestina do Pará', 'BR', 'PA'),
(12724, 31, 498, 'Paragominas', 'BR', 'PA'),
(12725, 31, 498, 'Parauapebas', 'BR', 'PA'),
(12726, 31, 498, 'Pau d\'Arco', 'BR', 'PA'),
(12727, 31, 498, 'Peixe-Boi', 'BR', 'PA'),
(12728, 31, 498, 'Piçarra', 'BR', 'PA'),
(12729, 31, 498, 'Placas', 'BR', 'PA'),
(12730, 31, 498, 'Ponta de Pedras', 'BR', 'PA'),
(12731, 31, 498, 'Portel', 'BR', 'PA'),
(12732, 31, 498, 'Porto de Moz', 'BR', 'PA'),
(12733, 31, 498, 'Prainha', 'BR', 'PA'),
(12734, 31, 498, 'Primavera', 'BR', 'PA'),
(12735, 31, 498, 'Quatipuru', 'BR', 'PA'),
(12736, 31, 498, 'Redenção', 'BR', 'PA'),
(12737, 31, 498, 'Rio Maria', 'BR', 'PA'),
(12738, 31, 498, 'Rondon do Pará', 'BR', 'PA'),
(12739, 31, 498, 'Rurópolis', 'BR', 'PA'),
(12740, 31, 498, 'Salinópolis', 'BR', 'PA'),
(12741, 31, 498, 'Salvaterra', 'BR', 'PA'),
(12742, 31, 498, 'Santa Bárbara do Pará', 'BR', 'PA'),
(12743, 31, 498, 'Santa Cruz do Arari', 'BR', 'PA'),
(12744, 31, 498, 'Santa Izabel do Pará', 'BR', 'PA'),
(12745, 31, 498, 'Santa Luzia do Pará', 'BR', 'PA'),
(12746, 31, 498, 'Santa Maria das Barreiras', 'BR', 'PA'),
(12747, 31, 498, 'Santa Maria do Pará', 'BR', 'PA'),
(12748, 31, 498, 'Santana do Araguaia', 'BR', 'PA'),
(12749, 31, 498, 'Santarém', 'BR', 'PA'),
(12750, 31, 498, 'Santarém Novo', 'BR', 'PA'),
(12751, 31, 498, 'Santo Antônio do Tauá', 'BR', 'PA'),
(12752, 31, 498, 'São Caetano de Odivelas', 'BR', 'PA'),
(12753, 31, 498, 'São Domingos do Araguaia', 'BR', 'PA'),
(12754, 31, 498, 'São Domingos do Capim', 'BR', 'PA'),
(12755, 31, 498, 'São Félix do Xingu', 'BR', 'PA'),
(12756, 31, 498, 'São Francisco do Pará', 'BR', 'PA'),
(12757, 31, 498, 'São Geraldo do Araguaia', 'BR', 'PA'),
(12758, 31, 498, 'São João da Ponta', 'BR', 'PA'),
(12759, 31, 498, 'São João de Pirabas', 'BR', 'PA'),
(12760, 31, 498, 'São João do Araguaia', 'BR', 'PA'),
(12761, 31, 498, 'São Miguel do Guamá', 'BR', 'PA'),
(12762, 31, 498, 'São Sebastião da Boa Vista', 'BR', 'PA'),
(12763, 31, 498, 'Sapucaia', 'BR', 'PA'),
(12764, 31, 498, 'Senador José Porfírio', 'BR', 'PA'),
(12765, 31, 498, 'Soure', 'BR', 'PA'),
(12766, 31, 498, 'Tailândia', 'BR', 'PA'),
(12767, 31, 498, 'Terra Alta', 'BR', 'PA'),
(12768, 31, 498, 'Terra Santa', 'BR', 'PA'),
(12769, 31, 498, 'Tomé Açu', 'BR', 'PA'),
(12770, 31, 498, 'Tomé-Açu', 'BR', 'PA'),
(12771, 31, 498, 'Tracuateua', 'BR', 'PA'),
(12772, 31, 498, 'Trairão', 'BR', 'PA'),
(12773, 31, 498, 'Tucumã', 'BR', 'PA'),
(12774, 31, 498, 'Tucuruí', 'BR', 'PA'),
(12775, 31, 498, 'Ulianópolis', 'BR', 'PA'),
(12776, 31, 498, 'Uruará', 'BR', 'PA'),
(12777, 31, 498, 'Vigia', 'BR', 'PA'),
(12778, 31, 498, 'Viseu', 'BR', 'PA'),
(12779, 31, 498, 'Vitória do Xingu', 'BR', 'PA'),
(12780, 31, 498, 'Xinguara', 'BR', 'PA'),
(12781, 31, 499, 'Água Branca', 'BR', 'PB'),
(12782, 31, 499, 'Aguiar', 'BR', 'PB'),
(12783, 31, 499, 'Alagoa Grande', 'BR', 'PB'),
(12784, 31, 499, 'Alagoa Nova', 'BR', 'PB'),
(12785, 31, 499, 'Alagoinha', 'BR', 'PB'),
(12786, 31, 499, 'Alcantil', 'BR', 'PB'),
(12787, 31, 499, 'Algodão de Jandaíra', 'BR', 'PB'),
(12788, 31, 499, 'Alhandra', 'BR', 'PB'),
(12789, 31, 499, 'Amparo', 'BR', 'PB'),
(12790, 31, 499, 'Aparecida', 'BR', 'PB'),
(12791, 31, 499, 'Araçagi', 'BR', 'PB'),
(12792, 31, 499, 'Arara', 'BR', 'PB'),
(12793, 31, 499, 'Araruna', 'BR', 'PB'),
(12794, 31, 499, 'Areia', 'BR', 'PB'),
(12795, 31, 499, 'Areia de Baraúnas', 'BR', 'PB'),
(12796, 31, 499, 'Areial', 'BR', 'PB'),
(12797, 31, 499, 'Aroeiras', 'BR', 'PB'),
(12798, 31, 499, 'Assunção', 'BR', 'PB'),
(12799, 31, 499, 'Baía da Traição', 'BR', 'PB'),
(12800, 31, 499, 'Bananeiras', 'BR', 'PB'),
(12801, 31, 499, 'Baraúna', 'BR', 'PB'),
(12802, 31, 499, 'Barra de Santa Rosa', 'BR', 'PB'),
(12803, 31, 499, 'Barra de Santana', 'BR', 'PB'),
(12804, 31, 499, 'Barra de São Miguel', 'BR', 'PB'),
(12805, 31, 499, 'Bayeux', 'BR', 'PB'),
(12806, 31, 499, 'Belém', 'BR', 'PB'),
(12807, 31, 499, 'Belém do Brejo do Cruz', 'BR', 'PB'),
(12808, 31, 499, 'Bernardino Batista', 'BR', 'PB'),
(12809, 31, 499, 'Boa Ventura', 'BR', 'PB'),
(12810, 31, 499, 'Boa Vista', 'BR', 'PB'),
(12811, 31, 499, 'Bom Jesus', 'BR', 'PB'),
(12812, 31, 499, 'Bom Sucesso', 'BR', 'PB'),
(12813, 31, 499, 'Bonito de Santa Fé', 'BR', 'PB'),
(12814, 31, 499, 'Boqueirão', 'BR', 'PB'),
(12815, 31, 499, 'Borborema', 'BR', 'PB'),
(12816, 31, 499, 'Brejo do Cruz', 'BR', 'PB'),
(12817, 31, 499, 'Brejo dos Santos', 'BR', 'PB'),
(12818, 31, 499, 'Caaporã', 'BR', 'PB'),
(12819, 31, 499, 'Cabaceiras', 'BR', 'PB'),
(12820, 31, 499, 'Cabedelo', 'BR', 'PB'),
(12821, 31, 499, 'Cachoeira dos Índios', 'BR', 'PB'),
(12822, 31, 499, 'Cacimba de Areia', 'BR', 'PB'),
(12823, 31, 499, 'Cacimba de Dentro', 'BR', 'PB'),
(12824, 31, 499, 'Cacimbas', 'BR', 'PB'),
(12825, 31, 499, 'Caiçara', 'BR', 'PB'),
(12826, 31, 499, 'Cajazeiras', 'BR', 'PB'),
(12827, 31, 499, 'Cajazeirinhas', 'BR', 'PB'),
(12828, 31, 499, 'Caldas Brandão', 'BR', 'PB'),
(12829, 31, 499, 'Camalaú', 'BR', 'PB'),
(12830, 31, 499, 'Campina Grande', 'BR', 'PB'),
(12831, 31, 499, 'Capim', 'BR', 'PB'),
(12832, 31, 499, 'Caraúbas', 'BR', 'PB'),
(12833, 31, 499, 'Carrapateira', 'BR', 'PB'),
(12834, 31, 499, 'Casserengue', 'BR', 'PB'),
(12835, 31, 499, 'Catingueira', 'BR', 'PB'),
(12836, 31, 499, 'Catolé do Rocha', 'BR', 'PB'),
(12837, 31, 499, 'Caturité', 'BR', 'PB'),
(12838, 31, 499, 'Conceição', 'BR', 'PB'),
(12839, 31, 499, 'Condado', 'BR', 'PB'),
(12840, 31, 499, 'Conde', 'BR', 'PB'),
(12841, 31, 499, 'Congo', 'BR', 'PB'),
(12842, 31, 499, 'Coremas', 'BR', 'PB'),
(12843, 31, 499, 'Coxixola', 'BR', 'PB'),
(12844, 31, 499, 'Cruz do Espírito Santo', 'BR', 'PB'),
(12845, 31, 499, 'Cubati', 'BR', 'PB'),
(12846, 31, 499, 'Cuité', 'BR', 'PB'),
(12847, 31, 499, 'Cuité de Mamanguape', 'BR', 'PB'),
(12848, 31, 499, 'Cuitegi', 'BR', 'PB'),
(12849, 31, 499, 'Curral de Cima', 'BR', 'PB'),
(12850, 31, 499, 'Curral Velho', 'BR', 'PB'),
(12851, 31, 499, 'Damião', 'BR', 'PB'),
(12852, 31, 499, 'Desterro', 'BR', 'PB'),
(12853, 31, 499, 'Diamante', 'BR', 'PB'),
(12854, 31, 499, 'Dona Inês', 'BR', 'PB'),
(12855, 31, 499, 'Duas Estradas', 'BR', 'PB'),
(12856, 31, 499, 'Emas', 'BR', 'PB'),
(12857, 31, 499, 'Esperança', 'BR', 'PB'),
(12858, 31, 499, 'Fagundes', 'BR', 'PB'),
(12859, 31, 499, 'Frei Martinho', 'BR', 'PB'),
(12860, 31, 499, 'Gado Bravo', 'BR', 'PB'),
(12861, 31, 499, 'Guarabira', 'BR', 'PB'),
(12862, 31, 499, 'Gurinhém', 'BR', 'PB'),
(12863, 31, 499, 'Gurjão', 'BR', 'PB'),
(12864, 31, 499, 'Ibiara', 'BR', 'PB'),
(12865, 31, 499, 'Igaracy', 'BR', 'PB'),
(12866, 31, 499, 'Imaculada', 'BR', 'PB'),
(12867, 31, 499, 'Ingá', 'BR', 'PB'),
(12868, 31, 499, 'Itabaiana', 'BR', 'PB'),
(12869, 31, 499, 'Itaporanga', 'BR', 'PB'),
(12870, 31, 499, 'Itapororoca', 'BR', 'PB'),
(12871, 31, 499, 'Itatuba', 'BR', 'PB'),
(12872, 31, 499, 'Jacaraú', 'BR', 'PB'),
(12873, 31, 499, 'Jericó', 'BR', 'PB'),
(12874, 31, 499, 'João Pessoa', 'BR', 'PB'),
(12875, 31, 499, 'Joca Claudino', 'BR', 'PB'),
(12876, 31, 499, 'Juarez Távora', 'BR', 'PB'),
(12877, 31, 499, 'Juazeirinho', 'BR', 'PB'),
(12878, 31, 499, 'Junco do Seridó', 'BR', 'PB'),
(12879, 31, 499, 'Juripiranga', 'BR', 'PB'),
(12880, 31, 499, 'Juru', 'BR', 'PB'),
(12881, 31, 499, 'Lagoa', 'BR', 'PB'),
(12882, 31, 499, 'Lagoa de Dentro', 'BR', 'PB'),
(12883, 31, 499, 'Lagoa Seca', 'BR', 'PB'),
(12884, 31, 499, 'Lastro', 'BR', 'PB'),
(12885, 31, 499, 'Livramento', 'BR', 'PB'),
(12886, 31, 499, 'Logradouro', 'BR', 'PB'),
(12887, 31, 499, 'Lucena', 'BR', 'PB'),
(12888, 31, 499, 'Mãe d\'Água', 'BR', 'PB'),
(12889, 31, 499, 'Malta', 'BR', 'PB'),
(12890, 31, 499, 'Mamanguape', 'BR', 'PB'),
(12891, 31, 499, 'Manaíra', 'BR', 'PB'),
(12892, 31, 499, 'Marcação', 'BR', 'PB'),
(12893, 31, 499, 'Mari', 'BR', 'PB'),
(12894, 31, 499, 'Marizópolis', 'BR', 'PB'),
(12895, 31, 499, 'Massaranduba', 'BR', 'PB'),
(12896, 31, 499, 'Mataraca', 'BR', 'PB'),
(12897, 31, 499, 'Matinhas', 'BR', 'PB'),
(12898, 31, 499, 'Mato Grosso', 'BR', 'PB'),
(12899, 31, 499, 'Maturéia', 'BR', 'PB'),
(12900, 31, 499, 'Mogeiro', 'BR', 'PB'),
(12901, 31, 499, 'Montadas', 'BR', 'PB'),
(12902, 31, 499, 'Monte Horebe', 'BR', 'PB'),
(12903, 31, 499, 'Monteiro', 'BR', 'PB'),
(12904, 31, 499, 'Mulungu', 'BR', 'PB'),
(12905, 31, 499, 'Natuba', 'BR', 'PB'),
(12906, 31, 499, 'Nazarezinho', 'BR', 'PB'),
(12907, 31, 499, 'Nova Floresta', 'BR', 'PB'),
(12908, 31, 499, 'Nova Olinda', 'BR', 'PB'),
(12909, 31, 499, 'Nova Palmeira', 'BR', 'PB'),
(12910, 31, 499, 'Olho d\'Água', 'BR', 'PB'),
(12911, 31, 499, 'Olivedos', 'BR', 'PB'),
(12912, 31, 499, 'Ouro Velho', 'BR', 'PB'),
(12913, 31, 499, 'Parari', 'BR', 'PB'),
(12914, 31, 499, 'Passagem', 'BR', 'PB'),
(12915, 31, 499, 'Patos', 'BR', 'PB'),
(12916, 31, 499, 'Paulista', 'BR', 'PB'),
(12917, 31, 499, 'Pedra Branca', 'BR', 'PB'),
(12918, 31, 499, 'Pedra Lavrada', 'BR', 'PB'),
(12919, 31, 499, 'Pedras de Fogo', 'BR', 'PB'),
(12920, 31, 499, 'Pedro Régis', 'BR', 'PB'),
(12921, 31, 499, 'Piancó', 'BR', 'PB'),
(12922, 31, 499, 'Picuí', 'BR', 'PB'),
(12923, 31, 499, 'Pilar', 'BR', 'PB'),
(12924, 31, 499, 'Pilões', 'BR', 'PB'),
(12925, 31, 499, 'Pilõezinhos', 'BR', 'PB'),
(12926, 31, 499, 'Pirpirituba', 'BR', 'PB'),
(12927, 31, 499, 'Pitimbu', 'BR', 'PB'),
(12928, 31, 499, 'Pocinhos', 'BR', 'PB'),
(12929, 31, 499, 'Poço Dantas', 'BR', 'PB'),
(12930, 31, 499, 'Poço de José de Moura', 'BR', 'PB'),
(12931, 31, 499, 'Pombal', 'BR', 'PB'),
(12932, 31, 499, 'Prata', 'BR', 'PB'),
(12933, 31, 499, 'Princesa Isabel', 'BR', 'PB'),
(12934, 31, 499, 'Puxinanã', 'BR', 'PB'),
(12935, 31, 499, 'Queimadas', 'BR', 'PB'),
(12936, 31, 499, 'Quixaba', 'BR', 'PB'),
(12937, 31, 499, 'Remígio', 'BR', 'PB'),
(12938, 31, 499, 'Riachão', 'BR', 'PB'),
(12939, 31, 499, 'Riachão do Bacamarte', 'BR', 'PB'),
(12940, 31, 499, 'Riachão do Poço', 'BR', 'PB'),
(12941, 31, 499, 'Riacho de Santo Antônio', 'BR', 'PB'),
(12942, 31, 499, 'Riacho dos Cavalos', 'BR', 'PB'),
(12943, 31, 499, 'Rio Tinto', 'BR', 'PB'),
(12944, 31, 499, 'Salgadinho', 'BR', 'PB'),
(12945, 31, 499, 'Salgado de São Félix', 'BR', 'PB'),
(12946, 31, 499, 'Santa Cecília', 'BR', 'PB'),
(12947, 31, 499, 'Santa Cruz', 'BR', 'PB'),
(12948, 31, 499, 'Santa Helena', 'BR', 'PB'),
(12949, 31, 499, 'Santa Inês', 'BR', 'PB'),
(12950, 31, 499, 'Santa Luzia', 'BR', 'PB'),
(12951, 31, 499, 'Santa Rita', 'BR', 'PB'),
(12952, 31, 499, 'Santa Teresinha', 'BR', 'PB'),
(12953, 31, 499, 'Santana de Mangueira', 'BR', 'PB'),
(12954, 31, 499, 'Santana dos Garrotes', 'BR', 'PB'),
(12955, 31, 499, 'Santo André', 'BR', 'PB'),
(12956, 31, 499, 'São Bentinho', 'BR', 'PB'),
(12957, 31, 499, 'São Bento', 'BR', 'PB'),
(12958, 31, 499, 'São Domingos', 'BR', 'PB'),
(12959, 31, 499, 'São Domingos do Cariri', 'BR', 'PB'),
(12960, 31, 499, 'São Francisco', 'BR', 'PB'),
(12961, 31, 499, 'São João do Cariri', 'BR', 'PB'),
(12962, 31, 499, 'São João do Rio do Peixe', 'BR', 'PB'),
(12963, 31, 499, 'São João do Tigre', 'BR', 'PB'),
(12964, 31, 499, 'São José da Lagoa Tapada', 'BR', 'PB'),
(12965, 31, 499, 'São José de Caiana', 'BR', 'PB'),
(12966, 31, 499, 'São José de Espinharas', 'BR', 'PB'),
(12967, 31, 499, 'São José de Piranhas', 'BR', 'PB'),
(12968, 31, 499, 'São José de Princesa', 'BR', 'PB'),
(12969, 31, 499, 'São José do Bonfim', 'BR', 'PB'),
(12970, 31, 499, 'São José do Brejo do Cruz', 'BR', 'PB'),
(12971, 31, 499, 'São José do Sabugi', 'BR', 'PB'),
(12972, 31, 499, 'São José dos Cordeiros', 'BR', 'PB'),
(12973, 31, 499, 'São José dos Ramos', 'BR', 'PB'),
(12974, 31, 499, 'São Mamede', 'BR', 'PB'),
(12975, 31, 499, 'São Miguel de Taipu', 'BR', 'PB'),
(12976, 31, 499, 'São Sebastião de Lagoa de Roça', 'BR', 'PB'),
(12977, 31, 499, 'São Sebastião do Umbuzeiro', 'BR', 'PB'),
(12978, 31, 499, 'São Vicente do Seridó', 'BR', 'PB'),
(12979, 31, 499, 'Sapé', 'BR', 'PB'),
(12980, 31, 499, 'Serra Branca', 'BR', 'PB'),
(12981, 31, 499, 'Serra da Raiz', 'BR', 'PB'),
(12982, 31, 499, 'Serra Grande', 'BR', 'PB'),
(12983, 31, 499, 'Serra Redonda', 'BR', 'PB'),
(12984, 31, 499, 'Serraria', 'BR', 'PB'),
(12985, 31, 499, 'Sertãozinho', 'BR', 'PB'),
(12986, 31, 499, 'Sobrado', 'BR', 'PB'),
(12987, 31, 499, 'Solânea', 'BR', 'PB'),
(12988, 31, 499, 'Soledade', 'BR', 'PB'),
(12989, 31, 499, 'Sossêgo', 'BR', 'PB'),
(12990, 31, 499, 'Sousa', 'BR', 'PB'),
(12991, 31, 499, 'Sumé', 'BR', 'PB'),
(12992, 31, 499, 'Tacima', 'BR', 'PB'),
(12993, 31, 499, 'Taperoá', 'BR', 'PB'),
(12994, 31, 499, 'Tavares', 'BR', 'PB'),
(12995, 31, 499, 'Teixeira', 'BR', 'PB'),
(12996, 31, 499, 'Tenório', 'BR', 'PB'),
(12997, 31, 499, 'Triunfo', 'BR', 'PB'),
(12998, 31, 499, 'Uiraúna', 'BR', 'PB'),
(12999, 31, 499, 'Umbuzeiro', 'BR', 'PB'),
(13000, 31, 499, 'Várzea', 'BR', 'PB');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(13001, 31, 499, 'Vieirópolis', 'BR', 'PB'),
(13002, 31, 499, 'Vista Serrana', 'BR', 'PB'),
(13003, 31, 499, 'Zabelê', 'BR', 'PB'),
(13004, 31, 500, 'Abatiá', 'BR', 'PR'),
(13005, 31, 500, 'Adrianópolis', 'BR', 'PR'),
(13006, 31, 500, 'Agudos do Sul', 'BR', 'PR'),
(13007, 31, 500, 'Almirante Tamandaré', 'BR', 'PR'),
(13008, 31, 500, 'Altamira do Paraná', 'BR', 'PR'),
(13009, 31, 500, 'Altãnia', 'BR', 'PR'),
(13010, 31, 500, 'Alto Paraíso', 'BR', 'PR'),
(13011, 31, 500, 'Alto Paraná', 'BR', 'PR'),
(13012, 31, 500, 'Alto Piquiri', 'BR', 'PR'),
(13013, 31, 500, 'Altônia', 'BR', 'PR'),
(13014, 31, 500, 'Alvorada do Sul', 'BR', 'PR'),
(13015, 31, 500, 'Amaporã', 'BR', 'PR'),
(13016, 31, 500, 'Ampére', 'BR', 'PR'),
(13017, 31, 500, 'Anahy', 'BR', 'PR'),
(13018, 31, 500, 'Andirá', 'BR', 'PR'),
(13019, 31, 500, 'Ângulo', 'BR', 'PR'),
(13020, 31, 500, 'Antonina', 'BR', 'PR'),
(13021, 31, 500, 'Antônio Olinto', 'BR', 'PR'),
(13022, 31, 500, 'Apucarana', 'BR', 'PR'),
(13023, 31, 500, 'Arapongas', 'BR', 'PR'),
(13024, 31, 500, 'Arapoti', 'BR', 'PR'),
(13025, 31, 500, 'Arapuã', 'BR', 'PR'),
(13026, 31, 500, 'Araruna', 'BR', 'PR'),
(13027, 31, 500, 'Araucária', 'BR', 'PR'),
(13028, 31, 500, 'Ariranha do Ivaí', 'BR', 'PR'),
(13029, 31, 500, 'Assaí', 'BR', 'PR'),
(13030, 31, 500, 'Assis Chateaubriand', 'BR', 'PR'),
(13031, 31, 500, 'Astorga', 'BR', 'PR'),
(13032, 31, 500, 'Atalaia', 'BR', 'PR'),
(13033, 31, 500, 'Balsa Nova', 'BR', 'PR'),
(13034, 31, 500, 'Bandeirantes', 'BR', 'PR'),
(13035, 31, 500, 'Barbosa Ferraz', 'BR', 'PR'),
(13036, 31, 500, 'Barra do Jacaré', 'BR', 'PR'),
(13037, 31, 500, 'Barracão', 'BR', 'PR'),
(13038, 31, 500, 'Bela Vista da Caroba', 'BR', 'PR'),
(13039, 31, 500, 'Bela Vista do Paraíso', 'BR', 'PR'),
(13040, 31, 500, 'Bituruna', 'BR', 'PR'),
(13041, 31, 500, 'Boa Esperança', 'BR', 'PR'),
(13042, 31, 500, 'Boa Esperança do Iguaçu', 'BR', 'PR'),
(13043, 31, 500, 'Boa Ventura de São Roque', 'BR', 'PR'),
(13044, 31, 500, 'Boa Vista da Aparecida', 'BR', 'PR'),
(13045, 31, 500, 'Bocaiúva do Sul', 'BR', 'PR'),
(13046, 31, 500, 'Bom Jesus do Sul', 'BR', 'PR'),
(13047, 31, 500, 'Bom Sucesso', 'BR', 'PR'),
(13048, 31, 500, 'Bom Sucesso do Sul', 'BR', 'PR'),
(13049, 31, 500, 'Borrazópolis', 'BR', 'PR'),
(13050, 31, 500, 'Braganey', 'BR', 'PR'),
(13051, 31, 500, 'Brasilândia do Sul', 'BR', 'PR'),
(13052, 31, 500, 'Cafeara', 'BR', 'PR'),
(13053, 31, 500, 'Cafelândia', 'BR', 'PR'),
(13054, 31, 500, 'Cafezal do Sul', 'BR', 'PR'),
(13055, 31, 500, 'Califórnia', 'BR', 'PR'),
(13056, 31, 500, 'Cambará', 'BR', 'PR'),
(13057, 31, 500, 'Cambé', 'BR', 'PR'),
(13058, 31, 500, 'Cambira', 'BR', 'PR'),
(13059, 31, 500, 'Campina da Lagoa', 'BR', 'PR'),
(13060, 31, 500, 'Campina do Simão', 'BR', 'PR'),
(13061, 31, 500, 'Campina Grande do Sul', 'BR', 'PR'),
(13062, 31, 500, 'Campo Bonito', 'BR', 'PR'),
(13063, 31, 500, 'Campo do Tenente', 'BR', 'PR'),
(13064, 31, 500, 'Campo Largo', 'BR', 'PR'),
(13065, 31, 500, 'Campo Magro', 'BR', 'PR'),
(13066, 31, 500, 'Campo Mourão', 'BR', 'PR'),
(13067, 31, 500, 'Cândido de Abreu', 'BR', 'PR'),
(13068, 31, 500, 'Candói', 'BR', 'PR'),
(13069, 31, 500, 'Cantagalo', 'BR', 'PR'),
(13070, 31, 500, 'Capanema', 'BR', 'PR'),
(13071, 31, 500, 'Capitão Leônidas Marques', 'BR', 'PR'),
(13072, 31, 500, 'Carambeí', 'BR', 'PR'),
(13073, 31, 500, 'Carlópolis', 'BR', 'PR'),
(13074, 31, 500, 'Cascavel', 'BR', 'PR'),
(13075, 31, 500, 'Castro', 'BR', 'PR'),
(13076, 31, 500, 'Catanduvas', 'BR', 'PR'),
(13077, 31, 500, 'Centenário do Sul', 'BR', 'PR'),
(13078, 31, 500, 'Cerro Azul', 'BR', 'PR'),
(13079, 31, 500, 'Céu Azul', 'BR', 'PR'),
(13080, 31, 500, 'Chopinzinho', 'BR', 'PR'),
(13081, 31, 500, 'Cianorte', 'BR', 'PR'),
(13082, 31, 500, 'Cidade Gaúcha', 'BR', 'PR'),
(13083, 31, 500, 'Clevelândia', 'BR', 'PR'),
(13084, 31, 500, 'Colombo', 'BR', 'PR'),
(13085, 31, 500, 'Colorado', 'BR', 'PR'),
(13086, 31, 500, 'Congonhinhas', 'BR', 'PR'),
(13087, 31, 500, 'Conselheiro Mairinck', 'BR', 'PR'),
(13088, 31, 500, 'Contenda', 'BR', 'PR'),
(13089, 31, 500, 'Corbélia', 'BR', 'PR'),
(13090, 31, 500, 'Cornélio Procópio', 'BR', 'PR'),
(13091, 31, 500, 'Coronel Domingos Soares', 'BR', 'PR'),
(13092, 31, 500, 'Coronel Vivida', 'BR', 'PR'),
(13093, 31, 500, 'Corumbataí do Sul', 'BR', 'PR'),
(13094, 31, 500, 'Cruz Machado', 'BR', 'PR'),
(13095, 31, 500, 'Cruzeiro do Iguaçu', 'BR', 'PR'),
(13096, 31, 500, 'Cruzeiro do Oeste', 'BR', 'PR'),
(13097, 31, 500, 'Cruzeiro do Sul', 'BR', 'PR'),
(13098, 31, 500, 'Cruzmaltina', 'BR', 'PR'),
(13099, 31, 500, 'Curitiba', 'BR', 'PR'),
(13100, 31, 500, 'Curiúva', 'BR', 'PR'),
(13101, 31, 500, 'Diamante d\'Oeste', 'BR', 'PR'),
(13102, 31, 500, 'Diamante do Norte', 'BR', 'PR'),
(13103, 31, 500, 'Diamante do Sul', 'BR', 'PR'),
(13104, 31, 500, 'Dois Vizinhos', 'BR', 'PR'),
(13105, 31, 500, 'Douradina', 'BR', 'PR'),
(13106, 31, 500, 'Doutor Camargo', 'BR', 'PR'),
(13107, 31, 500, 'Doutor Ulysses', 'BR', 'PR'),
(13108, 31, 500, 'Enéas Marques', 'BR', 'PR'),
(13109, 31, 500, 'Engenheiro Beltrão', 'BR', 'PR'),
(13110, 31, 500, 'Entre Rios do Oeste', 'BR', 'PR'),
(13111, 31, 500, 'Esperança Nova', 'BR', 'PR'),
(13112, 31, 500, 'Espigão Alto do Iguaçu', 'BR', 'PR'),
(13113, 31, 500, 'Farol', 'BR', 'PR'),
(13114, 31, 500, 'Faxinal', 'BR', 'PR'),
(13115, 31, 500, 'Fazenda Rio Grande', 'BR', 'PR'),
(13116, 31, 500, 'Fênix', 'BR', 'PR'),
(13117, 31, 500, 'Fernandes Pinheiro', 'BR', 'PR'),
(13118, 31, 500, 'Figueira', 'BR', 'PR'),
(13119, 31, 500, 'Flor da Serra do Sul', 'BR', 'PR'),
(13120, 31, 500, 'Floraí', 'BR', 'PR'),
(13121, 31, 500, 'Floresta', 'BR', 'PR'),
(13122, 31, 500, 'Florestópolis', 'BR', 'PR'),
(13123, 31, 500, 'Flórida', 'BR', 'PR'),
(13124, 31, 500, 'Formosa do Oeste', 'BR', 'PR'),
(13125, 31, 500, 'Foz do Iguaçu', 'BR', 'PR'),
(13126, 31, 500, 'Foz do Jordão', 'BR', 'PR'),
(13127, 31, 500, 'Francisco Alves', 'BR', 'PR'),
(13128, 31, 500, 'Francisco Beltrão', 'BR', 'PR'),
(13129, 31, 500, 'General Carneiro', 'BR', 'PR'),
(13130, 31, 500, 'Godoy Moreira', 'BR', 'PR'),
(13131, 31, 500, 'Goioerê', 'BR', 'PR'),
(13132, 31, 500, 'Goioxim', 'BR', 'PR'),
(13133, 31, 500, 'Grandes Rios', 'BR', 'PR'),
(13134, 31, 500, 'Guaíra', 'BR', 'PR'),
(13135, 31, 500, 'Guairaçá', 'BR', 'PR'),
(13136, 31, 500, 'Guamiranga', 'BR', 'PR'),
(13137, 31, 500, 'Guapirama', 'BR', 'PR'),
(13138, 31, 500, 'Guaporema', 'BR', 'PR'),
(13139, 31, 500, 'Guaraci', 'BR', 'PR'),
(13140, 31, 500, 'Guaraniaçu', 'BR', 'PR'),
(13141, 31, 500, 'Guarapuava', 'BR', 'PR'),
(13142, 31, 500, 'Guaraqueçaba', 'BR', 'PR'),
(13143, 31, 500, 'Guaratuba', 'BR', 'PR'),
(13144, 31, 500, 'Honório Serpa', 'BR', 'PR'),
(13145, 31, 500, 'Ibaiti', 'BR', 'PR'),
(13146, 31, 500, 'Ibema', 'BR', 'PR'),
(13147, 31, 500, 'Ibiporã', 'BR', 'PR'),
(13148, 31, 500, 'Icaraíma', 'BR', 'PR'),
(13149, 31, 500, 'Iguaraçu', 'BR', 'PR'),
(13150, 31, 500, 'Iguatu', 'BR', 'PR'),
(13151, 31, 500, 'Imbaú', 'BR', 'PR'),
(13152, 31, 500, 'Imbituva', 'BR', 'PR'),
(13153, 31, 500, 'Inácio Martins', 'BR', 'PR'),
(13154, 31, 500, 'Inajá', 'BR', 'PR'),
(13155, 31, 500, 'Indianópolis', 'BR', 'PR'),
(13156, 31, 500, 'Ipiranga', 'BR', 'PR'),
(13157, 31, 500, 'Iporã', 'BR', 'PR'),
(13158, 31, 500, 'Iracema do Oeste', 'BR', 'PR'),
(13159, 31, 500, 'Irati', 'BR', 'PR'),
(13160, 31, 500, 'Iretama', 'BR', 'PR'),
(13161, 31, 500, 'Itaguajé', 'BR', 'PR'),
(13162, 31, 500, 'Itaipulândia', 'BR', 'PR'),
(13163, 31, 500, 'Itambaracá', 'BR', 'PR'),
(13164, 31, 500, 'Itambé', 'BR', 'PR'),
(13165, 31, 500, 'Itapejara d\'Oeste', 'BR', 'PR'),
(13166, 31, 500, 'Itaperuçu', 'BR', 'PR'),
(13167, 31, 500, 'Itaúna do Sul', 'BR', 'PR'),
(13168, 31, 500, 'Ivaí', 'BR', 'PR'),
(13169, 31, 500, 'Ivaiporã', 'BR', 'PR'),
(13170, 31, 500, 'Ivaté', 'BR', 'PR'),
(13171, 31, 500, 'Ivatuba', 'BR', 'PR'),
(13172, 31, 500, 'Jaboti', 'BR', 'PR'),
(13173, 31, 500, 'Jacarezinho', 'BR', 'PR'),
(13174, 31, 500, 'Jaguapitã', 'BR', 'PR'),
(13175, 31, 500, 'Jaguariaíva', 'BR', 'PR'),
(13176, 31, 500, 'Jandaia do Sul', 'BR', 'PR'),
(13177, 31, 500, 'Janiópolis', 'BR', 'PR'),
(13178, 31, 500, 'Japira', 'BR', 'PR'),
(13179, 31, 500, 'Japurá', 'BR', 'PR'),
(13180, 31, 500, 'Jardim Alegre', 'BR', 'PR'),
(13181, 31, 500, 'Jardim Olinda', 'BR', 'PR'),
(13182, 31, 500, 'Jataizinho', 'BR', 'PR'),
(13183, 31, 500, 'Jesuítas', 'BR', 'PR'),
(13184, 31, 500, 'Joaquim Távora', 'BR', 'PR'),
(13185, 31, 500, 'Jundiaí do Sul', 'BR', 'PR'),
(13186, 31, 500, 'Juranda', 'BR', 'PR'),
(13187, 31, 500, 'Jussara', 'BR', 'PR'),
(13188, 31, 500, 'Kaloré', 'BR', 'PR'),
(13189, 31, 500, 'Lapa', 'BR', 'PR'),
(13190, 31, 500, 'Laranjal', 'BR', 'PR'),
(13191, 31, 500, 'Laranjeiras do Sul', 'BR', 'PR'),
(13192, 31, 500, 'Leópolis', 'BR', 'PR'),
(13193, 31, 500, 'Lidianópolis', 'BR', 'PR'),
(13194, 31, 500, 'Lindoeste', 'BR', 'PR'),
(13195, 31, 500, 'Loanda', 'BR', 'PR'),
(13196, 31, 500, 'Lobato', 'BR', 'PR'),
(13197, 31, 500, 'Londrina', 'BR', 'PR'),
(13198, 31, 500, 'Luiziana', 'BR', 'PR'),
(13199, 31, 500, 'Lunardelli', 'BR', 'PR'),
(13200, 31, 500, 'Lupionópolis', 'BR', 'PR'),
(13201, 31, 500, 'Mallet', 'BR', 'PR'),
(13202, 31, 500, 'Mamborê', 'BR', 'PR'),
(13203, 31, 500, 'Mandaguaçu', 'BR', 'PR'),
(13204, 31, 500, 'Mandaguari', 'BR', 'PR'),
(13205, 31, 500, 'Mandirituba', 'BR', 'PR'),
(13206, 31, 500, 'Manfrinópolis', 'BR', 'PR'),
(13207, 31, 500, 'Mangueirinha', 'BR', 'PR'),
(13208, 31, 500, 'Manoel Ribas', 'BR', 'PR'),
(13209, 31, 500, 'Marechal Cândido Rondon', 'BR', 'PR'),
(13210, 31, 500, 'Maria Helena', 'BR', 'PR'),
(13211, 31, 500, 'Marialva', 'BR', 'PR'),
(13212, 31, 500, 'Marilândia do Sul', 'BR', 'PR'),
(13213, 31, 500, 'Marilena', 'BR', 'PR'),
(13214, 31, 500, 'Mariluz', 'BR', 'PR'),
(13215, 31, 500, 'Maringá', 'BR', 'PR'),
(13216, 31, 500, 'Mariópolis', 'BR', 'PR'),
(13217, 31, 500, 'Maripá', 'BR', 'PR'),
(13218, 31, 500, 'Marmeleiro', 'BR', 'PR'),
(13219, 31, 500, 'Marquinho', 'BR', 'PR'),
(13220, 31, 500, 'Marumbi', 'BR', 'PR'),
(13221, 31, 500, 'Matelândia', 'BR', 'PR'),
(13222, 31, 500, 'Matinhos', 'BR', 'PR'),
(13223, 31, 500, 'Mato Rico', 'BR', 'PR'),
(13224, 31, 500, 'Mauá da Serra', 'BR', 'PR'),
(13225, 31, 500, 'Medianeira', 'BR', 'PR'),
(13226, 31, 500, 'Mercedes', 'BR', 'PR'),
(13227, 31, 500, 'Mirador', 'BR', 'PR'),
(13228, 31, 500, 'Miraselva', 'BR', 'PR'),
(13229, 31, 500, 'Missal', 'BR', 'PR'),
(13230, 31, 500, 'Moreira Sales', 'BR', 'PR'),
(13231, 31, 500, 'Morretes', 'BR', 'PR'),
(13232, 31, 500, 'Munhoz de Melo', 'BR', 'PR'),
(13233, 31, 500, 'Nossa Senhora das Graças', 'BR', 'PR'),
(13234, 31, 500, 'Nova Aliança do Ivaí', 'BR', 'PR'),
(13235, 31, 500, 'Nova América da Colina', 'BR', 'PR'),
(13236, 31, 500, 'Nova Aurora', 'BR', 'PR'),
(13237, 31, 500, 'Nova Cantu', 'BR', 'PR'),
(13238, 31, 500, 'Nova Esperança', 'BR', 'PR'),
(13239, 31, 500, 'Nova Esperança do Sudoeste', 'BR', 'PR'),
(13240, 31, 500, 'Nova Fátima', 'BR', 'PR'),
(13241, 31, 500, 'Nova Laranjeiras', 'BR', 'PR'),
(13242, 31, 500, 'Nova Londrina', 'BR', 'PR'),
(13243, 31, 500, 'Nova Olímpia', 'BR', 'PR'),
(13244, 31, 500, 'Nova Prata do Iguaçu', 'BR', 'PR'),
(13245, 31, 500, 'Nova Santa Bárbara', 'BR', 'PR'),
(13246, 31, 500, 'Nova Santa Rosa', 'BR', 'PR'),
(13247, 31, 500, 'Nova Tebas', 'BR', 'PR'),
(13248, 31, 500, 'Novo Itacolomi', 'BR', 'PR'),
(13249, 31, 500, 'Ortigueira', 'BR', 'PR'),
(13250, 31, 500, 'Ourizona', 'BR', 'PR'),
(13251, 31, 500, 'Ouro Verde do Oeste', 'BR', 'PR'),
(13252, 31, 500, 'Paiçandu', 'BR', 'PR'),
(13253, 31, 500, 'Palmas', 'BR', 'PR'),
(13254, 31, 500, 'Palmeira', 'BR', 'PR'),
(13255, 31, 500, 'Palmital', 'BR', 'PR'),
(13256, 31, 500, 'Palotina', 'BR', 'PR'),
(13257, 31, 500, 'Paraíso do Norte', 'BR', 'PR'),
(13258, 31, 500, 'Paranacity', 'BR', 'PR'),
(13259, 31, 500, 'Paranaguá', 'BR', 'PR'),
(13260, 31, 500, 'Paranapoema', 'BR', 'PR'),
(13261, 31, 500, 'Paranavaí', 'BR', 'PR'),
(13262, 31, 500, 'Pato Bragado', 'BR', 'PR'),
(13263, 31, 500, 'Pato Branco', 'BR', 'PR'),
(13264, 31, 500, 'Paula Freitas', 'BR', 'PR'),
(13265, 31, 500, 'Paulo Frontin', 'BR', 'PR'),
(13266, 31, 500, 'Peabiru', 'BR', 'PR'),
(13267, 31, 500, 'Perobal', 'BR', 'PR'),
(13268, 31, 500, 'Pérola', 'BR', 'PR'),
(13269, 31, 500, 'Pérola d\'Oeste', 'BR', 'PR'),
(13270, 31, 500, 'Piên', 'BR', 'PR'),
(13271, 31, 500, 'Pinhais', 'BR', 'PR'),
(13272, 31, 500, 'Pinhal de São Bento', 'BR', 'PR'),
(13273, 31, 500, 'Pinhalão', 'BR', 'PR'),
(13274, 31, 500, 'Pinhão', 'BR', 'PR'),
(13275, 31, 500, 'Piraí do Sul', 'BR', 'PR'),
(13276, 31, 500, 'Piraquara', 'BR', 'PR'),
(13277, 31, 500, 'Pitanga', 'BR', 'PR'),
(13278, 31, 500, 'Pitangueiras', 'BR', 'PR'),
(13279, 31, 500, 'Planaltina do Paraná', 'BR', 'PR'),
(13280, 31, 500, 'Planalto', 'BR', 'PR'),
(13281, 31, 500, 'Ponta Grossa', 'BR', 'PR'),
(13282, 31, 500, 'Pontal do Paraná', 'BR', 'PR'),
(13283, 31, 500, 'Porecatu', 'BR', 'PR'),
(13284, 31, 500, 'Porto Amazonas', 'BR', 'PR'),
(13285, 31, 500, 'Porto Barreiro', 'BR', 'PR'),
(13286, 31, 500, 'Porto Rico', 'BR', 'PR'),
(13287, 31, 500, 'Porto Vitória', 'BR', 'PR'),
(13288, 31, 500, 'Prado Ferreira', 'BR', 'PR'),
(13289, 31, 500, 'Pranchita', 'BR', 'PR'),
(13290, 31, 500, 'Presidente Castelo Branco', 'BR', 'PR'),
(13291, 31, 500, 'Primeiro de Maio', 'BR', 'PR'),
(13292, 31, 500, 'Prudentópolis', 'BR', 'PR'),
(13293, 31, 500, 'Quarto Centenário', 'BR', 'PR'),
(13294, 31, 500, 'Quatiguá', 'BR', 'PR'),
(13295, 31, 500, 'Quatro Barras', 'BR', 'PR'),
(13296, 31, 500, 'Quatro Pontes', 'BR', 'PR'),
(13297, 31, 500, 'Quedas do Iguaçu', 'BR', 'PR'),
(13298, 31, 500, 'Querência do Norte', 'BR', 'PR'),
(13299, 31, 500, 'Quinta do Sol', 'BR', 'PR'),
(13300, 31, 500, 'Quitandinha', 'BR', 'PR'),
(13301, 31, 500, 'Ramilândia', 'BR', 'PR'),
(13302, 31, 500, 'Rancho Alegre', 'BR', 'PR'),
(13303, 31, 500, 'Rancho Alegre d\'Oeste', 'BR', 'PR'),
(13304, 31, 500, 'Realeza', 'BR', 'PR'),
(13305, 31, 500, 'Rebouças', 'BR', 'PR'),
(13306, 31, 500, 'Renascença', 'BR', 'PR'),
(13307, 31, 500, 'Reserva', 'BR', 'PR'),
(13308, 31, 500, 'Reserva do Iguaçu', 'BR', 'PR'),
(13309, 31, 500, 'Ribeirão Claro', 'BR', 'PR'),
(13310, 31, 500, 'Ribeirão do Pinhal', 'BR', 'PR'),
(13311, 31, 500, 'Rio Azul', 'BR', 'PR'),
(13312, 31, 500, 'Rio Bom', 'BR', 'PR'),
(13313, 31, 500, 'Rio Bonito do Iguaçu', 'BR', 'PR'),
(13314, 31, 500, 'Rio Branco do Ivaí', 'BR', 'PR'),
(13315, 31, 500, 'Rio Branco do Sul', 'BR', 'PR'),
(13316, 31, 500, 'Rio Negro', 'BR', 'PR'),
(13317, 31, 500, 'Rolândia', 'BR', 'PR'),
(13318, 31, 500, 'Roncador', 'BR', 'PR'),
(13319, 31, 500, 'Rondon', 'BR', 'PR'),
(13320, 31, 500, 'Rosário do Ivaí', 'BR', 'PR'),
(13321, 31, 500, 'Sabáudia', 'BR', 'PR'),
(13322, 31, 500, 'Salgado Filho', 'BR', 'PR'),
(13323, 31, 500, 'Salto do Itararé', 'BR', 'PR'),
(13324, 31, 500, 'Salto do Lontra', 'BR', 'PR'),
(13325, 31, 500, 'Santa Amélia', 'BR', 'PR'),
(13326, 31, 500, 'Santa Cecília do Pavão', 'BR', 'PR'),
(13327, 31, 500, 'Santa Cruz de Monte Castelo', 'BR', 'PR'),
(13328, 31, 500, 'Santa Fé', 'BR', 'PR'),
(13329, 31, 500, 'Santa Helena', 'BR', 'PR'),
(13330, 31, 500, 'Santa Inês', 'BR', 'PR'),
(13331, 31, 500, 'Santa Isabel do Ivaí', 'BR', 'PR'),
(13332, 31, 500, 'Santa Izabel do Oeste', 'BR', 'PR'),
(13333, 31, 500, 'Santa Lúcia', 'BR', 'PR'),
(13334, 31, 500, 'Santa Maria do Oeste', 'BR', 'PR'),
(13335, 31, 500, 'Santa Mariana', 'BR', 'PR'),
(13336, 31, 500, 'Santa Mônica', 'BR', 'PR'),
(13337, 31, 500, 'Santa Tereza do Oeste', 'BR', 'PR'),
(13338, 31, 500, 'Santa Terezinha de Itaipu', 'BR', 'PR'),
(13339, 31, 500, 'Santana do Itararé', 'BR', 'PR'),
(13340, 31, 500, 'Santo Antônio da Platina', 'BR', 'PR'),
(13341, 31, 500, 'Santo Antônio do Caiuá', 'BR', 'PR'),
(13342, 31, 500, 'Santo Antônio do Paraíso', 'BR', 'PR'),
(13343, 31, 500, 'Santo Antônio do Sudoeste', 'BR', 'PR'),
(13344, 31, 500, 'Santo Inácio', 'BR', 'PR'),
(13345, 31, 500, 'São Carlos do Ivaí', 'BR', 'PR'),
(13346, 31, 500, 'São Jerônimo da Serra', 'BR', 'PR'),
(13347, 31, 500, 'São João', 'BR', 'PR'),
(13348, 31, 500, 'São João do Caiuá', 'BR', 'PR'),
(13349, 31, 500, 'São João do Ivaí', 'BR', 'PR'),
(13350, 31, 500, 'São João do Triunfo', 'BR', 'PR'),
(13351, 31, 500, 'São Jorge d\'Oeste', 'BR', 'PR'),
(13352, 31, 500, 'São Jorge do Ivaí', 'BR', 'PR'),
(13353, 31, 500, 'São Jorge do Patrocínio', 'BR', 'PR'),
(13354, 31, 500, 'São José da Boa Vista', 'BR', 'PR'),
(13355, 31, 500, 'São José das Palmeiras', 'BR', 'PR'),
(13356, 31, 500, 'São José dos Pinhais', 'BR', 'PR'),
(13357, 31, 500, 'São Manoel do Paraná', 'BR', 'PR'),
(13358, 31, 500, 'São Mateus do Sul', 'BR', 'PR'),
(13359, 31, 500, 'São Miguel do Iguaçu', 'BR', 'PR'),
(13360, 31, 500, 'São Pedro do Iguaçu', 'BR', 'PR'),
(13361, 31, 500, 'São Pedro do Ivaí', 'BR', 'PR'),
(13362, 31, 500, 'São Pedro do Paraná', 'BR', 'PR'),
(13363, 31, 500, 'São Sebastião da Amoreira', 'BR', 'PR'),
(13364, 31, 500, 'São Tomé', 'BR', 'PR'),
(13365, 31, 500, 'Sapopema', 'BR', 'PR'),
(13366, 31, 500, 'Sarandi', 'BR', 'PR'),
(13367, 31, 500, 'Saudade do Iguaçu', 'BR', 'PR'),
(13368, 31, 500, 'Sengés', 'BR', 'PR'),
(13369, 31, 500, 'Serranópolis do Iguaçu', 'BR', 'PR'),
(13370, 31, 500, 'Sertaneja', 'BR', 'PR'),
(13371, 31, 500, 'Sertanópolis', 'BR', 'PR'),
(13372, 31, 500, 'Siqueira Campos', 'BR', 'PR'),
(13373, 31, 500, 'Sulina', 'BR', 'PR'),
(13374, 31, 500, 'Tamarana', 'BR', 'PR'),
(13375, 31, 500, 'Tamboara', 'BR', 'PR'),
(13376, 31, 500, 'Tapejara', 'BR', 'PR'),
(13377, 31, 500, 'Tapira', 'BR', 'PR'),
(13378, 31, 500, 'Teixeira Soares', 'BR', 'PR'),
(13379, 31, 500, 'Telêmaco Borba', 'BR', 'PR'),
(13380, 31, 500, 'Terra Boa', 'BR', 'PR'),
(13381, 31, 500, 'Terra Rica', 'BR', 'PR'),
(13382, 31, 500, 'Terra Roxa', 'BR', 'PR'),
(13383, 31, 500, 'Tibagi', 'BR', 'PR'),
(13384, 31, 500, 'Tijucas do Sul', 'BR', 'PR'),
(13385, 31, 500, 'Toledo', 'BR', 'PR'),
(13386, 31, 500, 'Tomazina', 'BR', 'PR'),
(13387, 31, 500, 'Três Barras do Paraná', 'BR', 'PR'),
(13388, 31, 500, 'Tunas do Paraná', 'BR', 'PR'),
(13389, 31, 500, 'Tuneiras do Oeste', 'BR', 'PR'),
(13390, 31, 500, 'Tupãssi', 'BR', 'PR'),
(13391, 31, 500, 'Turvo', 'BR', 'PR'),
(13392, 31, 500, 'Ubiratã', 'BR', 'PR'),
(13393, 31, 500, 'Umuarama', 'BR', 'PR'),
(13394, 31, 500, 'União da Vitória', 'BR', 'PR'),
(13395, 31, 500, 'Uniflor', 'BR', 'PR'),
(13396, 31, 500, 'Uraí', 'BR', 'PR'),
(13397, 31, 500, 'Ventania', 'BR', 'PR'),
(13398, 31, 500, 'Vera Cruz do Oeste', 'BR', 'PR'),
(13399, 31, 500, 'Verê', 'BR', 'PR'),
(13400, 31, 500, 'Virmond', 'BR', 'PR'),
(13401, 31, 500, 'Vitorino', 'BR', 'PR'),
(13402, 31, 500, 'Wenceslau Braz', 'BR', 'PR'),
(13403, 31, 500, 'Xambrê', 'BR', 'PR'),
(13404, 31, 501, 'Abreu e Lima', 'BR', 'PE'),
(13405, 31, 501, 'Afogados da Ingazeira', 'BR', 'PE'),
(13406, 31, 501, 'Afrânio', 'BR', 'PE'),
(13407, 31, 501, 'Agrestina', 'BR', 'PE'),
(13408, 31, 501, 'Água Preta', 'BR', 'PE'),
(13409, 31, 501, 'Águas Belas', 'BR', 'PE'),
(13410, 31, 501, 'Alagoinha', 'BR', 'PE'),
(13411, 31, 501, 'Aliança', 'BR', 'PE'),
(13412, 31, 501, 'Altinho', 'BR', 'PE'),
(13413, 31, 501, 'Amaraji', 'BR', 'PE'),
(13414, 31, 501, 'Angelim', 'BR', 'PE'),
(13415, 31, 501, 'Araçoiaba', 'BR', 'PE'),
(13416, 31, 501, 'Araripina', 'BR', 'PE'),
(13417, 31, 501, 'Arcoverde', 'BR', 'PE'),
(13418, 31, 501, 'Barra de Guabiraba', 'BR', 'PE'),
(13419, 31, 501, 'Barreiros', 'BR', 'PE'),
(13420, 31, 501, 'Belém de Maria', 'BR', 'PE'),
(13421, 31, 501, 'Belém de São Francisco', 'BR', 'PE'),
(13422, 31, 501, 'Belém do São Francisco', 'BR', 'PE'),
(13423, 31, 501, 'Belo Jardim', 'BR', 'PE'),
(13424, 31, 501, 'Betânia', 'BR', 'PE'),
(13425, 31, 501, 'Bezerros', 'BR', 'PE'),
(13426, 31, 501, 'Bodocó', 'BR', 'PE'),
(13427, 31, 501, 'Bom Conselho', 'BR', 'PE'),
(13428, 31, 501, 'Bom Jardim', 'BR', 'PE'),
(13429, 31, 501, 'Bonito', 'BR', 'PE'),
(13430, 31, 501, 'Brejão', 'BR', 'PE'),
(13431, 31, 501, 'Brejinho', 'BR', 'PE'),
(13432, 31, 501, 'Brejo da Madre de Deus', 'BR', 'PE'),
(13433, 31, 501, 'Buenos Aires', 'BR', 'PE'),
(13434, 31, 501, 'Buíque', 'BR', 'PE'),
(13435, 31, 501, 'Cabo', 'BR', 'PE'),
(13436, 31, 501, 'Cabo de Santo Agostinho', 'BR', 'PE'),
(13437, 31, 501, 'Cabrobó', 'BR', 'PE'),
(13438, 31, 501, 'Cachoeirinha', 'BR', 'PE'),
(13439, 31, 501, 'Caetés', 'BR', 'PE'),
(13440, 31, 501, 'Calçado', 'BR', 'PE'),
(13441, 31, 501, 'Calumbi', 'BR', 'PE'),
(13442, 31, 501, 'Camaragibe', 'BR', 'PE'),
(13443, 31, 501, 'Camocim de São Félix', 'BR', 'PE'),
(13444, 31, 501, 'Camutanga', 'BR', 'PE'),
(13445, 31, 501, 'Canhotinho', 'BR', 'PE'),
(13446, 31, 501, 'Capoeiras', 'BR', 'PE'),
(13447, 31, 501, 'Carnaíba', 'BR', 'PE'),
(13448, 31, 501, 'Carnaubeira da Penha', 'BR', 'PE'),
(13449, 31, 501, 'Carpina', 'BR', 'PE'),
(13450, 31, 501, 'Caruaru', 'BR', 'PE'),
(13451, 31, 501, 'Casinhas', 'BR', 'PE'),
(13452, 31, 501, 'Catende', 'BR', 'PE'),
(13453, 31, 501, 'Cedro', 'BR', 'PE'),
(13454, 31, 501, 'Chã de Alegria', 'BR', 'PE'),
(13455, 31, 501, 'Chã Grande', 'BR', 'PE'),
(13456, 31, 501, 'Colônia Leopoldina', 'BR', 'PE'),
(13457, 31, 501, 'Condado', 'BR', 'PE'),
(13458, 31, 501, 'Correntes', 'BR', 'PE'),
(13459, 31, 501, 'Cortês', 'BR', 'PE'),
(13460, 31, 501, 'Cumaru', 'BR', 'PE'),
(13461, 31, 501, 'Cupira', 'BR', 'PE'),
(13462, 31, 501, 'Custódia', 'BR', 'PE'),
(13463, 31, 501, 'Dormentes', 'BR', 'PE'),
(13464, 31, 501, 'Escada', 'BR', 'PE'),
(13465, 31, 501, 'Exu', 'BR', 'PE'),
(13466, 31, 501, 'Feira Nova', 'BR', 'PE'),
(13467, 31, 501, 'Fernando de Noronha', 'BR', 'PE'),
(13468, 31, 501, 'Fernando de Noronha (Distrito Estadual)', 'BR', 'PE'),
(13469, 31, 501, 'Ferreiros', 'BR', 'PE'),
(13470, 31, 501, 'Flores', 'BR', 'PE'),
(13471, 31, 501, 'Floresta', 'BR', 'PE'),
(13472, 31, 501, 'Frei Miguelinho', 'BR', 'PE'),
(13473, 31, 501, 'Gameleira', 'BR', 'PE'),
(13474, 31, 501, 'Garanhuns', 'BR', 'PE'),
(13475, 31, 501, 'Glória do Goitá', 'BR', 'PE'),
(13476, 31, 501, 'Goiana', 'BR', 'PE'),
(13477, 31, 501, 'Granito', 'BR', 'PE'),
(13478, 31, 501, 'Gravatá', 'BR', 'PE'),
(13479, 31, 501, 'Guabiraba', 'BR', 'PE'),
(13480, 31, 501, 'Iati', 'BR', 'PE'),
(13481, 31, 501, 'Ibimirim', 'BR', 'PE'),
(13482, 31, 501, 'Ibirajuba', 'BR', 'PE'),
(13483, 31, 501, 'Igarassu', 'BR', 'PE'),
(13484, 31, 501, 'Iguaracy', 'BR', 'PE'),
(13485, 31, 501, 'Ilha de Itamaracá', 'BR', 'PE'),
(13486, 31, 501, 'Inajá', 'BR', 'PE'),
(13487, 31, 501, 'Ingazeira', 'BR', 'PE'),
(13488, 31, 501, 'Ipojuca', 'BR', 'PE'),
(13489, 31, 501, 'Ipubi', 'BR', 'PE'),
(13490, 31, 501, 'Itacuruba', 'BR', 'PE'),
(13491, 31, 501, 'Itaíba', 'BR', 'PE'),
(13492, 31, 501, 'Itamaracá', 'BR', 'PE'),
(13493, 31, 501, 'Itambé', 'BR', 'PE'),
(13494, 31, 501, 'Itapetim', 'BR', 'PE'),
(13495, 31, 501, 'Itapissuma', 'BR', 'PE'),
(13496, 31, 501, 'Itaquitinga', 'BR', 'PE'),
(13497, 31, 501, 'Jaboatão', 'BR', 'PE'),
(13498, 31, 501, 'Jaboatão dos Guararapes', 'BR', 'PE'),
(13499, 31, 501, 'Jaqueira', 'BR', 'PE'),
(13500, 31, 501, 'Jataúba', 'BR', 'PE');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(13501, 31, 501, 'Jatobá', 'BR', 'PE'),
(13502, 31, 501, 'João Alfredo', 'BR', 'PE'),
(13503, 31, 501, 'Joaquim Nabuco', 'BR', 'PE'),
(13504, 31, 501, 'Jucati', 'BR', 'PE'),
(13505, 31, 501, 'Jupi', 'BR', 'PE'),
(13506, 31, 501, 'Jurema', 'BR', 'PE'),
(13507, 31, 501, 'Lagoa de Itaenga', 'BR', 'PE'),
(13508, 31, 501, 'Lagoa do Carro', 'BR', 'PE'),
(13509, 31, 501, 'Lagoa do Itaenga', 'BR', 'PE'),
(13510, 31, 501, 'Lagoa do Ouro', 'BR', 'PE'),
(13511, 31, 501, 'Lagoa dos Gatos', 'BR', 'PE'),
(13512, 31, 501, 'Lagoa Grande', 'BR', 'PE'),
(13513, 31, 501, 'Lajedo', 'BR', 'PE'),
(13514, 31, 501, 'Limoeiro', 'BR', 'PE'),
(13515, 31, 501, 'Macaparana', 'BR', 'PE'),
(13516, 31, 501, 'Machados', 'BR', 'PE'),
(13517, 31, 501, 'Manari', 'BR', 'PE'),
(13518, 31, 501, 'Maraial', 'BR', 'PE'),
(13519, 31, 501, 'Mirandiba', 'BR', 'PE'),
(13520, 31, 501, 'Moreilândia', 'BR', 'PE'),
(13521, 31, 501, 'Moreno', 'BR', 'PE'),
(13522, 31, 501, 'Nazaré da Mata', 'BR', 'PE'),
(13523, 31, 501, 'Olinda', 'BR', 'PE'),
(13524, 31, 501, 'Orobó', 'BR', 'PE'),
(13525, 31, 501, 'Orocó', 'BR', 'PE'),
(13526, 31, 501, 'Ouricuri', 'BR', 'PE'),
(13527, 31, 501, 'Palmares', 'BR', 'PE'),
(13528, 31, 501, 'Palmeirina', 'BR', 'PE'),
(13529, 31, 501, 'Panelas', 'BR', 'PE'),
(13530, 31, 501, 'Paranatama', 'BR', 'PE'),
(13531, 31, 501, 'Parnamirim', 'BR', 'PE'),
(13532, 31, 501, 'Passira', 'BR', 'PE'),
(13533, 31, 501, 'Paudalho', 'BR', 'PE'),
(13534, 31, 501, 'Paulista', 'BR', 'PE'),
(13535, 31, 501, 'Pedra', 'BR', 'PE'),
(13536, 31, 501, 'Pesqueira', 'BR', 'PE'),
(13537, 31, 501, 'Petrolândia', 'BR', 'PE'),
(13538, 31, 501, 'Petrolina', 'BR', 'PE'),
(13539, 31, 501, 'Poção', 'BR', 'PE'),
(13540, 31, 501, 'Pombos', 'BR', 'PE'),
(13541, 31, 501, 'Primavera', 'BR', 'PE'),
(13542, 31, 501, 'Quipapá', 'BR', 'PE'),
(13543, 31, 501, 'Quixaba', 'BR', 'PE'),
(13544, 31, 501, 'Recife', 'BR', 'PE'),
(13545, 31, 501, 'Riacho das Almas', 'BR', 'PE'),
(13546, 31, 501, 'Ribeirão', 'BR', 'PE'),
(13547, 31, 501, 'Rio Formoso', 'BR', 'PE'),
(13548, 31, 501, 'Sairé', 'BR', 'PE'),
(13549, 31, 501, 'Salgadinho', 'BR', 'PE'),
(13550, 31, 501, 'Salgueiro', 'BR', 'PE'),
(13551, 31, 501, 'Saloá', 'BR', 'PE'),
(13552, 31, 501, 'Sanharó', 'BR', 'PE'),
(13553, 31, 501, 'Santa Cruz', 'BR', 'PE'),
(13554, 31, 501, 'Santa Cruz da Baixa Verde', 'BR', 'PE'),
(13555, 31, 501, 'Santa Cruz do Capibaribe', 'BR', 'PE'),
(13556, 31, 501, 'Santa Filomena', 'BR', 'PE'),
(13557, 31, 501, 'Santa Maria da Boa Vista', 'BR', 'PE'),
(13558, 31, 501, 'Santa Maria do Cambucá', 'BR', 'PE'),
(13559, 31, 501, 'Santa Terezinha', 'BR', 'PE'),
(13560, 31, 501, 'São Benedito do Sul', 'BR', 'PE'),
(13561, 31, 501, 'São Bento do Una', 'BR', 'PE'),
(13562, 31, 501, 'São Caitano', 'BR', 'PE'),
(13563, 31, 501, 'São João', 'BR', 'PE'),
(13564, 31, 501, 'São Joaquim do Monte', 'BR', 'PE'),
(13565, 31, 501, 'São José da Coroa Grande', 'BR', 'PE'),
(13566, 31, 501, 'São José do Belmonte', 'BR', 'PE'),
(13567, 31, 501, 'São José do Egito', 'BR', 'PE'),
(13568, 31, 501, 'São Lourenço da Mata', 'BR', 'PE'),
(13569, 31, 501, 'São Vicente Férrer', 'BR', 'PE'),
(13570, 31, 501, 'Serra Talhada', 'BR', 'PE'),
(13571, 31, 501, 'Serrita', 'BR', 'PE'),
(13572, 31, 501, 'Sertânia', 'BR', 'PE'),
(13573, 31, 501, 'Sirinhaém', 'BR', 'PE'),
(13574, 31, 501, 'Solidão', 'BR', 'PE'),
(13575, 31, 501, 'Surubim', 'BR', 'PE'),
(13576, 31, 501, 'Tabira', 'BR', 'PE'),
(13577, 31, 501, 'Tacaimbó', 'BR', 'PE'),
(13578, 31, 501, 'Tacaratu', 'BR', 'PE'),
(13579, 31, 501, 'Tamandaré', 'BR', 'PE'),
(13580, 31, 501, 'Taquaritinga do Norte', 'BR', 'PE'),
(13581, 31, 501, 'Terezinha', 'BR', 'PE'),
(13582, 31, 501, 'Terra Nova', 'BR', 'PE'),
(13583, 31, 501, 'Timbaúba', 'BR', 'PE'),
(13584, 31, 501, 'Toritama', 'BR', 'PE'),
(13585, 31, 501, 'Tracunhaém', 'BR', 'PE'),
(13586, 31, 501, 'Trindade', 'BR', 'PE'),
(13587, 31, 501, 'Triunfo', 'BR', 'PE'),
(13588, 31, 501, 'Tupanatinga', 'BR', 'PE'),
(13589, 31, 501, 'Tuparetama', 'BR', 'PE'),
(13590, 31, 501, 'Venturosa', 'BR', 'PE'),
(13591, 31, 501, 'Verdejante', 'BR', 'PE'),
(13592, 31, 501, 'Vertente do Lério', 'BR', 'PE'),
(13593, 31, 501, 'Vertentes', 'BR', 'PE'),
(13594, 31, 501, 'Vicência', 'BR', 'PE'),
(13595, 31, 501, 'Vitória de Santo Antão', 'BR', 'PE'),
(13596, 31, 501, 'Xexéu', 'BR', 'PE'),
(13597, 31, 502, 'Acauã', 'BR', 'PI'),
(13598, 31, 502, 'Agricolândia', 'BR', 'PI'),
(13599, 31, 502, 'Água Branca', 'BR', 'PI'),
(13600, 31, 502, 'Alagoinha do Piauí', 'BR', 'PI'),
(13601, 31, 502, 'Alegrete do Piauí', 'BR', 'PI'),
(13602, 31, 502, 'Alto Longá', 'BR', 'PI'),
(13603, 31, 502, 'Altos', 'BR', 'PI'),
(13604, 31, 502, 'Alvorada do Gurguéia', 'BR', 'PI'),
(13605, 31, 502, 'Amarante', 'BR', 'PI'),
(13606, 31, 502, 'Angical do Piauí', 'BR', 'PI'),
(13607, 31, 502, 'Anísio de Abreu', 'BR', 'PI'),
(13608, 31, 502, 'Antônio Almeida', 'BR', 'PI'),
(13609, 31, 502, 'Aroazes', 'BR', 'PI'),
(13610, 31, 502, 'Aroeiras do Itaim', 'BR', 'PI'),
(13611, 31, 502, 'Arraial', 'BR', 'PI'),
(13612, 31, 502, 'Assunção do Piauí', 'BR', 'PI'),
(13613, 31, 502, 'Avelino Lopes', 'BR', 'PI'),
(13614, 31, 502, 'Baixa Grande do Ribeiro', 'BR', 'PI'),
(13615, 31, 502, 'Barra d\'Alcântara', 'BR', 'PI'),
(13616, 31, 502, 'Barras', 'BR', 'PI'),
(13617, 31, 502, 'Barreiras do Piauí', 'BR', 'PI'),
(13618, 31, 502, 'Barro Duro', 'BR', 'PI'),
(13619, 31, 502, 'Batalha', 'BR', 'PI'),
(13620, 31, 502, 'Bela Vista do Piauí', 'BR', 'PI'),
(13621, 31, 502, 'Belém do Piauí', 'BR', 'PI'),
(13622, 31, 502, 'Beneditinos', 'BR', 'PI'),
(13623, 31, 502, 'Bertolínia', 'BR', 'PI'),
(13624, 31, 502, 'Betânia do Piauí', 'BR', 'PI'),
(13625, 31, 502, 'Boa Hora', 'BR', 'PI'),
(13626, 31, 502, 'Bocaina', 'BR', 'PI'),
(13627, 31, 502, 'Bom Jesus', 'BR', 'PI'),
(13628, 31, 502, 'Bom Princípio do Piauí', 'BR', 'PI'),
(13629, 31, 502, 'Bonfim do Piauí', 'BR', 'PI'),
(13630, 31, 502, 'Boqueirão do Piauí', 'BR', 'PI'),
(13631, 31, 502, 'Brasileira', 'BR', 'PI'),
(13632, 31, 502, 'Brejo do Piauí', 'BR', 'PI'),
(13633, 31, 502, 'Buriti dos Lopes', 'BR', 'PI'),
(13634, 31, 502, 'Buriti dos Montes', 'BR', 'PI'),
(13635, 31, 502, 'Cabeceiras do Piauí', 'BR', 'PI'),
(13636, 31, 502, 'Cajazeiras do Piauí', 'BR', 'PI'),
(13637, 31, 502, 'Cajueiro da Praia', 'BR', 'PI'),
(13638, 31, 502, 'Caldeirão Grande do Piauí', 'BR', 'PI'),
(13639, 31, 502, 'Campinas do Piauí', 'BR', 'PI'),
(13640, 31, 502, 'Campo Alegre do Fidalgo', 'BR', 'PI'),
(13641, 31, 502, 'Campo Grande do Piauí', 'BR', 'PI'),
(13642, 31, 502, 'Campo Largo do Piauí', 'BR', 'PI'),
(13643, 31, 502, 'Campo Maior', 'BR', 'PI'),
(13644, 31, 502, 'Canavieira', 'BR', 'PI'),
(13645, 31, 502, 'Canto do Buriti', 'BR', 'PI'),
(13646, 31, 502, 'Capitão de Campos', 'BR', 'PI'),
(13647, 31, 502, 'Capitão Gervásio Oliveira', 'BR', 'PI'),
(13648, 31, 502, 'Caracol', 'BR', 'PI'),
(13649, 31, 502, 'Caraúbas do Piauí', 'BR', 'PI'),
(13650, 31, 502, 'Caridade do Piauí', 'BR', 'PI'),
(13651, 31, 502, 'Castelo do Piauí', 'BR', 'PI'),
(13652, 31, 502, 'Caxingó', 'BR', 'PI'),
(13653, 31, 502, 'Cocal', 'BR', 'PI'),
(13654, 31, 502, 'Cocal de Telha', 'BR', 'PI'),
(13655, 31, 502, 'Cocal dos Alves', 'BR', 'PI'),
(13656, 31, 502, 'Coivaras', 'BR', 'PI'),
(13657, 31, 502, 'Colônia do Gurguéia', 'BR', 'PI'),
(13658, 31, 502, 'Colônia do Piauí', 'BR', 'PI'),
(13659, 31, 502, 'Conceição do Canindé', 'BR', 'PI'),
(13660, 31, 502, 'Coronel José Dias', 'BR', 'PI'),
(13661, 31, 502, 'Corrente', 'BR', 'PI'),
(13662, 31, 502, 'Cristalândia do Piauí', 'BR', 'PI'),
(13663, 31, 502, 'Cristino Castro', 'BR', 'PI'),
(13664, 31, 502, 'Curimatá', 'BR', 'PI'),
(13665, 31, 502, 'Currais', 'BR', 'PI'),
(13666, 31, 502, 'Curral Novo do Piauí', 'BR', 'PI'),
(13667, 31, 502, 'Curralinhos', 'BR', 'PI'),
(13668, 31, 502, 'Demerval Lobão', 'BR', 'PI'),
(13669, 31, 502, 'Dirceu Arcoverde', 'BR', 'PI'),
(13670, 31, 502, 'Dom Expedito Lopes', 'BR', 'PI'),
(13671, 31, 502, 'Dom Inocêncio', 'BR', 'PI'),
(13672, 31, 502, 'Domingos Mourão', 'BR', 'PI'),
(13673, 31, 502, 'Elesbão Veloso', 'BR', 'PI'),
(13674, 31, 502, 'Eliseu Martins', 'BR', 'PI'),
(13675, 31, 502, 'Esperantina', 'BR', 'PI'),
(13676, 31, 502, 'Fartura do Piauí', 'BR', 'PI'),
(13677, 31, 502, 'Flores do Piauí', 'BR', 'PI'),
(13678, 31, 502, 'Floresta do Piauí', 'BR', 'PI'),
(13679, 31, 502, 'Floriano', 'BR', 'PI'),
(13680, 31, 502, 'Francinópolis', 'BR', 'PI'),
(13681, 31, 502, 'Francisco Ayres', 'BR', 'PI'),
(13682, 31, 502, 'Francisco Macedo', 'BR', 'PI'),
(13683, 31, 502, 'Francisco Santos', 'BR', 'PI'),
(13684, 31, 502, 'Fronteiras', 'BR', 'PI'),
(13685, 31, 502, 'Geminiano', 'BR', 'PI'),
(13686, 31, 502, 'Gilbués', 'BR', 'PI'),
(13687, 31, 502, 'Guadalupe', 'BR', 'PI'),
(13688, 31, 502, 'Guaribas', 'BR', 'PI'),
(13689, 31, 502, 'Hugo Napoleão', 'BR', 'PI'),
(13690, 31, 502, 'Ilha Grande', 'BR', 'PI'),
(13691, 31, 502, 'Inhuma', 'BR', 'PI'),
(13692, 31, 502, 'Ipiranga do Piauí', 'BR', 'PI'),
(13693, 31, 502, 'Ipueiras', 'BR', 'PI'),
(13694, 31, 502, 'Isaías Coelho', 'BR', 'PI'),
(13695, 31, 502, 'Itainópolis', 'BR', 'PI'),
(13696, 31, 502, 'Itaueira', 'BR', 'PI'),
(13697, 31, 502, 'Jacobina do Piauí', 'BR', 'PI'),
(13698, 31, 502, 'Jaicós', 'BR', 'PI'),
(13699, 31, 502, 'Jardim do Mulato', 'BR', 'PI'),
(13700, 31, 502, 'Jatobá do Piauí', 'BR', 'PI'),
(13701, 31, 502, 'Jerumenha', 'BR', 'PI'),
(13702, 31, 502, 'João Costa', 'BR', 'PI'),
(13703, 31, 502, 'Joaquim Pires', 'BR', 'PI'),
(13704, 31, 502, 'Joca Marques', 'BR', 'PI'),
(13705, 31, 502, 'José de Freitas', 'BR', 'PI'),
(13706, 31, 502, 'Juazeiro do Piauí', 'BR', 'PI'),
(13707, 31, 502, 'Júlio Borges', 'BR', 'PI'),
(13708, 31, 502, 'Jurema', 'BR', 'PI'),
(13709, 31, 502, 'Lagoa Alegre', 'BR', 'PI'),
(13710, 31, 502, 'Lagoa de São Francisco', 'BR', 'PI'),
(13711, 31, 502, 'Lagoa do Barro do Piauí', 'BR', 'PI'),
(13712, 31, 502, 'Lagoa do Piauí', 'BR', 'PI'),
(13713, 31, 502, 'Lagoa do Sítio', 'BR', 'PI'),
(13714, 31, 502, 'Lagoinha do Piauí', 'BR', 'PI'),
(13715, 31, 502, 'Landri Sales', 'BR', 'PI'),
(13716, 31, 502, 'Luís Correia', 'BR', 'PI'),
(13717, 31, 502, 'Luzilândia', 'BR', 'PI'),
(13718, 31, 502, 'Madeiro', 'BR', 'PI'),
(13719, 31, 502, 'Manoel Emídio', 'BR', 'PI'),
(13720, 31, 502, 'Marcolândia', 'BR', 'PI'),
(13721, 31, 502, 'Marcos Parente', 'BR', 'PI'),
(13722, 31, 502, 'Massapê do Piauí', 'BR', 'PI'),
(13723, 31, 502, 'Matias Olímpio', 'BR', 'PI'),
(13724, 31, 502, 'Miguel Alves', 'BR', 'PI'),
(13725, 31, 502, 'Miguel Leão', 'BR', 'PI'),
(13726, 31, 502, 'Milton Brandão', 'BR', 'PI'),
(13727, 31, 502, 'Monsenhor Gil', 'BR', 'PI'),
(13728, 31, 502, 'Monsenhor Hipólito', 'BR', 'PI'),
(13729, 31, 502, 'Monte Alegre do Piauí', 'BR', 'PI'),
(13730, 31, 502, 'Morro Cabeça no Tempo', 'BR', 'PI'),
(13731, 31, 502, 'Morro do Chapéu do Piauí', 'BR', 'PI'),
(13732, 31, 502, 'Murici dos Portelas', 'BR', 'PI'),
(13733, 31, 502, 'Nazaré do Piauí', 'BR', 'PI'),
(13734, 31, 502, 'Nazária', 'BR', 'PI'),
(13735, 31, 502, 'Nossa Senhora de Nazaré', 'BR', 'PI'),
(13736, 31, 502, 'Nossa Senhora dos Remédios', 'BR', 'PI'),
(13737, 31, 502, 'Nova Santa Rita', 'BR', 'PI'),
(13738, 31, 502, 'Novo Oriente do Piauí', 'BR', 'PI'),
(13739, 31, 502, 'Novo Santo Antônio', 'BR', 'PI'),
(13740, 31, 502, 'Oeiras', 'BR', 'PI'),
(13741, 31, 502, 'Olho d\'Água do Piauí', 'BR', 'PI'),
(13742, 31, 502, 'Padre Marcos', 'BR', 'PI'),
(13743, 31, 502, 'Paes Landim', 'BR', 'PI'),
(13744, 31, 502, 'Pajeú do Piauí', 'BR', 'PI'),
(13745, 31, 502, 'Palmeira do Piauí', 'BR', 'PI'),
(13746, 31, 502, 'Palmeirais', 'BR', 'PI'),
(13747, 31, 502, 'Paquetá', 'BR', 'PI'),
(13748, 31, 502, 'Parnaguá', 'BR', 'PI'),
(13749, 31, 502, 'Parnaíba', 'BR', 'PI'),
(13750, 31, 502, 'Passagem Franca do Piauí', 'BR', 'PI'),
(13751, 31, 502, 'Patos do Piauí', 'BR', 'PI'),
(13752, 31, 502, 'Pau D\'arco do Piauí', 'BR', 'PI'),
(13753, 31, 502, 'Paulistana', 'BR', 'PI'),
(13754, 31, 502, 'Pavussu', 'BR', 'PI'),
(13755, 31, 502, 'Pedro II', 'BR', 'PI'),
(13756, 31, 502, 'Pedro Laurentino', 'BR', 'PI'),
(13757, 31, 502, 'Picos', 'BR', 'PI'),
(13758, 31, 502, 'Pimenteiras', 'BR', 'PI'),
(13759, 31, 502, 'Pio IX', 'BR', 'PI'),
(13760, 31, 502, 'Piracuruca', 'BR', 'PI'),
(13761, 31, 502, 'Piripiri', 'BR', 'PI'),
(13762, 31, 502, 'Porto', 'BR', 'PI'),
(13763, 31, 502, 'Porto Alegre do Piauí', 'BR', 'PI'),
(13764, 31, 502, 'Prata do Piauí', 'BR', 'PI'),
(13765, 31, 502, 'Queimada Nova', 'BR', 'PI'),
(13766, 31, 502, 'Redenção do Gurguéia', 'BR', 'PI'),
(13767, 31, 502, 'Regeneração', 'BR', 'PI'),
(13768, 31, 502, 'Riacho Frio', 'BR', 'PI'),
(13769, 31, 502, 'Ribeira do Piauí', 'BR', 'PI'),
(13770, 31, 502, 'Ribeiro Gonçalves', 'BR', 'PI'),
(13771, 31, 502, 'Rio Grande do Piauí', 'BR', 'PI'),
(13772, 31, 502, 'Santa Cruz do Piauí', 'BR', 'PI'),
(13773, 31, 502, 'Santa Cruz dos Milagres', 'BR', 'PI'),
(13774, 31, 502, 'Santa Filomena', 'BR', 'PI'),
(13775, 31, 502, 'Santa Luz', 'BR', 'PI'),
(13776, 31, 502, 'Santa Rosa do Piauí', 'BR', 'PI'),
(13777, 31, 502, 'Santana do Piauí', 'BR', 'PI'),
(13778, 31, 502, 'Santo Antônio de Lisboa', 'BR', 'PI'),
(13779, 31, 502, 'Santo Antônio dos Milagres', 'BR', 'PI'),
(13780, 31, 502, 'Santo Inácio do Piauí', 'BR', 'PI'),
(13781, 31, 502, 'São Braz do Piauí', 'BR', 'PI'),
(13782, 31, 502, 'São Félix do Piauí', 'BR', 'PI'),
(13783, 31, 502, 'São Francisco de Assis do Piauí', 'BR', 'PI'),
(13784, 31, 502, 'São Francisco do Piauí', 'BR', 'PI'),
(13785, 31, 502, 'São Gonçalo do Gurguéia', 'BR', 'PI'),
(13786, 31, 502, 'São Gonçalo do Piauí', 'BR', 'PI'),
(13787, 31, 502, 'São João da Canabrava', 'BR', 'PI'),
(13788, 31, 502, 'São João da Fronteira', 'BR', 'PI'),
(13789, 31, 502, 'São João da Serra', 'BR', 'PI'),
(13790, 31, 502, 'São João da Varjota', 'BR', 'PI'),
(13791, 31, 502, 'São João do Arraial', 'BR', 'PI'),
(13792, 31, 502, 'São João do Piauí', 'BR', 'PI'),
(13793, 31, 502, 'São José do Divino', 'BR', 'PI'),
(13794, 31, 502, 'São José do Peixe', 'BR', 'PI'),
(13795, 31, 502, 'São José do Piauí', 'BR', 'PI'),
(13796, 31, 502, 'São Julião', 'BR', 'PI'),
(13797, 31, 502, 'São Lourenço do Piauí', 'BR', 'PI'),
(13798, 31, 502, 'São Luis do Piauí', 'BR', 'PI'),
(13799, 31, 502, 'São Miguel da Baixa Grande', 'BR', 'PI'),
(13800, 31, 502, 'São Miguel do Fidalgo', 'BR', 'PI'),
(13801, 31, 502, 'São Miguel do Tapuio', 'BR', 'PI'),
(13802, 31, 502, 'São Pedro do Piauí', 'BR', 'PI'),
(13803, 31, 502, 'São Raimundo Nonato', 'BR', 'PI'),
(13804, 31, 502, 'Sebastião Barros', 'BR', 'PI'),
(13805, 31, 502, 'Sebastião Leal', 'BR', 'PI'),
(13806, 31, 502, 'Sigefredo Pacheco', 'BR', 'PI'),
(13807, 31, 502, 'Simões', 'BR', 'PI'),
(13808, 31, 502, 'Simplício Mendes', 'BR', 'PI'),
(13809, 31, 502, 'Socorro do Piauí', 'BR', 'PI'),
(13810, 31, 502, 'Sussuapara', 'BR', 'PI'),
(13811, 31, 502, 'Tamboril do Piauí', 'BR', 'PI'),
(13812, 31, 502, 'Tanque do Piauí', 'BR', 'PI'),
(13813, 31, 502, 'Teresina', 'BR', 'PI'),
(13814, 31, 502, 'União', 'BR', 'PI'),
(13815, 31, 502, 'Uruçuí', 'BR', 'PI'),
(13816, 31, 502, 'Valença do Piauí', 'BR', 'PI'),
(13817, 31, 502, 'Várzea Branca', 'BR', 'PI'),
(13818, 31, 502, 'Várzea Grande', 'BR', 'PI'),
(13819, 31, 502, 'Vera Mendes', 'BR', 'PI'),
(13820, 31, 502, 'Vila Nova do Piauí', 'BR', 'PI'),
(13821, 31, 502, 'Wall Ferraz', 'BR', 'PI'),
(13822, 31, 503, 'Angra dos Reis', 'BR', 'RJ'),
(13823, 31, 503, 'Aperibé', 'BR', 'RJ'),
(13824, 31, 503, 'Araruama', 'BR', 'RJ'),
(13825, 31, 503, 'Areal', 'BR', 'RJ'),
(13826, 31, 503, 'Armação dos Búzios', 'BR', 'RJ'),
(13827, 31, 503, 'Arraial do Cabo', 'BR', 'RJ'),
(13828, 31, 503, 'Barra do Piraí', 'BR', 'RJ'),
(13829, 31, 503, 'Barra Mansa', 'BR', 'RJ'),
(13830, 31, 503, 'Belford Roxo', 'BR', 'RJ'),
(13831, 31, 503, 'Bom Jardim', 'BR', 'RJ'),
(13832, 31, 503, 'Bom Jesus do Itabapoana', 'BR', 'RJ'),
(13833, 31, 503, 'Cabo Frio', 'BR', 'RJ'),
(13834, 31, 503, 'Cachoeiras de Macacu', 'BR', 'RJ'),
(13835, 31, 503, 'Cambuci', 'BR', 'RJ'),
(13836, 31, 503, 'Campos dos Goytacazes', 'BR', 'RJ'),
(13837, 31, 503, 'Cantagalo', 'BR', 'RJ'),
(13838, 31, 503, 'Carapebus', 'BR', 'RJ'),
(13839, 31, 503, 'Cardoso Moreira', 'BR', 'RJ'),
(13840, 31, 503, 'Carmo', 'BR', 'RJ'),
(13841, 31, 503, 'Casimiro de Abreu', 'BR', 'RJ'),
(13842, 31, 503, 'Comendador Levy Gasparian', 'BR', 'RJ'),
(13843, 31, 503, 'Conceição de Macabu', 'BR', 'RJ'),
(13844, 31, 503, 'Cordeiro', 'BR', 'RJ'),
(13845, 31, 503, 'Duas Barras', 'BR', 'RJ'),
(13846, 31, 503, 'Duque de Caxias', 'BR', 'RJ'),
(13847, 31, 503, 'Engenheiro Paulo de Frontin', 'BR', 'RJ'),
(13848, 31, 503, 'Guapimirim', 'BR', 'RJ'),
(13849, 31, 503, 'Iguaba Grande', 'BR', 'RJ'),
(13850, 31, 503, 'Ilha Grande', 'BR', 'RJ'),
(13851, 31, 503, 'Itaboraí', 'BR', 'RJ'),
(13852, 31, 503, 'Itaguaí', 'BR', 'RJ'),
(13853, 31, 503, 'Italva', 'BR', 'RJ'),
(13854, 31, 503, 'Itaocara', 'BR', 'RJ'),
(13855, 31, 503, 'Itaperuna', 'BR', 'RJ'),
(13856, 31, 503, 'Itatiaia', 'BR', 'RJ'),
(13857, 31, 503, 'Japeri', 'BR', 'RJ'),
(13858, 31, 503, 'Laje do Muriaé', 'BR', 'RJ'),
(13859, 31, 503, 'Macaé', 'BR', 'RJ'),
(13860, 31, 503, 'Macuco', 'BR', 'RJ'),
(13861, 31, 503, 'Magé', 'BR', 'RJ'),
(13862, 31, 503, 'Mangaratiba', 'BR', 'RJ'),
(13863, 31, 503, 'Maricá', 'BR', 'RJ'),
(13864, 31, 503, 'Mendes', 'BR', 'RJ'),
(13865, 31, 503, 'Mesquita', 'BR', 'RJ'),
(13866, 31, 503, 'Miguel Pereira', 'BR', 'RJ'),
(13867, 31, 503, 'Miracema', 'BR', 'RJ'),
(13868, 31, 503, 'Natividade', 'BR', 'RJ'),
(13869, 31, 503, 'Nilópolis', 'BR', 'RJ'),
(13870, 31, 503, 'Niterói', 'BR', 'RJ'),
(13871, 31, 503, 'Nova Friburgo', 'BR', 'RJ'),
(13872, 31, 503, 'Nova Iguaçu', 'BR', 'RJ'),
(13873, 31, 503, 'Paracambi', 'BR', 'RJ'),
(13874, 31, 503, 'Paraíba do Sul', 'BR', 'RJ'),
(13875, 31, 503, 'Paraty', 'BR', 'RJ'),
(13876, 31, 503, 'Paty do Alferes', 'BR', 'RJ'),
(13877, 31, 503, 'Petrópolis', 'BR', 'RJ'),
(13878, 31, 503, 'Pinheiral', 'BR', 'RJ'),
(13879, 31, 503, 'Piraí', 'BR', 'RJ'),
(13880, 31, 503, 'Porciúncula', 'BR', 'RJ'),
(13881, 31, 503, 'Porto Real', 'BR', 'RJ'),
(13882, 31, 503, 'Quatis', 'BR', 'RJ'),
(13883, 31, 503, 'Queimados', 'BR', 'RJ'),
(13884, 31, 503, 'Quissamã', 'BR', 'RJ'),
(13885, 31, 503, 'Resende', 'BR', 'RJ'),
(13886, 31, 503, 'Rio Bonito', 'BR', 'RJ'),
(13887, 31, 503, 'Rio Claro', 'BR', 'RJ'),
(13888, 31, 503, 'Rio das Flores', 'BR', 'RJ'),
(13889, 31, 503, 'Rio das Ostras', 'BR', 'RJ'),
(13890, 31, 503, 'Rio de Janeiro', 'BR', 'RJ'),
(13891, 31, 503, 'Santa Maria Madalena', 'BR', 'RJ'),
(13892, 31, 503, 'Santo Antônio de Pádua', 'BR', 'RJ'),
(13893, 31, 503, 'São Fidélis', 'BR', 'RJ'),
(13894, 31, 503, 'São Francisco de Itabapoana', 'BR', 'RJ'),
(13895, 31, 503, 'São Gonçalo', 'BR', 'RJ'),
(13896, 31, 503, 'São João da Barra', 'BR', 'RJ'),
(13897, 31, 503, 'São João de Meriti', 'BR', 'RJ'),
(13898, 31, 503, 'São José de Ubá', 'BR', 'RJ'),
(13899, 31, 503, 'São José do Vale do Rio Preto', 'BR', 'RJ'),
(13900, 31, 503, 'São Pedro', 'BR', 'RJ'),
(13901, 31, 503, 'São Pedro da Aldeia', 'BR', 'RJ'),
(13902, 31, 503, 'São Sebastião do Alto', 'BR', 'RJ'),
(13903, 31, 503, 'Sapucaia', 'BR', 'RJ'),
(13904, 31, 503, 'Saquarema', 'BR', 'RJ'),
(13905, 31, 503, 'Seropédica', 'BR', 'RJ'),
(13906, 31, 503, 'Silva Jardim', 'BR', 'RJ'),
(13907, 31, 503, 'Sumidouro', 'BR', 'RJ'),
(13908, 31, 503, 'Tanguá', 'BR', 'RJ'),
(13909, 31, 503, 'Teresópolis', 'BR', 'RJ'),
(13910, 31, 503, 'Trajano de Moraes', 'BR', 'RJ'),
(13911, 31, 503, 'Três Rios', 'BR', 'RJ'),
(13912, 31, 503, 'Valença', 'BR', 'RJ'),
(13913, 31, 503, 'Varre-Sai', 'BR', 'RJ'),
(13914, 31, 503, 'Vassouras', 'BR', 'RJ'),
(13915, 31, 503, 'Volta Redonda', 'BR', 'RJ'),
(13916, 31, 504, 'Acari', 'BR', 'RN'),
(13917, 31, 504, 'Açu', 'BR', 'RN'),
(13918, 31, 504, 'Afonso Bezerra', 'BR', 'RN'),
(13919, 31, 504, 'Água Nova', 'BR', 'RN'),
(13920, 31, 504, 'Alexandria', 'BR', 'RN'),
(13921, 31, 504, 'Almino Afonso', 'BR', 'RN'),
(13922, 31, 504, 'Alto do Rodrigues', 'BR', 'RN'),
(13923, 31, 504, 'Angicos', 'BR', 'RN'),
(13924, 31, 504, 'Antônio Martins', 'BR', 'RN'),
(13925, 31, 504, 'Apodi', 'BR', 'RN'),
(13926, 31, 504, 'Areia Branca', 'BR', 'RN'),
(13927, 31, 504, 'Arês', 'BR', 'RN'),
(13928, 31, 504, 'Augusto Severo', 'BR', 'RN'),
(13929, 31, 504, 'Baía Formosa', 'BR', 'RN'),
(13930, 31, 504, 'Baraúna', 'BR', 'RN'),
(13931, 31, 504, 'Barcelona', 'BR', 'RN'),
(13932, 31, 504, 'Bento Fernandes', 'BR', 'RN'),
(13933, 31, 504, 'Bodó', 'BR', 'RN'),
(13934, 31, 504, 'Bom Jesus', 'BR', 'RN'),
(13935, 31, 504, 'Brejinho', 'BR', 'RN'),
(13936, 31, 504, 'Caiçara do Norte', 'BR', 'RN'),
(13937, 31, 504, 'Caiçara do Rio do Vento', 'BR', 'RN'),
(13938, 31, 504, 'Caicó', 'BR', 'RN'),
(13939, 31, 504, 'Campo Redondo', 'BR', 'RN'),
(13940, 31, 504, 'Canguaretama', 'BR', 'RN'),
(13941, 31, 504, 'Caraúbas', 'BR', 'RN'),
(13942, 31, 504, 'Carnaúba dos Dantas', 'BR', 'RN'),
(13943, 31, 504, 'Carnaubais', 'BR', 'RN'),
(13944, 31, 504, 'Ceará Mirim', 'BR', 'RN'),
(13945, 31, 504, 'Ceará-Mirim', 'BR', 'RN'),
(13946, 31, 504, 'Cerro Corá', 'BR', 'RN'),
(13947, 31, 504, 'Coronel Ezequiel', 'BR', 'RN'),
(13948, 31, 504, 'Coronel João Pessoa', 'BR', 'RN'),
(13949, 31, 504, 'Cruzeta', 'BR', 'RN'),
(13950, 31, 504, 'Currais Novos', 'BR', 'RN'),
(13951, 31, 504, 'Doutor Severiano', 'BR', 'RN'),
(13952, 31, 504, 'Encanto', 'BR', 'RN'),
(13953, 31, 504, 'Equador', 'BR', 'RN'),
(13954, 31, 504, 'Espírito Santo', 'BR', 'RN'),
(13955, 31, 504, 'Extremoz', 'BR', 'RN'),
(13956, 31, 504, 'Felipe Guerra', 'BR', 'RN'),
(13957, 31, 504, 'Fernando Pedroza', 'BR', 'RN'),
(13958, 31, 504, 'Florânia', 'BR', 'RN'),
(13959, 31, 504, 'Francisco Dantas', 'BR', 'RN'),
(13960, 31, 504, 'Frutuoso Gomes', 'BR', 'RN'),
(13961, 31, 504, 'Galinhos', 'BR', 'RN'),
(13962, 31, 504, 'Goianinha', 'BR', 'RN'),
(13963, 31, 504, 'Governador Dix Sept Rosado', 'BR', 'RN'),
(13964, 31, 504, 'Governador Dix-Sept Rosado', 'BR', 'RN'),
(13965, 31, 504, 'Grossos', 'BR', 'RN'),
(13966, 31, 504, 'Guamaré', 'BR', 'RN'),
(13967, 31, 504, 'Ielmo Marinho', 'BR', 'RN'),
(13968, 31, 504, 'Ipanguaçu', 'BR', 'RN'),
(13969, 31, 504, 'Ipueira', 'BR', 'RN'),
(13970, 31, 504, 'Itajá', 'BR', 'RN'),
(13971, 31, 504, 'Itaú', 'BR', 'RN'),
(13972, 31, 504, 'Jaçanã', 'BR', 'RN'),
(13973, 31, 504, 'Jandaíra', 'BR', 'RN'),
(13974, 31, 504, 'Janduís', 'BR', 'RN'),
(13975, 31, 504, 'Januário Cicco', 'BR', 'RN'),
(13976, 31, 504, 'Japi', 'BR', 'RN'),
(13977, 31, 504, 'Jardim de Angicos', 'BR', 'RN'),
(13978, 31, 504, 'Jardim de Piranhas', 'BR', 'RN'),
(13979, 31, 504, 'Jardim do Seridó', 'BR', 'RN'),
(13980, 31, 504, 'João Câmara', 'BR', 'RN'),
(13981, 31, 504, 'João Dias', 'BR', 'RN'),
(13982, 31, 504, 'José da Penha', 'BR', 'RN'),
(13983, 31, 504, 'Jucurutu', 'BR', 'RN'),
(13984, 31, 504, 'Jundiá', 'BR', 'RN'),
(13985, 31, 504, 'Lagoa d\'Anta', 'BR', 'RN'),
(13986, 31, 504, 'Lagoa de Pedras', 'BR', 'RN'),
(13987, 31, 504, 'Lagoa de Velhos', 'BR', 'RN'),
(13988, 31, 504, 'Lagoa Nova', 'BR', 'RN'),
(13989, 31, 504, 'Lagoa Salgada', 'BR', 'RN'),
(13990, 31, 504, 'Lajes', 'BR', 'RN'),
(13991, 31, 504, 'Lajes Pintadas', 'BR', 'RN'),
(13992, 31, 504, 'Lucrécia', 'BR', 'RN'),
(13993, 31, 504, 'Luís Gomes', 'BR', 'RN'),
(13994, 31, 504, 'Macaíba', 'BR', 'RN'),
(13995, 31, 504, 'Macau', 'BR', 'RN'),
(13996, 31, 504, 'Major Sales', 'BR', 'RN'),
(13997, 31, 504, 'Marcelino Vieira', 'BR', 'RN'),
(13998, 31, 504, 'Martins', 'BR', 'RN'),
(13999, 31, 504, 'Maxaranguape', 'BR', 'RN'),
(14000, 31, 504, 'Messias Targino', 'BR', 'RN');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(14001, 31, 504, 'Montanhas', 'BR', 'RN'),
(14002, 31, 504, 'Monte Alegre', 'BR', 'RN'),
(14003, 31, 504, 'Monte das Gameleiras', 'BR', 'RN'),
(14004, 31, 504, 'Mossoró', 'BR', 'RN'),
(14005, 31, 504, 'Natal', 'BR', 'RN'),
(14006, 31, 504, 'Nísia Floresta', 'BR', 'RN'),
(14007, 31, 504, 'Nova Cruz', 'BR', 'RN'),
(14008, 31, 504, 'Olho-d\'Água do Borges', 'BR', 'RN'),
(14009, 31, 504, 'Ouro Branco', 'BR', 'RN'),
(14010, 31, 504, 'Paraná', 'BR', 'RN'),
(14011, 31, 504, 'Paraú', 'BR', 'RN'),
(14012, 31, 504, 'Parazinho', 'BR', 'RN'),
(14013, 31, 504, 'Parelhas', 'BR', 'RN'),
(14014, 31, 504, 'Parnamirim', 'BR', 'RN'),
(14015, 31, 504, 'Passa e Fica', 'BR', 'RN'),
(14016, 31, 504, 'Passagem', 'BR', 'RN'),
(14017, 31, 504, 'Patu', 'BR', 'RN'),
(14018, 31, 504, 'Pau dos Ferros', 'BR', 'RN'),
(14019, 31, 504, 'Pedra Grande', 'BR', 'RN'),
(14020, 31, 504, 'Pedra Preta', 'BR', 'RN'),
(14021, 31, 504, 'Pedro Avelino', 'BR', 'RN'),
(14022, 31, 504, 'Pedro Velho', 'BR', 'RN'),
(14023, 31, 504, 'Pendências', 'BR', 'RN'),
(14024, 31, 504, 'Pilões', 'BR', 'RN'),
(14025, 31, 504, 'Poço Branco', 'BR', 'RN'),
(14026, 31, 504, 'Portalegre', 'BR', 'RN'),
(14027, 31, 504, 'Porto do Mangue', 'BR', 'RN'),
(14028, 31, 504, 'Pureza', 'BR', 'RN'),
(14029, 31, 504, 'Rafael Fernandes', 'BR', 'RN'),
(14030, 31, 504, 'Rafael Godeiro', 'BR', 'RN'),
(14031, 31, 504, 'Riacho da Cruz', 'BR', 'RN'),
(14032, 31, 504, 'Riacho de Santana', 'BR', 'RN'),
(14033, 31, 504, 'Riachuelo', 'BR', 'RN'),
(14034, 31, 504, 'Rio do Fogo', 'BR', 'RN'),
(14035, 31, 504, 'Rodolfo Fernandes', 'BR', 'RN'),
(14036, 31, 504, 'Ruy Barbosa', 'BR', 'RN'),
(14037, 31, 504, 'Santa Cruz', 'BR', 'RN'),
(14038, 31, 504, 'Santa Maria', 'BR', 'RN'),
(14039, 31, 504, 'Santana do Matos', 'BR', 'RN'),
(14040, 31, 504, 'Santana do Seridó', 'BR', 'RN'),
(14041, 31, 504, 'Santo Antônio', 'BR', 'RN'),
(14042, 31, 504, 'São Bento do Norte', 'BR', 'RN'),
(14043, 31, 504, 'São Bento do Trairí', 'BR', 'RN'),
(14044, 31, 504, 'São Fernando', 'BR', 'RN'),
(14045, 31, 504, 'São Francisco do Oeste', 'BR', 'RN'),
(14046, 31, 504, 'São Gonçalo do Amarante', 'BR', 'RN'),
(14047, 31, 504, 'São João do Sabugi', 'BR', 'RN'),
(14048, 31, 504, 'São José de Mipibu', 'BR', 'RN'),
(14049, 31, 504, 'São José do Campestre', 'BR', 'RN'),
(14050, 31, 504, 'São José do Seridó', 'BR', 'RN'),
(14051, 31, 504, 'São Miguel', 'BR', 'RN'),
(14052, 31, 504, 'São Miguel do Gostoso', 'BR', 'RN'),
(14053, 31, 504, 'São Paulo do Potengi', 'BR', 'RN'),
(14054, 31, 504, 'São Pedro', 'BR', 'RN'),
(14055, 31, 504, 'São Rafael', 'BR', 'RN'),
(14056, 31, 504, 'São Tomé', 'BR', 'RN'),
(14057, 31, 504, 'São Vicente', 'BR', 'RN'),
(14058, 31, 504, 'Senador Elói de Souza', 'BR', 'RN'),
(14059, 31, 504, 'Senador Georgino Avelino', 'BR', 'RN'),
(14060, 31, 504, 'Serra Caiada', 'BR', 'RN'),
(14061, 31, 504, 'Serra de São Bento', 'BR', 'RN'),
(14062, 31, 504, 'Serra do Mel', 'BR', 'RN'),
(14063, 31, 504, 'Serra Negra do Norte', 'BR', 'RN'),
(14064, 31, 504, 'Serrinha', 'BR', 'RN'),
(14065, 31, 504, 'Serrinha dos Pintos', 'BR', 'RN'),
(14066, 31, 504, 'Severiano Melo', 'BR', 'RN'),
(14067, 31, 504, 'Sítio Novo', 'BR', 'RN'),
(14068, 31, 504, 'Taboleiro Grande', 'BR', 'RN'),
(14069, 31, 504, 'Taipu', 'BR', 'RN'),
(14070, 31, 504, 'Tangará', 'BR', 'RN'),
(14071, 31, 504, 'Tenente Ananias', 'BR', 'RN'),
(14072, 31, 504, 'Tenente Laurentino Cruz', 'BR', 'RN'),
(14073, 31, 504, 'Tibau', 'BR', 'RN'),
(14074, 31, 504, 'Tibau do Sul', 'BR', 'RN'),
(14075, 31, 504, 'Timbaúba dos Batistas', 'BR', 'RN'),
(14076, 31, 504, 'Touros', 'BR', 'RN'),
(14077, 31, 504, 'Triunfo Potiguar', 'BR', 'RN'),
(14078, 31, 504, 'Umarizal', 'BR', 'RN'),
(14079, 31, 504, 'Upanema', 'BR', 'RN'),
(14080, 31, 504, 'Várzea', 'BR', 'RN'),
(14081, 31, 504, 'Venha-Ver', 'BR', 'RN'),
(14082, 31, 504, 'Vera Cruz', 'BR', 'RN'),
(14083, 31, 504, 'Viçosa', 'BR', 'RN'),
(14084, 31, 504, 'Vila Flor', 'BR', 'RN'),
(14085, 31, 505, 'Aceguá', 'BR', 'RS'),
(14086, 31, 505, 'Água Santa', 'BR', 'RS'),
(14087, 31, 505, 'Agudo', 'BR', 'RS'),
(14088, 31, 505, 'Ajuricaba', 'BR', 'RS'),
(14089, 31, 505, 'Alecrim', 'BR', 'RS'),
(14090, 31, 505, 'Alegrete', 'BR', 'RS'),
(14091, 31, 505, 'Alegria', 'BR', 'RS'),
(14092, 31, 505, 'Almirante Tamandaré do Sul', 'BR', 'RS'),
(14093, 31, 505, 'Alpestre', 'BR', 'RS'),
(14094, 31, 505, 'Alto Alegre', 'BR', 'RS'),
(14095, 31, 505, 'Alto Feliz', 'BR', 'RS'),
(14096, 31, 505, 'Alvorada', 'BR', 'RS'),
(14097, 31, 505, 'Amaral Ferrador', 'BR', 'RS'),
(14098, 31, 505, 'Ametista do Sul', 'BR', 'RS'),
(14099, 31, 505, 'André da Rocha', 'BR', 'RS'),
(14100, 31, 505, 'Anta Gorda', 'BR', 'RS'),
(14101, 31, 505, 'Antônio Prado', 'BR', 'RS'),
(14102, 31, 505, 'Arambaré', 'BR', 'RS'),
(14103, 31, 505, 'Araricá', 'BR', 'RS'),
(14104, 31, 505, 'Aratiba', 'BR', 'RS'),
(14105, 31, 505, 'Arroio do Meio', 'BR', 'RS'),
(14106, 31, 505, 'Arroio do Padre', 'BR', 'RS'),
(14107, 31, 505, 'Arroio do Sal', 'BR', 'RS'),
(14108, 31, 505, 'Arroio do Tigre', 'BR', 'RS'),
(14109, 31, 505, 'Arroio dos Ratos', 'BR', 'RS'),
(14110, 31, 505, 'Arroio Grande', 'BR', 'RS'),
(14111, 31, 505, 'Arvorezinha', 'BR', 'RS'),
(14112, 31, 505, 'Augusto Pestana', 'BR', 'RS'),
(14113, 31, 505, 'Áurea', 'BR', 'RS'),
(14114, 31, 505, 'Bagé', 'BR', 'RS'),
(14115, 31, 505, 'Balneário Pinhal', 'BR', 'RS'),
(14116, 31, 505, 'Barão', 'BR', 'RS'),
(14117, 31, 505, 'Barão de Cotegipe', 'BR', 'RS'),
(14118, 31, 505, 'Barão do Triunfo', 'BR', 'RS'),
(14119, 31, 505, 'Barra do Guarita', 'BR', 'RS'),
(14120, 31, 505, 'Barra do Quaraí', 'BR', 'RS'),
(14121, 31, 505, 'Barra do Ribeiro', 'BR', 'RS'),
(14122, 31, 505, 'Barra do Rio Azul', 'BR', 'RS'),
(14123, 31, 505, 'Barra Funda', 'BR', 'RS'),
(14124, 31, 505, 'Barracão', 'BR', 'RS'),
(14125, 31, 505, 'Barros Cassal', 'BR', 'RS'),
(14126, 31, 505, 'Benjamin Constant do Sul', 'BR', 'RS'),
(14127, 31, 505, 'Bento Gonçalves', 'BR', 'RS'),
(14128, 31, 505, 'Boa Vista das Missões', 'BR', 'RS'),
(14129, 31, 505, 'Boa Vista do Buricá', 'BR', 'RS'),
(14130, 31, 505, 'Boa Vista do Cadeado', 'BR', 'RS'),
(14131, 31, 505, 'Boa Vista do Incra', 'BR', 'RS'),
(14132, 31, 505, 'Boa Vista do Sul', 'BR', 'RS'),
(14133, 31, 505, 'Bom Jesus', 'BR', 'RS'),
(14134, 31, 505, 'Bom Princípio', 'BR', 'RS'),
(14135, 31, 505, 'Bom Progresso', 'BR', 'RS'),
(14136, 31, 505, 'Bom Retiro do Sul', 'BR', 'RS'),
(14137, 31, 505, 'Boqueirão do Leão', 'BR', 'RS'),
(14138, 31, 505, 'Bossoroca', 'BR', 'RS'),
(14139, 31, 505, 'Bozano', 'BR', 'RS'),
(14140, 31, 505, 'Braga', 'BR', 'RS'),
(14141, 31, 505, 'Brochier', 'BR', 'RS'),
(14142, 31, 505, 'Butiá', 'BR', 'RS'),
(14143, 31, 505, 'Caçapava do Sul', 'BR', 'RS'),
(14144, 31, 505, 'Cacequi', 'BR', 'RS'),
(14145, 31, 505, 'Cachoeira do Sul', 'BR', 'RS'),
(14146, 31, 505, 'Cachoeirinha', 'BR', 'RS'),
(14147, 31, 505, 'Cacique Doble', 'BR', 'RS'),
(14148, 31, 505, 'Caibaté', 'BR', 'RS'),
(14149, 31, 505, 'Caiçara', 'BR', 'RS'),
(14150, 31, 505, 'Camaquã', 'BR', 'RS'),
(14151, 31, 505, 'Camargo', 'BR', 'RS'),
(14152, 31, 505, 'Cambará do Sul', 'BR', 'RS'),
(14153, 31, 505, 'Campestre da Serra', 'BR', 'RS'),
(14154, 31, 505, 'Campina das Missões', 'BR', 'RS'),
(14155, 31, 505, 'Campinas do Sul', 'BR', 'RS'),
(14156, 31, 505, 'Campo Bom', 'BR', 'RS'),
(14157, 31, 505, 'Campo Novo', 'BR', 'RS'),
(14158, 31, 505, 'Campos Borges', 'BR', 'RS'),
(14159, 31, 505, 'Candelária', 'BR', 'RS'),
(14160, 31, 505, 'Cândido Godói', 'BR', 'RS'),
(14161, 31, 505, 'Candiota', 'BR', 'RS'),
(14162, 31, 505, 'Canela', 'BR', 'RS'),
(14163, 31, 505, 'Canguçu', 'BR', 'RS'),
(14164, 31, 505, 'Canoas', 'BR', 'RS'),
(14165, 31, 505, 'Canudos do Vale', 'BR', 'RS'),
(14166, 31, 505, 'Capão Bonito do Sul', 'BR', 'RS'),
(14167, 31, 505, 'Capão da Canoa', 'BR', 'RS'),
(14168, 31, 505, 'Capão do Cipó', 'BR', 'RS'),
(14169, 31, 505, 'Capão do Leão', 'BR', 'RS'),
(14170, 31, 505, 'Capela de Santana', 'BR', 'RS'),
(14171, 31, 505, 'Capitão', 'BR', 'RS'),
(14172, 31, 505, 'Capivari do Sul', 'BR', 'RS'),
(14173, 31, 505, 'Caraá', 'BR', 'RS'),
(14174, 31, 505, 'Carazinho', 'BR', 'RS'),
(14175, 31, 505, 'Carlos Barbosa', 'BR', 'RS'),
(14176, 31, 505, 'Carlos Gomes', 'BR', 'RS'),
(14177, 31, 505, 'Casca', 'BR', 'RS'),
(14178, 31, 505, 'Caseiros', 'BR', 'RS'),
(14179, 31, 505, 'Catuípe', 'BR', 'RS'),
(14180, 31, 505, 'Caxias do Sul', 'BR', 'RS'),
(14181, 31, 505, 'Centenário', 'BR', 'RS'),
(14182, 31, 505, 'Cerrito', 'BR', 'RS'),
(14183, 31, 505, 'Cerro Branco', 'BR', 'RS'),
(14184, 31, 505, 'Cerro Grande', 'BR', 'RS'),
(14185, 31, 505, 'Cerro Grande do Sul', 'BR', 'RS'),
(14186, 31, 505, 'Cerro Largo', 'BR', 'RS'),
(14187, 31, 505, 'Chapada', 'BR', 'RS'),
(14188, 31, 505, 'Charqueadas', 'BR', 'RS'),
(14189, 31, 505, 'Charrua', 'BR', 'RS'),
(14190, 31, 505, 'Chiapetta', 'BR', 'RS'),
(14191, 31, 505, 'Chuí', 'BR', 'RS'),
(14192, 31, 505, 'Chuvisca', 'BR', 'RS'),
(14193, 31, 505, 'Cidreira', 'BR', 'RS'),
(14194, 31, 505, 'Ciríaco', 'BR', 'RS'),
(14195, 31, 505, 'Colinas', 'BR', 'RS'),
(14196, 31, 505, 'Colorado', 'BR', 'RS'),
(14197, 31, 505, 'Condor', 'BR', 'RS'),
(14198, 31, 505, 'Constantina', 'BR', 'RS'),
(14199, 31, 505, 'Coqueiro Baixo', 'BR', 'RS'),
(14200, 31, 505, 'Coqueiros do Sul', 'BR', 'RS'),
(14201, 31, 505, 'Coronel Barros', 'BR', 'RS'),
(14202, 31, 505, 'Coronel Bicaco', 'BR', 'RS'),
(14203, 31, 505, 'Coronel Pilar', 'BR', 'RS'),
(14204, 31, 505, 'Cotiporã', 'BR', 'RS'),
(14205, 31, 505, 'Coxilha', 'BR', 'RS'),
(14206, 31, 505, 'Crissiumal', 'BR', 'RS'),
(14207, 31, 505, 'Cristal', 'BR', 'RS'),
(14208, 31, 505, 'Cristal do Sul', 'BR', 'RS'),
(14209, 31, 505, 'Cruz Alta', 'BR', 'RS'),
(14210, 31, 505, 'Cruzaltense', 'BR', 'RS'),
(14211, 31, 505, 'Cruzeiro do Sul', 'BR', 'RS'),
(14212, 31, 505, 'David Canabarro', 'BR', 'RS'),
(14213, 31, 505, 'Derrubadas', 'BR', 'RS'),
(14214, 31, 505, 'Dezesseis de Novembro', 'BR', 'RS'),
(14215, 31, 505, 'Dilermando de Aguiar', 'BR', 'RS'),
(14216, 31, 505, 'Dois Irmãos', 'BR', 'RS'),
(14217, 31, 505, 'Dois Irmãos das Missões', 'BR', 'RS'),
(14218, 31, 505, 'Dois Lajeados', 'BR', 'RS'),
(14219, 31, 505, 'Dom Feliciano', 'BR', 'RS'),
(14220, 31, 505, 'Dom Pedrito', 'BR', 'RS'),
(14221, 31, 505, 'Dom Pedro de Alcântara', 'BR', 'RS'),
(14222, 31, 505, 'Dona Francisca', 'BR', 'RS'),
(14223, 31, 505, 'Doutor Maurício Cardoso', 'BR', 'RS'),
(14224, 31, 505, 'Doutor Ricardo', 'BR', 'RS'),
(14225, 31, 505, 'Eldorado do Sul', 'BR', 'RS'),
(14226, 31, 505, 'Encantado', 'BR', 'RS'),
(14227, 31, 505, 'Encruzilhada do Sul', 'BR', 'RS'),
(14228, 31, 505, 'Engenho Velho', 'BR', 'RS'),
(14229, 31, 505, 'Entre Rios do Sul', 'BR', 'RS'),
(14230, 31, 505, 'Entre-Ijuís', 'BR', 'RS'),
(14231, 31, 505, 'Erebango', 'BR', 'RS'),
(14232, 31, 505, 'Erechim', 'BR', 'RS'),
(14233, 31, 505, 'Ernestina', 'BR', 'RS'),
(14234, 31, 505, 'Erval Grande', 'BR', 'RS'),
(14235, 31, 505, 'Erval Seco', 'BR', 'RS'),
(14236, 31, 505, 'Esmeralda', 'BR', 'RS'),
(14237, 31, 505, 'Esperança do Sul', 'BR', 'RS'),
(14238, 31, 505, 'Espumoso', 'BR', 'RS'),
(14239, 31, 505, 'Estação', 'BR', 'RS'),
(14240, 31, 505, 'Estância Velha', 'BR', 'RS'),
(14241, 31, 505, 'Esteio', 'BR', 'RS'),
(14242, 31, 505, 'Estrela', 'BR', 'RS'),
(14243, 31, 505, 'Estrela Velha', 'BR', 'RS'),
(14244, 31, 505, 'Eugênio de Castro', 'BR', 'RS'),
(14245, 31, 505, 'Fagundes Varela', 'BR', 'RS'),
(14246, 31, 505, 'Farroupilha', 'BR', 'RS'),
(14247, 31, 505, 'Faxinal do Soturno', 'BR', 'RS'),
(14248, 31, 505, 'Faxinalzinho', 'BR', 'RS'),
(14249, 31, 505, 'Fazenda Vilanova', 'BR', 'RS'),
(14250, 31, 505, 'Feliz', 'BR', 'RS'),
(14251, 31, 505, 'Flores da Cunha', 'BR', 'RS'),
(14252, 31, 505, 'Floriano Peixoto', 'BR', 'RS'),
(14253, 31, 505, 'Fontoura Xavier', 'BR', 'RS'),
(14254, 31, 505, 'Formigueiro', 'BR', 'RS'),
(14255, 31, 505, 'Forquetinha', 'BR', 'RS'),
(14256, 31, 505, 'Fortaleza dos Valos', 'BR', 'RS'),
(14257, 31, 505, 'Frederico Westphalen', 'BR', 'RS'),
(14258, 31, 505, 'Garibaldi', 'BR', 'RS'),
(14259, 31, 505, 'Garruchos', 'BR', 'RS'),
(14260, 31, 505, 'Gaurama', 'BR', 'RS'),
(14261, 31, 505, 'General Câmara', 'BR', 'RS'),
(14262, 31, 505, 'Gentil', 'BR', 'RS'),
(14263, 31, 505, 'Getúlio Vargas', 'BR', 'RS'),
(14264, 31, 505, 'Giruá', 'BR', 'RS'),
(14265, 31, 505, 'Glorinha', 'BR', 'RS'),
(14266, 31, 505, 'Gramado', 'BR', 'RS'),
(14267, 31, 505, 'Gramado dos Loureiros', 'BR', 'RS'),
(14268, 31, 505, 'Gramado Xavier', 'BR', 'RS'),
(14269, 31, 505, 'Gravataí', 'BR', 'RS'),
(14270, 31, 505, 'Guabiju', 'BR', 'RS'),
(14271, 31, 505, 'Guaíba', 'BR', 'RS'),
(14272, 31, 505, 'Guaporé', 'BR', 'RS'),
(14273, 31, 505, 'Guarani das Missões', 'BR', 'RS'),
(14274, 31, 505, 'Harmonia', 'BR', 'RS'),
(14275, 31, 505, 'Herval', 'BR', 'RS'),
(14276, 31, 505, 'Herveiras', 'BR', 'RS'),
(14277, 31, 505, 'Horizontina', 'BR', 'RS'),
(14278, 31, 505, 'Hulha Negra', 'BR', 'RS'),
(14279, 31, 505, 'Humaitá', 'BR', 'RS'),
(14280, 31, 505, 'Ibarama', 'BR', 'RS'),
(14281, 31, 505, 'Ibiaçá', 'BR', 'RS'),
(14282, 31, 505, 'Ibiraiaras', 'BR', 'RS'),
(14283, 31, 505, 'Ibirapuitã', 'BR', 'RS'),
(14284, 31, 505, 'Ibirubá', 'BR', 'RS'),
(14285, 31, 505, 'Igrejinha', 'BR', 'RS'),
(14286, 31, 505, 'Ijuí', 'BR', 'RS'),
(14287, 31, 505, 'Ilópolis', 'BR', 'RS'),
(14288, 31, 505, 'Imbé', 'BR', 'RS'),
(14289, 31, 505, 'Imigrante', 'BR', 'RS'),
(14290, 31, 505, 'Independência', 'BR', 'RS'),
(14291, 31, 505, 'Inhacorá', 'BR', 'RS'),
(14292, 31, 505, 'Ipê', 'BR', 'RS'),
(14293, 31, 505, 'Ipiranga do Sul', 'BR', 'RS'),
(14294, 31, 505, 'Iraí', 'BR', 'RS'),
(14295, 31, 505, 'Itaara', 'BR', 'RS'),
(14296, 31, 505, 'Itacurubi', 'BR', 'RS'),
(14297, 31, 505, 'Itapuca', 'BR', 'RS'),
(14298, 31, 505, 'Itaqui', 'BR', 'RS'),
(14299, 31, 505, 'Itati', 'BR', 'RS'),
(14300, 31, 505, 'Itatiba do Sul', 'BR', 'RS'),
(14301, 31, 505, 'Ivorá', 'BR', 'RS'),
(14302, 31, 505, 'Ivoti', 'BR', 'RS'),
(14303, 31, 505, 'Jaboticaba', 'BR', 'RS'),
(14304, 31, 505, 'Jacuizinho', 'BR', 'RS'),
(14305, 31, 505, 'Jacutinga', 'BR', 'RS'),
(14306, 31, 505, 'Jaguarão', 'BR', 'RS'),
(14307, 31, 505, 'Jaguari', 'BR', 'RS'),
(14308, 31, 505, 'Jaquirana', 'BR', 'RS'),
(14309, 31, 505, 'Jari', 'BR', 'RS'),
(14310, 31, 505, 'Jóia', 'BR', 'RS'),
(14311, 31, 505, 'Júlio de Castilhos', 'BR', 'RS'),
(14312, 31, 505, 'Lagoa Bonita do Sul', 'BR', 'RS'),
(14313, 31, 505, 'Lagoa dos Três Cantos', 'BR', 'RS'),
(14314, 31, 505, 'Lagoa Vermelha', 'BR', 'RS'),
(14315, 31, 505, 'Lagoão', 'BR', 'RS'),
(14316, 31, 505, 'Lajeado', 'BR', 'RS'),
(14317, 31, 505, 'Lajeado do Bugre', 'BR', 'RS'),
(14318, 31, 505, 'Lavras do Sul', 'BR', 'RS'),
(14319, 31, 505, 'Liberato Salzano', 'BR', 'RS'),
(14320, 31, 505, 'Lindolfo Collor', 'BR', 'RS'),
(14321, 31, 505, 'Linha Nova', 'BR', 'RS'),
(14322, 31, 505, 'Maçambará', 'BR', 'RS'),
(14323, 31, 505, 'Machadinho', 'BR', 'RS'),
(14324, 31, 505, 'Mampituba', 'BR', 'RS'),
(14325, 31, 505, 'Manoel Viana', 'BR', 'RS'),
(14326, 31, 505, 'Maquiné', 'BR', 'RS'),
(14327, 31, 505, 'Maratá', 'BR', 'RS'),
(14328, 31, 505, 'Marau', 'BR', 'RS'),
(14329, 31, 505, 'Marcelino Ramos', 'BR', 'RS'),
(14330, 31, 505, 'Mariana Pimentel', 'BR', 'RS'),
(14331, 31, 505, 'Mariano Moro', 'BR', 'RS'),
(14332, 31, 505, 'Marques de Souza', 'BR', 'RS'),
(14333, 31, 505, 'Mata', 'BR', 'RS'),
(14334, 31, 505, 'Mato Castelhano', 'BR', 'RS'),
(14335, 31, 505, 'Mato Leitão', 'BR', 'RS'),
(14336, 31, 505, 'Mato Queimado', 'BR', 'RS'),
(14337, 31, 505, 'Maximiliano de Almeida', 'BR', 'RS'),
(14338, 31, 505, 'Minas do Leão', 'BR', 'RS'),
(14339, 31, 505, 'Miraguaí', 'BR', 'RS'),
(14340, 31, 505, 'Montauri', 'BR', 'RS'),
(14341, 31, 505, 'Monte Alegre dos Campos', 'BR', 'RS'),
(14342, 31, 505, 'Monte Belo do Sul', 'BR', 'RS'),
(14343, 31, 505, 'Montenegro', 'BR', 'RS'),
(14344, 31, 505, 'Mormaço', 'BR', 'RS'),
(14345, 31, 505, 'Morrinhos do Sul', 'BR', 'RS'),
(14346, 31, 505, 'Morro Redondo', 'BR', 'RS'),
(14347, 31, 505, 'Morro Reuter', 'BR', 'RS'),
(14348, 31, 505, 'Mostardas', 'BR', 'RS'),
(14349, 31, 505, 'Muçum', 'BR', 'RS'),
(14350, 31, 505, 'Muitos Capões', 'BR', 'RS'),
(14351, 31, 505, 'Muliterno', 'BR', 'RS'),
(14352, 31, 505, 'Não Me Toque', 'BR', 'RS'),
(14353, 31, 505, 'Não-Me-Toque', 'BR', 'RS'),
(14354, 31, 505, 'Nicolau Vergueiro', 'BR', 'RS'),
(14355, 31, 505, 'Nonoai', 'BR', 'RS'),
(14356, 31, 505, 'Nova Alvorada', 'BR', 'RS'),
(14357, 31, 505, 'Nova Araçá', 'BR', 'RS'),
(14358, 31, 505, 'Nova Bassano', 'BR', 'RS'),
(14359, 31, 505, 'Nova Boa Vista', 'BR', 'RS'),
(14360, 31, 505, 'Nova Bréscia', 'BR', 'RS'),
(14361, 31, 505, 'Nova Candelária', 'BR', 'RS'),
(14362, 31, 505, 'Nova Esperança do Sul', 'BR', 'RS'),
(14363, 31, 505, 'Nova Hartz', 'BR', 'RS'),
(14364, 31, 505, 'Nova Pádua', 'BR', 'RS'),
(14365, 31, 505, 'Nova Palma', 'BR', 'RS'),
(14366, 31, 505, 'Nova Petrópolis', 'BR', 'RS'),
(14367, 31, 505, 'Nova Prata', 'BR', 'RS'),
(14368, 31, 505, 'Nova Ramada', 'BR', 'RS'),
(14369, 31, 505, 'Nova Roma do Sul', 'BR', 'RS'),
(14370, 31, 505, 'Nova Santa Rita', 'BR', 'RS'),
(14371, 31, 505, 'Novo Barreiro', 'BR', 'RS'),
(14372, 31, 505, 'Novo Cabrais', 'BR', 'RS'),
(14373, 31, 505, 'Novo Hamburgo', 'BR', 'RS'),
(14374, 31, 505, 'Novo Machado', 'BR', 'RS'),
(14375, 31, 505, 'Novo Tiradentes', 'BR', 'RS'),
(14376, 31, 505, 'Novo Xingu', 'BR', 'RS'),
(14377, 31, 505, 'Osório', 'BR', 'RS'),
(14378, 31, 505, 'Paim Filho', 'BR', 'RS'),
(14379, 31, 505, 'Palmares do Sul', 'BR', 'RS'),
(14380, 31, 505, 'Palmeira das Missões', 'BR', 'RS'),
(14381, 31, 505, 'Palmitinho', 'BR', 'RS'),
(14382, 31, 505, 'Panambi', 'BR', 'RS'),
(14383, 31, 505, 'Pantano Grande', 'BR', 'RS'),
(14384, 31, 505, 'Paraí', 'BR', 'RS'),
(14385, 31, 505, 'Paraíso do Sul', 'BR', 'RS'),
(14386, 31, 505, 'Pareci Novo', 'BR', 'RS'),
(14387, 31, 505, 'Parobé', 'BR', 'RS'),
(14388, 31, 505, 'Passa Sete', 'BR', 'RS'),
(14389, 31, 505, 'Passo do Sobrado', 'BR', 'RS'),
(14390, 31, 505, 'Passo Fundo', 'BR', 'RS'),
(14391, 31, 505, 'Paulo Bento', 'BR', 'RS'),
(14392, 31, 505, 'Paverama', 'BR', 'RS'),
(14393, 31, 505, 'Pedras Altas', 'BR', 'RS'),
(14394, 31, 505, 'Pedro Osório', 'BR', 'RS'),
(14395, 31, 505, 'Pejuçara', 'BR', 'RS'),
(14396, 31, 505, 'Pelotas', 'BR', 'RS'),
(14397, 31, 505, 'Picada Café', 'BR', 'RS'),
(14398, 31, 505, 'Pinhal', 'BR', 'RS'),
(14399, 31, 505, 'Pinhal da Serra', 'BR', 'RS'),
(14400, 31, 505, 'Pinhal Grande', 'BR', 'RS'),
(14401, 31, 505, 'Pinheirinho do Vale', 'BR', 'RS'),
(14402, 31, 505, 'Pinheiro Machado', 'BR', 'RS'),
(14403, 31, 505, 'Pinheiros', 'BR', 'RS'),
(14404, 31, 505, 'Pinto Bandeira', 'BR', 'RS'),
(14405, 31, 505, 'Pirapó', 'BR', 'RS'),
(14406, 31, 505, 'Piratini', 'BR', 'RS'),
(14407, 31, 505, 'Planalto', 'BR', 'RS'),
(14408, 31, 505, 'Poço das Antas', 'BR', 'RS'),
(14409, 31, 505, 'Pontão', 'BR', 'RS'),
(14410, 31, 505, 'Ponte Preta', 'BR', 'RS'),
(14411, 31, 505, 'Portão', 'BR', 'RS'),
(14412, 31, 505, 'Porto Alegre', 'BR', 'RS'),
(14413, 31, 505, 'Porto Lucena', 'BR', 'RS'),
(14414, 31, 505, 'Porto Mauá', 'BR', 'RS'),
(14415, 31, 505, 'Porto Vera Cruz', 'BR', 'RS'),
(14416, 31, 505, 'Porto Xavier', 'BR', 'RS'),
(14417, 31, 505, 'Pouso Novo', 'BR', 'RS'),
(14418, 31, 505, 'Presidente Lucena', 'BR', 'RS'),
(14419, 31, 505, 'Progresso', 'BR', 'RS'),
(14420, 31, 505, 'Protásio Alves', 'BR', 'RS'),
(14421, 31, 505, 'Putinga', 'BR', 'RS'),
(14422, 31, 505, 'Quaraí', 'BR', 'RS'),
(14423, 31, 505, 'Quatro Irmãos', 'BR', 'RS'),
(14424, 31, 505, 'Quevedos', 'BR', 'RS'),
(14425, 31, 505, 'Quinze de Novembro', 'BR', 'RS'),
(14426, 31, 505, 'Redentora', 'BR', 'RS'),
(14427, 31, 505, 'Relvado', 'BR', 'RS'),
(14428, 31, 505, 'Restinga Sêca', 'BR', 'RS'),
(14429, 31, 505, 'Rio dos Índios', 'BR', 'RS'),
(14430, 31, 505, 'Rio Grande', 'BR', 'RS'),
(14431, 31, 505, 'Rio Pardo', 'BR', 'RS'),
(14432, 31, 505, 'Riozinho', 'BR', 'RS'),
(14433, 31, 505, 'Roca Sales', 'BR', 'RS'),
(14434, 31, 505, 'Rodeio Bonito', 'BR', 'RS'),
(14435, 31, 505, 'Rolador', 'BR', 'RS'),
(14436, 31, 505, 'Rolante', 'BR', 'RS'),
(14437, 31, 505, 'Ronda Alta', 'BR', 'RS'),
(14438, 31, 505, 'Rondinha', 'BR', 'RS'),
(14439, 31, 505, 'Roque Gonzales', 'BR', 'RS'),
(14440, 31, 505, 'Rosário do Sul', 'BR', 'RS'),
(14441, 31, 505, 'Sagrada Família', 'BR', 'RS'),
(14442, 31, 505, 'Saldanha Marinho', 'BR', 'RS'),
(14443, 31, 505, 'Salto do Jacuí', 'BR', 'RS'),
(14444, 31, 505, 'Salvador das Missões', 'BR', 'RS'),
(14445, 31, 505, 'Salvador do Sul', 'BR', 'RS'),
(14446, 31, 505, 'Sananduva', 'BR', 'RS'),
(14447, 31, 505, 'Sant\'Ana do Livramento', 'BR', 'RS'),
(14448, 31, 505, 'Santa Bárbara do Sul', 'BR', 'RS'),
(14449, 31, 505, 'Santa Cecília do Sul', 'BR', 'RS'),
(14450, 31, 505, 'Santa Clara do Sul', 'BR', 'RS'),
(14451, 31, 505, 'Santa Cruz do Sul', 'BR', 'RS'),
(14452, 31, 505, 'Santa Margarida do Sul', 'BR', 'RS'),
(14453, 31, 505, 'Santa Maria', 'BR', 'RS'),
(14454, 31, 505, 'Santa Maria do Herval', 'BR', 'RS'),
(14455, 31, 505, 'Santa Rosa', 'BR', 'RS'),
(14456, 31, 505, 'Santa Tereza', 'BR', 'RS'),
(14457, 31, 505, 'Santa Vitória do Palmar', 'BR', 'RS'),
(14458, 31, 505, 'Santana da Boa Vista', 'BR', 'RS'),
(14459, 31, 505, 'Santana do Livramento', 'BR', 'RS'),
(14460, 31, 505, 'Santiago', 'BR', 'RS'),
(14461, 31, 505, 'Santo Ângelo', 'BR', 'RS'),
(14462, 31, 505, 'Santo Antônio da Patrulha', 'BR', 'RS'),
(14463, 31, 505, 'Santo Antônio das Missões', 'BR', 'RS'),
(14464, 31, 505, 'Santo Antônio do Palma', 'BR', 'RS'),
(14465, 31, 505, 'Santo Antônio do Planalto', 'BR', 'RS'),
(14466, 31, 505, 'Santo Augusto', 'BR', 'RS'),
(14467, 31, 505, 'Santo Cristo', 'BR', 'RS'),
(14468, 31, 505, 'Santo Expedito do Sul', 'BR', 'RS'),
(14469, 31, 505, 'São Borja', 'BR', 'RS'),
(14470, 31, 505, 'São Domingos do Sul', 'BR', 'RS'),
(14471, 31, 505, 'São Francisco de Assis', 'BR', 'RS'),
(14472, 31, 505, 'São Francisco de Paula', 'BR', 'RS'),
(14473, 31, 505, 'São Gabriel', 'BR', 'RS'),
(14474, 31, 505, 'São Jerônimo', 'BR', 'RS'),
(14475, 31, 505, 'São João da Urtiga', 'BR', 'RS'),
(14476, 31, 505, 'São João do Polêsine', 'BR', 'RS'),
(14477, 31, 505, 'São Jorge', 'BR', 'RS'),
(14478, 31, 505, 'São José das Missões', 'BR', 'RS'),
(14479, 31, 505, 'São José do Herval', 'BR', 'RS'),
(14480, 31, 505, 'São José do Hortêncio', 'BR', 'RS'),
(14481, 31, 505, 'São José do Inhacorá', 'BR', 'RS'),
(14482, 31, 505, 'São José do Norte', 'BR', 'RS'),
(14483, 31, 505, 'São José do Ouro', 'BR', 'RS'),
(14484, 31, 505, 'São José do Sul', 'BR', 'RS'),
(14485, 31, 505, 'São José dos Ausentes', 'BR', 'RS'),
(14486, 31, 505, 'São Leopoldo', 'BR', 'RS'),
(14487, 31, 505, 'São Lourenço do Sul', 'BR', 'RS'),
(14488, 31, 505, 'São Luiz Gonzaga', 'BR', 'RS'),
(14489, 31, 505, 'São Marcos', 'BR', 'RS'),
(14490, 31, 505, 'São Martinho', 'BR', 'RS'),
(14491, 31, 505, 'São Martinho da Serra', 'BR', 'RS'),
(14492, 31, 505, 'São Miguel das Missões', 'BR', 'RS'),
(14493, 31, 505, 'São Nicolau', 'BR', 'RS'),
(14494, 31, 505, 'São Paulo das Missões', 'BR', 'RS'),
(14495, 31, 505, 'São Pedro da Serra', 'BR', 'RS'),
(14496, 31, 505, 'São Pedro das Missões', 'BR', 'RS'),
(14497, 31, 505, 'São Pedro do Butiá', 'BR', 'RS'),
(14498, 31, 505, 'São Pedro do Sul', 'BR', 'RS'),
(14499, 31, 505, 'São Sebastião do Caí', 'BR', 'RS'),
(14500, 31, 505, 'São Sepé', 'BR', 'RS');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(14501, 31, 505, 'São Valentim', 'BR', 'RS'),
(14502, 31, 505, 'São Valentim do Sul', 'BR', 'RS'),
(14503, 31, 505, 'São Valério do Sul', 'BR', 'RS'),
(14504, 31, 505, 'São Vendelino', 'BR', 'RS'),
(14505, 31, 505, 'São Vicente do Sul', 'BR', 'RS'),
(14506, 31, 505, 'Sapiranga', 'BR', 'RS'),
(14507, 31, 505, 'Sapucaia', 'BR', 'RS'),
(14508, 31, 505, 'Sapucaia do Sul', 'BR', 'RS'),
(14509, 31, 505, 'Sarandi', 'BR', 'RS'),
(14510, 31, 505, 'Seberi', 'BR', 'RS'),
(14511, 31, 505, 'Sede Nova', 'BR', 'RS'),
(14512, 31, 505, 'Segredo', 'BR', 'RS'),
(14513, 31, 505, 'Selbach', 'BR', 'RS'),
(14514, 31, 505, 'Senador Salgado Filho', 'BR', 'RS'),
(14515, 31, 505, 'Sentinela do Sul', 'BR', 'RS'),
(14516, 31, 505, 'Serafina Corrêa', 'BR', 'RS'),
(14517, 31, 505, 'Sério', 'BR', 'RS'),
(14518, 31, 505, 'Sertão', 'BR', 'RS'),
(14519, 31, 505, 'Sertão Santana', 'BR', 'RS'),
(14520, 31, 505, 'Sete de Setembro', 'BR', 'RS'),
(14521, 31, 505, 'Severiano de Almeida', 'BR', 'RS'),
(14522, 31, 505, 'Silveira Martins', 'BR', 'RS'),
(14523, 31, 505, 'Sinimbu', 'BR', 'RS'),
(14524, 31, 505, 'Sobradinho', 'BR', 'RS'),
(14525, 31, 505, 'Soledade', 'BR', 'RS'),
(14526, 31, 505, 'Tabaí', 'BR', 'RS'),
(14527, 31, 505, 'Tapejara', 'BR', 'RS'),
(14528, 31, 505, 'Tapera', 'BR', 'RS'),
(14529, 31, 505, 'Tapes', 'BR', 'RS'),
(14530, 31, 505, 'Taquara', 'BR', 'RS'),
(14531, 31, 505, 'Taquari', 'BR', 'RS'),
(14532, 31, 505, 'Taquaruçu do Sul', 'BR', 'RS'),
(14533, 31, 505, 'Tavares', 'BR', 'RS'),
(14534, 31, 505, 'Tenente Portela', 'BR', 'RS'),
(14535, 31, 505, 'Terra de Areia', 'BR', 'RS'),
(14536, 31, 505, 'Teutônia', 'BR', 'RS'),
(14537, 31, 505, 'Tio Hugo', 'BR', 'RS'),
(14538, 31, 505, 'Tiradentes do Sul', 'BR', 'RS'),
(14539, 31, 505, 'Toropi', 'BR', 'RS'),
(14540, 31, 505, 'Torres', 'BR', 'RS'),
(14541, 31, 505, 'Tramandaí', 'BR', 'RS'),
(14542, 31, 505, 'Travesseiro', 'BR', 'RS'),
(14543, 31, 505, 'Três Arroios', 'BR', 'RS'),
(14544, 31, 505, 'Três Cachoeiras', 'BR', 'RS'),
(14545, 31, 505, 'Três Coroas', 'BR', 'RS'),
(14546, 31, 505, 'Três de Maio', 'BR', 'RS'),
(14547, 31, 505, 'Três Forquilhas', 'BR', 'RS'),
(14548, 31, 505, 'Três Palmeiras', 'BR', 'RS'),
(14549, 31, 505, 'Três Passos', 'BR', 'RS'),
(14550, 31, 505, 'Trindade do Sul', 'BR', 'RS'),
(14551, 31, 505, 'Triunfo', 'BR', 'RS'),
(14552, 31, 505, 'Tucunduva', 'BR', 'RS'),
(14553, 31, 505, 'Tunas', 'BR', 'RS'),
(14554, 31, 505, 'Tupanci do Sul', 'BR', 'RS'),
(14555, 31, 505, 'Tupanciretã', 'BR', 'RS'),
(14556, 31, 505, 'Tupandi', 'BR', 'RS'),
(14557, 31, 505, 'Tuparendi', 'BR', 'RS'),
(14558, 31, 505, 'Turuçu', 'BR', 'RS'),
(14559, 31, 505, 'Ubiretama', 'BR', 'RS'),
(14560, 31, 505, 'União da Serra', 'BR', 'RS'),
(14561, 31, 505, 'Unistalda', 'BR', 'RS'),
(14562, 31, 505, 'Uruguaiana', 'BR', 'RS'),
(14563, 31, 505, 'Vacaria', 'BR', 'RS'),
(14564, 31, 505, 'Vale do Sol', 'BR', 'RS'),
(14565, 31, 505, 'Vale Real', 'BR', 'RS'),
(14566, 31, 505, 'Vale Verde', 'BR', 'RS'),
(14567, 31, 505, 'Vanini', 'BR', 'RS'),
(14568, 31, 505, 'Venâncio Aires', 'BR', 'RS'),
(14569, 31, 505, 'Vera Cruz', 'BR', 'RS'),
(14570, 31, 505, 'Veranópolis', 'BR', 'RS'),
(14571, 31, 505, 'Vespasiano Corrêa', 'BR', 'RS'),
(14572, 31, 505, 'Viadutos', 'BR', 'RS'),
(14573, 31, 505, 'Viamão', 'BR', 'RS'),
(14574, 31, 505, 'Vicente Dutra', 'BR', 'RS'),
(14575, 31, 505, 'Victor Graeff', 'BR', 'RS'),
(14576, 31, 505, 'Vila Flores', 'BR', 'RS'),
(14577, 31, 505, 'Vila Lângaro', 'BR', 'RS'),
(14578, 31, 505, 'Vila Maria', 'BR', 'RS'),
(14579, 31, 505, 'Vila Nova do Sul', 'BR', 'RS'),
(14580, 31, 505, 'Vista Alegre', 'BR', 'RS'),
(14581, 31, 505, 'Vista Alegre do Prata', 'BR', 'RS'),
(14582, 31, 505, 'Vista Gaúcha', 'BR', 'RS'),
(14583, 31, 505, 'Vitória das Missões', 'BR', 'RS'),
(14584, 31, 505, 'Westfália', 'BR', 'RS'),
(14585, 31, 505, 'Xangri-lá', 'BR', 'RS'),
(14586, 31, 506, 'Alta Floresta d\'Oeste', 'BR', 'RO'),
(14587, 31, 506, 'Alto Alegre dos Parecis', 'BR', 'RO'),
(14588, 31, 506, 'Alto Paraíso', 'BR', 'RO'),
(14589, 31, 506, 'Alvorada d\'Oeste', 'BR', 'RO'),
(14590, 31, 506, 'Ariquemes', 'BR', 'RO'),
(14591, 31, 506, 'Buritis', 'BR', 'RO'),
(14592, 31, 506, 'Cabixi', 'BR', 'RO'),
(14593, 31, 506, 'Cacaulândia', 'BR', 'RO'),
(14594, 31, 506, 'Cacoal', 'BR', 'RO'),
(14595, 31, 506, 'Campo Novo de Rondônia', 'BR', 'RO'),
(14596, 31, 506, 'Candeias do Jamari', 'BR', 'RO'),
(14597, 31, 506, 'Castanheiras', 'BR', 'RO'),
(14598, 31, 506, 'Cerejeiras', 'BR', 'RO'),
(14599, 31, 506, 'Chupinguaia', 'BR', 'RO'),
(14600, 31, 506, 'Colorado do Oeste', 'BR', 'RO'),
(14601, 31, 506, 'Corumbiara', 'BR', 'RO'),
(14602, 31, 506, 'Costa Marques', 'BR', 'RO'),
(14603, 31, 506, 'Cujubim', 'BR', 'RO'),
(14604, 31, 506, 'Espigão d\'Oeste', 'BR', 'RO'),
(14605, 31, 506, 'Extrema', 'BR', 'RO'),
(14606, 31, 506, 'Governador Jorge Teixeira', 'BR', 'RO'),
(14607, 31, 506, 'Guajará Mirim', 'BR', 'RO'),
(14608, 31, 506, 'Guajará-Mirim', 'BR', 'RO'),
(14609, 31, 506, 'Itapuã do Oeste', 'BR', 'RO'),
(14610, 31, 506, 'Jaru', 'BR', 'RO'),
(14611, 31, 506, 'Ji Paraná', 'BR', 'RO'),
(14612, 31, 506, 'Ji-Paraná', 'BR', 'RO'),
(14613, 31, 506, 'Machadinho d\'Oeste', 'BR', 'RO'),
(14614, 31, 506, 'Ministro Andreazza', 'BR', 'RO'),
(14615, 31, 506, 'Mirante da Serra', 'BR', 'RO'),
(14616, 31, 506, 'Monte Negro', 'BR', 'RO'),
(14617, 31, 506, 'Nova Brasilândia d\'Oeste', 'BR', 'RO'),
(14618, 31, 506, 'Nova Mamoré', 'BR', 'RO'),
(14619, 31, 506, 'Nova União', 'BR', 'RO'),
(14620, 31, 506, 'Novo Horizonte do Oeste', 'BR', 'RO'),
(14621, 31, 506, 'Ouro Preto do Oeste', 'BR', 'RO'),
(14622, 31, 506, 'Parecis', 'BR', 'RO'),
(14623, 31, 506, 'Pimenta Bueno', 'BR', 'RO'),
(14624, 31, 506, 'Pimenteiras do Oeste', 'BR', 'RO'),
(14625, 31, 506, 'Porto Velho', 'BR', 'RO'),
(14626, 31, 506, 'Pôsto Fiscal Rolim de Moura', 'BR', 'RO'),
(14627, 31, 506, 'Presidente Médici', 'BR', 'RO'),
(14628, 31, 506, 'Primavera de Rondônia', 'BR', 'RO'),
(14629, 31, 506, 'Rio Crespo', 'BR', 'RO'),
(14630, 31, 506, 'Rolim de Moura', 'BR', 'RO'),
(14631, 31, 506, 'Santa Luzia d\'Oeste', 'BR', 'RO'),
(14632, 31, 506, 'São Felipe d\'Oeste', 'BR', 'RO'),
(14633, 31, 506, 'São Francisco do Guaporé', 'BR', 'RO'),
(14634, 31, 506, 'São Miguel do Guaporé', 'BR', 'RO'),
(14635, 31, 506, 'Seringueiras', 'BR', 'RO'),
(14636, 31, 506, 'Teixeirópolis', 'BR', 'RO'),
(14637, 31, 506, 'Theobroma', 'BR', 'RO'),
(14638, 31, 506, 'Urupá', 'BR', 'RO'),
(14639, 31, 506, 'Vale do Anari', 'BR', 'RO'),
(14640, 31, 506, 'Vale do Paraíso', 'BR', 'RO'),
(14641, 31, 506, 'Vilhena', 'BR', 'RO'),
(14642, 31, 507, 'Amajari', 'BR', 'RR'),
(14643, 31, 507, 'Boa Vista', 'BR', 'RR'),
(14644, 31, 507, 'Bonfim', 'BR', 'RR'),
(14645, 31, 507, 'Cantá', 'BR', 'RR'),
(14646, 31, 507, 'Caracaraí', 'BR', 'RR'),
(14647, 31, 507, 'Caroebe', 'BR', 'RR'),
(14648, 31, 507, 'Iracema', 'BR', 'RR'),
(14649, 31, 507, 'Mucajaí', 'BR', 'RR'),
(14650, 31, 507, 'Normandia', 'BR', 'RR'),
(14651, 31, 507, 'Pacaraima', 'BR', 'RR'),
(14652, 31, 507, 'Rorainópolis', 'BR', 'RR'),
(14653, 31, 507, 'São João da Baliza', 'BR', 'RR'),
(14654, 31, 507, 'São Luís', 'BR', 'RR'),
(14655, 31, 507, 'Uiramutã', 'BR', 'RR'),
(14656, 31, 508, 'Abdon Batista', 'BR', 'SC'),
(14657, 31, 508, 'Abelardo Luz', 'BR', 'SC'),
(14658, 31, 508, 'Agrolândia', 'BR', 'SC'),
(14659, 31, 508, 'Agronômica', 'BR', 'SC'),
(14660, 31, 508, 'Água Doce', 'BR', 'SC'),
(14661, 31, 508, 'Águas de Chapecó', 'BR', 'SC'),
(14662, 31, 508, 'Águas Frias', 'BR', 'SC'),
(14663, 31, 508, 'Águas Mornas', 'BR', 'SC'),
(14664, 31, 508, 'Alfredo Wagner', 'BR', 'SC'),
(14665, 31, 508, 'Alto Bela Vista', 'BR', 'SC'),
(14666, 31, 508, 'Anchieta', 'BR', 'SC'),
(14667, 31, 508, 'Angelina', 'BR', 'SC'),
(14668, 31, 508, 'Anita Garibaldi', 'BR', 'SC'),
(14669, 31, 508, 'Anitápolis', 'BR', 'SC'),
(14670, 31, 508, 'Antônio Carlos', 'BR', 'SC'),
(14671, 31, 508, 'Apiúna', 'BR', 'SC'),
(14672, 31, 508, 'Arabutã', 'BR', 'SC'),
(14673, 31, 508, 'Araquari', 'BR', 'SC'),
(14674, 31, 508, 'Araranguá', 'BR', 'SC'),
(14675, 31, 508, 'Armação', 'BR', 'SC'),
(14676, 31, 508, 'Armazém', 'BR', 'SC'),
(14677, 31, 508, 'Arroio Trinta', 'BR', 'SC'),
(14678, 31, 508, 'Arvoredo', 'BR', 'SC'),
(14679, 31, 508, 'Ascurra', 'BR', 'SC'),
(14680, 31, 508, 'Atalanta', 'BR', 'SC'),
(14681, 31, 508, 'Aurora', 'BR', 'SC'),
(14682, 31, 508, 'Balneário Arroio do Silva', 'BR', 'SC'),
(14683, 31, 508, 'Balneário Barra do Sul', 'BR', 'SC'),
(14684, 31, 508, 'Balneário Camboriú', 'BR', 'SC'),
(14685, 31, 508, 'Balneário Gaivota', 'BR', 'SC'),
(14686, 31, 508, 'Balneário Piçarras', 'BR', 'SC'),
(14687, 31, 508, 'Balneário Rincão', 'BR', 'SC'),
(14688, 31, 508, 'Bandeirante', 'BR', 'SC'),
(14689, 31, 508, 'Barra Bonita', 'BR', 'SC'),
(14690, 31, 508, 'Barra Velha', 'BR', 'SC'),
(14691, 31, 508, 'Bela Vista do Toldo', 'BR', 'SC'),
(14692, 31, 508, 'Belmonte', 'BR', 'SC'),
(14693, 31, 508, 'Benedito Novo', 'BR', 'SC'),
(14694, 31, 508, 'Biguaçu', 'BR', 'SC'),
(14695, 31, 508, 'Blumenau', 'BR', 'SC'),
(14696, 31, 508, 'Bocaina do Sul', 'BR', 'SC'),
(14697, 31, 508, 'Bom Jardim da Serra', 'BR', 'SC'),
(14698, 31, 508, 'Bom Jesus', 'BR', 'SC'),
(14699, 31, 508, 'Bom Jesus do Oeste', 'BR', 'SC'),
(14700, 31, 508, 'Bom Retiro', 'BR', 'SC'),
(14701, 31, 508, 'Bombinhas', 'BR', 'SC'),
(14702, 31, 508, 'Botuverá', 'BR', 'SC'),
(14703, 31, 508, 'Braço do Norte', 'BR', 'SC'),
(14704, 31, 508, 'Braço do Trombudo', 'BR', 'SC'),
(14705, 31, 508, 'Brunópolis', 'BR', 'SC'),
(14706, 31, 508, 'Brusque', 'BR', 'SC'),
(14707, 31, 508, 'Caçador', 'BR', 'SC'),
(14708, 31, 508, 'Caibi', 'BR', 'SC'),
(14709, 31, 508, 'Calmon', 'BR', 'SC'),
(14710, 31, 508, 'Camboriú', 'BR', 'SC'),
(14711, 31, 508, 'Campinas', 'BR', 'SC'),
(14712, 31, 508, 'Campo Alegre', 'BR', 'SC'),
(14713, 31, 508, 'Campo Belo do Sul', 'BR', 'SC'),
(14714, 31, 508, 'Campo Erê', 'BR', 'SC'),
(14715, 31, 508, 'Campos Novos', 'BR', 'SC'),
(14716, 31, 508, 'Canelinha', 'BR', 'SC'),
(14717, 31, 508, 'Canoinhas', 'BR', 'SC'),
(14718, 31, 508, 'Capão Alto', 'BR', 'SC'),
(14719, 31, 508, 'Capinzal', 'BR', 'SC'),
(14720, 31, 508, 'Capivari de Baixo', 'BR', 'SC'),
(14721, 31, 508, 'Carianos', 'BR', 'SC'),
(14722, 31, 508, 'Carvoeira', 'BR', 'SC'),
(14723, 31, 508, 'Catanduvas', 'BR', 'SC'),
(14724, 31, 508, 'Caxambu do Sul', 'BR', 'SC'),
(14725, 31, 508, 'Celso Ramos', 'BR', 'SC'),
(14726, 31, 508, 'Cerro Negro', 'BR', 'SC'),
(14727, 31, 508, 'Chapadão do Lageado', 'BR', 'SC'),
(14728, 31, 508, 'Chapecó', 'BR', 'SC'),
(14729, 31, 508, 'Cocal', 'BR', 'SC'),
(14730, 31, 508, 'Cocal do Sul', 'BR', 'SC'),
(14731, 31, 508, 'Concórdia', 'BR', 'SC'),
(14732, 31, 508, 'Cordilheira Alta', 'BR', 'SC'),
(14733, 31, 508, 'Coronel Freitas', 'BR', 'SC'),
(14734, 31, 508, 'Coronel Martins', 'BR', 'SC'),
(14735, 31, 508, 'Corrego Grande', 'BR', 'SC'),
(14736, 31, 508, 'Correia Pinto', 'BR', 'SC'),
(14737, 31, 508, 'Corupá', 'BR', 'SC'),
(14738, 31, 508, 'Costeira do Pirajubae', 'BR', 'SC'),
(14739, 31, 508, 'Criciúma', 'BR', 'SC'),
(14740, 31, 508, 'Cunha Porã', 'BR', 'SC'),
(14741, 31, 508, 'Cunhataí', 'BR', 'SC'),
(14742, 31, 508, 'Curitibanos', 'BR', 'SC'),
(14743, 31, 508, 'Descanso', 'BR', 'SC'),
(14744, 31, 508, 'Dionísio Cerqueira', 'BR', 'SC'),
(14745, 31, 508, 'Dona Emma', 'BR', 'SC'),
(14746, 31, 508, 'Doutor Pedrinho', 'BR', 'SC'),
(14747, 31, 508, 'Entre Rios', 'BR', 'SC'),
(14748, 31, 508, 'Ermo', 'BR', 'SC'),
(14749, 31, 508, 'Erval Velho', 'BR', 'SC'),
(14750, 31, 508, 'Faxinal dos Guedes', 'BR', 'SC'),
(14751, 31, 508, 'Flor do Sertão', 'BR', 'SC'),
(14752, 31, 508, 'Florianópolis', 'BR', 'SC'),
(14753, 31, 508, 'Formosa do Sul', 'BR', 'SC'),
(14754, 31, 508, 'Forquilhinha', 'BR', 'SC'),
(14755, 31, 508, 'Fraiburgo', 'BR', 'SC'),
(14756, 31, 508, 'Freguesia do Ribeirao da Ilha', 'BR', 'SC'),
(14757, 31, 508, 'Frei Rogério', 'BR', 'SC'),
(14758, 31, 508, 'Galvão', 'BR', 'SC'),
(14759, 31, 508, 'Garopaba', 'BR', 'SC'),
(14760, 31, 508, 'Garuva', 'BR', 'SC'),
(14761, 31, 508, 'Gaspar', 'BR', 'SC'),
(14762, 31, 508, 'Governador Celso Ramos', 'BR', 'SC'),
(14763, 31, 508, 'Grão Pará', 'BR', 'SC'),
(14764, 31, 508, 'Gravatal', 'BR', 'SC'),
(14765, 31, 508, 'Guabiruba', 'BR', 'SC'),
(14766, 31, 508, 'Guaraciaba', 'BR', 'SC'),
(14767, 31, 508, 'Guaramirim', 'BR', 'SC'),
(14768, 31, 508, 'Guarujá do Sul', 'BR', 'SC'),
(14769, 31, 508, 'Guatambú', 'BR', 'SC'),
(14770, 31, 508, 'Herval d\'Oeste', 'BR', 'SC'),
(14771, 31, 508, 'Ibiam', 'BR', 'SC'),
(14772, 31, 508, 'Ibicaré', 'BR', 'SC'),
(14773, 31, 508, 'Ibirama', 'BR', 'SC'),
(14774, 31, 508, 'Içara', 'BR', 'SC'),
(14775, 31, 508, 'Ilhota', 'BR', 'SC'),
(14776, 31, 508, 'Imaruí', 'BR', 'SC'),
(14777, 31, 508, 'Imbituba', 'BR', 'SC'),
(14778, 31, 508, 'Imbuia', 'BR', 'SC'),
(14779, 31, 508, 'Indaial', 'BR', 'SC'),
(14780, 31, 508, 'Iomerê', 'BR', 'SC'),
(14781, 31, 508, 'Ipira', 'BR', 'SC'),
(14782, 31, 508, 'Iporã do Oeste', 'BR', 'SC'),
(14783, 31, 508, 'Ipuaçu', 'BR', 'SC'),
(14784, 31, 508, 'Ipumirim', 'BR', 'SC'),
(14785, 31, 508, 'Iraceminha', 'BR', 'SC'),
(14786, 31, 508, 'Irani', 'BR', 'SC'),
(14787, 31, 508, 'Irati', 'BR', 'SC'),
(14788, 31, 508, 'Irineópolis', 'BR', 'SC'),
(14789, 31, 508, 'Itá', 'BR', 'SC'),
(14790, 31, 508, 'Itacorubi', 'BR', 'SC'),
(14791, 31, 508, 'Itaiópolis', 'BR', 'SC'),
(14792, 31, 508, 'Itajaí', 'BR', 'SC'),
(14793, 31, 508, 'Itapema', 'BR', 'SC'),
(14794, 31, 508, 'Itapiranga', 'BR', 'SC'),
(14795, 31, 508, 'Itapoá', 'BR', 'SC'),
(14796, 31, 508, 'Ituporanga', 'BR', 'SC'),
(14797, 31, 508, 'Jaborá', 'BR', 'SC'),
(14798, 31, 508, 'Jacinto Machado', 'BR', 'SC'),
(14799, 31, 508, 'Jaguaruna', 'BR', 'SC'),
(14800, 31, 508, 'Jaraguá do Sul', 'BR', 'SC'),
(14801, 31, 508, 'Jardinópolis', 'BR', 'SC'),
(14802, 31, 508, 'Joaçaba', 'BR', 'SC'),
(14803, 31, 508, 'Joinville', 'BR', 'SC'),
(14804, 31, 508, 'José Boiteux', 'BR', 'SC'),
(14805, 31, 508, 'Jupiá', 'BR', 'SC'),
(14806, 31, 508, 'Lacerdópolis', 'BR', 'SC'),
(14807, 31, 508, 'Lages', 'BR', 'SC'),
(14808, 31, 508, 'Lagoa', 'BR', 'SC'),
(14809, 31, 508, 'Laguna', 'BR', 'SC'),
(14810, 31, 508, 'Lajeado Grande', 'BR', 'SC'),
(14811, 31, 508, 'Laurentino', 'BR', 'SC'),
(14812, 31, 508, 'Lauro Muller', 'BR', 'SC'),
(14813, 31, 508, 'Lebon Régis', 'BR', 'SC'),
(14814, 31, 508, 'Leoberto Leal', 'BR', 'SC'),
(14815, 31, 508, 'Lindóia do Sul', 'BR', 'SC'),
(14816, 31, 508, 'Lontras', 'BR', 'SC'),
(14817, 31, 508, 'Luiz Alves', 'BR', 'SC'),
(14818, 31, 508, 'Luzerna', 'BR', 'SC'),
(14819, 31, 508, 'Macieira', 'BR', 'SC'),
(14820, 31, 508, 'Mafra', 'BR', 'SC'),
(14821, 31, 508, 'Major Gercino', 'BR', 'SC'),
(14822, 31, 508, 'Major Vieira', 'BR', 'SC'),
(14823, 31, 508, 'Maracajá', 'BR', 'SC'),
(14824, 31, 508, 'Maravilha', 'BR', 'SC'),
(14825, 31, 508, 'Marema', 'BR', 'SC'),
(14826, 31, 508, 'Massaranduba', 'BR', 'SC'),
(14827, 31, 508, 'Matos Costa', 'BR', 'SC'),
(14828, 31, 508, 'Meleiro', 'BR', 'SC'),
(14829, 31, 508, 'Mirim Doce', 'BR', 'SC'),
(14830, 31, 508, 'Modelo', 'BR', 'SC'),
(14831, 31, 508, 'Mondaí', 'BR', 'SC'),
(14832, 31, 508, 'Monte Carlo', 'BR', 'SC'),
(14833, 31, 508, 'Monte Castelo', 'BR', 'SC'),
(14834, 31, 508, 'Morro da Cruz', 'BR', 'SC'),
(14835, 31, 508, 'Morro da Fumaça', 'BR', 'SC'),
(14836, 31, 508, 'Morro Grande', 'BR', 'SC'),
(14837, 31, 508, 'Navegantes', 'BR', 'SC'),
(14838, 31, 508, 'Nova Erechim', 'BR', 'SC'),
(14839, 31, 508, 'Nova Itaberaba', 'BR', 'SC'),
(14840, 31, 508, 'Nova Trento', 'BR', 'SC'),
(14841, 31, 508, 'Nova Veneza', 'BR', 'SC'),
(14842, 31, 508, 'Novo Horizonte', 'BR', 'SC'),
(14843, 31, 508, 'Orleans', 'BR', 'SC'),
(14844, 31, 508, 'Otacílio Costa', 'BR', 'SC'),
(14845, 31, 508, 'Ouro', 'BR', 'SC'),
(14846, 31, 508, 'Ouro Verde', 'BR', 'SC'),
(14847, 31, 508, 'Paial', 'BR', 'SC'),
(14848, 31, 508, 'Painel', 'BR', 'SC'),
(14849, 31, 508, 'Palhoça', 'BR', 'SC'),
(14850, 31, 508, 'Palma Sola', 'BR', 'SC'),
(14851, 31, 508, 'Palmeira', 'BR', 'SC'),
(14852, 31, 508, 'Palmitos', 'BR', 'SC'),
(14853, 31, 508, 'Pantanal', 'BR', 'SC'),
(14854, 31, 508, 'Pantano do Sul', 'BR', 'SC'),
(14855, 31, 508, 'Papanduva', 'BR', 'SC'),
(14856, 31, 508, 'Paraíso', 'BR', 'SC'),
(14857, 31, 508, 'Passo de Torres', 'BR', 'SC'),
(14858, 31, 508, 'Passos Maia', 'BR', 'SC'),
(14859, 31, 508, 'Paulo Lopes', 'BR', 'SC'),
(14860, 31, 508, 'Pedras Grandes', 'BR', 'SC'),
(14861, 31, 508, 'Penha', 'BR', 'SC'),
(14862, 31, 508, 'Peritiba', 'BR', 'SC'),
(14863, 31, 508, 'Petrolândia', 'BR', 'SC'),
(14864, 31, 508, 'Pinhalzinho', 'BR', 'SC'),
(14865, 31, 508, 'Pinheiro Preto', 'BR', 'SC'),
(14866, 31, 508, 'Piratuba', 'BR', 'SC'),
(14867, 31, 508, 'Planalto Alegre', 'BR', 'SC'),
(14868, 31, 508, 'Pomerode', 'BR', 'SC'),
(14869, 31, 508, 'Ponte Alta', 'BR', 'SC'),
(14870, 31, 508, 'Ponte Alta do Norte', 'BR', 'SC'),
(14871, 31, 508, 'Ponte Serrada', 'BR', 'SC'),
(14872, 31, 508, 'Porto Belo', 'BR', 'SC'),
(14873, 31, 508, 'Porto União', 'BR', 'SC'),
(14874, 31, 508, 'Pouso Redondo', 'BR', 'SC'),
(14875, 31, 508, 'Praia Grande', 'BR', 'SC'),
(14876, 31, 508, 'Presidente Castello Branco', 'BR', 'SC'),
(14877, 31, 508, 'Presidente Getúlio', 'BR', 'SC'),
(14878, 31, 508, 'Presidente Nereu', 'BR', 'SC'),
(14879, 31, 508, 'Princesa', 'BR', 'SC'),
(14880, 31, 508, 'Quilombo', 'BR', 'SC'),
(14881, 31, 508, 'Rancho Queimado', 'BR', 'SC'),
(14882, 31, 508, 'Residencia Moacir PU5BHV', 'BR', 'SC'),
(14883, 31, 508, 'Ribeirão da Ilha', 'BR', 'SC'),
(14884, 31, 508, 'Rio das Antas', 'BR', 'SC'),
(14885, 31, 508, 'Rio do Campo', 'BR', 'SC'),
(14886, 31, 508, 'Rio do Oeste', 'BR', 'SC'),
(14887, 31, 508, 'Rio do Sul', 'BR', 'SC'),
(14888, 31, 508, 'Rio dos Cedros', 'BR', 'SC'),
(14889, 31, 508, 'Rio Fortuna', 'BR', 'SC'),
(14890, 31, 508, 'Rio Negrinho', 'BR', 'SC'),
(14891, 31, 508, 'Rio Rufino', 'BR', 'SC'),
(14892, 31, 508, 'Rio Tavares', 'BR', 'SC'),
(14893, 31, 508, 'Riqueza', 'BR', 'SC'),
(14894, 31, 508, 'Rodeio', 'BR', 'SC'),
(14895, 31, 508, 'Romelândia', 'BR', 'SC'),
(14896, 31, 508, 'Saco dos Limoes', 'BR', 'SC'),
(14897, 31, 508, 'Salete', 'BR', 'SC'),
(14898, 31, 508, 'Saltinho', 'BR', 'SC'),
(14899, 31, 508, 'Salto Veloso', 'BR', 'SC'),
(14900, 31, 508, 'Sangão', 'BR', 'SC'),
(14901, 31, 508, 'Santa Cecília', 'BR', 'SC'),
(14902, 31, 508, 'Santa Helena', 'BR', 'SC'),
(14903, 31, 508, 'Santa Monica', 'BR', 'SC'),
(14904, 31, 508, 'Santa Rosa de Lima', 'BR', 'SC'),
(14905, 31, 508, 'Santa Rosa do Sul', 'BR', 'SC'),
(14906, 31, 508, 'Santa Terezinha', 'BR', 'SC'),
(14907, 31, 508, 'Santa Terezinha do Progresso', 'BR', 'SC'),
(14908, 31, 508, 'Santiago do Sul', 'BR', 'SC'),
(14909, 31, 508, 'Santo Amaro da Imperatriz', 'BR', 'SC'),
(14910, 31, 508, 'São Bento do Sul', 'BR', 'SC'),
(14911, 31, 508, 'São Bernardino', 'BR', 'SC'),
(14912, 31, 508, 'São Bonifácio', 'BR', 'SC'),
(14913, 31, 508, 'São Carlos', 'BR', 'SC'),
(14914, 31, 508, 'São Cristóvão do Sul', 'BR', 'SC'),
(14915, 31, 508, 'São Domingos', 'BR', 'SC'),
(14916, 31, 508, 'São Francisco do Sul', 'BR', 'SC'),
(14917, 31, 508, 'São João Batista', 'BR', 'SC'),
(14918, 31, 508, 'São João do Itaperiú', 'BR', 'SC'),
(14919, 31, 508, 'São João do Oeste', 'BR', 'SC'),
(14920, 31, 508, 'São João do Sul', 'BR', 'SC'),
(14921, 31, 508, 'São Joaquim', 'BR', 'SC'),
(14922, 31, 508, 'São José', 'BR', 'SC'),
(14923, 31, 508, 'São José do Cedro', 'BR', 'SC'),
(14924, 31, 508, 'São José do Cerrito', 'BR', 'SC'),
(14925, 31, 508, 'São Lourenço do Oeste', 'BR', 'SC'),
(14926, 31, 508, 'São Ludgero', 'BR', 'SC'),
(14927, 31, 508, 'São Martinho', 'BR', 'SC'),
(14928, 31, 508, 'São Miguel da Boa Vista', 'BR', 'SC'),
(14929, 31, 508, 'São Miguel do Oeste', 'BR', 'SC'),
(14930, 31, 508, 'São Pedro de Alcântara', 'BR', 'SC'),
(14931, 31, 508, 'Saudades', 'BR', 'SC'),
(14932, 31, 508, 'Schroeder', 'BR', 'SC'),
(14933, 31, 508, 'Seara', 'BR', 'SC'),
(14934, 31, 508, 'Serra Alta', 'BR', 'SC'),
(14935, 31, 508, 'Siderópolis', 'BR', 'SC'),
(14936, 31, 508, 'Sombrio', 'BR', 'SC'),
(14937, 31, 508, 'Sul Brasil', 'BR', 'SC'),
(14938, 31, 508, 'Taió', 'BR', 'SC'),
(14939, 31, 508, 'Tangará', 'BR', 'SC'),
(14940, 31, 508, 'Tapera', 'BR', 'SC'),
(14941, 31, 508, 'Tigrinhos', 'BR', 'SC'),
(14942, 31, 508, 'Tijucas', 'BR', 'SC'),
(14943, 31, 508, 'Timbé do Sul', 'BR', 'SC'),
(14944, 31, 508, 'Timbó', 'BR', 'SC'),
(14945, 31, 508, 'Timbó Grande', 'BR', 'SC'),
(14946, 31, 508, 'Três Barras', 'BR', 'SC'),
(14947, 31, 508, 'Treviso', 'BR', 'SC'),
(14948, 31, 508, 'Treze de Maio', 'BR', 'SC'),
(14949, 31, 508, 'Treze Tílias', 'BR', 'SC'),
(14950, 31, 508, 'Trindade', 'BR', 'SC'),
(14951, 31, 508, 'Trombudo Central', 'BR', 'SC'),
(14952, 31, 508, 'Tubarão', 'BR', 'SC'),
(14953, 31, 508, 'Tunápolis', 'BR', 'SC'),
(14954, 31, 508, 'Turvo', 'BR', 'SC'),
(14955, 31, 508, 'União do Oeste', 'BR', 'SC'),
(14956, 31, 508, 'Urubici', 'BR', 'SC'),
(14957, 31, 508, 'Urupema', 'BR', 'SC'),
(14958, 31, 508, 'Urussanga', 'BR', 'SC'),
(14959, 31, 508, 'Vargeão', 'BR', 'SC'),
(14960, 31, 508, 'Vargem', 'BR', 'SC'),
(14961, 31, 508, 'Vargem Bonita', 'BR', 'SC'),
(14962, 31, 508, 'Vidal Ramos', 'BR', 'SC'),
(14963, 31, 508, 'Videira', 'BR', 'SC'),
(14964, 31, 508, 'Vitor Meireles', 'BR', 'SC'),
(14965, 31, 508, 'Witmarsum', 'BR', 'SC'),
(14966, 31, 508, 'Xanxerê', 'BR', 'SC'),
(14967, 31, 508, 'Xavantina', 'BR', 'SC'),
(14968, 31, 508, 'Xaxim', 'BR', 'SC'),
(14969, 31, 508, 'Zortéa', 'BR', 'SC'),
(14970, 31, 509, 'Adamantina', 'BR', 'SP'),
(14971, 31, 509, 'Adolfo', 'BR', 'SP'),
(14972, 31, 509, 'Aguaí', 'BR', 'SP'),
(14973, 31, 509, 'Águas da Prata', 'BR', 'SP'),
(14974, 31, 509, 'Águas de Lindóia', 'BR', 'SP'),
(14975, 31, 509, 'Águas de Santa Bárbara', 'BR', 'SP'),
(14976, 31, 509, 'Águas de São Pedro', 'BR', 'SP'),
(14977, 31, 509, 'Agudos', 'BR', 'SP'),
(14978, 31, 509, 'Alambari', 'BR', 'SP'),
(14979, 31, 509, 'Alfredo Marcondes', 'BR', 'SP'),
(14980, 31, 509, 'Altair', 'BR', 'SP'),
(14981, 31, 509, 'Altinópolis', 'BR', 'SP'),
(14982, 31, 509, 'Alto Alegre', 'BR', 'SP'),
(14983, 31, 509, 'Alumínio', 'BR', 'SP'),
(14984, 31, 509, 'Álvares Florence', 'BR', 'SP'),
(14985, 31, 509, 'Álvares Machado', 'BR', 'SP'),
(14986, 31, 509, 'Álvaro de Carvalho', 'BR', 'SP'),
(14987, 31, 509, 'Alvinlândia', 'BR', 'SP'),
(14988, 31, 509, 'Americana', 'BR', 'SP'),
(14989, 31, 509, 'Américo Brasiliense', 'BR', 'SP'),
(14990, 31, 509, 'Américo de Campos', 'BR', 'SP'),
(14991, 31, 509, 'Amparo', 'BR', 'SP'),
(14992, 31, 509, 'Analândia', 'BR', 'SP'),
(14993, 31, 509, 'Andradina', 'BR', 'SP'),
(14994, 31, 509, 'Angatuba', 'BR', 'SP'),
(14995, 31, 509, 'Anhembi', 'BR', 'SP'),
(14996, 31, 509, 'Anhumas', 'BR', 'SP'),
(14997, 31, 509, 'Aparecida', 'BR', 'SP'),
(14998, 31, 509, 'Aparecida d\'Oeste', 'BR', 'SP'),
(14999, 31, 509, 'Apiaí', 'BR', 'SP'),
(15000, 31, 509, 'Araçariguama', 'BR', 'SP');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(15001, 31, 509, 'Araçatuba', 'BR', 'SP'),
(15002, 31, 509, 'Araçoiaba da Serra', 'BR', 'SP'),
(15003, 31, 509, 'Aramina', 'BR', 'SP'),
(15004, 31, 509, 'Arandu', 'BR', 'SP'),
(15005, 31, 509, 'Arapeí', 'BR', 'SP'),
(15006, 31, 509, 'Araraquara', 'BR', 'SP'),
(15007, 31, 509, 'Araras', 'BR', 'SP'),
(15008, 31, 509, 'Arco-Íris', 'BR', 'SP'),
(15009, 31, 509, 'Arealva', 'BR', 'SP'),
(15010, 31, 509, 'Areias', 'BR', 'SP'),
(15011, 31, 509, 'Areiópolis', 'BR', 'SP'),
(15012, 31, 509, 'Ariranha', 'BR', 'SP'),
(15013, 31, 509, 'Artur Nogueira', 'BR', 'SP'),
(15014, 31, 509, 'Arujá', 'BR', 'SP'),
(15015, 31, 509, 'Aspásia', 'BR', 'SP'),
(15016, 31, 509, 'Assis', 'BR', 'SP'),
(15017, 31, 509, 'Atibaia', 'BR', 'SP'),
(15018, 31, 509, 'Auriflama', 'BR', 'SP'),
(15019, 31, 509, 'Avaí', 'BR', 'SP'),
(15020, 31, 509, 'Avanhandava', 'BR', 'SP'),
(15021, 31, 509, 'Avaré', 'BR', 'SP'),
(15022, 31, 509, 'Bady Bassitt', 'BR', 'SP'),
(15023, 31, 509, 'Balbinos', 'BR', 'SP'),
(15024, 31, 509, 'Bálsamo', 'BR', 'SP'),
(15025, 31, 509, 'Bananal', 'BR', 'SP'),
(15026, 31, 509, 'Barão de Antonina', 'BR', 'SP'),
(15027, 31, 509, 'Barbosa', 'BR', 'SP'),
(15028, 31, 509, 'Bariri', 'BR', 'SP'),
(15029, 31, 509, 'Barra Bonita', 'BR', 'SP'),
(15030, 31, 509, 'Barra do Chapéu', 'BR', 'SP'),
(15031, 31, 509, 'Barra do Turvo', 'BR', 'SP'),
(15032, 31, 509, 'Barretos', 'BR', 'SP'),
(15033, 31, 509, 'Barrinha', 'BR', 'SP'),
(15034, 31, 509, 'Barueri', 'BR', 'SP'),
(15035, 31, 509, 'Bastos', 'BR', 'SP'),
(15036, 31, 509, 'Batatais', 'BR', 'SP'),
(15037, 31, 509, 'Bauru', 'BR', 'SP'),
(15038, 31, 509, 'Bebedouro', 'BR', 'SP'),
(15039, 31, 509, 'Bento de Abreu', 'BR', 'SP'),
(15040, 31, 509, 'Bernardino de Campos', 'BR', 'SP'),
(15041, 31, 509, 'Bertioga', 'BR', 'SP'),
(15042, 31, 509, 'Bilac', 'BR', 'SP'),
(15043, 31, 509, 'Birigui', 'BR', 'SP'),
(15044, 31, 509, 'Biritiba Mirim', 'BR', 'SP'),
(15045, 31, 509, 'Biritiba-Mirim', 'BR', 'SP'),
(15046, 31, 509, 'Boa Esperança do Sul', 'BR', 'SP'),
(15047, 31, 509, 'Bocaina', 'BR', 'SP'),
(15048, 31, 509, 'Bofete', 'BR', 'SP'),
(15049, 31, 509, 'Boituva', 'BR', 'SP'),
(15050, 31, 509, 'Bom Jesus dos Perdões', 'BR', 'SP'),
(15051, 31, 509, 'Bom Sucesso de Itararé', 'BR', 'SP'),
(15052, 31, 509, 'Borá', 'BR', 'SP'),
(15053, 31, 509, 'Boracéia', 'BR', 'SP'),
(15054, 31, 509, 'Borborema', 'BR', 'SP'),
(15055, 31, 509, 'Borebi', 'BR', 'SP'),
(15056, 31, 509, 'Botucatu', 'BR', 'SP'),
(15057, 31, 509, 'Bragança Paulista', 'BR', 'SP'),
(15058, 31, 509, 'Braúna', 'BR', 'SP'),
(15059, 31, 509, 'Brejo Alegre', 'BR', 'SP'),
(15060, 31, 509, 'Brodósqui', 'BR', 'SP'),
(15061, 31, 509, 'Brodowski', 'BR', 'SP'),
(15062, 31, 509, 'Brotas', 'BR', 'SP'),
(15063, 31, 509, 'Buri', 'BR', 'SP'),
(15064, 31, 509, 'Buritama', 'BR', 'SP'),
(15065, 31, 509, 'Buritizal', 'BR', 'SP'),
(15066, 31, 509, 'Cabrália Paulista', 'BR', 'SP'),
(15067, 31, 509, 'Cabreúva', 'BR', 'SP'),
(15068, 31, 509, 'Caçapava', 'BR', 'SP'),
(15069, 31, 509, 'Cachoeira Paulista', 'BR', 'SP'),
(15070, 31, 509, 'Caconde', 'BR', 'SP'),
(15071, 31, 509, 'Cafelândia', 'BR', 'SP'),
(15072, 31, 509, 'Caiabu', 'BR', 'SP'),
(15073, 31, 509, 'Caieiras', 'BR', 'SP'),
(15074, 31, 509, 'Caiuá', 'BR', 'SP'),
(15075, 31, 509, 'Cajamar', 'BR', 'SP'),
(15076, 31, 509, 'Cajati', 'BR', 'SP'),
(15077, 31, 509, 'Cajobi', 'BR', 'SP'),
(15078, 31, 509, 'Cajuru', 'BR', 'SP'),
(15079, 31, 509, 'Campina do Monte Alegre', 'BR', 'SP'),
(15080, 31, 509, 'Campinas', 'BR', 'SP'),
(15081, 31, 509, 'Campo Limpo Paulista', 'BR', 'SP'),
(15082, 31, 509, 'Campos do Jordão', 'BR', 'SP'),
(15083, 31, 509, 'Campos Novos Paulista', 'BR', 'SP'),
(15084, 31, 509, 'Cananéia', 'BR', 'SP'),
(15085, 31, 509, 'Canas', 'BR', 'SP'),
(15086, 31, 509, 'Cândido Mota', 'BR', 'SP'),
(15087, 31, 509, 'Cândido Rodrigues', 'BR', 'SP'),
(15088, 31, 509, 'Canitar', 'BR', 'SP'),
(15089, 31, 509, 'Capâo Bonito', 'BR', 'SP'),
(15090, 31, 509, 'Capela do Alto', 'BR', 'SP'),
(15091, 31, 509, 'Capivari', 'BR', 'SP'),
(15092, 31, 509, 'Caraguatatuba', 'BR', 'SP'),
(15093, 31, 509, 'Carapicuíba', 'BR', 'SP'),
(15094, 31, 509, 'Cardoso', 'BR', 'SP'),
(15095, 31, 509, 'Casa Branca', 'BR', 'SP'),
(15096, 31, 509, 'Cássia dos Coqueiros', 'BR', 'SP'),
(15097, 31, 509, 'Castilho', 'BR', 'SP'),
(15098, 31, 509, 'Catanduva', 'BR', 'SP'),
(15099, 31, 509, 'Catiguá', 'BR', 'SP'),
(15100, 31, 509, 'Cedral', 'BR', 'SP'),
(15101, 31, 509, 'Cerqueira César', 'BR', 'SP'),
(15102, 31, 509, 'Cerquilho', 'BR', 'SP'),
(15103, 31, 509, 'Cesário Lange', 'BR', 'SP'),
(15104, 31, 509, 'Charqueada', 'BR', 'SP'),
(15105, 31, 509, 'Chavantes', 'BR', 'SP'),
(15106, 31, 509, 'Clementina', 'BR', 'SP'),
(15107, 31, 509, 'Colina', 'BR', 'SP'),
(15108, 31, 509, 'Colômbia', 'BR', 'SP'),
(15109, 31, 509, 'Conchal', 'BR', 'SP'),
(15110, 31, 509, 'Conchas', 'BR', 'SP'),
(15111, 31, 509, 'Cordeirópolis', 'BR', 'SP'),
(15112, 31, 509, 'Coroados', 'BR', 'SP'),
(15113, 31, 509, 'Coronel Macedo', 'BR', 'SP'),
(15114, 31, 509, 'Corumbataí', 'BR', 'SP'),
(15115, 31, 509, 'Cosmópolis', 'BR', 'SP'),
(15116, 31, 509, 'Cosmorama', 'BR', 'SP'),
(15117, 31, 509, 'Cotia', 'BR', 'SP'),
(15118, 31, 509, 'Cravinhos', 'BR', 'SP'),
(15119, 31, 509, 'Cristais Paulista', 'BR', 'SP'),
(15120, 31, 509, 'Cruzália', 'BR', 'SP'),
(15121, 31, 509, 'Cruzeiro', 'BR', 'SP'),
(15122, 31, 509, 'Cubatão', 'BR', 'SP'),
(15123, 31, 509, 'Cunha', 'BR', 'SP'),
(15124, 31, 509, 'Descalvado', 'BR', 'SP'),
(15125, 31, 509, 'Diadema', 'BR', 'SP'),
(15126, 31, 509, 'Dirce Reis', 'BR', 'SP'),
(15127, 31, 509, 'Divinolândia', 'BR', 'SP'),
(15128, 31, 509, 'Dobrada', 'BR', 'SP'),
(15129, 31, 509, 'Dois Córregos', 'BR', 'SP'),
(15130, 31, 509, 'Dolcinópolis', 'BR', 'SP'),
(15131, 31, 509, 'Dourado', 'BR', 'SP'),
(15132, 31, 509, 'Dracena', 'BR', 'SP'),
(15133, 31, 509, 'Duartina', 'BR', 'SP'),
(15134, 31, 509, 'Dumont', 'BR', 'SP'),
(15135, 31, 509, 'Echaporã', 'BR', 'SP'),
(15136, 31, 509, 'Eldorado', 'BR', 'SP'),
(15137, 31, 509, 'Elias Fausto', 'BR', 'SP'),
(15138, 31, 509, 'Elisiário', 'BR', 'SP'),
(15139, 31, 509, 'Embaúba', 'BR', 'SP'),
(15140, 31, 509, 'Embu', 'BR', 'SP'),
(15141, 31, 509, 'Embu das Artes', 'BR', 'SP'),
(15142, 31, 509, 'Embu Guaçu', 'BR', 'SP'),
(15143, 31, 509, 'Embu-Guaçu', 'BR', 'SP'),
(15144, 31, 509, 'Emilianópolis', 'BR', 'SP'),
(15145, 31, 509, 'Engenheiro Coelho', 'BR', 'SP'),
(15146, 31, 509, 'Espírito Santo do Pinhal', 'BR', 'SP'),
(15147, 31, 509, 'Espírito Santo do Turvo', 'BR', 'SP'),
(15148, 31, 509, 'Estiva Gerbi', 'BR', 'SP'),
(15149, 31, 509, 'Estrela d\'Oeste', 'BR', 'SP'),
(15150, 31, 509, 'Estrela do Norte', 'BR', 'SP'),
(15151, 31, 509, 'Euclides da Cunha Paulista', 'BR', 'SP'),
(15152, 31, 509, 'Fartura', 'BR', 'SP'),
(15153, 31, 509, 'Fernando Prestes', 'BR', 'SP'),
(15154, 31, 509, 'Fernandópolis', 'BR', 'SP'),
(15155, 31, 509, 'Fernão', 'BR', 'SP'),
(15156, 31, 509, 'Ferraz de Vasconcelos', 'BR', 'SP'),
(15157, 31, 509, 'Flora Rica', 'BR', 'SP'),
(15158, 31, 509, 'Floreal', 'BR', 'SP'),
(15159, 31, 509, 'Flórida Paulista', 'BR', 'SP'),
(15160, 31, 509, 'Florínea', 'BR', 'SP'),
(15161, 31, 509, 'Franca', 'BR', 'SP'),
(15162, 31, 509, 'Francisco Morato', 'BR', 'SP'),
(15163, 31, 509, 'Franco da Rocha', 'BR', 'SP'),
(15164, 31, 509, 'Gabriel Monteiro', 'BR', 'SP'),
(15165, 31, 509, 'Gália', 'BR', 'SP'),
(15166, 31, 509, 'Garça', 'BR', 'SP'),
(15167, 31, 509, 'Gastão Vidigal', 'BR', 'SP'),
(15168, 31, 509, 'Gavião Peixoto', 'BR', 'SP'),
(15169, 31, 509, 'General Salgado', 'BR', 'SP'),
(15170, 31, 509, 'Getulina', 'BR', 'SP'),
(15171, 31, 509, 'Glicério', 'BR', 'SP'),
(15172, 31, 509, 'Guaiçara', 'BR', 'SP'),
(15173, 31, 509, 'Guaimbê', 'BR', 'SP'),
(15174, 31, 509, 'Guaíra', 'BR', 'SP'),
(15175, 31, 509, 'Guapiaçu', 'BR', 'SP'),
(15176, 31, 509, 'Guapiara', 'BR', 'SP'),
(15177, 31, 509, 'Guará', 'BR', 'SP'),
(15178, 31, 509, 'Guaraçaí', 'BR', 'SP'),
(15179, 31, 509, 'Guaraci', 'BR', 'SP'),
(15180, 31, 509, 'Guarani d\'Oeste', 'BR', 'SP'),
(15181, 31, 509, 'Guarantã', 'BR', 'SP'),
(15182, 31, 509, 'Guararapes', 'BR', 'SP'),
(15183, 31, 509, 'Guararema', 'BR', 'SP'),
(15184, 31, 509, 'Guaratinguetá', 'BR', 'SP'),
(15185, 31, 509, 'Guareí', 'BR', 'SP'),
(15186, 31, 509, 'Guariba', 'BR', 'SP'),
(15187, 31, 509, 'Guarujá', 'BR', 'SP'),
(15188, 31, 509, 'Guarulhos', 'BR', 'SP'),
(15189, 31, 509, 'Guatapará', 'BR', 'SP'),
(15190, 31, 509, 'Guzolândia', 'BR', 'SP'),
(15191, 31, 509, 'Herculândia', 'BR', 'SP'),
(15192, 31, 509, 'Holambra', 'BR', 'SP'),
(15193, 31, 509, 'Hortolândia', 'BR', 'SP'),
(15194, 31, 509, 'Iacanga', 'BR', 'SP'),
(15195, 31, 509, 'Iacri', 'BR', 'SP'),
(15196, 31, 509, 'Iaras', 'BR', 'SP'),
(15197, 31, 509, 'Ibaté', 'BR', 'SP'),
(15198, 31, 509, 'Ibirá', 'BR', 'SP'),
(15199, 31, 509, 'Ibirarema', 'BR', 'SP'),
(15200, 31, 509, 'Ibitinga', 'BR', 'SP'),
(15201, 31, 509, 'Ibiúna', 'BR', 'SP'),
(15202, 31, 509, 'Icém', 'BR', 'SP'),
(15203, 31, 509, 'Iepê', 'BR', 'SP'),
(15204, 31, 509, 'Igaraçu do Tietê', 'BR', 'SP'),
(15205, 31, 509, 'Igarapava', 'BR', 'SP'),
(15206, 31, 509, 'Igaratá', 'BR', 'SP'),
(15207, 31, 509, 'Iguape', 'BR', 'SP'),
(15208, 31, 509, 'Ilha Comprida', 'BR', 'SP'),
(15209, 31, 509, 'Ilha Solteira', 'BR', 'SP'),
(15210, 31, 509, 'Ilhabela', 'BR', 'SP'),
(15211, 31, 509, 'Indaiatuba', 'BR', 'SP'),
(15212, 31, 509, 'Indiana', 'BR', 'SP'),
(15213, 31, 509, 'Indiaporã', 'BR', 'SP'),
(15214, 31, 509, 'Inúbia Paulista', 'BR', 'SP'),
(15215, 31, 509, 'Ipauçu', 'BR', 'SP'),
(15216, 31, 509, 'Ipaussu', 'BR', 'SP'),
(15217, 31, 509, 'Iperó', 'BR', 'SP'),
(15218, 31, 509, 'Ipeúna', 'BR', 'SP'),
(15219, 31, 509, 'Ipiguá', 'BR', 'SP'),
(15220, 31, 509, 'Iporanga', 'BR', 'SP'),
(15221, 31, 509, 'Ipuã', 'BR', 'SP'),
(15222, 31, 509, 'Iracemápolis', 'BR', 'SP'),
(15223, 31, 509, 'Irapuã', 'BR', 'SP'),
(15224, 31, 509, 'Irapuru', 'BR', 'SP'),
(15225, 31, 509, 'Itaberá', 'BR', 'SP'),
(15226, 31, 509, 'Itaí', 'BR', 'SP'),
(15227, 31, 509, 'Itajobi', 'BR', 'SP'),
(15228, 31, 509, 'Itaju', 'BR', 'SP'),
(15229, 31, 509, 'Itanhaém', 'BR', 'SP'),
(15230, 31, 509, 'Itaoca', 'BR', 'SP'),
(15231, 31, 509, 'Itapecerica da Serra', 'BR', 'SP'),
(15232, 31, 509, 'Itapetininga', 'BR', 'SP'),
(15233, 31, 509, 'Itapeva', 'BR', 'SP'),
(15234, 31, 509, 'Itapevi', 'BR', 'SP'),
(15235, 31, 509, 'Itapira', 'BR', 'SP'),
(15236, 31, 509, 'Itapirapuã Paulista', 'BR', 'SP'),
(15237, 31, 509, 'Itápolis', 'BR', 'SP'),
(15238, 31, 509, 'Itaporanga', 'BR', 'SP'),
(15239, 31, 509, 'Itapuí', 'BR', 'SP'),
(15240, 31, 509, 'Itapura', 'BR', 'SP'),
(15241, 31, 509, 'Itaquaquecetuba', 'BR', 'SP'),
(15242, 31, 509, 'Itararé', 'BR', 'SP'),
(15243, 31, 509, 'Itariri', 'BR', 'SP'),
(15244, 31, 509, 'Itatiba', 'BR', 'SP'),
(15245, 31, 509, 'Itatinga', 'BR', 'SP'),
(15246, 31, 509, 'Itirapina', 'BR', 'SP'),
(15247, 31, 509, 'Itirapuã', 'BR', 'SP'),
(15248, 31, 509, 'Itobi', 'BR', 'SP'),
(15249, 31, 509, 'Itu', 'BR', 'SP'),
(15250, 31, 509, 'Itupeva', 'BR', 'SP'),
(15251, 31, 509, 'Ituverava', 'BR', 'SP'),
(15252, 31, 509, 'Jaborandi', 'BR', 'SP'),
(15253, 31, 509, 'Jaboticabal', 'BR', 'SP'),
(15254, 31, 509, 'Jacareí', 'BR', 'SP'),
(15255, 31, 509, 'Jaci', 'BR', 'SP'),
(15256, 31, 509, 'Jacupiranga', 'BR', 'SP'),
(15257, 31, 509, 'Jaguariúna', 'BR', 'SP'),
(15258, 31, 509, 'Jales', 'BR', 'SP'),
(15259, 31, 509, 'Jambeiro', 'BR', 'SP'),
(15260, 31, 509, 'Jandira', 'BR', 'SP'),
(15261, 31, 509, 'Jardim Paulista', 'BR', 'SP'),
(15262, 31, 509, 'Jardinópolis', 'BR', 'SP'),
(15263, 31, 509, 'Jarinu', 'BR', 'SP'),
(15264, 31, 509, 'Jaú', 'BR', 'SP'),
(15265, 31, 509, 'Jeriquara', 'BR', 'SP'),
(15266, 31, 509, 'Joanópolis', 'BR', 'SP'),
(15267, 31, 509, 'João Ramalho', 'BR', 'SP'),
(15268, 31, 509, 'José Bonifácio', 'BR', 'SP'),
(15269, 31, 509, 'Júlio Mesquita', 'BR', 'SP'),
(15270, 31, 509, 'Jumirim', 'BR', 'SP'),
(15271, 31, 509, 'Jundiaí', 'BR', 'SP'),
(15272, 31, 509, 'Junqueirópolis', 'BR', 'SP'),
(15273, 31, 509, 'Juquiá', 'BR', 'SP'),
(15274, 31, 509, 'Juquitiba', 'BR', 'SP'),
(15275, 31, 509, 'Lagoinha', 'BR', 'SP'),
(15276, 31, 509, 'Laranjal Paulista', 'BR', 'SP'),
(15277, 31, 509, 'Lavínia', 'BR', 'SP'),
(15278, 31, 509, 'Lavrinhas', 'BR', 'SP'),
(15279, 31, 509, 'Leme', 'BR', 'SP'),
(15280, 31, 509, 'Lençóis Paulista', 'BR', 'SP'),
(15281, 31, 509, 'Limeira', 'BR', 'SP'),
(15282, 31, 509, 'Lindóia', 'BR', 'SP'),
(15283, 31, 509, 'Lins', 'BR', 'SP'),
(15284, 31, 509, 'Lorena', 'BR', 'SP'),
(15285, 31, 509, 'Lourdes', 'BR', 'SP'),
(15286, 31, 509, 'Louveira', 'BR', 'SP'),
(15287, 31, 509, 'Lucélia', 'BR', 'SP'),
(15288, 31, 509, 'Lucianópolis', 'BR', 'SP'),
(15289, 31, 509, 'Luís Antônio', 'BR', 'SP'),
(15290, 31, 509, 'Luiziânia', 'BR', 'SP'),
(15291, 31, 509, 'Lupércio', 'BR', 'SP'),
(15292, 31, 509, 'Lutécia', 'BR', 'SP'),
(15293, 31, 509, 'Macatuba', 'BR', 'SP'),
(15294, 31, 509, 'Macaubal', 'BR', 'SP'),
(15295, 31, 509, 'Macedônia', 'BR', 'SP'),
(15296, 31, 509, 'Magda', 'BR', 'SP'),
(15297, 31, 509, 'Mairinque', 'BR', 'SP'),
(15298, 31, 509, 'Mairiporã', 'BR', 'SP'),
(15299, 31, 509, 'Manduri', 'BR', 'SP'),
(15300, 31, 509, 'Marabá Paulista', 'BR', 'SP'),
(15301, 31, 509, 'Maracaí', 'BR', 'SP'),
(15302, 31, 509, 'Marapoama', 'BR', 'SP'),
(15303, 31, 509, 'Mariápolis', 'BR', 'SP'),
(15304, 31, 509, 'Marília', 'BR', 'SP'),
(15305, 31, 509, 'Marinópolis', 'BR', 'SP'),
(15306, 31, 509, 'Martinópolis', 'BR', 'SP'),
(15307, 31, 509, 'Matão', 'BR', 'SP'),
(15308, 31, 509, 'Mauá', 'BR', 'SP'),
(15309, 31, 509, 'Mendonça', 'BR', 'SP'),
(15310, 31, 509, 'Meridiano', 'BR', 'SP'),
(15311, 31, 509, 'Mesópolis', 'BR', 'SP'),
(15312, 31, 509, 'Miguelópolis', 'BR', 'SP'),
(15313, 31, 509, 'Mineiros do Tietê', 'BR', 'SP'),
(15314, 31, 509, 'Mira Estrela', 'BR', 'SP'),
(15315, 31, 509, 'Miracatu', 'BR', 'SP'),
(15316, 31, 509, 'Mirandopólis', 'BR', 'SP'),
(15317, 31, 509, 'Mirante do Paranapanema', 'BR', 'SP'),
(15318, 31, 509, 'Mirassol', 'BR', 'SP'),
(15319, 31, 509, 'Mirassolândia', 'BR', 'SP'),
(15320, 31, 509, 'Mococa', 'BR', 'SP'),
(15321, 31, 509, 'Mogi das Cruzes', 'BR', 'SP'),
(15322, 31, 509, 'Mogi Guaçu', 'BR', 'SP'),
(15323, 31, 509, 'Mogi Mirim', 'BR', 'SP'),
(15324, 31, 509, 'Mombuca', 'BR', 'SP'),
(15325, 31, 509, 'Monções', 'BR', 'SP'),
(15326, 31, 509, 'Mongaguá', 'BR', 'SP'),
(15327, 31, 509, 'Monte Alegre do Sul', 'BR', 'SP'),
(15328, 31, 509, 'Monte Alto', 'BR', 'SP'),
(15329, 31, 509, 'Monte Aprazível', 'BR', 'SP'),
(15330, 31, 509, 'Monte Azul Paulista', 'BR', 'SP'),
(15331, 31, 509, 'Monte Castelo', 'BR', 'SP'),
(15332, 31, 509, 'Monte Mor', 'BR', 'SP'),
(15333, 31, 509, 'Monteiro Lobato', 'BR', 'SP'),
(15334, 31, 509, 'Morro Agudo', 'BR', 'SP'),
(15335, 31, 509, 'Morungaba', 'BR', 'SP'),
(15336, 31, 509, 'Motuca', 'BR', 'SP'),
(15337, 31, 509, 'Murutinga do Sul', 'BR', 'SP'),
(15338, 31, 509, 'Nantes', 'BR', 'SP'),
(15339, 31, 509, 'Narandiba', 'BR', 'SP'),
(15340, 31, 509, 'Natividade da Serra', 'BR', 'SP'),
(15341, 31, 509, 'Nazaré Paulista', 'BR', 'SP'),
(15342, 31, 509, 'Neves Paulista', 'BR', 'SP'),
(15343, 31, 509, 'Nhandeara', 'BR', 'SP'),
(15344, 31, 509, 'Nipoã', 'BR', 'SP'),
(15345, 31, 509, 'Nova Aliança', 'BR', 'SP'),
(15346, 31, 509, 'Nova Campina', 'BR', 'SP'),
(15347, 31, 509, 'Nova Canaã Paulista', 'BR', 'SP'),
(15348, 31, 509, 'Nova Castilho', 'BR', 'SP'),
(15349, 31, 509, 'Nova Europa', 'BR', 'SP'),
(15350, 31, 509, 'Nova Granada', 'BR', 'SP'),
(15351, 31, 509, 'Nova Guataporanga', 'BR', 'SP'),
(15352, 31, 509, 'Nova Independência', 'BR', 'SP'),
(15353, 31, 509, 'Nova Luzitânia', 'BR', 'SP'),
(15354, 31, 509, 'Nova Odessa', 'BR', 'SP'),
(15355, 31, 509, 'Novais', 'BR', 'SP'),
(15356, 31, 509, 'Novo Horizonte', 'BR', 'SP'),
(15357, 31, 509, 'Nuporanga', 'BR', 'SP'),
(15358, 31, 509, 'Ocauçu', 'BR', 'SP'),
(15359, 31, 509, 'Óleo', 'BR', 'SP'),
(15360, 31, 509, 'Olímpia', 'BR', 'SP'),
(15361, 31, 509, 'Onda Verde', 'BR', 'SP'),
(15362, 31, 509, 'Oriente', 'BR', 'SP'),
(15363, 31, 509, 'Orindiúva', 'BR', 'SP'),
(15364, 31, 509, 'Orlândia', 'BR', 'SP'),
(15365, 31, 509, 'Osasco', 'BR', 'SP'),
(15366, 31, 509, 'Oscar Bressane', 'BR', 'SP'),
(15367, 31, 509, 'Osvaldo Cruz', 'BR', 'SP'),
(15368, 31, 509, 'Ourinhos', 'BR', 'SP'),
(15369, 31, 509, 'Ouro Verde', 'BR', 'SP'),
(15370, 31, 509, 'Ouroeste', 'BR', 'SP'),
(15371, 31, 509, 'Pacaembu', 'BR', 'SP'),
(15372, 31, 509, 'Palestina', 'BR', 'SP'),
(15373, 31, 509, 'Palmares Paulista', 'BR', 'SP'),
(15374, 31, 509, 'Palmeira d\'Oeste', 'BR', 'SP'),
(15375, 31, 509, 'Palmital', 'BR', 'SP'),
(15376, 31, 509, 'Panorama', 'BR', 'SP'),
(15377, 31, 509, 'Paraguaçu Paulista', 'BR', 'SP'),
(15378, 31, 509, 'Paraibuna', 'BR', 'SP'),
(15379, 31, 509, 'Paraíso', 'BR', 'SP'),
(15380, 31, 509, 'Paranapanema', 'BR', 'SP'),
(15381, 31, 509, 'Paranapuã', 'BR', 'SP'),
(15382, 31, 509, 'Parapuã', 'BR', 'SP'),
(15383, 31, 509, 'Pardinho', 'BR', 'SP'),
(15384, 31, 509, 'Pariquera Açu', 'BR', 'SP'),
(15385, 31, 509, 'Pariquera-Açu', 'BR', 'SP'),
(15386, 31, 509, 'Parisi', 'BR', 'SP'),
(15387, 31, 509, 'Patrocínio Paulista', 'BR', 'SP'),
(15388, 31, 509, 'Paulicéia', 'BR', 'SP'),
(15389, 31, 509, 'Paulínia', 'BR', 'SP'),
(15390, 31, 509, 'Paulista Flórida', 'BR', 'SP'),
(15391, 31, 509, 'Paulistânia', 'BR', 'SP'),
(15392, 31, 509, 'Paulo de Faria', 'BR', 'SP'),
(15393, 31, 509, 'Pederneiras', 'BR', 'SP'),
(15394, 31, 509, 'Pedra Bela', 'BR', 'SP'),
(15395, 31, 509, 'Pedranópolis', 'BR', 'SP'),
(15396, 31, 509, 'Pedregulho', 'BR', 'SP'),
(15397, 31, 509, 'Pedreira', 'BR', 'SP'),
(15398, 31, 509, 'Pedrinhas Paulista', 'BR', 'SP'),
(15399, 31, 509, 'Pedro de Toledo', 'BR', 'SP'),
(15400, 31, 509, 'Penápolis', 'BR', 'SP'),
(15401, 31, 509, 'Pereira Barreto', 'BR', 'SP'),
(15402, 31, 509, 'Pereiras', 'BR', 'SP'),
(15403, 31, 509, 'Peruíbe', 'BR', 'SP'),
(15404, 31, 509, 'Piacatu', 'BR', 'SP'),
(15405, 31, 509, 'Piedade', 'BR', 'SP'),
(15406, 31, 509, 'Pilar do Sul', 'BR', 'SP'),
(15407, 31, 509, 'Pindamonhangaba', 'BR', 'SP'),
(15408, 31, 509, 'Pindorama', 'BR', 'SP'),
(15409, 31, 509, 'Pinhalzinho', 'BR', 'SP'),
(15410, 31, 509, 'Piquerobi', 'BR', 'SP'),
(15411, 31, 509, 'Piquete', 'BR', 'SP'),
(15412, 31, 509, 'Piracaia', 'BR', 'SP'),
(15413, 31, 509, 'Piracicaba', 'BR', 'SP'),
(15414, 31, 509, 'Piraju', 'BR', 'SP'),
(15415, 31, 509, 'Pirajuí', 'BR', 'SP'),
(15416, 31, 509, 'Pirangi', 'BR', 'SP'),
(15417, 31, 509, 'Pirapora do Bom Jesus', 'BR', 'SP'),
(15418, 31, 509, 'Pirapozinho', 'BR', 'SP'),
(15419, 31, 509, 'Pirassununga', 'BR', 'SP'),
(15420, 31, 509, 'Piratininga', 'BR', 'SP'),
(15421, 31, 509, 'Pitangueiras', 'BR', 'SP'),
(15422, 31, 509, 'Planalto', 'BR', 'SP'),
(15423, 31, 509, 'Platina', 'BR', 'SP'),
(15424, 31, 509, 'Poá', 'BR', 'SP'),
(15425, 31, 509, 'Poloni', 'BR', 'SP'),
(15426, 31, 509, 'Pompéia', 'BR', 'SP'),
(15427, 31, 509, 'Pongaí', 'BR', 'SP'),
(15428, 31, 509, 'Pontal', 'BR', 'SP'),
(15429, 31, 509, 'Pontalinda', 'BR', 'SP'),
(15430, 31, 509, 'Pontes Gestal', 'BR', 'SP'),
(15431, 31, 509, 'Populina', 'BR', 'SP'),
(15432, 31, 509, 'Porangaba', 'BR', 'SP'),
(15433, 31, 509, 'Porto Feliz', 'BR', 'SP'),
(15434, 31, 509, 'Porto Ferreira', 'BR', 'SP'),
(15435, 31, 509, 'Potim', 'BR', 'SP'),
(15436, 31, 509, 'Potirendaba', 'BR', 'SP'),
(15437, 31, 509, 'Pracinha', 'BR', 'SP'),
(15438, 31, 509, 'Pradópolis', 'BR', 'SP'),
(15439, 31, 509, 'Praia Grande', 'BR', 'SP'),
(15440, 31, 509, 'Pratânia', 'BR', 'SP'),
(15441, 31, 509, 'Presidente Alves', 'BR', 'SP'),
(15442, 31, 509, 'Presidente Bernardes', 'BR', 'SP'),
(15443, 31, 509, 'Presidente Epitácio', 'BR', 'SP'),
(15444, 31, 509, 'Presidente Prudente', 'BR', 'SP'),
(15445, 31, 509, 'Presidente Venceslau', 'BR', 'SP'),
(15446, 31, 509, 'Promissão', 'BR', 'SP'),
(15447, 31, 509, 'Quadra', 'BR', 'SP'),
(15448, 31, 509, 'Quatá', 'BR', 'SP'),
(15449, 31, 509, 'Queiroz', 'BR', 'SP'),
(15450, 31, 509, 'Queluz', 'BR', 'SP'),
(15451, 31, 509, 'Quintana', 'BR', 'SP'),
(15452, 31, 509, 'Rafard', 'BR', 'SP'),
(15453, 31, 509, 'Rancharia', 'BR', 'SP'),
(15454, 31, 509, 'Redenção da Serra', 'BR', 'SP'),
(15455, 31, 509, 'Regente Feijó', 'BR', 'SP'),
(15456, 31, 509, 'Reginópolis', 'BR', 'SP'),
(15457, 31, 509, 'Registro', 'BR', 'SP'),
(15458, 31, 509, 'Restinga', 'BR', 'SP'),
(15459, 31, 509, 'Ribeira', 'BR', 'SP'),
(15460, 31, 509, 'Ribeirão Bonito', 'BR', 'SP'),
(15461, 31, 509, 'Ribeirão Branco', 'BR', 'SP'),
(15462, 31, 509, 'Ribeirão Corrente', 'BR', 'SP'),
(15463, 31, 509, 'Ribeirão do Sul', 'BR', 'SP'),
(15464, 31, 509, 'Ribeirão dos Índios', 'BR', 'SP'),
(15465, 31, 509, 'Ribeirão Grande', 'BR', 'SP'),
(15466, 31, 509, 'Ribeirão Pires', 'BR', 'SP'),
(15467, 31, 509, 'Ribeirão Preto', 'BR', 'SP'),
(15468, 31, 509, 'Rifaina', 'BR', 'SP'),
(15469, 31, 509, 'Rincão', 'BR', 'SP'),
(15470, 31, 509, 'Rinópolis', 'BR', 'SP'),
(15471, 31, 509, 'Rio Claro', 'BR', 'SP'),
(15472, 31, 509, 'Rio das Pedras', 'BR', 'SP'),
(15473, 31, 509, 'Rio Grande da Serra', 'BR', 'SP'),
(15474, 31, 509, 'Riolândia', 'BR', 'SP'),
(15475, 31, 509, 'Riversul', 'BR', 'SP'),
(15476, 31, 509, 'Rosana', 'BR', 'SP'),
(15477, 31, 509, 'Roseira', 'BR', 'SP'),
(15478, 31, 509, 'Rubiácea', 'BR', 'SP'),
(15479, 31, 509, 'Rubinéia', 'BR', 'SP'),
(15480, 31, 509, 'Sabino', 'BR', 'SP'),
(15481, 31, 509, 'Sagres', 'BR', 'SP'),
(15482, 31, 509, 'Sales', 'BR', 'SP'),
(15483, 31, 509, 'Sales Oliveira', 'BR', 'SP'),
(15484, 31, 509, 'Salesópolis', 'BR', 'SP'),
(15485, 31, 509, 'Salmourão', 'BR', 'SP'),
(15486, 31, 509, 'Saltinho', 'BR', 'SP'),
(15487, 31, 509, 'Salto', 'BR', 'SP'),
(15488, 31, 509, 'Salto de Pirapora', 'BR', 'SP'),
(15489, 31, 509, 'Salto Grande', 'BR', 'SP'),
(15490, 31, 509, 'Sandovalina', 'BR', 'SP'),
(15491, 31, 509, 'Santa Adélia', 'BR', 'SP'),
(15492, 31, 509, 'Santa Albertina', 'BR', 'SP'),
(15493, 31, 509, 'Santa Bárbara d\'Oeste', 'BR', 'SP'),
(15494, 31, 509, 'Santa Branca', 'BR', 'SP'),
(15495, 31, 509, 'Santa Clara d\'Oeste', 'BR', 'SP'),
(15496, 31, 509, 'Santa Cruz da Conceição', 'BR', 'SP'),
(15497, 31, 509, 'Santa Cruz da Esperança', 'BR', 'SP'),
(15498, 31, 509, 'Santa Cruz das Palmeiras', 'BR', 'SP'),
(15499, 31, 509, 'Santa Cruz do Rio Pardo', 'BR', 'SP'),
(15500, 31, 509, 'Santa Ernestina', 'BR', 'SP');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(15501, 31, 509, 'Santa Fé do Sul', 'BR', 'SP'),
(15502, 31, 509, 'Santa Gertrudes', 'BR', 'SP'),
(15503, 31, 509, 'Santa Isabel', 'BR', 'SP'),
(15504, 31, 509, 'Santa Lúcia', 'BR', 'SP'),
(15505, 31, 509, 'Santa Maria da Serra', 'BR', 'SP'),
(15506, 31, 509, 'Santa Mercedes', 'BR', 'SP'),
(15507, 31, 509, 'Santa Rita d\'Oeste', 'BR', 'SP'),
(15508, 31, 509, 'Santa Rita do Passa Quatro', 'BR', 'SP'),
(15509, 31, 509, 'Santa Rosa de Viterbo', 'BR', 'SP'),
(15510, 31, 509, 'Santa Salete', 'BR', 'SP'),
(15511, 31, 509, 'Santana da Ponte Pensa', 'BR', 'SP'),
(15512, 31, 509, 'Santana de Parnaíba', 'BR', 'SP'),
(15513, 31, 509, 'Santo Anastácio', 'BR', 'SP'),
(15514, 31, 509, 'Santo André', 'BR', 'SP'),
(15515, 31, 509, 'Santo Antônio da Alegria', 'BR', 'SP'),
(15516, 31, 509, 'Santo Antônio de Posse', 'BR', 'SP'),
(15517, 31, 509, 'Santo Antônio do Aracanguá', 'BR', 'SP'),
(15518, 31, 509, 'Santo Antônio do Jardim', 'BR', 'SP'),
(15519, 31, 509, 'Santo Antônio do Pinhal', 'BR', 'SP'),
(15520, 31, 509, 'Santo Expedito', 'BR', 'SP'),
(15521, 31, 509, 'Santópolis do Aguapeí', 'BR', 'SP'),
(15522, 31, 509, 'Santos', 'BR', 'SP'),
(15523, 31, 509, 'São Bento do Sapucaí', 'BR', 'SP'),
(15524, 31, 509, 'São Bernardo do Campo', 'BR', 'SP'),
(15525, 31, 509, 'São Caetano do Sul', 'BR', 'SP'),
(15526, 31, 509, 'São Carlos', 'BR', 'SP'),
(15527, 31, 509, 'São Francisco', 'BR', 'SP'),
(15528, 31, 509, 'São João da Boa Vista', 'BR', 'SP'),
(15529, 31, 509, 'São João das Duas Pontes', 'BR', 'SP'),
(15530, 31, 509, 'São João de Iracema', 'BR', 'SP'),
(15531, 31, 509, 'São João do Pau d\'Alho', 'BR', 'SP'),
(15532, 31, 509, 'São Joaquim da Barra', 'BR', 'SP'),
(15533, 31, 509, 'São José da Bela Vista', 'BR', 'SP'),
(15534, 31, 509, 'São José do Barreiro', 'BR', 'SP'),
(15535, 31, 509, 'São José do Rio Pardo', 'BR', 'SP'),
(15536, 31, 509, 'São José do Rio Preto', 'BR', 'SP'),
(15537, 31, 509, 'São José dos Campos', 'BR', 'SP'),
(15538, 31, 509, 'São Lourenço da Serra', 'BR', 'SP'),
(15539, 31, 509, 'São Luiz do Paraitinga', 'BR', 'SP'),
(15540, 31, 509, 'São Manuel', 'BR', 'SP'),
(15541, 31, 509, 'São Miguel Arcanjo', 'BR', 'SP'),
(15542, 31, 509, 'São Paulo', 'BR', 'SP'),
(15543, 31, 509, 'São Pedro', 'BR', 'SP'),
(15544, 31, 509, 'São Pedro do Turvo', 'BR', 'SP'),
(15545, 31, 509, 'São Roque', 'BR', 'SP'),
(15546, 31, 509, 'São Sebastião', 'BR', 'SP'),
(15547, 31, 509, 'São Sebastião da Grama', 'BR', 'SP'),
(15548, 31, 509, 'São Simão', 'BR', 'SP'),
(15549, 31, 509, 'São Vicente', 'BR', 'SP'),
(15550, 31, 509, 'Sarapuí', 'BR', 'SP'),
(15551, 31, 509, 'Sarutaiá', 'BR', 'SP'),
(15552, 31, 509, 'Sebastianópolis do Sul', 'BR', 'SP'),
(15553, 31, 509, 'Serra Azul', 'BR', 'SP'),
(15554, 31, 509, 'Serra Negra', 'BR', 'SP'),
(15555, 31, 509, 'Serrana', 'BR', 'SP'),
(15556, 31, 509, 'Sertãozinho', 'BR', 'SP'),
(15557, 31, 509, 'Sete Barras', 'BR', 'SP'),
(15558, 31, 509, 'Severínia', 'BR', 'SP'),
(15559, 31, 509, 'Silveiras', 'BR', 'SP'),
(15560, 31, 509, 'Socorro', 'BR', 'SP'),
(15561, 31, 509, 'Sorocaba', 'BR', 'SP'),
(15562, 31, 509, 'Sud Mennucci', 'BR', 'SP'),
(15563, 31, 509, 'Sumaré', 'BR', 'SP'),
(15564, 31, 509, 'Suzanápolis', 'BR', 'SP'),
(15565, 31, 509, 'Suzano', 'BR', 'SP'),
(15566, 31, 509, 'Tabapuã', 'BR', 'SP'),
(15567, 31, 509, 'Tabatinga', 'BR', 'SP'),
(15568, 31, 509, 'Taboão da Serra', 'BR', 'SP'),
(15569, 31, 509, 'Taciba', 'BR', 'SP'),
(15570, 31, 509, 'Taguaí', 'BR', 'SP'),
(15571, 31, 509, 'Taiaçu', 'BR', 'SP'),
(15572, 31, 509, 'Taiúva', 'BR', 'SP'),
(15573, 31, 509, 'Tambaú', 'BR', 'SP'),
(15574, 31, 509, 'Tanabi', 'BR', 'SP'),
(15575, 31, 509, 'Tapiraí', 'BR', 'SP'),
(15576, 31, 509, 'Tapiratiba', 'BR', 'SP'),
(15577, 31, 509, 'Taquaral', 'BR', 'SP'),
(15578, 31, 509, 'Taquaritinga', 'BR', 'SP'),
(15579, 31, 509, 'Taquarituba', 'BR', 'SP'),
(15580, 31, 509, 'Taquarivaí', 'BR', 'SP'),
(15581, 31, 509, 'Tarabai', 'BR', 'SP'),
(15582, 31, 509, 'Tarumã', 'BR', 'SP'),
(15583, 31, 509, 'Tatuí', 'BR', 'SP'),
(15584, 31, 509, 'Taubaté', 'BR', 'SP'),
(15585, 31, 509, 'Tejupá', 'BR', 'SP'),
(15586, 31, 509, 'Teodoro Sampaio', 'BR', 'SP'),
(15587, 31, 509, 'Terra Roxa', 'BR', 'SP'),
(15588, 31, 509, 'Tietê', 'BR', 'SP'),
(15589, 31, 509, 'Timburi', 'BR', 'SP'),
(15590, 31, 509, 'Torre de Pedra', 'BR', 'SP'),
(15591, 31, 509, 'Torrinha', 'BR', 'SP'),
(15592, 31, 509, 'Trabiju', 'BR', 'SP'),
(15593, 31, 509, 'Tremembé', 'BR', 'SP'),
(15594, 31, 509, 'Três Fronteiras', 'BR', 'SP'),
(15595, 31, 509, 'Tuiuti', 'BR', 'SP'),
(15596, 31, 509, 'Tupã', 'BR', 'SP'),
(15597, 31, 509, 'Tupi Paulista', 'BR', 'SP'),
(15598, 31, 509, 'Turiúba', 'BR', 'SP'),
(15599, 31, 509, 'Turmalina', 'BR', 'SP'),
(15600, 31, 509, 'Ubarana', 'BR', 'SP'),
(15601, 31, 509, 'Ubatuba', 'BR', 'SP'),
(15602, 31, 509, 'Ubirajara', 'BR', 'SP'),
(15603, 31, 509, 'Uchoa', 'BR', 'SP'),
(15604, 31, 509, 'União Paulista', 'BR', 'SP'),
(15605, 31, 509, 'Urânia', 'BR', 'SP'),
(15606, 31, 509, 'Uru', 'BR', 'SP'),
(15607, 31, 509, 'Urupês', 'BR', 'SP'),
(15608, 31, 509, 'Valentim Gentil', 'BR', 'SP'),
(15609, 31, 509, 'Valinhos', 'BR', 'SP'),
(15610, 31, 509, 'Valparaíso', 'BR', 'SP'),
(15611, 31, 509, 'Vargem', 'BR', 'SP'),
(15612, 31, 509, 'Vargem Grande do Sul', 'BR', 'SP'),
(15613, 31, 509, 'Vargem Grande Paulista', 'BR', 'SP'),
(15614, 31, 509, 'Várzea Paulista', 'BR', 'SP'),
(15615, 31, 509, 'Vera Cruz', 'BR', 'SP'),
(15616, 31, 509, 'Vinhedo', 'BR', 'SP'),
(15617, 31, 509, 'Viradouro', 'BR', 'SP'),
(15618, 31, 509, 'Vista Alegre do Alto', 'BR', 'SP'),
(15619, 31, 509, 'Vitória Brasil', 'BR', 'SP'),
(15620, 31, 509, 'Votorantim', 'BR', 'SP'),
(15621, 31, 509, 'Votuporanga', 'BR', 'SP'),
(15622, 31, 509, 'Zacarias', 'BR', 'SP'),
(15623, 31, 510, 'Amparo de São Francisco', 'BR', 'SE'),
(15624, 31, 510, 'Aquidabã', 'BR', 'SE'),
(15625, 31, 510, 'Aracaju', 'BR', 'SE'),
(15626, 31, 510, 'Arauá', 'BR', 'SE'),
(15627, 31, 510, 'Areia Branca', 'BR', 'SE'),
(15628, 31, 510, 'Barra dos Coqueiros', 'BR', 'SE'),
(15629, 31, 510, 'Boquim', 'BR', 'SE'),
(15630, 31, 510, 'Brejo Grande', 'BR', 'SE'),
(15631, 31, 510, 'Campo do Brito', 'BR', 'SE'),
(15632, 31, 510, 'Canhoba', 'BR', 'SE'),
(15633, 31, 510, 'Canindé de São Francisco', 'BR', 'SE'),
(15634, 31, 510, 'Capela', 'BR', 'SE'),
(15635, 31, 510, 'Carira', 'BR', 'SE'),
(15636, 31, 510, 'Carmópolis', 'BR', 'SE'),
(15637, 31, 510, 'Cedro de São João', 'BR', 'SE'),
(15638, 31, 510, 'Cristinápolis', 'BR', 'SE'),
(15639, 31, 510, 'Cumbe', 'BR', 'SE'),
(15640, 31, 510, 'Divina Pastora', 'BR', 'SE'),
(15641, 31, 510, 'Estância', 'BR', 'SE'),
(15642, 31, 510, 'Feira Nova', 'BR', 'SE'),
(15643, 31, 510, 'Frei Paulo', 'BR', 'SE'),
(15644, 31, 510, 'Gararu', 'BR', 'SE'),
(15645, 31, 510, 'General Maynard', 'BR', 'SE'),
(15646, 31, 510, 'Gracho Cardoso', 'BR', 'SE'),
(15647, 31, 510, 'Ilha das Flores', 'BR', 'SE'),
(15648, 31, 510, 'Indiaroba', 'BR', 'SE'),
(15649, 31, 510, 'Itabaiana', 'BR', 'SE'),
(15650, 31, 510, 'Itabaianinha', 'BR', 'SE'),
(15651, 31, 510, 'Itabi', 'BR', 'SE'),
(15652, 31, 510, 'Itaporanga d\'Ajuda', 'BR', 'SE'),
(15653, 31, 510, 'Japaratuba', 'BR', 'SE'),
(15654, 31, 510, 'Japoatã', 'BR', 'SE'),
(15655, 31, 510, 'Lagarto', 'BR', 'SE'),
(15656, 31, 510, 'Laranjeiras', 'BR', 'SE'),
(15657, 31, 510, 'Macambira', 'BR', 'SE'),
(15658, 31, 510, 'Malhada dos Bois', 'BR', 'SE'),
(15659, 31, 510, 'Malhador', 'BR', 'SE'),
(15660, 31, 510, 'Maruim', 'BR', 'SE'),
(15661, 31, 510, 'Moita Bonita', 'BR', 'SE'),
(15662, 31, 510, 'Monte Alegre de Sergipe', 'BR', 'SE'),
(15663, 31, 510, 'Muribeca', 'BR', 'SE'),
(15664, 31, 510, 'Neópolis', 'BR', 'SE'),
(15665, 31, 510, 'Nossa Senhora Aparecida', 'BR', 'SE'),
(15666, 31, 510, 'Nossa Senhora da Glória', 'BR', 'SE'),
(15667, 31, 510, 'Nossa Senhora das Dores', 'BR', 'SE'),
(15668, 31, 510, 'Nossa Senhora de Lourdes', 'BR', 'SE'),
(15669, 31, 510, 'Nossa Senhora do Socorro', 'BR', 'SE'),
(15670, 31, 510, 'Pacatuba', 'BR', 'SE'),
(15671, 31, 510, 'Pedra Mole', 'BR', 'SE'),
(15672, 31, 510, 'Pedrinhas', 'BR', 'SE'),
(15673, 31, 510, 'Pinhão', 'BR', 'SE'),
(15674, 31, 510, 'Pirambu', 'BR', 'SE'),
(15675, 31, 510, 'Poço Redondo', 'BR', 'SE'),
(15676, 31, 510, 'Poço Verde', 'BR', 'SE'),
(15677, 31, 510, 'Porto da Folha', 'BR', 'SE'),
(15678, 31, 510, 'Propriá', 'BR', 'SE'),
(15679, 31, 510, 'Riachão do Dantas', 'BR', 'SE'),
(15680, 31, 510, 'Riachuelo', 'BR', 'SE'),
(15681, 31, 510, 'Ribeirópolis', 'BR', 'SE'),
(15682, 31, 510, 'Rosário do Catete', 'BR', 'SE'),
(15683, 31, 510, 'Salgado', 'BR', 'SE'),
(15684, 31, 510, 'Santa Luzia do Itanhy', 'BR', 'SE'),
(15685, 31, 510, 'Santa Rosa de Lima', 'BR', 'SE'),
(15686, 31, 510, 'Santana do São Francisco', 'BR', 'SE'),
(15687, 31, 510, 'Santo Amaro das Brotas', 'BR', 'SE'),
(15688, 31, 510, 'São Cristóvão', 'BR', 'SE'),
(15689, 31, 510, 'São Domingos', 'BR', 'SE'),
(15690, 31, 510, 'São Francisco', 'BR', 'SE'),
(15691, 31, 510, 'São Miguel do Aleixo', 'BR', 'SE'),
(15692, 31, 510, 'Simão Dias', 'BR', 'SE'),
(15693, 31, 510, 'Siriri', 'BR', 'SE'),
(15694, 31, 510, 'Telha', 'BR', 'SE'),
(15695, 31, 510, 'Tobias Barreto', 'BR', 'SE'),
(15696, 31, 510, 'Tomar do Geru', 'BR', 'SE'),
(15697, 31, 510, 'Umbaúba', 'BR', 'SE'),
(15698, 31, 511, 'Abreulândia', 'BR', 'TO'),
(15699, 31, 511, 'Aguiarnópolis', 'BR', 'TO'),
(15700, 31, 511, 'Aliança do Tocantins', 'BR', 'TO'),
(15701, 31, 511, 'Almas', 'BR', 'TO'),
(15702, 31, 511, 'Alvorada', 'BR', 'TO'),
(15703, 31, 511, 'Ananás', 'BR', 'TO'),
(15704, 31, 511, 'Angico', 'BR', 'TO'),
(15705, 31, 511, 'Aparecida do Rio Negro', 'BR', 'TO'),
(15706, 31, 511, 'Aragominas', 'BR', 'TO'),
(15707, 31, 511, 'Araguacema', 'BR', 'TO'),
(15708, 31, 511, 'Araguaçu', 'BR', 'TO'),
(15709, 31, 511, 'Araguaína', 'BR', 'TO'),
(15710, 31, 511, 'Araguanã', 'BR', 'TO'),
(15711, 31, 511, 'Araguatins', 'BR', 'TO'),
(15712, 31, 511, 'Arapoema', 'BR', 'TO'),
(15713, 31, 511, 'Arraias', 'BR', 'TO'),
(15714, 31, 511, 'Augustinópolis', 'BR', 'TO'),
(15715, 31, 511, 'Aurora do Tocantins', 'BR', 'TO'),
(15716, 31, 511, 'Axixá do Tocantins', 'BR', 'TO'),
(15717, 31, 511, 'Babaçulândia', 'BR', 'TO'),
(15718, 31, 511, 'Bandeirantes do Tocantins', 'BR', 'TO'),
(15719, 31, 511, 'Barra do Ouro', 'BR', 'TO'),
(15720, 31, 511, 'Barrolândia', 'BR', 'TO'),
(15721, 31, 511, 'Bernardo Sayão', 'BR', 'TO'),
(15722, 31, 511, 'Bom Jesus do Tocantins', 'BR', 'TO'),
(15723, 31, 511, 'Brasilândia do Tocantins', 'BR', 'TO'),
(15724, 31, 511, 'Brejinho de Nazaré', 'BR', 'TO'),
(15725, 31, 511, 'Buriti do Tocantins', 'BR', 'TO'),
(15726, 31, 511, 'Cachoeirinha', 'BR', 'TO'),
(15727, 31, 511, 'Campos Lindos', 'BR', 'TO'),
(15728, 31, 511, 'Cariri do Tocantins', 'BR', 'TO'),
(15729, 31, 511, 'Carmolândia', 'BR', 'TO'),
(15730, 31, 511, 'Carrasco Bonito', 'BR', 'TO'),
(15731, 31, 511, 'Caseara', 'BR', 'TO'),
(15732, 31, 511, 'Centenário', 'BR', 'TO'),
(15733, 31, 511, 'Chapada da Natividade', 'BR', 'TO'),
(15734, 31, 511, 'Chapada de Areia', 'BR', 'TO'),
(15735, 31, 511, 'Colinas do Tocantins', 'BR', 'TO'),
(15736, 31, 511, 'Colméia', 'BR', 'TO'),
(15737, 31, 511, 'Combinado', 'BR', 'TO'),
(15738, 31, 511, 'Conceição do Tocantins', 'BR', 'TO'),
(15739, 31, 511, 'Couto Magalhães', 'BR', 'TO'),
(15740, 31, 511, 'Cristalândia', 'BR', 'TO'),
(15741, 31, 511, 'Crixás do Tocantins', 'BR', 'TO'),
(15742, 31, 511, 'Darcinópolis', 'BR', 'TO'),
(15743, 31, 511, 'Dianópolis', 'BR', 'TO'),
(15744, 31, 511, 'Divinópolis do Tocantins', 'BR', 'TO'),
(15745, 31, 511, 'Dois Irmãos do Tocantins', 'BR', 'TO'),
(15746, 31, 511, 'Dueré', 'BR', 'TO'),
(15747, 31, 511, 'Esperantina', 'BR', 'TO'),
(15748, 31, 511, 'Fátima', 'BR', 'TO'),
(15749, 31, 511, 'Figueirópolis', 'BR', 'TO'),
(15750, 31, 511, 'Filadélfia', 'BR', 'TO'),
(15751, 31, 511, 'Formoso do Araguaia', 'BR', 'TO'),
(15752, 31, 511, 'Fortaleza do Tabocão', 'BR', 'TO'),
(15753, 31, 511, 'Goianorte', 'BR', 'TO'),
(15754, 31, 511, 'Goiatins', 'BR', 'TO'),
(15755, 31, 511, 'Guaraí', 'BR', 'TO'),
(15756, 31, 511, 'Gurupi', 'BR', 'TO'),
(15757, 31, 511, 'Ipueiras', 'BR', 'TO'),
(15758, 31, 511, 'Itacajá', 'BR', 'TO'),
(15759, 31, 511, 'Itaguatins', 'BR', 'TO'),
(15760, 31, 511, 'Itapiratins', 'BR', 'TO'),
(15761, 31, 511, 'Itaporã do Tocantins', 'BR', 'TO'),
(15762, 31, 511, 'Jaú do Tocantins', 'BR', 'TO'),
(15763, 31, 511, 'Juarina', 'BR', 'TO'),
(15764, 31, 511, 'Lagoa da Confusão', 'BR', 'TO'),
(15765, 31, 511, 'Lagoa do Tocantins', 'BR', 'TO'),
(15766, 31, 511, 'Lajeado', 'BR', 'TO'),
(15767, 31, 511, 'Lavandeira', 'BR', 'TO'),
(15768, 31, 511, 'Lizarda', 'BR', 'TO'),
(15769, 31, 511, 'Luzinópolis', 'BR', 'TO'),
(15770, 31, 511, 'Marianópolis do Tocantins', 'BR', 'TO'),
(15771, 31, 511, 'Mateiros', 'BR', 'TO'),
(15772, 31, 511, 'Maurilândia do Tocantins', 'BR', 'TO'),
(15773, 31, 511, 'Miracema do Tocantins', 'BR', 'TO'),
(15774, 31, 511, 'Miranorte', 'BR', 'TO'),
(15775, 31, 511, 'Monte do Carmo', 'BR', 'TO'),
(15776, 31, 511, 'Monte Santo do Tocantins', 'BR', 'TO'),
(15777, 31, 511, 'Muricilândia', 'BR', 'TO'),
(15778, 31, 511, 'Natividade', 'BR', 'TO'),
(15779, 31, 511, 'Nazaré', 'BR', 'TO'),
(15780, 31, 511, 'Nova Olinda', 'BR', 'TO'),
(15781, 31, 511, 'Nova Rosalândia', 'BR', 'TO'),
(15782, 31, 511, 'Novo Acordo', 'BR', 'TO'),
(15783, 31, 511, 'Novo Alegre', 'BR', 'TO'),
(15784, 31, 511, 'Novo Jardim', 'BR', 'TO'),
(15785, 31, 511, 'Oliveira de Fátima', 'BR', 'TO'),
(15786, 31, 511, 'Palmas', 'BR', 'TO'),
(15787, 31, 511, 'Palmeirante', 'BR', 'TO'),
(15788, 31, 511, 'Palmeiras do Tocantins', 'BR', 'TO'),
(15789, 31, 511, 'Palmeirópolis', 'BR', 'TO'),
(15790, 31, 511, 'Paraíso do Tocantins', 'BR', 'TO'),
(15791, 31, 511, 'Paranã', 'BR', 'TO'),
(15792, 31, 511, 'Pau d\'Arco', 'BR', 'TO'),
(15793, 31, 511, 'Pedro Afonso', 'BR', 'TO'),
(15794, 31, 511, 'Peixe', 'BR', 'TO'),
(15795, 31, 511, 'Pequizeiro', 'BR', 'TO'),
(15796, 31, 511, 'Pindorama do Tocantins', 'BR', 'TO'),
(15797, 31, 511, 'Piraquê', 'BR', 'TO'),
(15798, 31, 511, 'Pium', 'BR', 'TO'),
(15799, 31, 511, 'Ponte Alta do Bom Jesus', 'BR', 'TO'),
(15800, 31, 511, 'Ponte Alta do Tocantins', 'BR', 'TO'),
(15801, 31, 511, 'Porto Alegre do Tocantins', 'BR', 'TO'),
(15802, 31, 511, 'Porto Nacional', 'BR', 'TO'),
(15803, 31, 511, 'Praia Norte', 'BR', 'TO'),
(15804, 31, 511, 'Presidente Kennedy', 'BR', 'TO'),
(15805, 31, 511, 'Pugmil', 'BR', 'TO'),
(15806, 31, 511, 'Recursolândia', 'BR', 'TO'),
(15807, 31, 511, 'Riachinho', 'BR', 'TO'),
(15808, 31, 511, 'Rio da Conceição', 'BR', 'TO'),
(15809, 31, 511, 'Rio dos Bois', 'BR', 'TO'),
(15810, 31, 511, 'Rio Sono', 'BR', 'TO'),
(15811, 31, 511, 'Sampaio', 'BR', 'TO'),
(15812, 31, 511, 'Sandolândia', 'BR', 'TO'),
(15813, 31, 511, 'Santa Fé do Araguaia', 'BR', 'TO'),
(15814, 31, 511, 'Santa Maria do Tocantins', 'BR', 'TO'),
(15815, 31, 511, 'Santa Rita do Tocantins', 'BR', 'TO'),
(15816, 31, 511, 'Santa Rosa do Tocantins', 'BR', 'TO'),
(15817, 31, 511, 'Santa Tereza do Tocantins', 'BR', 'TO'),
(15818, 31, 511, 'Santa Terezinha do Tocantins', 'BR', 'TO'),
(15819, 31, 511, 'São Bento do Tocantins', 'BR', 'TO'),
(15820, 31, 511, 'São Félix do Tocantins', 'BR', 'TO'),
(15821, 31, 511, 'São Miguel do Tocantins', 'BR', 'TO'),
(15822, 31, 511, 'São Salvador do Tocantins', 'BR', 'TO'),
(15823, 31, 511, 'São Sebastião do Tocantins', 'BR', 'TO'),
(15824, 31, 511, 'São Valério', 'BR', 'TO'),
(15825, 31, 511, 'Silvanópolis', 'BR', 'TO'),
(15826, 31, 511, 'Sítio Novo do Tocantins', 'BR', 'TO'),
(15827, 31, 511, 'Sucupira', 'BR', 'TO'),
(15828, 31, 511, 'Taguatinga', 'BR', 'TO'),
(15829, 31, 511, 'Taipas do Tocantins', 'BR', 'TO'),
(15830, 31, 511, 'Talismã', 'BR', 'TO'),
(15831, 31, 511, 'Tocantínia', 'BR', 'TO'),
(15832, 31, 511, 'Tocantinópolis', 'BR', 'TO'),
(15833, 31, 511, 'Tupirama', 'BR', 'TO'),
(15834, 31, 511, 'Tupiratins', 'BR', 'TO'),
(15835, 31, 511, 'Wanderlândia', 'BR', 'TO'),
(15836, 31, 511, 'Xambioá', 'BR', 'TO'),
(15837, 33, 512, 'Kuala Belait', 'BN', 'BE'),
(15838, 33, 512, 'Seria', 'BN', 'BE'),
(15839, 33, 513, 'Bandar Seri Begawan', 'BN', 'BM'),
(15840, 33, 513, 'Berakas A', 'BN', 'BM'),
(15841, 33, 513, 'Kapok', 'BN', 'BM'),
(15842, 33, 513, 'Mentiri', 'BN', 'BM'),
(15843, 33, 513, 'Serasa', 'BN', 'BM'),
(15844, 33, 514, 'Bangar', 'BN', 'TE'),
(15845, 33, 515, 'Tutong', 'BN', 'TU'),
(15846, 34, 516, 'Bansko', 'BG', '01'),
(15847, 34, 516, 'Belitsa', 'BG', '01'),
(15848, 34, 516, 'Blagoevgrad', 'BG', '01'),
(15849, 34, 516, 'Garmen', 'BG', '01'),
(15850, 34, 516, 'Gotse Delchev', 'BG', '01'),
(15851, 34, 516, 'Hadzhidimovo', 'BG', '01'),
(15852, 34, 516, 'Kolarovo', 'BG', '01'),
(15853, 34, 516, 'Kresna', 'BG', '01'),
(15854, 34, 516, 'Obshtina Bansko', 'BG', '01'),
(15855, 34, 516, 'Obshtina Belitsa', 'BG', '01'),
(15856, 34, 516, 'Obshtina Blagoevgrad', 'BG', '01'),
(15857, 34, 516, 'Obshtina Garmen', 'BG', '01'),
(15858, 34, 516, 'Obshtina Gotse Delchev', 'BG', '01'),
(15859, 34, 516, 'Obshtina Kresna', 'BG', '01'),
(15860, 34, 516, 'Obshtina Petrich', 'BG', '01'),
(15861, 34, 516, 'Obshtina Razlog', 'BG', '01'),
(15862, 34, 516, 'Obshtina Sandanski', 'BG', '01'),
(15863, 34, 516, 'Obshtina Satovcha', 'BG', '01'),
(15864, 34, 516, 'Obshtina Simitli', 'BG', '01'),
(15865, 34, 516, 'Obshtina Strumyani', 'BG', '01'),
(15866, 34, 516, 'Obshtina Yakoruda', 'BG', '01'),
(15867, 34, 516, 'Petrich', 'BG', '01'),
(15868, 34, 516, 'Razlog', 'BG', '01'),
(15869, 34, 516, 'Sandanski', 'BG', '01'),
(15870, 34, 516, 'Satovcha', 'BG', '01'),
(15871, 34, 516, 'Simitli', 'BG', '01'),
(15872, 34, 516, 'Stara Kresna', 'BG', '01'),
(15873, 34, 516, 'Strumyani', 'BG', '01'),
(15874, 34, 516, 'Yakoruda', 'BG', '01'),
(15875, 34, 517, 'Aheloy', 'BG', '02'),
(15876, 34, 517, 'Ahtopol', 'BG', '02'),
(15877, 34, 517, 'Aytos', 'BG', '02'),
(15878, 34, 517, 'Bata', 'BG', '02'),
(15879, 34, 517, 'Burgas', 'BG', '02'),
(15880, 34, 517, 'Chernomorets', 'BG', '02'),
(15881, 34, 517, 'Kameno', 'BG', '02'),
(15882, 34, 517, 'Karnobat', 'BG', '02'),
(15883, 34, 517, 'Kiten', 'BG', '02'),
(15884, 34, 517, 'Malko Tarnovo', 'BG', '02'),
(15885, 34, 517, 'Nesebar', 'BG', '02'),
(15886, 34, 517, 'Obshtina Aytos', 'BG', '02'),
(15887, 34, 517, 'Obshtina Burgas', 'BG', '02'),
(15888, 34, 517, 'Obshtina Kameno', 'BG', '02'),
(15889, 34, 517, 'Obshtina Karnobat', 'BG', '02'),
(15890, 34, 517, 'Obshtina Malko Tarnovo', 'BG', '02'),
(15891, 34, 517, 'Obshtina Nesebar', 'BG', '02'),
(15892, 34, 517, 'Obshtina Pomorie', 'BG', '02'),
(15893, 34, 517, 'Obshtina Primorsko', 'BG', '02'),
(15894, 34, 517, 'Obshtina Sozopol', 'BG', '02'),
(15895, 34, 517, 'Obshtina Sungurlare', 'BG', '02'),
(15896, 34, 517, 'Obzor', 'BG', '02'),
(15897, 34, 517, 'Pomorie', 'BG', '02'),
(15898, 34, 517, 'Primorsko', 'BG', '02'),
(15899, 34, 517, 'Ravda', 'BG', '02'),
(15900, 34, 517, 'Ruen', 'BG', '02'),
(15901, 34, 517, 'Sarafovo', 'BG', '02'),
(15902, 34, 517, 'Sozopol', 'BG', '02'),
(15903, 34, 517, 'Sredets', 'BG', '02'),
(15904, 34, 517, 'Sungurlare', 'BG', '02'),
(15905, 34, 517, 'Sveti Vlas', 'BG', '02'),
(15906, 34, 517, 'Tsarevo', 'BG', '02'),
(15907, 34, 518, 'Balchik', 'BG', '08'),
(15908, 34, 518, 'Dobrich', 'BG', '08'),
(15909, 34, 518, 'General Toshevo', 'BG', '08'),
(15910, 34, 518, 'Kavarna', 'BG', '08'),
(15911, 34, 518, 'Krushari', 'BG', '08'),
(15912, 34, 518, 'Obshtina Balchik', 'BG', '08'),
(15913, 34, 518, 'Obshtina Dobrich', 'BG', '08'),
(15914, 34, 518, 'Obshtina Dobrich-Selska', 'BG', '08'),
(15915, 34, 518, 'Obshtina General Toshevo', 'BG', '08'),
(15916, 34, 518, 'Obshtina Kavarna', 'BG', '08'),
(15917, 34, 518, 'Obshtina Krushari', 'BG', '08'),
(15918, 34, 518, 'Obshtina Shabla', 'BG', '08'),
(15919, 34, 518, 'Obshtina Tervel', 'BG', '08'),
(15920, 34, 518, 'Shabla', 'BG', '08'),
(15921, 34, 518, 'Tervel', 'BG', '08'),
(15922, 34, 519, 'Dryanovo', 'BG', '07'),
(15923, 34, 519, 'Gabrovo', 'BG', '07'),
(15924, 34, 519, 'Obshtina Dryanovo', 'BG', '07'),
(15925, 34, 519, 'Obshtina Gabrovo', 'BG', '07'),
(15926, 34, 519, 'Obshtina Sevlievo', 'BG', '07'),
(15927, 34, 519, 'Obshtina Tryavna', 'BG', '07'),
(15928, 34, 519, 'Sevlievo', 'BG', '07'),
(15929, 34, 519, 'Tryavna', 'BG', '07'),
(15930, 34, 520, 'Dimitrovgrad', 'BG', '26'),
(15931, 34, 520, 'Harmanli', 'BG', '26'),
(15932, 34, 520, 'Haskovo', 'BG', '26'),
(15933, 34, 520, 'Ivaylovgrad', 'BG', '26'),
(15934, 34, 520, 'Lyubimets', 'BG', '26'),
(15935, 34, 520, 'Madzharovo', 'BG', '26'),
(15936, 34, 520, 'Mineralni Bani', 'BG', '26'),
(15937, 34, 520, 'Obshtina Dimitrovgrad', 'BG', '26'),
(15938, 34, 520, 'Obshtina Harmanli', 'BG', '26'),
(15939, 34, 520, 'Obshtina Haskovo', 'BG', '26'),
(15940, 34, 520, 'Obshtina Ivaylovgrad', 'BG', '26'),
(15941, 34, 520, 'Obshtina Madzharovo', 'BG', '26'),
(15942, 34, 520, 'Obshtina Mineralni Bani', 'BG', '26'),
(15943, 34, 520, 'Obshtina Stambolovo', 'BG', '26'),
(15944, 34, 520, 'Obshtina Svilengrad', 'BG', '26'),
(15945, 34, 520, 'Obshtina Topolovgrad', 'BG', '26'),
(15946, 34, 520, 'Simeonovgrad', 'BG', '26'),
(15947, 34, 520, 'Svilengrad', 'BG', '26'),
(15948, 34, 520, 'Topolovgrad', 'BG', '26'),
(15949, 34, 521, 'Ardino', 'BG', '09'),
(15950, 34, 521, 'Dzhebel', 'BG', '09'),
(15951, 34, 521, 'Kardzhali', 'BG', '09'),
(15952, 34, 521, 'Kirkovo', 'BG', '09'),
(15953, 34, 521, 'Krumovgrad', 'BG', '09'),
(15954, 34, 521, 'Obshtina Ardino', 'BG', '09'),
(15955, 34, 521, 'Obshtina Chernoochene', 'BG', '09'),
(15956, 34, 521, 'Obshtina Dzhebel', 'BG', '09'),
(15957, 34, 521, 'Obshtina Kardzhali', 'BG', '09'),
(15958, 34, 521, 'Obshtina Kirkovo', 'BG', '09'),
(15959, 34, 521, 'Obshtina Momchilgrad', 'BG', '09'),
(15960, 34, 522, 'Boboshevo', 'BG', '10'),
(15961, 34, 522, 'Bobov Dol', 'BG', '10'),
(15962, 34, 522, 'Dupnitsa', 'BG', '10'),
(15963, 34, 522, 'Kocherinovo', 'BG', '10'),
(15964, 34, 522, 'Kyustendil', 'BG', '10'),
(15965, 34, 522, 'Nevestino', 'BG', '10'),
(15966, 34, 522, 'Obshtina Boboshevo', 'BG', '10'),
(15967, 34, 522, 'Obshtina Bobov Dol', 'BG', '10'),
(15968, 34, 522, 'Obshtina Dupnitsa', 'BG', '10'),
(15969, 34, 522, 'Obshtina Kocherinovo', 'BG', '10'),
(15970, 34, 522, 'Obshtina Kyustendil', 'BG', '10'),
(15971, 34, 522, 'Obshtina Nevestino', 'BG', '10'),
(15972, 34, 522, 'Obshtina Rila', 'BG', '10'),
(15973, 34, 522, 'Obshtina Sapareva Banya', 'BG', '10'),
(15974, 34, 522, 'Obshtina Treklyano', 'BG', '10'),
(15975, 34, 522, 'Rila', 'BG', '10'),
(15976, 34, 522, 'Sapareva Banya', 'BG', '10'),
(15977, 34, 523, 'Apriltsi', 'BG', '11'),
(15978, 34, 523, 'Letnitsa', 'BG', '11'),
(15979, 34, 523, 'Lovech', 'BG', '11'),
(15980, 34, 523, 'Lukovit', 'BG', '11'),
(15981, 34, 523, 'Obshtina Lovech', 'BG', '11'),
(15982, 34, 523, 'Obshtina Teteven', 'BG', '11'),
(15983, 34, 523, 'Obshtina Ugarchin', 'BG', '11'),
(15984, 34, 523, 'Teteven', 'BG', '11'),
(15985, 34, 523, 'Troyan', 'BG', '11'),
(15986, 34, 523, 'Ugarchin', 'BG', '11'),
(15987, 34, 523, 'Yablanitsa', 'BG', '11'),
(15988, 34, 524, 'Berkovitsa', 'BG', '12'),
(15989, 34, 524, 'Boychinovtsi', 'BG', '12'),
(15990, 34, 524, 'Brusartsi', 'BG', '12'),
(15991, 34, 524, 'Chiprovtsi', 'BG', '12'),
(15992, 34, 524, 'Lom', 'BG', '12'),
(15993, 34, 524, 'Medkovets', 'BG', '12'),
(15994, 34, 524, 'Montana', 'BG', '12'),
(15995, 34, 524, 'Obshtina Boychinovtsi', 'BG', '12'),
(15996, 34, 524, 'Obshtina Chiprovtsi', 'BG', '12'),
(15997, 34, 524, 'Obshtina Georgi Damyanovo', 'BG', '12'),
(15998, 34, 524, 'Obshtina Lom', 'BG', '12'),
(15999, 34, 524, 'Obshtina Montana', 'BG', '12'),
(16000, 34, 524, 'Obshtina Valchedram', 'BG', '12');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(16001, 34, 524, 'Obshtina Varshets', 'BG', '12'),
(16002, 34, 524, 'Obshtina Yakimovo', 'BG', '12'),
(16003, 34, 524, 'Valchedram', 'BG', '12'),
(16004, 34, 524, 'Varshets', 'BG', '12'),
(16005, 34, 524, 'Yakimovo', 'BG', '12'),
(16006, 34, 525, 'Batak', 'BG', '13'),
(16007, 34, 525, 'Belovo', 'BG', '13'),
(16008, 34, 525, 'Bratsigovo', 'BG', '13'),
(16009, 34, 525, 'Lesichovo', 'BG', '13'),
(16010, 34, 525, 'Obshtina Batak', 'BG', '13'),
(16011, 34, 525, 'Obshtina Belovo', 'BG', '13'),
(16012, 34, 525, 'Obshtina Bratsigovo', 'BG', '13'),
(16013, 34, 525, 'Obshtina Lesichovo', 'BG', '13'),
(16014, 34, 525, 'Obshtina Panagyurishte', 'BG', '13'),
(16015, 34, 525, 'Obshtina Pazardzhik', 'BG', '13'),
(16016, 34, 525, 'Obshtina Peshtera', 'BG', '13'),
(16017, 34, 525, 'Obshtina Rakitovo', 'BG', '13'),
(16018, 34, 525, 'Obshtina Septemvri', 'BG', '13'),
(16019, 34, 525, 'Obshtina Strelcha', 'BG', '13'),
(16020, 34, 525, 'Obshtina Velingrad', 'BG', '13'),
(16021, 34, 525, 'Panagyurishte', 'BG', '13'),
(16022, 34, 525, 'Pazardzhik', 'BG', '13'),
(16023, 34, 525, 'Peshtera', 'BG', '13'),
(16024, 34, 525, 'Rakitovo', 'BG', '13'),
(16025, 34, 525, 'Sarnitsa', 'BG', '13'),
(16026, 34, 525, 'Sarnitsa Obshtina', 'BG', '13'),
(16027, 34, 525, 'Septemvri', 'BG', '13'),
(16028, 34, 525, 'Strelcha', 'BG', '13'),
(16029, 34, 525, 'Velingrad', 'BG', '13'),
(16030, 34, 526, 'Batanovtsi', 'BG', '14'),
(16031, 34, 526, 'Breznik', 'BG', '14'),
(16032, 34, 526, 'Obshtina Kovachevtsi', 'BG', '14'),
(16033, 34, 526, 'Obshtina Pernik', 'BG', '14'),
(16034, 34, 526, 'Obshtina Radomir', 'BG', '14'),
(16035, 34, 526, 'Obshtina Zemen', 'BG', '14'),
(16036, 34, 526, 'Pernik', 'BG', '14'),
(16037, 34, 526, 'Radomir', 'BG', '14'),
(16038, 34, 526, 'Tran', 'BG', '14'),
(16039, 34, 526, 'Zemen', 'BG', '14'),
(16040, 34, 527, 'Belene', 'BG', '15'),
(16041, 34, 527, 'Cherven Bryag', 'BG', '15'),
(16042, 34, 527, 'Dolna Mitropolia', 'BG', '15'),
(16043, 34, 527, 'Dolni Dabnik', 'BG', '15'),
(16044, 34, 527, 'Gulyantsi', 'BG', '15'),
(16045, 34, 527, 'Iskar', 'BG', '15'),
(16046, 34, 527, 'Knezha', 'BG', '15'),
(16047, 34, 527, 'Koynare', 'BG', '15'),
(16048, 34, 527, 'Levski', 'BG', '15'),
(16049, 34, 527, 'Nikopol', 'BG', '15'),
(16050, 34, 527, 'Obshtina Belene', 'BG', '15'),
(16051, 34, 527, 'Obshtina Cherven Bryag', 'BG', '15'),
(16052, 34, 527, 'Obshtina Dolna Mitropolia', 'BG', '15'),
(16053, 34, 527, 'Obshtina Dolni Dabnik', 'BG', '15'),
(16054, 34, 527, 'Obshtina Gulyantsi', 'BG', '15'),
(16055, 34, 527, 'Obshtina Iskar', 'BG', '15'),
(16056, 34, 527, 'Obshtina Knezha', 'BG', '15'),
(16057, 34, 527, 'Obshtina Levski', 'BG', '15'),
(16058, 34, 527, 'Obshtina Nikopol', 'BG', '15'),
(16059, 34, 527, 'Obshtina Pleven', 'BG', '15'),
(16060, 34, 527, 'Obshtina Pordim', 'BG', '15'),
(16061, 34, 527, 'Pleven', 'BG', '15'),
(16062, 34, 527, 'Pordim', 'BG', '15'),
(16063, 34, 527, 'Slavyanovo', 'BG', '15'),
(16064, 34, 528, 'Asenovgrad', 'BG', '16'),
(16065, 34, 528, 'Brezovo', 'BG', '16'),
(16066, 34, 528, 'Hisarya', 'BG', '16'),
(16067, 34, 528, 'Kalofer', 'BG', '16'),
(16068, 34, 528, 'Kaloyanovo', 'BG', '16'),
(16069, 34, 528, 'Karlovo', 'BG', '16'),
(16070, 34, 528, 'Klisura', 'BG', '16'),
(16071, 34, 528, 'Krichim', 'BG', '16'),
(16072, 34, 528, 'Laki', 'BG', '16'),
(16073, 34, 528, 'Obshtina Asenovgrad', 'BG', '16'),
(16074, 34, 528, 'Obshtina Hisarya', 'BG', '16'),
(16075, 34, 528, 'Obshtina Kaloyanovo', 'BG', '16'),
(16076, 34, 528, 'Obshtina Karlovo', 'BG', '16'),
(16077, 34, 528, 'Obshtina Krichim', 'BG', '16'),
(16078, 34, 528, 'Obshtina Kuklen', 'BG', '16'),
(16079, 34, 528, 'Obshtina Laki', 'BG', '16'),
(16080, 34, 528, 'Obshtina Maritsa', 'BG', '16'),
(16081, 34, 528, 'Obshtina Parvomay', 'BG', '16'),
(16082, 34, 528, 'Obshtina Perushtitsa', 'BG', '16'),
(16083, 34, 528, 'Obshtina Plovdiv', 'BG', '16'),
(16084, 34, 528, 'Obshtina Rakovski', 'BG', '16'),
(16085, 34, 528, 'Obshtina Rodopi', 'BG', '16'),
(16086, 34, 528, 'Obshtina Sadovo', 'BG', '16'),
(16087, 34, 528, 'Obshtina Saedinenie', 'BG', '16'),
(16088, 34, 528, 'Obshtina Sopot', 'BG', '16'),
(16089, 34, 528, 'Obshtina Stamboliyski', 'BG', '16'),
(16090, 34, 528, 'Parvomay', 'BG', '16'),
(16091, 34, 528, 'Perushtitsa', 'BG', '16'),
(16092, 34, 528, 'Plovdiv', 'BG', '16'),
(16093, 34, 528, 'Rakovski', 'BG', '16'),
(16094, 34, 528, 'Sadovo', 'BG', '16'),
(16095, 34, 528, 'Saedinenie', 'BG', '16'),
(16096, 34, 528, 'Stamboliyski', 'BG', '16'),
(16097, 34, 528, 'Topolovo', 'BG', '16'),
(16098, 34, 529, 'Isperih', 'BG', '17'),
(16099, 34, 529, 'Kubrat', 'BG', '17'),
(16100, 34, 529, 'Loznitsa', 'BG', '17'),
(16101, 34, 529, 'Medovene', 'BG', '17'),
(16102, 34, 529, 'Obshtina Isperih', 'BG', '17'),
(16103, 34, 529, 'Obshtina Kubrat', 'BG', '17'),
(16104, 34, 529, 'Obshtina Loznitsa', 'BG', '17'),
(16105, 34, 529, 'Obshtina Razgrad', 'BG', '17'),
(16106, 34, 529, 'Obshtina Samuil', 'BG', '17'),
(16107, 34, 529, 'Obshtina Tsar Kaloyan', 'BG', '17'),
(16108, 34, 529, 'Obshtina Zavet', 'BG', '17'),
(16109, 34, 529, 'Razgrad', 'BG', '17'),
(16110, 34, 529, 'Samuil', 'BG', '17'),
(16111, 34, 529, 'Tsar Kaloyan', 'BG', '17'),
(16112, 34, 529, 'Zavet', 'BG', '17'),
(16113, 34, 530, 'Borovo', 'BG', '18'),
(16114, 34, 530, 'Dve Mogili', 'BG', '18'),
(16115, 34, 530, 'Ivanovo', 'BG', '18'),
(16116, 34, 530, 'Obshtina Borovo', 'BG', '18'),
(16117, 34, 530, 'Obshtina Byala', 'BG', '18'),
(16118, 34, 530, 'Obshtina Dve Mogili', 'BG', '18'),
(16119, 34, 530, 'Obshtina Ivanovo', 'BG', '18'),
(16120, 34, 530, 'Obshtina Ruse', 'BG', '18'),
(16121, 34, 530, 'Obshtina Slivo Pole', 'BG', '18'),
(16122, 34, 530, 'Obshtina Tsenovo', 'BG', '18'),
(16123, 34, 530, 'Obshtina Vetovo', 'BG', '18'),
(16124, 34, 530, 'Ruse', 'BG', '18'),
(16125, 34, 530, 'Senovo', 'BG', '18'),
(16126, 34, 530, 'Slivo Pole', 'BG', '18'),
(16127, 34, 530, 'Tsenovo', 'BG', '18'),
(16128, 34, 530, 'Vetovo', 'BG', '18'),
(16129, 34, 531, 'Shumen', 'BG', '27'),
(16130, 34, 532, 'Alfatar', 'BG', '19'),
(16131, 34, 532, 'Dulovo', 'BG', '19'),
(16132, 34, 532, 'Glavinitsa', 'BG', '19'),
(16133, 34, 532, 'Kaynardzha', 'BG', '19'),
(16134, 34, 532, 'Obshtina Alfatar', 'BG', '19'),
(16135, 34, 532, 'Obshtina Dulovo', 'BG', '19'),
(16136, 34, 532, 'Obshtina Glavinitsa', 'BG', '19'),
(16137, 34, 532, 'Obshtina Kaynardzha', 'BG', '19'),
(16138, 34, 532, 'Obshtina Silistra', 'BG', '19'),
(16139, 34, 532, 'Obshtina Sitovo', 'BG', '19'),
(16140, 34, 532, 'Obshtina Tutrakan', 'BG', '19'),
(16141, 34, 532, 'Silistra', 'BG', '19'),
(16142, 34, 532, 'Sitovo', 'BG', '19'),
(16143, 34, 532, 'Tutrakan', 'BG', '19'),
(16144, 34, 533, 'Kermen', 'BG', '20'),
(16145, 34, 533, 'Kotel', 'BG', '20'),
(16146, 34, 533, 'Nova Zagora', 'BG', '20'),
(16147, 34, 533, 'Obshtina Kotel', 'BG', '20'),
(16148, 34, 533, 'Obshtina Nova Zagora', 'BG', '20'),
(16149, 34, 533, 'Obshtina Sliven', 'BG', '20'),
(16150, 34, 533, 'Obshtina Tvarditsa', 'BG', '20'),
(16151, 34, 533, 'Sliven', 'BG', '20'),
(16152, 34, 533, 'Tvarditsa', 'BG', '20'),
(16153, 34, 534, 'Banite', 'BG', '21'),
(16154, 34, 534, 'Borino', 'BG', '21'),
(16155, 34, 534, 'Chepelare', 'BG', '21'),
(16156, 34, 534, 'Devin', 'BG', '21'),
(16157, 34, 534, 'Dospat', 'BG', '21'),
(16158, 34, 534, 'Gyovren', 'BG', '21'),
(16159, 34, 534, 'Madan', 'BG', '21'),
(16160, 34, 534, 'Nedelino', 'BG', '21'),
(16161, 34, 534, 'Obshtina Banite', 'BG', '21'),
(16162, 34, 534, 'Obshtina Borino', 'BG', '21'),
(16163, 34, 534, 'Obshtina Chepelare', 'BG', '21'),
(16164, 34, 534, 'Obshtina Devin', 'BG', '21'),
(16165, 34, 534, 'Obshtina Dospat', 'BG', '21'),
(16166, 34, 534, 'Obshtina Madan', 'BG', '21'),
(16167, 34, 534, 'Obshtina Nedelino', 'BG', '21'),
(16168, 34, 534, 'Obshtina Rudozem', 'BG', '21'),
(16169, 34, 534, 'Obshtina Smolyan', 'BG', '21'),
(16170, 34, 534, 'Obshtina Zlatograd', 'BG', '21'),
(16171, 34, 534, 'Rudozem', 'BG', '21'),
(16172, 34, 534, 'Smolyan', 'BG', '21'),
(16173, 34, 534, 'Zlatograd', 'BG', '21'),
(16174, 34, 535, 'Buhovo', 'BG', '22'),
(16175, 34, 535, 'Sofia', 'BG', '22'),
(16176, 34, 535, 'Stolichna Obshtina', 'BG', '22'),
(16177, 34, 536, 'Anton', 'BG', '23'),
(16178, 34, 536, 'Botevgrad', 'BG', '23'),
(16179, 34, 536, 'Bozhurishte', 'BG', '23'),
(16180, 34, 536, 'Chavdar', 'BG', '23'),
(16181, 34, 536, 'Chelopech', 'BG', '23'),
(16182, 34, 536, 'Dolna Banya', 'BG', '23'),
(16183, 34, 536, 'Dragoman', 'BG', '23'),
(16184, 34, 536, 'Elin Pelin', 'BG', '23'),
(16185, 34, 536, 'Etropole', 'BG', '23'),
(16186, 34, 536, 'Godech', 'BG', '23'),
(16187, 34, 536, 'Gorna Malina', 'BG', '23'),
(16188, 34, 536, 'Ihtiman', 'BG', '23'),
(16189, 34, 536, 'Koprivshtitsa', 'BG', '23'),
(16190, 34, 536, 'Kostinbrod', 'BG', '23'),
(16191, 34, 536, 'Lakatnik', 'BG', '23'),
(16192, 34, 536, 'Mirkovo', 'BG', '23'),
(16193, 34, 536, 'Obshtina Anton', 'BG', '23'),
(16194, 34, 536, 'Obshtina Botevgrad', 'BG', '23'),
(16195, 34, 536, 'Obshtina Bozhurishte', 'BG', '23'),
(16196, 34, 536, 'Obshtina Chavdar', 'BG', '23'),
(16197, 34, 536, 'Obshtina Chelopech', 'BG', '23'),
(16198, 34, 536, 'Obshtina Dolna Banya', 'BG', '23'),
(16199, 34, 536, 'Obshtina Dragoman', 'BG', '23'),
(16200, 34, 536, 'Obshtina Elin Pelin', 'BG', '23'),
(16201, 34, 536, 'Obshtina Etropole', 'BG', '23'),
(16202, 34, 536, 'Obshtina Gorna Malina', 'BG', '23'),
(16203, 34, 536, 'Obshtina Koprivshtitsa', 'BG', '23'),
(16204, 34, 536, 'Obshtina Kostenets', 'BG', '23'),
(16205, 34, 536, 'Obshtina Kostinbrod', 'BG', '23'),
(16206, 34, 536, 'Obshtina Mirkovo', 'BG', '23'),
(16207, 34, 536, 'Obshtina Pirdop', 'BG', '23'),
(16208, 34, 536, 'Obshtina Pravets', 'BG', '23'),
(16209, 34, 536, 'Obshtina Samokov', 'BG', '23'),
(16210, 34, 536, 'Obshtina Slivnitsa', 'BG', '23'),
(16211, 34, 536, 'Obshtina Svoge', 'BG', '23'),
(16212, 34, 536, 'Obshtina Zlatitsa', 'BG', '23'),
(16213, 34, 536, 'Pirdop', 'BG', '23'),
(16214, 34, 536, 'Pravets', 'BG', '23'),
(16215, 34, 536, 'Samokov', 'BG', '23'),
(16216, 34, 536, 'Slivnitsa', 'BG', '23'),
(16217, 34, 536, 'Svoge', 'BG', '23'),
(16218, 34, 536, 'Zlatitsa', 'BG', '23'),
(16219, 34, 537, 'Asen', 'BG', '24'),
(16220, 34, 537, 'Chirpan', 'BG', '24'),
(16221, 34, 537, 'Gŭlŭbovo', 'BG', '24'),
(16222, 34, 537, 'Gurkovo', 'BG', '24'),
(16223, 34, 537, 'Kazanlak', 'BG', '24'),
(16224, 34, 537, 'Maglizh', 'BG', '24'),
(16225, 34, 537, 'Nikolaevo', 'BG', '24'),
(16226, 34, 537, 'Obshtina Bratya Daskalovi', 'BG', '24'),
(16227, 34, 537, 'Obshtina Chirpan', 'BG', '24'),
(16228, 34, 537, 'Obshtina Galabovo', 'BG', '24'),
(16229, 34, 537, 'Obshtina Gurkovo', 'BG', '24'),
(16230, 34, 537, 'Obshtina Kazanlŭk', 'BG', '24'),
(16231, 34, 537, 'Obshtina Maglizh', 'BG', '24'),
(16232, 34, 537, 'Obshtina Nikolaevo', 'BG', '24'),
(16233, 34, 537, 'Obshtina Opan', 'BG', '24'),
(16234, 34, 537, 'Obshtina Pavel Banya', 'BG', '24'),
(16235, 34, 537, 'Obshtina Radnevo', 'BG', '24'),
(16236, 34, 537, 'Obshtina Stara Zagora', 'BG', '24'),
(16237, 34, 537, 'Pavel Banya', 'BG', '24'),
(16238, 34, 537, 'Radnevo', 'BG', '24'),
(16239, 34, 537, 'Shipka', 'BG', '24'),
(16240, 34, 537, 'Stara Zagora', 'BG', '24'),
(16241, 34, 538, 'Antonovo', 'BG', '25'),
(16242, 34, 538, 'Obshtina Antonovo', 'BG', '25'),
(16243, 34, 538, 'Obshtina Omurtag', 'BG', '25'),
(16244, 34, 538, 'Obshtina Opaka', 'BG', '25'),
(16245, 34, 538, 'Obshtina Popovo', 'BG', '25'),
(16246, 34, 538, 'Obshtina Targovishte', 'BG', '25'),
(16247, 34, 538, 'Omurtag', 'BG', '25'),
(16248, 34, 538, 'Opaka', 'BG', '25'),
(16249, 34, 538, 'Popovo', 'BG', '25'),
(16250, 34, 538, 'Targovishte', 'BG', '25'),
(16251, 34, 539, 'Aksakovo', 'BG', '03'),
(16252, 34, 539, 'Asparuhovo', 'BG', '03'),
(16253, 34, 539, 'Balgarevo', 'BG', '03'),
(16254, 34, 539, 'Beloslav', 'BG', '03'),
(16255, 34, 539, 'Byala', 'BG', '03'),
(16256, 34, 539, 'Dalgopol', 'BG', '03'),
(16257, 34, 539, 'Devnya', 'BG', '03'),
(16258, 34, 539, 'Dolni Chiflik', 'BG', '03'),
(16259, 34, 539, 'Kiten', 'BG', '03'),
(16260, 34, 539, 'Obshtina Aksakovo', 'BG', '03'),
(16261, 34, 539, 'Obshtina Avren', 'BG', '03'),
(16262, 34, 539, 'Obshtina Beloslav', 'BG', '03'),
(16263, 34, 539, 'Obshtina Byala', 'BG', '03'),
(16264, 34, 539, 'Obshtina Dalgopol', 'BG', '03'),
(16265, 34, 539, 'Obshtina Devnya', 'BG', '03'),
(16266, 34, 539, 'Obshtina Dolni Chiflik', 'BG', '03'),
(16267, 34, 539, 'Obshtina Provadia', 'BG', '03'),
(16268, 34, 539, 'Obshtina Suvorovo', 'BG', '03'),
(16269, 34, 539, 'Obshtina Valchidol', 'BG', '03'),
(16270, 34, 539, 'Obshtina Varna', 'BG', '03'),
(16271, 34, 539, 'Obshtina Vetrino', 'BG', '03'),
(16272, 34, 539, 'Provadia', 'BG', '03'),
(16273, 34, 539, 'Suvorovo', 'BG', '03'),
(16274, 34, 539, 'Valchidol', 'BG', '03'),
(16275, 34, 539, 'Varna', 'BG', '03'),
(16276, 34, 539, 'Vetrino', 'BG', '03'),
(16277, 34, 539, 'Zlatni Pyasatsi', 'BG', '03'),
(16278, 34, 540, 'Byala Cherkva', 'BG', '04'),
(16279, 34, 540, 'Debelets', 'BG', '04'),
(16280, 34, 540, 'Elena', 'BG', '04'),
(16281, 34, 540, 'Gorna Oryahovitsa', 'BG', '04'),
(16282, 34, 540, 'Kilifarevo', 'BG', '04'),
(16283, 34, 540, 'Lyaskovets', 'BG', '04'),
(16284, 34, 540, 'Obshtina Elena', 'BG', '04'),
(16285, 34, 540, 'Obshtina Gorna Oryahovitsa', 'BG', '04'),
(16286, 34, 540, 'Obshtina Lyaskovets', 'BG', '04'),
(16287, 34, 540, 'Obshtina Pavlikeni', 'BG', '04'),
(16288, 34, 540, 'Obshtina Polski Trambesh', 'BG', '04'),
(16289, 34, 540, 'Obshtina Strazhitsa', 'BG', '04'),
(16290, 34, 540, 'Obshtina Suhindol', 'BG', '04'),
(16291, 34, 540, 'Obshtina Svishtov', 'BG', '04'),
(16292, 34, 540, 'Obshtina Veliko Tŭrnovo', 'BG', '04'),
(16293, 34, 540, 'Obshtina Zlataritsa', 'BG', '04'),
(16294, 34, 540, 'Parvomaytsi', 'BG', '04'),
(16295, 34, 540, 'Pavlikeni', 'BG', '04'),
(16296, 34, 540, 'Polski Trambesh', 'BG', '04'),
(16297, 34, 540, 'Strazhitsa', 'BG', '04'),
(16298, 34, 540, 'Suhindol', 'BG', '04'),
(16299, 34, 540, 'Svishtov', 'BG', '04'),
(16300, 34, 540, 'Veliko Tŭrnovo', 'BG', '04'),
(16301, 34, 540, 'Zlataritsa', 'BG', '04'),
(16302, 34, 541, 'Belogradchik', 'BG', '05'),
(16303, 34, 541, 'Boynitsa', 'BG', '05'),
(16304, 34, 541, 'Bregovo', 'BG', '05'),
(16305, 34, 541, 'Chuprene', 'BG', '05'),
(16306, 34, 541, 'Dimovo', 'BG', '05'),
(16307, 34, 541, 'Drenovets', 'BG', '05'),
(16308, 34, 541, 'Dunavtsi', 'BG', '05'),
(16309, 34, 541, 'Gramada', 'BG', '05'),
(16310, 34, 541, 'Kula', 'BG', '05'),
(16311, 34, 541, 'Makresh', 'BG', '05'),
(16312, 34, 541, 'Novo Selo', 'BG', '05'),
(16313, 34, 541, 'Obshtina Belogradchik', 'BG', '05'),
(16314, 34, 541, 'Obshtina Boynitsa', 'BG', '05'),
(16315, 34, 541, 'Obshtina Dimovo', 'BG', '05'),
(16316, 34, 541, 'Obshtina Gramada', 'BG', '05'),
(16317, 34, 541, 'Obshtina Kula', 'BG', '05'),
(16318, 34, 541, 'Obshtina Ruzhintsi', 'BG', '05'),
(16319, 34, 541, 'Obshtina Vidin', 'BG', '05'),
(16320, 34, 541, 'Ruzhintsi', 'BG', '05'),
(16321, 34, 541, 'Vidin', 'BG', '05'),
(16322, 34, 542, 'Borovan', 'BG', '06'),
(16323, 34, 542, 'Byala Slatina', 'BG', '06'),
(16324, 34, 542, 'Hayredin', 'BG', '06'),
(16325, 34, 542, 'Kozloduy', 'BG', '06'),
(16326, 34, 542, 'Krivodol', 'BG', '06'),
(16327, 34, 542, 'Mezdra', 'BG', '06'),
(16328, 34, 542, 'Mizia', 'BG', '06'),
(16329, 34, 542, 'Obshtina Borovan', 'BG', '06'),
(16330, 34, 542, 'Obshtina Hayredin', 'BG', '06'),
(16331, 34, 542, 'Obshtina Kozloduy', 'BG', '06'),
(16332, 34, 542, 'Obshtina Krivodol', 'BG', '06'),
(16333, 34, 542, 'Obshtina Mezdra', 'BG', '06'),
(16334, 34, 542, 'Obshtina Mizia', 'BG', '06'),
(16335, 34, 542, 'Obshtina Oryahovo', 'BG', '06'),
(16336, 34, 542, 'Obshtina Roman', 'BG', '06'),
(16337, 34, 542, 'Obshtina Vratsa', 'BG', '06'),
(16338, 34, 542, 'Oryahovo', 'BG', '06'),
(16339, 34, 542, 'Roman', 'BG', '06'),
(16340, 34, 542, 'Vratsa', 'BG', '06'),
(16341, 34, 543, 'Bolyarovo', 'BG', '28'),
(16342, 34, 543, 'Elhovo', 'BG', '28'),
(16343, 34, 543, 'Obshtina Bolyarovo', 'BG', '28'),
(16344, 34, 543, 'Obshtina Elhovo', 'BG', '28'),
(16345, 34, 543, 'Obshtina Straldzha', 'BG', '28'),
(16346, 34, 543, 'Obshtina Tundzha', 'BG', '28'),
(16347, 34, 543, 'Obshtina Yambol', 'BG', '28'),
(16348, 34, 543, 'Straldzha', 'BG', '28'),
(16349, 34, 543, 'Yambol', 'BG', '28'),
(16350, 35, 548, 'Barani', 'BF', '01'),
(16351, 35, 548, 'Boromo', 'BF', '01'),
(16352, 35, 548, 'Dédougou', 'BF', '01'),
(16353, 35, 548, 'Nouna', 'BF', '01'),
(16354, 35, 548, 'Province de la Kossi', 'BF', '01'),
(16355, 35, 548, 'Province des Balé', 'BF', '01'),
(16356, 35, 548, 'Province des Banwa', 'BF', '01'),
(16357, 35, 548, 'Province du Mouhoun', 'BF', '01'),
(16358, 35, 548, 'Province du Nayala', 'BF', '01'),
(16359, 35, 548, 'Province du Sourou', 'BF', '01'),
(16360, 35, 548, 'Salanso', 'BF', '01'),
(16361, 35, 548, 'Toma', 'BF', '01'),
(16362, 35, 548, 'Tougan', 'BF', '01'),
(16363, 35, 551, 'Banfora', 'BF', '02'),
(16364, 35, 551, 'Province de la Comoé', 'BF', '02'),
(16365, 35, 551, 'Province de la Léraba', 'BF', '02'),
(16366, 35, 551, 'Sindou', 'BF', '02'),
(16367, 35, 552, 'Kadiogo Province', 'BF', '03'),
(16368, 35, 552, 'Ouagadougou', 'BF', '03'),
(16369, 35, 553, 'Garango', 'BF', '04'),
(16370, 35, 553, 'Koupéla', 'BF', '04'),
(16371, 35, 553, 'Kouritenga Province', 'BF', '04'),
(16372, 35, 553, 'Ouargaye', 'BF', '04'),
(16373, 35, 553, 'Province du Boulgou', 'BF', '04'),
(16374, 35, 553, 'Province du Koulpélogo', 'BF', '04'),
(16375, 35, 553, 'Tenkodogo', 'BF', '04'),
(16376, 35, 554, 'Boulsa', 'BF', '05'),
(16377, 35, 554, 'Kaya', 'BF', '05'),
(16378, 35, 554, 'Kongoussi', 'BF', '05'),
(16379, 35, 554, 'Province du Bam', 'BF', '05'),
(16380, 35, 554, 'Province du Namentenga', 'BF', '05'),
(16381, 35, 554, 'Province du Sanmatenga', 'BF', '05'),
(16382, 35, 555, 'Goulouré', 'BF', '06'),
(16383, 35, 555, 'Kokologo', 'BF', '06'),
(16384, 35, 555, 'Koudougou', 'BF', '06'),
(16385, 35, 555, 'Léo', 'BF', '06'),
(16386, 35, 555, 'Pitmoaga', 'BF', '06'),
(16387, 35, 555, 'Province de la Sissili', 'BF', '06'),
(16388, 35, 555, 'Province du Boulkiemdé', 'BF', '06'),
(16389, 35, 555, 'Province du Sanguié', 'BF', '06'),
(16390, 35, 555, 'Province du Ziro', 'BF', '06'),
(16391, 35, 555, 'Réo', 'BF', '06'),
(16392, 35, 555, 'Sapouy', 'BF', '06'),
(16393, 35, 556, 'Bazega Province', 'BF', '07'),
(16394, 35, 556, 'Kombissiri', 'BF', '07'),
(16395, 35, 556, 'Manga', 'BF', '07'),
(16396, 35, 556, 'Nahouri Province', 'BF', '07'),
(16397, 35, 556, 'Pô', 'BF', '07'),
(16398, 35, 556, 'Zoundweogo Province', 'BF', '07'),
(16399, 35, 558, 'Bogandé', 'BF', '08'),
(16400, 35, 558, 'Diapaga', 'BF', '08'),
(16401, 35, 558, 'Fada N\'gourma', 'BF', '08'),
(16402, 35, 558, 'Gayéri', 'BF', '08'),
(16403, 35, 558, 'Gnagna Province', 'BF', '08'),
(16404, 35, 558, 'Pama', 'BF', '08'),
(16405, 35, 558, 'Province de la Komandjoari', 'BF', '08'),
(16406, 35, 558, 'Province de la Kompienga', 'BF', '08'),
(16407, 35, 558, 'Province de la Tapoa', 'BF', '08'),
(16408, 35, 558, 'Province du Gourma', 'BF', '08'),
(16409, 35, 562, 'Bobo-Dioulasso', 'BF', '09'),
(16410, 35, 562, 'Houndé', 'BF', '09'),
(16411, 35, 562, 'Province du Houet', 'BF', '09'),
(16412, 35, 562, 'Province du Kénédougou', 'BF', '09'),
(16413, 35, 562, 'Province du Tuy', 'BF', '09'),
(16414, 35, 579, 'Gourcy', 'BF', '10'),
(16415, 35, 579, 'Ouahigouya', 'BF', '10'),
(16416, 35, 579, 'Province du Loroum', 'BF', '10'),
(16417, 35, 579, 'Province du Passoré', 'BF', '10'),
(16418, 35, 579, 'Province du Yatenga', 'BF', '10'),
(16419, 35, 579, 'Province du Zondoma', 'BF', '10'),
(16420, 35, 579, 'Titao', 'BF', '10'),
(16421, 35, 579, 'Yako', 'BF', '10'),
(16422, 35, 584, 'Boussé', 'BF', '11'),
(16423, 35, 584, 'Oubritenga', 'BF', '11'),
(16424, 35, 584, 'Province du Ganzourgou', 'BF', '11'),
(16425, 35, 584, 'Province du Kourwéogo', 'BF', '11'),
(16426, 35, 584, 'Ziniaré', 'BF', '11'),
(16427, 35, 584, 'Zorgo', 'BF', '11'),
(16428, 35, 586, 'Djibo', 'BF', '12'),
(16429, 35, 586, 'Dori', 'BF', '12'),
(16430, 35, 586, 'Gorom-Gorom', 'BF', '12'),
(16431, 35, 586, 'Province de l’Oudalan', 'BF', '12'),
(16432, 35, 586, 'Province du Séno', 'BF', '12'),
(16433, 35, 586, 'Province du Soum', 'BF', '12'),
(16434, 35, 586, 'Province du Yagha', 'BF', '12'),
(16435, 35, 593, 'Batié', 'BF', '13'),
(16436, 35, 593, 'Dano', 'BF', '13'),
(16437, 35, 593, 'Diébougou', 'BF', '13'),
(16438, 35, 593, 'Province de la Bougouriba', 'BF', '13'),
(16439, 35, 593, 'Province du Ioba', 'BF', '13'),
(16440, 35, 593, 'Province du Noumbièl', 'BF', '13'),
(16441, 35, 593, 'Province du Poni', 'BF', '13'),
(16442, 36, 601, 'Bubanza', 'BI', 'BB'),
(16443, 36, 602, 'Bujumbura', 'BI', 'BM'),
(16444, 36, 604, 'Bururi', 'BI', 'BR'),
(16445, 36, 605, 'Cankuzo', 'BI', 'CA'),
(16446, 36, 606, 'Cibitoke', 'BI', 'CI'),
(16447, 36, 607, 'Gitega', 'BI', 'GI'),
(16448, 36, 608, 'Karuzi', 'BI', 'KR'),
(16449, 36, 609, 'Kayanza', 'BI', 'KY'),
(16450, 36, 610, 'Kirundo', 'BI', 'KI'),
(16451, 36, 611, 'Makamba', 'BI', 'MA'),
(16452, 36, 612, 'Muramvya', 'BI', 'MU'),
(16453, 36, 613, 'Muyinga', 'BI', 'MY'),
(16454, 36, 614, 'Mwaro', 'BI', 'MW'),
(16455, 36, 615, 'Ngozi', 'BI', 'NG'),
(16456, 36, 616, 'Rumonge', 'BI', 'RM'),
(16457, 36, 617, 'Rutana', 'BI', 'RT'),
(16458, 36, 618, 'Ruyigi', 'BI', 'RY'),
(16459, 37, 619, 'Mongkol Borei', 'KH', '1'),
(16460, 37, 619, 'Paoy Paet', 'KH', '1'),
(16461, 37, 619, 'Sisophon', 'KH', '1'),
(16462, 37, 619, 'Srŏk Malai', 'KH', '1'),
(16463, 37, 619, 'Srŏk Svay Chék', 'KH', '1'),
(16464, 37, 620, 'Battambang', 'KH', '2'),
(16465, 37, 620, 'Srŏk Âk Phnŭm', 'KH', '2'),
(16466, 37, 620, 'Srŏk Banăn', 'KH', '2'),
(16467, 37, 620, 'Srŏk Bâvĭl', 'KH', '2'),
(16468, 37, 620, 'Srŏk Rotanak Mondol', 'KH', '2'),
(16469, 37, 621, 'Cheung Prey', 'KH', '3'),
(16470, 37, 621, 'Kampong Cham', 'KH', '3'),
(16471, 37, 621, 'Srŏk Bathéay', 'KH', '3'),
(16472, 37, 622, 'Baribour', 'KH', '4'),
(16473, 37, 622, 'Kampong Chhnang', 'KH', '4'),
(16474, 37, 622, 'Rolea B\'ier', 'KH', '4'),
(16475, 37, 622, 'Srŏk Chol Kiri', 'KH', '4'),
(16476, 37, 622, 'Srŏk Sameakki Mean Chey', 'KH', '4'),
(16477, 37, 623, 'Kampong Speu', 'KH', '5'),
(16478, 37, 623, 'Krŏng Chbar Mon', 'KH', '5'),
(16479, 37, 623, 'Srŏk Basedth', 'KH', '5'),
(16480, 37, 623, 'Srŏk Kông Pĭsei', 'KH', '5'),
(16481, 37, 623, 'Srŏk Ŏdŏngk', 'KH', '5'),
(16482, 37, 625, 'Angkor Chey', 'KH', '7'),
(16483, 37, 625, 'Banteay Meas', 'KH', '7'),
(16484, 37, 625, 'Chhouk District', 'KH', '7'),
(16485, 37, 625, 'Kampong Bay', 'KH', '7'),
(16486, 37, 625, 'Kampong Tranch', 'KH', '7'),
(16487, 37, 625, 'Kampot', 'KH', '7'),
(16488, 37, 625, 'Srŏk Chŭm Kiri', 'KH', '7'),
(16489, 37, 625, 'Srŏk Dângtóng', 'KH', '7'),
(16490, 37, 625, 'Srok Tuek Chhou', 'KH', '7'),
(16491, 37, 626, 'Krŏng Ta Khmau', 'KH', '8'),
(16492, 37, 626, 'Srŏk Khsăch Kândal', 'KH', '8'),
(16493, 37, 626, 'Ta Khmau', 'KH', '8'),
(16494, 37, 627, 'Krong Kep', 'KH', '23'),
(16495, 37, 627, 'Srŏk Dâmnăk Châng’aeur', 'KH', '23'),
(16496, 37, 628, 'Koh Kong', 'KH', '9'),
(16497, 37, 628, 'Smach Mean Chey', 'KH', '9'),
(16498, 37, 628, 'Srae Ambel', 'KH', '9'),
(16499, 37, 628, 'Srŏk Batum Sakôr', 'KH', '9'),
(16500, 37, 628, 'Srŏk Môndôl Seima', 'KH', '9');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(16501, 37, 629, 'Kracheh', 'KH', '10'),
(16502, 37, 629, 'Kratié', 'KH', '10'),
(16503, 37, 629, 'Snuol', 'KH', '10'),
(16504, 37, 630, 'Krŏng Sênmônoŭrôm', 'KH', '11'),
(16505, 37, 630, 'Sen Monorom', 'KH', '11'),
(16506, 37, 630, 'Srŏk Kaev Seima', 'KH', '11'),
(16507, 37, 630, 'Srŏk Pech Chreada', 'KH', '11'),
(16508, 37, 631, 'Samraong', 'KH', '22'),
(16509, 37, 631, 'Srŏk Bântéay Âmpĭl', 'KH', '22'),
(16510, 37, 631, 'Srŏk Sâmraông', 'KH', '22'),
(16511, 37, 631, 'Srŏk Trâpeăng Prasat', 'KH', '22'),
(16512, 37, 632, 'Khan Sala Krau', 'KH', '24'),
(16513, 37, 632, 'Pailin', 'KH', '24'),
(16514, 37, 633, 'Khan 7 Makara', 'KH', '12'),
(16515, 37, 633, 'Khan Châmkar Mon', 'KH', '12'),
(16516, 37, 633, 'Khan Dângkaô', 'KH', '12'),
(16517, 37, 633, 'Khan Duŏn Pénh', 'KH', '12'),
(16518, 37, 633, 'Khan Méan Chey', 'KH', '12'),
(16519, 37, 633, 'Khan Russey Keo', 'KH', '12'),
(16520, 37, 633, 'Khan Saen Sokh', 'KH', '12'),
(16521, 37, 633, 'Phnom Penh', 'KH', '12'),
(16522, 37, 634, 'Sangkom Thmei', 'KH', '13'),
(16523, 37, 634, 'Srŏk Ch’êh Sên', 'KH', '13'),
(16524, 37, 634, 'Srŏk Chhêb', 'KH', '13'),
(16525, 37, 634, 'Srŏk Kulén', 'KH', '13'),
(16526, 37, 634, 'Srŏk Rôviĕng', 'KH', '13'),
(16527, 37, 634, 'Srŏk Tbêng Méanchey', 'KH', '13'),
(16528, 37, 634, 'Tbeng Meanchey', 'KH', '13'),
(16529, 37, 635, 'Prey Veng', 'KH', '14'),
(16530, 37, 635, 'Srŏk Kâmpóng Léav', 'KH', '14'),
(16531, 37, 635, 'Srŏk Mésang', 'KH', '14'),
(16532, 37, 635, 'Srŏk Preăh Sdéch', 'KH', '14'),
(16533, 37, 636, 'Bakan', 'KH', '15'),
(16534, 37, 636, 'Krakor', 'KH', '15'),
(16535, 37, 636, 'Pursat', 'KH', '15'),
(16536, 37, 636, 'Sampov Meas', 'KH', '15'),
(16537, 37, 636, 'Srŏk Kândiĕng', 'KH', '15'),
(16538, 37, 636, 'Srŏk Véal Vêng', 'KH', '15'),
(16539, 37, 637, 'Banlung', 'KH', '16'),
(16540, 37, 637, 'Lumphat', 'KH', '16'),
(16541, 37, 637, 'Srŏk Ândong Méas', 'KH', '16'),
(16542, 37, 637, 'Srŏk Bâ Kêv', 'KH', '16'),
(16543, 37, 637, 'Srŏk Ban Lŭng', 'KH', '16'),
(16544, 37, 637, 'Srŏk Koun Mom', 'KH', '16'),
(16545, 37, 637, 'Srŏk Ou Chum', 'KH', '16'),
(16546, 37, 637, 'Srŏk Ou Ya Dav', 'KH', '16'),
(16547, 37, 637, 'Srŏk Ta Vêng', 'KH', '16'),
(16548, 37, 638, 'Siem Reap', 'KH', '17'),
(16549, 37, 638, 'Srŏk Ângkôr Thum', 'KH', '17'),
(16550, 37, 638, 'Srŏk Prasat Bakong', 'KH', '17'),
(16551, 37, 638, 'Svay Leu', 'KH', '17'),
(16552, 37, 638, 'Varin', 'KH', '17'),
(16553, 37, 639, 'Sihanoukville', 'KH', '18'),
(16554, 37, 639, 'Srok Stueng Hav', 'KH', '18'),
(16555, 37, 640, 'Srŏk Srêsén', 'KH', '19'),
(16556, 37, 640, 'Stueng Traeng', 'KH', '19'),
(16557, 37, 640, 'Stung Treng', 'KH', '19'),
(16558, 37, 641, 'Srŏk Svay Chrŭm', 'KH', '20'),
(16559, 37, 641, 'Svay Rieng', 'KH', '20'),
(16560, 37, 642, 'Krŏng Doun Kaev', 'KH', '21'),
(16561, 37, 642, 'Phumĭ Véal Srê', 'KH', '21'),
(16562, 37, 642, 'Srŏk Ângkôr Borei', 'KH', '21'),
(16563, 37, 642, 'Srŏk Borei Cholsar', 'KH', '21'),
(16564, 37, 642, 'Takeo', 'KH', '21'),
(16565, 38, 643, 'Bankim', 'CM', 'AD'),
(16566, 38, 643, 'Banyo', 'CM', 'AD'),
(16567, 38, 643, 'Bélel', 'CM', 'AD'),
(16568, 38, 643, 'Djohong', 'CM', 'AD'),
(16569, 38, 643, 'Kontcha', 'CM', 'AD'),
(16570, 38, 643, 'Mayo-Banyo', 'CM', 'AD'),
(16571, 38, 643, 'Meïganga', 'CM', 'AD'),
(16572, 38, 643, 'Ngaoundéré', 'CM', 'AD'),
(16573, 38, 643, 'Somié', 'CM', 'AD'),
(16574, 38, 643, 'Tibati', 'CM', 'AD'),
(16575, 38, 643, 'Tignère', 'CM', 'AD'),
(16576, 38, 643, 'Vina', 'CM', 'AD'),
(16577, 38, 644, 'Akono', 'CM', 'CE'),
(16578, 38, 644, 'Akonolinga', 'CM', 'CE'),
(16579, 38, 644, 'Bafia', 'CM', 'CE'),
(16580, 38, 644, 'Eséka', 'CM', 'CE'),
(16581, 38, 644, 'Essé', 'CM', 'CE'),
(16582, 38, 644, 'Évodoula', 'CM', 'CE'),
(16583, 38, 644, 'Mbalmayo', 'CM', 'CE'),
(16584, 38, 644, 'Mbam-Et-Inoubou', 'CM', 'CE'),
(16585, 38, 644, 'Mbandjok', 'CM', 'CE'),
(16586, 38, 644, 'Mbankomo', 'CM', 'CE'),
(16587, 38, 644, 'Mefou-et-Akono', 'CM', 'CE'),
(16588, 38, 644, 'Mfoundi', 'CM', 'CE'),
(16589, 38, 644, 'Minta', 'CM', 'CE'),
(16590, 38, 644, 'Nanga Eboko', 'CM', 'CE'),
(16591, 38, 644, 'Ndikiniméki', 'CM', 'CE'),
(16592, 38, 644, 'Ngomedzap', 'CM', 'CE'),
(16593, 38, 644, 'Ngoro', 'CM', 'CE'),
(16594, 38, 644, 'Nkoteng', 'CM', 'CE'),
(16595, 38, 644, 'Ntui', 'CM', 'CE'),
(16596, 38, 644, 'Obala', 'CM', 'CE'),
(16597, 38, 644, 'Okoa', 'CM', 'CE'),
(16598, 38, 644, 'Okola', 'CM', 'CE'),
(16599, 38, 644, 'Ombésa', 'CM', 'CE'),
(16600, 38, 644, 'Saa', 'CM', 'CE'),
(16601, 38, 644, 'Yaoundé', 'CM', 'CE'),
(16602, 38, 644, 'Yoko', 'CM', 'CE'),
(16603, 38, 645, 'Abong Mbang', 'CM', 'ES'),
(16604, 38, 645, 'Batouri', 'CM', 'ES'),
(16605, 38, 645, 'Bélabo', 'CM', 'ES'),
(16606, 38, 645, 'Bertoua', 'CM', 'ES'),
(16607, 38, 645, 'Bétaré Oya', 'CM', 'ES'),
(16608, 38, 645, 'Dimako', 'CM', 'ES'),
(16609, 38, 645, 'Doumé', 'CM', 'ES'),
(16610, 38, 645, 'Garoua Boulaï', 'CM', 'ES'),
(16611, 38, 645, 'Mbang', 'CM', 'ES'),
(16612, 38, 645, 'Ndelele', 'CM', 'ES'),
(16613, 38, 645, 'Yokadouma', 'CM', 'ES'),
(16614, 38, 646, 'Bogo', 'CM', 'EN'),
(16615, 38, 646, 'Kaélé', 'CM', 'EN'),
(16616, 38, 646, 'Kousséri', 'CM', 'EN'),
(16617, 38, 646, 'Koza', 'CM', 'EN'),
(16618, 38, 646, 'Makary', 'CM', 'EN'),
(16619, 38, 646, 'Maroua', 'CM', 'EN'),
(16620, 38, 646, 'Mayo-Sava', 'CM', 'EN'),
(16621, 38, 646, 'Mayo-Tsanaga', 'CM', 'EN'),
(16622, 38, 646, 'Mindif', 'CM', 'EN'),
(16623, 38, 646, 'Mokolo', 'CM', 'EN'),
(16624, 38, 646, 'Mora', 'CM', 'EN'),
(16625, 38, 646, 'Yagoua', 'CM', 'EN'),
(16626, 38, 647, 'Bonabéri', 'CM', 'LT'),
(16627, 38, 647, 'Diang', 'CM', 'LT'),
(16628, 38, 647, 'Dibombari', 'CM', 'LT'),
(16629, 38, 647, 'Dizangué', 'CM', 'LT'),
(16630, 38, 647, 'Douala', 'CM', 'LT'),
(16631, 38, 647, 'Edéa', 'CM', 'LT'),
(16632, 38, 647, 'Loum', 'CM', 'LT'),
(16633, 38, 647, 'Manjo', 'CM', 'LT'),
(16634, 38, 647, 'Mbanga', 'CM', 'LT'),
(16635, 38, 647, 'Melong', 'CM', 'LT'),
(16636, 38, 647, 'Mouanko', 'CM', 'LT'),
(16637, 38, 647, 'Ndom', 'CM', 'LT'),
(16638, 38, 647, 'Ngambé', 'CM', 'LT'),
(16639, 38, 647, 'Nkongsamba', 'CM', 'LT'),
(16640, 38, 647, 'Penja', 'CM', 'LT'),
(16641, 38, 647, 'Yabassi', 'CM', 'LT'),
(16642, 38, 648, 'Faro Department', 'CM', 'NO'),
(16643, 38, 648, 'Garoua', 'CM', 'NO'),
(16644, 38, 648, 'Guider', 'CM', 'NO'),
(16645, 38, 648, 'Lagdo', 'CM', 'NO'),
(16646, 38, 648, 'Mayo-Louti', 'CM', 'NO'),
(16647, 38, 648, 'Mayo-Rey', 'CM', 'NO'),
(16648, 38, 648, 'Pitoa', 'CM', 'NO'),
(16649, 38, 648, 'Poli', 'CM', 'NO'),
(16650, 38, 648, 'Rey Bouba', 'CM', 'NO'),
(16651, 38, 648, 'Tcholliré', 'CM', 'NO'),
(16652, 38, 649, 'Babanki', 'CM', 'NW'),
(16653, 38, 649, 'Bali', 'CM', 'NW'),
(16654, 38, 649, 'Bamenda', 'CM', 'NW'),
(16655, 38, 649, 'Batibo', 'CM', 'NW'),
(16656, 38, 649, 'Belo', 'CM', 'NW'),
(16657, 38, 649, 'Boyo', 'CM', 'NW'),
(16658, 38, 649, 'Fundong', 'CM', 'NW'),
(16659, 38, 649, 'Jakiri', 'CM', 'NW'),
(16660, 38, 649, 'Kumbo', 'CM', 'NW'),
(16661, 38, 649, 'Mbengwi', 'CM', 'NW'),
(16662, 38, 649, 'Mme-Bafumen', 'CM', 'NW'),
(16663, 38, 649, 'Njinikom', 'CM', 'NW'),
(16664, 38, 649, 'Wum', 'CM', 'NW'),
(16665, 38, 650, 'Akom II', 'CM', 'SU'),
(16666, 38, 650, 'Ambam', 'CM', 'SU'),
(16667, 38, 650, 'Ébolowa', 'CM', 'SU'),
(16668, 38, 650, 'Kribi', 'CM', 'SU'),
(16669, 38, 650, 'Lolodorf', 'CM', 'SU'),
(16670, 38, 650, 'Mvangué', 'CM', 'SU'),
(16671, 38, 650, 'Mvila', 'CM', 'SU'),
(16672, 38, 650, 'Sangmélima', 'CM', 'SU'),
(16673, 38, 651, 'Bamusso', 'CM', 'SW'),
(16674, 38, 651, 'Bekondo', 'CM', 'SW'),
(16675, 38, 651, 'Buea', 'CM', 'SW'),
(16676, 38, 651, 'Fako Division', 'CM', 'SW'),
(16677, 38, 651, 'Fontem', 'CM', 'SW'),
(16678, 38, 651, 'Kumba', 'CM', 'SW'),
(16679, 38, 651, 'Lebialem', 'CM', 'SW'),
(16680, 38, 651, 'Limbe', 'CM', 'SW'),
(16681, 38, 651, 'Mamfe', 'CM', 'SW'),
(16682, 38, 651, 'Mundemba', 'CM', 'SW'),
(16683, 38, 651, 'Mutengene', 'CM', 'SW'),
(16684, 38, 651, 'Muyuka', 'CM', 'SW'),
(16685, 38, 651, 'Nguti', 'CM', 'SW'),
(16686, 38, 651, 'Tiko', 'CM', 'SW'),
(16687, 38, 652, 'Bafang', 'CM', 'OU'),
(16688, 38, 652, 'Bafoussam', 'CM', 'OU'),
(16689, 38, 652, 'Bamendjou', 'CM', 'OU'),
(16690, 38, 652, 'Bana', 'CM', 'OU'),
(16691, 38, 652, 'Bandjoun', 'CM', 'OU'),
(16692, 38, 652, 'Bangangté', 'CM', 'OU'),
(16693, 38, 652, 'Bansoa', 'CM', 'OU'),
(16694, 38, 652, 'Bazou', 'CM', 'OU'),
(16695, 38, 652, 'Dschang', 'CM', 'OU'),
(16696, 38, 652, 'Foumban', 'CM', 'OU'),
(16697, 38, 652, 'Foumbot', 'CM', 'OU'),
(16698, 38, 652, 'Hauts-Plateaux', 'CM', 'OU'),
(16699, 38, 652, 'Koung-Khi', 'CM', 'OU'),
(16700, 38, 652, 'Mbouda', 'CM', 'OU'),
(16701, 38, 652, 'Ngou', 'CM', 'OU'),
(16702, 38, 652, 'Noun', 'CM', 'OU'),
(16703, 38, 652, 'Tonga', 'CM', 'OU'),
(16704, 39, 653, 'Airdrie', 'CA', 'AB'),
(16705, 39, 653, 'Athabasca', 'CA', 'AB'),
(16706, 39, 653, 'Banff', 'CA', 'AB'),
(16707, 39, 653, 'Barrhead', 'CA', 'AB'),
(16708, 39, 653, 'Bassano', 'CA', 'AB'),
(16709, 39, 653, 'Beaumont', 'CA', 'AB'),
(16710, 39, 653, 'Beaverlodge', 'CA', 'AB'),
(16711, 39, 653, 'Black Diamond', 'CA', 'AB'),
(16712, 39, 653, 'Blackfalds', 'CA', 'AB'),
(16713, 39, 653, 'Bon Accord', 'CA', 'AB'),
(16714, 39, 653, 'Bonnyville', 'CA', 'AB'),
(16715, 39, 653, 'Bow Island', 'CA', 'AB'),
(16716, 39, 653, 'Brooks', 'CA', 'AB'),
(16717, 39, 653, 'Calgary', 'CA', 'AB'),
(16718, 39, 653, 'Calmar', 'CA', 'AB'),
(16719, 39, 653, 'Camrose', 'CA', 'AB'),
(16720, 39, 653, 'Canmore', 'CA', 'AB'),
(16721, 39, 653, 'Cardston', 'CA', 'AB'),
(16722, 39, 653, 'Carstairs', 'CA', 'AB'),
(16723, 39, 653, 'Chestermere', 'CA', 'AB'),
(16724, 39, 653, 'Claresholm', 'CA', 'AB'),
(16725, 39, 653, 'Coaldale', 'CA', 'AB'),
(16726, 39, 653, 'Coalhurst', 'CA', 'AB'),
(16727, 39, 653, 'Cochrane', 'CA', 'AB'),
(16728, 39, 653, 'Cold Lake', 'CA', 'AB'),
(16729, 39, 653, 'Crossfield', 'CA', 'AB'),
(16730, 39, 653, 'Devon', 'CA', 'AB'),
(16731, 39, 653, 'Didsbury', 'CA', 'AB'),
(16732, 39, 653, 'Drayton Valley', 'CA', 'AB'),
(16733, 39, 653, 'Edmonton', 'CA', 'AB'),
(16734, 39, 653, 'Edson', 'CA', 'AB'),
(16735, 39, 653, 'Elk Point', 'CA', 'AB'),
(16736, 39, 653, 'Fairview', 'CA', 'AB'),
(16737, 39, 653, 'Falher', 'CA', 'AB'),
(16738, 39, 653, 'Fort Macleod', 'CA', 'AB'),
(16739, 39, 653, 'Fort McMurray', 'CA', 'AB'),
(16740, 39, 653, 'Fort Saskatchewan', 'CA', 'AB'),
(16741, 39, 653, 'Fox Creek', 'CA', 'AB'),
(16742, 39, 653, 'Gibbons', 'CA', 'AB'),
(16743, 39, 653, 'Grand Centre', 'CA', 'AB'),
(16744, 39, 653, 'Grande Cache', 'CA', 'AB'),
(16745, 39, 653, 'Grande Prairie', 'CA', 'AB'),
(16746, 39, 653, 'Grimshaw', 'CA', 'AB'),
(16747, 39, 653, 'Hanna', 'CA', 'AB'),
(16748, 39, 653, 'Heritage Pointe', 'CA', 'AB'),
(16749, 39, 653, 'High Level', 'CA', 'AB'),
(16750, 39, 653, 'High Prairie', 'CA', 'AB'),
(16751, 39, 653, 'High River', 'CA', 'AB'),
(16752, 39, 653, 'Hinton', 'CA', 'AB'),
(16753, 39, 653, 'Irricana', 'CA', 'AB'),
(16754, 39, 653, 'Jasper Park Lodge', 'CA', 'AB'),
(16755, 39, 653, 'Killam', 'CA', 'AB'),
(16756, 39, 653, 'Lac La Biche', 'CA', 'AB'),
(16757, 39, 653, 'Lacombe', 'CA', 'AB'),
(16758, 39, 653, 'Lamont', 'CA', 'AB'),
(16759, 39, 653, 'Larkspur', 'CA', 'AB'),
(16760, 39, 653, 'Laurel', 'CA', 'AB'),
(16761, 39, 653, 'Leduc', 'CA', 'AB'),
(16762, 39, 653, 'Lethbridge', 'CA', 'AB'),
(16763, 39, 653, 'Lloydminster', 'CA', 'AB'),
(16764, 39, 653, 'Magrath', 'CA', 'AB'),
(16765, 39, 653, 'Manning', 'CA', 'AB'),
(16766, 39, 653, 'Mannville', 'CA', 'AB'),
(16767, 39, 653, 'Maple Ridge', 'CA', 'AB'),
(16768, 39, 653, 'Mayerthorpe', 'CA', 'AB'),
(16769, 39, 653, 'Medicine Hat', 'CA', 'AB'),
(16770, 39, 653, 'Mill Woods Town Centre', 'CA', 'AB'),
(16771, 39, 653, 'Millet', 'CA', 'AB'),
(16772, 39, 653, 'Morinville', 'CA', 'AB'),
(16773, 39, 653, 'Nanton', 'CA', 'AB'),
(16774, 39, 653, 'Okotoks', 'CA', 'AB'),
(16775, 39, 653, 'Olds', 'CA', 'AB'),
(16776, 39, 653, 'Peace River', 'CA', 'AB'),
(16777, 39, 653, 'Penhold', 'CA', 'AB'),
(16778, 39, 653, 'Picture Butte', 'CA', 'AB'),
(16779, 39, 653, 'Pincher Creek', 'CA', 'AB'),
(16780, 39, 653, 'Ponoka', 'CA', 'AB'),
(16781, 39, 653, 'Provost', 'CA', 'AB'),
(16782, 39, 653, 'Raymond', 'CA', 'AB'),
(16783, 39, 653, 'Red Deer', 'CA', 'AB'),
(16784, 39, 653, 'Rideau Park', 'CA', 'AB'),
(16785, 39, 653, 'Rimbey', 'CA', 'AB'),
(16786, 39, 653, 'Rocky Mountain House', 'CA', 'AB'),
(16787, 39, 653, 'Sexsmith', 'CA', 'AB'),
(16788, 39, 653, 'Sherwood Park', 'CA', 'AB'),
(16789, 39, 653, 'Silver Berry', 'CA', 'AB'),
(16790, 39, 653, 'Slave Lake', 'CA', 'AB'),
(16791, 39, 653, 'Smoky Lake', 'CA', 'AB'),
(16792, 39, 653, 'Spirit River', 'CA', 'AB'),
(16793, 39, 653, 'Springbrook', 'CA', 'AB'),
(16794, 39, 653, 'Spruce Grove', 'CA', 'AB'),
(16795, 39, 653, 'St. Albert', 'CA', 'AB'),
(16796, 39, 653, 'Stettler', 'CA', 'AB'),
(16797, 39, 653, 'Stony Plain', 'CA', 'AB'),
(16798, 39, 653, 'Strathmore', 'CA', 'AB'),
(16799, 39, 653, 'Sundre', 'CA', 'AB'),
(16800, 39, 653, 'Swan Hills', 'CA', 'AB'),
(16801, 39, 653, 'Sylvan Lake', 'CA', 'AB'),
(16802, 39, 653, 'Taber', 'CA', 'AB'),
(16803, 39, 653, 'Tamarack', 'CA', 'AB'),
(16804, 39, 653, 'Three Hills', 'CA', 'AB'),
(16805, 39, 653, 'Tofield', 'CA', 'AB'),
(16806, 39, 653, 'Two Hills', 'CA', 'AB'),
(16807, 39, 653, 'Valleyview', 'CA', 'AB'),
(16808, 39, 653, 'Vegreville', 'CA', 'AB'),
(16809, 39, 653, 'Vermilion', 'CA', 'AB'),
(16810, 39, 653, 'Viking', 'CA', 'AB'),
(16811, 39, 653, 'Vulcan', 'CA', 'AB'),
(16812, 39, 653, 'Wainwright', 'CA', 'AB'),
(16813, 39, 653, 'Wembley', 'CA', 'AB'),
(16814, 39, 653, 'Westlake', 'CA', 'AB'),
(16815, 39, 653, 'Westlock', 'CA', 'AB'),
(16816, 39, 653, 'Wetaskiwin', 'CA', 'AB'),
(16817, 39, 653, 'Whitecourt', 'CA', 'AB'),
(16818, 39, 653, 'Wild Rose', 'CA', 'AB'),
(16819, 39, 654, 'Abbotsford', 'CA', 'BC'),
(16820, 39, 654, 'Agassiz', 'CA', 'BC'),
(16821, 39, 654, 'Aldergrove', 'CA', 'BC'),
(16822, 39, 654, 'Aldergrove East', 'CA', 'BC'),
(16823, 39, 654, 'Anmore', 'CA', 'BC'),
(16824, 39, 654, 'Arbutus Ridge', 'CA', 'BC'),
(16825, 39, 654, 'Armstrong', 'CA', 'BC'),
(16826, 39, 654, 'Ashcroft', 'CA', 'BC'),
(16827, 39, 654, 'Barrière', 'CA', 'BC'),
(16828, 39, 654, 'Bowen Island', 'CA', 'BC'),
(16829, 39, 654, 'Burnaby', 'CA', 'BC'),
(16830, 39, 654, 'Burns Lake', 'CA', 'BC'),
(16831, 39, 654, 'Cache Creek', 'CA', 'BC'),
(16832, 39, 654, 'Campbell River', 'CA', 'BC'),
(16833, 39, 654, 'Castlegar', 'CA', 'BC'),
(16834, 39, 654, 'Cedar', 'CA', 'BC'),
(16835, 39, 654, 'Central Coast Regional District', 'CA', 'BC'),
(16836, 39, 654, 'Chase', 'CA', 'BC'),
(16837, 39, 654, 'Chemainus', 'CA', 'BC'),
(16838, 39, 654, 'Chetwynd', 'CA', 'BC'),
(16839, 39, 654, 'Chilliwack', 'CA', 'BC'),
(16840, 39, 654, 'Colwood', 'CA', 'BC'),
(16841, 39, 654, 'Coombs', 'CA', 'BC'),
(16842, 39, 654, 'Coquitlam', 'CA', 'BC'),
(16843, 39, 654, 'Courtenay', 'CA', 'BC'),
(16844, 39, 654, 'Cowichan Bay', 'CA', 'BC'),
(16845, 39, 654, 'Cranbrook', 'CA', 'BC'),
(16846, 39, 654, 'Creston', 'CA', 'BC'),
(16847, 39, 654, 'Cumberland', 'CA', 'BC'),
(16848, 39, 654, 'Dawson Creek', 'CA', 'BC'),
(16849, 39, 654, 'Delta', 'CA', 'BC'),
(16850, 39, 654, 'Denman Island', 'CA', 'BC'),
(16851, 39, 654, 'Denman Island Trust Area', 'CA', 'BC'),
(16852, 39, 654, 'Duck Lake', 'CA', 'BC'),
(16853, 39, 654, 'Duncan', 'CA', 'BC'),
(16854, 39, 654, 'East Wellington', 'CA', 'BC'),
(16855, 39, 654, 'Elkford', 'CA', 'BC'),
(16856, 39, 654, 'Ellison', 'CA', 'BC'),
(16857, 39, 654, 'Enderby', 'CA', 'BC'),
(16858, 39, 654, 'Fairwinds', 'CA', 'BC'),
(16859, 39, 654, 'Fernie', 'CA', 'BC'),
(16860, 39, 654, 'Fort Nelson', 'CA', 'BC'),
(16861, 39, 654, 'Fort St. John', 'CA', 'BC'),
(16862, 39, 654, 'Fraser Valley Regional District', 'CA', 'BC'),
(16863, 39, 654, 'French Creek', 'CA', 'BC'),
(16864, 39, 654, 'Fruitvale', 'CA', 'BC'),
(16865, 39, 654, 'Gibsons', 'CA', 'BC'),
(16866, 39, 654, 'Golden', 'CA', 'BC'),
(16867, 39, 654, 'Grand Forks', 'CA', 'BC'),
(16868, 39, 654, 'Hanceville', 'CA', 'BC'),
(16869, 39, 654, 'Hope', 'CA', 'BC'),
(16870, 39, 654, 'Hornby Island', 'CA', 'BC'),
(16871, 39, 654, 'Houston', 'CA', 'BC'),
(16872, 39, 654, 'Invermere', 'CA', 'BC'),
(16873, 39, 654, 'Kamloops', 'CA', 'BC'),
(16874, 39, 654, 'Kelowna', 'CA', 'BC'),
(16875, 39, 654, 'Kimberley', 'CA', 'BC'),
(16876, 39, 654, 'Kitimat', 'CA', 'BC'),
(16877, 39, 654, 'Ladner', 'CA', 'BC'),
(16878, 39, 654, 'Ladysmith', 'CA', 'BC'),
(16879, 39, 654, 'Lake Cowichan', 'CA', 'BC'),
(16880, 39, 654, 'Langford', 'CA', 'BC'),
(16881, 39, 654, 'Langley', 'CA', 'BC'),
(16882, 39, 654, 'Lillooet', 'CA', 'BC'),
(16883, 39, 654, 'Lions Bay', 'CA', 'BC'),
(16884, 39, 654, 'Logan Lake', 'CA', 'BC'),
(16885, 39, 654, 'Lumby', 'CA', 'BC'),
(16886, 39, 654, 'Mackenzie', 'CA', 'BC'),
(16887, 39, 654, 'Maple Ridge', 'CA', 'BC'),
(16888, 39, 654, 'Merritt', 'CA', 'BC'),
(16889, 39, 654, 'Metchosin', 'CA', 'BC'),
(16890, 39, 654, 'Metro Vancouver Regional District', 'CA', 'BC'),
(16891, 39, 654, 'Mission', 'CA', 'BC'),
(16892, 39, 654, 'Nakusp', 'CA', 'BC'),
(16893, 39, 654, 'Nanaimo', 'CA', 'BC'),
(16894, 39, 654, 'Nelson', 'CA', 'BC'),
(16895, 39, 654, 'New Westminster', 'CA', 'BC'),
(16896, 39, 654, 'North Cowichan', 'CA', 'BC'),
(16897, 39, 654, 'North Oyster/Yellow Point', 'CA', 'BC'),
(16898, 39, 654, 'North Saanich', 'CA', 'BC'),
(16899, 39, 654, 'North Vancouver', 'CA', 'BC'),
(16900, 39, 654, 'Oak Bay', 'CA', 'BC'),
(16901, 39, 654, 'Okanagan', 'CA', 'BC'),
(16902, 39, 654, 'Okanagan Falls', 'CA', 'BC'),
(16903, 39, 654, 'Oliver', 'CA', 'BC'),
(16904, 39, 654, 'Osoyoos', 'CA', 'BC'),
(16905, 39, 654, 'Parksville', 'CA', 'BC'),
(16906, 39, 654, 'Peace River Regional District', 'CA', 'BC'),
(16907, 39, 654, 'Peachland', 'CA', 'BC'),
(16908, 39, 654, 'Pemberton', 'CA', 'BC'),
(16909, 39, 654, 'Penticton', 'CA', 'BC'),
(16910, 39, 654, 'Pitt Meadows', 'CA', 'BC'),
(16911, 39, 654, 'Port Alberni', 'CA', 'BC'),
(16912, 39, 654, 'Port Coquitlam', 'CA', 'BC'),
(16913, 39, 654, 'Port McNeill', 'CA', 'BC'),
(16914, 39, 654, 'Port Moody', 'CA', 'BC'),
(16915, 39, 654, 'Powell River', 'CA', 'BC'),
(16916, 39, 654, 'Prince George', 'CA', 'BC'),
(16917, 39, 654, 'Prince Rupert', 'CA', 'BC'),
(16918, 39, 654, 'Princeton', 'CA', 'BC'),
(16919, 39, 654, 'Puntledge', 'CA', 'BC'),
(16920, 39, 654, 'Quesnel', 'CA', 'BC'),
(16921, 39, 654, 'Regional District of Alberni-Clayoquot', 'CA', 'BC'),
(16922, 39, 654, 'Regional District of Central Okanagan', 'CA', 'BC'),
(16923, 39, 654, 'Revelstoke', 'CA', 'BC'),
(16924, 39, 654, 'Richmond', 'CA', 'BC'),
(16925, 39, 654, 'Rossland', 'CA', 'BC'),
(16926, 39, 654, 'Royston', 'CA', 'BC'),
(16927, 39, 654, 'Salmo', 'CA', 'BC'),
(16928, 39, 654, 'Salmon Arm', 'CA', 'BC'),
(16929, 39, 654, 'Salt Spring Island', 'CA', 'BC'),
(16930, 39, 654, 'Saltair', 'CA', 'BC'),
(16931, 39, 654, 'Sechelt', 'CA', 'BC'),
(16932, 39, 654, 'Sicamous', 'CA', 'BC'),
(16933, 39, 654, 'Six Mile', 'CA', 'BC'),
(16934, 39, 654, 'Smithers', 'CA', 'BC'),
(16935, 39, 654, 'Sooke', 'CA', 'BC'),
(16936, 39, 654, 'South Pender Harbour', 'CA', 'BC'),
(16937, 39, 654, 'Sparwood', 'CA', 'BC'),
(16938, 39, 654, 'Summerland', 'CA', 'BC'),
(16939, 39, 654, 'Surrey', 'CA', 'BC'),
(16940, 39, 654, 'Terrace', 'CA', 'BC'),
(16941, 39, 654, 'Tofino', 'CA', 'BC'),
(16942, 39, 654, 'Trail', 'CA', 'BC'),
(16943, 39, 654, 'Tsawwassen', 'CA', 'BC'),
(16944, 39, 654, 'Tumbler Ridge', 'CA', 'BC'),
(16945, 39, 654, 'Ucluelet', 'CA', 'BC'),
(16946, 39, 654, 'Vancouver', 'CA', 'BC'),
(16947, 39, 654, 'Vanderhoof', 'CA', 'BC'),
(16948, 39, 654, 'Vernon', 'CA', 'BC'),
(16949, 39, 654, 'Victoria', 'CA', 'BC'),
(16950, 39, 654, 'Walnut Grove', 'CA', 'BC'),
(16951, 39, 654, 'Welcome Beach', 'CA', 'BC'),
(16952, 39, 654, 'West End', 'CA', 'BC'),
(16953, 39, 654, 'West Kelowna', 'CA', 'BC'),
(16954, 39, 654, 'West Vancouver', 'CA', 'BC'),
(16955, 39, 654, 'Whistler', 'CA', 'BC'),
(16956, 39, 654, 'White Rock', 'CA', 'BC'),
(16957, 39, 654, 'Williams Lake', 'CA', 'BC'),
(16958, 39, 655, 'Altona', 'CA', 'MB'),
(16959, 39, 655, 'Beausejour', 'CA', 'MB'),
(16960, 39, 655, 'Boissevain', 'CA', 'MB'),
(16961, 39, 655, 'Brandon', 'CA', 'MB'),
(16962, 39, 655, 'Carberry', 'CA', 'MB'),
(16963, 39, 655, 'Carman', 'CA', 'MB'),
(16964, 39, 655, 'Cross Lake 19A', 'CA', 'MB'),
(16965, 39, 655, 'Dauphin', 'CA', 'MB'),
(16966, 39, 655, 'De Salaberry', 'CA', 'MB'),
(16967, 39, 655, 'Deloraine', 'CA', 'MB'),
(16968, 39, 655, 'Flin Flon', 'CA', 'MB'),
(16969, 39, 655, 'Gimli', 'CA', 'MB'),
(16970, 39, 655, 'Grunthal', 'CA', 'MB'),
(16971, 39, 655, 'Headingley', 'CA', 'MB'),
(16972, 39, 655, 'Ile des Chênes', 'CA', 'MB'),
(16973, 39, 655, 'Killarney', 'CA', 'MB'),
(16974, 39, 655, 'La Broquerie', 'CA', 'MB'),
(16975, 39, 655, 'Lac du Bonnet', 'CA', 'MB'),
(16976, 39, 655, 'Landmark', 'CA', 'MB'),
(16977, 39, 655, 'Lorette', 'CA', 'MB'),
(16978, 39, 655, 'Melita', 'CA', 'MB'),
(16979, 39, 655, 'Minnedosa', 'CA', 'MB'),
(16980, 39, 655, 'Moose Lake', 'CA', 'MB'),
(16981, 39, 655, 'Morden', 'CA', 'MB'),
(16982, 39, 655, 'Morris', 'CA', 'MB'),
(16983, 39, 655, 'Neepawa', 'CA', 'MB'),
(16984, 39, 655, 'Niverville', 'CA', 'MB'),
(16985, 39, 655, 'Portage la Prairie', 'CA', 'MB'),
(16986, 39, 655, 'Rivers', 'CA', 'MB'),
(16987, 39, 655, 'Roblin', 'CA', 'MB'),
(16988, 39, 655, 'Selkirk', 'CA', 'MB'),
(16989, 39, 655, 'Shilo', 'CA', 'MB'),
(16990, 39, 655, 'Souris', 'CA', 'MB'),
(16991, 39, 655, 'St. Adolphe', 'CA', 'MB'),
(16992, 39, 655, 'Steinbach', 'CA', 'MB'),
(16993, 39, 655, 'Stonewall', 'CA', 'MB'),
(16994, 39, 655, 'Swan River', 'CA', 'MB'),
(16995, 39, 655, 'The Pas', 'CA', 'MB'),
(16996, 39, 655, 'Thompson', 'CA', 'MB'),
(16997, 39, 655, 'Virden', 'CA', 'MB'),
(16998, 39, 655, 'West St. Paul', 'CA', 'MB'),
(16999, 39, 655, 'Winkler', 'CA', 'MB'),
(17000, 39, 655, 'Winnipeg', 'CA', 'MB');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(17001, 39, 656, 'Baie Ste. Anne', 'CA', 'NB'),
(17002, 39, 656, 'Bathurst', 'CA', 'NB'),
(17003, 39, 656, 'Bouctouche', 'CA', 'NB'),
(17004, 39, 656, 'Campbellton', 'CA', 'NB'),
(17005, 39, 656, 'Dieppe', 'CA', 'NB'),
(17006, 39, 656, 'Edmundston', 'CA', 'NB'),
(17007, 39, 656, 'Florenceville-Bristol', 'CA', 'NB'),
(17008, 39, 656, 'Fredericton', 'CA', 'NB'),
(17009, 39, 656, 'Fundy Bay', 'CA', 'NB'),
(17010, 39, 656, 'Grande-Digue', 'CA', 'NB'),
(17011, 39, 656, 'Greater Lakeburn', 'CA', 'NB'),
(17012, 39, 656, 'Hampton', 'CA', 'NB'),
(17013, 39, 656, 'Harrison Brook', 'CA', 'NB'),
(17014, 39, 656, 'Keswick Ridge', 'CA', 'NB'),
(17015, 39, 656, 'Lincoln', 'CA', 'NB'),
(17016, 39, 656, 'Lutes Mountain', 'CA', 'NB'),
(17017, 39, 656, 'McEwen', 'CA', 'NB'),
(17018, 39, 656, 'Miramichi', 'CA', 'NB'),
(17019, 39, 656, 'Moncton', 'CA', 'NB'),
(17020, 39, 656, 'Nackawic', 'CA', 'NB'),
(17021, 39, 656, 'New Maryland', 'CA', 'NB'),
(17022, 39, 656, 'Noonan', 'CA', 'NB'),
(17023, 39, 656, 'Oromocto', 'CA', 'NB'),
(17024, 39, 656, 'Richibucto', 'CA', 'NB'),
(17025, 39, 656, 'Sackville', 'CA', 'NB'),
(17026, 39, 656, 'Saint Andrews', 'CA', 'NB'),
(17027, 39, 656, 'Saint John', 'CA', 'NB'),
(17028, 39, 656, 'Saint-Antoine', 'CA', 'NB'),
(17029, 39, 656, 'Saint-Léonard', 'CA', 'NB'),
(17030, 39, 656, 'Salisbury', 'CA', 'NB'),
(17031, 39, 656, 'Shediac', 'CA', 'NB'),
(17032, 39, 656, 'Shediac Bridge-Shediac River', 'CA', 'NB'),
(17033, 39, 656, 'Shippagan', 'CA', 'NB'),
(17034, 39, 656, 'Starlight Village', 'CA', 'NB'),
(17035, 39, 656, 'Sussex', 'CA', 'NB'),
(17036, 39, 656, 'Tracadie-Sheila', 'CA', 'NB'),
(17037, 39, 656, 'Wells', 'CA', 'NB'),
(17038, 39, 657, 'Bay Roberts', 'CA', 'NL'),
(17039, 39, 657, 'Bay St. George South', 'CA', 'NL'),
(17040, 39, 657, 'Bonavista', 'CA', 'NL'),
(17041, 39, 657, 'Botwood', 'CA', 'NL'),
(17042, 39, 657, 'Burgeo', 'CA', 'NL'),
(17043, 39, 657, 'Carbonear', 'CA', 'NL'),
(17044, 39, 657, 'Catalina', 'CA', 'NL'),
(17045, 39, 657, 'Channel-Port aux Basques', 'CA', 'NL'),
(17046, 39, 657, 'Clarenville-Shoal Harbour', 'CA', 'NL'),
(17047, 39, 657, 'Conception Bay South', 'CA', 'NL'),
(17048, 39, 657, 'Corner Brook', 'CA', 'NL'),
(17049, 39, 657, 'Deer Lake', 'CA', 'NL'),
(17050, 39, 657, 'Fogo Island', 'CA', 'NL'),
(17051, 39, 657, 'Gambo', 'CA', 'NL'),
(17052, 39, 657, 'Goulds', 'CA', 'NL'),
(17053, 39, 657, 'Grand Bank', 'CA', 'NL'),
(17054, 39, 657, 'Grand Falls-Windsor', 'CA', 'NL'),
(17055, 39, 657, 'Happy Valley-Goose Bay', 'CA', 'NL'),
(17056, 39, 657, 'Harbour Breton', 'CA', 'NL'),
(17057, 39, 657, 'Labrador City', 'CA', 'NL'),
(17058, 39, 657, 'Lewisporte', 'CA', 'NL'),
(17059, 39, 657, 'Marystown', 'CA', 'NL'),
(17060, 39, 657, 'Mount Pearl', 'CA', 'NL'),
(17061, 39, 657, 'Pasadena', 'CA', 'NL'),
(17062, 39, 657, 'Springdale', 'CA', 'NL'),
(17063, 39, 657, 'St. Anthony', 'CA', 'NL'),
(17064, 39, 657, 'St. John\'s', 'CA', 'NL'),
(17065, 39, 657, 'Stephenville', 'CA', 'NL'),
(17066, 39, 657, 'Stephenville Crossing', 'CA', 'NL'),
(17067, 39, 657, 'Torbay', 'CA', 'NL'),
(17068, 39, 657, 'Upper Island Cove', 'CA', 'NL'),
(17069, 39, 657, 'Wabana', 'CA', 'NL'),
(17070, 39, 658, 'Behchokǫ̀', 'CA', 'NT'),
(17071, 39, 658, 'Fort McPherson', 'CA', 'NT'),
(17072, 39, 658, 'Fort Smith', 'CA', 'NT'),
(17073, 39, 658, 'Hay River', 'CA', 'NT'),
(17074, 39, 658, 'Inuvik', 'CA', 'NT'),
(17075, 39, 658, 'Norman Wells', 'CA', 'NT'),
(17076, 39, 658, 'Yellowknife', 'CA', 'NT'),
(17077, 39, 659, 'Amherst', 'CA', 'NS'),
(17078, 39, 659, 'Annapolis County', 'CA', 'NS'),
(17079, 39, 659, 'Antigonish', 'CA', 'NS'),
(17080, 39, 659, 'Berwick', 'CA', 'NS'),
(17081, 39, 659, 'Bridgewater', 'CA', 'NS'),
(17082, 39, 659, 'Cape Breton County', 'CA', 'NS'),
(17083, 39, 659, 'Chester', 'CA', 'NS'),
(17084, 39, 659, 'Colchester', 'CA', 'NS'),
(17085, 39, 659, 'Cole Harbour', 'CA', 'NS'),
(17086, 39, 659, 'Cow Bay', 'CA', 'NS'),
(17087, 39, 659, 'Dartmouth', 'CA', 'NS'),
(17088, 39, 659, 'Digby', 'CA', 'NS'),
(17089, 39, 659, 'Digby County', 'CA', 'NS'),
(17090, 39, 659, 'English Corner', 'CA', 'NS'),
(17091, 39, 659, 'Eskasoni 3', 'CA', 'NS'),
(17092, 39, 659, 'Fall River', 'CA', 'NS'),
(17093, 39, 659, 'Glace Bay', 'CA', 'NS'),
(17094, 39, 659, 'Greenwood', 'CA', 'NS'),
(17095, 39, 659, 'Halifax', 'CA', 'NS'),
(17096, 39, 659, 'Hantsport', 'CA', 'NS'),
(17097, 39, 659, 'Hayes Subdivision', 'CA', 'NS'),
(17098, 39, 659, 'Kentville', 'CA', 'NS'),
(17099, 39, 659, 'Lake Echo', 'CA', 'NS'),
(17100, 39, 659, 'Lantz', 'CA', 'NS'),
(17101, 39, 659, 'Lower Sackville', 'CA', 'NS'),
(17102, 39, 659, 'Lunenburg', 'CA', 'NS'),
(17103, 39, 659, 'Middleton', 'CA', 'NS'),
(17104, 39, 659, 'New Glasgow', 'CA', 'NS'),
(17105, 39, 659, 'Oxford', 'CA', 'NS'),
(17106, 39, 659, 'Parrsboro', 'CA', 'NS'),
(17107, 39, 659, 'Pictou', 'CA', 'NS'),
(17108, 39, 659, 'Pictou County', 'CA', 'NS'),
(17109, 39, 659, 'Port Hawkesbury', 'CA', 'NS'),
(17110, 39, 659, 'Port Williams', 'CA', 'NS'),
(17111, 39, 659, 'Princeville', 'CA', 'NS'),
(17112, 39, 659, 'Shelburne', 'CA', 'NS'),
(17113, 39, 659, 'Springhill', 'CA', 'NS'),
(17114, 39, 659, 'Sydney', 'CA', 'NS'),
(17115, 39, 659, 'Sydney Mines', 'CA', 'NS'),
(17116, 39, 659, 'Truro', 'CA', 'NS'),
(17117, 39, 659, 'Windsor', 'CA', 'NS'),
(17118, 39, 659, 'Wolfville', 'CA', 'NS'),
(17119, 39, 659, 'Yarmouth', 'CA', 'NS'),
(17120, 39, 660, 'Clyde River', 'CA', 'NU'),
(17121, 39, 660, 'Gjoa Haven', 'CA', 'NU'),
(17122, 39, 660, 'Iqaluit', 'CA', 'NU'),
(17123, 39, 660, 'Kugluktuk', 'CA', 'NU'),
(17124, 39, 660, 'Pangnirtung', 'CA', 'NU'),
(17125, 39, 660, 'Rankin Inlet', 'CA', 'NU'),
(17126, 39, 661, 'Ajax', 'CA', 'ON'),
(17127, 39, 661, 'Algoma', 'CA', 'ON'),
(17128, 39, 661, 'Alliston', 'CA', 'ON'),
(17129, 39, 661, 'Amherstburg', 'CA', 'ON'),
(17130, 39, 661, 'Amigo Beach', 'CA', 'ON'),
(17131, 39, 661, 'Ancaster', 'CA', 'ON'),
(17132, 39, 661, 'Angus', 'CA', 'ON'),
(17133, 39, 661, 'Arnprior', 'CA', 'ON'),
(17134, 39, 661, 'Atikokan', 'CA', 'ON'),
(17135, 39, 661, 'Attawapiskat', 'CA', 'ON'),
(17136, 39, 661, 'Aurora', 'CA', 'ON'),
(17137, 39, 661, 'Aylmer', 'CA', 'ON'),
(17138, 39, 661, 'Azilda', 'CA', 'ON'),
(17139, 39, 661, 'Ballantrae', 'CA', 'ON'),
(17140, 39, 661, 'Bancroft', 'CA', 'ON'),
(17141, 39, 661, 'Barrie', 'CA', 'ON'),
(17142, 39, 661, 'Bath', 'CA', 'ON'),
(17143, 39, 661, 'Belleville', 'CA', 'ON'),
(17144, 39, 661, 'Bells Corners', 'CA', 'ON'),
(17145, 39, 661, 'Belmont', 'CA', 'ON'),
(17146, 39, 661, 'Binbrook', 'CA', 'ON'),
(17147, 39, 661, 'Bluewater', 'CA', 'ON'),
(17148, 39, 661, 'Bourget', 'CA', 'ON'),
(17149, 39, 661, 'Bracebridge', 'CA', 'ON'),
(17150, 39, 661, 'Brampton', 'CA', 'ON'),
(17151, 39, 661, 'Brant', 'CA', 'ON'),
(17152, 39, 661, 'Brantford', 'CA', 'ON'),
(17153, 39, 661, 'Brockville', 'CA', 'ON'),
(17154, 39, 661, 'Brussels', 'CA', 'ON'),
(17155, 39, 661, 'Burford', 'CA', 'ON'),
(17156, 39, 661, 'Burlington', 'CA', 'ON'),
(17157, 39, 661, 'Cambridge', 'CA', 'ON'),
(17158, 39, 661, 'Camlachie', 'CA', 'ON'),
(17159, 39, 661, 'Capreol', 'CA', 'ON'),
(17160, 39, 661, 'Carleton Place', 'CA', 'ON'),
(17161, 39, 661, 'Casselman', 'CA', 'ON'),
(17162, 39, 661, 'Chatham', 'CA', 'ON'),
(17163, 39, 661, 'Chatham-Kent', 'CA', 'ON'),
(17164, 39, 661, 'Clarence-Rockland', 'CA', 'ON'),
(17165, 39, 661, 'Cobourg', 'CA', 'ON'),
(17166, 39, 661, 'Cochrane District', 'CA', 'ON'),
(17167, 39, 661, 'Collingwood', 'CA', 'ON'),
(17168, 39, 661, 'Concord', 'CA', 'ON'),
(17169, 39, 661, 'Constance Bay', 'CA', 'ON'),
(17170, 39, 661, 'Cookstown', 'CA', 'ON'),
(17171, 39, 661, 'Cornwall', 'CA', 'ON'),
(17172, 39, 661, 'Corunna', 'CA', 'ON'),
(17173, 39, 661, 'Deep River', 'CA', 'ON'),
(17174, 39, 661, 'Delaware', 'CA', 'ON'),
(17175, 39, 661, 'Deseronto', 'CA', 'ON'),
(17176, 39, 661, 'Dorchester', 'CA', 'ON'),
(17177, 39, 661, 'Dowling', 'CA', 'ON'),
(17178, 39, 661, 'Dryden', 'CA', 'ON'),
(17179, 39, 661, 'Durham', 'CA', 'ON'),
(17180, 39, 661, 'Ear Falls', 'CA', 'ON'),
(17181, 39, 661, 'East Gwillimbury', 'CA', 'ON'),
(17182, 39, 661, 'East York', 'CA', 'ON'),
(17183, 39, 661, 'Elliot Lake', 'CA', 'ON'),
(17184, 39, 661, 'Elmvale', 'CA', 'ON'),
(17185, 39, 661, 'Englehart', 'CA', 'ON'),
(17186, 39, 661, 'Espanola', 'CA', 'ON'),
(17187, 39, 661, 'Essex', 'CA', 'ON'),
(17188, 39, 661, 'Etobicoke', 'CA', 'ON'),
(17189, 39, 661, 'Fort Erie', 'CA', 'ON'),
(17190, 39, 661, 'Fort Frances', 'CA', 'ON'),
(17191, 39, 661, 'Gananoque', 'CA', 'ON'),
(17192, 39, 661, 'Glencoe', 'CA', 'ON'),
(17193, 39, 661, 'Goderich', 'CA', 'ON'),
(17194, 39, 661, 'Golden', 'CA', 'ON'),
(17195, 39, 661, 'Gravenhurst', 'CA', 'ON'),
(17196, 39, 661, 'Greater Napanee', 'CA', 'ON'),
(17197, 39, 661, 'Greater Sudbury', 'CA', 'ON'),
(17198, 39, 661, 'Greenstone', 'CA', 'ON'),
(17199, 39, 661, 'Guelph', 'CA', 'ON'),
(17200, 39, 661, 'Haldimand County', 'CA', 'ON'),
(17201, 39, 661, 'Haliburton Village', 'CA', 'ON'),
(17202, 39, 661, 'Halton', 'CA', 'ON'),
(17203, 39, 661, 'Hamilton', 'CA', 'ON'),
(17204, 39, 661, 'Hanover', 'CA', 'ON'),
(17205, 39, 661, 'Harriston', 'CA', 'ON'),
(17206, 39, 661, 'Hawkesbury', 'CA', 'ON'),
(17207, 39, 661, 'Hearst', 'CA', 'ON'),
(17208, 39, 661, 'Hornepayne', 'CA', 'ON'),
(17209, 39, 661, 'Huntsville', 'CA', 'ON'),
(17210, 39, 661, 'Huron East', 'CA', 'ON'),
(17211, 39, 661, 'Ingersoll', 'CA', 'ON'),
(17212, 39, 661, 'Innisfil', 'CA', 'ON'),
(17213, 39, 661, 'Iroquois Falls', 'CA', 'ON'),
(17214, 39, 661, 'Jarvis', 'CA', 'ON'),
(17215, 39, 661, 'Kanata', 'CA', 'ON'),
(17216, 39, 661, 'Kapuskasing', 'CA', 'ON'),
(17217, 39, 661, 'Kawartha Lakes', 'CA', 'ON'),
(17218, 39, 661, 'Kenora', 'CA', 'ON'),
(17219, 39, 661, 'Keswick', 'CA', 'ON'),
(17220, 39, 661, 'Kincardine', 'CA', 'ON'),
(17221, 39, 661, 'King', 'CA', 'ON'),
(17222, 39, 661, 'Kingston', 'CA', 'ON'),
(17223, 39, 661, 'Kirkland Lake', 'CA', 'ON'),
(17224, 39, 661, 'Kitchener', 'CA', 'ON'),
(17225, 39, 661, 'L\'Orignal', 'CA', 'ON'),
(17226, 39, 661, 'Lakefield', 'CA', 'ON'),
(17227, 39, 661, 'Lambton Shores', 'CA', 'ON'),
(17228, 39, 661, 'Lappe', 'CA', 'ON'),
(17229, 39, 661, 'Leamington', 'CA', 'ON'),
(17230, 39, 661, 'Limoges', 'CA', 'ON'),
(17231, 39, 661, 'Lindsay', 'CA', 'ON'),
(17232, 39, 661, 'Listowel', 'CA', 'ON'),
(17233, 39, 661, 'Little Current', 'CA', 'ON'),
(17234, 39, 661, 'Lively', 'CA', 'ON'),
(17235, 39, 661, 'London', 'CA', 'ON'),
(17236, 39, 661, 'Lucan', 'CA', 'ON'),
(17237, 39, 661, 'Madoc', 'CA', 'ON'),
(17238, 39, 661, 'Manitoulin District', 'CA', 'ON'),
(17239, 39, 661, 'Manitouwadge', 'CA', 'ON'),
(17240, 39, 661, 'Marathon', 'CA', 'ON'),
(17241, 39, 661, 'Markdale', 'CA', 'ON'),
(17242, 39, 661, 'Markham', 'CA', 'ON'),
(17243, 39, 661, 'Mattawa', 'CA', 'ON'),
(17244, 39, 661, 'Meaford', 'CA', 'ON'),
(17245, 39, 661, 'Metcalfe', 'CA', 'ON'),
(17246, 39, 661, 'Midland', 'CA', 'ON'),
(17247, 39, 661, 'Mildmay', 'CA', 'ON'),
(17248, 39, 661, 'Millbrook', 'CA', 'ON'),
(17249, 39, 661, 'Milton', 'CA', 'ON'),
(17250, 39, 661, 'Mississauga', 'CA', 'ON'),
(17251, 39, 661, 'Mississauga Beach', 'CA', 'ON'),
(17252, 39, 661, 'Moose Factory', 'CA', 'ON'),
(17253, 39, 661, 'Moosonee', 'CA', 'ON'),
(17254, 39, 661, 'Morrisburg', 'CA', 'ON'),
(17255, 39, 661, 'Mount Albert', 'CA', 'ON'),
(17256, 39, 661, 'Mount Brydges', 'CA', 'ON'),
(17257, 39, 661, 'Napanee', 'CA', 'ON'),
(17258, 39, 661, 'Napanee Downtown', 'CA', 'ON'),
(17259, 39, 661, 'Neebing', 'CA', 'ON'),
(17260, 39, 661, 'Nepean', 'CA', 'ON'),
(17261, 39, 661, 'New Hamburg', 'CA', 'ON'),
(17262, 39, 661, 'Newmarket', 'CA', 'ON'),
(17263, 39, 661, 'Niagara Falls', 'CA', 'ON'),
(17264, 39, 661, 'Nipissing District', 'CA', 'ON'),
(17265, 39, 661, 'Norfolk County', 'CA', 'ON'),
(17266, 39, 661, 'North Bay', 'CA', 'ON'),
(17267, 39, 661, 'North Perth', 'CA', 'ON'),
(17268, 39, 661, 'North York', 'CA', 'ON'),
(17269, 39, 661, 'Norwood', 'CA', 'ON'),
(17270, 39, 661, 'Oakville', 'CA', 'ON'),
(17271, 39, 661, 'Omemee', 'CA', 'ON'),
(17272, 39, 661, 'Orangeville', 'CA', 'ON'),
(17273, 39, 661, 'Orillia', 'CA', 'ON'),
(17274, 39, 661, 'Osgoode', 'CA', 'ON'),
(17275, 39, 661, 'Oshawa', 'CA', 'ON'),
(17276, 39, 661, 'Ottawa', 'CA', 'ON'),
(17277, 39, 661, 'Owen Sound', 'CA', 'ON'),
(17278, 39, 661, 'Paisley', 'CA', 'ON'),
(17279, 39, 661, 'Paris', 'CA', 'ON'),
(17280, 39, 661, 'Parkhill', 'CA', 'ON'),
(17281, 39, 661, 'Parry Sound', 'CA', 'ON'),
(17282, 39, 661, 'Parry Sound District', 'CA', 'ON'),
(17283, 39, 661, 'Peel', 'CA', 'ON'),
(17284, 39, 661, 'Pembroke', 'CA', 'ON'),
(17285, 39, 661, 'Perth', 'CA', 'ON'),
(17286, 39, 661, 'Petawawa', 'CA', 'ON'),
(17287, 39, 661, 'Peterborough', 'CA', 'ON'),
(17288, 39, 661, 'Petrolia', 'CA', 'ON'),
(17289, 39, 661, 'Pickering', 'CA', 'ON'),
(17290, 39, 661, 'Picton', 'CA', 'ON'),
(17291, 39, 661, 'Plantagenet', 'CA', 'ON'),
(17292, 39, 661, 'Plattsville', 'CA', 'ON'),
(17293, 39, 661, 'Port Colborne', 'CA', 'ON'),
(17294, 39, 661, 'Port Hope', 'CA', 'ON'),
(17295, 39, 661, 'Port Rowan', 'CA', 'ON'),
(17296, 39, 661, 'Port Stanley', 'CA', 'ON'),
(17297, 39, 661, 'Powassan', 'CA', 'ON'),
(17298, 39, 661, 'Prescott', 'CA', 'ON'),
(17299, 39, 661, 'Prince Edward', 'CA', 'ON'),
(17300, 39, 661, 'Queenswood Heights', 'CA', 'ON'),
(17301, 39, 661, 'Quinte West', 'CA', 'ON'),
(17302, 39, 661, 'Rainy River District', 'CA', 'ON'),
(17303, 39, 661, 'Rayside-Balfour', 'CA', 'ON'),
(17304, 39, 661, 'Red Lake', 'CA', 'ON'),
(17305, 39, 661, 'Regional Municipality of Waterloo', 'CA', 'ON'),
(17306, 39, 661, 'Renfrew', 'CA', 'ON'),
(17307, 39, 661, 'Richmond', 'CA', 'ON'),
(17308, 39, 661, 'Richmond Hill', 'CA', 'ON'),
(17309, 39, 661, 'Ridgetown', 'CA', 'ON'),
(17310, 39, 661, 'Rockwood', 'CA', 'ON'),
(17311, 39, 661, 'Russell', 'CA', 'ON'),
(17312, 39, 661, 'Sarnia', 'CA', 'ON'),
(17313, 39, 661, 'Sault Ste. Marie', 'CA', 'ON'),
(17314, 39, 661, 'Scarborough', 'CA', 'ON'),
(17315, 39, 661, 'Seaforth', 'CA', 'ON'),
(17316, 39, 661, 'Shelburne', 'CA', 'ON'),
(17317, 39, 661, 'Simcoe', 'CA', 'ON'),
(17318, 39, 661, 'Sioux Lookout', 'CA', 'ON'),
(17319, 39, 661, 'Skatepark', 'CA', 'ON'),
(17320, 39, 661, 'Smiths Falls', 'CA', 'ON'),
(17321, 39, 661, 'South Huron', 'CA', 'ON'),
(17322, 39, 661, 'South River', 'CA', 'ON'),
(17323, 39, 661, 'St. Catharines', 'CA', 'ON'),
(17324, 39, 661, 'St. George', 'CA', 'ON'),
(17325, 39, 661, 'St. Thomas', 'CA', 'ON'),
(17326, 39, 661, 'Stirling', 'CA', 'ON'),
(17327, 39, 661, 'Stoney Point', 'CA', 'ON'),
(17328, 39, 661, 'Stratford', 'CA', 'ON'),
(17329, 39, 661, 'Sudbury', 'CA', 'ON'),
(17330, 39, 661, 'Tavistock', 'CA', 'ON'),
(17331, 39, 661, 'Temiskaming Shores', 'CA', 'ON'),
(17332, 39, 661, 'Thessalon', 'CA', 'ON'),
(17333, 39, 661, 'Thornhill', 'CA', 'ON'),
(17334, 39, 661, 'Thorold', 'CA', 'ON'),
(17335, 39, 661, 'Thunder Bay', 'CA', 'ON'),
(17336, 39, 661, 'Thunder Bay District', 'CA', 'ON'),
(17337, 39, 661, 'Timiskaming District', 'CA', 'ON'),
(17338, 39, 661, 'Timmins', 'CA', 'ON'),
(17339, 39, 661, 'Tobermory', 'CA', 'ON'),
(17340, 39, 661, 'Toronto', 'CA', 'ON'),
(17341, 39, 661, 'Toronto county', 'CA', 'ON'),
(17342, 39, 661, 'Tottenham', 'CA', 'ON'),
(17343, 39, 661, 'Tweed', 'CA', 'ON'),
(17344, 39, 661, 'Uxbridge', 'CA', 'ON'),
(17345, 39, 661, 'Valley East', 'CA', 'ON'),
(17346, 39, 661, 'Vanier', 'CA', 'ON'),
(17347, 39, 661, 'Vaughan', 'CA', 'ON'),
(17348, 39, 661, 'Vineland', 'CA', 'ON'),
(17349, 39, 661, 'Virgil', 'CA', 'ON'),
(17350, 39, 661, 'Walpole Island', 'CA', 'ON'),
(17351, 39, 661, 'Wasaga Beach', 'CA', 'ON'),
(17352, 39, 661, 'Waterford', 'CA', 'ON'),
(17353, 39, 661, 'Waterloo', 'CA', 'ON'),
(17354, 39, 661, 'Watford', 'CA', 'ON'),
(17355, 39, 661, 'Wawa', 'CA', 'ON'),
(17356, 39, 661, 'Welland', 'CA', 'ON'),
(17357, 39, 661, 'Wellesley', 'CA', 'ON'),
(17358, 39, 661, 'Wendover', 'CA', 'ON'),
(17359, 39, 661, 'West Lorne', 'CA', 'ON'),
(17360, 39, 661, 'Willowdale', 'CA', 'ON'),
(17361, 39, 661, 'Winchester', 'CA', 'ON'),
(17362, 39, 661, 'Windsor', 'CA', 'ON'),
(17363, 39, 661, 'Wingham', 'CA', 'ON'),
(17364, 39, 661, 'Woodstock', 'CA', 'ON'),
(17365, 39, 661, 'York', 'CA', 'ON'),
(17366, 39, 662, 'Alberton', 'CA', 'PE'),
(17367, 39, 662, 'Belfast', 'CA', 'PE'),
(17368, 39, 662, 'Charlottetown', 'CA', 'PE'),
(17369, 39, 662, 'Cornwall', 'CA', 'PE'),
(17370, 39, 662, 'Fallingbrook', 'CA', 'PE'),
(17371, 39, 662, 'Kensington', 'CA', 'PE'),
(17372, 39, 662, 'Montague', 'CA', 'PE'),
(17373, 39, 662, 'Souris', 'CA', 'PE'),
(17374, 39, 662, 'Summerside', 'CA', 'PE'),
(17375, 39, 663, 'Abitibi-Témiscamingue', 'CA', 'QC'),
(17376, 39, 663, 'Acton Vale', 'CA', 'QC'),
(17377, 39, 663, 'Adstock', 'CA', 'QC'),
(17378, 39, 663, 'Albanel', 'CA', 'QC'),
(17379, 39, 663, 'Alma', 'CA', 'QC'),
(17380, 39, 663, 'Amos', 'CA', 'QC'),
(17381, 39, 663, 'Amqui', 'CA', 'QC'),
(17382, 39, 663, 'Ange-Gardien', 'CA', 'QC'),
(17383, 39, 663, 'Asbestos', 'CA', 'QC'),
(17384, 39, 663, 'Baie-Comeau', 'CA', 'QC'),
(17385, 39, 663, 'Baie-D\'Urfé', 'CA', 'QC'),
(17386, 39, 663, 'Baie-Saint-Paul', 'CA', 'QC'),
(17387, 39, 663, 'Barraute', 'CA', 'QC'),
(17388, 39, 663, 'Bas-Saint-Laurent', 'CA', 'QC'),
(17389, 39, 663, 'Beaconsfield', 'CA', 'QC'),
(17390, 39, 663, 'Beauceville', 'CA', 'QC'),
(17391, 39, 663, 'Beauharnois', 'CA', 'QC'),
(17392, 39, 663, 'Beaupré', 'CA', 'QC'),
(17393, 39, 663, 'Bécancour', 'CA', 'QC'),
(17394, 39, 663, 'Bedford', 'CA', 'QC'),
(17395, 39, 663, 'Beloeil', 'CA', 'QC'),
(17396, 39, 663, 'Berthierville', 'CA', 'QC'),
(17397, 39, 663, 'Blainville', 'CA', 'QC'),
(17398, 39, 663, 'Bois-des-Filion', 'CA', 'QC'),
(17399, 39, 663, 'Boisbriand', 'CA', 'QC'),
(17400, 39, 663, 'Bonaventure', 'CA', 'QC'),
(17401, 39, 663, 'Boucherville', 'CA', 'QC'),
(17402, 39, 663, 'Breakeyville', 'CA', 'QC'),
(17403, 39, 663, 'Bromont', 'CA', 'QC'),
(17404, 39, 663, 'Brossard', 'CA', 'QC'),
(17405, 39, 663, 'Brownsburg-Chatham', 'CA', 'QC'),
(17406, 39, 663, 'Buckingham', 'CA', 'QC'),
(17407, 39, 663, 'Cabano', 'CA', 'QC'),
(17408, 39, 663, 'Cacouna', 'CA', 'QC'),
(17409, 39, 663, 'Candiac', 'CA', 'QC'),
(17410, 39, 663, 'Cantley', 'CA', 'QC'),
(17411, 39, 663, 'Cap-Chat', 'CA', 'QC'),
(17412, 39, 663, 'Cap-Santé', 'CA', 'QC'),
(17413, 39, 663, 'Capitale-Nationale', 'CA', 'QC'),
(17414, 39, 663, 'Carignan', 'CA', 'QC'),
(17415, 39, 663, 'Carleton', 'CA', 'QC'),
(17416, 39, 663, 'Carleton-sur-Mer', 'CA', 'QC'),
(17417, 39, 663, 'Centre-du-Québec', 'CA', 'QC'),
(17418, 39, 663, 'Chambly', 'CA', 'QC'),
(17419, 39, 663, 'Chambord', 'CA', 'QC'),
(17420, 39, 663, 'Chandler', 'CA', 'QC'),
(17421, 39, 663, 'Chapais', 'CA', 'QC'),
(17422, 39, 663, 'Charlemagne', 'CA', 'QC'),
(17423, 39, 663, 'Château-Richer', 'CA', 'QC'),
(17424, 39, 663, 'Châteauguay', 'CA', 'QC'),
(17425, 39, 663, 'Chaudière-Appalaches', 'CA', 'QC'),
(17426, 39, 663, 'Chertsey', 'CA', 'QC'),
(17427, 39, 663, 'Chibougamau', 'CA', 'QC'),
(17428, 39, 663, 'Chute-aux-Outardes', 'CA', 'QC'),
(17429, 39, 663, 'Coaticook', 'CA', 'QC'),
(17430, 39, 663, 'Contrecoeur', 'CA', 'QC'),
(17431, 39, 663, 'Cookshire', 'CA', 'QC'),
(17432, 39, 663, 'Cookshire-Eaton', 'CA', 'QC'),
(17433, 39, 663, 'Côte-Nord', 'CA', 'QC'),
(17434, 39, 663, 'Côte-Saint-Luc', 'CA', 'QC'),
(17435, 39, 663, 'Coteau-du-Lac', 'CA', 'QC'),
(17436, 39, 663, 'Cowansville', 'CA', 'QC'),
(17437, 39, 663, 'Crabtree', 'CA', 'QC'),
(17438, 39, 663, 'Danville', 'CA', 'QC'),
(17439, 39, 663, 'Daveluyville', 'CA', 'QC'),
(17440, 39, 663, 'Delson', 'CA', 'QC'),
(17441, 39, 663, 'Deux-Montagnes', 'CA', 'QC'),
(17442, 39, 663, 'Disraeli', 'CA', 'QC'),
(17443, 39, 663, 'Dolbeau-Mistassini', 'CA', 'QC'),
(17444, 39, 663, 'Dollard-Des Ormeaux', 'CA', 'QC'),
(17445, 39, 663, 'Donnacona', 'CA', 'QC'),
(17446, 39, 663, 'Dorval', 'CA', 'QC'),
(17447, 39, 663, 'Drummondville', 'CA', 'QC'),
(17448, 39, 663, 'Dunham', 'CA', 'QC'),
(17449, 39, 663, 'East Angus', 'CA', 'QC'),
(17450, 39, 663, 'East Broughton', 'CA', 'QC'),
(17451, 39, 663, 'Farnham', 'CA', 'QC'),
(17452, 39, 663, 'Ferme-Neuve', 'CA', 'QC'),
(17453, 39, 663, 'Fermont', 'CA', 'QC'),
(17454, 39, 663, 'Forestville', 'CA', 'QC'),
(17455, 39, 663, 'Fort-Coulonge', 'CA', 'QC'),
(17456, 39, 663, 'Fossambault-sur-le-Lac', 'CA', 'QC'),
(17457, 39, 663, 'Franklin', 'CA', 'QC'),
(17458, 39, 663, 'Gaspé', 'CA', 'QC'),
(17459, 39, 663, 'Gaspésie-Îles-de-la-Madeleine', 'CA', 'QC'),
(17460, 39, 663, 'Gatineau', 'CA', 'QC'),
(17461, 39, 663, 'Godefroy', 'CA', 'QC'),
(17462, 39, 663, 'Granby', 'CA', 'QC'),
(17463, 39, 663, 'Hampstead', 'CA', 'QC'),
(17464, 39, 663, 'Hauterive', 'CA', 'QC'),
(17465, 39, 663, 'Havre-Saint-Pierre', 'CA', 'QC'),
(17466, 39, 663, 'Hérouxville', 'CA', 'QC'),
(17467, 39, 663, 'Hudson', 'CA', 'QC'),
(17468, 39, 663, 'Huntingdon', 'CA', 'QC'),
(17469, 39, 663, 'Joliette', 'CA', 'QC'),
(17470, 39, 663, 'Jonquière', 'CA', 'QC'),
(17471, 39, 663, 'Kingsey Falls', 'CA', 'QC'),
(17472, 39, 663, 'Kirkland', 'CA', 'QC'),
(17473, 39, 663, 'L\'Ancienne-Lorette', 'CA', 'QC'),
(17474, 39, 663, 'L\'Ange-Gardien', 'CA', 'QC'),
(17475, 39, 663, 'L\'Ascension-de-Notre-Seigneur', 'CA', 'QC'),
(17476, 39, 663, 'L\'Assomption', 'CA', 'QC'),
(17477, 39, 663, 'L\'Épiphanie', 'CA', 'QC'),
(17478, 39, 663, 'L\'Île-Perrot', 'CA', 'QC'),
(17479, 39, 663, 'La Conception', 'CA', 'QC'),
(17480, 39, 663, 'La Haute-Saint-Charles', 'CA', 'QC'),
(17481, 39, 663, 'La Malbaie', 'CA', 'QC'),
(17482, 39, 663, 'La Minerve', 'CA', 'QC'),
(17483, 39, 663, 'La Pocatière', 'CA', 'QC'),
(17484, 39, 663, 'La Prairie', 'CA', 'QC'),
(17485, 39, 663, 'La Sarre', 'CA', 'QC'),
(17486, 39, 663, 'La Tuque', 'CA', 'QC'),
(17487, 39, 663, 'Labelle', 'CA', 'QC'),
(17488, 39, 663, 'Lac-Alouette', 'CA', 'QC'),
(17489, 39, 663, 'Lac-Brome', 'CA', 'QC'),
(17490, 39, 663, 'Lac-Connelly', 'CA', 'QC'),
(17491, 39, 663, 'Lac-Lapierre', 'CA', 'QC'),
(17492, 39, 663, 'Lac-Mégantic', 'CA', 'QC'),
(17493, 39, 663, 'Lac-Simon', 'CA', 'QC'),
(17494, 39, 663, 'Lachute', 'CA', 'QC'),
(17495, 39, 663, 'Lacolle', 'CA', 'QC'),
(17496, 39, 663, 'Lanoraie', 'CA', 'QC'),
(17497, 39, 663, 'Laval', 'CA', 'QC'),
(17498, 39, 663, 'Lavaltrie', 'CA', 'QC'),
(17499, 39, 663, 'Le Bic', 'CA', 'QC'),
(17500, 39, 663, 'le Plateau', 'CA', 'QC');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(17501, 39, 663, 'Lebel-sur-Quévillon', 'CA', 'QC'),
(17502, 39, 663, 'Leblanc', 'CA', 'QC'),
(17503, 39, 663, 'Les Cèdres', 'CA', 'QC'),
(17504, 39, 663, 'Les Coteaux', 'CA', 'QC'),
(17505, 39, 663, 'Les Escoumins', 'CA', 'QC'),
(17506, 39, 663, 'Lévis', 'CA', 'QC'),
(17507, 39, 663, 'Linière', 'CA', 'QC'),
(17508, 39, 663, 'Longueuil', 'CA', 'QC'),
(17509, 39, 663, 'Lorraine', 'CA', 'QC'),
(17510, 39, 663, 'Louiseville', 'CA', 'QC'),
(17511, 39, 663, 'Luceville', 'CA', 'QC'),
(17512, 39, 663, 'Macamic', 'CA', 'QC'),
(17513, 39, 663, 'Magog', 'CA', 'QC'),
(17514, 39, 663, 'Malartic', 'CA', 'QC'),
(17515, 39, 663, 'Maliotenam', 'CA', 'QC'),
(17516, 39, 663, 'Manawan', 'CA', 'QC'),
(17517, 39, 663, 'Mandeville', 'CA', 'QC'),
(17518, 39, 663, 'Maniwaki', 'CA', 'QC'),
(17519, 39, 663, 'Maria', 'CA', 'QC'),
(17520, 39, 663, 'Marieville', 'CA', 'QC'),
(17521, 39, 663, 'Mascouche', 'CA', 'QC'),
(17522, 39, 663, 'Maskinongé', 'CA', 'QC'),
(17523, 39, 663, 'Matagami', 'CA', 'QC'),
(17524, 39, 663, 'Matane', 'CA', 'QC'),
(17525, 39, 663, 'Mauricie', 'CA', 'QC'),
(17526, 39, 663, 'Melocheville', 'CA', 'QC'),
(17527, 39, 663, 'Mercier', 'CA', 'QC'),
(17528, 39, 663, 'Métabetchouan', 'CA', 'QC'),
(17529, 39, 663, 'Metabetchouan-Lac-a-la-Croix', 'CA', 'QC'),
(17530, 39, 663, 'Mirabel', 'CA', 'QC'),
(17531, 39, 663, 'Mistissini', 'CA', 'QC'),
(17532, 39, 663, 'Mont-Joli', 'CA', 'QC'),
(17533, 39, 663, 'Mont-Laurier', 'CA', 'QC'),
(17534, 39, 663, 'Mont-Royal', 'CA', 'QC'),
(17535, 39, 663, 'Mont-Saint-Grégoire', 'CA', 'QC'),
(17536, 39, 663, 'Mont-Saint-Hilaire', 'CA', 'QC'),
(17537, 39, 663, 'Mont-Tremblant', 'CA', 'QC'),
(17538, 39, 663, 'Montmagny', 'CA', 'QC'),
(17539, 39, 663, 'Montréal', 'CA', 'QC'),
(17540, 39, 663, 'Montréal-Est', 'CA', 'QC'),
(17541, 39, 663, 'Montréal-Ouest', 'CA', 'QC'),
(17542, 39, 663, 'Morin-Heights', 'CA', 'QC'),
(17543, 39, 663, 'Napierville', 'CA', 'QC'),
(17544, 39, 663, 'Neuville', 'CA', 'QC'),
(17545, 39, 663, 'New Carlisle', 'CA', 'QC'),
(17546, 39, 663, 'New-Richmond', 'CA', 'QC'),
(17547, 39, 663, 'Nicolet', 'CA', 'QC'),
(17548, 39, 663, 'Nord-du-Québec', 'CA', 'QC'),
(17549, 39, 663, 'Normandin', 'CA', 'QC'),
(17550, 39, 663, 'Notre-Dame-de-Grâce', 'CA', 'QC'),
(17551, 39, 663, 'Notre-Dame-de-l\'Île-Perrot', 'CA', 'QC'),
(17552, 39, 663, 'Notre-Dame-des-Prairies', 'CA', 'QC'),
(17553, 39, 663, 'Notre-Dame-du-Lac', 'CA', 'QC'),
(17554, 39, 663, 'Notre-Dame-du-Mont-Carmel', 'CA', 'QC'),
(17555, 39, 663, 'Oka', 'CA', 'QC'),
(17556, 39, 663, 'Ormstown', 'CA', 'QC'),
(17557, 39, 663, 'Otterburn Park', 'CA', 'QC'),
(17558, 39, 663, 'Outaouais', 'CA', 'QC'),
(17559, 39, 663, 'Papineauville', 'CA', 'QC'),
(17560, 39, 663, 'Parc-Boutin', 'CA', 'QC'),
(17561, 39, 663, 'Piedmont', 'CA', 'QC'),
(17562, 39, 663, 'Pierreville', 'CA', 'QC'),
(17563, 39, 663, 'Pincourt', 'CA', 'QC'),
(17564, 39, 663, 'Plessisville', 'CA', 'QC'),
(17565, 39, 663, 'Pohénégamook', 'CA', 'QC'),
(17566, 39, 663, 'Pointe-Calumet', 'CA', 'QC'),
(17567, 39, 663, 'Pointe-Claire', 'CA', 'QC'),
(17568, 39, 663, 'Pointe-du-Lac', 'CA', 'QC'),
(17569, 39, 663, 'Pont Rouge', 'CA', 'QC'),
(17570, 39, 663, 'Pont-Rouge', 'CA', 'QC'),
(17571, 39, 663, 'Port-Cartier', 'CA', 'QC'),
(17572, 39, 663, 'Portneuf', 'CA', 'QC'),
(17573, 39, 663, 'Prévost', 'CA', 'QC'),
(17574, 39, 663, 'Princeville', 'CA', 'QC'),
(17575, 39, 663, 'Québec', 'CA', 'QC'),
(17576, 39, 663, 'Rawdon', 'CA', 'QC'),
(17577, 39, 663, 'Repentigny', 'CA', 'QC'),
(17578, 39, 663, 'Richelieu', 'CA', 'QC'),
(17579, 39, 663, 'Richmond', 'CA', 'QC'),
(17580, 39, 663, 'Rigaud', 'CA', 'QC'),
(17581, 39, 663, 'Rimouski', 'CA', 'QC'),
(17582, 39, 663, 'Rivière-du-Loup', 'CA', 'QC'),
(17583, 39, 663, 'Rivière-Rouge', 'CA', 'QC'),
(17584, 39, 663, 'Roberval', 'CA', 'QC'),
(17585, 39, 663, 'Rock Forest', 'CA', 'QC'),
(17586, 39, 663, 'Rosemère', 'CA', 'QC'),
(17587, 39, 663, 'Rougemont', 'CA', 'QC'),
(17588, 39, 663, 'Rouyn-Noranda', 'CA', 'QC'),
(17589, 39, 663, 'Sacré-Coeur', 'CA', 'QC'),
(17590, 39, 663, 'Saguenay', 'CA', 'QC'),
(17591, 39, 663, 'Saint-Adolphe-d\'Howard', 'CA', 'QC'),
(17592, 39, 663, 'Saint-Alexandre', 'CA', 'QC'),
(17593, 39, 663, 'Saint-Amable', 'CA', 'QC'),
(17594, 39, 663, 'Saint-Ambroise', 'CA', 'QC'),
(17595, 39, 663, 'Saint-André-Avellin', 'CA', 'QC'),
(17596, 39, 663, 'Saint-Anselme', 'CA', 'QC'),
(17597, 39, 663, 'Saint-Antoine-de-Tilly', 'CA', 'QC'),
(17598, 39, 663, 'Saint-Augustin', 'CA', 'QC'),
(17599, 39, 663, 'Saint-Augustin-de-Desmaures', 'CA', 'QC'),
(17600, 39, 663, 'Saint-Barnabé-Sud', 'CA', 'QC'),
(17601, 39, 663, 'Saint-Basile-le-Grand', 'CA', 'QC'),
(17602, 39, 663, 'Saint-Boniface', 'CA', 'QC'),
(17603, 39, 663, 'Saint-Bruno', 'CA', 'QC'),
(17604, 39, 663, 'Saint-Bruno-de-Guigues', 'CA', 'QC'),
(17605, 39, 663, 'Saint-Bruno-de-Montarville', 'CA', 'QC'),
(17606, 39, 663, 'Saint-Canut', 'CA', 'QC'),
(17607, 39, 663, 'Saint-Césaire', 'CA', 'QC'),
(17608, 39, 663, 'Saint-Charles', 'CA', 'QC'),
(17609, 39, 663, 'Saint-Côme-Linière', 'CA', 'QC'),
(17610, 39, 663, 'Saint-Constant', 'CA', 'QC'),
(17611, 39, 663, 'Saint-Cyrille-de-Wendover', 'CA', 'QC'),
(17612, 39, 663, 'Saint-Damase', 'CA', 'QC'),
(17613, 39, 663, 'Saint-Denis-sur-Richelieu', 'CA', 'QC'),
(17614, 39, 663, 'Saint-Donat-de-Montcalm', 'CA', 'QC'),
(17615, 39, 663, 'Saint-Édouard', 'CA', 'QC'),
(17616, 39, 663, 'Saint-Elzéar', 'CA', 'QC'),
(17617, 39, 663, 'Saint-Éphrem-de-Beauce', 'CA', 'QC'),
(17618, 39, 663, 'Saint-Eustache', 'CA', 'QC'),
(17619, 39, 663, 'Saint-Félicien', 'CA', 'QC'),
(17620, 39, 663, 'Saint-Félix-de-Valois', 'CA', 'QC'),
(17621, 39, 663, 'Saint-Gabriel', 'CA', 'QC'),
(17622, 39, 663, 'Saint-Gédéon', 'CA', 'QC'),
(17623, 39, 663, 'Saint-Georges', 'CA', 'QC'),
(17624, 39, 663, 'Saint-Germain-de-Grantham', 'CA', 'QC'),
(17625, 39, 663, 'Saint-Henri', 'CA', 'QC'),
(17626, 39, 663, 'Saint-Hippolyte', 'CA', 'QC'),
(17627, 39, 663, 'Saint-Honoré', 'CA', 'QC'),
(17628, 39, 663, 'Saint-Hyacinthe', 'CA', 'QC'),
(17629, 39, 663, 'Saint-Isidore', 'CA', 'QC'),
(17630, 39, 663, 'Saint-Jacques-le-Mineur', 'CA', 'QC'),
(17631, 39, 663, 'Saint-Jean-Baptiste', 'CA', 'QC'),
(17632, 39, 663, 'Saint-Jean-sur-Richelieu', 'CA', 'QC'),
(17633, 39, 663, 'Saint-Jérôme', 'CA', 'QC'),
(17634, 39, 663, 'Saint-Joseph', 'CA', 'QC'),
(17635, 39, 663, 'Saint-Joseph-de-Beauce', 'CA', 'QC'),
(17636, 39, 663, 'Saint-Joseph-de-Coleraine', 'CA', 'QC'),
(17637, 39, 663, 'Saint-Joseph-du-Lac', 'CA', 'QC'),
(17638, 39, 663, 'Saint-Lambert-de-Lauzon', 'CA', 'QC'),
(17639, 39, 663, 'Saint-Laurent', 'CA', 'QC'),
(17640, 39, 663, 'Saint-Lazare', 'CA', 'QC'),
(17641, 39, 663, 'Saint-Léonard', 'CA', 'QC'),
(17642, 39, 663, 'Saint-Léonard-d\'Aston', 'CA', 'QC'),
(17643, 39, 663, 'Saint-Liboire', 'CA', 'QC'),
(17644, 39, 663, 'Saint-Lin-Laurentides', 'CA', 'QC'),
(17645, 39, 663, 'Saint-Marc-des-Carrières', 'CA', 'QC'),
(17646, 39, 663, 'Saint-Mathieu', 'CA', 'QC'),
(17647, 39, 663, 'Saint-Michel', 'CA', 'QC'),
(17648, 39, 663, 'Saint-Michel-des-Saints', 'CA', 'QC'),
(17649, 39, 663, 'Saint-Nazaire', 'CA', 'QC'),
(17650, 39, 663, 'Saint-Norbert', 'CA', 'QC'),
(17651, 39, 663, 'Saint-Pacôme', 'CA', 'QC'),
(17652, 39, 663, 'Saint-Pascal', 'CA', 'QC'),
(17653, 39, 663, 'Saint-Philippe-de-La Prairie', 'CA', 'QC'),
(17654, 39, 663, 'Saint-Pie', 'CA', 'QC'),
(17655, 39, 663, 'Saint-Pierre-les-Becquets', 'CA', 'QC'),
(17656, 39, 663, 'Saint-Prime', 'CA', 'QC'),
(17657, 39, 663, 'Saint-Raphaël', 'CA', 'QC'),
(17658, 39, 663, 'Saint-Raymond', 'CA', 'QC'),
(17659, 39, 663, 'Saint-Rémi', 'CA', 'QC'),
(17660, 39, 663, 'Saint-Rémi-de-Tingwick', 'CA', 'QC'),
(17661, 39, 663, 'Saint-Sauveur', 'CA', 'QC'),
(17662, 39, 663, 'Saint-Sauveur-des-Monts', 'CA', 'QC'),
(17663, 39, 663, 'Saint-Siméon', 'CA', 'QC'),
(17664, 39, 663, 'Saint-Thomas', 'CA', 'QC'),
(17665, 39, 663, 'Saint-Tite', 'CA', 'QC'),
(17666, 39, 663, 'Saint-Victor', 'CA', 'QC'),
(17667, 39, 663, 'Saint-Zotique', 'CA', 'QC'),
(17668, 39, 663, 'Sainte Catherine de la Jacques Cartier', 'CA', 'QC'),
(17669, 39, 663, 'Sainte-Adèle', 'CA', 'QC'),
(17670, 39, 663, 'Sainte-Agathe-des-Monts', 'CA', 'QC'),
(17671, 39, 663, 'Sainte-Anne-de-Bellevue', 'CA', 'QC'),
(17672, 39, 663, 'Sainte-Anne-des-Monts', 'CA', 'QC'),
(17673, 39, 663, 'Sainte-Anne-des-Plaines', 'CA', 'QC'),
(17674, 39, 663, 'Sainte-Béatrix', 'CA', 'QC'),
(17675, 39, 663, 'Sainte-Catherine', 'CA', 'QC'),
(17676, 39, 663, 'Sainte-Croix', 'CA', 'QC'),
(17677, 39, 663, 'Sainte-Élisabeth', 'CA', 'QC'),
(17678, 39, 663, 'Sainte-Julie', 'CA', 'QC'),
(17679, 39, 663, 'Sainte-Julienne', 'CA', 'QC'),
(17680, 39, 663, 'Sainte-Madeleine', 'CA', 'QC'),
(17681, 39, 663, 'Sainte-Marie', 'CA', 'QC'),
(17682, 39, 663, 'Sainte-Marthe-sur-le-Lac', 'CA', 'QC'),
(17683, 39, 663, 'Sainte-Martine', 'CA', 'QC'),
(17684, 39, 663, 'Sainte-Sophie', 'CA', 'QC'),
(17685, 39, 663, 'Sainte-Thècle', 'CA', 'QC'),
(17686, 39, 663, 'Sainte-Thérèse', 'CA', 'QC'),
(17687, 39, 663, 'Salaberry-de-Valleyfield', 'CA', 'QC'),
(17688, 39, 663, 'Salluit', 'CA', 'QC'),
(17689, 39, 663, 'Senneterre', 'CA', 'QC'),
(17690, 39, 663, 'Sept-Îles', 'CA', 'QC'),
(17691, 39, 663, 'Shannon', 'CA', 'QC'),
(17692, 39, 663, 'Shawinigan', 'CA', 'QC'),
(17693, 39, 663, 'Shawville', 'CA', 'QC'),
(17694, 39, 663, 'Sherbrooke', 'CA', 'QC'),
(17695, 39, 663, 'Sorel-Tracy', 'CA', 'QC'),
(17696, 39, 663, 'St-Jean-Port-Joli', 'CA', 'QC'),
(17697, 39, 663, 'Sutton', 'CA', 'QC'),
(17698, 39, 663, 'Témiscaming', 'CA', 'QC'),
(17699, 39, 663, 'Terrasse-des-Pins', 'CA', 'QC'),
(17700, 39, 663, 'Terrebonne', 'CA', 'QC'),
(17701, 39, 663, 'Thetford-Mines', 'CA', 'QC'),
(17702, 39, 663, 'Thurso', 'CA', 'QC'),
(17703, 39, 663, 'Trois-Rivières', 'CA', 'QC'),
(17704, 39, 663, 'Val-d\'Or', 'CA', 'QC'),
(17705, 39, 663, 'Val-David', 'CA', 'QC'),
(17706, 39, 663, 'Val-des-Monts', 'CA', 'QC'),
(17707, 39, 663, 'Val-Morin', 'CA', 'QC'),
(17708, 39, 663, 'Valcourt', 'CA', 'QC'),
(17709, 39, 663, 'Vallée-Jonction', 'CA', 'QC'),
(17710, 39, 663, 'Varennes', 'CA', 'QC'),
(17711, 39, 663, 'Vaudreuil-Dorion', 'CA', 'QC'),
(17712, 39, 663, 'Venise-en-Québec', 'CA', 'QC'),
(17713, 39, 663, 'Verchères', 'CA', 'QC'),
(17714, 39, 663, 'Victoriaville', 'CA', 'QC'),
(17715, 39, 663, 'Ville-Marie', 'CA', 'QC'),
(17716, 39, 663, 'Wakefield', 'CA', 'QC'),
(17717, 39, 663, 'Warwick', 'CA', 'QC'),
(17718, 39, 663, 'Waskaganish', 'CA', 'QC'),
(17719, 39, 663, 'Waswanipi', 'CA', 'QC'),
(17720, 39, 663, 'Waterloo', 'CA', 'QC'),
(17721, 39, 663, 'Weedon Centre', 'CA', 'QC'),
(17722, 39, 663, 'Westmount', 'CA', 'QC'),
(17723, 39, 663, 'Weymontachie', 'CA', 'QC'),
(17724, 39, 663, 'Windsor', 'CA', 'QC'),
(17725, 39, 663, 'Yamachiche', 'CA', 'QC'),
(17726, 39, 664, 'Assiniboia', 'CA', 'SK'),
(17727, 39, 664, 'Biggar', 'CA', 'SK'),
(17728, 39, 664, 'Canora', 'CA', 'SK'),
(17729, 39, 664, 'Carlyle', 'CA', 'SK'),
(17730, 39, 664, 'Dalmeny', 'CA', 'SK'),
(17731, 39, 664, 'Esterhazy', 'CA', 'SK'),
(17732, 39, 664, 'Estevan', 'CA', 'SK'),
(17733, 39, 664, 'Foam Lake', 'CA', 'SK'),
(17734, 39, 664, 'Gravelbourg', 'CA', 'SK'),
(17735, 39, 664, 'Hudson Bay', 'CA', 'SK'),
(17736, 39, 664, 'Humboldt', 'CA', 'SK'),
(17737, 39, 664, 'Indian Head', 'CA', 'SK'),
(17738, 39, 664, 'Kamsack', 'CA', 'SK'),
(17739, 39, 664, 'Kerrobert', 'CA', 'SK'),
(17740, 39, 664, 'Kindersley', 'CA', 'SK'),
(17741, 39, 664, 'La Ronge', 'CA', 'SK'),
(17742, 39, 664, 'Langenburg', 'CA', 'SK'),
(17743, 39, 664, 'Langham', 'CA', 'SK'),
(17744, 39, 664, 'Lanigan', 'CA', 'SK'),
(17745, 39, 664, 'Lumsden', 'CA', 'SK'),
(17746, 39, 664, 'Macklin', 'CA', 'SK'),
(17747, 39, 664, 'Maple Creek', 'CA', 'SK'),
(17748, 39, 664, 'Martensville', 'CA', 'SK'),
(17749, 39, 664, 'Meadow Lake', 'CA', 'SK'),
(17750, 39, 664, 'Melfort', 'CA', 'SK'),
(17751, 39, 664, 'Melville', 'CA', 'SK'),
(17752, 39, 664, 'Moose Jaw', 'CA', 'SK'),
(17753, 39, 664, 'Moosomin', 'CA', 'SK'),
(17754, 39, 664, 'Nipawin', 'CA', 'SK'),
(17755, 39, 664, 'North Battleford', 'CA', 'SK'),
(17756, 39, 664, 'Outlook', 'CA', 'SK'),
(17757, 39, 664, 'Oxbow', 'CA', 'SK'),
(17758, 39, 664, 'Pelican Narrows', 'CA', 'SK'),
(17759, 39, 664, 'Pilot Butte', 'CA', 'SK'),
(17760, 39, 664, 'Preeceville', 'CA', 'SK'),
(17761, 39, 664, 'Prince Albert', 'CA', 'SK'),
(17762, 39, 664, 'Regina', 'CA', 'SK'),
(17763, 39, 664, 'Regina Beach', 'CA', 'SK'),
(17764, 39, 664, 'Rosetown', 'CA', 'SK'),
(17765, 39, 664, 'Rosthern', 'CA', 'SK'),
(17766, 39, 664, 'Saskatoon', 'CA', 'SK'),
(17767, 39, 664, 'Shaunavon', 'CA', 'SK'),
(17768, 39, 664, 'Shellbrook', 'CA', 'SK'),
(17769, 39, 664, 'Swift Current', 'CA', 'SK'),
(17770, 39, 664, 'Tisdale', 'CA', 'SK'),
(17771, 39, 664, 'Unity', 'CA', 'SK'),
(17772, 39, 664, 'Wadena', 'CA', 'SK'),
(17773, 39, 664, 'Warman', 'CA', 'SK'),
(17774, 39, 664, 'Watrous', 'CA', 'SK'),
(17775, 39, 664, 'Weyburn', 'CA', 'SK'),
(17776, 39, 664, 'White City', 'CA', 'SK'),
(17777, 39, 664, 'Wilkie', 'CA', 'SK'),
(17778, 39, 664, 'Wynyard', 'CA', 'SK'),
(17779, 39, 664, 'Yorkton', 'CA', 'SK'),
(17780, 39, 665, 'Dawson City', 'CA', 'YT'),
(17781, 39, 665, 'Haines Junction', 'CA', 'YT'),
(17782, 39, 665, 'Watson Lake', 'CA', 'YT'),
(17783, 39, 665, 'Whitehorse', 'CA', 'YT'),
(17784, 40, 667, 'Sal Rei', 'CV', 'BV'),
(17785, 40, 668, 'Nova Sintra', 'CV', 'BR'),
(17786, 40, 669, 'Vila do Maio', 'CV', 'MA'),
(17787, 40, 670, 'Igreja', 'CV', 'MO'),
(17788, 40, 671, 'Pombas', 'CV', 'PA'),
(17789, 40, 672, 'Porto Novo', 'CV', 'PN'),
(17790, 40, 673, 'Praia', 'CV', 'PR'),
(17791, 40, 674, 'Ribeira Brava', 'CV', 'RB'),
(17792, 40, 675, 'Ponta do Sol', 'CV', 'RG'),
(17793, 40, 675, 'Ribeira Grande', 'CV', 'RG'),
(17794, 40, 676, 'Cidade Velha', 'CV', 'RS'),
(17795, 40, 677, 'Espargos', 'CV', 'SL'),
(17796, 40, 677, 'Santa Maria', 'CV', 'SL'),
(17797, 40, 678, 'Assomada', 'CV', 'CA'),
(17798, 40, 679, 'Cova Figueira', 'CV', 'CF'),
(17799, 40, 680, 'Pedra Badejo', 'CV', 'CR'),
(17800, 40, 680, 'Santa Cruz', 'CV', 'CR'),
(17801, 40, 681, 'São Domingos', 'CV', 'SD'),
(17802, 40, 682, 'São Filipe', 'CV', 'SF'),
(17803, 40, 683, 'João Teves', 'CV', 'SO'),
(17804, 40, 684, 'Calheta', 'CV', 'SM'),
(17805, 40, 685, 'Mindelo', 'CV', 'SV'),
(17806, 40, 687, 'Tarrafal', 'CV', 'TA'),
(17807, 40, 688, 'Tarrafal de São Nicolau', 'CV', 'TS'),
(17808, 42, 689, 'Bamingui', 'CF', 'BB'),
(17809, 42, 689, 'Ndélé', 'CF', 'BB'),
(17810, 42, 690, 'Bangui', 'CF', 'BGF'),
(17811, 42, 691, 'Alindao', 'CF', 'BK'),
(17812, 42, 691, 'Kembé', 'CF', 'BK'),
(17813, 42, 691, 'Mobaye', 'CF', 'BK'),
(17814, 42, 692, 'Obo', 'CF', 'HM'),
(17815, 42, 692, 'Zemio', 'CF', 'HM'),
(17816, 42, 693, 'Bria', 'CF', 'HK'),
(17817, 42, 693, 'Ouadda', 'CF', 'HK'),
(17818, 42, 694, 'Sibut', 'CF', 'KG'),
(17819, 42, 695, 'Boda', 'CF', 'LB'),
(17820, 42, 695, 'Boganangone', 'CF', 'LB'),
(17821, 42, 695, 'Mbaiki', 'CF', 'LB'),
(17822, 42, 695, 'Mongoumba', 'CF', 'LB'),
(17823, 42, 696, 'Berberati', 'CF', 'HS'),
(17824, 42, 696, 'Carnot', 'CF', 'HS'),
(17825, 42, 696, 'Gamboula', 'CF', 'HS'),
(17826, 42, 697, 'Bangassou', 'CF', 'MB'),
(17827, 42, 697, 'Gambo', 'CF', 'MB'),
(17828, 42, 697, 'Ouango', 'CF', 'MB'),
(17829, 42, 697, 'Rafai', 'CF', 'MB'),
(17830, 42, 698, 'Kaga Bandoro', 'CF', 'KB'),
(17831, 42, 698, 'Kaga-Bandoro', 'CF', 'KB'),
(17832, 42, 699, 'Baoro', 'CF', 'NM'),
(17833, 42, 699, 'Bouar', 'CF', 'NM'),
(17834, 42, 700, 'Bimbo', 'CF', 'MP'),
(17835, 42, 700, 'Boali', 'CF', 'MP'),
(17836, 42, 700, 'Damara', 'CF', 'MP'),
(17837, 42, 701, 'Bambari', 'CF', 'UK'),
(17838, 42, 701, 'Grimari', 'CF', 'UK'),
(17839, 42, 701, 'Ippy', 'CF', 'UK'),
(17840, 42, 701, 'Kouango', 'CF', 'UK'),
(17841, 42, 702, 'Batangafo', 'CF', 'AC'),
(17842, 42, 702, 'Bossangoa', 'CF', 'AC'),
(17843, 42, 702, 'Bouca', 'CF', 'AC'),
(17844, 42, 702, 'Kabo', 'CF', 'AC'),
(17845, 42, 703, 'Bocaranga', 'CF', 'OP'),
(17846, 42, 703, 'Bozoum', 'CF', 'OP'),
(17847, 42, 703, 'Paoua', 'CF', 'OP'),
(17848, 42, 704, 'Nola', 'CF', 'SE'),
(17849, 42, 705, 'Birao', 'CF', 'VK'),
(17850, 42, 705, 'Ouanda-Djallé', 'CF', 'VK'),
(17851, 43, 706, 'Moussoro', 'TD', 'BG'),
(17852, 43, 707, 'Ati', 'TD', 'BA'),
(17853, 43, 707, 'Oum Hadjer', 'TD', 'BA'),
(17854, 43, 708, 'Faya-Largeau', 'TD', 'BO'),
(17855, 43, 709, 'Baguirmi Department', 'TD', 'CB'),
(17856, 43, 709, 'Bousso', 'TD', 'CB'),
(17857, 43, 709, 'Chari Department', 'TD', 'CB'),
(17858, 43, 709, 'Dababa', 'TD', 'CB'),
(17859, 43, 709, 'Gaoui', 'TD', 'CB'),
(17860, 43, 709, 'Linia', 'TD', 'CB'),
(17861, 43, 709, 'Mandjafa', 'TD', 'CB'),
(17862, 43, 709, 'Massenya', 'TD', 'CB'),
(17863, 43, 711, 'Fada', 'TD', 'EO'),
(17864, 43, 712, 'Bitkine', 'TD', 'GR'),
(17865, 43, 712, 'Melfi', 'TD', 'GR'),
(17866, 43, 712, 'Mongo', 'TD', 'GR'),
(17867, 43, 713, 'Bokoro', 'TD', 'HL'),
(17868, 43, 713, 'Massaguet', 'TD', 'HL'),
(17869, 43, 713, 'Massakory', 'TD', 'HL'),
(17870, 43, 714, 'Mao', 'TD', 'KA'),
(17871, 43, 715, 'Bol', 'TD', 'LC'),
(17872, 43, 716, 'Beïnamar', 'TD', 'LO'),
(17873, 43, 716, 'Benoy', 'TD', 'LO'),
(17874, 43, 716, 'Lac Wey', 'TD', 'LO'),
(17875, 43, 716, 'Moundou', 'TD', 'LO'),
(17876, 43, 717, 'Bébédja', 'TD', 'LR'),
(17877, 43, 717, 'Béboto', 'TD', 'LR'),
(17878, 43, 717, 'Doba', 'TD', 'LR'),
(17879, 43, 718, 'Goundi', 'TD', 'MA'),
(17880, 43, 718, 'Koumra', 'TD', 'MA'),
(17881, 43, 718, 'Moïssala', 'TD', 'MA'),
(17882, 43, 719, 'Bongor', 'TD', 'ME'),
(17883, 43, 719, 'Gounou Gaya', 'TD', 'ME'),
(17884, 43, 719, 'Guelendeng', 'TD', 'ME'),
(17885, 43, 720, 'Mboursou Léré', 'TD', 'MO'),
(17886, 43, 720, 'Pala', 'TD', 'MO'),
(17887, 43, 721, 'Kyabé', 'TD', 'MC'),
(17888, 43, 721, 'Sarh', 'TD', 'MC'),
(17889, 43, 722, 'N\'Djamena', 'TD', 'ND'),
(17890, 43, 723, 'Abéché', 'TD', 'OD'),
(17891, 43, 723, 'Adré', 'TD', 'OD'),
(17892, 43, 723, 'Goz Béïda', 'TD', 'OD'),
(17893, 43, 724, 'Am Timan', 'TD', 'SA'),
(17894, 43, 725, 'Goz Beïda', 'TD', 'SI'),
(17895, 43, 726, 'Béré', 'TD', 'TA'),
(17896, 43, 726, 'Kelo', 'TD', 'TA'),
(17897, 43, 726, 'Laï', 'TD', 'TA'),
(17898, 43, 727, 'Aozou', 'TD', 'TI'),
(17899, 43, 728, 'Biltine', 'TD', 'WF'),
(17900, 43, 728, 'Iriba', 'TD', 'WF'),
(17901, 44, 729, 'Aysén', 'CL', 'AI'),
(17902, 44, 729, 'Chile Chico', 'CL', 'AI'),
(17903, 44, 729, 'Cisnes', 'CL', 'AI'),
(17904, 44, 729, 'Cochrane', 'CL', 'AI'),
(17905, 44, 729, 'Coyhaique', 'CL', 'AI'),
(17906, 44, 729, 'Guaitecas', 'CL', 'AI'),
(17907, 44, 729, 'Lago Verde', 'CL', 'AI'),
(17908, 44, 729, 'O\'Higgins', 'CL', 'AI'),
(17909, 44, 729, 'Río Ibáñez', 'CL', 'AI'),
(17910, 44, 729, 'Tortel', 'CL', 'AI'),
(17911, 44, 730, 'Antofagasta', 'CL', 'AN'),
(17912, 44, 730, 'Calama', 'CL', 'AN'),
(17913, 44, 730, 'María Elena', 'CL', 'AN'),
(17914, 44, 730, 'Mejillones', 'CL', 'AN'),
(17915, 44, 730, 'Ollagüe', 'CL', 'AN'),
(17916, 44, 730, 'San Pedro de Atacama', 'CL', 'AN'),
(17917, 44, 730, 'Sierra Gorda', 'CL', 'AN'),
(17918, 44, 730, 'Taltal', 'CL', 'AN'),
(17919, 44, 730, 'Tocopilla', 'CL', 'AN'),
(17920, 44, 731, 'Arica', 'CL', 'AP'),
(17921, 44, 731, 'Camarones', 'CL', 'AP'),
(17922, 44, 731, 'General Lagos', 'CL', 'AP'),
(17923, 44, 731, 'Putre', 'CL', 'AP'),
(17924, 44, 732, 'Alto del Carmen', 'CL', 'AT'),
(17925, 44, 732, 'Caldera', 'CL', 'AT'),
(17926, 44, 732, 'Chañaral', 'CL', 'AT'),
(17927, 44, 732, 'Copiapó', 'CL', 'AT'),
(17928, 44, 732, 'Diego de Almagro', 'CL', 'AT'),
(17929, 44, 732, 'Freirina', 'CL', 'AT'),
(17930, 44, 732, 'Huasco', 'CL', 'AT'),
(17931, 44, 732, 'Tierra Amarilla', 'CL', 'AT'),
(17932, 44, 732, 'Vallenar', 'CL', 'AT'),
(17933, 44, 733, 'Alto Biobío', 'CL', 'BI'),
(17934, 44, 733, 'Antuco', 'CL', 'BI'),
(17935, 44, 733, 'Arauco', 'CL', 'BI'),
(17936, 44, 733, 'Cabrero', 'CL', 'BI'),
(17937, 44, 733, 'Cañete', 'CL', 'BI'),
(17938, 44, 733, 'Chiguayante', 'CL', 'BI'),
(17939, 44, 733, 'Concepción', 'CL', 'BI'),
(17940, 44, 733, 'Contulmo', 'CL', 'BI'),
(17941, 44, 733, 'Coronel', 'CL', 'BI'),
(17942, 44, 733, 'Curanilahue', 'CL', 'BI'),
(17943, 44, 733, 'Florida', 'CL', 'BI'),
(17944, 44, 733, 'Hualpén', 'CL', 'BI'),
(17945, 44, 733, 'Hualqui', 'CL', 'BI'),
(17946, 44, 733, 'Laja', 'CL', 'BI'),
(17947, 44, 733, 'Lebu', 'CL', 'BI'),
(17948, 44, 733, 'Los Álamos', 'CL', 'BI'),
(17949, 44, 733, 'Los Ángeles', 'CL', 'BI'),
(17950, 44, 733, 'Lota', 'CL', 'BI'),
(17951, 44, 733, 'Mulchén', 'CL', 'BI'),
(17952, 44, 733, 'Nacimiento', 'CL', 'BI'),
(17953, 44, 733, 'Negrete', 'CL', 'BI'),
(17954, 44, 733, 'Penco', 'CL', 'BI'),
(17955, 44, 733, 'Quilaco', 'CL', 'BI'),
(17956, 44, 733, 'Quilleco', 'CL', 'BI'),
(17957, 44, 733, 'San Pedro de la Paz', 'CL', 'BI'),
(17958, 44, 733, 'San Rosendo', 'CL', 'BI'),
(17959, 44, 733, 'Santa Bárbara', 'CL', 'BI'),
(17960, 44, 733, 'Santa Juana', 'CL', 'BI'),
(17961, 44, 733, 'Talcahuano', 'CL', 'BI'),
(17962, 44, 733, 'Tirúa', 'CL', 'BI'),
(17963, 44, 733, 'Tomé', 'CL', 'BI'),
(17964, 44, 733, 'Tucapel', 'CL', 'BI'),
(17965, 44, 733, 'Yumbel', 'CL', 'BI'),
(17966, 44, 734, 'Andacollo', 'CL', 'CO'),
(17967, 44, 734, 'Canela', 'CL', 'CO'),
(17968, 44, 734, 'Combarbalá', 'CL', 'CO'),
(17969, 44, 734, 'Coquimbo', 'CL', 'CO'),
(17970, 44, 734, 'Illapel', 'CL', 'CO'),
(17971, 44, 734, 'La Higuera', 'CL', 'CO'),
(17972, 44, 734, 'La Serena', 'CL', 'CO'),
(17973, 44, 734, 'Los Vilos', 'CL', 'CO'),
(17974, 44, 734, 'Monte Patria', 'CL', 'CO'),
(17975, 44, 734, 'Ovalle', 'CL', 'CO'),
(17976, 44, 734, 'Paihuano', 'CL', 'CO'),
(17977, 44, 734, 'Punitaqui', 'CL', 'CO'),
(17978, 44, 734, 'Río Hurtado', 'CL', 'CO'),
(17979, 44, 734, 'Salamanca', 'CL', 'CO'),
(17980, 44, 734, 'Vicuña', 'CL', 'CO'),
(17981, 44, 735, 'Angol', 'CL', 'AR'),
(17982, 44, 735, 'Carahue', 'CL', 'AR'),
(17983, 44, 735, 'Cholchol', 'CL', 'AR'),
(17984, 44, 735, 'Collipulli', 'CL', 'AR'),
(17985, 44, 735, 'Cunco', 'CL', 'AR'),
(17986, 44, 735, 'Curacautín', 'CL', 'AR'),
(17987, 44, 735, 'Curarrehue', 'CL', 'AR'),
(17988, 44, 735, 'Ercilla', 'CL', 'AR'),
(17989, 44, 735, 'Freire', 'CL', 'AR'),
(17990, 44, 735, 'Galvarino', 'CL', 'AR'),
(17991, 44, 735, 'Gorbea', 'CL', 'AR'),
(17992, 44, 735, 'Lautaro', 'CL', 'AR'),
(17993, 44, 735, 'Loncoche', 'CL', 'AR'),
(17994, 44, 735, 'Lonquimay', 'CL', 'AR'),
(17995, 44, 735, 'Los Sauces', 'CL', 'AR'),
(17996, 44, 735, 'Lumaco', 'CL', 'AR'),
(17997, 44, 735, 'Melipeuco', 'CL', 'AR'),
(17998, 44, 735, 'Nueva Imperial', 'CL', 'AR'),
(17999, 44, 735, 'Padre Las Casas', 'CL', 'AR'),
(18000, 44, 735, 'Perquenco', 'CL', 'AR');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(18001, 44, 735, 'Pitrufquén', 'CL', 'AR'),
(18002, 44, 735, 'Pucón', 'CL', 'AR'),
(18003, 44, 735, 'Purén', 'CL', 'AR'),
(18004, 44, 735, 'Renaico', 'CL', 'AR'),
(18005, 44, 735, 'Saavedra', 'CL', 'AR'),
(18006, 44, 735, 'Temuco', 'CL', 'AR'),
(18007, 44, 735, 'Teodoro Schmidt', 'CL', 'AR'),
(18008, 44, 735, 'Toltén', 'CL', 'AR'),
(18009, 44, 735, 'Traiguén', 'CL', 'AR'),
(18010, 44, 735, 'Victoria', 'CL', 'AR'),
(18011, 44, 735, 'Vilcún', 'CL', 'AR'),
(18012, 44, 735, 'Villarrica', 'CL', 'AR'),
(18013, 44, 736, 'Chépica', 'CL', 'LI'),
(18014, 44, 736, 'Chimbarongo', 'CL', 'LI'),
(18015, 44, 736, 'Codegua', 'CL', 'LI'),
(18016, 44, 736, 'Coínco', 'CL', 'LI'),
(18017, 44, 736, 'Coltauco', 'CL', 'LI'),
(18018, 44, 736, 'Doñihue', 'CL', 'LI'),
(18019, 44, 736, 'Graneros', 'CL', 'LI'),
(18020, 44, 736, 'La Estrella', 'CL', 'LI'),
(18021, 44, 736, 'Las Cabras', 'CL', 'LI'),
(18022, 44, 736, 'Litueche', 'CL', 'LI'),
(18023, 44, 736, 'Lolol', 'CL', 'LI'),
(18024, 44, 736, 'Machalí', 'CL', 'LI'),
(18025, 44, 736, 'Malloa', 'CL', 'LI'),
(18026, 44, 736, 'Marchigüe', 'CL', 'LI'),
(18027, 44, 736, 'Mostazal', 'CL', 'LI'),
(18028, 44, 736, 'Nancagua', 'CL', 'LI'),
(18029, 44, 736, 'Navidad', 'CL', 'LI'),
(18030, 44, 736, 'Olivar', 'CL', 'LI'),
(18031, 44, 736, 'Palmilla', 'CL', 'LI'),
(18032, 44, 736, 'Paredones', 'CL', 'LI'),
(18033, 44, 736, 'Peralillo', 'CL', 'LI'),
(18034, 44, 736, 'Peumo', 'CL', 'LI'),
(18035, 44, 736, 'Pichidegua', 'CL', 'LI'),
(18036, 44, 736, 'Pichilemu', 'CL', 'LI'),
(18037, 44, 736, 'Placilla', 'CL', 'LI'),
(18038, 44, 736, 'Pumanque', 'CL', 'LI'),
(18039, 44, 736, 'Quinta de Tilcoco', 'CL', 'LI'),
(18040, 44, 736, 'Rancagua', 'CL', 'LI'),
(18041, 44, 736, 'Rengo', 'CL', 'LI'),
(18042, 44, 736, 'Requínoa', 'CL', 'LI'),
(18043, 44, 736, 'San Fernando', 'CL', 'LI'),
(18044, 44, 736, 'San Vicente', 'CL', 'LI'),
(18045, 44, 736, 'Santa Cruz', 'CL', 'LI'),
(18046, 44, 737, 'Ancud', 'CL', 'LL'),
(18047, 44, 737, 'Calbuco', 'CL', 'LL'),
(18048, 44, 737, 'Castro', 'CL', 'LL'),
(18049, 44, 737, 'Chaitén', 'CL', 'LL'),
(18050, 44, 737, 'Chonchi', 'CL', 'LL'),
(18051, 44, 737, 'Cochamó', 'CL', 'LL'),
(18052, 44, 737, 'Curaco de Vélez', 'CL', 'LL'),
(18053, 44, 737, 'Dalcahue', 'CL', 'LL'),
(18054, 44, 737, 'Fresia', 'CL', 'LL'),
(18055, 44, 737, 'Frutillar', 'CL', 'LL'),
(18056, 44, 737, 'Futaleufú', 'CL', 'LL'),
(18057, 44, 737, 'Hualaihué', 'CL', 'LL'),
(18058, 44, 737, 'Llanquihue', 'CL', 'LL'),
(18059, 44, 737, 'Los Muermos', 'CL', 'LL'),
(18060, 44, 737, 'Maullín', 'CL', 'LL'),
(18061, 44, 737, 'Osorno', 'CL', 'LL'),
(18062, 44, 737, 'Palena', 'CL', 'LL'),
(18063, 44, 737, 'Puerto Montt', 'CL', 'LL'),
(18064, 44, 737, 'Puerto Octay', 'CL', 'LL'),
(18065, 44, 737, 'Puerto Varas', 'CL', 'LL'),
(18066, 44, 737, 'Puqueldón', 'CL', 'LL'),
(18067, 44, 737, 'Purranque', 'CL', 'LL'),
(18068, 44, 737, 'Puyehue', 'CL', 'LL'),
(18069, 44, 737, 'Queilén', 'CL', 'LL'),
(18070, 44, 737, 'Quellón', 'CL', 'LL'),
(18071, 44, 737, 'Quemchi', 'CL', 'LL'),
(18072, 44, 737, 'Quinchao', 'CL', 'LL'),
(18073, 44, 737, 'Río Negro', 'CL', 'LL'),
(18074, 44, 737, 'San Juan de la Costa', 'CL', 'LL'),
(18075, 44, 737, 'San Pablo', 'CL', 'LL'),
(18076, 44, 738, 'Corral', 'CL', 'LR'),
(18077, 44, 738, 'Futrono', 'CL', 'LR'),
(18078, 44, 738, 'La Unión', 'CL', 'LR'),
(18079, 44, 738, 'Lago Ranco', 'CL', 'LR'),
(18080, 44, 738, 'Lanco', 'CL', 'LR'),
(18081, 44, 738, 'Los Lagos', 'CL', 'LR'),
(18082, 44, 738, 'Máfil', 'CL', 'LR'),
(18083, 44, 738, 'Mariquina', 'CL', 'LR'),
(18084, 44, 738, 'Paillaco', 'CL', 'LR'),
(18085, 44, 738, 'Panguipulli', 'CL', 'LR'),
(18086, 44, 738, 'Río Bueno', 'CL', 'LR'),
(18087, 44, 738, 'Valdivia', 'CL', 'LR'),
(18088, 44, 739, 'Antártica', 'CL', 'MA'),
(18089, 44, 739, 'Cabo de Hornos', 'CL', 'MA'),
(18090, 44, 739, 'Laguna Blanca', 'CL', 'MA'),
(18091, 44, 739, 'Natales', 'CL', 'MA'),
(18092, 44, 739, 'Porvenir', 'CL', 'MA'),
(18093, 44, 739, 'Primavera', 'CL', 'MA'),
(18094, 44, 739, 'Punta Arenas', 'CL', 'MA'),
(18095, 44, 739, 'Río Verde', 'CL', 'MA'),
(18096, 44, 739, 'San Gregorio', 'CL', 'MA'),
(18097, 44, 739, 'Timaukel', 'CL', 'MA'),
(18098, 44, 739, 'Torres del Paine', 'CL', 'MA'),
(18099, 44, 740, 'Cauquenes', 'CL', 'ML'),
(18100, 44, 740, 'Chanco', 'CL', 'ML'),
(18101, 44, 740, 'Colbún', 'CL', 'ML'),
(18102, 44, 740, 'Constitución', 'CL', 'ML'),
(18103, 44, 740, 'Curepto', 'CL', 'ML'),
(18104, 44, 740, 'Curicó', 'CL', 'ML'),
(18105, 44, 740, 'Empedrado', 'CL', 'ML'),
(18106, 44, 740, 'Hualañé', 'CL', 'ML'),
(18107, 44, 740, 'Licantén', 'CL', 'ML'),
(18108, 44, 740, 'Linares', 'CL', 'ML'),
(18109, 44, 740, 'Longaví', 'CL', 'ML'),
(18110, 44, 740, 'Maule', 'CL', 'ML'),
(18111, 44, 740, 'Molina', 'CL', 'ML'),
(18112, 44, 740, 'Parral', 'CL', 'ML'),
(18113, 44, 740, 'Pelarco', 'CL', 'ML'),
(18114, 44, 740, 'Pelluhue', 'CL', 'ML'),
(18115, 44, 740, 'Pencahue', 'CL', 'ML'),
(18116, 44, 740, 'Rauco', 'CL', 'ML'),
(18117, 44, 740, 'Retiro', 'CL', 'ML'),
(18118, 44, 740, 'Río Claro', 'CL', 'ML'),
(18119, 44, 740, 'Romeral', 'CL', 'ML'),
(18120, 44, 740, 'Sagrada Familia', 'CL', 'ML'),
(18121, 44, 740, 'San Clemente', 'CL', 'ML'),
(18122, 44, 740, 'San Javier', 'CL', 'ML'),
(18123, 44, 740, 'San Rafael', 'CL', 'ML'),
(18124, 44, 740, 'Talca', 'CL', 'ML'),
(18125, 44, 740, 'Teno', 'CL', 'ML'),
(18126, 44, 740, 'Vichuquén', 'CL', 'ML'),
(18127, 44, 740, 'Villa Alegre', 'CL', 'ML'),
(18128, 44, 740, 'Yerbas Buenas', 'CL', 'ML'),
(18129, 44, 741, 'Bulnes', 'CL', 'NB'),
(18130, 44, 741, 'Chillán', 'CL', 'NB'),
(18131, 44, 741, 'Chillán Viejo', 'CL', 'NB'),
(18132, 44, 741, 'Cobquecura', 'CL', 'NB'),
(18133, 44, 741, 'Coelemu', 'CL', 'NB'),
(18134, 44, 741, 'Coihueco', 'CL', 'NB'),
(18135, 44, 741, 'El Carmen', 'CL', 'NB'),
(18136, 44, 741, 'Ninhue', 'CL', 'NB'),
(18137, 44, 741, 'Ñiquén', 'CL', 'NB'),
(18138, 44, 741, 'Pemuco', 'CL', 'NB'),
(18139, 44, 741, 'Pinto', 'CL', 'NB'),
(18140, 44, 741, 'Portezuelo', 'CL', 'NB'),
(18141, 44, 741, 'Quillón', 'CL', 'NB'),
(18142, 44, 741, 'Quirihue', 'CL', 'NB'),
(18143, 44, 741, 'Ránquil', 'CL', 'NB'),
(18144, 44, 741, 'San Carlos', 'CL', 'NB'),
(18145, 44, 741, 'San Fabián', 'CL', 'NB'),
(18146, 44, 741, 'San Ignacio', 'CL', 'NB'),
(18147, 44, 741, 'San Nicolás', 'CL', 'NB'),
(18148, 44, 741, 'Treguaco', 'CL', 'NB'),
(18149, 44, 741, 'Yungay', 'CL', 'NB'),
(18150, 44, 742, 'Alhué', 'CL', 'RM'),
(18151, 44, 742, 'Buin', 'CL', 'RM'),
(18152, 44, 742, 'Calera de Tango', 'CL', 'RM'),
(18153, 44, 742, 'Cerrillos', 'CL', 'RM'),
(18154, 44, 742, 'Cerro Navia', 'CL', 'RM'),
(18155, 44, 742, 'Colina', 'CL', 'RM'),
(18156, 44, 742, 'Conchalí', 'CL', 'RM'),
(18157, 44, 742, 'Curacaví', 'CL', 'RM'),
(18158, 44, 742, 'El Bosque', 'CL', 'RM'),
(18159, 44, 742, 'El Monte', 'CL', 'RM'),
(18160, 44, 742, 'Estación Central', 'CL', 'RM'),
(18161, 44, 742, 'Huechuraba', 'CL', 'RM'),
(18162, 44, 742, 'Independencia', 'CL', 'RM'),
(18163, 44, 742, 'Isla de Maipo', 'CL', 'RM'),
(18164, 44, 742, 'La Cisterna', 'CL', 'RM'),
(18165, 44, 742, 'La Florida', 'CL', 'RM'),
(18166, 44, 742, 'La Granja', 'CL', 'RM'),
(18167, 44, 742, 'La Pintana', 'CL', 'RM'),
(18168, 44, 742, 'La Reina', 'CL', 'RM'),
(18169, 44, 742, 'Lampa', 'CL', 'RM'),
(18170, 44, 742, 'Las Condes', 'CL', 'RM'),
(18171, 44, 742, 'Lo Barnechea', 'CL', 'RM'),
(18172, 44, 742, 'Lo Espejo', 'CL', 'RM'),
(18173, 44, 742, 'Lo Prado', 'CL', 'RM'),
(18174, 44, 742, 'Macul', 'CL', 'RM'),
(18175, 44, 742, 'Maipú', 'CL', 'RM'),
(18176, 44, 742, 'María Pinto', 'CL', 'RM'),
(18177, 44, 742, 'Melipilla', 'CL', 'RM'),
(18178, 44, 742, 'Ñuñoa', 'CL', 'RM'),
(18179, 44, 742, 'Padre Hurtado', 'CL', 'RM'),
(18180, 44, 742, 'Paine', 'CL', 'RM'),
(18181, 44, 742, 'Pedro Aguirre Cerda', 'CL', 'RM'),
(18182, 44, 742, 'Peñaflor', 'CL', 'RM'),
(18183, 44, 742, 'Peñalolén', 'CL', 'RM'),
(18184, 44, 742, 'Pirque', 'CL', 'RM'),
(18185, 44, 742, 'Providencia', 'CL', 'RM'),
(18186, 44, 742, 'Pudahuel', 'CL', 'RM'),
(18187, 44, 742, 'Puente Alto', 'CL', 'RM'),
(18188, 44, 742, 'Quilicura', 'CL', 'RM'),
(18189, 44, 742, 'Quinta Normal', 'CL', 'RM'),
(18190, 44, 742, 'Recoleta', 'CL', 'RM'),
(18191, 44, 742, 'Renca', 'CL', 'RM'),
(18192, 44, 742, 'San Bernardo', 'CL', 'RM'),
(18193, 44, 742, 'San Joaquín', 'CL', 'RM'),
(18194, 44, 742, 'San José de Maipo', 'CL', 'RM'),
(18195, 44, 742, 'San Miguel', 'CL', 'RM'),
(18196, 44, 742, 'San Pedro', 'CL', 'RM'),
(18197, 44, 742, 'San Ramón', 'CL', 'RM'),
(18198, 44, 742, 'Santiago', 'CL', 'RM'),
(18199, 44, 742, 'Talagante', 'CL', 'RM'),
(18200, 44, 742, 'Tiltil', 'CL', 'RM'),
(18201, 44, 742, 'Vitacura', 'CL', 'RM'),
(18202, 44, 743, 'Alto Hospicio', 'CL', 'TA'),
(18203, 44, 743, 'Camiña', 'CL', 'TA'),
(18204, 44, 743, 'Colchane', 'CL', 'TA'),
(18205, 44, 743, 'Huara', 'CL', 'TA'),
(18206, 44, 743, 'Iquique', 'CL', 'TA'),
(18207, 44, 743, 'Pica', 'CL', 'TA'),
(18208, 44, 743, 'Pozo Almonte', 'CL', 'TA'),
(18209, 44, 744, 'Algarrobo', 'CL', 'VS'),
(18210, 44, 744, 'Cabildo', 'CL', 'VS'),
(18211, 44, 744, 'Calle Larga', 'CL', 'VS'),
(18212, 44, 744, 'Cartagena', 'CL', 'VS'),
(18213, 44, 744, 'Casablanca', 'CL', 'VS'),
(18214, 44, 744, 'Catemu', 'CL', 'VS'),
(18215, 44, 744, 'Concón', 'CL', 'VS'),
(18216, 44, 744, 'El Quisco', 'CL', 'VS'),
(18217, 44, 744, 'El Tabo', 'CL', 'VS'),
(18218, 44, 744, 'Hijuelas', 'CL', 'VS'),
(18219, 44, 744, 'Isla de Pascua', 'CL', 'VS'),
(18220, 44, 744, 'Juan Fernández', 'CL', 'VS'),
(18221, 44, 744, 'La Calera', 'CL', 'VS'),
(18222, 44, 744, 'La Cruz', 'CL', 'VS'),
(18223, 44, 744, 'La Ligua', 'CL', 'VS'),
(18224, 44, 744, 'Limache', 'CL', 'VS'),
(18225, 44, 744, 'Llaillay', 'CL', 'VS'),
(18226, 44, 744, 'Los Andes', 'CL', 'VS'),
(18227, 44, 744, 'Nogales', 'CL', 'VS'),
(18228, 44, 744, 'Olmué', 'CL', 'VS'),
(18229, 44, 744, 'Panquehue', 'CL', 'VS'),
(18230, 44, 744, 'Papudo', 'CL', 'VS'),
(18231, 44, 744, 'Petorca', 'CL', 'VS'),
(18232, 44, 744, 'Puchuncaví', 'CL', 'VS'),
(18233, 44, 744, 'Putaendo', 'CL', 'VS'),
(18234, 44, 744, 'Quillota', 'CL', 'VS'),
(18235, 44, 744, 'Quilpué', 'CL', 'VS'),
(18236, 44, 744, 'Quintero', 'CL', 'VS'),
(18237, 44, 744, 'Rinconada', 'CL', 'VS'),
(18238, 44, 744, 'San Antonio', 'CL', 'VS'),
(18239, 44, 744, 'San Esteban', 'CL', 'VS'),
(18240, 44, 744, 'San Felipe', 'CL', 'VS'),
(18241, 44, 744, 'Santa María', 'CL', 'VS'),
(18242, 44, 744, 'Santo Domingo', 'CL', 'VS'),
(18243, 44, 744, 'Valparaíso', 'CL', 'VS'),
(18244, 44, 744, 'Villa Alemana', 'CL', 'VS'),
(18245, 44, 744, 'Viña del Mar', 'CL', 'VS'),
(18246, 44, 744, 'Zapallar', 'CL', 'VS'),
(18247, 45, 745, 'Anqing', 'CN', 'AH'),
(18248, 45, 745, 'Anqing Shi', 'CN', 'AH'),
(18249, 45, 745, 'Bengbu', 'CN', 'AH'),
(18250, 45, 745, 'Bozhou', 'CN', 'AH'),
(18251, 45, 745, 'Chaohu', 'CN', 'AH'),
(18252, 45, 745, 'Chizhou', 'CN', 'AH'),
(18253, 45, 745, 'Chizhou Shi', 'CN', 'AH'),
(18254, 45, 745, 'Chuzhou', 'CN', 'AH'),
(18255, 45, 745, 'Chuzhou Shi', 'CN', 'AH'),
(18256, 45, 745, 'Datong', 'CN', 'AH'),
(18257, 45, 745, 'Fuyang', 'CN', 'AH'),
(18258, 45, 745, 'Fuyang Shi', 'CN', 'AH'),
(18259, 45, 745, 'Gushu', 'CN', 'AH'),
(18260, 45, 745, 'Hefei', 'CN', 'AH'),
(18261, 45, 745, 'Hefei Shi', 'CN', 'AH'),
(18262, 45, 745, 'Huaibei', 'CN', 'AH'),
(18263, 45, 745, 'Huainan', 'CN', 'AH'),
(18264, 45, 745, 'Huainan Shi', 'CN', 'AH'),
(18265, 45, 745, 'Huaiyuan Chengguanzhen', 'CN', 'AH'),
(18266, 45, 745, 'Huangshan', 'CN', 'AH'),
(18267, 45, 745, 'Huangshan Shi', 'CN', 'AH'),
(18268, 45, 745, 'Huoqiu Chengguanzhen', 'CN', 'AH'),
(18269, 45, 745, 'Jieshou', 'CN', 'AH'),
(18270, 45, 745, 'Lu’an', 'CN', 'AH'),
(18271, 45, 745, 'Lucheng', 'CN', 'AH'),
(18272, 45, 745, 'Mengcheng Chengguanzhen', 'CN', 'AH'),
(18273, 45, 745, 'Mingguang', 'CN', 'AH'),
(18274, 45, 745, 'Suixi', 'CN', 'AH'),
(18275, 45, 745, 'Suzhou', 'CN', 'AH'),
(18276, 45, 745, 'Suzhou Shi', 'CN', 'AH'),
(18277, 45, 745, 'Tangzhai', 'CN', 'AH'),
(18278, 45, 745, 'Wucheng', 'CN', 'AH'),
(18279, 45, 745, 'Wuhu', 'CN', 'AH'),
(18280, 45, 745, 'Wusong', 'CN', 'AH'),
(18281, 45, 745, 'Wuyang', 'CN', 'AH'),
(18282, 45, 745, 'Xuanzhou', 'CN', 'AH'),
(18283, 45, 745, 'Yingshang Chengguanzhen', 'CN', 'AH'),
(18284, 45, 746, 'Beijing', 'CN', 'BJ'),
(18285, 45, 746, 'Changping', 'CN', 'BJ'),
(18286, 45, 746, 'Daxing', 'CN', 'BJ'),
(18287, 45, 746, 'Fangshan', 'CN', 'BJ'),
(18288, 45, 746, 'Liangxiang', 'CN', 'BJ'),
(18289, 45, 746, 'Mentougou', 'CN', 'BJ'),
(18290, 45, 746, 'Shunyi', 'CN', 'BJ'),
(18291, 45, 746, 'Tongzhou', 'CN', 'BJ'),
(18292, 45, 747, 'Beibei', 'CN', 'CQ'),
(18293, 45, 747, 'Caijia', 'CN', 'CQ'),
(18294, 45, 747, 'Chongqing', 'CN', 'CQ'),
(18295, 45, 747, 'Dongxi', 'CN', 'CQ'),
(18296, 45, 747, 'Fuling', 'CN', 'CQ'),
(18297, 45, 747, 'Ganshui', 'CN', 'CQ'),
(18298, 45, 747, 'Guofuchang', 'CN', 'CQ'),
(18299, 45, 747, 'Hechuan', 'CN', 'CQ'),
(18300, 45, 747, 'Jijiang', 'CN', 'CQ'),
(18301, 45, 747, 'Liangping District', 'CN', 'CQ'),
(18302, 45, 747, 'Puhechang', 'CN', 'CQ'),
(18303, 45, 747, 'Shapingba District', 'CN', 'CQ'),
(18304, 45, 747, 'Shijiaochang', 'CN', 'CQ'),
(18305, 45, 747, 'Wanxian', 'CN', 'CQ'),
(18306, 45, 747, 'Wanzhou District', 'CN', 'CQ'),
(18307, 45, 747, 'Yongchuan', 'CN', 'CQ'),
(18308, 45, 747, 'Yudong', 'CN', 'CQ'),
(18309, 45, 747, 'Yuzhong District', 'CN', 'CQ'),
(18310, 45, 748, 'Badu', 'CN', 'FJ'),
(18311, 45, 748, 'Baiqi', 'CN', 'FJ'),
(18312, 45, 748, 'Baiyun', 'CN', 'FJ'),
(18313, 45, 748, 'Beishancun', 'CN', 'FJ'),
(18314, 45, 748, 'Changqiao', 'CN', 'FJ'),
(18315, 45, 748, 'Chengmen', 'CN', 'FJ'),
(18316, 45, 748, 'Chixi', 'CN', 'FJ'),
(18317, 45, 748, 'Chongru', 'CN', 'FJ'),
(18318, 45, 748, 'Dadeng', 'CN', 'FJ'),
(18319, 45, 748, 'Daixi', 'CN', 'FJ'),
(18320, 45, 748, 'Danyang', 'CN', 'FJ'),
(18321, 45, 748, 'Daqiao', 'CN', 'FJ'),
(18322, 45, 748, 'Dazuo', 'CN', 'FJ'),
(18323, 45, 748, 'Dinghaicun', 'CN', 'FJ'),
(18324, 45, 748, 'Dingtoucun', 'CN', 'FJ'),
(18325, 45, 748, 'Dongchongcun', 'CN', 'FJ'),
(18326, 45, 748, 'Dongdai', 'CN', 'FJ'),
(18327, 45, 748, 'Donghu', 'CN', 'FJ'),
(18328, 45, 748, 'Dongling', 'CN', 'FJ'),
(18329, 45, 748, 'Dongyuan', 'CN', 'FJ'),
(18330, 45, 748, 'Feiluan', 'CN', 'FJ'),
(18331, 45, 748, 'Fengpu', 'CN', 'FJ'),
(18332, 45, 748, 'Fengzhou', 'CN', 'FJ'),
(18333, 45, 748, 'Fu’an', 'CN', 'FJ'),
(18334, 45, 748, 'Fuding', 'CN', 'FJ'),
(18335, 45, 748, 'Fuqing', 'CN', 'FJ'),
(18336, 45, 748, 'Fuzhou', 'CN', 'FJ'),
(18337, 45, 748, 'Gantang', 'CN', 'FJ'),
(18338, 45, 748, 'Guantou', 'CN', 'FJ'),
(18339, 45, 748, 'Gufeng', 'CN', 'FJ'),
(18340, 45, 748, 'Hetang', 'CN', 'FJ'),
(18341, 45, 748, 'Hongtang', 'CN', 'FJ'),
(18342, 45, 748, 'Hongyang', 'CN', 'FJ'),
(18343, 45, 748, 'Houyu', 'CN', 'FJ'),
(18344, 45, 748, 'Huai’an', 'CN', 'FJ'),
(18345, 45, 748, 'Huangtian', 'CN', 'FJ'),
(18346, 45, 748, 'Huotong', 'CN', 'FJ'),
(18347, 45, 748, 'Jian’ou', 'CN', 'FJ'),
(18348, 45, 748, 'Jiangkou', 'CN', 'FJ'),
(18349, 45, 748, 'Jianjiang', 'CN', 'FJ'),
(18350, 45, 748, 'Jingfeng', 'CN', 'FJ'),
(18351, 45, 748, 'Jinjiang', 'CN', 'FJ'),
(18352, 45, 748, 'Jinjing', 'CN', 'FJ'),
(18353, 45, 748, 'Jitoucun', 'CN', 'FJ'),
(18354, 45, 748, 'Kengyuan', 'CN', 'FJ'),
(18355, 45, 748, 'Kerencun', 'CN', 'FJ'),
(18356, 45, 748, 'Kuai’an', 'CN', 'FJ'),
(18357, 45, 748, 'Lianhecun', 'CN', 'FJ'),
(18358, 45, 748, 'Liuwudiancun', 'CN', 'FJ'),
(18359, 45, 748, 'Longmen', 'CN', 'FJ'),
(18360, 45, 748, 'Longyan', 'CN', 'FJ'),
(18361, 45, 748, 'Luoqiao', 'CN', 'FJ'),
(18362, 45, 748, 'Luoyang', 'CN', 'FJ'),
(18363, 45, 748, 'Luxia', 'CN', 'FJ'),
(18364, 45, 748, 'Maping', 'CN', 'FJ'),
(18365, 45, 748, 'Meipu', 'CN', 'FJ'),
(18366, 45, 748, 'Min’an', 'CN', 'FJ'),
(18367, 45, 748, 'Nanping', 'CN', 'FJ'),
(18368, 45, 748, 'Neikeng', 'CN', 'FJ'),
(18369, 45, 748, 'Ningde', 'CN', 'FJ'),
(18370, 45, 748, 'Pandu', 'CN', 'FJ'),
(18371, 45, 748, 'Pucheng', 'CN', 'FJ'),
(18372, 45, 748, 'Putian', 'CN', 'FJ'),
(18373, 45, 748, 'Qibu', 'CN', 'FJ'),
(18374, 45, 748, 'Qidu', 'CN', 'FJ'),
(18375, 45, 748, 'Quanzhou', 'CN', 'FJ'),
(18376, 45, 748, 'Rong’an', 'CN', 'FJ'),
(18377, 45, 748, 'Sanming', 'CN', 'FJ'),
(18378, 45, 748, 'Shajiang', 'CN', 'FJ'),
(18379, 45, 748, 'Shangjie', 'CN', 'FJ'),
(18380, 45, 748, 'Shanxia', 'CN', 'FJ'),
(18381, 45, 748, 'Shanyang', 'CN', 'FJ'),
(18382, 45, 748, 'Shaowu', 'CN', 'FJ'),
(18383, 45, 748, 'Shijing', 'CN', 'FJ'),
(18384, 45, 748, 'Shima', 'CN', 'FJ'),
(18385, 45, 748, 'Shoushan', 'CN', 'FJ'),
(18386, 45, 748, 'Shuangxi', 'CN', 'FJ'),
(18387, 45, 748, 'Shuangzhu', 'CN', 'FJ'),
(18388, 45, 748, 'Shuikou', 'CN', 'FJ'),
(18389, 45, 748, 'Tangkou', 'CN', 'FJ'),
(18390, 45, 748, 'Tantou', 'CN', 'FJ'),
(18391, 45, 748, 'Tatou', 'CN', 'FJ'),
(18392, 45, 748, 'Tingjiang', 'CN', 'FJ'),
(18393, 45, 748, 'Tuzhai', 'CN', 'FJ'),
(18394, 45, 748, 'Wubao', 'CN', 'FJ'),
(18395, 45, 748, 'Wuyishan', 'CN', 'FJ'),
(18396, 45, 748, 'Wuyucun', 'CN', 'FJ'),
(18397, 45, 748, 'Xiabaishi', 'CN', 'FJ'),
(18398, 45, 748, 'Xiahu', 'CN', 'FJ'),
(18399, 45, 748, 'Xiamen', 'CN', 'FJ'),
(18400, 45, 748, 'Xiancun', 'CN', 'FJ'),
(18401, 45, 748, 'Xiangyun', 'CN', 'FJ'),
(18402, 45, 748, 'Xibing', 'CN', 'FJ'),
(18403, 45, 748, 'Xiling', 'CN', 'FJ'),
(18404, 45, 748, 'Ximei', 'CN', 'FJ'),
(18405, 45, 748, 'Xinan', 'CN', 'FJ'),
(18406, 45, 748, 'Xindian', 'CN', 'FJ'),
(18407, 45, 748, 'Yakou', 'CN', 'FJ'),
(18408, 45, 748, 'Yanghou', 'CN', 'FJ'),
(18409, 45, 748, 'Yangzhong', 'CN', 'FJ'),
(18410, 45, 748, 'Yantian', 'CN', 'FJ'),
(18411, 45, 748, 'Yingdu', 'CN', 'FJ'),
(18412, 45, 748, 'Yinglin', 'CN', 'FJ'),
(18413, 45, 748, 'Yongning', 'CN', 'FJ'),
(18414, 45, 748, 'Yushan', 'CN', 'FJ'),
(18415, 45, 748, 'Zhangwan', 'CN', 'FJ'),
(18416, 45, 748, 'Zhangzhou', 'CN', 'FJ'),
(18417, 45, 748, 'Zhenhaicun', 'CN', 'FJ'),
(18418, 45, 748, 'Zhongfang', 'CN', 'FJ'),
(18419, 45, 748, 'Zhuoyang', 'CN', 'FJ'),
(18420, 45, 748, 'Zhuqi', 'CN', 'FJ'),
(18421, 45, 749, 'Baiyin', 'CN', 'GS'),
(18422, 45, 749, 'Beidao', 'CN', 'GS'),
(18423, 45, 749, 'Dingxi Shi', 'CN', 'GS'),
(18424, 45, 749, 'Hezuo', 'CN', 'GS'),
(18425, 45, 749, 'Jiayuguan', 'CN', 'GS'),
(18426, 45, 749, 'Jinchang', 'CN', 'GS'),
(18427, 45, 749, 'Jiuquan', 'CN', 'GS'),
(18428, 45, 749, 'Lanzhou', 'CN', 'GS'),
(18429, 45, 749, 'Laojunmiao', 'CN', 'GS'),
(18430, 45, 749, 'Linxia Chengguanzhen', 'CN', 'GS'),
(18431, 45, 749, 'Linxia Huizu Zizhizhou', 'CN', 'GS'),
(18432, 45, 749, 'Longnan Shi', 'CN', 'GS'),
(18433, 45, 749, 'Mawu', 'CN', 'GS'),
(18434, 45, 749, 'Pingliang', 'CN', 'GS'),
(18435, 45, 749, 'Qincheng', 'CN', 'GS'),
(18436, 45, 749, 'Qingyang Shi', 'CN', 'GS'),
(18437, 45, 749, 'Tianshui', 'CN', 'GS'),
(18438, 45, 749, 'Wuwei', 'CN', 'GS'),
(18439, 45, 749, 'Zhangye', 'CN', 'GS'),
(18440, 45, 749, 'Zhangye Shi', 'CN', 'GS'),
(18441, 45, 750, 'Anbu', 'CN', 'GD'),
(18442, 45, 750, 'Chaozhou', 'CN', 'GD'),
(18443, 45, 750, 'Chenghua', 'CN', 'GD'),
(18444, 45, 750, 'Daliang', 'CN', 'GD'),
(18445, 45, 750, 'Danshui', 'CN', 'GD'),
(18446, 45, 750, 'Dasha', 'CN', 'GD'),
(18447, 45, 750, 'Dongguan', 'CN', 'GD'),
(18448, 45, 750, 'Donghai', 'CN', 'GD'),
(18449, 45, 750, 'Ducheng', 'CN', 'GD'),
(18450, 45, 750, 'Encheng', 'CN', 'GD'),
(18451, 45, 750, 'Foshan', 'CN', 'GD'),
(18452, 45, 750, 'Foshan Shi', 'CN', 'GD'),
(18453, 45, 750, 'Gaoyao', 'CN', 'GD'),
(18454, 45, 750, 'Gaozhou', 'CN', 'GD'),
(18455, 45, 750, 'Guangzhou', 'CN', 'GD'),
(18456, 45, 750, 'Guangzhou Shi', 'CN', 'GD'),
(18457, 45, 750, 'Haikuotiankong', 'CN', 'GD'),
(18458, 45, 750, 'Haimen', 'CN', 'GD'),
(18459, 45, 750, 'Hepo', 'CN', 'GD'),
(18460, 45, 750, 'Heyuan', 'CN', 'GD'),
(18461, 45, 750, 'Huaicheng', 'CN', 'GD'),
(18462, 45, 750, 'Huanggang', 'CN', 'GD'),
(18463, 45, 750, 'Huazhou', 'CN', 'GD'),
(18464, 45, 750, 'Huicheng', 'CN', 'GD'),
(18465, 45, 750, 'Huizhou', 'CN', 'GD'),
(18466, 45, 750, 'Humen', 'CN', 'GD'),
(18467, 45, 750, 'Jiangmen', 'CN', 'GD'),
(18468, 45, 750, 'Jiazi', 'CN', 'GD'),
(18469, 45, 750, 'Jieshi', 'CN', 'GD'),
(18470, 45, 750, 'Jieyang', 'CN', 'GD'),
(18471, 45, 750, 'Lecheng', 'CN', 'GD'),
(18472, 45, 750, 'Lianjiang', 'CN', 'GD'),
(18473, 45, 750, 'Lianzhou', 'CN', 'GD'),
(18474, 45, 750, 'Licheng', 'CN', 'GD'),
(18475, 45, 750, 'Lubu', 'CN', 'GD'),
(18476, 45, 750, 'Luocheng', 'CN', 'GD'),
(18477, 45, 750, 'Luoyang', 'CN', 'GD'),
(18478, 45, 750, 'Maba', 'CN', 'GD'),
(18479, 45, 750, 'Maoming', 'CN', 'GD'),
(18480, 45, 750, 'Meizhou', 'CN', 'GD'),
(18481, 45, 750, 'Nanfeng', 'CN', 'GD'),
(18482, 45, 750, 'Pingshan', 'CN', 'GD'),
(18483, 45, 750, 'Puning', 'CN', 'GD'),
(18484, 45, 750, 'Qingyuan', 'CN', 'GD'),
(18485, 45, 750, 'Sanshui', 'CN', 'GD'),
(18486, 45, 750, 'Shantou', 'CN', 'GD'),
(18487, 45, 750, 'Shanwei', 'CN', 'GD'),
(18488, 45, 750, 'Shaoguan', 'CN', 'GD'),
(18489, 45, 750, 'Shaping', 'CN', 'GD'),
(18490, 45, 750, 'Shenzhen', 'CN', 'GD'),
(18491, 45, 750, 'Shilong', 'CN', 'GD'),
(18492, 45, 750, 'Shiqi', 'CN', 'GD'),
(18493, 45, 750, 'Shiqiao', 'CN', 'GD'),
(18494, 45, 750, 'Shiwan', 'CN', 'GD'),
(18495, 45, 750, 'Shixing', 'CN', 'GD'),
(18496, 45, 750, 'Taishan', 'CN', 'GD'),
(18497, 45, 750, 'Tangping', 'CN', 'GD'),
(18498, 45, 750, 'Wuchuan', 'CN', 'GD'),
(18499, 45, 750, 'Xingning', 'CN', 'GD'),
(18500, 45, 750, 'Xinhui', 'CN', 'GD');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(18501, 45, 750, 'Xinyi', 'CN', 'GD'),
(18502, 45, 750, 'Xiongzhou', 'CN', 'GD'),
(18503, 45, 750, 'Xucheng', 'CN', 'GD'),
(18504, 45, 750, 'Yangchun', 'CN', 'GD'),
(18505, 45, 750, 'Yangjiang', 'CN', 'GD'),
(18506, 45, 750, 'Yingcheng', 'CN', 'GD'),
(18507, 45, 750, 'Yunfu', 'CN', 'GD'),
(18508, 45, 750, 'Zhanjiang', 'CN', 'GD'),
(18509, 45, 750, 'Zhaoqing', 'CN', 'GD'),
(18510, 45, 750, 'Zhongshan', 'CN', 'GD'),
(18511, 45, 750, 'Zhongshan Prefecture', 'CN', 'GD'),
(18512, 45, 750, 'Zhuhai', 'CN', 'GD'),
(18513, 45, 751, 'Babu', 'CN', 'GX'),
(18514, 45, 751, 'Baihe', 'CN', 'GX'),
(18515, 45, 751, 'Baise City', 'CN', 'GX'),
(18516, 45, 751, 'Baise Shi', 'CN', 'GX'),
(18517, 45, 751, 'Beihai', 'CN', 'GX'),
(18518, 45, 751, 'Chongzuo Shi', 'CN', 'GX'),
(18519, 45, 751, 'Dazhai', 'CN', 'GX'),
(18520, 45, 751, 'Fangchenggang Shi', 'CN', 'GX'),
(18521, 45, 751, 'Guigang', 'CN', 'GX'),
(18522, 45, 751, 'Guilin', 'CN', 'GX'),
(18523, 45, 751, 'Guilin Shi', 'CN', 'GX'),
(18524, 45, 751, 'Guiping', 'CN', 'GX'),
(18525, 45, 751, 'Hechi Shi', 'CN', 'GX'),
(18526, 45, 751, 'Jinji', 'CN', 'GX'),
(18527, 45, 751, 'Laibin', 'CN', 'GX'),
(18528, 45, 751, 'Lianzhou', 'CN', 'GX'),
(18529, 45, 751, 'Lingcheng', 'CN', 'GX'),
(18530, 45, 751, 'Liuzhou Shi', 'CN', 'GX'),
(18531, 45, 751, 'Luorong', 'CN', 'GX'),
(18532, 45, 751, 'Nandu', 'CN', 'GX'),
(18533, 45, 751, 'Nanning', 'CN', 'GX'),
(18534, 45, 751, 'Pingnan', 'CN', 'GX'),
(18535, 45, 751, 'Pumiao', 'CN', 'GX'),
(18536, 45, 751, 'Qinzhou', 'CN', 'GX'),
(18537, 45, 751, 'Wuzhou', 'CN', 'GX'),
(18538, 45, 751, 'Yangshuo', 'CN', 'GX'),
(18539, 45, 751, 'Yashan', 'CN', 'GX'),
(18540, 45, 751, 'Yulin', 'CN', 'GX'),
(18541, 45, 752, 'Anshun', 'CN', 'GZ'),
(18542, 45, 752, 'Aoshi', 'CN', 'GZ'),
(18543, 45, 752, 'Bahuang', 'CN', 'GZ'),
(18544, 45, 752, 'Baishi', 'CN', 'GZ'),
(18545, 45, 752, 'Bangdong', 'CN', 'GZ'),
(18546, 45, 752, 'Benchu', 'CN', 'GZ'),
(18547, 45, 752, 'Bijie', 'CN', 'GZ'),
(18548, 45, 752, 'Chadian', 'CN', 'GZ'),
(18549, 45, 752, 'Changsha', 'CN', 'GZ'),
(18550, 45, 752, 'Chumi', 'CN', 'GZ'),
(18551, 45, 752, 'Dabachang', 'CN', 'GZ'),
(18552, 45, 752, 'Darong', 'CN', 'GZ'),
(18553, 45, 752, 'Dundong', 'CN', 'GZ'),
(18554, 45, 752, 'Duyun', 'CN', 'GZ'),
(18555, 45, 752, 'Gaoniang', 'CN', 'GZ'),
(18556, 45, 752, 'Gaowu', 'CN', 'GZ'),
(18557, 45, 752, 'Gaozeng', 'CN', 'GZ'),
(18558, 45, 752, 'Guandu', 'CN', 'GZ'),
(18559, 45, 752, 'Guiyang', 'CN', 'GZ'),
(18560, 45, 752, 'Huaqiu', 'CN', 'GZ'),
(18561, 45, 752, 'Lantian', 'CN', 'GZ'),
(18562, 45, 752, 'Liangcunchang', 'CN', 'GZ'),
(18563, 45, 752, 'Liupanshui', 'CN', 'GZ'),
(18564, 45, 752, 'Longlisuo', 'CN', 'GZ'),
(18565, 45, 752, 'Loushanguan', 'CN', 'GZ'),
(18566, 45, 752, 'Maoping', 'CN', 'GZ'),
(18567, 45, 752, 'Ouyang', 'CN', 'GZ'),
(18568, 45, 752, 'Pingjiang', 'CN', 'GZ'),
(18569, 45, 752, 'Qiandongnan Miao and Dong Autonomous Prefecture', 'CN', 'GZ'),
(18570, 45, 752, 'Qianxinan Bouyeizu Miaozu Zizhizhou', 'CN', 'GZ'),
(18571, 45, 752, 'Qimeng', 'CN', 'GZ'),
(18572, 45, 752, 'Qinglang', 'CN', 'GZ'),
(18573, 45, 752, 'Runsong', 'CN', 'GZ'),
(18574, 45, 752, 'Sanchahe', 'CN', 'GZ'),
(18575, 45, 752, 'Sangmu', 'CN', 'GZ'),
(18576, 45, 752, 'Shiqian', 'CN', 'GZ'),
(18577, 45, 752, 'Songkan', 'CN', 'GZ'),
(18578, 45, 752, 'Tingdong', 'CN', 'GZ'),
(18579, 45, 752, 'Tonggu', 'CN', 'GZ'),
(18580, 45, 752, 'Tongren', 'CN', 'GZ'),
(18581, 45, 752, 'Tongren Diqu', 'CN', 'GZ'),
(18582, 45, 752, 'Weining', 'CN', 'GZ'),
(18583, 45, 752, 'Wenshui', 'CN', 'GZ'),
(18584, 45, 752, 'Xiajiang', 'CN', 'GZ'),
(18585, 45, 752, 'Xiaoweizhai', 'CN', 'GZ'),
(18586, 45, 752, 'Xinzhan', 'CN', 'GZ'),
(18587, 45, 752, 'Xishan', 'CN', 'GZ'),
(18588, 45, 752, 'Xujiaba', 'CN', 'GZ'),
(18589, 45, 752, 'Yangtou', 'CN', 'GZ'),
(18590, 45, 752, 'Youyupu', 'CN', 'GZ'),
(18591, 45, 752, 'Zhongchao', 'CN', 'GZ'),
(18592, 45, 752, 'Zhujiachang', 'CN', 'GZ'),
(18593, 45, 752, 'Zunyi', 'CN', 'GZ'),
(18594, 45, 753, 'Basuo', 'CN', 'HI'),
(18595, 45, 753, 'Chongshan', 'CN', 'HI'),
(18596, 45, 753, 'Dadonghai', 'CN', 'HI'),
(18597, 45, 753, 'Haikou', 'CN', 'HI'),
(18598, 45, 753, 'Jinjiang', 'CN', 'HI'),
(18599, 45, 753, 'Lincheng', 'CN', 'HI'),
(18600, 45, 753, 'Nada', 'CN', 'HI'),
(18601, 45, 753, 'Qionghai', 'CN', 'HI'),
(18602, 45, 753, 'Qiongshan', 'CN', 'HI'),
(18603, 45, 753, 'Sansha', 'CN', 'HI'),
(18604, 45, 753, 'Sanya', 'CN', 'HI'),
(18605, 45, 753, 'Wanning', 'CN', 'HI'),
(18606, 45, 753, 'Wenchang', 'CN', 'HI'),
(18607, 45, 753, 'Xiuying', 'CN', 'HI'),
(18608, 45, 754, 'Baoding', 'CN', 'HE'),
(18609, 45, 754, 'Beidaihehaibin', 'CN', 'HE'),
(18610, 45, 754, 'Botou', 'CN', 'HE'),
(18611, 45, 754, 'Cangzhou', 'CN', 'HE'),
(18612, 45, 754, 'Cangzhou Shi', 'CN', 'HE'),
(18613, 45, 754, 'Changli', 'CN', 'HE'),
(18614, 45, 754, 'Chengde', 'CN', 'HE'),
(18615, 45, 754, 'Chengde Prefecture', 'CN', 'HE'),
(18616, 45, 754, 'Dingzhou', 'CN', 'HE'),
(18617, 45, 754, 'Fengrun', 'CN', 'HE'),
(18618, 45, 754, 'Guye', 'CN', 'HE'),
(18619, 45, 754, 'Handan', 'CN', 'HE'),
(18620, 45, 754, 'Hecun', 'CN', 'HE'),
(18621, 45, 754, 'Hengshui', 'CN', 'HE'),
(18622, 45, 754, 'Langfang', 'CN', 'HE'),
(18623, 45, 754, 'Langfang Shi', 'CN', 'HE'),
(18624, 45, 754, 'Linshui', 'CN', 'HE'),
(18625, 45, 754, 'Linxi', 'CN', 'HE'),
(18626, 45, 754, 'Luancheng', 'CN', 'HE'),
(18627, 45, 754, 'Nangong', 'CN', 'HE'),
(18628, 45, 754, 'Pengcheng', 'CN', 'HE'),
(18629, 45, 754, 'Qinhuangdao', 'CN', 'HE'),
(18630, 45, 754, 'Renqiu', 'CN', 'HE'),
(18631, 45, 754, 'Shahecheng', 'CN', 'HE'),
(18632, 45, 754, 'Shanhaiguan', 'CN', 'HE'),
(18633, 45, 754, 'Shijiazhuang', 'CN', 'HE'),
(18634, 45, 754, 'Shijiazhuang Shi', 'CN', 'HE'),
(18635, 45, 754, 'Songling', 'CN', 'HE'),
(18636, 45, 754, 'Tangjiazhuang', 'CN', 'HE'),
(18637, 45, 754, 'Tangshan', 'CN', 'HE'),
(18638, 45, 754, 'Tangshan Shi', 'CN', 'HE'),
(18639, 45, 754, 'Tianchang', 'CN', 'HE'),
(18640, 45, 754, 'Xingtai', 'CN', 'HE'),
(18641, 45, 754, 'Xinji', 'CN', 'HE'),
(18642, 45, 754, 'Zhangjiakou', 'CN', 'HE'),
(18643, 45, 754, 'Zhangjiakou Shi', 'CN', 'HE'),
(18644, 45, 754, 'Zhangjiakou Shi Xuanhua Qu', 'CN', 'HE'),
(18645, 45, 754, 'Zhaogezhuang', 'CN', 'HE'),
(18646, 45, 754, 'Zunhua', 'CN', 'HE'),
(18647, 45, 755, 'Acheng', 'CN', 'HL'),
(18648, 45, 755, 'Anda', 'CN', 'HL'),
(18649, 45, 755, 'Baiquan', 'CN', 'HL'),
(18650, 45, 755, 'Bamiantong', 'CN', 'HL'),
(18651, 45, 755, 'Baoqing', 'CN', 'HL'),
(18652, 45, 755, 'Baoshan', 'CN', 'HL'),
(18653, 45, 755, 'Bayan', 'CN', 'HL'),
(18654, 45, 755, 'Bei’an', 'CN', 'HL'),
(18655, 45, 755, 'Binzhou', 'CN', 'HL'),
(18656, 45, 755, 'Boli', 'CN', 'HL'),
(18657, 45, 755, 'Chaihe', 'CN', 'HL'),
(18658, 45, 755, 'Chengzihe', 'CN', 'HL'),
(18659, 45, 755, 'Daqing', 'CN', 'HL'),
(18660, 45, 755, 'Dongning', 'CN', 'HL'),
(18661, 45, 755, 'Dongxing', 'CN', 'HL'),
(18662, 45, 755, 'Fendou', 'CN', 'HL'),
(18663, 45, 755, 'Fengxiang', 'CN', 'HL'),
(18664, 45, 755, 'Fujin', 'CN', 'HL'),
(18665, 45, 755, 'Fuli', 'CN', 'HL'),
(18666, 45, 755, 'Fuyu', 'CN', 'HL'),
(18667, 45, 755, 'Fuyuan', 'CN', 'HL'),
(18668, 45, 755, 'Gannan', 'CN', 'HL'),
(18669, 45, 755, 'Hailin', 'CN', 'HL'),
(18670, 45, 755, 'Hailun', 'CN', 'HL'),
(18671, 45, 755, 'Harbin', 'CN', 'HL'),
(18672, 45, 755, 'Hegang', 'CN', 'HL'),
(18673, 45, 755, 'Heihe', 'CN', 'HL'),
(18674, 45, 755, 'Honggang', 'CN', 'HL'),
(18675, 45, 755, 'Huanan', 'CN', 'HL'),
(18676, 45, 755, 'Hulan', 'CN', 'HL'),
(18677, 45, 755, 'Hulan Ergi', 'CN', 'HL'),
(18678, 45, 755, 'Jiamusi', 'CN', 'HL'),
(18679, 45, 755, 'Jidong', 'CN', 'HL'),
(18680, 45, 755, 'Jixi', 'CN', 'HL'),
(18681, 45, 755, 'Langxiang', 'CN', 'HL'),
(18682, 45, 755, 'Lanxi', 'CN', 'HL'),
(18683, 45, 755, 'Lianhe', 'CN', 'HL'),
(18684, 45, 755, 'Lingdong', 'CN', 'HL'),
(18685, 45, 755, 'Linkou', 'CN', 'HL'),
(18686, 45, 755, 'Longfeng', 'CN', 'HL'),
(18687, 45, 755, 'Longjiang', 'CN', 'HL'),
(18688, 45, 755, 'Mingshui', 'CN', 'HL'),
(18689, 45, 755, 'Mishan', 'CN', 'HL'),
(18690, 45, 755, 'Mudanjiang', 'CN', 'HL'),
(18691, 45, 755, 'Nehe', 'CN', 'HL'),
(18692, 45, 755, 'Nenjiang', 'CN', 'HL'),
(18693, 45, 755, 'Nianzishan', 'CN', 'HL'),
(18694, 45, 755, 'Ning’an', 'CN', 'HL'),
(18695, 45, 755, 'Qinggang', 'CN', 'HL'),
(18696, 45, 755, 'Qiqihar', 'CN', 'HL'),
(18697, 45, 755, 'Shangzhi', 'CN', 'HL'),
(18698, 45, 755, 'Shanhecun', 'CN', 'HL'),
(18699, 45, 755, 'Shuangcheng', 'CN', 'HL'),
(18700, 45, 755, 'Shuangyashan', 'CN', 'HL'),
(18701, 45, 755, 'Suifenhe', 'CN', 'HL'),
(18702, 45, 755, 'Suihua', 'CN', 'HL'),
(18703, 45, 755, 'Suileng', 'CN', 'HL'),
(18704, 45, 755, 'Tahe', 'CN', 'HL'),
(18705, 45, 755, 'Taihecun', 'CN', 'HL'),
(18706, 45, 755, 'Taikang', 'CN', 'HL'),
(18707, 45, 755, 'Tailai', 'CN', 'HL'),
(18708, 45, 755, 'Tieli', 'CN', 'HL'),
(18709, 45, 755, 'Wangkui', 'CN', 'HL'),
(18710, 45, 755, 'Wuchang', 'CN', 'HL'),
(18711, 45, 755, 'Xinqing', 'CN', 'HL'),
(18712, 45, 755, 'Yichun', 'CN', 'HL'),
(18713, 45, 755, 'Yilan', 'CN', 'HL'),
(18714, 45, 755, 'Youhao', 'CN', 'HL'),
(18715, 45, 755, 'Zhaodong', 'CN', 'HL'),
(18716, 45, 755, 'Zhaoyuan', 'CN', 'HL'),
(18717, 45, 755, 'Zhaozhou', 'CN', 'HL'),
(18718, 45, 756, 'Anyang', 'CN', 'HA'),
(18719, 45, 756, 'Anyang Shi', 'CN', 'HA'),
(18720, 45, 756, 'Binhe', 'CN', 'HA'),
(18721, 45, 756, 'Chengguan', 'CN', 'HA'),
(18722, 45, 756, 'Chengjiao', 'CN', 'HA'),
(18723, 45, 756, 'Daokou', 'CN', 'HA'),
(18724, 45, 756, 'Dingcheng', 'CN', 'HA'),
(18725, 45, 756, 'Hancheng', 'CN', 'HA'),
(18726, 45, 756, 'Hebi', 'CN', 'HA'),
(18727, 45, 756, 'Huaidian', 'CN', 'HA'),
(18728, 45, 756, 'Huazhou', 'CN', 'HA'),
(18729, 45, 756, 'Huichang', 'CN', 'HA'),
(18730, 45, 756, 'Jianshe', 'CN', 'HA'),
(18731, 45, 756, 'Jiaozuo', 'CN', 'HA'),
(18732, 45, 756, 'Jishui', 'CN', 'HA'),
(18733, 45, 756, 'Jiyuan', 'CN', 'HA'),
(18734, 45, 756, 'Kaifeng', 'CN', 'HA'),
(18735, 45, 756, 'Kaiyuan', 'CN', 'HA'),
(18736, 45, 756, 'Lingbao Chengguanzhen', 'CN', 'HA'),
(18737, 45, 756, 'Luohe', 'CN', 'HA'),
(18738, 45, 756, 'Luohe Shi', 'CN', 'HA'),
(18739, 45, 756, 'Luoyang', 'CN', 'HA'),
(18740, 45, 756, 'Minggang', 'CN', 'HA'),
(18741, 45, 756, 'Nanyang', 'CN', 'HA'),
(18742, 45, 756, 'Pingdingshan', 'CN', 'HA'),
(18743, 45, 756, 'Puyang Chengguanzhen', 'CN', 'HA'),
(18744, 45, 756, 'Puyang Shi', 'CN', 'HA'),
(18745, 45, 756, 'Qingping', 'CN', 'HA'),
(18746, 45, 756, 'Runing', 'CN', 'HA'),
(18747, 45, 756, 'Ruzhou', 'CN', 'HA'),
(18748, 45, 756, 'Shangqiu', 'CN', 'HA'),
(18749, 45, 756, 'Songyang', 'CN', 'HA'),
(18750, 45, 756, 'Suohe', 'CN', 'HA'),
(18751, 45, 756, 'Tanbei', 'CN', 'HA'),
(18752, 45, 756, 'Wacheng', 'CN', 'HA'),
(18753, 45, 756, 'Xiangcheng Chengguanzhen', 'CN', 'HA'),
(18754, 45, 756, 'Xincheng', 'CN', 'HA'),
(18755, 45, 756, 'Xinhualu', 'CN', 'HA'),
(18756, 45, 756, 'Xinxiang', 'CN', 'HA'),
(18757, 45, 756, 'Xinxiang Shi', 'CN', 'HA'),
(18758, 45, 756, 'Xinyang', 'CN', 'HA'),
(18759, 45, 756, 'Xixiang', 'CN', 'HA'),
(18760, 45, 756, 'Xuchang', 'CN', 'HA'),
(18761, 45, 756, 'Xuchang Shi', 'CN', 'HA'),
(18762, 45, 756, 'Yakou', 'CN', 'HA'),
(18763, 45, 756, 'Yanshi Chengguanzhen', 'CN', 'HA'),
(18764, 45, 756, 'Yigou', 'CN', 'HA'),
(18765, 45, 756, 'Yima', 'CN', 'HA'),
(18766, 45, 756, 'Yingchuan', 'CN', 'HA'),
(18767, 45, 756, 'Yunyang', 'CN', 'HA'),
(18768, 45, 756, 'Zhengzhou', 'CN', 'HA'),
(18769, 45, 756, 'Zhoukou', 'CN', 'HA'),
(18770, 45, 756, 'Zhumadian', 'CN', 'HA'),
(18771, 45, 756, 'Zhumadian Shi', 'CN', 'HA'),
(18772, 45, 756, 'Zijinglu', 'CN', 'HA'),
(18773, 45, 758, 'Anlu', 'CN', 'HB'),
(18774, 45, 758, 'Buhe', 'CN', 'HB'),
(18775, 45, 758, 'Caidian', 'CN', 'HB'),
(18776, 45, 758, 'Caohe', 'CN', 'HB'),
(18777, 45, 758, 'Chengzhong', 'CN', 'HB'),
(18778, 45, 758, 'Danjiangkou', 'CN', 'HB'),
(18779, 45, 758, 'Daye', 'CN', 'HB'),
(18780, 45, 758, 'Duobao', 'CN', 'HB'),
(18781, 45, 758, 'Enshi', 'CN', 'HB'),
(18782, 45, 758, 'Enshi Tujiazu Miaozu Zizhizhou', 'CN', 'HB'),
(18783, 45, 758, 'Ezhou', 'CN', 'HB'),
(18784, 45, 758, 'Ezhou Shi', 'CN', 'HB'),
(18785, 45, 758, 'Fengkou', 'CN', 'HB'),
(18786, 45, 758, 'Guangshui', 'CN', 'HB'),
(18787, 45, 758, 'Gucheng Chengguanzhen', 'CN', 'HB'),
(18788, 45, 758, 'Hanchuan', 'CN', 'HB'),
(18789, 45, 758, 'Huanggang', 'CN', 'HB'),
(18790, 45, 758, 'Huangmei', 'CN', 'HB'),
(18791, 45, 758, 'Huangpi', 'CN', 'HB'),
(18792, 45, 758, 'Huangshi', 'CN', 'HB'),
(18793, 45, 758, 'Huangzhou', 'CN', 'HB'),
(18794, 45, 758, 'Jingling', 'CN', 'HB'),
(18795, 45, 758, 'Jingmen', 'CN', 'HB'),
(18796, 45, 758, 'Jingmen Shi', 'CN', 'HB'),
(18797, 45, 758, 'Jingzhou', 'CN', 'HB'),
(18798, 45, 758, 'Laohekou', 'CN', 'HB'),
(18799, 45, 758, 'Lichuan', 'CN', 'HB'),
(18800, 45, 758, 'Macheng', 'CN', 'HB'),
(18801, 45, 758, 'Nanzhang Chengguanzhen', 'CN', 'HB'),
(18802, 45, 758, 'Puqi', 'CN', 'HB'),
(18803, 45, 758, 'Qianjiang', 'CN', 'HB'),
(18804, 45, 758, 'Qingquan', 'CN', 'HB'),
(18805, 45, 758, 'Shashi', 'CN', 'HB'),
(18806, 45, 758, 'Shennongjia', 'CN', 'HB'),
(18807, 45, 758, 'Shiyan', 'CN', 'HB'),
(18808, 45, 758, 'Suizhou', 'CN', 'HB'),
(18809, 45, 758, 'Wuhan', 'CN', 'HB'),
(18810, 45, 758, 'Wuxue', 'CN', 'HB'),
(18811, 45, 758, 'Xiangyang', 'CN', 'HB'),
(18812, 45, 758, 'Xianning', 'CN', 'HB'),
(18813, 45, 758, 'Xianning Prefecture', 'CN', 'HB'),
(18814, 45, 758, 'Xiantao', 'CN', 'HB'),
(18815, 45, 758, 'Xiaogan', 'CN', 'HB'),
(18816, 45, 758, 'Xihe', 'CN', 'HB'),
(18817, 45, 758, 'Xindi', 'CN', 'HB'),
(18818, 45, 758, 'Xinshi', 'CN', 'HB'),
(18819, 45, 758, 'Xinzhou', 'CN', 'HB'),
(18820, 45, 758, 'Xiulin', 'CN', 'HB'),
(18821, 45, 758, 'Yichang', 'CN', 'HB'),
(18822, 45, 758, 'Yicheng', 'CN', 'HB'),
(18823, 45, 758, 'Yunmeng Chengguanzhen', 'CN', 'HB'),
(18824, 45, 758, 'Zaoyang', 'CN', 'HB'),
(18825, 45, 758, 'Zhicheng', 'CN', 'HB'),
(18826, 45, 758, 'Zhijiang', 'CN', 'HB'),
(18827, 45, 758, 'Zhongxiang', 'CN', 'HB'),
(18828, 45, 759, 'Anjiang', 'CN', 'HN'),
(18829, 45, 759, 'Anping', 'CN', 'HN'),
(18830, 45, 759, 'Anxiang', 'CN', 'HN'),
(18831, 45, 759, 'Baisha', 'CN', 'HN'),
(18832, 45, 759, 'Biyong', 'CN', 'HN'),
(18833, 45, 759, 'Bojia', 'CN', 'HN'),
(18834, 45, 759, 'Boyang', 'CN', 'HN'),
(18835, 45, 759, 'Bozhou', 'CN', 'HN'),
(18836, 45, 759, 'Changde', 'CN', 'HN'),
(18837, 45, 759, 'Changsha', 'CN', 'HN'),
(18838, 45, 759, 'Changsha Shi', 'CN', 'HN'),
(18839, 45, 759, 'Chatian', 'CN', 'HN'),
(18840, 45, 759, 'Chenzhou', 'CN', 'HN'),
(18841, 45, 759, 'Dabaozi', 'CN', 'HN'),
(18842, 45, 759, 'Dehang', 'CN', 'HN'),
(18843, 45, 759, 'Dengjiapu', 'CN', 'HN'),
(18844, 45, 759, 'Dengyuantai', 'CN', 'HN'),
(18845, 45, 759, 'Dongshan Dongzuxiang', 'CN', 'HN'),
(18846, 45, 759, 'Fenghuang', 'CN', 'HN'),
(18847, 45, 759, 'Gangdong', 'CN', 'HN'),
(18848, 45, 759, 'Gaoqiao', 'CN', 'HN'),
(18849, 45, 759, 'Gaoyi', 'CN', 'HN'),
(18850, 45, 759, 'Guankou', 'CN', 'HN'),
(18851, 45, 759, 'Hengbanqiao', 'CN', 'HN'),
(18852, 45, 759, 'Hengyang', 'CN', 'HN'),
(18853, 45, 759, 'Hexiangqiao', 'CN', 'HN'),
(18854, 45, 759, 'Hongjiang', 'CN', 'HN'),
(18855, 45, 759, 'Hongqiao', 'CN', 'HN'),
(18856, 45, 759, 'Huaihua', 'CN', 'HN'),
(18857, 45, 759, 'Huangjinjing', 'CN', 'HN'),
(18858, 45, 759, 'Huanglong', 'CN', 'HN'),
(18859, 45, 759, 'Huangmaoyuan', 'CN', 'HN'),
(18860, 45, 759, 'Huangqiao', 'CN', 'HN'),
(18861, 45, 759, 'Huangtukuang', 'CN', 'HN'),
(18862, 45, 759, 'Huangxikou', 'CN', 'HN'),
(18863, 45, 759, 'Huaqiao', 'CN', 'HN'),
(18864, 45, 759, 'Huayuan', 'CN', 'HN'),
(18865, 45, 759, 'Huomachong', 'CN', 'HN'),
(18866, 45, 759, 'Jiangfang', 'CN', 'HN'),
(18867, 45, 759, 'Jiangkouxu', 'CN', 'HN'),
(18868, 45, 759, 'Jiangshi', 'CN', 'HN'),
(18869, 45, 759, 'Jinhe', 'CN', 'HN'),
(18870, 45, 759, 'Jinshi', 'CN', 'HN'),
(18871, 45, 759, 'Jinshiqiao', 'CN', 'HN'),
(18872, 45, 759, 'Lanli', 'CN', 'HN'),
(18873, 45, 759, 'Leiyang', 'CN', 'HN'),
(18874, 45, 759, 'Lengshuijiang', 'CN', 'HN'),
(18875, 45, 759, 'Lengshuitan', 'CN', 'HN'),
(18876, 45, 759, 'Liangyaping', 'CN', 'HN'),
(18877, 45, 759, 'Lianyuan', 'CN', 'HN'),
(18878, 45, 759, 'Linkou', 'CN', 'HN'),
(18879, 45, 759, 'Liuduzhai', 'CN', 'HN'),
(18880, 45, 759, 'Lixiqiao', 'CN', 'HN'),
(18881, 45, 759, 'Longtan', 'CN', 'HN'),
(18882, 45, 759, 'Longtou’an', 'CN', 'HN'),
(18883, 45, 759, 'Loudi', 'CN', 'HN'),
(18884, 45, 759, 'Luojiu', 'CN', 'HN'),
(18885, 45, 759, 'Luyang', 'CN', 'HN'),
(18886, 45, 759, 'Ma’an', 'CN', 'HN'),
(18887, 45, 759, 'Malin', 'CN', 'HN'),
(18888, 45, 759, 'Maoping', 'CN', 'HN'),
(18889, 45, 759, 'Nanmuping', 'CN', 'HN'),
(18890, 45, 759, 'Nanzhou', 'CN', 'HN'),
(18891, 45, 759, 'Prefecture of Chenzhou', 'CN', 'HN'),
(18892, 45, 759, 'Pukou', 'CN', 'HN'),
(18893, 45, 759, 'Puzi', 'CN', 'HN'),
(18894, 45, 759, 'Qiancheng', 'CN', 'HN'),
(18895, 45, 759, 'Qianzhou', 'CN', 'HN'),
(18896, 45, 759, 'Qiaojiang', 'CN', 'HN'),
(18897, 45, 759, 'Qingjiangqiao', 'CN', 'HN'),
(18898, 45, 759, 'Qingxi', 'CN', 'HN'),
(18899, 45, 759, 'Qionghu', 'CN', 'HN'),
(18900, 45, 759, 'Ruoshui', 'CN', 'HN'),
(18901, 45, 759, 'Shangmei', 'CN', 'HN'),
(18902, 45, 759, 'Shanmen', 'CN', 'HN'),
(18903, 45, 759, 'Shijiang', 'CN', 'HN'),
(18904, 45, 759, 'Shuangjiang', 'CN', 'HN'),
(18905, 45, 759, 'Shuangxi', 'CN', 'HN'),
(18906, 45, 759, 'Shuiche', 'CN', 'HN'),
(18907, 45, 759, 'Shuidatian', 'CN', 'HN'),
(18908, 45, 759, 'Simenqian', 'CN', 'HN'),
(18909, 45, 759, 'Tangjiafang', 'CN', 'HN'),
(18910, 45, 759, 'Tanwan', 'CN', 'HN'),
(18911, 45, 759, 'Tongwan', 'CN', 'HN'),
(18912, 45, 759, 'Tuokou', 'CN', 'HN'),
(18913, 45, 759, 'Wantouqiao', 'CN', 'HN'),
(18914, 45, 759, 'Wenxing', 'CN', 'HN'),
(18915, 45, 759, 'Wulingyuan', 'CN', 'HN'),
(18916, 45, 759, 'Wuxi', 'CN', 'HN'),
(18917, 45, 759, 'Wuyang', 'CN', 'HN'),
(18918, 45, 759, 'Xiangtan', 'CN', 'HN'),
(18919, 45, 759, 'Xiangxi Tujiazu Miaozu Zizhizhou', 'CN', 'HN'),
(18920, 45, 759, 'Xiangxiang', 'CN', 'HN'),
(18921, 45, 759, 'Xianrenwan', 'CN', 'HN'),
(18922, 45, 759, 'Xianxi', 'CN', 'HN'),
(18923, 45, 759, 'Xiaohenglong', 'CN', 'HN'),
(18924, 45, 759, 'Xiaolongmen', 'CN', 'HN'),
(18925, 45, 759, 'Xiaoshajiang', 'CN', 'HN'),
(18926, 45, 759, 'Xishan', 'CN', 'HN'),
(18927, 45, 759, 'Xixi', 'CN', 'HN'),
(18928, 45, 759, 'Xiyan', 'CN', 'HN'),
(18929, 45, 759, 'Yanmen', 'CN', 'HN'),
(18930, 45, 759, 'Yaoshi', 'CN', 'HN'),
(18931, 45, 759, 'Yatunpu', 'CN', 'HN'),
(18932, 45, 759, 'Yiyang', 'CN', 'HN'),
(18933, 45, 759, 'Yongfeng', 'CN', 'HN'),
(18934, 45, 759, 'Yongzhou', 'CN', 'HN'),
(18935, 45, 759, 'Yueyang', 'CN', 'HN'),
(18936, 45, 759, 'Yueyang Shi', 'CN', 'HN'),
(18937, 45, 759, 'Yutan', 'CN', 'HN'),
(18938, 45, 759, 'Zhaishi Miaozu Dongzuxiang', 'CN', 'HN'),
(18939, 45, 759, 'Zhangjiajie', 'CN', 'HN'),
(18940, 45, 759, 'Zhongfang', 'CN', 'HN'),
(18941, 45, 759, 'Zhongzhai', 'CN', 'HN'),
(18942, 45, 759, 'Zhushi', 'CN', 'HN'),
(18943, 45, 759, 'Zhuzhou', 'CN', 'HN'),
(18944, 45, 759, 'Zhuzhou Shi', 'CN', 'HN'),
(18945, 45, 759, 'Zhuzhoujiang Miaozuxiang', 'CN', 'HN'),
(18946, 45, 760, 'Baotou', 'CN', 'NM'),
(18947, 45, 760, 'Bayan Nur', 'CN', 'NM'),
(18948, 45, 760, 'Bayannur Shi', 'CN', 'NM'),
(18949, 45, 760, 'Beichengqu', 'CN', 'NM'),
(18950, 45, 760, 'Chifeng', 'CN', 'NM'),
(18951, 45, 760, 'Dongsheng', 'CN', 'NM'),
(18952, 45, 760, 'E’erguna', 'CN', 'NM'),
(18953, 45, 760, 'Erenhot', 'CN', 'NM'),
(18954, 45, 760, 'Genhe', 'CN', 'NM'),
(18955, 45, 760, 'Hailar', 'CN', 'NM'),
(18956, 45, 760, 'Hohhot', 'CN', 'NM'),
(18957, 45, 760, 'Hulunbuir Region', 'CN', 'NM'),
(18958, 45, 760, 'Jalai Nur', 'CN', 'NM'),
(18959, 45, 760, 'Jiagedaqi', 'CN', 'NM'),
(18960, 45, 760, 'Jining', 'CN', 'NM'),
(18961, 45, 760, 'Manzhouli', 'CN', 'NM'),
(18962, 45, 760, 'Mositai', 'CN', 'NM'),
(18963, 45, 760, 'Mujiayingzi', 'CN', 'NM'),
(18964, 45, 760, 'Ordos', 'CN', 'NM'),
(18965, 45, 760, 'Ordos Shi', 'CN', 'NM'),
(18966, 45, 760, 'Oroqen Zizhiqi', 'CN', 'NM'),
(18967, 45, 760, 'Pingzhuang', 'CN', 'NM'),
(18968, 45, 760, 'Salaqi', 'CN', 'NM'),
(18969, 45, 760, 'Shiguai', 'CN', 'NM'),
(18970, 45, 760, 'Tongliao', 'CN', 'NM'),
(18971, 45, 760, 'Ulanhot', 'CN', 'NM'),
(18972, 45, 760, 'Wenquan', 'CN', 'NM'),
(18973, 45, 760, 'Wuda', 'CN', 'NM'),
(18974, 45, 760, 'Wuhai', 'CN', 'NM'),
(18975, 45, 760, 'Xilin Gol Meng', 'CN', 'NM'),
(18976, 45, 760, 'Xilin Hot', 'CN', 'NM'),
(18977, 45, 760, 'Yakeshi', 'CN', 'NM'),
(18978, 45, 760, 'Zhalantun', 'CN', 'NM'),
(18979, 45, 761, 'ChangZhou', 'CN', 'JS'),
(18980, 45, 761, 'HuaiAn', 'CN', 'JS'),
(18981, 45, 761, 'LianYunGang', 'CN', 'JS'),
(18982, 45, 761, 'NanJing', 'CN', 'JS'),
(18983, 45, 761, 'NanTong', 'CN', 'JS'),
(18984, 45, 761, 'SuQian', 'CN', 'JS'),
(18985, 45, 761, 'SuZhou', 'CN', 'JS'),
(18986, 45, 761, 'TaiZhou', 'CN', 'JS'),
(18987, 45, 761, 'WuXi', 'CN', 'JS'),
(18988, 45, 761, 'XuZhou', 'CN', 'JS'),
(18989, 45, 761, 'YanCheng', 'CN', 'JS'),
(18990, 45, 761, 'YangZhou', 'CN', 'JS'),
(18991, 45, 761, 'ZhenJiang', 'CN', 'JS'),
(18992, 45, 762, 'Changleng', 'CN', 'JX'),
(18993, 45, 762, 'Fenyi', 'CN', 'JX'),
(18994, 45, 762, 'Ganzhou', 'CN', 'JX'),
(18995, 45, 762, 'Ganzhou Shi', 'CN', 'JX'),
(18996, 45, 762, 'Guixi', 'CN', 'JX'),
(18997, 45, 762, 'Ji’an', 'CN', 'JX'),
(18998, 45, 762, 'Jianguang', 'CN', 'JX'),
(18999, 45, 762, 'Jingdezhen', 'CN', 'JX'),
(19000, 45, 762, 'Jingdezhen Shi', 'CN', 'JX');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(19001, 45, 762, 'Jiujiang', 'CN', 'JX'),
(19002, 45, 762, 'Nanchang', 'CN', 'JX'),
(19003, 45, 762, 'Pingxiang', 'CN', 'JX'),
(19004, 45, 762, 'Poyang', 'CN', 'JX'),
(19005, 45, 762, 'Shangrao', 'CN', 'JX'),
(19006, 45, 762, 'Xinyu', 'CN', 'JX'),
(19007, 45, 762, 'Yichun', 'CN', 'JX'),
(19008, 45, 763, 'Baicheng', 'CN', 'JL'),
(19009, 45, 763, 'Baishan', 'CN', 'JL'),
(19010, 45, 763, 'Baishishan', 'CN', 'JL'),
(19011, 45, 763, 'Changchun', 'CN', 'JL'),
(19012, 45, 763, 'Changling', 'CN', 'JL'),
(19013, 45, 763, 'Chaoyang', 'CN', 'JL'),
(19014, 45, 763, 'Dalai', 'CN', 'JL'),
(19015, 45, 763, 'Dashitou', 'CN', 'JL'),
(19016, 45, 763, 'Dehui', 'CN', 'JL'),
(19017, 45, 763, 'Dongfeng', 'CN', 'JL'),
(19018, 45, 763, 'Dunhua', 'CN', 'JL'),
(19019, 45, 763, 'Erdaojiang', 'CN', 'JL'),
(19020, 45, 763, 'Fuyu', 'CN', 'JL'),
(19021, 45, 763, 'Gongzhuling', 'CN', 'JL'),
(19022, 45, 763, 'Guangming', 'CN', 'JL'),
(19023, 45, 763, 'Helong', 'CN', 'JL'),
(19024, 45, 763, 'Hepingjie', 'CN', 'JL'),
(19025, 45, 763, 'Huadian', 'CN', 'JL'),
(19026, 45, 763, 'Huangnihe', 'CN', 'JL'),
(19027, 45, 763, 'Huinan', 'CN', 'JL'),
(19028, 45, 763, 'Hunchun', 'CN', 'JL'),
(19029, 45, 763, 'Ji’an', 'CN', 'JL'),
(19030, 45, 763, 'Jilin', 'CN', 'JL'),
(19031, 45, 763, 'Jishu', 'CN', 'JL'),
(19032, 45, 763, 'Jiutai', 'CN', 'JL'),
(19033, 45, 763, 'Kaitong', 'CN', 'JL'),
(19034, 45, 763, 'Liaoyuan', 'CN', 'JL'),
(19035, 45, 763, 'Linjiang', 'CN', 'JL'),
(19036, 45, 763, 'Lishu', 'CN', 'JL'),
(19037, 45, 763, 'Liuhe', 'CN', 'JL'),
(19038, 45, 763, 'Longjing', 'CN', 'JL'),
(19039, 45, 763, 'Meihekou', 'CN', 'JL'),
(19040, 45, 763, 'Mingyue', 'CN', 'JL'),
(19041, 45, 763, 'Minzhu', 'CN', 'JL'),
(19042, 45, 763, 'Panshi', 'CN', 'JL'),
(19043, 45, 763, 'Sanchazi', 'CN', 'JL'),
(19044, 45, 763, 'Shuangyang', 'CN', 'JL'),
(19045, 45, 763, 'Shulan', 'CN', 'JL'),
(19046, 45, 763, 'Siping', 'CN', 'JL'),
(19047, 45, 763, 'Songjianghe', 'CN', 'JL'),
(19048, 45, 763, 'Songyuan', 'CN', 'JL'),
(19049, 45, 763, 'Tonghua', 'CN', 'JL'),
(19050, 45, 763, 'Tonghua Shi', 'CN', 'JL'),
(19051, 45, 763, 'Tumen', 'CN', 'JL'),
(19052, 45, 763, 'Wangqing', 'CN', 'JL'),
(19053, 45, 763, 'Xinglongshan', 'CN', 'JL'),
(19054, 45, 763, 'Yanbian Chaoxianzu Zizhizhou', 'CN', 'JL'),
(19055, 45, 763, 'Yanji', 'CN', 'JL'),
(19056, 45, 763, 'Yantongshan', 'CN', 'JL'),
(19057, 45, 763, 'Yushu', 'CN', 'JL'),
(19058, 45, 763, 'Zhengjiatun', 'CN', 'JL'),
(19059, 45, 763, 'Zhenlai', 'CN', 'JL'),
(19060, 45, 764, 'Anshan', 'CN', 'LN'),
(19061, 45, 764, 'Beipiao', 'CN', 'LN'),
(19062, 45, 764, 'Benxi', 'CN', 'LN'),
(19063, 45, 764, 'Changtu', 'CN', 'LN'),
(19064, 45, 764, 'Chaoyang', 'CN', 'LN'),
(19065, 45, 764, 'Dalian', 'CN', 'LN'),
(19066, 45, 764, 'Dalianwan', 'CN', 'LN'),
(19067, 45, 764, 'Dandong', 'CN', 'LN'),
(19068, 45, 764, 'Dashiqiao', 'CN', 'LN'),
(19069, 45, 764, 'Dongling', 'CN', 'LN'),
(19070, 45, 764, 'Fengcheng', 'CN', 'LN'),
(19071, 45, 764, 'Fushun', 'CN', 'LN'),
(19072, 45, 764, 'Fuxin', 'CN', 'LN'),
(19073, 45, 764, 'Gaizhou', 'CN', 'LN'),
(19074, 45, 764, 'Gongchangling', 'CN', 'LN'),
(19075, 45, 764, 'Haicheng', 'CN', 'LN'),
(19076, 45, 764, 'Heishan', 'CN', 'LN'),
(19077, 45, 764, 'Huanren', 'CN', 'LN'),
(19078, 45, 764, 'Huludao', 'CN', 'LN'),
(19079, 45, 764, 'Huludao Shi', 'CN', 'LN'),
(19080, 45, 764, 'Hushitai', 'CN', 'LN'),
(19081, 45, 764, 'Jinzhou', 'CN', 'LN'),
(19082, 45, 764, 'Jiupu', 'CN', 'LN'),
(19083, 45, 764, 'Kaiyuan', 'CN', 'LN'),
(19084, 45, 764, 'Kuandian', 'CN', 'LN'),
(19085, 45, 764, 'Langtoucun', 'CN', 'LN'),
(19086, 45, 764, 'Lianshan', 'CN', 'LN'),
(19087, 45, 764, 'Liaoyang', 'CN', 'LN'),
(19088, 45, 764, 'Liaozhong', 'CN', 'LN'),
(19089, 45, 764, 'Linghai', 'CN', 'LN'),
(19090, 45, 764, 'Lingyuan', 'CN', 'LN'),
(19091, 45, 764, 'Lüshun', 'CN', 'LN'),
(19092, 45, 764, 'Nanpiao', 'CN', 'LN'),
(19093, 45, 764, 'Nantai', 'CN', 'LN'),
(19094, 45, 764, 'Panjin Shi', 'CN', 'LN'),
(19095, 45, 764, 'Panshan', 'CN', 'LN'),
(19096, 45, 764, 'Pulandian', 'CN', 'LN'),
(19097, 45, 764, 'Shenyang', 'CN', 'LN'),
(19098, 45, 764, 'Sujiatun', 'CN', 'LN'),
(19099, 45, 764, 'Tieling', 'CN', 'LN'),
(19100, 45, 764, 'Tieling Shi', 'CN', 'LN'),
(19101, 45, 764, 'Wafangdian', 'CN', 'LN'),
(19102, 45, 764, 'Xiaoshi', 'CN', 'LN'),
(19103, 45, 764, 'Xifeng', 'CN', 'LN'),
(19104, 45, 764, 'Xingcheng', 'CN', 'LN'),
(19105, 45, 764, 'Xinmin', 'CN', 'LN'),
(19106, 45, 764, 'Xinxing', 'CN', 'LN'),
(19107, 45, 764, 'Xiuyan', 'CN', 'LN'),
(19108, 45, 764, 'Yebaishou', 'CN', 'LN'),
(19109, 45, 764, 'Yingkou', 'CN', 'LN'),
(19110, 45, 764, 'Zhuanghe', 'CN', 'LN'),
(19111, 45, 766, 'Dawukou', 'CN', 'NX'),
(19112, 45, 766, 'Dongta', 'CN', 'NX'),
(19113, 45, 766, 'Shitanjing', 'CN', 'NX'),
(19114, 45, 766, 'Shizuishan', 'CN', 'NX'),
(19115, 45, 766, 'Wuzhong', 'CN', 'NX'),
(19116, 45, 766, 'Yinchuan', 'CN', 'NX'),
(19117, 45, 766, 'Zhongwei', 'CN', 'NX'),
(19118, 45, 767, 'Delingha', 'CN', 'QH'),
(19119, 45, 767, 'Golmud', 'CN', 'QH'),
(19120, 45, 767, 'Golog Tibetan Autonomous Prefecture', 'CN', 'QH'),
(19121, 45, 767, 'Haibei Tibetan Autonomous Prefecture', 'CN', 'QH'),
(19122, 45, 767, 'Huangnan Zangzu Zizhizhou', 'CN', 'QH'),
(19123, 45, 767, 'Xining', 'CN', 'QH'),
(19124, 45, 767, 'Xireg', 'CN', 'QH'),
(19125, 45, 767, 'Yushu Zangzu Zizhizhou', 'CN', 'QH'),
(19126, 45, 768, 'Ankang', 'CN', 'SN'),
(19127, 45, 768, 'Baoji Shi', 'CN', 'SN'),
(19128, 45, 768, 'Guozhen', 'CN', 'SN'),
(19129, 45, 768, 'Hancheng', 'CN', 'SN'),
(19130, 45, 768, 'Hanzhong', 'CN', 'SN'),
(19131, 45, 768, 'Huayin', 'CN', 'SN'),
(19132, 45, 768, 'Lintong', 'CN', 'SN'),
(19133, 45, 768, 'Tongchuanshi', 'CN', 'SN'),
(19134, 45, 768, 'Weinan', 'CN', 'SN'),
(19135, 45, 768, 'Xi’an', 'CN', 'SN'),
(19136, 45, 768, 'Xianyang', 'CN', 'SN'),
(19137, 45, 768, 'Yanliang', 'CN', 'SN'),
(19138, 45, 768, 'Yulinshi', 'CN', 'SN'),
(19139, 45, 768, 'Yuxia', 'CN', 'SN'),
(19140, 45, 769, 'Anqiu', 'CN', 'SD'),
(19141, 45, 769, 'Beizhai', 'CN', 'SD'),
(19142, 45, 769, 'Bianzhuang', 'CN', 'SD'),
(19143, 45, 769, 'Binzhou', 'CN', 'SD'),
(19144, 45, 769, 'Boshan', 'CN', 'SD'),
(19145, 45, 769, 'Changqing', 'CN', 'SD'),
(19146, 45, 769, 'Chengqu', 'CN', 'SD'),
(19147, 45, 769, 'Chengtangcun', 'CN', 'SD'),
(19148, 45, 769, 'Chengyang', 'CN', 'SD'),
(19149, 45, 769, 'Dengying', 'CN', 'SD'),
(19150, 45, 769, 'Dengzhou', 'CN', 'SD'),
(19151, 45, 769, 'Dezhou', 'CN', 'SD'),
(19152, 45, 769, 'Dingtao', 'CN', 'SD'),
(19153, 45, 769, 'Dongcun', 'CN', 'SD'),
(19154, 45, 769, 'Dongdu', 'CN', 'SD'),
(19155, 45, 769, 'Feicheng', 'CN', 'SD'),
(19156, 45, 769, 'Gaomi', 'CN', 'SD'),
(19157, 45, 769, 'Hanting', 'CN', 'SD'),
(19158, 45, 769, 'Heze', 'CN', 'SD'),
(19159, 45, 769, 'Jiamaying', 'CN', 'SD'),
(19160, 45, 769, 'Jiaozhou', 'CN', 'SD'),
(19161, 45, 769, 'Jiehu', 'CN', 'SD'),
(19162, 45, 769, 'Jimo', 'CN', 'SD'),
(19163, 45, 769, 'Jinan', 'CN', 'SD'),
(19164, 45, 769, 'Jining', 'CN', 'SD'),
(19165, 45, 769, 'Juye', 'CN', 'SD'),
(19166, 45, 769, 'Kuiju', 'CN', 'SD'),
(19167, 45, 769, 'Kutao', 'CN', 'SD'),
(19168, 45, 769, 'Laiwu', 'CN', 'SD'),
(19169, 45, 769, 'Laixi', 'CN', 'SD'),
(19170, 45, 769, 'Laiyang', 'CN', 'SD'),
(19171, 45, 769, 'Laizhou', 'CN', 'SD'),
(19172, 45, 769, 'Laocheng', 'CN', 'SD'),
(19173, 45, 769, 'Liaocheng', 'CN', 'SD'),
(19174, 45, 769, 'Linqu', 'CN', 'SD'),
(19175, 45, 769, 'Linyi', 'CN', 'SD'),
(19176, 45, 769, 'Longgang', 'CN', 'SD'),
(19177, 45, 769, 'Mengyin', 'CN', 'SD'),
(19178, 45, 769, 'Mingshui', 'CN', 'SD'),
(19179, 45, 769, 'Mizhou', 'CN', 'SD'),
(19180, 45, 769, 'Nanding', 'CN', 'SD'),
(19181, 45, 769, 'Nanma', 'CN', 'SD'),
(19182, 45, 769, 'Ninghai', 'CN', 'SD'),
(19183, 45, 769, 'Ningyang', 'CN', 'SD'),
(19184, 45, 769, 'Pingdu', 'CN', 'SD'),
(19185, 45, 769, 'Pingyi', 'CN', 'SD'),
(19186, 45, 769, 'Pingyin', 'CN', 'SD'),
(19187, 45, 769, 'Qingdao', 'CN', 'SD'),
(19188, 45, 769, 'Qingnian', 'CN', 'SD'),
(19189, 45, 769, 'Qingshancun', 'CN', 'SD'),
(19190, 45, 769, 'Qingyang', 'CN', 'SD'),
(19191, 45, 769, 'Qingzhou', 'CN', 'SD'),
(19192, 45, 769, 'Qufu', 'CN', 'SD'),
(19193, 45, 769, 'Rizhao', 'CN', 'SD'),
(19194, 45, 769, 'Shancheng', 'CN', 'SD'),
(19195, 45, 769, 'Shanting', 'CN', 'SD'),
(19196, 45, 769, 'Shazikou', 'CN', 'SD'),
(19197, 45, 769, 'Shengli', 'CN', 'SD'),
(19198, 45, 769, 'Shilaorencun', 'CN', 'SD'),
(19199, 45, 769, 'Shizilu', 'CN', 'SD'),
(19200, 45, 769, 'Shouguang', 'CN', 'SD'),
(19201, 45, 769, 'Sishui', 'CN', 'SD'),
(19202, 45, 769, 'Suozhen', 'CN', 'SD'),
(19203, 45, 769, 'Tai’an', 'CN', 'SD'),
(19204, 45, 769, 'Taozhuang', 'CN', 'SD'),
(19205, 45, 769, 'Tianfu', 'CN', 'SD'),
(19206, 45, 769, 'Weifang', 'CN', 'SD'),
(19207, 45, 769, 'Weihai', 'CN', 'SD'),
(19208, 45, 769, 'Wenshang', 'CN', 'SD'),
(19209, 45, 769, 'Xiazhen', 'CN', 'SD'),
(19210, 45, 769, 'Xiazhuang', 'CN', 'SD'),
(19211, 45, 769, 'Xiliguantun', 'CN', 'SD'),
(19212, 45, 769, 'Xindian', 'CN', 'SD'),
(19213, 45, 769, 'Xintai', 'CN', 'SD'),
(19214, 45, 769, 'Yanggu', 'CN', 'SD'),
(19215, 45, 769, 'Yanta', 'CN', 'SD'),
(19216, 45, 769, 'Yantai', 'CN', 'SD'),
(19217, 45, 769, 'Yanzhou', 'CN', 'SD'),
(19218, 45, 769, 'Yatou', 'CN', 'SD'),
(19219, 45, 769, 'Yinzhu', 'CN', 'SD'),
(19220, 45, 769, 'Yishui', 'CN', 'SD'),
(19221, 45, 769, 'Yucheng', 'CN', 'SD'),
(19222, 45, 769, 'Zaozhuang', 'CN', 'SD'),
(19223, 45, 769, 'Zhaoyuan', 'CN', 'SD'),
(19224, 45, 769, 'Zhoucheng', 'CN', 'SD'),
(19225, 45, 769, 'Zhoucun', 'CN', 'SD'),
(19226, 45, 769, 'Zhu Cheng City', 'CN', 'SD'),
(19227, 45, 769, 'Zhuangyuan', 'CN', 'SD'),
(19228, 45, 769, 'Zibo', 'CN', 'SD'),
(19229, 45, 769, 'Zoucheng', 'CN', 'SD'),
(19230, 45, 770, 'Shanghai', 'CN', 'SH'),
(19231, 45, 770, 'Songjiang', 'CN', 'SH'),
(19232, 45, 770, 'Zhabei', 'CN', 'SH'),
(19233, 45, 770, 'Zhujiajiao', 'CN', 'SH'),
(19234, 45, 771, 'Changzhi', 'CN', 'SX'),
(19235, 45, 771, 'Datong', 'CN', 'SX'),
(19236, 45, 771, 'Datong Shi', 'CN', 'SX'),
(19237, 45, 771, 'Gutao', 'CN', 'SX'),
(19238, 45, 771, 'Jiexiu', 'CN', 'SX'),
(19239, 45, 771, 'Jincheng', 'CN', 'SX'),
(19240, 45, 771, 'Jinzhong Shi', 'CN', 'SX'),
(19241, 45, 771, 'Linfen', 'CN', 'SX'),
(19242, 45, 771, 'Lüliang', 'CN', 'SX'),
(19243, 45, 771, 'Shuozhou', 'CN', 'SX'),
(19244, 45, 771, 'Taiyuan', 'CN', 'SX'),
(19245, 45, 771, 'Xintian', 'CN', 'SX'),
(19246, 45, 771, 'Xinzhi', 'CN', 'SX'),
(19247, 45, 771, 'Xinzhou', 'CN', 'SX'),
(19248, 45, 771, 'Yangquan', 'CN', 'SX'),
(19249, 45, 771, 'Yuanping', 'CN', 'SX'),
(19250, 45, 771, 'Yuci', 'CN', 'SX'),
(19251, 45, 771, 'Yuncheng', 'CN', 'SX'),
(19252, 45, 772, 'Aba Zangzu Qiangzu Zizhizhou', 'CN', 'SC'),
(19253, 45, 772, 'Barkam', 'CN', 'SC'),
(19254, 45, 772, 'Bazhong Shi', 'CN', 'SC'),
(19255, 45, 772, 'Changchi', 'CN', 'SC'),
(19256, 45, 772, 'Chengdu', 'CN', 'SC'),
(19257, 45, 772, 'Chonglong', 'CN', 'SC'),
(19258, 45, 772, 'Dadukou', 'CN', 'SC'),
(19259, 45, 772, 'Dazhou', 'CN', 'SC'),
(19260, 45, 772, 'Deyang', 'CN', 'SC'),
(19261, 45, 772, 'Dongxi', 'CN', 'SC'),
(19262, 45, 772, 'Fangting', 'CN', 'SC'),
(19263, 45, 772, 'Fubao', 'CN', 'SC'),
(19264, 45, 772, 'Gaoping', 'CN', 'SC'),
(19265, 45, 772, 'Garzê Zangzu Zizhizhou', 'CN', 'SC'),
(19266, 45, 772, 'Guang’an', 'CN', 'SC'),
(19267, 45, 772, 'Guangyuan', 'CN', 'SC'),
(19268, 45, 772, 'Jiancheng', 'CN', 'SC'),
(19269, 45, 772, 'Jiangyou', 'CN', 'SC'),
(19270, 45, 772, 'Jiannan', 'CN', 'SC'),
(19271, 45, 772, 'Kangding', 'CN', 'SC'),
(19272, 45, 772, 'Langzhong', 'CN', 'SC'),
(19273, 45, 772, 'Leshan', 'CN', 'SC'),
(19274, 45, 772, 'Liangshan Yizu Zizhizhou', 'CN', 'SC'),
(19275, 45, 772, 'Linqiong', 'CN', 'SC'),
(19276, 45, 772, 'Luocheng', 'CN', 'SC'),
(19277, 45, 772, 'Luzhou', 'CN', 'SC'),
(19278, 45, 772, 'Meishan Shi', 'CN', 'SC'),
(19279, 45, 772, 'Mianyang', 'CN', 'SC'),
(19280, 45, 772, 'Nanchong', 'CN', 'SC'),
(19281, 45, 772, 'Nanlong', 'CN', 'SC'),
(19282, 45, 772, 'Neijiang', 'CN', 'SC'),
(19283, 45, 772, 'Panzhihua', 'CN', 'SC'),
(19284, 45, 772, 'Puji', 'CN', 'SC'),
(19285, 45, 772, 'Shuanghejiedao', 'CN', 'SC'),
(19286, 45, 772, 'Suining', 'CN', 'SC'),
(19287, 45, 772, 'Taihe', 'CN', 'SC'),
(19288, 45, 772, 'Taiping', 'CN', 'SC'),
(19289, 45, 772, 'Tianpeng', 'CN', 'SC'),
(19290, 45, 772, 'Tongchuan', 'CN', 'SC'),
(19291, 45, 772, 'Xialiang', 'CN', 'SC'),
(19292, 45, 772, 'Xiantan', 'CN', 'SC'),
(19293, 45, 772, 'Xichang', 'CN', 'SC'),
(19294, 45, 772, 'Xunchang', 'CN', 'SC'),
(19295, 45, 772, 'Yanjiang', 'CN', 'SC'),
(19296, 45, 772, 'Yibin', 'CN', 'SC'),
(19297, 45, 772, 'Yucheng', 'CN', 'SC'),
(19298, 45, 772, 'Zengjia', 'CN', 'SC'),
(19299, 45, 772, 'Zhongba', 'CN', 'SC'),
(19300, 45, 772, 'Zigong', 'CN', 'SC'),
(19301, 45, 773, 'Baoying', 'CN', 'TW'),
(19302, 45, 773, 'Changshu City', 'CN', 'TW'),
(19303, 45, 773, 'Changzhou', 'CN', 'TW'),
(19304, 45, 773, 'Chengxiang', 'CN', 'TW'),
(19305, 45, 773, 'Dazhong', 'CN', 'TW'),
(19306, 45, 773, 'Dongkan', 'CN', 'TW'),
(19307, 45, 773, 'Dongtai', 'CN', 'TW'),
(19308, 45, 773, 'Fengxian', 'CN', 'TW'),
(19309, 45, 773, 'Gaogou', 'CN', 'TW'),
(19310, 45, 773, 'Gaoyou', 'CN', 'TW'),
(19311, 45, 773, 'Guiren', 'CN', 'TW'),
(19312, 45, 773, 'Haizhou', 'CN', 'TW'),
(19313, 45, 773, 'Hede', 'CN', 'TW'),
(19314, 45, 773, 'Huai\'an', 'CN', 'TW'),
(19315, 45, 773, 'Huai’an Shi', 'CN', 'TW'),
(19316, 45, 773, 'Huilong', 'CN', 'TW'),
(19317, 45, 773, 'Hutang', 'CN', 'TW'),
(19318, 45, 773, 'Jiangyan', 'CN', 'TW'),
(19319, 45, 773, 'Jiangyin', 'CN', 'TW'),
(19320, 45, 773, 'Jingjiang', 'CN', 'TW'),
(19321, 45, 773, 'Jinsha', 'CN', 'TW'),
(19322, 45, 773, 'Juegang', 'CN', 'TW'),
(19323, 45, 773, 'Kunshan', 'CN', 'TW'),
(19324, 45, 773, 'Lianyungang Shi', 'CN', 'TW'),
(19325, 45, 773, 'Licheng', 'CN', 'TW'),
(19326, 45, 773, 'Mudu', 'CN', 'TW'),
(19327, 45, 773, 'Nanjing', 'CN', 'TW'),
(19328, 45, 773, 'Nantong', 'CN', 'TW'),
(19329, 45, 773, 'Pizhou', 'CN', 'TW'),
(19330, 45, 773, 'Qinnan', 'CN', 'TW'),
(19331, 45, 773, 'Rucheng', 'CN', 'TW'),
(19332, 45, 773, 'Sanmao', 'CN', 'TW'),
(19333, 45, 773, 'Songling', 'CN', 'TW'),
(19334, 45, 773, 'Suicheng', 'CN', 'TW'),
(19335, 45, 773, 'Suzhou', 'CN', 'TW'),
(19336, 45, 773, 'Taixing', 'CN', 'TW'),
(19337, 45, 773, 'Taizhou', 'CN', 'TW'),
(19338, 45, 773, 'Tongshan', 'CN', 'TW'),
(19339, 45, 773, 'Wuxi', 'CN', 'TW'),
(19340, 45, 773, 'Xiannü', 'CN', 'TW'),
(19341, 45, 773, 'Xiaolingwei', 'CN', 'TW'),
(19342, 45, 773, 'Xinghua', 'CN', 'TW'),
(19343, 45, 773, 'Xinpu', 'CN', 'TW'),
(19344, 45, 773, 'Yancheng', 'CN', 'TW'),
(19345, 45, 773, 'Yangzhou', 'CN', 'TW'),
(19346, 45, 773, 'Yicheng', 'CN', 'TW'),
(19347, 45, 773, 'Yushan', 'CN', 'TW'),
(19348, 45, 773, 'Zhangjiagang', 'CN', 'TW'),
(19349, 45, 773, 'Zhenjiang', 'CN', 'TW'),
(19350, 45, 773, 'Zhenzhou', 'CN', 'TW'),
(19351, 45, 773, 'Zhongxing', 'CN', 'TW'),
(19352, 45, 773, 'Zhouzhuang', 'CN', 'TW'),
(19353, 45, 774, 'Badaogu', 'CN', 'TJ'),
(19354, 45, 774, 'Baijian', 'CN', 'TJ'),
(19355, 45, 774, 'Bamencheng', 'CN', 'TJ'),
(19356, 45, 774, 'Bangjun', 'CN', 'TJ'),
(19357, 45, 774, 'Beicang', 'CN', 'TJ'),
(19358, 45, 774, 'Beihuaidian', 'CN', 'TJ'),
(19359, 45, 774, 'Beilizigu', 'CN', 'TJ'),
(19360, 45, 774, 'Biaokou', 'CN', 'TJ'),
(19361, 45, 774, 'Binhai New Area', 'CN', 'TJ'),
(19362, 45, 774, 'Caijiapu', 'CN', 'TJ'),
(19363, 45, 774, 'Caodian', 'CN', 'TJ'),
(19364, 45, 774, 'Chabaihu', 'CN', 'TJ'),
(19365, 45, 774, 'Changtun', 'CN', 'TJ'),
(19366, 45, 774, 'Chengtougu', 'CN', 'TJ'),
(19367, 45, 774, 'Chitu', 'CN', 'TJ'),
(19368, 45, 774, 'Cuijiamatou', 'CN', 'TJ'),
(19369, 45, 774, 'Dadunqiu', 'CN', 'TJ'),
(19370, 45, 774, 'Dakoutun', 'CN', 'TJ'),
(19371, 45, 774, 'Dashentang', 'CN', 'TJ'),
(19372, 45, 774, 'Dawangtai', 'CN', 'TJ'),
(19373, 45, 774, 'Daxinzhuang', 'CN', 'TJ'),
(19374, 45, 774, 'Dazhongzhuang', 'CN', 'TJ'),
(19375, 45, 774, 'Dongditou', 'CN', 'TJ'),
(19376, 45, 774, 'Dongshigu', 'CN', 'TJ'),
(19377, 45, 774, 'Erwangzhuang', 'CN', 'TJ'),
(19378, 45, 774, 'Fanzhuang', 'CN', 'TJ'),
(19379, 45, 774, 'Fengtai (Ninghe)', 'CN', 'TJ'),
(19380, 45, 774, 'Fuzhuang', 'CN', 'TJ'),
(19381, 45, 774, 'Gaojingzhuang', 'CN', 'TJ'),
(19382, 45, 774, 'Hanjiashu', 'CN', 'TJ'),
(19383, 45, 774, 'Hebeitun', 'CN', 'TJ'),
(19384, 45, 774, 'Hexiwu', 'CN', 'TJ'),
(19385, 45, 774, 'Huangcaotuo', 'CN', 'TJ'),
(19386, 45, 774, 'Huantuo', 'CN', 'TJ'),
(19387, 45, 774, 'Huogezhuang', 'CN', 'TJ'),
(19388, 45, 774, 'Jiangwakou', 'CN', 'TJ'),
(19389, 45, 774, 'Lianzhuang', 'CN', 'TJ'),
(19390, 45, 774, 'Lintingkou', 'CN', 'TJ'),
(19391, 45, 774, 'Liujiading', 'CN', 'TJ'),
(19392, 45, 774, 'Liukuaizhuang', 'CN', 'TJ'),
(19393, 45, 774, 'Liuzikou', 'CN', 'TJ'),
(19394, 45, 774, 'Luotuofangzi', 'CN', 'TJ'),
(19395, 45, 774, 'Meichang', 'CN', 'TJ'),
(19396, 45, 774, 'Mengquan', 'CN', 'TJ'),
(19397, 45, 774, 'Panzhuang', 'CN', 'TJ'),
(19398, 45, 774, 'Qingguang', 'CN', 'TJ'),
(19399, 45, 774, 'Sangzi', 'CN', 'TJ'),
(19400, 45, 774, 'Shangcang', 'CN', 'TJ'),
(19401, 45, 774, 'Shimianzhuang', 'CN', 'TJ'),
(19402, 45, 774, 'Shuangjiang', 'CN', 'TJ'),
(19403, 45, 774, 'Sigaozhuang', 'CN', 'TJ'),
(19404, 45, 774, 'Tianjin', 'CN', 'TJ'),
(19405, 45, 774, 'Touying', 'CN', 'TJ'),
(19406, 45, 774, 'Wangqinzhuang', 'CN', 'TJ'),
(19407, 45, 774, 'Weiwangzhuang', 'CN', 'TJ'),
(19408, 45, 774, 'Xiawuqi', 'CN', 'TJ'),
(19409, 45, 774, 'Xiditou', 'CN', 'TJ'),
(19410, 45, 774, 'Xinkaikou', 'CN', 'TJ'),
(19411, 45, 774, 'Xitazhuang', 'CN', 'TJ'),
(19412, 45, 774, 'Yangjinzhuang', 'CN', 'TJ'),
(19413, 45, 774, 'Yangliuqing', 'CN', 'TJ'),
(19414, 45, 774, 'Yinliu', 'CN', 'TJ'),
(19415, 45, 774, 'Yixingfu', 'CN', 'TJ'),
(19416, 45, 774, 'Youguzhuang', 'CN', 'TJ'),
(19417, 45, 774, 'Yuelongzhuang', 'CN', 'TJ'),
(19418, 45, 774, 'Yuguzhuang', 'CN', 'TJ'),
(19419, 45, 774, 'Zaojiacheng', 'CN', 'TJ'),
(19420, 45, 774, 'Zhangjiawo', 'CN', 'TJ'),
(19421, 45, 774, 'Zhaoguli', 'CN', 'TJ'),
(19422, 45, 774, 'Zhaoguli', 'CN', 'TJ'),
(19423, 45, 775, 'Ailan Mubage', 'CN', 'XJ'),
(19424, 45, 775, 'Aksu', 'CN', 'XJ'),
(19425, 45, 775, 'Aksu Diqu', 'CN', 'XJ'),
(19426, 45, 775, 'Altay', 'CN', 'XJ'),
(19427, 45, 775, 'Altay Diqu', 'CN', 'XJ'),
(19428, 45, 775, 'Aral', 'CN', 'XJ'),
(19429, 45, 775, 'Aykol', 'CN', 'XJ'),
(19430, 45, 775, 'Baijiantan', 'CN', 'XJ'),
(19431, 45, 775, 'Baluntaicun', 'CN', 'XJ'),
(19432, 45, 775, 'Bayingolin Mongol Zizhizhou', 'CN', 'XJ'),
(19433, 45, 775, 'Changji', 'CN', 'XJ'),
(19434, 45, 775, 'Changji Huizu Zizhizhou', 'CN', 'XJ'),
(19435, 45, 775, 'Fukang', 'CN', 'XJ'),
(19436, 45, 775, 'Hami', 'CN', 'XJ'),
(19437, 45, 775, 'Hotan', 'CN', 'XJ'),
(19438, 45, 775, 'Hoxtolgay', 'CN', 'XJ'),
(19439, 45, 775, 'Huocheng', 'CN', 'XJ'),
(19440, 45, 775, 'Ili Kazak Zizhizhou', 'CN', 'XJ'),
(19441, 45, 775, 'Karamay', 'CN', 'XJ'),
(19442, 45, 775, 'Karamay Shi', 'CN', 'XJ'),
(19443, 45, 775, 'Kashgar', 'CN', 'XJ'),
(19444, 45, 775, 'Kaxgar Diqu', 'CN', 'XJ'),
(19445, 45, 775, 'Korla', 'CN', 'XJ'),
(19446, 45, 775, 'Kuqa', 'CN', 'XJ'),
(19447, 45, 775, 'Kuytun', 'CN', 'XJ'),
(19448, 45, 775, 'Qapqal', 'CN', 'XJ'),
(19449, 45, 775, 'Shache', 'CN', 'XJ'),
(19450, 45, 775, 'Shihezi', 'CN', 'XJ'),
(19451, 45, 775, 'Sishilichengzi', 'CN', 'XJ'),
(19452, 45, 775, 'Tacheng', 'CN', 'XJ'),
(19453, 45, 775, 'Tacheng Diqu', 'CN', 'XJ'),
(19454, 45, 775, 'Turpan', 'CN', 'XJ'),
(19455, 45, 775, 'Turpan Diqu', 'CN', 'XJ'),
(19456, 45, 775, 'Ürümqi', 'CN', 'XJ'),
(19457, 45, 775, 'Urumqi Shi', 'CN', 'XJ'),
(19458, 45, 775, 'Xinyuan', 'CN', 'XJ'),
(19459, 45, 775, 'Zangguy', 'CN', 'XJ'),
(19460, 45, 776, 'Burang', 'CN', 'XZ'),
(19461, 45, 776, 'Dêqên', 'CN', 'XZ'),
(19462, 45, 776, 'Jiangzi', 'CN', 'XZ'),
(19463, 45, 776, 'Lhasa', 'CN', 'XZ'),
(19464, 45, 776, 'Nagqu', 'CN', 'XZ'),
(19465, 45, 776, 'Nagqu Diqu', 'CN', 'XZ'),
(19466, 45, 776, 'Ngari Diqu', 'CN', 'XZ'),
(19467, 45, 776, 'Nyingchi Prefecture', 'CN', 'XZ'),
(19468, 45, 776, 'Qamdo', 'CN', 'XZ'),
(19469, 45, 776, 'Qamdo Shi', 'CN', 'XZ'),
(19470, 45, 776, 'Rikaze', 'CN', 'XZ'),
(19471, 45, 776, 'Saga', 'CN', 'XZ'),
(19472, 45, 776, 'Shannan Diqu', 'CN', 'XZ'),
(19473, 45, 777, 'Chuxiong Yizu Zizhizhou', 'CN', 'YN'),
(19474, 45, 777, 'Dali', 'CN', 'YN'),
(19475, 45, 777, 'Dali Baizu Zizhizhou', 'CN', 'YN'),
(19476, 45, 777, 'Dehong Daizu Jingpozu Zizhizhou', 'CN', 'YN'),
(19477, 45, 777, 'Dêqên Tibetan Autonomous Prefecture', 'CN', 'YN'),
(19478, 45, 777, 'Gejiu', 'CN', 'YN'),
(19479, 45, 777, 'Haikou', 'CN', 'YN'),
(19480, 45, 777, 'Honghe Hanizu Yizu Zizhizhou', 'CN', 'YN'),
(19481, 45, 777, 'Jinghong', 'CN', 'YN'),
(19482, 45, 777, 'Kaihua', 'CN', 'YN'),
(19483, 45, 777, 'Kaiyuan', 'CN', 'YN'),
(19484, 45, 777, 'Kunming', 'CN', 'YN'),
(19485, 45, 777, 'Lianran', 'CN', 'YN'),
(19486, 45, 777, 'Lijiang', 'CN', 'YN'),
(19487, 45, 777, 'Lincang Shi', 'CN', 'YN'),
(19488, 45, 777, 'Longquan', 'CN', 'YN'),
(19489, 45, 777, 'Mabai', 'CN', 'YN'),
(19490, 45, 777, 'Majie', 'CN', 'YN'),
(19491, 45, 777, 'Miyang', 'CN', 'YN'),
(19492, 45, 777, 'Nujiang Lisuzu Zizhizhou', 'CN', 'YN'),
(19493, 45, 777, 'Qujing', 'CN', 'YN'),
(19494, 45, 777, 'Shangri-La', 'CN', 'YN'),
(19495, 45, 777, 'Shilin', 'CN', 'YN'),
(19496, 45, 777, 'Wenlan', 'CN', 'YN'),
(19497, 45, 777, 'Wenshan City', 'CN', 'YN'),
(19498, 45, 777, 'Wenshan Zhuangzu Miaozu Zizhizhou', 'CN', 'YN'),
(19499, 45, 777, 'Yuxi', 'CN', 'YN'),
(19500, 45, 777, 'Zhaotong', 'CN', 'YN');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(19501, 45, 777, 'Zhongshu', 'CN', 'YN'),
(19502, 45, 778, 'Deqing', 'CN', 'ZJ'),
(19503, 45, 778, 'Dongyang', 'CN', 'ZJ'),
(19504, 45, 778, 'Fenghua', 'CN', 'ZJ'),
(19505, 45, 778, 'Fuyang', 'CN', 'ZJ'),
(19506, 45, 778, 'Guli', 'CN', 'ZJ'),
(19507, 45, 778, 'Haining', 'CN', 'ZJ'),
(19508, 45, 778, 'Hangzhou', 'CN', 'ZJ'),
(19509, 45, 778, 'Huangyan', 'CN', 'ZJ'),
(19510, 45, 778, 'Huzhou', 'CN', 'ZJ'),
(19511, 45, 778, 'Jiaojiang', 'CN', 'ZJ'),
(19512, 45, 778, 'Jiashan', 'CN', 'ZJ'),
(19513, 45, 778, 'Jiaxing', 'CN', 'ZJ'),
(19514, 45, 778, 'Jiaxing Shi', 'CN', 'ZJ'),
(19515, 45, 778, 'Jinhua', 'CN', 'ZJ'),
(19516, 45, 778, 'Jinxiang', 'CN', 'ZJ'),
(19517, 45, 778, 'Kunyang', 'CN', 'ZJ'),
(19518, 45, 778, 'Lanxi', 'CN', 'ZJ'),
(19519, 45, 778, 'Lianghu', 'CN', 'ZJ'),
(19520, 45, 778, 'Linhai', 'CN', 'ZJ'),
(19521, 45, 778, 'Linping', 'CN', 'ZJ'),
(19522, 45, 778, 'Lishui', 'CN', 'ZJ'),
(19523, 45, 778, 'Luqiao', 'CN', 'ZJ'),
(19524, 45, 778, 'Ningbo', 'CN', 'ZJ'),
(19525, 45, 778, 'Ninghai', 'CN', 'ZJ'),
(19526, 45, 778, 'Puyang', 'CN', 'ZJ'),
(19527, 45, 778, 'Quzhou', 'CN', 'ZJ'),
(19528, 45, 778, 'Shangyu', 'CN', 'ZJ'),
(19529, 45, 778, 'Shaoxing', 'CN', 'ZJ'),
(19530, 45, 778, 'Shenjiamen', 'CN', 'ZJ'),
(19531, 45, 778, 'Taizhou', 'CN', 'ZJ'),
(19532, 45, 778, 'Wenling', 'CN', 'ZJ'),
(19533, 45, 778, 'Wenzhou', 'CN', 'ZJ'),
(19534, 45, 778, 'Wuzhen', 'CN', 'ZJ'),
(19535, 45, 778, 'Xianju', 'CN', 'ZJ'),
(19536, 45, 778, 'Xiaoshan', 'CN', 'ZJ'),
(19537, 45, 778, 'Yiwu', 'CN', 'ZJ'),
(19538, 45, 778, 'Yuyao', 'CN', 'ZJ'),
(19539, 45, 778, 'Zhaobaoshan', 'CN', 'ZJ'),
(19540, 45, 778, 'Zhicheng', 'CN', 'ZJ'),
(19541, 45, 778, 'Zhoushan', 'CN', 'ZJ'),
(19542, 45, 778, 'Zhuji', 'CN', 'ZJ'),
(19543, 48, 779, 'El Encanto', 'CO', 'AMA'),
(19544, 48, 779, 'La Chorrera', 'CO', 'AMA'),
(19545, 48, 779, 'La Pedrera', 'CO', 'AMA'),
(19546, 48, 779, 'La Victoria', 'CO', 'AMA'),
(19547, 48, 779, 'Leticia', 'CO', 'AMA'),
(19548, 48, 779, 'Miriti - Paraná', 'CO', 'AMA'),
(19549, 48, 779, 'Puerto Alegría', 'CO', 'AMA'),
(19550, 48, 779, 'Puerto Arica', 'CO', 'AMA'),
(19551, 48, 779, 'Puerto Nariño', 'CO', 'AMA'),
(19552, 48, 779, 'Puerto Santander', 'CO', 'AMA'),
(19553, 48, 779, 'Tarapacá', 'CO', 'AMA'),
(19554, 48, 780, 'Abejorral', 'CO', 'ANT'),
(19555, 48, 780, 'Abriaquí', 'CO', 'ANT'),
(19556, 48, 780, 'Alejandría', 'CO', 'ANT'),
(19557, 48, 780, 'Amagá', 'CO', 'ANT'),
(19558, 48, 780, 'Amalfi', 'CO', 'ANT'),
(19559, 48, 780, 'Andes', 'CO', 'ANT'),
(19560, 48, 780, 'Angelópolis', 'CO', 'ANT'),
(19561, 48, 780, 'Angostura', 'CO', 'ANT'),
(19562, 48, 780, 'Anorí', 'CO', 'ANT'),
(19563, 48, 780, 'Anza', 'CO', 'ANT'),
(19564, 48, 780, 'Apartadó', 'CO', 'ANT'),
(19565, 48, 780, 'Arboletes', 'CO', 'ANT'),
(19566, 48, 780, 'Argelia', 'CO', 'ANT'),
(19567, 48, 780, 'Armenia', 'CO', 'ANT'),
(19568, 48, 780, 'Barbosa', 'CO', 'ANT'),
(19569, 48, 780, 'Bello', 'CO', 'ANT'),
(19570, 48, 780, 'Belmira', 'CO', 'ANT'),
(19571, 48, 780, 'Betania', 'CO', 'ANT'),
(19572, 48, 780, 'Betulia', 'CO', 'ANT'),
(19573, 48, 780, 'Briceño', 'CO', 'ANT'),
(19574, 48, 780, 'Buriticá', 'CO', 'ANT'),
(19575, 48, 780, 'Cáceres', 'CO', 'ANT'),
(19576, 48, 780, 'Caicedo', 'CO', 'ANT'),
(19577, 48, 780, 'Caldas', 'CO', 'ANT'),
(19578, 48, 780, 'Campamento', 'CO', 'ANT'),
(19579, 48, 780, 'Cañasgordas', 'CO', 'ANT'),
(19580, 48, 780, 'Caracolí', 'CO', 'ANT'),
(19581, 48, 780, 'Caramanta', 'CO', 'ANT'),
(19582, 48, 780, 'Carepa', 'CO', 'ANT'),
(19583, 48, 780, 'Carolina', 'CO', 'ANT'),
(19584, 48, 780, 'Caucasia', 'CO', 'ANT'),
(19585, 48, 780, 'Chigorodó', 'CO', 'ANT'),
(19586, 48, 780, 'Cisneros', 'CO', 'ANT'),
(19587, 48, 780, 'Ciudad Bolívar', 'CO', 'ANT'),
(19588, 48, 780, 'Cocorná', 'CO', 'ANT'),
(19589, 48, 780, 'Concepción', 'CO', 'ANT'),
(19590, 48, 780, 'Concordia', 'CO', 'ANT'),
(19591, 48, 780, 'Copacabana', 'CO', 'ANT'),
(19592, 48, 780, 'Dabeiba', 'CO', 'ANT'),
(19593, 48, 780, 'Donmatías', 'CO', 'ANT'),
(19594, 48, 780, 'Ebéjico', 'CO', 'ANT'),
(19595, 48, 780, 'El Bagre', 'CO', 'ANT'),
(19596, 48, 780, 'El Carmen de Viboral', 'CO', 'ANT'),
(19597, 48, 780, 'El Santuario', 'CO', 'ANT'),
(19598, 48, 780, 'Entrerrios', 'CO', 'ANT'),
(19599, 48, 780, 'Envigado', 'CO', 'ANT'),
(19600, 48, 780, 'Fredonia', 'CO', 'ANT'),
(19601, 48, 780, 'Frontino', 'CO', 'ANT'),
(19602, 48, 780, 'Giraldo', 'CO', 'ANT'),
(19603, 48, 780, 'Girardota', 'CO', 'ANT'),
(19604, 48, 780, 'Gómez Plata', 'CO', 'ANT'),
(19605, 48, 780, 'Granada', 'CO', 'ANT'),
(19606, 48, 780, 'Guadalupe', 'CO', 'ANT'),
(19607, 48, 780, 'Guarne', 'CO', 'ANT'),
(19608, 48, 780, 'Guatapé', 'CO', 'ANT'),
(19609, 48, 780, 'Heliconia', 'CO', 'ANT'),
(19610, 48, 780, 'Hispania', 'CO', 'ANT'),
(19611, 48, 780, 'Itagui', 'CO', 'ANT'),
(19612, 48, 780, 'Ituango', 'CO', 'ANT'),
(19613, 48, 780, 'Jardín', 'CO', 'ANT'),
(19614, 48, 780, 'Jericó', 'CO', 'ANT'),
(19615, 48, 780, 'La Ceja', 'CO', 'ANT'),
(19616, 48, 780, 'La Estrella', 'CO', 'ANT'),
(19617, 48, 780, 'La Pintada', 'CO', 'ANT'),
(19618, 48, 780, 'La Unión', 'CO', 'ANT'),
(19619, 48, 780, 'Liborina', 'CO', 'ANT'),
(19620, 48, 780, 'Maceo', 'CO', 'ANT'),
(19621, 48, 780, 'Marinilla', 'CO', 'ANT'),
(19622, 48, 780, 'Medellín', 'CO', 'ANT'),
(19623, 48, 780, 'Montebello', 'CO', 'ANT'),
(19624, 48, 780, 'Murindó', 'CO', 'ANT'),
(19625, 48, 780, 'Mutatá', 'CO', 'ANT'),
(19626, 48, 780, 'Nariño', 'CO', 'ANT'),
(19627, 48, 780, 'Nechí', 'CO', 'ANT'),
(19628, 48, 780, 'Necoclí', 'CO', 'ANT'),
(19629, 48, 780, 'Olaya', 'CO', 'ANT'),
(19630, 48, 780, 'Peñol', 'CO', 'ANT'),
(19631, 48, 780, 'Peque', 'CO', 'ANT'),
(19632, 48, 780, 'Pueblorrico', 'CO', 'ANT'),
(19633, 48, 780, 'Puerto Berrío', 'CO', 'ANT'),
(19634, 48, 780, 'Puerto Nare', 'CO', 'ANT'),
(19635, 48, 780, 'Puerto Triunfo', 'CO', 'ANT'),
(19636, 48, 780, 'Remedios', 'CO', 'ANT'),
(19637, 48, 780, 'Retiro', 'CO', 'ANT'),
(19638, 48, 780, 'Rionegro', 'CO', 'ANT'),
(19639, 48, 780, 'Sabanalarga', 'CO', 'ANT'),
(19640, 48, 780, 'Sabaneta', 'CO', 'ANT'),
(19641, 48, 780, 'Salgar', 'CO', 'ANT'),
(19642, 48, 780, 'San Andrés de Cuerquía', 'CO', 'ANT'),
(19643, 48, 780, 'San Carlos', 'CO', 'ANT'),
(19644, 48, 780, 'San Francisco', 'CO', 'ANT'),
(19645, 48, 780, 'San Jerónimo', 'CO', 'ANT'),
(19646, 48, 780, 'San José de la Montaña', 'CO', 'ANT'),
(19647, 48, 780, 'San Juan de Urabá', 'CO', 'ANT'),
(19648, 48, 780, 'San Luis', 'CO', 'ANT'),
(19649, 48, 780, 'San Pedro de los Milagros', 'CO', 'ANT'),
(19650, 48, 780, 'San Pedro de Uraba', 'CO', 'ANT'),
(19651, 48, 780, 'San Rafael', 'CO', 'ANT'),
(19652, 48, 780, 'San Roque', 'CO', 'ANT'),
(19653, 48, 780, 'San Vicente Ferrer', 'CO', 'ANT'),
(19654, 48, 780, 'Santa Bárbara', 'CO', 'ANT'),
(19655, 48, 780, 'Santa Fe de Antioquia', 'CO', 'ANT'),
(19656, 48, 780, 'Santa Rosa de Osos', 'CO', 'ANT'),
(19657, 48, 780, 'Santo Domingo', 'CO', 'ANT'),
(19658, 48, 780, 'Segovia', 'CO', 'ANT'),
(19659, 48, 780, 'Sonson', 'CO', 'ANT'),
(19660, 48, 780, 'Sopetrán', 'CO', 'ANT'),
(19661, 48, 780, 'Támesis', 'CO', 'ANT'),
(19662, 48, 780, 'Tarazá', 'CO', 'ANT'),
(19663, 48, 780, 'Tarso', 'CO', 'ANT'),
(19664, 48, 780, 'Titiribí', 'CO', 'ANT'),
(19665, 48, 780, 'Toledo', 'CO', 'ANT'),
(19666, 48, 780, 'Turbo', 'CO', 'ANT'),
(19667, 48, 780, 'Uramita', 'CO', 'ANT'),
(19668, 48, 780, 'Urrao', 'CO', 'ANT'),
(19669, 48, 780, 'Valdivia', 'CO', 'ANT'),
(19670, 48, 780, 'Valparaíso', 'CO', 'ANT'),
(19671, 48, 780, 'Vegachí', 'CO', 'ANT'),
(19672, 48, 780, 'Venecia', 'CO', 'ANT'),
(19673, 48, 780, 'Vigía del Fuerte', 'CO', 'ANT'),
(19674, 48, 780, 'Yalí', 'CO', 'ANT'),
(19675, 48, 780, 'Yarumal', 'CO', 'ANT'),
(19676, 48, 780, 'Yolombó', 'CO', 'ANT'),
(19677, 48, 780, 'Yondó', 'CO', 'ANT'),
(19678, 48, 780, 'Zaragoza', 'CO', 'ANT'),
(19679, 48, 781, 'Arauca', 'CO', 'ARA'),
(19680, 48, 781, 'Arauquita', 'CO', 'ARA'),
(19681, 48, 781, 'Cravo Norte', 'CO', 'ARA'),
(19682, 48, 781, 'Fortul', 'CO', 'ARA'),
(19683, 48, 781, 'Puerto Rondón', 'CO', 'ARA'),
(19684, 48, 781, 'Saravena', 'CO', 'ARA'),
(19685, 48, 781, 'Tame', 'CO', 'ARA'),
(19686, 48, 782, 'Providencia', 'CO', 'SAP'),
(19687, 48, 782, 'San Andrés', 'CO', 'SAP'),
(19688, 48, 783, 'Baranoa', 'CO', 'ATL'),
(19689, 48, 783, 'Barranquilla', 'CO', 'ATL'),
(19690, 48, 783, 'Campo de la Cruz', 'CO', 'ATL'),
(19691, 48, 783, 'Candelaria', 'CO', 'ATL'),
(19692, 48, 783, 'Galapa', 'CO', 'ATL'),
(19693, 48, 783, 'Juan de Acosta', 'CO', 'ATL'),
(19694, 48, 783, 'Luruaco', 'CO', 'ATL'),
(19695, 48, 783, 'Malambo', 'CO', 'ATL'),
(19696, 48, 783, 'Manatí', 'CO', 'ATL'),
(19697, 48, 783, 'Palmar de Varela', 'CO', 'ATL'),
(19698, 48, 783, 'Piojó', 'CO', 'ATL'),
(19699, 48, 783, 'Polonuevo', 'CO', 'ATL'),
(19700, 48, 783, 'Ponedera', 'CO', 'ATL'),
(19701, 48, 783, 'Puerto Colombia', 'CO', 'ATL'),
(19702, 48, 783, 'Repelón', 'CO', 'ATL'),
(19703, 48, 783, 'Sabanagrande', 'CO', 'ATL'),
(19704, 48, 783, 'Sabanalarga', 'CO', 'ATL'),
(19705, 48, 783, 'Santa Lucía', 'CO', 'ATL'),
(19706, 48, 783, 'Santo Tomás', 'CO', 'ATL'),
(19707, 48, 783, 'Soledad', 'CO', 'ATL'),
(19708, 48, 783, 'Suan', 'CO', 'ATL'),
(19709, 48, 783, 'Tubará', 'CO', 'ATL'),
(19710, 48, 783, 'Usiacurí', 'CO', 'ATL'),
(19711, 48, 784, 'Bogotá D.C.', 'CO', 'DC'),
(19712, 48, 785, 'Achí', 'CO', 'BOL'),
(19713, 48, 785, 'Altos del Rosario', 'CO', 'BOL'),
(19714, 48, 785, 'Arenal', 'CO', 'BOL'),
(19715, 48, 785, 'Arjona', 'CO', 'BOL'),
(19716, 48, 785, 'Arroyohondo', 'CO', 'BOL'),
(19717, 48, 785, 'Barranco de Loba', 'CO', 'BOL'),
(19718, 48, 785, 'Calamar', 'CO', 'BOL'),
(19719, 48, 785, 'Cantagallo', 'CO', 'BOL'),
(19720, 48, 785, 'Cartagena de Indias', 'CO', 'BOL'),
(19721, 48, 785, 'Cicuco', 'CO', 'BOL'),
(19722, 48, 785, 'Clemencia', 'CO', 'BOL'),
(19723, 48, 785, 'Córdoba', 'CO', 'BOL'),
(19724, 48, 785, 'El Carmen de Bolívar', 'CO', 'BOL'),
(19725, 48, 785, 'El Guamo', 'CO', 'BOL'),
(19726, 48, 785, 'El Peñón', 'CO', 'BOL'),
(19727, 48, 785, 'Hatillo de Loba', 'CO', 'BOL'),
(19728, 48, 785, 'Magangué', 'CO', 'BOL'),
(19729, 48, 785, 'Mahates', 'CO', 'BOL'),
(19730, 48, 785, 'Margarita', 'CO', 'BOL'),
(19731, 48, 785, 'María la Baja', 'CO', 'BOL'),
(19732, 48, 785, 'Mompós', 'CO', 'BOL'),
(19733, 48, 785, 'Montecristo', 'CO', 'BOL'),
(19734, 48, 785, 'Morales', 'CO', 'BOL'),
(19735, 48, 785, 'Norosí', 'CO', 'BOL'),
(19736, 48, 785, 'Pinillos', 'CO', 'BOL'),
(19737, 48, 785, 'Regidor', 'CO', 'BOL'),
(19738, 48, 785, 'Río Viejo', 'CO', 'BOL'),
(19739, 48, 785, 'San Cristóbal', 'CO', 'BOL'),
(19740, 48, 785, 'San Estanislao', 'CO', 'BOL'),
(19741, 48, 785, 'San Fernando', 'CO', 'BOL'),
(19742, 48, 785, 'San Jacinto', 'CO', 'BOL'),
(19743, 48, 785, 'San Jacinto del Cauca', 'CO', 'BOL'),
(19744, 48, 785, 'San Juan Nepomuceno', 'CO', 'BOL'),
(19745, 48, 785, 'San Martín de Loba', 'CO', 'BOL'),
(19746, 48, 785, 'San Pablo', 'CO', 'BOL'),
(19747, 48, 785, 'Santa Catalina', 'CO', 'BOL'),
(19748, 48, 785, 'Santa Rosa', 'CO', 'BOL'),
(19749, 48, 785, 'Santa Rosa del Sur', 'CO', 'BOL'),
(19750, 48, 785, 'Simití', 'CO', 'BOL'),
(19751, 48, 785, 'Soplaviento', 'CO', 'BOL'),
(19752, 48, 785, 'Talaigua Nuevo', 'CO', 'BOL'),
(19753, 48, 785, 'Tiquisio', 'CO', 'BOL'),
(19754, 48, 785, 'Turbaco', 'CO', 'BOL'),
(19755, 48, 785, 'Turbaná', 'CO', 'BOL'),
(19756, 48, 785, 'Villanueva', 'CO', 'BOL'),
(19757, 48, 785, 'Zambrano', 'CO', 'BOL'),
(19758, 48, 786, 'Almeida', 'CO', 'BOY'),
(19759, 48, 786, 'Aquitania', 'CO', 'BOY'),
(19760, 48, 786, 'Arcabuco', 'CO', 'BOY'),
(19761, 48, 786, 'Belén', 'CO', 'BOY'),
(19762, 48, 786, 'Berbeo', 'CO', 'BOY'),
(19763, 48, 786, 'Betéitiva', 'CO', 'BOY'),
(19764, 48, 786, 'Boavita', 'CO', 'BOY'),
(19765, 48, 786, 'Boyacá', 'CO', 'BOY'),
(19766, 48, 786, 'Briceño', 'CO', 'BOY'),
(19767, 48, 786, 'Buenavista', 'CO', 'BOY'),
(19768, 48, 786, 'Busbanzá', 'CO', 'BOY'),
(19769, 48, 786, 'Caldas', 'CO', 'BOY'),
(19770, 48, 786, 'Campohermoso', 'CO', 'BOY'),
(19771, 48, 786, 'Cerinza', 'CO', 'BOY'),
(19772, 48, 786, 'Chinavita', 'CO', 'BOY'),
(19773, 48, 786, 'Chiquinquirá', 'CO', 'BOY'),
(19774, 48, 786, 'Chíquiza', 'CO', 'BOY'),
(19775, 48, 786, 'Chiscas', 'CO', 'BOY'),
(19776, 48, 786, 'Chita', 'CO', 'BOY'),
(19777, 48, 786, 'Chitaraque', 'CO', 'BOY'),
(19778, 48, 786, 'Chivatá', 'CO', 'BOY'),
(19779, 48, 786, 'Chivor', 'CO', 'BOY'),
(19780, 48, 786, 'Ciénega', 'CO', 'BOY'),
(19781, 48, 786, 'Combita', 'CO', 'BOY'),
(19782, 48, 786, 'Coper', 'CO', 'BOY'),
(19783, 48, 786, 'Corrales', 'CO', 'BOY'),
(19784, 48, 786, 'Covarachía', 'CO', 'BOY'),
(19785, 48, 786, 'Cubará', 'CO', 'BOY'),
(19786, 48, 786, 'Cucaita', 'CO', 'BOY'),
(19787, 48, 786, 'Cuítiva', 'CO', 'BOY'),
(19788, 48, 786, 'Duitama', 'CO', 'BOY'),
(19789, 48, 786, 'El Cocuy', 'CO', 'BOY'),
(19790, 48, 786, 'El Espino', 'CO', 'BOY'),
(19791, 48, 786, 'Firavitoba', 'CO', 'BOY'),
(19792, 48, 786, 'Floresta', 'CO', 'BOY'),
(19793, 48, 786, 'Gachantivá', 'CO', 'BOY'),
(19794, 48, 786, 'Gameza', 'CO', 'BOY'),
(19795, 48, 786, 'Garagoa', 'CO', 'BOY'),
(19796, 48, 786, 'Guacamayas', 'CO', 'BOY'),
(19797, 48, 786, 'Guateque', 'CO', 'BOY'),
(19798, 48, 786, 'Guayatá', 'CO', 'BOY'),
(19799, 48, 786, 'Güicán', 'CO', 'BOY'),
(19800, 48, 786, 'Iza', 'CO', 'BOY'),
(19801, 48, 786, 'Jenesano', 'CO', 'BOY'),
(19802, 48, 786, 'Jericó', 'CO', 'BOY'),
(19803, 48, 786, 'La Capilla', 'CO', 'BOY'),
(19804, 48, 786, 'La Uvita', 'CO', 'BOY'),
(19805, 48, 786, 'La Victoria', 'CO', 'BOY'),
(19806, 48, 786, 'Labranzagrande', 'CO', 'BOY'),
(19807, 48, 786, 'Macanal', 'CO', 'BOY'),
(19808, 48, 786, 'Maripí', 'CO', 'BOY'),
(19809, 48, 786, 'Miraflores', 'CO', 'BOY'),
(19810, 48, 786, 'Mongua', 'CO', 'BOY'),
(19811, 48, 786, 'Monguí', 'CO', 'BOY'),
(19812, 48, 786, 'Moniquirá', 'CO', 'BOY'),
(19813, 48, 786, 'Motavita', 'CO', 'BOY'),
(19814, 48, 786, 'Muzo', 'CO', 'BOY'),
(19815, 48, 786, 'Nobsa', 'CO', 'BOY'),
(19816, 48, 786, 'Nuevo Colón', 'CO', 'BOY'),
(19817, 48, 786, 'Oicatá', 'CO', 'BOY'),
(19818, 48, 786, 'Otanche', 'CO', 'BOY'),
(19819, 48, 786, 'Pachavita', 'CO', 'BOY'),
(19820, 48, 786, 'Páez', 'CO', 'BOY'),
(19821, 48, 786, 'Paipa', 'CO', 'BOY'),
(19822, 48, 786, 'Pajarito', 'CO', 'BOY'),
(19823, 48, 786, 'Panqueba', 'CO', 'BOY'),
(19824, 48, 786, 'Pauna', 'CO', 'BOY'),
(19825, 48, 786, 'Paya', 'CO', 'BOY'),
(19826, 48, 786, 'Paz de Río', 'CO', 'BOY'),
(19827, 48, 786, 'Pesca', 'CO', 'BOY'),
(19828, 48, 786, 'Pisba', 'CO', 'BOY'),
(19829, 48, 786, 'Puerto Boyacá', 'CO', 'BOY'),
(19830, 48, 786, 'Quípama', 'CO', 'BOY'),
(19831, 48, 786, 'Ramiriquí', 'CO', 'BOY'),
(19832, 48, 786, 'Ráquira', 'CO', 'BOY'),
(19833, 48, 786, 'Rondón', 'CO', 'BOY'),
(19834, 48, 786, 'Saboyá', 'CO', 'BOY'),
(19835, 48, 786, 'Sáchica', 'CO', 'BOY'),
(19836, 48, 786, 'Samacá', 'CO', 'BOY'),
(19837, 48, 786, 'San Eduardo', 'CO', 'BOY'),
(19838, 48, 786, 'San José de Pare', 'CO', 'BOY'),
(19839, 48, 786, 'San Luis de Gaceno', 'CO', 'BOY'),
(19840, 48, 786, 'San Mateo', 'CO', 'BOY'),
(19841, 48, 786, 'San Miguel de Sema', 'CO', 'BOY'),
(19842, 48, 786, 'San Pablo de Borbur', 'CO', 'BOY'),
(19843, 48, 786, 'Santa María', 'CO', 'BOY'),
(19844, 48, 786, 'Santa Rosa de Viterbo', 'CO', 'BOY'),
(19845, 48, 786, 'Santa Sofía', 'CO', 'BOY'),
(19846, 48, 786, 'Santana', 'CO', 'BOY'),
(19847, 48, 786, 'Sativanorte', 'CO', 'BOY'),
(19848, 48, 786, 'Sativasur', 'CO', 'BOY'),
(19849, 48, 786, 'Siachoque', 'CO', 'BOY'),
(19850, 48, 786, 'Soatá', 'CO', 'BOY'),
(19851, 48, 786, 'Socha', 'CO', 'BOY'),
(19852, 48, 786, 'Socotá', 'CO', 'BOY'),
(19853, 48, 786, 'Sogamoso', 'CO', 'BOY'),
(19854, 48, 786, 'Somondoco', 'CO', 'BOY'),
(19855, 48, 786, 'Sora', 'CO', 'BOY'),
(19856, 48, 786, 'Soracá', 'CO', 'BOY'),
(19857, 48, 786, 'Sotaquirá', 'CO', 'BOY'),
(19858, 48, 786, 'Susacón', 'CO', 'BOY'),
(19859, 48, 786, 'Sutamarchán', 'CO', 'BOY'),
(19860, 48, 786, 'Sutatenza', 'CO', 'BOY'),
(19861, 48, 786, 'Tasco', 'CO', 'BOY'),
(19862, 48, 786, 'Tenza', 'CO', 'BOY'),
(19863, 48, 786, 'Tibaná', 'CO', 'BOY'),
(19864, 48, 786, 'Tibasosa', 'CO', 'BOY'),
(19865, 48, 786, 'Tinjacá', 'CO', 'BOY'),
(19866, 48, 786, 'Tipacoque', 'CO', 'BOY'),
(19867, 48, 786, 'Toca', 'CO', 'BOY'),
(19868, 48, 786, 'Togüí', 'CO', 'BOY'),
(19869, 48, 786, 'Tópaga', 'CO', 'BOY'),
(19870, 48, 786, 'Tota', 'CO', 'BOY'),
(19871, 48, 786, 'Tunja', 'CO', 'BOY'),
(19872, 48, 786, 'Tununguá', 'CO', 'BOY'),
(19873, 48, 786, 'Turmequé', 'CO', 'BOY'),
(19874, 48, 786, 'Tuta', 'CO', 'BOY'),
(19875, 48, 786, 'Tutazá', 'CO', 'BOY'),
(19876, 48, 786, 'Umbita', 'CO', 'BOY'),
(19877, 48, 786, 'Ventaquemada', 'CO', 'BOY'),
(19878, 48, 786, 'Villa de Leyva', 'CO', 'BOY'),
(19879, 48, 786, 'Viracachá', 'CO', 'BOY'),
(19880, 48, 786, 'Zetaquira', 'CO', 'BOY'),
(19881, 48, 787, 'Aguadas', 'CO', 'CAL'),
(19882, 48, 787, 'Anserma', 'CO', 'CAL'),
(19883, 48, 787, 'Aranzazu', 'CO', 'CAL'),
(19884, 48, 787, 'Belalcázar', 'CO', 'CAL'),
(19885, 48, 787, 'Chinchiná', 'CO', 'CAL'),
(19886, 48, 787, 'Filadelfia', 'CO', 'CAL'),
(19887, 48, 787, 'La Dorada', 'CO', 'CAL'),
(19888, 48, 787, 'La Merced', 'CO', 'CAL'),
(19889, 48, 787, 'Manizales', 'CO', 'CAL'),
(19890, 48, 787, 'Manzanares', 'CO', 'CAL'),
(19891, 48, 787, 'Marmato', 'CO', 'CAL'),
(19892, 48, 787, 'Marquetalia', 'CO', 'CAL'),
(19893, 48, 787, 'Marulanda', 'CO', 'CAL'),
(19894, 48, 787, 'Neira', 'CO', 'CAL'),
(19895, 48, 787, 'Norcasia', 'CO', 'CAL'),
(19896, 48, 787, 'Pácora', 'CO', 'CAL'),
(19897, 48, 787, 'Palestina', 'CO', 'CAL'),
(19898, 48, 787, 'Pensilvania', 'CO', 'CAL'),
(19899, 48, 787, 'Riosucio', 'CO', 'CAL'),
(19900, 48, 787, 'Risaralda', 'CO', 'CAL'),
(19901, 48, 787, 'Salamina', 'CO', 'CAL'),
(19902, 48, 787, 'Samaná', 'CO', 'CAL'),
(19903, 48, 787, 'San José', 'CO', 'CAL'),
(19904, 48, 787, 'Supía', 'CO', 'CAL'),
(19905, 48, 787, 'Victoria', 'CO', 'CAL'),
(19906, 48, 787, 'Villamaría', 'CO', 'CAL'),
(19907, 48, 787, 'Viterbo', 'CO', 'CAL'),
(19908, 48, 788, 'Albania', 'CO', 'CAQ'),
(19909, 48, 788, 'Belén de Los Andaquies', 'CO', 'CAQ'),
(19910, 48, 788, 'Cartagena del Chairá', 'CO', 'CAQ'),
(19911, 48, 788, 'Curillo', 'CO', 'CAQ'),
(19912, 48, 788, 'El Doncello', 'CO', 'CAQ'),
(19913, 48, 788, 'El Paujil', 'CO', 'CAQ'),
(19914, 48, 788, 'Florencia', 'CO', 'CAQ'),
(19915, 48, 788, 'La Montañita', 'CO', 'CAQ'),
(19916, 48, 788, 'Milán', 'CO', 'CAQ'),
(19917, 48, 788, 'Morelia', 'CO', 'CAQ'),
(19918, 48, 788, 'Puerto Rico', 'CO', 'CAQ'),
(19919, 48, 788, 'San José del Fragua', 'CO', 'CAQ'),
(19920, 48, 788, 'San Vicente del Caguán', 'CO', 'CAQ'),
(19921, 48, 788, 'Solano', 'CO', 'CAQ'),
(19922, 48, 788, 'Solita', 'CO', 'CAQ'),
(19923, 48, 788, 'Valparaíso', 'CO', 'CAQ'),
(19924, 48, 789, 'Aguazul', 'CO', 'CAS'),
(19925, 48, 789, 'Chameza', 'CO', 'CAS'),
(19926, 48, 789, 'Hato Corozal', 'CO', 'CAS'),
(19927, 48, 789, 'La Salina', 'CO', 'CAS'),
(19928, 48, 789, 'Maní', 'CO', 'CAS'),
(19929, 48, 789, 'Monterrey', 'CO', 'CAS'),
(19930, 48, 789, 'Nunchía', 'CO', 'CAS'),
(19931, 48, 789, 'Orocué', 'CO', 'CAS'),
(19932, 48, 789, 'Paz de Ariporo', 'CO', 'CAS'),
(19933, 48, 789, 'Pore', 'CO', 'CAS'),
(19934, 48, 789, 'Recetor', 'CO', 'CAS'),
(19935, 48, 789, 'Sabanalarga', 'CO', 'CAS'),
(19936, 48, 789, 'Sácama', 'CO', 'CAS'),
(19937, 48, 789, 'San Luis de Palenque', 'CO', 'CAS'),
(19938, 48, 789, 'Támara', 'CO', 'CAS'),
(19939, 48, 789, 'Tauramena', 'CO', 'CAS'),
(19940, 48, 789, 'Trinidad', 'CO', 'CAS'),
(19941, 48, 789, 'Villanueva', 'CO', 'CAS'),
(19942, 48, 789, 'Yopal', 'CO', 'CAS'),
(19943, 48, 790, 'Almaguer', 'CO', 'CAU'),
(19944, 48, 790, 'Argelia', 'CO', 'CAU'),
(19945, 48, 790, 'Balboa', 'CO', 'CAU'),
(19946, 48, 790, 'Bolívar', 'CO', 'CAU'),
(19947, 48, 790, 'Buenos Aires', 'CO', 'CAU'),
(19948, 48, 790, 'Cajibío', 'CO', 'CAU'),
(19949, 48, 790, 'Caldono', 'CO', 'CAU'),
(19950, 48, 790, 'Caloto', 'CO', 'CAU'),
(19951, 48, 790, 'Corinto', 'CO', 'CAU'),
(19952, 48, 790, 'El Tambo', 'CO', 'CAU'),
(19953, 48, 790, 'Florencia', 'CO', 'CAU'),
(19954, 48, 790, 'Guachené', 'CO', 'CAU'),
(19955, 48, 790, 'Guapi', 'CO', 'CAU'),
(19956, 48, 790, 'Inzá', 'CO', 'CAU'),
(19957, 48, 790, 'Jambaló', 'CO', 'CAU'),
(19958, 48, 790, 'La Sierra', 'CO', 'CAU'),
(19959, 48, 790, 'La Vega', 'CO', 'CAU'),
(19960, 48, 790, 'López de Micay', 'CO', 'CAU'),
(19961, 48, 790, 'Mercaderes', 'CO', 'CAU'),
(19962, 48, 790, 'Miranda', 'CO', 'CAU'),
(19963, 48, 790, 'Morales', 'CO', 'CAU'),
(19964, 48, 790, 'Padilla', 'CO', 'CAU'),
(19965, 48, 790, 'Páez', 'CO', 'CAU'),
(19966, 48, 790, 'Patía', 'CO', 'CAU'),
(19967, 48, 790, 'Piamonte', 'CO', 'CAU'),
(19968, 48, 790, 'Piendamo', 'CO', 'CAU'),
(19969, 48, 790, 'Popayán', 'CO', 'CAU'),
(19970, 48, 790, 'Puerto Tejada', 'CO', 'CAU'),
(19971, 48, 790, 'Puracé', 'CO', 'CAU'),
(19972, 48, 790, 'Rosas', 'CO', 'CAU'),
(19973, 48, 790, 'San Sebastián', 'CO', 'CAU'),
(19974, 48, 790, 'Santa Rosa', 'CO', 'CAU'),
(19975, 48, 790, 'Santander de Quilichao', 'CO', 'CAU'),
(19976, 48, 790, 'Silvia', 'CO', 'CAU'),
(19977, 48, 790, 'Sotará', 'CO', 'CAU'),
(19978, 48, 790, 'Suárez', 'CO', 'CAU'),
(19979, 48, 790, 'Sucre', 'CO', 'CAU'),
(19980, 48, 790, 'Timbío', 'CO', 'CAU'),
(19981, 48, 790, 'Timbiquí', 'CO', 'CAU'),
(19982, 48, 790, 'Toribio', 'CO', 'CAU'),
(19983, 48, 790, 'Totoró', 'CO', 'CAU'),
(19984, 48, 790, 'Villa Rica', 'CO', 'CAU'),
(19985, 48, 791, 'Aguachica', 'CO', 'CES'),
(19986, 48, 791, 'Agustín Codazzi', 'CO', 'CES'),
(19987, 48, 791, 'Astrea', 'CO', 'CES'),
(19988, 48, 791, 'Becerril', 'CO', 'CES'),
(19989, 48, 791, 'Bosconia', 'CO', 'CES'),
(19990, 48, 791, 'Chimichagua', 'CO', 'CES'),
(19991, 48, 791, 'Chiriguaná', 'CO', 'CES'),
(19992, 48, 791, 'Curumaní', 'CO', 'CES'),
(19993, 48, 791, 'El Copey', 'CO', 'CES'),
(19994, 48, 791, 'El Paso', 'CO', 'CES'),
(19995, 48, 791, 'Gamarra', 'CO', 'CES'),
(19996, 48, 791, 'González', 'CO', 'CES'),
(19997, 48, 791, 'La Gloria', 'CO', 'CES'),
(19998, 48, 791, 'La Jagua de Ibirico', 'CO', 'CES'),
(19999, 48, 791, 'La Paz', 'CO', 'CES'),
(20000, 48, 791, 'Manaure Balcón del Cesar', 'CO', 'CES');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(20001, 48, 791, 'Pailitas', 'CO', 'CES'),
(20002, 48, 791, 'Pelaya', 'CO', 'CES'),
(20003, 48, 791, 'Pueblo Bello', 'CO', 'CES'),
(20004, 48, 791, 'Río de Oro', 'CO', 'CES'),
(20005, 48, 791, 'San Alberto', 'CO', 'CES'),
(20006, 48, 791, 'San Diego', 'CO', 'CES'),
(20007, 48, 791, 'San Martín', 'CO', 'CES'),
(20008, 48, 791, 'Tamalameque', 'CO', 'CES'),
(20009, 48, 791, 'Valledupar', 'CO', 'CES'),
(20010, 48, 792, 'Acandí', 'CO', 'CHO'),
(20011, 48, 792, 'Alto Baudó', 'CO', 'CHO'),
(20012, 48, 792, 'Atrato', 'CO', 'CHO'),
(20013, 48, 792, 'Bagadó', 'CO', 'CHO'),
(20014, 48, 792, 'Bahía Solano', 'CO', 'CHO'),
(20015, 48, 792, 'Bajo Baudó', 'CO', 'CHO'),
(20016, 48, 792, 'Bojayá', 'CO', 'CHO'),
(20017, 48, 792, 'Carmen del Darien', 'CO', 'CHO'),
(20018, 48, 792, 'Cértegui', 'CO', 'CHO'),
(20019, 48, 792, 'Condoto', 'CO', 'CHO'),
(20020, 48, 792, 'El Cantón de San Pablo', 'CO', 'CHO'),
(20021, 48, 792, 'El Carmen de Atrato', 'CO', 'CHO'),
(20022, 48, 792, 'Istmina', 'CO', 'CHO'),
(20023, 48, 792, 'Juradó', 'CO', 'CHO'),
(20024, 48, 792, 'Litoral del San Juan', 'CO', 'CHO'),
(20025, 48, 792, 'Lloró', 'CO', 'CHO'),
(20026, 48, 792, 'Medio Atrato', 'CO', 'CHO'),
(20027, 48, 792, 'Medio Baudó', 'CO', 'CHO'),
(20028, 48, 792, 'Medio San Juan', 'CO', 'CHO'),
(20029, 48, 792, 'Nóvita', 'CO', 'CHO'),
(20030, 48, 792, 'Nuquí', 'CO', 'CHO'),
(20031, 48, 792, 'Quibdó', 'CO', 'CHO'),
(20032, 48, 792, 'Río Iro', 'CO', 'CHO'),
(20033, 48, 792, 'Río Quito', 'CO', 'CHO'),
(20034, 48, 792, 'Riosucio', 'CO', 'CHO'),
(20035, 48, 792, 'San José del Palmar', 'CO', 'CHO'),
(20036, 48, 792, 'Sipí', 'CO', 'CHO'),
(20037, 48, 792, 'Tadó', 'CO', 'CHO'),
(20038, 48, 792, 'Unguía', 'CO', 'CHO'),
(20039, 48, 792, 'Unión Panamericana', 'CO', 'CHO'),
(20040, 48, 793, 'Ayapel', 'CO', 'COR'),
(20041, 48, 793, 'Buenavista', 'CO', 'COR'),
(20042, 48, 793, 'Canalete', 'CO', 'COR'),
(20043, 48, 793, 'Cereté', 'CO', 'COR'),
(20044, 48, 793, 'Chimá', 'CO', 'COR'),
(20045, 48, 793, 'Chinú', 'CO', 'COR'),
(20046, 48, 793, 'Ciénaga de Oro', 'CO', 'COR'),
(20047, 48, 793, 'Cotorra', 'CO', 'COR'),
(20048, 48, 793, 'La Apartada', 'CO', 'COR'),
(20049, 48, 793, 'Lorica', 'CO', 'COR'),
(20050, 48, 793, 'Los Córdobas', 'CO', 'COR'),
(20051, 48, 793, 'Momil', 'CO', 'COR'),
(20052, 48, 793, 'Moñitos', 'CO', 'COR'),
(20053, 48, 793, 'Montelíbano', 'CO', 'COR'),
(20054, 48, 793, 'Montería', 'CO', 'COR'),
(20055, 48, 793, 'Planeta Rica', 'CO', 'COR'),
(20056, 48, 793, 'Pueblo Nuevo', 'CO', 'COR'),
(20057, 48, 793, 'Puerto Escondido', 'CO', 'COR'),
(20058, 48, 793, 'Puerto Libertador', 'CO', 'COR'),
(20059, 48, 793, 'Purísima', 'CO', 'COR'),
(20060, 48, 793, 'Sahagún', 'CO', 'COR'),
(20061, 48, 793, 'San Andrés de Sotavento', 'CO', 'COR'),
(20062, 48, 793, 'San Antero', 'CO', 'COR'),
(20063, 48, 793, 'San Bernardo del Viento', 'CO', 'COR'),
(20064, 48, 793, 'San Carlos', 'CO', 'COR'),
(20065, 48, 793, 'San José de Uré', 'CO', 'COR'),
(20066, 48, 793, 'San Pelayo', 'CO', 'COR'),
(20067, 48, 793, 'Tierralta', 'CO', 'COR'),
(20068, 48, 793, 'Tuchín', 'CO', 'COR'),
(20069, 48, 793, 'Valencia', 'CO', 'COR'),
(20070, 48, 794, 'Agua de Dios', 'CO', 'CUN'),
(20071, 48, 794, 'Albán', 'CO', 'CUN'),
(20072, 48, 794, 'Anapoima', 'CO', 'CUN'),
(20073, 48, 794, 'Anolaima', 'CO', 'CUN'),
(20074, 48, 794, 'Apulo', 'CO', 'CUN'),
(20075, 48, 794, 'Arbeláez', 'CO', 'CUN'),
(20076, 48, 794, 'Beltrán', 'CO', 'CUN'),
(20077, 48, 794, 'Bituima', 'CO', 'CUN'),
(20078, 48, 794, 'Bogotá D.C.', 'CO', 'CUN'),
(20079, 48, 794, 'Bojacá', 'CO', 'CUN'),
(20080, 48, 794, 'Cabrera', 'CO', 'CUN'),
(20081, 48, 794, 'Cachipay', 'CO', 'CUN'),
(20082, 48, 794, 'Cajicá', 'CO', 'CUN'),
(20083, 48, 794, 'Caparrapí', 'CO', 'CUN'),
(20084, 48, 794, 'Caqueza', 'CO', 'CUN'),
(20085, 48, 794, 'Carmen de Carupa', 'CO', 'CUN'),
(20086, 48, 794, 'Chaguaní', 'CO', 'CUN'),
(20087, 48, 794, 'Chía', 'CO', 'CUN'),
(20088, 48, 794, 'Chipaque', 'CO', 'CUN'),
(20089, 48, 794, 'Choachí', 'CO', 'CUN'),
(20090, 48, 794, 'Chocontá', 'CO', 'CUN'),
(20091, 48, 794, 'Cogua', 'CO', 'CUN'),
(20092, 48, 794, 'Cota', 'CO', 'CUN'),
(20093, 48, 794, 'Cucunubá', 'CO', 'CUN'),
(20094, 48, 794, 'El Colegio', 'CO', 'CUN'),
(20095, 48, 794, 'El Peñón', 'CO', 'CUN'),
(20096, 48, 794, 'El Rosal', 'CO', 'CUN'),
(20097, 48, 794, 'Facatativá', 'CO', 'CUN'),
(20098, 48, 794, 'Fomeque', 'CO', 'CUN'),
(20099, 48, 794, 'Fosca', 'CO', 'CUN'),
(20100, 48, 794, 'Funza', 'CO', 'CUN'),
(20101, 48, 794, 'Fúquene', 'CO', 'CUN'),
(20102, 48, 794, 'Fusagasugá', 'CO', 'CUN'),
(20103, 48, 794, 'Gachala', 'CO', 'CUN'),
(20104, 48, 794, 'Gachancipá', 'CO', 'CUN'),
(20105, 48, 794, 'Gachetá', 'CO', 'CUN'),
(20106, 48, 794, 'Gama', 'CO', 'CUN'),
(20107, 48, 794, 'Girardot', 'CO', 'CUN'),
(20108, 48, 794, 'Granada', 'CO', 'CUN'),
(20109, 48, 794, 'Guachetá', 'CO', 'CUN'),
(20110, 48, 794, 'Guaduas', 'CO', 'CUN'),
(20111, 48, 794, 'Guasca', 'CO', 'CUN'),
(20112, 48, 794, 'Guataquí', 'CO', 'CUN'),
(20113, 48, 794, 'Guatavita', 'CO', 'CUN'),
(20114, 48, 794, 'Guayabal de Siquima', 'CO', 'CUN'),
(20115, 48, 794, 'Guayabetal', 'CO', 'CUN'),
(20116, 48, 794, 'Gutiérrez', 'CO', 'CUN'),
(20117, 48, 794, 'Jerusalén', 'CO', 'CUN'),
(20118, 48, 794, 'Junín', 'CO', 'CUN'),
(20119, 48, 794, 'La Calera', 'CO', 'CUN'),
(20120, 48, 794, 'La Mesa', 'CO', 'CUN'),
(20121, 48, 794, 'La Palma', 'CO', 'CUN'),
(20122, 48, 794, 'La Peña', 'CO', 'CUN'),
(20123, 48, 794, 'La Vega', 'CO', 'CUN'),
(20124, 48, 794, 'Lenguazaque', 'CO', 'CUN'),
(20125, 48, 794, 'Macheta', 'CO', 'CUN'),
(20126, 48, 794, 'Madrid', 'CO', 'CUN'),
(20127, 48, 794, 'Manta', 'CO', 'CUN'),
(20128, 48, 794, 'Medina', 'CO', 'CUN'),
(20129, 48, 794, 'Mosquera', 'CO', 'CUN'),
(20130, 48, 794, 'Nariño', 'CO', 'CUN'),
(20131, 48, 794, 'Nemocón', 'CO', 'CUN'),
(20132, 48, 794, 'Nilo', 'CO', 'CUN'),
(20133, 48, 794, 'Nimaima', 'CO', 'CUN'),
(20134, 48, 794, 'Nocaima', 'CO', 'CUN'),
(20135, 48, 794, 'Pacho', 'CO', 'CUN'),
(20136, 48, 794, 'Paime', 'CO', 'CUN'),
(20137, 48, 794, 'Pandi', 'CO', 'CUN'),
(20138, 48, 794, 'Paratebueno', 'CO', 'CUN'),
(20139, 48, 794, 'Pasca', 'CO', 'CUN'),
(20140, 48, 794, 'Puerto Salgar', 'CO', 'CUN'),
(20141, 48, 794, 'Pulí', 'CO', 'CUN'),
(20142, 48, 794, 'Quebradanegra', 'CO', 'CUN'),
(20143, 48, 794, 'Quetame', 'CO', 'CUN'),
(20144, 48, 794, 'Quipile', 'CO', 'CUN'),
(20145, 48, 794, 'Ricaurte', 'CO', 'CUN'),
(20146, 48, 794, 'San Antonio del Tequendama', 'CO', 'CUN'),
(20147, 48, 794, 'San Bernardo', 'CO', 'CUN'),
(20148, 48, 794, 'San Cayetano', 'CO', 'CUN'),
(20149, 48, 794, 'San Francisco', 'CO', 'CUN'),
(20150, 48, 794, 'San Juan de Río Seco', 'CO', 'CUN'),
(20151, 48, 794, 'Sasaima', 'CO', 'CUN'),
(20152, 48, 794, 'Sesquilé', 'CO', 'CUN'),
(20153, 48, 794, 'Sibaté', 'CO', 'CUN'),
(20154, 48, 794, 'Silvania', 'CO', 'CUN'),
(20155, 48, 794, 'Simijaca', 'CO', 'CUN'),
(20156, 48, 794, 'Soacha', 'CO', 'CUN'),
(20157, 48, 794, 'Sopó', 'CO', 'CUN'),
(20158, 48, 794, 'Subachoque', 'CO', 'CUN'),
(20159, 48, 794, 'Suesca', 'CO', 'CUN'),
(20160, 48, 794, 'Supatá', 'CO', 'CUN'),
(20161, 48, 794, 'Susa', 'CO', 'CUN'),
(20162, 48, 794, 'Sutatausa', 'CO', 'CUN'),
(20163, 48, 794, 'Tabio', 'CO', 'CUN'),
(20164, 48, 794, 'Tausa', 'CO', 'CUN'),
(20165, 48, 794, 'Tena', 'CO', 'CUN'),
(20166, 48, 794, 'Tenjo', 'CO', 'CUN'),
(20167, 48, 794, 'Tibacuy', 'CO', 'CUN'),
(20168, 48, 794, 'Tibirita', 'CO', 'CUN'),
(20169, 48, 794, 'Tocaima', 'CO', 'CUN'),
(20170, 48, 794, 'Tocancipá', 'CO', 'CUN'),
(20171, 48, 794, 'Topaipí', 'CO', 'CUN'),
(20172, 48, 794, 'Ubalá', 'CO', 'CUN'),
(20173, 48, 794, 'Ubaque', 'CO', 'CUN'),
(20174, 48, 794, 'Une', 'CO', 'CUN'),
(20175, 48, 794, 'Útica', 'CO', 'CUN'),
(20176, 48, 794, 'Venecia', 'CO', 'CUN'),
(20177, 48, 794, 'Vergara', 'CO', 'CUN'),
(20178, 48, 794, 'Vianí', 'CO', 'CUN'),
(20179, 48, 794, 'Villa de San Diego de Ubate', 'CO', 'CUN'),
(20180, 48, 794, 'Villagómez', 'CO', 'CUN'),
(20181, 48, 794, 'Villapinzón', 'CO', 'CUN'),
(20182, 48, 794, 'Villeta', 'CO', 'CUN'),
(20183, 48, 794, 'Viotá', 'CO', 'CUN'),
(20184, 48, 794, 'Yacopí', 'CO', 'CUN'),
(20185, 48, 794, 'Zipacón', 'CO', 'CUN'),
(20186, 48, 794, 'Zipaquirá', 'CO', 'CUN'),
(20187, 48, 795, 'Barranco Minas', 'CO', 'GUA'),
(20188, 48, 795, 'Cacahual', 'CO', 'GUA'),
(20189, 48, 795, 'Inírida', 'CO', 'GUA'),
(20190, 48, 795, 'La Guadalupe', 'CO', 'GUA'),
(20191, 48, 795, 'Mapiripana', 'CO', 'GUA'),
(20192, 48, 795, 'Morichal', 'CO', 'GUA'),
(20193, 48, 795, 'Pana Pana', 'CO', 'GUA'),
(20194, 48, 795, 'Puerto Colombia', 'CO', 'GUA'),
(20195, 48, 795, 'San Felipe', 'CO', 'GUA'),
(20196, 48, 796, 'Calamar', 'CO', 'GUV'),
(20197, 48, 796, 'El Retorno', 'CO', 'GUV'),
(20198, 48, 796, 'Miraflores', 'CO', 'GUV'),
(20199, 48, 796, 'San José del Guaviare', 'CO', 'GUV'),
(20200, 48, 797, 'Acevedo', 'CO', 'HUI'),
(20201, 48, 797, 'Aipe', 'CO', 'HUI'),
(20202, 48, 797, 'Algeciras', 'CO', 'HUI'),
(20203, 48, 797, 'Altamira', 'CO', 'HUI'),
(20204, 48, 797, 'Baraya', 'CO', 'HUI'),
(20205, 48, 797, 'Campoalegre', 'CO', 'HUI'),
(20206, 48, 797, 'Colombia', 'CO', 'HUI'),
(20207, 48, 797, 'El Agrado', 'CO', 'HUI'),
(20208, 48, 797, 'Elias', 'CO', 'HUI'),
(20209, 48, 797, 'Garzón', 'CO', 'HUI'),
(20210, 48, 797, 'Gigante', 'CO', 'HUI'),
(20211, 48, 797, 'Guadalupe', 'CO', 'HUI'),
(20212, 48, 797, 'Hobo', 'CO', 'HUI'),
(20213, 48, 797, 'Iquira', 'CO', 'HUI'),
(20214, 48, 797, 'Isnos', 'CO', 'HUI'),
(20215, 48, 797, 'La Argentina', 'CO', 'HUI'),
(20216, 48, 797, 'La Plata', 'CO', 'HUI'),
(20217, 48, 797, 'Nataga', 'CO', 'HUI'),
(20218, 48, 797, 'Neiva', 'CO', 'HUI'),
(20219, 48, 797, 'Oporapa', 'CO', 'HUI'),
(20220, 48, 797, 'Paicol', 'CO', 'HUI'),
(20221, 48, 797, 'Palermo', 'CO', 'HUI'),
(20222, 48, 797, 'Palestina', 'CO', 'HUI'),
(20223, 48, 797, 'Pital', 'CO', 'HUI'),
(20224, 48, 797, 'Pitalito', 'CO', 'HUI'),
(20225, 48, 797, 'Rivera', 'CO', 'HUI'),
(20226, 48, 797, 'Saladoblanco', 'CO', 'HUI'),
(20227, 48, 797, 'San Agustín', 'CO', 'HUI'),
(20228, 48, 797, 'Santa María', 'CO', 'HUI'),
(20229, 48, 797, 'Suaza', 'CO', 'HUI'),
(20230, 48, 797, 'Tarqui', 'CO', 'HUI'),
(20231, 48, 797, 'Tello', 'CO', 'HUI'),
(20232, 48, 797, 'Teruel', 'CO', 'HUI'),
(20233, 48, 797, 'Tesalia', 'CO', 'HUI'),
(20234, 48, 797, 'Timana', 'CO', 'HUI'),
(20235, 48, 797, 'Villavieja', 'CO', 'HUI'),
(20236, 48, 797, 'Yaguará', 'CO', 'HUI'),
(20237, 48, 798, 'Albania', 'CO', 'LAG'),
(20238, 48, 798, 'Barrancas', 'CO', 'LAG'),
(20239, 48, 798, 'Dibulla', 'CO', 'LAG'),
(20240, 48, 798, 'Distracción', 'CO', 'LAG'),
(20241, 48, 798, 'El Molino', 'CO', 'LAG'),
(20242, 48, 798, 'Fonseca', 'CO', 'LAG'),
(20243, 48, 798, 'Hatonuevo', 'CO', 'LAG'),
(20244, 48, 798, 'La Jagua del Pilar', 'CO', 'LAG'),
(20245, 48, 798, 'Maicao', 'CO', 'LAG'),
(20246, 48, 798, 'Manaure', 'CO', 'LAG'),
(20247, 48, 798, 'Riohacha', 'CO', 'LAG'),
(20248, 48, 798, 'San Juan del Cesar', 'CO', 'LAG'),
(20249, 48, 798, 'Uribia', 'CO', 'LAG'),
(20250, 48, 798, 'Urumita', 'CO', 'LAG'),
(20251, 48, 798, 'Villanueva', 'CO', 'LAG'),
(20252, 48, 799, 'Algarrobo', 'CO', 'MAG'),
(20253, 48, 799, 'Aracataca', 'CO', 'MAG'),
(20254, 48, 799, 'Ariguaní', 'CO', 'MAG'),
(20255, 48, 799, 'Cerro de San Antonio', 'CO', 'MAG'),
(20256, 48, 799, 'Chivolo', 'CO', 'MAG'),
(20257, 48, 799, 'Ciénaga', 'CO', 'MAG'),
(20258, 48, 799, 'Concordia', 'CO', 'MAG'),
(20259, 48, 799, 'El Banco', 'CO', 'MAG'),
(20260, 48, 799, 'El Piñon', 'CO', 'MAG'),
(20261, 48, 799, 'El Retén', 'CO', 'MAG'),
(20262, 48, 799, 'Fundación', 'CO', 'MAG'),
(20263, 48, 799, 'Guamal', 'CO', 'MAG'),
(20264, 48, 799, 'Nueva Granada', 'CO', 'MAG'),
(20265, 48, 799, 'Pedraza', 'CO', 'MAG'),
(20266, 48, 799, 'Pijiño del Carmen', 'CO', 'MAG'),
(20267, 48, 799, 'Pivijay', 'CO', 'MAG'),
(20268, 48, 799, 'Plato', 'CO', 'MAG'),
(20269, 48, 799, 'Puebloviejo', 'CO', 'MAG'),
(20270, 48, 799, 'Remolino', 'CO', 'MAG'),
(20271, 48, 799, 'Sabanas de San Angel', 'CO', 'MAG'),
(20272, 48, 799, 'Salamina', 'CO', 'MAG'),
(20273, 48, 799, 'San Sebastián de Buenavista', 'CO', 'MAG'),
(20274, 48, 799, 'San Zenón', 'CO', 'MAG'),
(20275, 48, 799, 'Santa Ana', 'CO', 'MAG'),
(20276, 48, 799, 'Santa Bárbara de Pinto', 'CO', 'MAG'),
(20277, 48, 799, 'Santa Marta', 'CO', 'MAG'),
(20278, 48, 799, 'Sitionuevo', 'CO', 'MAG'),
(20279, 48, 799, 'Tenerife', 'CO', 'MAG'),
(20280, 48, 799, 'Zapayán', 'CO', 'MAG'),
(20281, 48, 799, 'Zona Bananera', 'CO', 'MAG'),
(20282, 48, 800, 'Acacías', 'CO', 'MET'),
(20283, 48, 800, 'Barranca de Upía', 'CO', 'MET'),
(20284, 48, 800, 'Cabuyaro', 'CO', 'MET'),
(20285, 48, 800, 'Castilla la Nueva', 'CO', 'MET'),
(20286, 48, 800, 'Cubarral', 'CO', 'MET'),
(20287, 48, 800, 'Cumaral', 'CO', 'MET'),
(20288, 48, 800, 'El Calvario', 'CO', 'MET'),
(20289, 48, 800, 'El Castillo', 'CO', 'MET'),
(20290, 48, 800, 'El Dorado', 'CO', 'MET'),
(20291, 48, 800, 'Fuente de Oro', 'CO', 'MET'),
(20292, 48, 800, 'Granada', 'CO', 'MET'),
(20293, 48, 800, 'Guamal', 'CO', 'MET'),
(20294, 48, 800, 'La Macarena', 'CO', 'MET'),
(20295, 48, 800, 'Lejanías', 'CO', 'MET'),
(20296, 48, 800, 'Mapiripán', 'CO', 'MET'),
(20297, 48, 800, 'Mesetas', 'CO', 'MET'),
(20298, 48, 800, 'Puerto Concordia', 'CO', 'MET'),
(20299, 48, 800, 'Puerto Gaitán', 'CO', 'MET'),
(20300, 48, 800, 'Puerto Lleras', 'CO', 'MET'),
(20301, 48, 800, 'Puerto López', 'CO', 'MET'),
(20302, 48, 800, 'Puerto Rico', 'CO', 'MET'),
(20303, 48, 800, 'Restrepo', 'CO', 'MET'),
(20304, 48, 800, 'San Carlos de Guaroa', 'CO', 'MET'),
(20305, 48, 800, 'San Juan de Arama', 'CO', 'MET'),
(20306, 48, 800, 'San Juanito', 'CO', 'MET'),
(20307, 48, 800, 'San Martín', 'CO', 'MET'),
(20308, 48, 800, 'Uribe', 'CO', 'MET'),
(20309, 48, 800, 'Villavicencio', 'CO', 'MET'),
(20310, 48, 800, 'Vistahermosa', 'CO', 'MET'),
(20311, 48, 801, 'Aldana', 'CO', 'NAR'),
(20312, 48, 801, 'Ancuya', 'CO', 'NAR'),
(20313, 48, 801, 'Arboleda', 'CO', 'NAR'),
(20314, 48, 801, 'Barbacoas', 'CO', 'NAR'),
(20315, 48, 801, 'Belén', 'CO', 'NAR'),
(20316, 48, 801, 'Buesaco', 'CO', 'NAR'),
(20317, 48, 801, 'Chachagüí', 'CO', 'NAR'),
(20318, 48, 801, 'Colón', 'CO', 'NAR'),
(20319, 48, 801, 'Consaca', 'CO', 'NAR'),
(20320, 48, 801, 'Contadero', 'CO', 'NAR'),
(20321, 48, 801, 'Córdoba', 'CO', 'NAR'),
(20322, 48, 801, 'Cuaspud', 'CO', 'NAR'),
(20323, 48, 801, 'Cumbal', 'CO', 'NAR'),
(20324, 48, 801, 'Cumbitara', 'CO', 'NAR'),
(20325, 48, 801, 'El Charco', 'CO', 'NAR'),
(20326, 48, 801, 'El Peñol', 'CO', 'NAR'),
(20327, 48, 801, 'El Rosario', 'CO', 'NAR'),
(20328, 48, 801, 'El Tablón de Gómez', 'CO', 'NAR'),
(20329, 48, 801, 'El Tambo', 'CO', 'NAR'),
(20330, 48, 801, 'Francisco Pizarro', 'CO', 'NAR'),
(20331, 48, 801, 'Funes', 'CO', 'NAR'),
(20332, 48, 801, 'Guachucal', 'CO', 'NAR'),
(20333, 48, 801, 'Guaitarilla', 'CO', 'NAR'),
(20334, 48, 801, 'Gualmatán', 'CO', 'NAR'),
(20335, 48, 801, 'Iles', 'CO', 'NAR'),
(20336, 48, 801, 'Imués', 'CO', 'NAR'),
(20337, 48, 801, 'Ipiales', 'CO', 'NAR'),
(20338, 48, 801, 'La Cruz', 'CO', 'NAR'),
(20339, 48, 801, 'La Florida', 'CO', 'NAR'),
(20340, 48, 801, 'La Llanada', 'CO', 'NAR'),
(20341, 48, 801, 'La Tola', 'CO', 'NAR'),
(20342, 48, 801, 'La Unión', 'CO', 'NAR'),
(20343, 48, 801, 'Leiva', 'CO', 'NAR'),
(20344, 48, 801, 'Linares', 'CO', 'NAR'),
(20345, 48, 801, 'Los Andes', 'CO', 'NAR'),
(20346, 48, 801, 'Magüí Payán', 'CO', 'NAR'),
(20347, 48, 801, 'Mallama', 'CO', 'NAR'),
(20348, 48, 801, 'Mosquera', 'CO', 'NAR'),
(20349, 48, 801, 'Nariño', 'CO', 'NAR'),
(20350, 48, 801, 'Olaya Herrera', 'CO', 'NAR'),
(20351, 48, 801, 'Ospina', 'CO', 'NAR'),
(20352, 48, 801, 'Pasto', 'CO', 'NAR'),
(20353, 48, 801, 'Policarpa', 'CO', 'NAR'),
(20354, 48, 801, 'Potosí', 'CO', 'NAR'),
(20355, 48, 801, 'Providencia', 'CO', 'NAR'),
(20356, 48, 801, 'Puerres', 'CO', 'NAR'),
(20357, 48, 801, 'Pupiales', 'CO', 'NAR'),
(20358, 48, 801, 'Ricaurte', 'CO', 'NAR'),
(20359, 48, 801, 'Roberto Payán', 'CO', 'NAR'),
(20360, 48, 801, 'Samaniego', 'CO', 'NAR'),
(20361, 48, 801, 'San Bernardo', 'CO', 'NAR'),
(20362, 48, 801, 'San José de Albán', 'CO', 'NAR'),
(20363, 48, 801, 'San Lorenzo', 'CO', 'NAR'),
(20364, 48, 801, 'San Pablo', 'CO', 'NAR'),
(20365, 48, 801, 'San Pedro de Cartago', 'CO', 'NAR'),
(20366, 48, 801, 'Sandoná', 'CO', 'NAR'),
(20367, 48, 801, 'Santa Bárbara', 'CO', 'NAR'),
(20368, 48, 801, 'Santacruz', 'CO', 'NAR'),
(20369, 48, 801, 'Sapuyes', 'CO', 'NAR'),
(20370, 48, 801, 'Taminango', 'CO', 'NAR'),
(20371, 48, 801, 'Tangua', 'CO', 'NAR'),
(20372, 48, 801, 'Tumaco', 'CO', 'NAR'),
(20373, 48, 801, 'Túquerres', 'CO', 'NAR'),
(20374, 48, 801, 'Yacuanquer', 'CO', 'NAR'),
(20375, 48, 802, 'Abrego', 'CO', 'NSA'),
(20376, 48, 802, 'Arboledas', 'CO', 'NSA'),
(20377, 48, 802, 'Bochalema', 'CO', 'NSA'),
(20378, 48, 802, 'Bucarasica', 'CO', 'NSA'),
(20379, 48, 802, 'Cachirá', 'CO', 'NSA'),
(20380, 48, 802, 'Cácota', 'CO', 'NSA'),
(20381, 48, 802, 'Chinácota', 'CO', 'NSA'),
(20382, 48, 802, 'Chitagá', 'CO', 'NSA'),
(20383, 48, 802, 'Convención', 'CO', 'NSA'),
(20384, 48, 802, 'Cúcuta', 'CO', 'NSA'),
(20385, 48, 802, 'Cucutilla', 'CO', 'NSA'),
(20386, 48, 802, 'Durania', 'CO', 'NSA'),
(20387, 48, 802, 'El Carmen', 'CO', 'NSA'),
(20388, 48, 802, 'El Tarra', 'CO', 'NSA'),
(20389, 48, 802, 'El Zulia', 'CO', 'NSA'),
(20390, 48, 802, 'Gramalote', 'CO', 'NSA'),
(20391, 48, 802, 'Hacarí', 'CO', 'NSA'),
(20392, 48, 802, 'Herrán', 'CO', 'NSA'),
(20393, 48, 802, 'La Esperanza', 'CO', 'NSA'),
(20394, 48, 802, 'La Playa', 'CO', 'NSA'),
(20395, 48, 802, 'Labateca', 'CO', 'NSA'),
(20396, 48, 802, 'Los Patios', 'CO', 'NSA'),
(20397, 48, 802, 'Lourdes', 'CO', 'NSA'),
(20398, 48, 802, 'Mutiscua', 'CO', 'NSA'),
(20399, 48, 802, 'Ocaña', 'CO', 'NSA'),
(20400, 48, 802, 'Pamplona', 'CO', 'NSA'),
(20401, 48, 802, 'Pamplonita', 'CO', 'NSA'),
(20402, 48, 802, 'Puerto Santander', 'CO', 'NSA'),
(20403, 48, 802, 'Ragonvalia', 'CO', 'NSA'),
(20404, 48, 802, 'Salazar', 'CO', 'NSA'),
(20405, 48, 802, 'San Calixto', 'CO', 'NSA'),
(20406, 48, 802, 'San Cayetano', 'CO', 'NSA'),
(20407, 48, 802, 'Santiago', 'CO', 'NSA'),
(20408, 48, 802, 'Sardinata', 'CO', 'NSA'),
(20409, 48, 802, 'Silos', 'CO', 'NSA'),
(20410, 48, 802, 'Teorama', 'CO', 'NSA'),
(20411, 48, 802, 'Tibú', 'CO', 'NSA'),
(20412, 48, 802, 'Toledo', 'CO', 'NSA'),
(20413, 48, 802, 'Villa Caro', 'CO', 'NSA'),
(20414, 48, 802, 'Villa del Rosario', 'CO', 'NSA'),
(20415, 48, 803, 'Colón', 'CO', 'PUT'),
(20416, 48, 803, 'Mocoa', 'CO', 'PUT'),
(20417, 48, 803, 'Orito', 'CO', 'PUT'),
(20418, 48, 803, 'Puerto Asís', 'CO', 'PUT'),
(20419, 48, 803, 'Puerto Caicedo', 'CO', 'PUT'),
(20420, 48, 803, 'Puerto Guzmán', 'CO', 'PUT'),
(20421, 48, 803, 'Puerto Leguízamo', 'CO', 'PUT'),
(20422, 48, 803, 'San Francisco', 'CO', 'PUT'),
(20423, 48, 803, 'San Miguel', 'CO', 'PUT'),
(20424, 48, 803, 'Santiago', 'CO', 'PUT'),
(20425, 48, 803, 'Sibundoy', 'CO', 'PUT'),
(20426, 48, 803, 'Valle del Guamuez', 'CO', 'PUT'),
(20427, 48, 803, 'Villagarzón', 'CO', 'PUT'),
(20428, 48, 804, 'Armenia', 'CO', 'QUI'),
(20429, 48, 804, 'Buenavista', 'CO', 'QUI'),
(20430, 48, 804, 'Calarca', 'CO', 'QUI'),
(20431, 48, 804, 'Circasia', 'CO', 'QUI'),
(20432, 48, 804, 'Córdoba', 'CO', 'QUI'),
(20433, 48, 804, 'Filandia', 'CO', 'QUI'),
(20434, 48, 804, 'Génova', 'CO', 'QUI'),
(20435, 48, 804, 'La Tebaida', 'CO', 'QUI'),
(20436, 48, 804, 'Montenegro', 'CO', 'QUI'),
(20437, 48, 804, 'Pijao', 'CO', 'QUI'),
(20438, 48, 804, 'Quimbaya', 'CO', 'QUI'),
(20439, 48, 804, 'Salento', 'CO', 'QUI'),
(20440, 48, 805, 'Apía', 'CO', 'RIS'),
(20441, 48, 805, 'Balboa', 'CO', 'RIS'),
(20442, 48, 805, 'Belén de Umbría', 'CO', 'RIS'),
(20443, 48, 805, 'Dosquebradas', 'CO', 'RIS'),
(20444, 48, 805, 'Guática', 'CO', 'RIS'),
(20445, 48, 805, 'La Celia', 'CO', 'RIS'),
(20446, 48, 805, 'La Virginia', 'CO', 'RIS'),
(20447, 48, 805, 'Marsella', 'CO', 'RIS'),
(20448, 48, 805, 'Mistrató', 'CO', 'RIS'),
(20449, 48, 805, 'Pereira', 'CO', 'RIS'),
(20450, 48, 805, 'Pueblo Rico', 'CO', 'RIS'),
(20451, 48, 805, 'Quinchía', 'CO', 'RIS'),
(20452, 48, 805, 'Santa Rosa de Cabal', 'CO', 'RIS'),
(20453, 48, 805, 'Santuario', 'CO', 'RIS'),
(20454, 48, 806, 'Aguada', 'CO', 'SAN'),
(20455, 48, 806, 'Albania', 'CO', 'SAN'),
(20456, 48, 806, 'Aratoca', 'CO', 'SAN'),
(20457, 48, 806, 'Barbosa', 'CO', 'SAN'),
(20458, 48, 806, 'Barichara', 'CO', 'SAN'),
(20459, 48, 806, 'Barrancabermeja', 'CO', 'SAN'),
(20460, 48, 806, 'Betulia', 'CO', 'SAN'),
(20461, 48, 806, 'Bolívar', 'CO', 'SAN'),
(20462, 48, 806, 'Bucaramanga', 'CO', 'SAN'),
(20463, 48, 806, 'Cabrera', 'CO', 'SAN'),
(20464, 48, 806, 'California', 'CO', 'SAN'),
(20465, 48, 806, 'Capitanejo', 'CO', 'SAN'),
(20466, 48, 806, 'Carcasí', 'CO', 'SAN'),
(20467, 48, 806, 'Cepitá', 'CO', 'SAN'),
(20468, 48, 806, 'Cerrito', 'CO', 'SAN'),
(20469, 48, 806, 'Charalá', 'CO', 'SAN'),
(20470, 48, 806, 'Charta', 'CO', 'SAN'),
(20471, 48, 806, 'Chima', 'CO', 'SAN'),
(20472, 48, 806, 'Chipatá', 'CO', 'SAN'),
(20473, 48, 806, 'Cimitarra', 'CO', 'SAN'),
(20474, 48, 806, 'Concepción', 'CO', 'SAN'),
(20475, 48, 806, 'Confines', 'CO', 'SAN'),
(20476, 48, 806, 'Contratación', 'CO', 'SAN'),
(20477, 48, 806, 'Coromoro', 'CO', 'SAN'),
(20478, 48, 806, 'Curití', 'CO', 'SAN'),
(20479, 48, 806, 'El Carmen de Chucurí', 'CO', 'SAN'),
(20480, 48, 806, 'El Guacamayo', 'CO', 'SAN'),
(20481, 48, 806, 'El Peñón', 'CO', 'SAN'),
(20482, 48, 806, 'El Playón', 'CO', 'SAN'),
(20483, 48, 806, 'Encino', 'CO', 'SAN'),
(20484, 48, 806, 'Enciso', 'CO', 'SAN'),
(20485, 48, 806, 'Florián', 'CO', 'SAN'),
(20486, 48, 806, 'Floridablanca', 'CO', 'SAN'),
(20487, 48, 806, 'Galán', 'CO', 'SAN'),
(20488, 48, 806, 'Gambita', 'CO', 'SAN'),
(20489, 48, 806, 'Girón', 'CO', 'SAN'),
(20490, 48, 806, 'Guaca', 'CO', 'SAN'),
(20491, 48, 806, 'Guadalupe', 'CO', 'SAN'),
(20492, 48, 806, 'Guapotá', 'CO', 'SAN'),
(20493, 48, 806, 'Guavatá', 'CO', 'SAN'),
(20494, 48, 806, 'Güepsa', 'CO', 'SAN'),
(20495, 48, 806, 'Hato', 'CO', 'SAN'),
(20496, 48, 806, 'Jesús María', 'CO', 'SAN'),
(20497, 48, 806, 'Jordán', 'CO', 'SAN'),
(20498, 48, 806, 'La Belleza', 'CO', 'SAN'),
(20499, 48, 806, 'La Paz', 'CO', 'SAN'),
(20500, 48, 806, 'Landázuri', 'CO', 'SAN');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(20501, 48, 806, 'Lebrija', 'CO', 'SAN'),
(20502, 48, 806, 'Los Santos', 'CO', 'SAN'),
(20503, 48, 806, 'Macaravita', 'CO', 'SAN'),
(20504, 48, 806, 'Málaga', 'CO', 'SAN'),
(20505, 48, 806, 'Matanza', 'CO', 'SAN'),
(20506, 48, 806, 'Mogotes', 'CO', 'SAN'),
(20507, 48, 806, 'Molagavita', 'CO', 'SAN'),
(20508, 48, 806, 'Ocamonte', 'CO', 'SAN'),
(20509, 48, 806, 'Oiba', 'CO', 'SAN'),
(20510, 48, 806, 'Onzaga', 'CO', 'SAN'),
(20511, 48, 806, 'Palmar', 'CO', 'SAN'),
(20512, 48, 806, 'Palmas del Socorro', 'CO', 'SAN'),
(20513, 48, 806, 'Páramo', 'CO', 'SAN'),
(20514, 48, 806, 'Piedecuesta', 'CO', 'SAN'),
(20515, 48, 806, 'Pinchote', 'CO', 'SAN'),
(20516, 48, 806, 'Puente Nacional', 'CO', 'SAN'),
(20517, 48, 806, 'Puerto Parra', 'CO', 'SAN'),
(20518, 48, 806, 'Puerto Wilches', 'CO', 'SAN'),
(20519, 48, 806, 'Rionegro', 'CO', 'SAN'),
(20520, 48, 806, 'Sabana de Torres', 'CO', 'SAN'),
(20521, 48, 806, 'San Andrés', 'CO', 'SAN'),
(20522, 48, 806, 'San Benito', 'CO', 'SAN'),
(20523, 48, 806, 'San Gil', 'CO', 'SAN'),
(20524, 48, 806, 'San Joaquín', 'CO', 'SAN'),
(20525, 48, 806, 'San José de Miranda', 'CO', 'SAN'),
(20526, 48, 806, 'San Miguel', 'CO', 'SAN'),
(20527, 48, 806, 'San Vicente de Chucurí', 'CO', 'SAN'),
(20528, 48, 806, 'Santa Bárbara', 'CO', 'SAN'),
(20529, 48, 806, 'Santa Helena Del Opón', 'CO', 'SAN'),
(20530, 48, 806, 'Simacota', 'CO', 'SAN'),
(20531, 48, 806, 'Socorro', 'CO', 'SAN'),
(20532, 48, 806, 'Suaita', 'CO', 'SAN'),
(20533, 48, 806, 'Sucre', 'CO', 'SAN'),
(20534, 48, 806, 'Suratá', 'CO', 'SAN'),
(20535, 48, 806, 'Tona', 'CO', 'SAN'),
(20536, 48, 806, 'Valle de San José', 'CO', 'SAN'),
(20537, 48, 806, 'Vélez', 'CO', 'SAN'),
(20538, 48, 806, 'Vetas', 'CO', 'SAN'),
(20539, 48, 806, 'Villanueva', 'CO', 'SAN'),
(20540, 48, 806, 'Zapatoca', 'CO', 'SAN'),
(20541, 48, 807, 'Buenavista', 'CO', 'SUC'),
(20542, 48, 807, 'Caimito', 'CO', 'SUC'),
(20543, 48, 807, 'Chalán', 'CO', 'SUC'),
(20544, 48, 807, 'Coloso', 'CO', 'SUC'),
(20545, 48, 807, 'Corozal', 'CO', 'SUC'),
(20546, 48, 807, 'Coveñas', 'CO', 'SUC'),
(20547, 48, 807, 'El Roble', 'CO', 'SUC'),
(20548, 48, 807, 'Galeras', 'CO', 'SUC'),
(20549, 48, 807, 'Guaranda', 'CO', 'SUC'),
(20550, 48, 807, 'La Unión', 'CO', 'SUC'),
(20551, 48, 807, 'Los Palmitos', 'CO', 'SUC'),
(20552, 48, 807, 'Majagual', 'CO', 'SUC'),
(20553, 48, 807, 'Morroa', 'CO', 'SUC'),
(20554, 48, 807, 'Ovejas', 'CO', 'SUC'),
(20555, 48, 807, 'Palmito', 'CO', 'SUC'),
(20556, 48, 807, 'Sampués', 'CO', 'SUC'),
(20557, 48, 807, 'San Benito Abad', 'CO', 'SUC'),
(20558, 48, 807, 'San Juan de Betulia', 'CO', 'SUC'),
(20559, 48, 807, 'San Luis de Sincé', 'CO', 'SUC'),
(20560, 48, 807, 'San Marcos', 'CO', 'SUC'),
(20561, 48, 807, 'San Onofre', 'CO', 'SUC'),
(20562, 48, 807, 'San Pedro', 'CO', 'SUC'),
(20563, 48, 807, 'Santiago de Tolú', 'CO', 'SUC'),
(20564, 48, 807, 'Sincelejo', 'CO', 'SUC'),
(20565, 48, 807, 'Sucre', 'CO', 'SUC'),
(20566, 48, 807, 'Tolú Viejo', 'CO', 'SUC'),
(20567, 48, 808, 'Alpujarra', 'CO', 'TOL'),
(20568, 48, 808, 'Alvarado', 'CO', 'TOL'),
(20569, 48, 808, 'Ambalema', 'CO', 'TOL'),
(20570, 48, 808, 'Anzoátegui', 'CO', 'TOL'),
(20571, 48, 808, 'Armero', 'CO', 'TOL'),
(20572, 48, 808, 'Ataco', 'CO', 'TOL'),
(20573, 48, 808, 'Cajamarca', 'CO', 'TOL'),
(20574, 48, 808, 'Carmen de Apicalá', 'CO', 'TOL'),
(20575, 48, 808, 'Casabianca', 'CO', 'TOL'),
(20576, 48, 808, 'Chaparral', 'CO', 'TOL'),
(20577, 48, 808, 'Coello', 'CO', 'TOL'),
(20578, 48, 808, 'Coyaima', 'CO', 'TOL'),
(20579, 48, 808, 'Cunday', 'CO', 'TOL'),
(20580, 48, 808, 'Dolores', 'CO', 'TOL'),
(20581, 48, 808, 'Espinal', 'CO', 'TOL'),
(20582, 48, 808, 'Falan', 'CO', 'TOL'),
(20583, 48, 808, 'Flandes', 'CO', 'TOL'),
(20584, 48, 808, 'Fresno', 'CO', 'TOL'),
(20585, 48, 808, 'Guamo', 'CO', 'TOL'),
(20586, 48, 808, 'Herveo', 'CO', 'TOL'),
(20587, 48, 808, 'Honda', 'CO', 'TOL'),
(20588, 48, 808, 'Ibagué', 'CO', 'TOL'),
(20589, 48, 808, 'Icononzo', 'CO', 'TOL'),
(20590, 48, 808, 'Lérida', 'CO', 'TOL'),
(20591, 48, 808, 'Líbano', 'CO', 'TOL'),
(20592, 48, 808, 'Melgar', 'CO', 'TOL'),
(20593, 48, 808, 'Murillo', 'CO', 'TOL'),
(20594, 48, 808, 'Natagaima', 'CO', 'TOL'),
(20595, 48, 808, 'Ortega', 'CO', 'TOL'),
(20596, 48, 808, 'Palocabildo', 'CO', 'TOL'),
(20597, 48, 808, 'Piedras', 'CO', 'TOL'),
(20598, 48, 808, 'Planadas', 'CO', 'TOL'),
(20599, 48, 808, 'Prado', 'CO', 'TOL'),
(20600, 48, 808, 'Purificación', 'CO', 'TOL'),
(20601, 48, 808, 'Rioblanco', 'CO', 'TOL'),
(20602, 48, 808, 'Roncesvalles', 'CO', 'TOL'),
(20603, 48, 808, 'Rovira', 'CO', 'TOL'),
(20604, 48, 808, 'Saldaña', 'CO', 'TOL'),
(20605, 48, 808, 'San Antonio', 'CO', 'TOL'),
(20606, 48, 808, 'San Luis', 'CO', 'TOL'),
(20607, 48, 808, 'San Sebastián de Mariquita', 'CO', 'TOL'),
(20608, 48, 808, 'Santa Isabel', 'CO', 'TOL'),
(20609, 48, 808, 'Suárez', 'CO', 'TOL'),
(20610, 48, 808, 'Valle de San Juan', 'CO', 'TOL'),
(20611, 48, 808, 'Venadillo', 'CO', 'TOL'),
(20612, 48, 808, 'Villahermosa', 'CO', 'TOL'),
(20613, 48, 808, 'Villarrica', 'CO', 'TOL'),
(20614, 48, 809, 'Alcalá', 'CO', 'VAC'),
(20615, 48, 809, 'Andalucía', 'CO', 'VAC'),
(20616, 48, 809, 'Ansermanuevo', 'CO', 'VAC'),
(20617, 48, 809, 'Argelia', 'CO', 'VAC'),
(20618, 48, 809, 'Bolívar', 'CO', 'VAC'),
(20619, 48, 809, 'Buenaventura', 'CO', 'VAC'),
(20620, 48, 809, 'Bugalagrande', 'CO', 'VAC'),
(20621, 48, 809, 'Caicedonia', 'CO', 'VAC'),
(20622, 48, 809, 'Cali', 'CO', 'VAC'),
(20623, 48, 809, 'Calima', 'CO', 'VAC'),
(20624, 48, 809, 'Candelaria', 'CO', 'VAC'),
(20625, 48, 809, 'Cartago', 'CO', 'VAC'),
(20626, 48, 809, 'Dagua', 'CO', 'VAC'),
(20627, 48, 809, 'El Águila', 'CO', 'VAC'),
(20628, 48, 809, 'El Cairo', 'CO', 'VAC'),
(20629, 48, 809, 'El Cerrito', 'CO', 'VAC'),
(20630, 48, 809, 'El Dovio', 'CO', 'VAC'),
(20631, 48, 809, 'Florida', 'CO', 'VAC'),
(20632, 48, 809, 'Ginebra', 'CO', 'VAC'),
(20633, 48, 809, 'Guacarí', 'CO', 'VAC'),
(20634, 48, 809, 'Guadalajara de Buga', 'CO', 'VAC'),
(20635, 48, 809, 'Jamundí', 'CO', 'VAC'),
(20636, 48, 809, 'La Cumbre', 'CO', 'VAC'),
(20637, 48, 809, 'La Unión', 'CO', 'VAC'),
(20638, 48, 809, 'La Victoria', 'CO', 'VAC'),
(20639, 48, 809, 'Obando', 'CO', 'VAC'),
(20640, 48, 809, 'Palmira', 'CO', 'VAC'),
(20641, 48, 809, 'Pradera', 'CO', 'VAC'),
(20642, 48, 809, 'Restrepo', 'CO', 'VAC'),
(20643, 48, 809, 'Riofrío', 'CO', 'VAC'),
(20644, 48, 809, 'Roldanillo', 'CO', 'VAC'),
(20645, 48, 809, 'San Pedro', 'CO', 'VAC'),
(20646, 48, 809, 'Sevilla', 'CO', 'VAC'),
(20647, 48, 809, 'Toro', 'CO', 'VAC'),
(20648, 48, 809, 'Trujillo', 'CO', 'VAC'),
(20649, 48, 809, 'Tuluá', 'CO', 'VAC'),
(20650, 48, 809, 'Ulloa', 'CO', 'VAC'),
(20651, 48, 809, 'Versalles', 'CO', 'VAC'),
(20652, 48, 809, 'Vijes', 'CO', 'VAC'),
(20653, 48, 809, 'Yotoco', 'CO', 'VAC'),
(20654, 48, 809, 'Yumbo', 'CO', 'VAC'),
(20655, 48, 809, 'Zarzal', 'CO', 'VAC'),
(20656, 48, 810, 'Caruru', 'CO', 'VAU'),
(20657, 48, 810, 'Mitú', 'CO', 'VAU'),
(20658, 48, 810, 'Pacoa', 'CO', 'VAU'),
(20659, 48, 810, 'Papunaua', 'CO', 'VAU'),
(20660, 48, 810, 'Taraira', 'CO', 'VAU'),
(20661, 48, 810, 'Yavaraté', 'CO', 'VAU'),
(20662, 48, 811, 'Cumaribo', 'CO', 'VID'),
(20663, 48, 811, 'La Primavera', 'CO', 'VID'),
(20664, 48, 811, 'Puerto Carreño', 'CO', 'VID'),
(20665, 48, 811, 'Santa Rosalia', 'CO', 'VID'),
(20666, 49, 812, 'Adda-Douéni', 'KM', 'A'),
(20667, 49, 812, 'Antsahé', 'KM', 'A'),
(20668, 49, 812, 'Assimpao', 'KM', 'A'),
(20669, 49, 812, 'Bambao', 'KM', 'A'),
(20670, 49, 812, 'Bandajou', 'KM', 'A'),
(20671, 49, 812, 'Barakani', 'KM', 'A'),
(20672, 49, 812, 'Bimbini', 'KM', 'A'),
(20673, 49, 812, 'Boungouéni', 'KM', 'A'),
(20674, 49, 812, 'Chandra', 'KM', 'A'),
(20675, 49, 812, 'Chironkamba', 'KM', 'A'),
(20676, 49, 812, 'Chitrouni', 'KM', 'A'),
(20677, 49, 812, 'Daji', 'KM', 'A'),
(20678, 49, 812, 'Domoni', 'KM', 'A'),
(20679, 49, 812, 'Dziani', 'KM', 'A'),
(20680, 49, 812, 'Hajoho', 'KM', 'A'),
(20681, 49, 812, 'Harembo', 'KM', 'A'),
(20682, 49, 812, 'Kangani', 'KM', 'A'),
(20683, 49, 812, 'Kavani', 'KM', 'A'),
(20684, 49, 812, 'Koki', 'KM', 'A'),
(20685, 49, 812, 'Koni-Djodjo', 'KM', 'A'),
(20686, 49, 812, 'Koni-Ngani', 'KM', 'A'),
(20687, 49, 812, 'Kyo', 'KM', 'A'),
(20688, 49, 812, 'Limbi', 'KM', 'A'),
(20689, 49, 812, 'Lingoni', 'KM', 'A'),
(20690, 49, 812, 'Magnassini-Nindri', 'KM', 'A'),
(20691, 49, 812, 'Maraharé', 'KM', 'A'),
(20692, 49, 812, 'Mirontsi', 'KM', 'A'),
(20693, 49, 812, 'Mjamaoué', 'KM', 'A'),
(20694, 49, 812, 'Mjimandra', 'KM', 'A'),
(20695, 49, 812, 'Moutsamoudou', 'KM', 'A'),
(20696, 49, 812, 'Moya', 'KM', 'A'),
(20697, 49, 812, 'Mramani', 'KM', 'A'),
(20698, 49, 812, 'Mrémani', 'KM', 'A'),
(20699, 49, 812, 'Ongoni', 'KM', 'A'),
(20700, 49, 812, 'Ouani', 'KM', 'A'),
(20701, 49, 812, 'Ouzini', 'KM', 'A'),
(20702, 49, 812, 'Pajé', 'KM', 'A'),
(20703, 49, 812, 'Patsi', 'KM', 'A'),
(20704, 49, 812, 'Sima', 'KM', 'A'),
(20705, 49, 812, 'Tsimbeo', 'KM', 'A'),
(20706, 49, 812, 'Vouani', 'KM', 'A'),
(20707, 49, 813, 'Bahani', 'KM', 'G'),
(20708, 49, 813, 'Bambadjani', 'KM', 'G'),
(20709, 49, 813, 'Bouni', 'KM', 'G'),
(20710, 49, 813, 'Chezani', 'KM', 'G'),
(20711, 49, 813, 'Chindini', 'KM', 'G'),
(20712, 49, 813, 'Chouani', 'KM', 'G'),
(20713, 49, 813, 'Dembéni', 'KM', 'G'),
(20714, 49, 813, 'Douniani', 'KM', 'G'),
(20715, 49, 813, 'Dzahadjou', 'KM', 'G'),
(20716, 49, 813, 'Foumbouni', 'KM', 'G'),
(20717, 49, 813, 'Hantsindzi', 'KM', 'G'),
(20718, 49, 813, 'Héroumbili', 'KM', 'G'),
(20719, 49, 813, 'Itsandra', 'KM', 'G'),
(20720, 49, 813, 'Itsandzéni', 'KM', 'G'),
(20721, 49, 813, 'Ivouani', 'KM', 'G'),
(20722, 49, 813, 'Koua', 'KM', 'G'),
(20723, 49, 813, 'Madjeouéni', 'KM', 'G'),
(20724, 49, 813, 'Mandza', 'KM', 'G'),
(20725, 49, 813, 'Mavingouni', 'KM', 'G'),
(20726, 49, 813, 'Mbéni', 'KM', 'G'),
(20727, 49, 813, 'Mitsamiouli', 'KM', 'G'),
(20728, 49, 813, 'Mitsoudjé', 'KM', 'G'),
(20729, 49, 813, 'Mnoungou', 'KM', 'G'),
(20730, 49, 813, 'Mohoro', 'KM', 'G'),
(20731, 49, 813, 'Moroni', 'KM', 'G'),
(20732, 49, 813, 'Mtsamdou', 'KM', 'G'),
(20733, 49, 813, 'Mvouni', 'KM', 'G'),
(20734, 49, 813, 'Nioumamilima', 'KM', 'G'),
(20735, 49, 813, 'Ntsaouéni', 'KM', 'G'),
(20736, 49, 813, 'Ntsoudjini', 'KM', 'G'),
(20737, 49, 813, 'Ouellah', 'KM', 'G'),
(20738, 49, 813, 'Ouhozi', 'KM', 'G'),
(20739, 49, 813, 'Ourovéni', 'KM', 'G'),
(20740, 49, 813, 'Oussivo', 'KM', 'G'),
(20741, 49, 813, 'Salimani', 'KM', 'G'),
(20742, 49, 813, 'Séléa', 'KM', 'G'),
(20743, 49, 813, 'Singani', 'KM', 'G'),
(20744, 49, 813, 'Tsidjé', 'KM', 'G'),
(20745, 49, 813, 'Vanadjou', 'KM', 'G'),
(20746, 49, 813, 'Vanambouani', 'KM', 'G'),
(20747, 49, 814, 'Djoyézi', 'KM', 'M'),
(20748, 49, 814, 'Fomboni', 'KM', 'M'),
(20749, 49, 814, 'Hoani', 'KM', 'M'),
(20750, 49, 814, 'Mtakoudja', 'KM', 'M'),
(20751, 49, 814, 'Nioumachoua', 'KM', 'M'),
(20752, 49, 814, 'Ouanani', 'KM', 'M'),
(20753, 49, 814, 'Ziroudani', 'KM', 'M'),
(20754, 50, 815, 'Kayes', 'CG', '11'),
(20755, 50, 815, 'Madingou', 'CG', '11'),
(20756, 50, 816, 'Brazzaville', 'CG', 'BZV'),
(20757, 50, 817, 'Makoua', 'CG', '8'),
(20758, 50, 817, 'Owando', 'CG', '8'),
(20759, 50, 818, 'Ewo', 'CG', '15'),
(20760, 50, 820, 'Sibiti', 'CG', '2'),
(20761, 50, 821, 'Impfondo', 'CG', '7'),
(20762, 50, 822, 'Dolisie', 'CG', '9'),
(20763, 50, 822, 'Mossendjo', 'CG', '9'),
(20764, 50, 823, 'Djambala', 'CG', '14'),
(20765, 50, 823, 'Gamboma', 'CG', '14'),
(20766, 50, 824, 'Loandjili', 'CG', '16'),
(20767, 50, 824, 'Pointe-Noire', 'CG', '16'),
(20768, 50, 825, 'Kinkala', 'CG', '12'),
(20769, 50, 826, 'Ouésso', 'CG', '13'),
(20770, 50, 826, 'Sémbé', 'CG', '13'),
(20771, 52, 827, 'Alajuela', 'CR', 'A'),
(20772, 52, 827, 'Atenas', 'CR', 'A'),
(20773, 52, 827, 'Bijagua', 'CR', 'A'),
(20774, 52, 827, 'Carrillos', 'CR', 'A'),
(20775, 52, 827, 'Desamparados', 'CR', 'A'),
(20776, 52, 827, 'Esquipulas', 'CR', 'A'),
(20777, 52, 827, 'Grecia', 'CR', 'A'),
(20778, 52, 827, 'Guatuso', 'CR', 'A'),
(20779, 52, 827, 'La Fortuna', 'CR', 'A'),
(20780, 52, 827, 'Los Chiles', 'CR', 'A'),
(20781, 52, 827, 'Naranjo', 'CR', 'A'),
(20782, 52, 827, 'Orotina', 'CR', 'A'),
(20783, 52, 827, 'Palmares', 'CR', 'A'),
(20784, 52, 827, 'Pital', 'CR', 'A'),
(20785, 52, 827, 'Poás', 'CR', 'A'),
(20786, 52, 827, 'Pocosol', 'CR', 'A'),
(20787, 52, 827, 'Quesada', 'CR', 'A'),
(20788, 52, 827, 'Río Segundo', 'CR', 'A'),
(20789, 52, 827, 'Sabanilla', 'CR', 'A'),
(20790, 52, 827, 'San Carlos', 'CR', 'A'),
(20791, 52, 827, 'San José', 'CR', 'A'),
(20792, 52, 827, 'San Juan', 'CR', 'A'),
(20793, 52, 827, 'San Mateo', 'CR', 'A'),
(20794, 52, 827, 'San Rafael', 'CR', 'A'),
(20795, 52, 827, 'San Ramón', 'CR', 'A'),
(20796, 52, 827, 'Santiago', 'CR', 'A'),
(20797, 52, 827, 'Upala', 'CR', 'A'),
(20798, 52, 827, 'Valverde Vega', 'CR', 'A'),
(20799, 52, 827, 'Zarcero', 'CR', 'A'),
(20800, 52, 828, 'Abangares', 'CR', 'G'),
(20801, 52, 828, 'Bagaces', 'CR', 'G'),
(20802, 52, 828, 'Belén', 'CR', 'G'),
(20803, 52, 828, 'Cañas', 'CR', 'G'),
(20804, 52, 828, 'Carrillo', 'CR', 'G'),
(20805, 52, 828, 'Fortuna', 'CR', 'G'),
(20806, 52, 828, 'Hojancha', 'CR', 'G'),
(20807, 52, 828, 'Juntas', 'CR', 'G'),
(20808, 52, 828, 'La Cruz', 'CR', 'G'),
(20809, 52, 828, 'Liberia', 'CR', 'G'),
(20810, 52, 828, 'Nandayure', 'CR', 'G'),
(20811, 52, 828, 'Nicoya', 'CR', 'G'),
(20812, 52, 828, 'Sámara', 'CR', 'G'),
(20813, 52, 828, 'Santa Cruz', 'CR', 'G'),
(20814, 52, 828, 'Sardinal', 'CR', 'G'),
(20815, 52, 828, 'Tilarán', 'CR', 'G'),
(20816, 52, 829, 'Ángeles', 'CR', 'H'),
(20817, 52, 829, 'Barva', 'CR', 'H'),
(20818, 52, 829, 'Belén', 'CR', 'H'),
(20819, 52, 829, 'Flores', 'CR', 'H'),
(20820, 52, 829, 'Heredia', 'CR', 'H'),
(20821, 52, 829, 'La Asunción', 'CR', 'H'),
(20822, 52, 829, 'Llorente', 'CR', 'H'),
(20823, 52, 829, 'Mercedes', 'CR', 'H'),
(20824, 52, 829, 'San Antonio', 'CR', 'H'),
(20825, 52, 829, 'San Francisco', 'CR', 'H'),
(20826, 52, 829, 'San Isidro', 'CR', 'H'),
(20827, 52, 829, 'San Josecito', 'CR', 'H'),
(20828, 52, 829, 'San Pablo', 'CR', 'H'),
(20829, 52, 829, 'San Rafael', 'CR', 'H'),
(20830, 52, 829, 'Santa Bárbara', 'CR', 'H'),
(20831, 52, 829, 'Santo Domingo', 'CR', 'H'),
(20832, 52, 829, 'Sarapiquí', 'CR', 'H'),
(20833, 52, 830, 'Batán', 'CR', 'L'),
(20834, 52, 830, 'Guácimo', 'CR', 'L'),
(20835, 52, 830, 'Guápiles', 'CR', 'L'),
(20836, 52, 830, 'Limón', 'CR', 'L'),
(20837, 52, 830, 'Matina', 'CR', 'L'),
(20838, 52, 830, 'Pococí', 'CR', 'L'),
(20839, 52, 830, 'Pocora', 'CR', 'L'),
(20840, 52, 830, 'Roxana', 'CR', 'L'),
(20841, 52, 830, 'Siquirres', 'CR', 'L'),
(20842, 52, 830, 'Sixaola', 'CR', 'L'),
(20843, 52, 830, 'Talamanca', 'CR', 'L'),
(20844, 52, 831, 'Alvarado', 'CR', 'C'),
(20845, 52, 831, 'Cartago', 'CR', 'C'),
(20846, 52, 831, 'Concepción', 'CR', 'C'),
(20847, 52, 831, 'Cot', 'CR', 'C'),
(20848, 52, 831, 'El Guarco', 'CR', 'C'),
(20849, 52, 831, 'Jiménez', 'CR', 'C'),
(20850, 52, 831, 'La Suiza', 'CR', 'C'),
(20851, 52, 831, 'La Unión', 'CR', 'C'),
(20852, 52, 831, 'Oreamuno', 'CR', 'C'),
(20853, 52, 831, 'Orosí', 'CR', 'C'),
(20854, 52, 831, 'Pacayas', 'CR', 'C'),
(20855, 52, 831, 'Paraíso', 'CR', 'C'),
(20856, 52, 831, 'Pejibaye', 'CR', 'C'),
(20857, 52, 831, 'San Diego', 'CR', 'C'),
(20858, 52, 831, 'Tobosi', 'CR', 'C'),
(20859, 52, 831, 'Tres Ríos', 'CR', 'C'),
(20860, 52, 831, 'Tucurrique', 'CR', 'C'),
(20861, 52, 831, 'Turrialba', 'CR', 'C'),
(20862, 52, 832, 'Buenos Aires', 'CR', 'P'),
(20863, 52, 832, 'Canoas', 'CR', 'P'),
(20864, 52, 832, 'Chacarita', 'CR', 'P'),
(20865, 52, 832, 'Ciudad Cortés', 'CR', 'P'),
(20866, 52, 832, 'Corredor', 'CR', 'P'),
(20867, 52, 832, 'Corredores', 'CR', 'P'),
(20868, 52, 832, 'Coto Brus', 'CR', 'P'),
(20869, 52, 832, 'Esparza', 'CR', 'P'),
(20870, 52, 832, 'Garabito', 'CR', 'P'),
(20871, 52, 832, 'Golfito', 'CR', 'P'),
(20872, 52, 832, 'Jacó', 'CR', 'P'),
(20873, 52, 832, 'Miramar', 'CR', 'P'),
(20874, 52, 832, 'Montes de Oro', 'CR', 'P'),
(20875, 52, 832, 'Osa', 'CR', 'P'),
(20876, 52, 832, 'Paquera', 'CR', 'P'),
(20877, 52, 832, 'Parrita', 'CR', 'P'),
(20878, 52, 832, 'Puntarenas', 'CR', 'P'),
(20879, 52, 832, 'Quepos', 'CR', 'P'),
(20880, 52, 832, 'San Vito', 'CR', 'P'),
(20881, 52, 833, 'Acosta', 'CR', 'SJ'),
(20882, 52, 833, 'Alajuelita', 'CR', 'SJ'),
(20883, 52, 833, 'Aserrí', 'CR', 'SJ'),
(20884, 52, 833, 'Calle Blancos', 'CR', 'SJ'),
(20885, 52, 833, 'Colima', 'CR', 'SJ'),
(20886, 52, 833, 'Colón', 'CR', 'SJ'),
(20887, 52, 833, 'Curridabat', 'CR', 'SJ'),
(20888, 52, 833, 'Daniel Flores', 'CR', 'SJ'),
(20889, 52, 833, 'Desamparados', 'CR', 'SJ'),
(20890, 52, 833, 'Dota', 'CR', 'SJ'),
(20891, 52, 833, 'Escazú', 'CR', 'SJ'),
(20892, 52, 833, 'Goicoechea', 'CR', 'SJ'),
(20893, 52, 833, 'Granadilla', 'CR', 'SJ'),
(20894, 52, 833, 'Guadalupe', 'CR', 'SJ'),
(20895, 52, 833, 'Ipís', 'CR', 'SJ'),
(20896, 52, 833, 'León Cortés', 'CR', 'SJ'),
(20897, 52, 833, 'Mercedes', 'CR', 'SJ'),
(20898, 52, 833, 'Montes de Oca', 'CR', 'SJ'),
(20899, 52, 833, 'Mora', 'CR', 'SJ'),
(20900, 52, 833, 'Moravia', 'CR', 'SJ'),
(20901, 52, 833, 'Palmichal', 'CR', 'SJ'),
(20902, 52, 833, 'Patarrá', 'CR', 'SJ'),
(20903, 52, 833, 'Pérez Zeledón', 'CR', 'SJ'),
(20904, 52, 833, 'Puriscal', 'CR', 'SJ'),
(20905, 52, 833, 'Purral', 'CR', 'SJ'),
(20906, 52, 833, 'Sabanilla', 'CR', 'SJ'),
(20907, 52, 833, 'Salitral', 'CR', 'SJ'),
(20908, 52, 833, 'Salitrillos', 'CR', 'SJ'),
(20909, 52, 833, 'San Felipe', 'CR', 'SJ'),
(20910, 52, 833, 'San Ignacio', 'CR', 'SJ'),
(20911, 52, 833, 'San Isidro', 'CR', 'SJ'),
(20912, 52, 833, 'San José', 'CR', 'SJ'),
(20913, 52, 833, 'San Juan', 'CR', 'SJ'),
(20914, 52, 833, 'San Juan de Dios', 'CR', 'SJ'),
(20915, 52, 833, 'San Marcos', 'CR', 'SJ'),
(20916, 52, 833, 'San Miguel', 'CR', 'SJ'),
(20917, 52, 833, 'San Pedro', 'CR', 'SJ'),
(20918, 52, 833, 'San Rafael', 'CR', 'SJ'),
(20919, 52, 833, 'San Rafael Abajo', 'CR', 'SJ'),
(20920, 52, 833, 'San Rafael Arriba', 'CR', 'SJ'),
(20921, 52, 833, 'San Vicente', 'CR', 'SJ'),
(20922, 52, 833, 'San Vicente de Moravia', 'CR', 'SJ'),
(20923, 52, 833, 'Santa Ana', 'CR', 'SJ'),
(20924, 52, 833, 'Santiago', 'CR', 'SJ'),
(20925, 52, 833, 'Tarrazú', 'CR', 'SJ'),
(20926, 52, 833, 'Tejar', 'CR', 'SJ'),
(20927, 52, 833, 'Tibás', 'CR', 'SJ'),
(20928, 52, 833, 'Turrubares', 'CR', 'SJ'),
(20929, 52, 833, 'Vázquez de Coronado', 'CR', 'SJ'),
(20930, 53, 834, 'Abidjan', 'CI', 'AB'),
(20931, 53, 834, 'Abobo', 'CI', 'AB'),
(20932, 53, 834, 'Anyama', 'CI', 'AB'),
(20933, 53, 834, 'Bingerville', 'CI', 'AB'),
(20934, 53, 837, 'Gbôklé', 'CI', 'BS'),
(20935, 53, 837, 'Nawa', 'CI', 'BS'),
(20936, 53, 837, 'San-Pédro', 'CI', 'BS'),
(20937, 53, 837, 'Sassandra', 'CI', 'BS'),
(20938, 53, 837, 'Tabou', 'CI', 'BS'),
(20939, 53, 839, 'Abengourou', 'CI', 'CM'),
(20940, 53, 839, 'Aboisso', 'CI', 'CM'),
(20941, 53, 839, 'Adiaké', 'CI', 'CM'),
(20942, 53, 839, 'Agnibilékrou', 'CI', 'CM'),
(20943, 53, 839, 'Ayamé', 'CI', 'CM'),
(20944, 53, 839, 'Bonoua', 'CI', 'CM'),
(20945, 53, 839, 'Grand-Bassam', 'CI', 'CM'),
(20946, 53, 839, 'Indénié-Djuablin', 'CI', 'CM'),
(20947, 53, 839, 'Sud-Comoé', 'CI', 'CM'),
(20948, 53, 840, 'Folon', 'CI', 'DN'),
(20949, 53, 840, 'Kabadougou', 'CI', 'DN'),
(20950, 53, 840, 'Odienné', 'CI', 'DN'),
(20951, 53, 842, 'Bangolo', 'CI', '06'),
(20952, 53, 842, 'Biankouma', 'CI', '06'),
(20953, 53, 842, 'Cavally', 'CI', '06'),
(20954, 53, 842, 'Danané', 'CI', '06'),
(20955, 53, 842, 'Duekoué', 'CI', '06'),
(20956, 53, 842, 'Guémon', 'CI', '06'),
(20957, 53, 842, 'Guiglo', 'CI', '06'),
(20958, 53, 842, 'Man', 'CI', '06'),
(20959, 53, 842, 'Tonkpi', 'CI', '06'),
(20960, 53, 842, 'Toulépleu Gueré', 'CI', '06'),
(20961, 53, 844, 'Divo', 'CI', 'GD'),
(20962, 53, 844, 'Gagnoa', 'CI', 'GD'),
(20963, 53, 844, 'Gôh', 'CI', 'GD'),
(20964, 53, 844, 'Guibéroua', 'CI', 'GD'),
(20965, 53, 844, 'Lakota', 'CI', 'GD'),
(20966, 53, 844, 'Lôh-Djiboua', 'CI', 'GD'),
(20967, 53, 844, 'Oumé', 'CI', 'GD'),
(20968, 53, 847, 'Arrah', 'CI', '07'),
(20969, 53, 847, 'Bélier', 'CI', '07'),
(20970, 53, 847, 'Bocanda', 'CI', '07'),
(20971, 53, 847, 'Bongouanou', 'CI', '07'),
(20972, 53, 847, 'Daoukro', 'CI', '07'),
(20973, 53, 847, 'Dimbokro', 'CI', '07'),
(20974, 53, 847, 'Iffou', 'CI', '07'),
(20975, 53, 847, 'Moronou', 'CI', '07'),
(20976, 53, 847, 'N\'Zi', 'CI', '07'),
(20977, 53, 847, 'Toumodi', 'CI', '07'),
(20978, 53, 847, 'Yamoussoukro', 'CI', '07'),
(20979, 53, 849, 'Adzopé', 'CI', '01'),
(20980, 53, 849, 'Affery', 'CI', '01'),
(20981, 53, 849, 'Agboville', 'CI', '01'),
(20982, 53, 849, 'Agnéby-Tiassa', 'CI', '01'),
(20983, 53, 849, 'Akoupé', 'CI', '01'),
(20984, 53, 849, 'Dabou', 'CI', '01'),
(20985, 53, 849, 'Grand-Lahou', 'CI', '01'),
(20986, 53, 849, 'Grands-Ponts', 'CI', '01'),
(20987, 53, 849, 'Tiassalé', 'CI', '01'),
(20988, 53, 855, 'Bouaflé', 'CI', 'SM'),
(20989, 53, 855, 'Daloa', 'CI', 'SM'),
(20990, 53, 855, 'Haut-Sassandra', 'CI', 'SM'),
(20991, 53, 855, 'Issia', 'CI', 'SM'),
(20992, 53, 855, 'Marahoué', 'CI', 'SM'),
(20993, 53, 855, 'Vavoua', 'CI', 'SM'),
(20994, 53, 855, 'Zuénoula', 'CI', 'SM'),
(20995, 53, 860, 'Béoumi', 'CI', '04'),
(20996, 53, 860, 'Botro', 'CI', '04'),
(20997, 53, 860, 'Bouaké', 'CI', '04'),
(20998, 53, 860, 'Dabakala', 'CI', '04'),
(20999, 53, 860, 'Gbêkê', 'CI', '04'),
(21000, 53, 860, 'Hambol', 'CI', '04');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(21001, 53, 860, 'Katiola', 'CI', '04'),
(21002, 53, 860, 'Sakassou', 'CI', '04'),
(21003, 53, 861, 'Bafing', 'CI', 'WR'),
(21004, 53, 861, 'Béré', 'CI', 'WR'),
(21005, 53, 861, 'Mankono', 'CI', 'WR'),
(21006, 53, 861, 'Séguéla', 'CI', 'WR'),
(21007, 53, 861, 'Touba', 'CI', 'WR'),
(21008, 53, 861, 'Worodougou', 'CI', 'WR'),
(21009, 53, 864, 'Bondoukou', 'CI', 'ZZ'),
(21010, 53, 864, 'Bouna', 'CI', 'ZZ'),
(21011, 53, 864, 'Bounkani', 'CI', 'ZZ'),
(21012, 53, 864, 'Gontougo', 'CI', 'ZZ'),
(21013, 53, 864, 'Sinfra', 'CI', 'ZZ'),
(21014, 53, 864, 'Tanda', 'CI', 'ZZ'),
(21015, 54, 865, 'Bjelovar', 'HR', '07'),
(21016, 54, 865, 'Brezovac', 'HR', '07'),
(21017, 54, 865, 'Čazma', 'HR', '07'),
(21018, 54, 865, 'Daruvar', 'HR', '07'),
(21019, 54, 865, 'Dežanovac', 'HR', '07'),
(21020, 54, 865, 'Đulovac', 'HR', '07'),
(21021, 54, 865, 'Garešnica', 'HR', '07'),
(21022, 54, 865, 'Grad Bjelovar', 'HR', '07'),
(21023, 54, 865, 'Grad Čazma', 'HR', '07'),
(21024, 54, 865, 'Grad Daruvar', 'HR', '07'),
(21025, 54, 865, 'Grad Garešnica', 'HR', '07'),
(21026, 54, 865, 'Grad Grubišno Polje', 'HR', '07'),
(21027, 54, 865, 'Grubišno Polje', 'HR', '07'),
(21028, 54, 865, 'Gudovac', 'HR', '07'),
(21029, 54, 865, 'Hercegovac', 'HR', '07'),
(21030, 54, 865, 'Ivanska', 'HR', '07'),
(21031, 54, 865, 'Kapela', 'HR', '07'),
(21032, 54, 865, 'Končanica', 'HR', '07'),
(21033, 54, 865, 'Predavac', 'HR', '07'),
(21034, 54, 865, 'Rovišće', 'HR', '07'),
(21035, 54, 865, 'Šandrovac', 'HR', '07'),
(21036, 54, 865, 'Severin', 'HR', '07'),
(21037, 54, 865, 'Sirač', 'HR', '07'),
(21038, 54, 865, 'Velika Pisanica', 'HR', '07'),
(21039, 54, 865, 'Veliki Grđevac', 'HR', '07'),
(21040, 54, 865, 'Ždralovi', 'HR', '07'),
(21041, 54, 865, 'Zrinski Topolovac', 'HR', '07'),
(21042, 54, 866, 'Batrina', 'HR', '12'),
(21043, 54, 866, 'Brodski Varoš', 'HR', '12'),
(21044, 54, 866, 'Bukovlje', 'HR', '12'),
(21045, 54, 866, 'Cernik', 'HR', '12'),
(21046, 54, 866, 'Davor', 'HR', '12'),
(21047, 54, 866, 'Donji Andrijevci', 'HR', '12'),
(21048, 54, 866, 'Garčin', 'HR', '12'),
(21049, 54, 866, 'Gornji Bogićevci', 'HR', '12'),
(21050, 54, 866, 'Grad Nova Gradiška', 'HR', '12'),
(21051, 54, 866, 'Grad Slavonski Brod', 'HR', '12'),
(21052, 54, 866, 'Gundinci', 'HR', '12'),
(21053, 54, 866, 'Korenica', 'HR', '12'),
(21054, 54, 866, 'Kruševica', 'HR', '12'),
(21055, 54, 866, 'Lužani', 'HR', '12'),
(21056, 54, 866, 'Nova Gradiška', 'HR', '12'),
(21057, 54, 866, 'Okučani', 'HR', '12'),
(21058, 54, 866, 'Oprisavci', 'HR', '12'),
(21059, 54, 866, 'Oriovac', 'HR', '12'),
(21060, 54, 866, 'Podvinje', 'HR', '12'),
(21061, 54, 866, 'Rešetari', 'HR', '12'),
(21062, 54, 866, 'Ruščica', 'HR', '12'),
(21063, 54, 866, 'Sibinj', 'HR', '12'),
(21064, 54, 866, 'Sikirevci', 'HR', '12'),
(21065, 54, 866, 'Slavonski Brod', 'HR', '12'),
(21066, 54, 866, 'Slobodnica', 'HR', '12'),
(21067, 54, 866, 'Stari Perkovci', 'HR', '12'),
(21068, 54, 866, 'Velika Kopanica', 'HR', '12'),
(21069, 54, 866, 'Vrpolje', 'HR', '12'),
(21070, 54, 867, 'Cavtat', 'HR', '19'),
(21071, 54, 867, 'Čibača', 'HR', '19'),
(21072, 54, 867, 'Dubrovačko primorje', 'HR', '19'),
(21073, 54, 867, 'Grad Dubrovnik', 'HR', '19'),
(21074, 54, 867, 'Grad Korčula', 'HR', '19'),
(21075, 54, 867, 'Grad Ploče', 'HR', '19'),
(21076, 54, 867, 'Komin', 'HR', '19'),
(21077, 54, 867, 'Konavle', 'HR', '19'),
(21078, 54, 867, 'Korčula', 'HR', '19'),
(21079, 54, 867, 'Lastovo', 'HR', '19'),
(21080, 54, 867, 'Lumbarda', 'HR', '19'),
(21081, 54, 867, 'Metković', 'HR', '19'),
(21082, 54, 867, 'Mljet', 'HR', '19'),
(21083, 54, 867, 'Mokošica', 'HR', '19'),
(21084, 54, 867, 'Općina Lastovo', 'HR', '19'),
(21085, 54, 867, 'Opuzen', 'HR', '19'),
(21086, 54, 867, 'Orebić', 'HR', '19'),
(21087, 54, 867, 'Podgora', 'HR', '19'),
(21088, 54, 867, 'Pojezerje', 'HR', '19'),
(21089, 54, 867, 'Slivno', 'HR', '19'),
(21090, 54, 867, 'Smokvica', 'HR', '19'),
(21091, 54, 867, 'Ston', 'HR', '19'),
(21092, 54, 867, 'Vela Luka', 'HR', '19'),
(21093, 54, 867, 'Zažablje', 'HR', '19'),
(21094, 54, 867, 'Žrnovo', 'HR', '19'),
(21095, 54, 867, 'Župa dubrovačka', 'HR', '19'),
(21096, 54, 868, 'Bale', 'HR', '18'),
(21097, 54, 868, 'Bale-Valle', 'HR', '18'),
(21098, 54, 868, 'Brtonigla', 'HR', '18'),
(21099, 54, 868, 'Brtonigla-Verteneglio', 'HR', '18'),
(21100, 54, 868, 'Buje', 'HR', '18'),
(21101, 54, 868, 'Buje-Buie', 'HR', '18'),
(21102, 54, 868, 'Buzet', 'HR', '18'),
(21103, 54, 868, 'Fažana', 'HR', '18'),
(21104, 54, 868, 'Fažana-Fasana', 'HR', '18'),
(21105, 54, 868, 'Funtana', 'HR', '18'),
(21106, 54, 868, 'Funtana-Fontane', 'HR', '18'),
(21107, 54, 868, 'Galižana', 'HR', '18'),
(21108, 54, 868, 'Grad Buzet', 'HR', '18'),
(21109, 54, 868, 'Grad Labin', 'HR', '18'),
(21110, 54, 868, 'Grad Pazin', 'HR', '18'),
(21111, 54, 868, 'Grožnjan', 'HR', '18'),
(21112, 54, 868, 'Grožnjan-Grisignana', 'HR', '18'),
(21113, 54, 868, 'Kanfanar', 'HR', '18'),
(21114, 54, 868, 'Karojba', 'HR', '18'),
(21115, 54, 868, 'Kaštelir-Labinci', 'HR', '18'),
(21116, 54, 868, 'Labin', 'HR', '18'),
(21117, 54, 868, 'Ližnjan', 'HR', '18'),
(21118, 54, 868, 'Ližnjan-Lisignano', 'HR', '18'),
(21119, 54, 868, 'Lupoglav', 'HR', '18'),
(21120, 54, 868, 'Marčana', 'HR', '18'),
(21121, 54, 868, 'Medulin', 'HR', '18'),
(21122, 54, 868, 'Motovun', 'HR', '18'),
(21123, 54, 868, 'Motovun-Montona', 'HR', '18'),
(21124, 54, 868, 'Novigrad', 'HR', '18'),
(21125, 54, 868, 'Novigrad-Cittanova', 'HR', '18'),
(21126, 54, 868, 'Općina Lanišće', 'HR', '18'),
(21127, 54, 868, 'Oprtalj-Portole', 'HR', '18'),
(21128, 54, 868, 'Pazin', 'HR', '18'),
(21129, 54, 868, 'Poreč', 'HR', '18'),
(21130, 54, 868, 'Poreč-Parenzo', 'HR', '18'),
(21131, 54, 868, 'Pula', 'HR', '18'),
(21132, 54, 868, 'Pula-Pola', 'HR', '18'),
(21133, 54, 868, 'Rabac', 'HR', '18'),
(21134, 54, 868, 'Raša', 'HR', '18'),
(21135, 54, 868, 'Rovinj', 'HR', '18'),
(21136, 54, 868, 'Rovinj-Rovigno', 'HR', '18'),
(21137, 54, 868, 'Sveta Nedelja', 'HR', '18'),
(21138, 54, 868, 'Sveti Lovreč', 'HR', '18'),
(21139, 54, 868, 'Tar', 'HR', '18'),
(21140, 54, 868, 'Tar-Vabriga-Torre Abrega', 'HR', '18'),
(21141, 54, 868, 'Umag', 'HR', '18'),
(21142, 54, 868, 'Umag-Umago', 'HR', '18'),
(21143, 54, 868, 'Valbandon', 'HR', '18'),
(21144, 54, 868, 'Vinež', 'HR', '18'),
(21145, 54, 868, 'Višnjan-Visignano', 'HR', '18'),
(21146, 54, 868, 'Vižinada-Visinada', 'HR', '18'),
(21147, 54, 868, 'Vodnjan', 'HR', '18'),
(21148, 54, 868, 'Vodnjan-Dignano', 'HR', '18'),
(21149, 54, 868, 'Vrsar', 'HR', '18'),
(21150, 54, 868, 'Vrsar-Orsera', 'HR', '18'),
(21151, 54, 868, 'Žminj', 'HR', '18'),
(21152, 54, 870, 'Drnje', 'HR', '06'),
(21153, 54, 870, 'Đelekovec', 'HR', '06'),
(21154, 54, 870, 'Đurđevac', 'HR', '06'),
(21155, 54, 870, 'Ferdinandovac', 'HR', '06'),
(21156, 54, 870, 'Gola', 'HR', '06'),
(21157, 54, 870, 'Gornja Rijeka', 'HR', '06'),
(21158, 54, 870, 'Grad Koprivnica', 'HR', '06'),
(21159, 54, 870, 'Grad Križevci', 'HR', '06'),
(21160, 54, 870, 'Hlebine', 'HR', '06'),
(21161, 54, 870, 'Kalinovac', 'HR', '06'),
(21162, 54, 870, 'Koprivnica', 'HR', '06'),
(21163, 54, 870, 'Koprivnički Ivanec', 'HR', '06'),
(21164, 54, 870, 'Križevci', 'HR', '06'),
(21165, 54, 870, 'Legrad', 'HR', '06'),
(21166, 54, 870, 'Molve', 'HR', '06'),
(21167, 54, 870, 'Novo Virje', 'HR', '06'),
(21168, 54, 870, 'Peteranec', 'HR', '06'),
(21169, 54, 870, 'Rasinja', 'HR', '06'),
(21170, 54, 870, 'Reka', 'HR', '06'),
(21171, 54, 870, 'Sigetec', 'HR', '06'),
(21172, 54, 870, 'Virje', 'HR', '06'),
(21173, 54, 871, 'Bedekovčina', 'HR', '02'),
(21174, 54, 871, 'Budinščina', 'HR', '02'),
(21175, 54, 871, 'Đurmanec', 'HR', '02'),
(21176, 54, 871, 'Grad Donja Stubica', 'HR', '02'),
(21177, 54, 871, 'Grad Klanjec', 'HR', '02'),
(21178, 54, 871, 'Grad Krapina', 'HR', '02'),
(21179, 54, 871, 'Grad Zabok', 'HR', '02'),
(21180, 54, 871, 'Grad Zlatar', 'HR', '02'),
(21181, 54, 871, 'Jesenje', 'HR', '02'),
(21182, 54, 871, 'Klanjec', 'HR', '02'),
(21183, 54, 871, 'Konjščina', 'HR', '02'),
(21184, 54, 871, 'Krapina', 'HR', '02'),
(21185, 54, 871, 'Kumrovec', 'HR', '02'),
(21186, 54, 871, 'Mače', 'HR', '02'),
(21187, 54, 871, 'Marija Bistrica', 'HR', '02'),
(21188, 54, 871, 'Mihovljan', 'HR', '02'),
(21189, 54, 871, 'Oroslavje', 'HR', '02'),
(21190, 54, 871, 'Pregrada', 'HR', '02'),
(21191, 54, 871, 'Radoboj', 'HR', '02'),
(21192, 54, 871, 'Stubičke Toplice', 'HR', '02'),
(21193, 54, 871, 'Sveti Križ Začretje', 'HR', '02'),
(21194, 54, 871, 'Zabok', 'HR', '02'),
(21195, 54, 871, 'Zlatar', 'HR', '02'),
(21196, 54, 871, 'Zlatar Bistrica', 'HR', '02'),
(21197, 54, 872, 'Brinje', 'HR', '09'),
(21198, 54, 872, 'Gospić', 'HR', '09'),
(21199, 54, 872, 'Karlobag', 'HR', '09'),
(21200, 54, 872, 'Lički Osik', 'HR', '09'),
(21201, 54, 872, 'Novalja', 'HR', '09'),
(21202, 54, 872, 'Otočac', 'HR', '09'),
(21203, 54, 872, 'Perušić', 'HR', '09'),
(21204, 54, 872, 'Plitvička Jezera', 'HR', '09'),
(21205, 54, 872, 'Popovača', 'HR', '09'),
(21206, 54, 872, 'Senj', 'HR', '09'),
(21207, 54, 873, 'Belica', 'HR', '20'),
(21208, 54, 873, 'Čakovec', 'HR', '20'),
(21209, 54, 873, 'Dekanovec', 'HR', '20'),
(21210, 54, 873, 'Domašinec', 'HR', '20'),
(21211, 54, 873, 'Goričan', 'HR', '20'),
(21212, 54, 873, 'Grad Čakovec', 'HR', '20'),
(21213, 54, 873, 'Hodošan', 'HR', '20'),
(21214, 54, 873, 'Ivanovec', 'HR', '20'),
(21215, 54, 873, 'Kotoriba', 'HR', '20'),
(21216, 54, 873, 'Kuršanec', 'HR', '20'),
(21217, 54, 873, 'Lopatinec', 'HR', '20'),
(21218, 54, 873, 'Mačkovec', 'HR', '20'),
(21219, 54, 873, 'Mala Subotica', 'HR', '20'),
(21220, 54, 873, 'Mihovljan', 'HR', '20'),
(21221, 54, 873, 'Mursko Središće', 'HR', '20'),
(21222, 54, 873, 'Nedelišće', 'HR', '20'),
(21223, 54, 873, 'Novo Selo Rok', 'HR', '20'),
(21224, 54, 873, 'Orehovica', 'HR', '20'),
(21225, 54, 873, 'Peklenica', 'HR', '20'),
(21226, 54, 873, 'Podturen', 'HR', '20'),
(21227, 54, 873, 'Prelog', 'HR', '20'),
(21228, 54, 873, 'Pribislavec', 'HR', '20'),
(21229, 54, 873, 'Šenkovec', 'HR', '20'),
(21230, 54, 873, 'Strahoninec', 'HR', '20'),
(21231, 54, 873, 'Sveti Juraj na Bregu', 'HR', '20'),
(21232, 54, 873, 'Vratišinec', 'HR', '20'),
(21233, 54, 874, 'Antunovac', 'HR', '14'),
(21234, 54, 874, 'Beli Manastir', 'HR', '14'),
(21235, 54, 874, 'Belišće', 'HR', '14'),
(21236, 54, 874, 'Bijelo Brdo', 'HR', '14'),
(21237, 54, 874, 'Bilje', 'HR', '14'),
(21238, 54, 874, 'Bistrinci', 'HR', '14'),
(21239, 54, 874, 'Bizovac', 'HR', '14'),
(21240, 54, 874, 'Brijest', 'HR', '14'),
(21241, 54, 874, 'Budrovci', 'HR', '14'),
(21242, 54, 874, 'Čeminac', 'HR', '14'),
(21243, 54, 874, 'Čepin', 'HR', '14'),
(21244, 54, 874, 'Dalj', 'HR', '14'),
(21245, 54, 874, 'Darda', 'HR', '14'),
(21246, 54, 874, 'Donji Miholjac', 'HR', '14'),
(21247, 54, 874, 'Draž', 'HR', '14'),
(21248, 54, 874, 'Đakovo', 'HR', '14'),
(21249, 54, 874, 'Đurđenovac', 'HR', '14'),
(21250, 54, 874, 'Erdut', 'HR', '14'),
(21251, 54, 874, 'Ernestinovo', 'HR', '14'),
(21252, 54, 874, 'Feričanci', 'HR', '14'),
(21253, 54, 874, 'Gorjani', 'HR', '14'),
(21254, 54, 874, 'Grad Beli Manastir', 'HR', '14'),
(21255, 54, 874, 'Grad Donji Miholjac', 'HR', '14'),
(21256, 54, 874, 'Grad Našice', 'HR', '14'),
(21257, 54, 874, 'Grad Osijek', 'HR', '14'),
(21258, 54, 874, 'Grad Valpovo', 'HR', '14'),
(21259, 54, 874, 'Jagodnjak', 'HR', '14'),
(21260, 54, 874, 'Jelisavac', 'HR', '14'),
(21261, 54, 874, 'Josipovac', 'HR', '14'),
(21262, 54, 874, 'Karanac', 'HR', '14'),
(21263, 54, 874, 'Kneževi Vinogradi', 'HR', '14'),
(21264, 54, 874, 'Koška', 'HR', '14'),
(21265, 54, 874, 'Kuševac', 'HR', '14'),
(21266, 54, 874, 'Ladimirevci', 'HR', '14'),
(21267, 54, 874, 'Laslovo', 'HR', '14'),
(21268, 54, 874, 'Magadenovac', 'HR', '14'),
(21269, 54, 874, 'Marijanci', 'HR', '14'),
(21270, 54, 874, 'Marjanci', 'HR', '14'),
(21271, 54, 874, 'Markovac Našički', 'HR', '14'),
(21272, 54, 874, 'Martin', 'HR', '14'),
(21273, 54, 874, 'Našice', 'HR', '14'),
(21274, 54, 874, 'Osijek', 'HR', '14'),
(21275, 54, 874, 'Petlovac', 'HR', '14'),
(21276, 54, 874, 'Petrijevci', 'HR', '14'),
(21277, 54, 874, 'Piškorevci', 'HR', '14'),
(21278, 54, 874, 'Podgorač', 'HR', '14'),
(21279, 54, 874, 'Podravska Moslavina', 'HR', '14'),
(21280, 54, 874, 'Sarvaš', 'HR', '14'),
(21281, 54, 874, 'Satnica Đakovačka', 'HR', '14'),
(21282, 54, 874, 'Semeljci', 'HR', '14'),
(21283, 54, 874, 'Široko Polje', 'HR', '14'),
(21284, 54, 874, 'Šodolovci', 'HR', '14'),
(21285, 54, 874, 'Strizivojna', 'HR', '14'),
(21286, 54, 874, 'Tenja', 'HR', '14'),
(21287, 54, 874, 'Valpovo', 'HR', '14'),
(21288, 54, 874, 'Velimirovac', 'HR', '14'),
(21289, 54, 874, 'Viljevo', 'HR', '14'),
(21290, 54, 874, 'Viškovci', 'HR', '14'),
(21291, 54, 874, 'Višnjevac', 'HR', '14'),
(21292, 54, 874, 'Vladislavci', 'HR', '14'),
(21293, 54, 874, 'Vuka', 'HR', '14'),
(21294, 54, 875, 'Brestovac', 'HR', '11'),
(21295, 54, 875, 'Grad Pakrac', 'HR', '11'),
(21296, 54, 875, 'Grad Požega', 'HR', '11'),
(21297, 54, 875, 'Jakšić', 'HR', '11'),
(21298, 54, 875, 'Kaptol', 'HR', '11'),
(21299, 54, 875, 'Kutjevo', 'HR', '11'),
(21300, 54, 875, 'Lipik', 'HR', '11'),
(21301, 54, 875, 'Pakrac', 'HR', '11'),
(21302, 54, 875, 'Pleternica', 'HR', '11'),
(21303, 54, 875, 'Požega', 'HR', '11'),
(21304, 54, 875, 'Velika', 'HR', '11'),
(21305, 54, 875, 'Vidovci', 'HR', '11'),
(21306, 54, 876, 'Bakar', 'HR', '08'),
(21307, 54, 876, 'Banjol', 'HR', '08'),
(21308, 54, 876, 'Baška', 'HR', '08'),
(21309, 54, 876, 'Bribir', 'HR', '08'),
(21310, 54, 876, 'Buzdohanj', 'HR', '08'),
(21311, 54, 876, 'Čavle', 'HR', '08'),
(21312, 54, 876, 'Cernik', 'HR', '08'),
(21313, 54, 876, 'Cres', 'HR', '08'),
(21314, 54, 876, 'Crikvenica', 'HR', '08'),
(21315, 54, 876, 'Delnice', 'HR', '08'),
(21316, 54, 876, 'Dražice', 'HR', '08'),
(21317, 54, 876, 'Drenova', 'HR', '08'),
(21318, 54, 876, 'Fužine', 'HR', '08'),
(21319, 54, 876, 'Grad Čabar', 'HR', '08'),
(21320, 54, 876, 'Grad Crikvenica', 'HR', '08'),
(21321, 54, 876, 'Grad Delnice', 'HR', '08'),
(21322, 54, 876, 'Grad Krk', 'HR', '08'),
(21323, 54, 876, 'Grad Opatija', 'HR', '08'),
(21324, 54, 876, 'Grad Rijeka', 'HR', '08'),
(21325, 54, 876, 'Grad Vrbovsko', 'HR', '08'),
(21326, 54, 876, 'Hreljin', 'HR', '08'),
(21327, 54, 876, 'Jadranovo', 'HR', '08'),
(21328, 54, 876, 'Kampor', 'HR', '08'),
(21329, 54, 876, 'Kastav', 'HR', '08'),
(21330, 54, 876, 'Klana', 'HR', '08'),
(21331, 54, 876, 'Kraljevica', 'HR', '08'),
(21332, 54, 876, 'Krasica', 'HR', '08'),
(21333, 54, 876, 'Krk', 'HR', '08'),
(21334, 54, 876, 'Lopar', 'HR', '08'),
(21335, 54, 876, 'Lovran', 'HR', '08'),
(21336, 54, 876, 'Mali Lošinj', 'HR', '08'),
(21337, 54, 876, 'Malinska-Dubašnica', 'HR', '08'),
(21338, 54, 876, 'Marčelji', 'HR', '08'),
(21339, 54, 876, 'Marinići', 'HR', '08'),
(21340, 54, 876, 'Matulji', 'HR', '08'),
(21341, 54, 876, 'Mihotići', 'HR', '08'),
(21342, 54, 876, 'Mrkopalj', 'HR', '08'),
(21343, 54, 876, 'Njivice', 'HR', '08'),
(21344, 54, 876, 'Novi Vinodolski', 'HR', '08'),
(21345, 54, 876, 'Omišalj', 'HR', '08'),
(21346, 54, 876, 'Opatija', 'HR', '08'),
(21347, 54, 876, 'Podhum', 'HR', '08'),
(21348, 54, 876, 'Punat', 'HR', '08'),
(21349, 54, 876, 'Rab', 'HR', '08'),
(21350, 54, 876, 'Rijeka', 'HR', '08'),
(21351, 54, 876, 'Rubeši', 'HR', '08'),
(21352, 54, 876, 'Selce', 'HR', '08'),
(21353, 54, 876, 'Skrad', 'HR', '08'),
(21354, 54, 876, 'Škrljevo', 'HR', '08'),
(21355, 54, 876, 'Supetarska Draga', 'HR', '08'),
(21356, 54, 876, 'Vinodolska općina', 'HR', '08'),
(21357, 54, 876, 'Viškovo', 'HR', '08'),
(21358, 54, 876, 'Vrbnik', 'HR', '08'),
(21359, 54, 876, 'Vrbovsko', 'HR', '08'),
(21360, 54, 877, 'Brodarica', 'HR', '15'),
(21361, 54, 877, 'Drniš', 'HR', '15'),
(21362, 54, 877, 'Grad Drniš', 'HR', '15'),
(21363, 54, 877, 'Grad Šibenik', 'HR', '15'),
(21364, 54, 877, 'Kistanje', 'HR', '15'),
(21365, 54, 877, 'Knin', 'HR', '15'),
(21366, 54, 877, 'Murter', 'HR', '15'),
(21367, 54, 877, 'Murter-Kornati', 'HR', '15'),
(21368, 54, 877, 'Pirovac', 'HR', '15'),
(21369, 54, 877, 'Primošten', 'HR', '15'),
(21370, 54, 877, 'Promina', 'HR', '15'),
(21371, 54, 877, 'Rogoznica', 'HR', '15'),
(21372, 54, 877, 'Rogoznica Općina', 'HR', '15'),
(21373, 54, 877, 'Šibenik', 'HR', '15'),
(21374, 54, 877, 'Skradin', 'HR', '15'),
(21375, 54, 877, 'Tisno', 'HR', '15'),
(21376, 54, 877, 'Tribunj', 'HR', '15'),
(21377, 54, 877, 'Vodice', 'HR', '15'),
(21378, 54, 878, 'Budaševo', 'HR', '03'),
(21379, 54, 878, 'Dvor', 'HR', '03'),
(21380, 54, 878, 'Glina', 'HR', '03'),
(21381, 54, 878, 'Grad Glina', 'HR', '03'),
(21382, 54, 878, 'Grad Hrvatska Kostajnica', 'HR', '03'),
(21383, 54, 878, 'Grad Kutina', 'HR', '03'),
(21384, 54, 878, 'Grad Novska', 'HR', '03'),
(21385, 54, 878, 'Grad Petrinja', 'HR', '03'),
(21386, 54, 878, 'Grad Sisak', 'HR', '03'),
(21387, 54, 878, 'Gvozd', 'HR', '03'),
(21388, 54, 878, 'Hrvatska Kostajnica', 'HR', '03'),
(21389, 54, 878, 'Kutina', 'HR', '03'),
(21390, 54, 878, 'Lekenik', 'HR', '03'),
(21391, 54, 878, 'Lipovljani', 'HR', '03'),
(21392, 54, 878, 'Martinska Ves', 'HR', '03'),
(21393, 54, 878, 'Novska', 'HR', '03'),
(21394, 54, 878, 'Općina Dvor', 'HR', '03'),
(21395, 54, 878, 'Općina Gvozd', 'HR', '03'),
(21396, 54, 878, 'Petrinja', 'HR', '03'),
(21397, 54, 878, 'Popovača', 'HR', '03'),
(21398, 54, 878, 'Repušnica', 'HR', '03'),
(21399, 54, 878, 'Sisak', 'HR', '03'),
(21400, 54, 878, 'Sunja', 'HR', '03'),
(21401, 54, 878, 'Voloder', 'HR', '03'),
(21402, 54, 879, 'Baška Voda', 'HR', '17'),
(21403, 54, 879, 'Bol', 'HR', '17'),
(21404, 54, 879, 'Brela', 'HR', '17'),
(21405, 54, 879, 'Brnaze', 'HR', '17'),
(21406, 54, 879, 'Dicmo', 'HR', '17'),
(21407, 54, 879, 'Donji Vinjani', 'HR', '17'),
(21408, 54, 879, 'Duće', 'HR', '17'),
(21409, 54, 879, 'Dugi Rat Općina', 'HR', '17'),
(21410, 54, 879, 'Dugopolje', 'HR', '17'),
(21411, 54, 879, 'Gala', 'HR', '17'),
(21412, 54, 879, 'Grabovci', 'HR', '17'),
(21413, 54, 879, 'Grad Hvar', 'HR', '17'),
(21414, 54, 879, 'Grad Imotski', 'HR', '17'),
(21415, 54, 879, 'Grad Makarska', 'HR', '17'),
(21416, 54, 879, 'Grad Omiš', 'HR', '17'),
(21417, 54, 879, 'Grad Sinj', 'HR', '17'),
(21418, 54, 879, 'Grad Split', 'HR', '17'),
(21419, 54, 879, 'Grad Supetar', 'HR', '17'),
(21420, 54, 879, 'Grad Trogir', 'HR', '17'),
(21421, 54, 879, 'Grad Vis', 'HR', '17'),
(21422, 54, 879, 'Grad Vrgorac', 'HR', '17'),
(21423, 54, 879, 'Gradac', 'HR', '17'),
(21424, 54, 879, 'Greda', 'HR', '17'),
(21425, 54, 879, 'Grubine', 'HR', '17'),
(21426, 54, 879, 'Hrvace', 'HR', '17'),
(21427, 54, 879, 'Hvar', 'HR', '17'),
(21428, 54, 879, 'Imotski', 'HR', '17'),
(21429, 54, 879, 'Jelsa', 'HR', '17'),
(21430, 54, 879, 'Jesenice', 'HR', '17'),
(21431, 54, 879, 'Kamen', 'HR', '17'),
(21432, 54, 879, 'Kaštel Gomilica', 'HR', '17'),
(21433, 54, 879, 'Kaštel Kambelovac', 'HR', '17'),
(21434, 54, 879, 'Kaštel Lukšić', 'HR', '17'),
(21435, 54, 879, 'Kaštel Novi', 'HR', '17'),
(21436, 54, 879, 'Kaštel Štafilić', 'HR', '17'),
(21437, 54, 879, 'Kaštel Stari', 'HR', '17'),
(21438, 54, 879, 'Kaštela', 'HR', '17'),
(21439, 54, 879, 'Klis', 'HR', '17'),
(21440, 54, 879, 'Komiža', 'HR', '17'),
(21441, 54, 879, 'Košute', 'HR', '17'),
(21442, 54, 879, 'Lokvičići', 'HR', '17'),
(21443, 54, 879, 'Lovreć', 'HR', '17'),
(21444, 54, 879, 'Makarska', 'HR', '17'),
(21445, 54, 879, 'Milna', 'HR', '17'),
(21446, 54, 879, 'Mravince', 'HR', '17'),
(21447, 54, 879, 'Muć', 'HR', '17'),
(21448, 54, 879, 'Nerežišća', 'HR', '17'),
(21449, 54, 879, 'Okrug', 'HR', '17'),
(21450, 54, 879, 'Okrug Gornji', 'HR', '17'),
(21451, 54, 879, 'Omiš', 'HR', '17'),
(21452, 54, 879, 'Otok', 'HR', '17'),
(21453, 54, 879, 'Podstrana', 'HR', '17'),
(21454, 54, 879, 'Postira', 'HR', '17'),
(21455, 54, 879, 'Proložac', 'HR', '17'),
(21456, 54, 879, 'Pučišća', 'HR', '17'),
(21457, 54, 879, 'Runović', 'HR', '17'),
(21458, 54, 879, 'Runovići', 'HR', '17'),
(21459, 54, 879, 'Seget', 'HR', '17'),
(21460, 54, 879, 'Seget Vranjica', 'HR', '17'),
(21461, 54, 879, 'Selca', 'HR', '17'),
(21462, 54, 879, 'Sinj', 'HR', '17'),
(21463, 54, 879, 'Slatine', 'HR', '17'),
(21464, 54, 879, 'Solin', 'HR', '17'),
(21465, 54, 879, 'Šolta', 'HR', '17'),
(21466, 54, 879, 'Split', 'HR', '17'),
(21467, 54, 879, 'Srinjine', 'HR', '17'),
(21468, 54, 879, 'Stari Grad', 'HR', '17'),
(21469, 54, 879, 'Stobreč', 'HR', '17'),
(21470, 54, 879, 'Supetar', 'HR', '17'),
(21471, 54, 879, 'Trilj', 'HR', '17'),
(21472, 54, 879, 'Trogir', 'HR', '17'),
(21473, 54, 879, 'Tučepi', 'HR', '17'),
(21474, 54, 879, 'Turjaci', 'HR', '17'),
(21475, 54, 879, 'Veliki Drvenik', 'HR', '17'),
(21476, 54, 879, 'Vis', 'HR', '17'),
(21477, 54, 879, 'Vranjic', 'HR', '17'),
(21478, 54, 879, 'Vrgorac', 'HR', '17'),
(21479, 54, 879, 'Vrlika', 'HR', '17'),
(21480, 54, 879, 'Zagvozd', 'HR', '17'),
(21481, 54, 879, 'Zmijavci', 'HR', '17'),
(21482, 54, 879, 'Žrnovnica', 'HR', '17'),
(21483, 54, 880, 'Beretinec', 'HR', '05'),
(21484, 54, 880, 'Breznica', 'HR', '05'),
(21485, 54, 880, 'Breznički Hum', 'HR', '05'),
(21486, 54, 880, 'Cestica', 'HR', '05'),
(21487, 54, 880, 'Donje Ladanje', 'HR', '05'),
(21488, 54, 880, 'Gornje Vratno', 'HR', '05'),
(21489, 54, 880, 'Gornji Kneginec', 'HR', '05'),
(21490, 54, 880, 'Grad Ivanec', 'HR', '05'),
(21491, 54, 880, 'Grad Ludbreg', 'HR', '05'),
(21492, 54, 880, 'Grad Novi Marof', 'HR', '05'),
(21493, 54, 880, 'Grad Varaždin', 'HR', '05'),
(21494, 54, 880, 'Hrašćica', 'HR', '05'),
(21495, 54, 880, 'Ivanec', 'HR', '05'),
(21496, 54, 880, 'Jalkovec', 'HR', '05'),
(21497, 54, 880, 'Jalžabet', 'HR', '05'),
(21498, 54, 880, 'Klenovnik', 'HR', '05'),
(21499, 54, 880, 'Kućan Marof', 'HR', '05'),
(21500, 54, 880, 'Lepoglava', 'HR', '05');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(21501, 54, 880, 'Ljubešćica', 'HR', '05'),
(21502, 54, 880, 'Ludbreg', 'HR', '05'),
(21503, 54, 880, 'Nedeljanec', 'HR', '05'),
(21504, 54, 880, 'Petrijanec', 'HR', '05'),
(21505, 54, 880, 'Remetinec', 'HR', '05'),
(21506, 54, 880, 'Sračinec', 'HR', '05'),
(21507, 54, 880, 'Sveti Đurđ', 'HR', '05'),
(21508, 54, 880, 'Tužno', 'HR', '05'),
(21509, 54, 880, 'Varaždin', 'HR', '05'),
(21510, 54, 880, 'Vidovec', 'HR', '05'),
(21511, 54, 880, 'Vinica', 'HR', '05'),
(21512, 54, 881, 'Čačinci', 'HR', '10'),
(21513, 54, 881, 'Čađavica', 'HR', '10'),
(21514, 54, 881, 'Crnac', 'HR', '10'),
(21515, 54, 881, 'Grad Orahovica', 'HR', '10'),
(21516, 54, 881, 'Grad Slatina', 'HR', '10'),
(21517, 54, 881, 'Grad Virovitica', 'HR', '10'),
(21518, 54, 881, 'Gradina', 'HR', '10'),
(21519, 54, 881, 'Mikleuš', 'HR', '10'),
(21520, 54, 881, 'Nova Bukovica', 'HR', '10'),
(21521, 54, 881, 'Orahovica', 'HR', '10'),
(21522, 54, 881, 'Pitomača', 'HR', '10'),
(21523, 54, 881, 'Rezovac', 'HR', '10'),
(21524, 54, 881, 'Slatina', 'HR', '10'),
(21525, 54, 881, 'Sopje', 'HR', '10'),
(21526, 54, 881, 'Špišić Bukovica', 'HR', '10'),
(21527, 54, 881, 'Suhopolje', 'HR', '10'),
(21528, 54, 881, 'Virovitica', 'HR', '10'),
(21529, 54, 881, 'Voćin', 'HR', '10'),
(21530, 54, 881, 'Zdenci', 'HR', '10'),
(21531, 54, 882, 'Andrijaševci', 'HR', '16'),
(21532, 54, 882, 'Babina Greda', 'HR', '16'),
(21533, 54, 882, 'Bobota', 'HR', '16'),
(21534, 54, 882, 'Bogdanovci', 'HR', '16'),
(21535, 54, 882, 'Borovo', 'HR', '16'),
(21536, 54, 882, 'Borovo Selo', 'HR', '16'),
(21537, 54, 882, 'Bošnjaci', 'HR', '16'),
(21538, 54, 882, 'Bršadin', 'HR', '16'),
(21539, 54, 882, 'Cerić', 'HR', '16'),
(21540, 54, 882, 'Cerna', 'HR', '16'),
(21541, 54, 882, 'Drenovci', 'HR', '16'),
(21542, 54, 882, 'Grad Vinkovci', 'HR', '16'),
(21543, 54, 882, 'Grad Vukovar', 'HR', '16'),
(21544, 54, 882, 'Grad Županja', 'HR', '16'),
(21545, 54, 882, 'Gradište', 'HR', '16'),
(21546, 54, 882, 'Gunja', 'HR', '16'),
(21547, 54, 882, 'Ilok', 'HR', '16'),
(21548, 54, 882, 'Ivankovo', 'HR', '16'),
(21549, 54, 882, 'Jarmina', 'HR', '16'),
(21550, 54, 882, 'Komletinci', 'HR', '16'),
(21551, 54, 882, 'Lovas', 'HR', '16'),
(21552, 54, 882, 'Markušica', 'HR', '16'),
(21553, 54, 882, 'Mirkovci', 'HR', '16'),
(21554, 54, 882, 'Negoslavci', 'HR', '16'),
(21555, 54, 882, 'Nijemci', 'HR', '16'),
(21556, 54, 882, 'Nuštar', 'HR', '16'),
(21557, 54, 882, 'Otok', 'HR', '16'),
(21558, 54, 882, 'Privlaka', 'HR', '16'),
(21559, 54, 882, 'Retkovci', 'HR', '16'),
(21560, 54, 882, 'Rokovci', 'HR', '16'),
(21561, 54, 882, 'Soljani', 'HR', '16'),
(21562, 54, 882, 'Stari Jankovci', 'HR', '16'),
(21563, 54, 882, 'Štitar', 'HR', '16'),
(21564, 54, 882, 'Tordinci', 'HR', '16'),
(21565, 54, 882, 'Tovarnik', 'HR', '16'),
(21566, 54, 882, 'Trpinja', 'HR', '16'),
(21567, 54, 882, 'Vinkovci', 'HR', '16'),
(21568, 54, 882, 'Vođinci', 'HR', '16'),
(21569, 54, 882, 'Vrbanja', 'HR', '16'),
(21570, 54, 882, 'Vukovar', 'HR', '16'),
(21571, 54, 882, 'Županja', 'HR', '16'),
(21572, 54, 883, 'Benkovac', 'HR', '13'),
(21573, 54, 883, 'Bibinje', 'HR', '13'),
(21574, 54, 883, 'Biograd na Moru', 'HR', '13'),
(21575, 54, 883, 'Galovac', 'HR', '13'),
(21576, 54, 883, 'Gornji Karin', 'HR', '13'),
(21577, 54, 883, 'Gračac', 'HR', '13'),
(21578, 54, 883, 'Grad Biograd na Moru', 'HR', '13'),
(21579, 54, 883, 'Jasenice', 'HR', '13'),
(21580, 54, 883, 'Kali', 'HR', '13'),
(21581, 54, 883, 'Kruševo', 'HR', '13'),
(21582, 54, 883, 'Nin', 'HR', '13'),
(21583, 54, 883, 'Novigrad Općina', 'HR', '13'),
(21584, 54, 883, 'Obrovac', 'HR', '13'),
(21585, 54, 883, 'Osljak', 'HR', '13'),
(21586, 54, 883, 'Pag', 'HR', '13'),
(21587, 54, 883, 'Pakoštane', 'HR', '13'),
(21588, 54, 883, 'Polača', 'HR', '13'),
(21589, 54, 883, 'Poličnik', 'HR', '13'),
(21590, 54, 883, 'Posedarje', 'HR', '13'),
(21591, 54, 883, 'Preko', 'HR', '13'),
(21592, 54, 883, 'Pridraga', 'HR', '13'),
(21593, 54, 883, 'Privlaka', 'HR', '13'),
(21594, 54, 883, 'Ražanac', 'HR', '13'),
(21595, 54, 883, 'Sali', 'HR', '13'),
(21596, 54, 883, 'Škabrnja', 'HR', '13'),
(21597, 54, 883, 'Stari Grad', 'HR', '13'),
(21598, 54, 883, 'Starigrad', 'HR', '13'),
(21599, 54, 883, 'Sukošan', 'HR', '13'),
(21600, 54, 883, 'Sveti Filip i Jakov', 'HR', '13'),
(21601, 54, 883, 'Tkon', 'HR', '13'),
(21602, 54, 883, 'Turanj', 'HR', '13'),
(21603, 54, 883, 'Ugljan', 'HR', '13'),
(21604, 54, 883, 'Vir', 'HR', '13'),
(21605, 54, 883, 'Vrsi', 'HR', '13'),
(21606, 54, 883, 'Zadar', 'HR', '13'),
(21607, 54, 884, 'Bestovje', 'HR', '01'),
(21608, 54, 884, 'Bistra', 'HR', '01'),
(21609, 54, 884, 'Brckovljani', 'HR', '01'),
(21610, 54, 884, 'Brdovec', 'HR', '01'),
(21611, 54, 884, 'Bregana', 'HR', '01'),
(21612, 54, 884, 'Donja Bistra', 'HR', '01'),
(21613, 54, 884, 'Donja Lomnica', 'HR', '01'),
(21614, 54, 884, 'Donja Zdenčina', 'HR', '01'),
(21615, 54, 884, 'Donji Stupnik', 'HR', '01'),
(21616, 54, 884, 'Farkaševac', 'HR', '01'),
(21617, 54, 884, 'Gornja Bistra', 'HR', '01'),
(21618, 54, 884, 'Gračec', 'HR', '01'),
(21619, 54, 884, 'Grad Dugo Selo', 'HR', '01'),
(21620, 54, 884, 'Grad Jastrebarsko', 'HR', '01'),
(21621, 54, 884, 'Grad Samobor', 'HR', '01'),
(21622, 54, 884, 'Grad Sveti Ivan Zelina', 'HR', '01'),
(21623, 54, 884, 'Grad Velika Gorica', 'HR', '01'),
(21624, 54, 884, 'Grad Vrbovec', 'HR', '01'),
(21625, 54, 884, 'Grad Zaprešić', 'HR', '01'),
(21626, 54, 884, 'Gradec', 'HR', '01'),
(21627, 54, 884, 'Gradići', 'HR', '01'),
(21628, 54, 884, 'Jablanovec', 'HR', '01'),
(21629, 54, 884, 'Jakovlje', 'HR', '01'),
(21630, 54, 884, 'Jastrebarsko', 'HR', '01'),
(21631, 54, 884, 'Kerestinec', 'HR', '01'),
(21632, 54, 884, 'Križ', 'HR', '01'),
(21633, 54, 884, 'Kuče', 'HR', '01'),
(21634, 54, 884, 'Lonjica', 'HR', '01'),
(21635, 54, 884, 'Luka', 'HR', '01'),
(21636, 54, 884, 'Lukavec', 'HR', '01'),
(21637, 54, 884, 'Lupoglav', 'HR', '01'),
(21638, 54, 884, 'Mičevec', 'HR', '01'),
(21639, 54, 884, 'Mraclin', 'HR', '01'),
(21640, 54, 884, 'Novo Čiče', 'HR', '01'),
(21641, 54, 884, 'Novoselec', 'HR', '01'),
(21642, 54, 884, 'Općina Dubrava', 'HR', '01'),
(21643, 54, 884, 'Orešje', 'HR', '01'),
(21644, 54, 884, 'Pojatno', 'HR', '01'),
(21645, 54, 884, 'Preseka', 'HR', '01'),
(21646, 54, 884, 'Prigorje Brdovečko', 'HR', '01'),
(21647, 54, 884, 'Pušća', 'HR', '01'),
(21648, 54, 884, 'Rakitje', 'HR', '01'),
(21649, 54, 884, 'Rakov Potok', 'HR', '01'),
(21650, 54, 884, 'Rude', 'HR', '01'),
(21651, 54, 884, 'Samobor', 'HR', '01'),
(21652, 54, 884, 'Stupnik', 'HR', '01'),
(21653, 54, 884, 'Sveta Nedelja', 'HR', '01'),
(21654, 54, 884, 'Sveta Nedjelja', 'HR', '01'),
(21655, 54, 884, 'Velika Gorica', 'HR', '01'),
(21656, 54, 884, 'Velika Mlaka', 'HR', '01'),
(21657, 54, 884, 'Velika Ostrna', 'HR', '01'),
(21658, 54, 884, 'Vrbovec', 'HR', '01'),
(21659, 54, 884, 'Zaprešić', 'HR', '01'),
(21660, 54, 884, 'Zdenci Brdovečki', 'HR', '01'),
(21661, 54, 884, 'Brezovica', 'HR', '21'),
(21662, 54, 884, 'Centar', 'HR', '21'),
(21663, 54, 884, 'Dubrava', 'HR', '21'),
(21664, 54, 884, 'Gradska četvrt Donji grad', 'HR', '21'),
(21665, 54, 884, 'Gradska četvrt Gornji Grad - Medvescak', 'HR', '21'),
(21666, 54, 884, 'Gradska četvrt Podsljeme', 'HR', '21'),
(21667, 54, 884, 'Horvati', 'HR', '21'),
(21668, 54, 884, 'Jankomir', 'HR', '21'),
(21669, 54, 884, 'Ježdovec', 'HR', '21'),
(21670, 54, 884, 'Kašina', 'HR', '21'),
(21671, 54, 884, 'Lučko', 'HR', '21'),
(21672, 54, 884, 'Novi Zagreb', 'HR', '21'),
(21673, 54, 884, 'Odra', 'HR', '21'),
(21674, 54, 884, 'Sesvete', 'HR', '21'),
(21675, 54, 884, 'Stenjevec', 'HR', '21'),
(21676, 54, 884, 'Strmec', 'HR', '21'),
(21677, 54, 884, 'Zadvorsko', 'HR', '21'),
(21678, 54, 884, 'Zagreb', 'HR', '21'),
(21679, 55, 886, 'Alquízar', 'CU', '15'),
(21680, 55, 886, 'Artemisa', 'CU', '15'),
(21681, 55, 886, 'Bahía Honda', 'CU', '15'),
(21682, 55, 886, 'Bauta', 'CU', '15'),
(21683, 55, 886, 'Cabañas', 'CU', '15'),
(21684, 55, 886, 'Candelaria', 'CU', '15'),
(21685, 55, 886, 'Guanajay', 'CU', '15'),
(21686, 55, 886, 'Güira de Melena', 'CU', '15'),
(21687, 55, 886, 'Mariel', 'CU', '15'),
(21688, 55, 886, 'Municipio de Artemisa', 'CU', '15'),
(21689, 55, 886, 'Municipio de Bauta', 'CU', '15'),
(21690, 55, 886, 'Municipio de Guanajay', 'CU', '15'),
(21691, 55, 886, 'Municipio de Mariel', 'CU', '15'),
(21692, 55, 886, 'Municipio de San Cristóbal', 'CU', '15'),
(21693, 55, 886, 'San Antonio de los Baños', 'CU', '15'),
(21694, 55, 886, 'San Cristobal', 'CU', '15'),
(21695, 55, 886, 'Soroa', 'CU', '15'),
(21696, 55, 887, 'Camagüey', 'CU', '09'),
(21697, 55, 887, 'El Caney', 'CU', '09'),
(21698, 55, 887, 'Esmeralda', 'CU', '09'),
(21699, 55, 887, 'Florida', 'CU', '09'),
(21700, 55, 887, 'Guáimaro', 'CU', '09'),
(21701, 55, 887, 'Jimaguayú', 'CU', '09'),
(21702, 55, 887, 'Minas', 'CU', '09'),
(21703, 55, 887, 'Municipio de Florida', 'CU', '09'),
(21704, 55, 887, 'Municipio de Nuevitas', 'CU', '09'),
(21705, 55, 887, 'Nuevitas', 'CU', '09'),
(21706, 55, 887, 'Santa Cruz del Sur', 'CU', '09'),
(21707, 55, 887, 'Sibanicú', 'CU', '09'),
(21708, 55, 887, 'Vertientes', 'CU', '09'),
(21709, 55, 888, 'Baraguá', 'CU', '08'),
(21710, 55, 888, 'Chambas', 'CU', '08'),
(21711, 55, 888, 'Ciego de Ávila', 'CU', '08'),
(21712, 55, 888, 'Ciro Redondo', 'CU', '08'),
(21713, 55, 888, 'Florencia', 'CU', '08'),
(21714, 55, 888, 'Morón', 'CU', '08'),
(21715, 55, 888, 'Municipio de Ciego de Ávila', 'CU', '08'),
(21716, 55, 888, 'Municipio de Morón', 'CU', '08'),
(21717, 55, 888, 'Primero de Enero', 'CU', '08'),
(21718, 55, 888, 'Venezuela', 'CU', '08'),
(21719, 55, 889, 'Abreus', 'CU', '06'),
(21720, 55, 889, 'Aguada de Pasajeros', 'CU', '06'),
(21721, 55, 889, 'Cienfuegos', 'CU', '06'),
(21722, 55, 889, 'Cruces', 'CU', '06'),
(21723, 55, 889, 'Cumanayagua', 'CU', '06'),
(21724, 55, 889, 'Lajas', 'CU', '06'),
(21725, 55, 889, 'Municipio de Abreus', 'CU', '06'),
(21726, 55, 889, 'Municipio de Cienfuegos', 'CU', '06'),
(21727, 55, 889, 'Palmira', 'CU', '06'),
(21728, 55, 889, 'Rodas', 'CU', '06'),
(21729, 55, 890, 'Bartolomé Masó', 'CU', '12'),
(21730, 55, 890, 'Bayamo', 'CU', '12'),
(21731, 55, 890, 'Campechuela', 'CU', '12'),
(21732, 55, 890, 'Cauto Cristo', 'CU', '12'),
(21733, 55, 890, 'Guisa', 'CU', '12'),
(21734, 55, 890, 'Jiguaní', 'CU', '12'),
(21735, 55, 890, 'Manzanillo', 'CU', '12'),
(21736, 55, 890, 'Media Luna', 'CU', '12'),
(21737, 55, 890, 'Municipio de Bayamo', 'CU', '12'),
(21738, 55, 890, 'Municipio de Manzanillo', 'CU', '12'),
(21739, 55, 890, 'Municipio de Niquero', 'CU', '12'),
(21740, 55, 890, 'Niquero', 'CU', '12'),
(21741, 55, 890, 'Río Cauto', 'CU', '12'),
(21742, 55, 890, 'Yara', 'CU', '12'),
(21743, 55, 891, 'Baracoa', 'CU', '14'),
(21744, 55, 891, 'Guantánamo', 'CU', '14'),
(21745, 55, 891, 'Maisí', 'CU', '14'),
(21746, 55, 891, 'Municipio de Guantánamo', 'CU', '14'),
(21747, 55, 891, 'Río Guayabal de Yateras', 'CU', '14'),
(21748, 55, 891, 'San Antonio del Sur', 'CU', '14'),
(21749, 55, 892, 'Alamar', 'CU', '03'),
(21750, 55, 892, 'Arroyo Naranjo', 'CU', '03'),
(21751, 55, 892, 'Boyeros', 'CU', '03'),
(21752, 55, 892, 'Centro Habana', 'CU', '03'),
(21753, 55, 892, 'Cerro', 'CU', '03'),
(21754, 55, 892, 'Diez de Octubre', 'CU', '03'),
(21755, 55, 892, 'Guanabacoa', 'CU', '03'),
(21756, 55, 892, 'Habana del Este', 'CU', '03'),
(21757, 55, 892, 'Havana', 'CU', '03'),
(21758, 55, 892, 'La Habana Vieja', 'CU', '03'),
(21759, 55, 892, 'Regla', 'CU', '03'),
(21760, 55, 892, 'San Miguel del Padrón', 'CU', '03'),
(21761, 55, 892, 'Santiago de las Vegas', 'CU', '03'),
(21762, 55, 893, 'Banes', 'CU', '11'),
(21763, 55, 893, 'Cacocum', 'CU', '11'),
(21764, 55, 893, 'Cueto', 'CU', '11'),
(21765, 55, 893, 'Gibara', 'CU', '11'),
(21766, 55, 893, 'Holguín', 'CU', '11'),
(21767, 55, 893, 'Jobabo', 'CU', '11'),
(21768, 55, 893, 'Moa', 'CU', '11'),
(21769, 55, 893, 'Municipio de Banes', 'CU', '11'),
(21770, 55, 893, 'Municipio de Holguín', 'CU', '11'),
(21771, 55, 893, 'Sagua de Tánamo', 'CU', '11'),
(21772, 55, 893, 'San Germán', 'CU', '11'),
(21773, 55, 894, 'Nueva Gerona', 'CU', '99'),
(21774, 55, 895, 'Amancio', 'CU', '10'),
(21775, 55, 895, 'Colombia', 'CU', '10'),
(21776, 55, 895, 'Jesús Menéndez', 'CU', '10'),
(21777, 55, 895, 'Jobabo', 'CU', '10'),
(21778, 55, 895, 'Las Tunas', 'CU', '10'),
(21779, 55, 895, 'Manatí', 'CU', '10'),
(21780, 55, 895, 'Puerto Padre', 'CU', '10'),
(21781, 55, 896, 'Alacranes', 'CU', '04'),
(21782, 55, 896, 'Bolondrón', 'CU', '04'),
(21783, 55, 896, 'Calimete', 'CU', '04'),
(21784, 55, 896, 'Cárdenas', 'CU', '04'),
(21785, 55, 896, 'Colón', 'CU', '04'),
(21786, 55, 896, 'Jagüey Grande', 'CU', '04'),
(21787, 55, 896, 'Jovellanos', 'CU', '04'),
(21788, 55, 896, 'Limonar', 'CU', '04'),
(21789, 55, 896, 'Los Arabos', 'CU', '04'),
(21790, 55, 896, 'Manguito', 'CU', '04'),
(21791, 55, 896, 'Martí', 'CU', '04'),
(21792, 55, 896, 'Matanzas', 'CU', '04'),
(21793, 55, 896, 'Municipio de Cárdenas', 'CU', '04'),
(21794, 55, 896, 'Municipio de Matanzas', 'CU', '04'),
(21795, 55, 896, 'Pedro Betancourt', 'CU', '04'),
(21796, 55, 896, 'Perico', 'CU', '04'),
(21797, 55, 896, 'Unión de Reyes', 'CU', '04'),
(21798, 55, 896, 'Varadero', 'CU', '04'),
(21799, 55, 897, 'Batabanó', 'CU', '16'),
(21800, 55, 897, 'Bejucal', 'CU', '16'),
(21801, 55, 897, 'Güines', 'CU', '16'),
(21802, 55, 897, 'Jamaica', 'CU', '16'),
(21803, 55, 897, 'Jaruco', 'CU', '16'),
(21804, 55, 897, 'La Salud', 'CU', '16'),
(21805, 55, 897, 'Madruga', 'CU', '16'),
(21806, 55, 897, 'Municipio de Güines', 'CU', '16'),
(21807, 55, 897, 'Municipio de Melena del Sur', 'CU', '16'),
(21808, 55, 897, 'Quivicán', 'CU', '16'),
(21809, 55, 897, 'San José de las Lajas', 'CU', '16'),
(21810, 55, 897, 'San Nicolás de Bari', 'CU', '16'),
(21811, 55, 897, 'Santa Cruz del Norte', 'CU', '16'),
(21812, 55, 898, 'Consolación del Sur', 'CU', '01'),
(21813, 55, 898, 'Guane', 'CU', '01'),
(21814, 55, 898, 'Los Palacios', 'CU', '01'),
(21815, 55, 898, 'Mantua', 'CU', '01'),
(21816, 55, 898, 'Minas de Matahambre', 'CU', '01'),
(21817, 55, 898, 'Municipio de Consolación del Sur', 'CU', '01'),
(21818, 55, 898, 'Municipio de Guane', 'CU', '01'),
(21819, 55, 898, 'Municipio de La Palma', 'CU', '01'),
(21820, 55, 898, 'Municipio de Los Palacios', 'CU', '01'),
(21821, 55, 898, 'Pinar del Río', 'CU', '01'),
(21822, 55, 898, 'Puerto Esperanza', 'CU', '01'),
(21823, 55, 898, 'San Diego de Los Baños', 'CU', '01'),
(21824, 55, 898, 'San Luis', 'CU', '01'),
(21825, 55, 898, 'Viñales', 'CU', '01'),
(21826, 55, 899, 'Cabaiguán', 'CU', '07'),
(21827, 55, 899, 'Condado', 'CU', '07'),
(21828, 55, 899, 'Fomento', 'CU', '07'),
(21829, 55, 899, 'Guayos', 'CU', '07'),
(21830, 55, 899, 'Jatibonico', 'CU', '07'),
(21831, 55, 899, 'La Sierpe', 'CU', '07'),
(21832, 55, 899, 'Municipio de Cabaiguán', 'CU', '07'),
(21833, 55, 899, 'Municipio de Jatibonico', 'CU', '07'),
(21834, 55, 899, 'Municipio de Sancti Spíritus', 'CU', '07'),
(21835, 55, 899, 'Municipio de Trinidad', 'CU', '07'),
(21836, 55, 899, 'Sancti Spíritus', 'CU', '07'),
(21837, 55, 899, 'Topes de Collantes', 'CU', '07'),
(21838, 55, 899, 'Trinidad', 'CU', '07'),
(21839, 55, 899, 'Yaguajay', 'CU', '07'),
(21840, 55, 899, 'Zaza del Medio', 'CU', '07'),
(21841, 55, 900, 'Contramaestre', 'CU', '13'),
(21842, 55, 900, 'El Cobre', 'CU', '13'),
(21843, 55, 900, 'Municipio de Palma Soriano', 'CU', '13'),
(21844, 55, 900, 'Municipio de Santiago de Cuba', 'CU', '13'),
(21845, 55, 900, 'Palma Soriano', 'CU', '13'),
(21846, 55, 900, 'San Luis', 'CU', '13'),
(21847, 55, 900, 'Santiago de Cuba', 'CU', '13'),
(21848, 55, 901, 'Caibarién', 'CU', '05'),
(21849, 55, 901, 'Calabazar de Sagua', 'CU', '05'),
(21850, 55, 901, 'Camajuaní', 'CU', '05'),
(21851, 55, 901, 'Cifuentes', 'CU', '05'),
(21852, 55, 901, 'Corralillo', 'CU', '05'),
(21853, 55, 901, 'Encrucijada', 'CU', '05'),
(21854, 55, 901, 'Esperanza', 'CU', '05'),
(21855, 55, 901, 'Isabela de Sagua', 'CU', '05'),
(21856, 55, 901, 'Manicaragua', 'CU', '05'),
(21857, 55, 901, 'Municipio de Placetas', 'CU', '05'),
(21858, 55, 901, 'Municipio de Santa Clara', 'CU', '05'),
(21859, 55, 901, 'Placetas', 'CU', '05'),
(21860, 55, 901, 'Quemado de Güines', 'CU', '05'),
(21861, 55, 901, 'Rancho Veloz', 'CU', '05'),
(21862, 55, 901, 'Ranchuelo', 'CU', '05'),
(21863, 55, 901, 'Sagua la Grande', 'CU', '05'),
(21864, 55, 901, 'Santa Clara', 'CU', '05'),
(21865, 55, 901, 'Santo Domingo', 'CU', '05'),
(21866, 57, 902, 'Acherítou', 'CY', '04'),
(21867, 57, 902, 'Áchna', 'CY', '04'),
(21868, 57, 902, 'Ammochostos Municipality', 'CY', '04'),
(21869, 57, 902, 'Avgórou', 'CY', '04'),
(21870, 57, 902, 'Ayia Napa', 'CY', '04'),
(21871, 57, 902, 'Derýneia', 'CY', '04'),
(21872, 57, 902, 'Famagusta', 'CY', '04'),
(21873, 57, 902, 'Frénaros', 'CY', '04'),
(21874, 57, 902, 'Lefkónoiko', 'CY', '04'),
(21875, 57, 902, 'Leonárisso', 'CY', '04'),
(21876, 57, 902, 'Liopétri', 'CY', '04'),
(21877, 57, 902, 'Paralímni', 'CY', '04'),
(21878, 57, 902, 'Protaras', 'CY', '04'),
(21879, 57, 902, 'Rizokárpaso', 'CY', '04'),
(21880, 57, 902, 'Tríkomo', 'CY', '04'),
(21881, 57, 903, 'Kyrenia', 'CY', '06'),
(21882, 57, 903, 'Kyrenia Municipality', 'CY', '06'),
(21883, 57, 903, 'Lápithos', 'CY', '06'),
(21884, 57, 904, 'Aradíppou', 'CY', '03'),
(21885, 57, 904, 'Athíenou', 'CY', '03'),
(21886, 57, 904, 'Dhromolaxia', 'CY', '03'),
(21887, 57, 904, 'Kíti', 'CY', '03'),
(21888, 57, 904, 'Kofínou', 'CY', '03'),
(21889, 57, 904, 'Kolossi', 'CY', '03'),
(21890, 57, 904, 'Kórnos', 'CY', '03'),
(21891, 57, 904, 'Larnaca', 'CY', '03'),
(21892, 57, 904, 'Livádia', 'CY', '03'),
(21893, 57, 904, 'Meneou', 'CY', '03'),
(21894, 57, 904, 'Mosfilotí', 'CY', '03'),
(21895, 57, 904, 'Pérgamos', 'CY', '03'),
(21896, 57, 904, 'Perivólia', 'CY', '03'),
(21897, 57, 904, 'Psevdás', 'CY', '03'),
(21898, 57, 904, 'Pýla', 'CY', '03'),
(21899, 57, 904, 'Tersefánou', 'CY', '03'),
(21900, 57, 904, 'Troúlloi', 'CY', '03'),
(21901, 57, 904, 'Voróklini', 'CY', '03'),
(21902, 57, 904, 'Xylofágou', 'CY', '03'),
(21903, 57, 904, 'Xylotymbou', 'CY', '03'),
(21904, 57, 905, 'Ágios Tomás', 'CY', '02'),
(21905, 57, 905, 'Ágios Týchon', 'CY', '03'),
(21906, 57, 905, 'Erími', 'CY', '02'),
(21907, 57, 905, 'Germasógeia', 'CY', '02'),
(21908, 57, 905, 'Kyperoúnta', 'CY', '02'),
(21909, 57, 905, 'Lemesós', 'CY', '02'),
(21910, 57, 905, 'Limassol', 'CY', '02'),
(21911, 57, 905, 'Mouttagiáka', 'CY', '02'),
(21912, 57, 905, 'Páchna', 'CY', '02'),
(21913, 57, 905, 'Páno Polemídia', 'CY', '02'),
(21914, 57, 905, 'Parekklisha', 'CY', '02'),
(21915, 57, 905, 'Peléndri', 'CY', '02'),
(21916, 57, 905, 'Pissoúri', 'CY', '02'),
(21917, 57, 905, 'Pyrgos', 'CY', '02'),
(21918, 57, 905, 'Sotíra', 'CY', '02'),
(21919, 57, 905, 'Soúni-Zanakiá', 'CY', '02'),
(21920, 57, 905, 'Ýpsonas', 'CY', '02'),
(21921, 57, 906, 'Akáki', 'CY', '01'),
(21922, 57, 906, 'Alámpra', 'CY', '01'),
(21923, 57, 906, 'Aredioú', 'CY', '01'),
(21924, 57, 906, 'Astromerítis', 'CY', '01'),
(21925, 57, 906, 'Dáli', 'CY', '01'),
(21926, 57, 906, 'Ergátes', 'CY', '01'),
(21927, 57, 906, 'Géri', 'CY', '01'),
(21928, 57, 906, 'Kakopetriá', 'CY', '01'),
(21929, 57, 906, 'Káto Defterá', 'CY', '01'),
(21930, 57, 906, 'Káto Pýrgos', 'CY', '01'),
(21931, 57, 906, 'Klírou', 'CY', '01'),
(21932, 57, 906, 'Kokkinotrimithiá', 'CY', '01'),
(21933, 57, 906, 'Léfka', 'CY', '01'),
(21934, 57, 906, 'Lýmpia', 'CY', '01'),
(21935, 57, 906, 'Lythrodóntas', 'CY', '01'),
(21936, 57, 906, 'Mámmari', 'CY', '01'),
(21937, 57, 906, 'Méniko', 'CY', '01'),
(21938, 57, 906, 'Mórfou', 'CY', '01'),
(21939, 57, 906, 'Nicosia', 'CY', '01'),
(21940, 57, 906, 'Nicosia Municipality', 'CY', '01'),
(21941, 57, 906, 'Páno Defterá', 'CY', '01'),
(21942, 57, 906, 'Péra', 'CY', '01'),
(21943, 57, 906, 'Peristeróna', 'CY', '01'),
(21944, 57, 906, 'Psimolofou', 'CY', '01'),
(21945, 57, 906, 'Tséri', 'CY', '01'),
(21946, 57, 907, 'Argáka', 'CY', '05'),
(21947, 57, 907, 'Chlórakas', 'CY', '05'),
(21948, 57, 907, 'Emba', 'CY', '05'),
(21949, 57, 907, 'Geroskipou', 'CY', '05'),
(21950, 57, 907, 'Geroskípou (quarter)', 'CY', '05'),
(21951, 57, 907, 'Geroskípou Municipality', 'CY', '05'),
(21952, 57, 907, 'Kissonerga', 'CY', '05'),
(21953, 57, 907, 'Koloni', 'CY', '05'),
(21954, 57, 907, 'Konia', 'CY', '05'),
(21955, 57, 907, 'Mesógi', 'CY', '05'),
(21956, 57, 907, 'Paphos', 'CY', '05'),
(21957, 57, 907, 'Pégeia', 'CY', '05'),
(21958, 57, 907, 'Pólis', 'CY', '05'),
(21959, 57, 907, 'Tála', 'CY', '05'),
(21960, 57, 907, 'Tsáda', 'CY', '05'),
(21961, 58, 931, 'Bavorov', 'CZ', '31'),
(21962, 58, 931, 'Bechyně', 'CZ', '31'),
(21963, 58, 931, 'Benešov nad Černou', 'CZ', '31'),
(21964, 58, 931, 'Bernartice', 'CZ', '31'),
(21965, 58, 931, 'Blatná', 'CZ', '31'),
(21966, 58, 931, 'Borek', 'CZ', '31'),
(21967, 58, 931, 'Borová Lada', 'CZ', '31'),
(21968, 58, 931, 'Borovany', 'CZ', '31'),
(21969, 58, 931, 'Brloh', 'CZ', '31'),
(21970, 58, 931, 'České Budějovice', 'CZ', '31'),
(21971, 58, 931, 'České Velenice', 'CZ', '31'),
(21972, 58, 931, 'Český Krumlov', 'CZ', '31'),
(21973, 58, 931, 'Český Rudolec', 'CZ', '31'),
(21974, 58, 931, 'Chlum u Třeboně', 'CZ', '31'),
(21975, 58, 931, 'Chotoviny', 'CZ', '31'),
(21976, 58, 931, 'Chvalšiny', 'CZ', '31'),
(21977, 58, 931, 'Chýnov', 'CZ', '31'),
(21978, 58, 931, 'Chyšky', 'CZ', '31'),
(21979, 58, 931, 'Čimelice', 'CZ', '31'),
(21980, 58, 931, 'Čkyně', 'CZ', '31'),
(21981, 58, 931, 'Dačice', 'CZ', '31'),
(21982, 58, 931, 'Dolní Bukovsko', 'CZ', '31'),
(21983, 58, 931, 'Dolní Dvořiště', 'CZ', '31'),
(21984, 58, 931, 'Dřiteň', 'CZ', '31'),
(21985, 58, 931, 'Dubné', 'CZ', '31'),
(21986, 58, 931, 'Frymburk', 'CZ', '31'),
(21987, 58, 931, 'Hluboká nad Vltavou', 'CZ', '31'),
(21988, 58, 931, 'Horní Planá', 'CZ', '31'),
(21989, 58, 931, 'Horní Stropnice', 'CZ', '31'),
(21990, 58, 931, 'Hrdějovice', 'CZ', '31'),
(21991, 58, 931, 'Husinec', 'CZ', '31'),
(21992, 58, 931, 'Jarošov nad Nežárkou', 'CZ', '31'),
(21993, 58, 931, 'Jindřichův Hradec', 'CZ', '31'),
(21994, 58, 931, 'Jistebnice', 'CZ', '31'),
(21995, 58, 931, 'Kájov', 'CZ', '31'),
(21996, 58, 931, 'Kamenný Újezd', 'CZ', '31'),
(21997, 58, 931, 'Kaplice', 'CZ', '31'),
(21998, 58, 931, 'Kardašova Řečice', 'CZ', '31'),
(21999, 58, 931, 'Katovice', 'CZ', '31'),
(22000, 58, 931, 'Kovářov', 'CZ', '31');

INSERT INTO `cities` (`id`, `country_id`, `state_id`, `name`, `country_code`, `state_code`) VALUES
(22001, 58, 931, 'Křemže', 'CZ', '31'),
(22002, 58, 931, 'Kunžak', 'CZ', '31'),
(22003, 58, 931, 'Ledenice', 'CZ', '31'),
(22004, 58, 931, 'Lhenice', 'CZ', '31'),
(22005, 58, 931, 'Lišov', 'CZ', '31'),
(22006, 58, 931, 'Litvínovice', 'CZ', '31'),
(22007, 58, 931, 'Lomnice nad Lužnicí', 'CZ', '31'),
(22008, 58, 931, 'Loučovice', 'CZ', '31'),
(22009, 58, 931, 'Malonty', 'CZ', '31'),
(22010, 58, 931, 'Malšice', 'CZ', '31'),
(22011, 58, 931, 'Milevsko', 'CZ', '31'),
(22012, 58, 931, 'Mirotice', 'CZ', '31'),
(22013, 58, 931, 'Mirovice', 'CZ', '31'),
(22014, 58, 931, 'Mladá Vožice', 'CZ', '31'),
(22015, 58, 931, 'Netolice', 'CZ', '31'),
(22016, 58, 931, 'Nová Bystřice', 'CZ', '31'),
(22017, 58, 931, 'Nová Včelnice', 'CZ', '31'),
(22018, 58, 931, 'Nové Hrady', 'CZ', '31'),
(22019, 58, 931, 'Okres České Budějovice', 'CZ', '31'),
(22020, 58, 931, 'Okres Český Krumlov', 'CZ', '31'),
(22021, 58, 931, 'Okres Jindřichův Hradec', 'CZ', '31'),
(22022, 58, 931, 'Okres Písek', 'CZ', '31'),
(22023, 58, 931, 'Okres Prachatice', 'CZ', '31'),
(22024, 58, 931, 'Okres Strakonice', 'CZ', '31'),
(22025, 58, 931, 'Okres Tábor', 'CZ', '31'),
(22026, 58, 931, 'Opařany', 'CZ', '31'),
(22027, 58, 931, 'Písek', 'CZ', '31'),
(22028, 58, 931, 'Planá nad Lužnicí', 'CZ', '31'),
(22029, 58, 931, 'Prachatice', 'CZ', '31'),
(22030, 58, 931, 'Protivín', 'CZ', '31'),
(22031, 58, 931, 'Radomyšl', 'CZ', '31'),
(22032, 58, 931, 'Rudolfov', 'CZ', '31'),
(22033, 58, 931, 'Sedlice', 'CZ', '31'),
(22034, 58, 931, 'Sepekov', 'CZ', '31'),
(22035, 58, 931, 'Ševětín', 'CZ', '31'),
(22036, 58, 931, 'Sezimovo Ústí', 'CZ', '31'),
(22037, 58, 931, 'Slavonice', 'CZ', '31'),
(22038, 58, 931, 'Soběslav', 'CZ', '31'),
(22039, 58, 931, 'Srubec', 'CZ', '31'),
(22040, 58, 931, 'Stachy', 'CZ', '31'),
(22041, 58, 931, 'Strakonice', 'CZ', '31'),
(22042, 58, 931, 'Strmilov', 'CZ', '31'),
(22043, 58, 931, 'Strunkovice nad Blanicí', 'CZ', '31'),
(22044, 58, 931, 'Studená', 'CZ', '31'),
(22045, 58, 931, 'Suchdol nad Lužnicí', 'CZ', '31'),
(22046, 58, 931, 'Tábor', 'CZ', '31'),
(22047, 58, 931, 'Třeboň', 'CZ', '31'),
(22048, 58, 931, 'Trhové Sviny', 'CZ', '31'),
(22049, 58, 931, 'Týn nad Vltavou', 'CZ', '31'),
(22050, 58, 931, 'Vacov', 'CZ', '31'),
(22051, 58, 931, 'Včelná', 'CZ', '31'),
(22052, 58, 931, 'Velešín', 'CZ', '31'),
(22053, 58, 931, 'Veselí nad Lužnicí', 'CZ', '31'),
(22054, 58, 931, 'Větřní', 'CZ', '31'),
(22055, 58, 931, 'Vimperk', 'CZ', '31'),
(22056, 58, 931, 'Vlachovo Březí', 'CZ', '31'),
(22057, 58, 931, 'Vodňany', 'CZ', '31'),
(22058, 58, 931, 'Volary', 'CZ', '31'),
(22059, 58, 931, 'Volyně', 'CZ', '31'),
(22060, 58, 931, 'Vyšší Brod', 'CZ', '31'),
(22061, 58, 931, 'Zdíkov', 'CZ', '31'),
(22062, 58, 931, 'Zliv', 'CZ', '31'),
(22063, 58, 932, 'Adamov', 'CZ', '64'),
(22064, 58, 932, 'Bílovice nad Svitavou', 'CZ', '64'),
(22065, 58, 932, 'Blansko', 'CZ', '64'),
(22066, 58, 932, 'Blažovice', 'CZ', '64'),
(22067, 58, 932, 'Blížkovice', 'CZ', '64'),
(22068, 58, 932, 'Blučina', 'CZ', '64'),
(22069, 58, 932, 'Bořetice', 'CZ', '64'),
(22070, 58, 932, 'Bořitov', 'CZ', '64'),
(22071, 58, 932, 'Boskovice', 'CZ', '64'),
(22072, 58, 932, 'Bošovice', 'CZ', '64'),
(22073, 58, 932, 'Božice', 'CZ', '64'),
(22074, 58, 932, 'Břeclav', 'CZ', '64'),
(22075, 58, 932, 'Březí', 'CZ', '64'),
(22076, 58, 932, 'Brno', 'CZ', '64'),
(22077, 58, 932, 'Bučovice', 'CZ', '64'),
(22078, 58, 932, 'Bzenec', 'CZ', '64'),
(22079, 58, 932, 'Čebín', 'CZ', '64'),
(22080, 58, 932, 'Čejč', 'CZ', '64'),
(22081, 58, 932, 'Čejkovice', 'CZ', '64'),
(22082, 58, 932, 'Černá Hora', 'CZ', '64'),
(22083, 58, 932, 'Dambořice', 'CZ', '64'),
(22084, 58, 932, 'Dobšice', 'CZ', '64'),
(22085, 58, 932, 'Dolní Bojanovice', 'CZ', '64'),
(22086, 58, 932, 'Dolní Dunajovice', 'CZ', '64'),
(22087, 58, 932, 'Dolní Kounice', 'CZ', '64'),
(22088, 58, 932, 'Dolní Loućky', 'CZ', '64'),
(22089, 58, 932, 'Domanín', 'CZ', '64'),
(22090, 58, 932, 'Doubravice nad Svitavou', 'CZ', '64'),
(22091, 58, 932, 'Drásov', 'CZ', '64'),
(22092, 58, 932, 'Drnholec', 'CZ', '64'),
(22093, 58, 932, 'Drnovice', 'CZ', '64'),
(22094, 58, 932, 'Dubňany', 'CZ', '64'),
(22095, 58, 932, 'Hevlín', 'CZ', '64'),
(22096, 58, 932, 'Hlohovec', 'CZ', '64'),
(22097, 58, 932, 'Hodonice', 'CZ', '64'),
(22098, 58, 932, 'Hodonín', 'CZ', '64'),
(22099, 58, 932, 'Hostěradice', 'CZ', '64'),
(22100, 58, 932, 'Hovorany', 'CZ', '64'),
(22101, 58, 932, 'Hroznová Lhota', 'CZ', '64'),
(22102, 58, 932, 'Hrušky', 'CZ', '64'),
(22103, 58, 932, 'Hrušovany nad Jevišovkou', 'CZ', '64'),
(22104, 58, 932, 'Hrušovany u Brna', 'CZ', '64'),
(22105, 58, 932, 'Hustopeče', 'CZ', '64'),
(22106, 58, 932, 'Ivančice', 'CZ', '64'),
(22107, 58, 932, 'Ivanovice na Hané', 'CZ', '64'),
(22108, 58, 932, 'Jaroslavice', 'CZ', '64'),
(22109, 58, 932, 'Jedovnice', 'CZ', '64'),
(22110, 58, 932, 'Jevišovice', 'CZ', '64'),
(22111, 58, 932, 'Klobouky', 'CZ', '64'),
(22112, 58, 932, 'Kněždub', 'CZ', '64'),
(22113, 58, 932, 'Kobylí', 'CZ', '64'),
(22114, 58, 932, 'Kostice', 'CZ', '64'),
(22115, 58, 932, 'Křenovice', 'CZ', '64'),
(22116, 58, 932, 'Křepice', 'CZ', '64'),
(22117, 58, 932, 'Krumvíř', 'CZ', '64'),
(22118, 58, 932, 'Kunštát', 'CZ', '64'),
(22119, 58, 932, 'Kuřim', 'CZ', '64'),
(22120, 58, 932, 'Kyjov', 'CZ', '64'),
(22121, 58, 932, 'Lanžhot', 'CZ', '64'),
(22122, 58, 932, 'Lednice', 'CZ', '64'),
(22123, 58, 932, 'Lelekovice', 'CZ', '64'),
(22124, 58, 932, 'Letonice', 'CZ', '64'),
(22125, 58, 932, 'Letovice', 'CZ', '64'),
(22126, 58, 932, 'Lipov', 'CZ', '64'),
(22127, 58, 932, 'Lipovec', 'CZ', '64'),
(22128, 58, 932, 'Lipůvka', 'CZ', '64'),
(22129, 58, 932, 'Lomnice', 'CZ', '64'),
(22130, 58, 932, 'Louka', 'CZ', '64'),
(22131, 58, 932, 'Lužice', 'CZ', '64'),
(22132, 58, 932, 'Lysice', 'CZ', '64'),
(22133, 58, 932, 'Měnín', 'CZ', '64'),
(22134, 58, 932, 'Město Brno', 'CZ', '64'),
(22135, 58, 932, 'Mikulčice', 'CZ', '64'),
(22136, 58, 932, 'Mikulov', 'CZ', '64'),
(22137, 58, 932, 'Milotice', 'CZ', '64'),
(22138, 58, 932, 'Miroslav', 'CZ', '64'),
(22139, 58, 932, 'Modřice', 'CZ', '64'),
(22140, 58, 932, 'Mokrá Hora', 'CZ', '64'),
(22141, 58, 932, 'Moravany', 'CZ', '64'),
(22142, 58, 932, 'Moravská Nová Ves', 'CZ', '64'),
(22143, 58, 932, 'Moravský Krumlov', 'CZ', '64'),
(22144, 58, 932, 'Moravský Písek', 'CZ', '64'),
(22145, 58, 932, 'Moravský Žižkov', 'CZ', '64'),
(22146, 58, 932, 'Moutnice', 'CZ', '64'),
(22147, 58, 932, 'Mutěnice', 'CZ', '64'),
(22148, 58, 932, 'Nedvědice', 'CZ', '64'),
(22149, 58, 932, 'Nesovice', 'CZ', '64'),
(22150, 58, 932, 'Nosislav', 'CZ', '64'),
(22151, 58, 932, 'Novosedly', 'CZ', '64'),
(22152, 58, 932, 'Okres Blansko', 'CZ', '64'),
(22153, 58, 932, 'Okres Břeclav', 'CZ', '64'),
(22154, 58, 932, 'Okres Brno-venkov', 'CZ', '64'),
(22155, 58, 932, 'Okres Hodonín', 'CZ', '64'),
(22156, 58, 932, 'Okres Vyškov', 'CZ', '64'),
(22157, 58, 932, 'Okres Znojmo', 'CZ', '64'),
(22158, 58, 932, 'Olbramovice', 'CZ', '64'),
(22159, 58, 932, 'Olešnice', 'CZ', '64'),
(22160, 58, 932, 'Ořechov', 'CZ', '64'),
(22161, 58, 932, 'Oslavany', 'CZ', '64'),
(22162, 58, 932, 'Ostopovice', 'CZ', '64'),
(22163, 58, 932, 'Ostrov u Macochy', 'CZ', '64'),
(22164, 58, 932, 'Otnice', 'CZ', '64'),
(22165, 58, 932, 'Petrov', 'CZ', '64'),
(22166, 58, 932, 'Podivín', 'CZ', '64'),
(22167, 58, 932, 'Podolí', 'CZ', '64'),
(22168, 58, 932, 'Pohořelice', 'CZ', '64'),
(22169, 58, 932, 'Pozořice', 'CZ', '64'),
(22170, 58, 932, 'Předklášteří', 'CZ', '64'),
(22171, 58, 932, 'Prušánky', 'CZ', '64'),
(22172, 58, 932, 'Pustiměř', 'CZ', '64'),
(22173, 58, 932, 'Rájec-Jestřebí', 'CZ', '64'),
(22174, 58, 932, 'Ráječko', 'CZ', '64'),
(22175, 58, 932, 'Rajhrad', 'CZ', '64'),
(22176, 58, 932, 'Rajhradice', 'CZ', '64'),
(22177, 58, 932, 'Rakvice', 'CZ', '64'),
(22178, 58, 932, 'Ratíškovice', 'CZ', '64'),
(22179, 58, 932, 'Říčany', 'CZ', '64'),
(22180, 58, 932, 'Rohatec', 'CZ', '64'),
(22181, 58, 932, 'Rosice', 'CZ', '64'),
(22182, 58, 932, 'Rousínov', 'CZ', '64'),
(22183, 58, 932, 'Šakvice', 'CZ', '64'),
(22184, 58, 932, 'Šanov', 'CZ', '64'),
(22185, 58, 932, 'Šardice', 'CZ', '64'),
(22186, 58, 932, 'Šatov', 'CZ', '64'),
(22187, 58, 932, 'Šitbořice', 'CZ', '64'),
(22188, 58, 932, 'Šlapanice', 'CZ', '64'),
(22189, 58, 932, 'Slavkov u Brna', 'CZ', '64'),
(22190, 58, 932, 'Sokolnice', 'CZ', '64'),
(22191, 58, 932, 'Strážnice', 'CZ', '64'),
(22192, 58, 932, 'Střelice', 'CZ', '64'),
(22193, 58, 932, 'Suchohrdly', 'CZ', '64'),
(22194, 58, 932, 'Sudoměřice', 'CZ', '64'),
(22195, 58, 932, 'Svitávka', 'CZ', '64'),
(22196, 58, 932, 'Tasovice', 'CZ', '64'),
(22197, 58, 932, 'Telnice', 'CZ', '64'),
(22198, 58, 932, 'Těšany', 'CZ', '64'),
(22199, 58, 932, 'Tišnov', 'CZ', '64'),
(22200, 58, 932, 'Troubsko', 'CZ', '64'),
(22201, 58, 932, 'Tvarožná', 'CZ', '64'),
(22202, 58, 932, 'Tvrdonice', 'CZ', '64'),
(22203, 58, 932, 'Týnec', 'CZ', '64'),
(22204, 58, 932, 'Únanov', 'CZ', '64'),
(22205, 58, 932, 'Vacenovice', 'CZ', '64'),
(22206, 58, 932, 'Valtice', 'CZ', '64'),
(22207, 58, 932, 'Velká nad Veličkou', 'CZ', '64'),
(22208, 58, 932, 'Velké Bílovice', 'CZ', '64'),
(22209, 58, 932, 'Velké Němčice', 'CZ', '64'),
(22210, 58, 932, 'Velké Opatovice', 'CZ', '64'),
(22211, 58, 932, 'Velké Pavlovice', 'CZ', '64'),
(22212, 58, 932, 'Veselí nad Moravou', 'CZ', '64'),
(22213, 58, 932, 'Veverská Bítýška', 'CZ', '64'),
(22214, 58, 932, 'Viničné Šumice', 'CZ', '64'),
(22215, 58, 932, 'Višňové', 'CZ', '64'),
(22216, 58, 932, 'Vlkoš', 'CZ', '64'),
(22217, 58, 932, 'Vnorovy', 'CZ', '64'),
(22218, 58, 932, 'Vojkovice', 'CZ', '64'),
(22219, 58, 932, 'Vracov', 'CZ', '64'),
(22220, 58, 932, 'Vranovice', 'CZ', '64'),
(22221, 58, 932, 'Vrbice', 'CZ', '64'),
(22222, 58, 932, 'Vrbovec', 'CZ', '64'),
(22223, 58, 932, 'Vyškov', 'CZ', '64'),
(22224, 58, 932, 'Žabčice', 'CZ', '64'),
(22225, 58, 932, 'Zaječí', 'CZ', '64'),
(22226, 58, 932, 'Zastávka', 'CZ', '64'),
(22227, 58, 932, 'Zbraslav', 'CZ', '64'),
(22228, 58, 932, 'Zbýšov', 'CZ', '64'),
(22229, 58, 932, 'Ždánice', 'CZ', '64'),
(22230, 58, 932, 'Želešice', 'CZ', '64'),
(22231, 58, 932, 'Žeravice', 'CZ', '64'),
(22232, 58, 932, 'Židlochovice', 'CZ', '64'),
(22233, 58, 932, 'Znojmo', 'CZ', '64'),
(22234, 58, 934, 'Abertamy', 'CZ', '41'),
(22235, 58, 934, 'Aš', 'CZ', '41'),
(22236, 58, 934, 'Bochov', 'CZ', '41'),
(22237, 58, 934, 'Březová', 'CZ', '41'),
(22238, 58, 934, 'Bukovany', 'CZ', '41'),
(22239, 58, 934, 'Cheb', 'CZ', '41'),
(22240, 58, 934, 'Chodov', 'CZ', '41'),
(22241, 58, 934, 'Dalovice', 'CZ', '41'),
(22242, 58, 934, 'Dolní Rychnov', 'CZ', '41'),
(22243, 58, 934, 'Dolní Žandov', 'CZ', '41'),
(22244, 58, 934, 'Františkovy Lázně', 'CZ', '41'),
(22245, 58, 934, 'Habartov', 'CZ', '41'),
(22246, 58, 934, 'Hazlov', 'CZ', '41'),
(22247, 58, 934, 'Horní Slavkov', 'CZ', '41'),
(22248, 58, 934, 'Hranice', 'CZ', '41'),
(22249, 58, 934, 'Hroznětín', 'CZ', '41'),
(22250, 58, 934, 'Jáchymov', 'CZ', '41'),
(22251, 58, 934, 'Karlovy Vary', 'CZ', '41'),
(22252, 58, 934, 'Klášter', 'CZ', '41'),
(22253, 58, 934, 'Kraslice', 'CZ', '41'),
(22254, 58, 934, 'Kynšperk nad Ohří', 'CZ', '41'),
(22255, 58, 934, 'Lázně Kynžvart', 'CZ', '41'),
(22256, 58, 934, 'Loket', 'CZ', '41'),
(22257, 58, 934, 'Lomnice', 'CZ', '41'),
(22258, 58, 934, 'Luby', 'CZ', '41'),
(22259, 58, 934, 'Mariánské Lázně', 'CZ', '41'),
(22260, 58, 934, 'Merklín', 'CZ', '41'),
(22261, 58, 934, 'Město', 'CZ', '41'),
(22262, 58, 934, 'Nejdek', 'CZ', '41'),
(22263, 58, 934, 'Nová Role', 'CZ', '41'),
(22264, 58, 934, 'Nové Sedlo', 'CZ', '41'),
(22265, 58, 934, 'Okres Cheb', 'CZ', '41'),
(22266, 58, 934, 'Okres Karlovy Vary', 'CZ', '41'),
(22267, 58, 934, 'Okres Sokolov', 'CZ', '41'),
(22268, 58, 934, 'Oloví', 'CZ', '41'),
(22269, 58, 934, 'Ostrov', 'CZ', '41'),
(22270, 58, 934, 'Plesná', 'CZ', '41'),
(22271, 58, 934, 'Rotava', 'CZ', '41'),
(22272, 58, 934, 'Sadov', 'CZ', '41'),
(22273, 58, 934, 'Skalná', 'CZ', '41'),
(22274, 58, 934, 'Sokolov', 'CZ', '41'),
(22275, 58, 934, 'Svatava', 'CZ', '41'),
(22276, 58, 934, 'Toužim', 'CZ', '41'),
(22277, 58, 934, 'Velká Hleďsebe', 'CZ', '41'),
(22278, 58, 934, 'Vintířov', 'CZ', '41'),
(22279, 58, 934, 'Žlutice', 'CZ', '41'),
(22280, 58, 940, 'Batelov', 'CZ', '63'),
(22281, 58, 940, 'Bohdalov', 'CZ', '63'),
(22282, 58, 940, 'Brtnice', 'CZ', '63'),
(22283, 58, 940, 'Budišov', 'CZ', '63'),
(22284, 58, 940, 'Bystřice nad Pernštejnem', 'CZ', '63'),
(22285, 58, 940, 'Černovice', 'CZ', '63'),
(22286, 58, 940, 'Chotěboř', 'CZ', '63'),
(22287, 58, 940, 'Dobronín', 'CZ', '63'),
(22288, 58, 940, 'Dolní Cerekev', 'CZ', '63'),
(22289, 58, 940, 'Golčův Jeníkov', 'CZ', '63'),
(22290, 58, 940, 'Habry', 'CZ', '63'),
(22291, 58, 940, 'Havlíčkův Brod', 'CZ', '63'),
(22292, 58, 940, 'Herálec', 'CZ', '63'),
(22293, 58, 940, 'Horní Cerekev', 'CZ', '63'),
(22294, 58, 940, 'Hrotovice', 'CZ', '63'),
(22295, 58, 940, 'Humpolec', 'CZ', '63'),
(22296, 58, 940, 'Jaroměřice nad Rokytnou', 'CZ', '63'),
(22297, 58, 940, 'Jemnice', 'CZ', '63'),
(22298, 58, 940, 'Jihlava', 'CZ', '63'),
(22299, 58, 940, 'Jimramov', 'CZ', '63'),
(22300, 58, 940, 'Kamenice', 'CZ', '63'),
(22301, 58, 940, 'Kamenice nad Lipou', 'CZ', '63'),
(22302, 58, 940, 'Kněžice', 'CZ', '63'),
(22303, 58, 940, 'Křižanov', 'CZ', '63'),
(22304, 58, 940, 'Křížová', 'CZ', '63'),
(22305, 58, 940, 'Ledeč nad Sázavou', 'CZ', '63'),
(22306, 58, 940, 'Lípa', 'CZ', '63'),
(22307, 58, 940, 'Luka nad Jihlavou', 'CZ', '63'),
(22308, 58, 940, 'Lukavec', 'CZ', '63'),
(22309, 58, 940, 'Měřín', 'CZ', '63'),
(22310, 58, 940, 'Mohelno', 'CZ', '63'),
(22311, 58, 940, 'Moravské Budějovice', 'CZ', '63'),
(22312, 58, 940, 'Náměšť nad Oslavou', 'CZ', '63'),
(22313, 58, 940, 'Nová Cerekev', 'CZ', '63'),
(22314, 58, 940, 'Nové Město na Moravě', 'CZ', '63'),
(22315, 58, 940, 'Nové Syrovice', 'CZ', '63'),
(22316, 58, 940, 'Nové Veselí', 'CZ', '63'),
(22317, 58, 940, 'Okres Havlíčkův Brod', 'CZ', '63'),
(22318, 58, 940, 'Okres Jihlava', 'CZ', '63'),
(22319, 58, 940, 'Okres Pelhřimov', 'CZ', '63'),
(22320, 58, 940, 'Okres Třebíč', 'CZ', '63'),
(22321, 58, 940, 'Okres Žďár nad Sázavou', 'CZ', '63'),
(22322, 58, 940, 'Okříšky', 'CZ', '63'),
(22323, 58, 940, 'Okrouhlice', 'CZ', '63'),
(22324, 58, 940, 'Pacov', 'CZ', '63'),
(22325, 58, 940, 'Pelhřimov', 'CZ', '63'),
(22326, 58, 940, 'Počátky', 'CZ', '63'),
(22327, 58, 940, 'Polná', 'CZ', '63'),
(22328, 58, 940, 'Přibyslav', 'CZ', '63'),
(22329, 58, 940, 'Rouchovany', 'CZ', '63'),
(22330, 58, 940, 'Stařeč', 'CZ', '63'),
(22331, 58, 940, 'Štoky', 'CZ', '63'),
(22332, 58, 940, 'Světlá nad Sázavou', 'CZ', '63'),
(22333, 58, 940, 'Svratka', 'CZ', '63'),
(22334, 58, 940, 'Telč', 'CZ', '63'),
(22335, 58, 940, 'Třebíč', 'CZ', '63'),
(22336, 58, 940, 'Třešť', 'CZ', '63'),
(22337, 58, 940, 'Velká Bíteš', 'CZ', '63'),
(22338, 58, 940, 'Velké Meziříčí', 'CZ', '63'),
(22339, 58, 940, 'Velký Beranov', 'CZ', '63'),
(22340, 58, 940, 'Vilémov', 'CZ', '63'),
(22341, 58, 940, 'Vladislav', 'CZ', '63'),
(22342, 58, 940, 'Žďár nad Sázavou', 'CZ', '63'),
(22343, 58, 940, 'Žďár nad Sázavou Druhy', 'CZ', '63'),
(22344, 58, 940, 'Želetava', 'CZ', '63'),
(22345, 58, 940, 'Želiv', 'CZ', '63'),
(22346, 58, 940, 'Žirovnice', 'CZ', '63'),
(22347, 58, 941, 'Albrechtice nad Orlicí', 'CZ', '52'),
(22348, 58, 941, 'Bílá Třemešná', 'CZ', '52'),
(22349, 58, 941, 'Borohrádek', 'CZ', '52'),
(22350, 58, 941, 'Broumov', 'CZ', '52'),
(22351, 58, 941, 'Častolovice', 'CZ', '52'),
(22352, 58, 941, 'Černilov', 'CZ', '52'),
(22353, 58, 941, 'Černožice', 'CZ', '52'),
(22354, 58, 941, 'Červený Kostelec', 'CZ', '52'),
(22355, 58, 941, 'Česká Skalice', 'CZ', '52'),
(22356, 58, 941, 'České Meziříčí', 'CZ', '52'),
(22357, 58, 941, 'Chlumec nad Cidlinou', 'CZ', '52'),
(22358, 58, 941, 'Dobruška', 'CZ', '52'),
(22359, 58, 941, 'Dolní Černilov', 'CZ', '52'),
(22360, 58, 941, 'Doudleby nad Orlicí', 'CZ', '52'),
(22361, 58, 941, 'Dvůr Králové nad Labem', 'CZ', '52'),
(22362, 58, 941, 'Hořice', 'CZ', '52'),
(22363, 58, 941, 'Hostinné', 'CZ', '52'),
(22364, 58, 941, 'Hradec Králové', 'CZ', '52'),
(22365, 58, 941, 'Hronov', 'CZ', '52'),
(22366, 58, 941, 'Jaroměř', 'CZ', '52'),
(22367, 58, 941, 'Jičín', 'CZ', '52'),
(22368, 58, 941, 'Kopidlno', 'CZ', '52'),
(22369, 58, 941, 'Kostelec nad Orlicí', 'CZ', '52'),
(22370, 58, 941, 'Kvasiny', 'CZ', '52'),
(22371, 58, 941, 'Lázně Bělohrad', 'CZ', '52'),
(22372, 58, 941, 'Libáň', 'CZ', '52'),
(22373, 58, 941, 'Machov', 'CZ', '52'),
(22374, 58, 941, 'Malé Svatoňovice', 'CZ', '52'),
(22375, 58, 941, 'Meziměstí', 'CZ', '52'),
(22376, 58, 941, 'Mladé Buky', 'CZ', '52'),
(22377, 58, 941, 'Mostek', 'CZ', '52'),
(22378, 58, 941, 'Náchod', 'CZ', '52'),
(22379, 58, 941, 'Nechanice', 'CZ', '52'),
(22380, 58, 941, 'Nová Paka', 'CZ', '52'),
(22381, 58, 941, 'Nové Město nad Metují', 'CZ', '52'),
(22382, 58, 941, 'Nový Bydžov', 'CZ', '52'),
(22383, 58, 941, 'Okres Hradec Králové', 'CZ', '52'),
(22384, 58, 941, 'Okres Jičín', 'CZ', '52'),
(22385, 58, 941, 'Okres Náchod', 'CZ', '52'),
(22386, 58, 941, 'Okres Rychnov nad Kněžnou', 'CZ', '52'),
(22387, 58, 941, 'Okres Trutnov', 'CZ', '52'),
(22388, 58, 941, 'Opočno', 'CZ', '52'),
(22389, 58, 941, 'Ostroměř', 'CZ', '52'),
(22390, 58, 941, 'Pecka', 'CZ', '52'),
(22391, 58, 941, 'Pilníkov', 'CZ', '52'),
(22392, 58, 941, 'Police nad Metují', 'CZ', '52'),
(22393, 58, 941, 'Předměřice nad Labem', 'CZ', '52'),
(22394, 58, 941, 'Provodov-Šonov', 'CZ', '52'),
(22395, 58, 941, 'Radvanice', 'CZ', '52'),
(22396, 58, 941, 'Rokytnice v Orlických Horách', 'CZ', '52'),
(22397, 58, 941, 'Rtyně v Podkrkonoší', 'CZ', '52'),
(22398, 58, 941, 'Rudník', 'CZ', '52'),
(22399, 58, 941, 'Rychnov nad Kněžnou', 'CZ', '52'),
(22400, 58, 941, 'Skuhrov nad Bělou', 'CZ', '52'),
(22401, 58, 941, 'Smidary', 'CZ', '52'),
(22402, 58, 941, 'Smiřice', 'CZ', '52'),
(22403, 58, 941, 'Sobotka', 'CZ', '52'),
(22404, 58, 941, 'Solnice', 'CZ', '52'),
(22405, 58, 941, 'Špindlerův Mlýn', 'CZ', '52'),
(22406, 58, 941, 'Stará Paka', 'CZ', '52'),
(22407, 58, 941, 'Staré Nechanice', 'CZ', '52'),
(22408, 58, 941, 'Stěžery', 'CZ', '52'),
(22409, 58, 941, 'Svoboda nad Úpou', 'CZ', '52'),
(22410, 58, 941, 'Teplice nad Metují', 'CZ', '52'),
(22411, 58, 941, 'Třebechovice pod Orebem', 'CZ', '52'),
(22412, 58, 941, 'Trutnov', 'CZ', '52'),
(22413, 58, 941, 'Týniště nad Orlicí', 'CZ', '52'),
(22414, 58, 941, 'Úpice', 'CZ', '52'),
(22415, 58, 941, 'Valdice', 'CZ', '52'),
(22416, 58, 941, 'Vamberk', 'CZ', '52'),
(22417, 58, 941, 'Velké Poříčí', 'CZ', '52'),
(22418, 58, 941, 'Velké Svatoňovice', 'CZ', '52'),
(22419, 58, 941, 'Vrchlabí', 'CZ', '52'),
(22420, 58, 941, 'Všestary', 'CZ', '52'),
(22421, 58, 941, 'Žacléř', 'CZ', '52'),
(22422, 58, 941, 'Zadní Mostek', 'CZ', '52'),
(22423, 58, 941, 'Železnice', 'CZ', '52'),
(22424, 58, 945, 'Benecko', 'CZ', '51'),
(22425, 58, 945, 'Brniště', 'CZ', '51'),
(22426, 58, 945, 'Česká Lípa', 'CZ', '51'),
(22427, 58, 945, 'Český Dub', 'CZ', '51'),
(22428, 58, 945, 'Chrastava', 'CZ', '51'),
(22429, 58, 945, 'Cvikov', 'CZ', '51'),
(22430, 58, 945, 'Desná', 'CZ', '51'),
(22431, 58, 945, 'Doksy', 'CZ', '51'),
(22432, 58, 945, 'Dubá', 'CZ', '51'),
(22433, 58, 945, 'Frýdlant', 'CZ', '51'),
(22434, 58, 945, 'Harrachov', 'CZ', '51'),
(22435, 58, 945, 'Hejnice', 'CZ', '51'),
(22436, 58, 945, 'Hodkovice nad Mohelkou', 'CZ', '51'),
(22437, 58, 945, 'Horní Branná', 'CZ', '51'),
(22438, 58, 945, 'Hrádek nad Nisou', 'CZ', '51'),
(22439, 58, 945, 'Jablonec nad Jizerou', 'CZ', '51'),
(22440, 58, 945, 'Jablonec nad Nisou', 'CZ', '51'),
(22441, 58, 945, 'Jablonné v Podještědí', 'CZ', '51'),
(22442, 58, 945, 'Janov nad Nisou', 'CZ', '51'),
(22443, 58, 945, 'Jilemnice', 'CZ', '51'),
(22444, 58, 945, 'Josefův Důl', 'CZ', '51'),
(22445, 58, 945, 'Kamenický Šenov', 'CZ', '51'),
(22446, 58, 945, 'Kořenov', 'CZ', '51'),
(22447, 58, 945, 'Košťálov', 'CZ', '51'),
(22448, 58, 945, 'Liberec', 'CZ', '51'),
(22449, 58, 945, 'Lomnice nad Popelkou', 'CZ', '51'),
(22450, 58, 945, 'Lučany nad Nisou', 'CZ', '51'),
(22451, 58, 945, 'Malá Skála', 'CZ', '51'),
(22452, 58, 945, 'Mimoň', 'CZ', '51'),
(22453, 58, 945, 'Mníšek', 'CZ', '51'),
(22454, 58, 945, 'Nové Město pod Smrkem', 'CZ', '51'),
(22455, 58, 945, 'Nový Bor', 'CZ', '51'),
(22456, 58, 945, 'Ohrazenice', 'CZ', '51'),
(22457, 58, 945, 'Okres Česká Lípa', 'CZ', '51'),
(22458, 58, 945, 'Okres Jablonec nad Nisou', 'CZ', '51'),
(22459, 58, 945, 'Okres Liberec', 'CZ', '51'),
(22460, 58, 945, 'Okres Semily', 'CZ', '51'),
(22461, 58, 945, 'Osečná', 'CZ', '51'),
(22462, 58, 945, 'Pěnčín', 'CZ', '51'),
(22463, 58, 945, 'Plavy', 'CZ', '51'),
(22464, 58, 945, 'Poniklá', 'CZ', '51'),
(22465, 58, 945, 'Příšovice', 'CZ', '51'),
(22466, 58, 945, 'Raspenava', 'CZ', '51'),
(22467, 58, 945, 'Rokytnice nad Jizerou', 'CZ', '51'),
(22468, 58, 945, 'Rovensko pod Troskami', 'CZ', '51'),
(22469, 58, 945, 'Semily', 'CZ', '51'),
(22470, 58, 945, 'Smržovka', 'CZ', '51'),
(22471, 58, 945, 'Stráž nad Nisou', 'CZ', '51'),
(22472, 58, 945, 'Stráž pod Ralskem', 'CZ', '51'),
(22473, 58, 945, 'Studenec', 'CZ', '51'),
(22474, 58, 945, 'Tanvald', 'CZ', '51'),
(22475, 58, 945, 'Turnov', 'CZ', '51'),
(22476, 58, 945, 'Valdice', 'CZ', '51'),
(22477, 58, 945, 'Velké Hamry', 'CZ', '51'),
(22478, 58, 945, 'Višňova', 'CZ', '51'),
(22479, 58, 945, 'Vysoké nad Jizerou', 'CZ', '51'),
(22480, 58, 945, 'Zákupy', 'CZ', '51'),
(22481, 58, 945, 'Žandov', 'CZ', '51'),
(22482, 58, 945, 'Železný Brod', 'CZ', '51'),
(22483, 58, 950, 'Albrechtice', 'CZ', '80'),
(22484, 58, 950, 'Bartošovice', 'CZ', '80'),
(22485, 58, 950, 'Baška', 'CZ', '80'),
(22486, 58, 950, 'Bílovec', 'CZ', '80'),
(22487, 58, 950, 'Bohumín', 'CZ', '80'),
(22488, 58, 950, 'Bohuslavice', 'CZ', '80'),
(22489, 58, 950, 'Bolatice', 'CZ', '80'),
(22490, 58, 950, 'Brantice', 'CZ'