<?php

namespace Modules\Shop\Database\Seeders;

use App\Models\Country;
use App\Models\Setting;
use Illuminate\Database\Seeder;
use Modules\Shop\Models\ShopPage;
use Nnjeim\World\Models\Currency;
use Modules\Shop\Models\ShopCoupon;
use Modules\Shop\Models\ShopCurrency;
use Modules\Shop\Models\ShopShippingMethod;

class ShopSettingSeeder extends Seeder
{
    public function run()
    {
        Setting::updateOrCreate(['tec_key' => 'general'], ['tec_value' => json_encode([
            'name'                           => 'SMA Shop',
            'store_id'                       => mt_rand(1, 3),
            'phone'                          => '010-1234-5678',
            'email'                          => 'contact@sma.tec.sh',
            'logo'                           => '/img/sma-icon.svg',
            'logo_dark'                      => '/img/sma-icon-light.svg',
            'products_per_page'              => '24',
            'shop_mode'                      => 'public',
            'hide_price'                     => '0',
            'disable_cart'                   => '0',
            'guest_checkout'                 => '0',
            'max_unpaid_orders'              => '1',
            'user_registration'              => '1',
            'new_account_email_confirmation' => '1',
        ])]);

        Setting::updateOrCreate(['tec_key' => 'seo'], ['tec_value' => json_encode([
            'title'                => 'Shop Home',
            'description'          => 'This is the shop homepage description.',
            'products_title'       => 'Our Products',
            'products_description' => 'Explore our wide range of products available for purchase.',
        ])]);

        Setting::updateOrCreate(['tec_key' => 'shop_slider'], ['tec_value' => json_encode([
            [
                'image'       => '/img/dummy.avif',
                'bg_image'    => '',
                'heading'     => 'Slider Heading 1',
                'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
                'button_text' => 'Shop Now',
                'button_link' => url('/products'),
            ],
            [
                'image'       => '/img/dummy.avif',
                'bg_image'    => '',
                'heading'     => 'Slider Heading 2',
                'description' => 'Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
                'button_text' => 'Discover More',
                'button_link' => url('/products'),
            ],
        ])]);
        Setting::updateOrCreate(['tec_key' => 'shop_cta'], ['tec_value' => json_encode([
            'bg_image'    => '/img/cta-bg.avif',
            'heading'     => 'CTA Heading',
            'description' => 'lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
            'button_text' => 'Action',
            'button_link' => url('/products'),
        ])]);
        Setting::updateOrCreate(['tec_key' => 'shop_footer'], ['tec_value' => json_encode([
            'sections' => [
                ['title' => 'Section 1', 'menus' => [
                    ['label' => 'Section 1 Link 1', 'link' => url('/products')],
                    ['label' => 'Section 1 Link 2', 'link' => url('/products')],
                    ['label' => 'Section 1 Link 3', 'link' => url('/products')],
                    ['label' => 'Section 1 Link 4', 'link' => url('/products')],
                    ['label' => 'Section 1 Link 5', 'link' => url('/products')],
                ]],
                ['title' => 'Section 2', 'menus' => [
                    ['label' => 'Section 2 Link 1', 'link' => url('/products')],
                    ['label' => 'Section 2 Link 2', 'link' => url('/products')],
                    ['label' => 'Section 2 Link 3', 'link' => url('/products')],
                    ['label' => 'Section 2 Link 4', 'link' => url('/products')],
                    ['label' => 'Section 2 Link 5', 'link' => url('/products')],
                    ['label' => 'Section 2 Link 6', 'link' => url('/products')],
                ]],
                ['title' => 'Section 3', 'menus' => [
                    ['label' => 'Section 3 Link 1', 'link' => url('/products')],
                    ['label' => 'Section 3 Link 2', 'link' => url('/products')],
                    ['label' => 'Section 3 Link 3', 'link' => url('/products')],
                ]],
                ['title' => 'Connect', 'menus' => [
                    ['label' => 'Contact Us', 'link' => url('/products')],
                    ['label' => 'Facebook', 'link' => url('/products')],
                    ['label' => 'Instagram', 'link' => url('/products')],
                    ['label' => 'LinkedIn', 'link' => url('/products')],
                ]],
            ],
        ])]);
        Setting::updateOrCreate(['tec_key' => 'page_menus'], ['tec_value' => json_encode([
            ['label' => 'Blog', 'link' => url('page/contact')],
            ['label' => 'FAQ', 'link' => url('page/contact')],
            ['label' => 'About Us', 'link' => url('page/contact')],
            ['label' => 'Contact Us', 'link' => url('page/contact')],
            ['label' => 'Privacy Policy', 'link' => url('page/contact')],
            ['label' => 'Terms of Service', 'link' => url('page/contact')],
        ])]);
        Setting::updateOrCreate(['tec_key' => 'notification'], ['tec_value' => json_encode([
            'message'     => 'Beta release! Shop module is still in pre-release testing!',
            'button_text' => 'Shop Now',
            'button_link' => url('/products'),
        ])]);
        Setting::updateOrCreate(['tec_key' => 'social_links'], ['tec_value' => json_encode([
            'facebook'  => '',
            'instagram' => '',
            'twitter'   => '',
            'linkedin'  => '',
            'youtube'   => '',
            'pinterest' => '',
        ])]);
        Setting::updateOrCreate(['tec_key' => 'newsletter_input'], ['tec_value' => '1']);
        Setting::updateOrCreate(['tec_key' => 'brands_article'], ['tec_value' => '0']);
        Setting::updateOrCreate(['tec_key' => 'payment'], ['tec_value' => json_encode([
            'default_currency' => 'USD',
            'gateway'          => 'Stripe',
            'services'         => [
                'paypal' => [
                    'enabled'   => '1',
                    'client_id' => 'AXVE4fpuDxeEDDRwoc3WDKwog6uL6yizmuM5nse54kFl3R0901VQdy2lemcWZWoTK1XRTTuUD4uLQmDF',
                    'secret'    => 'EFnQQ_XgtwgqNa6p32aWQhPyeE4jyOprFyuFZbgLji2QyJ1St2xEMPj9UCJrVyoww4zSZc0gU_zS8wv-',
                ],
                'stripe' => [
                    'enabled' => '1',
                    'key'     => 'pk_test_515LpChLkXRKe1IYhsQa8cl6Xtk0MNzoQF0g53FGtG5u0d5apCU8OqG7a1pUsbugrtVgcW2O0fM3FtCJg1d2AEdK400rQBLZNdt',
                    'secret'  => 'sk_test_515LpChLkXRKe1IYhWsCzVIdorJlvGT8wkDKUqUjo3lAAWjGVRTyFrZCqI8remH466frXeotGdl6JWnNgF7lIwHoZ00sqklcFcd',
                ],
            ],
        ])]);

        $usd = Currency::where('code', 'USD')->first();
        ShopCurrency::updateOrCreate(['currency_id' => $usd->id], ['exchange_rate' => 1.00]);
        $eur = Currency::where('code', 'EUR')->first();
        ShopCurrency::updateOrCreate(
            ['currency_id' => $eur->id],
            ['exchange_rate' => 0.9, 'show_at_end' => false, 'auto_update' => true]
        );

        ShopPage::updateOrCreate(
            ['slug' => 'about-us'],
            [
                'title'       => 'About Us',
                'description' => 'This is about us page description.',
                'body'        => 'This is test about us page :)',
            ]);

        ShopPage::updateOrCreate(
            ['slug' => 'contact'],
            [
                'title'       => 'Contact Us',
                'description' => 'Get in touch with us for any inquiries or support.',
                'body'        => '<!-- [map:Menara Kuala Lumpur] -->

<!-- [contact-form] -->',
            ]
        );

        ShopCoupon::updateOrCreate(
            ['code' => 'Test5'],
            [
                'discount'    => '5',
                'allowed'     => 1,
                'active'      => 1,
                'expiry_date' => now()->addDays(30),
            ]
        );

        ShopShippingMethod::updateOrCreate(
            ['provider_name' => 'DHL eCommerce'],
            ['rate' => 8, 'provider_name' => 'DHL eCommerce']
        );
        $india = Country::where('iso2', 'IN')->first();
        ShopShippingMethod::updateOrCreate(
            ['provider_name' => 'IndiaPost'],
            [
                'rate'          => 20,
                'provider_name' => 'IndiaPost',
                'country_id'    => $india->id,
            ]
        );
        $malaysia = Country::where('iso2', 'MY')->first();
        ShopShippingMethod::updateOrCreate(
            ['provider_name' => 'PostLaju'],
            [
                'rate'          => 30,
                'provider_name' => 'PostLaju',
                'country_id'    => $malaysia->id,
            ]
        );

        cache()->flush();
    }
}
