@php
  $errors = $errors->any() ? $errors->all() : null;
@endphp
<div x-data="{
    notifications: [],
    add(e) {
        this.notifications.push({
            id: e.timeStamp,
            type: e.detail.type,
            title: e.detail.title,
            content: e.detail.content,
        })
    },
    remove(notification) {
        this.notifications = this.notifications.filter(i => i.id !== notification.id)
    },
    init() {
        @if(session()->has('success'))
        this.add(new CustomEvent('notification', {
            detail: {
                type: 'success',
                title: '{{ addslashes(session('title')) }}',
                content: '{{ addslashes(session('success')) }}',
            },
        }));
        @endif
        @if(session()->has('error'))
        this.add(new CustomEvent('notification', {
            detail: {
                type: 'error',
                title: '{{ addslashes(session('title')) }}',
                content: '{{ addslashes(session('error')) }}',
            },
        }));
        @endif
        @if($errors)
        @foreach($errors as $error)
        this.add(new CustomEvent('notification', {
            detail: {
                type: 'error',
                {{-- title: '{{ addslashes(session('title')) }}', --}}
                content: '{{ $error }}',
            },
        }));
        @endforeach
        @endif
    }
}" class="fixed top-0 end-0 flex w-full max-w-sm flex-col space-y-4 pe-4 pt-4 sm:justify-start z-50" role="status"
  aria-live="polite" @notify.window="add($event)">
  <!-- Notification -->
  <template x-for="notification in notifications" :key="notification.id">
    <div x-data="{
        show: false,
        init() {
            this.$nextTick(() => this.show = true)
    
            setTimeout(() => this.transitionOut(), 4000)
        },
        transitionOut() {
            this.show = false
    
            setTimeout(() => this.remove(this.notification), 500)
        },
    }" x-show="show" x-transition.duration.500ms
      class="pointer-events-auto relative w-full max-w-sm rounded-lg border border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-950 p-2 shadow-lg">
      <div class="flex items-start gap-4">
        <div class="flex-1 py-1.5 ps-2.5 flex gap-2">
          <!-- Icons -->
          <div x-show="notification.type === 'info'" class="flex-shrink-0">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="mt-0.5 size-4">
              <path fill-rule="evenodd"
                d="M15 8A7 7 0 1 1 1 8a7 7 0 0 1 14 0ZM9 5a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM6.75 8a.75.75 0 0 0 0 1.5h.75v1.75a.75.75 0 0 0 1.5 0v-2.5A.75.75 0 0 0 8.25 8h-1.5Z"
                clip-rule="evenodd" />
            </svg>
            <span class="sr-only">{{ __('Information') }}:</span>
          </div>

          <div x-show="notification.type === 'success'" class="flex-shrink-0">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="mt-0.5 size-4 text-green-600">
              <path fill-rule="evenodd"
                d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14Zm3.844-8.791a.75.75 0 0 0-1.188-.918l-3.7 4.79-1.649-1.833a.75.75 0 1 0-1.114 1.004l2.25 2.5a.75.75 0 0 0 1.15-.043l4.25-5.5Z"
                clip-rule="evenodd"></path>
            </svg>
            <span class="sr-only">{{ __('Success') }}:</span>
          </div>

          <div x-show="notification.type === 'error'" class="flex-shrink-0">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="mt-0.5 size-4 text-red-600">
              <path fill-rule="evenodd"
                d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14ZM8 4a.75.75 0 0 1 .75.75v3a.75.75 0 0 1-1.5 0v-3A.75.75 0 0 1 8 4Zm0 8a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
                clip-rule="evenodd"></path>
            </svg>
            <span class="sr-only">{{ __('Error') }}:</span>
          </div>

          <!-- Text -->
          <div class="flex flex-col gap-y-2">
            <p x-text="notification.title || notification.type" class="capitalize font-medium text-sm"></p>

            <div class="text-sm text-mute" x-text="notification.content"></div>
          </div>
        </div>
        <!-- Remove button -->
        <div class="flex items-center">
          <button @click="transitionOut()" type="button"
            class="inline-flex items-center font-medium justify-center p-1.5 rounded-md hover:bg-gray-800/5 text-gray-400 hover:text-gray-800">
            <svg aria-hidden class="size-5" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd"
                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                clip-rule="evenodd"></path>
            </svg>
            <span class="sr-only">{{ __('close notification') }}</span>
          </button>
        </div>
      </div>
    </div>
  </template>
</div>
