<x-shop::jet.form-section submit="updateProfileInformation">
  <x-slot name="title">
    {{ __('Profile Information') }}
  </x-slot>

  <x-slot name="description">
    {{ __('Update your account\'s profile information and email address.') }}
  </x-slot>

  <x-slot name="form">
    <!-- Profile Photo -->
    @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
      <div x-data="{ photoName: null, photoPreview: null }" class="col-span-6 sm:col-span-4">
        <!-- Profile Photo File Input -->
        <input type="file" id="photo" class="hidden" wire:model.live="photo" x-ref="photo"
          x-on:change="
            photoName = $refs.photo.files[0].name;
            const reader = new FileReader();
            reader.onload = (e) => {
                photoPreview = e.target.result;
            };
            reader.readAsDataURL($refs.photo.files[0]);
        " />

        <x-shop::jet.label for="photo" value="{{ __('Photo') }}" />

        <!-- Current Profile Photo -->
        <div class="mt-2" x-show="! photoPreview">
          <img src="{{ $this->user->profile_photo_url }}" alt="{{ $this->user->name }}" class="rounded-full size-20 object-cover">
        </div>

        <!-- New Profile Photo Preview -->
        <div class="mt-2" x-show="photoPreview" style="display: none;">
          <span class="block rounded-full size-20 bg-cover bg-no-repeat bg-center"
            x-bind:style="'background-image: url(\'' + photoPreview + '\');'">
          </span>
        </div>

        <x-shop::jet.secondary-button class="mt-2 me-2" type="button" x-on:click.prevent="$refs.photo.click()">
          {{ __('Select A New Photo') }}
        </x-shop::jet.secondary-button>

        @if ($this->user->profile_photo_path)
          <x-shop::jet.secondary-button type="button" class="mt-2" wire:click="deleteProfilePhoto">
            {{ __('Remove Photo') }}
          </x-shop::jet.secondary-button>
        @endif

        <x-shop::jet.input-error for="photo" class="mt-2" />
      </div>
    @endif

    <!-- Name -->
    <div class="col-span-6 sm:col-span-4">
      <x-shop::jet.label for="name" value="{{ __('Name') }}" />
      <x-shop::jet.input id="name" type="text" class="mt-1 block w-full" wire:model="state.name" required autocomplete="name" />
      <x-shop::jet.input-error for="name" class="mt-2" />
    </div>

    <!-- Email -->
    <div class="col-span-6 sm:col-span-4">
      <x-shop::jet.label for="email" value="{{ __('Email') }}" />
      <x-shop::jet.input id="email" type="email" class="mt-1 block w-full" wire:model="state.email" required
        autocomplete="username" />
      <x-shop::jet.input-error for="email" class="mt-2" />

      @if (Laravel\Fortify\Features::enabled(Laravel\Fortify\Features::emailVerification()) && !$this->user->hasVerifiedEmail())
        <p class="text-sm mt-2 dark:text-white">
          {{ __('Your email address is unverified.') }}

          <button type="button"
            class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800"
            wire:click.prevent="sendEmailVerification">
            {{ __('Click here to re-send the verification email.') }}
          </button>
        </p>

        @if ($this->verificationLinkSent)
          <p class="mt-2 font-medium text-sm text-green-600 dark:text-green-400">
            {{ __('A new verification link has been sent to your email address.') }}
          </p>
        @endif
      @endif
    </div>
  </x-slot>

  <x-slot name="actions">
    <x-shop::jet.action-message class="me-3" on="saved">
      {{ __('Saved.') }}
    </x-shop::jet.action-message>

    <x-shop::jet.button wire:loading.attr="disabled" wire:target="photo">
      {{ __('Save') }}
    </x-shop::jet.button>
  </x-slot>
</x-shop::jet.form-section>
