import { usePage } from '@inertiajs/vue3';
export const getMenus = t => {
  let menus = [
    {
      name: 'main',
      heading: t('Main'),
      menus: [
        {
          name: 'dashboard',
          route: 'dashboard',
          icon: 'home',
          permissions: ['all'],
          label: t('Dashboard'),
        },
        // {
        //   name: 'pos',
        //   route: 'pos',
        //   icon: 'pos',
        //   permissions: ['pos'],
        //   label: t('Point of Sale'),
        // },
        {
          name: 'pos',
          route: 'pos',
          icon: 'pos',
          route_prefix: 'pos',
          module: 'pos_module',
          label: t('Point of Sale'),
          permissions: ['read-pos', 'read-orders'],
          sub_menu: [
            {
              name: 'pos',
              route: 'pos',
              icon: 'pos-o',
              target: 'pos',
              permissions: ['read-pos'],
              label: t('POS Sale'),
            },
            {
              name: 'settings.pos',
              route: 'settings.pos',
              icon: 'cog-o',
              target: 'pos',
              permissions: ['settings'],
              label: t('POS Settings'),
            },
            {
              name: 'orders.index',
              route: 'orders.index',
              icon: 'orders-o',
              target: 'pos',
              permissions: ['read-orders'],
              label: t('List POS Orders'),
            },
          ],
        },
        {
          name: 'orders',
          route: null,
          icon: 'squares',
          route_prefix: 'orders',
          label: t('Sales & Purchases'),
          permissions: [
            'read-sales',
            'create-sales',
            'read-purchases',
            'create-purchases',
            'read-payments',
            'read-deliveries',
            'read-quotations',
            'read-expenses',
            'read-gift-cards',
            'read-return-orders',
            'read-orders',
          ],
          sub_menu: [
            {
              name: 'sales.list',
              route: 'sales.index',
              icon: 'bag',
              target: 'orders',
              permissions: ['read-sales'],
              label: t('List All {x}', { x: t('Sales') }),
            },
            {
              name: 'sales.create',
              route: 'sales.create',
              icon: 'bag-o',
              target: 'orders',
              permissions: ['create-sales'],
              label: t('Add New {x}', { x: t('Sale') }),
            },

            { name: 'separator' },
            {
              name: 'purchases.list',
              route: 'purchases.index',
              icon: 'cart',
              target: 'orders',
              permissions: ['read-purchases'],
              label: t('List All {x}', { x: t('Purchases') }),
            },
            {
              name: 'purchases.create',
              route: 'purchases.create',
              icon: 'cart-o',
              target: 'orders',
              permissions: ['create-purchases'],
              label: t('Add New {x}', { x: t('Purchase') }),
            },

            { name: 'separator' },
            {
              name: 'payments.list',
              route: 'payments.index',
              icon: 'dollar',
              target: 'orders',
              permissions: ['read-payments'],
              label: t('Payments'),
              //   label: t('List All {x}', { x: t('Payments') }),
            },
            // {
            //   name: 'payments.create',
            //   route: 'payments.create',
            //   icon: 'dollar-o',
            //   target: 'orders',
            //   permissions: ['create-payments'],
            //   label: t('Add New {x}', { x: t('Payment') }),
            // },

            // { name: 'separator' },
            {
              name: 'deliveries.list',
              route: 'deliveries.index',
              icon: 'truck',
              target: 'orders',
              permissions: ['read-deliveries'],
              label: t('Deliveries'),
              //   label: t('List All {x}', { x: t('Payments') }),
            },
            {
              name: 'quotations.list',
              route: 'quotations.index',
              icon: 'docs',
              target: 'orders',
              permissions: ['read-quotations'],
              label: t('Quotations'),
              //   label: t('List All {x}', { x: t('Quotations') }),
            },
            {
              hidden: true,
              name: 'quotations.create',
              route: 'quotations.create',
              icon: 'docs',
              target: 'orders',
              permissions: ['create-quotations'],
              label: t('Create {x}', { x: t('Quotation') }),
            },
            {
              name: 'expenses.list',
              route: 'expenses.index',
              icon: 'money',
              target: 'orders',
              permissions: ['read-expenses'],
              label: t('Expenses'),
            },
            {
              name: 'incomes.list',
              route: 'incomes.index',
              icon: 'tipjar',
              target: 'orders',
              permissions: ['read-incomes'],
              label: t('Incomes'),
            },
            {
              name: 'gift_cards.list',
              route: 'gift_cards.index',
              icon: 'gift',
              target: 'orders',
              permissions: ['read-gift-cards'],
              label: t('Gift Cards'),
            },
            // { name: 'separator' },
            {
              name: 'return_orders.list',
              route: 'return_orders.index',
              icon: 'return',
              target: 'orders',
              permissions: ['read-return-orders'],
              label: t('Return Orders'),
            },
            {
              hidden: true,
              name: 'return_orders.create',
              route: 'return_orders.create',
              icon: 'add',
              target: 'orders',
              permissions: ['create-return_orders'],
              label: t('Add New {x}', { x: t('Return Order') }),
            },
          ],
        },
        // {
        //   name: 'sales',
        //   route: null,
        //   icon: 'bag',
        //   route_prefix: 'sales',
        //   label: t('Sales'),
        //   permissions: ['read-sales', 'create-sales', 'update-sales'],
        //   sub_menu: [
        //     {
        //       name: 'sales.list',
        //       route: 'sales.index',
        //       icon: 'list',
        //       target: 'sales',
        //       permissions: ['read-sales'],
        //       label: t('List All {x}', { x: t('Sales') }),
        //     },
        //     {
        //       name: 'sales.create',
        //       route: 'sales.create',
        //       icon: 'add',
        //       target: 'sales',
        //       permissions: ['create-sales'],
        //       label: t('Add New {x}', { x: t('Sale') }),
        //     },
        //     {
        //       name: 'products.edit',
        //       route: 'products.edit',
        //       icon: 'add',
        //       hidden: true,
        //       target: 'products',
        //       permissions: ['update-products'],
        //       label: t('Edit {x}', { x: t('Sale') }),
        //     },
        //     // { name: 'separator' },
        //     // {
        //     //   name: 'expenses.index',
        //     //   route: 'expenses.index',
        //     //   icon: 'adjust-v',
        //     //   target: 'products',
        //     //   permissions: ['read-expenses', 'update-expenses'],
        //     //   label: t('Expenses'),
        //     // },
        //   ],
        // },
        // {
        //   name: 'purchases',
        //   route: null,
        //   icon: 'cart',
        //   route_prefix: 'purchases',
        //   label: t('Purchases'),
        //   permissions: ['read-purchases', 'create-purchases', 'update-purchases'],
        //   sub_menu: [
        //     {
        //       name: 'purchases.list',
        //       route: 'purchases.index',
        //       icon: 'list',
        //       target: 'purchases',
        //       permissions: ['read-purchases'],
        //       label: t('List All {x}', { x: t('Purchases') }),
        //     },
        //     {
        //       name: 'purchases.create',
        //       route: 'purchases.create',
        //       icon: 'add',
        //       target: 'purchases',
        //       permissions: ['create-purchases'],
        //       label: t('Add New {x}', { x: t('Purchase') }),
        //     },
        //     {
        //       name: 'products.edit',
        //       route: 'products.edit',
        //       icon: 'add',
        //       hidden: true,
        //       target: 'products',
        //       permissions: ['update-products'],
        //       label: t('Edit {x}', { x: t('Purchase') }),
        //     },

        //     // { name: 'separator' },
        //     // {
        //     //   name: 'expenses.index',
        //     //   route: 'expenses.index',
        //     //   icon: 'adjust-v',
        //     //   target: 'products',
        //     //   permissions: ['read-expenses', 'update-expenses'],
        //     //   label: t('Expenses'),
        //     // },
        //   ],
        // },
        {
          name: 'products',
          route: null,
          icon: 'barcode',
          route_prefix: 'products',
          label: t('Products'),
          permissions: [
            'read-products',
            'create-products',
            'update-products',
            'import-products',
            'read-adjustments',
            'read-transfers',
            'read-stock-counts',
            'read-brands',
            'read-categories',
            'read-units',
            'read-labels',
            'read-promotions',
          ],
          sub_menu: [
            {
              name: 'products.list',
              route: 'products.index',
              icon: 'barcode',
              target: 'products',
              permissions: ['read-products'],
              label: t('List All {x}', { x: t('Products') }),
            },
            {
              name: 'products.create',
              route: 'products.create',
              icon: 'barcode-o',
              target: 'products',
              permissions: ['create-products'],
              label: t('Add New {x}', { x: t('Product') }),
            },
            {
              name: 'products.edit',
              route: 'products.edit',
              icon: 'add',
              hidden: true,
              target: 'products',
              permissions: ['update-products'],
              label: t('Edit {x}', { x: t('Product') }),
            },
            {
              name: 'products.import',
              route: 'products.import',
              icon: 'import',
              target: 'products',
              permissions: ['import-products'],
              label: t('Import {x}', { x: t('Products') }),
            },
            { name: 'separator' },
            {
              name: 'adjustments.index',
              route: 'adjustments.index',
              icon: 'adjust',
              target: 'products',
              permissions: ['read-adjustments'],
              label: t('Adjustments'),
            },
            {
              hidden: true,
              name: 'adjustments.create',
              route: 'adjustments.create',
              icon: 'adjust',
              target: 'products',
              permissions: ['create-adjustments'],
              label: t('Create {x}', { x: t('Adjustment') }),
            },
            {
              name: 'transfers.index',
              route: 'transfers.index',
              icon: 'transfer',
              target: 'products',
              permissions: ['read-transfers'],
              label: t('Transfers'),
            },
            {
              hidden: true,
              name: 'transfers.create',
              route: 'transfers.create',
              icon: 'transfer',
              target: 'products',
              permissions: ['create-transfers'],
              label: t('Create {x}', { x: t('Transfer') }),
            },
            {
              name: 'stock_counts.index',
              route: 'stock_counts.index',
              icon: 'check-badge',
              target: 'products',
              permissions: ['read-stock-counts'],
              label: t('Stock Counts'),
            },
            {
              hidden: true,
              name: 'stock_counts.create',
              route: 'stock_counts.create',
              icon: 'check-badge',
              target: 'products',
              permissions: ['create-stock-counts'],
              label: t('Create {x}', { x: t('Stock Count') }),
            },
            {
              name: 'brands.index',
              route: 'brands.index',
              icon: 'star',
              target: 'products',
              permissions: ['read-brands'],
              label: t('Brands'),
            },
            {
              name: 'categories.index',
              route: 'categories.index',
              icon: 'folder',
              target: 'products',
              permissions: ['read-categories'],
              label: t('Categories'),
            },
            {
              name: 'categories.import',
              route: 'categories.import',
              icon: 'folder',
              hidden: true,
              target: 'products',
              permissions: ['import-categories'],
              label: t('Import {x}', { x: t('Categories') }),
            },
            {
              name: 'units.index',
              route: 'units.index',
              icon: 'funnel',
              target: 'products',
              permissions: ['read-units'],
              label: t('Units'),
            },
            {
              name: 'labels.index',
              route: 'labels.index',
              icon: 'print',
              target: 'products',
              permissions: ['read-labels'],
              label: t('Labels'),
            },
            {
              name: 'promotions.index',
              route: 'promotions.index',
              icon: 'sparkles',
              target: 'products',
              permissions: ['read-promotions'],
              label: t('Promotions'),
            },
          ],
        },
        {
          name: 'repairs',
          route: null,
          icon: 'repair',
          route_prefix: 'repair',
          label: t('Repair Services'),
          permissions: ['read-service-types', 'read-repair-orders', 'create-repair-orders'],
          sub_menu: [
            {
              name: 'repair-orders.list',
              route: 'repair-orders.index',
              icon: 'repair',
              target: 'repairs',
              permissions: ['read-repair-orders'],
              label: t('List All {x}', { x: t('Repair Orders') }),
            },
            {
              name: 'repair-orders.create',
              route: 'repair-orders.create',
              icon: 'repair-o',
              target: 'repairs',
              permissions: ['create-repair-orders'],
              label: t('Add New {x}', { x: t('Repair Order') }),
            },
            {
              name: 'repair-orders.edit',
              route: 'repair-orders.edit',
              icon: 'edit',
              hidden: true,
              target: 'repairs',
              permissions: ['update-repair-orders'],
              label: t('Edit {x}', { x: t('Repair Order') }),
            },
            { name: 'separator' },
            {
              name: 'technicians.index',
              route: 'technicians.index',
              icon: 'users',
              target: 'repairs',
              permissions: ['read-technicians'],
              label: t('Technicians'),
            },
            {
              name: 'service-types.index',
              route: 'service-types.index',
              icon: 'cog',
              target: 'repairs',
              permissions: ['read-service-types'],
              label: t('Service Types'),
            },
          ],
        },
        {
          name: 'people',
          route: null,
          route_prefix: 'people',
          icon: 'people',
          label: t('People'),
          permissions: [
            'read-customers',
            'create-customers',
            'read-suppliers',
            'create-suppliers',
            'read-users',
            'create-users',
            'read-roles',
            'create-roles',
            'read-price-groups',
            'create-price-groups',
            'read-customer-groups',
            'create-customer-groups',
          ],
          sub_menu: [
            {
              name: 'customers.index',
              route: 'customers.index',
              icon: 'group',
              target: 'people',
              permissions: ['read-customers'],
              label: t('Customers'),
            },
            {
              name: 'suppliers.index',
              route: 'suppliers.index',
              icon: 'suppliers',
              target: 'people',
              permissions: ['read-suppliers'],
              label: t('Suppliers'),
            },
            { name: 'separator' },
            {
              name: 'price_groups.index',
              route: 'price_groups.index',
              icon: 'people',
              target: 'people',
              permissions: ['read-price-groups'],
              label: t('Price Groups'),
            },
            {
              name: 'customer_groups.index',
              route: 'customer_groups.index',
              icon: 'people',
              target: 'people',
              permissions: ['read-customer-groups'],
              label: t('Customer Groups'),
            },
            { name: 'separator' },
            {
              name: 'users.index',
              route: 'users.index',
              icon: 'users',
              target: 'people',
              permissions: ['read-users'],
              label: t('Users'),
            },
            {
              name: 'roles.index',
              route: 'roles.index',
              icon: 'adjust-h',
              target: 'people',
              permissions: ['read-roles'],
              label: t('Roles'),
            },
          ],
        },
        {
          name: 'accounting',
          route: null,
          route_prefix: '/admin/accounting',
          icon: 'book',
          label: t('Accounting'),
          permissions: [
            'read-accounts',
            'read-account-types',
            'read-account-transactions',
            'read-account-transfers',
            'read-assets',
            'read-asset-categories',
            'read-asset-allocations',
            'read-asset-maintenances',
          ],
          sub_menu: [
            {
              name: 'accounts.index',
              route: 'accounts.index',
              icon: 'book',
              target: 'accounting',
              permissions: ['read-accounts'],
              label: t('Accounts'),
            },
            {
              name: 'account-types.index',
              route: 'account-types.index',
              icon: 'list',
              target: 'accounting',
              permissions: ['read-account-types'],
              label: t('Account Types'),
            },
            {
              name: 'account-transfers.index',
              route: 'account-transfers.index',
              icon: 'money',
              target: 'accounting',
              permissions: ['read-account-transfers'],
              label: t('Transfers'),
            },
            {
              name: 'account-transactions.index',
              route: 'account-transactions.index',
              icon: 'transaction',
              target: 'accounting',
              permissions: ['read-account-transactions'],
              label: t('Transactions'),
            },
            { name: 'separator' },
            {
              name: 'assets.index',
              route: 'assets.index',
              icon: 'cube',
              target: 'accounting',
              permissions: ['read-assets'],
              label: t('Assets'),
            },
            {
              name: 'asset-categories.index',
              route: 'asset-categories.index',
              icon: 'folder',
              target: 'accounting',
              permissions: ['read-asset-categories'],
              label: t('Asset Categories'),
            },
            {
              name: 'asset-allocations.index',
              route: 'asset-allocations.index',
              icon: 'users',
              target: 'accounting',
              permissions: ['read-asset-allocations'],
              label: t('Asset Allocations'),
            },
            {
              name: 'asset-maintenances.index',
              route: 'asset-maintenances.index',
              icon: 'wrench',
              target: 'accounting',
              permissions: ['read-asset-maintenances'],
              label: t('Asset Maintenances'),
            },
          ],
        },
        {
          name: 'settings',
          route: null,
          route_prefix: '/admin/settings',
          icon: 'cog',
          label: t('Settings'),
          permissions: ['settings', 'read-accounts', 'read-stores', 'read-taxes', 'read-custom-fields'],
          sub_menu: [
            {
              name: 'settings.index',
              route: 'settings.index',
              icon: 'settings',
              target: 'settings',
              permissions: ['settings'],
              label: t('{x} Settings', { x: t('General') }),
            },
            {
              name: 'settings.mail',
              route: 'settings.mail',
              icon: 'envelope',
              target: 'settings',
              permissions: ['settings'],
              label: t('{x} Settings', { x: t('Mail') }),
            },
            {
              name: 'settings.payment',
              route: 'settings.payment',
              icon: 'dollar-o',
              target: 'settings',
              permissions: ['settings'],
              label: t('{x} Settings', { x: t('Payment') }),
            },
            {
              name: 'settings.barcode',
              route: 'settings.barcode',
              icon: 'scale',
              target: 'settings',
              permissions: ['settings'],
              label: t('{x} Settings', { x: t('Scale Barcode') }),
            },
            { name: 'separator' },
            {
              name: 'stores.index',
              route: 'stores.index',
              icon: 'store',
              target: 'settings',
              permissions: ['read-stores'],
              label: t('Stores'),
            },
            {
              name: 'taxes.index',
              route: 'taxes.index',
              icon: 'receipt',
              target: 'settings',
              permissions: ['read-taxes'],
              label: t('Taxes'),
            },
            {
              name: 'custom_fields.index',
              route: 'custom_fields.index',
              icon: 'textbox',
              target: 'settings',
              permissions: ['read-custom-fields'],
              label: t('Custom Fields'),
            },
          ],
        },
        {
          name: 'shop',
          route: 'shop',
          icon: 'shop',
          route_prefix: 'shop',
          module: 'shop_module',
          label: t('Shop Module'),
          permissions: ['read-settings'],
          sub_menu: [
            {
              name: 'shop.home',
              link: route().has('shop.home') ? route('shop.home') : null,
              route: 'shop.home',
              icon: 'shop-o',
              target: 'shop',
              permissions: [],
              label: t('Shop Home'),
            },
            {
              name: 'shop.settings',
              link: route().has('shop.settings') ? route('shop.settings') : null,
              route: 'shop.settings',
              icon: 'cog-o',
              target: 'shop',
              permissions: ['read-settings'],
              label: t('Shop Settings'),
            },
          ],
        },
        {
          name: 'reports',
          route: null,
          route_prefix: 'reports',
          icon: 'bar-chart',
          label: t('Reports'),
          permissions: [
            'sales-report',
            'purchases-report',
            'payments-report',
            'expenses-report',
            'products-report',
            'categories-report',
            'adjustments-report',
            'transfers-report',
            'profit_loss-report',
            'customers-report',
            'suppliers-report',
            'staff-report',
            'return-order-report',
            'activities-report',
          ],
          sub_menu: [
            {
              name: 'daily_sales.report',
              route: 'daily_sales.report',
              icon: 'calendar-dots',
              target: 'reports',
              permissions: ['sales-report'],
              label: t('{x} Report', { x: t('Daily Sales') }),
            },
            {
              name: 'monthly_sales.report',
              route: 'monthly_sales.report',
              icon: 'calendar',
              target: 'reports',
              permissions: ['sales-report'],
              label: t('{x} Report', { x: t('Monthly Sales') }),
            },
            {
              name: 'sales.report',
              route: 'sales.report',
              icon: 'bag',
              target: 'reports',
              permissions: ['sales-report'],
              label: t('{x} Report', { x: t('Sales') }),
            },
            {
              name: 'registers.report',
              route: 'registers.report',
              icon: 'register',
              target: 'reports',
              permissions: ['registers-report'],
              label: t('{x} Report', { x: t('Registers') }),
            },
            {
              name: 'purchases.report',
              route: 'purchases.report',
              icon: 'cart',
              target: 'reports',
              permissions: ['purchases-report'],
              label: t('{x} Report', { x: t('Purchases') }),
            },
            {
              name: 'payments.report',
              route: 'payments.report',
              icon: 'dollar',
              target: 'reports',
              permissions: ['payments-report'],
              label: t('{x} Report', { x: t('Payments') }),
            },
            {
              name: 'expenses.report',
              route: 'expenses.report',
              icon: 'money',
              target: 'reports',
              permissions: ['expenses-report'],
              label: t('{x} Report', { x: t('Expenses') }),
            },
            {
              name: 'products.report',
              route: 'products.report',
              icon: 'barcode',
              target: 'reports',
              permissions: ['products-report'],
              label: t('{x} Report', { x: t('Products') }),
            },
            {
              name: 'brands.report',
              route: 'brands.report',
              icon: 'star',
              target: 'reports',
              permissions: ['brands-report'],
              label: t('{x} Report', { x: t('Brands') }),
            },
            {
              name: 'categories.report',
              route: 'categories.report',
              icon: 'folder',
              target: 'reports',
              permissions: ['categories-report'],
              label: t('{x} Report', { x: t('Categories') }),
            },
            {
              name: 'adjustments.report',
              route: 'adjustments.report',
              icon: 'adjust',
              target: 'reports',
              permissions: ['adjustments-report'],
              label: t('{x} Report', { x: t('Adjustments') }),
            },
            {
              name: 'transfers.report',
              route: 'transfers.report',
              icon: 'transfer',
              target: 'reports',
              permissions: ['transfers-report'],
              label: t('{x} Report', { x: t('Transfers') }),
            },
            {
              name: 'return_orders.report',
              route: 'return_orders.report',
              icon: 'return',
              target: 'reports',
              permissions: ['return-orders-report'],
              label: t('{x} Report', { x: t('Return Order') }),
            },
            {
              name: 'profit_loss.report',
              route: 'profit_loss.report',
              icon: 'chart-xac',
              target: 'reports',
              permissions: ['profit_loss-report'],
              label: t('{x} Report', { x: t('Profit & Loss') }),
            },
            {
              name: 'customers.report',
              route: 'customers.report',
              icon: 'group',
              target: 'reports',
              permissions: ['customers-report'],
              label: t('{x} Report', { x: t('Customers') }),
            },
            {
              name: 'suppliers.report',
              route: 'suppliers.report',
              icon: 'suppliers',
              target: 'reports',
              permissions: ['suppliers-report'],
              label: t('{x} Report', { x: t('Suppliers') }),
            },
            {
              name: 'staff.report',
              route: 'staff.report',
              icon: 'users',
              target: 'reports',
              permissions: ['staff-report'],
              label: t('{x} Report', { x: t('Staff') }),
            },
            {
              name: 'activities.report',
              route: 'activities.report',
              icon: 'file-text',
              target: 'reports',
              permissions: ['activities-report'],
              label: t('{x} Report', { x: t('Activities') }),
            },
          ],
        },
      ],
    },

    {
      name: 'support',
      heading: 'Support',
      menus: [
        {
          link: 'https://tecdiary.github.io/sma-guide/',
          name: 'docs',
          route: 'docs',
          icon: 'docs2',
          hidden: false,
          sub_menu: false,
          permissions: ['all'],
          label: t('Docs'),
        },
        {
          link: 'https://tecdiary.com/support',
          name: 'support',
          route: 'support',
          icon: 'support',
          hidden: false,
          sub_menu: false,
          permissions: ['all'],
          label: t('Support'),
        },
        {
          link: 'https://tecdiary.com/changelogs/stock-manager-advance-with-all-modules',
          name: 'changelog',
          route: 'changelog',
          icon: 'code',
          hidden: false,
          sub_menu: false,
          permissions: ['all'],
          label: t('Changelog'),
        },
      ],
    },
  ];

  if (usePage().props.settings?.restaurant == 1) {
    menus[0].menus = menus[0].menus.map(menu => {
      if (menu.name == 'pos') {
        menu.sub_menu.push({
          name: 'halls.index',
          route: 'pos.halls.index',
          icon: 'building',
          target: 'pos',
          permissions: ['read-halls'],
          label: t('Restaurant Halls'),
        });
        menu.sub_menu.push({
          name: 'tables.index',
          route: 'pos.tables.index',
          icon: 'grid',
          target: 'pos',
          permissions: ['read-tables'],
          label: t('Restaurant Tables'),
        });
        menu.sub_menu.push({
          name: 'qr-codes.index',
          route: 'pos.qr-codes.index',
          icon: 'qrcode',
          target: 'pos',
          permissions: ['read-tables'],
          label: t('Table QR Codes'),
        });
      }
      return menu;
    });
  }

  return menus;
};
