<?php

/**
 * @copyright Copyright (c) 2024 Sean Kau (kliensheng2020@gmail.com)
 * @license https://github.com/klsheng/myinvois-php-sdk/blob/main/LICENSE
 */

namespace Klsheng\Myinvois\Ubl\Constant;

/**
 * Country codes
 * 
 * @author Sean Kau (kliensheng2020@gmail.com)
 * @since 1.0.0
 */
class CountryCodes
{
    const CODE = 'Code';
    const COUNTRY = 'Country';

    const MALAYSIA = 'MYS';

    public static function getItems()
    {
        return [
            [
                CountryCodes::CODE => "ABW",
                CountryCodes::COUNTRY => "ARUBA"
            ],
            [
                CountryCodes::CODE => "AFG",
                CountryCodes::COUNTRY => "AFGHANISTAN"
            ],
            [
                CountryCodes::CODE => "AGO",
                CountryCodes::COUNTRY => "ANGOLA"
            ],
            [
                CountryCodes::CODE => "AIA",
                CountryCodes::COUNTRY => "ANGUILLA"
            ],
            [
                CountryCodes::CODE => "ALA",
                CountryCodes::COUNTRY => "ALAND ISLANDS"
            ],
            [
                CountryCodes::CODE => "ALB",
                CountryCodes::COUNTRY => "ALBANIA"
            ],
            [
                CountryCodes::CODE => "AND",
                CountryCodes::COUNTRY => "ANDORA"
            ],
            [
                CountryCodes::CODE => "ANT",
                CountryCodes::COUNTRY => "NETHERLANDS ANTILLE"
            ],
            [
                CountryCodes::CODE => "ARE",
                CountryCodes::COUNTRY => "UNITED ARAB EMIRATES"
            ],
            [
                CountryCodes::CODE => "ARG",
                CountryCodes::COUNTRY => "ARGENTINA"
            ],
            [
                CountryCodes::CODE => "ARM",
                CountryCodes::COUNTRY => "ARMENIA"
            ],
            [
                CountryCodes::CODE => "ASM",
                CountryCodes::COUNTRY => "AMERICAN SAMOA"
            ],
            [
                CountryCodes::CODE => "ATA",
                CountryCodes::COUNTRY => "ANTARCTICA"
            ],
            [
                CountryCodes::CODE => "ATF",
                CountryCodes::COUNTRY => "FRENCH SOUTHERN TERRITORIES"
            ],
            [
                CountryCodes::CODE => "ATG",
                CountryCodes::COUNTRY => "ANTIGUA AND BARBUDA"
            ],
            [
                CountryCodes::CODE => "AUS",
                CountryCodes::COUNTRY => "AUSTRALIA"
            ],
            [
                CountryCodes::CODE => "AUT",
                CountryCodes::COUNTRY => "AUSTRIA"
            ],
            [
                CountryCodes::CODE => "AZE",
                CountryCodes::COUNTRY => "AZERBAIDJAN"
            ],
            [
                CountryCodes::CODE => "BDI",
                CountryCodes::COUNTRY => "BURUNDI"
            ],
            [
                CountryCodes::CODE => "BEL",
                CountryCodes::COUNTRY => "BELGIUM"
            ],
            [
                CountryCodes::CODE => "BEN",
                CountryCodes::COUNTRY => "BENIN"
            ],
            [
                CountryCodes::CODE => "BES",
                CountryCodes::COUNTRY => "BONAIRE, SINT EUSTATIUS AND SABA"
            ],
            [
                CountryCodes::CODE => "BFA",
                CountryCodes::COUNTRY => "BURKINA FASO"
            ],
            [
                CountryCodes::CODE => "BGD",
                CountryCodes::COUNTRY => "BANGLADESH"
            ],
            [
                CountryCodes::CODE => "BGR",
                CountryCodes::COUNTRY => "BULGARIA"
            ],
            [
                CountryCodes::CODE => "BHR",
                CountryCodes::COUNTRY => "BAHRAIN"
            ],
            [
                CountryCodes::CODE => "BHS",
                CountryCodes::COUNTRY => "BAHAMAS"
            ],
            [
                CountryCodes::CODE => "BIH",
                CountryCodes::COUNTRY => "BOSNIA AND HERZEGOVINA"
            ],
            [
                CountryCodes::CODE => "BLM",
                CountryCodes::COUNTRY => "SAINT BARTHELEMY"
            ],
            [
                CountryCodes::CODE => "BLR",
                CountryCodes::COUNTRY => "BELARUS"
            ],
            [
                CountryCodes::CODE => "BLZ",
                CountryCodes::COUNTRY => "BELIZE"
            ],
            [
                CountryCodes::CODE => "BMU",
                CountryCodes::COUNTRY => "BERMUDA"
            ],
            [
                CountryCodes::CODE => "BOL",
                CountryCodes::COUNTRY => "BOLIVIA"
            ],
            [
                CountryCodes::CODE => "BRA",
                CountryCodes::COUNTRY => "BRAZIL"
            ],
            [
                CountryCodes::CODE => "BRB",
                CountryCodes::COUNTRY => "BARBADOS"
            ],
            [
                CountryCodes::CODE => "BRN",
                CountryCodes::COUNTRY => "BRUNEI DARUSSALAM"
            ],
            [
                CountryCodes::CODE => "BTN",
                CountryCodes::COUNTRY => "BHUTAN"
            ],
            [
                CountryCodes::CODE => "BVT",
                CountryCodes::COUNTRY => "BOUVET ISLAND"
            ],
            [
                CountryCodes::CODE => "BWA",
                CountryCodes::COUNTRY => "BOTSWANA"
            ],
            [
                CountryCodes::CODE => "CAF",
                CountryCodes::COUNTRY => "CENTRAL AFRICAN REPUBLIC"
            ],
            [
                CountryCodes::CODE => "CAN",
                CountryCodes::COUNTRY => "CANADA"
            ],
            [
                CountryCodes::CODE => "CCK",
                CountryCodes::COUNTRY => "COCOS ISLAND"
            ],
            [
                CountryCodes::CODE => "CHE",
                CountryCodes::COUNTRY => "SWITZERLAND"
            ],
            [
                CountryCodes::CODE => "CHL",
                CountryCodes::COUNTRY => "CHILE"
            ],
            [
                CountryCodes::CODE => "CHN",
                CountryCodes::COUNTRY => "CHINA"
            ],
            [
                CountryCodes::CODE => "CIV",
                CountryCodes::COUNTRY => "COTE D'IVOIRE"
            ],
            [
                CountryCodes::CODE => "CMR",
                CountryCodes::COUNTRY => "CAMEROON"
            ],
            [
                CountryCodes::CODE => "COD",
                CountryCodes::COUNTRY => "CONGO, THE DEMOCRATIC REPUBLIC"
            ],
            [
                CountryCodes::CODE => "COG",
                CountryCodes::COUNTRY => "CONGO"
            ],
            [
                CountryCodes::CODE => "COK",
                CountryCodes::COUNTRY => "COOK ISLANDS "
            ],
            [
                CountryCodes::CODE => "COL",
                CountryCodes::COUNTRY => "COLOMBIA"
            ],
            [
                CountryCodes::CODE => "COM",
                CountryCodes::COUNTRY => "COMOROS"
            ],
            [
                CountryCodes::CODE => "CPV",
                CountryCodes::COUNTRY => "CABO VERDE"
            ],
            [
                CountryCodes::CODE => "CRI",
                CountryCodes::COUNTRY => "COSTA RICA"
            ],
            [
                CountryCodes::CODE => "CRM",
                CountryCodes::COUNTRY => "CRIMEA"
            ],
            [
                CountryCodes::CODE => "CUB",
                CountryCodes::COUNTRY => "CUBA"
            ],
            [
                CountryCodes::CODE => "CUW",
                CountryCodes::COUNTRY => "CURACAO"
            ],
            [
                CountryCodes::CODE => "CXR",
                CountryCodes::COUNTRY => "CHRISTMAS ISLANDS"
            ],
            [
                CountryCodes::CODE => "CYM",
                CountryCodes::COUNTRY => "CAYMAN ISLANDS"
            ],
            [
                CountryCodes::CODE => "CYP",
                CountryCodes::COUNTRY => "CYPRUS"
            ],
            [
                CountryCodes::CODE => "CZE",
                CountryCodes::COUNTRY => "CZECH REPUBLIC"
            ],
            [
                CountryCodes::CODE => "DEU",
                CountryCodes::COUNTRY => "GERMANY"
            ],
            [
                CountryCodes::CODE => "DJI",
                CountryCodes::COUNTRY => "DJIBOUTI"
            ],
            [
                CountryCodes::CODE => "DMA",
                CountryCodes::COUNTRY => "DOMINICA"
            ],
            [
                CountryCodes::CODE => "DNK",
                CountryCodes::COUNTRY => "DENMARK"
            ],
            [
                CountryCodes::CODE => "DOM",
                CountryCodes::COUNTRY => "DOMINICAN REPUBLIC"
            ],
            [
                CountryCodes::CODE => "DZA",
                CountryCodes::COUNTRY => "ALGERIA"
            ],
            [
                CountryCodes::CODE => "ECU",
                CountryCodes::COUNTRY => "ECUADOR"
            ],
            [
                CountryCodes::CODE => "EGY",
                CountryCodes::COUNTRY => "EGYPT"
            ],
            [
                CountryCodes::CODE => "ERI",
                CountryCodes::COUNTRY => "ERITREA"
            ],
            [
                CountryCodes::CODE => "ESH",
                CountryCodes::COUNTRY => "WESTERN SAHARA"
            ],
            [
                CountryCodes::CODE => "ESP",
                CountryCodes::COUNTRY => "SPAIN"
            ],
            [
                CountryCodes::CODE => "EST",
                CountryCodes::COUNTRY => "ESTONIA"
            ],
            [
                CountryCodes::CODE => "ETH",
                CountryCodes::COUNTRY => "ETHIOPIA"
            ],
            [
                CountryCodes::CODE => "FIN",
                CountryCodes::COUNTRY => "FINLAND"
            ],
            [
                CountryCodes::CODE => "FJI",
                CountryCodes::COUNTRY => "FIJI"
            ],
            [
                CountryCodes::CODE => "FLK",
                CountryCodes::COUNTRY => "FALKLAND ISLANDS (MALVINAS)"
            ],
            [
                CountryCodes::CODE => "FRA",
                CountryCodes::COUNTRY => "FRANCE"
            ],
            [
                CountryCodes::CODE => "FRO",
                CountryCodes::COUNTRY => "FAEROE ISLANDS"
            ],
            [
                CountryCodes::CODE => "FSM",
                CountryCodes::COUNTRY => "MICRONESIA, FEDERATED STATES OF"
            ],
            [
                CountryCodes::CODE => "GAB",
                CountryCodes::COUNTRY => "GABON"
            ],
            [
                CountryCodes::CODE => "GBR",
                CountryCodes::COUNTRY => "UNITED KINGDOM"
            ],
            [
                CountryCodes::CODE => "GEO",
                CountryCodes::COUNTRY => "GEORGIA"
            ],
            [
                CountryCodes::CODE => "GGY",
                CountryCodes::COUNTRY => "GUERNSEY"
            ],
            [
                CountryCodes::CODE => "GHA",
                CountryCodes::COUNTRY => "GHANA"
            ],
            [
                CountryCodes::CODE => "GIB",
                CountryCodes::COUNTRY => "GIBRALTAR"
            ],
            [
                CountryCodes::CODE => "GIN",
                CountryCodes::COUNTRY => "GUINEA"
            ],
            [
                CountryCodes::CODE => "GLP",
                CountryCodes::COUNTRY => "GUADELOUPE"
            ],
            [
                CountryCodes::CODE => "GMB",
                CountryCodes::COUNTRY => "GAMBIA"
            ],
            [
                CountryCodes::CODE => "GNB",
                CountryCodes::COUNTRY => "GUINEA-BISSAU"
            ],
            [
                CountryCodes::CODE => "GNQ",
                CountryCodes::COUNTRY => "EQUATORIAL GUINEA"
            ],
            [
                CountryCodes::CODE => "GRC",
                CountryCodes::COUNTRY => "GREECE"
            ],
            [
                CountryCodes::CODE => "GRD",
                CountryCodes::COUNTRY => "GRENADA"
            ],
            [
                CountryCodes::CODE => "GRL",
                CountryCodes::COUNTRY => "GREENLAND"
            ],
            [
                CountryCodes::CODE => "GTM",
                CountryCodes::COUNTRY => "GUATEMALA"
            ],
            [
                CountryCodes::CODE => "GUF",
                CountryCodes::COUNTRY => "FRENCH GUIANA"
            ],
            [
                CountryCodes::CODE => "GUM",
                CountryCodes::COUNTRY => "GUAM"
            ],
            [
                CountryCodes::CODE => "GUY",
                CountryCodes::COUNTRY => "GUYANA"
            ],
            [
                CountryCodes::CODE => "HKG",
                CountryCodes::COUNTRY => "HONG KONG"
            ],
            [
                CountryCodes::CODE => "HMD",
                CountryCodes::COUNTRY => "HEARD AND MCDONALD ISLANDS"
            ],
            [
                CountryCodes::CODE => "HND",
                CountryCodes::COUNTRY => "HONDURAS"
            ],
            [
                CountryCodes::CODE => "HRV",
                CountryCodes::COUNTRY => "CROATIA"
            ],
            [
                CountryCodes::CODE => "HTI",
                CountryCodes::COUNTRY => "HAITI"
            ],
            [
                CountryCodes::CODE => "HUN",
                CountryCodes::COUNTRY => "HUNGARY"
            ],
            [
                CountryCodes::CODE => "IDN",
                CountryCodes::COUNTRY => "INDONESIA"
            ],
            [
                CountryCodes::CODE => "IMN",
                CountryCodes::COUNTRY => "ISLE OF MAN"
            ],
            [
                CountryCodes::CODE => "IND",
                CountryCodes::COUNTRY => "INDIA"
            ],
            [
                CountryCodes::CODE => "IOT",
                CountryCodes::COUNTRY => "BRITISH INDIAN OCEAN TERRITORY"
            ],
            [
                CountryCodes::CODE => "IRL",
                CountryCodes::COUNTRY => "IRELAND"
            ],
            [
                CountryCodes::CODE => "IRN",
                CountryCodes::COUNTRY => "IRAN"
            ],
            [
                CountryCodes::CODE => "IRQ",
                CountryCodes::COUNTRY => "IRAQ"
            ],
            [
                CountryCodes::CODE => "ISL",
                CountryCodes::COUNTRY => "ICELAND"
            ],
            [
                CountryCodes::CODE => "ISR",
                CountryCodes::COUNTRY => "ISRAEL"
            ],
            [
                CountryCodes::CODE => "ITA",
                CountryCodes::COUNTRY => "ITALY"
            ],
            [
                CountryCodes::CODE => "JAM",
                CountryCodes::COUNTRY => "JAMAICA"
            ],
            [
                CountryCodes::CODE => "JEY",
                CountryCodes::COUNTRY => "JERSEY (CHANNEL ISLANDS)"
            ],
            [
                CountryCodes::CODE => "JOR",
                CountryCodes::COUNTRY => "JORDAN "
            ],
            [
                CountryCodes::CODE => "JPN",
                CountryCodes::COUNTRY => "JAPAN"
            ],
            [
                CountryCodes::CODE => "KAZ",
                CountryCodes::COUNTRY => "KAZAKHSTAN"
            ],
            [
                CountryCodes::CODE => "KEN",
                CountryCodes::COUNTRY => "KENYA"
            ],
            [
                CountryCodes::CODE => "KGZ",
                CountryCodes::COUNTRY => "KYRGYZSTAN"
            ],
            [
                CountryCodes::CODE => "KHM",
                CountryCodes::COUNTRY => "CAMBODIA"
            ],
            [
                CountryCodes::CODE => "KIR",
                CountryCodes::COUNTRY => "KIRIBATI"
            ],
            [
                CountryCodes::CODE => "KNA",
                CountryCodes::COUNTRY => "ST.KITTS AND NEVIS"
            ],
            [
                CountryCodes::CODE => "KOR",
                CountryCodes::COUNTRY => "THE REPUBLIC OF KOREA"
            ],
            [
                CountryCodes::CODE => "KWT",
                CountryCodes::COUNTRY => "KUWAIT"
            ],
            [
                CountryCodes::CODE => "LAO",
                CountryCodes::COUNTRY => "LAOS"
            ],
            [
                CountryCodes::CODE => "LBN",
                CountryCodes::COUNTRY => "LEBANON"
            ],
            [
                CountryCodes::CODE => "LBR",
                CountryCodes::COUNTRY => "LIBERIA"
            ],
            [
                CountryCodes::CODE => "LBY",
                CountryCodes::COUNTRY => "LIBYAN ARAB JAMAHIRIYA"
            ],
            [
                CountryCodes::CODE => "LCA",
                CountryCodes::COUNTRY => "SAINT LUCIA "
            ],
            [
                CountryCodes::CODE => "LIE",
                CountryCodes::COUNTRY => "LIECHTENSTEIN "
            ],
            [
                CountryCodes::CODE => "LKA",
                CountryCodes::COUNTRY => "SRI LANKA  "
            ],
            [
                CountryCodes::CODE => "LSO",
                CountryCodes::COUNTRY => "LESOTHO"
            ],
            [
                CountryCodes::CODE => "LTU",
                CountryCodes::COUNTRY => "LITHUANIA"
            ],
            [
                CountryCodes::CODE => "LUX",
                CountryCodes::COUNTRY => "LUXEMBOURG"
            ],
            [
                CountryCodes::CODE => "LVA",
                CountryCodes::COUNTRY => "LATVIA "
            ],
            [
                CountryCodes::CODE => "MAC",
                CountryCodes::COUNTRY => "MACAO"
            ],
            [
                CountryCodes::CODE => "MAF",
                CountryCodes::COUNTRY => "SAINT MARTIN (FRENCH PART)"
            ],
            [
                CountryCodes::CODE => "MAR",
                CountryCodes::COUNTRY => "MOROCCO"
            ],
            [
                CountryCodes::CODE => "MCO",
                CountryCodes::COUNTRY => "MONACO"
            ],
            [
                CountryCodes::CODE => "MDA",
                CountryCodes::COUNTRY => "MOLDOVA, REPUBLIC OF"
            ],
            [
                CountryCodes::CODE => "MDG",
                CountryCodes::COUNTRY => "MADAGASCAR"
            ],
            [
                CountryCodes::CODE => "MDV",
                CountryCodes::COUNTRY => "MALDIVES"
            ],
            [
                CountryCodes::CODE => "MEX",
                CountryCodes::COUNTRY => "MEXICO"
            ],
            [
                CountryCodes::CODE => "MHL",
                CountryCodes::COUNTRY => "MARSHALL ISLANDS "
            ],
            [
                CountryCodes::CODE => "MKD",
                CountryCodes::COUNTRY => "MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF"
            ],
            [
                CountryCodes::CODE => "MLI",
                CountryCodes::COUNTRY => "MALI"
            ],
            [
                CountryCodes::CODE => "MLT",
                CountryCodes::COUNTRY => "MALTA"
            ],
            [
                CountryCodes::CODE => "MMR",
                CountryCodes::COUNTRY => "MYANMAR"
            ],
            [
                CountryCodes::CODE => "MNE",
                CountryCodes::COUNTRY => "MONTENEGRO"
            ],
            [
                CountryCodes::CODE => "MNG",
                CountryCodes::COUNTRY => "MONGOLIA "
            ],
            [
                CountryCodes::CODE => "MNP",
                CountryCodes::COUNTRY => "NORTHERN MARIANA ISLANDS"
            ],
            [
                CountryCodes::CODE => "MOZ",
                CountryCodes::COUNTRY => "MOZAMBIQUE"
            ],
            [
                CountryCodes::CODE => "MRT",
                CountryCodes::COUNTRY => "MAURITANIA"
            ],
            [
                CountryCodes::CODE => "MSR",
                CountryCodes::COUNTRY => "MONTSERRAT"
            ],
            [
                CountryCodes::CODE => "MTQ",
                CountryCodes::COUNTRY => "MARTINIQUE"
            ],
            [
                CountryCodes::CODE => "MUS",
                CountryCodes::COUNTRY => "MAURITIUS"
            ],
            [
                CountryCodes::CODE => "MWI",
                CountryCodes::COUNTRY => "MALAWI"
            ],
            [
                CountryCodes::CODE => CountryCodes::MALAYSIA,
                CountryCodes::COUNTRY => "MALAYSIA"
            ],
            [
                CountryCodes::CODE => "MYT",
                CountryCodes::COUNTRY => "MAYOTTE"
            ],
            [
                CountryCodes::CODE => "NAM",
                CountryCodes::COUNTRY => "NAMIBIA"
            ],
            [
                CountryCodes::CODE => "NCL",
                CountryCodes::COUNTRY => "NEW CALEDONIA "
            ],
            [
                CountryCodes::CODE => "NER",
                CountryCodes::COUNTRY => "NIGER"
            ],
            [
                CountryCodes::CODE => "NFK",
                CountryCodes::COUNTRY => "NORFOLK ISLAND"
            ],
            [
                CountryCodes::CODE => "NGA",
                CountryCodes::COUNTRY => "NIGERIA"
            ],
            [
                CountryCodes::CODE => "NIC",
                CountryCodes::COUNTRY => "NICARAGUA"
            ],
            [
                CountryCodes::CODE => "NIU",
                CountryCodes::COUNTRY => "NIUE"
            ],
            [
                CountryCodes::CODE => "NLD",
                CountryCodes::COUNTRY => "NETHERLANDS"
            ],
            [
                CountryCodes::CODE => "NOR",
                CountryCodes::COUNTRY => "NORWAY"
            ],
            [
                CountryCodes::CODE => "NPL",
                CountryCodes::COUNTRY => "NEPAL"
            ],
            [
                CountryCodes::CODE => "NRU",
                CountryCodes::COUNTRY => "NAURU"
            ],
            [
                CountryCodes::CODE => "NZL",
                CountryCodes::COUNTRY => "NEW ZEALAND "
            ],
            [
                CountryCodes::CODE => "OMN",
                CountryCodes::COUNTRY => "OMAN"
            ],
            [
                CountryCodes::CODE => "PAK",
                CountryCodes::COUNTRY => "PAKISTAN"
            ],
            [
                CountryCodes::CODE => "PAN",
                CountryCodes::COUNTRY => "PANAMA"
            ],
            [
                CountryCodes::CODE => "PCN",
                CountryCodes::COUNTRY => "PITCAIRN"
            ],
            [
                CountryCodes::CODE => "PER",
                CountryCodes::COUNTRY => "PERU"
            ],
            [
                CountryCodes::CODE => "PHL",
                CountryCodes::COUNTRY => "PHILIPPINES"
            ],
            [
                CountryCodes::CODE => "PLW",
                CountryCodes::COUNTRY => "PALAU"
            ],
            [
                CountryCodes::CODE => "PNG",
                CountryCodes::COUNTRY => "PAPUA NEW GUINEA"
            ],
            [
                CountryCodes::CODE => "POL",
                CountryCodes::COUNTRY => "POLAND"
            ],
            [
                CountryCodes::CODE => "PRI",
                CountryCodes::COUNTRY => "PUERTO RICO"
            ],
            [
                CountryCodes::CODE => "PRK",
                CountryCodes::COUNTRY => "DEMOC.PEOPLES REP.OF KOREA"
            ],
            [
                CountryCodes::CODE => "PRT",
                CountryCodes::COUNTRY => "PORTUGAL"
            ],
            [
                CountryCodes::CODE => "PRY",
                CountryCodes::COUNTRY => "PARAGUAY"
            ],
            [
                CountryCodes::CODE => "PSE",
                CountryCodes::COUNTRY => "PALESTINIAN TERRITORY, OCCUPIED"
            ],
            [
                CountryCodes::CODE => "PYF",
                CountryCodes::COUNTRY => "FRENCH POLYNESIA"
            ],
            [
                CountryCodes::CODE => "QAT",
                CountryCodes::COUNTRY => "QATAR"
            ],
            [
                CountryCodes::CODE => "REU",
                CountryCodes::COUNTRY => "REUNION"
            ],
            [
                CountryCodes::CODE => "ROU",
                CountryCodes::COUNTRY => "ROMANIA"
            ],
            [
                CountryCodes::CODE => "RUS",
                CountryCodes::COUNTRY => "RUSSIAN FEDERATION (USSR)"
            ],
            [
                CountryCodes::CODE => "RWA",
                CountryCodes::COUNTRY => "RWANDA"
            ],
            [
                CountryCodes::CODE => "SAU",
                CountryCodes::COUNTRY => "SAUDI ARABIA"
            ],
            [
                CountryCodes::CODE => "SCT",
                CountryCodes::COUNTRY => "SCOTLAND"
            ],
            [
                CountryCodes::CODE => "SDN",
                CountryCodes::COUNTRY => "SUDAN"
            ],
            [
                CountryCodes::CODE => "SEN",
                CountryCodes::COUNTRY => "SENEGAL"
            ],
            [
                CountryCodes::CODE => "SGP",
                CountryCodes::COUNTRY => "SINGAPORE"
            ],
            [
                CountryCodes::CODE => "SGS",
                CountryCodes::COUNTRY => "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLAND"
            ],
            [
                CountryCodes::CODE => "SHN",
                CountryCodes::COUNTRY => "ST. HELENA "
            ],
            [
                CountryCodes::CODE => "SJM",
                CountryCodes::COUNTRY => "SVALBARD AND JAN MAYEN ISLANDS"
            ],
            [
                CountryCodes::CODE => "SLB",
                CountryCodes::COUNTRY => "SOLOMON ISLANDS"
            ],
            [
                CountryCodes::CODE => "SLE",
                CountryCodes::COUNTRY => "SIERRA LEONE"
            ],
            [
                CountryCodes::CODE => "SLV",
                CountryCodes::COUNTRY => "EL SALVADOR"
            ],
            [
                CountryCodes::CODE => "SMR",
                CountryCodes::COUNTRY => "SAN MARINO"
            ],
            [
                CountryCodes::CODE => "SOM",
                CountryCodes::COUNTRY => "SOMALIA"
            ],
            [
                CountryCodes::CODE => "SPM",
                CountryCodes::COUNTRY => "ST. PIERRE AND MIQUELON"
            ],
            [
                CountryCodes::CODE => "SRB",
                CountryCodes::COUNTRY => "SERBIA & MONTENEGRO "
            ],
            [
                CountryCodes::CODE => "SSD",
                CountryCodes::COUNTRY => "SOUTH SUDAN"
            ],
            [
                CountryCodes::CODE => "STP",
                CountryCodes::COUNTRY => "SAO TOME AND PRINCIPE"
            ],
            [
                CountryCodes::CODE => "SUR",
                CountryCodes::COUNTRY => "SURINAME"
            ],
            [
                CountryCodes::CODE => "SVK",
                CountryCodes::COUNTRY => "SLOVAK REPUBLIC"
            ],
            [
                CountryCodes::CODE => "SVN",
                CountryCodes::COUNTRY => "SLOVENIA"
            ],
            [
                CountryCodes::CODE => "SWE",
                CountryCodes::COUNTRY => "SWEDEN"
            ],
            [
                CountryCodes::CODE => "SWZ",
                CountryCodes::COUNTRY => "ESWATINI, KINGDOM OF (SWAZILAND)"
            ],
            [
                CountryCodes::CODE => "SXM",
                CountryCodes::COUNTRY => "SINT MAARTEN"
            ],
            [
                CountryCodes::CODE => "SYC",
                CountryCodes::COUNTRY => "SEYCHELLES"
            ],
            [
                CountryCodes::CODE => "SYR",
                CountryCodes::COUNTRY => "SYRIAN ARAB REPUBLIC"
            ],
            [
                CountryCodes::CODE => "TCA",
                CountryCodes::COUNTRY => "TURKS AND CAICOS ISLANDS"
            ],
            [
                CountryCodes::CODE => "TCD",
                CountryCodes::COUNTRY => "CHAD"
            ],
            [
                CountryCodes::CODE => "TGO",
                CountryCodes::COUNTRY => "TOGO"
            ],
            [
                CountryCodes::CODE => "THA",
                CountryCodes::COUNTRY => "THAILAND"
            ],
            [
                CountryCodes::CODE => "TJK",
                CountryCodes::COUNTRY => "TAJIKISTAN"
            ],
            [
                CountryCodes::CODE => "TKL",
                CountryCodes::COUNTRY => "TOKELAU"
            ],
            [
                CountryCodes::CODE => "TKM",
                CountryCodes::COUNTRY => "TURKMENISTAN"
            ],
            [
                CountryCodes::CODE => "TLS",
                CountryCodes::COUNTRY => "TIMOR-LESTE "
            ],
            [
                CountryCodes::CODE => "TON",
                CountryCodes::COUNTRY => "TONGA"
            ],
            [
                CountryCodes::CODE => "TTO",
                CountryCodes::COUNTRY => "TRINIDAD AND TOBAGO"
            ],
            [
                CountryCodes::CODE => "TUN",
                CountryCodes::COUNTRY => "TUNISIA"
            ],
            [
                CountryCodes::CODE => "TUR",
                CountryCodes::COUNTRY => "TURKIYE "
            ],
            [
                CountryCodes::CODE => "TUV",
                CountryCodes::COUNTRY => "TUVALU"
            ],
            [
                CountryCodes::CODE => "TWN",
                CountryCodes::COUNTRY => "TAIWAN"
            ],
            [
                CountryCodes::CODE => "TZA",
                CountryCodes::COUNTRY => "TANZANIA UNITED REPUBLIC"
            ],
            [
                CountryCodes::CODE => "UGA",
                CountryCodes::COUNTRY => "UGANDA"
            ],
            [
                CountryCodes::CODE => "UKR",
                CountryCodes::COUNTRY => "UKRAINE"
            ],
            [
                CountryCodes::CODE => "UMI",
                CountryCodes::COUNTRY => "UNITED STATES MINOR OUTLYING ISLANDS"
            ],
            [
                CountryCodes::CODE => "URY",
                CountryCodes::COUNTRY => "URUGUAY"
            ],
            [
                CountryCodes::CODE => "USA",
                CountryCodes::COUNTRY => "UNITED STATES OF AMERICA"
            ],
            [
                CountryCodes::CODE => "UZB",
                CountryCodes::COUNTRY => "UZBEKISTAN"
            ],
            [
                CountryCodes::CODE => "VAT",
                CountryCodes::COUNTRY => "VATICAN CITY STATE (HOLY SEE)"
            ],
            [
                CountryCodes::CODE => "VCT",
                CountryCodes::COUNTRY => "SAINT VINCENT AND GRENADINES"
            ],
            [
                CountryCodes::CODE => "VEN",
                CountryCodes::COUNTRY => "VENEZUELA"
            ],
            [
                CountryCodes::CODE => "VGB",
                CountryCodes::COUNTRY => "VIRGIN ISLANDS(BRITISH)"
            ],
            [
                CountryCodes::CODE => "VIR",
                CountryCodes::COUNTRY => "VIRGIN ISLANDS(US)"
            ],
            [
                CountryCodes::CODE => "VNM",
                CountryCodes::COUNTRY => "VIETNAM"
            ],
            [
                CountryCodes::CODE => "VUT",
                CountryCodes::COUNTRY => "VANUATU"
            ],
            [
                CountryCodes::CODE => "WLF",
                CountryCodes::COUNTRY => "WALLIS AND FUTUNA ISLANDS"
            ],
            [
                CountryCodes::CODE => "WSM",
                CountryCodes::COUNTRY => "SAMOA"
            ],
            [
                CountryCodes::CODE => "XKX",
                CountryCodes::COUNTRY => "KOSOVO"
            ],
            [
                CountryCodes::CODE => "YEM",
                CountryCodes::COUNTRY => "YEMEN"
            ],
            [
                CountryCodes::CODE => "ZAF",
                CountryCodes::COUNTRY => "SOUTH AFRICA"
            ],
            [
                CountryCodes::CODE => "ZMB",
                CountryCodes::COUNTRY => "ZAMBIA"
            ],
            [
                CountryCodes::CODE => "ZWE",
                CountryCodes::COUNTRY => "ZIMBABWE"
            ],
        ];
    }
}
