<?php

/**
 * @copyright Copyright (c) 2024 Sean Kau (kliensheng2020@gmail.com)
 * @license https://github.com/klsheng/myinvois-php-sdk/blob/main/LICENSE
 */

namespace Klsheng\Myinvois\Ubl\Constant;

/**
 * Currency codes
 * 
 * @author Sean Kau (kliensheng2020@gmail.com)
 * @since 1.0.0
 */
class CurrencyCodes
{
    const CODE = 'Code';
    const CURRENCY = 'Currency';

    const MYR = 'MYR';

    public static function getItems()
    {
        return [
            [
                CurrencyCodes::CODE => 'AED',
                CurrencyCodes::CURRENCY => 'UAE Dirham'
            ],
            [
                CurrencyCodes::CODE => 'AFN',
                CurrencyCodes::CURRENCY => 'Afghani'
            ],
            [
                CurrencyCodes::CODE => 'ALL',
                CurrencyCodes::CURRENCY => 'Lek'
            ],
            [
                CurrencyCodes::CODE => 'AMD',
                CurrencyCodes::CURRENCY => 'Armenian Dram'
            ],
            [
                CurrencyCodes::CODE => 'ANG',
                CurrencyCodes::CURRENCY => 'Netherlands Antillean Guilder'
            ],
            [
                CurrencyCodes::CODE => 'AOA',
                CurrencyCodes::CURRENCY => 'Kwanza'
            ],
            [
                CurrencyCodes::CODE => 'ARS',
                CurrencyCodes::CURRENCY => 'Argentine Peso'
            ],
            [
                CurrencyCodes::CODE => 'AUD',
                CurrencyCodes::CURRENCY => 'Australian Dollar'
            ],
            [
                CurrencyCodes::CODE => 'AWG',
                CurrencyCodes::CURRENCY => 'Aruban Florin'
            ],
            [
                CurrencyCodes::CODE => 'AZN',
                CurrencyCodes::CURRENCY => 'Azerbaijan Manat'
            ],
            [
                CurrencyCodes::CODE => 'BAM',
                CurrencyCodes::CURRENCY => 'Convertible Mark'
            ],
            [
                CurrencyCodes::CODE => 'BBD',
                CurrencyCodes::CURRENCY => 'Barbados Dollar'
            ],
            [
                CurrencyCodes::CODE => 'BDT',
                CurrencyCodes::CURRENCY => 'Taka'
            ],
            [
                CurrencyCodes::CODE => 'BGN',
                CurrencyCodes::CURRENCY => 'Bulgarian Lev'
            ],
            [
                CurrencyCodes::CODE => 'BHD',
                CurrencyCodes::CURRENCY => 'Bahraini Dinar'
            ],
            [
                CurrencyCodes::CODE => 'BIF',
                CurrencyCodes::CURRENCY => 'Burundi Franc'
            ],
            [
                CurrencyCodes::CODE => 'BMD',
                CurrencyCodes::CURRENCY => 'Bermudian Dollar'
            ],
            [
                CurrencyCodes::CODE => 'BND',
                CurrencyCodes::CURRENCY => 'Brunei Dollar'
            ],
            [
                CurrencyCodes::CODE => 'BOB',
                CurrencyCodes::CURRENCY => 'Boliviano'
            ],
            [
                CurrencyCodes::CODE => 'BOV',
                CurrencyCodes::CURRENCY => 'Mvdol'
            ],
            [
                CurrencyCodes::CODE => 'BRL',
                CurrencyCodes::CURRENCY => 'Brazilian Real'
            ],
            [
                CurrencyCodes::CODE => 'BSD',
                CurrencyCodes::CURRENCY => 'Bahamian Dollar'
            ],
            [
                CurrencyCodes::CODE => 'BTN',
                CurrencyCodes::CURRENCY => 'Ngultrum'
            ],
            [
                CurrencyCodes::CODE => 'BWP',
                CurrencyCodes::CURRENCY => 'Pula'
            ],
            [
                CurrencyCodes::CODE => 'BYN',
                CurrencyCodes::CURRENCY => 'Belarusian Ruble'
            ],
            [
                CurrencyCodes::CODE => 'BZD',
                CurrencyCodes::CURRENCY => 'Belize Dollar'
            ],
            [
                CurrencyCodes::CODE => 'CAD',
                CurrencyCodes::CURRENCY => 'Canadian Dollar'
            ],
            [
                CurrencyCodes::CODE => 'CDF',
                CurrencyCodes::CURRENCY => 'Congolese Franc'
            ],
            [
                CurrencyCodes::CODE => 'CHE',
                CurrencyCodes::CURRENCY => 'WIR Euro'
            ],
            [
                CurrencyCodes::CODE => 'CHF',
                CurrencyCodes::CURRENCY => 'Swiss Franc'
            ],
            [
                CurrencyCodes::CODE => 'CHW',
                CurrencyCodes::CURRENCY => 'WIR Franc'
            ],
            [
                CurrencyCodes::CODE => 'CLF',
                CurrencyCodes::CURRENCY => 'Unidad de Fomento'
            ],
            [
                CurrencyCodes::CODE => 'CLP',
                CurrencyCodes::CURRENCY => 'Chilean Peso'
            ],
            [
                CurrencyCodes::CODE => 'CNH',
                CurrencyCodes::CURRENCY => 'Yuan Renminbi (International)'
            ],
            [
                CurrencyCodes::CODE => 'CNY',
                CurrencyCodes::CURRENCY => 'Yuan Renminbi (Domestic)'
            ],
            [
                CurrencyCodes::CODE => 'COP',
                CurrencyCodes::CURRENCY => 'Colombian Peso'
            ],
            [
                CurrencyCodes::CODE => 'COU',
                CurrencyCodes::CURRENCY => 'Unidad de Valor Real'
            ],
            [
                CurrencyCodes::CODE => 'CRC',
                CurrencyCodes::CURRENCY => 'Costa Rican Colon'
            ],
            [
                CurrencyCodes::CODE => 'CUC',
                CurrencyCodes::CURRENCY => 'Peso Convertible'
            ],
            [
                CurrencyCodes::CODE => 'CUP',
                CurrencyCodes::CURRENCY => 'Cuban Peso'
            ],
            [
                CurrencyCodes::CODE => 'CVE',
                CurrencyCodes::CURRENCY => 'Cabo Verde Escudo'
            ],
            [
                CurrencyCodes::CODE => 'CZK',
                CurrencyCodes::CURRENCY => 'Czech Koruna'
            ],
            [
                CurrencyCodes::CODE => 'DJF',
                CurrencyCodes::CURRENCY => 'Djibouti Franc'
            ],
            [
                CurrencyCodes::CODE => 'DKK',
                CurrencyCodes::CURRENCY => 'Danish Krone'
            ],
            [
                CurrencyCodes::CODE => 'DOP',
                CurrencyCodes::CURRENCY => 'Dominican Peso'
            ],
            [
                CurrencyCodes::CODE => 'DZD',
                CurrencyCodes::CURRENCY => 'Algerian Dinar'
            ],
            [
                CurrencyCodes::CODE => 'EGP',
                CurrencyCodes::CURRENCY => 'Egyptian Pound'
            ],
            [
                CurrencyCodes::CODE => 'ERN',
                CurrencyCodes::CURRENCY => 'Nakfa'
            ],
            [
                CurrencyCodes::CODE => 'ETB',
                CurrencyCodes::CURRENCY => 'Ethiopian Birr'
            ],
            [
                CurrencyCodes::CODE => 'EUR',
                CurrencyCodes::CURRENCY => 'Euro'
            ],
            [
                CurrencyCodes::CODE => 'FJD',
                CurrencyCodes::CURRENCY => 'Fiji Dollar'
            ],
            [
                CurrencyCodes::CODE => 'FKP',
                CurrencyCodes::CURRENCY => 'Falkland Islands Pound'
            ],
            [
                CurrencyCodes::CODE => 'GBP',
                CurrencyCodes::CURRENCY => 'Pound Sterling'
            ],
            [
                CurrencyCodes::CODE => 'GEL',
                CurrencyCodes::CURRENCY => 'Lari'
            ],
            [
                CurrencyCodes::CODE => 'GHS',
                CurrencyCodes::CURRENCY => 'Ghana Cedi'
            ],
            [
                CurrencyCodes::CODE => 'GIP',
                CurrencyCodes::CURRENCY => 'Gibraltar Pound'
            ],
            [
                CurrencyCodes::CODE => 'GMD',
                CurrencyCodes::CURRENCY => 'Dalasi'
            ],
            [
                CurrencyCodes::CODE => 'GNF',
                CurrencyCodes::CURRENCY => 'Guinean Franc'
            ],
            [
                CurrencyCodes::CODE => 'GTQ',
                CurrencyCodes::CURRENCY => 'Quetzal'
            ],
            [
                CurrencyCodes::CODE => 'GYD',
                CurrencyCodes::CURRENCY => 'Guyana Dollar'
            ],
            [
                CurrencyCodes::CODE => 'HKD',
                CurrencyCodes::CURRENCY => 'Hong Kong Dollar'
            ],
            [
                CurrencyCodes::CODE => 'HNL',
                CurrencyCodes::CURRENCY => 'Lempira'
            ],
            [
                CurrencyCodes::CODE => 'HTG',
                CurrencyCodes::CURRENCY => 'Gourde'
            ],
            [
                CurrencyCodes::CODE => 'HUF',
                CurrencyCodes::CURRENCY => 'Forint'
            ],
            [
                CurrencyCodes::CODE => 'IDR',
                CurrencyCodes::CURRENCY => 'Rupiah'
            ],
            [
                CurrencyCodes::CODE => 'ILS',
                CurrencyCodes::CURRENCY => 'New Israeli Sheqel'
            ],
            [
                CurrencyCodes::CODE => 'INR',
                CurrencyCodes::CURRENCY => 'Indian Rupee'
            ],
            [
                CurrencyCodes::CODE => 'IQD',
                CurrencyCodes::CURRENCY => 'Iraqi Dinar'
            ],
            [
                CurrencyCodes::CODE => 'IRR',
                CurrencyCodes::CURRENCY => 'Iranian Rial'
            ],
            [
                CurrencyCodes::CODE => 'ISK',
                CurrencyCodes::CURRENCY => 'Iceland Krona'
            ],
            [
                CurrencyCodes::CODE => 'JMD',
                CurrencyCodes::CURRENCY => 'Jamaican Dollar'
            ],
            [
                CurrencyCodes::CODE => 'JOD',
                CurrencyCodes::CURRENCY => 'Jordanian Dinar'
            ],
            [
                CurrencyCodes::CODE => 'JPY',
                CurrencyCodes::CURRENCY => 'Yen'
            ],
            [
                CurrencyCodes::CODE => 'KES',
                CurrencyCodes::CURRENCY => 'Kenyan Shilling'
            ],
            [
                CurrencyCodes::CODE => 'KGS',
                CurrencyCodes::CURRENCY => 'Som'
            ],
            [
                CurrencyCodes::CODE => 'KHR',
                CurrencyCodes::CURRENCY => 'Riel'
            ],
            [
                CurrencyCodes::CODE => 'KMF',
                CurrencyCodes::CURRENCY => 'Comorian Franc '
            ],
            [
                CurrencyCodes::CODE => 'KPW',
                CurrencyCodes::CURRENCY => 'North Korean Won'
            ],
            [
                CurrencyCodes::CODE => 'KRW',
                CurrencyCodes::CURRENCY => 'Won'
            ],
            [
                CurrencyCodes::CODE => 'KWD',
                CurrencyCodes::CURRENCY => 'Kuwaiti Dinar'
            ],
            [
                CurrencyCodes::CODE => 'KYD',
                CurrencyCodes::CURRENCY => 'Cayman Islands Dollar'
            ],
            [
                CurrencyCodes::CODE => 'KZT',
                CurrencyCodes::CURRENCY => 'Tenge'
            ],
            [
                CurrencyCodes::CODE => 'LAK',
                CurrencyCodes::CURRENCY => 'Lao Kip'
            ],
            [
                CurrencyCodes::CODE => 'LBP',
                CurrencyCodes::CURRENCY => 'Lebanese Pound'
            ],
            [
                CurrencyCodes::CODE => 'LKR',
                CurrencyCodes::CURRENCY => 'Sri Lanka Rupee'
            ],
            [
                CurrencyCodes::CODE => 'LRD',
                CurrencyCodes::CURRENCY => 'Liberian Dollar'
            ],
            [
                CurrencyCodes::CODE => 'LSL',
                CurrencyCodes::CURRENCY => 'Loti'
            ],
            [
                CurrencyCodes::CODE => 'LYD',
                CurrencyCodes::CURRENCY => 'Libyan Dinar'
            ],
            [
                CurrencyCodes::CODE => 'MAD',
                CurrencyCodes::CURRENCY => 'Moroccan Dirham'
            ],
            [
                CurrencyCodes::CODE => 'MDL',
                CurrencyCodes::CURRENCY => 'Moldovan Leu'
            ],
            [
                CurrencyCodes::CODE => 'MGA',
                CurrencyCodes::CURRENCY => 'Malagasy Ariary'
            ],
            [
                CurrencyCodes::CODE => 'MKD',
                CurrencyCodes::CURRENCY => 'Denar'
            ],
            [
                CurrencyCodes::CODE => 'MMK',
                CurrencyCodes::CURRENCY => 'Kyat'
            ],
            [
                CurrencyCodes::CODE => 'MNT',
                CurrencyCodes::CURRENCY => 'Tugrik'
            ],
            [
                CurrencyCodes::CODE => 'MOP',
                CurrencyCodes::CURRENCY => 'Pataca'
            ],
            [
                CurrencyCodes::CODE => 'MRU',
                CurrencyCodes::CURRENCY => 'Ouguiya'
            ],
            [
                CurrencyCodes::CODE => 'MUR',
                CurrencyCodes::CURRENCY => 'Mauritius Rupee'
            ],
            [
                CurrencyCodes::CODE => 'MVR',
                CurrencyCodes::CURRENCY => 'Rufiyaa'
            ],
            [
                CurrencyCodes::CODE => 'MWK',
                CurrencyCodes::CURRENCY => 'Malawi Kwacha'
            ],
            [
                CurrencyCodes::CODE => 'MXN',
                CurrencyCodes::CURRENCY => 'Mexican Peso'
            ],
            [
                CurrencyCodes::CODE => 'MXV',
                CurrencyCodes::CURRENCY => 'Mexican Unidad de Inversion (UDI)'
            ],
            [
                CurrencyCodes::CODE => CurrencyCodes::MYR,
                CurrencyCodes::CURRENCY => 'Malaysian Ringgit'
            ],
            [
                CurrencyCodes::CODE => 'MZN',
                CurrencyCodes::CURRENCY => 'Mozambique Metical'
            ],
            [
                CurrencyCodes::CODE => 'NAD',
                CurrencyCodes::CURRENCY => 'Namibia Dollar'
            ],
            [
                CurrencyCodes::CODE => 'NGN',
                CurrencyCodes::CURRENCY => 'Naira'
            ],
            [
                CurrencyCodes::CODE => 'NIO',
                CurrencyCodes::CURRENCY => 'Cordoba Oro'
            ],
            [
                CurrencyCodes::CODE => 'NOK',
                CurrencyCodes::CURRENCY => 'Norwegian Krone'
            ],
            [
                CurrencyCodes::CODE => 'NPR',
                CurrencyCodes::CURRENCY => 'Nepalese Rupee'
            ],
            [
                CurrencyCodes::CODE => 'NZD',
                CurrencyCodes::CURRENCY => 'New Zealand Dollar'
            ],
            [
                CurrencyCodes::CODE => 'OMR',
                CurrencyCodes::CURRENCY => 'Rial Omani'
            ],
            [
                CurrencyCodes::CODE => 'PAB',
                CurrencyCodes::CURRENCY => 'Balboa'
            ],
            [
                CurrencyCodes::CODE => 'PEN',
                CurrencyCodes::CURRENCY => 'Sol'
            ],
            [
                CurrencyCodes::CODE => 'PGK',
                CurrencyCodes::CURRENCY => 'Kina'
            ],
            [
                CurrencyCodes::CODE => 'PHP',
                CurrencyCodes::CURRENCY => 'Philippine Peso'
            ],
            [
                CurrencyCodes::CODE => 'PKR',
                CurrencyCodes::CURRENCY => 'Pakistan Rupee'
            ],
            [
                CurrencyCodes::CODE => 'PLN',
                CurrencyCodes::CURRENCY => 'Zloty'
            ],
            [
                CurrencyCodes::CODE => 'PYG',
                CurrencyCodes::CURRENCY => 'Guarani'
            ],
            [
                CurrencyCodes::CODE => 'QAR',
                CurrencyCodes::CURRENCY => 'Qatari Rial'
            ],
            [
                CurrencyCodes::CODE => 'RON',
                CurrencyCodes::CURRENCY => 'Romanian Leu'
            ],
            [
                CurrencyCodes::CODE => 'RSD',
                CurrencyCodes::CURRENCY => 'Serbian Dinar'
            ],
            [
                CurrencyCodes::CODE => 'RUB',
                CurrencyCodes::CURRENCY => 'Russian Ruble'
            ],
            [
                CurrencyCodes::CODE => 'RWF',
                CurrencyCodes::CURRENCY => 'Rwanda Franc'
            ],
            [
                CurrencyCodes::CODE => 'SAR',
                CurrencyCodes::CURRENCY => 'Saudi Riyal'
            ],
            [
                CurrencyCodes::CODE => 'SBD',
                CurrencyCodes::CURRENCY => 'Solomon Islands Dollar'
            ],
            [
                CurrencyCodes::CODE => 'SCR',
                CurrencyCodes::CURRENCY => 'Seychelles Rupee'
            ],
            [
                CurrencyCodes::CODE => 'SDG',
                CurrencyCodes::CURRENCY => 'Sudanese Pound'
            ],
            [
                CurrencyCodes::CODE => 'SEK',
                CurrencyCodes::CURRENCY => 'Swedish Krona'
            ],
            [
                CurrencyCodes::CODE => 'SGD',
                CurrencyCodes::CURRENCY => 'Singapore Dollar'
            ],
            [
                CurrencyCodes::CODE => 'SHP',
                CurrencyCodes::CURRENCY => 'Saint Helena Pound'
            ],
            [
                CurrencyCodes::CODE => 'SLE',
                CurrencyCodes::CURRENCY => 'Leone'
            ],
            [
                CurrencyCodes::CODE => 'SLL',
                CurrencyCodes::CURRENCY => 'Leone'
            ],
            [
                CurrencyCodes::CODE => 'SOS',
                CurrencyCodes::CURRENCY => 'Somali Shilling'
            ],
            [
                CurrencyCodes::CODE => 'SRD',
                CurrencyCodes::CURRENCY => 'Surinam Dollar'
            ],
            [
                CurrencyCodes::CODE => 'SSP',
                CurrencyCodes::CURRENCY => 'South Sudanese Pound'
            ],
            [
                CurrencyCodes::CODE => 'STN',
                CurrencyCodes::CURRENCY => 'Dobra'
            ],
            [
                CurrencyCodes::CODE => 'SVC',
                CurrencyCodes::CURRENCY => 'El Salvador Colon'
            ],
            [
                CurrencyCodes::CODE => 'SYP',
                CurrencyCodes::CURRENCY => 'Syrian Pound'
            ],
            [
                CurrencyCodes::CODE => 'SZL',
                CurrencyCodes::CURRENCY => 'Lilangeni'
            ],
            [
                CurrencyCodes::CODE => 'THB',
                CurrencyCodes::CURRENCY => 'Baht'
            ],
            [
                CurrencyCodes::CODE => 'TJS',
                CurrencyCodes::CURRENCY => 'Somoni'
            ],
            [
                CurrencyCodes::CODE => 'TMT',
                CurrencyCodes::CURRENCY => 'Turkmenistan New Manat'
            ],
            [
                CurrencyCodes::CODE => 'TND',
                CurrencyCodes::CURRENCY => 'Tunisian Dinar'
            ],
            [
                CurrencyCodes::CODE => 'TOP',
                CurrencyCodes::CURRENCY => 'Pa’anga'
            ],
            [
                CurrencyCodes::CODE => 'TRY',
                CurrencyCodes::CURRENCY => 'Turkish Lira'
            ],
            [
                CurrencyCodes::CODE => 'TTD',
                CurrencyCodes::CURRENCY => 'Trinidad and Tobago Dollar'
            ],
            [
                CurrencyCodes::CODE => 'TWD',
                CurrencyCodes::CURRENCY => 'New Taiwan Dollar'
            ],
            [
                CurrencyCodes::CODE => 'TZS',
                CurrencyCodes::CURRENCY => 'Tanzanian Shilling'
            ],
            [
                CurrencyCodes::CODE => 'UAH',
                CurrencyCodes::CURRENCY => 'Hryvnia'
            ],
            [
                CurrencyCodes::CODE => 'UGX',
                CurrencyCodes::CURRENCY => 'Uganda Shilling'
            ],
            [
                CurrencyCodes::CODE => 'USD',
                CurrencyCodes::CURRENCY => 'US Dollar'
            ],
            [
                CurrencyCodes::CODE => 'USN',
                CurrencyCodes::CURRENCY => 'US Dollar (Next day)'
            ],
            [
                CurrencyCodes::CODE => 'UYI',
                CurrencyCodes::CURRENCY => 'Uruguay Peso en Unidades Indexadas (UI)'
            ],
            [
                CurrencyCodes::CODE => 'UYU',
                CurrencyCodes::CURRENCY => 'Peso Uruguayo'
            ],
            [
                CurrencyCodes::CODE => 'UYW',
                CurrencyCodes::CURRENCY => 'Unidad Previsional'
            ],
            [
                CurrencyCodes::CODE => 'UZS',
                CurrencyCodes::CURRENCY => 'Uzbekistan Sum'
            ],
            [
                CurrencyCodes::CODE => 'VED',
                CurrencyCodes::CURRENCY => 'Bolívar Soberano'
            ],
            [
                CurrencyCodes::CODE => 'VES',
                CurrencyCodes::CURRENCY => 'Bolívar Soberano'
            ],
            [
                CurrencyCodes::CODE => 'VND',
                CurrencyCodes::CURRENCY => 'Dong'
            ],
            [
                CurrencyCodes::CODE => 'VUV',
                CurrencyCodes::CURRENCY => 'Vatu'
            ],
            [
                CurrencyCodes::CODE => 'WST',
                CurrencyCodes::CURRENCY => 'Tala'
            ],
            [
                CurrencyCodes::CODE => 'XAF',
                CurrencyCodes::CURRENCY => 'CFA Franc BEAC'
            ],
            [
                CurrencyCodes::CODE => 'XAG',
                CurrencyCodes::CURRENCY => 'Silver'
            ],
            [
                CurrencyCodes::CODE => 'XAU',
                CurrencyCodes::CURRENCY => 'Gold'
            ],
            [
                CurrencyCodes::CODE => 'XBA',
                CurrencyCodes::CURRENCY => 'Bond Markets Unit European Composite Unit (EURCO)'
            ],
            [
                CurrencyCodes::CODE => 'XBB',
                CurrencyCodes::CURRENCY => 'Bond Markets Unit European Monetary Unit (E.M.U.-6)'
            ],
            [
                CurrencyCodes::CODE => 'XBC',
                CurrencyCodes::CURRENCY => 'Bond Markets Unit European Unit of Account 9 (E.U.A.-9)'
            ],
            [
                CurrencyCodes::CODE => 'XBD',
                CurrencyCodes::CURRENCY => 'Bond Markets Unit European Unit of Account 17 (E.U.A.-17)'
            ],
            [
                CurrencyCodes::CODE => 'XCD',
                CurrencyCodes::CURRENCY => 'East Caribbean Dollar'
            ],
            [
                CurrencyCodes::CODE => 'XDR',
                CurrencyCodes::CURRENCY => 'SDR (Special Drawing Right)'
            ],
            [
                CurrencyCodes::CODE => 'XOF',
                CurrencyCodes::CURRENCY => 'CFA Franc BCEAO'
            ],
            [
                CurrencyCodes::CODE => 'XPD',
                CurrencyCodes::CURRENCY => 'Palladium'
            ],
            [
                CurrencyCodes::CODE => 'XPF',
                CurrencyCodes::CURRENCY => 'CFP Franc'
            ],
            [
                CurrencyCodes::CODE => 'XPT',
                CurrencyCodes::CURRENCY => 'Platinum'
            ],
            [
                CurrencyCodes::CODE => 'XSU',
                CurrencyCodes::CURRENCY => 'Sucre'
            ],
            [
                CurrencyCodes::CODE => 'XUA',
                CurrencyCodes::CURRENCY => 'ADB Unit of Account'
            ],
            [
                CurrencyCodes::CODE => 'XXX',
                CurrencyCodes::CURRENCY => 'The codes assigned for transactions where no currency is involved'
            ],
            [
                CurrencyCodes::CODE => 'YER',
                CurrencyCodes::CURRENCY => 'Yemeni Rial'
            ],
            [
                CurrencyCodes::CODE => 'ZAR',
                CurrencyCodes::CURRENCY => 'Rand'
            ],
            [
                CurrencyCodes::CODE => 'ZMW',
                CurrencyCodes::CURRENCY => 'Zambian Kwacha'
            ],
            [
                CurrencyCodes::CODE => 'ZWL',
                CurrencyCodes::CURRENCY => 'Zimbabwe Dollar'
            ],
        ];
    }
}
