<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Intelligence\V2\Transcript;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class EncryptedSentencesContext extends InstanceContext
    {
    /**
     * Initialize the EncryptedSentencesContext
     *
     * @param Version $version Version that contains the resource
     * @param string $transcriptSid The unique SID identifier of the Transcript.
     */
    public function __construct(
        Version $version,
        $transcriptSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'transcriptSid' =>
            $transcriptSid,
        ];

        $this->uri = '/Transcripts/' . \rawurlencode($transcriptSid)
        .'/Sentences/Encrypted';
    }

    /**
     * Helper function for Fetch
     *
     * @param array|Options $options Optional Arguments
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(array $options = []): Response
    {
        $options = new Values($options);

        $params = Values::of([
            'Redacted' =>
                Serialize::booleanToString($options['redacted']),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, $params, [], $headers, "fetch");
    }

    /**
     * Fetch the EncryptedSentencesInstance
     *
     * @param array|Options $options Optional Arguments
     * @return EncryptedSentencesInstance Fetched EncryptedSentencesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): EncryptedSentencesInstance
    {
        $response = $this->_fetch($options);
        return new EncryptedSentencesInstance(
            $this->version,
            $response->getContent(),
            $this->solution['transcriptSid']
        );
        
    }

    /**
     * Fetch the EncryptedSentencesInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_fetch($options);
        $resource = new EncryptedSentencesInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['transcriptSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Intelligence.V2.EncryptedSentencesContext ' . \implode(' ', $context) . ']';
    }
}
