<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Voice
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Voice\V1\ConnectionPolicy;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Stream;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ArrayMetadata;
use Twilio\Metadata\PageMetadata;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Metadata\StreamMetadata;
use Twilio\Serialize;


class ConnectionPolicyTargetList extends ListResource
    {
    /**
     * Construct the ConnectionPolicyTargetList
     *
     * @param Version $version Version that contains the resource
     * @param string $connectionPolicySid The SID of the Connection Policy that owns the Target.
     */
    public function __construct(
        Version $version,
        string $connectionPolicySid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'connectionPolicySid' =>
            $connectionPolicySid,
        
        ];

        $this->uri = '/ConnectionPolicies/' . \rawurlencode($connectionPolicySid)
        .'/Targets';
    }

    /**
     * Helper function for Create
     *
     * @param string $target The SIP address you want Twilio to route your calls to. This must be a `sip:` schema. `sips` is NOT supported.
     * @param array|Options $options Optional Arguments
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(string $target, array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'Target' =>
                $target,
            'FriendlyName' =>
                $options['friendlyName'],
            'Priority' =>
                $options['priority'],
            'Weight' =>
                $options['weight'],
            'Enabled' =>
                Serialize::booleanToString($options['enabled']),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the ConnectionPolicyTargetInstance
     *
     * @param string $target The SIP address you want Twilio to route your calls to. This must be a `sip:` schema. `sips` is NOT supported.
     * @param array|Options $options Optional Arguments
     * @return ConnectionPolicyTargetInstance Created ConnectionPolicyTargetInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $target, array $options = []): ConnectionPolicyTargetInstance
    {
        $response = $this->_create( $target, $options);
        return new ConnectionPolicyTargetInstance(
            $this->version,
            $response->getContent(),
            $this->solution['connectionPolicySid']
        );
        
    }

    /**
     * Create the ConnectionPolicyTargetInstance with Metadata
     *
     * @param string $target The SIP address you want Twilio to route your calls to. This must be a `sip:` schema. `sips` is NOT supported.
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(string $target, array $options = []): ResourceMetadata
    {
        $response = $this->_create( $target, $options);
        $resource = new ConnectionPolicyTargetInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['connectionPolicySid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Reads ConnectionPolicyTargetInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return ConnectionPolicyTargetInstance[] Array of results
     */
    public function read(?int $limit = null, $pageSize = null): array
    {
        return \iterator_to_array($this->stream($limit, $pageSize), false);
    }

    /**
     * Reads ConnectionPolicyTargetInstance records from the API as a list
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return ArrayMetadata Array of results along with metadata
     */
    public function readWithMetadata(?int $limit = null, $pageSize = null): ArrayMetadata
    {
        $streamWithMetadata = $this->streamWithMetadata($limit, $pageSize);
        $readResponse = \iterator_to_array($streamWithMetadata, false);
        return new ArrayMetadata(
            $readResponse,
            $streamWithMetadata->getStatusCode(),
            $streamWithMetadata->getHeaders()
        );
    }

    /**
     * Streams ConnectionPolicyTargetInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return Stream stream of results
     */
    public function stream(?int $limit = null, $pageSize = null): Stream
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Streams ConnectionPolicyTargetInstance records from the API as a generator stream and returns result with Metadata
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return StreamMetadata stream of results with metadata
     */
    public function streamWithMetadata(?int $limit = null, $pageSize = null): StreamMetadata
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $pageWithMetadata = $this->pageWithMetadata($limits['pageSize']);

        $stream = $this->version->stream($pageWithMetadata->getPage(), $limits['limit'], $limits['pageLimit']);

        return new StreamMetadata(
            $stream,
            $pageWithMetadata->getStatusCode(),
            $pageWithMetadata->getHeaders()
        );
    }

    /**
     * Helper function for Page
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return Response Paged Response
     */
    private function _page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): Response
    {

        $params = Values::of([
            'PageToken' => $pageToken,
            'Page' => $pageNumber,
            'PageSize' => $pageSize,
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json']);
        return $this->version->page('GET', $this->uri, $params, [], $headers);
    }

    /**
     * Retrieve a single page of ConnectionPolicyTargetInstance records from the API.
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return ConnectionPolicyTargetPage Page of ConnectionPolicyTargetInstance
     */
    public function page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): ConnectionPolicyTargetPage
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        return new ConnectionPolicyTargetPage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a single page of ConnectionPolicyTargetInstance records with metadata
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return PageMetadata of ConnectionPolicyTargetInstance
     */
    public function pageWithMetadata(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): PageMetadata
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        $resource =  new ConnectionPolicyTargetPage($this->version, $response, $this->solution);

        return new PageMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }

    /**
     * Retrieve a specific page of ConnectionPolicyTargetInstance records from the API.
     * Request is executed immediately
     *
     * @param string $targetUrl API-generated URL for the requested results page
     * @return ConnectionPolicyTargetPage Page of ConnectionPolicyTargetInstance
     */
    public function getPage(string $targetUrl): ConnectionPolicyTargetPage
    {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new ConnectionPolicyTargetPage($this->version, $response, $this->solution);
    }


    /**
     * Constructs a ConnectionPolicyTargetContext
     *
     * @param string $sid The unique string that we created to identify the Target resource to delete.
     */
    public function getContext(
        string $sid
        
    ): ConnectionPolicyTargetContext
    {
        return new ConnectionPolicyTargetContext(
            $this->version,
            $this->solution['connectionPolicySid'],
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Voice.V1.ConnectionPolicyTargetList]';
    }
}
